/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSNamespaceRule;
import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.GroupingRule;
import io.sf.carte.doc.style.css.om.StyleRule;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class NamespaceRule
extends BaseCSSRule
implements CSSNamespaceRule {
    private static final long serialVersionUID = 1L;
    private String namespaceURI = null;
    private String prefix = null;

    protected NamespaceRule(AbstractCSSStyleSheet parentSheet, int origin, String prefix, String namespaceURI) {
        super(parentSheet, (short)10, origin);
        this.prefix = prefix;
        this.namespaceURI = namespaceURI;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
        AbstractCSSStyleSheet parentSheet = this.getParentStyleSheet();
        if (parentSheet != null) {
            parentSheet.unregisterNamespace(this.namespaceURI);
            parentSheet.registerNamespace(this);
            this.updateSelectorText(parentSheet.getCssRules());
        }
    }

    private void updateSelectorText(CSSRuleArrayList rules) {
        for (CSSRule rule : rules) {
            short type = rule.getType();
            if (type == 1) {
                ((StyleRule)rule).updateSelectorText();
                continue;
            }
            if (!(rule instanceof GroupingRule)) continue;
            this.updateSelectorText(((GroupingRule)rule).getCssRules());
        }
    }

    @Override
    int addToSheet(AbstractCSSStyleSheet sheet, int importCount) {
        this.addToSheetAsLocal(sheet);
        return importCount;
    }

    @Override
    void addToSheetAsLocal(AbstractCSSStyleSheet sheet) {
        sheet.addNamespaceRule(this);
    }

    @Override
    public String getCssText() {
        if (this.namespaceURI == null) {
            return null;
        }
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(this.namespaceURI.length() + 32);
        try {
            this.writeCssText((SimpleWriter)sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        if (this.namespaceURI == null) {
            return;
        }
        wri.write((CharSequence)"@namespace ");
        if (this.prefix != null) {
            wri.write((CharSequence)this.prefix);
            wri.write(' ');
        }
        context.writeURL(wri, this.namespaceURI);
        context.writeSemiColon(wri);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.namespaceURI == null ? 0 : this.namespaceURI.hashCode());
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamespaceRule other = (NamespaceRule)obj;
        if (this.namespaceURI == null ? other.namespaceURI != null : !this.namespaceURI.equals(other.namespaceURI)) {
            return false;
        }
        return !(this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix));
    }

    @Override
    public NamespaceRule clone(AbstractCSSStyleSheet parentSheet) {
        return new NamespaceRule(parentSheet, this.getOrigin(), this.prefix, this.namespaceURI);
    }
}

