/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.stages;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.FirSimpleSyntheticPropertySymbol;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolvedWithLowPriority;
import org.jetbrains.kotlin.fir.resolve.calls.ResolvedWithSynthetic;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStage;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0096@R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/DiscriminateSyntheticAndForbiddenProperties;", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStage;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "context", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolve"})
public final class DiscriminateSyntheticAndForbiddenProperties
extends ResolutionStage {
    @NotNull
    public static final DiscriminateSyntheticAndForbiddenProperties INSTANCE = new DiscriminateSyntheticAndForbiddenProperties();

    private DiscriminateSyntheticAndForbiddenProperties() {
    }

    @Override
    @Nullable
    public Object check(@NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Candidate candidate2, @NotNull Continuation<? super Unit> $completion) {
        FirBasedSymbol<?> symbol = candidate2.getSymbol();
        if (symbol instanceof FirSimpleSyntheticPropertySymbol) {
            sink.reportDiagnostic(ResolvedWithSynthetic.INSTANCE);
        }
        if (symbol instanceof FirEnumEntrySymbol && Intrinsics.areEqual(((FirEnumEntrySymbol)symbol).getName(), StandardNames.ENUM_ENTRIES) && LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.ForbidEnumEntryNamedEntries)) {
            sink.reportDiagnostic(ResolvedWithLowPriority.INSTANCE);
        }
        return Unit.INSTANCE;
    }
}

