/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import oracle.i18n.text.converter.CharsetMeta;

public class CharConvRepackage {
    private static final String M_COMMAND = "-custom-charsets-jar";
    private static final String M_CHARSET = "-charset";
    private static final String M_MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static final String M_DEFAULT_JAR_NAME = "jdbc_orai18n_cs.jar";
    private static final String M_RESERVED_NAME = "orai18n";
    private static final String[] GDK_JDBC_PACKAGE_CLASS = new String[]{"oracle/i18n/text/converter/CharacterConverterOGS.class", "oracle/i18n/text/converter/CharacterConverter12Byte.class", "oracle/i18n/text/converter/CharacterConverter1Byte.class", "oracle/i18n/text/converter/CharacterConverterGB18030.class", "oracle/i18n/text/converter/CharacterConverterJAEUC.class", "oracle/i18n/text/converter/CharacterConverterLC.class", "oracle/i18n/text/converter/CharacterConverterSJIS.class", "oracle/i18n/text/converter/CharacterConverterShift.class", "oracle/i18n/text/converter/CharacterConverterZHTEUC.class", "oracle/i18n/text/converter/Messages.class", "oracle/i18n/text/converter/GDKMessage.class", "oracle/i18n/util/GDKOracleMetaData.class", "oracle/i18n/text/converter/CharacterConverter.class"};
    private static final Set UNICODE_CHARSETS = new HashSet();

    public static final String getCommand() {
        return M_COMMAND;
    }

    public static void printUsage() {
        System.out.println("  -custom-charsets-jar <jar/zip file name> -charset <character set name> [<character set name> ...] : Generates a custom character set jar/zip file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(List list) throws Exception {
        File file;
        Object object;
        if (list.size() < 2) {
            CharConvRepackage.printUsage();
            return;
        }
        Class<CharConvRepackage> clazz = CharConvRepackage.class;
        for (int i = 0; i < GDK_JDBC_PACKAGE_CLASS.length; ++i) {
            object = clazz.getResourceAsStream("/" + GDK_JDBC_PACKAGE_CLASS[i]);
            if (object != null) continue;
            new ClassNotFoundException("/" + GDK_JDBC_PACKAGE_CLASS[i]);
        }
        object = (String)list.get(0);
        if (M_CHARSET.equals(object)) {
            file = new File(M_DEFAULT_JAR_NAME);
        } else {
            file = new File((String)object);
            if (file.getName().startsWith(M_RESERVED_NAME)) {
                throw new IllegalArgumentException("You cannot specify the name for jar/zip file: " + file.getName());
            }
            list.remove(0);
            if (!M_CHARSET.equals(list.get(0))) {
                CharConvRepackage.printUsage();
                return;
            }
        }
        list.remove(0);
        File file2 = File.createTempFile("gdk", null);
        file2.deleteOnExit();
        try (FileOutputStream fileOutputStream = null;){
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            int n;
            fileOutputStream = new FileOutputStream(file2);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            for (n = 0; n < list.size(); ++n) {
                object8 = ((String)list.get(n)).toUpperCase(Locale.US);
                if (UNICODE_CHARSETS.contains(object8)) {
                    System.out.println("Added       Character set : " + (String)object8);
                    continue;
                }
                object7 = CharsetMeta.getInstance();
                object6 = ((CharsetMeta)object7).getCharSetId((String)object8);
                if (object6 == null) {
                    throw new UnsupportedEncodingException((String)object8);
                }
                object5 = Integer.toHexString(Integer.parseInt((String)object6));
                object4 = "lx2" + ("0000" + (String)object5).substring(((String)object5).length());
                object3 = "oracle/i18n/data/" + (String)object4 + ".glb";
                object2 = clazz.getResourceAsStream("/" + (String)object3);
                if (object2 == null) {
                    throw new UnsupportedEncodingException((String)object8);
                }
                ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object2);
                Object object9 = objectInputStream.readObject();
                objectInputStream.close();
                ((InputStream)object2).close();
                ZipEntry zipEntry = new ZipEntry((String)object3);
                zipOutputStream.putNextEntry(zipEntry);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(zipOutputStream);
                objectOutputStream.writeObject(object9);
                System.out.println("Added       Character set : " + (String)object8);
            }
            for (n = 0; n < GDK_JDBC_PACKAGE_CLASS.length; ++n) {
                object8 = new ZipEntry(GDK_JDBC_PACKAGE_CLASS[n]);
                zipOutputStream.putNextEntry((ZipEntry)object8);
                object7 = clazz.getResourceAsStream("/" + GDK_JDBC_PACKAGE_CLASS[n]);
                CharConvRepackage.copyFile((InputStream)object7, zipOutputStream);
                ((InputStream)object7).close();
            }
            ZipEntry zipEntry = new ZipEntry(M_MANIFEST_NAME);
            zipOutputStream.putNextEntry(zipEntry);
            object8 = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
            object7 = new JarFile((String)object8);
            object6 = ((JarFile)object7).entries();
            while (object6.hasMoreElements()) {
                object5 = (JarEntry)object6.nextElement();
                object4 = ((ZipEntry)object5).getName();
                if (!((String)object4).equals(M_MANIFEST_NAME)) continue;
                object3 = ((JarFile)object7).getInputStream((ZipEntry)object5);
                CharConvRepackage.copyFile((InputStream)object3, zipOutputStream);
                ((InputStream)object3).close();
                break;
            }
            object5 = new ByteArrayOutputStream();
            object4 = new OutputStreamWriter((OutputStream)object5, "iso-8859-1");
            ((Writer)object4).write("\n");
            ((Writer)object4).write("This custom character set jar/zip file was created with the following command:\n");
            ((Writer)object4).write("java -jar orai18n.jar -custom-charsets-jar " + file.getName() + " " + M_CHARSET);
            for (int i = 0; i < list.size(); ++i) {
                object2 = ((String)list.get(i)).toUpperCase(Locale.US);
                ((Writer)object4).write(" ");
                ((Writer)object4).write((String)object2);
            }
            ((Writer)object4).write("\n");
            ((OutputStreamWriter)object4).close();
            ((ByteArrayOutputStream)object5).close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object5).toByteArray());
            zipEntry = new ZipEntry("oracle/i18n/readme.txt");
            zipOutputStream.putNextEntry(zipEntry);
            CharConvRepackage.copyFile(byteArrayInputStream, zipOutputStream);
            byteArrayInputStream.close();
            zipOutputStream.close();
            fileOutputStream.close();
            fileOutputStream = null;
            if (!file2.renameTo(file)) {
                object2 = new FileInputStream(file2);
                fileOutputStream = new FileOutputStream(file);
                CharConvRepackage.copyFile((InputStream)object2, fileOutputStream);
                fileOutputStream.close();
                fileOutputStream = null;
                ((FileInputStream)object2).close();
            }
        }
    }

    private static final void copyFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[8192];
        int n = -1;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    static {
        UNICODE_CHARSETS.add("AL16UTF16");
        UNICODE_CHARSETS.add("AL16UTF16LE");
        UNICODE_CHARSETS.add("AL32UTF8");
        UNICODE_CHARSETS.add("UTF8");
        UNICODE_CHARSETS.add("UTFE");
        UNICODE_CHARSETS.add("AL24UTFFSS");
    }
}

