/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.util.ArrayList;
import oracle.jdbc.OracleHostnameResolver;
import oracle.net.jdbc.TNSAddress.Address;
import oracle.net.jdbc.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.nt.ConnectDescription;
import oracle.net.resolver.InetAddressResolver;
import oracle.net.resolver.NavSchemaObject;

public class NavAddress
extends Address
implements NavSchemaObject {
    final NVNavigator nav = new NVNavigator();
    public static final String CONNECT_DATA_ADDRESS = "(ADDRESS=$$REPLACE_THIS$$)";

    public NavAddress(SchemaObjectFactoryInterface fac) {
        super(fac);
    }

    @Override
    public void navigate(ConnStrategy cs, StringBuffer sBuf) throws NetException {
        boolean needToCloseDescription = false;
        if (cs.currentDescription() == null) {
            cs.newConnectDescription();
            needToCloseDescription = true;
        }
        this.parseAddressParamsAndNavigate(cs.getHostnameResolver(), cs, sBuf);
        if (needToCloseDescription) {
            String descriptionString = cs.currentDescription().getConnectOptions().get((int)0).conn_data.toString();
            if (descriptionString.contains(CONNECT_DATA_ADDRESS)) {
                descriptionString = descriptionString.replace(CONNECT_DATA_ADDRESS, this.toString());
            }
            cs.currentDescription().setDescriptionString(descriptionString);
            cs.closeDescription();
        }
    }

    @Override
    public void addToString(ConnStrategy cs) {
        String NVString = this.toString();
        ArrayList<ConnOption> cOpts = cs.currentDescription().getConnectOptions();
        for (ConnOption co : cOpts) {
            if (co.done) continue;
            co.conn_data.append(NVString);
        }
    }

    private void parseAddressParamsAndNavigate(OracleHostnameResolver hostnameResolver, ConnStrategy cs, StringBuffer sBuf) throws NetException {
        this.readHttpsProxyConfig(cs);
        ConnOption co = new ConnOption();
        co.addr = String.format("(ADDRESS=(PROTOCOL=%s)(HOST=%s)(PORT=%s))", this.prot, this.host, this.port);
        co.host = this.host;
        co.port = this.port;
        co.httpsProxy = this.httpsProxy;
        co.httpsProxyPort = this.httpsProxyPort;
        co.inetSocketAddress = null;
        co.webSocketUri = this.webSocketURI;
        co.protocol = this.prot;
        co.conn_data.append(sBuf.toString());
        if (!InetAddressResolver.isInetAddressResolutionRequired(this.addr, this.prot, cs.socketOptions, this.httpsProxy) || this.prot.equalsIgnoreCase("beq")) {
            co.conn_data.append(this.toString());
        } else {
            co.conn_data.append(CONNECT_DATA_ADDRESS);
        }
        cs.currentDescription().addConnectOption(co);
    }

    private void readHttpsProxyConfig(ConnStrategy cs) {
        ConnectDescription desc = cs.currentDescription();
        if (this.httpsProxy == null) {
            this.httpsProxy = desc.getHttpsProxy();
        }
        if (this.httpsProxy != null && this.httpsProxyPort == -1) {
            this.httpsProxyPort = desc.getHttpsProxyPort();
        }
    }
}

