"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = GeospatialPlugin;
var _shared = require("../../common/constants/shared");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// eslint-disable-next-line import/no-default-export
function GeospatialPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.geospatial = components.clientAction.namespaceFactory();
  const geospatial = Client.prototype.geospatial.prototype;
  geospatial.geospatialQuery = ca({
    url: {
      fmt: `${_shared.UPLOAD_GEOJSON_API_PATH}`
    },
    method: 'POST'
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfc2hhcmVkIiwicmVxdWlyZSIsIkdlb3NwYXRpYWxQbHVnaW4iLCJDbGllbnQiLCJjb25maWciLCJjb21wb25lbnRzIiwiY2EiLCJjbGllbnRBY3Rpb24iLCJmYWN0b3J5IiwicHJvdG90eXBlIiwiZ2Vvc3BhdGlhbCIsIm5hbWVzcGFjZUZhY3RvcnkiLCJnZW9zcGF0aWFsUXVlcnkiLCJ1cmwiLCJmbXQiLCJVUExPQURfR0VPSlNPTl9BUElfUEFUSCIsIm1ldGhvZCIsIm1vZHVsZSIsImV4cG9ydHMiLCJkZWZhdWx0Il0sInNvdXJjZXMiOlsiZ2Vvc3BhdGlhbF9wbHVnaW4udHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgeyBVUExPQURfR0VPSlNPTl9BUElfUEFUSCB9IGZyb20gJy4uLy4uL2NvbW1vbi9jb25zdGFudHMvc2hhcmVkJztcblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGltcG9ydC9uby1kZWZhdWx0LWV4cG9ydFxuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gR2Vvc3BhdGlhbFBsdWdpbihDbGllbnQsIGNvbmZpZywgY29tcG9uZW50cykge1xuICBjb25zdCBjYSA9IGNvbXBvbmVudHMuY2xpZW50QWN0aW9uLmZhY3Rvcnk7XG4gIENsaWVudC5wcm90b3R5cGUuZ2Vvc3BhdGlhbCA9IGNvbXBvbmVudHMuY2xpZW50QWN0aW9uLm5hbWVzcGFjZUZhY3RvcnkoKTtcbiAgY29uc3QgZ2Vvc3BhdGlhbCA9IENsaWVudC5wcm90b3R5cGUuZ2Vvc3BhdGlhbC5wcm90b3R5cGU7XG5cbiAgZ2Vvc3BhdGlhbC5nZW9zcGF0aWFsUXVlcnkgPSBjYSh7XG4gICAgdXJsOiB7XG4gICAgICBmbXQ6IGAke1VQTE9BRF9HRU9KU09OX0FQSV9QQVRIfWAsXG4gICAgfSxcbiAgICBtZXRob2Q6ICdQT1NUJyxcbiAgfSk7XG59XG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUtBLElBQUFBLE9BQUEsR0FBQUMsT0FBQTtBQUxBO0FBQ0E7QUFDQTtBQUNBOztBQUlBO0FBQ2UsU0FBU0MsZ0JBQWdCQSxDQUFDQyxNQUFNLEVBQUVDLE1BQU0sRUFBRUMsVUFBVSxFQUFFO0VBQ25FLE1BQU1DLEVBQUUsR0FBR0QsVUFBVSxDQUFDRSxZQUFZLENBQUNDLE9BQU87RUFDMUNMLE1BQU0sQ0FBQ00sU0FBUyxDQUFDQyxVQUFVLEdBQUdMLFVBQVUsQ0FBQ0UsWUFBWSxDQUFDSSxnQkFBZ0IsQ0FBQyxDQUFDO0VBQ3hFLE1BQU1ELFVBQVUsR0FBR1AsTUFBTSxDQUFDTSxTQUFTLENBQUNDLFVBQVUsQ0FBQ0QsU0FBUztFQUV4REMsVUFBVSxDQUFDRSxlQUFlLEdBQUdOLEVBQUUsQ0FBQztJQUM5Qk8sR0FBRyxFQUFFO01BQ0hDLEdBQUcsRUFBRyxHQUFFQywrQkFBd0I7SUFDbEMsQ0FBQztJQUNEQyxNQUFNLEVBQUU7RUFDVixDQUFDLENBQUM7QUFDSjtBQUFDQyxNQUFBLENBQUFDLE9BQUEsR0FBQUEsT0FBQSxDQUFBQyxPQUFBIn0=