/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingestion;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ingestion.ErrorPolicy;
import org.opensearch.client.opensearch.ingestion.PollerState;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ShardIngestionState
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ShardIngestionState> {
    @Nullable
    private final String batchStartPointer;
    @Nullable
    private final ErrorPolicy errorPolicy;
    @Nullable
    private final Boolean pollerPaused;
    @Nullable
    private final PollerState pollerState;
    @Nullable
    private final Integer shard;
    @Nullable
    private final Boolean writeBlockEnabled;
    public static final JsonpDeserializer<ShardIngestionState> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardIngestionState::setupShardIngestionStateDeserializer);

    private ShardIngestionState(Builder builder) {
        this.batchStartPointer = builder.batchStartPointer;
        this.errorPolicy = builder.errorPolicy;
        this.pollerPaused = builder.pollerPaused;
        this.pollerState = builder.pollerState;
        this.shard = builder.shard;
        this.writeBlockEnabled = builder.writeBlockEnabled;
    }

    public static ShardIngestionState of(Function<Builder, ObjectBuilder<ShardIngestionState>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String batchStartPointer() {
        return this.batchStartPointer;
    }

    @Nullable
    public final ErrorPolicy errorPolicy() {
        return this.errorPolicy;
    }

    @Nullable
    public final Boolean pollerPaused() {
        return this.pollerPaused;
    }

    @Nullable
    public final PollerState pollerState() {
        return this.pollerState;
    }

    @Nullable
    public final Integer shard() {
        return this.shard;
    }

    @Nullable
    public final Boolean writeBlockEnabled() {
        return this.writeBlockEnabled;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.batchStartPointer != null) {
            generator.writeKey("batch_start_pointer");
            generator.write(this.batchStartPointer);
        }
        if (this.errorPolicy != null) {
            generator.writeKey("error_policy");
            this.errorPolicy.serialize(generator, mapper);
        }
        if (this.pollerPaused != null) {
            generator.writeKey("poller_paused");
            generator.write(this.pollerPaused.booleanValue());
        }
        if (this.pollerState != null) {
            generator.writeKey("poller_state");
            this.pollerState.serialize(generator, mapper);
        }
        if (this.shard != null) {
            generator.writeKey("shard");
            generator.write(this.shard.intValue());
        }
        if (this.writeBlockEnabled != null) {
            generator.writeKey("write_block_enabled");
            generator.write(this.writeBlockEnabled.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupShardIngestionStateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::batchStartPointer, JsonpDeserializer.stringDeserializer(), "batch_start_pointer");
        op.add(Builder::errorPolicy, ErrorPolicy._DESERIALIZER, "error_policy");
        op.add(Builder::pollerPaused, JsonpDeserializer.booleanDeserializer(), "poller_paused");
        op.add(Builder::pollerState, PollerState._DESERIALIZER, "poller_state");
        op.add(Builder::shard, JsonpDeserializer.integerDeserializer(), "shard");
        op.add(Builder::writeBlockEnabled, JsonpDeserializer.booleanDeserializer(), "write_block_enabled");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.batchStartPointer);
        result = 31 * result + Objects.hashCode(this.errorPolicy);
        result = 31 * result + Objects.hashCode(this.pollerPaused);
        result = 31 * result + Objects.hashCode(this.pollerState);
        result = 31 * result + Objects.hashCode(this.shard);
        result = 31 * result + Objects.hashCode(this.writeBlockEnabled);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardIngestionState other = (ShardIngestionState)o;
        return Objects.equals(this.batchStartPointer, other.batchStartPointer) && Objects.equals(this.errorPolicy, other.errorPolicy) && Objects.equals(this.pollerPaused, other.pollerPaused) && Objects.equals(this.pollerState, other.pollerState) && Objects.equals(this.shard, other.shard) && Objects.equals(this.writeBlockEnabled, other.writeBlockEnabled);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ShardIngestionState> {
        @Nullable
        private String batchStartPointer;
        @Nullable
        private ErrorPolicy errorPolicy;
        @Nullable
        private Boolean pollerPaused;
        @Nullable
        private PollerState pollerState;
        @Nullable
        private Integer shard;
        @Nullable
        private Boolean writeBlockEnabled;

        public Builder() {
        }

        private Builder(ShardIngestionState o) {
            this.batchStartPointer = o.batchStartPointer;
            this.errorPolicy = o.errorPolicy;
            this.pollerPaused = o.pollerPaused;
            this.pollerState = o.pollerState;
            this.shard = o.shard;
            this.writeBlockEnabled = o.writeBlockEnabled;
        }

        private Builder(Builder o) {
            this.batchStartPointer = o.batchStartPointer;
            this.errorPolicy = o.errorPolicy;
            this.pollerPaused = o.pollerPaused;
            this.pollerState = o.pollerState;
            this.shard = o.shard;
            this.writeBlockEnabled = o.writeBlockEnabled;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder batchStartPointer(@Nullable String value) {
            this.batchStartPointer = value;
            return this;
        }

        @Nonnull
        public final Builder errorPolicy(@Nullable ErrorPolicy value) {
            this.errorPolicy = value;
            return this;
        }

        @Nonnull
        public final Builder pollerPaused(@Nullable Boolean value) {
            this.pollerPaused = value;
            return this;
        }

        @Nonnull
        public final Builder pollerState(@Nullable PollerState value) {
            this.pollerState = value;
            return this;
        }

        @Nonnull
        public final Builder shard(@Nullable Integer value) {
            this.shard = value;
            return this;
        }

        @Nonnull
        public final Builder writeBlockEnabled(@Nullable Boolean value) {
            this.writeBlockEnabled = value;
            return this;
        }

        @Override
        @Nonnull
        public ShardIngestionState build() {
            this._checkSingleUse();
            return new ShardIngestionState(this);
        }
    }
}

