/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.contextpropagation;

import io.micrometer.context.ContextAccessor;
import io.netty.channel.Channel;
import java.util.Map;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import reactor.netty.ReactorNetty;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public final class ChannelContextAccessor
implements ContextAccessor<Channel, Channel> {
    public Class<? extends Channel> readableType() {
        return Channel.class;
    }

    public void readValues(Channel sourceContext, Predicate<Object> keyPredicate, Map<Object, Object> readValues) {
        ContextView contextView = ReactorNetty.getChannelContext(sourceContext);
        if (contextView != null) {
            contextView.forEach((k, v) -> {
                if (keyPredicate.test(k)) {
                    readValues.put(k, v);
                }
            });
        }
    }

    public <T> @Nullable T readValue(Channel sourceContext, Object key) {
        ContextView contextView = ReactorNetty.getChannelContext(sourceContext);
        if (contextView != null) {
            return (T)contextView.getOrDefault(key, null);
        }
        return null;
    }

    public Class<? extends Channel> writeableType() {
        return Channel.class;
    }

    public Channel writeValues(Map<Object, Object> valuesToWrite, Channel targetContext) {
        if (!valuesToWrite.isEmpty()) {
            ContextView contextView = ReactorNetty.getChannelContext(targetContext);
            ReactorNetty.setChannelContext(targetContext, (ContextView)(contextView != null ? Context.of((ContextView)contextView).putAllMap(valuesToWrite) : Context.of(valuesToWrite)));
        }
        return targetContext;
    }
}

