/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.saml.saml1.core.Action;
import org.opensaml.saml.saml1.core.AuthorizationDecisionQuery;
import org.opensaml.saml.saml1.core.Evidence;
import org.opensaml.saml.saml1.core.impl.SubjectQueryImpl;

public class AuthorizationDecisionQueryImpl
extends SubjectQueryImpl
implements AuthorizationDecisionQuery {
    @Nullable
    private String resource;
    @Nonnull
    private final XMLObjectChildrenList<Action> actions;
    @Nullable
    private Evidence evidence;

    protected AuthorizationDecisionQueryImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
        this.setElementNamespacePrefix("saml1p");
        this.actions = new XMLObjectChildrenList(this);
    }

    @Override
    @Nullable
    public String getResource() {
        return this.resource;
    }

    @Override
    public void setResource(@Nullable String res) {
        this.resource = this.prepareForAssignment(this.resource, res);
    }

    @Override
    @Nonnull
    @Live
    public List<Action> getActions() {
        return this.actions;
    }

    @Override
    @Nullable
    public Evidence getEvidence() {
        return this.evidence;
    }

    @Override
    public void setEvidence(@Nullable Evidence ev) {
        this.evidence = this.prepareForAssignment(this.evidence, ev);
    }

    @Override
    @Nullable
    @NotLive
    @Unmodifiable
    public List<XMLObject> getOrderedChildren() {
        ArrayList<XMLObject> list = new ArrayList<XMLObject>(this.actions.size() + 2);
        List<XMLObject> superKids = super.getOrderedChildren();
        if (superKids != null) {
            list.addAll(superKids);
        }
        list.addAll(this.actions);
        if (this.evidence != null) {
            list.add(this.evidence);
        }
        return CollectionSupport.copyToList(list);
    }
}

