/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.Load;
import net.sourceforge.plantuml.project.lang.Something;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;

public class ComplementSeveralDays
implements Something<GanttDiagram> {
    @Override
    public IRegex toRegex(String suffix) {
        return new RegexConcat(new RegexLeaf(4, "COMPLEMENT" + suffix, "(\\d+)[%s]+(day|week|month)s?(?:[%s]+and[%s]+(\\d+)[%s]+(day|week|month)s?)?"));
    }

    @Override
    public Failable<Load> getMe(GanttDiagram system, RegexResult arg, String suffix) {
        String prefix = "COMPLEMENT" + suffix;
        int firstValue = Integer.parseInt(arg.get(prefix, 0));
        String firstUnit = arg.get(prefix, 1);
        int firstDays = this.toDays(system, firstValue, firstUnit);
        int secondDays = 0;
        String secondValue = arg.get(prefix, 2);
        if (secondValue != null) {
            int value = Integer.parseInt(secondValue);
            String unit = arg.get(prefix, 3);
            secondDays = this.toDays(system, value, unit);
        }
        int totalDays = firstDays + secondDays;
        return Failable.ok(Load.inWinks(totalDays));
    }

    private int toDays(GanttDiagram system, int value, String unit) {
        switch (unit.charAt(0)) {
            case 'D': 
            case 'd': {
                return value;
            }
            case 'W': 
            case 'w': {
                return value * system.daysInWeek();
            }
            case 'M': 
            case 'm': {
                return value * system.daysInMonth();
            }
        }
        throw new IllegalArgumentException("unknown time unit: " + unit);
    }
}

