# This file has been autogenerated by the pywayland scanner

# Copyright 2014 © Stephen "Lyude" Chandler Paul
# Copyright 2015-2016 © Red Hat, Inc.
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice (including the
# next paragraph) shall be included in all copies or substantial
# portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .zwp_tablet_tool_v1 import ZwpTabletToolV1
from .zwp_tablet_v1 import ZwpTabletV1


class ZwpTabletSeatV1(Interface):
    """Controller object for graphic tablet devices of a seat

    An object that provides access to the graphics tablets available on this
    seat. After binding to this interface, the compositor sends a set of
    wp_tablet_seat.tablet_added and wp_tablet_seat.tool_added events.
    """

    name = "zwp_tablet_seat_v1"
    version = 1


class ZwpTabletSeatV1Proxy(Proxy[ZwpTabletSeatV1]):
    interface = ZwpTabletSeatV1

    @ZwpTabletSeatV1.request()
    def destroy(self) -> None:
        """Release the memory for the tablet seat object

        Destroy the wp_tablet_seat object. Objects created from this object are
        unaffected and should be destroyed separately.
        """
        self._marshal(0)
        self._destroy()


class ZwpTabletSeatV1Resource(Resource):
    interface = ZwpTabletSeatV1

    @ZwpTabletSeatV1.event(
        Argument(ArgumentType.NewId, interface=ZwpTabletV1),
    )
    def tablet_added(self, id: ZwpTabletV1) -> None:
        """New device notification

        This event is sent whenever a new tablet becomes available on this
        seat. This event only provides the object id of the tablet, any static
        information about the tablet (device name, vid/pid, etc.) is sent
        through the wp_tablet interface.

        :param id:
            the newly added graphics tablet
        :type id:
            :class:`~pywayland.protocol.tablet_unstable_v1.ZwpTabletV1`
        """
        self._post_event(0, id)

    @ZwpTabletSeatV1.event(
        Argument(ArgumentType.NewId, interface=ZwpTabletToolV1),
    )
    def tool_added(self, id: ZwpTabletToolV1) -> None:
        """A new tool has been used with a tablet

        This event is sent whenever a tool that has not previously been used
        with a tablet comes into use. This event only provides the object id of
        the tool; any static information about the tool (capabilities, type,
        etc.) is sent through the wp_tablet_tool interface.

        :param id:
            the newly added tablet tool
        :type id:
            :class:`~pywayland.protocol.tablet_unstable_v1.ZwpTabletToolV1`
        """
        self._post_event(1, id)


class ZwpTabletSeatV1Global(Global):
    interface = ZwpTabletSeatV1


ZwpTabletSeatV1._gen_c()
ZwpTabletSeatV1.proxy_class = ZwpTabletSeatV1Proxy
ZwpTabletSeatV1.resource_class = ZwpTabletSeatV1Resource
ZwpTabletSeatV1.global_class = ZwpTabletSeatV1Global
