/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.internal.nanojson;

import java.io.IOException;
import java.io.Reader;
import org.carrot2.internal.nanojson.JsonParserException;

final class JsonTokener {
    static final int BUFFER_SIZE = 32768;
    static final int BUFFER_ROOM = 256;
    static final int MAX_ESCAPE = 5;
    private int linePos = 1;
    private int rowPos;
    private int charOffset;
    private int utf8adjust;
    private int tokenCharPos;
    private int tokenCharOffset;
    private boolean eof;
    private int index;
    private final Reader reader;
    private final char[] buffer = new char[32768];
    private int bufferLength;
    private final boolean utf8 = false;
    protected StringBuilder reusableBuffer = new StringBuilder();
    protected boolean isDouble;
    static final char[] TRUE = new char[]{'r', 'u', 'e'};
    static final char[] FALSE = new char[]{'a', 'l', 's', 'e'};
    static final char[] NULL = new char[]{'u', 'l', 'l'};
    static final int TOKEN_EOF = 0;
    static final int TOKEN_COMMA = 1;
    static final int TOKEN_COLON = 2;
    static final int TOKEN_OBJECT_END = 3;
    static final int TOKEN_ARRAY_END = 4;
    static final int TOKEN_NULL = 5;
    static final int TOKEN_TRUE = 6;
    static final int TOKEN_FALSE = 7;
    static final int TOKEN_STRING = 8;
    static final int TOKEN_NUMBER = 9;
    static final int TOKEN_OBJECT_START = 10;
    static final int TOKEN_ARRAY_START = 11;
    static final int TOKEN_VALUE_MIN = 5;

    JsonTokener(Reader reader) throws JsonParserException {
        this.reader = reader;
        this.init();
    }

    private void init() throws JsonParserException {
        this.eof = this.refillBuffer();
        this.consumeWhitespace();
    }

    void consumeKeyword(char first, char[] expected) throws JsonParserException {
        if (this.ensureBuffer(expected.length) < expected.length) {
            throw this.createHelpfulException(first, expected, 0);
        }
        for (int i = 0; i < expected.length; ++i) {
            if (this.buffer[this.index++] == expected[i]) continue;
            throw this.createHelpfulException(first, expected, i);
        }
        this.fixupAfterRawBufferRead();
        if (this.isAsciiLetter(this.peekChar())) {
            throw this.createHelpfulException(first, expected, expected.length);
        }
    }

    void consumeTokenNumber(char savedChar) throws JsonParserException {
        int n;
        this.reusableBuffer.setLength(0);
        this.reusableBuffer.append(savedChar);
        this.isDouble = false;
        int state = savedChar == '-' ? 1 : (savedChar == '0' ? 3 : 2);
        block7: while ((n = this.ensureBuffer(256)) != 0) {
            for (int i = 0; i < n; ++i) {
                char nc = this.buffer[this.index];
                if (!this.isDigitCharacter(nc)) break block7;
                int ns = -1;
                switch (state) {
                    case 1: {
                        if (nc == '-' && state == 0) {
                            ns = 1;
                            break;
                        }
                        if (nc == '0') {
                            ns = 3;
                            break;
                        }
                        if (nc < '0' || nc > '9') break;
                        ns = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (nc >= '0' && nc <= '9' && state == 2) {
                            ns = 2;
                            break;
                        }
                        if (nc == '.') {
                            this.isDouble = true;
                            ns = 4;
                            break;
                        }
                        if (nc != 'e' && nc != 'E') break;
                        this.isDouble = true;
                        ns = 6;
                        break;
                    }
                    case 4: 
                    case 5: {
                        if (nc >= '0' && nc <= '9') {
                            ns = 5;
                            break;
                        }
                        if (nc != 'e' && nc != 'E' || state != 5) break;
                        this.isDouble = true;
                        ns = 6;
                        break;
                    }
                    case 6: 
                    case 7: {
                        if (nc == '+' || nc == '-' && state == 6) {
                            ns = 7;
                            break;
                        }
                        if (nc < '0' || nc > '9') break;
                        ns = 8;
                        break;
                    }
                    case 8: {
                        if (nc < '0' || nc > '9') break;
                        ns = 8;
                        break;
                    }
                    default: {
                        assert (false) : "Impossible";
                        break;
                    }
                }
                this.reusableBuffer.append(nc);
                ++this.index;
                if (ns == -1) {
                    throw this.createParseException(null, "Malformed number: " + this.reusableBuffer, true);
                }
                state = ns;
            }
        }
        if (state != 2 && state != 3 && state != 5 && state != 8) {
            throw this.createParseException(null, "Malformed number: " + this.reusableBuffer, true);
        }
        if (state == 3 && savedChar == '-') {
            this.isDouble = true;
        }
        this.fixupAfterRawBufferRead();
    }

    void consumeTokenString() throws JsonParserException {
        char c;
        int n;
        this.reusableBuffer.setLength(0);
        block13: while (true) {
            if ((n = this.ensureBuffer(256)) == 0) {
                throw this.createParseException(null, "String was not terminated before end of input", true);
            }
            for (int i = 0; i < n; ++i) {
                c = this.stringChar();
                if (c == '\"') {
                    this.reusableBuffer.append(this.buffer, this.index - i - 1, i);
                    this.fixupAfterRawBufferRead();
                    return;
                }
                if (c != '\\') continue;
                this.reusableBuffer.append(this.buffer, this.index - i - 1, i);
                --this.index;
                break block13;
            }
            this.reusableBuffer.append(this.buffer, this.index - n, n);
        }
        do {
            if ((n = this.ensureBuffer(256)) == 0) {
                throw this.createParseException(null, "String was not terminated before end of input", true);
            }
            int end = this.index + n;
            block16: while (this.index < end) {
                c = this.stringChar();
                switch (c) {
                    case '\"': {
                        this.fixupAfterRawBufferRead();
                        return;
                    }
                    case '\\': {
                        if (end - this.index < 5) {
                            n = this.ensureBuffer(5);
                            end = this.index + n;
                            if (this.buffer[this.index] == 'u' && n < 5) {
                                this.index = this.bufferLength;
                                throw this.createParseException(null, "EOF encountered in the middle of a string escape", false);
                            }
                        }
                        char escape = this.buffer[this.index++];
                        switch (escape) {
                            case 'b': {
                                this.reusableBuffer.append('\b');
                                continue block16;
                            }
                            case 'f': {
                                this.reusableBuffer.append('\f');
                                continue block16;
                            }
                            case 'n': {
                                this.reusableBuffer.append('\n');
                                continue block16;
                            }
                            case 'r': {
                                this.reusableBuffer.append('\r');
                                continue block16;
                            }
                            case 't': {
                                this.reusableBuffer.append('\t');
                                continue block16;
                            }
                            case '\"': 
                            case '/': 
                            case '\\': {
                                this.reusableBuffer.append(escape);
                                continue block16;
                            }
                            case 'u': {
                                int escaped = 0;
                                for (int j = 0; j < 4; ++j) {
                                    char digit;
                                    escaped <<= 4;
                                    if ((digit = this.buffer[this.index++]) >= '0' && digit <= '9') {
                                        escaped |= digit - 48;
                                        continue;
                                    }
                                    if (digit >= 'A' && digit <= 'F') {
                                        escaped |= digit - 65 + 10;
                                        continue;
                                    }
                                    if (digit >= 'a' && digit <= 'f') {
                                        escaped |= digit - 97 + 10;
                                        continue;
                                    }
                                    throw this.createParseException(null, "Expected unicode hex escape character: " + (char)digit + " (" + digit + ")", false);
                                }
                                this.reusableBuffer.append((char)escaped);
                                continue block16;
                            }
                        }
                        throw this.createParseException(null, "Invalid escape: \\" + escape, false);
                    }
                }
                this.reusableBuffer.append(c);
            }
        } while (this.index <= this.bufferLength);
        this.index = this.bufferLength;
        throw this.createParseException(null, "EOF encountered in the middle of a string escape", false);
    }

    private char stringChar() throws JsonParserException {
        char c;
        if ((c = this.buffer[this.index++]) < ' ') {
            this.throwControlCharacterException(c);
        }
        return c;
    }

    private void throwControlCharacterException(char c) throws JsonParserException {
        if (c == '\n') {
            ++this.linePos;
            this.rowPos = this.index + 1 + this.charOffset;
            this.utf8adjust = 0;
        }
        throw this.createParseException(null, "Strings may not contain control characters: 0x" + Integer.toString(c, 16), false);
    }

    private boolean isDigitCharacter(int c) {
        return c >= 48 && c <= 57 || c == 101 || c == 69 || c == 46 || c == 43 || c == 45;
    }

    boolean isWhitespace(int c) {
        return c == 32 || c == 10 || c == 13 || c == 9;
    }

    boolean isAsciiLetter(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }

    private boolean refillBuffer() throws JsonParserException {
        try {
            int r = this.reader.read(this.buffer, 0, this.buffer.length);
            if (r <= 0) {
                return true;
            }
            this.charOffset += this.bufferLength;
            this.index = 0;
            this.bufferLength = r;
            return false;
        }
        catch (IOException e) {
            throw this.createParseException(e, "IOException", true);
        }
    }

    private int peekChar() {
        return this.eof ? -1 : this.buffer[this.index];
    }

    int ensureBuffer(int n) throws JsonParserException {
        if (this.bufferLength - n >= this.index) {
            return n;
        }
        if (this.index > 0) {
            this.charOffset += this.index;
            this.bufferLength -= this.index;
            System.arraycopy(this.buffer, this.index, this.buffer, 0, this.bufferLength);
            this.index = 0;
        }
        try {
            while (this.buffer.length > this.bufferLength) {
                int r = this.reader.read(this.buffer, this.bufferLength, this.buffer.length - this.bufferLength);
                if (r <= 0) {
                    return this.bufferLength - this.index;
                }
                this.bufferLength += r;
                if (this.bufferLength <= n) continue;
                return this.bufferLength - this.index;
            }
            assert (false) : "Unexpected internal error";
            throw new IOException("Unexpected internal error");
        }
        catch (IOException e) {
            throw this.createParseException(e, "IOException", true);
        }
    }

    private int advanceChar() throws JsonParserException {
        if (this.eof) {
            return -1;
        }
        char c = this.buffer[this.index];
        if (c == '\n') {
            ++this.linePos;
            this.rowPos = this.index + 1 + this.charOffset;
            this.utf8adjust = 0;
        }
        ++this.index;
        if (this.index >= this.bufferLength) {
            this.eof = this.refillBuffer();
        }
        return c;
    }

    int advanceCharFast() {
        char c = this.buffer[this.index];
        if (c == '\n') {
            ++this.linePos;
            this.rowPos = this.index + 1 + this.charOffset;
            this.utf8adjust = 0;
        }
        ++this.index;
        return c;
    }

    private void consumeWhitespace() throws JsonParserException {
        int n;
        do {
            n = this.ensureBuffer(256);
            for (int i = 0; i < n; ++i) {
                char c = this.buffer[this.index];
                if (!this.isWhitespace(c)) {
                    this.fixupAfterRawBufferRead();
                    return;
                }
                if (c == '\n') {
                    ++this.linePos;
                    this.rowPos = this.index + 1 + this.charOffset;
                    this.utf8adjust = 0;
                }
                ++this.index;
            }
        } while (n > 0);
        this.eof = true;
    }

    int advanceToToken() throws JsonParserException {
        int token;
        int c = this.advanceChar();
        while (this.isWhitespace(c)) {
            c = this.advanceChar();
        }
        this.tokenCharPos = this.index + this.charOffset - this.rowPos - this.utf8adjust;
        this.tokenCharOffset = this.charOffset + this.index;
        switch (c) {
            case -1: {
                return 0;
            }
            case 91: {
                token = 11;
                break;
            }
            case 93: {
                token = 4;
                break;
            }
            case 44: {
                token = 1;
                break;
            }
            case 58: {
                token = 2;
                break;
            }
            case 123: {
                token = 10;
                break;
            }
            case 125: {
                token = 3;
                break;
            }
            case 116: {
                this.consumeKeyword((char)c, TRUE);
                token = 6;
                break;
            }
            case 102: {
                this.consumeKeyword((char)c, FALSE);
                token = 7;
                break;
            }
            case 110: {
                this.consumeKeyword((char)c, NULL);
                token = 5;
                break;
            }
            case 34: {
                this.consumeTokenString();
                token = 8;
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.consumeTokenNumber((char)c);
                token = 9;
                break;
            }
            case 43: 
            case 46: {
                throw this.createParseException(null, "Numbers may not start with '" + (char)c + "'", true);
            }
            default: {
                if (this.isAsciiLetter(c)) {
                    throw this.createHelpfulException((char)c, null, 0);
                }
                throw this.createParseException(null, "Unexpected character: " + (char)c, true);
            }
        }
        return token;
    }

    int tokenChar() throws JsonParserException {
        int c = this.advanceChar();
        while (this.isWhitespace(c)) {
            c = this.advanceChar();
        }
        return c;
    }

    void fixupAfterRawBufferRead() throws JsonParserException {
        if (this.index >= this.bufferLength) {
            this.eof = this.refillBuffer();
        }
    }

    JsonParserException createHelpfulException(char first, char[] expected, int failurePosition) throws JsonParserException {
        StringBuilder errorToken = new StringBuilder(first + (expected == null ? "" : new String(expected, 0, failurePosition)));
        while (this.isAsciiLetter(this.peekChar()) && errorToken.length() < 15) {
            errorToken.append((char)this.advanceChar());
        }
        return this.createParseException(null, "Unexpected token '" + errorToken + "'" + (String)(expected == null ? "" : ". Did you mean '" + first + new String(expected) + "'?"), true);
    }

    JsonParserException createParseException(Exception e, String message, boolean tokenPos) {
        if (tokenPos) {
            return new JsonParserException(e, message + " on line " + this.linePos + ", char " + this.tokenCharPos, this.linePos, this.tokenCharPos, this.tokenCharOffset);
        }
        int charPos = Math.max(1, this.index + this.charOffset - this.rowPos - this.utf8adjust);
        return new JsonParserException(e, message + " on line " + this.linePos + ", char " + charPos, this.linePos, charPos, this.index + this.charOffset);
    }
}

