/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.tika;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggStreamIdentifier;
import org.gagravarr.ogg.audio.OggAudioHeaders;
import org.gagravarr.ogg.audio.OggAudioInfoHeader;
import org.gagravarr.ogg.audio.OggAudioStream;
import org.gagravarr.opus.OpusFile;
import org.gagravarr.opus.OpusInfo;
import org.gagravarr.tika.OggAudioParser;
import org.gagravarr.vorbis.VorbisStyleComments;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpusParser
extends OggAudioParser {
    private static final long serialVersionUID = 5904981674814527529L;
    protected static final MediaType OPUS_AUDIO = MediaType.parse((String)OggStreamIdentifier.OPUS_AUDIO.mimetype);
    protected static final MediaType OPUS_AUDIO_ALT = MediaType.parse((String)OggStreamIdentifier.OPUS_AUDIO_ALT.mimetype);
    private static List<MediaType> TYPES = Arrays.asList(OPUS_AUDIO, OPUS_AUDIO_ALT);

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return new HashSet<MediaType>(TYPES);
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        metadata.set("Content-Type", OPUS_AUDIO.toString());
        metadata.set(XMPDM.AUDIO_COMPRESSOR, "Opus");
        OggFile ogg = new OggFile(stream);
        OpusFile opus = new OpusFile(ogg);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        this.extractInfo(metadata, opus.getInfo());
        OpusParser.extractComments(metadata, xhtml, (VorbisStyleComments)opus.getTags());
        OpusParser.extractDuration(metadata, xhtml, (OggAudioHeaders)opus, (OggAudioStream)opus);
        xhtml.endDocument();
        opus.close();
    }

    protected void extractInfo(Metadata metadata, OpusInfo info) throws TikaException {
        metadata.set(XMPDM.AUDIO_SAMPLE_RATE, (int)info.getRate());
        metadata.add("version", "Opus " + info.getMajorVersion() + "." + info.getMinorVersion());
        OpusParser.extractChannelInfo(metadata, (OggAudioInfoHeader)info);
    }
}

