"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const sinon_1 = __importDefault(require("sinon"));
const assert = __importStar(require("assert"));
const vscode_languageserver_types_1 = require("vscode-languageserver-types");
const documents_1 = require("../../../src/lib/documents");
describe('Document Manager', () => {
    const textDocument = {
        uri: 'file:///hello.svelte',
        version: 0,
        languageId: 'svelte',
        text: 'Hello, world!'
    };
    const createTextDocument = (textDocument) => new documents_1.Document(textDocument.uri, textDocument.text);
    it('opens documents', () => {
        const createDocument = sinon_1.default.spy((_) => new documents_1.Document('', ''));
        const manager = new documents_1.DocumentManager(createDocument);
        manager.openClientDocument(textDocument);
        sinon_1.default.assert.calledOnce(createDocument);
        sinon_1.default.assert.calledWith(createDocument.firstCall, textDocument);
    });
    it('updates the whole document', () => {
        const document = createTextDocument(textDocument);
        const createDocument = sinon_1.default.stub().returns(document);
        const manager = new documents_1.DocumentManager(createDocument);
        manager.openClientDocument(textDocument);
        manager.updateDocument(textDocument, [{ text: 'New content' }]);
        assert.strictEqual(document.getText(), 'New content');
    });
    it('updates the parts of the document', () => {
        const document = createTextDocument(textDocument);
        const createDocument = sinon_1.default.stub().returns(document);
        const manager = new documents_1.DocumentManager(createDocument);
        manager.openClientDocument(textDocument);
        manager.updateDocument(textDocument, [
            {
                text: 'svelte',
                range: vscode_languageserver_types_1.Range.create(0, 7, 0, 12),
                rangeLength: 5
            },
            {
                text: 'Greetings',
                range: vscode_languageserver_types_1.Range.create(0, 0, 0, 5),
                rangeLength: 5
            }
        ]);
        assert.strictEqual(document.getText(), 'Greetings, svelte!');
    });
    it("fails to update if document isn't open", () => {
        const manager = new documents_1.DocumentManager(createTextDocument);
        assert.throws(() => manager.updateDocument(textDocument, []));
    });
    it('update document in case-insensitive fs with different casing', () => {
        const textDocument = {
            uri: 'file:///hello2.svelte',
            version: 0,
            languageId: 'svelte',
            text: 'Hello, world!'
        };
        const manager = new documents_1.DocumentManager(createTextDocument, {
            useCaseSensitiveFileNames: false
        });
        manager.openClientDocument(textDocument);
        const firstVersion = manager.get(textDocument.uri).version;
        const position = { line: 0, character: textDocument.text.length };
        manager.updateDocument({
            ...textDocument,
            uri: 'file:///Hello2.svelte'
        }, [
            {
                range: { start: position, end: position },
                text: ' '
            }
        ]);
        assert.ok(manager.get(textDocument.uri).version > firstVersion);
    });
});
//# sourceMappingURL=DocumentManager.test.js.map