// extensions/common/mojom/event_dispatcher.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_EVENT_DISPATCHER_MOJOM_H_
#define EXTENSIONS_COMMON_MOJOM_EVENT_DISPATCHER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/event_dispatcher.mojom-features.h"  // IWYU pragma: export
#include "extensions/common/mojom/event_dispatcher.mojom-shared.h"  // IWYU pragma: export
#include "extensions/common/mojom/event_dispatcher.mojom-forward.h"  // IWYU pragma: export
#include "extensions/common/mojom/host_id.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace extensions::mojom {

class EventDispatcherProxy;

template <typename ImplRefTraits>
class EventDispatcherStub;

class EventDispatcherRequestValidator;
class EventDispatcherResponseValidator;


class EventDispatcher
    : public EventDispatcherInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = EventDispatcherInterfaceBase;
  using Proxy_ = EventDispatcherProxy;

  template <typename ImplRefTraits>
  using Stub_ = EventDispatcherStub<ImplRefTraits>;

  using RequestValidator_ = EventDispatcherRequestValidator;
  using ResponseValidator_ = EventDispatcherResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDispatchEventMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DispatchEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~EventDispatcher() = default;


  using DispatchEventCallback = base::OnceCallback<void(bool)>;
  
  virtual void DispatchEvent(DispatchEventParamsPtr params, ::base::Value::List event_args, DispatchEventCallback callback) = 0;
};



class  EventDispatcherProxy
    : public EventDispatcher {
 public:
  using InterfaceType = EventDispatcher;

  explicit EventDispatcherProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DispatchEvent(DispatchEventParamsPtr params, ::base::Value::List event_args, DispatchEventCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  EventDispatcherStubDispatch {
 public:
  static bool Accept(EventDispatcher* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      EventDispatcher* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<EventDispatcher>>
class EventDispatcherStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  EventDispatcherStub() = default;
  ~EventDispatcherStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EventDispatcherStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EventDispatcherStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  EventDispatcherRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  EventDispatcherResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  EventFilteringInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EventFilteringInfo, T>::value>;
  using DataView = EventFilteringInfoDataView;
  using Data_ = internal::EventFilteringInfo_Data;

  template <typename... Args>
  static EventFilteringInfoPtr New(Args&&... args) {
    return EventFilteringInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EventFilteringInfoPtr From(const U& u) {
    return mojo::TypeConverter<EventFilteringInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EventFilteringInfo>::Convert(*this);
  }


  EventFilteringInfo();

  EventFilteringInfo(
      const std::optional<::GURL>& url,
      const std::optional<std::string>& service_type,
      bool has_instance_id,
      int32_t instance_id,
      const std::optional<std::string>& window_type,
      bool has_window_exposed_by_default,
      bool window_exposed_by_default);


  ~EventFilteringInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EventFilteringInfoPtr>
  EventFilteringInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EventFilteringInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EventFilteringInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EventFilteringInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EventFilteringInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EventFilteringInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EventFilteringInfo_UnserializedMessageContext<
            UserType, EventFilteringInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EventFilteringInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EventFilteringInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EventFilteringInfo_UnserializedMessageContext<
            UserType, EventFilteringInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EventFilteringInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::GURL> url;
  
  std::optional<std::string> service_type;
  
  bool has_instance_id;
  
  int32_t instance_id;
  
  std::optional<std::string> window_type;
  
  bool has_window_exposed_by_default;
  
  bool window_exposed_by_default;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EventFilteringInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EventFilteringInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EventFilteringInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EventFilteringInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DispatchEventParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DispatchEventParams, T>::value>;
  using DataView = DispatchEventParamsDataView;
  using Data_ = internal::DispatchEventParams_Data;

  template <typename... Args>
  static DispatchEventParamsPtr New(Args&&... args) {
    return DispatchEventParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DispatchEventParamsPtr From(const U& u) {
    return mojo::TypeConverter<DispatchEventParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DispatchEventParams>::Convert(*this);
  }


  DispatchEventParams();

  DispatchEventParams(
      int32_t worker_thread_id,
      ::extensions::mojom::HostIDPtr host_id,
      const std::string& event_name,
      int32_t event_id,
      bool is_user_gesture,
      EventFilteringInfoPtr filtering_info);

DispatchEventParams(const DispatchEventParams&) = delete;
DispatchEventParams& operator=(const DispatchEventParams&) = delete;

  ~DispatchEventParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DispatchEventParamsPtr>
  DispatchEventParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DispatchEventParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DispatchEventParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DispatchEventParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DispatchEventParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DispatchEventParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DispatchEventParams_UnserializedMessageContext<
            UserType, DispatchEventParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DispatchEventParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DispatchEventParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DispatchEventParams_UnserializedMessageContext<
            UserType, DispatchEventParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DispatchEventParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t worker_thread_id;
  
  ::extensions::mojom::HostIDPtr host_id;
  
  std::string event_name;
  
  int32_t event_id;
  
  bool is_user_gesture;
  
  EventFilteringInfoPtr filtering_info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DispatchEventParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DispatchEventParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DispatchEventParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DispatchEventParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
EventFilteringInfoPtr EventFilteringInfo::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(service_type),
      mojo::Clone(has_instance_id),
      mojo::Clone(instance_id),
      mojo::Clone(window_type),
      mojo::Clone(has_window_exposed_by_default),
      mojo::Clone(window_exposed_by_default)
  );
}

template <typename T, EventFilteringInfo::EnableIfSame<T>*>
bool EventFilteringInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->service_type, other_struct.service_type))
    return false;
  if (!mojo::Equals(this->has_instance_id, other_struct.has_instance_id))
    return false;
  if (!mojo::Equals(this->instance_id, other_struct.instance_id))
    return false;
  if (!mojo::Equals(this->window_type, other_struct.window_type))
    return false;
  if (!mojo::Equals(this->has_window_exposed_by_default, other_struct.has_window_exposed_by_default))
    return false;
  if (!mojo::Equals(this->window_exposed_by_default, other_struct.window_exposed_by_default))
    return false;
  return true;
}

template <typename T, EventFilteringInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.service_type < rhs.service_type)
    return true;
  if (rhs.service_type < lhs.service_type)
    return false;
  if (lhs.has_instance_id < rhs.has_instance_id)
    return true;
  if (rhs.has_instance_id < lhs.has_instance_id)
    return false;
  if (lhs.instance_id < rhs.instance_id)
    return true;
  if (rhs.instance_id < lhs.instance_id)
    return false;
  if (lhs.window_type < rhs.window_type)
    return true;
  if (rhs.window_type < lhs.window_type)
    return false;
  if (lhs.has_window_exposed_by_default < rhs.has_window_exposed_by_default)
    return true;
  if (rhs.has_window_exposed_by_default < lhs.has_window_exposed_by_default)
    return false;
  if (lhs.window_exposed_by_default < rhs.window_exposed_by_default)
    return true;
  if (rhs.window_exposed_by_default < lhs.window_exposed_by_default)
    return false;
  return false;
}
template <typename StructPtrType>
DispatchEventParamsPtr DispatchEventParams::Clone() const {
  return New(
      mojo::Clone(worker_thread_id),
      mojo::Clone(host_id),
      mojo::Clone(event_name),
      mojo::Clone(event_id),
      mojo::Clone(is_user_gesture),
      mojo::Clone(filtering_info)
  );
}

template <typename T, DispatchEventParams::EnableIfSame<T>*>
bool DispatchEventParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->worker_thread_id, other_struct.worker_thread_id))
    return false;
  if (!mojo::Equals(this->host_id, other_struct.host_id))
    return false;
  if (!mojo::Equals(this->event_name, other_struct.event_name))
    return false;
  if (!mojo::Equals(this->event_id, other_struct.event_id))
    return false;
  if (!mojo::Equals(this->is_user_gesture, other_struct.is_user_gesture))
    return false;
  if (!mojo::Equals(this->filtering_info, other_struct.filtering_info))
    return false;
  return true;
}

template <typename T, DispatchEventParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.worker_thread_id < rhs.worker_thread_id)
    return true;
  if (rhs.worker_thread_id < lhs.worker_thread_id)
    return false;
  if (lhs.host_id < rhs.host_id)
    return true;
  if (rhs.host_id < lhs.host_id)
    return false;
  if (lhs.event_name < rhs.event_name)
    return true;
  if (rhs.event_name < lhs.event_name)
    return false;
  if (lhs.event_id < rhs.event_id)
    return true;
  if (rhs.event_id < lhs.event_id)
    return false;
  if (lhs.is_user_gesture < rhs.is_user_gesture)
    return true;
  if (rhs.is_user_gesture < lhs.is_user_gesture)
    return false;
  if (lhs.filtering_info < rhs.filtering_info)
    return true;
  if (rhs.filtering_info < lhs.filtering_info)
    return false;
  return false;
}


}  // extensions::mojom

namespace mojo {


template <>
struct  StructTraits<::extensions::mojom::EventFilteringInfo::DataView,
                                         ::extensions::mojom::EventFilteringInfoPtr> {
  static bool IsNull(const ::extensions::mojom::EventFilteringInfoPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::EventFilteringInfoPtr* output) { output->reset(); }

  static const decltype(::extensions::mojom::EventFilteringInfo::url)& url(
      const ::extensions::mojom::EventFilteringInfoPtr& input) {
    return input->url;
  }

  static const decltype(::extensions::mojom::EventFilteringInfo::service_type)& service_type(
      const ::extensions::mojom::EventFilteringInfoPtr& input) {
    return input->service_type;
  }

  static decltype(::extensions::mojom::EventFilteringInfo::has_instance_id) has_instance_id(
      const ::extensions::mojom::EventFilteringInfoPtr& input) {
    return input->has_instance_id;
  }

  static decltype(::extensions::mojom::EventFilteringInfo::instance_id) instance_id(
      const ::extensions::mojom::EventFilteringInfoPtr& input) {
    return input->instance_id;
  }

  static const decltype(::extensions::mojom::EventFilteringInfo::window_type)& window_type(
      const ::extensions::mojom::EventFilteringInfoPtr& input) {
    return input->window_type;
  }

  static decltype(::extensions::mojom::EventFilteringInfo::has_window_exposed_by_default) has_window_exposed_by_default(
      const ::extensions::mojom::EventFilteringInfoPtr& input) {
    return input->has_window_exposed_by_default;
  }

  static decltype(::extensions::mojom::EventFilteringInfo::window_exposed_by_default) window_exposed_by_default(
      const ::extensions::mojom::EventFilteringInfoPtr& input) {
    return input->window_exposed_by_default;
  }

  static bool Read(::extensions::mojom::EventFilteringInfo::DataView input, ::extensions::mojom::EventFilteringInfoPtr* output);
};


template <>
struct  StructTraits<::extensions::mojom::DispatchEventParams::DataView,
                                         ::extensions::mojom::DispatchEventParamsPtr> {
  static bool IsNull(const ::extensions::mojom::DispatchEventParamsPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::DispatchEventParamsPtr* output) { output->reset(); }

  static decltype(::extensions::mojom::DispatchEventParams::worker_thread_id) worker_thread_id(
      const ::extensions::mojom::DispatchEventParamsPtr& input) {
    return input->worker_thread_id;
  }

  static const decltype(::extensions::mojom::DispatchEventParams::host_id)& host_id(
      const ::extensions::mojom::DispatchEventParamsPtr& input) {
    return input->host_id;
  }

  static const decltype(::extensions::mojom::DispatchEventParams::event_name)& event_name(
      const ::extensions::mojom::DispatchEventParamsPtr& input) {
    return input->event_name;
  }

  static decltype(::extensions::mojom::DispatchEventParams::event_id) event_id(
      const ::extensions::mojom::DispatchEventParamsPtr& input) {
    return input->event_id;
  }

  static decltype(::extensions::mojom::DispatchEventParams::is_user_gesture) is_user_gesture(
      const ::extensions::mojom::DispatchEventParamsPtr& input) {
    return input->is_user_gesture;
  }

  static const decltype(::extensions::mojom::DispatchEventParams::filtering_info)& filtering_info(
      const ::extensions::mojom::DispatchEventParamsPtr& input) {
    return input->filtering_info;
  }

  static bool Read(::extensions::mojom::DispatchEventParams::DataView input, ::extensions::mojom::DispatchEventParamsPtr* output);
};

}  // namespace mojo

#endif  // EXTENSIONS_COMMON_MOJOM_EVENT_DISPATCHER_MOJOM_H_