// qtwebengine/browser/extensions/webui/extensions_ui_qt.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef QTWEBENGINE_BROWSER_EXTENSIONS_WEBUI_EXTENSIONS_UI_QT_MOJOM_SHARED_H_
#define QTWEBENGINE_BROWSER_EXTENSIONS_WEBUI_EXTENSIONS_UI_QT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "qtwebengine/browser/extensions/webui/extensions_ui_qt.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace qtwebengine::mojom {
class ExtensionInfoDataView;



}  // qtwebengine::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::qtwebengine::mojom::ExtensionInfoDataView> {
  using Data = ::qtwebengine::mojom::internal::ExtensionInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace qtwebengine::mojom {
// Interface base classes. They are used for type safety check.
class ExtensionsUIHandlerFactoryInterfaceBase {};

using ExtensionsUIHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<ExtensionsUIHandlerFactoryInterfaceBase>;
using ExtensionsUIHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<ExtensionsUIHandlerFactoryInterfaceBase>;
using ExtensionsUIHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ExtensionsUIHandlerFactoryInterfaceBase>;
using ExtensionsUIHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ExtensionsUIHandlerFactoryInterfaceBase>;
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class ExtensionInfoDataView {
 public:
  ExtensionInfoDataView() = default;

  ExtensionInfoDataView(
      internal::ExtensionInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVersion(UserType* output) {
    
    auto* pointer = data_->version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool isEnabled() const {
    return data_->isEnabled;
  }
  bool isInstalled() const {
    return data_->isInstalled;
  }
  bool isLoaded() const {
    return data_->isLoaded;
  }
 private:
  internal::ExtensionInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // qtwebengine::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::qtwebengine::mojom::ExtensionInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::qtwebengine::mojom::ExtensionInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::qtwebengine::mojom::internal::ExtensionInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in ExtensionInfo struct");
    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_description, description_fragment);
    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->description.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null description in ExtensionInfo struct");
    decltype(Traits::version(input)) in_version = Traits::version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->version)::BaseType> version_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_version, version_fragment);
    fragment->version.Set(
        version_fragment.is_null() ? nullptr : version_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->version.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null version in ExtensionInfo struct");
    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_id, id_fragment);
    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in ExtensionInfo struct");
    fragment->isEnabled = Traits::isEnabled(input);
    fragment->isInstalled = Traits::isInstalled(input);
    fragment->isLoaded = Traits::isLoaded(input);
  }

  static bool Deserialize(::qtwebengine::mojom::internal::ExtensionInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::qtwebengine::mojom::ExtensionInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace qtwebengine::mojom {

inline void ExtensionInfoDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ExtensionInfoDataView::GetDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ExtensionInfoDataView::GetVersionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->version.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ExtensionInfoDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // qtwebengine::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // QTWEBENGINE_BROWSER_EXTENSIONS_WEBUI_EXTENSIONS_UI_QT_MOJOM_SHARED_H_