// services/network/public/mojom/oblivious_http_request.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_OBLIVIOUS_HTTP_REQUEST_MOJOM_SHARED_INTERNAL_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_OBLIVIOUS_HTTP_REQUEST_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "services/network/public/mojom/isolation_info.mojom-shared-internal.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared-internal.h"
#include "services/network/public/mojom/network_param.mojom-shared-internal.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace network::mojom {
namespace internal {
class ObliviousHttpRequestBody_Data;
class ObliviousHttpResponse_Data;
class ObliviousHttpPaddingParameters_Data;
class ObliviousHttpRequest_Data;
class ObliviousHttpCompletionResult_Data;

#pragma pack(push, 1)


class  ObliviousHttpCompletionResult_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  ObliviousHttpCompletionResult_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~ObliviousHttpCompletionResult_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<ObliviousHttpCompletionResult_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class ObliviousHttpCompletionResult_Tag : uint32_t {

    
    kNetError,
    
    kOuterResponseErrorCode,
    
    kInnerResponse,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    int32_t f_net_error;
    int32_t f_outer_response_error_code;
    mojo::internal::Pointer<internal::ObliviousHttpResponse_Data> f_inner_response;
    uint64_t unknown;
  };

  uint32_t size;
  ObliviousHttpCompletionResult_Tag tag;
  Union_ data;
};
static_assert(sizeof(ObliviousHttpCompletionResult_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(ObliviousHttpCompletionResult_Data)");
class  ObliviousHttpRequestBody_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ByteString_Data> content;
  mojo::internal::Pointer<mojo::internal::String_Data> content_type;

 private:
  friend class mojo::internal::MessageFragment<ObliviousHttpRequestBody_Data>;

  ObliviousHttpRequestBody_Data();
  ~ObliviousHttpRequestBody_Data() = delete;
};
static_assert(sizeof(ObliviousHttpRequestBody_Data) == 24,
              "Bad sizeof(ObliviousHttpRequestBody_Data)");
// Used by ObliviousHttpRequestBody::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ObliviousHttpRequestBody_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ObliviousHttpRequestBody_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ObliviousHttpRequestBody_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ObliviousHttpRequestBody_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ObliviousHttpRequestBody_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ObliviousHttpResponse_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t response_code;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::network::mojom::internal::HttpResponseHeaders_Data> headers;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ByteString_Data> response_body;

 private:
  friend class mojo::internal::MessageFragment<ObliviousHttpResponse_Data>;

  ObliviousHttpResponse_Data();
  ~ObliviousHttpResponse_Data() = delete;
};
static_assert(sizeof(ObliviousHttpResponse_Data) == 32,
              "Bad sizeof(ObliviousHttpResponse_Data)");
// Used by ObliviousHttpResponse::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ObliviousHttpResponse_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ObliviousHttpResponse_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ObliviousHttpResponse_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ObliviousHttpResponse_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ObliviousHttpResponse_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ObliviousHttpPaddingParameters_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t add_exponential_pad : 1;
  uint8_t pad_to_next_power_of_two : 1;
  uint8_t pad1_[1];
  uint16_t exponential_mean;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ObliviousHttpPaddingParameters_Data>;

  ObliviousHttpPaddingParameters_Data();
  ~ObliviousHttpPaddingParameters_Data() = delete;
};
static_assert(sizeof(ObliviousHttpPaddingParameters_Data) == 16,
              "Bad sizeof(ObliviousHttpPaddingParameters_Data)");
// Used by ObliviousHttpPaddingParameters::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ObliviousHttpPaddingParameters_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ObliviousHttpPaddingParameters_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ObliviousHttpPaddingParameters_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ObliviousHttpPaddingParameters_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ObliviousHttpPaddingParameters_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ObliviousHttpRequest_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> relay_url;
  mojo::internal::Pointer<::network::mojom::internal::MutableNetworkTrafficAnnotationTag_Data> traffic_annotation;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> timeout_duration;
  mojo::internal::Pointer<mojo::internal::String_Data> key_config;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> resource_url;
  mojo::internal::Pointer<mojo::internal::String_Data> method;
  mojo::internal::Pointer<internal::ObliviousHttpRequestBody_Data> request_body;
  mojo::internal::Pointer<::network::mojom::internal::TrustTokenParams_Data> trust_token_params;
  mojo::internal::Pointer<internal::ObliviousHttpPaddingParameters_Data> padding_params;

 private:
  friend class mojo::internal::MessageFragment<ObliviousHttpRequest_Data>;

  ObliviousHttpRequest_Data();
  ~ObliviousHttpRequest_Data() = delete;
};
static_assert(sizeof(ObliviousHttpRequest_Data) == 80,
              "Bad sizeof(ObliviousHttpRequest_Data)");
// Used by ObliviousHttpRequest::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ObliviousHttpRequest_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ObliviousHttpRequest_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ObliviousHttpRequest_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ObliviousHttpRequest_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ObliviousHttpRequest_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_OBLIVIOUS_HTTP_REQUEST_MOJOM_SHARED_INTERNAL_H_