// services/viz/public/mojom/compositing/layer_context.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_CONTEXT_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_CONTEXT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/layer_context.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/animation.mojom-shared.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-shared.h"
#include "services/viz/public/mojom/compositing/layer.mojom-shared.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/tiling.mojom-shared.h"
#include "skia/public/mojom/skcolor4f.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace viz::mojom {
class LayerTreeUpdateDataView;

class PendingLayerContextDataView;



}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::LayerTreeUpdateDataView> {
  using Data = ::viz::mojom::internal::LayerTreeUpdate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::PendingLayerContextDataView> {
  using Data = ::viz::mojom::internal::PendingLayerContext_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {
// Interface base classes. They are used for type safety check.
class LayerContextInterfaceBase {};

using LayerContextPtrDataView =
    mojo::InterfacePtrDataView<LayerContextInterfaceBase>;
using LayerContextRequestDataView =
    mojo::InterfaceRequestDataView<LayerContextInterfaceBase>;
using LayerContextAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LayerContextInterfaceBase>;
using LayerContextAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LayerContextInterfaceBase>;
class LayerContextClientInterfaceBase {};

using LayerContextClientPtrDataView =
    mojo::InterfacePtrDataView<LayerContextClientInterfaceBase>;
using LayerContextClientRequestDataView =
    mojo::InterfaceRequestDataView<LayerContextClientInterfaceBase>;
using LayerContextClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LayerContextClientInterfaceBase>;
using LayerContextClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LayerContextClientInterfaceBase>;


class LayerTreeUpdateDataView {
 public:
  LayerTreeUpdateDataView() = default;

  LayerTreeUpdateDataView(
      internal::LayerTreeUpdate_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t source_frame_number() const {
    return data_->source_frame_number;
  }
  uint64_t trace_id() const {
    return data_->trace_id;
  }
  inline void GetDeviceViewportDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceViewport(UserType* output) {
    
    auto* pointer = data_->device_viewport.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  float device_scale_factor() const {
    return data_->device_scale_factor;
  }
  float painted_device_scale_factor() const {
    return data_->painted_device_scale_factor;
  }
  inline void GetLocalSurfaceIdFromParentDataView(
      ::viz::mojom::LocalSurfaceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocalSurfaceIdFromParent(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::LocalSurfaceIdDataView, UserType>(),
    "Attempting to read the optional `local_surface_id_from_parent` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLocalSurfaceIdFromParent` instead "
    "of `ReadLocalSurfaceIdFromParent if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->local_surface_id_from_parent.Get();
    return mojo::internal::Deserialize<::viz::mojom::LocalSurfaceIdDataView>(
        pointer, output, message_);
  }
  inline void GetBackgroundColorDataView(
      ::skia::mojom::SkColor4fDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundColor(UserType* output) {
    
    auto* pointer = data_->background_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColor4fDataView>(
        pointer, output, message_);
  }
  int32_t overscroll_elasticity_transform() const {
    return data_->overscroll_elasticity_transform;
  }
  int32_t page_scale_transform() const {
    return data_->page_scale_transform;
  }
  int32_t inner_scroll() const {
    return data_->inner_scroll;
  }
  int32_t outer_clip() const {
    return data_->outer_clip;
  }
  int32_t outer_scroll() const {
    return data_->outer_scroll;
  }
  inline void GetLayersDataView(
      mojo::ArrayDataView<::viz::mojom::LayerDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLayers(UserType* output) {
    
    auto* pointer = data_->layers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::LayerDataView>>(
        pointer, output, message_);
  }
  inline void GetLayerOrderDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLayerOrder(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<int32_t>, UserType>(),
    "Attempting to read the optional `layer_order` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLayerOrder` instead "
    "of `ReadLayerOrder if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->layer_order.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
  inline void GetTransformTreeUpdateDataView(
      ::viz::mojom::TransformTreeUpdateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransformTreeUpdate(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::TransformTreeUpdateDataView, UserType>(),
    "Attempting to read the optional `transform_tree_update` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTransformTreeUpdate` instead "
    "of `ReadTransformTreeUpdate if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->transform_tree_update.Get();
    return mojo::internal::Deserialize<::viz::mojom::TransformTreeUpdateDataView>(
        pointer, output, message_);
  }
  inline void GetTransformNodesDataView(
      mojo::ArrayDataView<::viz::mojom::TransformNodeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransformNodes(UserType* output) {
    
    auto* pointer = data_->transform_nodes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::TransformNodeDataView>>(
        pointer, output, message_);
  }
  inline void GetClipNodesDataView(
      mojo::ArrayDataView<::viz::mojom::ClipNodeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClipNodes(UserType* output) {
    
    auto* pointer = data_->clip_nodes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::ClipNodeDataView>>(
        pointer, output, message_);
  }
  inline void GetEffectNodesDataView(
      mojo::ArrayDataView<::viz::mojom::EffectNodeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEffectNodes(UserType* output) {
    
    auto* pointer = data_->effect_nodes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::EffectNodeDataView>>(
        pointer, output, message_);
  }
  inline void GetScrollNodesDataView(
      mojo::ArrayDataView<::viz::mojom::ScrollNodeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollNodes(UserType* output) {
    
    auto* pointer = data_->scroll_nodes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::ScrollNodeDataView>>(
        pointer, output, message_);
  }
  uint32_t num_transform_nodes() const {
    return data_->num_transform_nodes;
  }
  uint32_t num_clip_nodes() const {
    return data_->num_clip_nodes;
  }
  uint32_t num_effect_nodes() const {
    return data_->num_effect_nodes;
  }
  uint32_t num_scroll_nodes() const {
    return data_->num_scroll_nodes;
  }
  inline void GetTilingsDataView(
      mojo::ArrayDataView<::viz::mojom::TilingDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTilings(UserType* output) {
    
    auto* pointer = data_->tilings.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::TilingDataView>>(
        pointer, output, message_);
  }
  inline void GetAnimationTimelinesDataView(
      mojo::ArrayDataView<::viz::mojom::AnimationTimelineDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnimationTimelines(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::viz::mojom::AnimationTimelineDataView>, UserType>(),
    "Attempting to read the optional `animation_timelines` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAnimationTimelines` instead "
    "of `ReadAnimationTimelines if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->animation_timelines.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::AnimationTimelineDataView>>(
        pointer, output, message_);
  }
  inline void GetRemovedAnimationTimelinesDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemovedAnimationTimelines(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<int32_t>, UserType>(),
    "Attempting to read the optional `removed_animation_timelines` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRemovedAnimationTimelines` instead "
    "of `ReadRemovedAnimationTimelines if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->removed_animation_timelines.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
 private:
  internal::LayerTreeUpdate_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PendingLayerContextDataView {
 public:
  PendingLayerContextDataView() = default;

  PendingLayerContextDataView(
      internal::PendingLayerContext_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::viz::mojom::LayerContextAssociatedRequestDataView>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::viz::mojom::LayerContextClientAssociatedPtrInfoDataView>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PendingLayerContext_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::LayerTreeUpdateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::LayerTreeUpdateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::LayerTreeUpdate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->source_frame_number = Traits::source_frame_number(input);
    fragment->trace_id = Traits::trace_id(input);
    decltype(Traits::device_viewport(input)) in_device_viewport = Traits::device_viewport(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_viewport)::BaseType> device_viewport_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_device_viewport, device_viewport_fragment);
    fragment->device_viewport.Set(
        device_viewport_fragment.is_null() ? nullptr : device_viewport_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->device_viewport.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null device_viewport in LayerTreeUpdate struct");
    fragment->device_scale_factor = Traits::device_scale_factor(input);
    fragment->painted_device_scale_factor = Traits::painted_device_scale_factor(input);
    decltype(Traits::local_surface_id_from_parent(input)) in_local_surface_id_from_parent = Traits::local_surface_id_from_parent(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->local_surface_id_from_parent)::BaseType> local_surface_id_from_parent_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
        in_local_surface_id_from_parent, local_surface_id_from_parent_fragment);
    fragment->local_surface_id_from_parent.Set(
        local_surface_id_from_parent_fragment.is_null() ? nullptr : local_surface_id_from_parent_fragment.data());
    decltype(Traits::background_color(input)) in_background_color = Traits::background_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->background_color)::BaseType> background_color_fragment(
            fragment.message());
    mojo::internal::Serialize<::skia::mojom::SkColor4fDataView>(
        in_background_color, background_color_fragment);
    fragment->background_color.Set(
        background_color_fragment.is_null() ? nullptr : background_color_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->background_color.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null background_color in LayerTreeUpdate struct");
    fragment->overscroll_elasticity_transform = Traits::overscroll_elasticity_transform(input);
    fragment->page_scale_transform = Traits::page_scale_transform(input);
    fragment->inner_scroll = Traits::inner_scroll(input);
    fragment->outer_clip = Traits::outer_clip(input);
    fragment->outer_scroll = Traits::outer_scroll(input);
    decltype(Traits::layers(input)) in_layers = Traits::layers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->layers)::BaseType>
        layers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& layers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::LayerDataView>>(
        in_layers, layers_fragment, &layers_validate_params);
    fragment->layers.Set(
        layers_fragment.is_null() ? nullptr : layers_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->layers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null layers in LayerTreeUpdate struct");
    decltype(Traits::layer_order(input)) in_layer_order = Traits::layer_order(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->layer_order)::BaseType>
        layer_order_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& layer_order_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
        in_layer_order, layer_order_fragment, &layer_order_validate_params);
    fragment->layer_order.Set(
        layer_order_fragment.is_null() ? nullptr : layer_order_fragment.data());
    decltype(Traits::transform_tree_update(input)) in_transform_tree_update = Traits::transform_tree_update(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transform_tree_update)::BaseType> transform_tree_update_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::TransformTreeUpdateDataView>(
        in_transform_tree_update, transform_tree_update_fragment);
    fragment->transform_tree_update.Set(
        transform_tree_update_fragment.is_null() ? nullptr : transform_tree_update_fragment.data());
    decltype(Traits::transform_nodes(input)) in_transform_nodes = Traits::transform_nodes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transform_nodes)::BaseType>
        transform_nodes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& transform_nodes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::TransformNodeDataView>>(
        in_transform_nodes, transform_nodes_fragment, &transform_nodes_validate_params);
    fragment->transform_nodes.Set(
        transform_nodes_fragment.is_null() ? nullptr : transform_nodes_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->transform_nodes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transform_nodes in LayerTreeUpdate struct");
    decltype(Traits::clip_nodes(input)) in_clip_nodes = Traits::clip_nodes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->clip_nodes)::BaseType>
        clip_nodes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& clip_nodes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ClipNodeDataView>>(
        in_clip_nodes, clip_nodes_fragment, &clip_nodes_validate_params);
    fragment->clip_nodes.Set(
        clip_nodes_fragment.is_null() ? nullptr : clip_nodes_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->clip_nodes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null clip_nodes in LayerTreeUpdate struct");
    decltype(Traits::effect_nodes(input)) in_effect_nodes = Traits::effect_nodes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->effect_nodes)::BaseType>
        effect_nodes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& effect_nodes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::EffectNodeDataView>>(
        in_effect_nodes, effect_nodes_fragment, &effect_nodes_validate_params);
    fragment->effect_nodes.Set(
        effect_nodes_fragment.is_null() ? nullptr : effect_nodes_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->effect_nodes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null effect_nodes in LayerTreeUpdate struct");
    decltype(Traits::scroll_nodes(input)) in_scroll_nodes = Traits::scroll_nodes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scroll_nodes)::BaseType>
        scroll_nodes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& scroll_nodes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ScrollNodeDataView>>(
        in_scroll_nodes, scroll_nodes_fragment, &scroll_nodes_validate_params);
    fragment->scroll_nodes.Set(
        scroll_nodes_fragment.is_null() ? nullptr : scroll_nodes_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->scroll_nodes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scroll_nodes in LayerTreeUpdate struct");
    fragment->num_transform_nodes = Traits::num_transform_nodes(input);
    fragment->num_clip_nodes = Traits::num_clip_nodes(input);
    fragment->num_effect_nodes = Traits::num_effect_nodes(input);
    fragment->num_scroll_nodes = Traits::num_scroll_nodes(input);
    decltype(Traits::tilings(input)) in_tilings = Traits::tilings(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tilings)::BaseType>
        tilings_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& tilings_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::TilingDataView>>(
        in_tilings, tilings_fragment, &tilings_validate_params);
    fragment->tilings.Set(
        tilings_fragment.is_null() ? nullptr : tilings_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->tilings.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tilings in LayerTreeUpdate struct");
    decltype(Traits::animation_timelines(input)) in_animation_timelines = Traits::animation_timelines(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->animation_timelines)::BaseType>
        animation_timelines_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& animation_timelines_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::AnimationTimelineDataView>>(
        in_animation_timelines, animation_timelines_fragment, &animation_timelines_validate_params);
    fragment->animation_timelines.Set(
        animation_timelines_fragment.is_null() ? nullptr : animation_timelines_fragment.data());
    decltype(Traits::removed_animation_timelines(input)) in_removed_animation_timelines = Traits::removed_animation_timelines(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->removed_animation_timelines)::BaseType>
        removed_animation_timelines_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& removed_animation_timelines_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
        in_removed_animation_timelines, removed_animation_timelines_fragment, &removed_animation_timelines_validate_params);
    fragment->removed_animation_timelines.Set(
        removed_animation_timelines_fragment.is_null() ? nullptr : removed_animation_timelines_fragment.data());
  }

  static bool Deserialize(::viz::mojom::internal::LayerTreeUpdate_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::LayerTreeUpdateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::PendingLayerContextDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::PendingLayerContextDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::PendingLayerContext_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::receiver(input)) in_receiver = Traits::receiver(input);
    mojo::internal::Serialize<::viz::mojom::LayerContextAssociatedRequestDataView>(
        in_receiver, &fragment->receiver, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->receiver),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid receiver in PendingLayerContext struct");
    decltype(Traits::client(input)) in_client = Traits::client(input);
    mojo::internal::Serialize<::viz::mojom::LayerContextClientAssociatedPtrInfoDataView>(
        in_client, &fragment->client, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->client),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid client in PendingLayerContext struct");
  }

  static bool Deserialize(::viz::mojom::internal::PendingLayerContext_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::PendingLayerContextDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void LayerTreeUpdateDataView::GetDeviceViewportDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->device_viewport.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetLocalSurfaceIdFromParentDataView(
    ::viz::mojom::LocalSurfaceIdDataView* output) {
  auto pointer = data_->local_surface_id_from_parent.Get();
  *output = ::viz::mojom::LocalSurfaceIdDataView(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetBackgroundColorDataView(
    ::skia::mojom::SkColor4fDataView* output) {
  auto pointer = data_->background_color.Get();
  *output = ::skia::mojom::SkColor4fDataView(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetLayersDataView(
    mojo::ArrayDataView<::viz::mojom::LayerDataView>* output) {
  auto pointer = data_->layers.Get();
  *output = mojo::ArrayDataView<::viz::mojom::LayerDataView>(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetLayerOrderDataView(
    mojo::ArrayDataView<int32_t>* output) {
  auto pointer = data_->layer_order.Get();
  *output = mojo::ArrayDataView<int32_t>(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetTransformTreeUpdateDataView(
    ::viz::mojom::TransformTreeUpdateDataView* output) {
  auto pointer = data_->transform_tree_update.Get();
  *output = ::viz::mojom::TransformTreeUpdateDataView(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetTransformNodesDataView(
    mojo::ArrayDataView<::viz::mojom::TransformNodeDataView>* output) {
  auto pointer = data_->transform_nodes.Get();
  *output = mojo::ArrayDataView<::viz::mojom::TransformNodeDataView>(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetClipNodesDataView(
    mojo::ArrayDataView<::viz::mojom::ClipNodeDataView>* output) {
  auto pointer = data_->clip_nodes.Get();
  *output = mojo::ArrayDataView<::viz::mojom::ClipNodeDataView>(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetEffectNodesDataView(
    mojo::ArrayDataView<::viz::mojom::EffectNodeDataView>* output) {
  auto pointer = data_->effect_nodes.Get();
  *output = mojo::ArrayDataView<::viz::mojom::EffectNodeDataView>(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetScrollNodesDataView(
    mojo::ArrayDataView<::viz::mojom::ScrollNodeDataView>* output) {
  auto pointer = data_->scroll_nodes.Get();
  *output = mojo::ArrayDataView<::viz::mojom::ScrollNodeDataView>(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetTilingsDataView(
    mojo::ArrayDataView<::viz::mojom::TilingDataView>* output) {
  auto pointer = data_->tilings.Get();
  *output = mojo::ArrayDataView<::viz::mojom::TilingDataView>(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetAnimationTimelinesDataView(
    mojo::ArrayDataView<::viz::mojom::AnimationTimelineDataView>* output) {
  auto pointer = data_->animation_timelines.Get();
  *output = mojo::ArrayDataView<::viz::mojom::AnimationTimelineDataView>(pointer, message_);
}
inline void LayerTreeUpdateDataView::GetRemovedAnimationTimelinesDataView(
    mojo::ArrayDataView<int32_t>* output) {
  auto pointer = data_->removed_animation_timelines.Get();
  *output = mojo::ArrayDataView<int32_t>(pointer, message_);
}





}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_CONTEXT_MOJOM_SHARED_H_