// third_party/blink/public/mojom/blob/data_element.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_DATA_ELEMENT_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_DATA_ELEMENT_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/blob/data_element.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/blob/data_element.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/blob/data_element.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom-blink.h"
#include "mojo/public/mojom/base/file_path.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class BytesProviderProxy;

template <typename ImplRefTraits>
class BytesProviderStub;

class BytesProviderRequestValidator;
class BytesProviderResponseValidator;


class PLATFORM_EXPORT BytesProvider
    : public BytesProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BytesProviderInterfaceBase;
  using Proxy_ = BytesProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = BytesProviderStub<ImplRefTraits>;

  using RequestValidator_ = BytesProviderRequestValidator;
  using ResponseValidator_ = BytesProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRequestAsReplyMinVersion = 0,
    kRequestAsStreamMinVersion = 0,
    kRequestAsFileMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestAsReply_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestAsStream_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestAsFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BytesProvider() = default;


  using RequestAsReplyCallback = base::OnceCallback<void(const WTF::Vector<uint8_t>&)>;
  
  virtual void RequestAsReply(RequestAsReplyCallback callback) = 0;

  
  virtual void RequestAsStream(::mojo::ScopedDataPipeProducerHandle pipe) = 0;


  using RequestAsFileCallback = base::OnceCallback<void(std::optional<::base::Time>)>;
  
  virtual void RequestAsFile(uint64_t source_offset, uint64_t source_size, ::base::File file, uint64_t file_offset, RequestAsFileCallback callback) = 0;
};



class PLATFORM_EXPORT BytesProviderProxy
    : public BytesProvider {
 public:
  using InterfaceType = BytesProvider;

  explicit BytesProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestAsReply(RequestAsReplyCallback callback) final;
  
  void RequestAsStream(::mojo::ScopedDataPipeProducerHandle pipe) final;
  
  void RequestAsFile(uint64_t source_offset, uint64_t source_size, ::base::File file, uint64_t file_offset, RequestAsFileCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT BytesProviderStubDispatch {
 public:
  static bool Accept(BytesProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BytesProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BytesProvider>>
class BytesProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BytesProviderStub() = default;
  ~BytesProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BytesProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BytesProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT BytesProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT BytesProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class PLATFORM_EXPORT DataElement {
 public:
  using DataView = DataElementDataView;
  using Data_ = internal::DataElement_Data;
  using Tag = Data_::DataElement_Tag;

  template <typename... Args>
  static DataElementPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |bytes|.
  static DataElementPtr
  NewBytes(
      DataElementBytesPtr value) {
    auto result = DataElementPtr(std::in_place);
    result->set_bytes(std::move(value));
    return result;
  }
  // Construct an instance holding |file|.
  static DataElementPtr
  NewFile(
      DataElementFilePtr value) {
    auto result = DataElementPtr(std::in_place);
    result->set_file(std::move(value));
    return result;
  }
  // Construct an instance holding |blob|.
  static DataElementPtr
  NewBlob(
      DataElementBlobPtr value) {
    auto result = DataElementPtr(std::in_place);
    result->set_blob(std::move(value));
    return result;
  }

  template <typename U>
  static DataElementPtr From(const U& u) {
    return mojo::TypeConverter<DataElementPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataElement>::Convert(*this);
  }

  DataElement();
  ~DataElement();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  DataElement(const DataElement& other) = delete;
  DataElement& operator=(const DataElement& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = DataElementPtr>
  DataElementPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, DataElement>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, DataElement>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_bytes() const { return tag_ == Tag::kBytes; }

  
  DataElementBytesPtr& get_bytes() const {
    CHECK(tag_ == Tag::kBytes);
    return *(data_.bytes);
  }

  
  void set_bytes(
      DataElementBytesPtr bytes);
  
  bool is_file() const { return tag_ == Tag::kFile; }

  
  DataElementFilePtr& get_file() const {
    CHECK(tag_ == Tag::kFile);
    return *(data_.file);
  }

  
  void set_file(
      DataElementFilePtr file);
  
  bool is_blob() const { return tag_ == Tag::kBlob; }

  
  DataElementBlobPtr& get_blob() const {
    CHECK(tag_ == Tag::kBlob);
    return *(data_.blob);
  }

  
  void set_blob(
      DataElementBlobPtr blob);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataElement::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<DataElement::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    DataElementBytesPtr* bytes;
    DataElementFilePtr* file;
    DataElementBlobPtr* blob;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class PLATFORM_EXPORT DataElementBytes {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DataElementBytes, T>::value>;
  using DataView = DataElementBytesDataView;
  using Data_ = internal::DataElementBytes_Data;
  
  static constexpr uint64_t kMaximumEmbeddedDataSize = 256000ULL;

  template <typename... Args>
  static DataElementBytesPtr New(Args&&... args) {
    return DataElementBytesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DataElementBytesPtr From(const U& u) {
    return mojo::TypeConverter<DataElementBytesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataElementBytes>::Convert(*this);
  }


  DataElementBytes();

  DataElementBytes(
      uint64_t length,
      std::optional<WTF::Vector<uint8_t>> embedded_data,
      ::mojo::PendingRemote<BytesProvider> data);

DataElementBytes(const DataElementBytes&) = delete;
DataElementBytes& operator=(const DataElementBytes&) = delete;

  ~DataElementBytes();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DataElementBytesPtr>
  DataElementBytesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DataElementBytes::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DataElementBytes::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DataElementBytes::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataElementBytes::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DataElementBytes_UnserializedMessageContext<
            UserType, DataElementBytes::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DataElementBytes::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DataElementBytes::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DataElementBytes_UnserializedMessageContext<
            UserType, DataElementBytes::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DataElementBytes::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t length;
  
  std::optional<WTF::Vector<uint8_t>> embedded_data;
  
  ::mojo::PendingRemote<BytesProvider> data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DataElementBytes::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DataElementBytes::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DataElementBytes::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DataElementBytes::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT DataElementFile {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DataElementFile, T>::value>;
  using DataView = DataElementFileDataView;
  using Data_ = internal::DataElementFile_Data;

  template <typename... Args>
  static DataElementFilePtr New(Args&&... args) {
    return DataElementFilePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DataElementFilePtr From(const U& u) {
    return mojo::TypeConverter<DataElementFilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataElementFile>::Convert(*this);
  }


  DataElementFile();

  DataElementFile(
      const ::base::FilePath& path,
      uint64_t offset,
      uint64_t length,
      std::optional<::base::Time> expected_modification_time);


  ~DataElementFile();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DataElementFilePtr>
  DataElementFilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DataElementFile::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DataElementFile::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DataElementFile::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataElementFile::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataElementFile::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DataElementFile_UnserializedMessageContext<
            UserType, DataElementFile::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DataElementFile::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DataElementFile::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DataElementFile_UnserializedMessageContext<
            UserType, DataElementFile::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DataElementFile::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::FilePath path;
  
  uint64_t offset;
  
  uint64_t length;
  
  std::optional<::base::Time> expected_modification_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DataElementFile::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DataElementFile::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DataElementFile::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DataElementFile::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT DataElementBlob {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DataElementBlob, T>::value>;
  using DataView = DataElementBlobDataView;
  using Data_ = internal::DataElementBlob_Data;

  template <typename... Args>
  static DataElementBlobPtr New(Args&&... args) {
    return DataElementBlobPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DataElementBlobPtr From(const U& u) {
    return mojo::TypeConverter<DataElementBlobPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataElementBlob>::Convert(*this);
  }


  DataElementBlob();

  DataElementBlob(
      ::mojo::PendingRemote<::blink::mojom::blink::Blob> blob,
      uint64_t offset,
      uint64_t length);

DataElementBlob(const DataElementBlob&) = delete;
DataElementBlob& operator=(const DataElementBlob&) = delete;

  ~DataElementBlob();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DataElementBlobPtr>
  DataElementBlobPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DataElementBlob::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DataElementBlob::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DataElementBlob::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataElementBlob::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DataElementBlob_UnserializedMessageContext<
            UserType, DataElementBlob::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DataElementBlob::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DataElementBlob::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DataElementBlob_UnserializedMessageContext<
            UserType, DataElementBlob::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DataElementBlob::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<::blink::mojom::blink::Blob> blob;
  
  uint64_t offset;
  
  uint64_t length;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DataElementBlob::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DataElementBlob::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DataElementBlob::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DataElementBlob::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
DataElementPtr DataElement::Clone() const {
  switch (tag_) {
    case Tag::kBytes:
      return NewBytes(
          mojo::Clone(*data_.bytes));
    case Tag::kFile:
      return NewFile(
          mojo::Clone(*data_.file));
    case Tag::kBlob:
      return NewBlob(
          mojo::Clone(*data_.blob));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, DataElement>::value>::type*>
bool DataElement::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kBytes:
      return mojo::Equals(*(data_.bytes), *(other.data_.bytes));
    case Tag::kFile:
      return mojo::Equals(*(data_.file), *(other.data_.file));
    case Tag::kBlob:
      return mojo::Equals(*(data_.blob), *(other.data_.blob));
  }

  return false;
}
template <typename StructPtrType>
DataElementBytesPtr DataElementBytes::Clone() const {
  return New(
      mojo::Clone(length),
      mojo::Clone(embedded_data),
      mojo::Clone(data)
  );
}

template <typename T, DataElementBytes::EnableIfSame<T>*>
bool DataElementBytes::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->length, other_struct.length))
    return false;
  if (!mojo::Equals(this->embedded_data, other_struct.embedded_data))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, DataElementBytes::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.length < rhs.length)
    return true;
  if (rhs.length < lhs.length)
    return false;
  if (lhs.embedded_data < rhs.embedded_data)
    return true;
  if (rhs.embedded_data < lhs.embedded_data)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
DataElementFilePtr DataElementFile::Clone() const {
  return New(
      mojo::Clone(path),
      mojo::Clone(offset),
      mojo::Clone(length),
      mojo::Clone(expected_modification_time)
  );
}

template <typename T, DataElementFile::EnableIfSame<T>*>
bool DataElementFile::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  if (!mojo::Equals(this->length, other_struct.length))
    return false;
  if (!mojo::Equals(this->expected_modification_time, other_struct.expected_modification_time))
    return false;
  return true;
}

template <typename T, DataElementFile::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.path < rhs.path)
    return true;
  if (rhs.path < lhs.path)
    return false;
  if (lhs.offset < rhs.offset)
    return true;
  if (rhs.offset < lhs.offset)
    return false;
  if (lhs.length < rhs.length)
    return true;
  if (rhs.length < lhs.length)
    return false;
  if (lhs.expected_modification_time < rhs.expected_modification_time)
    return true;
  if (rhs.expected_modification_time < lhs.expected_modification_time)
    return false;
  return false;
}
template <typename StructPtrType>
DataElementBlobPtr DataElementBlob::Clone() const {
  return New(
      mojo::Clone(blob),
      mojo::Clone(offset),
      mojo::Clone(length)
  );
}

template <typename T, DataElementBlob::EnableIfSame<T>*>
bool DataElementBlob::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->blob, other_struct.blob))
    return false;
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  if (!mojo::Equals(this->length, other_struct.length))
    return false;
  return true;
}

template <typename T, DataElementBlob::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.blob < rhs.blob)
    return true;
  if (rhs.blob < lhs.blob)
    return false;
  if (lhs.offset < rhs.offset)
    return true;
  if (rhs.offset < lhs.offset)
    return false;
  if (lhs.length < rhs.length)
    return true;
  if (rhs.length < lhs.length)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DataElementBytes::DataView,
                                         ::blink::mojom::blink::DataElementBytesPtr> {
  static bool IsNull(const ::blink::mojom::blink::DataElementBytesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DataElementBytesPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::DataElementBytes::length) length(
      const ::blink::mojom::blink::DataElementBytesPtr& input) {
    return input->length;
  }

  static const decltype(::blink::mojom::blink::DataElementBytes::embedded_data)& embedded_data(
      const ::blink::mojom::blink::DataElementBytesPtr& input) {
    return input->embedded_data;
  }

  static  decltype(::blink::mojom::blink::DataElementBytes::data)& data(
       ::blink::mojom::blink::DataElementBytesPtr& input) {
    return input->data;
  }

  static bool Read(::blink::mojom::blink::DataElementBytes::DataView input, ::blink::mojom::blink::DataElementBytesPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DataElementFile::DataView,
                                         ::blink::mojom::blink::DataElementFilePtr> {
  static bool IsNull(const ::blink::mojom::blink::DataElementFilePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DataElementFilePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::DataElementFile::path)& path(
      const ::blink::mojom::blink::DataElementFilePtr& input) {
    return input->path;
  }

  static decltype(::blink::mojom::blink::DataElementFile::offset) offset(
      const ::blink::mojom::blink::DataElementFilePtr& input) {
    return input->offset;
  }

  static decltype(::blink::mojom::blink::DataElementFile::length) length(
      const ::blink::mojom::blink::DataElementFilePtr& input) {
    return input->length;
  }

  static const decltype(::blink::mojom::blink::DataElementFile::expected_modification_time)& expected_modification_time(
      const ::blink::mojom::blink::DataElementFilePtr& input) {
    return input->expected_modification_time;
  }

  static bool Read(::blink::mojom::blink::DataElementFile::DataView input, ::blink::mojom::blink::DataElementFilePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DataElementBlob::DataView,
                                         ::blink::mojom::blink::DataElementBlobPtr> {
  static bool IsNull(const ::blink::mojom::blink::DataElementBlobPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DataElementBlobPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::blink::DataElementBlob::blob)& blob(
       ::blink::mojom::blink::DataElementBlobPtr& input) {
    return input->blob;
  }

  static decltype(::blink::mojom::blink::DataElementBlob::offset) offset(
      const ::blink::mojom::blink::DataElementBlobPtr& input) {
    return input->offset;
  }

  static decltype(::blink::mojom::blink::DataElementBlob::length) length(
      const ::blink::mojom::blink::DataElementBlobPtr& input) {
    return input->length;
  }

  static bool Read(::blink::mojom::blink::DataElementBlob::DataView input, ::blink::mojom::blink::DataElementBlobPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::DataElement::DataView,
                                        ::blink::mojom::blink::DataElementPtr> {
  static bool IsNull(const ::blink::mojom::blink::DataElementPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DataElementPtr* output) { output->reset(); }

  static ::blink::mojom::blink::DataElement::Tag GetTag(const ::blink::mojom::blink::DataElementPtr& input) {
    return input->which();
  }

  static  ::blink::mojom::blink::DataElementBytesPtr& bytes( ::blink::mojom::blink::DataElementPtr& input) {
    return input->get_bytes();
  }

  static const ::blink::mojom::blink::DataElementFilePtr& file(const ::blink::mojom::blink::DataElementPtr& input) {
    return input->get_file();
  }

  static  ::blink::mojom::blink::DataElementBlobPtr& blob( ::blink::mojom::blink::DataElementPtr& input) {
    return input->get_blob();
  }

  static bool Read(::blink::mojom::blink::DataElement::DataView input, ::blink::mojom::blink::DataElementPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_DATA_ELEMENT_MOJOM_BLINK_H_