/* BluetoothEnums.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BluetoothEnums.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Inspired by gnome-bluetooth.
 */

#include "statusapplet.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

/**
 * The type of battery reporting supported by the device.
 */
static GType
battery_type_get_type_once (void)
{
	static const GEnumValue values[] = {{BATTERY_TYPE_NONE, "BATTERY_TYPE_NONE", "none"}, {BATTERY_TYPE_PERCENTAGE, "BATTERY_TYPE_PERCENTAGE", "percentage"}, {BATTERY_TYPE_COARSE, "BATTERY_TYPE_COARSE", "coarse"}, {0, NULL, NULL}};
	GType battery_type_type_id;
	battery_type_type_id = g_enum_register_static ("BatteryType", values);
	return battery_type_type_id;
}

GType
battery_type_get_type (void)
{
	static volatile gsize battery_type_type_id__once = 0;
	if (g_once_init_enter (&battery_type_type_id__once)) {
		GType battery_type_type_id;
		battery_type_type_id = battery_type_get_type_once ();
		g_once_init_leave (&battery_type_type_id__once, battery_type_type_id);
	}
	return battery_type_type_id__once;
}

/**
 * The type of a Bluetooth device.
 */
static GType
bluetooth_type_get_type_once (void)
{
	static const GFlagsValue values[] = {{BLUETOOTH_TYPE_ANY, "BLUETOOTH_TYPE_ANY", "any"}, {BLUETOOTH_TYPE_PHONE, "BLUETOOTH_TYPE_PHONE", "phone"}, {BLUETOOTH_TYPE_MODEM, "BLUETOOTH_TYPE_MODEM", "modem"}, {BLUETOOTH_TYPE_COMPUTER, "BLUETOOTH_TYPE_COMPUTER", "computer"}, {BLUETOOTH_TYPE_NETWORK, "BLUETOOTH_TYPE_NETWORK", "network"}, {BLUETOOTH_TYPE_HEADSET, "BLUETOOTH_TYPE_HEADSET", "headset"}, {BLUETOOTH_TYPE_HEADPHONES, "BLUETOOTH_TYPE_HEADPHONES", "headphones"}, {BLUETOOTH_TYPE_OTHER_AUDIO, "BLUETOOTH_TYPE_OTHER_AUDIO", "other-audio"}, {BLUETOOTH_TYPE_KEYBOARD, "BLUETOOTH_TYPE_KEYBOARD", "keyboard"}, {BLUETOOTH_TYPE_MOUSE, "BLUETOOTH_TYPE_MOUSE", "mouse"}, {BLUETOOTH_TYPE_CAMERA, "BLUETOOTH_TYPE_CAMERA", "camera"}, {BLUETOOTH_TYPE_PRINTER, "BLUETOOTH_TYPE_PRINTER", "printer"}, {BLUETOOTH_TYPE_JOYPAD, "BLUETOOTH_TYPE_JOYPAD", "joypad"}, {BLUETOOTH_TYPE_TABLET, "BLUETOOTH_TYPE_TABLET", "tablet"}, {BLUETOOTH_TYPE_VIDEO, "BLUETOOTH_TYPE_VIDEO", "video"}, {BLUETOOTH_TYPE_REMOTE_CONTROL, "BLUETOOTH_TYPE_REMOTE_CONTROL", "remote-control"}, {BLUETOOTH_TYPE_SCANNER, "BLUETOOTH_TYPE_SCANNER", "scanner"}, {BLUETOOTH_TYPE_DISPLAY, "BLUETOOTH_TYPE_DISPLAY", "display"}, {BLUETOOTH_TYPE_WEARABLE, "BLUETOOTH_TYPE_WEARABLE", "wearable"}, {BLUETOOTH_TYPE_TOY, "BLUETOOTH_TYPE_TOY", "toy"}, {BLUETOOTH_TYPE_SPEAKERS, "BLUETOOTH_TYPE_SPEAKERS", "speakers"}, {0, NULL, NULL}};
	GType bluetooth_type_type_id;
	bluetooth_type_type_id = g_flags_register_static ("BluetoothType", values);
	return bluetooth_type_type_id;
}

GType
bluetooth_type_get_type (void)
{
	static volatile gsize bluetooth_type_type_id__once = 0;
	if (g_once_init_enter (&bluetooth_type_type_id__once)) {
		GType bluetooth_type_type_id;
		bluetooth_type_type_id = bluetooth_type_get_type_once ();
		g_once_init_leave (&bluetooth_type_type_id__once, bluetooth_type_type_id);
	}
	return bluetooth_type_type_id__once;
}

/**
 * A more precise power state for a Bluetooth adapter.
 */
/**
 * Try to match a string to a PowerState.
 *
 * If no match is found, returns PowerState.ABSENT.
 */
PowerState
power_state_from_string (const gchar* state)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	PowerState result;
	g_return_val_if_fail (state != NULL, 0);
	_tmp0_ = state;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("on")))) {
		switch (0) {
			default:
			{
				result = POWER_STATE_ON;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("off-enabling")))) {
		switch (0) {
			default:
			{
				result = POWER_STATE_TURNING_ON;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("on-disabling")))) {
		switch (0) {
			default:
			{
				result = POWER_STATE_TURNING_OFF;
				return result;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("off")))) || (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("off-blocked"))))) {
		switch (0) {
			default:
			{
				result = POWER_STATE_OFF;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = POWER_STATE_ABSENT;
				return result;
			}
		}
	}
}

static GType
power_state_get_type_once (void)
{
	static const GEnumValue values[] = {{POWER_STATE_ABSENT, "POWER_STATE_ABSENT", "absent"}, {POWER_STATE_ON, "POWER_STATE_ON", "on"}, {POWER_STATE_TURNING_ON, "POWER_STATE_TURNING_ON", "turning-on"}, {POWER_STATE_TURNING_OFF, "POWER_STATE_TURNING_OFF", "turning-off"}, {POWER_STATE_OFF, "POWER_STATE_OFF", "off"}, {0, NULL, NULL}};
	GType power_state_type_id;
	power_state_type_id = g_enum_register_static ("PowerState", values);
	return power_state_type_id;
}

GType
power_state_get_type (void)
{
	static volatile gsize power_state_type_id__once = 0;
	if (g_once_init_enter (&power_state_type_id__once)) {
		GType power_state_type_id;
		power_state_type_id = power_state_get_type_once ();
		g_once_init_leave (&power_state_type_id__once, power_state_type_id);
	}
	return power_state_type_id__once;
}

