// Copyright 2024-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: buf/plugin/info/v1/license.proto

//go:build !protoopaque

package infov1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A plugin license.
type License struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The SPDX license ID.
	//
	// See https://spdx.org/licenses.
	SpdxLicenseId string `protobuf:"bytes,1,opt,name=spdx_license_id,json=spdxLicenseId,proto3" json:"spdx_license_id,omitempty"`
	// The source of a license is either raw text, or a URL that contains the license.
	//
	// Types that are valid to be assigned to Source:
	//
	//	*License_Text
	//	*License_Url
	Source        isLicense_Source `protobuf_oneof:"source"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *License) Reset() {
	*x = License{}
	mi := &file_buf_plugin_info_v1_license_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *License) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*License) ProtoMessage() {}

func (x *License) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_info_v1_license_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *License) GetSpdxLicenseId() string {
	if x != nil {
		return x.SpdxLicenseId
	}
	return ""
}

func (x *License) GetSource() isLicense_Source {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *License) GetText() string {
	if x != nil {
		if x, ok := x.Source.(*License_Text); ok {
			return x.Text
		}
	}
	return ""
}

func (x *License) GetUrl() string {
	if x != nil {
		if x, ok := x.Source.(*License_Url); ok {
			return x.Url
		}
	}
	return ""
}

func (x *License) SetSpdxLicenseId(v string) {
	x.SpdxLicenseId = v
}

func (x *License) SetText(v string) {
	x.Source = &License_Text{v}
}

func (x *License) SetUrl(v string) {
	x.Source = &License_Url{v}
}

func (x *License) HasSource() bool {
	if x == nil {
		return false
	}
	return x.Source != nil
}

func (x *License) HasText() bool {
	if x == nil {
		return false
	}
	_, ok := x.Source.(*License_Text)
	return ok
}

func (x *License) HasUrl() bool {
	if x == nil {
		return false
	}
	_, ok := x.Source.(*License_Url)
	return ok
}

func (x *License) ClearSource() {
	x.Source = nil
}

func (x *License) ClearText() {
	if _, ok := x.Source.(*License_Text); ok {
		x.Source = nil
	}
}

func (x *License) ClearUrl() {
	if _, ok := x.Source.(*License_Url); ok {
		x.Source = nil
	}
}

const License_Source_not_set_case case_License_Source = 0
const License_Text_case case_License_Source = 2
const License_Url_case case_License_Source = 3

func (x *License) WhichSource() case_License_Source {
	if x == nil {
		return License_Source_not_set_case
	}
	switch x.Source.(type) {
	case *License_Text:
		return License_Text_case
	case *License_Url:
		return License_Url_case
	default:
		return License_Source_not_set_case
	}
}

type License_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The SPDX license ID.
	//
	// See https://spdx.org/licenses.
	SpdxLicenseId string
	// The source of a license is either raw text, or a URL that contains the license.

	// Fields of oneof Source:
	// The raw text of the license.
	Text *string
	// The url that contains the license.
	Url *string
	// -- end of Source
}

func (b0 License_builder) Build() *License {
	m0 := &License{}
	b, x := &b0, m0
	_, _ = b, x
	x.SpdxLicenseId = b.SpdxLicenseId
	if b.Text != nil {
		x.Source = &License_Text{*b.Text}
	}
	if b.Url != nil {
		x.Source = &License_Url{*b.Url}
	}
	return m0
}

type case_License_Source protoreflect.FieldNumber

func (x case_License_Source) String() string {
	md := file_buf_plugin_info_v1_license_proto_msgTypes[0].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isLicense_Source interface {
	isLicense_Source()
}

type License_Text struct {
	// The raw text of the license.
	Text string `protobuf:"bytes,2,opt,name=text,proto3,oneof"`
}

type License_Url struct {
	// The url that contains the license.
	Url string `protobuf:"bytes,3,opt,name=url,proto3,oneof"`
}

func (*License_Text) isLicense_Source() {}

func (*License_Url) isLicense_Source() {}

var File_buf_plugin_info_v1_license_proto protoreflect.FileDescriptor

const file_buf_plugin_info_v1_license_proto_rawDesc = "" +
	"\n" +
	" buf/plugin/info/v1/license.proto\x12\x12buf.plugin.info.v1\x1a\x1bbuf/validate/validate.proto\"\x98\x01\n" +
	"\aLicense\x12E\n" +
	"\x0fspdx_license_id\x18\x01 \x01(\tB\x1d\xbaH\x1a\xd8\x01\x01r\x15\x10\x012\x11^[a-zA-Z0-9-.+]+$R\rspdxLicenseId\x12\x14\n" +
	"\x04text\x18\x02 \x01(\tH\x00R\x04text\x12\x1f\n" +
	"\x03url\x18\x03 \x01(\tB\v\xbaH\b\xd8\x01\x01r\x03\x88\x01\x01H\x00R\x03urlB\x0f\n" +
	"\x06source\x12\x05\xbaH\x02\b\x01BRZPbuf.build/gen/go/bufbuild/bufplugin/protocolbuffers/go/buf/plugin/info/v1;infov1b\x06proto3"

var file_buf_plugin_info_v1_license_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_buf_plugin_info_v1_license_proto_goTypes = []any{
	(*License)(nil), // 0: buf.plugin.info.v1.License
}
var file_buf_plugin_info_v1_license_proto_depIdxs = []int32{
	0, // [0:0] is the sub-list for method output_type
	0, // [0:0] is the sub-list for method input_type
	0, // [0:0] is the sub-list for extension type_name
	0, // [0:0] is the sub-list for extension extendee
	0, // [0:0] is the sub-list for field type_name
}

func init() { file_buf_plugin_info_v1_license_proto_init() }
func file_buf_plugin_info_v1_license_proto_init() {
	if File_buf_plugin_info_v1_license_proto != nil {
		return
	}
	file_buf_plugin_info_v1_license_proto_msgTypes[0].OneofWrappers = []any{
		(*License_Text)(nil),
		(*License_Url)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_plugin_info_v1_license_proto_rawDesc), len(file_buf_plugin_info_v1_license_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_plugin_info_v1_license_proto_goTypes,
		DependencyIndexes: file_buf_plugin_info_v1_license_proto_depIdxs,
		MessageInfos:      file_buf_plugin_info_v1_license_proto_msgTypes,
	}.Build()
	File_buf_plugin_info_v1_license_proto = out.File
	file_buf_plugin_info_v1_license_proto_goTypes = nil
	file_buf_plugin_info_v1_license_proto_depIdxs = nil
}
