// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package policy

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	stderrors "errors"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/cilium/cilium/api/v1/models"
)

// GetFqdnCacheReader is a Reader for the GetFqdnCache structure.
type GetFqdnCacheReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetFqdnCacheReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (any, error) {
	switch response.Code() {
	case 200:
		result := NewGetFqdnCacheOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetFqdnCacheBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetFqdnCacheNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /fqdn/cache] GetFqdnCache", response, response.Code())
	}
}

// NewGetFqdnCacheOK creates a GetFqdnCacheOK with default headers values
func NewGetFqdnCacheOK() *GetFqdnCacheOK {
	return &GetFqdnCacheOK{}
}

/*
GetFqdnCacheOK describes a response with status code 200, with default header values.

Success
*/
type GetFqdnCacheOK struct {
	Payload []*models.DNSLookup
}

// IsSuccess returns true when this get fqdn cache o k response has a 2xx status code
func (o *GetFqdnCacheOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get fqdn cache o k response has a 3xx status code
func (o *GetFqdnCacheOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get fqdn cache o k response has a 4xx status code
func (o *GetFqdnCacheOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get fqdn cache o k response has a 5xx status code
func (o *GetFqdnCacheOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get fqdn cache o k response a status code equal to that given
func (o *GetFqdnCacheOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get fqdn cache o k response
func (o *GetFqdnCacheOK) Code() int {
	return 200
}

func (o *GetFqdnCacheOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /fqdn/cache][%d] getFqdnCacheOK %s", 200, payload)
}

func (o *GetFqdnCacheOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /fqdn/cache][%d] getFqdnCacheOK %s", 200, payload)
}

func (o *GetFqdnCacheOK) GetPayload() []*models.DNSLookup {
	return o.Payload
}

func (o *GetFqdnCacheOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && !stderrors.Is(err, io.EOF) {
		return err
	}

	return nil
}

// NewGetFqdnCacheBadRequest creates a GetFqdnCacheBadRequest with default headers values
func NewGetFqdnCacheBadRequest() *GetFqdnCacheBadRequest {
	return &GetFqdnCacheBadRequest{}
}

/*
GetFqdnCacheBadRequest describes a response with status code 400, with default header values.

Invalid request (error parsing parameters)
*/
type GetFqdnCacheBadRequest struct {
	Payload models.Error
}

// IsSuccess returns true when this get fqdn cache bad request response has a 2xx status code
func (o *GetFqdnCacheBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get fqdn cache bad request response has a 3xx status code
func (o *GetFqdnCacheBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get fqdn cache bad request response has a 4xx status code
func (o *GetFqdnCacheBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get fqdn cache bad request response has a 5xx status code
func (o *GetFqdnCacheBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get fqdn cache bad request response a status code equal to that given
func (o *GetFqdnCacheBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get fqdn cache bad request response
func (o *GetFqdnCacheBadRequest) Code() int {
	return 400
}

func (o *GetFqdnCacheBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /fqdn/cache][%d] getFqdnCacheBadRequest %s", 400, payload)
}

func (o *GetFqdnCacheBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /fqdn/cache][%d] getFqdnCacheBadRequest %s", 400, payload)
}

func (o *GetFqdnCacheBadRequest) GetPayload() models.Error {
	return o.Payload
}

func (o *GetFqdnCacheBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && !stderrors.Is(err, io.EOF) {
		return err
	}

	return nil
}

// NewGetFqdnCacheNotFound creates a GetFqdnCacheNotFound with default headers values
func NewGetFqdnCacheNotFound() *GetFqdnCacheNotFound {
	return &GetFqdnCacheNotFound{}
}

/*
GetFqdnCacheNotFound describes a response with status code 404, with default header values.

No DNS data with provided parameters found
*/
type GetFqdnCacheNotFound struct {
}

// IsSuccess returns true when this get fqdn cache not found response has a 2xx status code
func (o *GetFqdnCacheNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get fqdn cache not found response has a 3xx status code
func (o *GetFqdnCacheNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get fqdn cache not found response has a 4xx status code
func (o *GetFqdnCacheNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get fqdn cache not found response has a 5xx status code
func (o *GetFqdnCacheNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get fqdn cache not found response a status code equal to that given
func (o *GetFqdnCacheNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get fqdn cache not found response
func (o *GetFqdnCacheNotFound) Code() int {
	return 404
}

func (o *GetFqdnCacheNotFound) Error() string {
	return fmt.Sprintf("[GET /fqdn/cache][%d] getFqdnCacheNotFound", 404)
}

func (o *GetFqdnCacheNotFound) String() string {
	return fmt.Sprintf("[GET /fqdn/cache][%d] getFqdnCacheNotFound", 404)
}

func (o *GetFqdnCacheNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}
