
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "downloadmanager_downloadinfo_wrapper.h"

// Argument includes
#include <webpage.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_DownloadManager_DownloadInfo_Type = nullptr;
static PyTypeObject *Sbk_DownloadManager_DownloadInfo_TypeF(void)
{
    return _Sbk_DownloadManager_DownloadInfo_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_DownloadManager_DownloadInfo_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::DownloadManager::DownloadInfo >()))
        return -1;

    ::DownloadManager::DownloadInfo *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadInfo_IDX]);

    if (PyArg_ParseTuple(args, "|O:DownloadInfo", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: DownloadInfo::DownloadInfo(WebPage*=)
    // 1: DownloadInfo::DownloadInfo(DownloadManager::DownloadInfo)
    if (numArgs == 0) {
        overloadId = 0; // DownloadInfo(WebPage*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), (pyArgs[0])))) {
        overloadId = 0; // DownloadInfo(WebPage*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadInfo_IDX]), (pyArgs[0])))) {
        overloadId = 1; // DownloadInfo(DownloadManager::DownloadInfo)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadInfo_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadInfo_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // DownloadInfo(WebPage *p)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"p", 0}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadInfo_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::WebPage *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // DownloadInfo(WebPage*)
                cptr = new ::DownloadManager::DownloadInfo(cppArg0);
            }
            break;
        }
        case 1: // DownloadInfo(const DownloadManager::DownloadInfo &DownloadInfo)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadInfo_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::DownloadManager::DownloadInfo cppArg0_local;
            ::DownloadManager::DownloadInfo *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // DownloadInfo(DownloadManager::DownloadInfo)
                cptr = new ::DownloadManager::DownloadInfo(*cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::DownloadManager::DownloadInfo >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadInfo_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_DownloadManager_DownloadInfo__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::DownloadManager::DownloadInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadInfo_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_DownloadManager_DownloadInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_DownloadManager_DownloadInfo_methods[] = {
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_DownloadManager_DownloadInfo__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static PyObject *Sbk_DownloadManager_DownloadInfo_get_page(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::DownloadManager::DownloadInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), cppSelf->page);
}
static int Sbk_DownloadManager_DownloadInfo_set_page(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::DownloadManager::DownloadInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("page");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("page", "WebPage");
        return -1;
    }

    auto *&cppOut_ptr = cppSelf->page;
    pythonToCpp(pyIn, &cppOut_ptr);

    Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "page", pyIn);
    return 0;
}

static PyObject *Sbk_DownloadManager_DownloadInfo_get_suggestedFileName(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::DownloadManager::DownloadInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->suggestedFileName);
}
static int Sbk_DownloadManager_DownloadInfo_set_suggestedFileName(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::DownloadManager::DownloadInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("suggestedFileName");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("suggestedFileName", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->suggestedFileName;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_DownloadManager_DownloadInfo_get_askWhatToDo(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::DownloadManager::DownloadInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->askWhatToDo;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_DownloadManager_DownloadInfo_set_askWhatToDo(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::DownloadManager::DownloadInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("askWhatToDo");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("askWhatToDo", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->askWhatToDo;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->askWhatToDo = cppOut_local;

    return 0;
}

static PyObject *Sbk_DownloadManager_DownloadInfo_get_forceChoosingPath(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::DownloadManager::DownloadInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->forceChoosingPath;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_DownloadManager_DownloadInfo_set_forceChoosingPath(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::DownloadManager::DownloadInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("forceChoosingPath");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("forceChoosingPath", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->forceChoosingPath;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->forceChoosingPath = cppOut_local;

    return 0;
}

// Getters and Setters for DownloadInfo
static PyGetSetDef Sbk_DownloadManager_DownloadInfo_getsetlist[] = {
    {const_cast<char *>("page"), Sbk_DownloadManager_DownloadInfo_get_page, Sbk_DownloadManager_DownloadInfo_set_page, nullptr, nullptr},
    {const_cast<char *>("suggestedFileName"), Sbk_DownloadManager_DownloadInfo_get_suggestedFileName, Sbk_DownloadManager_DownloadInfo_set_suggestedFileName, nullptr, nullptr},
    {const_cast<char *>("askWhatToDo"), Sbk_DownloadManager_DownloadInfo_get_askWhatToDo, Sbk_DownloadManager_DownloadInfo_set_askWhatToDo, nullptr, nullptr},
    {const_cast<char *>("forceChoosingPath"), Sbk_DownloadManager_DownloadInfo_get_forceChoosingPath, Sbk_DownloadManager_DownloadInfo_set_forceChoosingPath, nullptr, nullptr},
    {nullptr, nullptr, nullptr, nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_DownloadManager_DownloadInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_DownloadManager_DownloadInfo_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_DownloadManager_DownloadInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_DownloadManager_DownloadInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_DownloadManager_DownloadInfo_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_DownloadManager_DownloadInfo_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_DownloadManager_DownloadInfo_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_DownloadManager_DownloadInfo_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_DownloadManager_DownloadInfo_spec = {
    "1:PyFalkon.DownloadManager.DownloadInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_DownloadManager_DownloadInfo_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void DownloadInfo_PythonToCpp_DownloadInfo_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_DownloadManager_DownloadInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_DownloadInfo_PythonToCpp_DownloadInfo_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_DownloadManager_DownloadInfo_TypeF()))
        return DownloadInfo_PythonToCpp_DownloadInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *DownloadInfo_PTR_CppToPython_DownloadInfo(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_DownloadManager_DownloadInfo_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_DownloadManager_DownloadInfo_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *DownloadInfo_COPY_CppToPython_DownloadInfo(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::DownloadManager::DownloadInfo *>(cppIn);
    return Shiboken::Object::newObject(Sbk_DownloadManager_DownloadInfo_TypeF(), new ::DownloadManager::DownloadInfo(*source), true, true);
}

// Python to C++ copy conversion.
static void DownloadInfo_PythonToCpp_DownloadInfo_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::DownloadManager::DownloadInfo *>(cppOut) = *reinterpret_cast< ::DownloadManager::DownloadInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadInfo_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_DownloadInfo_PythonToCpp_DownloadInfo_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_DownloadManager_DownloadInfo_TypeF()))
        return DownloadInfo_PythonToCpp_DownloadInfo_COPY;
    return {};
}

// Implicit conversions.
static void WebPagePTR_PythonToCpp_DownloadManager_DownloadInfo(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::DownloadManager::DownloadInfo *>(cppOut) = ::DownloadManager::DownloadInfo(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_WebPagePTR_PythonToCpp_DownloadManager_DownloadInfo_Convertible(PyObject *pyIn)
{
    if (SbkObject_TypeCheck(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), pyIn))
        return WebPagePTR_PythonToCpp_DownloadManager_DownloadInfo;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *DownloadManager_DownloadInfo_SignatureStrings[] = {
    "1:PyFalkon.DownloadManager.DownloadInfo(self,p:PyFalkon.WebPage=nullptr)",
    "0:PyFalkon.DownloadManager.DownloadInfo(self,DownloadInfo:PyFalkon.DownloadManager.DownloadInfo)",
    "PyFalkon.DownloadManager.DownloadInfo.__copy__(self)->typing._Self",
    nullptr}; // Sentinel
#else
static constexpr size_t DownloadManager_DownloadInfo_SignatureByteSize = 103;
static constexpr uint8_t DownloadManager_DownloadInfo_SignatureBytes[103] = {
    0x78, 0xda, 0x33, 0xb4, 0x0a, 0xa8, 0x74, 0x4b, 0xcc, 0xc9, 0xce, 0xcf, 0xd3, 0x73, 0xc9, 0x2f,
    0xcf, 0xcb, 0xc9, 0x4f, 0x4c, 0xf1, 0x4d, 0xcc, 0x4b, 0x4c, 0x4f, 0x2d, 0x82, 0xf3, 0x3d, 0xf3,
    0xd2, 0xf2, 0x35, 0x8a, 0x53, 0x73, 0xd2, 0x74, 0x0a, 0x10, 0x8a, 0xc3, 0x53, 0x93, 0x02, 0x80,
    0xaa, 0x6c, 0xf3, 0x4a, 0x73, 0x72, 0x0a, 0x4a, 0x8a, 0x34, 0xb9, 0x0c, 0x48, 0x31, 0x08, 0x59,
    0x84, 0x38, 0x7d, 0x9a, 0x5c, 0x44, 0x29, 0xd3, 0x8b, 0x8f, 0x4f, 0xce, 0x2f, 0xa8, 0x8c, 0x8f,
    0x07, 0xdb, 0xa3, 0xa9, 0x6b, 0x57, 0x52, 0x59, 0x90, 0x99, 0x97, 0xae, 0x17, 0x1f, 0x0c, 0xe4,
    0x72, 0x01, 0x00, 0xb5, 0xb2, 0x57, 0x7e
};
#endif

PyTypeObject *init_DownloadManager_DownloadInfo(PyObject *enclosingClass)
{
    if (SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadInfo_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadInfo_IDX].type;

    Shiboken::AutoDecRef Sbk_DownloadManager_DownloadInfo_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_DownloadManager_DownloadInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "DownloadInfo",
        "DownloadManager::DownloadInfo",
        &Sbk_DownloadManager_DownloadInfo_spec,
        &Shiboken::callCppDestructor< ::DownloadManager::DownloadInfo >,
        Sbk_DownloadManager_DownloadInfo_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::InnerClass | Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = _Sbk_DownloadManager_DownloadInfo_Type; // references _Sbk_DownloadManager_DownloadInfo_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, DownloadManager_DownloadInfo_SignatureStrings);
#else
    InitSignatureBytes(pyType, DownloadManager_DownloadInfo_SignatureBytes, DownloadManager_DownloadInfo_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_DownloadManager_DownloadInfo_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadInfo_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        DownloadInfo_PythonToCpp_DownloadInfo_PTR,
        is_DownloadInfo_PythonToCpp_DownloadInfo_PTR_Convertible,
        DownloadInfo_PTR_CppToPython_DownloadInfo,
        DownloadInfo_COPY_CppToPython_DownloadInfo);

    Shiboken::Conversions::registerConverterName(converter, "DownloadManager::DownloadInfo");
    Shiboken::Conversions::registerConverterName(converter, "DownloadManager::DownloadInfo*");
    Shiboken::Conversions::registerConverterName(converter, "DownloadManager::DownloadInfo&");
    Shiboken::Conversions::registerConverterAlias(converter, "DownloadInfo");
    Shiboken::Conversions::registerConverterAlias(converter, "DownloadInfo*");
    Shiboken::Conversions::registerConverterAlias(converter, "DownloadInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::DownloadManager::DownloadInfo).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        DownloadInfo_PythonToCpp_DownloadInfo_COPY,
        is_DownloadInfo_PythonToCpp_DownloadInfo_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        WebPagePTR_PythonToCpp_DownloadManager_DownloadInfo,
        is_WebPagePTR_PythonToCpp_DownloadManager_DownloadInfo_Convertible);

    qRegisterMetaType< ::DownloadManager::DownloadInfo >("DownloadInfo");
    qRegisterMetaType< ::DownloadManager::DownloadInfo >("DownloadManager::DownloadInfo");

    return pyType;
}
