/* imap-fetch-command.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-fetch-command.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_FETCH_COMMAND_0_PROPERTY,
	GEARY_IMAP_FETCH_COMMAND_FOR_DATA_TYPES_PROPERTY,
	GEARY_IMAP_FETCH_COMMAND_FOR_BODY_DATA_SPECIFIERS_PROPERTY,
	GEARY_IMAP_FETCH_COMMAND_NUM_PROPERTIES
};
static GParamSpec* geary_imap_fetch_command_properties[GEARY_IMAP_FETCH_COMMAND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GearyImapFetchCommandPrivate {
	GeeList* _for_data_types;
	GeeList* _for_body_data_specifiers;
};

static gint GearyImapFetchCommand_private_offset;
static gpointer geary_imap_fetch_command_parent_class = NULL;

static void geary_imap_fetch_command_set_for_data_types (GearyImapFetchCommand* self,
                                                  GeeList* value);
static void geary_imap_fetch_command_set_for_body_data_specifiers (GearyImapFetchCommand* self,
                                                            GeeList* value);
static void geary_imap_fetch_command_finalize (GObject * obj);
static GType geary_imap_fetch_command_get_type_once (void);
static void _vala_geary_imap_fetch_command_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_geary_imap_fetch_command_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);

static inline gpointer
geary_imap_fetch_command_get_instance_private (GearyImapFetchCommand* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapFetchCommand_private_offset);
}

GeeList*
geary_imap_fetch_command_get_for_data_types (GearyImapFetchCommand* self)
{
	GeeList* result;
	GeeList* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_FETCH_COMMAND (self), NULL);
	_tmp0_ = self->priv->_for_data_types;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_imap_fetch_command_set_for_data_types (GearyImapFetchCommand* self,
                                             GeeList* value)
{
	GeeList* old_value;
	g_return_if_fail (GEARY_IMAP_IS_FETCH_COMMAND (self));
	old_value = geary_imap_fetch_command_get_for_data_types (self);
	if (old_value != value) {
		GeeList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_for_data_types);
		self->priv->_for_data_types = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_fetch_command_properties[GEARY_IMAP_FETCH_COMMAND_FOR_DATA_TYPES_PROPERTY]);
	}
}

GeeList*
geary_imap_fetch_command_get_for_body_data_specifiers (GearyImapFetchCommand* self)
{
	GeeList* result;
	GeeList* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_FETCH_COMMAND (self), NULL);
	_tmp0_ = self->priv->_for_body_data_specifiers;
	result = _tmp0_;
	return result;
}

static void
geary_imap_fetch_command_set_for_body_data_specifiers (GearyImapFetchCommand* self,
                                                       GeeList* value)
{
	GeeList* old_value;
	g_return_if_fail (GEARY_IMAP_IS_FETCH_COMMAND (self));
	old_value = geary_imap_fetch_command_get_for_body_data_specifiers (self);
	if (old_value != value) {
		GeeList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_for_body_data_specifiers);
		self->priv->_for_body_data_specifiers = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_fetch_command_properties[GEARY_IMAP_FETCH_COMMAND_FOR_BODY_DATA_SPECIFIERS_PROPERTY]);
	}
}

GearyImapFetchCommand*
geary_imap_fetch_command_construct (GType object_type,
                                    GearyImapMessageSet* msg_set,
                                    GeeList* data_items,
                                    GeeList* body_data_items,
                                    GCancellable* should_send)
{
	GearyImapFetchCommand * self = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GearyImapListParameter* _tmp3_;
	GearyImapListParameter* _tmp4_;
	GearyImapParameter* _tmp5_;
	GearyImapParameter* _tmp6_;
	gint _tmp7_ = 0;
	gint data_items_length = 0;
	gint _tmp10_ = 0;
	gint body_items_length = 0;
	gboolean _tmp13_ = FALSE;
	g_return_val_if_fail (GEARY_IMAP_IS_MESSAGE_SET (msg_set), NULL);
	g_return_val_if_fail ((data_items == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (data_items, GEE_TYPE_LIST), NULL);
	g_return_val_if_fail ((body_data_items == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (body_data_items, GEE_TYPE_LIST), NULL);
	g_return_val_if_fail ((should_send == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (should_send, g_cancellable_get_type ()), NULL);
	_tmp1_ = geary_imap_message_set_get_is_uid (msg_set);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = GEARY_IMAP_FETCH_COMMAND_UID_NAME;
	} else {
		_tmp0_ = GEARY_IMAP_FETCH_COMMAND_NAME;
	}
	self = (GearyImapFetchCommand*) geary_imap_command_construct (object_type, _tmp0_, NULL, (gint) 0, should_send);
	_tmp3_ = geary_imap_command_get_args (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
	_tmp4_ = _tmp3_;
	_tmp5_ = geary_imap_message_set_to_parameter (msg_set);
	_tmp6_ = _tmp5_;
	geary_imap_list_parameter_add (_tmp4_, _tmp6_);
	_g_object_unref0 (_tmp6_);
	if (data_items != NULL) {
		gint _tmp8_;
		gint _tmp9_;
		_tmp8_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (data_items, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp9_ = _tmp8_;
		_tmp7_ = _tmp9_;
	} else {
		_tmp7_ = 0;
	}
	data_items_length = _tmp7_;
	if (body_data_items != NULL) {
		gint _tmp11_;
		gint _tmp12_;
		_tmp11_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (body_data_items, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp12_ = _tmp11_;
		_tmp10_ = _tmp12_;
	} else {
		_tmp10_ = 0;
	}
	body_items_length = _tmp10_;
	if (data_items_length == 1) {
		_tmp13_ = body_items_length == 0;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		GearyImapListParameter* _tmp14_;
		GearyImapListParameter* _tmp15_;
		gpointer _tmp16_;
		GearyImapStringParameter* _tmp17_;
		GearyImapStringParameter* _tmp18_;
		_tmp14_ = geary_imap_command_get_args (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
		_tmp15_ = _tmp14_;
		_tmp16_ = gee_list_get (data_items, 0);
		_tmp17_ = geary_imap_fetch_data_specifier_to_parameter ((GearyImapFetchDataSpecifier) ((gintptr) _tmp16_));
		_tmp18_ = _tmp17_;
		geary_imap_list_parameter_add (_tmp15_, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_g_object_unref0 (_tmp18_);
	} else {
		gboolean _tmp19_ = FALSE;
		if (data_items_length == 0) {
			_tmp19_ = body_items_length == 1;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			GearyImapListParameter* _tmp20_;
			GearyImapListParameter* _tmp21_;
			gpointer _tmp22_;
			GearyImapFetchBodyDataSpecifier* _tmp23_;
			GearyImapParameter* _tmp24_;
			GearyImapParameter* _tmp25_;
			_tmp20_ = geary_imap_command_get_args (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
			_tmp21_ = _tmp20_;
			_tmp22_ = gee_list_get (body_data_items, 0);
			_tmp23_ = (GearyImapFetchBodyDataSpecifier*) _tmp22_;
			_tmp24_ = geary_imap_fetch_body_data_specifier_to_request_parameter (_tmp23_);
			_tmp25_ = _tmp24_;
			geary_imap_list_parameter_add (_tmp21_, _tmp25_);
			_g_object_unref0 (_tmp25_);
			_g_object_unref0 (_tmp23_);
		} else {
			GearyImapListParameter* list = NULL;
			GearyImapListParameter* _tmp26_;
			GearyImapListParameter* _tmp48_;
			GearyImapListParameter* _tmp49_;
			GearyImapListParameter* _tmp50_;
			_tmp26_ = geary_imap_list_parameter_new ();
			list = _tmp26_;
			if (data_items_length > 0) {
				{
					GeeList* _data_item_list = NULL;
					gint _data_item_size = 0;
					GeeList* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					gint _data_item_index = 0;
					_data_item_list = data_items;
					_tmp27_ = _data_item_list;
					_tmp28_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_COLLECTION, GeeCollection));
					_tmp29_ = _tmp28_;
					_data_item_size = _tmp29_;
					_data_item_index = -1;
					while (TRUE) {
						gint _tmp30_;
						gint _tmp31_;
						GearyImapFetchDataSpecifier data_item = 0;
						GeeList* _tmp32_;
						gpointer _tmp33_;
						GearyImapListParameter* _tmp34_;
						GearyImapStringParameter* _tmp35_;
						GearyImapStringParameter* _tmp36_;
						_data_item_index = _data_item_index + 1;
						_tmp30_ = _data_item_index;
						_tmp31_ = _data_item_size;
						if (!(_tmp30_ < _tmp31_)) {
							break;
						}
						_tmp32_ = _data_item_list;
						_tmp33_ = gee_list_get (_tmp32_, _data_item_index);
						data_item = (GearyImapFetchDataSpecifier) ((gintptr) _tmp33_);
						_tmp34_ = list;
						_tmp35_ = geary_imap_fetch_data_specifier_to_parameter (data_item);
						_tmp36_ = _tmp35_;
						geary_imap_list_parameter_add (_tmp34_, G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
						_g_object_unref0 (_tmp36_);
					}
				}
			}
			if (body_items_length > 0) {
				{
					GeeList* _body_item_list = NULL;
					gint _body_item_size = 0;
					GeeList* _tmp37_;
					gint _tmp38_;
					gint _tmp39_;
					gint _body_item_index = 0;
					_body_item_list = body_data_items;
					_tmp37_ = _body_item_list;
					_tmp38_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GEE_TYPE_COLLECTION, GeeCollection));
					_tmp39_ = _tmp38_;
					_body_item_size = _tmp39_;
					_body_item_index = -1;
					while (TRUE) {
						gint _tmp40_;
						gint _tmp41_;
						GearyImapFetchBodyDataSpecifier* body_item = NULL;
						GeeList* _tmp42_;
						gpointer _tmp43_;
						GearyImapListParameter* _tmp44_;
						GearyImapFetchBodyDataSpecifier* _tmp45_;
						GearyImapParameter* _tmp46_;
						GearyImapParameter* _tmp47_;
						_body_item_index = _body_item_index + 1;
						_tmp40_ = _body_item_index;
						_tmp41_ = _body_item_size;
						if (!(_tmp40_ < _tmp41_)) {
							break;
						}
						_tmp42_ = _body_item_list;
						_tmp43_ = gee_list_get (_tmp42_, _body_item_index);
						body_item = (GearyImapFetchBodyDataSpecifier*) _tmp43_;
						_tmp44_ = list;
						_tmp45_ = body_item;
						_tmp46_ = geary_imap_fetch_body_data_specifier_to_request_parameter (_tmp45_);
						_tmp47_ = _tmp46_;
						geary_imap_list_parameter_add (_tmp44_, _tmp47_);
						_g_object_unref0 (_tmp47_);
						_g_object_unref0 (body_item);
					}
				}
			}
			_tmp48_ = geary_imap_command_get_args (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
			_tmp49_ = _tmp48_;
			_tmp50_ = list;
			geary_imap_list_parameter_add (_tmp49_, G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
			_g_object_unref0 (list);
		}
	}
	if (data_items != NULL) {
		GeeList* _tmp51_;
		_tmp51_ = self->priv->_for_data_types;
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (data_items, GEE_TYPE_COLLECTION, GeeCollection));
	}
	if (body_data_items != NULL) {
		GeeList* _tmp52_;
		_tmp52_ = self->priv->_for_body_data_specifiers;
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (body_data_items, GEE_TYPE_COLLECTION, GeeCollection));
	}
	return self;
}

GearyImapFetchCommand*
geary_imap_fetch_command_new (GearyImapMessageSet* msg_set,
                              GeeList* data_items,
                              GeeList* body_data_items,
                              GCancellable* should_send)
{
	return geary_imap_fetch_command_construct (GEARY_IMAP_TYPE_FETCH_COMMAND, msg_set, data_items, body_data_items, should_send);
}

GearyImapFetchCommand*
geary_imap_fetch_command_construct_data_type (GType object_type,
                                              GearyImapMessageSet* msg_set,
                                              GearyImapFetchDataSpecifier data_type,
                                              GCancellable* should_send)
{
	GearyImapFetchCommand * self = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeList* _tmp3_;
	GearyImapListParameter* _tmp4_;
	GearyImapListParameter* _tmp5_;
	GearyImapParameter* _tmp6_;
	GearyImapParameter* _tmp7_;
	GearyImapListParameter* _tmp8_;
	GearyImapListParameter* _tmp9_;
	GearyImapStringParameter* _tmp10_;
	GearyImapStringParameter* _tmp11_;
	g_return_val_if_fail (GEARY_IMAP_IS_MESSAGE_SET (msg_set), NULL);
	g_return_val_if_fail ((should_send == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (should_send, g_cancellable_get_type ()), NULL);
	_tmp1_ = geary_imap_message_set_get_is_uid (msg_set);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = GEARY_IMAP_FETCH_COMMAND_UID_NAME;
	} else {
		_tmp0_ = GEARY_IMAP_FETCH_COMMAND_NAME;
	}
	self = (GearyImapFetchCommand*) geary_imap_command_construct (object_type, _tmp0_, NULL, (gint) 0, should_send);
	_tmp3_ = self->priv->_for_data_types;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), (gpointer) ((gintptr) data_type));
	_tmp4_ = geary_imap_command_get_args (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
	_tmp5_ = _tmp4_;
	_tmp6_ = geary_imap_message_set_to_parameter (msg_set);
	_tmp7_ = _tmp6_;
	geary_imap_list_parameter_add (_tmp5_, _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = geary_imap_command_get_args (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
	_tmp9_ = _tmp8_;
	_tmp10_ = geary_imap_fetch_data_specifier_to_parameter (data_type);
	_tmp11_ = _tmp10_;
	geary_imap_list_parameter_add (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
	_g_object_unref0 (_tmp11_);
	return self;
}

GearyImapFetchCommand*
geary_imap_fetch_command_new_data_type (GearyImapMessageSet* msg_set,
                                        GearyImapFetchDataSpecifier data_type,
                                        GCancellable* should_send)
{
	return geary_imap_fetch_command_construct_data_type (GEARY_IMAP_TYPE_FETCH_COMMAND, msg_set, data_type, should_send);
}

GearyImapFetchCommand*
geary_imap_fetch_command_construct_body_data_type (GType object_type,
                                                   GearyImapMessageSet* msg_set,
                                                   GearyImapFetchBodyDataSpecifier* body_data_specifier,
                                                   GCancellable* should_send)
{
	GearyImapFetchCommand * self = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeList* _tmp3_;
	GearyImapListParameter* _tmp4_;
	GearyImapListParameter* _tmp5_;
	GearyImapParameter* _tmp6_;
	GearyImapParameter* _tmp7_;
	GearyImapListParameter* _tmp8_;
	GearyImapListParameter* _tmp9_;
	GearyImapParameter* _tmp10_;
	GearyImapParameter* _tmp11_;
	g_return_val_if_fail (GEARY_IMAP_IS_MESSAGE_SET (msg_set), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_FETCH_BODY_DATA_SPECIFIER (body_data_specifier), NULL);
	g_return_val_if_fail ((should_send == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (should_send, g_cancellable_get_type ()), NULL);
	_tmp1_ = geary_imap_message_set_get_is_uid (msg_set);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = GEARY_IMAP_FETCH_COMMAND_UID_NAME;
	} else {
		_tmp0_ = GEARY_IMAP_FETCH_COMMAND_NAME;
	}
	self = (GearyImapFetchCommand*) geary_imap_command_construct (object_type, _tmp0_, NULL, (gint) 0, should_send);
	_tmp3_ = self->priv->_for_body_data_specifiers;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), body_data_specifier);
	_tmp4_ = geary_imap_command_get_args (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
	_tmp5_ = _tmp4_;
	_tmp6_ = geary_imap_message_set_to_parameter (msg_set);
	_tmp7_ = _tmp6_;
	geary_imap_list_parameter_add (_tmp5_, _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = geary_imap_command_get_args (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
	_tmp9_ = _tmp8_;
	_tmp10_ = geary_imap_fetch_body_data_specifier_to_request_parameter (body_data_specifier);
	_tmp11_ = _tmp10_;
	geary_imap_list_parameter_add (_tmp9_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	return self;
}

GearyImapFetchCommand*
geary_imap_fetch_command_new_body_data_type (GearyImapMessageSet* msg_set,
                                             GearyImapFetchBodyDataSpecifier* body_data_specifier,
                                             GCancellable* should_send)
{
	return geary_imap_fetch_command_construct_body_data_type (GEARY_IMAP_TYPE_FETCH_COMMAND, msg_set, body_data_specifier, should_send);
}

static void
geary_imap_fetch_command_class_init (GearyImapFetchCommandClass * klass,
                                     gpointer klass_data)
{
	geary_imap_fetch_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapFetchCommand_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_fetch_command_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_fetch_command_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_fetch_command_finalize;
	/**
	     * Non-null if {@link FetchCommand} created for this {@link FetchDataSpecifier}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_FETCH_COMMAND_FOR_DATA_TYPES_PROPERTY, geary_imap_fetch_command_properties[GEARY_IMAP_FETCH_COMMAND_FOR_DATA_TYPES_PROPERTY] = g_param_spec_object ("for-data-types", "for-data-types", "for-data-types", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Non-null if {@link FetchCommand} created for this {@link FetchBodyDataSpecifier}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_FETCH_COMMAND_FOR_BODY_DATA_SPECIFIERS_PROPERTY, geary_imap_fetch_command_properties[GEARY_IMAP_FETCH_COMMAND_FOR_BODY_DATA_SPECIFIERS_PROPERTY] = g_param_spec_object ("for-body-data-specifiers", "for-body-data-specifiers", "for-body-data-specifiers", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_fetch_command_instance_init (GearyImapFetchCommand * self,
                                        gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	self->priv = geary_imap_fetch_command_get_instance_private (self);
	_tmp0_ = gee_array_list_new (GEARY_IMAP_TYPE_FETCH_DATA_SPECIFIER, NULL, NULL, NULL, NULL, NULL);
	self->priv->_for_data_types = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
	_tmp1_ = gee_array_list_new (GEARY_IMAP_TYPE_FETCH_BODY_DATA_SPECIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->_for_body_data_specifiers = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_LIST, GeeList);
}

static void
geary_imap_fetch_command_finalize (GObject * obj)
{
	GearyImapFetchCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_FETCH_COMMAND, GearyImapFetchCommand);
	_g_object_unref0 (self->priv->_for_data_types);
	_g_object_unref0 (self->priv->_for_body_data_specifiers);
	G_OBJECT_CLASS (geary_imap_fetch_command_parent_class)->finalize (obj);
}

/**
 * A representation of the IMAP FETCH command.
 *
 * FETCH is easily the most complicated IMAP command.  It has a large number of parameters, some of
 * which have a number of variants, others defined as macros combining other fields, and the
 * returned {@link ServerData} requires involved decoding patterns.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-6.4.5]]
 *
 * @see FetchedData
 * @see StoreCommand
 */
 G_GNUC_NO_INLINE static GType
geary_imap_fetch_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapFetchCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_fetch_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapFetchCommand), 0, (GInstanceInitFunc) geary_imap_fetch_command_instance_init, NULL };
	GType geary_imap_fetch_command_type_id;
	geary_imap_fetch_command_type_id = g_type_register_static (GEARY_IMAP_TYPE_COMMAND, "GearyImapFetchCommand", &g_define_type_info, 0);
	GearyImapFetchCommand_private_offset = g_type_add_instance_private (geary_imap_fetch_command_type_id, sizeof (GearyImapFetchCommandPrivate));
	return geary_imap_fetch_command_type_id;
}

GType
geary_imap_fetch_command_get_type (void)
{
	static gsize geary_imap_fetch_command_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_fetch_command_type_id__once)) {
		GType geary_imap_fetch_command_type_id;
		geary_imap_fetch_command_type_id = geary_imap_fetch_command_get_type_once ();
		g_once_init_leave (&geary_imap_fetch_command_type_id__once, geary_imap_fetch_command_type_id);
	}
	return geary_imap_fetch_command_type_id__once;
}

static void
_vala_geary_imap_fetch_command_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GearyImapFetchCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_FETCH_COMMAND, GearyImapFetchCommand);
	switch (property_id) {
		case GEARY_IMAP_FETCH_COMMAND_FOR_DATA_TYPES_PROPERTY:
		g_value_set_object (value, geary_imap_fetch_command_get_for_data_types (self));
		break;
		case GEARY_IMAP_FETCH_COMMAND_FOR_BODY_DATA_SPECIFIERS_PROPERTY:
		g_value_set_object (value, geary_imap_fetch_command_get_for_body_data_specifiers (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_fetch_command_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	GearyImapFetchCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_FETCH_COMMAND, GearyImapFetchCommand);
	switch (property_id) {
		case GEARY_IMAP_FETCH_COMMAND_FOR_DATA_TYPES_PROPERTY:
		geary_imap_fetch_command_set_for_data_types (self, g_value_get_object (value));
		break;
		case GEARY_IMAP_FETCH_COMMAND_FOR_BODY_DATA_SPECIFIERS_PROPERTY:
		geary_imap_fetch_command_set_for_body_data_specifiers (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

