/* retro-firmware.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from retro-firmware.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <retro-gtk.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GAMES_RETRO_FIRMWARE_0_PROPERTY,
	GAMES_RETRO_FIRMWARE_NUM_PROPERTIES
};
static GParamSpec* games_retro_firmware_properties[GAMES_RETRO_FIRMWARE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GamesRetroFirmwarePrivate {
	gchar* name;
	gboolean is_mandatory;
	gchar* path;
	gchar* md5;
	gchar* sha512;
};

static gint GamesRetroFirmware_private_offset;
static gpointer games_retro_firmware_parent_class = NULL;
static GamesFirmwareIface * games_retro_firmware_games_firmware_parent_iface = NULL;

static gboolean games_retro_firmware_real_get_is_mandatory (GamesFirmware* base);
static void games_retro_firmware_real_check_is_valid (GamesFirmware* base,
                                               GamesPlatform* platform,
                                               GError** error);
static void games_retro_firmware_finalize (GObject * obj);
static GType games_retro_firmware_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_retro_firmware_get_instance_private (GamesRetroFirmware* self)
{
	return G_STRUCT_MEMBER_P (self, GamesRetroFirmware_private_offset);
}

GamesRetroFirmware*
games_retro_firmware_construct (GType object_type,
                                const gchar* name,
                                RetroCoreDescriptor* core_descriptor,
                                GError** error)
{
	GamesRetroFirmware * self = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (core_descriptor != NULL, NULL);
	self = (GamesRetroFirmware*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp0_;
	_tmp1_ = retro_core_descriptor_has_firmware_md5 (core_descriptor, name, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	if (_tmp1_) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = retro_core_descriptor_get_firmware_md5 (core_descriptor, name, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_g_free0 (self->priv->md5);
		self->priv->md5 = _tmp4_;
		_g_free0 (_tmp2_);
	}
	_tmp5_ = retro_core_descriptor_has_firmware_sha512 (core_descriptor, name, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	if (_tmp5_) {
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = retro_core_descriptor_get_firmware_sha512 (core_descriptor, name, &_inner_error0_);
		_tmp6_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		}
		_tmp8_ = _tmp6_;
		_tmp6_ = NULL;
		_g_free0 (self->priv->sha512);
		self->priv->sha512 = _tmp8_;
		_g_free0 (_tmp6_);
	}
	_tmp9_ = retro_core_descriptor_get_is_firmware_mandatory (core_descriptor, name, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	self->priv->is_mandatory = _tmp9_;
	_tmp11_ = retro_core_descriptor_get_firmware_path (core_descriptor, name, &_inner_error0_);
	_tmp10_ = _tmp11_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp12_ = _tmp10_;
	_tmp10_ = NULL;
	_g_free0 (self->priv->path);
	self->priv->path = _tmp12_;
	_g_free0 (_tmp10_);
	return self;
}

GamesRetroFirmware*
games_retro_firmware_new (const gchar* name,
                          RetroCoreDescriptor* core_descriptor,
                          GError** error)
{
	return games_retro_firmware_construct (GAMES_TYPE_RETRO_FIRMWARE, name, core_descriptor, error);
}

static gboolean
games_retro_firmware_real_get_is_mandatory (GamesFirmware* base)
{
	GamesRetroFirmware * self;
	gboolean result;
	self = (GamesRetroFirmware*) base;
	result = self->priv->is_mandatory;
	return result;
}

static void
games_retro_firmware_real_check_is_valid (GamesFirmware* base,
                                          GamesPlatform* platform,
                                          GError** error)
{
	GamesRetroFirmware * self;
	GFile* firmware_dir = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* firmware = NULL;
	GFile* _tmp4_;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	GError* _inner_error0_ = NULL;
	self = (GamesRetroFirmware*) base;
	g_return_if_fail (platform != NULL);
	_tmp0_ = games_platform_get_system_dir (platform);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	firmware_dir = _tmp3_;
	_tmp4_ = firmware_dir;
	_tmp5_ = self->priv->path;
	_tmp6_ = g_file_get_child (_tmp4_, _tmp5_);
	firmware = _tmp6_;
	_tmp7_ = firmware;
	if (!g_file_query_exists (_tmp7_, NULL)) {
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GError* _tmp11_;
		GError* _tmp12_;
		_tmp8_ = firmware;
		_tmp9_ = g_file_get_path (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_error_new (GAMES_FIRMWARE_ERROR, GAMES_FIRMWARE_ERROR_FIRMWARE_NOT_FOUND, "This game requires the %s firmware file to run.", _tmp10_);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		_inner_error0_ = _tmp12_;
		if (_inner_error0_->domain == GAMES_FIRMWARE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (firmware);
			_g_object_unref0 (firmware_dir);
			return;
		} else {
			_g_object_unref0 (firmware);
			_g_object_unref0 (firmware_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp14_ = self->priv->md5;
	if (_tmp14_ == NULL) {
		const gchar* _tmp15_;
		_tmp15_ = self->priv->sha512;
		_tmp13_ = _tmp15_ == NULL;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		_g_object_unref0 (firmware);
		_g_object_unref0 (firmware_dir);
		return;
	}
	{
		GFileInputStream* stream = NULL;
		GFile* _tmp16_;
		GFileInputStream* _tmp17_;
		GFileInputStream* _tmp18_;
		gsize size = 0UL;
		GFileInputStream* _tmp19_;
		GFileInputStream* _tmp20_;
		GBytes* bytes = NULL;
		GFileInputStream* _tmp21_;
		GBytes* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp35_;
		_tmp16_ = firmware;
		_tmp17_ = g_file_read (_tmp16_, NULL, &_inner_error0_);
		stream = _tmp17_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp18_ = stream;
		G_TYPE_INSTANCE_GET_CLASS (_tmp18_, g_file_input_stream_get_type (), GFileInputStreamClass)->seek (_tmp18_, (gint64) 0, G_SEEK_END, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (stream);
			goto __catch0_g_error;
		}
		_tmp19_ = stream;
		size = (gsize) G_TYPE_INSTANCE_GET_CLASS (_tmp19_, g_file_input_stream_get_type (), GFileInputStreamClass)->tell (_tmp19_);
		_tmp20_ = stream;
		G_TYPE_INSTANCE_GET_CLASS (_tmp20_, g_file_input_stream_get_type (), GFileInputStreamClass)->seek (_tmp20_, (gint64) 0, G_SEEK_SET, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (stream);
			goto __catch0_g_error;
		}
		_tmp21_ = stream;
		_tmp22_ = g_input_stream_read_bytes ((GInputStream*) _tmp21_, size, NULL, &_inner_error0_);
		bytes = _tmp22_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (stream);
			goto __catch0_g_error;
		}
		_tmp23_ = self->priv->md5;
		if (_tmp23_ != NULL) {
			GBytes* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			const gchar* _tmp27_;
			gboolean _tmp28_;
			_tmp24_ = bytes;
			_tmp25_ = g_compute_checksum_for_bytes (G_CHECKSUM_MD5, _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = self->priv->md5;
			_tmp28_ = g_strcmp0 (_tmp26_, _tmp27_) != 0;
			_g_free0 (_tmp26_);
			if (_tmp28_) {
				GFile* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				const gchar* _tmp32_;
				GError* _tmp33_;
				GError* _tmp34_;
				_tmp29_ = firmware;
				_tmp30_ = g_file_get_path (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = self->priv->md5;
				_tmp33_ = g_error_new (GAMES_FIRMWARE_ERROR, GAMES_FIRMWARE_ERROR_FIRMWARE_NOT_FOUND, "This game requires the %s firmware file with a MD5 fingerprint of %s t" \
"o run.", _tmp31_, _tmp32_);
				_tmp34_ = _tmp33_;
				_g_free0 (_tmp31_);
				_inner_error0_ = _tmp34_;
				_g_bytes_unref0 (bytes);
				_g_object_unref0 (stream);
				goto __catch0_g_error;
			}
		}
		_tmp35_ = self->priv->sha512;
		if (_tmp35_ != NULL) {
			GBytes* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			const gchar* _tmp39_;
			gboolean _tmp40_;
			_tmp36_ = bytes;
			_tmp37_ = g_compute_checksum_for_bytes (G_CHECKSUM_SHA512, _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = self->priv->sha512;
			_tmp40_ = g_strcmp0 (_tmp38_, _tmp39_) != 0;
			_g_free0 (_tmp38_);
			if (_tmp40_) {
				GFile* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				const gchar* _tmp44_;
				GError* _tmp45_;
				GError* _tmp46_;
				_tmp41_ = firmware;
				_tmp42_ = g_file_get_path (_tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = self->priv->sha512;
				_tmp45_ = g_error_new (GAMES_FIRMWARE_ERROR, GAMES_FIRMWARE_ERROR_FIRMWARE_NOT_FOUND, "This game requires the %s firmware file with a SHA-512 fingerprint of " \
"%s to run.", _tmp43_, _tmp44_);
				_tmp46_ = _tmp45_;
				_g_free0 (_tmp43_);
				_inner_error0_ = _tmp46_;
				_g_bytes_unref0 (bytes);
				_g_object_unref0 (stream);
				goto __catch0_g_error;
			}
		}
		_g_bytes_unref0 (bytes);
		_g_object_unref0 (stream);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp47_;
		const gchar* _tmp48_;
		GError* _tmp49_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp47_ = e;
		_tmp48_ = _tmp47_->message;
		_tmp49_ = g_error_new_literal (GAMES_FIRMWARE_ERROR, GAMES_FIRMWARE_ERROR_FIRMWARE_NOT_FOUND, _tmp48_);
		_inner_error0_ = _tmp49_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_FIRMWARE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (firmware);
			_g_object_unref0 (firmware_dir);
			return;
		} else {
			_g_object_unref0 (firmware);
			_g_object_unref0 (firmware_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (firmware);
	_g_object_unref0 (firmware_dir);
}

static void
games_retro_firmware_class_init (GamesRetroFirmwareClass * klass,
                                 gpointer klass_data)
{
	games_retro_firmware_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesRetroFirmware_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_retro_firmware_finalize;
}

static void
games_retro_firmware_games_firmware_interface_init (GamesFirmwareIface * iface,
                                                    gpointer iface_data)
{
	games_retro_firmware_games_firmware_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_is_mandatory = (gboolean (*) (GamesFirmware*)) games_retro_firmware_real_get_is_mandatory;
	iface->check_is_valid = (void (*) (GamesFirmware*, GamesPlatform*, GError**)) games_retro_firmware_real_check_is_valid;
}

static void
games_retro_firmware_instance_init (GamesRetroFirmware * self,
                                    gpointer klass)
{
	self->priv = games_retro_firmware_get_instance_private (self);
}

static void
games_retro_firmware_finalize (GObject * obj)
{
	GamesRetroFirmware * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_RETRO_FIRMWARE, GamesRetroFirmware);
	_g_free0 (self->priv->name);
	_g_free0 (self->priv->path);
	_g_free0 (self->priv->md5);
	_g_free0 (self->priv->sha512);
	G_OBJECT_CLASS (games_retro_firmware_parent_class)->finalize (obj);
}

static GType
games_retro_firmware_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesRetroFirmwareClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_retro_firmware_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesRetroFirmware), 0, (GInstanceInitFunc) games_retro_firmware_instance_init, NULL };
	static const GInterfaceInfo games_firmware_info = { (GInterfaceInitFunc) games_retro_firmware_games_firmware_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType games_retro_firmware_type_id;
	games_retro_firmware_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesRetroFirmware", &g_define_type_info, 0);
	g_type_add_interface_static (games_retro_firmware_type_id, GAMES_TYPE_FIRMWARE, &games_firmware_info);
	GamesRetroFirmware_private_offset = g_type_add_instance_private (games_retro_firmware_type_id, sizeof (GamesRetroFirmwarePrivate));
	return games_retro_firmware_type_id;
}

GType
games_retro_firmware_get_type (void)
{
	static volatile gsize games_retro_firmware_type_id__once = 0;
	if (g_once_init_enter (&games_retro_firmware_type_id__once)) {
		GType games_retro_firmware_type_id;
		games_retro_firmware_type_id = games_retro_firmware_get_type_once ();
		g_once_init_leave (&games_retro_firmware_type_id__once, games_retro_firmware_type_id);
	}
	return games_retro_firmware_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

