/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, vocoder, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_vocoder_codec2_decode_ps = R"doc(CODEC2 Vocoder Decoder.

Input: A vector of unpacked bits forming a Codec2 frame.


Output: 16-bit short values of an audio signal with sampling rate 8 kHz.


See also gr::vocoder::codec2_encode_sp.

Constructor Specific Documentation:

Make Codec2 decoder block.

Args:
    mode : Encoded bit rate/mode)doc";


static const char* __doc_gr_vocoder_codec2_decode_ps_codec2_decode_ps = R"doc()doc";


static const char* __doc_gr_vocoder_codec2_decode_ps_make = R"doc(CODEC2 Vocoder Decoder.

Input: A vector of unpacked bits forming a Codec2 frame.


Output: 16-bit short values of an audio signal with sampling rate 8 kHz.


See also gr::vocoder::codec2_encode_sp.

Constructor Specific Documentation:

Make Codec2 decoder block.

Args:
    mode : Encoded bit rate/mode)doc";
