/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_float_to_uchar = R"doc(Convert stream of floats to a stream of unsigned chars.

Constructor Specific Documentation:

Build a float to uchar block.

Args:
    vlen : vector length of data streams.
    scale : a scalar multiplier to change the output signal scale.
    bias : a scalar additive value to change the output signal offset.)doc";


static const char* __doc_gr_blocks_float_to_uchar_float_to_uchar = R"doc()doc";


static const char* __doc_gr_blocks_float_to_uchar_make = R"doc(Convert stream of floats to a stream of unsigned chars.

Constructor Specific Documentation:

Build a float to uchar block.

Args:
    vlen : vector length of data streams.
    scale : a scalar multiplier to change the output signal scale.
    bias : a scalar additive value to change the output signal offset.)doc";


static const char* __doc_gr_blocks_float_to_uchar_scale = R"doc(Get the scalar multiplier value.)doc";


static const char* __doc_gr_blocks_float_to_uchar_bias = R"doc(Get the scalar bias value.)doc";


static const char* __doc_gr_blocks_float_to_uchar_set_scale = R"doc(Set the scalar multiplier value.)doc";


static const char* __doc_gr_blocks_float_to_uchar_set_bias = R"doc(Set the scalar bias value.)doc";
