// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	monitoringv1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
)

// OTLPConfigApplyConfiguration represents a declarative configuration of the OTLPConfig type for use
// with apply.
type OTLPConfigApplyConfiguration struct {
	PromoteAllResourceAttributes      *bool                                   `json:"promoteAllResourceAttributes,omitempty"`
	IgnoreResourceAttributes          []string                                `json:"ignoreResourceAttributes,omitempty"`
	PromoteResourceAttributes         []string                                `json:"promoteResourceAttributes,omitempty"`
	TranslationStrategy               *monitoringv1.TranslationStrategyOption `json:"translationStrategy,omitempty"`
	KeepIdentifyingResourceAttributes *bool                                   `json:"keepIdentifyingResourceAttributes,omitempty"`
	ConvertHistogramsToNHCB           *bool                                   `json:"convertHistogramsToNHCB,omitempty"`
	PromoteScopeMetadata              *bool                                   `json:"promoteScopeMetadata,omitempty"`
}

// OTLPConfigApplyConfiguration constructs a declarative configuration of the OTLPConfig type for use with
// apply.
func OTLPConfig() *OTLPConfigApplyConfiguration {
	return &OTLPConfigApplyConfiguration{}
}

// WithPromoteAllResourceAttributes sets the PromoteAllResourceAttributes field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PromoteAllResourceAttributes field is set to the value of the last call.
func (b *OTLPConfigApplyConfiguration) WithPromoteAllResourceAttributes(value bool) *OTLPConfigApplyConfiguration {
	b.PromoteAllResourceAttributes = &value
	return b
}

// WithIgnoreResourceAttributes adds the given value to the IgnoreResourceAttributes field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the IgnoreResourceAttributes field.
func (b *OTLPConfigApplyConfiguration) WithIgnoreResourceAttributes(values ...string) *OTLPConfigApplyConfiguration {
	for i := range values {
		b.IgnoreResourceAttributes = append(b.IgnoreResourceAttributes, values[i])
	}
	return b
}

// WithPromoteResourceAttributes adds the given value to the PromoteResourceAttributes field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the PromoteResourceAttributes field.
func (b *OTLPConfigApplyConfiguration) WithPromoteResourceAttributes(values ...string) *OTLPConfigApplyConfiguration {
	for i := range values {
		b.PromoteResourceAttributes = append(b.PromoteResourceAttributes, values[i])
	}
	return b
}

// WithTranslationStrategy sets the TranslationStrategy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TranslationStrategy field is set to the value of the last call.
func (b *OTLPConfigApplyConfiguration) WithTranslationStrategy(value monitoringv1.TranslationStrategyOption) *OTLPConfigApplyConfiguration {
	b.TranslationStrategy = &value
	return b
}

// WithKeepIdentifyingResourceAttributes sets the KeepIdentifyingResourceAttributes field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the KeepIdentifyingResourceAttributes field is set to the value of the last call.
func (b *OTLPConfigApplyConfiguration) WithKeepIdentifyingResourceAttributes(value bool) *OTLPConfigApplyConfiguration {
	b.KeepIdentifyingResourceAttributes = &value
	return b
}

// WithConvertHistogramsToNHCB sets the ConvertHistogramsToNHCB field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ConvertHistogramsToNHCB field is set to the value of the last call.
func (b *OTLPConfigApplyConfiguration) WithConvertHistogramsToNHCB(value bool) *OTLPConfigApplyConfiguration {
	b.ConvertHistogramsToNHCB = &value
	return b
}

// WithPromoteScopeMetadata sets the PromoteScopeMetadata field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PromoteScopeMetadata field is set to the value of the last call.
func (b *OTLPConfigApplyConfiguration) WithPromoteScopeMetadata(value bool) *OTLPConfigApplyConfiguration {
	b.PromoteScopeMetadata = &value
	return b
}
