{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Cairo.Structs.TextCluster
    ( 

-- * Exported types
    TextCluster(..)                         ,
    newZeroTextCluster                      ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveTextClusterMethod                ,
#endif



 -- * Properties


-- ** numBytes #attr:numBytes#
-- | /No description available in the introspection data./

    getTextClusterNumBytes                  ,
    setTextClusterNumBytes                  ,
#if defined(ENABLE_OVERLOADING)
    textCluster_numBytes                    ,
#endif


-- ** numGlyphs #attr:numGlyphs#
-- | /No description available in the introspection data./

    getTextClusterNumGlyphs                 ,
    setTextClusterNumGlyphs                 ,
#if defined(ENABLE_OVERLOADING)
    textCluster_numGlyphs                   ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype TextCluster = TextCluster (SP.ManagedPtr TextCluster)
    deriving (Eq)

instance SP.ManagedPtrNewtype TextCluster where
    toManagedPtr (TextCluster p) = p

foreign import ccall "cairo_gobject_text_cluster_get_type" c_cairo_gobject_text_cluster_get_type :: 
    IO GType

type instance O.ParentTypes TextCluster = '[]
instance O.HasParentTypes TextCluster

instance B.Types.TypedObject TextCluster where
    glibType = c_cairo_gobject_text_cluster_get_type

instance B.Types.GBoxed TextCluster

-- | Convert t'TextCluster' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe TextCluster) where
    gvalueGType_ = c_cairo_gobject_text_cluster_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr TextCluster)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr TextCluster)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed TextCluster ptr
        else return P.Nothing
        
    

-- | Construct a t'TextCluster' struct initialized to zero.
newZeroTextCluster :: MonadIO m => m TextCluster
newZeroTextCluster = liftIO $ callocBoxedBytes 8 >>= wrapBoxed TextCluster

instance tag ~ 'AttrSet => Constructible TextCluster tag where
    new _ attrs = do
        o <- newZeroTextCluster
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@num_bytes@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textCluster #numBytes
-- @
getTextClusterNumBytes :: MonadIO m => TextCluster -> m Int32
getTextClusterNumBytes s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@num_bytes@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textCluster [ #numBytes 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextClusterNumBytes :: MonadIO m => TextCluster -> Int32 -> m ()
setTextClusterNumBytes s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data TextClusterNumBytesFieldInfo
instance AttrInfo TextClusterNumBytesFieldInfo where
    type AttrBaseTypeConstraint TextClusterNumBytesFieldInfo = (~) TextCluster
    type AttrAllowedOps TextClusterNumBytesFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TextClusterNumBytesFieldInfo = (~) Int32
    type AttrTransferTypeConstraint TextClusterNumBytesFieldInfo = (~)Int32
    type AttrTransferType TextClusterNumBytesFieldInfo = Int32
    type AttrGetType TextClusterNumBytesFieldInfo = Int32
    type AttrLabel TextClusterNumBytesFieldInfo = "num_bytes"
    type AttrOrigin TextClusterNumBytesFieldInfo = TextCluster
    attrGet = getTextClusterNumBytes
    attrSet = setTextClusterNumBytes
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Cairo.Structs.TextCluster.numBytes"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-cairo-1.0.30/docs/GI-Cairo-Structs-TextCluster.html#g:attr:numBytes"
        })

textCluster_numBytes :: AttrLabelProxy "numBytes"
textCluster_numBytes = AttrLabelProxy

#endif


-- | Get the value of the “@num_glyphs@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textCluster #numGlyphs
-- @
getTextClusterNumGlyphs :: MonadIO m => TextCluster -> m Int32
getTextClusterNumGlyphs s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Int32
    return val

-- | Set the value of the “@num_glyphs@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textCluster [ #numGlyphs 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextClusterNumGlyphs :: MonadIO m => TextCluster -> Int32 -> m ()
setTextClusterNumGlyphs s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data TextClusterNumGlyphsFieldInfo
instance AttrInfo TextClusterNumGlyphsFieldInfo where
    type AttrBaseTypeConstraint TextClusterNumGlyphsFieldInfo = (~) TextCluster
    type AttrAllowedOps TextClusterNumGlyphsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TextClusterNumGlyphsFieldInfo = (~) Int32
    type AttrTransferTypeConstraint TextClusterNumGlyphsFieldInfo = (~)Int32
    type AttrTransferType TextClusterNumGlyphsFieldInfo = Int32
    type AttrGetType TextClusterNumGlyphsFieldInfo = Int32
    type AttrLabel TextClusterNumGlyphsFieldInfo = "num_glyphs"
    type AttrOrigin TextClusterNumGlyphsFieldInfo = TextCluster
    attrGet = getTextClusterNumGlyphs
    attrSet = setTextClusterNumGlyphs
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Cairo.Structs.TextCluster.numGlyphs"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-cairo-1.0.30/docs/GI-Cairo-Structs-TextCluster.html#g:attr:numGlyphs"
        })

textCluster_numGlyphs :: AttrLabelProxy "numGlyphs"
textCluster_numGlyphs = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TextCluster
type instance O.AttributeList TextCluster = TextClusterAttributeList
type TextClusterAttributeList = ('[ '("numBytes", TextClusterNumBytesFieldInfo), '("numGlyphs", TextClusterNumGlyphsFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTextClusterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTextClusterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTextClusterMethod t TextCluster, O.OverloadedMethod info TextCluster p) => OL.IsLabel t (TextCluster -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTextClusterMethod t TextCluster, O.OverloadedMethod info TextCluster p, R.HasField t TextCluster p) => R.HasField t TextCluster p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTextClusterMethod t TextCluster, O.OverloadedMethodInfo info TextCluster) => OL.IsLabel t (O.MethodProxy info TextCluster) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


