{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An opaque structure used as the base of all classes.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Structs.TypeClass
    ( 

-- * Exported types
    TypeClass(..)                           ,
    newZeroTypeClass                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addPrivate]("GI.GObject.Structs.TypeClass#g:method:addPrivate"), [peekParent]("GI.GObject.Structs.TypeClass#g:method:peekParent"), [unref]("GI.GObject.Structs.TypeClass#g:method:unref").
-- 
-- ==== Getters
-- [getPrivate]("GI.GObject.Structs.TypeClass#g:method:getPrivate").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveTypeClassMethod                  ,
#endif

-- ** addPrivate #method:addPrivate#

#if defined(ENABLE_OVERLOADING)
    TypeClassAddPrivateMethodInfo           ,
#endif
    typeClassAddPrivate                     ,


-- ** adjustPrivateOffset #method:adjustPrivateOffset#

    typeClassAdjustPrivateOffset            ,


-- ** get #method:get#

    typeClassGet                            ,


-- ** getPrivate #method:getPrivate#

#if defined(ENABLE_OVERLOADING)
    TypeClassGetPrivateMethodInfo           ,
#endif
    typeClassGetPrivate                     ,


-- ** peek #method:peek#

    typeClassPeek                           ,


-- ** peekParent #method:peekParent#

#if defined(ENABLE_OVERLOADING)
    TypeClassPeekParentMethodInfo           ,
#endif
    typeClassPeekParent                     ,


-- ** peekStatic #method:peekStatic#

    typeClassPeekStatic                     ,


-- ** ref #method:ref#

    typeClassRef                            ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    TypeClassUnrefMethodInfo                ,
#endif
    typeClassUnref                          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype TypeClass = TypeClass (SP.ManagedPtr TypeClass)
    deriving (Eq)

instance SP.ManagedPtrNewtype TypeClass where
    toManagedPtr (TypeClass p) = p

instance BoxedPtr TypeClass where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 8 >=> B.ManagedPtr.wrapPtr TypeClass)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr TypeClass where
    boxedPtrCalloc = callocBytes 8


-- | Construct a t'TypeClass' struct initialized to zero.
newZeroTypeClass :: MonadIO m => m TypeClass
newZeroTypeClass = liftIO $ boxedPtrCalloc >>= wrapPtr TypeClass

instance tag ~ 'AttrSet => Constructible TypeClass tag where
    new _ attrs = do
        o <- newZeroTypeClass
        GI.Attributes.set o attrs
        return o



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TypeClass
type instance O.AttributeList TypeClass = TypeClassAttributeList
type TypeClassAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method TypeClass::add_private
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "g_class"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "class structure for an instantiatable\n   type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "private_size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "size of private structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_type_class_add_private" g_type_class_add_private :: 
    Ptr TypeClass ->                        -- g_class : TInterface (Name {namespace = "GObject", name = "TypeClass"})
    FCT.CSize ->                            -- private_size : TBasicType TSize
    IO ()

{-# DEPRECATED typeClassAddPrivate ["(Since version 2.58)","Use the @/G_ADD_PRIVATE()/@ macro with the @G_DEFINE_*@","  family of macros to add instance private data to a type"] #-}
-- | Registers a private structure for an instantiatable type.
-- 
-- When an object is allocated, the private structures for
-- the type and all of its parent types are allocated
-- sequentially in the same memory block as the public
-- structures, and are zero-filled.
-- 
-- Note that the accumulated size of the private structures of
-- a type and all its parent types cannot exceed 64 KiB.
-- 
-- This function should be called in the type\'s @/class_init()/@ function.
-- The private structure can be retrieved using the
-- @/G_TYPE_INSTANCE_GET_PRIVATE()/@ macro.
-- 
-- The following example shows attaching a private structure
-- MyObjectPrivate to an object MyObject defined in the standard
-- GObject fashion in the type\'s @/class_init()/@ function.
-- 
-- Note the use of a structure member \"priv\" to avoid the overhead
-- of repeatedly calling @/MY_OBJECT_GET_PRIVATE()/@.
-- 
-- 
-- === /C code/
-- >
-- >typedef struct _MyObject        MyObject;
-- >typedef struct _MyObjectPrivate MyObjectPrivate;
-- >
-- >struct _MyObject {
-- > GObject parent;
-- >
-- > MyObjectPrivate *priv;
-- >};
-- >
-- >struct _MyObjectPrivate {
-- >  int some_field;
-- >};
-- >
-- >static void
-- >my_object_class_init (MyObjectClass *klass)
-- >{
-- >  g_type_class_add_private (klass, sizeof (MyObjectPrivate));
-- >}
-- >
-- >static void
-- >my_object_init (MyObject *my_object)
-- >{
-- >  my_object->priv = G_TYPE_INSTANCE_GET_PRIVATE (my_object,
-- >                                                 MY_TYPE_OBJECT,
-- >                                                 MyObjectPrivate);
-- >  // my_object->priv->some_field will be automatically initialised to 0
-- >}
-- >
-- >static int
-- >my_object_get_some_field (MyObject *my_object)
-- >{
-- >  MyObjectPrivate *priv;
-- >
-- >  g_return_val_if_fail (MY_IS_OBJECT (my_object), 0);
-- >
-- >  priv = my_object->priv;
-- >
-- >  return priv->some_field;
-- >}
-- 
-- 
-- /Since: 2.4/
typeClassAddPrivate ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    TypeClass
    -- ^ /@gClass@/: class structure for an instantiatable
    --    type
    -> FCT.CSize
    -- ^ /@privateSize@/: size of private structure
    -> m ()
typeClassAddPrivate gClass privateSize = liftIO $ do
    gClass' <- unsafeManagedPtrGetPtr gClass
    g_type_class_add_private gClass' privateSize
    touchManagedPtr gClass
    return ()

#if defined(ENABLE_OVERLOADING)
data TypeClassAddPrivateMethodInfo
instance (signature ~ (FCT.CSize -> m ()), MonadIO m) => O.OverloadedMethod TypeClassAddPrivateMethodInfo TypeClass signature where
    overloadedMethod = typeClassAddPrivate

instance O.OverloadedMethodInfo TypeClassAddPrivateMethodInfo TypeClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.TypeClass.typeClassAddPrivate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-TypeClass.html#v:typeClassAddPrivate"
        })


#endif

-- method TypeClass::get_private
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "klass"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "private_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_class_get_private" g_type_class_get_private :: 
    Ptr TypeClass ->                        -- klass : TInterface (Name {namespace = "GObject", name = "TypeClass"})
    CGType ->                               -- private_type : TBasicType TGType
    IO (Ptr ())

-- | /No description available in the introspection data./
typeClassGetPrivate ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    TypeClass
    -> GType
    -> m (Ptr ())
typeClassGetPrivate klass privateType = liftIO $ do
    klass' <- unsafeManagedPtrGetPtr klass
    let privateType' = gtypeToCGType privateType
    result <- g_type_class_get_private klass' privateType'
    touchManagedPtr klass
    return result

#if defined(ENABLE_OVERLOADING)
data TypeClassGetPrivateMethodInfo
instance (signature ~ (GType -> m (Ptr ())), MonadIO m) => O.OverloadedMethod TypeClassGetPrivateMethodInfo TypeClass signature where
    overloadedMethod = typeClassGetPrivate

instance O.OverloadedMethodInfo TypeClassGetPrivateMethodInfo TypeClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.TypeClass.typeClassGetPrivate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-TypeClass.html#v:typeClassGetPrivate"
        })


#endif

-- method TypeClass::peek_parent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "g_class"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the #GTypeClass structure to\n  retrieve the parent class for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GObject" , name = "TypeClass" })
-- throws : False
-- Skip return : False

foreign import ccall "g_type_class_peek_parent" g_type_class_peek_parent :: 
    Ptr TypeClass ->                        -- g_class : TInterface (Name {namespace = "GObject", name = "TypeClass"})
    IO (Ptr TypeClass)

-- | Retrieves the class structure of the immediate parent type of the
-- class passed in.
-- 
-- This is a convenience function often needed in class initializers.
-- 
-- Since derived classes hold a reference on their parent classes as
-- long as they are instantiated, the returned class will always exist.
-- 
-- This function is essentially equivalent to:
-- g_type_class_peek (g_type_parent (G_TYPE_FROM_CLASS (g_class)))
typeClassPeekParent ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    TypeClass
    -- ^ /@gClass@/: the t'GI.GObject.Structs.TypeClass.TypeClass' structure to
    --   retrieve the parent class for
    -> m TypeClass
    -- ^ __Returns:__ the parent class
    --   of /@gClass@/
typeClassPeekParent gClass = liftIO $ do
    gClass' <- unsafeManagedPtrGetPtr gClass
    result <- g_type_class_peek_parent gClass'
    checkUnexpectedReturnNULL "typeClassPeekParent" result
    result' <- (newPtr TypeClass) result
    touchManagedPtr gClass
    return result'

#if defined(ENABLE_OVERLOADING)
data TypeClassPeekParentMethodInfo
instance (signature ~ (m TypeClass), MonadIO m) => O.OverloadedMethod TypeClassPeekParentMethodInfo TypeClass signature where
    overloadedMethod = typeClassPeekParent

instance O.OverloadedMethodInfo TypeClassPeekParentMethodInfo TypeClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.TypeClass.typeClassPeekParent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-TypeClass.html#v:typeClassPeekParent"
        })


#endif

-- method TypeClass::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "g_class"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTypeClass structure to unref"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_type_class_unref" g_type_class_unref :: 
    Ptr TypeClass ->                        -- g_class : TInterface (Name {namespace = "GObject", name = "TypeClass"})
    IO ()

{-# DEPRECATED typeClassUnref ["(Since version 2.84)","Type class reference counting has been removed and type","   classes now cannot be finalized. This function no longer does anything."] #-}
-- | Decrements the reference count of the class structure being passed in.
-- 
-- Once the last reference count of a class has been released, classes
-- may be finalized by the type system, so further dereferencing of a
-- class pointer after 'GI.GObject.Structs.TypeClass.typeClassUnref' are invalid.
typeClassUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    TypeClass
    -- ^ /@gClass@/: a t'GI.GObject.Structs.TypeClass.TypeClass' structure to unref
    -> m ()
typeClassUnref gClass = liftIO $ do
    gClass' <- unsafeManagedPtrGetPtr gClass
    g_type_class_unref gClass'
    touchManagedPtr gClass
    return ()

#if defined(ENABLE_OVERLOADING)
data TypeClassUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod TypeClassUnrefMethodInfo TypeClass signature where
    overloadedMethod = typeClassUnref

instance O.OverloadedMethodInfo TypeClassUnrefMethodInfo TypeClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.TypeClass.typeClassUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-TypeClass.html#v:typeClassUnref"
        })


#endif

-- method TypeClass::adjust_private_offset
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "g_class"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "private_size_or_offset"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_type_class_adjust_private_offset" g_type_class_adjust_private_offset :: 
    Ptr () ->                               -- g_class : TBasicType TPtr
    Int32 ->                                -- private_size_or_offset : TBasicType TInt
    IO ()

-- | /No description available in the introspection data./
typeClassAdjustPrivateOffset ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -> Int32
    -> m ()
typeClassAdjustPrivateOffset gClass privateSizeOrOffset = liftIO $ do
    g_type_class_adjust_private_offset gClass privateSizeOrOffset
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method TypeClass::get
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "type ID of a classed type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GObject" , name = "TypeClass" })
-- throws : False
-- Skip return : False

foreign import ccall "g_type_class_get" g_type_class_get :: 
    CGType ->                               -- type : TBasicType TGType
    IO (Ptr TypeClass)

-- | Retrieves the type class of the given /@type@/.
-- 
-- This function will create the class on demand if it does not exist
-- already.
-- 
-- If you don\'t want to create the class, use 'GI.GObject.Functions.typeClassPeek' instead.
-- 
-- /Since: 2.84/
typeClassGet ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@type@/: type ID of a classed type
    -> m TypeClass
    -- ^ __Returns:__ the class structure
    --   for the type
typeClassGet type_ = liftIO $ do
    let type_' = gtypeToCGType type_
    result <- g_type_class_get type_'
    checkUnexpectedReturnNULL "typeClassGet" result
    result' <- (newPtr TypeClass) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method TypeClass::peek
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "type ID of a classed type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GObject" , name = "TypeClass" })
-- throws : False
-- Skip return : False

foreign import ccall "g_type_class_peek" g_type_class_peek :: 
    CGType ->                               -- type : TBasicType TGType
    IO (Ptr TypeClass)

-- | Retrieves the class for a give type.
-- 
-- This function is essentially the same as 'GI.GObject.Functions.typeClassGet',
-- except that the class may have not been instantiated yet.
-- 
-- As a consequence, this function may return 'P.Nothing' if the class
-- of the type passed in does not currently exist (hasn\'t been
-- referenced before).
typeClassPeek ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@type@/: type ID of a classed type
    -> m (Maybe TypeClass)
    -- ^ __Returns:__ the
    --   t'GI.GObject.Structs.TypeClass.TypeClass' structure for the given type ID or 'P.Nothing' if the class
    --   does not currently exist
typeClassPeek type_ = liftIO $ do
    let type_' = gtypeToCGType type_
    result <- g_type_class_peek type_'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr TypeClass) result'
        return result''
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method TypeClass::peek_static
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "type ID of a classed type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GObject" , name = "TypeClass" })
-- throws : False
-- Skip return : False

foreign import ccall "g_type_class_peek_static" g_type_class_peek_static :: 
    CGType ->                               -- type : TBasicType TGType
    IO (Ptr TypeClass)

-- | A more efficient version of 'GI.GObject.Functions.typeClassPeek' which works only for
-- static types.
-- 
-- /Since: 2.4/
typeClassPeekStatic ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@type@/: type ID of a classed type
    -> m (Maybe TypeClass)
    -- ^ __Returns:__ the
    --   t'GI.GObject.Structs.TypeClass.TypeClass' structure for the given type ID or 'P.Nothing' if the class
    --   does not currently exist or is dynamically loaded
typeClassPeekStatic type_ = liftIO $ do
    let type_' = gtypeToCGType type_
    result <- g_type_class_peek_static type_'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr TypeClass) result'
        return result''
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method TypeClass::ref
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "type ID of a classed type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GObject" , name = "TypeClass" })
-- throws : False
-- Skip return : False

foreign import ccall "g_type_class_ref" g_type_class_ref :: 
    CGType ->                               -- type : TBasicType TGType
    IO (Ptr TypeClass)

{-# DEPRECATED typeClassRef ["(Since version 2.84)","Use 'GI.GObject.Functions.typeClassGet' instead"] #-}
-- | Increments the reference count of the class structure belonging to
-- /@type@/.
-- 
-- This function will demand-create the class if it doesn\'t exist already.
typeClassRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@type@/: type ID of a classed type
    -> m TypeClass
    -- ^ __Returns:__ the t'GI.GObject.Structs.TypeClass.TypeClass'
    --   structure for the given type ID
typeClassRef type_ = liftIO $ do
    let type_' = gtypeToCGType type_
    result <- g_type_class_ref type_'
    checkUnexpectedReturnNULL "typeClassRef" result
    result' <- (newPtr TypeClass) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTypeClassMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTypeClassMethod "addPrivate" o = TypeClassAddPrivateMethodInfo
    ResolveTypeClassMethod "peekParent" o = TypeClassPeekParentMethodInfo
    ResolveTypeClassMethod "unref" o = TypeClassUnrefMethodInfo
    ResolveTypeClassMethod "getPrivate" o = TypeClassGetPrivateMethodInfo
    ResolveTypeClassMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTypeClassMethod t TypeClass, O.OverloadedMethod info TypeClass p) => OL.IsLabel t (TypeClass -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTypeClassMethod t TypeClass, O.OverloadedMethod info TypeClass p, R.HasField t TypeClass p) => R.HasField t TypeClass p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTypeClassMethod t TypeClass, O.OverloadedMethodInfo info TypeClass) => OL.IsLabel t (O.MethodProxy info TypeClass) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


