{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A render node for a solid color.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.ColorNode
    ( 

-- * Exported types
    ColorNode(..)                           ,
    IsColorNode                             ,
    toColorNode                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [draw]("GI.Gsk.Objects.RenderNode#g:method:draw"), [ref]("GI.Gsk.Objects.RenderNode#g:method:ref"), [serialize]("GI.Gsk.Objects.RenderNode#g:method:serialize"), [unref]("GI.Gsk.Objects.RenderNode#g:method:unref"), [writeToFile]("GI.Gsk.Objects.RenderNode#g:method:writeToFile").
-- 
-- ==== Getters
-- [getBounds]("GI.Gsk.Objects.RenderNode#g:method:getBounds"), [getColor]("GI.Gsk.Objects.ColorNode#g:method:getColor"), [getNodeType]("GI.Gsk.Objects.RenderNode#g:method:getNodeType"), [getOpaqueRect]("GI.Gsk.Objects.RenderNode#g:method:getOpaqueRect").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveColorNodeMethod                  ,
#endif

-- ** getColor #method:getColor#

#if defined(ENABLE_OVERLOADING)
    ColorNodeGetColorMethodInfo             ,
#endif
    colorNodeGetColor                       ,


-- ** new #method:new#

    colorNodeNew                            ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#else
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#endif

-- | Memory-managed wrapper type.
newtype ColorNode = ColorNode (SP.ManagedPtr ColorNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype ColorNode where
    toManagedPtr (ColorNode p) = p

foreign import ccall "gsk_color_node_get_type"
    c_gsk_color_node_get_type :: IO B.Types.GType

instance B.Types.TypedObject ColorNode where
    glibType = c_gsk_color_node_get_type

-- | Type class for types which can be safely cast to t'ColorNode', for instance with `toColorNode`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ColorNode o) => IsColorNode o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ColorNode o) => IsColorNode o

instance O.HasParentTypes ColorNode
type instance O.ParentTypes ColorNode = '[Gsk.RenderNode.RenderNode]

-- | Cast to t'ColorNode', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toColorNode :: (MIO.MonadIO m, IsColorNode o) => o -> m ColorNode
toColorNode = MIO.liftIO . B.ManagedPtr.unsafeCastTo ColorNode

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveColorNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveColorNodeMethod "draw" o = Gsk.RenderNode.RenderNodeDrawMethodInfo
    ResolveColorNodeMethod "ref" o = Gsk.RenderNode.RenderNodeRefMethodInfo
    ResolveColorNodeMethod "serialize" o = Gsk.RenderNode.RenderNodeSerializeMethodInfo
    ResolveColorNodeMethod "unref" o = Gsk.RenderNode.RenderNodeUnrefMethodInfo
    ResolveColorNodeMethod "writeToFile" o = Gsk.RenderNode.RenderNodeWriteToFileMethodInfo
    ResolveColorNodeMethod "getBounds" o = Gsk.RenderNode.RenderNodeGetBoundsMethodInfo
    ResolveColorNodeMethod "getColor" o = ColorNodeGetColorMethodInfo
    ResolveColorNodeMethod "getNodeType" o = Gsk.RenderNode.RenderNodeGetNodeTypeMethodInfo
    ResolveColorNodeMethod "getOpaqueRect" o = Gsk.RenderNode.RenderNodeGetOpaqueRectMethodInfo
    ResolveColorNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveColorNodeMethod t ColorNode, O.OverloadedMethod info ColorNode p) => OL.IsLabel t (ColorNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveColorNodeMethod t ColorNode, O.OverloadedMethod info ColorNode p, R.HasField t ColorNode p) => R.HasField t ColorNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveColorNodeMethod t ColorNode, O.OverloadedMethodInfo info ColorNode) => OL.IsLabel t (O.MethodProxy info ColorNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr ColorNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method ColorNode::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "rgba"
--           , argType = TInterface Name { namespace = "Gdk" , name = "RGBA" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkRGBA` specifying a color"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bounds"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the rectangle to render the color into"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "ColorNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_color_node_new" gsk_color_node_new :: 
    Ptr Gdk.RGBA.RGBA ->                    -- rgba : TInterface (Name {namespace = "Gdk", name = "RGBA"})
    Ptr Graphene.Rect.Rect ->               -- bounds : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO (Ptr ColorNode)

-- | Creates a @GskRenderNode@ that will render the color specified by /@rgba@/ into
-- the area given by /@bounds@/.
colorNodeNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gdk.RGBA.RGBA
    -- ^ /@rgba@/: a @GdkRGBA@ specifying a color
    -> Graphene.Rect.Rect
    -- ^ /@bounds@/: the rectangle to render the color into
    -> m ColorNode
    -- ^ __Returns:__ A new @GskRenderNode@
colorNodeNew rgba bounds = liftIO $ do
    rgba' <- unsafeManagedPtrGetPtr rgba
    bounds' <- unsafeManagedPtrGetPtr bounds
    result <- gsk_color_node_new rgba' bounds'
    checkUnexpectedReturnNULL "colorNodeNew" result
    result' <- (wrapPtr ColorNode) result
    touchManagedPtr rgba
    touchManagedPtr bounds
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ColorNode::get_color
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ColorNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "RGBA" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_color_node_get_color" gsk_color_node_get_color :: 
    Ptr ColorNode ->                        -- node : TInterface (Name {namespace = "Gsk", name = "ColorNode"})
    IO (Ptr Gdk.RGBA.RGBA)

-- | Retrieves the color of the given /@node@/.
-- 
-- The value returned by this function will not be correct
-- if the render node was created for a non-sRGB color.
colorNodeGetColor ::
    (B.CallStack.HasCallStack, MonadIO m, IsColorNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@
    -> m Gdk.RGBA.RGBA
    -- ^ __Returns:__ the color of the node
colorNodeGetColor node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_color_node_get_color node'
    checkUnexpectedReturnNULL "colorNodeGetColor" result
    result' <- (newBoxed Gdk.RGBA.RGBA) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data ColorNodeGetColorMethodInfo
instance (signature ~ (m Gdk.RGBA.RGBA), MonadIO m, IsColorNode a) => O.OverloadedMethod ColorNodeGetColorMethodInfo a signature where
    overloadedMethod = colorNodeGetColor

instance O.OverloadedMethodInfo ColorNodeGetColorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.ColorNode.colorNodeGetColor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-ColorNode.html#v:colorNodeGetColor"
        })


#endif


