{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @PangoFontset@ represents a set of @PangoFont@ to use when rendering text.
-- 
-- A @PangoFontset@ is the result of resolving a @PangoFontDescription@
-- against a particular @PangoContext@. It has operations for finding the
-- component font for a particular Unicode character, and for finding a
-- composite set of metrics for the entire fontset.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Objects.Fontset
    ( 

-- * Exported types
    Fontset(..)                             ,
    IsFontset                               ,
    toFontset                               ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [foreach]("GI.Pango.Objects.Fontset#g:method:foreach"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFont]("GI.Pango.Objects.Fontset#g:method:getFont"), [getMetrics]("GI.Pango.Objects.Fontset#g:method:getMetrics"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveFontsetMethod                    ,
#endif

-- ** foreach #method:foreach#

#if defined(ENABLE_OVERLOADING)
    FontsetForeachMethodInfo                ,
#endif
    fontsetForeach                          ,


-- ** getFont #method:getFont#

#if defined(ENABLE_OVERLOADING)
    FontsetGetFontMethodInfo                ,
#endif
    fontsetGetFont                          ,


-- ** getMetrics #method:getMetrics#

#if defined(ENABLE_OVERLOADING)
    FontsetGetMetricsMethodInfo             ,
#endif
    fontsetGetMetrics                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.HarfBuzz.Structs.FeatureT as HarfBuzz.FeatureT
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Objects.Context as Pango.Context
import {-# SOURCE #-} qualified GI.Pango.Objects.Coverage as Pango.Coverage
import {-# SOURCE #-} qualified GI.Pango.Objects.Font as Pango.Font
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFace as Pango.FontFace
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFamily as Pango.FontFamily
import {-# SOURCE #-} qualified GI.Pango.Objects.FontMap as Pango.FontMap
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.FontMetrics as Pango.FontMetrics
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.Matrix as Pango.Matrix
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Objects.Font as Pango.Font
import {-# SOURCE #-} qualified GI.Pango.Structs.FontMetrics as Pango.FontMetrics

#endif

-- | Memory-managed wrapper type.
newtype Fontset = Fontset (SP.ManagedPtr Fontset)
    deriving (Eq)

instance SP.ManagedPtrNewtype Fontset where
    toManagedPtr (Fontset p) = p

foreign import ccall "pango_fontset_get_type"
    c_pango_fontset_get_type :: IO B.Types.GType

instance B.Types.TypedObject Fontset where
    glibType = c_pango_fontset_get_type

instance B.Types.GObject Fontset

-- | Type class for types which can be safely cast to t'Fontset', for instance with `toFontset`.
class (SP.GObject o, O.IsDescendantOf Fontset o) => IsFontset o
instance (SP.GObject o, O.IsDescendantOf Fontset o) => IsFontset o

instance O.HasParentTypes Fontset
type instance O.ParentTypes Fontset = '[GObject.Object.Object]

-- | Cast to t'Fontset', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toFontset :: (MIO.MonadIO m, IsFontset o) => o -> m Fontset
toFontset = MIO.liftIO . B.ManagedPtr.unsafeCastTo Fontset

-- | Convert t'Fontset' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Fontset) where
    gvalueGType_ = c_pango_fontset_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Fontset)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Fontset)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Fontset ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveFontsetMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFontsetMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveFontsetMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveFontsetMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveFontsetMethod "foreach" o = FontsetForeachMethodInfo
    ResolveFontsetMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveFontsetMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveFontsetMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveFontsetMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveFontsetMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveFontsetMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveFontsetMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveFontsetMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveFontsetMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveFontsetMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveFontsetMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveFontsetMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveFontsetMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveFontsetMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveFontsetMethod "getFont" o = FontsetGetFontMethodInfo
    ResolveFontsetMethod "getMetrics" o = FontsetGetMetricsMethodInfo
    ResolveFontsetMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveFontsetMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveFontsetMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveFontsetMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveFontsetMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveFontsetMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFontsetMethod t Fontset, O.OverloadedMethod info Fontset p) => OL.IsLabel t (Fontset -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFontsetMethod t Fontset, O.OverloadedMethod info Fontset p, R.HasField t Fontset p) => R.HasField t Fontset p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFontsetMethod t Fontset, O.OverloadedMethodInfo info Fontset) => OL.IsLabel t (O.MethodProxy info Fontset) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Fontset
type instance O.AttributeList Fontset = FontsetAttributeList
type FontsetAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Fontset = FontsetSignalList
type FontsetSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Fontset::foreach
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "fontset"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Fontset" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontset`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType =
--               TInterface
--                 Name { namespace = "Pango" , name = "FontsetForeachFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Callback function" , sinceVersion = Nothing }
--           , argScope = ScopeTypeCall
--           , argClosure = 2
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to the callback function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_fontset_foreach" pango_fontset_foreach :: 
    Ptr Fontset ->                          -- fontset : TInterface (Name {namespace = "Pango", name = "Fontset"})
    FunPtr Pango.Callbacks.C_FontsetForeachFunc -> -- func : TInterface (Name {namespace = "Pango", name = "FontsetForeachFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO ()

-- | Iterates through all the fonts in a fontset, calling /@func@/ for
-- each one.
-- 
-- If /@func@/ returns 'P.True', that stops the iteration.
-- 
-- /Since: 1.4/
fontsetForeach ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontset a) =>
    a
    -- ^ /@fontset@/: a @PangoFontset@
    -> Pango.Callbacks.FontsetForeachFunc
    -- ^ /@func@/: Callback function
    -> m ()
fontsetForeach fontset func = liftIO $ do
    fontset' <- unsafeManagedPtrCastPtr fontset
    func' <- Pango.Callbacks.mk_FontsetForeachFunc (Pango.Callbacks.wrap_FontsetForeachFunc Nothing (Pango.Callbacks.drop_closures_FontsetForeachFunc func))
    let data_ = nullPtr
    pango_fontset_foreach fontset' func' data_
    safeFreeFunPtr $ castFunPtrToPtr func'
    touchManagedPtr fontset
    return ()

#if defined(ENABLE_OVERLOADING)
data FontsetForeachMethodInfo
instance (signature ~ (Pango.Callbacks.FontsetForeachFunc -> m ()), MonadIO m, IsFontset a) => O.OverloadedMethod FontsetForeachMethodInfo a signature where
    overloadedMethod = fontsetForeach

instance O.OverloadedMethodInfo FontsetForeachMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Fontset.fontsetForeach",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Fontset.html#v:fontsetForeach"
        })


#endif

-- method Fontset::get_font
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "fontset"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Fontset" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontset`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "wc"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Font" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_fontset_get_font" pango_fontset_get_font :: 
    Ptr Fontset ->                          -- fontset : TInterface (Name {namespace = "Pango", name = "Fontset"})
    Word32 ->                               -- wc : TBasicType TUInt
    IO (Ptr Pango.Font.Font)

-- | Returns the font in the fontset that contains the best
-- glyph for a Unicode character.
fontsetGetFont ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontset a) =>
    a
    -- ^ /@fontset@/: a @PangoFontset@
    -> Word32
    -- ^ /@wc@/: a Unicode character
    -> m Pango.Font.Font
    -- ^ __Returns:__ a @PangoFont@
fontsetGetFont fontset wc = liftIO $ do
    fontset' <- unsafeManagedPtrCastPtr fontset
    result <- pango_fontset_get_font fontset' wc
    checkUnexpectedReturnNULL "fontsetGetFont" result
    result' <- (wrapObject Pango.Font.Font) result
    touchManagedPtr fontset
    return result'

#if defined(ENABLE_OVERLOADING)
data FontsetGetFontMethodInfo
instance (signature ~ (Word32 -> m Pango.Font.Font), MonadIO m, IsFontset a) => O.OverloadedMethod FontsetGetFontMethodInfo a signature where
    overloadedMethod = fontsetGetFont

instance O.OverloadedMethodInfo FontsetGetFontMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Fontset.fontsetGetFont",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Fontset.html#v:fontsetGetFont"
        })


#endif

-- method Fontset::get_metrics
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "fontset"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Fontset" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontset`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Pango" , name = "FontMetrics" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_fontset_get_metrics" pango_fontset_get_metrics :: 
    Ptr Fontset ->                          -- fontset : TInterface (Name {namespace = "Pango", name = "Fontset"})
    IO (Ptr Pango.FontMetrics.FontMetrics)

-- | Get overall metric information for the fonts in the fontset.
fontsetGetMetrics ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontset a) =>
    a
    -- ^ /@fontset@/: a @PangoFontset@
    -> m Pango.FontMetrics.FontMetrics
    -- ^ __Returns:__ a @PangoFontMetrics@ object
fontsetGetMetrics fontset = liftIO $ do
    fontset' <- unsafeManagedPtrCastPtr fontset
    result <- pango_fontset_get_metrics fontset'
    checkUnexpectedReturnNULL "fontsetGetMetrics" result
    result' <- (wrapBoxed Pango.FontMetrics.FontMetrics) result
    touchManagedPtr fontset
    return result'

#if defined(ENABLE_OVERLOADING)
data FontsetGetMetricsMethodInfo
instance (signature ~ (m Pango.FontMetrics.FontMetrics), MonadIO m, IsFontset a) => O.OverloadedMethod FontsetGetMetricsMethodInfo a signature where
    overloadedMethod = fontsetGetMetrics

instance O.OverloadedMethodInfo FontsetGetMetricsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Fontset.fontsetGetMetrics",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Fontset.html#v:fontsetGetMetrics"
        })


#endif


