/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
)

// ResourceHealthApplyConfiguration represents a declarative configuration of the ResourceHealth type for use
// with apply.
//
// ResourceHealth represents the health of a resource. It has the latest device health information.
// This is a part of KEP https://kep.k8s.io/4680.
type ResourceHealthApplyConfiguration struct {
	// ResourceID is the unique identifier of the resource. See the ResourceID type for more information.
	ResourceID *corev1.ResourceID `json:"resourceID,omitempty"`
	// Health of the resource.
	// can be one of:
	// - Healthy: operates as normal
	// - Unhealthy: reported unhealthy. We consider this a temporary health issue
	// since we do not have a mechanism today to distinguish
	// temporary and permanent issues.
	// - Unknown: The status cannot be determined.
	// For example, Device Plugin got unregistered and hasn't been re-registered since.
	//
	// In future we may want to introduce the PermanentlyUnhealthy Status.
	Health *corev1.ResourceHealthStatus `json:"health,omitempty"`
}

// ResourceHealthApplyConfiguration constructs a declarative configuration of the ResourceHealth type for use with
// apply.
func ResourceHealth() *ResourceHealthApplyConfiguration {
	return &ResourceHealthApplyConfiguration{}
}

// WithResourceID sets the ResourceID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResourceID field is set to the value of the last call.
func (b *ResourceHealthApplyConfiguration) WithResourceID(value corev1.ResourceID) *ResourceHealthApplyConfiguration {
	b.ResourceID = &value
	return b
}

// WithHealth sets the Health field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Health field is set to the value of the last call.
func (b *ResourceHealthApplyConfiguration) WithHealth(value corev1.ResourceHealthStatus) *ResourceHealthApplyConfiguration {
	b.Health = &value
	return b
}
