
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kxmlgui_python.h"

// main header
#include "ktoggletoolbaraction_wrapper.h"

// Argument includes
#include <QString>
#include <ktoolbar.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KToggleToolBarAction_Type = nullptr;
static PyTypeObject *Sbk_KToggleToolBarAction_TypeF(void)
{
    return _Sbk_KToggleToolBarAction_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KToggleToolBarActionWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KToggleToolBarActionWrapper::KToggleToolBarActionWrapper(::KToolBar * toolBar, const ::QString & text, ::QObject * parent) : KToggleToolBarAction(toolBar, text, parent)
{
}

bool KToggleToolBarActionWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToggleToolBarAction_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::KToggleToolBarAction::eventFilter(watched, event);
    }
    return sbk_o_eventFilter("KToggleToolBarAction", funcName, gil, pyOverride, watched, event);
}

bool KToggleToolBarActionWrapper::sbk_o_eventFilter(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QObject * watched, ::QEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), watched),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), watched),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

KToggleToolBarActionWrapper::~KToggleToolBarActionWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KToggleToolBarAction_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KToggleToolBarAction_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KToggleToolBarAction >()))
        return -1;

    KToggleToolBarActionWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KToggleToolBarAction", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KToggleToolBarAction::KToggleToolBarAction(KToolBar*,QString,QObject*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KToolBar_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[2])))) {
        overloadId = 0; // KToggleToolBarAction(KToolBar*,QString,QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KToggleToolBarAction_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKXmlGuiTypeStructs[SBK_KToggleToolBarAction_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::KToolBar *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return -1;
        ::QObject *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KToggleToolBarAction(KToolBar*,QString,QObject*)
            cptr = new KToggleToolBarActionWrapper(cppArg0, cppArg1, cppArg2);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KToggleToolBarAction >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KToggleToolBarAction_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KToggleToolBarActionFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KToggleToolBarAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KToggleToolBarAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KToggleToolBarAction::eventFilter(QObject*,QEvent*)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "eventFilter", errInfo, SbkKXmlGuiTypeStructs[SBK_KToggleToolBarAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KToggleToolBarAction::eventFilter(cppArg0, cppArg1)
                : cppSelf->eventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KToggleToolBarActionFunc_toolBar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KToggleToolBarAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KToggleToolBarAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toolBar()
        KToolBar * cppResult = cppSelf->toolBar();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KToolBar_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KToggleToolBarAction_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KToggleToolBarAction_methods[] = {
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_KToggleToolBarActionFunc_eventFilter), METH_VARARGS, nullptr},
    {"toolBar", reinterpret_cast<PyCFunction>(Sbk_KToggleToolBarActionFunc_toolBar), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KToggleToolBarAction_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KToggleToolBarAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KToggleToolBarAction_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KToggleToolBarActionWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KToggleToolBarAction_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KToggleToolBarAction_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KToggleToolBarAction_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KToggleToolBarAction_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KToggleToolBarAction_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KToggleToolBarAction_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KToggleToolBarAction_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KToggleToolBarAction_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KToggleToolBarAction_spec = {
    "1:KXmlGui.KToggleToolBarAction",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KToggleToolBarAction_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KToggleToolBarAction_PythonToCpp_KToggleToolBarAction_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KToggleToolBarAction_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KToggleToolBarAction_PythonToCpp_KToggleToolBarAction_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KToggleToolBarAction_TypeF()))
        return KToggleToolBarAction_PythonToCpp_KToggleToolBarAction_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KToggleToolBarAction_PTR_CppToPython_KToggleToolBarAction(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KToggleToolBarAction_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    auto *tCppIn = reinterpret_cast<const ::KToggleToolBarAction *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    return Shiboken::Object::newObjectForPointer(Sbk_KToggleToolBarAction_TypeF(), const_cast<void *>(cppIn), false, typeName);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KToggleToolBarAction_SignatureStrings[] = {
    "KXmlGui.KToggleToolBarAction(self,toolBar:KXmlGui.KToolBar,text:QString,parent:PySide6.QtCore.QObject)",
    "KXmlGui.KToggleToolBarAction.eventFilter(self,watched:PySide6.QtCore.QObject,event:PySide6.QtCore.QEvent)->bool",
    "KXmlGui.KToggleToolBarAction.toolBar(self)->KXmlGui.KToolBar",
    nullptr}; // Sentinel
#else
static constexpr size_t KToggleToolBarAction_SignatureByteSize = 147;
static constexpr uint8_t KToggleToolBarAction_SignatureBytes[147] = {
    0x78, 0xda, 0xf3, 0x8e, 0xc8, 0xcd, 0x71, 0x2f, 0xcd, 0xd4, 0xf3, 0x0e, 0xc9, 0x4f, 0x4f, 0xcf,
    0x49, 0x0d, 0xc9, 0xcf, 0xcf, 0x71, 0x4a, 0x2c, 0x72, 0x4c, 0x2e, 0xc9, 0xcc, 0xcf, 0xd3, 0x28,
    0x4e, 0xcd, 0x49, 0xd3, 0x29, 0x81, 0x08, 0x59, 0x79, 0x23, 0x54, 0x82, 0x05, 0x74, 0x4a, 0x52,
    0x2b, 0x4a, 0xac, 0x02, 0x83, 0x4b, 0x8a, 0x32, 0xf3, 0xd2, 0x75, 0x0a, 0x12, 0x8b, 0x52, 0xf3,
    0x4a, 0xac, 0x02, 0x2a, 0x83, 0x33, 0x53, 0x52, 0xcd, 0xf4, 0x02, 0x4b, 0x9c, 0xf3, 0x8b, 0x52,
    0xf5, 0x02, 0xfd, 0x93, 0xb2, 0x52, 0x93, 0x4b, 0x34, 0xb9, 0xbc, 0xf1, 0x58, 0xa3, 0x97, 0x5a,
    0x06, 0xd4, 0xea, 0x96, 0x99, 0x53, 0x92, 0x5a, 0x04, 0xb1, 0xb2, 0x3c, 0xb1, 0x24, 0x39, 0x23,
    0x35, 0x05, 0x87, 0x69, 0x3a, 0x60, 0xf5, 0x18, 0x92, 0xae, 0x20, 0x51, 0x4d, 0x5d, 0xbb, 0x24,
    0xa0, 0xd9, 0xf8, 0xed, 0x83, 0xfa, 0x08, 0x6c, 0x17, 0x50, 0x03, 0xba, 0xc7, 0xb8, 0x00, 0x73,
    0x32, 0x63, 0xa1
};
#endif

PyTypeObject *init_KToggleToolBarAction(PyObject *module)
{
    if (SbkKXmlGuiTypeStructs[SBK_KToggleToolBarAction_IDX].type != nullptr)
        return SbkKXmlGuiTypeStructs[SBK_KToggleToolBarAction_IDX].type;

    Shiboken::AutoDecRef Sbk_KToggleToolBarAction_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KToggleToolBarAction_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KToggleToolBarAction",
        "KToggleToolBarAction*",
        &Sbk_KToggleToolBarAction_spec,
        &Shiboken::callCppDestructor< KToggleToolBarAction >,
        Sbk_KToggleToolBarAction_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KToggleToolBarAction_Type; // references _Sbk_KToggleToolBarAction_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KToggleToolBarAction_SignatureStrings);
#else
    InitSignatureBytes(pyType, KToggleToolBarAction_SignatureBytes, KToggleToolBarAction_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KToggleToolBarAction_PropertyStrings);
    SbkKXmlGuiTypeStructs[SBK_KToggleToolBarAction_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KToggleToolBarAction_PythonToCpp_KToggleToolBarAction_PTR,
        is_KToggleToolBarAction_PythonToCpp_KToggleToolBarAction_PTR_Convertible,
        KToggleToolBarAction_PTR_CppToPython_KToggleToolBarAction);

    Shiboken::Conversions::registerConverterName(converter, "KToggleToolBarAction");
    Shiboken::Conversions::registerConverterName(converter, "KToggleToolBarAction*");
    Shiboken::Conversions::registerConverterName(converter, "KToggleToolBarAction&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KToggleToolBarAction).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KToggleToolBarActionWrapper).name());

    qRegisterMetaType< ::KToggleToolBarAction *>();

    return pyType;
}
