// Code generated by ndpgen. DO NOT EDIT.

package host

import (
	"context"
	"encoding/json"

	extism "github.com/extism/go-sdk"
)

// WebSocketConnectRequest is the request type for WebSocket.Connect.
type WebSocketConnectRequest struct {
	Url          string            `json:"url"`
	Headers      map[string]string `json:"headers"`
	ConnectionID string            `json:"connectionId"`
}

// WebSocketConnectResponse is the response type for WebSocket.Connect.
type WebSocketConnectResponse struct {
	NewConnectionID string `json:"newConnectionId,omitempty"`
	Error           string `json:"error,omitempty"`
}

// WebSocketSendTextRequest is the request type for WebSocket.SendText.
type WebSocketSendTextRequest struct {
	ConnectionID string `json:"connectionId"`
	Message      string `json:"message"`
}

// WebSocketSendTextResponse is the response type for WebSocket.SendText.
type WebSocketSendTextResponse struct {
	Error string `json:"error,omitempty"`
}

// WebSocketSendBinaryRequest is the request type for WebSocket.SendBinary.
type WebSocketSendBinaryRequest struct {
	ConnectionID string `json:"connectionId"`
	Data         []byte `json:"data"`
}

// WebSocketSendBinaryResponse is the response type for WebSocket.SendBinary.
type WebSocketSendBinaryResponse struct {
	Error string `json:"error,omitempty"`
}

// WebSocketCloseConnectionRequest is the request type for WebSocket.CloseConnection.
type WebSocketCloseConnectionRequest struct {
	ConnectionID string `json:"connectionId"`
	Code         int32  `json:"code"`
	Reason       string `json:"reason"`
}

// WebSocketCloseConnectionResponse is the response type for WebSocket.CloseConnection.
type WebSocketCloseConnectionResponse struct {
	Error string `json:"error,omitempty"`
}

// RegisterWebSocketHostFunctions registers WebSocket service host functions.
// The returned host functions should be added to the plugin's configuration.
func RegisterWebSocketHostFunctions(service WebSocketService) []extism.HostFunction {
	return []extism.HostFunction{
		newWebSocketConnectHostFunction(service),
		newWebSocketSendTextHostFunction(service),
		newWebSocketSendBinaryHostFunction(service),
		newWebSocketCloseConnectionHostFunction(service),
	}
}

func newWebSocketConnectHostFunction(service WebSocketService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"websocket_connect",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {
			// Read JSON request from plugin memory
			reqBytes, err := p.ReadBytes(stack[0])
			if err != nil {
				websocketWriteError(p, stack, err)
				return
			}
			var req WebSocketConnectRequest
			if err := json.Unmarshal(reqBytes, &req); err != nil {
				websocketWriteError(p, stack, err)
				return
			}

			// Call the service method
			newconnectionid, svcErr := service.Connect(ctx, req.Url, req.Headers, req.ConnectionID)
			if svcErr != nil {
				websocketWriteError(p, stack, svcErr)
				return
			}

			// Write JSON response to plugin memory
			resp := WebSocketConnectResponse{
				NewConnectionID: newconnectionid,
			}
			websocketWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

func newWebSocketSendTextHostFunction(service WebSocketService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"websocket_sendtext",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {
			// Read JSON request from plugin memory
			reqBytes, err := p.ReadBytes(stack[0])
			if err != nil {
				websocketWriteError(p, stack, err)
				return
			}
			var req WebSocketSendTextRequest
			if err := json.Unmarshal(reqBytes, &req); err != nil {
				websocketWriteError(p, stack, err)
				return
			}

			// Call the service method
			if svcErr := service.SendText(ctx, req.ConnectionID, req.Message); svcErr != nil {
				websocketWriteError(p, stack, svcErr)
				return
			}

			// Write JSON response to plugin memory
			resp := WebSocketSendTextResponse{}
			websocketWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

func newWebSocketSendBinaryHostFunction(service WebSocketService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"websocket_sendbinary",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {
			// Read JSON request from plugin memory
			reqBytes, err := p.ReadBytes(stack[0])
			if err != nil {
				websocketWriteError(p, stack, err)
				return
			}
			var req WebSocketSendBinaryRequest
			if err := json.Unmarshal(reqBytes, &req); err != nil {
				websocketWriteError(p, stack, err)
				return
			}

			// Call the service method
			if svcErr := service.SendBinary(ctx, req.ConnectionID, req.Data); svcErr != nil {
				websocketWriteError(p, stack, svcErr)
				return
			}

			// Write JSON response to plugin memory
			resp := WebSocketSendBinaryResponse{}
			websocketWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

func newWebSocketCloseConnectionHostFunction(service WebSocketService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"websocket_closeconnection",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {
			// Read JSON request from plugin memory
			reqBytes, err := p.ReadBytes(stack[0])
			if err != nil {
				websocketWriteError(p, stack, err)
				return
			}
			var req WebSocketCloseConnectionRequest
			if err := json.Unmarshal(reqBytes, &req); err != nil {
				websocketWriteError(p, stack, err)
				return
			}

			// Call the service method
			if svcErr := service.CloseConnection(ctx, req.ConnectionID, req.Code, req.Reason); svcErr != nil {
				websocketWriteError(p, stack, svcErr)
				return
			}

			// Write JSON response to plugin memory
			resp := WebSocketCloseConnectionResponse{}
			websocketWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

// websocketWriteResponse writes a JSON response to plugin memory.
func websocketWriteResponse(p *extism.CurrentPlugin, stack []uint64, resp any) {
	respBytes, err := json.Marshal(resp)
	if err != nil {
		websocketWriteError(p, stack, err)
		return
	}
	respPtr, err := p.WriteBytes(respBytes)
	if err != nil {
		stack[0] = 0
		return
	}
	stack[0] = respPtr
}

// websocketWriteError writes an error response to plugin memory.
func websocketWriteError(p *extism.CurrentPlugin, stack []uint64, err error) {
	errResp := struct {
		Error string `json:"error"`
	}{Error: err.Error()}
	respBytes, _ := json.Marshal(errResp)
	respPtr, _ := p.WriteBytes(respBytes)
	stack[0] = respPtr
}
