/*
** Odin 2 Synthesizer Plugin
** Copyright (C) 2020 - 2021 TheWaveWarden
**
** Odin 2 is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** Odin 2 is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
*/

#include "WavetableData.h"

const float wavetable_data[NUMBER_OF_WAVETABLES][SUBTABLES_PER_WAVETABLE][WAVETABLE_LENGTH] = {
    {{0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966976,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983105,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983105,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966976,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966976,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983105,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983105,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966976,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715}},
    {{0,           0.00034862,  -0.00072432,  0.0011615,   -0.0017138,   0.00247955,   -0.00367616,
      0.00590469,  -0.0116439,  0.0550661,    0.168803,    0.148306,     0.161136,     0.151624,
      0.159266,    0.152838,    0.158402,     0.153495,    0.157873,     0.153945,     0.157467,
      0.15434,     0.157047,    0.154842,     0.156349,    0.156033,     0.153529,     0.170828,
      0.30416,     0.303411,    0.307996,     0.30323,     0.307919,     0.303307,     0.307878,
      0.303305,    0.307924,    0.303212,     0.308072,    0.302995,     0.308381,     0.302554,
      0.30903,     0.301542,    0.310764,     0.298386,    0.413989,     0.450499,     0.441114,
      0.445431,    0.443301,    0.444172,     0.444158,    0.443515,     0.444714,     0.443,
      0.445231,    0.44244,     0.445883,     0.441622,    0.446998,     0.439934,     0.449978,
      0.432921,    0.505579,    0.577879,     0.561179,    0.57087,      0.564152,     0.569192,
      0.565253,    0.568392,    0.565882,     0.567862,    0.56636,      0.5674,       0.566844,
      0.566846,    0.567546,    0.565838,     0.569266,    0.561899,     0.590216,     0.679203,
      0.669862,    0.676746,    0.671221,     0.675945,    0.671742,     0.675584,     0.672001,
      0.675397,    0.672136,    0.675303,     0.672194,    0.675278,     0.672189,     0.67531,
      0.672153,    0.675178,    0.67469,      0.762475,    0.773884,     0.772217,     0.772024,
      0.773008,    0.771551,    0.77336,      0.771243,    0.773664,     0.770914,     0.774048,
      0.770442,    0.774659,    0.769609,     0.77587,     0.767685,     0.779372,     0.759425,
      0.881513,    0.957609,    0.935247,     0.949102,    0.938736,     0.947259,     0.939822,
      0.946598,    0.940206,    0.946421,     0.940206,    0.946598,     0.939822,     0.947259,
      0.938736,    0.949102,    0.935247,     0.957609,    0.881513,     0.759425,     0.779372,
      0.767685,    0.77587,     0.769609,     0.774659,    0.770442,     0.774048,     0.770914,
      0.773664,    0.771243,    0.77336,      0.771551,    0.773008,     0.772024,     0.772217,
      0.773884,    0.762475,    0.67469,      0.675178,    0.672153,     0.67531,      0.672189,
      0.675278,    0.672194,    0.675303,     0.672136,    0.675397,     0.672001,     0.675584,
      0.671742,    0.675945,    0.671221,     0.676746,    0.669862,     0.679203,     0.590216,
      0.561899,    0.569266,    0.565838,     0.567546,    0.566846,     0.566844,     0.5674,
      0.56636,     0.567862,    0.565882,     0.568392,    0.565253,     0.569192,     0.564152,
      0.57087,     0.561179,    0.577879,     0.505579,    0.432921,     0.449978,     0.439934,
      0.446998,    0.441622,    0.445883,     0.44244,     0.445231,     0.443,        0.444714,
      0.443515,    0.444158,    0.444172,     0.443301,    0.445431,     0.441114,     0.450499,
      0.413989,    0.298386,    0.310764,     0.301542,    0.30903,      0.302554,     0.308381,
      0.302995,    0.308072,    0.303212,     0.307924,    0.303305,     0.307878,     0.303307,
      0.307919,    0.30323,     0.307996,     0.303411,    0.30416,      0.170828,     0.153529,
      0.156033,    0.156349,    0.154842,     0.157047,    0.15434,      0.157467,     0.153945,
      0.157873,    0.153495,    0.158402,     0.152838,    0.159266,     0.151624,     0.161136,
      0.148306,    0.168803,    0.0550661,    -0.0116439,  0.00590469,   -0.00367616,  0.00247954,
      -0.0017138,  0.00116148,  -0.000724329, 0.000348621, -5.42093e-16, -0.000348621, 0.000724329,
      -0.00116148, 0.0017138,   -0.00247954,  0.00367616,  -0.00590469,  0.0116439,    -0.0550661,
      -0.168803,   -0.148306,   -0.161136,    -0.151624,   -0.159266,    -0.152838,    -0.158402,
      -0.153495,   -0.157873,   -0.153945,    -0.157467,   -0.15434,     -0.157047,    -0.154842,
      -0.156349,   -0.156033,   -0.153529,    -0.170828,   -0.30416,     -0.303411,    -0.307996,
      -0.30323,    -0.307919,   -0.303307,    -0.307878,   -0.303305,    -0.307924,    -0.303212,
      -0.308072,   -0.302995,   -0.308381,    -0.302554,   -0.30903,     -0.301542,    -0.310764,
      -0.298386,   -0.413989,   -0.450499,    -0.441114,   -0.445431,    -0.443301,    -0.444172,
      -0.444158,   -0.443515,   -0.444714,    -0.443,      -0.445231,    -0.44244,     -0.445883,
      -0.441622,   -0.446998,   -0.439934,    -0.449978,   -0.432921,    -0.505579,    -0.577879,
      -0.561179,   -0.57087,    -0.564152,    -0.569192,   -0.565253,    -0.568392,    -0.565882,
      -0.567862,   -0.56636,    -0.5674,      -0.566844,   -0.566846,    -0.567546,    -0.565838,
      -0.569266,   -0.561899,   -0.590216,    -0.679203,   -0.669862,    -0.676746,    -0.671221,
      -0.675945,   -0.671742,   -0.675584,    -0.672001,   -0.675397,    -0.672136,    -0.675303,
      -0.672194,   -0.675278,   -0.672189,    -0.67531,    -0.672153,    -0.675178,    -0.67469,
      -0.762475,   -0.773884,   -0.772217,    -0.772024,   -0.773008,    -0.771551,    -0.77336,
      -0.771243,   -0.773664,   -0.770914,    -0.774048,   -0.770442,    -0.774659,    -0.769609,
      -0.77587,    -0.767685,   -0.779372,    -0.759425,   -0.881513,    -0.957609,    -0.935247,
      -0.949102,   -0.938736,   -0.947259,    -0.939822,   -0.946598,    -0.940206,    -0.946421,
      -0.940206,   -0.946598,   -0.939822,    -0.947259,   -0.938736,    -0.949102,    -0.935247,
      -0.957609,   -0.881513,   -0.759425,    -0.779372,   -0.767685,    -0.77587,     -0.769609,
      -0.774659,   -0.770442,   -0.774048,    -0.770914,   -0.773664,    -0.771243,    -0.77336,
      -0.771551,   -0.773008,   -0.772024,    -0.772217,   -0.773884,    -0.762475,    -0.67469,
      -0.675178,   -0.672153,   -0.67531,     -0.672189,   -0.675278,    -0.672194,    -0.675303,
      -0.672136,   -0.675397,   -0.672001,    -0.675584,   -0.671742,    -0.675945,    -0.671221,
      -0.676746,   -0.669862,   -0.679203,    -0.590216,   -0.561899,    -0.569266,    -0.565838,
      -0.567546,   -0.566846,   -0.566844,    -0.5674,     -0.56636,     -0.567862,    -0.565882,
      -0.568392,   -0.565253,   -0.569192,    -0.564152,   -0.57087,     -0.561179,    -0.577879,
      -0.505579,   -0.432921,   -0.449978,    -0.439934,   -0.446998,    -0.441622,    -0.445883,
      -0.44244,    -0.445231,   -0.443,       -0.444714,   -0.443515,    -0.444158,    -0.444172,
      -0.443301,   -0.445431,   -0.441114,    -0.450499,   -0.413989,    -0.298386,    -0.310764,
      -0.301542,   -0.30903,    -0.302554,    -0.308381,   -0.302995,    -0.308072,    -0.303212,
      -0.307924,   -0.303305,   -0.307878,    -0.303307,   -0.307919,    -0.30323,     -0.307996,
      -0.303411,   -0.30416,    -0.170828,    -0.153529,   -0.156033,    -0.156349,    -0.154842,
      -0.157047,   -0.15434,    -0.157467,    -0.153945,   -0.157873,    -0.153495,    -0.158402,
      -0.152838,   -0.159266,   -0.151624,    -0.161136,   -0.148306,    -0.168803,    -0.0550661,
      0.0116439,   -0.00590469, 0.00367616,   -0.00247955, 0.0017138,    -0.0011615,   0.00072432,
      -0.00034862},
     {0,           0.00034862,  -0.00072432,  0.0011615,   -0.0017138,   0.00247955,   -0.00367616,
      0.00590469,  -0.0116439,  0.0550661,    0.168803,    0.148306,     0.161136,     0.151624,
      0.159266,    0.152838,    0.158402,     0.153495,    0.157873,     0.153945,     0.157467,
      0.15434,     0.157047,    0.154842,     0.156349,    0.156033,     0.153529,     0.170828,
      0.30416,     0.303411,    0.307996,     0.30323,     0.307919,     0.303307,     0.307878,
      0.303305,    0.307924,    0.303212,     0.308072,    0.302995,     0.308381,     0.302554,
      0.30903,     0.301542,    0.310764,     0.298386,    0.413989,     0.450499,     0.441114,
      0.445431,    0.443301,    0.444172,     0.444158,    0.443515,     0.444714,     0.443,
      0.445231,    0.44244,     0.445883,     0.441622,    0.446998,     0.439934,     0.449978,
      0.432921,    0.505579,    0.577879,     0.561179,    0.57087,      0.564152,     0.569192,
      0.565253,    0.568392,    0.565882,     0.567862,    0.56636,      0.5674,       0.566844,
      0.566846,    0.567546,    0.565838,     0.569266,    0.561899,     0.590216,     0.679203,
      0.669862,    0.676746,    0.671221,     0.675945,    0.671742,     0.675584,     0.672001,
      0.675397,    0.672136,    0.675303,     0.672194,    0.675278,     0.672189,     0.67531,
      0.672153,    0.675178,    0.67469,      0.762475,    0.773884,     0.772217,     0.772024,
      0.773008,    0.771551,    0.77336,      0.771243,    0.773664,     0.770914,     0.774048,
      0.770442,    0.774659,    0.769609,     0.77587,     0.767685,     0.779372,     0.759425,
      0.881513,    0.957609,    0.935247,     0.949102,    0.938736,     0.947259,     0.939822,
      0.946598,    0.940206,    0.946421,     0.940206,    0.946598,     0.939822,     0.947259,
      0.938736,    0.949102,    0.935247,     0.957609,    0.881513,     0.759425,     0.779372,
      0.767685,    0.77587,     0.769609,     0.774659,    0.770442,     0.774048,     0.770914,
      0.773664,    0.771243,    0.77336,      0.771551,    0.773008,     0.772024,     0.772217,
      0.773884,    0.762475,    0.67469,      0.675178,    0.672153,     0.67531,      0.672189,
      0.675278,    0.672194,    0.675303,     0.672136,    0.675397,     0.672001,     0.675584,
      0.671742,    0.675945,    0.671221,     0.676746,    0.669862,     0.679203,     0.590216,
      0.561899,    0.569266,    0.565838,     0.567546,    0.566846,     0.566844,     0.5674,
      0.56636,     0.567862,    0.565882,     0.568392,    0.565253,     0.569192,     0.564152,
      0.57087,     0.561179,    0.577879,     0.505579,    0.432921,     0.449978,     0.439934,
      0.446998,    0.441622,    0.445883,     0.44244,     0.445231,     0.443,        0.444714,
      0.443515,    0.444158,    0.444172,     0.443301,    0.445431,     0.441114,     0.450499,
      0.413989,    0.298386,    0.310764,     0.301542,    0.30903,      0.302554,     0.308381,
      0.302995,    0.308072,    0.303212,     0.307924,    0.303305,     0.307878,     0.303307,
      0.307919,    0.30323,     0.307996,     0.303411,    0.30416,      0.170828,     0.153529,
      0.156033,    0.156349,    0.154842,     0.157047,    0.15434,      0.157467,     0.153945,
      0.157873,    0.153495,    0.158402,     0.152838,    0.159266,     0.151624,     0.161136,
      0.148306,    0.168803,    0.0550661,    -0.0116439,  0.00590469,   -0.00367616,  0.00247954,
      -0.0017138,  0.00116148,  -0.000724329, 0.000348621, -5.42093e-16, -0.000348621, 0.000724329,
      -0.00116148, 0.0017138,   -0.00247954,  0.00367616,  -0.00590469,  0.0116439,    -0.0550661,
      -0.168803,   -0.148306,   -0.161136,    -0.151624,   -0.159266,    -0.152838,    -0.158402,
      -0.153495,   -0.157873,   -0.153945,    -0.157467,   -0.15434,     -0.157047,    -0.154842,
      -0.156349,   -0.156033,   -0.153529,    -0.170828,   -0.30416,     -0.303411,    -0.307996,
      -0.30323,    -0.307919,   -0.303307,    -0.307878,   -0.303305,    -0.307924,    -0.303212,
      -0.308072,   -0.302995,   -0.308381,    -0.302554,   -0.30903,     -0.301542,    -0.310764,
      -0.298386,   -0.413989,   -0.450499,    -0.441114,   -0.445431,    -0.443301,    -0.444172,
      -0.444158,   -0.443515,   -0.444714,    -0.443,      -0.445231,    -0.44244,     -0.445883,
      -0.441622,   -0.446998,   -0.439934,    -0.449978,   -0.432921,    -0.505579,    -0.577879,
      -0.561179,   -0.57087,    -0.564152,    -0.569192,   -0.565253,    -0.568392,    -0.565882,
      -0.567862,   -0.56636,    -0.5674,      -0.566844,   -0.566846,    -0.567546,    -0.565838,
      -0.569266,   -0.561899,   -0.590216,    -0.679203,   -0.669862,    -0.676746,    -0.671221,
      -0.675945,   -0.671742,   -0.675584,    -0.672001,   -0.675397,    -0.672136,    -0.675303,
      -0.672194,   -0.675278,   -0.672189,    -0.67531,    -0.672153,    -0.675178,    -0.67469,
      -0.762475,   -0.773884,   -0.772217,    -0.772024,   -0.773008,    -0.771551,    -0.77336,
      -0.771243,   -0.773664,   -0.770914,    -0.774048,   -0.770442,    -0.774659,    -0.769609,
      -0.77587,    -0.767685,   -0.779372,    -0.759425,   -0.881513,    -0.957609,    -0.935247,
      -0.949102,   -0.938736,   -0.947259,    -0.939822,   -0.946598,    -0.940206,    -0.946421,
      -0.940206,   -0.946598,   -0.939822,    -0.947259,   -0.938736,    -0.949102,    -0.935247,
      -0.957609,   -0.881513,   -0.759425,    -0.779372,   -0.767685,    -0.77587,     -0.769609,
      -0.774659,   -0.770442,   -0.774048,    -0.770914,   -0.773664,    -0.771243,    -0.77336,
      -0.771551,   -0.773008,   -0.772024,    -0.772217,   -0.773884,    -0.762475,    -0.67469,
      -0.675178,   -0.672153,   -0.67531,     -0.672189,   -0.675278,    -0.672194,    -0.675303,
      -0.672136,   -0.675397,   -0.672001,    -0.675584,   -0.671742,    -0.675945,    -0.671221,
      -0.676746,   -0.669862,   -0.679203,    -0.590216,   -0.561899,    -0.569266,    -0.565838,
      -0.567546,   -0.566846,   -0.566844,    -0.5674,     -0.56636,     -0.567862,    -0.565882,
      -0.568392,   -0.565253,   -0.569192,    -0.564152,   -0.57087,     -0.561179,    -0.577879,
      -0.505579,   -0.432921,   -0.449978,    -0.439934,   -0.446998,    -0.441622,    -0.445883,
      -0.44244,    -0.445231,   -0.443,       -0.444714,   -0.443515,    -0.444158,    -0.444172,
      -0.443301,   -0.445431,   -0.441114,    -0.450499,   -0.413989,    -0.298386,    -0.310764,
      -0.301542,   -0.30903,    -0.302554,    -0.308381,   -0.302995,    -0.308072,    -0.303212,
      -0.307924,   -0.303305,   -0.307878,    -0.303307,   -0.307919,    -0.30323,     -0.307996,
      -0.303411,   -0.30416,    -0.170828,    -0.153529,   -0.156033,    -0.156349,    -0.154842,
      -0.157047,   -0.15434,    -0.157467,    -0.153945,   -0.157873,    -0.153495,    -0.158402,
      -0.152838,   -0.159266,   -0.151624,    -0.161136,   -0.148306,    -0.168803,    -0.0550661,
      0.0116439,   -0.00590469, 0.00367616,   -0.00247955, 0.0017138,    -0.0011615,   0.00072432,
      -0.00034862},
     {0,           0.00034862,  -0.00072432,  0.0011615,   -0.0017138,   0.00247955,   -0.00367616,
      0.00590469,  -0.0116439,  0.0550661,    0.168803,    0.148306,     0.161136,     0.151624,
      0.159266,    0.152838,    0.158402,     0.153495,    0.157873,     0.153945,     0.157467,
      0.15434,     0.157047,    0.154842,     0.156349,    0.156033,     0.153529,     0.170828,
      0.30416,     0.303411,    0.307996,     0.30323,     0.307919,     0.303307,     0.307878,
      0.303305,    0.307924,    0.303212,     0.308072,    0.302995,     0.308381,     0.302554,
      0.30903,     0.301542,    0.310764,     0.298386,    0.413989,     0.450499,     0.441114,
      0.445431,    0.443301,    0.444172,     0.444158,    0.443515,     0.444714,     0.443,
      0.445231,    0.44244,     0.445883,     0.441622,    0.446998,     0.439934,     0.449978,
      0.432921,    0.505579,    0.577879,     0.561179,    0.57087,      0.564152,     0.569192,
      0.565253,    0.568392,    0.565882,     0.567862,    0.56636,      0.5674,       0.566844,
      0.566846,    0.567546,    0.565838,     0.569266,    0.561899,     0.590216,     0.679203,
      0.669862,    0.676746,    0.671221,     0.675945,    0.671742,     0.675584,     0.672001,
      0.675397,    0.672136,    0.675303,     0.672194,    0.675278,     0.672189,     0.67531,
      0.672153,    0.675178,    0.67469,      0.762475,    0.773884,     0.772217,     0.772024,
      0.773008,    0.771551,    0.77336,      0.771243,    0.773664,     0.770914,     0.774048,
      0.770442,    0.774659,    0.769609,     0.77587,     0.767685,     0.779372,     0.759425,
      0.881513,    0.957609,    0.935247,     0.949102,    0.938736,     0.947259,     0.939822,
      0.946598,    0.940206,    0.946421,     0.940206,    0.946598,     0.939822,     0.947259,
      0.938736,    0.949102,    0.935247,     0.957609,    0.881513,     0.759425,     0.779372,
      0.767685,    0.77587,     0.769609,     0.774659,    0.770442,     0.774048,     0.770914,
      0.773664,    0.771243,    0.77336,      0.771551,    0.773008,     0.772024,     0.772217,
      0.773884,    0.762475,    0.67469,      0.675178,    0.672153,     0.67531,      0.672189,
      0.675278,    0.672194,    0.675303,     0.672136,    0.675397,     0.672001,     0.675584,
      0.671742,    0.675945,    0.671221,     0.676746,    0.669862,     0.679203,     0.590216,
      0.561899,    0.569266,    0.565838,     0.567546,    0.566846,     0.566844,     0.5674,
      0.56636,     0.567862,    0.565882,     0.568392,    0.565253,     0.569192,     0.564152,
      0.57087,     0.561179,    0.577879,     0.505579,    0.432921,     0.449978,     0.439934,
      0.446998,    0.441622,    0.445883,     0.44244,     0.445231,     0.443,        0.444714,
      0.443515,    0.444158,    0.444172,     0.443301,    0.445431,     0.441114,     0.450499,
      0.413989,    0.298386,    0.310764,     0.301542,    0.30903,      0.302554,     0.308381,
      0.302995,    0.308072,    0.303212,     0.307924,    0.303305,     0.307878,     0.303307,
      0.307919,    0.30323,     0.307996,     0.303411,    0.30416,      0.170828,     0.153529,
      0.156033,    0.156349,    0.154842,     0.157047,    0.15434,      0.157467,     0.153945,
      0.157873,    0.153495,    0.158402,     0.152838,    0.159266,     0.151624,     0.161136,
      0.148306,    0.168803,    0.0550661,    -0.0116439,  0.00590469,   -0.00367616,  0.00247954,
      -0.0017138,  0.00116148,  -0.000724329, 0.000348621, -5.42093e-16, -0.000348621, 0.000724329,
      -0.00116148, 0.0017138,   -0.00247954,  0.00367616,  -0.00590469,  0.0116439,    -0.0550661,
      -0.168803,   -0.148306,   -0.161136,    -0.151624,   -0.159266,    -0.152838,    -0.158402,
      -0.153495,   -0.157873,   -0.153945,    -0.157467,   -0.15434,     -0.157047,    -0.154842,
      -0.156349,   -0.156033,   -0.153529,    -0.170828,   -0.30416,     -0.303411,    -0.307996,
      -0.30323,    -0.307919,   -0.303307,    -0.307878,   -0.303305,    -0.307924,    -0.303212,
      -0.308072,   -0.302995,   -0.308381,    -0.302554,   -0.30903,     -0.301542,    -0.310764,
      -0.298386,   -0.413989,   -0.450499,    -0.441114,   -0.445431,    -0.443301,    -0.444172,
      -0.444158,   -0.443515,   -0.444714,    -0.443,      -0.445231,    -0.44244,     -0.445883,
      -0.441622,   -0.446998,   -0.439934,    -0.449978,   -0.432921,    -0.505579,    -0.577879,
      -0.561179,   -0.57087,    -0.564152,    -0.569192,   -0.565253,    -0.568392,    -0.565882,
      -0.567862,   -0.56636,    -0.5674,      -0.566844,   -0.566846,    -0.567546,    -0.565838,
      -0.569266,   -0.561899,   -0.590216,    -0.679203,   -0.669862,    -0.676746,    -0.671221,
      -0.675945,   -0.671742,   -0.675584,    -0.672001,   -0.675397,    -0.672136,    -0.675303,
      -0.672194,   -0.675278,   -0.672189,    -0.67531,    -0.672153,    -0.675178,    -0.67469,
      -0.762475,   -0.773884,   -0.772217,    -0.772024,   -0.773008,    -0.771551,    -0.77336,
      -0.771243,   -0.773664,   -0.770914,    -0.774048,   -0.770442,    -0.774659,    -0.769609,
      -0.77587,    -0.767685,   -0.779372,    -0.759425,   -0.881513,    -0.957609,    -0.935247,
      -0.949102,   -0.938736,   -0.947259,    -0.939822,   -0.946598,    -0.940206,    -0.946421,
      -0.940206,   -0.946598,   -0.939822,    -0.947259,   -0.938736,    -0.949102,    -0.935247,
      -0.957609,   -0.881513,   -0.759425,    -0.779372,   -0.767685,    -0.77587,     -0.769609,
      -0.774659,   -0.770442,   -0.774048,    -0.770914,   -0.773664,    -0.771243,    -0.77336,
      -0.771551,   -0.773008,   -0.772024,    -0.772217,   -0.773884,    -0.762475,    -0.67469,
      -0.675178,   -0.672153,   -0.67531,     -0.672189,   -0.675278,    -0.672194,    -0.675303,
      -0.672136,   -0.675397,   -0.672001,    -0.675584,   -0.671742,    -0.675945,    -0.671221,
      -0.676746,   -0.669862,   -0.679203,    -0.590216,   -0.561899,    -0.569266,    -0.565838,
      -0.567546,   -0.566846,   -0.566844,    -0.5674,     -0.56636,     -0.567862,    -0.565882,
      -0.568392,   -0.565253,   -0.569192,    -0.564152,   -0.57087,     -0.561179,    -0.577879,
      -0.505579,   -0.432921,   -0.449978,    -0.439934,   -0.446998,    -0.441622,    -0.445883,
      -0.44244,    -0.445231,   -0.443,       -0.444714,   -0.443515,    -0.444158,    -0.444172,
      -0.443301,   -0.445431,   -0.441114,    -0.450499,   -0.413989,    -0.298386,    -0.310764,
      -0.301542,   -0.30903,    -0.302554,    -0.308381,   -0.302995,    -0.308072,    -0.303212,
      -0.307924,   -0.303305,   -0.307878,    -0.303307,   -0.307919,    -0.30323,     -0.307996,
      -0.303411,   -0.30416,    -0.170828,    -0.153529,   -0.156033,    -0.156349,    -0.154842,
      -0.157047,   -0.15434,    -0.157467,    -0.153945,   -0.157873,    -0.153495,    -0.158402,
      -0.152838,   -0.159266,   -0.151624,    -0.161136,   -0.148306,    -0.168803,    -0.0550661,
      0.0116439,   -0.00590469, 0.00367616,   -0.00247955, 0.0017138,    -0.0011615,   0.00072432,
      -0.00034862},
     {0,           0.00034862,  -0.00072432,  0.0011615,   -0.0017138,   0.00247955,   -0.00367616,
      0.00590469,  -0.0116439,  0.0550661,    0.168803,    0.148306,     0.161136,     0.151624,
      0.159266,    0.152838,    0.158402,     0.153495,    0.157873,     0.153945,     0.157467,
      0.15434,     0.157047,    0.154842,     0.156349,    0.156033,     0.153529,     0.170828,
      0.30416,     0.303411,    0.307996,     0.30323,     0.307919,     0.303307,     0.307878,
      0.303305,    0.307924,    0.303212,     0.308072,    0.302995,     0.308381,     0.302554,
      0.30903,     0.301542,    0.310764,     0.298386,    0.413989,     0.450499,     0.441114,
      0.445431,    0.443301,    0.444172,     0.444158,    0.443515,     0.444714,     0.443,
      0.445231,    0.44244,     0.445883,     0.441622,    0.446998,     0.439934,     0.449978,
      0.432921,    0.505579,    0.577879,     0.561179,    0.57087,      0.564152,     0.569192,
      0.565253,    0.568392,    0.565882,     0.567862,    0.56636,      0.5674,       0.566844,
      0.566846,    0.567546,    0.565838,     0.569266,    0.561899,     0.590216,     0.679203,
      0.669862,    0.676746,    0.671221,     0.675945,    0.671742,     0.675584,     0.672001,
      0.675397,    0.672136,    0.675303,     0.672194,    0.675278,     0.672189,     0.67531,
      0.672153,    0.675178,    0.67469,      0.762475,    0.773884,     0.772217,     0.772024,
      0.773008,    0.771551,    0.77336,      0.771243,    0.773664,     0.770914,     0.774048,
      0.770442,    0.774659,    0.769609,     0.77587,     0.767685,     0.779372,     0.759425,
      0.881513,    0.957609,    0.935247,     0.949102,    0.938736,     0.947259,     0.939822,
      0.946598,    0.940206,    0.946421,     0.940206,    0.946598,     0.939822,     0.947259,
      0.938736,    0.949102,    0.935247,     0.957609,    0.881513,     0.759425,     0.779372,
      0.767685,    0.77587,     0.769609,     0.774659,    0.770442,     0.774048,     0.770914,
      0.773664,    0.771243,    0.77336,      0.771551,    0.773008,     0.772024,     0.772217,
      0.773884,    0.762475,    0.67469,      0.675178,    0.672153,     0.67531,      0.672189,
      0.675278,    0.672194,    0.675303,     0.672136,    0.675397,     0.672001,     0.675584,
      0.671742,    0.675945,    0.671221,     0.676746,    0.669862,     0.679203,     0.590216,
      0.561899,    0.569266,    0.565838,     0.567546,    0.566846,     0.566844,     0.5674,
      0.56636,     0.567862,    0.565882,     0.568392,    0.565253,     0.569192,     0.564152,
      0.57087,     0.561179,    0.577879,     0.505579,    0.432921,     0.449978,     0.439934,
      0.446998,    0.441622,    0.445883,     0.44244,     0.445231,     0.443,        0.444714,
      0.443515,    0.444158,    0.444172,     0.443301,    0.445431,     0.441114,     0.450499,
      0.413989,    0.298386,    0.310764,     0.301542,    0.30903,      0.302554,     0.308381,
      0.302995,    0.308072,    0.303212,     0.307924,    0.303305,     0.307878,     0.303307,
      0.307919,    0.30323,     0.307996,     0.303411,    0.30416,      0.170828,     0.153529,
      0.156033,    0.156349,    0.154842,     0.157047,    0.15434,      0.157467,     0.153945,
      0.157873,    0.153495,    0.158402,     0.152838,    0.159266,     0.151624,     0.161136,
      0.148306,    0.168803,    0.0550661,    -0.0116439,  0.00590469,   -0.00367616,  0.00247954,
      -0.0017138,  0.00116148,  -0.000724329, 0.000348621, -5.42093e-16, -0.000348621, 0.000724329,
      -0.00116148, 0.0017138,   -0.00247954,  0.00367616,  -0.00590469,  0.0116439,    -0.0550661,
      -0.168803,   -0.148306,   -0.161136,    -0.151624,   -0.159266,    -0.152838,    -0.158402,
      -0.153495,   -0.157873,   -0.153945,    -0.157467,   -0.15434,     -0.157047,    -0.154842,
      -0.156349,   -0.156033,   -0.153529,    -0.170828,   -0.30416,     -0.303411,    -0.307996,
      -0.30323,    -0.307919,   -0.303307,    -0.307878,   -0.303305,    -0.307924,    -0.303212,
      -0.308072,   -0.302995,   -0.308381,    -0.302554,   -0.30903,     -0.301542,    -0.310764,
      -0.298386,   -0.413989,   -0.450499,    -0.441114,   -0.445431,    -0.443301,    -0.444172,
      -0.444158,   -0.443515,   -0.444714,    -0.443,      -0.445231,    -0.44244,     -0.445883,
      -0.441622,   -0.446998,   -0.439934,    -0.449978,   -0.432921,    -0.505579,    -0.577879,
      -0.561179,   -0.57087,    -0.564152,    -0.569192,   -0.565253,    -0.568392,    -0.565882,
      -0.567862,   -0.56636,    -0.5674,      -0.566844,   -0.566846,    -0.567546,    -0.565838,
      -0.569266,   -0.561899,   -0.590216,    -0.679203,   -0.669862,    -0.676746,    -0.671221,
      -0.675945,   -0.671742,   -0.675584,    -0.672001,   -0.675397,    -0.672136,    -0.675303,
      -0.672194,   -0.675278,   -0.672189,    -0.67531,    -0.672153,    -0.675178,    -0.67469,
      -0.762475,   -0.773884,   -0.772217,    -0.772024,   -0.773008,    -0.771551,    -0.77336,
      -0.771243,   -0.773664,   -0.770914,    -0.774048,   -0.770442,    -0.774659,    -0.769609,
      -0.77587,    -0.767685,   -0.779372,    -0.759425,   -0.881513,    -0.957609,    -0.935247,
      -0.949102,   -0.938736,   -0.947259,    -0.939822,   -0.946598,    -0.940206,    -0.946421,
      -0.940206,   -0.946598,   -0.939822,    -0.947259,   -0.938736,    -0.949102,    -0.935247,
      -0.957609,   -0.881513,   -0.759425,    -0.779372,   -0.767685,    -0.77587,     -0.769609,
      -0.774659,   -0.770442,   -0.774048,    -0.770914,   -0.773664,    -0.771243,    -0.77336,
      -0.771551,   -0.773008,   -0.772024,    -0.772217,   -0.773884,    -0.762475,    -0.67469,
      -0.675178,   -0.672153,   -0.67531,     -0.672189,   -0.675278,    -0.672194,    -0.675303,
      -0.672136,   -0.675397,   -0.672001,    -0.675584,   -0.671742,    -0.675945,    -0.671221,
      -0.676746,   -0.669862,   -0.679203,    -0.590216,   -0.561899,    -0.569266,    -0.565838,
      -0.567546,   -0.566846,   -0.566844,    -0.5674,     -0.56636,     -0.567862,    -0.565882,
      -0.568392,   -0.565253,   -0.569192,    -0.564152,   -0.57087,     -0.561179,    -0.577879,
      -0.505579,   -0.432921,   -0.449978,    -0.439934,   -0.446998,    -0.441622,    -0.445883,
      -0.44244,    -0.445231,   -0.443,       -0.444714,   -0.443515,    -0.444158,    -0.444172,
      -0.443301,   -0.445431,   -0.441114,    -0.450499,   -0.413989,    -0.298386,    -0.310764,
      -0.301542,   -0.30903,    -0.302554,    -0.308381,   -0.302995,    -0.308072,    -0.303212,
      -0.307924,   -0.303305,   -0.307878,    -0.303307,   -0.307919,    -0.30323,     -0.307996,
      -0.303411,   -0.30416,    -0.170828,    -0.153529,   -0.156033,    -0.156349,    -0.154842,
      -0.157047,   -0.15434,    -0.157467,    -0.153945,   -0.157873,    -0.153495,    -0.158402,
      -0.152838,   -0.159266,   -0.151624,    -0.161136,   -0.148306,    -0.168803,    -0.0550661,
      0.0116439,   -0.00590469, 0.00367616,   -0.00247955, 0.0017138,    -0.0011615,   0.00072432,
      -0.00034862},
     {0,           0.00034862,  -0.00072432,  0.0011615,   -0.0017138,   0.00247955,   -0.00367616,
      0.00590469,  -0.0116439,  0.0550661,    0.168803,    0.148306,     0.161136,     0.151624,
      0.159266,    0.152838,    0.158402,     0.153495,    0.157873,     0.153945,     0.157467,
      0.15434,     0.157047,    0.154842,     0.156349,    0.156033,     0.153529,     0.170828,
      0.30416,     0.303411,    0.307996,     0.30323,     0.307919,     0.303307,     0.307878,
      0.303305,    0.307924,    0.303212,     0.308072,    0.302995,     0.308381,     0.302554,
      0.30903,     0.301542,    0.310764,     0.298386,    0.413989,     0.450499,     0.441114,
      0.445431,    0.443301,    0.444172,     0.444158,    0.443515,     0.444714,     0.443,
      0.445231,    0.44244,     0.445883,     0.441622,    0.446998,     0.439934,     0.449978,
      0.432921,    0.505579,    0.577879,     0.561179,    0.57087,      0.564152,     0.569192,
      0.565253,    0.568392,    0.565882,     0.567862,    0.56636,      0.5674,       0.566844,
      0.566846,    0.567546,    0.565838,     0.569266,    0.561899,     0.590216,     0.679203,
      0.669862,    0.676746,    0.671221,     0.675945,    0.671742,     0.675584,     0.672001,
      0.675397,    0.672136,    0.675303,     0.672194,    0.675278,     0.672189,     0.67531,
      0.672153,    0.675178,    0.67469,      0.762475,    0.773884,     0.772217,     0.772024,
      0.773008,    0.771551,    0.77336,      0.771243,    0.773664,     0.770914,     0.774048,
      0.770442,    0.774659,    0.769609,     0.77587,     0.767685,     0.779372,     0.759425,
      0.881513,    0.957609,    0.935247,     0.949102,    0.938736,     0.947259,     0.939822,
      0.946598,    0.940206,    0.946421,     0.940206,    0.946598,     0.939822,     0.947259,
      0.938736,    0.949102,    0.935247,     0.957609,    0.881513,     0.759425,     0.779372,
      0.767685,    0.77587,     0.769609,     0.774659,    0.770442,     0.774048,     0.770914,
      0.773664,    0.771243,    0.77336,      0.771551,    0.773008,     0.772024,     0.772217,
      0.773884,    0.762475,    0.67469,      0.675178,    0.672153,     0.67531,      0.672189,
      0.675278,    0.672194,    0.675303,     0.672136,    0.675397,     0.672001,     0.675584,
      0.671742,    0.675945,    0.671221,     0.676746,    0.669862,     0.679203,     0.590216,
      0.561899,    0.569266,    0.565838,     0.567546,    0.566846,     0.566844,     0.5674,
      0.56636,     0.567862,    0.565882,     0.568392,    0.565253,     0.569192,     0.564152,
      0.57087,     0.561179,    0.577879,     0.505579,    0.432921,     0.449978,     0.439934,
      0.446998,    0.441622,    0.445883,     0.44244,     0.445231,     0.443,        0.444714,
      0.443515,    0.444158,    0.444172,     0.443301,    0.445431,     0.441114,     0.450499,
      0.413989,    0.298386,    0.310764,     0.301542,    0.30903,      0.302554,     0.308381,
      0.302995,    0.308072,    0.303212,     0.307924,    0.303305,     0.307878,     0.303307,
      0.307919,    0.30323,     0.307996,     0.303411,    0.30416,      0.170828,     0.153529,
      0.156033,    0.156349,    0.154842,     0.157047,    0.15434,      0.157467,     0.153945,
      0.157873,    0.153495,    0.158402,     0.152838,    0.159266,     0.151624,     0.161136,
      0.148306,    0.168803,    0.0550661,    -0.0116439,  0.00590469,   -0.00367616,  0.00247954,
      -0.0017138,  0.00116148,  -0.000724329, 0.000348621, -5.42093e-16, -0.000348621, 0.000724329,
      -0.00116148, 0.0017138,   -0.00247954,  0.00367616,  -0.00590469,  0.0116439,    -0.0550661,
      -0.168803,   -0.148306,   -0.161136,    -0.151624,   -0.159266,    -0.152838,    -0.158402,
      -0.153495,   -0.157873,   -0.153945,    -0.157467,   -0.15434,     -0.157047,    -0.154842,
      -0.156349,   -0.156033,   -0.153529,    -0.170828,   -0.30416,     -0.303411,    -0.307996,
      -0.30323,    -0.307919,   -0.303307,    -0.307878,   -0.303305,    -0.307924,    -0.303212,
      -0.308072,   -0.302995,   -0.308381,    -0.302554,   -0.30903,     -0.301542,    -0.310764,
      -0.298386,   -0.413989,   -0.450499,    -0.441114,   -0.445431,    -0.443301,    -0.444172,
      -0.444158,   -0.443515,   -0.444714,    -0.443,      -0.445231,    -0.44244,     -0.445883,
      -0.441622,   -0.446998,   -0.439934,    -0.449978,   -0.432921,    -0.505579,    -0.577879,
      -0.561179,   -0.57087,    -0.564152,    -0.569192,   -0.565253,    -0.568392,    -0.565882,
      -0.567862,   -0.56636,    -0.5674,      -0.566844,   -0.566846,    -0.567546,    -0.565838,
      -0.569266,   -0.561899,   -0.590216,    -0.679203,   -0.669862,    -0.676746,    -0.671221,
      -0.675945,   -0.671742,   -0.675584,    -0.672001,   -0.675397,    -0.672136,    -0.675303,
      -0.672194,   -0.675278,   -0.672189,    -0.67531,    -0.672153,    -0.675178,    -0.67469,
      -0.762475,   -0.773884,   -0.772217,    -0.772024,   -0.773008,    -0.771551,    -0.77336,
      -0.771243,   -0.773664,   -0.770914,    -0.774048,   -0.770442,    -0.774659,    -0.769609,
      -0.77587,    -0.767685,   -0.779372,    -0.759425,   -0.881513,    -0.957609,    -0.935247,
      -0.949102,   -0.938736,   -0.947259,    -0.939822,   -0.946598,    -0.940206,    -0.946421,
      -0.940206,   -0.946598,   -0.939822,    -0.947259,   -0.938736,    -0.949102,    -0.935247,
      -0.957609,   -0.881513,   -0.759425,    -0.779372,   -0.767685,    -0.77587,     -0.769609,
      -0.774659,   -0.770442,   -0.774048,    -0.770914,   -0.773664,    -0.771243,    -0.77336,
      -0.771551,   -0.773008,   -0.772024,    -0.772217,   -0.773884,    -0.762475,    -0.67469,
      -0.675178,   -0.672153,   -0.67531,     -0.672189,   -0.675278,    -0.672194,    -0.675303,
      -0.672136,   -0.675397,   -0.672001,    -0.675584,   -0.671742,    -0.675945,    -0.671221,
      -0.676746,   -0.669862,   -0.679203,    -0.590216,   -0.561899,    -0.569266,    -0.565838,
      -0.567546,   -0.566846,   -0.566844,    -0.5674,     -0.56636,     -0.567862,    -0.565882,
      -0.568392,   -0.565253,   -0.569192,    -0.564152,   -0.57087,     -0.561179,    -0.577879,
      -0.505579,   -0.432921,   -0.449978,    -0.439934,   -0.446998,    -0.441622,    -0.445883,
      -0.44244,    -0.445231,   -0.443,       -0.444714,   -0.443515,    -0.444158,    -0.444172,
      -0.443301,   -0.445431,   -0.441114,    -0.450499,   -0.413989,    -0.298386,    -0.310764,
      -0.301542,   -0.30903,    -0.302554,    -0.308381,   -0.302995,    -0.308072,    -0.303212,
      -0.307924,   -0.303305,   -0.307878,    -0.303307,   -0.307919,    -0.30323,     -0.307996,
      -0.303411,   -0.30416,    -0.170828,    -0.153529,   -0.156033,    -0.156349,    -0.154842,
      -0.157047,   -0.15434,    -0.157467,    -0.153945,   -0.157873,    -0.153495,    -0.158402,
      -0.152838,   -0.159266,   -0.151624,    -0.161136,   -0.148306,    -0.168803,    -0.0550661,
      0.0116439,   -0.00590469, 0.00367616,   -0.00247955, 0.0017138,    -0.0011615,   0.00072432,
      -0.00034862},
     {0,           0.00034862,  -0.00072432,  0.0011615,   -0.0017138,   0.00247955,   -0.00367616,
      0.00590469,  -0.0116439,  0.0550661,    0.168803,    0.148306,     0.161136,     0.151624,
      0.159266,    0.152838,    0.158402,     0.153495,    0.157873,     0.153945,     0.157467,
      0.15434,     0.157047,    0.154842,     0.156349,    0.156033,     0.153529,     0.170828,
      0.30416,     0.303411,    0.307996,     0.30323,     0.307919,     0.303307,     0.307878,
      0.303305,    0.307924,    0.303212,     0.308072,    0.302995,     0.308381,     0.302554,
      0.30903,     0.301542,    0.310764,     0.298386,    0.413989,     0.450499,     0.441114,
      0.445431,    0.443301,    0.444172,     0.444158,    0.443515,     0.444714,     0.443,
      0.445231,    0.44244,     0.445883,     0.441622,    0.446998,     0.439934,     0.449978,
      0.432921,    0.505579,    0.577879,     0.561179,    0.57087,      0.564152,     0.569192,
      0.565253,    0.568392,    0.565882,     0.567862,    0.56636,      0.5674,       0.566844,
      0.566846,    0.567546,    0.565838,     0.569266,    0.561899,     0.590216,     0.679203,
      0.669862,    0.676746,    0.671221,     0.675945,    0.671742,     0.675584,     0.672001,
      0.675397,    0.672136,    0.675303,     0.672194,    0.675278,     0.672189,     0.67531,
      0.672153,    0.675178,    0.67469,      0.762475,    0.773884,     0.772217,     0.772024,
      0.773008,    0.771551,    0.77336,      0.771243,    0.773664,     0.770914,     0.774048,
      0.770442,    0.774659,    0.769609,     0.77587,     0.767685,     0.779372,     0.759425,
      0.881513,    0.957609,    0.935247,     0.949102,    0.938736,     0.947259,     0.939822,
      0.946598,    0.940206,    0.946421,     0.940206,    0.946598,     0.939822,     0.947259,
      0.938736,    0.949102,    0.935247,     0.957609,    0.881513,     0.759425,     0.779372,
      0.767685,    0.77587,     0.769609,     0.774659,    0.770442,     0.774048,     0.770914,
      0.773664,    0.771243,    0.77336,      0.771551,    0.773008,     0.772024,     0.772217,
      0.773884,    0.762475,    0.67469,      0.675178,    0.672153,     0.67531,      0.672189,
      0.675278,    0.672194,    0.675303,     0.672136,    0.675397,     0.672001,     0.675584,
      0.671742,    0.675945,    0.671221,     0.676746,    0.669862,     0.679203,     0.590216,
      0.561899,    0.569266,    0.565838,     0.567546,    0.566846,     0.566844,     0.5674,
      0.56636,     0.567862,    0.565882,     0.568392,    0.565253,     0.569192,     0.564152,
      0.57087,     0.561179,    0.577879,     0.505579,    0.432921,     0.449978,     0.439934,
      0.446998,    0.441622,    0.445883,     0.44244,     0.445231,     0.443,        0.444714,
      0.443515,    0.444158,    0.444172,     0.443301,    0.445431,     0.441114,     0.450499,
      0.413989,    0.298386,    0.310764,     0.301542,    0.30903,      0.302554,     0.308381,
      0.302995,    0.308072,    0.303212,     0.307924,    0.303305,     0.307878,     0.303307,
      0.307919,    0.30323,     0.307996,     0.303411,    0.30416,      0.170828,     0.153529,
      0.156033,    0.156349,    0.154842,     0.157047,    0.15434,      0.157467,     0.153945,
      0.157873,    0.153495,    0.158402,     0.152838,    0.159266,     0.151624,     0.161136,
      0.148306,    0.168803,    0.0550661,    -0.0116439,  0.00590469,   -0.00367616,  0.00247954,
      -0.0017138,  0.00116148,  -0.000724329, 0.000348621, -5.42093e-16, -0.000348621, 0.000724329,
      -0.00116148, 0.0017138,   -0.00247954,  0.00367616,  -0.00590469,  0.0116439,    -0.0550661,
      -0.168803,   -0.148306,   -0.161136,    -0.151624,   -0.159266,    -0.152838,    -0.158402,
      -0.153495,   -0.157873,   -0.153945,    -0.157467,   -0.15434,     -0.157047,    -0.154842,
      -0.156349,   -0.156033,   -0.153529,    -0.170828,   -0.30416,     -0.303411,    -0.307996,
      -0.30323,    -0.307919,   -0.303307,    -0.307878,   -0.303305,    -0.307924,    -0.303212,
      -0.308072,   -0.302995,   -0.308381,    -0.302554,   -0.30903,     -0.301542,    -0.310764,
      -0.298386,   -0.413989,   -0.450499,    -0.441114,   -0.445431,    -0.443301,    -0.444172,
      -0.444158,   -0.443515,   -0.444714,    -0.443,      -0.445231,    -0.44244,     -0.445883,
      -0.441622,   -0.446998,   -0.439934,    -0.449978,   -0.432921,    -0.505579,    -0.577879,
      -0.561179,   -0.57087,    -0.564152,    -0.569192,   -0.565253,    -0.568392,    -0.565882,
      -0.567862,   -0.56636,    -0.5674,      -0.566844,   -0.566846,    -0.567546,    -0.565838,
      -0.569266,   -0.561899,   -0.590216,    -0.679203,   -0.669862,    -0.676746,    -0.671221,
      -0.675945,   -0.671742,   -0.675584,    -0.672001,   -0.675397,    -0.672136,    -0.675303,
      -0.672194,   -0.675278,   -0.672189,    -0.67531,    -0.672153,    -0.675178,    -0.67469,
      -0.762475,   -0.773884,   -0.772217,    -0.772024,   -0.773008,    -0.771551,    -0.77336,
      -0.771243,   -0.773664,   -0.770914,    -0.774048,   -0.770442,    -0.774659,    -0.769609,
      -0.77587,    -0.767685,   -0.779372,    -0.759425,   -0.881513,    -0.957609,    -0.935247,
      -0.949102,   -0.938736,   -0.947259,    -0.939822,   -0.946598,    -0.940206,    -0.946421,
      -0.940206,   -0.946598,   -0.939822,    -0.947259,   -0.938736,    -0.949102,    -0.935247,
      -0.957609,   -0.881513,   -0.759425,    -0.779372,   -0.767685,    -0.77587,     -0.769609,
      -0.774659,   -0.770442,   -0.774048,    -0.770914,   -0.773664,    -0.771243,    -0.77336,
      -0.771551,   -0.773008,   -0.772024,    -0.772217,   -0.773884,    -0.762475,    -0.67469,
      -0.675178,   -0.672153,   -0.67531,     -0.672189,   -0.675278,    -0.672194,    -0.675303,
      -0.672136,   -0.675397,   -0.672001,    -0.675584,   -0.671742,    -0.675945,    -0.671221,
      -0.676746,   -0.669862,   -0.679203,    -0.590216,   -0.561899,    -0.569266,    -0.565838,
      -0.567546,   -0.566846,   -0.566844,    -0.5674,     -0.56636,     -0.567862,    -0.565882,
      -0.568392,   -0.565253,   -0.569192,    -0.564152,   -0.57087,     -0.561179,    -0.577879,
      -0.505579,   -0.432921,   -0.449978,    -0.439934,   -0.446998,    -0.441622,    -0.445883,
      -0.44244,    -0.445231,   -0.443,       -0.444714,   -0.443515,    -0.444158,    -0.444172,
      -0.443301,   -0.445431,   -0.441114,    -0.450499,   -0.413989,    -0.298386,    -0.310764,
      -0.301542,   -0.30903,    -0.302554,    -0.308381,   -0.302995,    -0.308072,    -0.303212,
      -0.307924,   -0.303305,   -0.307878,    -0.303307,   -0.307919,    -0.30323,     -0.307996,
      -0.303411,   -0.30416,    -0.170828,    -0.153529,   -0.156033,    -0.156349,    -0.154842,
      -0.157047,   -0.15434,    -0.157467,    -0.153945,   -0.157873,    -0.153495,    -0.158402,
      -0.152838,   -0.159266,   -0.151624,    -0.161136,   -0.148306,    -0.168803,    -0.0550661,
      0.0116439,   -0.00590469, 0.00367616,   -0.00247955, 0.0017138,    -0.0011615,   0.00072432,
      -0.00034862},
     {0,           0.00034862,  -0.00072432,  0.0011615,   -0.0017138,   0.00247955,   -0.00367616,
      0.00590469,  -0.0116439,  0.0550661,    0.168803,    0.148306,     0.161136,     0.151624,
      0.159266,    0.152838,    0.158402,     0.153495,    0.157873,     0.153945,     0.157467,
      0.15434,     0.157047,    0.154842,     0.156349,    0.156033,     0.153529,     0.170828,
      0.30416,     0.303411,    0.307996,     0.30323,     0.307919,     0.303307,     0.307878,
      0.303305,    0.307924,    0.303212,     0.308072,    0.302995,     0.308381,     0.302554,
      0.30903,     0.301542,    0.310764,     0.298386,    0.413989,     0.450499,     0.441114,
      0.445431,    0.443301,    0.444172,     0.444158,    0.443515,     0.444714,     0.443,
      0.445231,    0.44244,     0.445883,     0.441622,    0.446998,     0.439934,     0.449978,
      0.432921,    0.505579,    0.577879,     0.561179,    0.57087,      0.564152,     0.569192,
      0.565253,    0.568392,    0.565882,     0.567862,    0.56636,      0.5674,       0.566844,
      0.566846,    0.567546,    0.565838,     0.569266,    0.561899,     0.590216,     0.679203,
      0.669862,    0.676746,    0.671221,     0.675945,    0.671742,     0.675584,     0.672001,
      0.675397,    0.672136,    0.675303,     0.672194,    0.675278,     0.672189,     0.67531,
      0.672153,    0.675178,    0.67469,      0.762475,    0.773884,     0.772217,     0.772024,
      0.773008,    0.771551,    0.77336,      0.771243,    0.773664,     0.770914,     0.774048,
      0.770442,    0.774659,    0.769609,     0.77587,     0.767685,     0.779372,     0.759425,
      0.881513,    0.957609,    0.935247,     0.949102,    0.938736,     0.947259,     0.939822,
      0.946598,    0.940206,    0.946421,     0.940206,    0.946598,     0.939822,     0.947259,
      0.938736,    0.949102,    0.935247,     0.957609,    0.881513,     0.759425,     0.779372,
      0.767685,    0.77587,     0.769609,     0.774659,    0.770442,     0.774048,     0.770914,
      0.773664,    0.771243,    0.77336,      0.771551,    0.773008,     0.772024,     0.772217,
      0.773884,    0.762475,    0.67469,      0.675178,    0.672153,     0.67531,      0.672189,
      0.675278,    0.672194,    0.675303,     0.672136,    0.675397,     0.672001,     0.675584,
      0.671742,    0.675945,    0.671221,     0.676746,    0.669862,     0.679203,     0.590216,
      0.561899,    0.569266,    0.565838,     0.567546,    0.566846,     0.566844,     0.5674,
      0.56636,     0.567862,    0.565882,     0.568392,    0.565253,     0.569192,     0.564152,
      0.57087,     0.561179,    0.577879,     0.505579,    0.432921,     0.449978,     0.439934,
      0.446998,    0.441622,    0.445883,     0.44244,     0.445231,     0.443,        0.444714,
      0.443515,    0.444158,    0.444172,     0.443301,    0.445431,     0.441114,     0.450499,
      0.413989,    0.298386,    0.310764,     0.301542,    0.30903,      0.302554,     0.308381,
      0.302995,    0.308072,    0.303212,     0.307924,    0.303305,     0.307878,     0.303307,
      0.307919,    0.30323,     0.307996,     0.303411,    0.30416,      0.170828,     0.153529,
      0.156033,    0.156349,    0.154842,     0.157047,    0.15434,      0.157467,     0.153945,
      0.157873,    0.153495,    0.158402,     0.152838,    0.159266,     0.151624,     0.161136,
      0.148306,    0.168803,    0.0550661,    -0.0116439,  0.00590469,   -0.00367616,  0.00247954,
      -0.0017138,  0.00116148,  -0.000724329, 0.000348621, -5.42093e-16, -0.000348621, 0.000724329,
      -0.00116148, 0.0017138,   -0.00247954,  0.00367616,  -0.00590469,  0.0116439,    -0.0550661,
      -0.168803,   -0.148306,   -0.161136,    -0.151624,   -0.159266,    -0.152838,    -0.158402,
      -0.153495,   -0.157873,   -0.153945,    -0.157467,   -0.15434,     -0.157047,    -0.154842,
      -0.156349,   -0.156033,   -0.153529,    -0.170828,   -0.30416,     -0.303411,    -0.307996,
      -0.30323,    -0.307919,   -0.303307,    -0.307878,   -0.303305,    -0.307924,    -0.303212,
      -0.308072,   -0.302995,   -0.308381,    -0.302554,   -0.30903,     -0.301542,    -0.310764,
      -0.298386,   -0.413989,   -0.450499,    -0.441114,   -0.445431,    -0.443301,    -0.444172,
      -0.444158,   -0.443515,   -0.444714,    -0.443,      -0.445231,    -0.44244,     -0.445883,
      -0.441622,   -0.446998,   -0.439934,    -0.449978,   -0.432921,    -0.505579,    -0.577879,
      -0.561179,   -0.57087,    -0.564152,    -0.569192,   -0.565253,    -0.568392,    -0.565882,
      -0.567862,   -0.56636,    -0.5674,      -0.566844,   -0.566846,    -0.567546,    -0.565838,
      -0.569266,   -0.561899,   -0.590216,    -0.679203,   -0.669862,    -0.676746,    -0.671221,
      -0.675945,   -0.671742,   -0.675584,    -0.672001,   -0.675397,    -0.672136,    -0.675303,
      -0.672194,   -0.675278,   -0.672189,    -0.67531,    -0.672153,    -0.675178,    -0.67469,
      -0.762475,   -0.773884,   -0.772217,    -0.772024,   -0.773008,    -0.771551,    -0.77336,
      -0.771243,   -0.773664,   -0.770914,    -0.774048,   -0.770442,    -0.774659,    -0.769609,
      -0.77587,    -0.767685,   -0.779372,    -0.759425,   -0.881513,    -0.957609,    -0.935247,
      -0.949102,   -0.938736,   -0.947259,    -0.939822,   -0.946598,    -0.940206,    -0.946421,
      -0.940206,   -0.946598,   -0.939822,    -0.947259,   -0.938736,    -0.949102,    -0.935247,
      -0.957609,   -0.881513,   -0.759425,    -0.779372,   -0.767685,    -0.77587,     -0.769609,
      -0.774659,   -0.770442,   -0.774048,    -0.770914,   -0.773664,    -0.771243,    -0.77336,
      -0.771551,   -0.773008,   -0.772024,    -0.772217,   -0.773884,    -0.762475,    -0.67469,
      -0.675178,   -0.672153,   -0.67531,     -0.672189,   -0.675278,    -0.672194,    -0.675303,
      -0.672136,   -0.675397,   -0.672001,    -0.675584,   -0.671742,    -0.675945,    -0.671221,
      -0.676746,   -0.669862,   -0.679203,    -0.590216,   -0.561899,    -0.569266,    -0.565838,
      -0.567546,   -0.566846,   -0.566844,    -0.5674,     -0.56636,     -0.567862,    -0.565882,
      -0.568392,   -0.565253,   -0.569192,    -0.564152,   -0.57087,     -0.561179,    -0.577879,
      -0.505579,   -0.432921,   -0.449978,    -0.439934,   -0.446998,    -0.441622,    -0.445883,
      -0.44244,    -0.445231,   -0.443,       -0.444714,   -0.443515,    -0.444158,    -0.444172,
      -0.443301,   -0.445431,   -0.441114,    -0.450499,   -0.413989,    -0.298386,    -0.310764,
      -0.301542,   -0.30903,    -0.302554,    -0.308381,   -0.302995,    -0.308072,    -0.303212,
      -0.307924,   -0.303305,   -0.307878,    -0.303307,   -0.307919,    -0.30323,     -0.307996,
      -0.303411,   -0.30416,    -0.170828,    -0.153529,   -0.156033,    -0.156349,    -0.154842,
      -0.157047,   -0.15434,    -0.157467,    -0.153945,   -0.157873,    -0.153495,    -0.158402,
      -0.152838,   -0.159266,   -0.151624,    -0.161136,   -0.148306,    -0.168803,    -0.0550661,
      0.0116439,   -0.00590469, 0.00367616,   -0.00247955, 0.0017138,    -0.0011615,   0.00072432,
      -0.00034862},
     {0,           0.000540738, -0.00111255, 0.00175355,  -0.00252057,  0.00351435,   -0.00495374,
      0.00744022,  -0.0134517,  0.0571588,   0.166416,    0.150993,     0.158148,     0.154909,
      0.155694,    0.156682,    0.154306,    0.157819,    0.153349,     0.15864,      0.152634,
      0.159278,    0.152034,    0.159901,    0.15127,     0.161112,     0.148468,     0.17586,
      0.299165,    0.308366,    0.303078,    0.308114,    0.30306,      0.308147,     0.303047,
      0.308133,    0.303095,    0.308042,    0.303244,    0.307813,     0.303586,     0.307307,
      0.304341,    0.30614,     0.306285,    0.302714,    0.409844,     0.454432,     0.437422,
      0.448858,    0.440159,    0.447015,    0.441621,    0.445744,     0.442788,     0.444635,
      0.44387,     0.443548,    0.445005,    0.442296,    0.446502,     0.440276,     0.449769,
      0.433014,    0.50559,     0.577771,    0.561385,    0.57056,      0.564578,     0.568632,
      0.565968,    0.5675,      0.566977,    0.566543,    0.567925,     0.565573,     0.568942,
      0.564473,    0.570189,    0.562938,    0.572402,    0.558556,     0.593729,     0.67556,
      0.67359,     0.672981,    0.67498,     0.672237,    0.675362,     0.672085,     0.675359,
      0.672192,    0.675186,    0.672399,    0.674972,    0.672595,     0.674814,     0.672698,
      0.674799,    0.672449,    0.677546,    0.759449,    0.777112,     0.768764,     0.77571,
      0.769094,    0.775673,    0.769067,    0.775655,    0.769199,     0.775354,     0.76972,
      0.774564,    0.770838,    0.773034,    0.77293,     0.770062,     0.777625,     0.760492,
      0.881154,    0.957249,    0.93631,     0.947371,    0.941075,     0.94439,      0.943123,
      0.942977,    0.944023,    0.942537,    0.944023,    0.942977,     0.943123,     0.94439,
      0.941075,    0.947371,    0.93631,     0.957249,    0.881154,     0.760492,     0.777625,
      0.770062,    0.77293,     0.773034,    0.770838,    0.774564,     0.76972,      0.775354,
      0.769199,    0.775655,    0.769067,    0.775673,    0.769094,     0.77571,      0.768764,
      0.777112,    0.759449,    0.677546,    0.672449,    0.674799,     0.672698,     0.674814,
      0.672595,    0.674972,    0.672399,    0.675186,    0.672192,     0.675359,     0.672085,
      0.675362,    0.672237,    0.67498,     0.672981,    0.67359,      0.67556,      0.593729,
      0.558556,    0.572402,    0.562938,    0.570189,    0.564473,     0.568942,     0.565573,
      0.567925,    0.566543,    0.566977,    0.5675,      0.565968,     0.568632,     0.564578,
      0.57056,     0.561385,    0.577771,    0.50559,     0.433014,     0.449769,     0.440276,
      0.446502,    0.442296,    0.445005,    0.443548,    0.44387,      0.444635,     0.442788,
      0.445744,    0.441621,    0.447015,    0.440159,    0.448858,     0.437422,     0.454432,
      0.409844,    0.302714,    0.306285,    0.30614,     0.304341,     0.307307,     0.303586,
      0.307813,    0.303244,    0.308042,    0.303095,    0.308133,     0.303047,     0.308147,
      0.30306,     0.308114,    0.303078,    0.308366,    0.299165,     0.17586,      0.148468,
      0.161112,    0.15127,     0.159901,    0.152034,    0.159278,     0.152634,     0.15864,
      0.153349,    0.157819,    0.154306,    0.156682,    0.155694,     0.154909,     0.158148,
      0.150993,    0.166416,    0.0571588,   -0.0134517,  0.00744022,   -0.00495375,  0.00351434,
      -0.00252058, 0.00175354,  -0.00111256, 0.000540739, -6.29677e-16, -0.000540739, 0.00111256,
      -0.00175354, 0.00252058,  -0.00351434, 0.00495375,  -0.00744022,  0.0134517,    -0.0571588,
      -0.166416,   -0.150993,   -0.158148,   -0.154909,   -0.155694,    -0.156682,    -0.154306,
      -0.157819,   -0.153349,   -0.15864,    -0.152634,   -0.159278,    -0.152034,    -0.159901,
      -0.15127,    -0.161112,   -0.148468,   -0.17586,    -0.299165,    -0.308366,    -0.303078,
      -0.308114,   -0.30306,    -0.308147,   -0.303047,   -0.308133,    -0.303095,    -0.308042,
      -0.303244,   -0.307813,   -0.303586,   -0.307307,   -0.304341,    -0.30614,     -0.306285,
      -0.302714,   -0.409844,   -0.454432,   -0.437422,   -0.448858,    -0.440159,    -0.447015,
      -0.441621,   -0.445744,   -0.442788,   -0.444635,   -0.44387,     -0.443548,    -0.445005,
      -0.442296,   -0.446502,   -0.440276,   -0.449769,   -0.433014,    -0.50559,     -0.577771,
      -0.561385,   -0.57056,    -0.564578,   -0.568632,   -0.565968,    -0.5675,      -0.566977,
      -0.566543,   -0.567925,   -0.565573,   -0.568942,   -0.564473,    -0.570189,    -0.562938,
      -0.572402,   -0.558556,   -0.593729,   -0.67556,    -0.67359,     -0.672981,    -0.67498,
      -0.672237,   -0.675362,   -0.672085,   -0.675359,   -0.672192,    -0.675186,    -0.672399,
      -0.674972,   -0.672595,   -0.674814,   -0.672698,   -0.674799,    -0.672449,    -0.677546,
      -0.759449,   -0.777112,   -0.768764,   -0.77571,    -0.769094,    -0.775673,    -0.769067,
      -0.775655,   -0.769199,   -0.775354,   -0.76972,    -0.774564,    -0.770838,    -0.773034,
      -0.77293,    -0.770062,   -0.777625,   -0.760492,   -0.881154,    -0.957249,    -0.93631,
      -0.947371,   -0.941075,   -0.94439,    -0.943123,   -0.942977,    -0.944023,    -0.942537,
      -0.944023,   -0.942977,   -0.943123,   -0.94439,    -0.941075,    -0.947371,    -0.93631,
      -0.957249,   -0.881154,   -0.760492,   -0.777625,   -0.770062,    -0.77293,     -0.773034,
      -0.770838,   -0.774564,   -0.76972,    -0.775354,   -0.769199,    -0.775655,    -0.769067,
      -0.775673,   -0.769094,   -0.77571,    -0.768764,   -0.777112,    -0.759449,    -0.677546,
      -0.672449,   -0.674799,   -0.672698,   -0.674814,   -0.672595,    -0.674972,    -0.672399,
      -0.675186,   -0.672192,   -0.675359,   -0.672085,   -0.675362,    -0.672237,    -0.67498,
      -0.672981,   -0.67359,    -0.67556,    -0.593729,   -0.558556,    -0.572402,    -0.562938,
      -0.570189,   -0.564473,   -0.568942,   -0.565573,   -0.567925,    -0.566543,    -0.566977,
      -0.5675,     -0.565968,   -0.568632,   -0.564578,   -0.57056,     -0.561385,    -0.577771,
      -0.50559,    -0.433014,   -0.449769,   -0.440276,   -0.446502,    -0.442296,    -0.445005,
      -0.443548,   -0.44387,    -0.444635,   -0.442788,   -0.445744,    -0.441621,    -0.447015,
      -0.440159,   -0.448858,   -0.437422,   -0.454432,   -0.409844,    -0.302714,    -0.306285,
      -0.30614,    -0.304341,   -0.307307,   -0.303586,   -0.307813,    -0.303244,    -0.308042,
      -0.303095,   -0.308133,   -0.303047,   -0.308147,   -0.30306,     -0.308114,    -0.303078,
      -0.308366,   -0.299165,   -0.17586,    -0.148468,   -0.161112,    -0.15127,     -0.159901,
      -0.152034,   -0.159278,   -0.152634,   -0.15864,    -0.153349,    -0.157819,    -0.154306,
      -0.156682,   -0.155694,   -0.154909,   -0.158148,   -0.150993,    -0.166416,    -0.0571588,
      0.0134517,   -0.00744022, 0.00495374,  -0.00351435, 0.00252057,   -0.00175355,  0.00111255,
      -0.000540738},
     {0,          -0.00201933, 0.00352444, -0.00410962, 0.00354383,   -0.00176359, -0.00124166,
      0.00576968, -0.0139776,  0.0597513,  0.162117,    0.156456,     0.152212,    0.160522,
      0.151234,   0.159238,    0.154178,   0.155364,    0.158093,     0.152337,    0.159453,
      0.153085,   0.156596,    0.157642,   0.150994,    0.163722,     0.144056,    0.181344,
      0.293389,   0.313693,    0.298846,   0.310733,    0.302413,     0.306676,    0.306506,
      0.303138,   0.308868,    0.302454,   0.307659,    0.30537,      0.303633,    0.309604,
      0.300206,   0.31129,     0.301058,   0.307168,    0.406785,     0.455759,    0.437895,
      0.446721,   0.443675,    0.442531,   0.446541,    0.441038,     0.446556,    0.442492,
      0.443888,   0.445813,    0.440734,   0.447878,    0.440589,     0.445482,    0.446128,
      0.434589,   0.506155,    0.575361,   0.565113,    0.566116,     0.569176,    0.564358,
      0.569506,   0.565072,    0.567954,   0.567257,    0.565482,     0.569477,    0.564178,
      0.569239,   0.566345,    0.565111,   0.572264,    0.55678,      0.596872,    0.671843,
      0.677087,   0.670289,    0.676584,   0.67173,     0.674911,     0.673342,    0.673387,
      0.674815,   0.672061,    0.675679,   0.672124,    0.674283,     0.674944,    0.670427,
      0.679014,   0.667034,    0.683049,   0.755017,    0.779618,     0.768502,    0.773976,
      0.772194,   0.771913,    0.772988,   0.771741,    0.773175,     0.771267,    0.773663,
      0.771462,   0.772068,    0.774672,   0.767945,    0.777957,     0.768264,    0.769163,
      0.875405,   0.958531,    0.939762,   0.940374,    0.949316,     0.937553,    0.946488,
      0.943836,   0.939771,    0.94808,    0.939771,    0.943836,     0.946488,    0.937553,
      0.949316,   0.940374,    0.939762,   0.958531,    0.875405,     0.769163,    0.768264,
      0.777957,   0.767945,    0.774672,   0.772068,    0.771462,     0.773663,    0.771267,
      0.773175,   0.771741,    0.772988,   0.771913,    0.772194,     0.773976,    0.768502,
      0.779618,   0.755017,    0.683049,   0.667034,    0.679014,     0.670427,    0.674944,
      0.674283,   0.672124,    0.675679,   0.672061,    0.674815,     0.673387,    0.673342,
      0.674911,   0.67173,     0.676584,   0.670289,    0.677087,     0.671843,    0.596872,
      0.55678,    0.572264,    0.565111,   0.566345,    0.569239,     0.564178,    0.569477,
      0.565482,   0.567257,    0.567954,   0.565072,    0.569506,     0.564358,    0.569176,
      0.566116,   0.565113,    0.575361,   0.506155,    0.434589,     0.446128,    0.445482,
      0.440589,   0.447878,    0.440734,   0.445813,    0.443888,     0.442492,    0.446556,
      0.441038,   0.446541,    0.442531,   0.443675,    0.446721,     0.437895,    0.455759,
      0.406785,   0.307168,    0.301058,   0.31129,     0.300206,     0.309604,    0.303633,
      0.30537,    0.307659,    0.302454,   0.308868,    0.303138,     0.306506,    0.306676,
      0.302413,   0.310733,    0.298846,   0.313693,    0.293389,     0.181344,    0.144056,
      0.163722,   0.150994,    0.157642,   0.156596,    0.153085,     0.159453,    0.152337,
      0.158093,   0.155364,    0.154178,   0.159238,    0.151234,     0.160522,    0.152212,
      0.156456,   0.162117,    0.0597513,  -0.0139776,  0.00576968,   -0.00124166, -0.0017636,
      0.00354383, -0.00410963, 0.00352444, -0.00201933, -8.16467e-16, 0.00201933,  -0.00352444,
      0.00410963, -0.00354383, 0.0017636,  0.00124166,  -0.00576968,  0.0139776,   -0.0597513,
      -0.162117,  -0.156456,   -0.152212,  -0.160522,   -0.151234,    -0.159238,   -0.154178,
      -0.155364,  -0.158093,   -0.152337,  -0.159453,   -0.153085,    -0.156596,   -0.157642,
      -0.150994,  -0.163722,   -0.144056,  -0.181344,   -0.293389,    -0.313693,   -0.298846,
      -0.310733,  -0.302413,   -0.306676,  -0.306506,   -0.303138,    -0.308868,   -0.302454,
      -0.307659,  -0.30537,    -0.303633,  -0.309604,   -0.300206,    -0.31129,    -0.301058,
      -0.307168,  -0.406785,   -0.455759,  -0.437895,   -0.446721,    -0.443675,   -0.442531,
      -0.446541,  -0.441038,   -0.446556,  -0.442492,   -0.443888,    -0.445813,   -0.440734,
      -0.447878,  -0.440589,   -0.445482,  -0.446128,   -0.434589,    -0.506155,   -0.575361,
      -0.565113,  -0.566116,   -0.569176,  -0.564358,   -0.569506,    -0.565072,   -0.567954,
      -0.567257,  -0.565482,   -0.569477,  -0.564178,   -0.569239,    -0.566345,   -0.565111,
      -0.572264,  -0.55678,    -0.596872,  -0.671843,   -0.677087,    -0.670289,   -0.676584,
      -0.67173,   -0.674911,   -0.673342,  -0.673387,   -0.674815,    -0.672061,   -0.675679,
      -0.672124,  -0.674283,   -0.674944,  -0.670427,   -0.679014,    -0.667034,   -0.683049,
      -0.755017,  -0.779618,   -0.768502,  -0.773976,   -0.772194,    -0.771913,   -0.772988,
      -0.771741,  -0.773175,   -0.771267,  -0.773663,   -0.771462,    -0.772068,   -0.774672,
      -0.767945,  -0.777957,   -0.768264,  -0.769163,   -0.875405,    -0.958531,   -0.939762,
      -0.940374,  -0.949316,   -0.937553,  -0.946488,   -0.943836,    -0.939771,   -0.94808,
      -0.939771,  -0.943836,   -0.946488,  -0.937553,   -0.949316,    -0.940374,   -0.939762,
      -0.958531,  -0.875405,   -0.769163,  -0.768264,   -0.777957,    -0.767945,   -0.774672,
      -0.772068,  -0.771462,   -0.773663,  -0.771267,   -0.773175,    -0.771741,   -0.772988,
      -0.771913,  -0.772194,   -0.773976,  -0.768502,   -0.779618,    -0.755017,   -0.683049,
      -0.667034,  -0.679014,   -0.670427,  -0.674944,   -0.674283,    -0.672124,   -0.675679,
      -0.672061,  -0.674815,   -0.673387,  -0.673342,   -0.674911,    -0.67173,    -0.676584,
      -0.670289,  -0.677087,   -0.671843,  -0.596872,   -0.55678,     -0.572264,   -0.565111,
      -0.566345,  -0.569239,   -0.564178,  -0.569477,   -0.565482,    -0.567257,   -0.567954,
      -0.565072,  -0.569506,   -0.564358,  -0.569176,   -0.566116,    -0.565113,   -0.575361,
      -0.506155,  -0.434589,   -0.446128,  -0.445482,   -0.440589,    -0.447878,   -0.440734,
      -0.445813,  -0.443888,   -0.442492,  -0.446556,   -0.441038,    -0.446541,   -0.442531,
      -0.443675,  -0.446721,   -0.437895,  -0.455759,   -0.406785,    -0.307168,   -0.301058,
      -0.31129,   -0.300206,   -0.309604,  -0.303633,   -0.30537,     -0.307659,   -0.302454,
      -0.308868,  -0.303138,   -0.306506,  -0.306676,   -0.302413,    -0.310733,   -0.298846,
      -0.313693,  -0.293389,   -0.181344,  -0.144056,   -0.163722,    -0.150994,   -0.157642,
      -0.156596,  -0.153085,   -0.159453,  -0.152337,   -0.158093,    -0.155364,   -0.154178,
      -0.159238,  -0.151234,   -0.160522,  -0.152212,   -0.156456,    -0.162117,   -0.0597513,
      0.0139776,  -0.00576968, 0.00124166, 0.00176359,  -0.00354383,  0.00410962,  -0.00352444,
      0.00201933},
     {0,           -0.00472486, 0.00333282,  0.00283142,  -0.0060715, 0.00115397,  0.00769008,  -0.00941798,
      -0.0049371,  0.0648246,   0.14701,     0.169127,    0.151443,   0.150904,    0.161554,    0.156072,
      0.150879,    0.158725,    0.158505,    0.151063,    0.156323,   0.160636,    0.151568,    0.153089,
      0.163915,    0.152477,    0.143538,    0.194001,    0.278798,   0.318605,    0.30632,     0.298636,
      0.309045,    0.308671,    0.300972,    0.305806,    0.309765,   0.302586,    0.303383,    0.310482,
      0.304478,    0.300473,    0.311374,    0.308008,    0.292422,   0.32131,     0.398587,    0.451846,
      0.449583,    0.43739,     0.444271,    0.448389,    0.441226,   0.441885,    0.447831,    0.443504,
      0.440345,    0.447114,    0.445806,    0.438739,    0.445973,   0.449792,    0.434499,    0.44427,
      0.506302,    0.566018,    0.575446,    0.562754,    0.564709,   0.570936,    0.56656,     0.563996,
      0.56916,     0.568548,    0.563728,    0.5676,      0.570317,   0.563633,    0.56549,     0.573162,
      0.563069,    0.559467,    0.602885,    0.662366,    0.682348,   0.672467,    0.670365,    0.676143,
      0.67484,     0.671349,    0.674006,    0.675895,    0.672138,   0.67237,     0.676676,    0.673123,
      0.670306,    0.677888,    0.674881,    0.664162,    0.690603,   0.748995,    0.779661,    0.773435,
      0.768902,    0.773635,    0.773699,    0.771112,    0.771777,   0.773728,    0.772564,    0.770402,
      0.773591,    0.774354,    0.768426,    0.773404,    0.778441,   0.761194,    0.777712,    0.872316,
      0.953243,    0.949624,    0.933595,    0.947615,    0.946524,   0.937152,    0.946322,    0.94606,
      0.937857,    0.94606,     0.946322,    0.937152,    0.946524,   0.947615,    0.933595,    0.949624,
      0.953243,    0.872316,    0.777712,    0.761194,    0.778441,   0.773404,    0.768426,    0.774354,
      0.773591,    0.770402,    0.772564,    0.773728,    0.771777,   0.771112,    0.773699,    0.773635,
      0.768902,    0.773435,    0.779661,    0.748995,    0.690603,   0.664162,    0.674881,    0.677888,
      0.670306,    0.673123,    0.676676,    0.67237,     0.672138,   0.675895,    0.674006,    0.671349,
      0.67484,     0.676143,    0.670365,    0.672467,    0.682348,   0.662366,    0.602885,    0.559467,
      0.563069,    0.573162,    0.56549,     0.563633,    0.570317,   0.5676,      0.563728,    0.568548,
      0.56916,     0.563996,    0.56656,     0.570936,    0.564709,   0.562754,    0.575446,    0.566018,
      0.506302,    0.44427,     0.434499,    0.449792,    0.445973,   0.438739,    0.445806,    0.447114,
      0.440345,    0.443504,    0.447831,    0.441885,    0.441226,   0.448389,    0.444271,    0.43739,
      0.449583,    0.451846,    0.398587,    0.32131,     0.292422,   0.308008,    0.311374,    0.300473,
      0.304478,    0.310482,    0.303383,    0.302586,    0.309765,   0.305806,    0.300972,    0.308671,
      0.309045,    0.298636,    0.30632,     0.318605,    0.278798,   0.194001,    0.143538,    0.152477,
      0.163915,    0.153089,    0.151568,    0.160636,    0.156323,   0.151063,    0.158505,    0.158725,
      0.150879,    0.156072,    0.161554,    0.150904,    0.151443,   0.169127,    0.14701,     0.0648246,
      -0.0049371,  -0.00941799, 0.00769007,  0.00115396,  -0.0060715, 0.0028314,   0.00333281,  -0.00472486,
      -2.2579e-16, 0.00472486,  -0.00333281, -0.0028314,  0.0060715,  -0.00115396, -0.00769007, 0.00941799,
      0.0049371,   -0.0648246,  -0.14701,    -0.169127,   -0.151443,  -0.150904,   -0.161554,   -0.156072,
      -0.150879,   -0.158725,   -0.158505,   -0.151063,   -0.156323,  -0.160636,   -0.151568,   -0.153089,
      -0.163915,   -0.152477,   -0.143538,   -0.194001,   -0.278798,  -0.318605,   -0.30632,    -0.298636,
      -0.309045,   -0.308671,   -0.300972,   -0.305806,   -0.309765,  -0.302586,   -0.303383,   -0.310482,
      -0.304478,   -0.300473,   -0.311374,   -0.308008,   -0.292422,  -0.32131,    -0.398587,   -0.451846,
      -0.449583,   -0.43739,    -0.444271,   -0.448389,   -0.441226,  -0.441885,   -0.447831,   -0.443504,
      -0.440345,   -0.447114,   -0.445806,   -0.438739,   -0.445973,  -0.449792,   -0.434499,   -0.44427,
      -0.506302,   -0.566018,   -0.575446,   -0.562754,   -0.564709,  -0.570936,   -0.56656,    -0.563996,
      -0.56916,    -0.568548,   -0.563728,   -0.5676,     -0.570317,  -0.563633,   -0.56549,    -0.573162,
      -0.563069,   -0.559467,   -0.602885,   -0.662366,   -0.682348,  -0.672467,   -0.670365,   -0.676143,
      -0.67484,    -0.671349,   -0.674006,   -0.675895,   -0.672138,  -0.67237,    -0.676676,   -0.673123,
      -0.670306,   -0.677888,   -0.674881,   -0.664162,   -0.690603,  -0.748995,   -0.779661,   -0.773435,
      -0.768902,   -0.773635,   -0.773699,   -0.771112,   -0.771777,  -0.773728,   -0.772564,   -0.770402,
      -0.773591,   -0.774354,   -0.768426,   -0.773404,   -0.778441,  -0.761194,   -0.777712,   -0.872316,
      -0.953243,   -0.949624,   -0.933595,   -0.947615,   -0.946524,  -0.937152,   -0.946322,   -0.94606,
      -0.937857,   -0.94606,    -0.946322,   -0.937152,   -0.946524,  -0.947615,   -0.933595,   -0.949624,
      -0.953243,   -0.872316,   -0.777712,   -0.761194,   -0.778441,  -0.773404,   -0.768426,   -0.774354,
      -0.773591,   -0.770402,   -0.772564,   -0.773728,   -0.771777,  -0.771112,   -0.773699,   -0.773635,
      -0.768902,   -0.773435,   -0.779661,   -0.748995,   -0.690603,  -0.664162,   -0.674881,   -0.677888,
      -0.670306,   -0.673123,   -0.676676,   -0.67237,    -0.672138,  -0.675895,   -0.674006,   -0.671349,
      -0.67484,    -0.676143,   -0.670365,   -0.672467,   -0.682348,  -0.662366,   -0.602885,   -0.559467,
      -0.563069,   -0.573162,   -0.56549,    -0.563633,   -0.570317,  -0.5676,     -0.563728,   -0.568548,
      -0.56916,    -0.563996,   -0.56656,    -0.570936,   -0.564709,  -0.562754,   -0.575446,   -0.566018,
      -0.506302,   -0.44427,    -0.434499,   -0.449792,   -0.445973,  -0.438739,   -0.445806,   -0.447114,
      -0.440345,   -0.443504,   -0.447831,   -0.441885,   -0.441226,  -0.448389,   -0.444271,   -0.43739,
      -0.449583,   -0.451846,   -0.398587,   -0.32131,    -0.292422,  -0.308008,   -0.311374,   -0.300473,
      -0.304478,   -0.310482,   -0.303383,   -0.302586,   -0.309765,  -0.305806,   -0.300972,   -0.308671,
      -0.309045,   -0.298636,   -0.30632,    -0.318605,   -0.278798,  -0.194001,   -0.143538,   -0.152477,
      -0.163915,   -0.153089,   -0.151568,   -0.160636,   -0.156323,  -0.151063,   -0.158505,   -0.158725,
      -0.150879,   -0.156072,   -0.161554,   -0.150904,   -0.151443,  -0.169127,   -0.14701,    -0.0648246,
      0.0049371,   0.00941798,  -0.00769008, -0.00115397, 0.0060715,  -0.00283142, -0.00333282, 0.00472486},
     {0,           0.000582774,  0.00141694,  -0.00165356,  -0.00269572, 0.00431397,   0.00350693,
      -0.0111675,  -0.000474673, 0.0653202,   0.142528,     0.169769,    0.155834,     0.149055,
      0.157476,    0.159271,     0.154162,    0.154235,     0.156655,    0.156377,     0.156264,
      0.155311,    0.153568,     0.157577,    0.160424,     0.149368,    0.147834,     0.195633,
      0.274276,    0.318263,     0.31078,     0.297864,     0.304738,    0.310586,     0.304958,
      0.302597,    0.306539,     0.307074,    0.30521,      0.305139,    0.304569,     0.305853,
      0.30929,     0.303488,     0.296046,    0.324374,     0.394166,    0.450341,     0.454153,
      0.437582,    0.439861,     0.449258,    0.445431,     0.439964,    0.443915,     0.446662,
      0.443583,    0.442651,     0.443913,    0.444141,     0.445918,    0.444286,     0.436647,
      0.448891,    0.502526,     0.562962,    0.580014,     0.564138,    0.560101,     0.570883,
      0.570879,    0.563095,     0.565081,    0.570351,     0.567626,    0.564622,     0.566917,
      0.568017,    0.567657,     0.567631,    0.562915,     0.565265,    0.600739,     0.657466,
      0.686314,    0.675621,     0.665591,    0.674848,     0.679477,    0.67131,      0.669864,
      0.676656,    0.676042,     0.671013,    0.672643,     0.675565,    0.674311,     0.67374,
      0.671814,    0.67004,      0.691514,    0.742349,     0.781586,    0.77925,      0.764606,
      0.769962,    0.778924,     0.772464,    0.767111,     0.773663,    0.776207,     0.770558,
      0.77004,     0.773662,     0.77347,     0.773412,     0.771128,    0.764268,     0.786051,
      0.864167,    0.947114,     0.962692,    0.933759,     0.932631,    0.954426,     0.949187,
      0.931462,    0.941446,     0.955462,    0.941446,     0.931462,    0.949187,     0.954426,
      0.932631,    0.933759,     0.962692,    0.947114,     0.864167,    0.786051,     0.764268,
      0.771128,    0.773412,     0.77347,     0.773662,     0.77004,     0.770558,     0.776207,
      0.773663,    0.767111,     0.772464,    0.778924,     0.769962,    0.764606,     0.77925,
      0.781586,    0.742349,     0.691514,    0.67004,      0.671814,    0.67374,      0.674311,
      0.675565,    0.672643,     0.671013,    0.676042,     0.676656,    0.669864,     0.67131,
      0.679477,    0.674848,     0.665591,    0.675621,     0.686314,    0.657466,     0.600739,
      0.565265,    0.562915,     0.567631,    0.567657,     0.568017,    0.566917,     0.564622,
      0.567626,    0.570351,     0.565081,    0.563095,     0.570879,    0.570883,     0.560101,
      0.564138,    0.580014,     0.562962,    0.502526,     0.448891,    0.436647,     0.444286,
      0.445918,    0.444141,     0.443913,    0.442651,     0.443583,    0.446662,     0.443915,
      0.439964,    0.445431,     0.449258,    0.439861,     0.437582,    0.454153,     0.450341,
      0.394166,    0.324374,     0.296046,    0.303488,     0.30929,     0.305853,     0.304569,
      0.305139,    0.30521,      0.307074,    0.306539,     0.302597,    0.304958,     0.310586,
      0.304738,    0.297864,     0.31078,     0.318263,     0.274276,    0.195633,     0.147834,
      0.149368,    0.160424,     0.157577,    0.153568,     0.155311,    0.156264,     0.156377,
      0.156655,    0.154235,     0.154162,    0.159271,     0.157476,    0.149055,     0.155834,
      0.169769,    0.142528,     0.0653202,   -0.000474672, -0.0111675,  0.00350692,   0.00431396,
      -0.00269572, -0.00165357,  0.00141693,  0.000582773,  7.64573e-17, -0.000582773, -0.00141693,
      0.00165357,  0.00269572,   -0.00431396, -0.00350692,  0.0111675,   0.000474672,  -0.0653202,
      -0.142528,   -0.169769,    -0.155834,   -0.149055,    -0.157476,   -0.159271,    -0.154162,
      -0.154235,   -0.156655,    -0.156377,   -0.156264,    -0.155311,   -0.153568,    -0.157577,
      -0.160424,   -0.149368,    -0.147834,   -0.195633,    -0.274276,   -0.318263,    -0.31078,
      -0.297864,   -0.304738,    -0.310586,   -0.304958,    -0.302597,   -0.306539,    -0.307074,
      -0.30521,    -0.305139,    -0.304569,   -0.305853,    -0.30929,    -0.303488,    -0.296046,
      -0.324374,   -0.394166,    -0.450341,   -0.454153,    -0.437582,   -0.439861,    -0.449258,
      -0.445431,   -0.439964,    -0.443915,   -0.446662,    -0.443583,   -0.442651,    -0.443913,
      -0.444141,   -0.445918,    -0.444286,   -0.436647,    -0.448891,   -0.502526,    -0.562962,
      -0.580014,   -0.564138,    -0.560101,   -0.570883,    -0.570879,   -0.563095,    -0.565081,
      -0.570351,   -0.567626,    -0.564622,   -0.566917,    -0.568017,   -0.567657,    -0.567631,
      -0.562915,   -0.565265,    -0.600739,   -0.657466,    -0.686314,   -0.675621,    -0.665591,
      -0.674848,   -0.679477,    -0.67131,    -0.669864,    -0.676656,   -0.676042,    -0.671013,
      -0.672643,   -0.675565,    -0.674311,   -0.67374,     -0.671814,   -0.67004,     -0.691514,
      -0.742349,   -0.781586,    -0.77925,    -0.764606,    -0.769962,   -0.778924,    -0.772464,
      -0.767111,   -0.773663,    -0.776207,   -0.770558,    -0.77004,    -0.773662,    -0.77347,
      -0.773412,   -0.771128,    -0.764268,   -0.786051,    -0.864167,   -0.947114,    -0.962692,
      -0.933759,   -0.932631,    -0.954426,   -0.949187,    -0.931462,   -0.941446,    -0.955462,
      -0.941446,   -0.931462,    -0.949187,   -0.954426,    -0.932631,   -0.933759,    -0.962692,
      -0.947114,   -0.864167,    -0.786051,   -0.764268,    -0.771128,   -0.773412,    -0.77347,
      -0.773662,   -0.77004,     -0.770558,   -0.776207,    -0.773663,   -0.767111,    -0.772464,
      -0.778924,   -0.769962,    -0.764606,   -0.77925,     -0.781586,   -0.742349,    -0.691514,
      -0.67004,    -0.671814,    -0.67374,    -0.674311,    -0.675565,   -0.672643,    -0.671013,
      -0.676042,   -0.676656,    -0.669864,   -0.67131,     -0.679477,   -0.674848,    -0.665591,
      -0.675621,   -0.686314,    -0.657466,   -0.600739,    -0.565265,   -0.562915,    -0.567631,
      -0.567657,   -0.568017,    -0.566917,   -0.564622,    -0.567626,   -0.570351,    -0.565081,
      -0.563095,   -0.570879,    -0.570883,   -0.560101,    -0.564138,   -0.580014,    -0.562962,
      -0.502526,   -0.448891,    -0.436647,   -0.444286,    -0.445918,   -0.444141,    -0.443913,
      -0.442651,   -0.443583,    -0.446662,   -0.443915,    -0.439964,   -0.445431,    -0.449258,
      -0.439861,   -0.437582,    -0.454153,   -0.450341,    -0.394166,   -0.324374,    -0.296046,
      -0.303488,   -0.30929,     -0.305853,   -0.304569,    -0.305139,   -0.30521,     -0.307074,
      -0.306539,   -0.302597,    -0.304958,   -0.310586,    -0.304738,   -0.297864,    -0.31078,
      -0.318263,   -0.274276,    -0.195633,   -0.147834,    -0.149368,   -0.160424,    -0.157577,
      -0.153568,   -0.155311,    -0.156264,   -0.156377,    -0.156655,   -0.154235,    -0.154162,
      -0.159271,   -0.157476,    -0.149055,   -0.155834,    -0.169769,   -0.142528,    -0.0653202,
      0.000474673, 0.0111675,    -0.00350693, -0.00431397,  0.00269572,  0.00165356,   -0.00141694,
      -0.000582774},
     {0,           0.00620388,  0.000225558,  -0.00686878, -0.000403506, 0.00874673,  0.000288119,  -0.0144978,
      0.00342598,  0.0673075,   0.138242,     0.169268,    0.160179,     0.148033,    0.153404,     0.161742,
      0.157651,    0.150494,    0.154015,     0.161118,    0.157851,     0.149912,    0.153155,     0.163243,
      0.159628,    0.143842,    0.149779,     0.200619,    0.271329,     0.314176,    0.314506,     0.300756,
      0.300518,    0.309097,    0.30935,      0.302576,    0.302312,     0.308604,    0.308947,     0.302211,
      0.301613,    0.309967,    0.311235,     0.298484,    0.295266,     0.329907,    0.393716,     0.444679,
      0.455803,    0.442965,    0.437133,     0.444542,    0.449029,     0.443674,    0.439722,     0.444226,
      0.448045,    0.443638,    0.439528,     0.444674,    0.449879,     0.442274,    0.433426,     0.452239,
      0.504746,    0.558521,    0.578979,     0.569353,    0.559855,     0.56527,     0.5724,       0.568702,
      0.562392,    0.565153,    0.57128,      0.569038,    0.562581,     0.564699,    0.572332,     0.569614,
      0.558281,    0.564758,    0.604948,     0.656462,    0.682892,     0.678061,    0.667919,     0.671149,
      0.678472,    0.676003,    0.669418,     0.671306,    0.677952,     0.676636,    0.669378,     0.670068,
      0.678702,    0.67872,     0.666634,     0.665926,    0.697055,     0.745311,    0.776177,     0.777641,
      0.769355,    0.770117,    0.77536,      0.773758,    0.768996,     0.77103,     0.776423,     0.774321,
      0.7674,      0.769056,    0.778736,     0.77851,     0.763175,     0.759064,    0.796604,     0.869088,
      0.934192,    0.958422,    0.948683,     0.935931,    0.937982,     0.947103,    0.948855,     0.942159,
      0.937746,    0.942159,    0.948855,     0.947103,    0.937982,     0.935931,    0.948683,     0.958422,
      0.934192,    0.869088,    0.796604,     0.759064,    0.763175,     0.77851,     0.778736,     0.769056,
      0.7674,      0.774321,    0.776423,     0.77103,     0.768996,     0.773758,    0.77536,      0.770117,
      0.769355,    0.777641,    0.776177,     0.745311,    0.697055,     0.665926,    0.666634,     0.67872,
      0.678702,    0.670068,    0.669378,     0.676636,    0.677952,     0.671306,    0.669418,     0.676003,
      0.678472,    0.671149,    0.667919,     0.678061,    0.682892,     0.656462,    0.604948,     0.564758,
      0.558281,    0.569614,    0.572332,     0.564699,    0.562581,     0.569038,    0.57128,      0.565153,
      0.562392,    0.568702,    0.5724,       0.56527,     0.559855,     0.569353,    0.578979,     0.558521,
      0.504746,    0.452239,    0.433426,     0.442274,    0.449879,     0.444674,    0.439528,     0.443638,
      0.448045,    0.444226,    0.439722,     0.443674,    0.449029,     0.444542,    0.437133,     0.442965,
      0.455803,    0.444679,    0.393716,     0.329907,    0.295266,     0.298484,    0.311235,     0.309967,
      0.301613,    0.302211,    0.308947,     0.308604,    0.302312,     0.302576,    0.30935,      0.309097,
      0.300518,    0.300756,    0.314506,     0.314176,    0.271329,     0.200619,    0.149779,     0.143842,
      0.159628,    0.163243,    0.153155,     0.149912,    0.157851,     0.161118,    0.154015,     0.150494,
      0.157651,    0.161742,    0.153404,     0.148033,    0.160179,     0.169268,    0.138242,     0.0673075,
      0.00342598,  -0.0144978,  0.000288113,  0.00874672,  -0.000403511, -0.00686879, 0.000225551,  0.00620388,
      2.00141e-16, -0.00620388, -0.000225551, 0.00686879,  0.000403511,  -0.00874672, -0.000288113, 0.0144978,
      -0.00342598, -0.0673075,  -0.138242,    -0.169268,   -0.160179,    -0.148033,   -0.153404,    -0.161742,
      -0.157651,   -0.150494,   -0.154015,    -0.161118,   -0.157851,    -0.149912,   -0.153155,    -0.163243,
      -0.159628,   -0.143842,   -0.149779,    -0.200619,   -0.271329,    -0.314176,   -0.314506,    -0.300756,
      -0.300518,   -0.309097,   -0.30935,     -0.302576,   -0.302312,    -0.308604,   -0.308947,    -0.302211,
      -0.301613,   -0.309967,   -0.311235,    -0.298484,   -0.295266,    -0.329907,   -0.393716,    -0.444679,
      -0.455803,   -0.442965,   -0.437133,    -0.444542,   -0.449029,    -0.443674,   -0.439722,    -0.444226,
      -0.448045,   -0.443638,   -0.439528,    -0.444674,   -0.449879,    -0.442274,   -0.433426,    -0.452239,
      -0.504746,   -0.558521,   -0.578979,    -0.569353,   -0.559855,    -0.56527,    -0.5724,      -0.568702,
      -0.562392,   -0.565153,   -0.57128,     -0.569038,   -0.562581,    -0.564699,   -0.572332,    -0.569614,
      -0.558281,   -0.564758,   -0.604948,    -0.656462,   -0.682892,    -0.678061,   -0.667919,    -0.671149,
      -0.678472,   -0.676003,   -0.669418,    -0.671306,   -0.677952,    -0.676636,   -0.669378,    -0.670068,
      -0.678702,   -0.67872,    -0.666634,    -0.665926,   -0.697055,    -0.745311,   -0.776177,    -0.777641,
      -0.769355,   -0.770117,   -0.77536,     -0.773758,   -0.768996,    -0.77103,    -0.776423,    -0.774321,
      -0.7674,     -0.769056,   -0.778736,    -0.77851,    -0.763175,    -0.759064,   -0.796604,    -0.869088,
      -0.934192,   -0.958422,   -0.948683,    -0.935931,   -0.937982,    -0.947103,   -0.948855,    -0.942159,
      -0.937746,   -0.942159,   -0.948855,    -0.947103,   -0.937982,    -0.935931,   -0.948683,    -0.958422,
      -0.934192,   -0.869088,   -0.796604,    -0.759064,   -0.763175,    -0.77851,    -0.778736,    -0.769056,
      -0.7674,     -0.774321,   -0.776423,    -0.77103,    -0.768996,    -0.773758,   -0.77536,     -0.770117,
      -0.769355,   -0.777641,   -0.776177,    -0.745311,   -0.697055,    -0.665926,   -0.666634,    -0.67872,
      -0.678702,   -0.670068,   -0.669378,    -0.676636,   -0.677952,    -0.671306,   -0.669418,    -0.676003,
      -0.678472,   -0.671149,   -0.667919,    -0.678061,   -0.682892,    -0.656462,   -0.604948,    -0.564758,
      -0.558281,   -0.569614,   -0.572332,    -0.564699,   -0.562581,    -0.569038,   -0.57128,     -0.565153,
      -0.562392,   -0.568702,   -0.5724,      -0.56527,    -0.559855,    -0.569353,   -0.578979,    -0.558521,
      -0.504746,   -0.452239,   -0.433426,    -0.442274,   -0.449879,    -0.444674,   -0.439528,    -0.443638,
      -0.448045,   -0.444226,   -0.439722,    -0.443674,   -0.449029,    -0.444542,   -0.437133,    -0.442965,
      -0.455803,   -0.444679,   -0.393716,    -0.329907,   -0.295266,    -0.298484,   -0.311235,    -0.309967,
      -0.301613,   -0.302211,   -0.308947,    -0.308604,   -0.302312,    -0.302576,   -0.30935,     -0.309097,
      -0.300518,   -0.300756,   -0.314506,    -0.314176,   -0.271329,    -0.200619,   -0.149779,    -0.143842,
      -0.159628,   -0.163243,   -0.153155,    -0.149912,   -0.157851,    -0.161118,   -0.154015,    -0.150494,
      -0.157651,   -0.161742,   -0.153404,    -0.148033,   -0.160179,    -0.169268,   -0.138242,    -0.0673075,
      -0.00342598, 0.0144978,   -0.000288119, -0.00874673, 0.000403506,  0.00686878,  -0.000225558, -0.00620388},
     {0,           -0.00740607, -0.00523433, 0.00445379,  0.0094998,   0.00151135,  -0.0122812, -0.0123205,  0.0165439,
      0.0702227,   0.126588,    0.162039,    0.168802,    0.158257,    0.14877,     0.150082,   0.157944,    0.162027,
      0.157898,    0.151138,    0.150379,    0.15711,     0.163263,    0.159789,    0.14818,    0.14297,     0.160983,
      0.205859,    0.262088,    0.305209,    0.320207,    0.312093,    0.299441,    0.297298,   0.305526,    0.312727,
      0.310357,    0.301939,    0.29822,     0.304257,    0.312968,    0.312711,    0.301335,   0.291737,    0.302071,
      0.339178,    0.390895,    0.434642,    0.454571,    0.452137,    0.441832,    0.437467,   0.44184,     0.447903,
      0.448298,    0.443177,    0.439165,    0.441474,    0.447678,    0.449848,    0.443475,   0.434566,    0.437103,
      0.461633,    0.504609,    0.548711,    0.575172,    0.577975,    0.567347,    0.559486,   0.562277,    0.570364,
      0.573404,    0.568121,    0.561445,    0.561925,    0.569376,    0.574555,    0.569741,   0.558959,    0.556487,
      0.574275,    0.610366,    0.649511,    0.675207,    0.681809,    0.676406,    0.670497,   0.670331,    0.674106,
      0.676564,    0.675158,    0.672061,    0.671202,    0.673838,    0.676941,    0.676054,   0.670577,    0.666796,
      0.674793,    0.700125,    0.736879,    0.769508,    0.783959,    0.779145,    0.767661,   0.763993,    0.771208,
      0.779557,    0.778514,    0.769245,    0.763437,    0.769309,    0.780643,    0.782539,   0.769279,    0.754961,
      0.763557,    0.806527,    0.870166,    0.92577,     0.952833,    0.953031,    0.943435,   0.938703,    0.940863,
      0.944022,    0.944566,    0.944152,    0.944566,    0.944022,    0.940863,    0.938703,   0.943435,    0.953031,
      0.952833,    0.92577,     0.870166,    0.806527,    0.763557,    0.754961,    0.769279,   0.782539,    0.780643,
      0.769309,    0.763437,    0.769245,    0.778514,    0.779557,    0.771208,    0.763993,   0.767661,    0.779145,
      0.783959,    0.769508,    0.736879,    0.700125,    0.674793,    0.666796,    0.670577,   0.676054,    0.676941,
      0.673838,    0.671202,    0.672061,    0.675158,    0.676564,    0.674106,    0.670331,   0.670497,    0.676406,
      0.681809,    0.675207,    0.649511,    0.610366,    0.574275,    0.556487,    0.558959,   0.569741,    0.574555,
      0.569376,    0.561925,    0.561445,    0.568121,    0.573404,    0.570364,    0.562277,   0.559486,    0.567347,
      0.577975,    0.575172,    0.548711,    0.504609,    0.461633,    0.437103,    0.434566,   0.443475,    0.449848,
      0.447678,    0.441474,    0.439165,    0.443177,    0.448298,    0.447903,    0.44184,    0.437467,    0.441832,
      0.452137,    0.454571,    0.434642,    0.390895,    0.339178,    0.302071,    0.291737,   0.301335,    0.312711,
      0.312968,    0.304257,    0.29822,     0.301939,    0.310357,    0.312727,    0.305526,   0.297298,    0.299441,
      0.312093,    0.320207,    0.305209,    0.262088,    0.205859,    0.160983,    0.14297,    0.14818,     0.159789,
      0.163263,    0.15711,     0.150379,    0.151138,    0.157898,    0.162027,    0.157944,   0.150082,    0.14877,
      0.158257,    0.168802,    0.162039,    0.126588,    0.0702227,   0.0165439,   -0.0123205, -0.0122812,  0.00151133,
      0.0094998,   0.00445378,  -0.00523434, -0.00740608, -6.4937e-18, 0.00740608,  0.00523434, -0.00445378, -0.0094998,
      -0.00151133, 0.0122812,   0.0123205,   -0.0165439,  -0.0702227,  -0.126588,   -0.162039,  -0.168802,   -0.158257,
      -0.14877,    -0.150082,   -0.157944,   -0.162027,   -0.157898,   -0.151138,   -0.150379,  -0.15711,    -0.163263,
      -0.159789,   -0.14818,    -0.14297,    -0.160983,   -0.205859,   -0.262088,   -0.305209,  -0.320207,   -0.312093,
      -0.299441,   -0.297298,   -0.305526,   -0.312727,   -0.310357,   -0.301939,   -0.29822,   -0.304257,   -0.312968,
      -0.312711,   -0.301335,   -0.291737,   -0.302071,   -0.339178,   -0.390895,   -0.434642,  -0.454571,   -0.452137,
      -0.441832,   -0.437467,   -0.44184,    -0.447903,   -0.448298,   -0.443177,   -0.439165,  -0.441474,   -0.447678,
      -0.449848,   -0.443475,   -0.434566,   -0.437103,   -0.461633,   -0.504609,   -0.548711,  -0.575172,   -0.577975,
      -0.567347,   -0.559486,   -0.562277,   -0.570364,   -0.573404,   -0.568121,   -0.561445,  -0.561925,   -0.569376,
      -0.574555,   -0.569741,   -0.558959,   -0.556487,   -0.574275,   -0.610366,   -0.649511,  -0.675207,   -0.681809,
      -0.676406,   -0.670497,   -0.670331,   -0.674106,   -0.676564,   -0.675158,   -0.672061,  -0.671202,   -0.673838,
      -0.676941,   -0.676054,   -0.670577,   -0.666796,   -0.674793,   -0.700125,   -0.736879,  -0.769508,   -0.783959,
      -0.779145,   -0.767661,   -0.763993,   -0.771208,   -0.779557,   -0.778514,   -0.769245,  -0.763437,   -0.769309,
      -0.780643,   -0.782539,   -0.769279,   -0.754961,   -0.763557,   -0.806527,   -0.870166,  -0.92577,    -0.952833,
      -0.953031,   -0.943435,   -0.938703,   -0.940863,   -0.944022,   -0.944566,   -0.944152,  -0.944566,   -0.944022,
      -0.940863,   -0.938703,   -0.943435,   -0.953031,   -0.952833,   -0.92577,    -0.870166,  -0.806527,   -0.763557,
      -0.754961,   -0.769279,   -0.782539,   -0.780643,   -0.769309,   -0.763437,   -0.769245,  -0.778514,   -0.779557,
      -0.771208,   -0.763993,   -0.767661,   -0.779145,   -0.783959,   -0.769508,   -0.736879,  -0.700125,   -0.674793,
      -0.666796,   -0.670577,   -0.676054,   -0.676941,   -0.673838,   -0.671202,   -0.672061,  -0.675158,   -0.676564,
      -0.674106,   -0.670331,   -0.670497,   -0.676406,   -0.681809,   -0.675207,   -0.649511,  -0.610366,   -0.574275,
      -0.556487,   -0.558959,   -0.569741,   -0.574555,   -0.569376,   -0.561925,   -0.561445,  -0.568121,   -0.573404,
      -0.570364,   -0.562277,   -0.559486,   -0.567347,   -0.577975,   -0.575172,   -0.548711,  -0.504609,   -0.461633,
      -0.437103,   -0.434566,   -0.443475,   -0.449848,   -0.447678,   -0.441474,   -0.439165,  -0.443177,   -0.448298,
      -0.447903,   -0.44184,    -0.437467,   -0.441832,   -0.452137,   -0.454571,   -0.434642,  -0.390895,   -0.339178,
      -0.302071,   -0.291737,   -0.301335,   -0.312711,   -0.312968,   -0.304257,   -0.29822,   -0.301939,   -0.310357,
      -0.312727,   -0.305526,   -0.297298,   -0.299441,   -0.312093,   -0.320207,   -0.305209,  -0.262088,   -0.205859,
      -0.160983,   -0.14297,    -0.14818,    -0.159789,   -0.163263,   -0.15711,    -0.150379,  -0.151138,   -0.157898,
      -0.162027,   -0.157944,   -0.150082,   -0.14877,    -0.158257,   -0.168802,   -0.162039,  -0.126588,   -0.0702227,
      -0.0165439,  0.0123205,   0.0122812,   -0.00151135, -0.0094998,  -0.00445379, 0.00523433, 0.00740607},
     {0,          0.00837953,  0.0108024,   0.00503347, -0.0058174,  -0.0145998,  -0.0135096, 0.00230347,  0.0326174,
      0.0722226,  0.112854,    0.14604,     0.165882,   0.170961,    0.164727,    0.154064,   0.146331,    0.14603,
      0.152757,   0.161681,    0.166519,    0.163441,   0.1537,      0.143422,    0.140712,   0.151692,    0.177615,
      0.21433,    0.254057,    0.288348,    0.310932,   0.319557,    0.316418,    0.307147,   0.29856,     0.29582,
      0.300161,   0.308403,    0.314822,    0.314614,   0.307088,    0.296661,    0.290932,   0.296887,    0.317348,
      0.349595,   0.386657,    0.420298,    0.444089,   0.455286,    0.455169,    0.448126,   0.439915,    0.435546,
      0.43732,    0.443822,    0.450652,    0.452899,   0.448269,    0.439056,    0.43153,    0.432882,    0.447393,
      0.474086,   0.507158,    0.538753,    0.562327,   0.574842,    0.577076,    0.572508,   0.565711,    0.56086,
      0.560494,   0.564622,    0.570619,    0.574403,   0.572794,    0.565915,    0.557995,   0.555647,    0.564322,
      0.585067,   0.613672,    0.642768,    0.665472,   0.678297,    0.681812,    0.679222,   0.674329,    0.670178,
      0.66865,    0.670381,    0.674516,    0.678632,   0.679632,    0.675777,    0.668704,   0.663649,    0.667023,
      0.68248,    0.708136,    0.737091,    0.761128,   0.775108,    0.779078,    0.776955,   0.773246,    0.770535,
      0.769312,   0.769448,    0.771184,    0.774455,   0.777502,    0.777059,    0.771137,   0.762657,    0.760361,
      0.774782,   0.810956,    0.863012,    0.915391,   0.951062,    0.96164,     0.952274,   0.937569,    0.931293,
      0.93735,    0.948598,    0.954058,    0.948598,   0.93735,     0.931293,    0.937569,   0.952274,    0.96164,
      0.951062,   0.915391,    0.863012,    0.810956,   0.774782,    0.760361,    0.762657,   0.771137,    0.777059,
      0.777502,   0.774455,    0.771184,    0.769448,   0.769312,    0.770535,    0.773246,   0.776955,    0.779078,
      0.775108,   0.761128,    0.737091,    0.708136,   0.68248,     0.667023,    0.663649,   0.668704,    0.675777,
      0.679632,   0.678632,    0.674516,    0.670381,   0.66865,     0.670178,    0.674329,   0.679222,    0.681812,
      0.678297,   0.665472,    0.642768,    0.613672,   0.585067,    0.564322,    0.555647,   0.557995,    0.565915,
      0.572794,   0.574403,    0.570619,    0.564622,   0.560494,    0.56086,     0.565711,   0.572508,    0.577076,
      0.574842,   0.562327,    0.538753,    0.507158,   0.474086,    0.447393,    0.432882,   0.43153,     0.439056,
      0.448269,   0.452899,    0.450652,    0.443822,   0.43732,     0.435546,    0.439915,   0.448126,    0.455169,
      0.455286,   0.444089,    0.420298,    0.386657,   0.349595,    0.317348,    0.296887,   0.290932,    0.296661,
      0.307088,   0.314614,    0.314822,    0.308403,   0.300161,    0.29582,     0.29856,    0.307147,    0.316418,
      0.319557,   0.310932,    0.288348,    0.254057,   0.21433,     0.177615,    0.151692,   0.140712,    0.143422,
      0.1537,     0.163441,    0.166519,    0.161681,   0.152757,    0.14603,     0.146331,   0.154064,    0.164727,
      0.170961,   0.165882,    0.14604,     0.112854,   0.0722226,   0.0326174,   0.00230347, -0.0135096,  -0.0145998,
      -0.0058174, 0.00503346,  0.0108024,   0.00837953, -7.4065e-17, -0.00837953, -0.0108024, -0.00503346, 0.0058174,
      0.0145998,  0.0135096,   -0.00230347, -0.0326174, -0.0722226,  -0.112854,   -0.14604,   -0.165882,   -0.170961,
      -0.164727,  -0.154064,   -0.146331,   -0.14603,   -0.152757,   -0.161681,   -0.166519,  -0.163441,   -0.1537,
      -0.143422,  -0.140712,   -0.151692,   -0.177615,  -0.21433,    -0.254057,   -0.288348,  -0.310932,   -0.319557,
      -0.316418,  -0.307147,   -0.29856,    -0.29582,   -0.300161,   -0.308403,   -0.314822,  -0.314614,   -0.307088,
      -0.296661,  -0.290932,   -0.296887,   -0.317348,  -0.349595,   -0.386657,   -0.420298,  -0.444089,   -0.455286,
      -0.455169,  -0.448126,   -0.439915,   -0.435546,  -0.43732,    -0.443822,   -0.450652,  -0.452899,   -0.448269,
      -0.439056,  -0.43153,    -0.432882,   -0.447393,  -0.474086,   -0.507158,   -0.538753,  -0.562327,   -0.574842,
      -0.577076,  -0.572508,   -0.565711,   -0.56086,   -0.560494,   -0.564622,   -0.570619,  -0.574403,   -0.572794,
      -0.565915,  -0.557995,   -0.555647,   -0.564322,  -0.585067,   -0.613672,   -0.642768,  -0.665472,   -0.678297,
      -0.681812,  -0.679222,   -0.674329,   -0.670178,  -0.66865,    -0.670381,   -0.674516,  -0.678632,   -0.679632,
      -0.675777,  -0.668704,   -0.663649,   -0.667023,  -0.68248,    -0.708136,   -0.737091,  -0.761128,   -0.775108,
      -0.779078,  -0.776955,   -0.773246,   -0.770535,  -0.769312,   -0.769448,   -0.771184,  -0.774455,   -0.777502,
      -0.777059,  -0.771137,   -0.762657,   -0.760361,  -0.774782,   -0.810956,   -0.863012,  -0.915391,   -0.951062,
      -0.96164,   -0.952274,   -0.937569,   -0.931293,  -0.93735,    -0.948598,   -0.954058,  -0.948598,   -0.93735,
      -0.931293,  -0.937569,   -0.952274,   -0.96164,   -0.951062,   -0.915391,   -0.863012,  -0.810956,   -0.774782,
      -0.760361,  -0.762657,   -0.771137,   -0.777059,  -0.777502,   -0.774455,   -0.771184,  -0.769448,   -0.769312,
      -0.770535,  -0.773246,   -0.776955,   -0.779078,  -0.775108,   -0.761128,   -0.737091,  -0.708136,   -0.68248,
      -0.667023,  -0.663649,   -0.668704,   -0.675777,  -0.679632,   -0.678632,   -0.674516,  -0.670381,   -0.66865,
      -0.670178,  -0.674329,   -0.679222,   -0.681812,  -0.678297,   -0.665472,   -0.642768,  -0.613672,   -0.585067,
      -0.564322,  -0.555647,   -0.557995,   -0.565915,  -0.572794,   -0.574403,   -0.570619,  -0.564622,   -0.560494,
      -0.56086,   -0.565711,   -0.572508,   -0.577076,  -0.574842,   -0.562327,   -0.538753,  -0.507158,   -0.474086,
      -0.447393,  -0.432882,   -0.43153,    -0.439056,  -0.448269,   -0.452899,   -0.450652,  -0.443822,   -0.43732,
      -0.435546,  -0.439915,   -0.448126,   -0.455169,  -0.455286,   -0.444089,   -0.420298,  -0.386657,   -0.349595,
      -0.317348,  -0.296887,   -0.290932,   -0.296661,  -0.307088,   -0.314614,   -0.314822,  -0.308403,   -0.300161,
      -0.29582,   -0.29856,    -0.307147,   -0.316418,  -0.319557,   -0.310932,   -0.288348,  -0.254057,   -0.21433,
      -0.177615,  -0.151692,   -0.140712,   -0.143422,  -0.1537,     -0.163441,   -0.166519,  -0.161681,   -0.152757,
      -0.14603,   -0.146331,   -0.154064,   -0.164727,  -0.170961,   -0.165882,   -0.14604,   -0.112854,   -0.0722226,
      -0.0326174, -0.00230347, 0.0135096,   0.0145998,  0.0058174,   -0.00503347, -0.0108024, -0.00837953},
     {0,          0.00673601,  0.0088131,   0.00423914, -0.004862,    -0.0127207,  -0.0121868,  0.00213636,  0.0312462,
      0.0708011,  0.112411,    0.146714,    0.166973,   0.17163,      0.164661,    0.153566,    0.145878,    0.145819,
      0.152667,   0.161595,    0.166565,    0.163845,   0.1544,       0.143919,    0.140429,    0.150586,    0.176416,
      0.214064,   0.255152,    0.290118,    0.311997,   0.318945,     0.314457,    0.305318,    0.298347,    0.297476,
      0.302436,   0.309515,    0.313893,    0.312385,   0.305309,     0.296676,    0.292635,    0.298878,    0.318118,
      0.348707,   0.384968,    0.419141,    0.444183,   0.456299,     0.456189,    0.448495,    0.439657,    0.435107,
      0.437007,   0.443579,    0.450331,    0.452649,   0.448508,     0.439968,    0.43263,     0.433217,    0.44637,
      0.472202,   0.505845,    0.539268,    0.56457,    0.577199,     0.577597,    0.570552,    0.562642,    0.559083,
      0.561523,   0.567768,    0.573454,    0.574685,   0.570289,     0.562596,    0.55644,     0.556973,    0.567362,
      0.587414,   0.613653,    0.640673,    0.663103,   0.677373,     0.682665,    0.680831,    0.675435,    0.670334,
      0.668278,   0.669996,    0.674093,    0.677837,   0.678604,     0.675436,    0.669982,    0.666254,    0.66909,
      0.681864,   0.704487,    0.732788,    0.759811,   0.778623,     0.785389,    0.781169,    0.771411,    0.763255,
      0.761936,   0.768139,    0.777766,    0.784344,   0.782867,     0.773064,    0.760255,    0.753238,    0.760179,
      0.784579,   0.823388,    0.868187,    0.90881,    0.937526,     0.951734,    0.954012,    0.949856,    0.94458,
      0.941128,   0.939791,    0.939545,    0.939791,   0.941128,     0.94458,     0.949856,    0.954012,    0.951734,
      0.937526,   0.90881,     0.868187,    0.823388,   0.784579,     0.760179,    0.753238,    0.760255,    0.773064,
      0.782867,   0.784344,    0.777766,    0.768139,   0.761936,     0.763255,    0.771411,    0.781169,    0.785389,
      0.778623,   0.759811,    0.732788,    0.704487,   0.681864,     0.66909,     0.666254,    0.669982,    0.675436,
      0.678604,   0.677837,    0.674093,    0.669996,   0.668278,     0.670334,    0.675435,    0.680831,    0.682665,
      0.677373,   0.663103,    0.640673,    0.613653,   0.587414,     0.567362,    0.556973,    0.55644,     0.562596,
      0.570289,   0.574685,    0.573454,    0.567768,   0.561523,     0.559083,    0.562642,    0.570552,    0.577597,
      0.577199,   0.56457,     0.539268,    0.505845,   0.472202,     0.44637,     0.433217,    0.43263,     0.439968,
      0.448508,   0.452649,    0.450331,    0.443579,   0.437007,     0.435107,    0.439657,    0.448495,    0.456189,
      0.456299,   0.444183,    0.419141,    0.384968,   0.348707,     0.318118,    0.298878,    0.292635,    0.296676,
      0.305309,   0.312385,    0.313893,    0.309515,   0.302436,     0.297476,    0.298347,    0.305318,    0.314457,
      0.318945,   0.311997,    0.290118,    0.255152,   0.214064,     0.176416,    0.150586,    0.140429,    0.143919,
      0.1544,     0.163845,    0.166565,    0.161595,   0.152667,     0.145819,    0.145878,    0.153566,    0.164661,
      0.17163,    0.166973,    0.146714,    0.112411,   0.0708011,    0.0312462,   0.00213635,  -0.0121868,  -0.0127207,
      -0.004862,  0.00423913,  0.00881309,  0.00673601, -1.57804e-16, -0.00673601, -0.00881309, -0.00423913, 0.004862,
      0.0127207,  0.0121868,   -0.00213635, -0.0312462, -0.0708011,   -0.112411,   -0.146714,   -0.166973,   -0.17163,
      -0.164661,  -0.153566,   -0.145878,   -0.145819,  -0.152667,    -0.161595,   -0.166565,   -0.163845,   -0.1544,
      -0.143919,  -0.140429,   -0.150586,   -0.176416,  -0.214064,    -0.255152,   -0.290118,   -0.311997,   -0.318945,
      -0.314457,  -0.305318,   -0.298347,   -0.297476,  -0.302436,    -0.309515,   -0.313893,   -0.312385,   -0.305309,
      -0.296676,  -0.292635,   -0.298878,   -0.318118,  -0.348707,    -0.384968,   -0.419141,   -0.444183,   -0.456299,
      -0.456189,  -0.448495,   -0.439657,   -0.435107,  -0.437007,    -0.443579,   -0.450331,   -0.452649,   -0.448508,
      -0.439968,  -0.43263,    -0.433217,   -0.44637,   -0.472202,    -0.505845,   -0.539268,   -0.56457,    -0.577199,
      -0.577597,  -0.570552,   -0.562642,   -0.559083,  -0.561523,    -0.567768,   -0.573454,   -0.574685,   -0.570289,
      -0.562596,  -0.55644,    -0.556973,   -0.567362,  -0.587414,    -0.613653,   -0.640673,   -0.663103,   -0.677373,
      -0.682665,  -0.680831,   -0.675435,   -0.670334,  -0.668278,    -0.669996,   -0.674093,   -0.677837,   -0.678604,
      -0.675436,  -0.669982,   -0.666254,   -0.66909,   -0.681864,    -0.704487,   -0.732788,   -0.759811,   -0.778623,
      -0.785389,  -0.781169,   -0.771411,   -0.763255,  -0.761936,    -0.768139,   -0.777766,   -0.784344,   -0.782867,
      -0.773064,  -0.760255,   -0.753238,   -0.760179,  -0.784579,    -0.823388,   -0.868187,   -0.90881,    -0.937526,
      -0.951734,  -0.954012,   -0.949856,   -0.94458,   -0.941128,    -0.939791,   -0.939545,   -0.939791,   -0.941128,
      -0.94458,   -0.949856,   -0.954012,   -0.951734,  -0.937526,    -0.90881,    -0.868187,   -0.823388,   -0.784579,
      -0.760179,  -0.753238,   -0.760255,   -0.773064,  -0.782867,    -0.784344,   -0.777766,   -0.768139,   -0.761936,
      -0.763255,  -0.771411,   -0.781169,   -0.785389,  -0.778623,    -0.759811,   -0.732788,   -0.704487,   -0.681864,
      -0.66909,   -0.666254,   -0.669982,   -0.675436,  -0.678604,    -0.677837,   -0.674093,   -0.669996,   -0.668278,
      -0.670334,  -0.675435,   -0.680831,   -0.682665,  -0.677373,    -0.663103,   -0.640673,   -0.613653,   -0.587414,
      -0.567362,  -0.556973,   -0.55644,    -0.562596,  -0.570289,    -0.574685,   -0.573454,   -0.567768,   -0.561523,
      -0.559083,  -0.562642,   -0.570552,   -0.577597,  -0.577199,    -0.56457,    -0.539268,   -0.505845,   -0.472202,
      -0.44637,   -0.433217,   -0.43263,    -0.439968,  -0.448508,    -0.452649,   -0.450331,   -0.443579,   -0.437007,
      -0.435107,  -0.439657,   -0.448495,   -0.456189,  -0.456299,    -0.444183,   -0.419141,   -0.384968,   -0.348707,
      -0.318118,  -0.298878,   -0.292635,   -0.296676,  -0.305309,    -0.312385,   -0.313893,   -0.309515,   -0.302436,
      -0.297476,  -0.298347,   -0.305318,   -0.314457,  -0.318945,    -0.311997,   -0.290118,   -0.255152,   -0.214064,
      -0.176416,  -0.150586,   -0.140429,   -0.143919,  -0.1544,      -0.163845,   -0.166565,   -0.161595,   -0.152667,
      -0.145819,  -0.145878,   -0.153566,   -0.164661,  -0.17163,     -0.166973,   -0.146714,   -0.112411,   -0.0708011,
      -0.0312462, -0.00213636, 0.0121868,   0.0127207,  0.004862,     -0.00423914, -0.0088131,  -0.00673601},
     {0,           0.00845384,   0.01127,   0.00604734, -0.00469817,  -0.0142446,  -0.0144921,
      0.000356463, 0.0309419,    0.0720486, 0.114422,   0.148339,     0.167373,    0.170715,
      0.163068,    0.15222,      0.145445,  0.146373,   0.153743,     0.162545,    0.166955,
      0.163651,    0.153908,     0.143462,  0.14016,    0.150449,     0.176292,    0.213955,
      0.255219,    0.290534,     0.31273,   0.319659,   0.314661,     0.304695,    0.297049,
      0.296153,    0.301908,     0.310262,  0.315677,   0.31428,      0.30619,     0.295893,
      0.290475,    0.296486,     0.316883,  0.34944,    0.387372,     0.421915,    0.445741,
      0.455691,    0.453691,     0.445486,  0.437843,   0.435533,     0.439445,    0.446648,
      0.452302,    0.452437,     0.446284,  0.437032,   0.430633,     0.43321,     0.448238,
      0.474799,    0.50771,      0.539469,  0.563178,   0.575142,     0.576041,    0.570215,
      0.563466,    0.560406,     0.56258,   0.568155,   0.57326,      0.574268,    0.569921,
      0.56227,     0.555984,     0.556345,  0.566857,   0.587546,     0.614744,    0.642449,
      0.664646,    0.67758,      0.680995,  0.677849,   0.672716,     0.66964,     0.670439,
      0.674193,    0.678089,     0.679161,  0.676071,   0.670063,     0.664652,    0.66417,
      0.671854,    0.688325,     0.711161,  0.735738,   0.756974,     0.771207,    0.777413,
      0.777279,    0.774161,     0.771455,  0.77112,    0.773008,     0.775262,    0.775562,
      0.772616,    0.767219,     0.76237,   0.76238,    0.77131,      0.79135,     0.821784,
      0.858919,    0.897022,     0.929922,  0.952735,   0.963173,     0.962049,    0.952884,
      0.940788,    0.930958,     0.927214,  0.930958,   0.940788,     0.952884,    0.962049,
      0.963173,    0.952735,     0.929922,  0.897022,   0.858919,     0.821784,    0.79135,
      0.77131,     0.76238,      0.76237,   0.767219,   0.772616,     0.775562,    0.775262,
      0.773008,    0.77112,      0.771455,  0.774161,   0.777279,     0.777413,    0.771207,
      0.756974,    0.735738,     0.711161,  0.688325,   0.671854,     0.66417,     0.664652,
      0.670063,    0.676071,     0.679161,  0.678089,   0.674193,     0.670439,    0.66964,
      0.672716,    0.677849,     0.680995,  0.67758,    0.664646,     0.642449,    0.614744,
      0.587546,    0.566857,     0.556345,  0.555984,   0.56227,      0.569921,    0.574268,
      0.57326,     0.568155,     0.56258,   0.560406,   0.563466,     0.570215,    0.576041,
      0.575142,    0.563178,     0.539469,  0.50771,    0.474799,     0.448238,    0.43321,
      0.430633,    0.437032,     0.446284,  0.452437,   0.452302,     0.446648,    0.439445,
      0.435533,    0.437843,     0.445486,  0.453691,   0.455691,     0.445741,    0.421915,
      0.387372,    0.34944,      0.316883,  0.296486,   0.290475,     0.295893,    0.30619,
      0.31428,     0.315677,     0.310262,  0.301908,   0.296153,     0.297049,    0.304695,
      0.314661,    0.319659,     0.31273,   0.290534,   0.255219,     0.213955,    0.176292,
      0.150449,    0.14016,      0.143462,  0.153908,   0.163651,     0.166955,    0.162545,
      0.153743,    0.146373,     0.145445,  0.15222,    0.163068,     0.170715,    0.167373,
      0.148339,    0.114422,     0.0720486, 0.0309419,  0.000356456,  -0.0144921,  -0.0142446,
      -0.00469817, 0.00604733,   0.01127,   0.00845384, -1.63882e-16, -0.00845384, -0.01127,
      -0.00604733, 0.00469817,   0.0142446, 0.0144921,  -0.000356456, -0.0309419,  -0.0720486,
      -0.114422,   -0.148339,    -0.167373, -0.170715,  -0.163068,    -0.15222,    -0.145445,
      -0.146373,   -0.153743,    -0.162545, -0.166955,  -0.163651,    -0.153908,   -0.143462,
      -0.14016,    -0.150449,    -0.176292, -0.213955,  -0.255219,    -0.290534,   -0.31273,
      -0.319659,   -0.314661,    -0.304695, -0.297049,  -0.296153,    -0.301908,   -0.310262,
      -0.315677,   -0.31428,     -0.30619,  -0.295893,  -0.290475,    -0.296486,   -0.316883,
      -0.34944,    -0.387372,    -0.421915, -0.445741,  -0.455691,    -0.453691,   -0.445486,
      -0.437843,   -0.435533,    -0.439445, -0.446648,  -0.452302,    -0.452437,   -0.446284,
      -0.437032,   -0.430633,    -0.43321,  -0.448238,  -0.474799,    -0.50771,    -0.539469,
      -0.563178,   -0.575142,    -0.576041, -0.570215,  -0.563466,    -0.560406,   -0.56258,
      -0.568155,   -0.57326,     -0.574268, -0.569921,  -0.56227,     -0.555984,   -0.556345,
      -0.566857,   -0.587546,    -0.614744, -0.642449,  -0.664646,    -0.67758,    -0.680995,
      -0.677849,   -0.672716,    -0.66964,  -0.670439,  -0.674193,    -0.678089,   -0.679161,
      -0.676071,   -0.670063,    -0.664652, -0.66417,   -0.671854,    -0.688325,   -0.711161,
      -0.735738,   -0.756974,    -0.771207, -0.777413,  -0.777279,    -0.774161,   -0.771455,
      -0.77112,    -0.773008,    -0.775262, -0.775562,  -0.772616,    -0.767219,   -0.76237,
      -0.76238,    -0.77131,     -0.79135,  -0.821784,  -0.858919,    -0.897022,   -0.929922,
      -0.952735,   -0.963173,    -0.962049, -0.952884,  -0.940788,    -0.930958,   -0.927214,
      -0.930958,   -0.940788,    -0.952884, -0.962049,  -0.963173,    -0.952735,   -0.929922,
      -0.897022,   -0.858919,    -0.821784, -0.79135,   -0.77131,     -0.76238,    -0.76237,
      -0.767219,   -0.772616,    -0.775562, -0.775262,  -0.773008,    -0.77112,    -0.771455,
      -0.774161,   -0.777279,    -0.777413, -0.771207,  -0.756974,    -0.735738,   -0.711161,
      -0.688325,   -0.671854,    -0.66417,  -0.664652,  -0.670063,    -0.676071,   -0.679161,
      -0.678089,   -0.674193,    -0.670439, -0.66964,   -0.672716,    -0.677849,   -0.680995,
      -0.67758,    -0.664646,    -0.642449, -0.614744,  -0.587546,    -0.566857,   -0.556345,
      -0.555984,   -0.56227,     -0.569921, -0.574268,  -0.57326,     -0.568155,   -0.56258,
      -0.560406,   -0.563466,    -0.570215, -0.576041,  -0.575142,    -0.563178,   -0.539469,
      -0.50771,    -0.474799,    -0.448238, -0.43321,   -0.430633,    -0.437032,   -0.446284,
      -0.452437,   -0.452302,    -0.446648, -0.439445,  -0.435533,    -0.437843,   -0.445486,
      -0.453691,   -0.455691,    -0.445741, -0.421915,  -0.387372,    -0.34944,    -0.316883,
      -0.296486,   -0.290475,    -0.295893, -0.30619,   -0.31428,     -0.315677,   -0.310262,
      -0.301908,   -0.296153,    -0.297049, -0.304695,  -0.314661,    -0.319659,   -0.31273,
      -0.290534,   -0.255219,    -0.213955, -0.176292,  -0.150449,    -0.14016,    -0.143462,
      -0.153908,   -0.163651,    -0.166955, -0.162545,  -0.153743,    -0.146373,   -0.145445,
      -0.15222,    -0.163068,    -0.170715, -0.167373,  -0.148339,    -0.114422,   -0.0720486,
      -0.0309419,  -0.000356463, 0.0144921, 0.0142446,  0.00469817,   -0.00604734, -0.01127,
      -0.00845384},
     {0,          -0.00732991, -0.0129986,  -0.0154739,  -0.0134888,   -0.00618281, 0.00676461, 0.0250363,  0.0476464,
      0.0730024,  0.0990727,   0.123644,    0.144635,    0.16041,      0.170029,    0.173394,   0.171248,   0.165048,
      0.156719,   0.14836,     0.141953,    0.139119,    0.140961,     0.148,       0.160186,   0.176966,   0.197374,
      0.220131,   0.243739,    0.266589,    0.287083,    0.303782,     0.315577,    0.321861,   0.322664,   0.318718,
      0.31142,    0.302669,    0.294615,    0.289336,    0.288522,     0.293213,    0.30366,    0.319318,   0.33897,
      0.360963,   0.383469,    0.404752,    0.423365,    0.438273,     0.448892,    0.455068,   0.457035,   0.455363,
      0.45092,    0.444838,    0.438465,    0.433277,    0.430742,     0.432129,    0.438303,   0.449542,   0.465422,
      0.484826,   0.506079,    0.527201,    0.546232,    0.561553,     0.572147,    0.57773,    0.578739,   0.576187,
      0.571435,   0.565933,    0.561003,    0.557706,    0.556789,     0.558715,    0.563724,   0.57188,    0.583076,
      0.596992,   0.613027,    0.630252,    0.647415,    0.663062,     0.67574,     0.68427,    0.688012,   0.687066,
      0.682313,   0.675298,    0.667954,    0.662225,    0.659691,     0.661285,    0.667162,   0.676769,   0.68906,
      0.702808,   0.716897,    0.730522,    0.743234,    0.754841,     0.765213,    0.774087,   0.780957,   0.785125,
      0.785917,   0.783003,    0.776732,    0.768345,    0.759956,     0.754279,    0.754101,   0.761638,   0.77793,
      0.802442,   0.833019,    0.866226,    0.898022,    0.924626,     0.943336,    0.953125,   0.954817,   0.950814,
      0.944424,   0.938957,    0.936839,    0.938957,    0.944424,     0.950814,    0.954817,   0.953125,   0.943336,
      0.924626,   0.898022,    0.866226,    0.833019,    0.802442,     0.77793,     0.761638,   0.754101,   0.754279,
      0.759956,   0.768345,    0.776732,    0.783003,    0.785917,     0.785125,    0.780957,   0.774087,   0.765213,
      0.754841,   0.743234,    0.730522,    0.716897,    0.702808,     0.68906,     0.676769,   0.667162,   0.661285,
      0.659691,   0.662225,    0.667954,    0.675298,    0.682313,     0.687066,    0.688012,   0.68427,    0.67574,
      0.663062,   0.647415,    0.630252,    0.613027,    0.596992,     0.583076,    0.57188,    0.563724,   0.558715,
      0.556789,   0.557706,    0.561003,    0.565933,    0.571435,     0.576187,    0.578739,   0.57773,    0.572147,
      0.561553,   0.546232,    0.527201,    0.506079,    0.484826,     0.465422,    0.449542,   0.438303,   0.432129,
      0.430742,   0.433277,    0.438465,    0.444838,    0.45092,      0.455363,    0.457035,   0.455068,   0.448892,
      0.438273,   0.423365,    0.404752,    0.383469,    0.360963,     0.33897,     0.319318,   0.30366,    0.293213,
      0.288522,   0.289336,    0.294615,    0.302669,    0.31142,      0.318718,    0.322664,   0.321861,   0.315577,
      0.303782,   0.287083,    0.266589,    0.243739,    0.220131,     0.197374,    0.176966,   0.160186,   0.148,
      0.140961,   0.139119,    0.141953,    0.14836,     0.156719,     0.165048,    0.171248,   0.173394,   0.170029,
      0.16041,    0.144635,    0.123644,    0.0990727,   0.0730024,    0.0476464,   0.0250363,  0.0067646,  -0.00618282,
      -0.0134888, -0.015474,   -0.0129986,  -0.00732991, -3.16973e-16, 0.00732991,  0.0129986,  0.015474,   0.0134888,
      0.00618282, -0.0067646,  -0.0250363,  -0.0476464,  -0.0730024,   -0.0990727,  -0.123644,  -0.144635,  -0.16041,
      -0.170029,  -0.173394,   -0.171248,   -0.165048,   -0.156719,    -0.14836,    -0.141953,  -0.139119,  -0.140961,
      -0.148,     -0.160186,   -0.176966,   -0.197374,   -0.220131,    -0.243739,   -0.266589,  -0.287083,  -0.303782,
      -0.315577,  -0.321861,   -0.322664,   -0.318718,   -0.31142,     -0.302669,   -0.294615,  -0.289336,  -0.288522,
      -0.293213,  -0.30366,    -0.319318,   -0.33897,    -0.360963,    -0.383469,   -0.404752,  -0.423365,  -0.438273,
      -0.448892,  -0.455068,   -0.457035,   -0.455363,   -0.45092,     -0.444838,   -0.438465,  -0.433277,  -0.430742,
      -0.432129,  -0.438303,   -0.449542,   -0.465422,   -0.484826,    -0.506079,   -0.527201,  -0.546232,  -0.561553,
      -0.572147,  -0.57773,    -0.578739,   -0.576187,   -0.571435,    -0.565933,   -0.561003,  -0.557706,  -0.556789,
      -0.558715,  -0.563724,   -0.57188,    -0.583076,   -0.596992,    -0.613027,   -0.630252,  -0.647415,  -0.663062,
      -0.67574,   -0.68427,    -0.688012,   -0.687066,   -0.682313,    -0.675298,   -0.667954,  -0.662225,  -0.659691,
      -0.661285,  -0.667162,   -0.676769,   -0.68906,    -0.702808,    -0.716897,   -0.730522,  -0.743234,  -0.754841,
      -0.765213,  -0.774087,   -0.780957,   -0.785125,   -0.785917,    -0.783003,   -0.776732,  -0.768345,  -0.759956,
      -0.754279,  -0.754101,   -0.761638,   -0.77793,    -0.802442,    -0.833019,   -0.866226,  -0.898022,  -0.924626,
      -0.943336,  -0.953125,   -0.954817,   -0.950814,   -0.944424,    -0.938957,   -0.936839,  -0.938957,  -0.944424,
      -0.950814,  -0.954817,   -0.953125,   -0.943336,   -0.924626,    -0.898022,   -0.866226,  -0.833019,  -0.802442,
      -0.77793,   -0.761638,   -0.754101,   -0.754279,   -0.759956,    -0.768345,   -0.776732,  -0.783003,  -0.785917,
      -0.785125,  -0.780957,   -0.774087,   -0.765213,   -0.754841,    -0.743234,   -0.730522,  -0.716897,  -0.702808,
      -0.68906,   -0.676769,   -0.667162,   -0.661285,   -0.659691,    -0.662225,   -0.667954,  -0.675298,  -0.682313,
      -0.687066,  -0.688012,   -0.68427,    -0.67574,    -0.663062,    -0.647415,   -0.630252,  -0.613027,  -0.596992,
      -0.583076,  -0.57188,    -0.563724,   -0.558715,   -0.556789,    -0.557706,   -0.561003,  -0.565933,  -0.571435,
      -0.576187,  -0.578739,   -0.57773,    -0.572147,   -0.561553,    -0.546232,   -0.527201,  -0.506079,  -0.484826,
      -0.465422,  -0.449542,   -0.438303,   -0.432129,   -0.430742,    -0.433277,   -0.438465,  -0.444838,  -0.45092,
      -0.455363,  -0.457035,   -0.455068,   -0.448892,   -0.438273,    -0.423365,   -0.404752,  -0.383469,  -0.360963,
      -0.33897,   -0.319318,   -0.30366,    -0.293213,   -0.288522,    -0.289336,   -0.294615,  -0.302669,  -0.31142,
      -0.318718,  -0.322664,   -0.321861,   -0.315577,   -0.303782,    -0.287083,   -0.266589,  -0.243739,  -0.220131,
      -0.197374,  -0.176966,   -0.160186,   -0.148,      -0.140961,    -0.139119,   -0.141953,  -0.14836,   -0.156719,
      -0.165048,  -0.171248,   -0.173394,   -0.170029,   -0.16041,     -0.144635,   -0.123644,  -0.0990727, -0.0730024,
      -0.0476464, -0.0250363,  -0.00676461, 0.00618281,  0.0134888,    0.0154739,   0.0129986,  0.00732991},
     {0,          -0.00731357, -0.0128792,  -0.0151291,  -0.0128398,   -0.00526754, 0.00776178, 0.0258169,  0.0478889,
      0.0724845,  0.0977784,   0.121815,    0.142735,    0.159005,     0.169617,    0.174228,   0.17323,    0.167712,
      0.159344,   0.150169,    0.142348,    0.137879,    0.138338,     0.144672,    0.157079,   0.17499,    0.197149,
      0.221789,   0.246868,    0.270335,    0.290391,    0.3057,       0.31554,     0.319859,   0.319252,   0.314858,
      0.308201,   0.30099,     0.294928,    0.291519,    0.291925,     0.296857,    0.306526,   0.320643,   0.338456,
      0.358841,   0.380411,    0.401649,    0.421064,    0.437332,     0.449446,    0.456824,   0.459397,   0.457636,
      0.452523,   0.445458,    0.438112,    0.432228,    0.429409,     0.430905,    0.437436,   0.449087,   0.465277,
      0.484824,   0.506099,    0.527245,    0.546424,    0.562075,     0.573119,    0.5791,     0.580233,   0.577347,
      0.571756,   0.565052,    0.55888,     0.554714,    0.553681,     0.556437,    0.563133,   0.573439,   0.586643,
      0.601771,   0.617735,    0.633456,    0.647973,    0.660508,     0.670507,    0.677648,   0.681839,   0.683213,
      0.682122,   0.679125,    0.674983,    0.670624,    0.667089,     0.665443,    0.666655,   0.67146,    0.68022,
      0.69282,    0.70861,     0.726433,    0.744732,    0.761747,     0.775758,    0.785366,   0.789735,   0.788774,
      0.783203,   0.774499,    0.76471,     0.756163,    0.751115,     0.751404,    0.75816,    0.77162,    0.791093,
      0.815077,   0.8415,      0.868064,    0.8926,      0.913402,     0.929451,    0.940512,   0.947078,   0.950182,
      0.95111,    0.951084,    0.950971,    0.951084,    0.95111,      0.950182,    0.947078,   0.940512,   0.929451,
      0.913402,   0.8926,      0.868064,    0.8415,      0.815077,     0.791093,    0.77162,    0.75816,    0.751404,
      0.751115,   0.756163,    0.76471,     0.774499,    0.783203,     0.788774,    0.789735,   0.785366,   0.775758,
      0.761747,   0.744732,    0.726433,    0.70861,     0.69282,      0.68022,     0.67146,    0.666655,   0.665443,
      0.667089,   0.670624,    0.674983,    0.679125,    0.682122,     0.683213,    0.681839,   0.677648,   0.670507,
      0.660508,   0.647973,    0.633456,    0.617735,    0.601771,     0.586643,    0.573439,   0.563133,   0.556437,
      0.553681,   0.554714,    0.55888,     0.565052,    0.571756,     0.577347,    0.580233,   0.5791,     0.573119,
      0.562075,   0.546424,    0.527245,    0.506099,    0.484824,     0.465277,    0.449087,   0.437436,   0.430905,
      0.429409,   0.432228,    0.438112,    0.445458,    0.452523,     0.457636,    0.459397,   0.456824,   0.449446,
      0.437332,   0.421064,    0.401649,    0.380411,    0.358841,     0.338456,    0.320643,   0.306526,   0.296857,
      0.291925,   0.291519,    0.294928,    0.30099,     0.308201,     0.314858,    0.319252,   0.319859,   0.31554,
      0.3057,     0.290391,    0.270335,    0.246868,    0.221789,     0.197149,    0.17499,    0.157079,   0.144672,
      0.138338,   0.137879,    0.142348,    0.150169,    0.159344,     0.167712,    0.17323,    0.174228,   0.169617,
      0.159005,   0.142735,    0.121815,    0.0977784,   0.0724845,    0.0478889,   0.0258169,  0.00776177, -0.00526755,
      -0.0128398, -0.0151291,  -0.0128792,  -0.00731358, -2.66558e-16, 0.00731358,  0.0128792,  0.0151291,  0.0128398,
      0.00526755, -0.00776177, -0.0258169,  -0.0478889,  -0.0724845,   -0.0977784,  -0.121815,  -0.142735,  -0.159005,
      -0.169617,  -0.174228,   -0.17323,    -0.167712,   -0.159344,    -0.150169,   -0.142348,  -0.137879,  -0.138338,
      -0.144672,  -0.157079,   -0.17499,    -0.197149,   -0.221789,    -0.246868,   -0.270335,  -0.290391,  -0.3057,
      -0.31554,   -0.319859,   -0.319252,   -0.314858,   -0.308201,    -0.30099,    -0.294928,  -0.291519,  -0.291925,
      -0.296857,  -0.306526,   -0.320643,   -0.338456,   -0.358841,    -0.380411,   -0.401649,  -0.421064,  -0.437332,
      -0.449446,  -0.456824,   -0.459397,   -0.457636,   -0.452523,    -0.445458,   -0.438112,  -0.432228,  -0.429409,
      -0.430905,  -0.437436,   -0.449087,   -0.465277,   -0.484824,    -0.506099,   -0.527245,  -0.546424,  -0.562075,
      -0.573119,  -0.5791,     -0.580233,   -0.577347,   -0.571756,    -0.565052,   -0.55888,   -0.554714,  -0.553681,
      -0.556437,  -0.563133,   -0.573439,   -0.586643,   -0.601771,    -0.617735,   -0.633456,  -0.647973,  -0.660508,
      -0.670507,  -0.677648,   -0.681839,   -0.683213,   -0.682122,    -0.679125,   -0.674983,  -0.670624,  -0.667089,
      -0.665443,  -0.666655,   -0.67146,    -0.68022,    -0.69282,     -0.70861,    -0.726433,  -0.744732,  -0.761747,
      -0.775758,  -0.785366,   -0.789735,   -0.788774,   -0.783203,    -0.774499,   -0.76471,   -0.756163,  -0.751115,
      -0.751404,  -0.75816,    -0.77162,    -0.791093,   -0.815077,    -0.8415,     -0.868064,  -0.8926,    -0.913402,
      -0.929451,  -0.940512,   -0.947078,   -0.950182,   -0.95111,     -0.951084,   -0.950971,  -0.951084,  -0.95111,
      -0.950182,  -0.947078,   -0.940512,   -0.929451,   -0.913402,    -0.8926,     -0.868064,  -0.8415,    -0.815077,
      -0.791093,  -0.77162,    -0.75816,    -0.751404,   -0.751115,    -0.756163,   -0.76471,   -0.774499,  -0.783203,
      -0.788774,  -0.789735,   -0.785366,   -0.775758,   -0.761747,    -0.744732,   -0.726433,  -0.70861,   -0.69282,
      -0.68022,   -0.67146,    -0.666655,   -0.665443,   -0.667089,    -0.670624,   -0.674983,  -0.679125,  -0.682122,
      -0.683213,  -0.681839,   -0.677648,   -0.670507,   -0.660508,    -0.647973,   -0.633456,  -0.617735,  -0.601771,
      -0.586643,  -0.573439,   -0.563133,   -0.556437,   -0.553681,    -0.554714,   -0.55888,   -0.565052,  -0.571756,
      -0.577347,  -0.580233,   -0.5791,     -0.573119,   -0.562075,    -0.546424,   -0.527245,  -0.506099,  -0.484824,
      -0.465277,  -0.449087,   -0.437436,   -0.430905,   -0.429409,    -0.432228,   -0.438112,  -0.445458,  -0.452523,
      -0.457636,  -0.459397,   -0.456824,   -0.449446,   -0.437332,    -0.421064,   -0.401649,  -0.380411,  -0.358841,
      -0.338456,  -0.320643,   -0.306526,   -0.296857,   -0.291925,    -0.291519,   -0.294928,  -0.30099,   -0.308201,
      -0.314858,  -0.319252,   -0.319859,   -0.31554,    -0.3057,      -0.290391,   -0.270335,  -0.246868,  -0.221789,
      -0.197149,  -0.17499,    -0.157079,   -0.144672,   -0.138338,    -0.137879,   -0.142348,  -0.150169,  -0.159344,
      -0.167712,  -0.17323,    -0.174228,   -0.169617,   -0.159005,    -0.142735,   -0.121815,  -0.0977784, -0.0724845,
      -0.0478889, -0.0258169,  -0.00776178, 0.00526754,  0.0128398,    0.0151291,   0.0128792,  0.00731357},
     {0,          -0.00915125, -0.0161805,  -0.0192236,  -0.0169001,   -0.00848023, 0.00602957, 0.0258899,  0.0497216,
      0.0756768,  0.101664,    0.125605,    0.145679,    0.160545,     0.169496,    0.172531,   0.170354,   0.164275,
      0.156047,   0.147652,    0.141061,    0.138001,    0.139756,     0.147022,    0.159839,   0.177595,   0.199111,
      0.222791,   0.246815,    0.26935,     0.288768,    0.303826,     0.313797,    0.318549,   0.31854,    0.314758,
      0.308599,   0.301696,    0.295735,    0.292265,    0.292521,     0.297301,    0.306878,   0.320981,   0.338834,
      0.359248,   0.380759,    0.401794,    0.420842,    0.436625,     0.448234,    0.455226,   0.45767,    0.45614,
      0.451647,   0.445523,    0.439279,    0.43443,     0.43233,      0.434016,    0.440092,   0.450656,   0.465289,
      0.483098,   0.502815,    0.522939,    0.541911,    0.558291,     0.570929,    0.579102,   0.582604,   0.581775,
      0.577465,   0.570938,    0.563722,    0.557432,    0.553572,     0.553351,    0.557536,   0.566354,   0.579459,
      0.595977,   0.614602,    0.633764,    0.651821,    0.667262,     0.678898,    0.686011,   0.688448,   0.686636,
      0.681531,   0.674496,    0.667125,    0.661043,    0.657699,     0.658179,    0.663074,   0.672403,   0.685621,
      0.701692,   0.719225,    0.736661,    0.75247,     0.765356,     0.774411,    0.779235,   0.779979,   0.777315,
      0.772349,   0.766475,    0.761197,    0.757944,    0.757902,     0.761882,    0.770243,   0.782869,   0.799212,
      0.818384,   0.839281,    0.860724,    0.881592,    0.900935,     0.918045,    0.932485,   0.944071,   0.952819,
      0.958871,   0.962407,    0.963567,    0.962407,    0.958871,     0.952819,    0.944071,   0.932485,   0.918045,
      0.900935,   0.881592,    0.860724,    0.839281,    0.818384,     0.799212,    0.782869,   0.770243,   0.761882,
      0.757902,   0.757944,    0.761197,    0.766475,    0.772349,     0.777315,    0.779979,   0.779235,   0.774411,
      0.765356,   0.75247,     0.736661,    0.719225,    0.701692,     0.685621,    0.672403,   0.663074,   0.658179,
      0.657699,   0.661043,    0.667125,    0.674496,    0.681531,     0.686636,    0.688448,   0.686011,   0.678898,
      0.667262,   0.651821,    0.633764,    0.614602,    0.595977,     0.579459,    0.566354,   0.557536,   0.553351,
      0.553572,   0.557432,    0.563722,    0.570938,    0.577465,     0.581775,    0.582604,   0.579102,   0.570929,
      0.558291,   0.541911,    0.522939,    0.502815,    0.483098,     0.465289,    0.450656,   0.440092,   0.434016,
      0.43233,    0.43443,     0.439279,    0.445523,    0.451647,     0.45614,     0.45767,    0.455226,   0.448234,
      0.436625,   0.420842,    0.401794,    0.380759,    0.359248,     0.338834,    0.320981,   0.306878,   0.297301,
      0.292521,   0.292265,    0.295735,    0.301696,    0.308599,     0.314758,    0.31854,    0.318549,   0.313797,
      0.303826,   0.288768,    0.26935,     0.246815,    0.222791,     0.199111,    0.177595,   0.159839,   0.147022,
      0.139756,   0.138001,    0.141061,    0.147652,    0.156047,     0.164275,    0.170354,   0.172531,   0.169496,
      0.160545,   0.145679,    0.125605,    0.101664,    0.0756768,    0.0497216,   0.0258898,  0.00602956, -0.00848024,
      -0.0169001, -0.0192236,  -0.0161805,  -0.00915125, -3.30297e-16, 0.00915125,  0.0161805,  0.0192236,  0.0169001,
      0.00848024, -0.00602956, -0.0258898,  -0.0497216,  -0.0756768,   -0.101664,   -0.125605,  -0.145679,  -0.160545,
      -0.169496,  -0.172531,   -0.170354,   -0.164275,   -0.156047,    -0.147652,   -0.141061,  -0.138001,  -0.139756,
      -0.147022,  -0.159839,   -0.177595,   -0.199111,   -0.222791,    -0.246815,   -0.26935,   -0.288768,  -0.303826,
      -0.313797,  -0.318549,   -0.31854,    -0.314758,   -0.308599,    -0.301696,   -0.295735,  -0.292265,  -0.292521,
      -0.297301,  -0.306878,   -0.320981,   -0.338834,   -0.359248,    -0.380759,   -0.401794,  -0.420842,  -0.436625,
      -0.448234,  -0.455226,   -0.45767,    -0.45614,    -0.451647,    -0.445523,   -0.439279,  -0.43443,   -0.43233,
      -0.434016,  -0.440092,   -0.450656,   -0.465289,   -0.483098,    -0.502815,   -0.522939,  -0.541911,  -0.558291,
      -0.570929,  -0.579102,   -0.582604,   -0.581775,   -0.577465,    -0.570938,   -0.563722,  -0.557432,  -0.553572,
      -0.553351,  -0.557536,   -0.566354,   -0.579459,   -0.595977,    -0.614602,   -0.633764,  -0.651821,  -0.667262,
      -0.678898,  -0.686011,   -0.688448,   -0.686636,   -0.681531,    -0.674496,   -0.667125,  -0.661043,  -0.657699,
      -0.658179,  -0.663074,   -0.672403,   -0.685621,   -0.701692,    -0.719225,   -0.736661,  -0.75247,   -0.765356,
      -0.774411,  -0.779235,   -0.779979,   -0.777315,   -0.772349,    -0.766475,   -0.761197,  -0.757944,  -0.757902,
      -0.761882,  -0.770243,   -0.782869,   -0.799212,   -0.818384,    -0.839281,   -0.860724,  -0.881592,  -0.900935,
      -0.918045,  -0.932485,   -0.944071,   -0.952819,   -0.958871,    -0.962407,   -0.963567,  -0.962407,  -0.958871,
      -0.952819,  -0.944071,   -0.932485,   -0.918045,   -0.900935,    -0.881592,   -0.860724,  -0.839281,  -0.818384,
      -0.799212,  -0.782869,   -0.770243,   -0.761882,   -0.757902,    -0.757944,   -0.761197,  -0.766475,  -0.772349,
      -0.777315,  -0.779979,   -0.779235,   -0.774411,   -0.765356,    -0.75247,    -0.736661,  -0.719225,  -0.701692,
      -0.685621,  -0.672403,   -0.663074,   -0.658179,   -0.657699,    -0.661043,   -0.667125,  -0.674496,  -0.681531,
      -0.686636,  -0.688448,   -0.686011,   -0.678898,   -0.667262,    -0.651821,   -0.633764,  -0.614602,  -0.595977,
      -0.579459,  -0.566354,   -0.557536,   -0.553351,   -0.553572,    -0.557432,   -0.563722,  -0.570938,  -0.577465,
      -0.581775,  -0.582604,   -0.579102,   -0.570929,   -0.558291,    -0.541911,   -0.522939,  -0.502815,  -0.483098,
      -0.465289,  -0.450656,   -0.440092,   -0.434016,   -0.43233,     -0.43443,    -0.439279,  -0.445523,  -0.451647,
      -0.45614,   -0.45767,    -0.455226,   -0.448234,   -0.436625,    -0.420842,   -0.401794,  -0.380759,  -0.359248,
      -0.338834,  -0.320981,   -0.306878,   -0.297301,   -0.292521,    -0.292265,   -0.295735,  -0.301696,  -0.308599,
      -0.314758,  -0.31854,    -0.318549,   -0.313797,   -0.303826,    -0.288768,   -0.26935,   -0.246815,  -0.222791,
      -0.199111,  -0.177595,   -0.159839,   -0.147022,   -0.139756,    -0.138001,   -0.141061,  -0.147652,  -0.156047,
      -0.164275,  -0.170354,   -0.172531,   -0.169496,   -0.160545,    -0.145679,   -0.125605,  -0.101664,  -0.0756768,
      -0.0497216, -0.0258899,  -0.00602957, 0.00848023,  0.0169001,    0.0192236,   0.0161805,  0.00915125},
     {0,           0.000156917, 0.00123466, 0.00405297,  0.0092405,    0.0171657,    0.0278965,
      0.0411924,   0.0565309,   0.073165,   0.0902043,   0.106713,     0.121813,     0.134777,
      0.145115,    0.15262,     0.157394,   0.15984,     0.160613,     0.160549,     0.160575,
      0.161606,    0.164445,    0.169694,   0.177688,    0.18846,      0.201733,     0.216955,
      0.233357,    0.250035,    0.266053,   0.280547,    0.292812,     0.302387,     0.309104,
      0.313103,    0.31482,     0.31494,    0.314316,    0.313884,     0.314553,     0.317106,
      0.322117,    0.329886,    0.340405,   0.35336,     0.368163,     0.384019,     0.400012,
      0.415206,    0.428749,    0.439962,   0.448421,    0.453998,     0.456879,     0.457541,
      0.456701,    0.455239,    0.454096,   0.454175,    0.456241,     0.460833,     0.468207,
      0.478307,    0.490771,    0.504968,   0.520071,    0.535145,     0.549253,     0.561557,
      0.571413,    0.578441,    0.582569,   0.58404,     0.583388,     0.581378,     0.578923,
      0.576978,    0.576444,    0.578056,   0.58231,     0.589402,     0.599207,     0.611293,
      0.624965,    0.639343,    0.653463,   0.666379,    0.677273,     0.685548,     0.690894,
      0.693326,    0.693186,    0.691105,   0.687935,    0.684656,     0.682266,     0.681664,
      0.683558,    0.68837,     0.696194,   0.706778,    0.719551,     0.733681,     0.748169,
      0.761964,    0.774081,    0.783723,   0.790376,    0.793881,     0.794468,     0.792744,
      0.789643,    0.786332,    0.784095,   0.784196,    0.787737,     0.795534,     0.808008,
      0.825121,    0.846357,    0.870742,   0.896919,    0.923261,     0.948008,     0.969429,
      0.985976,    0.996427,    1,          0.996427,    0.985976,     0.969429,     0.948008,
      0.923261,    0.896919,    0.870742,   0.846357,    0.825121,     0.808008,     0.795534,
      0.787737,    0.784196,    0.784095,   0.786332,    0.789643,     0.792744,     0.794468,
      0.793881,    0.790376,    0.783723,   0.774081,    0.761964,     0.748169,     0.733681,
      0.719551,    0.706778,    0.696194,   0.68837,     0.683558,     0.681664,     0.682266,
      0.684656,    0.687935,    0.691105,   0.693186,    0.693326,     0.690894,     0.685548,
      0.677273,    0.666379,    0.653463,   0.639343,    0.624965,     0.611293,     0.599207,
      0.589402,    0.58231,     0.578056,   0.576444,    0.576978,     0.578923,     0.581378,
      0.583388,    0.58404,     0.582569,   0.578441,    0.571413,     0.561557,     0.549253,
      0.535145,    0.520071,    0.504968,   0.490771,    0.478307,     0.468207,     0.460833,
      0.456241,    0.454175,    0.454096,   0.455239,    0.456701,     0.457541,     0.456879,
      0.453998,    0.448421,    0.439962,   0.428749,    0.415206,     0.400012,     0.384019,
      0.368163,    0.35336,     0.340405,   0.329886,    0.322117,     0.317106,     0.314553,
      0.313884,    0.314316,    0.31494,    0.31482,     0.313103,     0.309104,     0.302387,
      0.292812,    0.280547,    0.266053,   0.250035,    0.233357,     0.216955,     0.201733,
      0.18846,     0.177688,    0.169694,   0.164445,    0.161606,     0.160575,     0.160549,
      0.160613,    0.15984,     0.157394,   0.15262,     0.145115,     0.134777,     0.121813,
      0.106713,    0.0902043,   0.073165,   0.0565309,   0.0411924,    0.0278965,    0.0171657,
      0.0092405,   0.00405297,  0.00123466, 0.000156918, -3.64792e-16, -0.000156918, -0.00123466,
      -0.00405297, -0.0092405,  -0.0171657, -0.0278965,  -0.0411924,   -0.0565309,   -0.073165,
      -0.0902043,  -0.106713,   -0.121813,  -0.134777,   -0.145115,    -0.15262,     -0.157394,
      -0.15984,    -0.160613,   -0.160549,  -0.160575,   -0.161606,    -0.164445,    -0.169694,
      -0.177688,   -0.18846,    -0.201733,  -0.216955,   -0.233357,    -0.250035,    -0.266053,
      -0.280547,   -0.292812,   -0.302387,  -0.309104,   -0.313103,    -0.31482,     -0.31494,
      -0.314316,   -0.313884,   -0.314553,  -0.317106,   -0.322117,    -0.329886,    -0.340405,
      -0.35336,    -0.368163,   -0.384019,  -0.400012,   -0.415206,    -0.428749,    -0.439962,
      -0.448421,   -0.453998,   -0.456879,  -0.457541,   -0.456701,    -0.455239,    -0.454096,
      -0.454175,   -0.456241,   -0.460833,  -0.468207,   -0.478307,    -0.490771,    -0.504968,
      -0.520071,   -0.535145,   -0.549253,  -0.561557,   -0.571413,    -0.578441,    -0.582569,
      -0.58404,    -0.583388,   -0.581378,  -0.578923,   -0.576978,    -0.576444,    -0.578056,
      -0.58231,    -0.589402,   -0.599207,  -0.611293,   -0.624965,    -0.639343,    -0.653463,
      -0.666379,   -0.677273,   -0.685548,  -0.690894,   -0.693326,    -0.693186,    -0.691105,
      -0.687935,   -0.684656,   -0.682266,  -0.681664,   -0.683558,    -0.68837,     -0.696194,
      -0.706778,   -0.719551,   -0.733681,  -0.748169,   -0.761964,    -0.774081,    -0.783723,
      -0.790376,   -0.793881,   -0.794468,  -0.792744,   -0.789643,    -0.786332,    -0.784095,
      -0.784196,   -0.787737,   -0.795534,  -0.808008,   -0.825121,    -0.846357,    -0.870742,
      -0.896919,   -0.923261,   -0.948008,  -0.969429,   -0.985976,    -0.996427,    -1,
      -0.996427,   -0.985976,   -0.969429,  -0.948008,   -0.923261,    -0.896919,    -0.870742,
      -0.846357,   -0.825121,   -0.808008,  -0.795534,   -0.787737,    -0.784196,    -0.784095,
      -0.786332,   -0.789643,   -0.792744,  -0.794468,   -0.793881,    -0.790376,    -0.783723,
      -0.774081,   -0.761964,   -0.748169,  -0.733681,   -0.719551,    -0.706778,    -0.696194,
      -0.68837,    -0.683558,   -0.681664,  -0.682266,   -0.684656,    -0.687935,    -0.691105,
      -0.693186,   -0.693326,   -0.690894,  -0.685548,   -0.677273,    -0.666379,    -0.653463,
      -0.639343,   -0.624965,   -0.611293,  -0.599207,   -0.589402,    -0.58231,     -0.578056,
      -0.576444,   -0.576978,   -0.578923,  -0.581378,   -0.583388,    -0.58404,     -0.582569,
      -0.578441,   -0.571413,   -0.561557,  -0.549253,   -0.535145,    -0.520071,    -0.504968,
      -0.490771,   -0.478307,   -0.468207,  -0.460833,   -0.456241,    -0.454175,    -0.454096,
      -0.455239,   -0.456701,   -0.457541,  -0.456879,   -0.453998,    -0.448421,    -0.439962,
      -0.428749,   -0.415206,   -0.400012,  -0.384019,   -0.368163,    -0.35336,     -0.340405,
      -0.329886,   -0.322117,   -0.317106,  -0.314553,   -0.313884,    -0.314316,    -0.31494,
      -0.31482,    -0.313103,   -0.309104,  -0.302387,   -0.292812,    -0.280547,    -0.266053,
      -0.250035,   -0.233357,   -0.216955,  -0.201733,   -0.18846,     -0.177688,    -0.169694,
      -0.164445,   -0.161606,   -0.160575,  -0.160549,   -0.160613,    -0.15984,     -0.157394,
      -0.15262,    -0.145115,   -0.134777,  -0.121813,   -0.106713,    -0.0902043,   -0.073165,
      -0.0565309,  -0.0411924,  -0.0278965, -0.0171657,  -0.0092405,   -0.00405297,  -0.00123466,
      -0.000156917},
     {0,          0.00762449, 0.0153286,  0.0231851,  0.0312535,    0.039575,    0.0481688,  0.0570304,  0.0661316,
      0.0754234,  0.0848392,  0.0943011,  0.103726,   0.113033,     0.12215,     0.131019,   0.139603,   0.147888,
      0.155883,   0.163621,   0.171158,   0.178562,   0.185914,     0.193298,    0.200793,   0.208467,   0.216373,
      0.22454,    0.232974,   0.241656,   0.250542,   0.259569,     0.268658,    0.277721,   0.286671,   0.295424,
      0.30391,    0.312081,   0.31991,    0.327397,   0.334568,     0.341474,    0.348187,   0.354791,   0.36138,
      0.368046,   0.374872,   0.381926,   0.389254,   0.396873,     0.404775,    0.412921,   0.421249,   0.429675,
      0.4381,     0.446421,   0.454538,   0.462363,   0.469825,     0.476883,    0.483521,   0.489758,   0.495644,
      0.501255,   0.506688,   0.512057,   0.517475,   0.523053,     0.528885,    0.535043,   0.541567,   0.548463,
      0.5557,     0.563213,   0.570906,   0.578661,   0.586348,     0.59383,     0.600985,   0.607705,   0.613916,
      0.619581,   0.624702,   0.629328,   0.633547,   0.637482,     0.641283,    0.645115,   0.649143,   0.65352,
      0.658374,   0.663793,   0.669819,   0.676442,   0.683595,     0.691163,    0.698983,   0.706864,   0.714592,
      0.721956,   0.728761,   0.734848,   0.740109,   0.744503,     0.74806,     0.750891,   0.75318,    0.755183,
      0.757206,   0.759597,   0.762712,   0.766903,   0.772481,     0.779697,    0.78872,    0.799616,   0.812339,
      0.826723,   0.842483,   0.859228,   0.876474,   0.893666,     0.910209,    0.925496,   0.938942,   0.950016,
      0.958269,   0.963363,   0.965085,   0.963363,   0.958269,     0.950016,    0.938942,   0.925496,   0.910209,
      0.893666,   0.876474,   0.859228,   0.842483,   0.826723,     0.812339,    0.799616,   0.78872,    0.779697,
      0.772481,   0.766903,   0.762712,   0.759597,   0.757206,     0.755183,    0.75318,    0.750891,   0.74806,
      0.744503,   0.740109,   0.734848,   0.728761,   0.721956,     0.714592,    0.706864,   0.698983,   0.691163,
      0.683595,   0.676442,   0.669819,   0.663793,   0.658374,     0.65352,     0.649143,   0.645115,   0.641283,
      0.637482,   0.633547,   0.629328,   0.624702,   0.619581,     0.613916,    0.607705,   0.600985,   0.59383,
      0.586348,   0.578661,   0.570906,   0.563213,   0.5557,       0.548463,    0.541567,   0.535043,   0.528885,
      0.523053,   0.517475,   0.512057,   0.506688,   0.501255,     0.495644,    0.489758,   0.483521,   0.476883,
      0.469825,   0.462363,   0.454538,   0.446421,   0.4381,       0.429675,    0.421249,   0.412921,   0.404775,
      0.396873,   0.389254,   0.381926,   0.374872,   0.368046,     0.36138,     0.354791,   0.348187,   0.341474,
      0.334568,   0.327397,   0.31991,    0.312081,   0.30391,      0.295424,    0.286671,   0.277721,   0.268658,
      0.259569,   0.250542,   0.241656,   0.232974,   0.22454,      0.216373,    0.208467,   0.200793,   0.193298,
      0.185914,   0.178562,   0.171158,   0.163621,   0.155883,     0.147888,    0.139603,   0.131019,   0.12215,
      0.113033,   0.103726,   0.0943011,  0.0848392,  0.0754234,    0.0661316,   0.0570303,  0.0481688,  0.039575,
      0.0312535,  0.0231851,  0.0153286,  0.00762449, -1.64796e-16, -0.00762449, -0.0153286, -0.0231851, -0.0312535,
      -0.039575,  -0.0481688, -0.0570303, -0.0661316, -0.0754234,   -0.0848392,  -0.0943011, -0.103726,  -0.113033,
      -0.12215,   -0.131019,  -0.139603,  -0.147888,  -0.155883,    -0.163621,   -0.171158,  -0.178562,  -0.185914,
      -0.193298,  -0.200793,  -0.208467,  -0.216373,  -0.22454,     -0.232974,   -0.241656,  -0.250542,  -0.259569,
      -0.268658,  -0.277721,  -0.286671,  -0.295424,  -0.30391,     -0.312081,   -0.31991,   -0.327397,  -0.334568,
      -0.341474,  -0.348187,  -0.354791,  -0.36138,   -0.368046,    -0.374872,   -0.381926,  -0.389254,  -0.396873,
      -0.404775,  -0.412921,  -0.421249,  -0.429675,  -0.4381,      -0.446421,   -0.454538,  -0.462363,  -0.469825,
      -0.476883,  -0.483521,  -0.489758,  -0.495644,  -0.501255,    -0.506688,   -0.512057,  -0.517475,  -0.523053,
      -0.528885,  -0.535043,  -0.541567,  -0.548463,  -0.5557,      -0.563213,   -0.570906,  -0.578661,  -0.586348,
      -0.59383,   -0.600985,  -0.607705,  -0.613916,  -0.619581,    -0.624702,   -0.629328,  -0.633547,  -0.637482,
      -0.641283,  -0.645115,  -0.649143,  -0.65352,   -0.658374,    -0.663793,   -0.669819,  -0.676442,  -0.683595,
      -0.691163,  -0.698983,  -0.706864,  -0.714592,  -0.721956,    -0.728761,   -0.734848,  -0.740109,  -0.744503,
      -0.74806,   -0.750891,  -0.75318,   -0.755183,  -0.757206,    -0.759597,   -0.762712,  -0.766903,  -0.772481,
      -0.779697,  -0.78872,   -0.799616,  -0.812339,  -0.826723,    -0.842483,   -0.859228,  -0.876474,  -0.893666,
      -0.910209,  -0.925496,  -0.938942,  -0.950016,  -0.958269,    -0.963363,   -0.965085,  -0.963363,  -0.958269,
      -0.950016,  -0.938942,  -0.925496,  -0.910209,  -0.893666,    -0.876474,   -0.859228,  -0.842483,  -0.826723,
      -0.812339,  -0.799616,  -0.78872,   -0.779697,  -0.772481,    -0.766903,   -0.762712,  -0.759597,  -0.757206,
      -0.755183,  -0.75318,   -0.750891,  -0.74806,   -0.744503,    -0.740109,   -0.734848,  -0.728761,  -0.721956,
      -0.714592,  -0.706864,  -0.698983,  -0.691163,  -0.683595,    -0.676442,   -0.669819,  -0.663793,  -0.658374,
      -0.65352,   -0.649143,  -0.645115,  -0.641283,  -0.637482,    -0.633547,   -0.629328,  -0.624702,  -0.619581,
      -0.613916,  -0.607705,  -0.600985,  -0.59383,   -0.586348,    -0.578661,   -0.570906,  -0.563213,  -0.5557,
      -0.548463,  -0.541567,  -0.535043,  -0.528885,  -0.523053,    -0.517475,   -0.512057,  -0.506688,  -0.501255,
      -0.495644,  -0.489758,  -0.483521,  -0.476883,  -0.469825,    -0.462363,   -0.454538,  -0.446421,  -0.4381,
      -0.429675,  -0.421249,  -0.412921,  -0.404775,  -0.396873,    -0.389254,   -0.381926,  -0.374872,  -0.368046,
      -0.36138,   -0.354791,  -0.348187,  -0.341474,  -0.334568,    -0.327397,   -0.31991,   -0.312081,  -0.30391,
      -0.295424,  -0.286671,  -0.277721,  -0.268658,  -0.259569,    -0.250542,   -0.241656,  -0.232974,  -0.22454,
      -0.216373,  -0.208467,  -0.200793,  -0.193298,  -0.185914,    -0.178562,   -0.171158,  -0.163621,  -0.155883,
      -0.147888,  -0.139603,  -0.131019,  -0.12215,   -0.113033,    -0.103726,   -0.0943011, -0.0848392, -0.0754234,
      -0.0661316, -0.0570304, -0.0481688, -0.039575,  -0.0312535,   -0.0231851,  -0.0153286, -0.00762449},
     {0,          0.00762032, 0.015296,   0.0230789,  0.0310147,    0.0391395,   0.0474783,  0.0560429,  0.0648312,
      0.0738277,  0.0830038,  0.0923194,  0.101726,   0.111168,     0.120587,    0.129926,   0.13913,    0.148153,
      0.156956,   0.165515,   0.173816,   0.181863,   0.18967,      0.197267,    0.204694,   0.212003,   0.219247,
      0.226485,   0.233777,   0.241175,   0.248726,   0.256465,     0.264416,    0.272588,   0.280976,   0.289558,
      0.2983,     0.307156,   0.31607,    0.324981,   0.333824,     0.342536,    0.351058,   0.35934,    0.367343,
      0.375041,   0.382427,   0.389505,   0.396299,   0.402847,     0.409198,    0.415414,   0.421561,   0.427709,
      0.433927,   0.440277,   0.446812,   0.453574,   0.460587,     0.467859,    0.475379,   0.48312,    0.491036,
      0.499067,   0.507142,   0.515185,   0.523114,   0.530849,     0.538318,    0.54546,    0.552229,   0.558595,
      0.564552,   0.570112,   0.57531,    0.5802,     0.584855,     0.58936,     0.593808,   0.5983,     0.60293,
      0.607787,   0.612949,   0.618471,   0.624391,   0.630719,     0.637441,    0.644513,   0.65187,    0.659421,
      0.66706,    0.674668,   0.682118,   0.689286,   0.696058,     0.702334,    0.708037,   0.71312,    0.717569,
      0.721407,   0.724693,   0.727526,   0.730036,   0.732388,     0.734767,    0.737375,   0.740421,   0.74411,
      0.748635,   0.754163,   0.760829,   0.768727,   0.777898,     0.788333,    0.799964,   0.812664,   0.826253,
      0.840498,   0.855122,   0.869812,   0.884231,   0.898028,     0.910853,    0.922368,   0.932264,   0.940266,
      0.94615,    0.949749,   0.95096,    0.949749,   0.94615,      0.940266,    0.932264,   0.922368,   0.910853,
      0.898028,   0.884231,   0.869812,   0.855122,   0.840498,     0.826253,    0.812664,   0.799964,   0.788333,
      0.777898,   0.768727,   0.760829,   0.754163,   0.748635,     0.74411,     0.740421,   0.737375,   0.734767,
      0.732388,   0.730036,   0.727526,   0.724693,   0.721407,     0.717569,    0.71312,    0.708037,   0.702334,
      0.696058,   0.689286,   0.682118,   0.674668,   0.66706,      0.659421,    0.65187,    0.644513,   0.637441,
      0.630719,   0.624391,   0.618471,   0.612949,   0.607787,     0.60293,     0.5983,     0.593808,   0.58936,
      0.584855,   0.5802,     0.57531,    0.570112,   0.564552,     0.558595,    0.552229,   0.54546,    0.538318,
      0.530849,   0.523114,   0.515185,   0.507142,   0.499067,     0.491036,    0.48312,    0.475379,   0.467859,
      0.460587,   0.453574,   0.446812,   0.440277,   0.433927,     0.427709,    0.421561,   0.415414,   0.409198,
      0.402847,   0.396299,   0.389505,   0.382427,   0.375041,     0.367343,    0.35934,    0.351058,   0.342536,
      0.333824,   0.324981,   0.31607,    0.307156,   0.2983,       0.289558,    0.280976,   0.272588,   0.264416,
      0.256465,   0.248726,   0.241175,   0.233777,   0.226485,     0.219247,    0.212003,   0.204694,   0.197267,
      0.18967,    0.181863,   0.173816,   0.165515,   0.156956,     0.148153,    0.13913,    0.129926,   0.120587,
      0.111168,   0.101726,   0.0923194,  0.0830038,  0.0738277,    0.0648312,   0.0560429,  0.0474783,  0.0391395,
      0.0310147,  0.0230789,  0.015296,   0.00762032, -1.14616e-16, -0.00762032, -0.015296,  -0.0230789, -0.0310147,
      -0.0391395, -0.0474783, -0.0560429, -0.0648312, -0.0738277,   -0.0830038,  -0.0923194, -0.101726,  -0.111168,
      -0.120587,  -0.129926,  -0.13913,   -0.148153,  -0.156956,    -0.165515,   -0.173816,  -0.181863,  -0.18967,
      -0.197267,  -0.204694,  -0.212003,  -0.219247,  -0.226485,    -0.233777,   -0.241175,  -0.248726,  -0.256465,
      -0.264416,  -0.272588,  -0.280976,  -0.289558,  -0.2983,      -0.307156,   -0.31607,   -0.324981,  -0.333824,
      -0.342536,  -0.351058,  -0.35934,   -0.367343,  -0.375041,    -0.382427,   -0.389505,  -0.396299,  -0.402847,
      -0.409198,  -0.415414,  -0.421561,  -0.427709,  -0.433927,    -0.440277,   -0.446812,  -0.453574,  -0.460587,
      -0.467859,  -0.475379,  -0.48312,   -0.491036,  -0.499067,    -0.507142,   -0.515185,  -0.523114,  -0.530849,
      -0.538318,  -0.54546,   -0.552229,  -0.558595,  -0.564552,    -0.570112,   -0.57531,   -0.5802,    -0.584855,
      -0.58936,   -0.593808,  -0.5983,    -0.60293,   -0.607787,    -0.612949,   -0.618471,  -0.624391,  -0.630719,
      -0.637441,  -0.644513,  -0.65187,   -0.659421,  -0.66706,     -0.674668,   -0.682118,  -0.689286,  -0.696058,
      -0.702334,  -0.708037,  -0.71312,   -0.717569,  -0.721407,    -0.724693,   -0.727526,  -0.730036,  -0.732388,
      -0.734767,  -0.737375,  -0.740421,  -0.74411,   -0.748635,    -0.754163,   -0.760829,  -0.768727,  -0.777898,
      -0.788333,  -0.799964,  -0.812664,  -0.826253,  -0.840498,    -0.855122,   -0.869812,  -0.884231,  -0.898028,
      -0.910853,  -0.922368,  -0.932264,  -0.940266,  -0.94615,     -0.949749,   -0.95096,   -0.949749,  -0.94615,
      -0.940266,  -0.932264,  -0.922368,  -0.910853,  -0.898028,    -0.884231,   -0.869812,  -0.855122,  -0.840498,
      -0.826253,  -0.812664,  -0.799964,  -0.788333,  -0.777898,    -0.768727,   -0.760829,  -0.754163,  -0.748635,
      -0.74411,   -0.740421,  -0.737375,  -0.734767,  -0.732388,    -0.730036,   -0.727526,  -0.724693,  -0.721407,
      -0.717569,  -0.71312,   -0.708037,  -0.702334,  -0.696058,    -0.689286,   -0.682118,  -0.674668,  -0.66706,
      -0.659421,  -0.65187,   -0.644513,  -0.637441,  -0.630719,    -0.624391,   -0.618471,  -0.612949,  -0.607787,
      -0.60293,   -0.5983,    -0.593808,  -0.58936,   -0.584855,    -0.5802,     -0.57531,   -0.570112,  -0.564552,
      -0.558595,  -0.552229,  -0.54546,   -0.538318,  -0.530849,    -0.523114,   -0.515185,  -0.507142,  -0.499067,
      -0.491036,  -0.48312,   -0.475379,  -0.467859,  -0.460587,    -0.453574,   -0.446812,  -0.440277,  -0.433927,
      -0.427709,  -0.421561,  -0.415414,  -0.409198,  -0.402847,    -0.396299,   -0.389505,  -0.382427,  -0.375041,
      -0.367343,  -0.35934,   -0.351058,  -0.342536,  -0.333824,    -0.324981,   -0.31607,   -0.307156,  -0.2983,
      -0.289558,  -0.280976,  -0.272588,  -0.264416,  -0.256465,    -0.248726,   -0.241175,  -0.233777,  -0.226485,
      -0.219247,  -0.212003,  -0.204694,  -0.197267,  -0.18967,     -0.181863,   -0.173816,  -0.165515,  -0.156956,
      -0.148153,  -0.13913,   -0.129926,  -0.120587,  -0.111168,    -0.101726,   -0.0923194, -0.0830038, -0.0738277,
      -0.0648312, -0.0560429, -0.0474783, -0.0391395, -0.0310147,   -0.0230789,  -0.015296,  -0.00762032},
     {0,          0.00761691, 0.015269,   0.0229901,  0.0308114,    0.0387601,   0.0468585, 0.055123,   0.0635637,
      0.0721835,  0.0809783,  0.089937,   0.0990419,  0.108269,     0.11759,     0.126971,  0.136376,   0.145768,
      0.155108,   0.16436,    0.173489,   0.182464,   0.191261,     0.199859,    0.208245,  0.216413,   0.224365,
      0.232108,   0.239659,   0.247041,   0.25428,    0.261409,     0.268465,    0.275486,  0.282509,   0.289572,
      0.296712,   0.303959,   0.31134,    0.318877,   0.326581,     0.334459,    0.34251,   0.350723,   0.35908,
      0.367557,   0.376121,   0.384737,   0.393363,   0.401955,     0.41047,     0.418864,  0.427094,   0.435122,
      0.442917,   0.450452,   0.457709,   0.464679,   0.47136,      0.47776,     0.483899,  0.489801,   0.495502,
      0.50104,    0.506464,   0.511821,   0.517164,   0.522544,     0.528011,    0.533611,  0.539383,   0.545361,
      0.551569,   0.55802,    0.564719,   0.571657,   0.578816,     0.586166,    0.593667,  0.601271,   0.608921,
      0.616556,   0.624111,   0.63152,    0.638719,   0.645645,     0.652245,    0.658472,  0.66429,    0.669678,
      0.674626,   0.679139,   0.68324,    0.686966,   0.690369,     0.693516,    0.696488,  0.699373,   0.702272,
      0.70529,    0.708532,   0.712107,   0.716117,   0.720657,     0.725811,    0.731651,  0.73823,    0.745583,
      0.753724,   0.762643,   0.772309,   0.782663,   0.793629,     0.805102,    0.816962,  0.829067,   0.841262,
      0.85338,    0.865245,   0.876676,   0.887493,   0.897523,     0.906596,    0.914561,  0.921278,   0.92663,
      0.930523,   0.932887,   0.933679,   0.932887,   0.930523,     0.92663,     0.921278,  0.914561,   0.906596,
      0.897523,   0.887493,   0.876676,   0.865245,   0.85338,      0.841262,    0.829067,  0.816962,   0.805102,
      0.793629,   0.782663,   0.772309,   0.762643,   0.753724,     0.745583,    0.73823,   0.731651,   0.725811,
      0.720657,   0.716117,   0.712107,   0.708532,   0.70529,      0.702272,    0.699373,  0.696488,   0.693516,
      0.690369,   0.686966,   0.68324,    0.679139,   0.674626,     0.669678,    0.66429,   0.658472,   0.652245,
      0.645645,   0.638719,   0.63152,    0.624111,   0.616556,     0.608921,    0.601271,  0.593667,   0.586166,
      0.578816,   0.571657,   0.564719,   0.55802,    0.551569,     0.545361,    0.539383,  0.533611,   0.528011,
      0.522544,   0.517164,   0.511821,   0.506464,   0.50104,      0.495502,    0.489801,  0.483899,   0.47776,
      0.47136,    0.464679,   0.457709,   0.450452,   0.442917,     0.435122,    0.427094,  0.418864,   0.41047,
      0.401955,   0.393363,   0.384737,   0.376121,   0.367557,     0.35908,     0.350723,  0.34251,    0.334459,
      0.326581,   0.318877,   0.31134,    0.303959,   0.296712,     0.289572,    0.282509,  0.275486,   0.268465,
      0.261409,   0.25428,    0.247041,   0.239659,   0.232108,     0.224365,    0.216413,  0.208245,   0.199859,
      0.191261,   0.182464,   0.173489,   0.16436,    0.155108,     0.145768,    0.136376,  0.126971,   0.11759,
      0.108269,   0.0990419,  0.089937,   0.0809783,  0.0721835,    0.0635637,   0.055123,  0.0468585,  0.0387601,
      0.0308114,  0.0229901,  0.015269,   0.00761691, -5.32209e-17, -0.00761691, -0.015269, -0.0229901, -0.0308114,
      -0.0387601, -0.0468585, -0.055123,  -0.0635637, -0.0721835,   -0.0809783,  -0.089937, -0.0990419, -0.108269,
      -0.11759,   -0.126971,  -0.136376,  -0.145768,  -0.155108,    -0.16436,    -0.173489, -0.182464,  -0.191261,
      -0.199859,  -0.208245,  -0.216413,  -0.224365,  -0.232108,    -0.239659,   -0.247041, -0.25428,   -0.261409,
      -0.268465,  -0.275486,  -0.282509,  -0.289572,  -0.296712,    -0.303959,   -0.31134,  -0.318877,  -0.326581,
      -0.334459,  -0.34251,   -0.350723,  -0.35908,   -0.367557,    -0.376121,   -0.384737, -0.393363,  -0.401955,
      -0.41047,   -0.418864,  -0.427094,  -0.435122,  -0.442917,    -0.450452,   -0.457709, -0.464679,  -0.47136,
      -0.47776,   -0.483899,  -0.489801,  -0.495502,  -0.50104,     -0.506464,   -0.511821, -0.517164,  -0.522544,
      -0.528011,  -0.533611,  -0.539383,  -0.545361,  -0.551569,    -0.55802,    -0.564719, -0.571657,  -0.578816,
      -0.586166,  -0.593667,  -0.601271,  -0.608921,  -0.616556,    -0.624111,   -0.63152,  -0.638719,  -0.645645,
      -0.652245,  -0.658472,  -0.66429,   -0.669678,  -0.674626,    -0.679139,   -0.68324,  -0.686966,  -0.690369,
      -0.693516,  -0.696488,  -0.699373,  -0.702272,  -0.70529,     -0.708532,   -0.712107, -0.716117,  -0.720657,
      -0.725811,  -0.731651,  -0.73823,   -0.745583,  -0.753724,    -0.762643,   -0.772309, -0.782663,  -0.793629,
      -0.805102,  -0.816962,  -0.829067,  -0.841262,  -0.85338,     -0.865245,   -0.876676, -0.887493,  -0.897523,
      -0.906596,  -0.914561,  -0.921278,  -0.92663,   -0.930523,    -0.932887,   -0.933679, -0.932887,  -0.930523,
      -0.92663,   -0.921278,  -0.914561,  -0.906596,  -0.897523,    -0.887493,   -0.876676, -0.865245,  -0.85338,
      -0.841262,  -0.829067,  -0.816962,  -0.805102,  -0.793629,    -0.782663,   -0.772309, -0.762643,  -0.753724,
      -0.745583,  -0.73823,   -0.731651,  -0.725811,  -0.720657,    -0.716117,   -0.712107, -0.708532,  -0.70529,
      -0.702272,  -0.699373,  -0.696488,  -0.693516,  -0.690369,    -0.686966,   -0.68324,  -0.679139,  -0.674626,
      -0.669678,  -0.66429,   -0.658472,  -0.652245,  -0.645645,    -0.638719,   -0.63152,  -0.624111,  -0.616556,
      -0.608921,  -0.601271,  -0.593667,  -0.586166,  -0.578816,    -0.571657,   -0.564719, -0.55802,   -0.551569,
      -0.545361,  -0.539383,  -0.533611,  -0.528011,  -0.522544,    -0.517164,   -0.511821, -0.506464,  -0.50104,
      -0.495502,  -0.489801,  -0.483899,  -0.47776,   -0.47136,     -0.464679,   -0.457709, -0.450452,  -0.442917,
      -0.435122,  -0.427094,  -0.418864,  -0.41047,   -0.401955,    -0.393363,   -0.384737, -0.376121,  -0.367557,
      -0.35908,   -0.350723,  -0.34251,   -0.334459,  -0.326581,    -0.318877,   -0.31134,  -0.303959,  -0.296712,
      -0.289572,  -0.282509,  -0.275486,  -0.268465,  -0.261409,    -0.25428,    -0.247041, -0.239659,  -0.232108,
      -0.224365,  -0.216413,  -0.208245,  -0.199859,  -0.191261,    -0.182464,   -0.173489, -0.16436,   -0.155108,
      -0.145768,  -0.136376,  -0.126971,  -0.11759,   -0.108269,    -0.0990419,  -0.089937, -0.0809783, -0.0721835,
      -0.0635637, -0.055123,  -0.0468585, -0.0387601, -0.0308114,   -0.0229901,  -0.015269, -0.00761691},
     {0,          0.00761424, 0.0152479,  0.0229198,  0.0306482,   0.0384499,   0.0463402,  0.0543323,  0.0624372,
      0.0706636,  0.0790172,  0.0875009,  0.0961147,  0.104855,    0.113717,    0.122691,   0.131766,   0.140928,
      0.15016,    0.159443,   0.16876,    0.178088,   0.187405,    0.19669,     0.20592,    0.215075,   0.224133,
      0.233075,   0.241885,   0.250546,   0.259047,   0.267377,    0.275529,    0.283499,   0.291286,   0.298893,
      0.306326,   0.313593,   0.320705,   0.327678,   0.334528,    0.341273,    0.347936,   0.354536,   0.361097,
      0.367642,   0.374195,   0.380776,   0.387408,   0.394109,    0.400898,    0.407789,   0.414795,   0.421925,
      0.429184,   0.436575,   0.444097,   0.451743,   0.459505,    0.467371,    0.475325,   0.483346,   0.491414,
      0.499504,   0.507588,   0.515639,   0.523629,   0.531526,    0.539302,    0.546928,   0.554377,   0.561624,
      0.568645,   0.575422,   0.581937,   0.588179,   0.594141,    0.599818,    0.605213,   0.610332,   0.615189,
      0.619799,   0.624185,   0.628372,   0.632393,   0.636281,    0.640076,    0.643817,   0.647548,   0.651315,
      0.655162,   0.659134,   0.663278,   0.667634,   0.672245,    0.677147,    0.682374,   0.687953,   0.693909,
      0.700258,   0.707011,   0.714172,   0.721737,   0.729697,    0.738032,    0.746716,   0.755717,   0.764995,
      0.774503,   0.784187,   0.793988,   0.803843,   0.813684,    0.823438,    0.833032,   0.842391,   0.851438,
      0.860097,   0.868294,   0.875957,   0.883018,   0.889413,    0.895081,    0.899972,   0.904039,   0.907243,
      0.909554,   0.910949,   0.911416,   0.910949,   0.909554,    0.907243,    0.904039,   0.899972,   0.895081,
      0.889413,   0.883018,   0.875957,   0.868294,   0.860097,    0.851438,    0.842391,   0.833032,   0.823438,
      0.813684,   0.803843,   0.793988,   0.784187,   0.774503,    0.764995,    0.755717,   0.746716,   0.738032,
      0.729697,   0.721737,   0.714172,   0.707011,   0.700258,    0.693909,    0.687953,   0.682374,   0.677147,
      0.672245,   0.667634,   0.663278,   0.659134,   0.655162,    0.651315,    0.647548,   0.643817,   0.640076,
      0.636281,   0.632393,   0.628372,   0.624185,   0.619799,    0.615189,    0.610332,   0.605213,   0.599818,
      0.594141,   0.588179,   0.581937,   0.575422,   0.568645,    0.561624,    0.554377,   0.546928,   0.539302,
      0.531526,   0.523629,   0.515639,   0.507588,   0.499504,    0.491414,    0.483346,   0.475325,   0.467371,
      0.459505,   0.451743,   0.444097,   0.436575,   0.429184,    0.421925,    0.414795,   0.407789,   0.400898,
      0.394109,   0.387408,   0.380776,   0.374195,   0.367642,    0.361097,    0.354536,   0.347936,   0.341273,
      0.334528,   0.327678,   0.320705,   0.313593,   0.306326,    0.298893,    0.291286,   0.283499,   0.275529,
      0.267377,   0.259047,   0.250546,   0.241885,   0.233075,    0.224133,    0.215075,   0.20592,    0.19669,
      0.187405,   0.178088,   0.16876,    0.159443,   0.15016,     0.140928,    0.131766,   0.122691,   0.113717,
      0.104855,   0.0961147,  0.0875009,  0.0790172,  0.0706636,   0.0624372,   0.0543323,  0.0463402,  0.0384499,
      0.0306482,  0.0229198,  0.0152479,  0.00761424, 2.58754e-17, -0.00761424, -0.0152479, -0.0229198, -0.0306482,
      -0.0384499, -0.0463402, -0.0543323, -0.0624372, -0.0706636,  -0.0790172,  -0.0875009, -0.0961147, -0.104855,
      -0.113717,  -0.122691,  -0.131766,  -0.140928,  -0.15016,    -0.159443,   -0.16876,   -0.178088,  -0.187405,
      -0.19669,   -0.20592,   -0.215075,  -0.224133,  -0.233075,   -0.241885,   -0.250546,  -0.259047,  -0.267377,
      -0.275529,  -0.283499,  -0.291286,  -0.298893,  -0.306326,   -0.313593,   -0.320705,  -0.327678,  -0.334528,
      -0.341273,  -0.347936,  -0.354536,  -0.361097,  -0.367642,   -0.374195,   -0.380776,  -0.387408,  -0.394109,
      -0.400898,  -0.407789,  -0.414795,  -0.421925,  -0.429184,   -0.436575,   -0.444097,  -0.451743,  -0.459505,
      -0.467371,  -0.475325,  -0.483346,  -0.491414,  -0.499504,   -0.507588,   -0.515639,  -0.523629,  -0.531526,
      -0.539302,  -0.546928,  -0.554377,  -0.561624,  -0.568645,   -0.575422,   -0.581937,  -0.588179,  -0.594141,
      -0.599818,  -0.605213,  -0.610332,  -0.615189,  -0.619799,   -0.624185,   -0.628372,  -0.632393,  -0.636281,
      -0.640076,  -0.643817,  -0.647548,  -0.651315,  -0.655162,   -0.659134,   -0.663278,  -0.667634,  -0.672245,
      -0.677147,  -0.682374,  -0.687953,  -0.693909,  -0.700258,   -0.707011,   -0.714172,  -0.721737,  -0.729697,
      -0.738032,  -0.746716,  -0.755717,  -0.764995,  -0.774503,   -0.784187,   -0.793988,  -0.803843,  -0.813684,
      -0.823438,  -0.833032,  -0.842391,  -0.851438,  -0.860097,   -0.868294,   -0.875957,  -0.883018,  -0.889413,
      -0.895081,  -0.899972,  -0.904039,  -0.907243,  -0.909554,   -0.910949,   -0.911416,  -0.910949,  -0.909554,
      -0.907243,  -0.904039,  -0.899972,  -0.895081,  -0.889413,   -0.883018,   -0.875957,  -0.868294,  -0.860097,
      -0.851438,  -0.842391,  -0.833032,  -0.823438,  -0.813684,   -0.803843,   -0.793988,  -0.784187,  -0.774503,
      -0.764995,  -0.755717,  -0.746716,  -0.738032,  -0.729697,   -0.721737,   -0.714172,  -0.707011,  -0.700258,
      -0.693909,  -0.687953,  -0.682374,  -0.677147,  -0.672245,   -0.667634,   -0.663278,  -0.659134,  -0.655162,
      -0.651315,  -0.647548,  -0.643817,  -0.640076,  -0.636281,   -0.632393,   -0.628372,  -0.624185,  -0.619799,
      -0.615189,  -0.610332,  -0.605213,  -0.599818,  -0.594141,   -0.588179,   -0.581937,  -0.575422,  -0.568645,
      -0.561624,  -0.554377,  -0.546928,  -0.539302,  -0.531526,   -0.523629,   -0.515639,  -0.507588,  -0.499504,
      -0.491414,  -0.483346,  -0.475325,  -0.467371,  -0.459505,   -0.451743,   -0.444097,  -0.436575,  -0.429184,
      -0.421925,  -0.414795,  -0.407789,  -0.400898,  -0.394109,   -0.387408,   -0.380776,  -0.374195,  -0.367642,
      -0.361097,  -0.354536,  -0.347936,  -0.341273,  -0.334528,   -0.327678,   -0.320705,  -0.313593,  -0.306326,
      -0.298893,  -0.291286,  -0.283499,  -0.275529,  -0.267377,   -0.259047,   -0.250546,  -0.241885,  -0.233075,
      -0.224133,  -0.215075,  -0.20592,   -0.19669,   -0.187405,   -0.178088,   -0.16876,   -0.159443,  -0.15016,
      -0.140928,  -0.131766,  -0.122691,  -0.113717,  -0.104855,   -0.0961147,  -0.0875009, -0.0790172, -0.0706636,
      -0.0624372, -0.0543323, -0.0463402, -0.0384499, -0.0306482,  -0.0229198,  -0.0152479, -0.00761424},
     {0,          0.00951122, 0.0190073,  0.0284733,  0.0378947,   0.0472576,   0.0565488,  0.065756,   0.0748683,
      0.0838759,  0.0927702,  0.101544,   0.110193,   0.118713,    0.127101,    0.135359,   0.143486,   0.151487,
      0.159366,   0.16713,    0.174786,   0.182344,   0.189815,    0.197209,    0.204539,   0.211818,   0.21906,
      0.226279,   0.233488,   0.240702,   0.247935,   0.255199,    0.262506,    0.269869,   0.277297,   0.284799,
      0.292383,   0.300055,   0.307819,   0.315678,   0.323632,    0.33168,     0.339819,   0.348044,   0.356349,
      0.364723,   0.373158,   0.38164,    0.390158,   0.398694,    0.407235,    0.415763,   0.424261,   0.43271,
      0.441093,   0.44939,    0.457585,   0.46566,    0.473597,    0.481381,    0.488998,   0.496434,   0.503679,
      0.510721,   0.517555,   0.524174,   0.530576,   0.53676,     0.542727,    0.548482,   0.554031,   0.559384,
      0.564553,   0.569552,   0.574396,   0.579104,   0.583696,    0.588195,    0.592622,   0.597004,   0.601364,
      0.60573,    0.610127,   0.614582,   0.619121,   0.62377,     0.628551,    0.63349,    0.638606,   0.64392,
      0.64945,    0.655209,   0.661209,   0.667461,   0.673971,    0.68074,     0.687768,   0.695051,   0.702581,
      0.710346,   0.718332,   0.72652,    0.734888,   0.743411,    0.752059,    0.760802,   0.769605,   0.778433,
      0.787245,   0.796002,   0.804661,   0.81318,    0.821514,    0.82962,     0.837454,   0.844971,   0.85213,
      0.858888,   0.865206,   0.871046,   0.876374,   0.881155,    0.885362,    0.888967,   0.891949,   0.894288,
      0.895969,   0.896982,   0.89732,    0.896982,   0.895969,    0.894288,    0.891949,   0.888967,   0.885362,
      0.881155,   0.876374,   0.871046,   0.865206,   0.858888,    0.85213,     0.844971,   0.837454,   0.82962,
      0.821514,   0.81318,    0.804661,   0.796002,   0.787245,    0.778433,    0.769605,   0.760802,   0.752059,
      0.743411,   0.734888,   0.72652,    0.718332,   0.710346,    0.702581,    0.695051,   0.687768,   0.68074,
      0.673971,   0.667461,   0.661209,   0.655209,   0.64945,     0.64392,     0.638606,   0.63349,    0.628551,
      0.62377,    0.619121,   0.614582,   0.610127,   0.60573,     0.601364,    0.597004,   0.592622,   0.588195,
      0.583696,   0.579104,   0.574396,   0.569552,   0.564553,    0.559384,    0.554031,   0.548482,   0.542727,
      0.53676,    0.530576,   0.524174,   0.517555,   0.510721,    0.503679,    0.496434,   0.488998,   0.481381,
      0.473597,   0.46566,    0.457585,   0.44939,    0.441093,    0.43271,     0.424261,   0.415763,   0.407235,
      0.398694,   0.390158,   0.38164,    0.373158,   0.364723,    0.356349,    0.348044,   0.339819,   0.33168,
      0.323632,   0.315678,   0.307819,   0.300055,   0.292383,    0.284799,    0.277297,   0.269869,   0.262506,
      0.255199,   0.247935,   0.240702,   0.233488,   0.226279,    0.21906,     0.211818,   0.204539,   0.197209,
      0.189815,   0.182344,   0.174786,   0.16713,    0.159366,    0.151487,    0.143486,   0.135359,   0.127101,
      0.118713,   0.110193,   0.101544,   0.0927702,  0.0838759,   0.0748683,   0.065756,   0.0565488,  0.0472576,
      0.0378947,  0.0284733,  0.0190073,  0.00951122, 9.49407e-17, -0.00951122, -0.0190073, -0.0284733, -0.0378947,
      -0.0472576, -0.0565488, -0.065756,  -0.0748683, -0.0838759,  -0.0927702,  -0.101544,  -0.110193,  -0.118713,
      -0.127101,  -0.135359,  -0.143486,  -0.151487,  -0.159366,   -0.16713,    -0.174786,  -0.182344,  -0.189815,
      -0.197209,  -0.204539,  -0.211818,  -0.21906,   -0.226279,   -0.233488,   -0.240702,  -0.247935,  -0.255199,
      -0.262506,  -0.269869,  -0.277297,  -0.284799,  -0.292383,   -0.300055,   -0.307819,  -0.315678,  -0.323632,
      -0.33168,   -0.339819,  -0.348044,  -0.356349,  -0.364723,   -0.373158,   -0.38164,   -0.390158,  -0.398694,
      -0.407235,  -0.415763,  -0.424261,  -0.43271,   -0.441093,   -0.44939,    -0.457585,  -0.46566,   -0.473597,
      -0.481381,  -0.488998,  -0.496434,  -0.503679,  -0.510721,   -0.517555,   -0.524174,  -0.530576,  -0.53676,
      -0.542727,  -0.548482,  -0.554031,  -0.559384,  -0.564553,   -0.569552,   -0.574396,  -0.579104,  -0.583696,
      -0.588195,  -0.592622,  -0.597004,  -0.601364,  -0.60573,    -0.610127,   -0.614582,  -0.619121,  -0.62377,
      -0.628551,  -0.63349,   -0.638606,  -0.64392,   -0.64945,    -0.655209,   -0.661209,  -0.667461,  -0.673971,
      -0.68074,   -0.687768,  -0.695051,  -0.702581,  -0.710346,   -0.718332,   -0.72652,   -0.734888,  -0.743411,
      -0.752059,  -0.760802,  -0.769605,  -0.778433,  -0.787245,   -0.796002,   -0.804661,  -0.81318,   -0.821514,
      -0.82962,   -0.837454,  -0.844971,  -0.85213,   -0.858888,   -0.865206,   -0.871046,  -0.876374,  -0.881155,
      -0.885362,  -0.888967,  -0.891949,  -0.894288,  -0.895969,   -0.896982,   -0.89732,   -0.896982,  -0.895969,
      -0.894288,  -0.891949,  -0.888967,  -0.885362,  -0.881155,   -0.876374,   -0.871046,  -0.865206,  -0.858888,
      -0.85213,   -0.844971,  -0.837454,  -0.82962,   -0.821514,   -0.81318,    -0.804661,  -0.796002,  -0.787245,
      -0.778433,  -0.769605,  -0.760802,  -0.752059,  -0.743411,   -0.734888,   -0.72652,   -0.718332,  -0.710346,
      -0.702581,  -0.695051,  -0.687768,  -0.68074,   -0.673971,   -0.667461,   -0.661209,  -0.655209,  -0.64945,
      -0.64392,   -0.638606,  -0.63349,   -0.628551,  -0.62377,    -0.619121,   -0.614582,  -0.610127,  -0.60573,
      -0.601364,  -0.597004,  -0.592622,  -0.588195,  -0.583696,   -0.579104,   -0.574396,  -0.569552,  -0.564553,
      -0.559384,  -0.554031,  -0.548482,  -0.542727,  -0.53676,    -0.530576,   -0.524174,  -0.517555,  -0.510721,
      -0.503679,  -0.496434,  -0.488998,  -0.481381,  -0.473597,   -0.46566,    -0.457585,  -0.44939,   -0.441093,
      -0.43271,   -0.424261,  -0.415763,  -0.407235,  -0.398694,   -0.390158,   -0.38164,   -0.373158,  -0.364723,
      -0.356349,  -0.348044,  -0.339819,  -0.33168,   -0.323632,   -0.315678,   -0.307819,  -0.300055,  -0.292383,
      -0.284799,  -0.277297,  -0.269869,  -0.262506,  -0.255199,   -0.247935,   -0.240702,  -0.233488,  -0.226279,
      -0.21906,   -0.211818,  -0.204539,  -0.197209,  -0.189815,   -0.182344,   -0.174786,  -0.16713,   -0.159366,
      -0.151487,  -0.143486,  -0.135359,  -0.127101,  -0.118713,   -0.110193,   -0.101544,  -0.0927702, -0.0838759,
      -0.0748683, -0.065756,  -0.0565488, -0.0472576, -0.0378947,  -0.0284733,  -0.0190073, -0.00951122},
     {0,          0.00761233, 0.0152327,  0.0228689,  0.0305289,   0.0382201,   0.0459497,  0.0537246,  0.0615511,
      0.0694351,  0.0773819,  0.0853961,  0.0934816,  0.101642,    0.109879,    0.118194,   0.126589,   0.135064,
      0.143616,   0.152246,   0.160949,   0.169722,   0.178562,    0.187462,    0.196417,   0.205421,   0.214465,
      0.223542,   0.232643,   0.241759,   0.25088,    0.259997,    0.269099,    0.278176,   0.287217,   0.296211,
      0.305148,   0.314017,   0.322809,   0.331512,   0.340118,    0.348617,    0.357,      0.365261,   0.37339,
      0.381382,   0.389231,   0.396932,   0.404482,   0.411877,    0.419115,    0.426195,   0.433118,   0.439884,
      0.446497,   0.452958,   0.459274,   0.465448,   0.471488,    0.4774,      0.483194,   0.488878,   0.494462,
      0.499956,   0.505373,   0.510724,   0.516021,   0.521278,    0.526506,    0.53172,    0.536933,   0.542158,
      0.547409,   0.552698,   0.558038,   0.563441,   0.56892,     0.574484,    0.580145,   0.585912,   0.591793,
      0.597796,   0.603927,   0.610192,   0.616594,   0.623135,    0.629819,    0.636643,   0.643607,   0.650708,
      0.657941,   0.665301,   0.672779,   0.680367,   0.688056,    0.695832,    0.703684,   0.711597,   0.719555,
      0.727542,   0.735539,   0.743529,   0.751492,   0.759407,    0.767253,    0.775008,   0.78265,    0.790158,
      0.797508,   0.804677,   0.811643,   0.818383,   0.824875,    0.831099,    0.837031,   0.842653,   0.847944,
      0.852885,   0.85746,    0.861652,   0.865444,   0.868825,    0.871781,    0.8743,     0.876375,   0.877997,
      0.87916,    0.879859,   0.880092,   0.879859,   0.87916,     0.877997,    0.876375,   0.8743,     0.871781,
      0.868825,   0.865444,   0.861652,   0.85746,    0.852885,    0.847944,    0.842653,   0.837031,   0.831099,
      0.824875,   0.818383,   0.811643,   0.804677,   0.797508,    0.790158,    0.78265,    0.775008,   0.767253,
      0.759407,   0.751492,   0.743529,   0.735539,   0.727542,    0.719555,    0.711597,   0.703684,   0.695832,
      0.688056,   0.680367,   0.672779,   0.665301,   0.657941,    0.650708,    0.643607,   0.636643,   0.629819,
      0.623135,   0.616594,   0.610192,   0.603927,   0.597796,    0.591793,    0.585912,   0.580145,   0.574484,
      0.56892,    0.563441,   0.558038,   0.552698,   0.547409,    0.542158,    0.536933,   0.53172,    0.526506,
      0.521278,   0.516021,   0.510724,   0.505373,   0.499956,    0.494462,    0.488878,   0.483194,   0.4774,
      0.471488,   0.465448,   0.459274,   0.452958,   0.446497,    0.439884,    0.433118,   0.426195,   0.419115,
      0.411877,   0.404482,   0.396932,   0.389231,   0.381382,    0.37339,     0.365261,   0.357,      0.348617,
      0.340118,   0.331512,   0.322809,   0.314017,   0.305148,    0.296211,    0.287217,   0.278176,   0.269099,
      0.259997,   0.25088,    0.241759,   0.232643,   0.223542,    0.214465,    0.205421,   0.196417,   0.187462,
      0.178562,   0.169722,   0.160949,   0.152246,   0.143616,    0.135064,    0.126589,   0.118194,   0.109879,
      0.101642,   0.0934816,  0.0853961,  0.0773819,  0.0694351,   0.0615511,   0.0537246,  0.0459497,  0.0382201,
      0.0305289,  0.0228689,  0.0152327,  0.00761233, 7.59526e-17, -0.00761233, -0.0152327, -0.0228689, -0.0305289,
      -0.0382201, -0.0459497, -0.0537246, -0.0615511, -0.0694351,  -0.0773819,  -0.0853961, -0.0934816, -0.101642,
      -0.109879,  -0.118194,  -0.126589,  -0.135064,  -0.143616,   -0.152246,   -0.160949,  -0.169722,  -0.178562,
      -0.187462,  -0.196417,  -0.205421,  -0.214465,  -0.223542,   -0.232643,   -0.241759,  -0.25088,   -0.259997,
      -0.269099,  -0.278176,  -0.287217,  -0.296211,  -0.305148,   -0.314017,   -0.322809,  -0.331512,  -0.340118,
      -0.348617,  -0.357,     -0.365261,  -0.37339,   -0.381382,   -0.389231,   -0.396932,  -0.404482,  -0.411877,
      -0.419115,  -0.426195,  -0.433118,  -0.439884,  -0.446497,   -0.452958,   -0.459274,  -0.465448,  -0.471488,
      -0.4774,    -0.483194,  -0.488878,  -0.494462,  -0.499956,   -0.505373,   -0.510724,  -0.516021,  -0.521278,
      -0.526506,  -0.53172,   -0.536933,  -0.542158,  -0.547409,   -0.552698,   -0.558038,  -0.563441,  -0.56892,
      -0.574484,  -0.580145,  -0.585912,  -0.591793,  -0.597796,   -0.603927,   -0.610192,  -0.616594,  -0.623135,
      -0.629819,  -0.636643,  -0.643607,  -0.650708,  -0.657941,   -0.665301,   -0.672779,  -0.680367,  -0.688056,
      -0.695832,  -0.703684,  -0.711597,  -0.719555,  -0.727542,   -0.735539,   -0.743529,  -0.751492,  -0.759407,
      -0.767253,  -0.775008,  -0.78265,   -0.790158,  -0.797508,   -0.804677,   -0.811643,  -0.818383,  -0.824875,
      -0.831099,  -0.837031,  -0.842653,  -0.847944,  -0.852885,   -0.85746,    -0.861652,  -0.865444,  -0.868825,
      -0.871781,  -0.8743,    -0.876375,  -0.877997,  -0.87916,    -0.879859,   -0.880092,  -0.879859,  -0.87916,
      -0.877997,  -0.876375,  -0.8743,    -0.871781,  -0.868825,   -0.865444,   -0.861652,  -0.85746,   -0.852885,
      -0.847944,  -0.842653,  -0.837031,  -0.831099,  -0.824875,   -0.818383,   -0.811643,  -0.804677,  -0.797508,
      -0.790158,  -0.78265,   -0.775008,  -0.767253,  -0.759407,   -0.751492,   -0.743529,  -0.735539,  -0.727542,
      -0.719555,  -0.711597,  -0.703684,  -0.695832,  -0.688056,   -0.680367,   -0.672779,  -0.665301,  -0.657941,
      -0.650708,  -0.643607,  -0.636643,  -0.629819,  -0.623135,   -0.616594,   -0.610192,  -0.603927,  -0.597796,
      -0.591793,  -0.585912,  -0.580145,  -0.574484,  -0.56892,    -0.563441,   -0.558038,  -0.552698,  -0.547409,
      -0.542158,  -0.536933,  -0.53172,   -0.526506,  -0.521278,   -0.516021,   -0.510724,  -0.505373,  -0.499956,
      -0.494462,  -0.488878,  -0.483194,  -0.4774,    -0.471488,   -0.465448,   -0.459274,  -0.452958,  -0.446497,
      -0.439884,  -0.433118,  -0.426195,  -0.419115,  -0.411877,   -0.404482,   -0.396932,  -0.389231,  -0.381382,
      -0.37339,   -0.365261,  -0.357,     -0.348617,  -0.340118,   -0.331512,   -0.322809,  -0.314017,  -0.305148,
      -0.296211,  -0.287217,  -0.278176,  -0.269099,  -0.259997,   -0.25088,    -0.241759,  -0.232643,  -0.223542,
      -0.214465,  -0.205421,  -0.196417,  -0.187462,  -0.178562,   -0.169722,   -0.160949,  -0.152246,  -0.143616,
      -0.135064,  -0.126589,  -0.118194,  -0.109879,  -0.101642,   -0.0934816,  -0.0853961, -0.0773819, -0.0694351,
      -0.0615511, -0.0537246, -0.0459497, -0.0382201, -0.0305289,  -0.0228689,  -0.0152327, -0.00761233},
     {0,          0.00951274, 0.0190195,  0.0285142,  0.037991,    0.047444,    0.0568674,  0.0662555,  0.0756029,
      0.0849041,  0.0941541,  0.103348,   0.11248,    0.121547,    0.130545,    0.139468,   0.148314,   0.157079,
      0.16576,    0.174354,   0.182859,   0.191273,   0.199594,    0.207821,    0.215952,   0.223987,   0.231927,
      0.23977,    0.247518,   0.255171,   0.26273,    0.270198,    0.277575,    0.284865,   0.29207,    0.299192,
      0.306235,   0.313202,   0.320097,   0.326925,   0.333688,    0.340392,    0.347041,   0.353641,   0.360195,
      0.36671,    0.373189,   0.379639,   0.386065,   0.392472,    0.398865,    0.40525,    0.411632,   0.418016,
      0.424407,   0.43081,    0.43723,    0.443672,   0.45014,     0.456638,    0.463171,   0.469741,   0.476352,
      0.483008,   0.489711,   0.496463,   0.503267,   0.510124,    0.517036,    0.524003,   0.531025,   0.538104,
      0.545238,   0.552426,   0.559667,   0.56696,    0.574302,    0.58169,     0.589121,   0.596592,   0.604099,
      0.611637,   0.6192,     0.626785,   0.634385,   0.641993,    0.649604,    0.65721,    0.664803,   0.672378,
      0.679924,   0.687436,   0.694902,   0.702316,   0.709668,    0.716948,    0.724148,   0.731258,   0.738268,
      0.74517,    0.751952,   0.758605,   0.765119,   0.771486,    0.777694,    0.783735,   0.789599,   0.795276,
      0.800758,   0.806035,   0.811099,   0.815941,   0.820554,    0.824929,    0.829059,   0.832937,   0.836556,
      0.83991,    0.842992,   0.845798,   0.848322,   0.85056,     0.852508,    0.854162,   0.85552,    0.856578,
      0.857336,   0.857791,   0.857942,   0.857791,   0.857336,    0.856578,    0.85552,    0.854162,   0.852508,
      0.85056,    0.848322,   0.845798,   0.842992,   0.83991,     0.836556,    0.832937,   0.829059,   0.824929,
      0.820554,   0.815941,   0.811099,   0.806035,   0.800758,    0.795276,    0.789599,   0.783735,   0.777694,
      0.771486,   0.765119,   0.758605,   0.751952,   0.74517,     0.738268,    0.731258,   0.724148,   0.716948,
      0.709668,   0.702316,   0.694902,   0.687436,   0.679924,    0.672378,    0.664803,   0.65721,    0.649604,
      0.641993,   0.634385,   0.626785,   0.6192,     0.611637,    0.604099,    0.596592,   0.589121,   0.58169,
      0.574302,   0.56696,    0.559667,   0.552426,   0.545238,    0.538104,    0.531025,   0.524003,   0.517036,
      0.510124,   0.503267,   0.496463,   0.489711,   0.483008,    0.476352,    0.469741,   0.463171,   0.456638,
      0.45014,    0.443672,   0.43723,    0.43081,    0.424407,    0.418016,    0.411632,   0.40525,    0.398865,
      0.392472,   0.386065,   0.379639,   0.373189,   0.36671,     0.360195,    0.353641,   0.347041,   0.340392,
      0.333688,   0.326925,   0.320097,   0.313202,   0.306235,    0.299192,    0.29207,    0.284865,   0.277575,
      0.270198,   0.26273,    0.255171,   0.247518,   0.23977,     0.231927,    0.223987,   0.215952,   0.207821,
      0.199594,   0.191273,   0.182859,   0.174354,   0.16576,     0.157079,    0.148314,   0.139468,   0.130545,
      0.121547,   0.11248,    0.103348,   0.0941541,  0.0849041,   0.0756029,   0.0662555,  0.0568674,  0.047444,
      0.037991,   0.0285142,  0.0190195,  0.00951274, 9.49407e-17, -0.00951274, -0.0190195, -0.0285142, -0.037991,
      -0.047444,  -0.0568674, -0.0662555, -0.0756029, -0.0849041,  -0.0941541,  -0.103348,  -0.11248,   -0.121547,
      -0.130545,  -0.139468,  -0.148314,  -0.157079,  -0.16576,    -0.174354,   -0.182859,  -0.191273,  -0.199594,
      -0.207821,  -0.215952,  -0.223987,  -0.231927,  -0.23977,    -0.247518,   -0.255171,  -0.26273,   -0.270198,
      -0.277575,  -0.284865,  -0.29207,   -0.299192,  -0.306235,   -0.313202,   -0.320097,  -0.326925,  -0.333688,
      -0.340392,  -0.347041,  -0.353641,  -0.360195,  -0.36671,    -0.373189,   -0.379639,  -0.386065,  -0.392472,
      -0.398865,  -0.40525,   -0.411632,  -0.418016,  -0.424407,   -0.43081,    -0.43723,   -0.443672,  -0.45014,
      -0.456638,  -0.463171,  -0.469741,  -0.476352,  -0.483008,   -0.489711,   -0.496463,  -0.503267,  -0.510124,
      -0.517036,  -0.524003,  -0.531025,  -0.538104,  -0.545238,   -0.552426,   -0.559667,  -0.56696,   -0.574302,
      -0.58169,   -0.589121,  -0.596592,  -0.604099,  -0.611637,   -0.6192,     -0.626785,  -0.634385,  -0.641993,
      -0.649604,  -0.65721,   -0.664803,  -0.672378,  -0.679924,   -0.687436,   -0.694902,  -0.702316,  -0.709668,
      -0.716948,  -0.724148,  -0.731258,  -0.738268,  -0.74517,    -0.751952,   -0.758605,  -0.765119,  -0.771486,
      -0.777694,  -0.783735,  -0.789599,  -0.795276,  -0.800758,   -0.806035,   -0.811099,  -0.815941,  -0.820554,
      -0.824929,  -0.829059,  -0.832937,  -0.836556,  -0.83991,    -0.842992,   -0.845798,  -0.848322,  -0.85056,
      -0.852508,  -0.854162,  -0.85552,   -0.856578,  -0.857336,   -0.857791,   -0.857942,  -0.857791,  -0.857336,
      -0.856578,  -0.85552,   -0.854162,  -0.852508,  -0.85056,    -0.848322,   -0.845798,  -0.842992,  -0.83991,
      -0.836556,  -0.832937,  -0.829059,  -0.824929,  -0.820554,   -0.815941,   -0.811099,  -0.806035,  -0.800758,
      -0.795276,  -0.789599,  -0.783735,  -0.777694,  -0.771486,   -0.765119,   -0.758605,  -0.751952,  -0.74517,
      -0.738268,  -0.731258,  -0.724148,  -0.716948,  -0.709668,   -0.702316,   -0.694902,  -0.687436,  -0.679924,
      -0.672378,  -0.664803,  -0.65721,   -0.649604,  -0.641993,   -0.634385,   -0.626785,  -0.6192,    -0.611637,
      -0.604099,  -0.596592,  -0.589121,  -0.58169,   -0.574302,   -0.56696,    -0.559667,  -0.552426,  -0.545238,
      -0.538104,  -0.531025,  -0.524003,  -0.517036,  -0.510124,   -0.503267,   -0.496463,  -0.489711,  -0.483008,
      -0.476352,  -0.469741,  -0.463171,  -0.456638,  -0.45014,    -0.443672,   -0.43723,   -0.43081,   -0.424407,
      -0.418016,  -0.411632,  -0.40525,   -0.398865,  -0.392472,   -0.386065,   -0.379639,  -0.373189,  -0.36671,
      -0.360195,  -0.353641,  -0.347041,  -0.340392,  -0.333688,   -0.326925,   -0.320097,  -0.313202,  -0.306235,
      -0.299192,  -0.29207,   -0.284865,  -0.277575,  -0.270198,   -0.26273,    -0.255171,  -0.247518,  -0.23977,
      -0.231927,  -0.223987,  -0.215952,  -0.207821,  -0.199594,   -0.191273,   -0.182859,  -0.174354,  -0.16576,
      -0.157079,  -0.148314,  -0.139468,  -0.130545,  -0.121547,   -0.11248,    -0.103348,  -0.0941541, -0.0849041,
      -0.0756029, -0.0662555, -0.0568674, -0.047444,  -0.037991,   -0.0285142,  -0.0190195, -0.00951274},
     {0,          0.00951274, 0.0190195,  0.0285142,  0.037991,    0.047444,    0.0568674,  0.0662555,  0.0756029,
      0.0849041,  0.0941541,  0.103348,   0.11248,    0.121547,    0.130545,    0.139468,   0.148314,   0.157079,
      0.16576,    0.174354,   0.182859,   0.191273,   0.199594,    0.207821,    0.215952,   0.223987,   0.231927,
      0.23977,    0.247518,   0.255171,   0.26273,    0.270198,    0.277575,    0.284865,   0.29207,    0.299192,
      0.306235,   0.313202,   0.320097,   0.326925,   0.333688,    0.340392,    0.347041,   0.353641,   0.360195,
      0.36671,    0.373189,   0.379639,   0.386065,   0.392472,    0.398865,    0.40525,    0.411632,   0.418016,
      0.424407,   0.43081,    0.43723,    0.443672,   0.45014,     0.456638,    0.463171,   0.469741,   0.476352,
      0.483008,   0.489711,   0.496463,   0.503267,   0.510124,    0.517036,    0.524003,   0.531025,   0.538104,
      0.545238,   0.552426,   0.559667,   0.56696,    0.574302,    0.58169,     0.589121,   0.596592,   0.604099,
      0.611637,   0.6192,     0.626785,   0.634385,   0.641993,    0.649604,    0.65721,    0.664803,   0.672378,
      0.679924,   0.687436,   0.694902,   0.702316,   0.709668,    0.716948,    0.724148,   0.731258,   0.738268,
      0.74517,    0.751952,   0.758605,   0.765119,   0.771486,    0.777694,    0.783735,   0.789599,   0.795276,
      0.800758,   0.806035,   0.811099,   0.815941,   0.820554,    0.824929,    0.829059,   0.832937,   0.836556,
      0.83991,    0.842992,   0.845798,   0.848322,   0.85056,     0.852508,    0.854162,   0.85552,    0.856578,
      0.857336,   0.857791,   0.857942,   0.857791,   0.857336,    0.856578,    0.85552,    0.854162,   0.852508,
      0.85056,    0.848322,   0.845798,   0.842992,   0.83991,     0.836556,    0.832937,   0.829059,   0.824929,
      0.820554,   0.815941,   0.811099,   0.806035,   0.800758,    0.795276,    0.789599,   0.783735,   0.777694,
      0.771486,   0.765119,   0.758605,   0.751952,   0.74517,     0.738268,    0.731258,   0.724148,   0.716948,
      0.709668,   0.702316,   0.694902,   0.687436,   0.679924,    0.672378,    0.664803,   0.65721,    0.649604,
      0.641993,   0.634385,   0.626785,   0.6192,     0.611637,    0.604099,    0.596592,   0.589121,   0.58169,
      0.574302,   0.56696,    0.559667,   0.552426,   0.545238,    0.538104,    0.531025,   0.524003,   0.517036,
      0.510124,   0.503267,   0.496463,   0.489711,   0.483008,    0.476352,    0.469741,   0.463171,   0.456638,
      0.45014,    0.443672,   0.43723,    0.43081,    0.424407,    0.418016,    0.411632,   0.40525,    0.398865,
      0.392472,   0.386065,   0.379639,   0.373189,   0.36671,     0.360195,    0.353641,   0.347041,   0.340392,
      0.333688,   0.326925,   0.320097,   0.313202,   0.306235,    0.299192,    0.29207,    0.284865,   0.277575,
      0.270198,   0.26273,    0.255171,   0.247518,   0.23977,     0.231927,    0.223987,   0.215952,   0.207821,
      0.199594,   0.191273,   0.182859,   0.174354,   0.16576,     0.157079,    0.148314,   0.139468,   0.130545,
      0.121547,   0.11248,    0.103348,   0.0941541,  0.0849041,   0.0756029,   0.0662555,  0.0568674,  0.047444,
      0.037991,   0.0285142,  0.0190195,  0.00951274, 9.49407e-17, -0.00951274, -0.0190195, -0.0285142, -0.037991,
      -0.047444,  -0.0568674, -0.0662555, -0.0756029, -0.0849041,  -0.0941541,  -0.103348,  -0.11248,   -0.121547,
      -0.130545,  -0.139468,  -0.148314,  -0.157079,  -0.16576,    -0.174354,   -0.182859,  -0.191273,  -0.199594,
      -0.207821,  -0.215952,  -0.223987,  -0.231927,  -0.23977,    -0.247518,   -0.255171,  -0.26273,   -0.270198,
      -0.277575,  -0.284865,  -0.29207,   -0.299192,  -0.306235,   -0.313202,   -0.320097,  -0.326925,  -0.333688,
      -0.340392,  -0.347041,  -0.353641,  -0.360195,  -0.36671,    -0.373189,   -0.379639,  -0.386065,  -0.392472,
      -0.398865,  -0.40525,   -0.411632,  -0.418016,  -0.424407,   -0.43081,    -0.43723,   -0.443672,  -0.45014,
      -0.456638,  -0.463171,  -0.469741,  -0.476352,  -0.483008,   -0.489711,   -0.496463,  -0.503267,  -0.510124,
      -0.517036,  -0.524003,  -0.531025,  -0.538104,  -0.545238,   -0.552426,   -0.559667,  -0.56696,   -0.574302,
      -0.58169,   -0.589121,  -0.596592,  -0.604099,  -0.611637,   -0.6192,     -0.626785,  -0.634385,  -0.641993,
      -0.649604,  -0.65721,   -0.664803,  -0.672378,  -0.679924,   -0.687436,   -0.694902,  -0.702316,  -0.709668,
      -0.716948,  -0.724148,  -0.731258,  -0.738268,  -0.74517,    -0.751952,   -0.758605,  -0.765119,  -0.771486,
      -0.777694,  -0.783735,  -0.789599,  -0.795276,  -0.800758,   -0.806035,   -0.811099,  -0.815941,  -0.820554,
      -0.824929,  -0.829059,  -0.832937,  -0.836556,  -0.83991,    -0.842992,   -0.845798,  -0.848322,  -0.85056,
      -0.852508,  -0.854162,  -0.85552,   -0.856578,  -0.857336,   -0.857791,   -0.857942,  -0.857791,  -0.857336,
      -0.856578,  -0.85552,   -0.854162,  -0.852508,  -0.85056,    -0.848322,   -0.845798,  -0.842992,  -0.83991,
      -0.836556,  -0.832937,  -0.829059,  -0.824929,  -0.820554,   -0.815941,   -0.811099,  -0.806035,  -0.800758,
      -0.795276,  -0.789599,  -0.783735,  -0.777694,  -0.771486,   -0.765119,   -0.758605,  -0.751952,  -0.74517,
      -0.738268,  -0.731258,  -0.724148,  -0.716948,  -0.709668,   -0.702316,   -0.694902,  -0.687436,  -0.679924,
      -0.672378,  -0.664803,  -0.65721,   -0.649604,  -0.641993,   -0.634385,   -0.626785,  -0.6192,    -0.611637,
      -0.604099,  -0.596592,  -0.589121,  -0.58169,   -0.574302,   -0.56696,    -0.559667,  -0.552426,  -0.545238,
      -0.538104,  -0.531025,  -0.524003,  -0.517036,  -0.510124,   -0.503267,   -0.496463,  -0.489711,  -0.483008,
      -0.476352,  -0.469741,  -0.463171,  -0.456638,  -0.45014,    -0.443672,   -0.43723,   -0.43081,   -0.424407,
      -0.418016,  -0.411632,  -0.40525,   -0.398865,  -0.392472,   -0.386065,   -0.379639,  -0.373189,  -0.36671,
      -0.360195,  -0.353641,  -0.347041,  -0.340392,  -0.333688,   -0.326925,   -0.320097,  -0.313202,  -0.306235,
      -0.299192,  -0.29207,   -0.284865,  -0.277575,  -0.270198,   -0.26273,    -0.255171,  -0.247518,  -0.23977,
      -0.231927,  -0.223987,  -0.215952,  -0.207821,  -0.199594,   -0.191273,   -0.182859,  -0.174354,  -0.16576,
      -0.157079,  -0.148314,  -0.139468,  -0.130545,  -0.121547,   -0.11248,    -0.103348,  -0.0941541, -0.0849041,
      -0.0756029, -0.0662555, -0.0568674, -0.047444,  -0.037991,   -0.0285142,  -0.0190195, -0.00951274},
     {0,          0.00761118, 0.0152235, 0.0228381,  0.0304562,   0.0380787,   0.045707,   0.053342,   0.0609848,
      0.0686366,  0.0762982,  0.0839708, 0.0916552,  0.0993525,   0.107063,    0.114789,   0.12253,    0.130287,
      0.138061,   0.145852,   0.153662,  0.16149,    0.169337,    0.177204,    0.185091,   0.192998,   0.200926,
      0.208874,   0.216843,   0.224833,  0.232844,   0.240875,    0.248926,    0.256997,   0.265088,   0.273198,
      0.281327,   0.289474,   0.297638,  0.305819,   0.314016,    0.322227,    0.330451,   0.338688,   0.346937,
      0.355195,   0.363462,   0.371736,  0.380015,   0.388298,    0.396584,    0.404869,   0.413153,   0.421434,
      0.429708,   0.437975,   0.446232,  0.454477,   0.462707,    0.47092,     0.479113,   0.487284,   0.495431,
      0.50355,    0.511638,   0.519694,  0.527714,   0.535695,    0.543634,    0.551528,   0.559375,   0.567171,
      0.574912,   0.582597,   0.590221,  0.597781,   0.605274,    0.612698,    0.620047,   0.62732,    0.634513,
      0.641623,   0.648645,   0.655578,  0.662417,   0.66916,     0.675802,    0.682342,   0.688775,   0.695097,
      0.701307,   0.707401,   0.713375,  0.719226,   0.724952,    0.73055,     0.736015,   0.741346,   0.746539,
      0.751592,   0.756502,   0.761265,  0.76588,    0.770344,    0.774655,    0.778809,   0.782804,   0.786639,
      0.790311,   0.793817,   0.797157,  0.800327,   0.803326,    0.806152,    0.808805,   0.811281,   0.813579,
      0.815699,   0.817639,   0.819398,  0.820974,   0.822367,    0.823576,    0.8246,     0.825439,   0.826092,
      0.826559,   0.826839,   0.826932,  0.826839,   0.826559,    0.826092,    0.825439,   0.8246,     0.823576,
      0.822367,   0.820974,   0.819398,  0.817639,   0.815699,    0.813579,    0.811281,   0.808805,   0.806152,
      0.803326,   0.800327,   0.797157,  0.793817,   0.790311,    0.786639,    0.782804,   0.778809,   0.774655,
      0.770344,   0.76588,    0.761265,  0.756502,   0.751592,    0.746539,    0.741346,   0.736015,   0.73055,
      0.724952,   0.719226,   0.713375,  0.707401,   0.701307,    0.695097,    0.688775,   0.682342,   0.675802,
      0.66916,    0.662417,   0.655578,  0.648645,   0.641623,    0.634513,    0.62732,    0.620047,   0.612698,
      0.605274,   0.597781,   0.590221,  0.582597,   0.574912,    0.567171,    0.559375,   0.551528,   0.543634,
      0.535695,   0.527714,   0.519694,  0.511638,   0.50355,     0.495431,    0.487284,   0.479113,   0.47092,
      0.462707,   0.454477,   0.446232,  0.437975,   0.429708,    0.421434,    0.413153,   0.404869,   0.396584,
      0.388298,   0.380015,   0.371736,  0.363462,   0.355195,    0.346937,    0.338688,   0.330451,   0.322227,
      0.314016,   0.305819,   0.297638,  0.289474,   0.281327,    0.273198,    0.265088,   0.256997,   0.248926,
      0.240875,   0.232844,   0.224833,  0.216843,   0.208874,    0.200926,    0.192998,   0.185091,   0.177204,
      0.169337,   0.16149,    0.153662,  0.145852,   0.138061,    0.130287,    0.12253,    0.114789,   0.107063,
      0.0993525,  0.0916552,  0.0839708, 0.0762982,  0.0686366,   0.0609848,   0.053342,   0.045707,   0.0380787,
      0.0304562,  0.0228381,  0.0152235, 0.00761118, 7.59525e-17, -0.00761118, -0.0152235, -0.0228381, -0.0304562,
      -0.0380787, -0.045707,  -0.053342, -0.0609848, -0.0686366,  -0.0762982,  -0.0839708, -0.0916552, -0.0993525,
      -0.107063,  -0.114789,  -0.12253,  -0.130287,  -0.138061,   -0.145852,   -0.153662,  -0.16149,   -0.169337,
      -0.177204,  -0.185091,  -0.192998, -0.200926,  -0.208874,   -0.216843,   -0.224833,  -0.232844,  -0.240875,
      -0.248926,  -0.256997,  -0.265088, -0.273198,  -0.281327,   -0.289474,   -0.297638,  -0.305819,  -0.314016,
      -0.322227,  -0.330451,  -0.338688, -0.346937,  -0.355195,   -0.363462,   -0.371736,  -0.380015,  -0.388298,
      -0.396584,  -0.404869,  -0.413153, -0.421434,  -0.429708,   -0.437975,   -0.446232,  -0.454477,  -0.462707,
      -0.47092,   -0.479113,  -0.487284, -0.495431,  -0.50355,    -0.511638,   -0.519694,  -0.527714,  -0.535695,
      -0.543634,  -0.551528,  -0.559375, -0.567171,  -0.574912,   -0.582597,   -0.590221,  -0.597781,  -0.605274,
      -0.612698,  -0.620047,  -0.62732,  -0.634513,  -0.641623,   -0.648645,   -0.655578,  -0.662417,  -0.66916,
      -0.675802,  -0.682342,  -0.688775, -0.695097,  -0.701307,   -0.707401,   -0.713375,  -0.719226,  -0.724952,
      -0.73055,   -0.736015,  -0.741346, -0.746539,  -0.751592,   -0.756502,   -0.761265,  -0.76588,   -0.770344,
      -0.774655,  -0.778809,  -0.782804, -0.786639,  -0.790311,   -0.793817,   -0.797157,  -0.800327,  -0.803326,
      -0.806152,  -0.808805,  -0.811281, -0.813579,  -0.815699,   -0.817639,   -0.819398,  -0.820974,  -0.822367,
      -0.823576,  -0.8246,    -0.825439, -0.826092,  -0.826559,   -0.826839,   -0.826932,  -0.826839,  -0.826559,
      -0.826092,  -0.825439,  -0.8246,   -0.823576,  -0.822367,   -0.820974,   -0.819398,  -0.817639,  -0.815699,
      -0.813579,  -0.811281,  -0.808805, -0.806152,  -0.803326,   -0.800327,   -0.797157,  -0.793817,  -0.790311,
      -0.786639,  -0.782804,  -0.778809, -0.774655,  -0.770344,   -0.76588,    -0.761265,  -0.756502,  -0.751592,
      -0.746539,  -0.741346,  -0.736015, -0.73055,   -0.724952,   -0.719226,   -0.713375,  -0.707401,  -0.701307,
      -0.695097,  -0.688775,  -0.682342, -0.675802,  -0.66916,    -0.662417,   -0.655578,  -0.648645,  -0.641623,
      -0.634513,  -0.62732,   -0.620047, -0.612698,  -0.605274,   -0.597781,   -0.590221,  -0.582597,  -0.574912,
      -0.567171,  -0.559375,  -0.551528, -0.543634,  -0.535695,   -0.527714,   -0.519694,  -0.511638,  -0.50355,
      -0.495431,  -0.487284,  -0.479113, -0.47092,   -0.462707,   -0.454477,   -0.446232,  -0.437975,  -0.429708,
      -0.421434,  -0.413153,  -0.404869, -0.396584,  -0.388298,   -0.380015,   -0.371736,  -0.363462,  -0.355195,
      -0.346937,  -0.338688,  -0.330451, -0.322227,  -0.314016,   -0.305819,   -0.297638,  -0.289474,  -0.281327,
      -0.273198,  -0.265088,  -0.256997, -0.248926,  -0.240875,   -0.232844,   -0.224833,  -0.216843,  -0.208874,
      -0.200926,  -0.192998,  -0.185091, -0.177204,  -0.169337,   -0.16149,    -0.153662,  -0.145852,  -0.138061,
      -0.130287,  -0.12253,   -0.114789, -0.107063,  -0.0993525,  -0.0916552,  -0.0839708, -0.0762982, -0.0686366,
      -0.0609848, -0.053342,  -0.045707, -0.0380787, -0.0304562,  -0.0228381,  -0.0152235, -0.00761118},
     {0,          0.00761118, 0.0152235, 0.0228381,  0.0304562,   0.0380787,   0.045707,   0.053342,   0.0609848,
      0.0686366,  0.0762982,  0.0839708, 0.0916552,  0.0993525,   0.107063,    0.114789,   0.12253,    0.130287,
      0.138061,   0.145852,   0.153662,  0.16149,    0.169337,    0.177204,    0.185091,   0.192998,   0.200926,
      0.208874,   0.216843,   0.224833,  0.232844,   0.240875,    0.248926,    0.256997,   0.265088,   0.273198,
      0.281327,   0.289474,   0.297638,  0.305819,   0.314016,    0.322227,    0.330451,   0.338688,   0.346937,
      0.355195,   0.363462,   0.371736,  0.380015,   0.388298,    0.396584,    0.404869,   0.413153,   0.421434,
      0.429708,   0.437975,   0.446232,  0.454477,   0.462707,    0.47092,     0.479113,   0.487284,   0.495431,
      0.50355,    0.511638,   0.519694,  0.527714,   0.535695,    0.543634,    0.551528,   0.559375,   0.567171,
      0.574912,   0.582597,   0.590221,  0.597781,   0.605274,    0.612698,    0.620047,   0.62732,    0.634513,
      0.641623,   0.648645,   0.655578,  0.662417,   0.66916,     0.675802,    0.682342,   0.688775,   0.695097,
      0.701307,   0.707401,   0.713375,  0.719226,   0.724952,    0.73055,     0.736015,   0.741346,   0.746539,
      0.751592,   0.756502,   0.761265,  0.76588,    0.770344,    0.774655,    0.778809,   0.782804,   0.786639,
      0.790311,   0.793817,   0.797157,  0.800327,   0.803326,    0.806152,    0.808805,   0.811281,   0.813579,
      0.815699,   0.817639,   0.819398,  0.820974,   0.822367,    0.823576,    0.8246,     0.825439,   0.826092,
      0.826559,   0.826839,   0.826932,  0.826839,   0.826559,    0.826092,    0.825439,   0.8246,     0.823576,
      0.822367,   0.820974,   0.819398,  0.817639,   0.815699,    0.813579,    0.811281,   0.808805,   0.806152,
      0.803326,   0.800327,   0.797157,  0.793817,   0.790311,    0.786639,    0.782804,   0.778809,   0.774655,
      0.770344,   0.76588,    0.761265,  0.756502,   0.751592,    0.746539,    0.741346,   0.736015,   0.73055,
      0.724952,   0.719226,   0.713375,  0.707401,   0.701307,    0.695097,    0.688775,   0.682342,   0.675802,
      0.66916,    0.662417,   0.655578,  0.648645,   0.641623,    0.634513,    0.62732,    0.620047,   0.612698,
      0.605274,   0.597781,   0.590221,  0.582597,   0.574912,    0.567171,    0.559375,   0.551528,   0.543634,
      0.535695,   0.527714,   0.519694,  0.511638,   0.50355,     0.495431,    0.487284,   0.479113,   0.47092,
      0.462707,   0.454477,   0.446232,  0.437975,   0.429708,    0.421434,    0.413153,   0.404869,   0.396584,
      0.388298,   0.380015,   0.371736,  0.363462,   0.355195,    0.346937,    0.338688,   0.330451,   0.322227,
      0.314016,   0.305819,   0.297638,  0.289474,   0.281327,    0.273198,    0.265088,   0.256997,   0.248926,
      0.240875,   0.232844,   0.224833,  0.216843,   0.208874,    0.200926,    0.192998,   0.185091,   0.177204,
      0.169337,   0.16149,    0.153662,  0.145852,   0.138061,    0.130287,    0.12253,    0.114789,   0.107063,
      0.0993525,  0.0916552,  0.0839708, 0.0762982,  0.0686366,   0.0609848,   0.053342,   0.045707,   0.0380787,
      0.0304562,  0.0228381,  0.0152235, 0.00761118, 7.59525e-17, -0.00761118, -0.0152235, -0.0228381, -0.0304562,
      -0.0380787, -0.045707,  -0.053342, -0.0609848, -0.0686366,  -0.0762982,  -0.0839708, -0.0916552, -0.0993525,
      -0.107063,  -0.114789,  -0.12253,  -0.130287,  -0.138061,   -0.145852,   -0.153662,  -0.16149,   -0.169337,
      -0.177204,  -0.185091,  -0.192998, -0.200926,  -0.208874,   -0.216843,   -0.224833,  -0.232844,  -0.240875,
      -0.248926,  -0.256997,  -0.265088, -0.273198,  -0.281327,   -0.289474,   -0.297638,  -0.305819,  -0.314016,
      -0.322227,  -0.330451,  -0.338688, -0.346937,  -0.355195,   -0.363462,   -0.371736,  -0.380015,  -0.388298,
      -0.396584,  -0.404869,  -0.413153, -0.421434,  -0.429708,   -0.437975,   -0.446232,  -0.454477,  -0.462707,
      -0.47092,   -0.479113,  -0.487284, -0.495431,  -0.50355,    -0.511638,   -0.519694,  -0.527714,  -0.535695,
      -0.543634,  -0.551528,  -0.559375, -0.567171,  -0.574912,   -0.582597,   -0.590221,  -0.597781,  -0.605274,
      -0.612698,  -0.620047,  -0.62732,  -0.634513,  -0.641623,   -0.648645,   -0.655578,  -0.662417,  -0.66916,
      -0.675802,  -0.682342,  -0.688775, -0.695097,  -0.701307,   -0.707401,   -0.713375,  -0.719226,  -0.724952,
      -0.73055,   -0.736015,  -0.741346, -0.746539,  -0.751592,   -0.756502,   -0.761265,  -0.76588,   -0.770344,
      -0.774655,  -0.778809,  -0.782804, -0.786639,  -0.790311,   -0.793817,   -0.797157,  -0.800327,  -0.803326,
      -0.806152,  -0.808805,  -0.811281, -0.813579,  -0.815699,   -0.817639,   -0.819398,  -0.820974,  -0.822367,
      -0.823576,  -0.8246,    -0.825439, -0.826092,  -0.826559,   -0.826839,   -0.826932,  -0.826839,  -0.826559,
      -0.826092,  -0.825439,  -0.8246,   -0.823576,  -0.822367,   -0.820974,   -0.819398,  -0.817639,  -0.815699,
      -0.813579,  -0.811281,  -0.808805, -0.806152,  -0.803326,   -0.800327,   -0.797157,  -0.793817,  -0.790311,
      -0.786639,  -0.782804,  -0.778809, -0.774655,  -0.770344,   -0.76588,    -0.761265,  -0.756502,  -0.751592,
      -0.746539,  -0.741346,  -0.736015, -0.73055,   -0.724952,   -0.719226,   -0.713375,  -0.707401,  -0.701307,
      -0.695097,  -0.688775,  -0.682342, -0.675802,  -0.66916,    -0.662417,   -0.655578,  -0.648645,  -0.641623,
      -0.634513,  -0.62732,   -0.620047, -0.612698,  -0.605274,   -0.597781,   -0.590221,  -0.582597,  -0.574912,
      -0.567171,  -0.559375,  -0.551528, -0.543634,  -0.535695,   -0.527714,   -0.519694,  -0.511638,  -0.50355,
      -0.495431,  -0.487284,  -0.479113, -0.47092,   -0.462707,   -0.454477,   -0.446232,  -0.437975,  -0.429708,
      -0.421434,  -0.413153,  -0.404869, -0.396584,  -0.388298,   -0.380015,   -0.371736,  -0.363462,  -0.355195,
      -0.346937,  -0.338688,  -0.330451, -0.322227,  -0.314016,   -0.305819,   -0.297638,  -0.289474,  -0.281327,
      -0.273198,  -0.265088,  -0.256997, -0.248926,  -0.240875,   -0.232844,   -0.224833,  -0.216843,  -0.208874,
      -0.200926,  -0.192998,  -0.185091, -0.177204,  -0.169337,   -0.16149,    -0.153662,  -0.145852,  -0.138061,
      -0.130287,  -0.12253,   -0.114789, -0.107063,  -0.0993525,  -0.0916552,  -0.0839708, -0.0762982, -0.0686366,
      -0.0609848, -0.053342,  -0.045707, -0.0380787, -0.0304562,  -0.0228381,  -0.0152235, -0.00761118},
     {0,          0.0095135,  0.0190256,  0.0285348,  0.0380397,   0.0475388,  0.0570309,  0.0665143,  0.0759877,
      0.0854497,  0.0948988,  0.104334,   0.113753,   0.123155,    0.132538,   0.141902,   0.151244,   0.160563,
      0.169858,   0.179128,   0.18837,    0.197584,   0.206769,    0.215922,   0.225043,   0.23413,    0.243181,
      0.252197,   0.261174,   0.270111,   0.279008,   0.287863,    0.296675,   0.305442,   0.314163,   0.322837,
      0.331462,   0.340037,   0.348561,   0.357032,   0.36545,     0.373813,   0.382119,   0.390368,   0.398558,
      0.406688,   0.414756,   0.422763,   0.430705,   0.438583,    0.446395,   0.454139,   0.461815,   0.469422,
      0.476958,   0.484422,   0.491813,   0.49913,    0.506372,    0.513537,   0.520625,   0.527635,   0.534566,
      0.541416,   0.548184,   0.55487,    0.561472,   0.56799,     0.574422,   0.580767,   0.587025,   0.593195,
      0.599276,   0.605266,   0.611165,   0.616972,   0.622686,    0.628306,   0.633832,   0.639262,   0.644596,
      0.649833,   0.654972,   0.660012,   0.664953,   0.669794,    0.674534,   0.679173,   0.683709,   0.688142,
      0.692471,   0.696697,   0.700817,   0.704832,   0.70874,     0.712542,   0.716237,   0.719823,   0.723302,
      0.726671,   0.729931,   0.733081,   0.736121,   0.73905,     0.741867,   0.744573,   0.747167,   0.749648,
      0.752016,   0.754271,   0.756412,   0.75844,    0.760353,    0.762152,   0.763836,   0.765405,   0.766858,
      0.768196,   0.769419,   0.770526,   0.771516,   0.77239,     0.773149,   0.77379,    0.774315,   0.774724,
      0.775016,   0.775191,   0.775249,   0.775191,   0.775016,    0.774724,   0.774315,   0.77379,    0.773149,
      0.77239,    0.771516,   0.770526,   0.769419,   0.768196,    0.766858,   0.765405,   0.763836,   0.762152,
      0.760353,   0.75844,    0.756412,   0.754271,   0.752016,    0.749648,   0.747167,   0.744573,   0.741867,
      0.73905,    0.736121,   0.733081,   0.729931,   0.726671,    0.723302,   0.719823,   0.716237,   0.712542,
      0.70874,    0.704832,   0.700817,   0.696697,   0.692471,    0.688142,   0.683709,   0.679173,   0.674534,
      0.669794,   0.664953,   0.660012,   0.654972,   0.649833,    0.644596,   0.639262,   0.633832,   0.628306,
      0.622686,   0.616972,   0.611165,   0.605266,   0.599276,    0.593195,   0.587025,   0.580767,   0.574422,
      0.56799,    0.561472,   0.55487,    0.548184,   0.541416,    0.534566,   0.527635,   0.520625,   0.513537,
      0.506372,   0.49913,    0.491813,   0.484422,   0.476958,    0.469422,   0.461815,   0.454139,   0.446395,
      0.438583,   0.430705,   0.422763,   0.414756,   0.406688,    0.398558,   0.390368,   0.382119,   0.373813,
      0.36545,    0.357032,   0.348561,   0.340037,   0.331462,    0.322837,   0.314163,   0.305442,   0.296675,
      0.287863,   0.279008,   0.270111,   0.261174,   0.252197,    0.243181,   0.23413,    0.225043,   0.215922,
      0.206769,   0.197584,   0.18837,    0.179128,   0.169858,    0.160563,   0.151244,   0.141902,   0.132538,
      0.123155,   0.113753,   0.104334,   0.0948988,  0.0854497,   0.0759877,  0.0665143,  0.0570309,  0.0475388,
      0.0380397,  0.0285348,  0.0190256,  0.0095135,  9.49406e-17, -0.0095135, -0.0190256, -0.0285348, -0.0380397,
      -0.0475388, -0.0570309, -0.0665143, -0.0759877, -0.0854497,  -0.0948988, -0.104334,  -0.113753,  -0.123155,
      -0.132538,  -0.141902,  -0.151244,  -0.160563,  -0.169858,   -0.179128,  -0.18837,   -0.197584,  -0.206769,
      -0.215922,  -0.225043,  -0.23413,   -0.243181,  -0.252197,   -0.261174,  -0.270111,  -0.279008,  -0.287863,
      -0.296675,  -0.305442,  -0.314163,  -0.322837,  -0.331462,   -0.340037,  -0.348561,  -0.357032,  -0.36545,
      -0.373813,  -0.382119,  -0.390368,  -0.398558,  -0.406688,   -0.414756,  -0.422763,  -0.430705,  -0.438583,
      -0.446395,  -0.454139,  -0.461815,  -0.469422,  -0.476958,   -0.484422,  -0.491813,  -0.49913,   -0.506372,
      -0.513537,  -0.520625,  -0.527635,  -0.534566,  -0.541416,   -0.548184,  -0.55487,   -0.561472,  -0.56799,
      -0.574422,  -0.580767,  -0.587025,  -0.593195,  -0.599276,   -0.605266,  -0.611165,  -0.616972,  -0.622686,
      -0.628306,  -0.633832,  -0.639262,  -0.644596,  -0.649833,   -0.654972,  -0.660012,  -0.664953,  -0.669794,
      -0.674534,  -0.679173,  -0.683709,  -0.688142,  -0.692471,   -0.696697,  -0.700817,  -0.704832,  -0.70874,
      -0.712542,  -0.716237,  -0.719823,  -0.723302,  -0.726671,   -0.729931,  -0.733081,  -0.736121,  -0.73905,
      -0.741867,  -0.744573,  -0.747167,  -0.749648,  -0.752016,   -0.754271,  -0.756412,  -0.75844,   -0.760353,
      -0.762152,  -0.763836,  -0.765405,  -0.766858,  -0.768196,   -0.769419,  -0.770526,  -0.771516,  -0.77239,
      -0.773149,  -0.77379,   -0.774315,  -0.774724,  -0.775016,   -0.775191,  -0.775249,  -0.775191,  -0.775016,
      -0.774724,  -0.774315,  -0.77379,   -0.773149,  -0.77239,    -0.771516,  -0.770526,  -0.769419,  -0.768196,
      -0.766858,  -0.765405,  -0.763836,  -0.762152,  -0.760353,   -0.75844,   -0.756412,  -0.754271,  -0.752016,
      -0.749648,  -0.747167,  -0.744573,  -0.741867,  -0.73905,    -0.736121,  -0.733081,  -0.729931,  -0.726671,
      -0.723302,  -0.719823,  -0.716237,  -0.712542,  -0.70874,    -0.704832,  -0.700817,  -0.696697,  -0.692471,
      -0.688142,  -0.683709,  -0.679173,  -0.674534,  -0.669794,   -0.664953,  -0.660012,  -0.654972,  -0.649833,
      -0.644596,  -0.639262,  -0.633832,  -0.628306,  -0.622686,   -0.616972,  -0.611165,  -0.605266,  -0.599276,
      -0.593195,  -0.587025,  -0.580767,  -0.574422,  -0.56799,    -0.561472,  -0.55487,   -0.548184,  -0.541416,
      -0.534566,  -0.527635,  -0.520625,  -0.513537,  -0.506372,   -0.49913,   -0.491813,  -0.484422,  -0.476958,
      -0.469422,  -0.461815,  -0.454139,  -0.446395,  -0.438583,   -0.430705,  -0.422763,  -0.414756,  -0.406688,
      -0.398558,  -0.390368,  -0.382119,  -0.373813,  -0.36545,    -0.357032,  -0.348561,  -0.340037,  -0.331462,
      -0.322837,  -0.314163,  -0.305442,  -0.296675,  -0.287863,   -0.279008,  -0.270111,  -0.261174,  -0.252197,
      -0.243181,  -0.23413,   -0.225043,  -0.215922,  -0.206769,   -0.197584,  -0.18837,   -0.179128,  -0.169858,
      -0.160563,  -0.151244,  -0.141902,  -0.132538,  -0.123155,   -0.113753,  -0.104334,  -0.0948988, -0.0854497,
      -0.0759877, -0.0665143, -0.0570309, -0.0475388, -0.0380397,  -0.0285348, -0.0190256, -0.0095135},
     {0,          0.0095135,  0.0190256,  0.0285348,  0.0380397,   0.0475388,  0.0570309,  0.0665143,  0.0759877,
      0.0854497,  0.0948988,  0.104334,   0.113753,   0.123155,    0.132538,   0.141902,   0.151244,   0.160563,
      0.169858,   0.179128,   0.18837,    0.197584,   0.206769,    0.215922,   0.225043,   0.23413,    0.243181,
      0.252197,   0.261174,   0.270111,   0.279008,   0.287863,    0.296675,   0.305442,   0.314163,   0.322837,
      0.331462,   0.340037,   0.348561,   0.357032,   0.36545,     0.373813,   0.382119,   0.390368,   0.398558,
      0.406688,   0.414756,   0.422763,   0.430705,   0.438583,    0.446395,   0.454139,   0.461815,   0.469422,
      0.476958,   0.484422,   0.491813,   0.49913,    0.506372,    0.513537,   0.520625,   0.527635,   0.534566,
      0.541416,   0.548184,   0.55487,    0.561472,   0.56799,     0.574422,   0.580767,   0.587025,   0.593195,
      0.599276,   0.605266,   0.611165,   0.616972,   0.622686,    0.628306,   0.633832,   0.639262,   0.644596,
      0.649833,   0.654972,   0.660012,   0.664953,   0.669794,    0.674534,   0.679173,   0.683709,   0.688142,
      0.692471,   0.696697,   0.700817,   0.704832,   0.70874,     0.712542,   0.716237,   0.719823,   0.723302,
      0.726671,   0.729931,   0.733081,   0.736121,   0.73905,     0.741867,   0.744573,   0.747167,   0.749648,
      0.752016,   0.754271,   0.756412,   0.75844,    0.760353,    0.762152,   0.763836,   0.765405,   0.766858,
      0.768196,   0.769419,   0.770526,   0.771516,   0.77239,     0.773149,   0.77379,    0.774315,   0.774724,
      0.775016,   0.775191,   0.775249,   0.775191,   0.775016,    0.774724,   0.774315,   0.77379,    0.773149,
      0.77239,    0.771516,   0.770526,   0.769419,   0.768196,    0.766858,   0.765405,   0.763836,   0.762152,
      0.760353,   0.75844,    0.756412,   0.754271,   0.752016,    0.749648,   0.747167,   0.744573,   0.741867,
      0.73905,    0.736121,   0.733081,   0.729931,   0.726671,    0.723302,   0.719823,   0.716237,   0.712542,
      0.70874,    0.704832,   0.700817,   0.696697,   0.692471,    0.688142,   0.683709,   0.679173,   0.674534,
      0.669794,   0.664953,   0.660012,   0.654972,   0.649833,    0.644596,   0.639262,   0.633832,   0.628306,
      0.622686,   0.616972,   0.611165,   0.605266,   0.599276,    0.593195,   0.587025,   0.580767,   0.574422,
      0.56799,    0.561472,   0.55487,    0.548184,   0.541416,    0.534566,   0.527635,   0.520625,   0.513537,
      0.506372,   0.49913,    0.491813,   0.484422,   0.476958,    0.469422,   0.461815,   0.454139,   0.446395,
      0.438583,   0.430705,   0.422763,   0.414756,   0.406688,    0.398558,   0.390368,   0.382119,   0.373813,
      0.36545,    0.357032,   0.348561,   0.340037,   0.331462,    0.322837,   0.314163,   0.305442,   0.296675,
      0.287863,   0.279008,   0.270111,   0.261174,   0.252197,    0.243181,   0.23413,    0.225043,   0.215922,
      0.206769,   0.197584,   0.18837,    0.179128,   0.169858,    0.160563,   0.151244,   0.141902,   0.132538,
      0.123155,   0.113753,   0.104334,   0.0948988,  0.0854497,   0.0759877,  0.0665143,  0.0570309,  0.0475388,
      0.0380397,  0.0285348,  0.0190256,  0.0095135,  9.49406e-17, -0.0095135, -0.0190256, -0.0285348, -0.0380397,
      -0.0475388, -0.0570309, -0.0665143, -0.0759877, -0.0854497,  -0.0948988, -0.104334,  -0.113753,  -0.123155,
      -0.132538,  -0.141902,  -0.151244,  -0.160563,  -0.169858,   -0.179128,  -0.18837,   -0.197584,  -0.206769,
      -0.215922,  -0.225043,  -0.23413,   -0.243181,  -0.252197,   -0.261174,  -0.270111,  -0.279008,  -0.287863,
      -0.296675,  -0.305442,  -0.314163,  -0.322837,  -0.331462,   -0.340037,  -0.348561,  -0.357032,  -0.36545,
      -0.373813,  -0.382119,  -0.390368,  -0.398558,  -0.406688,   -0.414756,  -0.422763,  -0.430705,  -0.438583,
      -0.446395,  -0.454139,  -0.461815,  -0.469422,  -0.476958,   -0.484422,  -0.491813,  -0.49913,   -0.506372,
      -0.513537,  -0.520625,  -0.527635,  -0.534566,  -0.541416,   -0.548184,  -0.55487,   -0.561472,  -0.56799,
      -0.574422,  -0.580767,  -0.587025,  -0.593195,  -0.599276,   -0.605266,  -0.611165,  -0.616972,  -0.622686,
      -0.628306,  -0.633832,  -0.639262,  -0.644596,  -0.649833,   -0.654972,  -0.660012,  -0.664953,  -0.669794,
      -0.674534,  -0.679173,  -0.683709,  -0.688142,  -0.692471,   -0.696697,  -0.700817,  -0.704832,  -0.70874,
      -0.712542,  -0.716237,  -0.719823,  -0.723302,  -0.726671,   -0.729931,  -0.733081,  -0.736121,  -0.73905,
      -0.741867,  -0.744573,  -0.747167,  -0.749648,  -0.752016,   -0.754271,  -0.756412,  -0.75844,   -0.760353,
      -0.762152,  -0.763836,  -0.765405,  -0.766858,  -0.768196,   -0.769419,  -0.770526,  -0.771516,  -0.77239,
      -0.773149,  -0.77379,   -0.774315,  -0.774724,  -0.775016,   -0.775191,  -0.775249,  -0.775191,  -0.775016,
      -0.774724,  -0.774315,  -0.77379,   -0.773149,  -0.77239,    -0.771516,  -0.770526,  -0.769419,  -0.768196,
      -0.766858,  -0.765405,  -0.763836,  -0.762152,  -0.760353,   -0.75844,   -0.756412,  -0.754271,  -0.752016,
      -0.749648,  -0.747167,  -0.744573,  -0.741867,  -0.73905,    -0.736121,  -0.733081,  -0.729931,  -0.726671,
      -0.723302,  -0.719823,  -0.716237,  -0.712542,  -0.70874,    -0.704832,  -0.700817,  -0.696697,  -0.692471,
      -0.688142,  -0.683709,  -0.679173,  -0.674534,  -0.669794,   -0.664953,  -0.660012,  -0.654972,  -0.649833,
      -0.644596,  -0.639262,  -0.633832,  -0.628306,  -0.622686,   -0.616972,  -0.611165,  -0.605266,  -0.599276,
      -0.593195,  -0.587025,  -0.580767,  -0.574422,  -0.56799,    -0.561472,  -0.55487,   -0.548184,  -0.541416,
      -0.534566,  -0.527635,  -0.520625,  -0.513537,  -0.506372,   -0.49913,   -0.491813,  -0.484422,  -0.476958,
      -0.469422,  -0.461815,  -0.454139,  -0.446395,  -0.438583,   -0.430705,  -0.422763,  -0.414756,  -0.406688,
      -0.398558,  -0.390368,  -0.382119,  -0.373813,  -0.36545,    -0.357032,  -0.348561,  -0.340037,  -0.331462,
      -0.322837,  -0.314163,  -0.305442,  -0.296675,  -0.287863,   -0.279008,  -0.270111,  -0.261174,  -0.252197,
      -0.243181,  -0.23413,   -0.225043,  -0.215922,  -0.206769,   -0.197584,  -0.18837,   -0.179128,  -0.169858,
      -0.160563,  -0.151244,  -0.141902,  -0.132538,  -0.123155,   -0.113753,  -0.104334,  -0.0948988, -0.0854497,
      -0.0759877, -0.0665143, -0.0570309, -0.0475388, -0.0380397,  -0.0285348, -0.0190256, -0.0095135},
     {0,          0.0095135,  0.0190256,  0.0285348,  0.0380397,   0.0475388,  0.0570309,  0.0665143,  0.0759877,
      0.0854497,  0.0948988,  0.104334,   0.113753,   0.123155,    0.132538,   0.141902,   0.151244,   0.160563,
      0.169858,   0.179128,   0.18837,    0.197584,   0.206769,    0.215922,   0.225043,   0.23413,    0.243181,
      0.252197,   0.261174,   0.270111,   0.279008,   0.287863,    0.296675,   0.305442,   0.314163,   0.322837,
      0.331462,   0.340037,   0.348561,   0.357032,   0.36545,     0.373813,   0.382119,   0.390368,   0.398558,
      0.406688,   0.414756,   0.422763,   0.430705,   0.438583,    0.446395,   0.454139,   0.461815,   0.469422,
      0.476958,   0.484422,   0.491813,   0.49913,    0.506372,    0.513537,   0.520625,   0.527635,   0.534566,
      0.541416,   0.548184,   0.55487,    0.561472,   0.56799,     0.574422,   0.580767,   0.587025,   0.593195,
      0.599276,   0.605266,   0.611165,   0.616972,   0.622686,    0.628306,   0.633832,   0.639262,   0.644596,
      0.649833,   0.654972,   0.660012,   0.664953,   0.669794,    0.674534,   0.679173,   0.683709,   0.688142,
      0.692471,   0.696697,   0.700817,   0.704832,   0.70874,     0.712542,   0.716237,   0.719823,   0.723302,
      0.726671,   0.729931,   0.733081,   0.736121,   0.73905,     0.741867,   0.744573,   0.747167,   0.749648,
      0.752016,   0.754271,   0.756412,   0.75844,    0.760353,    0.762152,   0.763836,   0.765405,   0.766858,
      0.768196,   0.769419,   0.770526,   0.771516,   0.77239,     0.773149,   0.77379,    0.774315,   0.774724,
      0.775016,   0.775191,   0.775249,   0.775191,   0.775016,    0.774724,   0.774315,   0.77379,    0.773149,
      0.77239,    0.771516,   0.770526,   0.769419,   0.768196,    0.766858,   0.765405,   0.763836,   0.762152,
      0.760353,   0.75844,    0.756412,   0.754271,   0.752016,    0.749648,   0.747167,   0.744573,   0.741867,
      0.73905,    0.736121,   0.733081,   0.729931,   0.726671,    0.723302,   0.719823,   0.716237,   0.712542,
      0.70874,    0.704832,   0.700817,   0.696697,   0.692471,    0.688142,   0.683709,   0.679173,   0.674534,
      0.669794,   0.664953,   0.660012,   0.654972,   0.649833,    0.644596,   0.639262,   0.633832,   0.628306,
      0.622686,   0.616972,   0.611165,   0.605266,   0.599276,    0.593195,   0.587025,   0.580767,   0.574422,
      0.56799,    0.561472,   0.55487,    0.548184,   0.541416,    0.534566,   0.527635,   0.520625,   0.513537,
      0.506372,   0.49913,    0.491813,   0.484422,   0.476958,    0.469422,   0.461815,   0.454139,   0.446395,
      0.438583,   0.430705,   0.422763,   0.414756,   0.406688,    0.398558,   0.390368,   0.382119,   0.373813,
      0.36545,    0.357032,   0.348561,   0.340037,   0.331462,    0.322837,   0.314163,   0.305442,   0.296675,
      0.287863,   0.279008,   0.270111,   0.261174,   0.252197,    0.243181,   0.23413,    0.225043,   0.215922,
      0.206769,   0.197584,   0.18837,    0.179128,   0.169858,    0.160563,   0.151244,   0.141902,   0.132538,
      0.123155,   0.113753,   0.104334,   0.0948988,  0.0854497,   0.0759877,  0.0665143,  0.0570309,  0.0475388,
      0.0380397,  0.0285348,  0.0190256,  0.0095135,  9.49406e-17, -0.0095135, -0.0190256, -0.0285348, -0.0380397,
      -0.0475388, -0.0570309, -0.0665143, -0.0759877, -0.0854497,  -0.0948988, -0.104334,  -0.113753,  -0.123155,
      -0.132538,  -0.141902,  -0.151244,  -0.160563,  -0.169858,   -0.179128,  -0.18837,   -0.197584,  -0.206769,
      -0.215922,  -0.225043,  -0.23413,   -0.243181,  -0.252197,   -0.261174,  -0.270111,  -0.279008,  -0.287863,
      -0.296675,  -0.305442,  -0.314163,  -0.322837,  -0.331462,   -0.340037,  -0.348561,  -0.357032,  -0.36545,
      -0.373813,  -0.382119,  -0.390368,  -0.398558,  -0.406688,   -0.414756,  -0.422763,  -0.430705,  -0.438583,
      -0.446395,  -0.454139,  -0.461815,  -0.469422,  -0.476958,   -0.484422,  -0.491813,  -0.49913,   -0.506372,
      -0.513537,  -0.520625,  -0.527635,  -0.534566,  -0.541416,   -0.548184,  -0.55487,   -0.561472,  -0.56799,
      -0.574422,  -0.580767,  -0.587025,  -0.593195,  -0.599276,   -0.605266,  -0.611165,  -0.616972,  -0.622686,
      -0.628306,  -0.633832,  -0.639262,  -0.644596,  -0.649833,   -0.654972,  -0.660012,  -0.664953,  -0.669794,
      -0.674534,  -0.679173,  -0.683709,  -0.688142,  -0.692471,   -0.696697,  -0.700817,  -0.704832,  -0.70874,
      -0.712542,  -0.716237,  -0.719823,  -0.723302,  -0.726671,   -0.729931,  -0.733081,  -0.736121,  -0.73905,
      -0.741867,  -0.744573,  -0.747167,  -0.749648,  -0.752016,   -0.754271,  -0.756412,  -0.75844,   -0.760353,
      -0.762152,  -0.763836,  -0.765405,  -0.766858,  -0.768196,   -0.769419,  -0.770526,  -0.771516,  -0.77239,
      -0.773149,  -0.77379,   -0.774315,  -0.774724,  -0.775016,   -0.775191,  -0.775249,  -0.775191,  -0.775016,
      -0.774724,  -0.774315,  -0.77379,   -0.773149,  -0.77239,    -0.771516,  -0.770526,  -0.769419,  -0.768196,
      -0.766858,  -0.765405,  -0.763836,  -0.762152,  -0.760353,   -0.75844,   -0.756412,  -0.754271,  -0.752016,
      -0.749648,  -0.747167,  -0.744573,  -0.741867,  -0.73905,    -0.736121,  -0.733081,  -0.729931,  -0.726671,
      -0.723302,  -0.719823,  -0.716237,  -0.712542,  -0.70874,    -0.704832,  -0.700817,  -0.696697,  -0.692471,
      -0.688142,  -0.683709,  -0.679173,  -0.674534,  -0.669794,   -0.664953,  -0.660012,  -0.654972,  -0.649833,
      -0.644596,  -0.639262,  -0.633832,  -0.628306,  -0.622686,   -0.616972,  -0.611165,  -0.605266,  -0.599276,
      -0.593195,  -0.587025,  -0.580767,  -0.574422,  -0.56799,    -0.561472,  -0.55487,   -0.548184,  -0.541416,
      -0.534566,  -0.527635,  -0.520625,  -0.513537,  -0.506372,   -0.49913,   -0.491813,  -0.484422,  -0.476958,
      -0.469422,  -0.461815,  -0.454139,  -0.446395,  -0.438583,   -0.430705,  -0.422763,  -0.414756,  -0.406688,
      -0.398558,  -0.390368,  -0.382119,  -0.373813,  -0.36545,    -0.357032,  -0.348561,  -0.340037,  -0.331462,
      -0.322837,  -0.314163,  -0.305442,  -0.296675,  -0.287863,   -0.279008,  -0.270111,  -0.261174,  -0.252197,
      -0.243181,  -0.23413,   -0.225043,  -0.215922,  -0.206769,   -0.197584,  -0.18837,   -0.179128,  -0.169858,
      -0.160563,  -0.151244,  -0.141902,  -0.132538,  -0.123155,   -0.113753,  -0.104334,  -0.0948988, -0.0854497,
      -0.0759877, -0.0665143, -0.0570309, -0.0475388, -0.0380397,  -0.0285348, -0.0190256, -0.0095135}},
    {{0,         0.925972,  0.709068,  0.837393,  0.746064,  0.817002,  0.758993,    0.80807,   0.765533,  0.803074,
      0.769474,  0.799886,  0.772105,  0.797678,  0.773985,  0.796059,  0.775394,    0.794822,  0.776489,  0.793846,
      0.777363,  0.793058,  0.778078,  0.792407,  0.778672,  0.791863,  0.779173,    0.7914,    0.779601,  0.791002,
      0.779972,  0.790657,  0.780295,  0.790354,  0.780579,  0.790087,  0.78083,     0.78985,   0.781054,  0.789638,
      0.781254,  0.789448,  0.781436,  0.789276,  0.781599,  0.78912,   0.781747,    0.788979,  0.781882,  0.78885,
      0.782006,  0.788731,  0.782119,  0.788622,  0.782222,  0.788523,  0.782318,    0.788431,  0.782407,  0.788345,
      0.782489,  0.788267,  0.782565,  0.788194,  0.782635,  0.788126,  0.782701,    0.788063,  0.782762,  0.788005,
      0.782818,  0.78795,   0.782871,  0.787899,  0.78292,   0.787852,  0.782966,    0.787808,  0.783009,  0.787767,
      0.783049,  0.787728,  0.783086,  0.787692,  0.783121,  0.787658,  0.783153,    0.787627,  0.783184,  0.787599,
      0.783212,  0.787572,  0.783238,  0.787547,  0.783263,  0.787523,  0.783284,    0.787502,  0.783305,  0.787483,
      0.783324,  0.787464,  0.783342,  0.787448,  0.783358,  0.787432,  0.783373,    0.787419,  0.783386,  0.787406,
      0.783397,  0.787395,  0.783407,  0.787386,  0.783417,  0.787377,  0.783425,    0.78737,   0.783431,  0.787364,
      0.783436,  0.787359,  0.78344,   0.787356,  0.783443,  0.787354,  0.783445,    0.787352,  0.783446,  0.787352,
      0.783445,  0.787354,  0.783443,  0.787356,  0.78344,   0.787359,  0.783436,    0.787364,  0.783431,  0.78737,
      0.783425,  0.787377,  0.783417,  0.787386,  0.783407,  0.787395,  0.783397,    0.787406,  0.783386,  0.787419,
      0.783373,  0.787432,  0.783358,  0.787448,  0.783342,  0.787464,  0.783324,    0.787483,  0.783305,  0.787502,
      0.783284,  0.787523,  0.783263,  0.787547,  0.783238,  0.787572,  0.783212,    0.787599,  0.783184,  0.787627,
      0.783153,  0.787658,  0.783121,  0.787692,  0.783086,  0.787728,  0.783049,    0.787767,  0.783009,  0.787808,
      0.782966,  0.787852,  0.78292,   0.787899,  0.782871,  0.78795,   0.782818,    0.788005,  0.782762,  0.788063,
      0.782701,  0.788126,  0.782635,  0.788194,  0.782565,  0.788267,  0.782489,    0.788345,  0.782407,  0.788431,
      0.782318,  0.788523,  0.782222,  0.788622,  0.782119,  0.788731,  0.782006,    0.78885,   0.781882,  0.788979,
      0.781747,  0.78912,   0.781599,  0.789276,  0.781436,  0.789448,  0.781254,    0.789638,  0.781054,  0.78985,
      0.78083,   0.790087,  0.780579,  0.790354,  0.780295,  0.790657,  0.779972,    0.791002,  0.779601,  0.7914,
      0.779173,  0.791863,  0.778672,  0.792407,  0.778078,  0.793058,  0.777363,    0.793846,  0.776489,  0.794822,
      0.775394,  0.796059,  0.773985,  0.797678,  0.772105,  0.799886,  0.769474,    0.803074,  0.765533,  0.80807,
      0.758993,  0.817002,  0.746064,  0.837393,  0.709068,  0.925972,  1.60939e-14, -0.925972, -0.709068, -0.837393,
      -0.746064, -0.817002, -0.758993, -0.80807,  -0.765533, -0.803074, -0.769474,   -0.799886, -0.772105, -0.797678,
      -0.773985, -0.796059, -0.775394, -0.794822, -0.776489, -0.793846, -0.777363,   -0.793058, -0.778078, -0.792407,
      -0.778672, -0.791863, -0.779173, -0.7914,   -0.779601, -0.791002, -0.779972,   -0.790657, -0.780295, -0.790354,
      -0.780579, -0.790087, -0.78083,  -0.78985,  -0.781054, -0.789638, -0.781254,   -0.789448, -0.781436, -0.789276,
      -0.781599, -0.78912,  -0.781747, -0.788979, -0.781882, -0.78885,  -0.782006,   -0.788731, -0.782119, -0.788622,
      -0.782222, -0.788523, -0.782318, -0.788431, -0.782407, -0.788345, -0.782489,   -0.788267, -0.782565, -0.788194,
      -0.782635, -0.788126, -0.782701, -0.788063, -0.782762, -0.788005, -0.782818,   -0.78795,  -0.782871, -0.787899,
      -0.78292,  -0.787852, -0.782966, -0.787808, -0.783009, -0.787767, -0.783049,   -0.787728, -0.783086, -0.787692,
      -0.783121, -0.787658, -0.783153, -0.787627, -0.783184, -0.787599, -0.783212,   -0.787572, -0.783238, -0.787547,
      -0.783263, -0.787523, -0.783284, -0.787502, -0.783305, -0.787483, -0.783324,   -0.787464, -0.783342, -0.787448,
      -0.783358, -0.787432, -0.783373, -0.787419, -0.783386, -0.787406, -0.783397,   -0.787395, -0.783407, -0.787386,
      -0.783417, -0.787377, -0.783425, -0.78737,  -0.783431, -0.787364, -0.783436,   -0.787359, -0.78344,  -0.787356,
      -0.783443, -0.787354, -0.783445, -0.787352, -0.783446, -0.787352, -0.783445,   -0.787354, -0.783443, -0.787356,
      -0.78344,  -0.787359, -0.783436, -0.787364, -0.783431, -0.78737,  -0.783425,   -0.787377, -0.783417, -0.787386,
      -0.783407, -0.787395, -0.783397, -0.787406, -0.783386, -0.787419, -0.783373,   -0.787432, -0.783358, -0.787448,
      -0.783342, -0.787464, -0.783324, -0.787483, -0.783305, -0.787502, -0.783284,   -0.787523, -0.783263, -0.787547,
      -0.783238, -0.787572, -0.783212, -0.787599, -0.783184, -0.787627, -0.783153,   -0.787658, -0.783121, -0.787692,
      -0.783086, -0.787728, -0.783049, -0.787767, -0.783009, -0.787808, -0.782966,   -0.787852, -0.78292,  -0.787899,
      -0.782871, -0.78795,  -0.782818, -0.788005, -0.782762, -0.788063, -0.782701,   -0.788126, -0.782635, -0.788194,
      -0.782565, -0.788267, -0.782489, -0.788345, -0.782407, -0.788431, -0.782318,   -0.788523, -0.782222, -0.788622,
      -0.782119, -0.788731, -0.782006, -0.78885,  -0.781882, -0.788979, -0.781747,   -0.78912,  -0.781599, -0.789276,
      -0.781436, -0.789448, -0.781254, -0.789638, -0.781054, -0.78985,  -0.78083,    -0.790087, -0.780579, -0.790354,
      -0.780295, -0.790657, -0.779972, -0.791002, -0.779601, -0.7914,   -0.779173,   -0.791863, -0.778672, -0.792407,
      -0.778078, -0.793058, -0.777363, -0.793846, -0.776489, -0.794822, -0.775394,   -0.796059, -0.773985, -0.797678,
      -0.772105, -0.799886, -0.769474, -0.803074, -0.765533, -0.80807,  -0.758993,   -0.817002, -0.746064, -0.837393,
      -0.709068, -0.925972},
     {0,         0.925972,  0.709068,  0.837393,  0.746064,  0.817002,  0.758993,    0.80807,   0.765533,  0.803074,
      0.769474,  0.799886,  0.772105,  0.797678,  0.773985,  0.796059,  0.775394,    0.794822,  0.776489,  0.793846,
      0.777363,  0.793058,  0.778078,  0.792407,  0.778672,  0.791863,  0.779173,    0.7914,    0.779601,  0.791002,
      0.779972,  0.790657,  0.780295,  0.790354,  0.780579,  0.790087,  0.78083,     0.78985,   0.781054,  0.789638,
      0.781254,  0.789448,  0.781436,  0.789276,  0.781599,  0.78912,   0.781747,    0.788979,  0.781882,  0.78885,
      0.782006,  0.788731,  0.782119,  0.788622,  0.782222,  0.788523,  0.782318,    0.788431,  0.782407,  0.788345,
      0.782489,  0.788267,  0.782565,  0.788194,  0.782635,  0.788126,  0.782701,    0.788063,  0.782762,  0.788005,
      0.782818,  0.78795,   0.782871,  0.787899,  0.78292,   0.787852,  0.782966,    0.787808,  0.783009,  0.787767,
      0.783049,  0.787728,  0.783086,  0.787692,  0.783121,  0.787658,  0.783153,    0.787627,  0.783184,  0.787599,
      0.783212,  0.787572,  0.783238,  0.787547,  0.783263,  0.787523,  0.783284,    0.787502,  0.783305,  0.787483,
      0.783324,  0.787464,  0.783342,  0.787448,  0.783358,  0.787432,  0.783373,    0.787419,  0.783386,  0.787406,
      0.783397,  0.787395,  0.783407,  0.787386,  0.783417,  0.787377,  0.783425,    0.78737,   0.783431,  0.787364,
      0.783436,  0.787359,  0.78344,   0.787356,  0.783443,  0.787354,  0.783445,    0.787352,  0.783446,  0.787352,
      0.783445,  0.787354,  0.783443,  0.787356,  0.78344,   0.787359,  0.783436,    0.787364,  0.783431,  0.78737,
      0.783425,  0.787377,  0.783417,  0.787386,  0.783407,  0.787395,  0.783397,    0.787406,  0.783386,  0.787419,
      0.783373,  0.787432,  0.783358,  0.787448,  0.783342,  0.787464,  0.783324,    0.787483,  0.783305,  0.787502,
      0.783284,  0.787523,  0.783263,  0.787547,  0.783238,  0.787572,  0.783212,    0.787599,  0.783184,  0.787627,
      0.783153,  0.787658,  0.783121,  0.787692,  0.783086,  0.787728,  0.783049,    0.787767,  0.783009,  0.787808,
      0.782966,  0.787852,  0.78292,   0.787899,  0.782871,  0.78795,   0.782818,    0.788005,  0.782762,  0.788063,
      0.782701,  0.788126,  0.782635,  0.788194,  0.782565,  0.788267,  0.782489,    0.788345,  0.782407,  0.788431,
      0.782318,  0.788523,  0.782222,  0.788622,  0.782119,  0.788731,  0.782006,    0.78885,   0.781882,  0.788979,
      0.781747,  0.78912,   0.781599,  0.789276,  0.781436,  0.789448,  0.781254,    0.789638,  0.781054,  0.78985,
      0.78083,   0.790087,  0.780579,  0.790354,  0.780295,  0.790657,  0.779972,    0.791002,  0.779601,  0.7914,
      0.779173,  0.791863,  0.778672,  0.792407,  0.778078,  0.793058,  0.777363,    0.793846,  0.776489,  0.794822,
      0.775394,  0.796059,  0.773985,  0.797678,  0.772105,  0.799886,  0.769474,    0.803074,  0.765533,  0.80807,
      0.758993,  0.817002,  0.746064,  0.837393,  0.709068,  0.925972,  1.60939e-14, -0.925972, -0.709068, -0.837393,
      -0.746064, -0.817002, -0.758993, -0.80807,  -0.765533, -0.803074, -0.769474,   -0.799886, -0.772105, -0.797678,
      -0.773985, -0.796059, -0.775394, -0.794822, -0.776489, -0.793846, -0.777363,   -0.793058, -0.778078, -0.792407,
      -0.778672, -0.791863, -0.779173, -0.7914,   -0.779601, -0.791002, -0.779972,   -0.790657, -0.780295, -0.790354,
      -0.780579, -0.790087, -0.78083,  -0.78985,  -0.781054, -0.789638, -0.781254,   -0.789448, -0.781436, -0.789276,
      -0.781599, -0.78912,  -0.781747, -0.788979, -0.781882, -0.78885,  -0.782006,   -0.788731, -0.782119, -0.788622,
      -0.782222, -0.788523, -0.782318, -0.788431, -0.782407, -0.788345, -0.782489,   -0.788267, -0.782565, -0.788194,
      -0.782635, -0.788126, -0.782701, -0.788063, -0.782762, -0.788005, -0.782818,   -0.78795,  -0.782871, -0.787899,
      -0.78292,  -0.787852, -0.782966, -0.787808, -0.783009, -0.787767, -0.783049,   -0.787728, -0.783086, -0.787692,
      -0.783121, -0.787658, -0.783153, -0.787627, -0.783184, -0.787599, -0.783212,   -0.787572, -0.783238, -0.787547,
      -0.783263, -0.787523, -0.783284, -0.787502, -0.783305, -0.787483, -0.783324,   -0.787464, -0.783342, -0.787448,
      -0.783358, -0.787432, -0.783373, -0.787419, -0.783386, -0.787406, -0.783397,   -0.787395, -0.783407, -0.787386,
      -0.783417, -0.787377, -0.783425, -0.78737,  -0.783431, -0.787364, -0.783436,   -0.787359, -0.78344,  -0.787356,
      -0.783443, -0.787354, -0.783445, -0.787352, -0.783446, -0.787352, -0.783445,   -0.787354, -0.783443, -0.787356,
      -0.78344,  -0.787359, -0.783436, -0.787364, -0.783431, -0.78737,  -0.783425,   -0.787377, -0.783417, -0.787386,
      -0.783407, -0.787395, -0.783397, -0.787406, -0.783386, -0.787419, -0.783373,   -0.787432, -0.783358, -0.787448,
      -0.783342, -0.787464, -0.783324, -0.787483, -0.783305, -0.787502, -0.783284,   -0.787523, -0.783263, -0.787547,
      -0.783238, -0.787572, -0.783212, -0.787599, -0.783184, -0.787627, -0.783153,   -0.787658, -0.783121, -0.787692,
      -0.783086, -0.787728, -0.783049, -0.787767, -0.783009, -0.787808, -0.782966,   -0.787852, -0.78292,  -0.787899,
      -0.782871, -0.78795,  -0.782818, -0.788005, -0.782762, -0.788063, -0.782701,   -0.788126, -0.782635, -0.788194,
      -0.782565, -0.788267, -0.782489, -0.788345, -0.782407, -0.788431, -0.782318,   -0.788523, -0.782222, -0.788622,
      -0.782119, -0.788731, -0.782006, -0.78885,  -0.781882, -0.788979, -0.781747,   -0.78912,  -0.781599, -0.789276,
      -0.781436, -0.789448, -0.781254, -0.789638, -0.781054, -0.78985,  -0.78083,    -0.790087, -0.780579, -0.790354,
      -0.780295, -0.790657, -0.779972, -0.791002, -0.779601, -0.7914,   -0.779173,   -0.791863, -0.778672, -0.792407,
      -0.778078, -0.793058, -0.777363, -0.793846, -0.776489, -0.794822, -0.775394,   -0.796059, -0.773985, -0.797678,
      -0.772105, -0.799886, -0.769474, -0.803074, -0.765533, -0.80807,  -0.758993,   -0.817002, -0.746064, -0.837393,
      -0.709068, -0.925972},
     {0,         0.925972,  0.709068,  0.837393,  0.746064,  0.817002,  0.758993,    0.80807,   0.765533,  0.803074,
      0.769474,  0.799886,  0.772105,  0.797678,  0.773985,  0.796059,  0.775394,    0.794822,  0.776489,  0.793846,
      0.777363,  0.793058,  0.778078,  0.792407,  0.778672,  0.791863,  0.779173,    0.7914,    0.779601,  0.791002,
      0.779972,  0.790657,  0.780295,  0.790354,  0.780579,  0.790087,  0.78083,     0.78985,   0.781054,  0.789638,
      0.781254,  0.789448,  0.781436,  0.789276,  0.781599,  0.78912,   0.781747,    0.788979,  0.781882,  0.78885,
      0.782006,  0.788731,  0.782119,  0.788622,  0.782222,  0.788523,  0.782318,    0.788431,  0.782407,  0.788345,
      0.782489,  0.788267,  0.782565,  0.788194,  0.782635,  0.788126,  0.782701,    0.788063,  0.782762,  0.788005,
      0.782818,  0.78795,   0.782871,  0.787899,  0.78292,   0.787852,  0.782966,    0.787808,  0.783009,  0.787767,
      0.783049,  0.787728,  0.783086,  0.787692,  0.783121,  0.787658,  0.783153,    0.787627,  0.783184,  0.787599,
      0.783212,  0.787572,  0.783238,  0.787547,  0.783263,  0.787523,  0.783284,    0.787502,  0.783305,  0.787483,
      0.783324,  0.787464,  0.783342,  0.787448,  0.783358,  0.787432,  0.783373,    0.787419,  0.783386,  0.787406,
      0.783397,  0.787395,  0.783407,  0.787386,  0.783417,  0.787377,  0.783425,    0.78737,   0.783431,  0.787364,
      0.783436,  0.787359,  0.78344,   0.787356,  0.783443,  0.787354,  0.783445,    0.787352,  0.783446,  0.787352,
      0.783445,  0.787354,  0.783443,  0.787356,  0.78344,   0.787359,  0.783436,    0.787364,  0.783431,  0.78737,
      0.783425,  0.787377,  0.783417,  0.787386,  0.783407,  0.787395,  0.783397,    0.787406,  0.783386,  0.787419,
      0.783373,  0.787432,  0.783358,  0.787448,  0.783342,  0.787464,  0.783324,    0.787483,  0.783305,  0.787502,
      0.783284,  0.787523,  0.783263,  0.787547,  0.783238,  0.787572,  0.783212,    0.787599,  0.783184,  0.787627,
      0.783153,  0.787658,  0.783121,  0.787692,  0.783086,  0.787728,  0.783049,    0.787767,  0.783009,  0.787808,
      0.782966,  0.787852,  0.78292,   0.787899,  0.782871,  0.78795,   0.782818,    0.788005,  0.782762,  0.788063,
      0.782701,  0.788126,  0.782635,  0.788194,  0.782565,  0.788267,  0.782489,    0.788345,  0.782407,  0.788431,
      0.782318,  0.788523,  0.782222,  0.788622,  0.782119,  0.788731,  0.782006,    0.78885,   0.781882,  0.788979,
      0.781747,  0.78912,   0.781599,  0.789276,  0.781436,  0.789448,  0.781254,    0.789638,  0.781054,  0.78985,
      0.78083,   0.790087,  0.780579,  0.790354,  0.780295,  0.790657,  0.779972,    0.791002,  0.779601,  0.7914,
      0.779173,  0.791863,  0.778672,  0.792407,  0.778078,  0.793058,  0.777363,    0.793846,  0.776489,  0.794822,
      0.775394,  0.796059,  0.773985,  0.797678,  0.772105,  0.799886,  0.769474,    0.803074,  0.765533,  0.80807,
      0.758993,  0.817002,  0.746064,  0.837393,  0.709068,  0.925972,  1.60939e-14, -0.925972, -0.709068, -0.837393,
      -0.746064, -0.817002, -0.758993, -0.80807,  -0.765533, -0.803074, -0.769474,   -0.799886, -0.772105, -0.797678,
      -0.773985, -0.796059, -0.775394, -0.794822, -0.776489, -0.793846, -0.777363,   -0.793058, -0.778078, -0.792407,
      -0.778672, -0.791863, -0.779173, -0.7914,   -0.779601, -0.791002, -0.779972,   -0.790657, -0.780295, -0.790354,
      -0.780579, -0.790087, -0.78083,  -0.78985,  -0.781054, -0.789638, -0.781254,   -0.789448, -0.781436, -0.789276,
      -0.781599, -0.78912,  -0.781747, -0.788979, -0.781882, -0.78885,  -0.782006,   -0.788731, -0.782119, -0.788622,
      -0.782222, -0.788523, -0.782318, -0.788431, -0.782407, -0.788345, -0.782489,   -0.788267, -0.782565, -0.788194,
      -0.782635, -0.788126, -0.782701, -0.788063, -0.782762, -0.788005, -0.782818,   -0.78795,  -0.782871, -0.787899,
      -0.78292,  -0.787852, -0.782966, -0.787808, -0.783009, -0.787767, -0.783049,   -0.787728, -0.783086, -0.787692,
      -0.783121, -0.787658, -0.783153, -0.787627, -0.783184, -0.787599, -0.783212,   -0.787572, -0.783238, -0.787547,
      -0.783263, -0.787523, -0.783284, -0.787502, -0.783305, -0.787483, -0.783324,   -0.787464, -0.783342, -0.787448,
      -0.783358, -0.787432, -0.783373, -0.787419, -0.783386, -0.787406, -0.783397,   -0.787395, -0.783407, -0.787386,
      -0.783417, -0.787377, -0.783425, -0.78737,  -0.783431, -0.787364, -0.783436,   -0.787359, -0.78344,  -0.787356,
      -0.783443, -0.787354, -0.783445, -0.787352, -0.783446, -0.787352, -0.783445,   -0.787354, -0.783443, -0.787356,
      -0.78344,  -0.787359, -0.783436, -0.787364, -0.783431, -0.78737,  -0.783425,   -0.787377, -0.783417, -0.787386,
      -0.783407, -0.787395, -0.783397, -0.787406, -0.783386, -0.787419, -0.783373,   -0.787432, -0.783358, -0.787448,
      -0.783342, -0.787464, -0.783324, -0.787483, -0.783305, -0.787502, -0.783284,   -0.787523, -0.783263, -0.787547,
      -0.783238, -0.787572, -0.783212, -0.787599, -0.783184, -0.787627, -0.783153,   -0.787658, -0.783121, -0.787692,
      -0.783086, -0.787728, -0.783049, -0.787767, -0.783009, -0.787808, -0.782966,   -0.787852, -0.78292,  -0.787899,
      -0.782871, -0.78795,  -0.782818, -0.788005, -0.782762, -0.788063, -0.782701,   -0.788126, -0.782635, -0.788194,
      -0.782565, -0.788267, -0.782489, -0.788345, -0.782407, -0.788431, -0.782318,   -0.788523, -0.782222, -0.788622,
      -0.782119, -0.788731, -0.782006, -0.78885,  -0.781882, -0.788979, -0.781747,   -0.78912,  -0.781599, -0.789276,
      -0.781436, -0.789448, -0.781254, -0.789638, -0.781054, -0.78985,  -0.78083,    -0.790087, -0.780579, -0.790354,
      -0.780295, -0.790657, -0.779972, -0.791002, -0.779601, -0.7914,   -0.779173,   -0.791863, -0.778672, -0.792407,
      -0.778078, -0.793058, -0.777363, -0.793846, -0.776489, -0.794822, -0.775394,   -0.796059, -0.773985, -0.797678,
      -0.772105, -0.799886, -0.769474, -0.803074, -0.765533, -0.80807,  -0.758993,   -0.817002, -0.746064, -0.837393,
      -0.709068, -0.925972},
     {0,         0.925972,  0.709068,  0.837393,  0.746064,  0.817002,  0.758993,    0.80807,   0.765533,  0.803074,
      0.769474,  0.799886,  0.772105,  0.797678,  0.773985,  0.796059,  0.775394,    0.794822,  0.776489,  0.793846,
      0.777363,  0.793058,  0.778078,  0.792407,  0.778672,  0.791863,  0.779173,    0.7914,    0.779601,  0.791002,
      0.779972,  0.790657,  0.780295,  0.790354,  0.780579,  0.790087,  0.78083,     0.78985,   0.781054,  0.789638,
      0.781254,  0.789448,  0.781436,  0.789276,  0.781599,  0.78912,   0.781747,    0.788979,  0.781882,  0.78885,
      0.782006,  0.788731,  0.782119,  0.788622,  0.782222,  0.788523,  0.782318,    0.788431,  0.782407,  0.788345,
      0.782489,  0.788267,  0.782565,  0.788194,  0.782635,  0.788126,  0.782701,    0.788063,  0.782762,  0.788005,
      0.782818,  0.78795,   0.782871,  0.787899,  0.78292,   0.787852,  0.782966,    0.787808,  0.783009,  0.787767,
      0.783049,  0.787728,  0.783086,  0.787692,  0.783121,  0.787658,  0.783153,    0.787627,  0.783184,  0.787599,
      0.783212,  0.787572,  0.783238,  0.787547,  0.783263,  0.787523,  0.783284,    0.787502,  0.783305,  0.787483,
      0.783324,  0.787464,  0.783342,  0.787448,  0.783358,  0.787432,  0.783373,    0.787419,  0.783386,  0.787406,
      0.783397,  0.787395,  0.783407,  0.787386,  0.783417,  0.787377,  0.783425,    0.78737,   0.783431,  0.787364,
      0.783436,  0.787359,  0.78344,   0.787356,  0.783443,  0.787354,  0.783445,    0.787352,  0.783446,  0.787352,
      0.783445,  0.787354,  0.783443,  0.787356,  0.78344,   0.787359,  0.783436,    0.787364,  0.783431,  0.78737,
      0.783425,  0.787377,  0.783417,  0.787386,  0.783407,  0.787395,  0.783397,    0.787406,  0.783386,  0.787419,
      0.783373,  0.787432,  0.783358,  0.787448,  0.783342,  0.787464,  0.783324,    0.787483,  0.783305,  0.787502,
      0.783284,  0.787523,  0.783263,  0.787547,  0.783238,  0.787572,  0.783212,    0.787599,  0.783184,  0.787627,
      0.783153,  0.787658,  0.783121,  0.787692,  0.783086,  0.787728,  0.783049,    0.787767,  0.783009,  0.787808,
      0.782966,  0.787852,  0.78292,   0.787899,  0.782871,  0.78795,   0.782818,    0.788005,  0.782762,  0.788063,
      0.782701,  0.788126,  0.782635,  0.788194,  0.782565,  0.788267,  0.782489,    0.788345,  0.782407,  0.788431,
      0.782318,  0.788523,  0.782222,  0.788622,  0.782119,  0.788731,  0.782006,    0.78885,   0.781882,  0.788979,
      0.781747,  0.78912,   0.781599,  0.789276,  0.781436,  0.789448,  0.781254,    0.789638,  0.781054,  0.78985,
      0.78083,   0.790087,  0.780579,  0.790354,  0.780295,  0.790657,  0.779972,    0.791002,  0.779601,  0.7914,
      0.779173,  0.791863,  0.778672,  0.792407,  0.778078,  0.793058,  0.777363,    0.793846,  0.776489,  0.794822,
      0.775394,  0.796059,  0.773985,  0.797678,  0.772105,  0.799886,  0.769474,    0.803074,  0.765533,  0.80807,
      0.758993,  0.817002,  0.746064,  0.837393,  0.709068,  0.925972,  1.60939e-14, -0.925972, -0.709068, -0.837393,
      -0.746064, -0.817002, -0.758993, -0.80807,  -0.765533, -0.803074, -0.769474,   -0.799886, -0.772105, -0.797678,
      -0.773985, -0.796059, -0.775394, -0.794822, -0.776489, -0.793846, -0.777363,   -0.793058, -0.778078, -0.792407,
      -0.778672, -0.791863, -0.779173, -0.7914,   -0.779601, -0.791002, -0.779972,   -0.790657, -0.780295, -0.790354,
      -0.780579, -0.790087, -0.78083,  -0.78985,  -0.781054, -0.789638, -0.781254,   -0.789448, -0.781436, -0.789276,
      -0.781599, -0.78912,  -0.781747, -0.788979, -0.781882, -0.78885,  -0.782006,   -0.788731, -0.782119, -0.788622,
      -0.782222, -0.788523, -0.782318, -0.788431, -0.782407, -0.788345, -0.782489,   -0.788267, -0.782565, -0.788194,
      -0.782635, -0.788126, -0.782701, -0.788063, -0.782762, -0.788005, -0.782818,   -0.78795,  -0.782871, -0.787899,
      -0.78292,  -0.787852, -0.782966, -0.787808, -0.783009, -0.787767, -0.783049,   -0.787728, -0.783086, -0.787692,
      -0.783121, -0.787658, -0.783153, -0.787627, -0.783184, -0.787599, -0.783212,   -0.787572, -0.783238, -0.787547,
      -0.783263, -0.787523, -0.783284, -0.787502, -0.783305, -0.787483, -0.783324,   -0.787464, -0.783342, -0.787448,
      -0.783358, -0.787432, -0.783373, -0.787419, -0.783386, -0.787406, -0.783397,   -0.787395, -0.783407, -0.787386,
      -0.783417, -0.787377, -0.783425, -0.78737,  -0.783431, -0.787364, -0.783436,   -0.787359, -0.78344,  -0.787356,
      -0.783443, -0.787354, -0.783445, -0.787352, -0.783446, -0.787352, -0.783445,   -0.787354, -0.783443, -0.787356,
      -0.78344,  -0.787359, -0.783436, -0.787364, -0.783431, -0.78737,  -0.783425,   -0.787377, -0.783417, -0.787386,
      -0.783407, -0.787395, -0.783397, -0.787406, -0.783386, -0.787419, -0.783373,   -0.787432, -0.783358, -0.787448,
      -0.783342, -0.787464, -0.783324, -0.787483, -0.783305, -0.787502, -0.783284,   -0.787523, -0.783263, -0.787547,
      -0.783238, -0.787572, -0.783212, -0.787599, -0.783184, -0.787627, -0.783153,   -0.787658, -0.783121, -0.787692,
      -0.783086, -0.787728, -0.783049, -0.787767, -0.783009, -0.787808, -0.782966,   -0.787852, -0.78292,  -0.787899,
      -0.782871, -0.78795,  -0.782818, -0.788005, -0.782762, -0.788063, -0.782701,   -0.788126, -0.782635, -0.788194,
      -0.782565, -0.788267, -0.782489, -0.788345, -0.782407, -0.788431, -0.782318,   -0.788523, -0.782222, -0.788622,
      -0.782119, -0.788731, -0.782006, -0.78885,  -0.781882, -0.788979, -0.781747,   -0.78912,  -0.781599, -0.789276,
      -0.781436, -0.789448, -0.781254, -0.789638, -0.781054, -0.78985,  -0.78083,    -0.790087, -0.780579, -0.790354,
      -0.780295, -0.790657, -0.779972, -0.791002, -0.779601, -0.7914,   -0.779173,   -0.791863, -0.778672, -0.792407,
      -0.778078, -0.793058, -0.777363, -0.793846, -0.776489, -0.794822, -0.775394,   -0.796059, -0.773985, -0.797678,
      -0.772105, -0.799886, -0.769474, -0.803074, -0.765533, -0.80807,  -0.758993,   -0.817002, -0.746064, -0.837393,
      -0.709068, -0.925972},
     {0,         0.925972,  0.709068,  0.837393,  0.746064,  0.817002,  0.758993,    0.80807,   0.765533,  0.803074,
      0.769474,  0.799886,  0.772105,  0.797678,  0.773985,  0.796059,  0.775394,    0.794822,  0.776489,  0.793846,
      0.777363,  0.793058,  0.778078,  0.792407,  0.778672,  0.791863,  0.779173,    0.7914,    0.779601,  0.791002,
      0.779972,  0.790657,  0.780295,  0.790354,  0.780579,  0.790087,  0.78083,     0.78985,   0.781054,  0.789638,
      0.781254,  0.789448,  0.781436,  0.789276,  0.781599,  0.78912,   0.781747,    0.788979,  0.781882,  0.78885,
      0.782006,  0.788731,  0.782119,  0.788622,  0.782222,  0.788523,  0.782318,    0.788431,  0.782407,  0.788345,
      0.782489,  0.788267,  0.782565,  0.788194,  0.782635,  0.788126,  0.782701,    0.788063,  0.782762,  0.788005,
      0.782818,  0.78795,   0.782871,  0.787899,  0.78292,   0.787852,  0.782966,    0.787808,  0.783009,  0.787767,
      0.783049,  0.787728,  0.783086,  0.787692,  0.783121,  0.787658,  0.783153,    0.787627,  0.783184,  0.787599,
      0.783212,  0.787572,  0.783238,  0.787547,  0.783263,  0.787523,  0.783284,    0.787502,  0.783305,  0.787483,
      0.783324,  0.787464,  0.783342,  0.787448,  0.783358,  0.787432,  0.783373,    0.787419,  0.783386,  0.787406,
      0.783397,  0.787395,  0.783407,  0.787386,  0.783417,  0.787377,  0.783425,    0.78737,   0.783431,  0.787364,
      0.783436,  0.787359,  0.78344,   0.787356,  0.783443,  0.787354,  0.783445,    0.787352,  0.783446,  0.787352,
      0.783445,  0.787354,  0.783443,  0.787356,  0.78344,   0.787359,  0.783436,    0.787364,  0.783431,  0.78737,
      0.783425,  0.787377,  0.783417,  0.787386,  0.783407,  0.787395,  0.783397,    0.787406,  0.783386,  0.787419,
      0.783373,  0.787432,  0.783358,  0.787448,  0.783342,  0.787464,  0.783324,    0.787483,  0.783305,  0.787502,
      0.783284,  0.787523,  0.783263,  0.787547,  0.783238,  0.787572,  0.783212,    0.787599,  0.783184,  0.787627,
      0.783153,  0.787658,  0.783121,  0.787692,  0.783086,  0.787728,  0.783049,    0.787767,  0.783009,  0.787808,
      0.782966,  0.787852,  0.78292,   0.787899,  0.782871,  0.78795,   0.782818,    0.788005,  0.782762,  0.788063,
      0.782701,  0.788126,  0.782635,  0.788194,  0.782565,  0.788267,  0.782489,    0.788345,  0.782407,  0.788431,
      0.782318,  0.788523,  0.782222,  0.788622,  0.782119,  0.788731,  0.782006,    0.78885,   0.781882,  0.788979,
      0.781747,  0.78912,   0.781599,  0.789276,  0.781436,  0.789448,  0.781254,    0.789638,  0.781054,  0.78985,
      0.78083,   0.790087,  0.780579,  0.790354,  0.780295,  0.790657,  0.779972,    0.791002,  0.779601,  0.7914,
      0.779173,  0.791863,  0.778672,  0.792407,  0.778078,  0.793058,  0.777363,    0.793846,  0.776489,  0.794822,
      0.775394,  0.796059,  0.773985,  0.797678,  0.772105,  0.799886,  0.769474,    0.803074,  0.765533,  0.80807,
      0.758993,  0.817002,  0.746064,  0.837393,  0.709068,  0.925972,  1.60939e-14, -0.925972, -0.709068, -0.837393,
      -0.746064, -0.817002, -0.758993, -0.80807,  -0.765533, -0.803074, -0.769474,   -0.799886, -0.772105, -0.797678,
      -0.773985, -0.796059, -0.775394, -0.794822, -0.776489, -0.793846, -0.777363,   -0.793058, -0.778078, -0.792407,
      -0.778672, -0.791863, -0.779173, -0.7914,   -0.779601, -0.791002, -0.779972,   -0.790657, -0.780295, -0.790354,
      -0.780579, -0.790087, -0.78083,  -0.78985,  -0.781054, -0.789638, -0.781254,   -0.789448, -0.781436, -0.789276,
      -0.781599, -0.78912,  -0.781747, -0.788979, -0.781882, -0.78885,  -0.782006,   -0.788731, -0.782119, -0.788622,
      -0.782222, -0.788523, -0.782318, -0.788431, -0.782407, -0.788345, -0.782489,   -0.788267, -0.782565, -0.788194,
      -0.782635, -0.788126, -0.782701, -0.788063, -0.782762, -0.788005, -0.782818,   -0.78795,  -0.782871, -0.787899,
      -0.78292,  -0.787852, -0.782966, -0.787808, -0.783009, -0.787767, -0.783049,   -0.787728, -0.783086, -0.787692,
      -0.783121, -0.787658, -0.783153, -0.787627, -0.783184, -0.787599, -0.783212,   -0.787572, -0.783238, -0.787547,
      -0.783263, -0.787523, -0.783284, -0.787502, -0.783305, -0.787483, -0.783324,   -0.787464, -0.783342, -0.787448,
      -0.783358, -0.787432, -0.783373, -0.787419, -0.783386, -0.787406, -0.783397,   -0.787395, -0.783407, -0.787386,
      -0.783417, -0.787377, -0.783425, -0.78737,  -0.783431, -0.787364, -0.783436,   -0.787359, -0.78344,  -0.787356,
      -0.783443, -0.787354, -0.783445, -0.787352, -0.783446, -0.787352, -0.783445,   -0.787354, -0.783443, -0.787356,
      -0.78344,  -0.787359, -0.783436, -0.787364, -0.783431, -0.78737,  -0.783425,   -0.787377, -0.783417, -0.787386,
      -0.783407, -0.787395, -0.783397, -0.787406, -0.783386, -0.787419, -0.783373,   -0.787432, -0.783358, -0.787448,
      -0.783342, -0.787464, -0.783324, -0.787483, -0.783305, -0.787502, -0.783284,   -0.787523, -0.783263, -0.787547,
      -0.783238, -0.787572, -0.783212, -0.787599, -0.783184, -0.787627, -0.783153,   -0.787658, -0.783121, -0.787692,
      -0.783086, -0.787728, -0.783049, -0.787767, -0.783009, -0.787808, -0.782966,   -0.787852, -0.78292,  -0.787899,
      -0.782871, -0.78795,  -0.782818, -0.788005, -0.782762, -0.788063, -0.782701,   -0.788126, -0.782635, -0.788194,
      -0.782565, -0.788267, -0.782489, -0.788345, -0.782407, -0.788431, -0.782318,   -0.788523, -0.782222, -0.788622,
      -0.782119, -0.788731, -0.782006, -0.78885,  -0.781882, -0.788979, -0.781747,   -0.78912,  -0.781599, -0.789276,
      -0.781436, -0.789448, -0.781254, -0.789638, -0.781054, -0.78985,  -0.78083,    -0.790087, -0.780579, -0.790354,
      -0.780295, -0.790657, -0.779972, -0.791002, -0.779601, -0.7914,   -0.779173,   -0.791863, -0.778672, -0.792407,
      -0.778078, -0.793058, -0.777363, -0.793846, -0.776489, -0.794822, -0.775394,   -0.796059, -0.773985, -0.797678,
      -0.772105, -0.799886, -0.769474, -0.803074, -0.765533, -0.80807,  -0.758993,   -0.817002, -0.746064, -0.837393,
      -0.709068, -0.925972},
     {0,         0.925972,  0.709068,  0.837393,  0.746064,  0.817002,  0.758993,    0.80807,   0.765533,  0.803074,
      0.769474,  0.799886,  0.772105,  0.797678,  0.773985,  0.796059,  0.775394,    0.794822,  0.776489,  0.793846,
      0.777363,  0.793058,  0.778078,  0.792407,  0.778672,  0.791863,  0.779173,    0.7914,    0.779601,  0.791002,
      0.779972,  0.790657,  0.780295,  0.790354,  0.780579,  0.790087,  0.78083,     0.78985,   0.781054,  0.789638,
      0.781254,  0.789448,  0.781436,  0.789276,  0.781599,  0.78912,   0.781747,    0.788979,  0.781882,  0.78885,
      0.782006,  0.788731,  0.782119,  0.788622,  0.782222,  0.788523,  0.782318,    0.788431,  0.782407,  0.788345,
      0.782489,  0.788267,  0.782565,  0.788194,  0.782635,  0.788126,  0.782701,    0.788063,  0.782762,  0.788005,
      0.782818,  0.78795,   0.782871,  0.787899,  0.78292,   0.787852,  0.782966,    0.787808,  0.783009,  0.787767,
      0.783049,  0.787728,  0.783086,  0.787692,  0.783121,  0.787658,  0.783153,    0.787627,  0.783184,  0.787599,
      0.783212,  0.787572,  0.783238,  0.787547,  0.783263,  0.787523,  0.783284,    0.787502,  0.783305,  0.787483,
      0.783324,  0.787464,  0.783342,  0.787448,  0.783358,  0.787432,  0.783373,    0.787419,  0.783386,  0.787406,
      0.783397,  0.787395,  0.783407,  0.787386,  0.783417,  0.787377,  0.783425,    0.78737,   0.783431,  0.787364,
      0.783436,  0.787359,  0.78344,   0.787356,  0.783443,  0.787354,  0.783445,    0.787352,  0.783446,  0.787352,
      0.783445,  0.787354,  0.783443,  0.787356,  0.78344,   0.787359,  0.783436,    0.787364,  0.783431,  0.78737,
      0.783425,  0.787377,  0.783417,  0.787386,  0.783407,  0.787395,  0.783397,    0.787406,  0.783386,  0.787419,
      0.783373,  0.787432,  0.783358,  0.787448,  0.783342,  0.787464,  0.783324,    0.787483,  0.783305,  0.787502,
      0.783284,  0.787523,  0.783263,  0.787547,  0.783238,  0.787572,  0.783212,    0.787599,  0.783184,  0.787627,
      0.783153,  0.787658,  0.783121,  0.787692,  0.783086,  0.787728,  0.783049,    0.787767,  0.783009,  0.787808,
      0.782966,  0.787852,  0.78292,   0.787899,  0.782871,  0.78795,   0.782818,    0.788005,  0.782762,  0.788063,
      0.782701,  0.788126,  0.782635,  0.788194,  0.782565,  0.788267,  0.782489,    0.788345,  0.782407,  0.788431,
      0.782318,  0.788523,  0.782222,  0.788622,  0.782119,  0.788731,  0.782006,    0.78885,   0.781882,  0.788979,
      0.781747,  0.78912,   0.781599,  0.789276,  0.781436,  0.789448,  0.781254,    0.789638,  0.781054,  0.78985,
      0.78083,   0.790087,  0.780579,  0.790354,  0.780295,  0.790657,  0.779972,    0.791002,  0.779601,  0.7914,
      0.779173,  0.791863,  0.778672,  0.792407,  0.778078,  0.793058,  0.777363,    0.793846,  0.776489,  0.794822,
      0.775394,  0.796059,  0.773985,  0.797678,  0.772105,  0.799886,  0.769474,    0.803074,  0.765533,  0.80807,
      0.758993,  0.817002,  0.746064,  0.837393,  0.709068,  0.925972,  1.60939e-14, -0.925972, -0.709068, -0.837393,
      -0.746064, -0.817002, -0.758993, -0.80807,  -0.765533, -0.803074, -0.769474,   -0.799886, -0.772105, -0.797678,
      -0.773985, -0.796059, -0.775394, -0.794822, -0.776489, -0.793846, -0.777363,   -0.793058, -0.778078, -0.792407,
      -0.778672, -0.791863, -0.779173, -0.7914,   -0.779601, -0.791002, -0.779972,   -0.790657, -0.780295, -0.790354,
      -0.780579, -0.790087, -0.78083,  -0.78985,  -0.781054, -0.789638, -0.781254,   -0.789448, -0.781436, -0.789276,
      -0.781599, -0.78912,  -0.781747, -0.788979, -0.781882, -0.78885,  -0.782006,   -0.788731, -0.782119, -0.788622,
      -0.782222, -0.788523, -0.782318, -0.788431, -0.782407, -0.788345, -0.782489,   -0.788267, -0.782565, -0.788194,
      -0.782635, -0.788126, -0.782701, -0.788063, -0.782762, -0.788005, -0.782818,   -0.78795,  -0.782871, -0.787899,
      -0.78292,  -0.787852, -0.782966, -0.787808, -0.783009, -0.787767, -0.783049,   -0.787728, -0.783086, -0.787692,
      -0.783121, -0.787658, -0.783153, -0.787627, -0.783184, -0.787599, -0.783212,   -0.787572, -0.783238, -0.787547,
      -0.783263, -0.787523, -0.783284, -0.787502, -0.783305, -0.787483, -0.783324,   -0.787464, -0.783342, -0.787448,
      -0.783358, -0.787432, -0.783373, -0.787419, -0.783386, -0.787406, -0.783397,   -0.787395, -0.783407, -0.787386,
      -0.783417, -0.787377, -0.783425, -0.78737,  -0.783431, -0.787364, -0.783436,   -0.787359, -0.78344,  -0.787356,
      -0.783443, -0.787354, -0.783445, -0.787352, -0.783446, -0.787352, -0.783445,   -0.787354, -0.783443, -0.787356,
      -0.78344,  -0.787359, -0.783436, -0.787364, -0.783431, -0.78737,  -0.783425,   -0.787377, -0.783417, -0.787386,
      -0.783407, -0.787395, -0.783397, -0.787406, -0.783386, -0.787419, -0.783373,   -0.787432, -0.783358, -0.787448,
      -0.783342, -0.787464, -0.783324, -0.787483, -0.783305, -0.787502, -0.783284,   -0.787523, -0.783263, -0.787547,
      -0.783238, -0.787572, -0.783212, -0.787599, -0.783184, -0.787627, -0.783153,   -0.787658, -0.783121, -0.787692,
      -0.783086, -0.787728, -0.783049, -0.787767, -0.783009, -0.787808, -0.782966,   -0.787852, -0.78292,  -0.787899,
      -0.782871, -0.78795,  -0.782818, -0.788005, -0.782762, -0.788063, -0.782701,   -0.788126, -0.782635, -0.788194,
      -0.782565, -0.788267, -0.782489, -0.788345, -0.782407, -0.788431, -0.782318,   -0.788523, -0.782222, -0.788622,
      -0.782119, -0.788731, -0.782006, -0.78885,  -0.781882, -0.788979, -0.781747,   -0.78912,  -0.781599, -0.789276,
      -0.781436, -0.789448, -0.781254, -0.789638, -0.781054, -0.78985,  -0.78083,    -0.790087, -0.780579, -0.790354,
      -0.780295, -0.790657, -0.779972, -0.791002, -0.779601, -0.7914,   -0.779173,   -0.791863, -0.778672, -0.792407,
      -0.778078, -0.793058, -0.777363, -0.793846, -0.776489, -0.794822, -0.775394,   -0.796059, -0.773985, -0.797678,
      -0.772105, -0.799886, -0.769474, -0.803074, -0.765533, -0.80807,  -0.758993,   -0.817002, -0.746064, -0.837393,
      -0.709068, -0.925972},
     {0,         0.925972,  0.709068,  0.837393,  0.746064,  0.817002,  0.758993,    0.80807,   0.765533,  0.803074,
      0.769474,  0.799886,  0.772105,  0.797678,  0.773985,  0.796059,  0.775394,    0.794822,  0.776489,  0.793846,
      0.777363,  0.793058,  0.778078,  0.792407,  0.778672,  0.791863,  0.779173,    0.7914,    0.779601,  0.791002,
      0.779972,  0.790657,  0.780295,  0.790354,  0.780579,  0.790087,  0.78083,     0.78985,   0.781054,  0.789638,
      0.781254,  0.789448,  0.781436,  0.789276,  0.781599,  0.78912,   0.781747,    0.788979,  0.781882,  0.78885,
      0.782006,  0.788731,  0.782119,  0.788622,  0.782222,  0.788523,  0.782318,    0.788431,  0.782407,  0.788345,
      0.782489,  0.788267,  0.782565,  0.788194,  0.782635,  0.788126,  0.782701,    0.788063,  0.782762,  0.788005,
      0.782818,  0.78795,   0.782871,  0.787899,  0.78292,   0.787852,  0.782966,    0.787808,  0.783009,  0.787767,
      0.783049,  0.787728,  0.783086,  0.787692,  0.783121,  0.787658,  0.783153,    0.787627,  0.783184,  0.787599,
      0.783212,  0.787572,  0.783238,  0.787547,  0.783263,  0.787523,  0.783284,    0.787502,  0.783305,  0.787483,
      0.783324,  0.787464,  0.783342,  0.787448,  0.783358,  0.787432,  0.783373,    0.787419,  0.783386,  0.787406,
      0.783397,  0.787395,  0.783407,  0.787386,  0.783417,  0.787377,  0.783425,    0.78737,   0.783431,  0.787364,
      0.783436,  0.787359,  0.78344,   0.787356,  0.783443,  0.787354,  0.783445,    0.787352,  0.783446,  0.787352,
      0.783445,  0.787354,  0.783443,  0.787356,  0.78344,   0.787359,  0.783436,    0.787364,  0.783431,  0.78737,
      0.783425,  0.787377,  0.783417,  0.787386,  0.783407,  0.787395,  0.783397,    0.787406,  0.783386,  0.787419,
      0.783373,  0.787432,  0.783358,  0.787448,  0.783342,  0.787464,  0.783324,    0.787483,  0.783305,  0.787502,
      0.783284,  0.787523,  0.783263,  0.787547,  0.783238,  0.787572,  0.783212,    0.787599,  0.783184,  0.787627,
      0.783153,  0.787658,  0.783121,  0.787692,  0.783086,  0.787728,  0.783049,    0.787767,  0.783009,  0.787808,
      0.782966,  0.787852,  0.78292,   0.787899,  0.782871,  0.78795,   0.782818,    0.788005,  0.782762,  0.788063,
      0.782701,  0.788126,  0.782635,  0.788194,  0.782565,  0.788267,  0.782489,    0.788345,  0.782407,  0.788431,
      0.782318,  0.788523,  0.782222,  0.788622,  0.782119,  0.788731,  0.782006,    0.78885,   0.781882,  0.788979,
      0.781747,  0.78912,   0.781599,  0.789276,  0.781436,  0.789448,  0.781254,    0.789638,  0.781054,  0.78985,
      0.78083,   0.790087,  0.780579,  0.790354,  0.780295,  0.790657,  0.779972,    0.791002,  0.779601,  0.7914,
      0.779173,  0.791863,  0.778672,  0.792407,  0.778078,  0.793058,  0.777363,    0.793846,  0.776489,  0.794822,
      0.775394,  0.796059,  0.773985,  0.797678,  0.772105,  0.799886,  0.769474,    0.803074,  0.765533,  0.80807,
      0.758993,  0.817002,  0.746064,  0.837393,  0.709068,  0.925972,  1.60939e-14, -0.925972, -0.709068, -0.837393,
      -0.746064, -0.817002, -0.758993, -0.80807,  -0.765533, -0.803074, -0.769474,   -0.799886, -0.772105, -0.797678,
      -0.773985, -0.796059, -0.775394, -0.794822, -0.776489, -0.793846, -0.777363,   -0.793058, -0.778078, -0.792407,
      -0.778672, -0.791863, -0.779173, -0.7914,   -0.779601, -0.791002, -0.779972,   -0.790657, -0.780295, -0.790354,
      -0.780579, -0.790087, -0.78083,  -0.78985,  -0.781054, -0.789638, -0.781254,   -0.789448, -0.781436, -0.789276,
      -0.781599, -0.78912,  -0.781747, -0.788979, -0.781882, -0.78885,  -0.782006,   -0.788731, -0.782119, -0.788622,
      -0.782222, -0.788523, -0.782318, -0.788431, -0.782407, -0.788345, -0.782489,   -0.788267, -0.782565, -0.788194,
      -0.782635, -0.788126, -0.782701, -0.788063, -0.782762, -0.788005, -0.782818,   -0.78795,  -0.782871, -0.787899,
      -0.78292,  -0.787852, -0.782966, -0.787808, -0.783009, -0.787767, -0.783049,   -0.787728, -0.783086, -0.787692,
      -0.783121, -0.787658, -0.783153, -0.787627, -0.783184, -0.787599, -0.783212,   -0.787572, -0.783238, -0.787547,
      -0.783263, -0.787523, -0.783284, -0.787502, -0.783305, -0.787483, -0.783324,   -0.787464, -0.783342, -0.787448,
      -0.783358, -0.787432, -0.783373, -0.787419, -0.783386, -0.787406, -0.783397,   -0.787395, -0.783407, -0.787386,
      -0.783417, -0.787377, -0.783425, -0.78737,  -0.783431, -0.787364, -0.783436,   -0.787359, -0.78344,  -0.787356,
      -0.783443, -0.787354, -0.783445, -0.787352, -0.783446, -0.787352, -0.783445,   -0.787354, -0.783443, -0.787356,
      -0.78344,  -0.787359, -0.783436, -0.787364, -0.783431, -0.78737,  -0.783425,   -0.787377, -0.783417, -0.787386,
      -0.783407, -0.787395, -0.783397, -0.787406, -0.783386, -0.787419, -0.783373,   -0.787432, -0.783358, -0.787448,
      -0.783342, -0.787464, -0.783324, -0.787483, -0.783305, -0.787502, -0.783284,   -0.787523, -0.783263, -0.787547,
      -0.783238, -0.787572, -0.783212, -0.787599, -0.783184, -0.787627, -0.783153,   -0.787658, -0.783121, -0.787692,
      -0.783086, -0.787728, -0.783049, -0.787767, -0.783009, -0.787808, -0.782966,   -0.787852, -0.78292,  -0.787899,
      -0.782871, -0.78795,  -0.782818, -0.788005, -0.782762, -0.788063, -0.782701,   -0.788126, -0.782635, -0.788194,
      -0.782565, -0.788267, -0.782489, -0.788345, -0.782407, -0.788431, -0.782318,   -0.788523, -0.782222, -0.788622,
      -0.782119, -0.788731, -0.782006, -0.78885,  -0.781882, -0.788979, -0.781747,   -0.78912,  -0.781599, -0.789276,
      -0.781436, -0.789448, -0.781254, -0.789638, -0.781054, -0.78985,  -0.78083,    -0.790087, -0.780579, -0.790354,
      -0.780295, -0.790657, -0.779972, -0.791002, -0.779601, -0.7914,   -0.779173,   -0.791863, -0.778672, -0.792407,
      -0.778078, -0.793058, -0.777363, -0.793846, -0.776489, -0.794822, -0.775394,   -0.796059, -0.773985, -0.797678,
      -0.772105, -0.799886, -0.769474, -0.803074, -0.765533, -0.80807,  -0.758993,   -0.817002, -0.746064, -0.837393,
      -0.709068, -0.925972},
     {0,         0.92094,   0.718982,  0.822895,  0.764714,  0.794748,  0.784208,    0.780606,  0.794489,  0.773395,
      0.799119,  0.770985,  0.799616,  0.772113,  0.797155,  0.775615,  0.792907,    0.780318,  0.788028,  0.785111,
      0.783553,  0.78907,   0.780267,  0.791571,  0.778619,  0.792348,  0.778687,    0.7915,    0.780212,  0.789429,
      0.78268,   0.786725,  0.785454,  0.78404,   0.787906,  0.781947,  0.789542,    0.780836,  0.79009,   0.780853,
      0.789535,  0.781889,  0.788099,  0.783627,  0.786173,  0.785623,  0.784223,    0.787416,  0.782684,  0.788621,
      0.78187,   0.78901,   0.781913,  0.788552,  0.782747,  0.787403,  0.784135,    0.785864,  0.785731,  0.784305,
      0.787162,  0.783081,  0.788114,  0.782451,  0.788393,  0.782529,  0.787972,    0.783263,  0.786977,  0.784455,
      0.785661,  0.785813,  0.78434,   0.787022,  0.783315,  0.787808,  0.782809,    0.788009,  0.782921,  0.787598,
      0.783602,  0.786692,  0.784676,  0.785514,  0.785886,  0.784344,  0.786947,    0.783452,  0.78762,   0.783037,
      0.787758,  0.783181,  0.787345,  0.783837,  0.786488,  0.784842,  0.785394,    0.785957,  0.784325,  0.786919,
      0.783526,  0.787509,  0.783178,  0.787597,  0.783355,  0.787169,  0.784007,    0.786334,  0.784975,  0.78529,
      0.786031,  0.784284,  0.786927,  0.78355,   0.787457,  0.783256,  0.7875,      0.783467,  0.787048,  0.78413,
      0.786213,  0.785088,  0.78519,   0.786115,  0.78422,   0.78697,   0.78353,     0.787454,  0.78328,   0.787454,
      0.78353,   0.78697,   0.78422,   0.786115,  0.78519,   0.785088,  0.786213,    0.78413,   0.787048,  0.783467,
      0.7875,    0.783256,  0.787457,  0.78355,   0.786927,  0.784284,  0.786031,    0.78529,   0.784975,  0.786334,
      0.784007,  0.787169,  0.783355,  0.787597,  0.783178,  0.787509,  0.783526,    0.786919,  0.784325,  0.785957,
      0.785394,  0.784842,  0.786488,  0.783837,  0.787345,  0.783181,  0.787758,    0.783037,  0.78762,   0.783452,
      0.786947,  0.784344,  0.785886,  0.785514,  0.784676,  0.786692,  0.783602,    0.787598,  0.782921,  0.788009,
      0.782809,  0.787808,  0.783315,  0.787022,  0.78434,   0.785813,  0.785661,    0.784455,  0.786977,  0.783263,
      0.787972,  0.782529,  0.788393,  0.782451,  0.788114,  0.783081,  0.787162,    0.784305,  0.785731,  0.785864,
      0.784135,  0.787403,  0.782747,  0.788552,  0.781913,  0.78901,   0.78187,     0.788621,  0.782684,  0.787416,
      0.784223,  0.785623,  0.786173,  0.783627,  0.788099,  0.781889,  0.789535,    0.780853,  0.79009,   0.780836,
      0.789542,  0.781947,  0.787906,  0.78404,   0.785454,  0.786725,  0.78268,     0.789429,  0.780212,  0.7915,
      0.778687,  0.792348,  0.778619,  0.791571,  0.780267,  0.78907,   0.783553,    0.785111,  0.788028,  0.780318,
      0.792907,  0.775615,  0.797155,  0.772113,  0.799616,  0.770985,  0.799119,    0.773395,  0.794489,  0.780606,
      0.784208,  0.794748,  0.764714,  0.822895,  0.718982,  0.92094,   1.50312e-14, -0.92094,  -0.718982, -0.822895,
      -0.764714, -0.794748, -0.784208, -0.780606, -0.794489, -0.773395, -0.799119,   -0.770985, -0.799616, -0.772113,
      -0.797155, -0.775615, -0.792907, -0.780318, -0.788028, -0.785111, -0.783553,   -0.78907,  -0.780267, -0.791571,
      -0.778619, -0.792348, -0.778687, -0.7915,   -0.780212, -0.789429, -0.78268,    -0.786725, -0.785454, -0.78404,
      -0.787906, -0.781947, -0.789542, -0.780836, -0.79009,  -0.780853, -0.789535,   -0.781889, -0.788099, -0.783627,
      -0.786173, -0.785623, -0.784223, -0.787416, -0.782684, -0.788621, -0.78187,    -0.78901,  -0.781913, -0.788552,
      -0.782747, -0.787403, -0.784135, -0.785864, -0.785731, -0.784305, -0.787162,   -0.783081, -0.788114, -0.782451,
      -0.788393, -0.782529, -0.787972, -0.783263, -0.786977, -0.784455, -0.785661,   -0.785813, -0.78434,  -0.787022,
      -0.783315, -0.787808, -0.782809, -0.788009, -0.782921, -0.787598, -0.783602,   -0.786692, -0.784676, -0.785514,
      -0.785886, -0.784344, -0.786947, -0.783452, -0.78762,  -0.783037, -0.787758,   -0.783181, -0.787345, -0.783837,
      -0.786488, -0.784842, -0.785394, -0.785957, -0.784325, -0.786919, -0.783526,   -0.787509, -0.783178, -0.787597,
      -0.783355, -0.787169, -0.784007, -0.786334, -0.784975, -0.78529,  -0.786031,   -0.784284, -0.786927, -0.78355,
      -0.787457, -0.783256, -0.7875,   -0.783467, -0.787048, -0.78413,  -0.786213,   -0.785088, -0.78519,  -0.786115,
      -0.78422,  -0.78697,  -0.78353,  -0.787454, -0.78328,  -0.787454, -0.78353,    -0.78697,  -0.78422,  -0.786115,
      -0.78519,  -0.785088, -0.786213, -0.78413,  -0.787048, -0.783467, -0.7875,     -0.783256, -0.787457, -0.78355,
      -0.786927, -0.784284, -0.786031, -0.78529,  -0.784975, -0.786334, -0.784007,   -0.787169, -0.783355, -0.787597,
      -0.783178, -0.787509, -0.783526, -0.786919, -0.784325, -0.785957, -0.785394,   -0.784842, -0.786488, -0.783837,
      -0.787345, -0.783181, -0.787758, -0.783037, -0.78762,  -0.783452, -0.786947,   -0.784344, -0.785886, -0.785514,
      -0.784676, -0.786692, -0.783602, -0.787598, -0.782921, -0.788009, -0.782809,   -0.787808, -0.783315, -0.787022,
      -0.78434,  -0.785813, -0.785661, -0.784455, -0.786977, -0.783263, -0.787972,   -0.782529, -0.788393, -0.782451,
      -0.788114, -0.783081, -0.787162, -0.784305, -0.785731, -0.785864, -0.784135,   -0.787403, -0.782747, -0.788552,
      -0.781913, -0.78901,  -0.78187,  -0.788621, -0.782684, -0.787416, -0.784223,   -0.785623, -0.786173, -0.783627,
      -0.788099, -0.781889, -0.789535, -0.780853, -0.79009,  -0.780836, -0.789542,   -0.781947, -0.787906, -0.78404,
      -0.785454, -0.786725, -0.78268,  -0.789429, -0.780212, -0.7915,   -0.778687,   -0.792348, -0.778619, -0.791571,
      -0.780267, -0.78907,  -0.783553, -0.785111, -0.788028, -0.780318, -0.792907,   -0.775615, -0.797155, -0.772113,
      -0.799616, -0.770985, -0.799119, -0.773395, -0.794489, -0.780606, -0.784208,   -0.794748, -0.764714, -0.822895,
      -0.718982, -0.92094},
     {0,         0.880351,  0.788852,  0.7426,    0.835162,  0.749547,  0.797874,    0.794827,  0.763363,  0.807917,
      0.772209,  0.785165,  0.79674,   0.769682,  0.797826,  0.78143,   0.780148,    0.796406,  0.774292,  0.791495,
      0.786623,  0.778097,  0.794856,  0.778351,  0.786952,  0.789633,  0.77778,     0.792596,  0.781959,  0.783714,
      0.791086,  0.778624,  0.790005,  0.785002,  0.78163,   0.791327,  0.78022,     0.787413,  0.787342,  0.780601,
      0.79064,   0.782214,  0.785101,  0.788887,  0.780506,  0.78931,   0.784287,    0.783284,  0.789609,  0.78117,
      0.787625,  0.786164,  0.782102,  0.789565,  0.782374,  0.785866,  0.787629,    0.781611,  0.788882,  0.783872,
      0.784285,  0.788543,  0.781778,  0.787744,  0.785415,  0.78308,   0.788849,    0.782495,  0.786372,  0.786777,
      0.782376,  0.788574,  0.783594,  0.784989,  0.78778,   0.782226,  0.787821,    0.784877,  0.783801,  0.788309,
      0.782596,  0.786744,  0.786133,  0.782968,  0.788327,  0.783389,  0.785532,    0.787178,  0.782589,  0.78787,
      0.784453,  0.784381,  0.787865,  0.78269,   0.787039,  0.785607,  0.783462,    0.788111,  0.783228,  0.785984,
      0.786667,  0.782906,  0.787901,  0.784097,  0.78488,   0.787474,  0.782783,    0.787288,  0.785147,  0.783902,
      0.78791,   0.783094,  0.786382,  0.786207,  0.7832,    0.787919,  0.783781,    0.785334,  0.787109,  0.782877,
      0.787508,  0.784724,  0.784315,  0.787712,  0.78298,   0.786751,  0.78577,     0.783486,  0.787924,  0.783486,
      0.78577,   0.786751,  0.78298,   0.787712,  0.784315,  0.784724,  0.787508,    0.782877,  0.787109,  0.785334,
      0.783781,  0.787919,  0.7832,    0.786207,  0.786382,  0.783094,  0.78791,     0.783902,  0.785147,  0.787288,
      0.782783,  0.787474,  0.78488,   0.784097,  0.787901,  0.782906,  0.786667,    0.785984,  0.783228,  0.788111,
      0.783462,  0.785607,  0.787039,  0.78269,   0.787865,  0.784381,  0.784453,    0.78787,   0.782589,  0.787178,
      0.785532,  0.783389,  0.788327,  0.782968,  0.786133,  0.786744,  0.782596,    0.788309,  0.783801,  0.784877,
      0.787821,  0.782226,  0.78778,   0.784989,  0.783594,  0.788574,  0.782376,    0.786777,  0.786372,  0.782495,
      0.788849,  0.78308,   0.785415,  0.787744,  0.781778,  0.788543,  0.784285,    0.783872,  0.788882,  0.781611,
      0.787629,  0.785866,  0.782374,  0.789565,  0.782102,  0.786164,  0.787625,    0.78117,   0.789609,  0.783284,
      0.784287,  0.78931,   0.780506,  0.788887,  0.785101,  0.782214,  0.79064,     0.780601,  0.787342,  0.787413,
      0.78022,   0.791327,  0.78163,   0.785002,  0.790005,  0.778624,  0.791086,    0.783714,  0.781959,  0.792596,
      0.77778,   0.789633,  0.786952,  0.778351,  0.794856,  0.778097,  0.786623,    0.791495,  0.774292,  0.796406,
      0.780148,  0.78143,   0.797826,  0.769682,  0.79674,   0.785165,  0.772209,    0.807917,  0.763363,  0.794827,
      0.797874,  0.749547,  0.835162,  0.7426,    0.788852,  0.880351,  1.29652e-14, -0.880351, -0.788852, -0.7426,
      -0.835162, -0.749547, -0.797874, -0.794827, -0.763363, -0.807917, -0.772209,   -0.785165, -0.79674,  -0.769682,
      -0.797826, -0.78143,  -0.780148, -0.796406, -0.774292, -0.791495, -0.786623,   -0.778097, -0.794856, -0.778351,
      -0.786952, -0.789633, -0.77778,  -0.792596, -0.781959, -0.783714, -0.791086,   -0.778624, -0.790005, -0.785002,
      -0.78163,  -0.791327, -0.78022,  -0.787413, -0.787342, -0.780601, -0.79064,    -0.782214, -0.785101, -0.788887,
      -0.780506, -0.78931,  -0.784287, -0.783284, -0.789609, -0.78117,  -0.787625,   -0.786164, -0.782102, -0.789565,
      -0.782374, -0.785866, -0.787629, -0.781611, -0.788882, -0.783872, -0.784285,   -0.788543, -0.781778, -0.787744,
      -0.785415, -0.78308,  -0.788849, -0.782495, -0.786372, -0.786777, -0.782376,   -0.788574, -0.783594, -0.784989,
      -0.78778,  -0.782226, -0.787821, -0.784877, -0.783801, -0.788309, -0.782596,   -0.786744, -0.786133, -0.782968,
      -0.788327, -0.783389, -0.785532, -0.787178, -0.782589, -0.78787,  -0.784453,   -0.784381, -0.787865, -0.78269,
      -0.787039, -0.785607, -0.783462, -0.788111, -0.783228, -0.785984, -0.786667,   -0.782906, -0.787901, -0.784097,
      -0.78488,  -0.787474, -0.782783, -0.787288, -0.785147, -0.783902, -0.78791,    -0.783094, -0.786382, -0.786207,
      -0.7832,   -0.787919, -0.783781, -0.785334, -0.787109, -0.782877, -0.787508,   -0.784724, -0.784315, -0.787712,
      -0.78298,  -0.786751, -0.78577,  -0.783486, -0.787924, -0.783486, -0.78577,    -0.786751, -0.78298,  -0.787712,
      -0.784315, -0.784724, -0.787508, -0.782877, -0.787109, -0.785334, -0.783781,   -0.787919, -0.7832,   -0.786207,
      -0.786382, -0.783094, -0.78791,  -0.783902, -0.785147, -0.787288, -0.782783,   -0.787474, -0.78488,  -0.784097,
      -0.787901, -0.782906, -0.786667, -0.785984, -0.783228, -0.788111, -0.783462,   -0.785607, -0.787039, -0.78269,
      -0.787865, -0.784381, -0.784453, -0.78787,  -0.782589, -0.787178, -0.785532,   -0.783389, -0.788327, -0.782968,
      -0.786133, -0.786744, -0.782596, -0.788309, -0.783801, -0.784877, -0.787821,   -0.782226, -0.78778,  -0.784989,
      -0.783594, -0.788574, -0.782376, -0.786777, -0.786372, -0.782495, -0.788849,   -0.78308,  -0.785415, -0.787744,
      -0.781778, -0.788543, -0.784285, -0.783872, -0.788882, -0.781611, -0.787629,   -0.785866, -0.782374, -0.789565,
      -0.782102, -0.786164, -0.787625, -0.78117,  -0.789609, -0.783284, -0.784287,   -0.78931,  -0.780506, -0.788887,
      -0.785101, -0.782214, -0.79064,  -0.780601, -0.787342, -0.787413, -0.78022,    -0.791327, -0.78163,  -0.785002,
      -0.790005, -0.778624, -0.791086, -0.783714, -0.781959, -0.792596, -0.77778,    -0.789633, -0.786952, -0.778351,
      -0.794856, -0.778097, -0.786623, -0.791495, -0.774292, -0.796406, -0.780148,   -0.78143,  -0.797826, -0.769682,
      -0.79674,  -0.785165, -0.772209, -0.807917, -0.763363, -0.794827, -0.797874,   -0.749547, -0.835162, -0.7426,
      -0.788852, -0.880351},
     {0,         0.811001,  0.871931,  0.71025,   0.796069,  0.823507,  0.748413,    0.787284,  0.811786,  0.762476,
      0.783012,  0.806177,  0.770105,  0.780568,  0.802594,  0.775073,  0.779071,    0.799908,  0.778655,  0.778154,
      0.79769,   0.7814,    0.77764,   0.795751,  0.783577,  0.777425,  0.793997,    0.785332,  0.777446,  0.792381,
      0.786754,  0.777661,  0.79088,   0.787897,  0.778033,  0.789483,  0.788796,    0.778537,  0.788188,  0.78948,
      0.779146,  0.786997,  0.789968,  0.77984,   0.785913,  0.790277,  0.780597,    0.78494,   0.790424,  0.781397,
      0.784083,  0.790423,  0.782222,  0.783346,  0.790288,  0.783053,  0.782731,    0.790035,  0.783874,  0.78224,
      0.78968,   0.784669,  0.781873,  0.789237,  0.785423,  0.781627,  0.788723,    0.786123,  0.781501,  0.788154,
      0.786757,  0.781489,  0.787546,  0.787316,  0.781583,  0.786916,  0.78779,     0.781776,  0.786278,  0.788174,
      0.782057,  0.785648,  0.788463,  0.782416,  0.785041,  0.788655,  0.782841,    0.78447,   0.78875,   0.783319,
      0.783947,  0.788749,  0.783836,  0.783484,  0.788656,  0.784379,  0.783087,    0.788476,  0.784932,  0.782767,
      0.788217,  0.785483,  0.782529,  0.787886,  0.786019,  0.782375,  0.787494,    0.786525,  0.782309,  0.787051,
      0.786989,  0.782329,  0.786571,  0.787403,  0.782435,  0.786065,  0.787755,    0.782621,  0.785545,  0.788037,
      0.782884,  0.785027,  0.788243,  0.783214,  0.784523,  0.788369,  0.783604,    0.784044,  0.788411,  0.784044,
      0.783604,  0.788369,  0.784523,  0.783214,  0.788243,  0.785027,  0.782884,    0.788037,  0.785545,  0.782621,
      0.787755,  0.786065,  0.782435,  0.787403,  0.786571,  0.782329,  0.786989,    0.787051,  0.782309,  0.786525,
      0.787494,  0.782375,  0.786019,  0.787886,  0.782529,  0.785483,  0.788217,    0.782767,  0.784932,  0.788476,
      0.783087,  0.784379,  0.788656,  0.783484,  0.783836,  0.788749,  0.783947,    0.783319,  0.78875,   0.78447,
      0.782841,  0.788655,  0.785041,  0.782416,  0.788463,  0.785648,  0.782057,    0.788174,  0.786278,  0.781776,
      0.78779,   0.786916,  0.781583,  0.787316,  0.787546,  0.781489,  0.786757,    0.788154,  0.781501,  0.786123,
      0.788723,  0.781627,  0.785423,  0.789237,  0.781873,  0.784669,  0.78968,     0.78224,   0.783874,  0.790035,
      0.782731,  0.783053,  0.790288,  0.783346,  0.782222,  0.790423,  0.784083,    0.781397,  0.790424,  0.78494,
      0.780597,  0.790277,  0.785913,  0.77984,   0.789968,  0.786997,  0.779146,    0.78948,   0.788188,  0.778537,
      0.788796,  0.789483,  0.778033,  0.787897,  0.79088,   0.777661,  0.786754,    0.792381,  0.777446,  0.785332,
      0.793997,  0.777425,  0.783577,  0.795751,  0.77764,   0.7814,    0.79769,     0.778154,  0.778655,  0.799908,
      0.779071,  0.775073,  0.802594,  0.780568,  0.770105,  0.806177,  0.783012,    0.762476,  0.811786,  0.787284,
      0.748413,  0.823507,  0.796069,  0.71025,   0.871931,  0.811001,  1.10479e-14, -0.811001, -0.871931, -0.71025,
      -0.796069, -0.823507, -0.748413, -0.787284, -0.811786, -0.762476, -0.783012,   -0.806177, -0.770105, -0.780568,
      -0.802594, -0.775073, -0.779071, -0.799908, -0.778655, -0.778154, -0.79769,    -0.7814,   -0.77764,  -0.795751,
      -0.783577, -0.777425, -0.793997, -0.785332, -0.777446, -0.792381, -0.786754,   -0.777661, -0.79088,  -0.787897,
      -0.778033, -0.789483, -0.788796, -0.778537, -0.788188, -0.78948,  -0.779146,   -0.786997, -0.789968, -0.77984,
      -0.785913, -0.790277, -0.780597, -0.78494,  -0.790424, -0.781397, -0.784083,   -0.790423, -0.782222, -0.783346,
      -0.790288, -0.783053, -0.782731, -0.790035, -0.783874, -0.78224,  -0.78968,    -0.784669, -0.781873, -0.789237,
      -0.785423, -0.781627, -0.788723, -0.786123, -0.781501, -0.788154, -0.786757,   -0.781489, -0.787546, -0.787316,
      -0.781583, -0.786916, -0.78779,  -0.781776, -0.786278, -0.788174, -0.782057,   -0.785648, -0.788463, -0.782416,
      -0.785041, -0.788655, -0.782841, -0.78447,  -0.78875,  -0.783319, -0.783947,   -0.788749, -0.783836, -0.783484,
      -0.788656, -0.784379, -0.783087, -0.788476, -0.784932, -0.782767, -0.788217,   -0.785483, -0.782529, -0.787886,
      -0.786019, -0.782375, -0.787494, -0.786525, -0.782309, -0.787051, -0.786989,   -0.782329, -0.786571, -0.787403,
      -0.782435, -0.786065, -0.787755, -0.782621, -0.785545, -0.788037, -0.782884,   -0.785027, -0.788243, -0.783214,
      -0.784523, -0.788369, -0.783604, -0.784044, -0.788411, -0.784044, -0.783604,   -0.788369, -0.784523, -0.783214,
      -0.788243, -0.785027, -0.782884, -0.788037, -0.785545, -0.782621, -0.787755,   -0.786065, -0.782435, -0.787403,
      -0.786571, -0.782329, -0.786989, -0.787051, -0.782309, -0.786525, -0.787494,   -0.782375, -0.786019, -0.787886,
      -0.782529, -0.785483, -0.788217, -0.782767, -0.784932, -0.788476, -0.783087,   -0.784379, -0.788656, -0.783484,
      -0.783836, -0.788749, -0.783947, -0.783319, -0.78875,  -0.78447,  -0.782841,   -0.788655, -0.785041, -0.782416,
      -0.788463, -0.785648, -0.782057, -0.788174, -0.786278, -0.781776, -0.78779,    -0.786916, -0.781583, -0.787316,
      -0.787546, -0.781489, -0.786757, -0.788154, -0.781501, -0.786123, -0.788723,   -0.781627, -0.785423, -0.789237,
      -0.781873, -0.784669, -0.78968,  -0.78224,  -0.783874, -0.790035, -0.782731,   -0.783053, -0.790288, -0.783346,
      -0.782222, -0.790423, -0.784083, -0.781397, -0.790424, -0.78494,  -0.780597,   -0.790277, -0.785913, -0.77984,
      -0.789968, -0.786997, -0.779146, -0.78948,  -0.788188, -0.778537, -0.788796,   -0.789483, -0.778033, -0.787897,
      -0.79088,  -0.777661, -0.786754, -0.792381, -0.777446, -0.785332, -0.793997,   -0.777425, -0.783577, -0.795751,
      -0.77764,  -0.7814,   -0.79769,  -0.778154, -0.778655, -0.799908, -0.779071,   -0.775073, -0.802594, -0.780568,
      -0.770105, -0.806177, -0.783012, -0.762476, -0.811786, -0.787284, -0.748413,   -0.823507, -0.796069, -0.71025,
      -0.871931, -0.811001},
     {0,         0.730034,  0.919528,  0.760778,  0.721685,  0.818896,  0.819127,    0.751862,  0.769222,  0.816083,
      0.789888,  0.758968,  0.788991,  0.806815,  0.776334,  0.76933,   0.797848,    0.796111,  0.771294,  0.779765,
      0.799708,  0.786462,  0.772056,  0.788204,  0.796862,  0.779552,  0.776449,    0.793372,  0.791458,  0.776222,
      0.782344,  0.79488,   0.785558,  0.776415,  0.787819,  0.793203,  0.780864,    0.779287,  0.791463,  0.789474,
      0.778439,  0.783505,  0.792597,  0.785137,  0.77857,   0.787616,  0.791318,    0.781555,  0.780805,  0.790428,
      0.788376,  0.779679,  0.784171,  0.791284,  0.784881,  0.779842,  0.787506,    0.790178,  0.781964,  0.781745,
      0.789795,  0.787677,  0.780453,  0.78461,   0.790447,  0.7847,    0.780669,    0.787452,  0.789422,  0.782219,
      0.782383,  0.789386,  0.787191,  0.780968,  0.784929,  0.789881,  0.784554,    0.781242,  0.787438,  0.788889,
      0.782376,  0.782844,  0.789117,  0.786829,  0.781318,  0.785178,  0.789484,    0.784423,  0.781652,  0.787454,
      0.788498,  0.782464,  0.783193,  0.788944,  0.786545,  0.781557,  0.785387,    0.789205,  0.784297,  0.78195,
      0.787498,  0.788203,  0.782497,  0.783466,  0.788844,  0.78631,   0.781712,    0.785573,  0.789011,  0.784168,
      0.782168,  0.787569,  0.787977,  0.782484,  0.783686,  0.788803,  0.786107,    0.781799,  0.785748,  0.788885,
      0.784028,  0.782323,  0.787669,  0.787803,  0.782426,  0.78387,   0.788817,    0.785923,  0.781827,  0.785923,
      0.788817,  0.78387,   0.782426,  0.787803,  0.787669,  0.782323,  0.784028,    0.788885,  0.785748,  0.781799,
      0.786107,  0.788803,  0.783686,  0.782484,  0.787977,  0.787569,  0.782168,    0.784168,  0.789011,  0.785573,
      0.781712,  0.78631,   0.788844,  0.783466,  0.782497,  0.788203,  0.787498,    0.78195,   0.784297,  0.789205,
      0.785387,  0.781557,  0.786545,  0.788944,  0.783193,  0.782464,  0.788498,    0.787454,  0.781652,  0.784423,
      0.789484,  0.785178,  0.781318,  0.786829,  0.789117,  0.782844,  0.782376,    0.788889,  0.787438,  0.781242,
      0.784554,  0.789881,  0.784929,  0.780968,  0.787191,  0.789386,  0.782383,    0.782219,  0.789422,  0.787452,
      0.780669,  0.7847,    0.790447,  0.78461,   0.780453,  0.787677,  0.789795,    0.781745,  0.781964,  0.790178,
      0.787506,  0.779842,  0.784881,  0.791284,  0.784171,  0.779679,  0.788376,    0.790428,  0.780805,  0.781555,
      0.791318,  0.787616,  0.77857,   0.785137,  0.792597,  0.783505,  0.778439,    0.789474,  0.791463,  0.779287,
      0.780864,  0.793203,  0.787819,  0.776415,  0.785558,  0.79488,   0.782344,    0.776222,  0.791458,  0.793372,
      0.776449,  0.779552,  0.796862,  0.788204,  0.772056,  0.786462,  0.799708,    0.779765,  0.771294,  0.796111,
      0.797848,  0.76933,   0.776334,  0.806815,  0.788991,  0.758968,  0.789888,    0.816083,  0.769222,  0.751862,
      0.819127,  0.818896,  0.721685,  0.760778,  0.919528,  0.730034,  8.77232e-15, -0.730034, -0.919528, -0.760778,
      -0.721685, -0.818896, -0.819127, -0.751862, -0.769222, -0.816083, -0.789888,   -0.758968, -0.788991, -0.806815,
      -0.776334, -0.76933,  -0.797848, -0.796111, -0.771294, -0.779765, -0.799708,   -0.786462, -0.772056, -0.788204,
      -0.796862, -0.779552, -0.776449, -0.793372, -0.791458, -0.776222, -0.782344,   -0.79488,  -0.785558, -0.776415,
      -0.787819, -0.793203, -0.780864, -0.779287, -0.791463, -0.789474, -0.778439,   -0.783505, -0.792597, -0.785137,
      -0.77857,  -0.787616, -0.791318, -0.781555, -0.780805, -0.790428, -0.788376,   -0.779679, -0.784171, -0.791284,
      -0.784881, -0.779842, -0.787506, -0.790178, -0.781964, -0.781745, -0.789795,   -0.787677, -0.780453, -0.78461,
      -0.790447, -0.7847,   -0.780669, -0.787452, -0.789422, -0.782219, -0.782383,   -0.789386, -0.787191, -0.780968,
      -0.784929, -0.789881, -0.784554, -0.781242, -0.787438, -0.788889, -0.782376,   -0.782844, -0.789117, -0.786829,
      -0.781318, -0.785178, -0.789484, -0.784423, -0.781652, -0.787454, -0.788498,   -0.782464, -0.783193, -0.788944,
      -0.786545, -0.781557, -0.785387, -0.789205, -0.784297, -0.78195,  -0.787498,   -0.788203, -0.782497, -0.783466,
      -0.788844, -0.78631,  -0.781712, -0.785573, -0.789011, -0.784168, -0.782168,   -0.787569, -0.787977, -0.782484,
      -0.783686, -0.788803, -0.786107, -0.781799, -0.785748, -0.788885, -0.784028,   -0.782323, -0.787669, -0.787803,
      -0.782426, -0.78387,  -0.788817, -0.785923, -0.781827, -0.785923, -0.788817,   -0.78387,  -0.782426, -0.787803,
      -0.787669, -0.782323, -0.784028, -0.788885, -0.785748, -0.781799, -0.786107,   -0.788803, -0.783686, -0.782484,
      -0.787977, -0.787569, -0.782168, -0.784168, -0.789011, -0.785573, -0.781712,   -0.78631,  -0.788844, -0.783466,
      -0.782497, -0.788203, -0.787498, -0.78195,  -0.784297, -0.789205, -0.785387,   -0.781557, -0.786545, -0.788944,
      -0.783193, -0.782464, -0.788498, -0.787454, -0.781652, -0.784423, -0.789484,   -0.785178, -0.781318, -0.786829,
      -0.789117, -0.782844, -0.782376, -0.788889, -0.787438, -0.781242, -0.784554,   -0.789881, -0.784929, -0.780968,
      -0.787191, -0.789386, -0.782383, -0.782219, -0.789422, -0.787452, -0.780669,   -0.7847,   -0.790447, -0.78461,
      -0.780453, -0.787677, -0.789795, -0.781745, -0.781964, -0.790178, -0.787506,   -0.779842, -0.784881, -0.791284,
      -0.784171, -0.779679, -0.788376, -0.790428, -0.780805, -0.781555, -0.791318,   -0.787616, -0.77857,  -0.785137,
      -0.792597, -0.783505, -0.778439, -0.789474, -0.791463, -0.779287, -0.780864,   -0.793203, -0.787819, -0.776415,
      -0.785558, -0.79488,  -0.782344, -0.776222, -0.791458, -0.793372, -0.776449,   -0.779552, -0.796862, -0.788204,
      -0.772056, -0.786462, -0.799708, -0.779765, -0.771294, -0.796111, -0.797848,   -0.76933,  -0.776334, -0.806815,
      -0.788991, -0.758968, -0.789888, -0.816083, -0.769222, -0.751862, -0.819127,   -0.818896, -0.721685, -0.760778,
      -0.919528, -0.730034},
     {0,         0.644817,  0.920953,  0.843932,  0.718956,  0.739778,  0.822927,    0.825151,  0.764681,  0.75016,
      0.794773,  0.816307,  0.784196,  0.758911,  0.780597,  0.807339,  0.794525,    0.768054,  0.773329,  0.798197,
      0.799218,  0.776971,  0.770857,  0.789742,  0.79977,   0.784739,  0.771941,    0.782859,  0.797333,  0.790573,
      0.775442,  0.778194,  0.79306,   0.793999,  0.780197,  0.776026,  0.788103,    0.794938,  0.785093,  0.776238,
      0.783505,  0.793695,  0.789187,  0.778357,  0.780081,  0.790884,  0.791819,    0.781657,  0.778317,  0.787306,
      0.792687,  0.785305,  0.778328,  0.783788,  0.791855,  0.788509,  0.779883,    0.781049,  0.789705,  0.790661,
      0.782475,  0.77957,   0.786837,  0.791424,  0.785448,  0.779529,  0.78393,     0.790776,  0.788131,  0.780798,
      0.78161,   0.788984,  0.789976,  0.782991,  0.780326,  0.786531,  0.790651,    0.785559,  0.780277,  0.783999,
      0.790095,  0.787914,  0.781386,  0.781948,  0.788512,  0.789554,  0.783337,    0.780799,  0.786314,  0.79016,
      0.785651,  0.780757,  0.78402,   0.789652,  0.787796,  0.781775,  0.782144,    0.788194,  0.789301,  0.78358,
      0.781088,  0.786152,  0.789856,  0.785738,  0.781059,  0.784005,  0.789369,    0.787752,  0.782028,  0.782239,
      0.787979,  0.789171,  0.783752,  0.781244,  0.786024,  0.789689,  0.785824,    0.781228,  0.783956,  0.789205,
      0.787767,  0.782181,  0.782249,  0.787841,  0.789141,  0.783874,  0.781287,    0.785917,  0.789636,  0.785917,
      0.781287,  0.783874,  0.789141,  0.787841,  0.782249,  0.782181,  0.787767,    0.789205,  0.783956,  0.781228,
      0.785824,  0.789689,  0.786024,  0.781244,  0.783752,  0.789171,  0.787979,    0.782239,  0.782028,  0.787752,
      0.789369,  0.784005,  0.781059,  0.785738,  0.789856,  0.786152,  0.781088,    0.78358,   0.789301,  0.788194,
      0.782144,  0.781775,  0.787796,  0.789652,  0.78402,   0.780757,  0.785651,    0.79016,   0.786314,  0.780799,
      0.783337,  0.789554,  0.788512,  0.781948,  0.781386,  0.787914,  0.790095,    0.783999,  0.780277,  0.785559,
      0.790651,  0.786531,  0.780326,  0.782991,  0.789976,  0.788984,  0.78161,     0.780798,  0.788131,  0.790776,
      0.78393,   0.779529,  0.785448,  0.791424,  0.786837,  0.77957,   0.782475,    0.790661,  0.789705,  0.781049,
      0.779883,  0.788509,  0.791855,  0.783788,  0.778328,  0.785305,  0.792687,    0.787306,  0.778317,  0.781657,
      0.791819,  0.790884,  0.780081,  0.778357,  0.789187,  0.793695,  0.783505,    0.776238,  0.785093,  0.794938,
      0.788103,  0.776026,  0.780197,  0.793999,  0.79306,   0.778194,  0.775442,    0.790573,  0.797333,  0.782859,
      0.771941,  0.784739,  0.79977,   0.789742,  0.770857,  0.776971,  0.799218,    0.798197,  0.773329,  0.768054,
      0.794525,  0.807339,  0.780597,  0.758911,  0.784196,  0.816307,  0.794773,    0.75016,   0.764681,  0.825151,
      0.822927,  0.739778,  0.718956,  0.843932,  0.920953,  0.644817,  7.38528e-15, -0.644817, -0.920953, -0.843932,
      -0.718956, -0.739778, -0.822927, -0.825151, -0.764681, -0.75016,  -0.794773,   -0.816307, -0.784196, -0.758911,
      -0.780597, -0.807339, -0.794525, -0.768054, -0.773329, -0.798197, -0.799218,   -0.776971, -0.770857, -0.789742,
      -0.79977,  -0.784739, -0.771941, -0.782859, -0.797333, -0.790573, -0.775442,   -0.778194, -0.79306,  -0.793999,
      -0.780197, -0.776026, -0.788103, -0.794938, -0.785093, -0.776238, -0.783505,   -0.793695, -0.789187, -0.778357,
      -0.780081, -0.790884, -0.791819, -0.781657, -0.778317, -0.787306, -0.792687,   -0.785305, -0.778328, -0.783788,
      -0.791855, -0.788509, -0.779883, -0.781049, -0.789705, -0.790661, -0.782475,   -0.77957,  -0.786837, -0.791424,
      -0.785448, -0.779529, -0.78393,  -0.790776, -0.788131, -0.780798, -0.78161,    -0.788984, -0.789976, -0.782991,
      -0.780326, -0.786531, -0.790651, -0.785559, -0.780277, -0.783999, -0.790095,   -0.787914, -0.781386, -0.781948,
      -0.788512, -0.789554, -0.783337, -0.780799, -0.786314, -0.79016,  -0.785651,   -0.780757, -0.78402,  -0.789652,
      -0.787796, -0.781775, -0.782144, -0.788194, -0.789301, -0.78358,  -0.781088,   -0.786152, -0.789856, -0.785738,
      -0.781059, -0.784005, -0.789369, -0.787752, -0.782028, -0.782239, -0.787979,   -0.789171, -0.783752, -0.781244,
      -0.786024, -0.789689, -0.785824, -0.781228, -0.783956, -0.789205, -0.787767,   -0.782181, -0.782249, -0.787841,
      -0.789141, -0.783874, -0.781287, -0.785917, -0.789636, -0.785917, -0.781287,   -0.783874, -0.789141, -0.787841,
      -0.782249, -0.782181, -0.787767, -0.789205, -0.783956, -0.781228, -0.785824,   -0.789689, -0.786024, -0.781244,
      -0.783752, -0.789171, -0.787979, -0.782239, -0.782028, -0.787752, -0.789369,   -0.784005, -0.781059, -0.785738,
      -0.789856, -0.786152, -0.781088, -0.78358,  -0.789301, -0.788194, -0.782144,   -0.781775, -0.787796, -0.789652,
      -0.78402,  -0.780757, -0.785651, -0.79016,  -0.786314, -0.780799, -0.783337,   -0.789554, -0.788512, -0.781948,
      -0.781386, -0.787914, -0.790095, -0.783999, -0.780277, -0.785559, -0.790651,   -0.786531, -0.780326, -0.782991,
      -0.789976, -0.788984, -0.78161,  -0.780798, -0.788131, -0.790776, -0.78393,    -0.779529, -0.785448, -0.791424,
      -0.786837, -0.77957,  -0.782475, -0.790661, -0.789705, -0.781049, -0.779883,   -0.788509, -0.791855, -0.783788,
      -0.778328, -0.785305, -0.792687, -0.787306, -0.778317, -0.781657, -0.791819,   -0.790884, -0.780081, -0.778357,
      -0.789187, -0.793695, -0.783505, -0.776238, -0.785093, -0.794938, -0.788103,   -0.776026, -0.780197, -0.793999,
      -0.79306,  -0.778194, -0.775442, -0.790573, -0.797333, -0.782859, -0.771941,   -0.784739, -0.79977,  -0.789742,
      -0.770857, -0.776971, -0.799218, -0.798197, -0.773329, -0.768054, -0.794525,   -0.807339, -0.780597, -0.758911,
      -0.784196, -0.816307, -0.794773, -0.75016,  -0.764681, -0.825151, -0.822927,   -0.739778, -0.718956, -0.843932,
      -0.920953, -0.644817},
     {0,         0.555053,  0.877004,  0.910508,  0.79388,   0.711991,  0.738391,    0.810883,  0.836455,  0.797197,
      0.751813,  0.754133,  0.793172,  0.817032,  0.799626,  0.767378,  0.760857,    0.784829,  0.80688,   0.800477,
      0.776279,  0.765496,  0.780084,  0.799968,  0.800304,  0.782232,  0.769414,    0.777279,  0.794657,  0.799405,
      0.786465,  0.772995,  0.775751,  0.790358,  0.797972,  0.789495,  0.776346,    0.775167,  0.786834,  0.79615,
      0.791577,  0.779469,  0.775319,  0.783983,  0.794064,  0.792862,  0.782331,    0.776053,  0.781756,  0.791833,
      0.793458,  0.784879,  0.777239,  0.780127,  0.789566,  0.793456,  0.787063,    0.778756,  0.77907,   0.787365,
      0.792947,  0.78884,   0.780489,  0.778556,  0.785324,  0.792021,  0.790178,    0.782326,  0.77854,   0.783522,
      0.790773,  0.79106,   0.784165,  0.77897,   0.782027,  0.789302,  0.791489,    0.785908,  0.779777,  0.780888,
      0.787707,  0.791483,  0.787469,  0.780886,  0.780136,  0.786086,  0.791077,    0.788778,  0.782211,  0.779785,
      0.784531,  0.790324,  0.789778,  0.783664,  0.779827,  0.783127,  0.789286,    0.79043,   0.785152,  0.780237,
      0.781946,  0.788041,  0.790716,  0.786588,  0.780976,  0.781047,  0.786671,    0.790634,  0.78789,   0.781984,
      0.780472,  0.78526,   0.7902,    0.788984,  0.783194,  0.780245,  0.783895,    0.789453,  0.789811,  0.784527,
      0.780372,  0.782656,  0.788443,  0.790326,  0.785902,  0.78084,   0.781617,    0.787234,  0.7905,    0.787234,
      0.781617,  0.78084,   0.785902,  0.790326,  0.788443,  0.782656,  0.780372,    0.784527,  0.789811,  0.789453,
      0.783895,  0.780245,  0.783194,  0.788984,  0.7902,    0.78526,   0.780472,    0.781984,  0.78789,   0.790634,
      0.786671,  0.781047,  0.780976,  0.786588,  0.790716,  0.788041,  0.781946,    0.780237,  0.785152,  0.79043,
      0.789286,  0.783127,  0.779827,  0.783664,  0.789778,  0.790324,  0.784531,    0.779785,  0.782211,  0.788778,
      0.791077,  0.786086,  0.780136,  0.780886,  0.787469,  0.791483,  0.787707,    0.780888,  0.779777,  0.785908,
      0.791489,  0.789302,  0.782027,  0.77897,   0.784165,  0.79106,   0.790773,    0.783522,  0.77854,   0.782326,
      0.790178,  0.792021,  0.785324,  0.778556,  0.780489,  0.78884,   0.792947,    0.787365,  0.77907,   0.778756,
      0.787063,  0.793456,  0.789566,  0.780127,  0.777239,  0.784879,  0.793458,    0.791833,  0.781756,  0.776053,
      0.782331,  0.792862,  0.794064,  0.783983,  0.775319,  0.779469,  0.791577,    0.79615,   0.786834,  0.775167,
      0.776346,  0.789495,  0.797972,  0.790358,  0.775751,  0.772995,  0.786465,    0.799405,  0.794657,  0.777279,
      0.769414,  0.782232,  0.800304,  0.799968,  0.780084,  0.765496,  0.776279,    0.800477,  0.80688,   0.784829,
      0.760857,  0.767378,  0.799626,  0.817032,  0.793172,  0.754133,  0.751813,    0.797197,  0.836455,  0.810883,
      0.738391,  0.711991,  0.79388,   0.910508,  0.877004,  0.555053,  6.43068e-15, -0.555053, -0.877004, -0.910508,
      -0.79388,  -0.711991, -0.738391, -0.810883, -0.836455, -0.797197, -0.751813,   -0.754133, -0.793172, -0.817032,
      -0.799626, -0.767378, -0.760857, -0.784829, -0.80688,  -0.800477, -0.776279,   -0.765496, -0.780084, -0.799968,
      -0.800304, -0.782232, -0.769414, -0.777279, -0.794657, -0.799405, -0.786465,   -0.772995, -0.775751, -0.790358,
      -0.797972, -0.789495, -0.776346, -0.775167, -0.786834, -0.79615,  -0.791577,   -0.779469, -0.775319, -0.783983,
      -0.794064, -0.792862, -0.782331, -0.776053, -0.781756, -0.791833, -0.793458,   -0.784879, -0.777239, -0.780127,
      -0.789566, -0.793456, -0.787063, -0.778756, -0.77907,  -0.787365, -0.792947,   -0.78884,  -0.780489, -0.778556,
      -0.785324, -0.792021, -0.790178, -0.782326, -0.77854,  -0.783522, -0.790773,   -0.79106,  -0.784165, -0.77897,
      -0.782027, -0.789302, -0.791489, -0.785908, -0.779777, -0.780888, -0.787707,   -0.791483, -0.787469, -0.780886,
      -0.780136, -0.786086, -0.791077, -0.788778, -0.782211, -0.779785, -0.784531,   -0.790324, -0.789778, -0.783664,
      -0.779827, -0.783127, -0.789286, -0.79043,  -0.785152, -0.780237, -0.781946,   -0.788041, -0.790716, -0.786588,
      -0.780976, -0.781047, -0.786671, -0.790634, -0.78789,  -0.781984, -0.780472,   -0.78526,  -0.7902,   -0.788984,
      -0.783194, -0.780245, -0.783895, -0.789453, -0.789811, -0.784527, -0.780372,   -0.782656, -0.788443, -0.790326,
      -0.785902, -0.78084,  -0.781617, -0.787234, -0.7905,   -0.787234, -0.781617,   -0.78084,  -0.785902, -0.790326,
      -0.788443, -0.782656, -0.780372, -0.784527, -0.789811, -0.789453, -0.783895,   -0.780245, -0.783194, -0.788984,
      -0.7902,   -0.78526,  -0.780472, -0.781984, -0.78789,  -0.790634, -0.786671,   -0.781047, -0.780976, -0.786588,
      -0.790716, -0.788041, -0.781946, -0.780237, -0.785152, -0.79043,  -0.789286,   -0.783127, -0.779827, -0.783664,
      -0.789778, -0.790324, -0.784531, -0.779785, -0.782211, -0.788778, -0.791077,   -0.786086, -0.780136, -0.780886,
      -0.787469, -0.791483, -0.787707, -0.780888, -0.779777, -0.785908, -0.791489,   -0.789302, -0.782027, -0.77897,
      -0.784165, -0.79106,  -0.790773, -0.783522, -0.77854,  -0.782326, -0.790178,   -0.792021, -0.785324, -0.778556,
      -0.780489, -0.78884,  -0.792947, -0.787365, -0.77907,  -0.778756, -0.787063,   -0.793456, -0.789566, -0.780127,
      -0.777239, -0.784879, -0.793458, -0.791833, -0.781756, -0.776053, -0.782331,   -0.792862, -0.794064, -0.783983,
      -0.775319, -0.779469, -0.791577, -0.79615,  -0.786834, -0.775167, -0.776346,   -0.789495, -0.797972, -0.790358,
      -0.775751, -0.772995, -0.786465, -0.799405, -0.794657, -0.777279, -0.769414,   -0.782232, -0.800304, -0.799968,
      -0.780084, -0.765496, -0.776279, -0.800477, -0.80688,  -0.784829, -0.760857,   -0.767378, -0.799626, -0.817032,
      -0.793172, -0.754133, -0.751813, -0.797197, -0.836455, -0.810883, -0.738391,   -0.711991, -0.79388,  -0.910508,
      -0.877004, -0.555053},
     {0,         0.475689,  0.805571,  0.924778,  0.876724,  0.771941,  0.711448,    0.729355,  0.790214,  0.83384,
      0.827479,  0.785997,  0.750766,  0.750977,  0.78123,   0.811182,  0.814779,    0.792037,  0.765895,  0.759742,
      0.776995,  0.80013,   0.808069,  0.79507,   0.774461,  0.765256,  0.774822,    0.793214,  0.803306,  0.796589,
      0.780203,  0.769516,  0.773822,  0.788356,  0.799403,  0.797161,  0.784366,    0.773153,  0.773612,  0.784763,
      0.795976,  0.797058,  0.787473,  0.776403,  0.773989,  0.782079,  0.792883,    0.796441,  0.789779,  0.779353,
      0.774819,  0.780118,  0.790071,  0.795421,  0.791421,  0.782026,  0.776003,    0.778771,  0.787536,  0.794093,
      0.79249,   0.784418,  0.777456,  0.777966,  0.785292,  0.792538,  0.793047,    0.786509,  0.779096,  0.777644,
      0.78336,   0.790831,  0.793147,  0.788279,  0.780851,  0.777754,  0.78176,     0.789048,  0.792842,  0.789706,
      0.782648,  0.778243,  0.780511,  0.787256,  0.792184,  0.790773,  0.784418,    0.779056,  0.779626,  0.785524,
      0.791231,  0.791476,  0.786098,  0.780136,  0.779108,  0.783911,  0.790041,    0.791812,  0.787629,  0.78142,
      0.778952,  0.782476,  0.788677,  0.791791,  0.788958,  0.782847,  0.779145,    0.781266,  0.787205,  0.791433,
      0.79004,   0.784349,  0.779662,  0.780321,  0.785689,  0.790766,  0.79084,     0.785861,  0.78047,   0.779673,
      0.784196,  0.789826,  0.79133,   0.787319,  0.781529,  0.779343,  0.78279,     0.78866,   0.791495,  0.78866,
      0.78279,   0.779343,  0.781529,  0.787319,  0.79133,   0.789826,  0.784196,    0.779673,  0.78047,   0.785861,
      0.79084,   0.790766,  0.785689,  0.780321,  0.779662,  0.784349,  0.79004,     0.791433,  0.787205,  0.781266,
      0.779145,  0.782847,  0.788958,  0.791791,  0.788677,  0.782476,  0.778952,    0.78142,   0.787629,  0.791812,
      0.790041,  0.783911,  0.779108,  0.780136,  0.786098,  0.791476,  0.791231,    0.785524,  0.779626,  0.779056,
      0.784418,  0.790773,  0.792184,  0.787256,  0.780511,  0.778243,  0.782648,    0.789706,  0.792842,  0.789048,
      0.78176,   0.777754,  0.780851,  0.788279,  0.793147,  0.790831,  0.78336,     0.777644,  0.779096,  0.786509,
      0.793047,  0.792538,  0.785292,  0.777966,  0.777456,  0.784418,  0.79249,     0.794093,  0.787536,  0.778771,
      0.776003,  0.782026,  0.791421,  0.795421,  0.790071,  0.780118,  0.774819,    0.779353,  0.789779,  0.796441,
      0.792883,  0.782079,  0.773989,  0.776403,  0.787473,  0.797058,  0.795976,    0.784763,  0.773612,  0.773153,
      0.784366,  0.797161,  0.799403,  0.788356,  0.773822,  0.769516,  0.780203,    0.796589,  0.803306,  0.793214,
      0.774822,  0.765256,  0.774461,  0.79507,   0.808069,  0.80013,   0.776995,    0.759742,  0.765895,  0.792037,
      0.814779,  0.811182,  0.78123,   0.750977,  0.750766,  0.785997,  0.827479,    0.83384,   0.790214,  0.729355,
      0.711448,  0.771941,  0.876724,  0.924778,  0.805571,  0.475689,  5.48366e-15, -0.475689, -0.805571, -0.924778,
      -0.876724, -0.771941, -0.711448, -0.729355, -0.790214, -0.83384,  -0.827479,   -0.785997, -0.750766, -0.750977,
      -0.78123,  -0.811182, -0.814779, -0.792037, -0.765895, -0.759742, -0.776995,   -0.80013,  -0.808069, -0.79507,
      -0.774461, -0.765256, -0.774822, -0.793214, -0.803306, -0.796589, -0.780203,   -0.769516, -0.773822, -0.788356,
      -0.799403, -0.797161, -0.784366, -0.773153, -0.773612, -0.784763, -0.795976,   -0.797058, -0.787473, -0.776403,
      -0.773989, -0.782079, -0.792883, -0.796441, -0.789779, -0.779353, -0.774819,   -0.780118, -0.790071, -0.795421,
      -0.791421, -0.782026, -0.776003, -0.778771, -0.787536, -0.794093, -0.79249,    -0.784418, -0.777456, -0.777966,
      -0.785292, -0.792538, -0.793047, -0.786509, -0.779096, -0.777644, -0.78336,    -0.790831, -0.793147, -0.788279,
      -0.780851, -0.777754, -0.78176,  -0.789048, -0.792842, -0.789706, -0.782648,   -0.778243, -0.780511, -0.787256,
      -0.792184, -0.790773, -0.784418, -0.779056, -0.779626, -0.785524, -0.791231,   -0.791476, -0.786098, -0.780136,
      -0.779108, -0.783911, -0.790041, -0.791812, -0.787629, -0.78142,  -0.778952,   -0.782476, -0.788677, -0.791791,
      -0.788958, -0.782847, -0.779145, -0.781266, -0.787205, -0.791433, -0.79004,    -0.784349, -0.779662, -0.780321,
      -0.785689, -0.790766, -0.79084,  -0.785861, -0.78047,  -0.779673, -0.784196,   -0.789826, -0.79133,  -0.787319,
      -0.781529, -0.779343, -0.78279,  -0.78866,  -0.791495, -0.78866,  -0.78279,    -0.779343, -0.781529, -0.787319,
      -0.79133,  -0.789826, -0.784196, -0.779673, -0.78047,  -0.785861, -0.79084,    -0.790766, -0.785689, -0.780321,
      -0.779662, -0.784349, -0.79004,  -0.791433, -0.787205, -0.781266, -0.779145,   -0.782847, -0.788958, -0.791791,
      -0.788677, -0.782476, -0.778952, -0.78142,  -0.787629, -0.791812, -0.790041,   -0.783911, -0.779108, -0.780136,
      -0.786098, -0.791476, -0.791231, -0.785524, -0.779626, -0.779056, -0.784418,   -0.790773, -0.792184, -0.787256,
      -0.780511, -0.778243, -0.782648, -0.789706, -0.792842, -0.789048, -0.78176,    -0.777754, -0.780851, -0.788279,
      -0.793147, -0.790831, -0.78336,  -0.777644, -0.779096, -0.786509, -0.793047,   -0.792538, -0.785292, -0.777966,
      -0.777456, -0.784418, -0.79249,  -0.794093, -0.787536, -0.778771, -0.776003,   -0.782026, -0.791421, -0.795421,
      -0.790071, -0.780118, -0.774819, -0.779353, -0.789779, -0.796441, -0.792883,   -0.782079, -0.773989, -0.776403,
      -0.787473, -0.797058, -0.795976, -0.784763, -0.773612, -0.773153, -0.784366,   -0.797161, -0.799403, -0.788356,
      -0.773822, -0.769516, -0.780203, -0.796589, -0.803306, -0.793214, -0.774822,   -0.765256, -0.774461, -0.79507,
      -0.808069, -0.80013,  -0.776995, -0.759742, -0.765895, -0.792037, -0.814779,   -0.811182, -0.78123,  -0.750977,
      -0.750766, -0.785997, -0.827479, -0.83384,  -0.790214, -0.729355, -0.711448,   -0.771941, -0.876724, -0.924778,
      -0.805571, -0.475689},
     {0,         0.401437,  0.715666,  0.889719,  0.923087,  0.862055,  0.77426,     0.71699,   0.714788,  0.755961,
      0.80713,   0.835927,  0.828934,  0.796082,  0.761189,  0.745901,  0.757117,    0.784728,  0.809763,  0.816921,
      0.803542,  0.779963,  0.761901,  0.760226,  0.774633,  0.794753,  0.807438,    0.805202,  0.790511,  0.773531,
      0.765203,  0.770283,  0.784721,  0.798764,  0.80347,   0.796344,  0.782571,    0.771305,  0.769639,  0.778177,
      0.790962,  0.799595,  0.798715,  0.789296,  0.777753,  0.7716,    0.774585,    0.784433,  0.79454,   0.798378,
      0.793695,  0.783809,  0.77528,   0.773572,  0.77957,   0.789155,  0.796017,    0.795798,  0.788845,  0.779853,
      0.774701,  0.776624,  0.784189,  0.792346,  0.795789,  0.792401,  0.784544,    0.777423,  0.775644,  0.780245,
      0.788097,  0.794029,  0.794225,  0.788673,  0.781098,  0.776465,  0.777735,    0.783973,  0.791029,  0.794297,
      0.79171,   0.785052,  0.778724,  0.776847,  0.780575,  0.787394,  0.792815,    0.793321,  0.788648,  0.781915,
      0.777541,  0.778353,  0.783757,  0.790171,  0.793395,  0.791358,  0.785447,    0.779564,  0.777553,  0.780692,
      0.786882,  0.792046,  0.792818,  0.788728,  0.782491,  0.778203,  0.778658,    0.783523,  0.789586,  0.792869,
      0.791239,  0.785791,  0.780114,  0.777929,  0.780651,  0.786474,  0.791569,    0.792599,  0.788902,  0.782919,
      0.778578,  0.778725,  0.783251,  0.78918,   0.792616,  0.79131,   0.786122,    0.780462,  0.778047,  0.780462,
      0.786122,  0.79131,   0.792616,  0.78918,   0.783251,  0.778725,  0.778578,    0.782919,  0.788902,  0.792599,
      0.791569,  0.786474,  0.780651,  0.777929,  0.780114,  0.785791,  0.791239,    0.792869,  0.789586,  0.783523,
      0.778658,  0.778203,  0.782491,  0.788728,  0.792818,  0.792046,  0.786882,    0.780692,  0.777553,  0.779564,
      0.785447,  0.791358,  0.793395,  0.790171,  0.783757,  0.778353,  0.777541,    0.781915,  0.788648,  0.793321,
      0.792815,  0.787394,  0.780575,  0.776847,  0.778724,  0.785052,  0.79171,     0.794297,  0.791029,  0.783973,
      0.777735,  0.776465,  0.781098,  0.788673,  0.794225,  0.794029,  0.788097,    0.780245,  0.775644,  0.777423,
      0.784544,  0.792401,  0.795789,  0.792346,  0.784189,  0.776624,  0.774701,    0.779853,  0.788845,  0.795798,
      0.796017,  0.789155,  0.77957,   0.773572,  0.77528,   0.783809,  0.793695,    0.798378,  0.79454,   0.784433,
      0.774585,  0.7716,    0.777753,  0.789296,  0.798715,  0.799595,  0.790962,    0.778177,  0.769639,  0.771305,
      0.782571,  0.796344,  0.80347,   0.798764,  0.784721,  0.770283,  0.765203,    0.773531,  0.790511,  0.805202,
      0.807438,  0.794753,  0.774633,  0.760226,  0.761901,  0.779963,  0.803542,    0.816921,  0.809763,  0.784728,
      0.757117,  0.745901,  0.761189,  0.796082,  0.828934,  0.835927,  0.80713,     0.755961,  0.714788,  0.71699,
      0.77426,   0.862055,  0.923087,  0.889719,  0.715666,  0.401437,  4.68411e-15, -0.401437, -0.715666, -0.889719,
      -0.923087, -0.862055, -0.77426,  -0.71699,  -0.714788, -0.755961, -0.80713,    -0.835927, -0.828934, -0.796082,
      -0.761189, -0.745901, -0.757117, -0.784728, -0.809763, -0.816921, -0.803542,   -0.779963, -0.761901, -0.760226,
      -0.774633, -0.794753, -0.807438, -0.805202, -0.790511, -0.773531, -0.765203,   -0.770283, -0.784721, -0.798764,
      -0.80347,  -0.796344, -0.782571, -0.771305, -0.769639, -0.778177, -0.790962,   -0.799595, -0.798715, -0.789296,
      -0.777753, -0.7716,   -0.774585, -0.784433, -0.79454,  -0.798378, -0.793695,   -0.783809, -0.77528,  -0.773572,
      -0.77957,  -0.789155, -0.796017, -0.795798, -0.788845, -0.779853, -0.774701,   -0.776624, -0.784189, -0.792346,
      -0.795789, -0.792401, -0.784544, -0.777423, -0.775644, -0.780245, -0.788097,   -0.794029, -0.794225, -0.788673,
      -0.781098, -0.776465, -0.777735, -0.783973, -0.791029, -0.794297, -0.79171,    -0.785052, -0.778724, -0.776847,
      -0.780575, -0.787394, -0.792815, -0.793321, -0.788648, -0.781915, -0.777541,   -0.778353, -0.783757, -0.790171,
      -0.793395, -0.791358, -0.785447, -0.779564, -0.777553, -0.780692, -0.786882,   -0.792046, -0.792818, -0.788728,
      -0.782491, -0.778203, -0.778658, -0.783523, -0.789586, -0.792869, -0.791239,   -0.785791, -0.780114, -0.777929,
      -0.780651, -0.786474, -0.791569, -0.792599, -0.788902, -0.782919, -0.778578,   -0.778725, -0.783251, -0.78918,
      -0.792616, -0.79131,  -0.786122, -0.780462, -0.778047, -0.780462, -0.786122,   -0.79131,  -0.792616, -0.78918,
      -0.783251, -0.778725, -0.778578, -0.782919, -0.788902, -0.792599, -0.791569,   -0.786474, -0.780651, -0.777929,
      -0.780114, -0.785791, -0.791239, -0.792869, -0.789586, -0.783523, -0.778658,   -0.778203, -0.782491, -0.788728,
      -0.792818, -0.792046, -0.786882, -0.780692, -0.777553, -0.779564, -0.785447,   -0.791358, -0.793395, -0.790171,
      -0.783757, -0.778353, -0.777541, -0.781915, -0.788648, -0.793321, -0.792815,   -0.787394, -0.780575, -0.776847,
      -0.778724, -0.785052, -0.79171,  -0.794297, -0.791029, -0.783973, -0.777735,   -0.776465, -0.781098, -0.788673,
      -0.794225, -0.794029, -0.788097, -0.780245, -0.775644, -0.777423, -0.784544,   -0.792401, -0.795789, -0.792346,
      -0.784189, -0.776624, -0.774701, -0.779853, -0.788845, -0.795798, -0.796017,   -0.789155, -0.77957,  -0.773572,
      -0.77528,  -0.783809, -0.793695, -0.798378, -0.79454,  -0.784433, -0.774585,   -0.7716,   -0.777753, -0.789296,
      -0.798715, -0.799595, -0.790962, -0.778177, -0.769639, -0.771305, -0.782571,   -0.796344, -0.80347,  -0.798764,
      -0.784721, -0.770283, -0.765203, -0.773531, -0.790511, -0.805202, -0.807438,   -0.794753, -0.774633, -0.760226,
      -0.761901, -0.779963, -0.803542, -0.816921, -0.809763, -0.784728, -0.757117,   -0.745901, -0.761189, -0.796082,
      -0.828934, -0.835927, -0.80713,  -0.755961, -0.714788, -0.71699,  -0.77426,    -0.862055, -0.923087, -0.889719,
      -0.715666, -0.401437},
     {0,         0.346021,  0.636362,  0.831518,  0.918729,  0.913482,  0.851804,  0.776606,  0.723252,  0.709511,
      0.733029,  0.77637,   0.816852,  0.83682,   0.830307,  0.803887,  0.77212,   0.750156,  0.746954,  0.761986,
      0.786479,  0.808201,  0.817335,  0.810734,  0.792777,  0.772739,  0.76014,   0.76033,   0.772321,  0.78969,
      0.803927,  0.808533,  0.801924,  0.78787,   0.773424,  0.76543,   0.767324,  0.777701,  0.791227,  0.80134,
      0.803406,  0.796811,  0.785069,  0.773981,  0.768789,  0.771724,  0.781066,  0.792121,  0.799558,  0.799964,
      0.793396,  0.783229,  0.774438,  0.771175,  0.774821,  0.783417,  0.792701,  0.798214,  0.797427,  0.790897,
      0.781907,  0.774832,  0.773009,  0.777177,  0.785188,  0.793105,  0.797133,  0.795431,  0.788946,  0.780898,
      0.775186,  0.774504,  0.779075,  0.786598,  0.793397,  0.796217,  0.793777,  0.787346,  0.78009,   0.775516,
      0.775779,  0.780674,  0.787768,  0.793611,  0.795405,  0.792347,  0.78598,   0.779421,  0.775833,  0.77691,
      0.78207,   0.788774,  0.793768,  0.794663,  0.791071,  0.784778,  0.77885,   0.776148,  0.777943,  0.783327,
      0.789663,  0.793882,  0.793961,  0.789898,  0.783688,  0.778353,  0.776466,  0.778917,  0.78449,   0.79047,
      0.793958,  0.793282,  0.788789,  0.782676,  0.77791,   0.776794,  0.779855,  0.785592,  0.791217,  0.794003,
      0.792607,  0.787718,  0.781714,  0.777509,  0.77714,   0.78078,   0.78666,   0.791924,  0.794017,  0.791924,
      0.78666,   0.78078,   0.77714,   0.777509,  0.781714,  0.787718,  0.792607,  0.794003,  0.791217,  0.785592,
      0.779855,  0.776794,  0.77791,   0.782676,  0.788789,  0.793282,  0.793958,  0.79047,   0.78449,   0.778917,
      0.776466,  0.778353,  0.783688,  0.789898,  0.793961,  0.793882,  0.789663,  0.783327,  0.777943,  0.776148,
      0.77885,   0.784778,  0.791071,  0.794663,  0.793768,  0.788774,  0.78207,   0.77691,   0.775833,  0.779421,
      0.78598,   0.792347,  0.795405,  0.793611,  0.787768,  0.780674,  0.775779,  0.775516,  0.78009,   0.787346,
      0.793777,  0.796217,  0.793397,  0.786598,  0.779075,  0.774504,  0.775186,  0.780898,  0.788946,  0.795431,
      0.797133,  0.793105,  0.785188,  0.777177,  0.773009,  0.774832,  0.781907,  0.790897,  0.797427,  0.798214,
      0.792701,  0.783417,  0.774821,  0.771175,  0.774438,  0.783229,  0.793396,  0.799964,  0.799558,  0.792121,
      0.781066,  0.771724,  0.768789,  0.773981,  0.785069,  0.796811,  0.803406,  0.80134,   0.791227,  0.777701,
      0.767324,  0.76543,   0.773424,  0.78787,   0.801924,  0.808533,  0.803927,  0.78969,   0.772321,  0.76033,
      0.76014,   0.772739,  0.792777,  0.810734,  0.817335,  0.808201,  0.786479,  0.761986,  0.746954,  0.750156,
      0.77212,   0.803887,  0.830307,  0.83682,   0.816852,  0.77637,   0.733029,  0.709511,  0.723252,  0.776606,
      0.851804,  0.913482,  0.918729,  0.831518,  0.636362,  0.346021,  4.022e-15, -0.346021, -0.636362, -0.831518,
      -0.918729, -0.913482, -0.851804, -0.776606, -0.723252, -0.709511, -0.733029, -0.77637,  -0.816852, -0.83682,
      -0.830307, -0.803887, -0.77212,  -0.750156, -0.746954, -0.761986, -0.786479, -0.808201, -0.817335, -0.810734,
      -0.792777, -0.772739, -0.76014,  -0.76033,  -0.772321, -0.78969,  -0.803927, -0.808533, -0.801924, -0.78787,
      -0.773424, -0.76543,  -0.767324, -0.777701, -0.791227, -0.80134,  -0.803406, -0.796811, -0.785069, -0.773981,
      -0.768789, -0.771724, -0.781066, -0.792121, -0.799558, -0.799964, -0.793396, -0.783229, -0.774438, -0.771175,
      -0.774821, -0.783417, -0.792701, -0.798214, -0.797427, -0.790897, -0.781907, -0.774832, -0.773009, -0.777177,
      -0.785188, -0.793105, -0.797133, -0.795431, -0.788946, -0.780898, -0.775186, -0.774504, -0.779075, -0.786598,
      -0.793397, -0.796217, -0.793777, -0.787346, -0.78009,  -0.775516, -0.775779, -0.780674, -0.787768, -0.793611,
      -0.795405, -0.792347, -0.78598,  -0.779421, -0.775833, -0.77691,  -0.78207,  -0.788774, -0.793768, -0.794663,
      -0.791071, -0.784778, -0.77885,  -0.776148, -0.777943, -0.783327, -0.789663, -0.793882, -0.793961, -0.789898,
      -0.783688, -0.778353, -0.776466, -0.778917, -0.78449,  -0.79047,  -0.793958, -0.793282, -0.788789, -0.782676,
      -0.77791,  -0.776794, -0.779855, -0.785592, -0.791217, -0.794003, -0.792607, -0.787718, -0.781714, -0.777509,
      -0.77714,  -0.78078,  -0.78666,  -0.791924, -0.794017, -0.791924, -0.78666,  -0.78078,  -0.77714,  -0.777509,
      -0.781714, -0.787718, -0.792607, -0.794003, -0.791217, -0.785592, -0.779855, -0.776794, -0.77791,  -0.782676,
      -0.788789, -0.793282, -0.793958, -0.79047,  -0.78449,  -0.778917, -0.776466, -0.778353, -0.783688, -0.789898,
      -0.793961, -0.793882, -0.789663, -0.783327, -0.777943, -0.776148, -0.77885,  -0.784778, -0.791071, -0.794663,
      -0.793768, -0.788774, -0.78207,  -0.77691,  -0.775833, -0.779421, -0.78598,  -0.792347, -0.795405, -0.793611,
      -0.787768, -0.780674, -0.775779, -0.775516, -0.78009,  -0.787346, -0.793777, -0.796217, -0.793397, -0.786598,
      -0.779075, -0.774504, -0.775186, -0.780898, -0.788946, -0.795431, -0.797133, -0.793105, -0.785188, -0.777177,
      -0.773009, -0.774832, -0.781907, -0.790897, -0.797427, -0.798214, -0.792701, -0.783417, -0.774821, -0.771175,
      -0.774438, -0.783229, -0.793396, -0.799964, -0.799558, -0.792121, -0.781066, -0.771724, -0.768789, -0.773981,
      -0.785069, -0.796811, -0.803406, -0.80134,  -0.791227, -0.777701, -0.767324, -0.76543,  -0.773424, -0.78787,
      -0.801924, -0.808533, -0.803927, -0.78969,  -0.772321, -0.76033,  -0.76014,  -0.772739, -0.792777, -0.810734,
      -0.817335, -0.808201, -0.786479, -0.761986, -0.746954, -0.750156, -0.77212,  -0.803887, -0.830307, -0.83682,
      -0.816852, -0.77637,  -0.733029, -0.709511, -0.723252, -0.776606, -0.851804, -0.913482, -0.918729, -0.831518,
      -0.636362, -0.346021},
     {0,         0.288908,  0.545493,  0.743954,  0.86996,   0.922888,  0.914879,    0.867083,  0.80415,   0.748407,
      0.715186,  0.71035,   0.730469,  0.765319,  0.801844,  0.828338,  0.837723,    0.829076,  0.807184,  0.780445,
      0.757909,  0.746403,  0.748625,  0.762663,  0.783002,  0.802557,  0.81505,     0.816939,  0.808356,  0.792803,
      0.775806,  0.763002,  0.758322,  0.762822,  0.774507,  0.789155,  0.801804,    0.808402,  0.807084,  0.798665,
      0.786249,  0.774107,  0.766227,  0.765025,  0.770617,  0.780881,  0.792243,    0.800904,  0.804103,  0.800981,
      0.792796,  0.782435,  0.773402,  0.768648,  0.769611,  0.775793,  0.784983,    0.79404,   0.799961,  0.800869,
      0.7966,    0.788714,  0.779928,  0.773188,  0.770685,  0.773148,  0.779638,    0.787899,  0.79514,   0.79897,
      0.798188,  0.793151,  0.785627,  0.778177,  0.773284,  0.772532,  0.776095,    0.782704,  0.790098,  0.795793,
      0.797916,  0.795816,  0.790262,  0.783166,  0.776924,  0.77361,   0.774291,    0.778684,  0.785267,  0.791809,
      0.796119,  0.796783,  0.793621,  0.78774,   0.781138,  0.776037,  0.77413,     0.776024,  0.781046,  0.787481,
      0.793159,  0.796182,  0.795558,  0.791526,  0.785468,  0.779431,  0.775442,    0.774827,  0.77777,   0.78326,
      0.789437,  0.794222,  0.796015,  0.794228,  0.789478,  0.783376,  0.777979,    0.775099,  0.775696,  0.779559,
      0.785377,  0.791189,  0.795038,  0.795633,  0.792778,  0.787439,  0.781418,    0.776742,  0.774986,  0.776742,
      0.781418,  0.787439,  0.792778,  0.795633,  0.795038,  0.791189,  0.785377,    0.779559,  0.775696,  0.775099,
      0.777979,  0.783376,  0.789478,  0.794228,  0.796015,  0.794222,  0.789437,    0.78326,   0.77777,   0.774827,
      0.775442,  0.779431,  0.785468,  0.791526,  0.795558,  0.796182,  0.793159,    0.787481,  0.781046,  0.776024,
      0.77413,   0.776037,  0.781138,  0.78774,   0.793621,  0.796783,  0.796119,    0.791809,  0.785267,  0.778684,
      0.774291,  0.77361,   0.776924,  0.783166,  0.790262,  0.795816,  0.797916,    0.795793,  0.790098,  0.782704,
      0.776095,  0.772532,  0.773284,  0.778177,  0.785627,  0.793151,  0.798188,    0.79897,   0.79514,   0.787899,
      0.779638,  0.773148,  0.770685,  0.773188,  0.779928,  0.788714,  0.7966,      0.800869,  0.799961,  0.79404,
      0.784983,  0.775793,  0.769611,  0.768648,  0.773402,  0.782435,  0.792796,    0.800981,  0.804103,  0.800904,
      0.792243,  0.780881,  0.770617,  0.765025,  0.766227,  0.774107,  0.786249,    0.798665,  0.807084,  0.808402,
      0.801804,  0.789155,  0.774507,  0.762822,  0.758322,  0.763002,  0.775806,    0.792803,  0.808356,  0.816939,
      0.81505,   0.802557,  0.783002,  0.762663,  0.748625,  0.746403,  0.757909,    0.780445,  0.807184,  0.829076,
      0.837723,  0.828338,  0.801844,  0.765319,  0.730469,  0.71035,   0.715186,    0.748407,  0.80415,   0.867083,
      0.914879,  0.922888,  0.86996,   0.743954,  0.545493,  0.288908,  3.19633e-15, -0.288908, -0.545493, -0.743954,
      -0.86996,  -0.922888, -0.914879, -0.867083, -0.80415,  -0.748407, -0.715186,   -0.71035,  -0.730469, -0.765319,
      -0.801844, -0.828338, -0.837723, -0.829076, -0.807184, -0.780445, -0.757909,   -0.746403, -0.748625, -0.762663,
      -0.783002, -0.802557, -0.81505,  -0.816939, -0.808356, -0.792803, -0.775806,   -0.763002, -0.758322, -0.762822,
      -0.774507, -0.789155, -0.801804, -0.808402, -0.807084, -0.798665, -0.786249,   -0.774107, -0.766227, -0.765025,
      -0.770617, -0.780881, -0.792243, -0.800904, -0.804103, -0.800981, -0.792796,   -0.782435, -0.773402, -0.768648,
      -0.769611, -0.775793, -0.784983, -0.79404,  -0.799961, -0.800869, -0.7966,     -0.788714, -0.779928, -0.773188,
      -0.770685, -0.773148, -0.779638, -0.787899, -0.79514,  -0.79897,  -0.798188,   -0.793151, -0.785627, -0.778177,
      -0.773284, -0.772532, -0.776095, -0.782704, -0.790098, -0.795793, -0.797916,   -0.795816, -0.790262, -0.783166,
      -0.776924, -0.77361,  -0.774291, -0.778684, -0.785267, -0.791809, -0.796119,   -0.796783, -0.793621, -0.78774,
      -0.781138, -0.776037, -0.77413,  -0.776024, -0.781046, -0.787481, -0.793159,   -0.796182, -0.795558, -0.791526,
      -0.785468, -0.779431, -0.775442, -0.774827, -0.77777,  -0.78326,  -0.789437,   -0.794222, -0.796015, -0.794228,
      -0.789478, -0.783376, -0.777979, -0.775099, -0.775696, -0.779559, -0.785377,   -0.791189, -0.795038, -0.795633,
      -0.792778, -0.787439, -0.781418, -0.776742, -0.774986, -0.776742, -0.781418,   -0.787439, -0.792778, -0.795633,
      -0.795038, -0.791189, -0.785377, -0.779559, -0.775696, -0.775099, -0.777979,   -0.783376, -0.789478, -0.794228,
      -0.796015, -0.794222, -0.789437, -0.78326,  -0.77777,  -0.774827, -0.775442,   -0.779431, -0.785468, -0.791526,
      -0.795558, -0.796182, -0.793159, -0.787481, -0.781046, -0.776024, -0.77413,    -0.776037, -0.781138, -0.78774,
      -0.793621, -0.796783, -0.796119, -0.791809, -0.785267, -0.778684, -0.774291,   -0.77361,  -0.776924, -0.783166,
      -0.790262, -0.795816, -0.797916, -0.795793, -0.790098, -0.782704, -0.776095,   -0.772532, -0.773284, -0.778177,
      -0.785627, -0.793151, -0.798188, -0.79897,  -0.79514,  -0.787899, -0.779638,   -0.773148, -0.770685, -0.773188,
      -0.779928, -0.788714, -0.7966,   -0.800869, -0.799961, -0.79404,  -0.784983,   -0.775793, -0.769611, -0.768648,
      -0.773402, -0.782435, -0.792796, -0.800981, -0.804103, -0.800904, -0.792243,   -0.780881, -0.770617, -0.765025,
      -0.766227, -0.774107, -0.786249, -0.798665, -0.807084, -0.808402, -0.801804,   -0.789155, -0.774507, -0.762822,
      -0.758322, -0.763002, -0.775806, -0.792803, -0.808356, -0.816939, -0.81505,    -0.802557, -0.783002, -0.762663,
      -0.748625, -0.746403, -0.757909, -0.780445, -0.807184, -0.829076, -0.837723,   -0.828338, -0.801844, -0.765319,
      -0.730469, -0.71035,  -0.715186, -0.748407, -0.80415,  -0.867083, -0.914879,   -0.922888, -0.86996,  -0.743954,
      -0.545493, -0.288908},
     {0,         0.242177,  0.465352,  0.653208,  0.79435,   0.883712,  0.922937,    0.919671,  0.885953,  0.836,
      0.783803,  0.740958,  0.715093,  0.709128,  0.721438,  0.746812,  0.777968,    0.807295,  0.828465,  0.837615,
      0.833906,  0.819405,  0.798364,  0.776103,  0.757762,  0.747187,  0.746188,    0.754292,  0.769013,  0.786547,
      0.802706,  0.81388,   0.817815,  0.814032,  0.803836,  0.789919,  0.775677,    0.764402,  0.758541,  0.759183,
      0.765875,  0.776797,  0.789241,  0.800268,  0.807388,  0.809114,  0.80526,     0.796933,  0.78623,   0.775718,
      0.767827,  0.764296,  0.765798,  0.771817,  0.780811,  0.790596,  0.798875,    0.803766,  0.804231,  0.800288,
      0.792976,  0.784089,  0.775739,  0.769857,  0.767752,  0.769823,  0.775486,    0.783336,  0.791492,  0.798043,
      0.801494,  0.801106,  0.797049,  0.790344,  0.782611,  0.775677,  0.771149,    0.770041,  0.772553,  0.778033,
      0.785148,  0.792207,  0.797557,  0.799972,  0.798931,  0.794729,  0.788397,    0.781448,  0.775519,  0.771988,
      0.771652,  0.774549,  0.779961,  0.786589,  0.792863,  0.797314,  0.798917,    0.797325,  0.792943,  0.786827,
      0.780431,  0.77526,   0.772518,  0.772831,  0.7761,    0.781534,  0.78784,     0.793528,  0.797265,  0.798183,
      0.796084,  0.791477,  0.785462,  0.779461,  0.774888,  0.772812,  0.773714,    0.777368,  0.782905,  0.789014,
      0.794253,  0.797389,  0.797689,  0.795086,  0.790199,  0.784185,  0.778463,    0.774383,  0.772906,  0.774383,
      0.778463,  0.784185,  0.790199,  0.795086,  0.797689,  0.797389,  0.794253,    0.789014,  0.782905,  0.777368,
      0.773714,  0.772812,  0.774888,  0.779461,  0.785462,  0.791477,  0.796084,    0.798183,  0.797265,  0.793528,
      0.78784,   0.781534,  0.7761,    0.772831,  0.772518,  0.77526,   0.780431,    0.786827,  0.792943,  0.797325,
      0.798917,  0.797314,  0.792863,  0.786589,  0.779961,  0.774549,  0.771652,    0.771988,  0.775519,  0.781448,
      0.788397,  0.794729,  0.798931,  0.799972,  0.797557,  0.792207,  0.785148,    0.778033,  0.772553,  0.770041,
      0.771149,  0.775677,  0.782611,  0.790344,  0.797049,  0.801106,  0.801494,    0.798043,  0.791492,  0.783336,
      0.775486,  0.769823,  0.767752,  0.769857,  0.775739,  0.784089,  0.792976,    0.800288,  0.804231,  0.803766,
      0.798875,  0.790596,  0.780811,  0.771817,  0.765798,  0.764296,  0.767827,    0.775718,  0.78623,   0.796933,
      0.80526,   0.809114,  0.807388,  0.800268,  0.789241,  0.776797,  0.765875,    0.759183,  0.758541,  0.764402,
      0.775677,  0.789919,  0.803836,  0.814032,  0.817815,  0.81388,   0.802706,    0.786547,  0.769013,  0.754292,
      0.746188,  0.747187,  0.757762,  0.776103,  0.798364,  0.819405,  0.833906,    0.837615,  0.828465,  0.807295,
      0.777968,  0.746812,  0.721438,  0.709128,  0.715093,  0.740958,  0.783803,    0.836,     0.885953,  0.919671,
      0.922937,  0.883712,  0.79435,   0.653208,  0.465352,  0.242177,  2.66961e-15, -0.242177, -0.465352, -0.653208,
      -0.79435,  -0.883712, -0.922937, -0.919671, -0.885953, -0.836,    -0.783803,   -0.740958, -0.715093, -0.709128,
      -0.721438, -0.746812, -0.777968, -0.807295, -0.828465, -0.837615, -0.833906,   -0.819405, -0.798364, -0.776103,
      -0.757762, -0.747187, -0.746188, -0.754292, -0.769013, -0.786547, -0.802706,   -0.81388,  -0.817815, -0.814032,
      -0.803836, -0.789919, -0.775677, -0.764402, -0.758541, -0.759183, -0.765875,   -0.776797, -0.789241, -0.800268,
      -0.807388, -0.809114, -0.80526,  -0.796933, -0.78623,  -0.775718, -0.767827,   -0.764296, -0.765798, -0.771817,
      -0.780811, -0.790596, -0.798875, -0.803766, -0.804231, -0.800288, -0.792976,   -0.784089, -0.775739, -0.769857,
      -0.767752, -0.769823, -0.775486, -0.783336, -0.791492, -0.798043, -0.801494,   -0.801106, -0.797049, -0.790344,
      -0.782611, -0.775677, -0.771149, -0.770041, -0.772553, -0.778033, -0.785148,   -0.792207, -0.797557, -0.799972,
      -0.798931, -0.794729, -0.788397, -0.781448, -0.775519, -0.771988, -0.771652,   -0.774549, -0.779961, -0.786589,
      -0.792863, -0.797314, -0.798917, -0.797325, -0.792943, -0.786827, -0.780431,   -0.77526,  -0.772518, -0.772831,
      -0.7761,   -0.781534, -0.78784,  -0.793528, -0.797265, -0.798183, -0.796084,   -0.791477, -0.785462, -0.779461,
      -0.774888, -0.772812, -0.773714, -0.777368, -0.782905, -0.789014, -0.794253,   -0.797389, -0.797689, -0.795086,
      -0.790199, -0.784185, -0.778463, -0.774383, -0.772906, -0.774383, -0.778463,   -0.784185, -0.790199, -0.795086,
      -0.797689, -0.797389, -0.794253, -0.789014, -0.782905, -0.777368, -0.773714,   -0.772812, -0.774888, -0.779461,
      -0.785462, -0.791477, -0.796084, -0.798183, -0.797265, -0.793528, -0.78784,    -0.781534, -0.7761,   -0.772831,
      -0.772518, -0.77526,  -0.780431, -0.786827, -0.792943, -0.797325, -0.798917,   -0.797314, -0.792863, -0.786589,
      -0.779961, -0.774549, -0.771652, -0.771988, -0.775519, -0.781448, -0.788397,   -0.794729, -0.798931, -0.799972,
      -0.797557, -0.792207, -0.785148, -0.778033, -0.772553, -0.770041, -0.771149,   -0.775677, -0.782611, -0.790344,
      -0.797049, -0.801106, -0.801494, -0.798043, -0.791492, -0.783336, -0.775486,   -0.769823, -0.767752, -0.769857,
      -0.775739, -0.784089, -0.792976, -0.800288, -0.804231, -0.803766, -0.798875,   -0.790596, -0.780811, -0.771817,
      -0.765798, -0.764296, -0.767827, -0.775718, -0.78623,  -0.796933, -0.80526,    -0.809114, -0.807388, -0.800268,
      -0.789241, -0.776797, -0.765875, -0.759183, -0.758541, -0.764402, -0.775677,   -0.789919, -0.803836, -0.814032,
      -0.817815, -0.81388,  -0.802706, -0.786547, -0.769013, -0.754292, -0.746188,   -0.747187, -0.757762, -0.776103,
      -0.798364, -0.819405, -0.833906, -0.837615, -0.828465, -0.807295, -0.777968,   -0.746812, -0.721438, -0.709128,
      -0.715093, -0.740958, -0.783803, -0.836,    -0.885953, -0.919671, -0.922937,   -0.883712, -0.79435,  -0.653208,
      -0.465352, -0.242177},
     {0,         0.206616,  0.401447,  0.573919,  0.715728,  0.821632,  0.88986,     0.922131,  0.923254,  0.900397,
      0.862124,  0.817315,  0.774129,  0.739131,  0.71668,   0.708645,  0.714474,    0.731563,  0.755875,  0.782692,
      0.807393,  0.826147,  0.836427,  0.837284,  0.829358,  0.814654,  0.796114,    0.77708,   0.760738,  0.749612,
      0.745209,  0.747838,  0.756636,  0.769776,  0.784825,  0.799166,  0.810445,    0.816934,  0.817787,  0.813134,
      0.804011,  0.792152,  0.779666,  0.768674,  0.760959,  0.757684,  0.759224,    0.765133,  0.774254,  0.784935,
      0.79532,   0.803671,  0.808648,  0.809524,  0.806283,  0.7996,    0.79071,     0.781179,  0.772637,  0.766499,
      0.763737,  0.764726,  0.7692,    0.776312,  0.784791,  0.793169,  0.800028,    0.804242,  0.805156,  0.80269,
      0.797335,  0.79006,   0.782141,  0.774933,  0.769647,  0.767143,  0.767794,    0.771432,  0.777386,  0.784604,
      0.791837,  0.797854,  0.801653,  0.802622,  0.800638,  0.796084,  0.789771,    0.782799,  0.776363,  0.771554,
      0.769169,  0.769585,  0.772696,  0.777941,  0.784402,  0.790963,  0.796504,    0.800092,  0.801133,  0.799474,
      0.795423,  0.789693,  0.783277,  0.777275,  0.77271,   0.77035,   0.770582,    0.773349,  0.778161,  0.784183,
      0.790379,  0.795687,  0.799205,  0.800341,  0.798912,  0.795172,  0.789772,    0.783642,  0.777834,  0.77334,
      0.770927,  0.771001,  0.773546,  0.77812,   0.783936,  0.789996,  0.795261,    0.79883,   0.800092,  0.79883,
      0.795261,  0.789996,  0.783936,  0.77812,   0.773546,  0.771001,  0.770927,    0.77334,   0.777834,  0.783642,
      0.789772,  0.795172,  0.798912,  0.800341,  0.799205,  0.795687,  0.790379,    0.784183,  0.778161,  0.773349,
      0.770582,  0.77035,   0.77271,   0.777275,  0.783277,  0.789693,  0.795423,    0.799474,  0.801133,  0.800092,
      0.796504,  0.790963,  0.784402,  0.777941,  0.772696,  0.769585,  0.769169,    0.771554,  0.776363,  0.782799,
      0.789771,  0.796084,  0.800638,  0.802622,  0.801653,  0.797854,  0.791837,    0.784604,  0.777386,  0.771432,
      0.767794,  0.767143,  0.769647,  0.774933,  0.782141,  0.79006,   0.797335,    0.80269,   0.805156,  0.804242,
      0.800028,  0.793169,  0.784791,  0.776312,  0.7692,    0.764726,  0.763737,    0.766499,  0.772637,  0.781179,
      0.79071,   0.7996,    0.806283,  0.809524,  0.808648,  0.803671,  0.79532,     0.784935,  0.774254,  0.765133,
      0.759224,  0.757684,  0.760959,  0.768674,  0.779666,  0.792152,  0.804011,    0.813134,  0.817787,  0.816934,
      0.810445,  0.799166,  0.784825,  0.769776,  0.756636,  0.747838,  0.745209,    0.749612,  0.760738,  0.77708,
      0.796114,  0.814654,  0.829358,  0.837284,  0.836427,  0.826147,  0.807393,    0.782692,  0.755875,  0.731563,
      0.714474,  0.708645,  0.71668,   0.739131,  0.774129,  0.817315,  0.862124,    0.900397,  0.923254,  0.922131,
      0.88986,   0.821632,  0.715728,  0.573919,  0.401447,  0.206616,  2.20564e-15, -0.206616, -0.401447, -0.573919,
      -0.715728, -0.821632, -0.88986,  -0.922131, -0.923254, -0.900397, -0.862124,   -0.817315, -0.774129, -0.739131,
      -0.71668,  -0.708645, -0.714474, -0.731563, -0.755875, -0.782692, -0.807393,   -0.826147, -0.836427, -0.837284,
      -0.829358, -0.814654, -0.796114, -0.77708,  -0.760738, -0.749612, -0.745209,   -0.747838, -0.756636, -0.769776,
      -0.784825, -0.799166, -0.810445, -0.816934, -0.817787, -0.813134, -0.804011,   -0.792152, -0.779666, -0.768674,
      -0.760959, -0.757684, -0.759224, -0.765133, -0.774254, -0.784935, -0.79532,    -0.803671, -0.808648, -0.809524,
      -0.806283, -0.7996,   -0.79071,  -0.781179, -0.772637, -0.766499, -0.763737,   -0.764726, -0.7692,   -0.776312,
      -0.784791, -0.793169, -0.800028, -0.804242, -0.805156, -0.80269,  -0.797335,   -0.79006,  -0.782141, -0.774933,
      -0.769647, -0.767143, -0.767794, -0.771432, -0.777386, -0.784604, -0.791837,   -0.797854, -0.801653, -0.802622,
      -0.800638, -0.796084, -0.789771, -0.782799, -0.776363, -0.771554, -0.769169,   -0.769585, -0.772696, -0.777941,
      -0.784402, -0.790963, -0.796504, -0.800092, -0.801133, -0.799474, -0.795423,   -0.789693, -0.783277, -0.777275,
      -0.77271,  -0.77035,  -0.770582, -0.773349, -0.778161, -0.784183, -0.790379,   -0.795687, -0.799205, -0.800341,
      -0.798912, -0.795172, -0.789772, -0.783642, -0.777834, -0.77334,  -0.770927,   -0.771001, -0.773546, -0.77812,
      -0.783936, -0.789996, -0.795261, -0.79883,  -0.800092, -0.79883,  -0.795261,   -0.789996, -0.783936, -0.77812,
      -0.773546, -0.771001, -0.770927, -0.77334,  -0.777834, -0.783642, -0.789772,   -0.795172, -0.798912, -0.800341,
      -0.799205, -0.795687, -0.790379, -0.784183, -0.778161, -0.773349, -0.770582,   -0.77035,  -0.77271,  -0.777275,
      -0.783277, -0.789693, -0.795423, -0.799474, -0.801133, -0.800092, -0.796504,   -0.790963, -0.784402, -0.777941,
      -0.772696, -0.769585, -0.769169, -0.771554, -0.776363, -0.782799, -0.789771,   -0.796084, -0.800638, -0.802622,
      -0.801653, -0.797854, -0.791837, -0.784604, -0.777386, -0.771432, -0.767794,   -0.767143, -0.769647, -0.774933,
      -0.782141, -0.79006,  -0.797335, -0.80269,  -0.805156, -0.804242, -0.800028,   -0.793169, -0.784791, -0.776312,
      -0.7692,   -0.764726, -0.763737, -0.766499, -0.772637, -0.781179, -0.79071,    -0.7996,   -0.806283, -0.809524,
      -0.808648, -0.803671, -0.79532,  -0.784935, -0.774254, -0.765133, -0.759224,   -0.757684, -0.760959, -0.768674,
      -0.779666, -0.792152, -0.804011, -0.813134, -0.817787, -0.816934, -0.810445,   -0.799166, -0.784825, -0.769776,
      -0.756636, -0.747838, -0.745209, -0.749612, -0.760738, -0.77708,  -0.796114,   -0.814654, -0.829358, -0.837284,
      -0.836427, -0.826147, -0.807393, -0.782692, -0.755875, -0.731563, -0.714474,   -0.708645, -0.71668,  -0.739131,
      -0.774129, -0.817315, -0.862124, -0.900397, -0.923254, -0.922131, -0.88986,    -0.821632, -0.715728, -0.573919,
      -0.401447, -0.206616},
     {0,         0.170684,  0.334734,  0.485977,  0.619133,  0.730161,  0.816508,   0.877244,  0.913052,  0.926108,
      0.919833,  0.898569,  0.867185,  0.83067,   0.793736,  0.760459,  0.734013,   0.716483,  0.708795,  0.710749,
      0.721157,  0.738049,  0.758951,  0.78118,   0.802135,  0.819568,  0.831789,   0.837803,  0.837369,  0.830972,
      0.819722,  0.805198,  0.789242,  0.773747,  0.760446,  0.75073,   0.745512,   0.745156,  0.749459,  0.757707,
      0.768773,  0.781266,  0.793697,  0.804648,  0.812927,  0.817698,  0.818552,   0.815543,  0.809161,  0.80026,
      0.789951,  0.779467,  0.770015,  0.762649,  0.758148,  0.756938,  0.759058,   0.764166,  0.771586,  0.780399,
      0.78955,   0.797978,  0.804729,  0.809068,  0.810557,  0.809092,  0.804915,   0.79857,   0.79084,   0.782647,
      0.774949,  0.768624,  0.764375,  0.76265,   0.763601,  0.767065,  0.772595,   0.779512,  0.786992,  0.79416,
      0.800189,  0.804402,  0.806339,  0.805811,  0.802917,  0.798027,  0.791737,   0.784797,  0.778019,  0.772188,
      0.767969,  0.76583,   0.765995,  0.768418,  0.772792,  0.778587,  0.785115,   0.79161,   0.797318,  0.801584,
      0.803924,  0.804083,  0.802063,  0.798115,  0.792715,  0.786501,  0.780202,   0.774553,  0.770205,  0.767658,
      0.767196,  0.768863,  0.772451,  0.777535,  0.783514,  0.789688,  0.795336,   0.799803,  0.802571,  0.803324,
      0.801979,  0.798699,  0.79387,   0.788059,  0.781946,  0.776244,  0.771618,   0.768608,  0.767564,  0.768608,
      0.771618,  0.776244,  0.781946,  0.788059,  0.79387,   0.798699,  0.801979,   0.803324,  0.802571,  0.799803,
      0.795336,  0.789688,  0.783514,  0.777535,  0.772451,  0.768863,  0.767196,   0.767658,  0.770205,  0.774553,
      0.780202,  0.786501,  0.792715,  0.798115,  0.802063,  0.804083,  0.803924,   0.801584,  0.797318,  0.79161,
      0.785115,  0.778587,  0.772792,  0.768418,  0.765995,  0.76583,   0.767969,   0.772188,  0.778019,  0.784797,
      0.791737,  0.798027,  0.802917,  0.805811,  0.806339,  0.804402,  0.800189,   0.79416,   0.786992,  0.779512,
      0.772595,  0.767065,  0.763601,  0.76265,   0.764375,  0.768624,  0.774949,   0.782647,  0.79084,   0.79857,
      0.804915,  0.809092,  0.810557,  0.809068,  0.804729,  0.797978,  0.78955,    0.780399,  0.771586,  0.764166,
      0.759058,  0.756938,  0.758148,  0.762649,  0.770015,  0.779467,  0.789951,   0.80026,   0.809161,  0.815543,
      0.818552,  0.817698,  0.812927,  0.804648,  0.793697,  0.781266,  0.768773,   0.757707,  0.749459,  0.745156,
      0.745512,  0.75073,   0.760446,  0.773747,  0.789242,  0.805198,  0.819722,   0.830972,  0.837369,  0.837803,
      0.831789,  0.819568,  0.802135,  0.78118,   0.758951,  0.738049,  0.721157,   0.710749,  0.708795,  0.716483,
      0.734013,  0.760459,  0.793736,  0.83067,   0.867185,  0.898569,  0.919833,   0.926108,  0.913052,  0.877244,
      0.816508,  0.730161,  0.619133,  0.485977,  0.334734,  0.170684,  1.9538e-15, -0.170684, -0.334734, -0.485977,
      -0.619133, -0.730161, -0.816508, -0.877244, -0.913052, -0.926108, -0.919833,  -0.898569, -0.867185, -0.83067,
      -0.793736, -0.760459, -0.734013, -0.716483, -0.708795, -0.710749, -0.721157,  -0.738049, -0.758951, -0.78118,
      -0.802135, -0.819568, -0.831789, -0.837803, -0.837369, -0.830972, -0.819722,  -0.805198, -0.789242, -0.773747,
      -0.760446, -0.75073,  -0.745512, -0.745156, -0.749459, -0.757707, -0.768773,  -0.781266, -0.793697, -0.804648,
      -0.812927, -0.817698, -0.818552, -0.815543, -0.809161, -0.80026,  -0.789951,  -0.779467, -0.770015, -0.762649,
      -0.758148, -0.756938, -0.759058, -0.764166, -0.771586, -0.780399, -0.78955,   -0.797978, -0.804729, -0.809068,
      -0.810557, -0.809092, -0.804915, -0.79857,  -0.79084,  -0.782647, -0.774949,  -0.768624, -0.764375, -0.76265,
      -0.763601, -0.767065, -0.772595, -0.779512, -0.786992, -0.79416,  -0.800189,  -0.804402, -0.806339, -0.805811,
      -0.802917, -0.798027, -0.791737, -0.784797, -0.778019, -0.772188, -0.767969,  -0.76583,  -0.765995, -0.768418,
      -0.772792, -0.778587, -0.785115, -0.79161,  -0.797318, -0.801584, -0.803924,  -0.804083, -0.802063, -0.798115,
      -0.792715, -0.786501, -0.780202, -0.774553, -0.770205, -0.767658, -0.767196,  -0.768863, -0.772451, -0.777535,
      -0.783514, -0.789688, -0.795336, -0.799803, -0.802571, -0.803324, -0.801979,  -0.798699, -0.79387,  -0.788059,
      -0.781946, -0.776244, -0.771618, -0.768608, -0.767564, -0.768608, -0.771618,  -0.776244, -0.781946, -0.788059,
      -0.79387,  -0.798699, -0.801979, -0.803324, -0.802571, -0.799803, -0.795336,  -0.789688, -0.783514, -0.777535,
      -0.772451, -0.768863, -0.767196, -0.767658, -0.770205, -0.774553, -0.780202,  -0.786501, -0.792715, -0.798115,
      -0.802063, -0.804083, -0.803924, -0.801584, -0.797318, -0.79161,  -0.785115,  -0.778587, -0.772792, -0.768418,
      -0.765995, -0.76583,  -0.767969, -0.772188, -0.778019, -0.784797, -0.791737,  -0.798027, -0.802917, -0.805811,
      -0.806339, -0.804402, -0.800189, -0.79416,  -0.786992, -0.779512, -0.772595,  -0.767065, -0.763601, -0.76265,
      -0.764375, -0.768624, -0.774949, -0.782647, -0.79084,  -0.79857,  -0.804915,  -0.809092, -0.810557, -0.809068,
      -0.804729, -0.797978, -0.78955,  -0.780399, -0.771586, -0.764166, -0.759058,  -0.756938, -0.758148, -0.762649,
      -0.770015, -0.779467, -0.789951, -0.80026,  -0.809161, -0.815543, -0.818552,  -0.817698, -0.812927, -0.804648,
      -0.793697, -0.781266, -0.768773, -0.757707, -0.749459, -0.745156, -0.745512,  -0.75073,  -0.760446, -0.773747,
      -0.789242, -0.805198, -0.819722, -0.830972, -0.837369, -0.837803, -0.831789,  -0.819568, -0.802135, -0.78118,
      -0.758951, -0.738049, -0.721157, -0.710749, -0.708795, -0.716483, -0.734013,  -0.760459, -0.793736, -0.83067,
      -0.867185, -0.898569, -0.919833, -0.926108, -0.913052, -0.877244, -0.816508,  -0.730161, -0.619133, -0.485977,
      -0.334734, -0.170684},
     {0,         0.146555,  0.288915,  0.423099,  0.545545,  0.653287,  0.744097,   0.816579,  0.870217,  0.905372,
      0.923223,  0.92567,   0.915192,  0.894677,  0.867241,  0.836029,  0.804039,   0.773952,  0.747994,  0.72784,
      0.714549,  0.708552,  0.709676,  0.71721,   0.73,      0.746571,  0.765266,   0.78438,   0.802297,  0.81761,
      0.829214,  0.836375,  0.838767,  0.836468,  0.829936,  0.819949,  0.807527,   0.793835,  0.780084,  0.767432,
      0.756888,  0.749244,  0.745013,  0.744404,  0.747318,  0.753365,  0.761912,   0.772141,  0.783128,  0.793915,
      0.8036,    0.811403,  0.816727,  0.819204,  0.818717,  0.815398,  0.809617,   0.801935,  0.79306,   0.783777,
      0.774885,  0.767127,  0.761132,  0.757362,  0.756083,  0.757342,  0.76097,    0.766605,  0.773721,  0.78168,
      0.789788,  0.797351,  0.803737,  0.808427,  0.811054,  0.811435,  0.809578,   0.805684,  0.80012,   0.79339,
      0.786087,  0.778843,  0.772275,  0.766932,  0.763253,  0.761526,  0.761871,   0.764229,  0.768371,  0.773921,
      0.780385,  0.787201,  0.793781,  0.799566,  0.80407,   0.806922,  0.807896,   0.806929,  0.804121,  0.799731,
      0.79415,   0.787865,  0.781421,  0.77537,   0.770229,  0.766429,  0.764288,   0.763977,  0.76551,   0.768745,
      0.773394,  0.779051,  0.785224,  0.791383,  0.796999,  0.801592,  0.804773,   0.806273,  0.805971,  0.803898,
      0.800236,  0.795304,  0.78953,   0.783409,  0.777469,  0.77222,   0.768113,   0.765498,  0.764601,  0.765498,
      0.768113,  0.77222,   0.777469,  0.783409,  0.78953,   0.795304,  0.800236,   0.803898,  0.805971,  0.806273,
      0.804773,  0.801592,  0.796999,  0.791383,  0.785224,  0.779051,  0.773394,   0.768745,  0.76551,   0.763977,
      0.764288,  0.766429,  0.770229,  0.77537,   0.781421,  0.787865,  0.79415,    0.799731,  0.804121,  0.806929,
      0.807896,  0.806922,  0.80407,   0.799566,  0.793781,  0.787201,  0.780385,   0.773921,  0.768371,  0.764229,
      0.761871,  0.761526,  0.763253,  0.766932,  0.772275,  0.778843,  0.786087,   0.79339,   0.80012,   0.805684,
      0.809578,  0.811435,  0.811054,  0.808427,  0.803737,  0.797351,  0.789788,   0.78168,   0.773721,  0.766605,
      0.76097,   0.757342,  0.756083,  0.757362,  0.761132,  0.767127,  0.774885,   0.783777,  0.79306,   0.801935,
      0.809617,  0.815398,  0.818717,  0.819204,  0.816727,  0.811403,  0.8036,     0.793915,  0.783128,  0.772141,
      0.761912,  0.753365,  0.747318,  0.744404,  0.745013,  0.749244,  0.756888,   0.767432,  0.780084,  0.793835,
      0.807527,  0.819949,  0.829936,  0.836468,  0.838767,  0.836375,  0.829214,   0.81761,   0.802297,  0.78438,
      0.765266,  0.746571,  0.73,      0.71721,   0.709676,  0.708552,  0.714549,   0.72784,   0.747994,  0.773952,
      0.804039,  0.836029,  0.867241,  0.894677,  0.915192,  0.92567,   0.923223,   0.905372,  0.870217,  0.816579,
      0.744097,  0.653287,  0.545545,  0.423099,  0.288915,  0.146555,  1.7194e-15, -0.146555, -0.288915, -0.423099,
      -0.545545, -0.653287, -0.744097, -0.816579, -0.870217, -0.905372, -0.923223,  -0.92567,  -0.915192, -0.894677,
      -0.867241, -0.836029, -0.804039, -0.773952, -0.747994, -0.72784,  -0.714549,  -0.708552, -0.709676, -0.71721,
      -0.73,     -0.746571, -0.765266, -0.78438,  -0.802297, -0.81761,  -0.829214,  -0.836375, -0.838767, -0.836468,
      -0.829936, -0.819949, -0.807527, -0.793835, -0.780084, -0.767432, -0.756888,  -0.749244, -0.745013, -0.744404,
      -0.747318, -0.753365, -0.761912, -0.772141, -0.783128, -0.793915, -0.8036,    -0.811403, -0.816727, -0.819204,
      -0.818717, -0.815398, -0.809617, -0.801935, -0.79306,  -0.783777, -0.774885,  -0.767127, -0.761132, -0.757362,
      -0.756083, -0.757342, -0.76097,  -0.766605, -0.773721, -0.78168,  -0.789788,  -0.797351, -0.803737, -0.808427,
      -0.811054, -0.811435, -0.809578, -0.805684, -0.80012,  -0.79339,  -0.786087,  -0.778843, -0.772275, -0.766932,
      -0.763253, -0.761526, -0.761871, -0.764229, -0.768371, -0.773921, -0.780385,  -0.787201, -0.793781, -0.799566,
      -0.80407,  -0.806922, -0.807896, -0.806929, -0.804121, -0.799731, -0.79415,   -0.787865, -0.781421, -0.77537,
      -0.770229, -0.766429, -0.764288, -0.763977, -0.76551,  -0.768745, -0.773394,  -0.779051, -0.785224, -0.791383,
      -0.796999, -0.801592, -0.804773, -0.806273, -0.805971, -0.803898, -0.800236,  -0.795304, -0.78953,  -0.783409,
      -0.777469, -0.77222,  -0.768113, -0.765498, -0.764601, -0.765498, -0.768113,  -0.77222,  -0.777469, -0.783409,
      -0.78953,  -0.795304, -0.800236, -0.803898, -0.805971, -0.806273, -0.804773,  -0.801592, -0.796999, -0.791383,
      -0.785224, -0.779051, -0.773394, -0.768745, -0.76551,  -0.763977, -0.764288,  -0.766429, -0.770229, -0.77537,
      -0.781421, -0.787865, -0.79415,  -0.799731, -0.804121, -0.806929, -0.807896,  -0.806922, -0.80407,  -0.799566,
      -0.793781, -0.787201, -0.780385, -0.773921, -0.768371, -0.764229, -0.761871,  -0.761526, -0.763253, -0.766932,
      -0.772275, -0.778843, -0.786087, -0.79339,  -0.80012,  -0.805684, -0.809578,  -0.811435, -0.811054, -0.808427,
      -0.803737, -0.797351, -0.789788, -0.78168,  -0.773721, -0.766605, -0.76097,   -0.757342, -0.756083, -0.757362,
      -0.761132, -0.767127, -0.774885, -0.783777, -0.79306,  -0.801935, -0.809617,  -0.815398, -0.818717, -0.819204,
      -0.816727, -0.811403, -0.8036,   -0.793915, -0.783128, -0.772141, -0.761912,  -0.753365, -0.747318, -0.744404,
      -0.745013, -0.749244, -0.756888, -0.767432, -0.780084, -0.793835, -0.807527,  -0.819949, -0.829936, -0.836468,
      -0.838767, -0.836375, -0.829214, -0.81761,  -0.802297, -0.78438,  -0.765266,  -0.746571, -0.73,     -0.71721,
      -0.709676, -0.708552, -0.714549, -0.72784,  -0.747994, -0.773952, -0.804039,  -0.836029, -0.867241, -0.894677,
      -0.915192, -0.92567,  -0.923223, -0.905372, -0.870217, -0.816579, -0.744097,  -0.653287, -0.545545, -0.423099,
      -0.288915, -0.146555},
     {0,         0.122309,  0.242183,  0.357271,  0.465396,  0.564626,  0.653341,    0.730287,  0.794612,  0.845886,
      0.884108,  0.909688,  0.923419,  0.926433,  0.92014,   0.906166,  0.886276,    0.862299,  0.836049,  0.809256,
      0.783496,  0.760137,  0.740294,  0.724796,  0.714172,  0.708642,  0.708139,    0.712323,  0.720623,  0.732282,
      0.746406,  0.762022,  0.778134,  0.793779,  0.808072,  0.820258,  0.829738,    0.836099,  0.839125,  0.838802,
      0.835304,  0.828982,  0.82033,   0.809953,  0.798533,  0.78678,   0.775396,    0.765035,  0.756267,  0.749547,
      0.745198,  0.743393,  0.744151,  0.747344,  0.752707,  0.759853,  0.76831,     0.777539,  0.786974,  0.796053,
      0.804251,  0.811108,  0.816254,  0.81943,   0.820499,  0.819448,  0.81639,     0.811554,  0.805265,  0.797929,
      0.79,      0.781962,  0.774292,  0.767436,  0.761785,  0.75765,   0.755247,    0.754688,  0.755972,  0.758992,
      0.763538,  0.769317,  0.775965,  0.783076,  0.790219,  0.79697,   0.802934,    0.807769,  0.811202,  0.813048,
      0.813217,  0.811722,  0.808669,  0.80426,   0.798772,  0.792543,  0.785951,    0.779392,  0.773257,  0.767906,
      0.76365,   0.760733,  0.759317,  0.759475,  0.761183,  0.76433,   0.768716,    0.774072,  0.780073,  0.786355,
      0.792545,  0.798272,  0.803198,  0.807033,  0.809553,  0.810614,  0.810159,    0.80822,   0.804918,  0.800455,
      0.795101,  0.789177,  0.783039,  0.777053,  0.771578,  0.766939,  0.763413,    0.76121,   0.76046,   0.76121,
      0.763413,  0.766939,  0.771578,  0.777053,  0.783039,  0.789177,  0.795101,    0.800455,  0.804918,  0.80822,
      0.810159,  0.810614,  0.809553,  0.807033,  0.803198,  0.798272,  0.792545,    0.786355,  0.780073,  0.774072,
      0.768716,  0.76433,   0.761183,  0.759475,  0.759317,  0.760733,  0.76365,     0.767906,  0.773257,  0.779392,
      0.785951,  0.792543,  0.798772,  0.80426,   0.808669,  0.811722,  0.813217,    0.813048,  0.811202,  0.807769,
      0.802934,  0.79697,   0.790219,  0.783076,  0.775965,  0.769317,  0.763538,    0.758992,  0.755972,  0.754688,
      0.755247,  0.75765,   0.761785,  0.767436,  0.774292,  0.781962,  0.79,        0.797929,  0.805265,  0.811554,
      0.81639,   0.819448,  0.820499,  0.81943,   0.816254,  0.811108,  0.804251,    0.796053,  0.786974,  0.777539,
      0.76831,   0.759853,  0.752707,  0.747344,  0.744151,  0.743393,  0.745198,    0.749547,  0.756267,  0.765035,
      0.775396,  0.78678,   0.798533,  0.809953,  0.82033,   0.828982,  0.835304,    0.838802,  0.839125,  0.836099,
      0.829738,  0.820258,  0.808072,  0.793779,  0.778134,  0.762022,  0.746406,    0.732282,  0.720623,  0.712323,
      0.708139,  0.708642,  0.714172,  0.724796,  0.740294,  0.760137,  0.783496,    0.809256,  0.836049,  0.862299,
      0.886276,  0.906166,  0.92014,   0.926433,  0.923419,  0.909688,  0.884108,    0.845886,  0.794612,  0.730287,
      0.653341,  0.564626,  0.465396,  0.357271,  0.242183,  0.122309,  1.48918e-15, -0.122309, -0.242183, -0.357271,
      -0.465396, -0.564626, -0.653341, -0.730287, -0.794612, -0.845886, -0.884108,   -0.909688, -0.923419, -0.926433,
      -0.92014,  -0.906166, -0.886276, -0.862299, -0.836049, -0.809256, -0.783496,   -0.760137, -0.740294, -0.724796,
      -0.714172, -0.708642, -0.708139, -0.712323, -0.720623, -0.732282, -0.746406,   -0.762022, -0.778134, -0.793779,
      -0.808072, -0.820258, -0.829738, -0.836099, -0.839125, -0.838802, -0.835304,   -0.828982, -0.82033,  -0.809953,
      -0.798533, -0.78678,  -0.775396, -0.765035, -0.756267, -0.749547, -0.745198,   -0.743393, -0.744151, -0.747344,
      -0.752707, -0.759853, -0.76831,  -0.777539, -0.786974, -0.796053, -0.804251,   -0.811108, -0.816254, -0.81943,
      -0.820499, -0.819448, -0.81639,  -0.811554, -0.805265, -0.797929, -0.79,       -0.781962, -0.774292, -0.767436,
      -0.761785, -0.75765,  -0.755247, -0.754688, -0.755972, -0.758992, -0.763538,   -0.769317, -0.775965, -0.783076,
      -0.790219, -0.79697,  -0.802934, -0.807769, -0.811202, -0.813048, -0.813217,   -0.811722, -0.808669, -0.80426,
      -0.798772, -0.792543, -0.785951, -0.779392, -0.773257, -0.767906, -0.76365,    -0.760733, -0.759317, -0.759475,
      -0.761183, -0.76433,  -0.768716, -0.774072, -0.780073, -0.786355, -0.792545,   -0.798272, -0.803198, -0.807033,
      -0.809553, -0.810614, -0.810159, -0.80822,  -0.804918, -0.800455, -0.795101,   -0.789177, -0.783039, -0.777053,
      -0.771578, -0.766939, -0.763413, -0.76121,  -0.76046,  -0.76121,  -0.763413,   -0.766939, -0.771578, -0.777053,
      -0.783039, -0.789177, -0.795101, -0.800455, -0.804918, -0.80822,  -0.810159,   -0.810614, -0.809553, -0.807033,
      -0.803198, -0.798272, -0.792545, -0.786355, -0.780073, -0.774072, -0.768716,   -0.76433,  -0.761183, -0.759475,
      -0.759317, -0.760733, -0.76365,  -0.767906, -0.773257, -0.779392, -0.785951,   -0.792543, -0.798772, -0.80426,
      -0.808669, -0.811722, -0.813217, -0.813048, -0.811202, -0.807769, -0.802934,   -0.79697,  -0.790219, -0.783076,
      -0.775965, -0.769317, -0.763538, -0.758992, -0.755972, -0.754688, -0.755247,   -0.75765,  -0.761785, -0.767436,
      -0.774292, -0.781962, -0.79,     -0.797929, -0.805265, -0.811554, -0.81639,    -0.819448, -0.820499, -0.81943,
      -0.816254, -0.811108, -0.804251, -0.796053, -0.786974, -0.777539, -0.76831,    -0.759853, -0.752707, -0.747344,
      -0.744151, -0.743393, -0.745198, -0.749547, -0.756267, -0.765035, -0.775396,   -0.78678,  -0.798533, -0.809953,
      -0.82033,  -0.828982, -0.835304, -0.838802, -0.839125, -0.836099, -0.829738,   -0.820258, -0.808072, -0.793779,
      -0.778134, -0.762022, -0.746406, -0.732282, -0.720623, -0.712323, -0.708139,   -0.708642, -0.714172, -0.724796,
      -0.740294, -0.760137, -0.783496, -0.809256, -0.836049, -0.862299, -0.886276,   -0.906166, -0.92014,  -0.926433,
      -0.923419, -0.909688, -0.884108, -0.845886, -0.794612, -0.730287, -0.653341,   -0.564626, -0.465396, -0.357271,
      -0.242183, -0.122309},
     {0,         0.0979655, 0.194681,  0.288927,  0.379537,  0.46543,   0.54563,     0.61929,    0.685706,  0.744337,
      0.794809,  0.83692,   0.870647,  0.896136,  0.913694,  0.923782,  0.926992,    0.924035,   0.915714,  0.902902,
      0.886518,  0.867503,  0.846791,  0.825289,  0.803851,  0.783261,  0.764212,    0.747295,   0.732985,  0.721634,
      0.713472,  0.708599,  0.706998,  0.708537,  0.712981,  0.720004,  0.729209,    0.74014,    0.752303,  0.765184,
      0.778268,  0.791056,  0.803081,  0.813928,  0.823237,  0.830724,  0.836178,    0.839473,   0.840568,  0.8395,
      0.836387,  0.831417,  0.824841,  0.816958,  0.808108,  0.798654,  0.788971,    0.779432,   0.770391,  0.762177,
      0.755076,  0.749326,  0.745109,  0.742544,  0.741688,  0.742531,  0.744999,    0.748962,   0.754235,  0.760591,
      0.767763,  0.775464,  0.783391,  0.791239,  0.798711,  0.805533,  0.811457,    0.816274,   0.819823,  0.82199,
      0.822716,  0.821998,  0.819885,  0.816481,  0.811934,  0.806434,  0.800203,    0.793489,   0.786553,  0.779663,
      0.773079,  0.767048,  0.761794,  0.757507,  0.754339,  0.752398,  0.751746,    0.752394,   0.754304,  0.757392,
      0.761528,  0.766547,  0.772248,  0.77841,   0.784792,  0.791152,  0.797245,    0.802842,   0.807731,  0.811732,
      0.814696,  0.816516,  0.81713,   0.816519,  0.814712,  0.811784,  0.807852,    0.803069,   0.797621,  0.791718,
      0.785589,  0.779466,  0.773585,  0.76817,   0.763427,  0.759537,  0.756648,    0.754869,   0.754268,  0.754869,
      0.756648,  0.759537,  0.763427,  0.76817,   0.773585,  0.779466,  0.785589,    0.791718,   0.797621,  0.803069,
      0.807852,  0.811784,  0.814712,  0.816519,  0.81713,   0.816516,  0.814696,    0.811732,   0.807731,  0.802842,
      0.797245,  0.791152,  0.784792,  0.77841,   0.772248,  0.766547,  0.761528,    0.757392,   0.754304,  0.752394,
      0.751746,  0.752398,  0.754339,  0.757507,  0.761794,  0.767048,  0.773079,    0.779663,   0.786553,  0.793489,
      0.800203,  0.806434,  0.811934,  0.816481,  0.819885,  0.821998,  0.822716,    0.82199,    0.819823,  0.816274,
      0.811457,  0.805533,  0.798711,  0.791239,  0.783391,  0.775464,  0.767763,    0.760591,   0.754235,  0.748962,
      0.744999,  0.742531,  0.741688,  0.742544,  0.745109,  0.749326,  0.755076,    0.762177,   0.770391,  0.779432,
      0.788971,  0.798654,  0.808108,  0.816958,  0.824841,  0.831417,  0.836387,    0.8395,     0.840568,  0.839473,
      0.836178,  0.830724,  0.823237,  0.813928,  0.803081,  0.791056,  0.778268,    0.765184,   0.752303,  0.74014,
      0.729209,  0.720004,  0.712981,  0.708537,  0.706998,  0.708599,  0.713472,    0.721634,   0.732985,  0.747295,
      0.764212,  0.783261,  0.803851,  0.825289,  0.846791,  0.867503,  0.886518,    0.902902,   0.915714,  0.924035,
      0.926992,  0.923782,  0.913694,  0.896136,  0.870647,  0.83692,   0.794809,    0.744337,   0.685706,  0.61929,
      0.54563,   0.46543,   0.379537,  0.288927,  0.194681,  0.0979655, 1.26625e-15, -0.0979655, -0.194681, -0.288927,
      -0.379537, -0.46543,  -0.54563,  -0.61929,  -0.685706, -0.744337, -0.794809,   -0.83692,   -0.870647, -0.896136,
      -0.913694, -0.923782, -0.926992, -0.924035, -0.915714, -0.902902, -0.886518,   -0.867503,  -0.846791, -0.825289,
      -0.803851, -0.783261, -0.764212, -0.747295, -0.732985, -0.721634, -0.713472,   -0.708599,  -0.706998, -0.708537,
      -0.712981, -0.720004, -0.729209, -0.74014,  -0.752303, -0.765184, -0.778268,   -0.791056,  -0.803081, -0.813928,
      -0.823237, -0.830724, -0.836178, -0.839473, -0.840568, -0.8395,   -0.836387,   -0.831417,  -0.824841, -0.816958,
      -0.808108, -0.798654, -0.788971, -0.779432, -0.770391, -0.762177, -0.755076,   -0.749326,  -0.745109, -0.742544,
      -0.741688, -0.742531, -0.744999, -0.748962, -0.754235, -0.760591, -0.767763,   -0.775464,  -0.783391, -0.791239,
      -0.798711, -0.805533, -0.811457, -0.816274, -0.819823, -0.82199,  -0.822716,   -0.821998,  -0.819885, -0.816481,
      -0.811934, -0.806434, -0.800203, -0.793489, -0.786553, -0.779663, -0.773079,   -0.767048,  -0.761794, -0.757507,
      -0.754339, -0.752398, -0.751746, -0.752394, -0.754304, -0.757392, -0.761528,   -0.766547,  -0.772248, -0.77841,
      -0.784792, -0.791152, -0.797245, -0.802842, -0.807731, -0.811732, -0.814696,   -0.816516,  -0.81713,  -0.816519,
      -0.814712, -0.811784, -0.807852, -0.803069, -0.797621, -0.791718, -0.785589,   -0.779466,  -0.773585, -0.76817,
      -0.763427, -0.759537, -0.756648, -0.754869, -0.754268, -0.754869, -0.756648,   -0.759537,  -0.763427, -0.76817,
      -0.773585, -0.779466, -0.785589, -0.791718, -0.797621, -0.803069, -0.807852,   -0.811784,  -0.814712, -0.816519,
      -0.81713,  -0.816516, -0.814696, -0.811732, -0.807731, -0.802842, -0.797245,   -0.791152,  -0.784792, -0.77841,
      -0.772248, -0.766547, -0.761528, -0.757392, -0.754304, -0.752394, -0.751746,   -0.752398,  -0.754339, -0.757507,
      -0.761794, -0.767048, -0.773079, -0.779663, -0.786553, -0.793489, -0.800203,   -0.806434,  -0.811934, -0.816481,
      -0.819885, -0.821998, -0.822716, -0.82199,  -0.819823, -0.816274, -0.811457,   -0.805533,  -0.798711, -0.791239,
      -0.783391, -0.775464, -0.767763, -0.760591, -0.754235, -0.748962, -0.744999,   -0.742531,  -0.741688, -0.742544,
      -0.745109, -0.749326, -0.755076, -0.762177, -0.770391, -0.779432, -0.788971,   -0.798654,  -0.808108, -0.816958,
      -0.824841, -0.831417, -0.836387, -0.8395,   -0.840568, -0.839473, -0.836178,   -0.830724,  -0.823237, -0.813928,
      -0.803081, -0.791056, -0.778268, -0.765184, -0.752303, -0.74014,  -0.729209,   -0.720004,  -0.712981, -0.708537,
      -0.706998, -0.708599, -0.713472, -0.721634, -0.732985, -0.747295, -0.764212,   -0.783261,  -0.803851, -0.825289,
      -0.846791, -0.867503, -0.886518, -0.902902, -0.915714, -0.924035, -0.926992,   -0.923782,  -0.913694, -0.896136,
      -0.870647, -0.83692,  -0.794809, -0.744337, -0.685706, -0.61929,  -0.54563,    -0.46543,   -0.379537, -0.288927,
      -0.194681, -0.0979655},
     {0,         0.073543,  0.146559,  0.218528,  0.288944,  0.357318,  0.423191,    0.486132,  0.54575,   0.601693,
      0.653657,  0.701385,  0.744674,  0.783372,  0.817386,  0.846673,  0.87125,     0.891184,  0.906595,  0.917651,
      0.924566,  0.927596,  0.927032,  0.923199,  0.916447,  0.907147,  0.895687,    0.882461,  0.867869,  0.852304,
      0.836156,  0.819796,  0.803578,  0.787834,  0.772864,  0.758939,  0.746296,    0.735134,  0.725612,  0.717852,
      0.711933,  0.707897,  0.705744,  0.705438,  0.70691,   0.710056,  0.714742,    0.720812,  0.728085,  0.736363,
      0.745436,  0.755084,  0.765085,  0.775215,  0.785256,  0.794998,  0.804244,    0.812812,  0.820542,  0.827293,
      0.832949,  0.83742,   0.840641,  0.842578,  0.843221,  0.842589,  0.840725,    0.837697,  0.833597,  0.828536,
      0.822641,  0.816058,  0.808938,  0.801446,  0.793747,  0.78601,   0.7784,      0.771077,  0.764192,  0.757884,
      0.752277,  0.747481,  0.743583,  0.740653,  0.738739,  0.737867,  0.73804,     0.73924,   0.741427,  0.744542,
      0.748505,  0.753223,  0.758585,  0.764468,  0.770742,  0.777267,  0.783901,    0.790502,  0.796929,  0.803045,
      0.808723,  0.813845,  0.818306,  0.822016,  0.824902,  0.826908,  0.827998,    0.828154,  0.82738,   0.825697,
      0.823147,  0.819791,  0.815703,  0.810976,  0.805714,  0.800031,  0.794053,    0.787908,  0.781728,  0.775646,
      0.769793,  0.764294,  0.759266,  0.754816,  0.751038,  0.748014,  0.745807,    0.744463,  0.744012,  0.744463,
      0.745807,  0.748014,  0.751038,  0.754816,  0.759266,  0.764294,  0.769793,    0.775646,  0.781728,  0.787908,
      0.794053,  0.800031,  0.805714,  0.810976,  0.815703,  0.819791,  0.823147,    0.825697,  0.82738,   0.828154,
      0.827998,  0.826908,  0.824902,  0.822016,  0.818306,  0.813845,  0.808723,    0.803045,  0.796929,  0.790502,
      0.783901,  0.777267,  0.770742,  0.764468,  0.758585,  0.753223,  0.748505,    0.744542,  0.741427,  0.73924,
      0.73804,   0.737867,  0.738739,  0.740653,  0.743583,  0.747481,  0.752277,    0.757884,  0.764192,  0.771077,
      0.7784,    0.78601,   0.793747,  0.801446,  0.808938,  0.816058,  0.822641,    0.828536,  0.833597,  0.837697,
      0.840725,  0.842589,  0.843221,  0.842578,  0.840641,  0.83742,   0.832949,    0.827293,  0.820542,  0.812812,
      0.804244,  0.794998,  0.785256,  0.775215,  0.765085,  0.755084,  0.745436,    0.736363,  0.728085,  0.720812,
      0.714742,  0.710056,  0.70691,   0.705438,  0.705744,  0.707897,  0.711933,    0.717852,  0.725612,  0.735134,
      0.746296,  0.758939,  0.772864,  0.787834,  0.803578,  0.819796,  0.836156,    0.852304,  0.867869,  0.882461,
      0.895687,  0.907147,  0.916447,  0.923199,  0.927032,  0.927596,  0.924566,    0.917651,  0.906595,  0.891184,
      0.87125,   0.846673,  0.817386,  0.783372,  0.744674,  0.701385,  0.653657,    0.601693,  0.54575,   0.486132,
      0.423191,  0.357318,  0.288944,  0.218528,  0.146559,  0.073543,  1.05776e-15, -0.073543, -0.146559, -0.218528,
      -0.288944, -0.357318, -0.423191, -0.486132, -0.54575,  -0.601693, -0.653657,   -0.701385, -0.744674, -0.783372,
      -0.817386, -0.846673, -0.87125,  -0.891184, -0.906595, -0.917651, -0.924566,   -0.927596, -0.927032, -0.923199,
      -0.916447, -0.907147, -0.895687, -0.882461, -0.867869, -0.852304, -0.836156,   -0.819796, -0.803578, -0.787834,
      -0.772864, -0.758939, -0.746296, -0.735134, -0.725612, -0.717852, -0.711933,   -0.707897, -0.705744, -0.705438,
      -0.70691,  -0.710056, -0.714742, -0.720812, -0.728085, -0.736363, -0.745436,   -0.755084, -0.765085, -0.775215,
      -0.785256, -0.794998, -0.804244, -0.812812, -0.820542, -0.827293, -0.832949,   -0.83742,  -0.840641, -0.842578,
      -0.843221, -0.842589, -0.840725, -0.837697, -0.833597, -0.828536, -0.822641,   -0.816058, -0.808938, -0.801446,
      -0.793747, -0.78601,  -0.7784,   -0.771077, -0.764192, -0.757884, -0.752277,   -0.747481, -0.743583, -0.740653,
      -0.738739, -0.737867, -0.73804,  -0.73924,  -0.741427, -0.744542, -0.748505,   -0.753223, -0.758585, -0.764468,
      -0.770742, -0.777267, -0.783901, -0.790502, -0.796929, -0.803045, -0.808723,   -0.813845, -0.818306, -0.822016,
      -0.824902, -0.826908, -0.827998, -0.828154, -0.82738,  -0.825697, -0.823147,   -0.819791, -0.815703, -0.810976,
      -0.805714, -0.800031, -0.794053, -0.787908, -0.781728, -0.775646, -0.769793,   -0.764294, -0.759266, -0.754816,
      -0.751038, -0.748014, -0.745807, -0.744463, -0.744012, -0.744463, -0.745807,   -0.748014, -0.751038, -0.754816,
      -0.759266, -0.764294, -0.769793, -0.775646, -0.781728, -0.787908, -0.794053,   -0.800031, -0.805714, -0.810976,
      -0.815703, -0.819791, -0.823147, -0.825697, -0.82738,  -0.828154, -0.827998,   -0.826908, -0.824902, -0.822016,
      -0.818306, -0.813845, -0.808723, -0.803045, -0.796929, -0.790502, -0.783901,   -0.777267, -0.770742, -0.764468,
      -0.758585, -0.753223, -0.748505, -0.744542, -0.741427, -0.73924,  -0.73804,    -0.737867, -0.738739, -0.740653,
      -0.743583, -0.747481, -0.752277, -0.757884, -0.764192, -0.771077, -0.7784,     -0.78601,  -0.793747, -0.801446,
      -0.808938, -0.816058, -0.822641, -0.828536, -0.833597, -0.837697, -0.840725,   -0.842589, -0.843221, -0.842578,
      -0.840641, -0.83742,  -0.832949, -0.827293, -0.820542, -0.812812, -0.804244,   -0.794998, -0.785256, -0.775215,
      -0.765085, -0.755084, -0.745436, -0.736363, -0.728085, -0.720812, -0.714742,   -0.710056, -0.70691,  -0.705438,
      -0.705744, -0.707897, -0.711933, -0.717852, -0.725612, -0.735134, -0.746296,   -0.758939, -0.772864, -0.787834,
      -0.803578, -0.819796, -0.836156, -0.852304, -0.867869, -0.882461, -0.895687,   -0.907147, -0.916447, -0.923199,
      -0.927032, -0.927596, -0.924566, -0.917651, -0.906595, -0.891184, -0.87125,    -0.846673, -0.817386, -0.783372,
      -0.744674, -0.701385, -0.653657, -0.601693, -0.54575,  -0.486132, -0.423191,   -0.357318, -0.288944, -0.218528,
      -0.146559, -0.073543},
     {0,         0.0613084, 0.122313,  0.182711,  0.242207,  0.300513,  0.35735,     0.412454,   0.465575,  0.516481,
      0.564957,  0.610811,  0.653874,  0.693999,  0.731065,  0.764976,  0.795662,    0.823081,   0.847216,  0.868076,
      0.885698,  0.900141,  0.91149,   0.919853,  0.925357,  0.928153,  0.928405,    0.926296,   0.922023,  0.915793,
      0.907823,  0.898339,  0.887567,  0.87574,   0.863089,  0.849841,  0.836221,    0.822446,   0.808722,  0.795248,
      0.782207,  0.769769,  0.75809,   0.747305,  0.737536,  0.728884,  0.72143,     0.715237,   0.710349,  0.706789,
      0.704562,  0.703654,  0.704035,  0.705655,  0.708451,  0.712346,  0.717249,    0.723058,   0.729661,  0.736938,
      0.744764,  0.75301,   0.761543,  0.77023,   0.778939,  0.787542,  0.795916,    0.803941,   0.811508,  0.818515,
      0.824873,  0.830499,  0.835328,  0.839303,  0.842383,  0.84454,   0.845759,    0.84604,    0.845394,  0.843848,
      0.84144,   0.838219,  0.834246,  0.829591,  0.824334,  0.818561,  0.812366,    0.805844,   0.799099,  0.792232,
      0.785345,  0.778543,  0.771924,  0.765584,  0.759613,  0.754097,  0.749112,    0.744726,   0.740998,  0.737978,
      0.735704,  0.734202,  0.733489,  0.733567,  0.734431,  0.736061,  0.738428,    0.74149,    0.745199,  0.749495,
      0.75431,   0.759571,  0.765197,  0.771102,  0.777197,  0.783391,  0.789592,    0.795707,   0.801646,  0.807321,
      0.812648,  0.817549,  0.821951,  0.825792,  0.829014,  0.83157,   0.833423,    0.834545,   0.834921,  0.834545,
      0.833423,  0.83157,   0.829014,  0.825792,  0.821951,  0.817549,  0.812648,    0.807321,   0.801646,  0.795707,
      0.789592,  0.783391,  0.777197,  0.771102,  0.765197,  0.759571,  0.75431,     0.749495,   0.745199,  0.74149,
      0.738428,  0.736061,  0.734431,  0.733567,  0.733489,  0.734202,  0.735704,    0.737978,   0.740998,  0.744726,
      0.749112,  0.754097,  0.759613,  0.765584,  0.771924,  0.778543,  0.785345,    0.792232,   0.799099,  0.805844,
      0.812366,  0.818561,  0.824334,  0.829591,  0.834246,  0.838219,  0.84144,     0.843848,   0.845394,  0.84604,
      0.845759,  0.84454,   0.842383,  0.839303,  0.835328,  0.830499,  0.824873,    0.818515,   0.811508,  0.803941,
      0.795916,  0.787542,  0.778939,  0.77023,   0.761543,  0.75301,   0.744764,    0.736938,   0.729661,  0.723058,
      0.717249,  0.712346,  0.708451,  0.705655,  0.704035,  0.703654,  0.704562,    0.706789,   0.710349,  0.715237,
      0.72143,   0.728884,  0.737536,  0.747305,  0.75809,   0.769769,  0.782207,    0.795248,   0.808722,  0.822446,
      0.836221,  0.849841,  0.863089,  0.87574,   0.887567,  0.898339,  0.907823,    0.915793,   0.922023,  0.926296,
      0.928405,  0.928153,  0.925357,  0.919853,  0.91149,   0.900141,  0.885698,    0.868076,   0.847216,  0.823081,
      0.795662,  0.764976,  0.731065,  0.693999,  0.653874,  0.610811,  0.564957,    0.516481,   0.465575,  0.412454,
      0.35735,   0.300513,  0.242207,  0.182711,  0.122313,  0.0613084, 6.12323e-16, -0.0613084, -0.122313, -0.182711,
      -0.242207, -0.300513, -0.35735,  -0.412454, -0.465575, -0.516481, -0.564957,   -0.610811,  -0.653874, -0.693999,
      -0.731065, -0.764976, -0.795662, -0.823081, -0.847216, -0.868076, -0.885698,   -0.900141,  -0.91149,  -0.919853,
      -0.925357, -0.928153, -0.928405, -0.926296, -0.922023, -0.915793, -0.907823,   -0.898339,  -0.887567, -0.87574,
      -0.863089, -0.849841, -0.836221, -0.822446, -0.808722, -0.795248, -0.782207,   -0.769769,  -0.75809,  -0.747305,
      -0.737536, -0.728884, -0.72143,  -0.715237, -0.710349, -0.706789, -0.704562,   -0.703654,  -0.704035, -0.705655,
      -0.708451, -0.712346, -0.717249, -0.723058, -0.729661, -0.736938, -0.744764,   -0.75301,   -0.761543, -0.77023,
      -0.778939, -0.787542, -0.795916, -0.803941, -0.811508, -0.818515, -0.824873,   -0.830499,  -0.835328, -0.839303,
      -0.842383, -0.84454,  -0.845759, -0.84604,  -0.845394, -0.843848, -0.84144,    -0.838219,  -0.834246, -0.829591,
      -0.824334, -0.818561, -0.812366, -0.805844, -0.799099, -0.792232, -0.785345,   -0.778543,  -0.771924, -0.765584,
      -0.759613, -0.754097, -0.749112, -0.744726, -0.740998, -0.737978, -0.735704,   -0.734202,  -0.733489, -0.733567,
      -0.734431, -0.736061, -0.738428, -0.74149,  -0.745199, -0.749495, -0.75431,    -0.759571,  -0.765197, -0.771102,
      -0.777197, -0.783391, -0.789592, -0.795707, -0.801646, -0.807321, -0.812648,   -0.817549,  -0.821951, -0.825792,
      -0.829014, -0.83157,  -0.833423, -0.834545, -0.834921, -0.834545, -0.833423,   -0.83157,   -0.829014, -0.825792,
      -0.821951, -0.817549, -0.812648, -0.807321, -0.801646, -0.795707, -0.789592,   -0.783391,  -0.777197, -0.771102,
      -0.765197, -0.759571, -0.75431,  -0.749495, -0.745199, -0.74149,  -0.738428,   -0.736061,  -0.734431, -0.733567,
      -0.733489, -0.734202, -0.735704, -0.737978, -0.740998, -0.744726, -0.749112,   -0.754097,  -0.759613, -0.765584,
      -0.771924, -0.778543, -0.785345, -0.792232, -0.799099, -0.805844, -0.812366,   -0.818561,  -0.824334, -0.829591,
      -0.834246, -0.838219, -0.84144,  -0.843848, -0.845394, -0.84604,  -0.845759,   -0.84454,   -0.842383, -0.839303,
      -0.835328, -0.830499, -0.824873, -0.818515, -0.811508, -0.803941, -0.795916,   -0.787542,  -0.778939, -0.77023,
      -0.761543, -0.75301,  -0.744764, -0.736938, -0.729661, -0.723058, -0.717249,   -0.712346,  -0.708451, -0.705655,
      -0.704035, -0.703654, -0.704562, -0.706789, -0.710349, -0.715237, -0.72143,    -0.728884,  -0.737536, -0.747305,
      -0.75809,  -0.769769, -0.782207, -0.795248, -0.808722, -0.822446, -0.836221,   -0.849841,  -0.863089, -0.87574,
      -0.887567, -0.898339, -0.907823, -0.915793, -0.922023, -0.926296, -0.928405,   -0.928153,  -0.925357, -0.919853,
      -0.91149,  -0.900141, -0.885698, -0.868076, -0.847216, -0.823081, -0.795662,   -0.764976,  -0.731065, -0.693999,
      -0.653874, -0.610811, -0.564957, -0.516481, -0.465575, -0.412454, -0.35735,    -0.300513,  -0.242207, -0.182711,
      -0.122313, -0.0613084},
     {0,         0.0490615, 0.097968,  0.146565,  0.194701,  0.242225,  0.288991,    0.334857,   0.379685,  0.423345,
      0.46571,   0.506663,  0.546093,  0.583899,  0.619987,  0.654275,  0.686686,    0.717158,   0.745637,  0.772079,
      0.796452,  0.818735,  0.838915,  0.856994,  0.87298,   0.886895,  0.89877,     0.908645,   0.916571,  0.922606,
      0.926819,  0.929285,  0.930088,  0.929316,  0.927068,  0.923443,  0.918549,    0.912497,   0.905399,  0.897372,
      0.888534,  0.879003,  0.8689,    0.858341,  0.847445,  0.836326,  0.825096,    0.813864,   0.802734,  0.791808,
      0.781178,  0.770933,  0.761157,  0.751925,  0.743305,  0.735359,  0.72814,     0.721694,   0.716059,  0.711265,
      0.707332,  0.704275,  0.702099,  0.700801,  0.700372,  0.700794,  0.702043,    0.704088,   0.706892,  0.710411,
      0.714597,  0.719397,  0.724752,  0.730601,  0.73688,   0.743522,  0.750456,    0.757614,   0.764922,  0.772311,
      0.77971,   0.787048,  0.794257,  0.801273,  0.808031,  0.814472,  0.820539,    0.826182,   0.831353,  0.836008,
      0.840112,  0.843632,  0.846541,  0.848821,  0.850456,  0.851438,  0.851765,    0.85144,    0.850474,  0.84888,
      0.846681,  0.843902,  0.840575,  0.836735,  0.832422,  0.827682,  0.822562,    0.817112,   0.811388,  0.805443,
      0.799337,  0.793127,  0.786873,  0.780635,  0.77447,   0.768438,  0.762594,    0.756994,   0.751689,  0.746729,
      0.74216,   0.738023,  0.734358,  0.731197,  0.728571,  0.726502,  0.725011,    0.724111,   0.72381,   0.724111,
      0.725011,  0.726502,  0.728571,  0.731197,  0.734358,  0.738023,  0.74216,     0.746729,   0.751689,  0.756994,
      0.762594,  0.768438,  0.77447,   0.780635,  0.786873,  0.793127,  0.799337,    0.805443,   0.811388,  0.817112,
      0.822562,  0.827682,  0.832422,  0.836735,  0.840575,  0.843902,  0.846681,    0.84888,    0.850474,  0.85144,
      0.851765,  0.851438,  0.850456,  0.848821,  0.846541,  0.843632,  0.840112,    0.836008,   0.831353,  0.826182,
      0.820539,  0.814472,  0.808031,  0.801273,  0.794257,  0.787048,  0.77971,     0.772311,   0.764922,  0.757614,
      0.750456,  0.743522,  0.73688,   0.730601,  0.724752,  0.719397,  0.714597,    0.710411,   0.706892,  0.704088,
      0.702043,  0.700794,  0.700372,  0.700801,  0.702099,  0.704275,  0.707332,    0.711265,   0.716059,  0.721694,
      0.72814,   0.735359,  0.743305,  0.751925,  0.761157,  0.770933,  0.781178,    0.791808,   0.802734,  0.813864,
      0.825096,  0.836326,  0.847445,  0.858341,  0.8689,    0.879003,  0.888534,    0.897372,   0.905399,  0.912497,
      0.918549,  0.923443,  0.927068,  0.929316,  0.930088,  0.929285,  0.926819,    0.922606,   0.916571,  0.908645,
      0.89877,   0.886895,  0.87298,   0.856994,  0.838915,  0.818735,  0.796452,    0.772079,   0.745637,  0.717158,
      0.686686,  0.654275,  0.619987,  0.583899,  0.546093,  0.506663,  0.46571,     0.423345,   0.379685,  0.334857,
      0.288991,  0.242225,  0.194701,  0.146565,  0.097968,  0.0490615, 4.89859e-16, -0.0490615, -0.097968, -0.146565,
      -0.194701, -0.242225, -0.288991, -0.334857, -0.379685, -0.423345, -0.46571,    -0.506663,  -0.546093, -0.583899,
      -0.619987, -0.654275, -0.686686, -0.717158, -0.745637, -0.772079, -0.796452,   -0.818735,  -0.838915, -0.856994,
      -0.87298,  -0.886895, -0.89877,  -0.908645, -0.916571, -0.922606, -0.926819,   -0.929285,  -0.930088, -0.929316,
      -0.927068, -0.923443, -0.918549, -0.912497, -0.905399, -0.897372, -0.888534,   -0.879003,  -0.8689,   -0.858341,
      -0.847445, -0.836326, -0.825096, -0.813864, -0.802734, -0.791808, -0.781178,   -0.770933,  -0.761157, -0.751925,
      -0.743305, -0.735359, -0.72814,  -0.721694, -0.716059, -0.711265, -0.707332,   -0.704275,  -0.702099, -0.700801,
      -0.700372, -0.700794, -0.702043, -0.704088, -0.706892, -0.710411, -0.714597,   -0.719397,  -0.724752, -0.730601,
      -0.73688,  -0.743522, -0.750456, -0.757614, -0.764922, -0.772311, -0.77971,    -0.787048,  -0.794257, -0.801273,
      -0.808031, -0.814472, -0.820539, -0.826182, -0.831353, -0.836008, -0.840112,   -0.843632,  -0.846541, -0.848821,
      -0.850456, -0.851438, -0.851765, -0.85144,  -0.850474, -0.84888,  -0.846681,   -0.843902,  -0.840575, -0.836735,
      -0.832422, -0.827682, -0.822562, -0.817112, -0.811388, -0.805443, -0.799337,   -0.793127,  -0.786873, -0.780635,
      -0.77447,  -0.768438, -0.762594, -0.756994, -0.751689, -0.746729, -0.74216,    -0.738023,  -0.734358, -0.731197,
      -0.728571, -0.726502, -0.725011, -0.724111, -0.72381,  -0.724111, -0.725011,   -0.726502,  -0.728571, -0.731197,
      -0.734358, -0.738023, -0.74216,  -0.746729, -0.751689, -0.756994, -0.762594,   -0.768438,  -0.77447,  -0.780635,
      -0.786873, -0.793127, -0.799337, -0.805443, -0.811388, -0.817112, -0.822562,   -0.827682,  -0.832422, -0.836735,
      -0.840575, -0.843902, -0.846681, -0.84888,  -0.850474, -0.85144,  -0.851765,   -0.851438,  -0.850456, -0.848821,
      -0.846541, -0.843632, -0.840112, -0.836008, -0.831353, -0.826182, -0.820539,   -0.814472,  -0.808031, -0.801273,
      -0.794257, -0.787048, -0.77971,  -0.772311, -0.764922, -0.757614, -0.750456,   -0.743522,  -0.73688,  -0.730601,
      -0.724752, -0.719397, -0.714597, -0.710411, -0.706892, -0.704088, -0.702043,   -0.700794,  -0.700372, -0.700801,
      -0.702099, -0.704275, -0.707332, -0.711265, -0.716059, -0.721694, -0.72814,    -0.735359,  -0.743305, -0.751925,
      -0.761157, -0.770933, -0.781178, -0.791808, -0.802734, -0.813864, -0.825096,   -0.836326,  -0.847445, -0.858341,
      -0.8689,   -0.879003, -0.888534, -0.897372, -0.905399, -0.912497, -0.918549,   -0.923443,  -0.927068, -0.929316,
      -0.930088, -0.929285, -0.926819, -0.922606, -0.916571, -0.908645, -0.89877,    -0.886895,  -0.87298,  -0.856994,
      -0.838915, -0.818735, -0.796452, -0.772079, -0.745637, -0.717158, -0.686686,   -0.654275,  -0.619987, -0.583899,
      -0.546093, -0.506663, -0.46571,  -0.423345, -0.379685, -0.334857, -0.288991,   -0.242225,  -0.194701, -0.146565,
      -0.097968, -0.0490615},
     {0,          0.0368047, 0.0735448, 0.110156,  0.146574,  0.182735,  0.218577,    0.254038,   0.289058,   0.323577,
      0.357537,   0.390883,  0.42356,   0.455517,  0.486703,  0.51707,   0.546574,    0.575171,   0.602823,   0.629491,
      0.655141,   0.679743,  0.703268,  0.725691,  0.746991,  0.767149,  0.786149,    0.80398,    0.820634,   0.836105,
      0.850391,   0.863494,  0.875418,  0.886173,  0.895767,  0.904217,  0.91154,     0.917755,   0.922886,   0.926959,
      0.930003,   0.932049,  0.93313,   0.933283,  0.932545,  0.930956,  0.92856,     0.925398,   0.921516,   0.91696,
      0.911779,   0.90602,   0.899733,  0.892968,  0.885775,  0.878205,  0.870309,    0.862138,   0.853742,   0.84517,
      0.836474,   0.8277,    0.818897,  0.810111,  0.801387,  0.79277,   0.784302,    0.776022,   0.767971,   0.760185,
      0.752699,   0.745545,  0.738754,  0.732354,  0.726371,  0.720828,  0.715745,    0.711141,   0.707031,   0.703428,
      0.700342,   0.697782,  0.695751,  0.694253,  0.693287,  0.692849,  0.692936,    0.693538,   0.694647,   0.696249,
      0.698329,   0.700871,  0.703856,  0.707263,  0.71107,   0.715251,  0.719782,    0.724634,   0.72978,    0.735189,
      0.740831,   0.746673,  0.752684,  0.758831,  0.76508,   0.771397,  0.77775,     0.784104,   0.790426,   0.796683,
      0.802843,   0.808873,  0.814743,  0.820423,  0.825884,  0.831098,  0.836038,    0.84068,    0.845,      0.848976,
      0.85259,    0.855822,  0.858656,  0.861078,  0.863077,  0.864642,  0.865765,    0.866442,   0.866668,   0.866442,
      0.865765,   0.864642,  0.863077,  0.861078,  0.858656,  0.855822,  0.85259,     0.848976,   0.845,      0.84068,
      0.836038,   0.831098,  0.825884,  0.820423,  0.814743,  0.808873,  0.802843,    0.796683,   0.790426,   0.784104,
      0.77775,    0.771397,  0.76508,   0.758831,  0.752684,  0.746673,  0.740831,    0.735189,   0.72978,    0.724634,
      0.719782,   0.715251,  0.71107,   0.707263,  0.703856,  0.700871,  0.698329,    0.696249,   0.694647,   0.693538,
      0.692936,   0.692849,  0.693287,  0.694253,  0.695751,  0.697782,  0.700342,    0.703428,   0.707031,   0.711141,
      0.715745,   0.720828,  0.726371,  0.732354,  0.738754,  0.745545,  0.752699,    0.760185,   0.767971,   0.776022,
      0.784302,   0.79277,   0.801387,  0.810111,  0.818897,  0.8277,    0.836474,    0.84517,    0.853742,   0.862138,
      0.870309,   0.878205,  0.885775,  0.892968,  0.899733,  0.90602,   0.911779,    0.91696,    0.921516,   0.925398,
      0.92856,    0.930956,  0.932545,  0.933283,  0.93313,   0.932049,  0.930003,    0.926959,   0.922886,   0.917755,
      0.91154,    0.904217,  0.895767,  0.886173,  0.875418,  0.863494,  0.850391,    0.836105,   0.820634,   0.80398,
      0.786149,   0.767149,  0.746991,  0.725691,  0.703268,  0.679743,  0.655141,    0.629491,   0.602823,   0.575171,
      0.546574,   0.51707,   0.486703,  0.455517,  0.42356,   0.390883,  0.357537,    0.323577,   0.289058,   0.254038,
      0.218577,   0.182735,  0.146574,  0.110156,  0.0735448, 0.0368047, 3.67394e-16, -0.0368047, -0.0735448, -0.110156,
      -0.146574,  -0.182735, -0.218577, -0.254038, -0.289058, -0.323577, -0.357537,   -0.390883,  -0.42356,   -0.455517,
      -0.486703,  -0.51707,  -0.546574, -0.575171, -0.602823, -0.629491, -0.655141,   -0.679743,  -0.703268,  -0.725691,
      -0.746991,  -0.767149, -0.786149, -0.80398,  -0.820634, -0.836105, -0.850391,   -0.863494,  -0.875418,  -0.886173,
      -0.895767,  -0.904217, -0.91154,  -0.917755, -0.922886, -0.926959, -0.930003,   -0.932049,  -0.93313,   -0.933283,
      -0.932545,  -0.930956, -0.92856,  -0.925398, -0.921516, -0.91696,  -0.911779,   -0.90602,   -0.899733,  -0.892968,
      -0.885775,  -0.878205, -0.870309, -0.862138, -0.853742, -0.84517,  -0.836474,   -0.8277,    -0.818897,  -0.810111,
      -0.801387,  -0.79277,  -0.784302, -0.776022, -0.767971, -0.760185, -0.752699,   -0.745545,  -0.738754,  -0.732354,
      -0.726371,  -0.720828, -0.715745, -0.711141, -0.707031, -0.703428, -0.700342,   -0.697782,  -0.695751,  -0.694253,
      -0.693287,  -0.692849, -0.692936, -0.693538, -0.694647, -0.696249, -0.698329,   -0.700871,  -0.703856,  -0.707263,
      -0.71107,   -0.715251, -0.719782, -0.724634, -0.72978,  -0.735189, -0.740831,   -0.746673,  -0.752684,  -0.758831,
      -0.76508,   -0.771397, -0.77775,  -0.784104, -0.790426, -0.796683, -0.802843,   -0.808873,  -0.814743,  -0.820423,
      -0.825884,  -0.831098, -0.836038, -0.84068,  -0.845,    -0.848976, -0.85259,    -0.855822,  -0.858656,  -0.861078,
      -0.863077,  -0.864642, -0.865765, -0.866442, -0.866668, -0.866442, -0.865765,   -0.864642,  -0.863077,  -0.861078,
      -0.858656,  -0.855822, -0.85259,  -0.848976, -0.845,    -0.84068,  -0.836038,   -0.831098,  -0.825884,  -0.820423,
      -0.814743,  -0.808873, -0.802843, -0.796683, -0.790426, -0.784104, -0.77775,    -0.771397,  -0.76508,   -0.758831,
      -0.752684,  -0.746673, -0.740831, -0.735189, -0.72978,  -0.724634, -0.719782,   -0.715251,  -0.71107,   -0.707263,
      -0.703856,  -0.700871, -0.698329, -0.696249, -0.694647, -0.693538, -0.692936,   -0.692849,  -0.693287,  -0.694253,
      -0.695751,  -0.697782, -0.700342, -0.703428, -0.707031, -0.711141, -0.715745,   -0.720828,  -0.726371,  -0.732354,
      -0.738754,  -0.745545, -0.752699, -0.760185, -0.767971, -0.776022, -0.784302,   -0.79277,   -0.801387,  -0.810111,
      -0.818897,  -0.8277,   -0.836474, -0.84517,  -0.853742, -0.862138, -0.870309,   -0.878205,  -0.885775,  -0.892968,
      -0.899733,  -0.90602,  -0.911779, -0.91696,  -0.921516, -0.925398, -0.92856,    -0.930956,  -0.932545,  -0.933283,
      -0.93313,   -0.932049, -0.930003, -0.926959, -0.922886, -0.917755, -0.91154,    -0.904217,  -0.895767,  -0.886173,
      -0.875418,  -0.863494, -0.850391, -0.836105, -0.820634, -0.80398,  -0.786149,   -0.767149,  -0.746991,  -0.725691,
      -0.703268,  -0.679743, -0.655141, -0.629491, -0.602823, -0.575171, -0.546574,   -0.51707,   -0.486703,  -0.455517,
      -0.42356,   -0.390883, -0.357537, -0.323577, -0.289058, -0.254038, -0.218577,   -0.182735,  -0.146574,  -0.110156,
      -0.0735448, -0.0368047},
     {0,          0.0368047, 0.0735448, 0.110156,  0.146574,  0.182735,  0.218577,    0.254038,   0.289058,   0.323577,
      0.357537,   0.390883,  0.42356,   0.455517,  0.486703,  0.51707,   0.546574,    0.575171,   0.602823,   0.629491,
      0.655141,   0.679743,  0.703268,  0.725691,  0.746991,  0.767149,  0.786149,    0.80398,    0.820634,   0.836105,
      0.850391,   0.863494,  0.875418,  0.886173,  0.895767,  0.904217,  0.91154,     0.917755,   0.922886,   0.926959,
      0.930003,   0.932049,  0.93313,   0.933283,  0.932545,  0.930956,  0.92856,     0.925398,   0.921516,   0.91696,
      0.911779,   0.90602,   0.899733,  0.892968,  0.885775,  0.878205,  0.870309,    0.862138,   0.853742,   0.84517,
      0.836474,   0.8277,    0.818897,  0.810111,  0.801387,  0.79277,   0.784302,    0.776022,   0.767971,   0.760185,
      0.752699,   0.745545,  0.738754,  0.732354,  0.726371,  0.720828,  0.715745,    0.711141,   0.707031,   0.703428,
      0.700342,   0.697782,  0.695751,  0.694253,  0.693287,  0.692849,  0.692936,    0.693538,   0.694647,   0.696249,
      0.698329,   0.700871,  0.703856,  0.707263,  0.71107,   0.715251,  0.719782,    0.724634,   0.72978,    0.735189,
      0.740831,   0.746673,  0.752684,  0.758831,  0.76508,   0.771397,  0.77775,     0.784104,   0.790426,   0.796683,
      0.802843,   0.808873,  0.814743,  0.820423,  0.825884,  0.831098,  0.836038,    0.84068,    0.845,      0.848976,
      0.85259,    0.855822,  0.858656,  0.861078,  0.863077,  0.864642,  0.865765,    0.866442,   0.866668,   0.866442,
      0.865765,   0.864642,  0.863077,  0.861078,  0.858656,  0.855822,  0.85259,     0.848976,   0.845,      0.84068,
      0.836038,   0.831098,  0.825884,  0.820423,  0.814743,  0.808873,  0.802843,    0.796683,   0.790426,   0.784104,
      0.77775,    0.771397,  0.76508,   0.758831,  0.752684,  0.746673,  0.740831,    0.735189,   0.72978,    0.724634,
      0.719782,   0.715251,  0.71107,   0.707263,  0.703856,  0.700871,  0.698329,    0.696249,   0.694647,   0.693538,
      0.692936,   0.692849,  0.693287,  0.694253,  0.695751,  0.697782,  0.700342,    0.703428,   0.707031,   0.711141,
      0.715745,   0.720828,  0.726371,  0.732354,  0.738754,  0.745545,  0.752699,    0.760185,   0.767971,   0.776022,
      0.784302,   0.79277,   0.801387,  0.810111,  0.818897,  0.8277,    0.836474,    0.84517,    0.853742,   0.862138,
      0.870309,   0.878205,  0.885775,  0.892968,  0.899733,  0.90602,   0.911779,    0.91696,    0.921516,   0.925398,
      0.92856,    0.930956,  0.932545,  0.933283,  0.93313,   0.932049,  0.930003,    0.926959,   0.922886,   0.917755,
      0.91154,    0.904217,  0.895767,  0.886173,  0.875418,  0.863494,  0.850391,    0.836105,   0.820634,   0.80398,
      0.786149,   0.767149,  0.746991,  0.725691,  0.703268,  0.679743,  0.655141,    0.629491,   0.602823,   0.575171,
      0.546574,   0.51707,   0.486703,  0.455517,  0.42356,   0.390883,  0.357537,    0.323577,   0.289058,   0.254038,
      0.218577,   0.182735,  0.146574,  0.110156,  0.0735448, 0.0368047, 3.67394e-16, -0.0368047, -0.0735448, -0.110156,
      -0.146574,  -0.182735, -0.218577, -0.254038, -0.289058, -0.323577, -0.357537,   -0.390883,  -0.42356,   -0.455517,
      -0.486703,  -0.51707,  -0.546574, -0.575171, -0.602823, -0.629491, -0.655141,   -0.679743,  -0.703268,  -0.725691,
      -0.746991,  -0.767149, -0.786149, -0.80398,  -0.820634, -0.836105, -0.850391,   -0.863494,  -0.875418,  -0.886173,
      -0.895767,  -0.904217, -0.91154,  -0.917755, -0.922886, -0.926959, -0.930003,   -0.932049,  -0.93313,   -0.933283,
      -0.932545,  -0.930956, -0.92856,  -0.925398, -0.921516, -0.91696,  -0.911779,   -0.90602,   -0.899733,  -0.892968,
      -0.885775,  -0.878205, -0.870309, -0.862138, -0.853742, -0.84517,  -0.836474,   -0.8277,    -0.818897,  -0.810111,
      -0.801387,  -0.79277,  -0.784302, -0.776022, -0.767971, -0.760185, -0.752699,   -0.745545,  -0.738754,  -0.732354,
      -0.726371,  -0.720828, -0.715745, -0.711141, -0.707031, -0.703428, -0.700342,   -0.697782,  -0.695751,  -0.694253,
      -0.693287,  -0.692849, -0.692936, -0.693538, -0.694647, -0.696249, -0.698329,   -0.700871,  -0.703856,  -0.707263,
      -0.71107,   -0.715251, -0.719782, -0.724634, -0.72978,  -0.735189, -0.740831,   -0.746673,  -0.752684,  -0.758831,
      -0.76508,   -0.771397, -0.77775,  -0.784104, -0.790426, -0.796683, -0.802843,   -0.808873,  -0.814743,  -0.820423,
      -0.825884,  -0.831098, -0.836038, -0.84068,  -0.845,    -0.848976, -0.85259,    -0.855822,  -0.858656,  -0.861078,
      -0.863077,  -0.864642, -0.865765, -0.866442, -0.866668, -0.866442, -0.865765,   -0.864642,  -0.863077,  -0.861078,
      -0.858656,  -0.855822, -0.85259,  -0.848976, -0.845,    -0.84068,  -0.836038,   -0.831098,  -0.825884,  -0.820423,
      -0.814743,  -0.808873, -0.802843, -0.796683, -0.790426, -0.784104, -0.77775,    -0.771397,  -0.76508,   -0.758831,
      -0.752684,  -0.746673, -0.740831, -0.735189, -0.72978,  -0.724634, -0.719782,   -0.715251,  -0.71107,   -0.707263,
      -0.703856,  -0.700871, -0.698329, -0.696249, -0.694647, -0.693538, -0.692936,   -0.692849,  -0.693287,  -0.694253,
      -0.695751,  -0.697782, -0.700342, -0.703428, -0.707031, -0.711141, -0.715745,   -0.720828,  -0.726371,  -0.732354,
      -0.738754,  -0.745545, -0.752699, -0.760185, -0.767971, -0.776022, -0.784302,   -0.79277,   -0.801387,  -0.810111,
      -0.818897,  -0.8277,   -0.836474, -0.84517,  -0.853742, -0.862138, -0.870309,   -0.878205,  -0.885775,  -0.892968,
      -0.899733,  -0.90602,  -0.911779, -0.91696,  -0.921516, -0.925398, -0.92856,    -0.930956,  -0.932545,  -0.933283,
      -0.93313,   -0.932049, -0.930003, -0.926959, -0.922886, -0.917755, -0.91154,    -0.904217,  -0.895767,  -0.886173,
      -0.875418,  -0.863494, -0.850391, -0.836105, -0.820634, -0.80398,  -0.786149,   -0.767149,  -0.746991,  -0.725691,
      -0.703268,  -0.679743, -0.655141, -0.629491, -0.602823, -0.575171, -0.546574,   -0.51707,   -0.486703,  -0.455517,
      -0.42356,   -0.390883, -0.357537, -0.323577, -0.289058, -0.254038, -0.218577,   -0.182735,  -0.146574,  -0.110156,
      -0.0735448, -0.0368047},
     {0,         0.0245406, 0.0490627, 0.0735479, 0.0979777,   0.122334,   0.146598,   0.170752,   0.194778,
      0.218659,  0.242375,  0.265911,  0.289248,  0.312371,    0.335261,   0.357903,   0.38028,    0.402377,
      0.424178,  0.445668,  0.466833,  0.487657,  0.508128,    0.528231,   0.547954,   0.567284,   0.586209,
      0.604718,  0.622799,  0.640441,  0.657636,  0.674372,    0.690642,   0.706438,   0.72175,    0.736572,
      0.750898,  0.764721,  0.778036,  0.790839,  0.803124,    0.814889,   0.82613,    0.836846,   0.847034,
      0.856693,  0.865823,  0.874425,  0.882498,  0.890044,    0.897066,   0.903566,   0.909546,   0.915012,
      0.919967,  0.924417,  0.928366,  0.931822,  0.93479,     0.937278,   0.939294,   0.940846,   0.941943,
      0.942594,  0.942808,  0.942597,  0.941971,  0.94094,     0.939517,   0.937713,   0.935541,   0.933013,
      0.930142,  0.926942,  0.923427,  0.919609,  0.915504,    0.911126,   0.906489,   0.901609,   0.8965,
      0.891177,  0.885657,  0.879954,  0.874084,  0.868063,    0.861907,   0.85563,    0.849249,   0.84278,
      0.836237,  0.829638,  0.822996,  0.816328,  0.809649,    0.802975,   0.796319,   0.789697,   0.783123,
      0.776612,  0.770177,  0.763833,  0.757593,  0.75147,     0.745476,   0.739626,   0.73393,    0.7284,
      0.723048,  0.717885,  0.712921,  0.708166,  0.703629,    0.699321,   0.695249,   0.691422,   0.687848,
      0.684532,  0.681483,  0.678705,  0.676205,  0.673988,    0.672057,   0.670417,   0.669071,   0.668021,
      0.66727,   0.666818,  0.666667,  0.666818,  0.66727,     0.668021,   0.669071,   0.670417,   0.672057,
      0.673988,  0.676205,  0.678705,  0.681483,  0.684532,    0.687848,   0.691422,   0.695249,   0.699321,
      0.703629,  0.708166,  0.712921,  0.717885,  0.723048,    0.7284,     0.73393,    0.739626,   0.745476,
      0.75147,   0.757593,  0.763833,  0.770177,  0.776612,    0.783123,   0.789697,   0.796319,   0.802975,
      0.809649,  0.816328,  0.822996,  0.829638,  0.836237,    0.84278,    0.849249,   0.85563,    0.861907,
      0.868063,  0.874084,  0.879954,  0.885657,  0.891177,    0.8965,     0.901609,   0.906489,   0.911126,
      0.915504,  0.919609,  0.923427,  0.926942,  0.930142,    0.933013,   0.935541,   0.937713,   0.939517,
      0.94094,   0.941971,  0.942597,  0.942808,  0.942594,    0.941943,   0.940846,   0.939294,   0.937278,
      0.93479,   0.931822,  0.928366,  0.924417,  0.919967,    0.915012,   0.909546,   0.903566,   0.897066,
      0.890044,  0.882498,  0.874425,  0.865823,  0.856693,    0.847034,   0.836846,   0.82613,    0.814889,
      0.803124,  0.790839,  0.778036,  0.764721,  0.750898,    0.736572,   0.72175,    0.706438,   0.690642,
      0.674372,  0.657636,  0.640441,  0.622799,  0.604718,    0.586209,   0.567284,   0.547954,   0.528231,
      0.508128,  0.487657,  0.466833,  0.445668,  0.424178,    0.402377,   0.38028,    0.357903,   0.335261,
      0.312371,  0.289248,  0.265911,  0.242375,  0.218659,    0.194778,   0.170752,   0.146598,   0.122334,
      0.0979777, 0.0735479, 0.0490627, 0.0245406, 2.44929e-16, -0.0245406, -0.0490627, -0.0735479, -0.0979777,
      -0.122334, -0.146598, -0.170752, -0.194778, -0.218659,   -0.242375,  -0.265911,  -0.289248,  -0.312371,
      -0.335261, -0.357903, -0.38028,  -0.402377, -0.424178,   -0.445668,  -0.466833,  -0.487657,  -0.508128,
      -0.528231, -0.547954, -0.567284, -0.586209, -0.604718,   -0.622799,  -0.640441,  -0.657636,  -0.674372,
      -0.690642, -0.706438, -0.72175,  -0.736572, -0.750898,   -0.764721,  -0.778036,  -0.790839,  -0.803124,
      -0.814889, -0.82613,  -0.836846, -0.847034, -0.856693,   -0.865823,  -0.874425,  -0.882498,  -0.890044,
      -0.897066, -0.903566, -0.909546, -0.915012, -0.919967,   -0.924417,  -0.928366,  -0.931822,  -0.93479,
      -0.937278, -0.939294, -0.940846, -0.941943, -0.942594,   -0.942808,  -0.942597,  -0.941971,  -0.94094,
      -0.939517, -0.937713, -0.935541, -0.933013, -0.930142,   -0.926942,  -0.923427,  -0.919609,  -0.915504,
      -0.911126, -0.906489, -0.901609, -0.8965,   -0.891177,   -0.885657,  -0.879954,  -0.874084,  -0.868063,
      -0.861907, -0.85563,  -0.849249, -0.84278,  -0.836237,   -0.829638,  -0.822996,  -0.816328,  -0.809649,
      -0.802975, -0.796319, -0.789697, -0.783123, -0.776612,   -0.770177,  -0.763833,  -0.757593,  -0.75147,
      -0.745476, -0.739626, -0.73393,  -0.7284,   -0.723048,   -0.717885,  -0.712921,  -0.708166,  -0.703629,
      -0.699321, -0.695249, -0.691422, -0.687848, -0.684532,   -0.681483,  -0.678705,  -0.676205,  -0.673988,
      -0.672057, -0.670417, -0.669071, -0.668021, -0.66727,    -0.666818,  -0.666667,  -0.666818,  -0.66727,
      -0.668021, -0.669071, -0.670417, -0.672057, -0.673988,   -0.676205,  -0.678705,  -0.681483,  -0.684532,
      -0.687848, -0.691422, -0.695249, -0.699321, -0.703629,   -0.708166,  -0.712921,  -0.717885,  -0.723048,
      -0.7284,   -0.73393,  -0.739626, -0.745476, -0.75147,    -0.757593,  -0.763833,  -0.770177,  -0.776612,
      -0.783123, -0.789697, -0.796319, -0.802975, -0.809649,   -0.816328,  -0.822996,  -0.829638,  -0.836237,
      -0.84278,  -0.849249, -0.85563,  -0.861907, -0.868063,   -0.874084,  -0.879954,  -0.885657,  -0.891177,
      -0.8965,   -0.901609, -0.906489, -0.911126, -0.915504,   -0.919609,  -0.923427,  -0.926942,  -0.930142,
      -0.933013, -0.935541, -0.937713, -0.939517, -0.94094,    -0.941971,  -0.942597,  -0.942808,  -0.942594,
      -0.941943, -0.940846, -0.939294, -0.937278, -0.93479,    -0.931822,  -0.928366,  -0.924417,  -0.919967,
      -0.915012, -0.909546, -0.903566, -0.897066, -0.890044,   -0.882498,  -0.874425,  -0.865823,  -0.856693,
      -0.847034, -0.836846, -0.82613,  -0.814889, -0.803124,   -0.790839,  -0.778036,  -0.764721,  -0.750898,
      -0.736572, -0.72175,  -0.706438, -0.690642, -0.674372,   -0.657636,  -0.640441,  -0.622799,  -0.604718,
      -0.586209, -0.567284, -0.547954, -0.528231, -0.508128,   -0.487657,  -0.466833,  -0.445668,  -0.424178,
      -0.402377, -0.38028,  -0.357903, -0.335261, -0.312371,   -0.289248,  -0.265911,  -0.242375,  -0.218659,
      -0.194778, -0.170752, -0.146598, -0.122334, -0.0979777,  -0.0735479, -0.0490627, -0.0245406},
     {0,         0.0245406, 0.0490627, 0.0735479, 0.0979777,   0.122334,   0.146598,   0.170752,   0.194778,
      0.218659,  0.242375,  0.265911,  0.289248,  0.312371,    0.335261,   0.357903,   0.38028,    0.402377,
      0.424178,  0.445668,  0.466833,  0.487657,  0.508128,    0.528231,   0.547954,   0.567284,   0.586209,
      0.604718,  0.622799,  0.640441,  0.657636,  0.674372,    0.690642,   0.706438,   0.72175,    0.736572,
      0.750898,  0.764721,  0.778036,  0.790839,  0.803124,    0.814889,   0.82613,    0.836846,   0.847034,
      0.856693,  0.865823,  0.874425,  0.882498,  0.890044,    0.897066,   0.903566,   0.909546,   0.915012,
      0.919967,  0.924417,  0.928366,  0.931822,  0.93479,     0.937278,   0.939294,   0.940846,   0.941943,
      0.942594,  0.942808,  0.942597,  0.941971,  0.94094,     0.939517,   0.937713,   0.935541,   0.933013,
      0.930142,  0.926942,  0.923427,  0.919609,  0.915504,    0.911126,   0.906489,   0.901609,   0.8965,
      0.891177,  0.885657,  0.879954,  0.874084,  0.868063,    0.861907,   0.85563,    0.849249,   0.84278,
      0.836237,  0.829638,  0.822996,  0.816328,  0.809649,    0.802975,   0.796319,   0.789697,   0.783123,
      0.776612,  0.770177,  0.763833,  0.757593,  0.75147,     0.745476,   0.739626,   0.73393,    0.7284,
      0.723048,  0.717885,  0.712921,  0.708166,  0.703629,    0.699321,   0.695249,   0.691422,   0.687848,
      0.684532,  0.681483,  0.678705,  0.676205,  0.673988,    0.672057,   0.670417,   0.669071,   0.668021,
      0.66727,   0.666818,  0.666667,  0.666818,  0.66727,     0.668021,   0.669071,   0.670417,   0.672057,
      0.673988,  0.676205,  0.678705,  0.681483,  0.684532,    0.687848,   0.691422,   0.695249,   0.699321,
      0.703629,  0.708166,  0.712921,  0.717885,  0.723048,    0.7284,     0.73393,    0.739626,   0.745476,
      0.75147,   0.757593,  0.763833,  0.770177,  0.776612,    0.783123,   0.789697,   0.796319,   0.802975,
      0.809649,  0.816328,  0.822996,  0.829638,  0.836237,    0.84278,    0.849249,   0.85563,    0.861907,
      0.868063,  0.874084,  0.879954,  0.885657,  0.891177,    0.8965,     0.901609,   0.906489,   0.911126,
      0.915504,  0.919609,  0.923427,  0.926942,  0.930142,    0.933013,   0.935541,   0.937713,   0.939517,
      0.94094,   0.941971,  0.942597,  0.942808,  0.942594,    0.941943,   0.940846,   0.939294,   0.937278,
      0.93479,   0.931822,  0.928366,  0.924417,  0.919967,    0.915012,   0.909546,   0.903566,   0.897066,
      0.890044,  0.882498,  0.874425,  0.865823,  0.856693,    0.847034,   0.836846,   0.82613,    0.814889,
      0.803124,  0.790839,  0.778036,  0.764721,  0.750898,    0.736572,   0.72175,    0.706438,   0.690642,
      0.674372,  0.657636,  0.640441,  0.622799,  0.604718,    0.586209,   0.567284,   0.547954,   0.528231,
      0.508128,  0.487657,  0.466833,  0.445668,  0.424178,    0.402377,   0.38028,    0.357903,   0.335261,
      0.312371,  0.289248,  0.265911,  0.242375,  0.218659,    0.194778,   0.170752,   0.146598,   0.122334,
      0.0979777, 0.0735479, 0.0490627, 0.0245406, 2.44929e-16, -0.0245406, -0.0490627, -0.0735479, -0.0979777,
      -0.122334, -0.146598, -0.170752, -0.194778, -0.218659,   -0.242375,  -0.265911,  -0.289248,  -0.312371,
      -0.335261, -0.357903, -0.38028,  -0.402377, -0.424178,   -0.445668,  -0.466833,  -0.487657,  -0.508128,
      -0.528231, -0.547954, -0.567284, -0.586209, -0.604718,   -0.622799,  -0.640441,  -0.657636,  -0.674372,
      -0.690642, -0.706438, -0.72175,  -0.736572, -0.750898,   -0.764721,  -0.778036,  -0.790839,  -0.803124,
      -0.814889, -0.82613,  -0.836846, -0.847034, -0.856693,   -0.865823,  -0.874425,  -0.882498,  -0.890044,
      -0.897066, -0.903566, -0.909546, -0.915012, -0.919967,   -0.924417,  -0.928366,  -0.931822,  -0.93479,
      -0.937278, -0.939294, -0.940846, -0.941943, -0.942594,   -0.942808,  -0.942597,  -0.941971,  -0.94094,
      -0.939517, -0.937713, -0.935541, -0.933013, -0.930142,   -0.926942,  -0.923427,  -0.919609,  -0.915504,
      -0.911126, -0.906489, -0.901609, -0.8965,   -0.891177,   -0.885657,  -0.879954,  -0.874084,  -0.868063,
      -0.861907, -0.85563,  -0.849249, -0.84278,  -0.836237,   -0.829638,  -0.822996,  -0.816328,  -0.809649,
      -0.802975, -0.796319, -0.789697, -0.783123, -0.776612,   -0.770177,  -0.763833,  -0.757593,  -0.75147,
      -0.745476, -0.739626, -0.73393,  -0.7284,   -0.723048,   -0.717885,  -0.712921,  -0.708166,  -0.703629,
      -0.699321, -0.695249, -0.691422, -0.687848, -0.684532,   -0.681483,  -0.678705,  -0.676205,  -0.673988,
      -0.672057, -0.670417, -0.669071, -0.668021, -0.66727,    -0.666818,  -0.666667,  -0.666818,  -0.66727,
      -0.668021, -0.669071, -0.670417, -0.672057, -0.673988,   -0.676205,  -0.678705,  -0.681483,  -0.684532,
      -0.687848, -0.691422, -0.695249, -0.699321, -0.703629,   -0.708166,  -0.712921,  -0.717885,  -0.723048,
      -0.7284,   -0.73393,  -0.739626, -0.745476, -0.75147,    -0.757593,  -0.763833,  -0.770177,  -0.776612,
      -0.783123, -0.789697, -0.796319, -0.802975, -0.809649,   -0.816328,  -0.822996,  -0.829638,  -0.836237,
      -0.84278,  -0.849249, -0.85563,  -0.861907, -0.868063,   -0.874084,  -0.879954,  -0.885657,  -0.891177,
      -0.8965,   -0.901609, -0.906489, -0.911126, -0.915504,   -0.919609,  -0.923427,  -0.926942,  -0.930142,
      -0.933013, -0.935541, -0.937713, -0.939517, -0.94094,    -0.941971,  -0.942597,  -0.942808,  -0.942594,
      -0.941943, -0.940846, -0.939294, -0.937278, -0.93479,    -0.931822,  -0.928366,  -0.924417,  -0.919967,
      -0.915012, -0.909546, -0.903566, -0.897066, -0.890044,   -0.882498,  -0.874425,  -0.865823,  -0.856693,
      -0.847034, -0.836846, -0.82613,  -0.814889, -0.803124,   -0.790839,  -0.778036,  -0.764721,  -0.750898,
      -0.736572, -0.72175,  -0.706438, -0.690642, -0.674372,   -0.657636,  -0.640441,  -0.622799,  -0.604718,
      -0.586209, -0.567284, -0.547954, -0.528231, -0.508128,   -0.487657,  -0.466833,  -0.445668,  -0.424178,
      -0.402377, -0.38028,  -0.357903, -0.335261, -0.312371,   -0.289248,  -0.265911,  -0.242375,  -0.218659,
      -0.194778, -0.170752, -0.146598, -0.122334, -0.0979777,  -0.0735479, -0.0490627, -0.0245406},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966977,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983106,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983106,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966977,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966977,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983106,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983106,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966977,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966977,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983106,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983106,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966977,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966977,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983106,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983106,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966977,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715},
     {0,          0.0122715,  0.0245412,  0.0368072,  0.0490677,   0.0613207,  0.0735646,  0.0857973,  0.0980171,
      0.110222,   0.122411,   0.134581,   0.14673,    0.158858,    0.170962,   0.18304,    0.19509,    0.207111,
      0.219101,   0.231058,   0.24298,    0.254866,   0.266713,    0.27852,    0.290285,   0.302006,   0.313682,
      0.32531,    0.33689,    0.348419,   0.359895,   0.371317,    0.382683,   0.393992,   0.405241,   0.41643,
      0.427555,   0.438616,   0.449611,   0.460539,   0.471397,    0.482184,   0.492898,   0.503538,   0.514103,
      0.52459,    0.534998,   0.545325,   0.55557,    0.565732,    0.575808,   0.585798,   0.595699,   0.605511,
      0.615232,   0.62486,    0.634393,   0.643832,   0.653173,    0.662416,   0.671559,   0.680601,   0.689541,
      0.698376,   0.707107,   0.715731,   0.724247,   0.732654,    0.740951,   0.749136,   0.757209,   0.765167,
      0.77301,    0.780737,   0.788346,   0.795837,   0.803208,    0.810457,   0.817585,   0.824589,   0.83147,
      0.838225,   0.844854,   0.851355,   0.857729,   0.863973,    0.870087,   0.87607,    0.881921,   0.88764,
      0.893224,   0.898674,   0.903989,   0.909168,   0.91421,     0.919114,   0.92388,    0.928506,   0.932993,
      0.937339,   0.941544,   0.945607,   0.949528,   0.953306,    0.95694,    0.960431,   0.963776,   0.966977,
      0.970031,   0.97294,    0.975702,   0.978317,   0.980785,    0.983106,   0.985278,   0.987301,   0.989177,
      0.990903,   0.99248,    0.993907,   0.995185,   0.996313,    0.99729,    0.998118,   0.998795,   0.999322,
      0.999699,   0.999925,   1,          0.999925,   0.999699,    0.999322,   0.998795,   0.998118,   0.99729,
      0.996313,   0.995185,   0.993907,   0.99248,    0.990903,    0.989177,   0.987301,   0.985278,   0.983106,
      0.980785,   0.978317,   0.975702,   0.97294,    0.970031,    0.966977,   0.963776,   0.960431,   0.95694,
      0.953306,   0.949528,   0.945607,   0.941544,   0.937339,    0.932993,   0.928506,   0.92388,    0.919114,
      0.91421,    0.909168,   0.903989,   0.898674,   0.893224,    0.88764,    0.881921,   0.87607,    0.870087,
      0.863973,   0.857729,   0.851355,   0.844854,   0.838225,    0.83147,    0.824589,   0.817585,   0.810457,
      0.803208,   0.795837,   0.788346,   0.780737,   0.77301,     0.765167,   0.757209,   0.749136,   0.740951,
      0.732654,   0.724247,   0.715731,   0.707107,   0.698376,    0.689541,   0.680601,   0.671559,   0.662416,
      0.653173,   0.643832,   0.634393,   0.62486,    0.615232,    0.605511,   0.595699,   0.585798,   0.575808,
      0.565732,   0.55557,    0.545325,   0.534998,   0.52459,     0.514103,   0.503538,   0.492898,   0.482184,
      0.471397,   0.460539,   0.449611,   0.438616,   0.427555,    0.41643,    0.405241,   0.393992,   0.382683,
      0.371317,   0.359895,   0.348419,   0.33689,    0.32531,     0.313682,   0.302006,   0.290285,   0.27852,
      0.266713,   0.254866,   0.24298,    0.231058,   0.219101,    0.207111,   0.19509,    0.18304,    0.170962,
      0.158858,   0.14673,    0.134581,   0.122411,   0.110222,    0.0980171,  0.0857973,  0.0735646,  0.0613207,
      0.0490677,  0.0368072,  0.0245412,  0.0122715,  1.22465e-16, -0.0122715, -0.0245412, -0.0368072, -0.0490677,
      -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.110222,   -0.122411,  -0.134581,  -0.14673,   -0.158858,
      -0.170962,  -0.18304,   -0.19509,   -0.207111,  -0.219101,   -0.231058,  -0.24298,   -0.254866,  -0.266713,
      -0.27852,   -0.290285,  -0.302006,  -0.313682,  -0.32531,    -0.33689,   -0.348419,  -0.359895,  -0.371317,
      -0.382683,  -0.393992,  -0.405241,  -0.41643,   -0.427555,   -0.438616,  -0.449611,  -0.460539,  -0.471397,
      -0.482184,  -0.492898,  -0.503538,  -0.514103,  -0.52459,    -0.534998,  -0.545325,  -0.55557,   -0.565732,
      -0.575808,  -0.585798,  -0.595699,  -0.605511,  -0.615232,   -0.62486,   -0.634393,  -0.643832,  -0.653173,
      -0.662416,  -0.671559,  -0.680601,  -0.689541,  -0.698376,   -0.707107,  -0.715731,  -0.724247,  -0.732654,
      -0.740951,  -0.749136,  -0.757209,  -0.765167,  -0.77301,    -0.780737,  -0.788346,  -0.795837,  -0.803208,
      -0.810457,  -0.817585,  -0.824589,  -0.83147,   -0.838225,   -0.844854,  -0.851355,  -0.857729,  -0.863973,
      -0.870087,  -0.87607,   -0.881921,  -0.88764,   -0.893224,   -0.898674,  -0.903989,  -0.909168,  -0.91421,
      -0.919114,  -0.92388,   -0.928506,  -0.932993,  -0.937339,   -0.941544,  -0.945607,  -0.949528,  -0.953306,
      -0.95694,   -0.960431,  -0.963776,  -0.966977,  -0.970031,   -0.97294,   -0.975702,  -0.978317,  -0.980785,
      -0.983106,  -0.985278,  -0.987301,  -0.989177,  -0.990903,   -0.99248,   -0.993907,  -0.995185,  -0.996313,
      -0.99729,   -0.998118,  -0.998795,  -0.999322,  -0.999699,   -0.999925,  -1,         -0.999925,  -0.999699,
      -0.999322,  -0.998795,  -0.998118,  -0.99729,   -0.996313,   -0.995185,  -0.993907,  -0.99248,   -0.990903,
      -0.989177,  -0.987301,  -0.985278,  -0.983106,  -0.980785,   -0.978317,  -0.975702,  -0.97294,   -0.970031,
      -0.966977,  -0.963776,  -0.960431,  -0.95694,   -0.953306,   -0.949528,  -0.945607,  -0.941544,  -0.937339,
      -0.932993,  -0.928506,  -0.92388,   -0.919114,  -0.91421,    -0.909168,  -0.903989,  -0.898674,  -0.893224,
      -0.88764,   -0.881921,  -0.87607,   -0.870087,  -0.863973,   -0.857729,  -0.851355,  -0.844854,  -0.838225,
      -0.83147,   -0.824589,  -0.817585,  -0.810457,  -0.803208,   -0.795837,  -0.788346,  -0.780737,  -0.77301,
      -0.765167,  -0.757209,  -0.749136,  -0.740951,  -0.732654,   -0.724247,  -0.715731,  -0.707107,  -0.698376,
      -0.689541,  -0.680601,  -0.671559,  -0.662416,  -0.653173,   -0.643832,  -0.634393,  -0.62486,   -0.615232,
      -0.605511,  -0.595699,  -0.585798,  -0.575808,  -0.565732,   -0.55557,   -0.545325,  -0.534998,  -0.52459,
      -0.514103,  -0.503538,  -0.492898,  -0.482184,  -0.471397,   -0.460539,  -0.449611,  -0.438616,  -0.427555,
      -0.41643,   -0.405241,  -0.393992,  -0.382683,  -0.371317,   -0.359895,  -0.348419,  -0.33689,   -0.32531,
      -0.313682,  -0.302006,  -0.290285,  -0.27852,   -0.266713,   -0.254866,  -0.24298,   -0.231058,  -0.219101,
      -0.207111,  -0.19509,   -0.18304,   -0.170962,  -0.158858,   -0.14673,   -0.134581,  -0.122411,  -0.110222,
      -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677,  -0.0368072, -0.0245412, -0.0122715}},
    {{0.2715,    0.914642,  0.762941,  0.853257,  0.788574,  0.839133,  0.797524,  0.832953,  0.802048,  0.8295,
      0.804769,  0.827301,  0.806582,  0.825782,  0.807874,  0.824671,  0.808839,  0.823826,  0.809585,  0.823163,
      0.810178,  0.82263,   0.81066,   0.822193,  0.811056,  0.821831,  0.811389,  0.821526,  0.811669,  0.821266,
      0.811909,  0.821045,  0.812115,  0.820853,  0.812293,  0.820687,  0.812449,  0.820544,  0.812582,  0.820417,
      0.8127,    0.820308,  0.812801,  0.820214,  0.81289,   0.820131,  0.812967,  0.820059,  0.813033,  0.819998,
      0.813089,  0.819946,  0.813137,  0.819902,  0.813176,  0.819868,  0.813207,  0.81984,   0.813231,  0.819819,
      0.813249,  0.819806,  0.813259,  0.819799,  0.813262,  0.819799,  0.813259,  0.819806,  0.813249,  0.819819,
      0.813231,  0.81984,   0.813207,  0.819868,  0.813176,  0.819902,  0.813137,  0.819946,  0.813089,  0.819998,
      0.813033,  0.820059,  0.812967,  0.820131,  0.81289,   0.820214,  0.812801,  0.820308,  0.8127,    0.820417,
      0.812582,  0.820544,  0.812449,  0.820687,  0.812293,  0.820853,  0.812115,  0.821045,  0.811909,  0.821266,
      0.811669,  0.821526,  0.811389,  0.821831,  0.811056,  0.822193,  0.81066,   0.82263,   0.810178,  0.823163,
      0.809585,  0.823826,  0.808839,  0.824671,  0.807874,  0.825782,  0.806582,  0.827301,  0.804769,  0.8295,
      0.802048,  0.832953,  0.797524,  0.839133,  0.788574,  0.853257,  0.762941,  0.914642,  0.2715,    -0.368935,
      -0.219941, -0.307549, -0.245575, -0.293424, -0.254529, -0.28724,  -0.259055, -0.283785, -0.26178,  -0.281582,
      -0.263597, -0.280057, -0.264895, -0.278941, -0.265865, -0.278089, -0.266619, -0.277418, -0.26722,  -0.276877,
      -0.26771,  -0.276431, -0.268118, -0.276057, -0.268461, -0.275741, -0.268754, -0.275469, -0.269006, -0.275233,
      -0.269227, -0.275027, -0.269421, -0.274845, -0.269592, -0.274683, -0.269744, -0.274539, -0.269881, -0.27441,
      -0.270004, -0.274293, -0.270115, -0.274187, -0.270216, -0.274091, -0.270307, -0.274003, -0.270392, -0.273923,
      -0.270469, -0.273849, -0.27054,  -0.27378,  -0.270605, -0.273717, -0.270666, -0.273659, -0.270722, -0.273605,
      -0.270775, -0.273554, -0.270823, -0.273507, -0.270868, -0.273463, -0.270911, -0.273422, -0.270951, -0.273384,
      -0.270988, -0.273348, -0.271022, -0.273314, -0.271056, -0.273282, -0.271087, -0.273252, -0.271116, -0.273224,
      -0.271143, -0.273197, -0.271169, -0.273171, -0.271194, -0.273148, -0.271217, -0.273125, -0.271239, -0.273104,
      -0.27126,  -0.273084, -0.27128,  -0.273064, -0.271298, -0.273046, -0.271317, -0.273029, -0.271333, -0.273012,
      -0.271349, -0.272997, -0.271364, -0.272981, -0.271379, -0.272967, -0.271393, -0.272954, -0.271406, -0.272941,
      -0.271419, -0.272929, -0.271431, -0.272917, -0.271442, -0.272906, -0.271453, -0.272895, -0.271463, -0.272885,
      -0.271473, -0.272876, -0.271482, -0.272866, -0.271491, -0.272858, -0.2715,   -0.27285,  -0.271508, -0.272842,
      -0.271516, -0.272834, -0.271523, -0.272827, -0.27153,  -0.27282,  -0.271537, -0.272813, -0.271543, -0.272807,
      -0.271549, -0.272801, -0.271554, -0.272796, -0.27156,  -0.272791, -0.271565, -0.272786, -0.27157,  -0.272781,
      -0.271575, -0.272777, -0.271579, -0.272773, -0.271583, -0.272769, -0.271586, -0.272765, -0.27159,  -0.272762,
      -0.271593, -0.272759, -0.271596, -0.272756, -0.271599, -0.272753, -0.271601, -0.272751, -0.271604, -0.272749,
      -0.271606, -0.272746, -0.271608, -0.272745, -0.27161,  -0.272743, -0.271611, -0.272742, -0.271613, -0.272741,
      -0.271614, -0.27274,  -0.271615, -0.272739, -0.271615, -0.272738, -0.271616, -0.272738, -0.271616, -0.272738,
      -0.271616, -0.272738, -0.271616, -0.272738, -0.271616, -0.272738, -0.271615, -0.272739, -0.271615, -0.27274,
      -0.271614, -0.272741, -0.271612, -0.272742, -0.271611, -0.272743, -0.27161,  -0.272745, -0.271608, -0.272746,
      -0.271606, -0.272749, -0.271604, -0.272751, -0.271601, -0.272753, -0.271599, -0.272756, -0.271596, -0.272759,
      -0.271593, -0.272762, -0.27159,  -0.272765, -0.271586, -0.272769, -0.271583, -0.272773, -0.271579, -0.272777,
      -0.271575, -0.272781, -0.27157,  -0.272786, -0.271565, -0.272791, -0.27156,  -0.272796, -0.271554, -0.272801,
      -0.271549, -0.272807, -0.271543, -0.272813, -0.271537, -0.27282,  -0.27153,  -0.272827, -0.271523, -0.272834,
      -0.271516, -0.272842, -0.271508, -0.27285,  -0.2715,   -0.272858, -0.271491, -0.272866, -0.271482, -0.272876,
      -0.271473, -0.272885, -0.271463, -0.272895, -0.271453, -0.272906, -0.271442, -0.272917, -0.271431, -0.272929,
      -0.271419, -0.272941, -0.271406, -0.272954, -0.271393, -0.272967, -0.271379, -0.272981, -0.271364, -0.272997,
      -0.271349, -0.273012, -0.271333, -0.273029, -0.271317, -0.273046, -0.271298, -0.273064, -0.271279, -0.273084,
      -0.27126,  -0.273104, -0.271239, -0.273125, -0.271217, -0.273148, -0.271194, -0.273171, -0.271169, -0.273197,
      -0.271143, -0.273223, -0.271116, -0.273252, -0.271086, -0.273282, -0.271056, -0.273314, -0.271022, -0.273348,
      -0.270988, -0.273384, -0.270951, -0.273422, -0.270911, -0.273463, -0.270868, -0.273507, -0.270823, -0.273554,
      -0.270775, -0.273605, -0.270722, -0.273659, -0.270666, -0.273717, -0.270605, -0.27378,  -0.27054,  -0.273848,
      -0.270469, -0.273923, -0.270392, -0.274003, -0.270307, -0.274091, -0.270216, -0.274187, -0.270115, -0.274293,
      -0.270004, -0.27441,  -0.269881, -0.274539, -0.269744, -0.274683, -0.269592, -0.274845, -0.269421, -0.275027,
      -0.269227, -0.275233, -0.269006, -0.275469, -0.268754, -0.275741, -0.268461, -0.276057, -0.268117, -0.276431,
      -0.26771,  -0.276876, -0.26722,  -0.277418, -0.266619, -0.278089, -0.265865, -0.278941, -0.264895, -0.280057,
      -0.263597, -0.281582, -0.26178,  -0.283785, -0.259055, -0.28724,  -0.254529, -0.293424, -0.245575, -0.307549,
      -0.219941, -0.368935},
     {0.2715,    0.914642,  0.762941,  0.853257,  0.788574,  0.839133,  0.797524,  0.832953,  0.802048,  0.8295,
      0.804769,  0.827301,  0.806582,  0.825782,  0.807874,  0.824671,  0.808839,  0.823826,  0.809585,  0.823163,
      0.810178,  0.82263,   0.81066,   0.822193,  0.811056,  0.821831,  0.811389,  0.821526,  0.811669,  0.821266,
      0.811909,  0.821045,  0.812115,  0.820853,  0.812293,  0.820687,  0.812449,  0.820544,  0.812582,  0.820417,
      0.8127,    0.820308,  0.812801,  0.820214,  0.81289,   0.820131,  0.812967,  0.820059,  0.813033,  0.819998,
      0.813089,  0.819946,  0.813137,  0.819902,  0.813176,  0.819868,  0.813207,  0.81984,   0.813231,  0.819819,
      0.813249,  0.819806,  0.813259,  0.819799,  0.813262,  0.819799,  0.813259,  0.819806,  0.813249,  0.819819,
      0.813231,  0.81984,   0.813207,  0.819868,  0.813176,  0.819902,  0.813137,  0.819946,  0.813089,  0.819998,
      0.813033,  0.820059,  0.812967,  0.820131,  0.81289,   0.820214,  0.812801,  0.820308,  0.8127,    0.820417,
      0.812582,  0.820544,  0.812449,  0.820687,  0.812293,  0.820853,  0.812115,  0.821045,  0.811909,  0.821266,
      0.811669,  0.821526,  0.811389,  0.821831,  0.811056,  0.822193,  0.81066,   0.82263,   0.810178,  0.823163,
      0.809585,  0.823826,  0.808839,  0.824671,  0.807874,  0.825782,  0.806582,  0.827301,  0.804769,  0.8295,
      0.802048,  0.832953,  0.797524,  0.839133,  0.788574,  0.853257,  0.762941,  0.914642,  0.2715,    -0.368935,
      -0.219941, -0.307549, -0.245575, -0.293424, -0.254529, -0.28724,  -0.259055, -0.283785, -0.26178,  -0.281582,
      -0.263597, -0.280057, -0.264895, -0.278941, -0.265865, -0.278089, -0.266619, -0.277418, -0.26722,  -0.276877,
      -0.26771,  -0.276431, -0.268118, -0.276057, -0.268461, -0.275741, -0.268754, -0.275469, -0.269006, -0.275233,
      -0.269227, -0.275027, -0.269421, -0.274845, -0.269592, -0.274683, -0.269744, -0.274539, -0.269881, -0.27441,
      -0.270004, -0.274293, -0.270115, -0.274187, -0.270216, -0.274091, -0.270307, -0.274003, -0.270392, -0.273923,
      -0.270469, -0.273849, -0.27054,  -0.27378,  -0.270605, -0.273717, -0.270666, -0.273659, -0.270722, -0.273605,
      -0.270775, -0.273554, -0.270823, -0.273507, -0.270868, -0.273463, -0.270911, -0.273422, -0.270951, -0.273384,
      -0.270988, -0.273348, -0.271022, -0.273314, -0.271056, -0.273282, -0.271087, -0.273252, -0.271116, -0.273224,
      -0.271143, -0.273197, -0.271169, -0.273171, -0.271194, -0.273148, -0.271217, -0.273125, -0.271239, -0.273104,
      -0.27126,  -0.273084, -0.27128,  -0.273064, -0.271298, -0.273046, -0.271317, -0.273029, -0.271333, -0.273012,
      -0.271349, -0.272997, -0.271364, -0.272981, -0.271379, -0.272967, -0.271393, -0.272954, -0.271406, -0.272941,
      -0.271419, -0.272929, -0.271431, -0.272917, -0.271442, -0.272906, -0.271453, -0.272895, -0.271463, -0.272885,
      -0.271473, -0.272876, -0.271482, -0.272866, -0.271491, -0.272858, -0.2715,   -0.27285,  -0.271508, -0.272842,
      -0.271516, -0.272834, -0.271523, -0.272827, -0.27153,  -0.27282,  -0.271537, -0.272813, -0.271543, -0.272807,
      -0.271549, -0.272801, -0.271554, -0.272796, -0.27156,  -0.272791, -0.271565, -0.272786, -0.27157,  -0.272781,
      -0.271575, -0.272777, -0.271579, -0.272773, -0.271583, -0.272769, -0.271586, -0.272765, -0.27159,  -0.272762,
      -0.271593, -0.272759, -0.271596, -0.272756, -0.271599, -0.272753, -0.271601, -0.272751, -0.271604, -0.272749,
      -0.271606, -0.272746, -0.271608, -0.272745, -0.27161,  -0.272743, -0.271611, -0.272742, -0.271613, -0.272741,
      -0.271614, -0.27274,  -0.271615, -0.272739, -0.271615, -0.272738, -0.271616, -0.272738, -0.271616, -0.272738,
      -0.271616, -0.272738, -0.271616, -0.272738, -0.271616, -0.272738, -0.271615, -0.272739, -0.271615, -0.27274,
      -0.271614, -0.272741, -0.271612, -0.272742, -0.271611, -0.272743, -0.27161,  -0.272745, -0.271608, -0.272746,
      -0.271606, -0.272749, -0.271604, -0.272751, -0.271601, -0.272753, -0.271599, -0.272756, -0.271596, -0.272759,
      -0.271593, -0.272762, -0.27159,  -0.272765, -0.271586, -0.272769, -0.271583, -0.272773, -0.271579, -0.272777,
      -0.271575, -0.272781, -0.27157,  -0.272786, -0.271565, -0.272791, -0.27156,  -0.272796, -0.271554, -0.272801,
      -0.271549, -0.272807, -0.271543, -0.272813, -0.271537, -0.27282,  -0.27153,  -0.272827, -0.271523, -0.272834,
      -0.271516, -0.272842, -0.271508, -0.27285,  -0.2715,   -0.272858, -0.271491, -0.272866, -0.271482, -0.272876,
      -0.271473, -0.272885, -0.271463, -0.272895, -0.271453, -0.272906, -0.271442, -0.272917, -0.271431, -0.272929,
      -0.271419, -0.272941, -0.271406, -0.272954, -0.271393, -0.272967, -0.271379, -0.272981, -0.271364, -0.272997,
      -0.271349, -0.273012, -0.271333, -0.273029, -0.271317, -0.273046, -0.271298, -0.273064, -0.271279, -0.273084,
      -0.27126,  -0.273104, -0.271239, -0.273125, -0.271217, -0.273148, -0.271194, -0.273171, -0.271169, -0.273197,
      -0.271143, -0.273223, -0.271116, -0.273252, -0.271086, -0.273282, -0.271056, -0.273314, -0.271022, -0.273348,
      -0.270988, -0.273384, -0.270951, -0.273422, -0.270911, -0.273463, -0.270868, -0.273507, -0.270823, -0.273554,
      -0.270775, -0.273605, -0.270722, -0.273659, -0.270666, -0.273717, -0.270605, -0.27378,  -0.27054,  -0.273848,
      -0.270469, -0.273923, -0.270392, -0.274003, -0.270307, -0.274091, -0.270216, -0.274187, -0.270115, -0.274293,
      -0.270004, -0.27441,  -0.269881, -0.274539, -0.269744, -0.274683, -0.269592, -0.274845, -0.269421, -0.275027,
      -0.269227, -0.275233, -0.269006, -0.275469, -0.268754, -0.275741, -0.268461, -0.276057, -0.268117, -0.276431,
      -0.26771,  -0.276876, -0.26722,  -0.277418, -0.266619, -0.278089, -0.265865, -0.278941, -0.264895, -0.280057,
      -0.263597, -0.281582, -0.26178,  -0.283785, -0.259055, -0.28724,  -0.254529, -0.293424, -0.245575, -0.307549,
      -0.219941, -0.368935},
     {0.2715,    0.914642,  0.762941,  0.853257,  0.788574,  0.839133,  0.797524,  0.832953,  0.802048,  0.8295,
      0.804769,  0.827301,  0.806582,  0.825782,  0.807874,  0.824671,  0.808839,  0.823826,  0.809585,  0.823163,
      0.810178,  0.82263,   0.81066,   0.822193,  0.811056,  0.821831,  0.811389,  0.821526,  0.811669,  0.821266,
      0.811909,  0.821045,  0.812115,  0.820853,  0.812293,  0.820687,  0.812449,  0.820544,  0.812582,  0.820417,
      0.8127,    0.820308,  0.812801,  0.820214,  0.81289,   0.820131,  0.812967,  0.820059,  0.813033,  0.819998,
      0.813089,  0.819946,  0.813137,  0.819902,  0.813176,  0.819868,  0.813207,  0.81984,   0.813231,  0.819819,
      0.813249,  0.819806,  0.813259,  0.819799,  0.813262,  0.819799,  0.813259,  0.819806,  0.813249,  0.819819,
      0.813231,  0.81984,   0.813207,  0.819868,  0.813176,  0.819902,  0.813137,  0.819946,  0.813089,  0.819998,
      0.813033,  0.820059,  0.812967,  0.820131,  0.81289,   0.820214,  0.812801,  0.820308,  0.8127,    0.820417,
      0.812582,  0.820544,  0.812449,  0.820687,  0.812293,  0.820853,  0.812115,  0.821045,  0.811909,  0.821266,
      0.811669,  0.821526,  0.811389,  0.821831,  0.811056,  0.822193,  0.81066,   0.82263,   0.810178,  0.823163,
      0.809585,  0.823826,  0.808839,  0.824671,  0.807874,  0.825782,  0.806582,  0.827301,  0.804769,  0.8295,
      0.802048,  0.832953,  0.797524,  0.839133,  0.788574,  0.853257,  0.762941,  0.914642,  0.2715,    -0.368935,
      -0.219941, -0.307549, -0.245575, -0.293424, -0.254529, -0.28724,  -0.259055, -0.283785, -0.26178,  -0.281582,
      -0.263597, -0.280057, -0.264895, -0.278941, -0.265865, -0.278089, -0.266619, -0.277418, -0.26722,  -0.276877,
      -0.26771,  -0.276431, -0.268118, -0.276057, -0.268461, -0.275741, -0.268754, -0.275469, -0.269006, -0.275233,
      -0.269227, -0.275027, -0.269421, -0.274845, -0.269592, -0.274683, -0.269744, -0.274539, -0.269881, -0.27441,
      -0.270004, -0.274293, -0.270115, -0.274187, -0.270216, -0.274091, -0.270307, -0.274003, -0.270392, -0.273923,
      -0.270469, -0.273849, -0.27054,  -0.27378,  -0.270605, -0.273717, -0.270666, -0.273659, -0.270722, -0.273605,
      -0.270775, -0.273554, -0.270823, -0.273507, -0.270868, -0.273463, -0.270911, -0.273422, -0.270951, -0.273384,
      -0.270988, -0.273348, -0.271022, -0.273314, -0.271056, -0.273282, -0.271087, -0.273252, -0.271116, -0.273224,
      -0.271143, -0.273197, -0.271169, -0.273171, -0.271194, -0.273148, -0.271217, -0.273125, -0.271239, -0.273104,
      -0.27126,  -0.273084, -0.27128,  -0.273064, -0.271298, -0.273046, -0.271317, -0.273029, -0.271333, -0.273012,
      -0.271349, -0.272997, -0.271364, -0.272981, -0.271379, -0.272967, -0.271393, -0.272954, -0.271406, -0.272941,
      -0.271419, -0.272929, -0.271431, -0.272917, -0.271442, -0.272906, -0.271453, -0.272895, -0.271463, -0.272885,
      -0.271473, -0.272876, -0.271482, -0.272866, -0.271491, -0.272858, -0.2715,   -0.27285,  -0.271508, -0.272842,
      -0.271516, -0.272834, -0.271523, -0.272827, -0.27153,  -0.27282,  -0.271537, -0.272813, -0.271543, -0.272807,
      -0.271549, -0.272801, -0.271554, -0.272796, -0.27156,  -0.272791, -0.271565, -0.272786, -0.27157,  -0.272781,
      -0.271575, -0.272777, -0.271579, -0.272773, -0.271583, -0.272769, -0.271586, -0.272765, -0.27159,  -0.272762,
      -0.271593, -0.272759, -0.271596, -0.272756, -0.271599, -0.272753, -0.271601, -0.272751, -0.271604, -0.272749,
      -0.271606, -0.272746, -0.271608, -0.272745, -0.27161,  -0.272743, -0.271611, -0.272742, -0.271613, -0.272741,
      -0.271614, -0.27274,  -0.271615, -0.272739, -0.271615, -0.272738, -0.271616, -0.272738, -0.271616, -0.272738,
      -0.271616, -0.272738, -0.271616, -0.272738, -0.271616, -0.272738, -0.271615, -0.272739, -0.271615, -0.27274,
      -0.271614, -0.272741, -0.271612, -0.272742, -0.271611, -0.272743, -0.27161,  -0.272745, -0.271608, -0.272746,
      -0.271606, -0.272749, -0.271604, -0.272751, -0.271601, -0.272753, -0.271599, -0.272756, -0.271596, -0.272759,
      -0.271593, -0.272762, -0.27159,  -0.272765, -0.271586, -0.272769, -0.271583, -0.272773, -0.271579, -0.272777,
      -0.271575, -0.272781, -0.27157,  -0.272786, -0.271565, -0.272791, -0.27156,  -0.272796, -0.271554, -0.272801,
      -0.271549, -0.272807, -0.271543, -0.272813, -0.271537, -0.27282,  -0.27153,  -0.272827, -0.271523, -0.272834,
      -0.271516, -0.272842, -0.271508, -0.27285,  -0.2715,   -0.272858, -0.271491, -0.272866, -0.271482, -0.272876,
      -0.271473, -0.272885, -0.271463, -0.272895, -0.271453, -0.272906, -0.271442, -0.272917, -0.271431, -0.272929,
      -0.271419, -0.272941, -0.271406, -0.272954, -0.271393, -0.272967, -0.271379, -0.272981, -0.271364, -0.272997,
      -0.271349, -0.273012, -0.271333, -0.273029, -0.271317, -0.273046, -0.271298, -0.273064, -0.271279, -0.273084,
      -0.27126,  -0.273104, -0.271239, -0.273125, -0.271217, -0.273148, -0.271194, -0.273171, -0.271169, -0.273197,
      -0.271143, -0.273223, -0.271116, -0.273252, -0.271086, -0.273282, -0.271056, -0.273314, -0.271022, -0.273348,
      -0.270988, -0.273384, -0.270951, -0.273422, -0.270911, -0.273463, -0.270868, -0.273507, -0.270823, -0.273554,
      -0.270775, -0.273605, -0.270722, -0.273659, -0.270666, -0.273717, -0.270605, -0.27378,  -0.27054,  -0.273848,
      -0.270469, -0.273923, -0.270392, -0.274003, -0.270307, -0.274091, -0.270216, -0.274187, -0.270115, -0.274293,
      -0.270004, -0.27441,  -0.269881, -0.274539, -0.269744, -0.274683, -0.269592, -0.274845, -0.269421, -0.275027,
      -0.269227, -0.275233, -0.269006, -0.275469, -0.268754, -0.275741, -0.268461, -0.276057, -0.268117, -0.276431,
      -0.26771,  -0.276876, -0.26722,  -0.277418, -0.266619, -0.278089, -0.265865, -0.278941, -0.264895, -0.280057,
      -0.263597, -0.281582, -0.26178,  -0.283785, -0.259055, -0.28724,  -0.254529, -0.293424, -0.245575, -0.307549,
      -0.219941, -0.368935},
     {0.2715,    0.914642,  0.762941,  0.853257,  0.788574,  0.839133,  0.797524,  0.832953,  0.802048,  0.8295,
      0.804769,  0.827301,  0.806582,  0.825782,  0.807874,  0.824671,  0.808839,  0.823826,  0.809585,  0.823163,
      0.810178,  0.82263,   0.81066,   0.822193,  0.811056,  0.821831,  0.811389,  0.821526,  0.811669,  0.821266,
      0.811909,  0.821045,  0.812115,  0.820853,  0.812293,  0.820687,  0.812449,  0.820544,  0.812582,  0.820417,
      0.8127,    0.820308,  0.812801,  0.820214,  0.81289,   0.820131,  0.812967,  0.820059,  0.813033,  0.819998,
      0.813089,  0.819946,  0.813137,  0.819902,  0.813176,  0.819868,  0.813207,  0.81984,   0.813231,  0.819819,
      0.813249,  0.819806,  0.813259,  0.819799,  0.813262,  0.819799,  0.813259,  0.819806,  0.813249,  0.819819,
      0.813231,  0.81984,   0.813207,  0.819868,  0.813176,  0.819902,  0.813137,  0.819946,  0.813089,  0.819998,
      0.813033,  0.820059,  0.812967,  0.820131,  0.81289,   0.820214,  0.812801,  0.820308,  0.8127,    0.820417,
      0.812582,  0.820544,  0.812449,  0.820687,  0.812293,  0.820853,  0.812115,  0.821045,  0.811909,  0.821266,
      0.811669,  0.821526,  0.811389,  0.821831,  0.811056,  0.822193,  0.81066,   0.82263,   0.810178,  0.823163,
      0.809585,  0.823826,  0.808839,  0.824671,  0.807874,  0.825782,  0.806582,  0.827301,  0.804769,  0.8295,
      0.802048,  0.832953,  0.797524,  0.839133,  0.788574,  0.853257,  0.762941,  0.914642,  0.2715,    -0.368935,
      -0.219941, -0.307549, -0.245575, -0.293424, -0.254529, -0.28724,  -0.259055, -0.283785, -0.26178,  -0.281582,
      -0.263597, -0.280057, -0.264895, -0.278941, -0.265865, -0.278089, -0.266619, -0.277418, -0.26722,  -0.276877,
      -0.26771,  -0.276431, -0.268118, -0.276057, -0.268461, -0.275741, -0.268754, -0.275469, -0.269006, -0.275233,
      -0.269227, -0.275027, -0.269421, -0.274845, -0.269592, -0.274683, -0.269744, -0.274539, -0.269881, -0.27441,
      -0.270004, -0.274293, -0.270115, -0.274187, -0.270216, -0.274091, -0.270307, -0.274003, -0.270392, -0.273923,
      -0.270469, -0.273849, -0.27054,  -0.27378,  -0.270605, -0.273717, -0.270666, -0.273659, -0.270722, -0.273605,
      -0.270775, -0.273554, -0.270823, -0.273507, -0.270868, -0.273463, -0.270911, -0.273422, -0.270951, -0.273384,
      -0.270988, -0.273348, -0.271022, -0.273314, -0.271056, -0.273282, -0.271087, -0.273252, -0.271116, -0.273224,
      -0.271143, -0.273197, -0.271169, -0.273171, -0.271194, -0.273148, -0.271217, -0.273125, -0.271239, -0.273104,
      -0.27126,  -0.273084, -0.27128,  -0.273064, -0.271298, -0.273046, -0.271317, -0.273029, -0.271333, -0.273012,
      -0.271349, -0.272997, -0.271364, -0.272981, -0.271379, -0.272967, -0.271393, -0.272954, -0.271406, -0.272941,
      -0.271419, -0.272929, -0.271431, -0.272917, -0.271442, -0.272906, -0.271453, -0.272895, -0.271463, -0.272885,
      -0.271473, -0.272876, -0.271482, -0.272866, -0.271491, -0.272858, -0.2715,   -0.27285,  -0.271508, -0.272842,
      -0.271516, -0.272834, -0.271523, -0.272827, -0.27153,  -0.27282,  -0.271537, -0.272813, -0.271543, -0.272807,
      -0.271549, -0.272801, -0.271554, -0.272796, -0.27156,  -0.272791, -0.271565, -0.272786, -0.27157,  -0.272781,
      -0.271575, -0.272777, -0.271579, -0.272773, -0.271583, -0.272769, -0.271586, -0.272765, -0.27159,  -0.272762,
      -0.271593, -0.272759, -0.271596, -0.272756, -0.271599, -0.272753, -0.271601, -0.272751, -0.271604, -0.272749,
      -0.271606, -0.272746, -0.271608, -0.272745, -0.27161,  -0.272743, -0.271611, -0.272742, -0.271613, -0.272741,
      -0.271614, -0.27274,  -0.271615, -0.272739, -0.271615, -0.272738, -0.271616, -0.272738, -0.271616, -0.272738,
      -0.271616, -0.272738, -0.271616, -0.272738, -0.271616, -0.272738, -0.271615, -0.272739, -0.271615, -0.27274,
      -0.271614, -0.272741, -0.271612, -0.272742, -0.271611, -0.272743, -0.27161,  -0.272745, -0.271608, -0.272746,
      -0.271606, -0.272749, -0.271604, -0.272751, -0.271601, -0.272753, -0.271599, -0.272756, -0.271596, -0.272759,
      -0.271593, -0.272762, -0.27159,  -0.272765, -0.271586, -0.272769, -0.271583, -0.272773, -0.271579, -0.272777,
      -0.271575, -0.272781, -0.27157,  -0.272786, -0.271565, -0.272791, -0.27156,  -0.272796, -0.271554, -0.272801,
      -0.271549, -0.272807, -0.271543, -0.272813, -0.271537, -0.27282,  -0.27153,  -0.272827, -0.271523, -0.272834,
      -0.271516, -0.272842, -0.271508, -0.27285,  -0.2715,   -0.272858, -0.271491, -0.272866, -0.271482, -0.272876,
      -0.271473, -0.272885, -0.271463, -0.272895, -0.271453, -0.272906, -0.271442, -0.272917, -0.271431, -0.272929,
      -0.271419, -0.272941, -0.271406, -0.272954, -0.271393, -0.272967, -0.271379, -0.272981, -0.271364, -0.272997,
      -0.271349, -0.273012, -0.271333, -0.273029, -0.271317, -0.273046, -0.271298, -0.273064, -0.271279, -0.273084,
      -0.27126,  -0.273104, -0.271239, -0.273125, -0.271217, -0.273148, -0.271194, -0.273171, -0.271169, -0.273197,
      -0.271143, -0.273223, -0.271116, -0.273252, -0.271086, -0.273282, -0.271056, -0.273314, -0.271022, -0.273348,
      -0.270988, -0.273384, -0.270951, -0.273422, -0.270911, -0.273463, -0.270868, -0.273507, -0.270823, -0.273554,
      -0.270775, -0.273605, -0.270722, -0.273659, -0.270666, -0.273717, -0.270605, -0.27378,  -0.27054,  -0.273848,
      -0.270469, -0.273923, -0.270392, -0.274003, -0.270307, -0.274091, -0.270216, -0.274187, -0.270115, -0.274293,
      -0.270004, -0.27441,  -0.269881, -0.274539, -0.269744, -0.274683, -0.269592, -0.274845, -0.269421, -0.275027,
      -0.269227, -0.275233, -0.269006, -0.275469, -0.268754, -0.275741, -0.268461, -0.276057, -0.268117, -0.276431,
      -0.26771,  -0.276876, -0.26722,  -0.277418, -0.266619, -0.278089, -0.265865, -0.278941, -0.264895, -0.280057,
      -0.263597, -0.281582, -0.26178,  -0.283785, -0.259055, -0.28724,  -0.254529, -0.293424, -0.245575, -0.307549,
      -0.219941, -0.368935},
     {0.2715,    0.914642,  0.762941,  0.853257,  0.788574,  0.839133,  0.797524,  0.832953,  0.802048,  0.8295,
      0.804769,  0.827301,  0.806582,  0.825782,  0.807874,  0.824671,  0.808839,  0.823826,  0.809585,  0.823163,
      0.810178,  0.82263,   0.81066,   0.822193,  0.811056,  0.821831,  0.811389,  0.821526,  0.811669,  0.821266,
      0.811909,  0.821045,  0.812115,  0.820853,  0.812293,  0.820687,  0.812449,  0.820544,  0.812582,  0.820417,
      0.8127,    0.820308,  0.812801,  0.820214,  0.81289,   0.820131,  0.812967,  0.820059,  0.813033,  0.819998,
      0.813089,  0.819946,  0.813137,  0.819902,  0.813176,  0.819868,  0.813207,  0.81984,   0.813231,  0.819819,
      0.813249,  0.819806,  0.813259,  0.819799,  0.813262,  0.819799,  0.813259,  0.819806,  0.813249,  0.819819,
      0.813231,  0.81984,   0.813207,  0.819868,  0.813176,  0.819902,  0.813137,  0.819946,  0.813089,  0.819998,
      0.813033,  0.820059,  0.812967,  0.820131,  0.81289,   0.820214,  0.812801,  0.820308,  0.8127,    0.820417,
      0.812582,  0.820544,  0.812449,  0.820687,  0.812293,  0.820853,  0.812115,  0.821045,  0.811909,  0.821266,
      0.811669,  0.821526,  0.811389,  0.821831,  0.811056,  0.822193,  0.81066,   0.82263,   0.810178,  0.823163,
      0.809585,  0.823826,  0.808839,  0.824671,  0.807874,  0.825782,  0.806582,  0.827301,  0.804769,  0.8295,
      0.802048,  0.832953,  0.797524,  0.839133,  0.788574,  0.853257,  0.762941,  0.914642,  0.2715,    -0.368935,
      -0.219941, -0.307549, -0.245575, -0.293424, -0.254529, -0.28724,  -0.259055, -0.283785, -0.26178,  -0.281582,
      -0.263597, -0.280057, -0.264895, -0.278941, -0.265865, -0.278089, -0.266619, -0.277418, -0.26722,  -0.276877,
      -0.26771,  -0.276431, -0.268118, -0.276057, -0.268461, -0.275741, -0.268754, -0.275469, -0.269006, -0.275233,
      -0.269227, -0.275027, -0.269421, -0.274845, -0.269592, -0.274683, -0.269744, -0.274539, -0.269881, -0.27441,
      -0.270004, -0.274293, -0.270115, -0.274187, -0.270216, -0.274091, -0.270307, -0.274003, -0.270392, -0.273923,
      -0.270469, -0.273849, -0.27054,  -0.27378,  -0.270605, -0.273717, -0.270666, -0.273659, -0.270722, -0.273605,
      -0.270775, -0.273554, -0.270823, -0.273507, -0.270868, -0.273463, -0.270911, -0.273422, -0.270951, -0.273384,
      -0.270988, -0.273348, -0.271022, -0.273314, -0.271056, -0.273282, -0.271087, -0.273252, -0.271116, -0.273224,
      -0.271143, -0.273197, -0.271169, -0.273171, -0.271194, -0.273148, -0.271217, -0.273125, -0.271239, -0.273104,
      -0.27126,  -0.273084, -0.27128,  -0.273064, -0.271298, -0.273046, -0.271317, -0.273029, -0.271333, -0.273012,
      -0.271349, -0.272997, -0.271364, -0.272981, -0.271379, -0.272967, -0.271393, -0.272954, -0.271406, -0.272941,
      -0.271419, -0.272929, -0.271431, -0.272917, -0.271442, -0.272906, -0.271453, -0.272895, -0.271463, -0.272885,
      -0.271473, -0.272876, -0.271482, -0.272866, -0.271491, -0.272858, -0.2715,   -0.27285,  -0.271508, -0.272842,
      -0.271516, -0.272834, -0.271523, -0.272827, -0.27153,  -0.27282,  -0.271537, -0.272813, -0.271543, -0.272807,
      -0.271549, -0.272801, -0.271554, -0.272796, -0.27156,  -0.272791, -0.271565, -0.272786, -0.27157,  -0.272781,
      -0.271575, -0.272777, -0.271579, -0.272773, -0.271583, -0.272769, -0.271586, -0.272765, -0.27159,  -0.272762,
      -0.271593, -0.272759, -0.271596, -0.272756, -0.271599, -0.272753, -0.271601, -0.272751, -0.271604, -0.272749,
      -0.271606, -0.272746, -0.271608, -0.272745, -0.27161,  -0.272743, -0.271611, -0.272742, -0.271613, -0.272741,
      -0.271614, -0.27274,  -0.271615, -0.272739, -0.271615, -0.272738, -0.271616, -0.272738, -0.271616, -0.272738,
      -0.271616, -0.272738, -0.271616, -0.272738, -0.271616, -0.272738, -0.271615, -0.272739, -0.271615, -0.27274,
      -0.271614, -0.272741, -0.271612, -0.272742, -0.271611, -0.272743, -0.27161,  -0.272745, -0.271608, -0.272746,
      -0.271606, -0.272749, -0.271604, -0.272751, -0.271601, -0.272753, -0.271599, -0.272756, -0.271596, -0.272759,
      -0.271593, -0.272762, -0.27159,  -0.272765, -0.271586, -0.272769, -0.271583, -0.272773, -0.271579, -0.272777,
      -0.271575, -0.272781, -0.27157,  -0.272786, -0.271565, -0.272791, -0.27156,  -0.272796, -0.271554, -0.272801,
      -0.271549, -0.272807, -0.271543, -0.272813, -0.271537, -0.27282,  -0.27153,  -0.272827, -0.271523, -0.272834,
      -0.271516, -0.272842, -0.271508, -0.27285,  -0.2715,   -0.272858, -0.271491, -0.272866, -0.271482, -0.272876,
      -0.271473, -0.272885, -0.271463, -0.272895, -0.271453, -0.272906, -0.271442, -0.272917, -0.271431, -0.272929,
      -0.271419, -0.272941, -0.271406, -0.272954, -0.271393, -0.272967, -0.271379, -0.272981, -0.271364, -0.272997,
      -0.271349, -0.273012, -0.271333, -0.273029, -0.271317, -0.273046, -0.271298, -0.273064, -0.271279, -0.273084,
      -0.27126,  -0.273104, -0.271239, -0.273125, -0.271217, -0.273148, -0.271194, -0.273171, -0.271169, -0.273197,
      -0.271143, -0.273223, -0.271116, -0.273252, -0.271086, -0.273282, -0.271056, -0.273314, -0.271022, -0.273348,
      -0.270988, -0.273384, -0.270951, -0.273422, -0.270911, -0.273463, -0.270868, -0.273507, -0.270823, -0.273554,
      -0.270775, -0.273605, -0.270722, -0.273659, -0.270666, -0.273717, -0.270605, -0.27378,  -0.27054,  -0.273848,
      -0.270469, -0.273923, -0.270392, -0.274003, -0.270307, -0.274091, -0.270216, -0.274187, -0.270115, -0.274293,
      -0.270004, -0.27441,  -0.269881, -0.274539, -0.269744, -0.274683, -0.269592, -0.274845, -0.269421, -0.275027,
      -0.269227, -0.275233, -0.269006, -0.275469, -0.268754, -0.275741, -0.268461, -0.276057, -0.268117, -0.276431,
      -0.26771,  -0.276876, -0.26722,  -0.277418, -0.266619, -0.278089, -0.265865, -0.278941, -0.264895, -0.280057,
      -0.263597, -0.281582, -0.26178,  -0.283785, -0.259055, -0.28724,  -0.254529, -0.293424, -0.245575, -0.307549,
      -0.219941, -0.368935},
     {0.2715,    0.914642,  0.762941,  0.853257,  0.788574,  0.839133,  0.797524,  0.832953,  0.802048,  0.8295,
      0.804769,  0.827301,  0.806582,  0.825782,  0.807874,  0.824671,  0.808839,  0.823826,  0.809585,  0.823163,
      0.810178,  0.82263,   0.81066,   0.822193,  0.811056,  0.821831,  0.811389,  0.821526,  0.811669,  0.821266,
      0.811909,  0.821045,  0.812115,  0.820853,  0.812293,  0.820687,  0.812449,  0.820544,  0.812582,  0.820417,
      0.8127,    0.820308,  0.812801,  0.820214,  0.81289,   0.820131,  0.812967,  0.820059,  0.813033,  0.819998,
      0.813089,  0.819946,  0.813137,  0.819902,  0.813176,  0.819868,  0.813207,  0.81984,   0.813231,  0.819819,
      0.813249,  0.819806,  0.813259,  0.819799,  0.813262,  0.819799,  0.813259,  0.819806,  0.813249,  0.819819,
      0.813231,  0.81984,   0.813207,  0.819868,  0.813176,  0.819902,  0.813137,  0.819946,  0.813089,  0.819998,
      0.813033,  0.820059,  0.812967,  0.820131,  0.81289,   0.820214,  0.812801,  0.820308,  0.8127,    0.820417,
      0.812582,  0.820544,  0.812449,  0.820687,  0.812293,  0.820853,  0.812115,  0.821045,  0.811909,  0.821266,
      0.811669,  0.821526,  0.811389,  0.821831,  0.811056,  0.822193,  0.81066,   0.82263,   0.810178,  0.823163,
      0.809585,  0.823826,  0.808839,  0.824671,  0.807874,  0.825782,  0.806582,  0.827301,  0.804769,  0.8295,
      0.802048,  0.832953,  0.797524,  0.839133,  0.788574,  0.853257,  0.762941,  0.914642,  0.2715,    -0.368935,
      -0.219941, -0.307549, -0.245575, -0.293424, -0.254529, -0.28724,  -0.259055, -0.283785, -0.26178,  -0.281582,
      -0.263597, -0.280057, -0.264895, -0.278941, -0.265865, -0.278089, -0.266619, -0.277418, -0.26722,  -0.276877,
      -0.26771,  -0.276431, -0.268118, -0.276057, -0.268461, -0.275741, -0.268754, -0.275469, -0.269006, -0.275233,
      -0.269227, -0.275027, -0.269421, -0.274845, -0.269592, -0.274683, -0.269744, -0.274539, -0.269881, -0.27441,
      -0.270004, -0.274293, -0.270115, -0.274187, -0.270216, -0.274091, -0.270307, -0.274003, -0.270392, -0.273923,
      -0.270469, -0.273849, -0.27054,  -0.27378,  -0.270605, -0.273717, -0.270666, -0.273659, -0.270722, -0.273605,
      -0.270775, -0.273554, -0.270823, -0.273507, -0.270868, -0.273463, -0.270911, -0.273422, -0.270951, -0.273384,
      -0.270988, -0.273348, -0.271022, -0.273314, -0.271056, -0.273282, -0.271087, -0.273252, -0.271116, -0.273224,
      -0.271143, -0.273197, -0.271169, -0.273171, -0.271194, -0.273148, -0.271217, -0.273125, -0.271239, -0.273104,
      -0.27126,  -0.273084, -0.27128,  -0.273064, -0.271298, -0.273046, -0.271317, -0.273029, -0.271333, -0.273012,
      -0.271349, -0.272997, -0.271364, -0.272981, -0.271379, -0.272967, -0.271393, -0.272954, -0.271406, -0.272941,
      -0.271419, -0.272929, -0.271431, -0.272917, -0.271442, -0.272906, -0.271453, -0.272895, -0.271463, -0.272885,
      -0.271473, -0.272876, -0.271482, -0.272866, -0.271491, -0.272858, -0.2715,   -0.27285,  -0.271508, -0.272842,
      -0.271516, -0.272834, -0.271523, -0.272827, -0.27153,  -0.27282,  -0.271537, -0.272813, -0.271543, -0.272807,
      -0.271549, -0.272801, -0.271554, -0.272796, -0.27156,  -0.272791, -0.271565, -0.272786, -0.27157,  -0.272781,
      -0.271575, -0.272777, -0.271579, -0.272773, -0.271583, -0.272769, -0.271586, -0.272765, -0.27159,  -0.272762,
      -0.271593, -0.272759, -0.271596, -0.272756, -0.271599, -0.272753, -0.271601, -0.272751, -0.271604, -0.272749,
      -0.271606, -0.272746, -0.271608, -0.272745, -0.27161,  -0.272743, -0.271611, -0.272742, -0.271613, -0.272741,
      -0.271614, -0.27274,  -0.271615, -0.272739, -0.271615, -0.272738, -0.271616, -0.272738, -0.271616, -0.272738,
      -0.271616, -0.272738, -0.271616, -0.272738, -0.271616, -0.272738, -0.271615, -0.272739, -0.271615, -0.27274,
      -0.271614, -0.272741, -0.271612, -0.272742, -0.271611, -0.272743, -0.27161,  -0.272745, -0.271608, -0.272746,
      -0.271606, -0.272749, -0.271604, -0.272751, -0.271601, -0.272753, -0.271599, -0.272756, -0.271596, -0.272759,
      -0.271593, -0.272762, -0.27159,  -0.272765, -0.271586, -0.272769, -0.271583, -0.272773, -0.271579, -0.272777,
      -0.271575, -0.272781, -0.27157,  -0.272786, -0.271565, -0.272791, -0.27156,  -0.272796, -0.271554, -0.272801,
      -0.271549, -0.272807, -0.271543, -0.272813, -0.271537, -0.27282,  -0.27153,  -0.272827, -0.271523, -0.272834,
      -0.271516, -0.272842, -0.271508, -0.27285,  -0.2715,   -0.272858, -0.271491, -0.272866, -0.271482, -0.272876,
      -0.271473, -0.272885, -0.271463, -0.272895, -0.271453, -0.272906, -0.271442, -0.272917, -0.271431, -0.272929,
      -0.271419, -0.272941, -0.271406, -0.272954, -0.271393, -0.272967, -0.271379, -0.272981, -0.271364, -0.272997,
      -0.271349, -0.273012, -0.271333, -0.273029, -0.271317, -0.273046, -0.271298, -0.273064, -0.271279, -0.273084,
      -0.27126,  -0.273104, -0.271239, -0.273125, -0.271217, -0.273148, -0.271194, -0.273171, -0.271169, -0.273197,
      -0.271143, -0.273223, -0.271116, -0.273252, -0.271086, -0.273282, -0.271056, -0.273314, -0.271022, -0.273348,
      -0.270988, -0.273384, -0.270951, -0.273422, -0.270911, -0.273463, -0.270868, -0.273507, -0.270823, -0.273554,
      -0.270775, -0.273605, -0.270722, -0.273659, -0.270666, -0.273717, -0.270605, -0.27378,  -0.27054,  -0.273848,
      -0.270469, -0.273923, -0.270392, -0.274003, -0.270307, -0.274091, -0.270216, -0.274187, -0.270115, -0.274293,
      -0.270004, -0.27441,  -0.269881, -0.274539, -0.269744, -0.274683, -0.269592, -0.274845, -0.269421, -0.275027,
      -0.269227, -0.275233, -0.269006, -0.275469, -0.268754, -0.275741, -0.268461, -0.276057, -0.268117, -0.276431,
      -0.26771,  -0.276876, -0.26722,  -0.277418, -0.266619, -0.278089, -0.265865, -0.278941, -0.264895, -0.280057,
      -0.263597, -0.281582, -0.26178,  -0.283785, -0.259055, -0.28724,  -0.254529, -0.293424, -0.245575, -0.307549,
      -0.219941, -0.368935},
     {0.2715,    0.914642,  0.762941,  0.853257,  0.788574,  0.839133,  0.797524,  0.832953,  0.802048,  0.8295,
      0.804769,  0.827301,  0.806582,  0.825782,  0.807874,  0.824671,  0.808839,  0.823826,  0.809585,  0.823163,
      0.810178,  0.82263,   0.81066,   0.822193,  0.811056,  0.821831,  0.811389,  0.821526,  0.811669,  0.821266,
      0.811909,  0.821045,  0.812115,  0.820853,  0.812293,  0.820687,  0.812449,  0.820544,  0.812582,  0.820417,
      0.8127,    0.820308,  0.812801,  0.820214,  0.81289,   0.820131,  0.812967,  0.820059,  0.813033,  0.819998,
      0.813089,  0.819946,  0.813137,  0.819902,  0.813176,  0.819868,  0.813207,  0.81984,   0.813231,  0.819819,
      0.813249,  0.819806,  0.813259,  0.819799,  0.813262,  0.819799,  0.813259,  0.819806,  0.813249,  0.819819,
      0.813231,  0.81984,   0.813207,  0.819868,  0.813176,  0.819902,  0.813137,  0.819946,  0.813089,  0.819998,
      0.813033,  0.820059,  0.812967,  0.820131,  0.81289,   0.820214,  0.812801,  0.820308,  0.8127,    0.820417,
      0.812582,  0.820544,  0.812449,  0.820687,  0.812293,  0.820853,  0.812115,  0.821045,  0.811909,  0.821266,
      0.811669,  0.821526,  0.811389,  0.821831,  0.811056,  0.822193,  0.81066,   0.82263,   0.810178,  0.823163,
      0.809585,  0.823826,  0.808839,  0.824671,  0.807874,  0.825782,  0.806582,  0.827301,  0.804769,  0.8295,
      0.802048,  0.832953,  0.797524,  0.839133,  0.788574,  0.853257,  0.762941,  0.914642,  0.2715,    -0.368935,
      -0.219941, -0.307549, -0.245575, -0.293424, -0.254529, -0.28724,  -0.259055, -0.283785, -0.26178,  -0.281582,
      -0.263597, -0.280057, -0.264895, -0.278941, -0.265865, -0.278089, -0.266619, -0.277418, -0.26722,  -0.276877,
      -0.26771,  -0.276431, -0.268118, -0.276057, -0.268461, -0.275741, -0.268754, -0.275469, -0.269006, -0.275233,
      -0.269227, -0.275027, -0.269421, -0.274845, -0.269592, -0.274683, -0.269744, -0.274539, -0.269881, -0.27441,
      -0.270004, -0.274293, -0.270115, -0.274187, -0.270216, -0.274091, -0.270307, -0.274003, -0.270392, -0.273923,
      -0.270469, -0.273849, -0.27054,  -0.27378,  -0.270605, -0.273717, -0.270666, -0.273659, -0.270722, -0.273605,
      -0.270775, -0.273554, -0.270823, -0.273507, -0.270868, -0.273463, -0.270911, -0.273422, -0.270951, -0.273384,
      -0.270988, -0.273348, -0.271022, -0.273314, -0.271056, -0.273282, -0.271087, -0.273252, -0.271116, -0.273224,
      -0.271143, -0.273197, -0.271169, -0.273171, -0.271194, -0.273148, -0.271217, -0.273125, -0.271239, -0.273104,
      -0.27126,  -0.273084, -0.27128,  -0.273064, -0.271298, -0.273046, -0.271317, -0.273029, -0.271333, -0.273012,
      -0.271349, -0.272997, -0.271364, -0.272981, -0.271379, -0.272967, -0.271393, -0.272954, -0.271406, -0.272941,
      -0.271419, -0.272929, -0.271431, -0.272917, -0.271442, -0.272906, -0.271453, -0.272895, -0.271463, -0.272885,
      -0.271473, -0.272876, -0.271482, -0.272866, -0.271491, -0.272858, -0.2715,   -0.27285,  -0.271508, -0.272842,
      -0.271516, -0.272834, -0.271523, -0.272827, -0.27153,  -0.27282,  -0.271537, -0.272813, -0.271543, -0.272807,
      -0.271549, -0.272801, -0.271554, -0.272796, -0.27156,  -0.272791, -0.271565, -0.272786, -0.27157,  -0.272781,
      -0.271575, -0.272777, -0.271579, -0.272773, -0.271583, -0.272769, -0.271586, -0.272765, -0.27159,  -0.272762,
      -0.271593, -0.272759, -0.271596, -0.272756, -0.271599, -0.272753, -0.271601, -0.272751, -0.271604, -0.272749,
      -0.271606, -0.272746, -0.271608, -0.272745, -0.27161,  -0.272743, -0.271611, -0.272742, -0.271613, -0.272741,
      -0.271614, -0.27274,  -0.271615, -0.272739, -0.271615, -0.272738, -0.271616, -0.272738, -0.271616, -0.272738,
      -0.271616, -0.272738, -0.271616, -0.272738, -0.271616, -0.272738, -0.271615, -0.272739, -0.271615, -0.27274,
      -0.271614, -0.272741, -0.271612, -0.272742, -0.271611, -0.272743, -0.27161,  -0.272745, -0.271608, -0.272746,
      -0.271606, -0.272749, -0.271604, -0.272751, -0.271601, -0.272753, -0.271599, -0.272756, -0.271596, -0.272759,
      -0.271593, -0.272762, -0.27159,  -0.272765, -0.271586, -0.272769, -0.271583, -0.272773, -0.271579, -0.272777,
      -0.271575, -0.272781, -0.27157,  -0.272786, -0.271565, -0.272791, -0.27156,  -0.272796, -0.271554, -0.272801,
      -0.271549, -0.272807, -0.271543, -0.272813, -0.271537, -0.27282,  -0.27153,  -0.272827, -0.271523, -0.272834,
      -0.271516, -0.272842, -0.271508, -0.27285,  -0.2715,   -0.272858, -0.271491, -0.272866, -0.271482, -0.272876,
      -0.271473, -0.272885, -0.271463, -0.272895, -0.271453, -0.272906, -0.271442, -0.272917, -0.271431, -0.272929,
      -0.271419, -0.272941, -0.271406, -0.272954, -0.271393, -0.272967, -0.271379, -0.272981, -0.271364, -0.272997,
      -0.271349, -0.273012, -0.271333, -0.273029, -0.271317, -0.273046, -0.271298, -0.273064, -0.271279, -0.273084,
      -0.27126,  -0.273104, -0.271239, -0.273125, -0.271217, -0.273148, -0.271194, -0.273171, -0.271169, -0.273197,
      -0.271143, -0.273223, -0.271116, -0.273252, -0.271086, -0.273282, -0.271056, -0.273314, -0.271022, -0.273348,
      -0.270988, -0.273384, -0.270951, -0.273422, -0.270911, -0.273463, -0.270868, -0.273507, -0.270823, -0.273554,
      -0.270775, -0.273605, -0.270722, -0.273659, -0.270666, -0.273717, -0.270605, -0.27378,  -0.27054,  -0.273848,
      -0.270469, -0.273923, -0.270392, -0.274003, -0.270307, -0.274091, -0.270216, -0.274187, -0.270115, -0.274293,
      -0.270004, -0.27441,  -0.269881, -0.274539, -0.269744, -0.274683, -0.269592, -0.274845, -0.269421, -0.275027,
      -0.269227, -0.275233, -0.269006, -0.275469, -0.268754, -0.275741, -0.268461, -0.276057, -0.268117, -0.276431,
      -0.26771,  -0.276876, -0.26722,  -0.277418, -0.266619, -0.278089, -0.265865, -0.278941, -0.264895, -0.280057,
      -0.263597, -0.281582, -0.26178,  -0.283785, -0.259055, -0.28724,  -0.254529, -0.293424, -0.245575, -0.307549,
      -0.219941, -0.368935},
     {0.271443,  0.91119,   0.769841,  0.843075,  0.801774,  0.823267,  0.815628,  0.813098,  0.823125,  0.807749,
      0.826646,  0.805827,  0.827166,  0.80652,   0.825454,  0.809049,  0.822318,  0.812581,  0.818599,  0.816288,
      0.815089,  0.81944,   0.812428,  0.821508,  0.811019,  0.822227,  0.810986,  0.821614,  0.812173,  0.819947,
      0.814204,  0.817683,  0.816566,  0.815358,  0.818724,  0.81348,   0.820228,  0.812424,  0.820795,  0.812362,
      0.820362,  0.813249,  0.819082,  0.814838,  0.817286,  0.816737,  0.815395,  0.818509,  0.81384,   0.819762,
      0.812956,  0.820232,  0.812922,  0.819834,  0.813722,  0.818682,  0.815156,  0.817053,  0.816884,  0.815325,
      0.81851,   0.813897,  0.819661,  0.813091,  0.820075,  0.813091,  0.819661,  0.813897,  0.81851,   0.815325,
      0.816884,  0.817053,  0.815156,  0.818682,  0.813722,  0.819834,  0.812922,  0.820232,  0.812956,  0.819762,
      0.81384,   0.818509,  0.815395,  0.816737,  0.817286,  0.814838,  0.819082,  0.813249,  0.820362,  0.812362,
      0.820795,  0.812424,  0.820228,  0.81348,   0.818724,  0.815358,  0.816566,  0.817683,  0.814204,  0.819947,
      0.812173,  0.821614,  0.810986,  0.822227,  0.811019,  0.821508,  0.812428,  0.81944,   0.815089,  0.816288,
      0.818599,  0.812581,  0.822318,  0.809049,  0.825454,  0.80652,   0.827166,  0.805827,  0.826646,  0.807749,
      0.823125,  0.813098,  0.815628,  0.823267,  0.801774,  0.843075,  0.769841,  0.91119,   0.271443,  -0.365412,
      -0.226783, -0.297632, -0.258238, -0.278418, -0.27142,  -0.26896,  -0.278208, -0.264275, -0.28115,  -0.262813,
      -0.281357, -0.263652, -0.279674, -0.265978, -0.276904, -0.269001, -0.273807, -0.27201,  -0.271029, -0.274439,
      -0.269039, -0.275929, -0.268082, -0.27635,  -0.268171, -0.275798, -0.269118, -0.27454,  -0.270594, -0.272942,
      -0.272216, -0.271391, -0.273616, -0.27021,  -0.274525, -0.269607, -0.274805, -0.269645, -0.274469, -0.270245,
      -0.273655, -0.271214, -0.272594, -0.272303, -0.271542, -0.273259, -0.270731, -0.273884, -0.270319, -0.274069,
      -0.270362, -0.27381,  -0.270812, -0.273203, -0.271535, -0.272411, -0.272348, -0.271625, -0.273062, -0.271023,
      -0.273523, -0.270725, -0.273645, -0.270779, -0.273424, -0.271148, -0.272933, -0.271728, -0.2723,   -0.272375,
      -0.271677, -0.272938, -0.271205, -0.273295, -0.270983, -0.273374, -0.271047, -0.273175, -0.271367, -0.272756,
      -0.271856, -0.272226, -0.272394, -0.271711, -0.272856, -0.271328, -0.27314,  -0.271158, -0.273189, -0.271231,
      -0.273002, -0.271519, -0.272632, -0.271946, -0.272173, -0.272409, -0.271734, -0.2728,   -0.271414, -0.273031,
      -0.271283, -0.273056, -0.271364, -0.272876, -0.27163,  -0.272541, -0.272013, -0.272133, -0.272422, -0.271749,
      -0.27276,  -0.271476, -0.272952, -0.271375, -0.272958, -0.271463, -0.272783, -0.271714, -0.272471, -0.272066,
      -0.2721,   -0.272434, -0.271757, -0.272732, -0.27152,  -0.272894, -0.271443, -0.272884, -0.271538, -0.27271,
      -0.27178,  -0.272416, -0.272108, -0.272072, -0.272446, -0.27176,  -0.272714, -0.271551, -0.272851, -0.271493,
      -0.272828, -0.271595, -0.272653, -0.271832, -0.27237,  -0.272145, -0.272046, -0.27246,  -0.271758, -0.272704,
      -0.271573, -0.272821, -0.271531, -0.272785, -0.271641, -0.272608, -0.271876, -0.272331, -0.272177, -0.272022,
      -0.272476, -0.271752, -0.272701, -0.271585, -0.2728,   -0.271558, -0.272753, -0.271677, -0.272571, -0.271912,
      -0.272297, -0.272207, -0.271997, -0.272494, -0.271742, -0.272703, -0.27159,  -0.272789, -0.271576, -0.27273,
      -0.271705, -0.27254,  -0.271944, -0.272266, -0.272237, -0.271972, -0.272515, -0.271726, -0.272713, -0.271587,
      -0.272785, -0.271587, -0.272713, -0.271726, -0.272515, -0.271972, -0.272237, -0.272266, -0.271944, -0.27254,
      -0.271705, -0.27273,  -0.271576, -0.272789, -0.27159,  -0.272703, -0.271742, -0.272494, -0.271997, -0.272207,
      -0.272297, -0.271912, -0.272571, -0.271677, -0.272753, -0.271558, -0.2728,   -0.271585, -0.272701, -0.271752,
      -0.272476, -0.272022, -0.272177, -0.272331, -0.271876, -0.272608, -0.271641, -0.272785, -0.271531, -0.272821,
      -0.271573, -0.272704, -0.271758, -0.27246,  -0.272046, -0.272145, -0.27237,  -0.271832, -0.272653, -0.271595,
      -0.272828, -0.271493, -0.272851, -0.271551, -0.272714, -0.27176,  -0.272446, -0.272072, -0.272108, -0.272416,
      -0.27178,  -0.27271,  -0.271538, -0.272884, -0.271443, -0.272894, -0.27152,  -0.272732, -0.271757, -0.272434,
      -0.2721,   -0.272066, -0.272471, -0.271714, -0.272783, -0.271463, -0.272958, -0.271375, -0.272952, -0.271476,
      -0.27276,  -0.271749, -0.272422, -0.272133, -0.272013, -0.272541, -0.27163,  -0.272876, -0.271364, -0.273056,
      -0.271283, -0.273031, -0.271414, -0.2728,   -0.271734, -0.272409, -0.272173, -0.271946, -0.272632, -0.271519,
      -0.273002, -0.271231, -0.273189, -0.271158, -0.27314,  -0.271328, -0.272856, -0.271711, -0.272394, -0.272226,
      -0.271856, -0.272756, -0.271367, -0.273175, -0.271047, -0.273374, -0.270983, -0.273295, -0.271205, -0.272939,
      -0.271677, -0.272376, -0.2723,   -0.271728, -0.272933, -0.271148, -0.273424, -0.270779, -0.273645, -0.270725,
      -0.273523, -0.271023, -0.273062, -0.271625, -0.272348, -0.272411, -0.271535, -0.273203, -0.270812, -0.27381,
      -0.270362, -0.274069, -0.270319, -0.273884, -0.270731, -0.273259, -0.271542, -0.272303, -0.272594, -0.271214,
      -0.273655, -0.270245, -0.274469, -0.269645, -0.274805, -0.269607, -0.274525, -0.27021,  -0.273616, -0.271391,
      -0.272216, -0.272942, -0.270594, -0.27454,  -0.269118, -0.275798, -0.268171, -0.27635,  -0.268082, -0.275929,
      -0.269039, -0.274439, -0.271029, -0.27201,  -0.273807, -0.269001, -0.276904, -0.265978, -0.279674, -0.263652,
      -0.281357, -0.262813, -0.28115,  -0.264275, -0.278208, -0.26896,  -0.27142,  -0.278418, -0.258238, -0.297632,
      -0.226783, -0.365412},
     {0.273052,  0.882805,  0.817333,  0.788834,  0.849615,  0.79185,   0.826336,  0.821121,  0.803065,  0.831333,
      0.806798,  0.818085,  0.82236,   0.807016,  0.825083,  0.812481,  0.814943,  0.82233,   0.809564,  0.821485,
      0.815526,  0.813576,  0.821733,  0.811591,  0.81906,   0.817294,  0.81311,   0.820865,  0.813268,  0.817373,
      0.81828,   0.813165,  0.819906,  0.81463,   0.816228,  0.818742,  0.813514,  0.818974,  0.815692,  0.815502,
      0.818857,  0.814002,  0.818146,  0.816477,  0.815089,  0.81876,   0.814522,  0.81746,   0.817027,  0.81489,
      0.818555,  0.815009,  0.816916,  0.817401,  0.81482,   0.818318,  0.815432,  0.816489,  0.817666,  0.814809,
      0.81809,   0.815797,  0.816133,  0.817881,  0.81481,   0.817881,  0.816133,  0.815797,  0.81809,   0.814809,
      0.817666,  0.816489,  0.815432,  0.818318,  0.81482,   0.817401,  0.816916,  0.815009,  0.818555,  0.81489,
      0.817027,  0.81746,   0.814522,  0.81876,   0.815089,  0.816477,  0.818146,  0.814002,  0.818857,  0.815502,
      0.815692,  0.818974,  0.813514,  0.818742,  0.816228,  0.81463,   0.819906,  0.813165,  0.81828,   0.817373,
      0.813268,  0.820865,  0.81311,   0.817294,  0.81906,   0.811591,  0.821733,  0.813576,  0.815526,  0.821485,
      0.809564,  0.82233,   0.814943,  0.812481,  0.825083,  0.807016,  0.82236,   0.818085,  0.806798,  0.831333,
      0.803065,  0.821121,  0.826336,  0.79185,   0.849615,  0.788834,  0.817333,  0.882805,  0.273052,  -0.339777,
      -0.272722, -0.243544, -0.306938, -0.245894, -0.282734, -0.277235, -0.25725,  -0.288728, -0.26126,  -0.273776,
      -0.279128, -0.260916, -0.282254, -0.267568, -0.269908, -0.279574, -0.26347,  -0.278168, -0.271347, -0.267913,
      -0.279193, -0.2658,   -0.275067, -0.273843, -0.267022, -0.27824,  -0.268036, -0.272614, -0.275431, -0.266931,
      -0.276895, -0.270133, -0.270738, -0.276266, -0.26745,  -0.275326, -0.271994, -0.269435, -0.276451, -0.268415,
      -0.2737,   -0.273515, -0.268705, -0.27609,  -0.269659, -0.272174, -0.274615, -0.268519, -0.275308, -0.271017,
      -0.270883, -0.275247, -0.268816, -0.274248, -0.272328, -0.269933, -0.275406, -0.269499, -0.273062, -0.273455,
      -0.269387, -0.275133, -0.270444, -0.2719,   -0.274288, -0.269263, -0.274507, -0.271512, -0.270897, -0.274759,
      -0.269532, -0.273639, -0.272562, -0.27016,  -0.274846, -0.270124, -0.272657, -0.273467, -0.269754, -0.274571,
      -0.270938, -0.271693, -0.274125, -0.269704, -0.273999, -0.271855, -0.270869, -0.274473, -0.26999,  -0.273223,
      -0.272749, -0.270279, -0.274486, -0.270551, -0.272358, -0.273506, -0.269984, -0.274186, -0.271298, -0.271523,
      -0.274036, -0.270006, -0.273629, -0.272121, -0.270824, -0.274283, -0.270322, -0.272905, -0.272908, -0.270347,
      -0.274228, -0.270878, -0.272116, -0.273556, -0.270145, -0.273893, -0.271586, -0.271372, -0.273984, -0.270232,
      -0.273336, -0.272345, -0.270771, -0.274144, -0.270585, -0.272641, -0.273052, -0.270387, -0.274026, -0.271146,
      -0.271906, -0.273611, -0.270266, -0.273653, -0.271831, -0.271234, -0.273953, -0.270415, -0.273087, -0.272544,
      -0.270713, -0.274035, -0.270807, -0.272409, -0.273185, -0.270411, -0.273856, -0.27138,  -0.271716, -0.27367,
      -0.270364, -0.273446, -0.272052, -0.271103, -0.273934, -0.270573, -0.272865, -0.272728, -0.270653, -0.273946,
      -0.271004, -0.272197, -0.273315, -0.270425, -0.273708, -0.271594, -0.271537, -0.273732, -0.270448, -0.273257,
      -0.272258, -0.270975, -0.273925, -0.270715, -0.272658, -0.272904, -0.270589, -0.273868, -0.271187, -0.271995,
      -0.273442, -0.270431, -0.273572, -0.271796, -0.271363, -0.273798, -0.270521, -0.273078, -0.272458, -0.270847,
      -0.273922, -0.270847, -0.272458, -0.273078, -0.270521, -0.273798, -0.271363, -0.271796, -0.273572, -0.270431,
      -0.273442, -0.271995, -0.271187, -0.273868, -0.270589, -0.272904, -0.272658, -0.270715, -0.273925, -0.270975,
      -0.272258, -0.273257, -0.270448, -0.273732, -0.271537, -0.271594, -0.273708, -0.270425, -0.273314, -0.272197,
      -0.271004, -0.273946, -0.270653, -0.272728, -0.272865, -0.270573, -0.273934, -0.271103, -0.272052, -0.273445,
      -0.270364, -0.27367,  -0.271716, -0.27138,  -0.273856, -0.270411, -0.273185, -0.272409, -0.270807, -0.274035,
      -0.270713, -0.272544, -0.273087, -0.270415, -0.273953, -0.271234, -0.271831, -0.273653, -0.270266, -0.273611,
      -0.271906, -0.271146, -0.274026, -0.270387, -0.273052, -0.272641, -0.270585, -0.274144, -0.270771, -0.272345,
      -0.273336, -0.270232, -0.273984, -0.271372, -0.271586, -0.273893, -0.270145, -0.273556, -0.272116, -0.270878,
      -0.274228, -0.270347, -0.272908, -0.272905, -0.270322, -0.274283, -0.270824, -0.272121, -0.273629, -0.270006,
      -0.274036, -0.271523, -0.271298, -0.274186, -0.269984, -0.273506, -0.272359, -0.270551, -0.274486, -0.270279,
      -0.272749, -0.273223, -0.26999,  -0.274473, -0.270869, -0.271855, -0.273999, -0.269704, -0.274125, -0.271693,
      -0.270938, -0.274571, -0.269754, -0.273467, -0.272657, -0.270124, -0.274846, -0.27016,  -0.272562, -0.273639,
      -0.269532, -0.274759, -0.270897, -0.271512, -0.274507, -0.269263, -0.274288, -0.2719,   -0.270444, -0.275133,
      -0.269387, -0.273455, -0.273062, -0.269499, -0.275406, -0.269933, -0.272328, -0.274248, -0.268816, -0.275247,
      -0.270883, -0.271017, -0.275308, -0.268519, -0.274615, -0.272174, -0.269659, -0.27609,  -0.268705, -0.273515,
      -0.2737,   -0.268415, -0.276451, -0.269435, -0.271993, -0.275326, -0.26745,  -0.276266, -0.270738, -0.270133,
      -0.276895, -0.266931, -0.275431, -0.272614, -0.268036, -0.27824,  -0.267022, -0.273843, -0.275067, -0.2658,
      -0.279193, -0.267913, -0.271347, -0.278168, -0.26347,  -0.279574, -0.269908, -0.267568, -0.282254, -0.260916,
      -0.279128, -0.273776, -0.26126,  -0.288728, -0.25725,  -0.277235, -0.282734, -0.245894, -0.306938, -0.243544,
      -0.272722, -0.339777},
     {0.273221,  0.835654,  0.874191,  0.765176,  0.825589,  0.840683,  0.79129,   0.819754,  0.832665,  0.800684,
      0.817012,  0.828933,  0.805608,  0.815496,  0.826654,  0.808685,  0.81459,   0.825041,  0.810806,  0.814036,
      0.823795,  0.812359,  0.813708,  0.822778,  0.813537,  0.813532,  0.821921,  0.814451,  0.813464,  0.821184,
      0.815167,  0.813473,  0.820545,  0.815729,  0.813536,  0.81999,   0.81617,   0.813636,  0.819508,  0.816512,
      0.813758,  0.819093,  0.816775,  0.813891,  0.81874,   0.816976,  0.814025,  0.818442,  0.817126,  0.814152,
      0.818196,  0.817238,  0.814265,  0.817995,  0.817324,  0.814358,  0.817834,  0.817395,  0.814428,  0.817707,
      0.817459,  0.814471,  0.817608,  0.817528,  0.814485,  0.817528,  0.817608,  0.814471,  0.817459,  0.817707,
      0.814428,  0.817395,  0.817834,  0.814358,  0.817324,  0.817995,  0.814265,  0.817238,  0.818196,  0.814152,
      0.817126,  0.818442,  0.814025,  0.816976,  0.81874,   0.813891,  0.816775,  0.819094,  0.813758,  0.816512,
      0.819508,  0.813636,  0.81617,   0.81999,   0.813536,  0.815729,  0.820545,  0.813473,  0.815167,  0.821184,
      0.813464,  0.814451,  0.821921,  0.813532,  0.813537,  0.822778,  0.813708,  0.812359,  0.823795,  0.814036,
      0.810806,  0.825041,  0.81459,   0.808685,  0.826654,  0.815496,  0.805608,  0.828933,  0.817012,  0.800684,
      0.832665,  0.819754,  0.79129,   0.840683,  0.825589,  0.765176,  0.874191,  0.835654,  0.273221,  -0.292239,
      -0.331081, -0.218764, -0.281843, -0.297844, -0.244966, -0.275659, -0.290056, -0.254502, -0.272557, -0.286505,
      -0.259622, -0.270681, -0.284355, -0.262943, -0.269424, -0.282815, -0.26535,  -0.268537, -0.281583, -0.267225,
      -0.267902, -0.280521, -0.268754, -0.267455, -0.279556, -0.270039, -0.267158, -0.278654, -0.271136, -0.266986,
      -0.277794, -0.272083, -0.266925, -0.276964, -0.272899, -0.26696,  -0.276161, -0.2736,   -0.267082, -0.275383,
      -0.274194, -0.26728,  -0.274634, -0.274689, -0.267547, -0.273916, -0.275087, -0.267874, -0.273233, -0.275395,
      -0.268253, -0.27259,  -0.275615, -0.268675, -0.271991, -0.275751, -0.269132, -0.271443, -0.275806, -0.269615,
      -0.270949, -0.275787, -0.270114, -0.270513, -0.275697, -0.270622, -0.270138, -0.275542, -0.27113,  -0.269826,
      -0.275329, -0.271629, -0.26958,  -0.275063, -0.272112, -0.269401, -0.274753, -0.272571, -0.269288, -0.274406,
      -0.272998, -0.269239, -0.274029, -0.273389, -0.269255, -0.273631, -0.273737, -0.26933,  -0.27322,  -0.274037,
      -0.269461, -0.272805, -0.274286, -0.269643, -0.272392, -0.274482, -0.269873, -0.27199,  -0.274621, -0.270142,
      -0.271607, -0.274705, -0.270446, -0.271248, -0.274731, -0.270776, -0.270921, -0.274703, -0.271126, -0.270631,
      -0.274621, -0.271488, -0.270382, -0.27449,  -0.271854, -0.270178, -0.274313, -0.272217, -0.270022, -0.274094,
      -0.272571, -0.269917, -0.273839, -0.272907, -0.269863, -0.273555, -0.273221, -0.26986,  -0.273247, -0.273504,
      -0.269907, -0.272922, -0.273754, -0.270002, -0.272588, -0.273964, -0.270142, -0.27225,  -0.274132, -0.270324,
      -0.271917, -0.274254, -0.270544, -0.271595, -0.27433,  -0.270795, -0.27129,  -0.274358, -0.271074, -0.271009,
      -0.274337, -0.271373, -0.270757, -0.27427,  -0.271685, -0.27054,  -0.274157, -0.272005, -0.27036,  -0.274003,
      -0.272325, -0.270222, -0.27381,  -0.272639, -0.270127, -0.273583, -0.27294,  -0.270079, -0.273327, -0.273222,
      -0.270077, -0.273047, -0.273479, -0.270121, -0.27275,  -0.273706, -0.27021,  -0.272442, -0.273899, -0.270342,
      -0.272129, -0.274054, -0.270514, -0.271818, -0.274166, -0.270722, -0.271515, -0.274234, -0.270962, -0.271228,
      -0.274257, -0.271228, -0.270962, -0.274234, -0.271515, -0.270722, -0.274166, -0.271818, -0.270514, -0.274054,
      -0.272129, -0.270342, -0.273899, -0.272442, -0.27021,  -0.273706, -0.27275,  -0.270121, -0.273479, -0.273047,
      -0.270077, -0.273222, -0.273327, -0.270079, -0.27294,  -0.273583, -0.270127, -0.272639, -0.27381,  -0.270222,
      -0.272325, -0.274003, -0.27036,  -0.272005, -0.274157, -0.27054,  -0.271685, -0.27427,  -0.270757, -0.271373,
      -0.274337, -0.271009, -0.271074, -0.274358, -0.27129,  -0.270795, -0.27433,  -0.271595, -0.270544, -0.274254,
      -0.271917, -0.270324, -0.274132, -0.27225,  -0.270142, -0.273964, -0.272588, -0.270002, -0.273754, -0.272922,
      -0.269907, -0.273504, -0.273247, -0.26986,  -0.273221, -0.273555, -0.269863, -0.272907, -0.273839, -0.269917,
      -0.272571, -0.274094, -0.270022, -0.272217, -0.274313, -0.270178, -0.271854, -0.27449,  -0.270382, -0.271488,
      -0.274622, -0.270631, -0.271126, -0.274703, -0.270921, -0.270776, -0.274731, -0.271248, -0.270446, -0.274705,
      -0.271607, -0.270142, -0.274621, -0.27199,  -0.269873, -0.274482, -0.272392, -0.269643, -0.274286, -0.272805,
      -0.269461, -0.274037, -0.27322,  -0.26933,  -0.273737, -0.273631, -0.269255, -0.273389, -0.274029, -0.269239,
      -0.272998, -0.274406, -0.269288, -0.272571, -0.274753, -0.269401, -0.272112, -0.275063, -0.26958,  -0.271629,
      -0.275329, -0.269826, -0.27113,  -0.275542, -0.270138, -0.270622, -0.275697, -0.270513, -0.270114, -0.275787,
      -0.270949, -0.269615, -0.275806, -0.271443, -0.269132, -0.275751, -0.271992, -0.268675, -0.275615, -0.272589,
      -0.268253, -0.275395, -0.273233, -0.267874, -0.275088, -0.273916, -0.267547, -0.274689, -0.274634, -0.26728,
      -0.274194, -0.275383, -0.267082, -0.2736,   -0.276161, -0.26696,  -0.272899, -0.276964, -0.266925, -0.272083,
      -0.277794, -0.266986, -0.271136, -0.278654, -0.267158, -0.270039, -0.279557, -0.267455, -0.268754, -0.280521,
      -0.267902, -0.267225, -0.281583, -0.268537, -0.26535,  -0.282815, -0.269424, -0.262943, -0.284355, -0.270681,
      -0.259622, -0.286505, -0.272558, -0.254503, -0.290056, -0.275659, -0.244966, -0.297844, -0.281843, -0.218764,
      -0.331081, -0.292239},
     {0.270939,  0.778345,  0.910692,  0.798923,  0.771319,  0.840609,  0.84072,   0.792172,  0.804825,  0.839074,
      0.819766,  0.79688,   0.819288,  0.832647,  0.8096,    0.804293,  0.826144,  0.824782,  0.805509,  0.812154,
      0.827856,  0.817331,  0.805833,  0.81884,   0.825845,  0.811701,  0.809164,  0.823195,  0.82158,   0.808759,
      0.813966,  0.824676,  0.816632,  0.8087,    0.818694,  0.823435,  0.812448,  0.811047,  0.822067,  0.820237,
      0.810082,  0.814799,  0.82331,   0.816247,  0.809994,  0.81871,   0.822294,  0.812715,  0.811987,  0.821605,
      0.81952,   0.810658,  0.815298,  0.822688,  0.815948,  0.810607,  0.818841,  0.821727,  0.812713,  0.812485,
      0.821515,  0.819096,  0.810808,  0.815652,  0.822505,  0.815652,  0.810808,  0.819096,  0.821515,  0.812485,
      0.812713,  0.821727,  0.818841,  0.810607,  0.815948,  0.822688,  0.815298,  0.810658,  0.81952,   0.821605,
      0.811987,  0.812715,  0.822294,  0.81871,   0.809994,  0.816247,  0.82331,   0.814799,  0.810082,  0.820237,
      0.822067,  0.811047,  0.812448,  0.823435,  0.818694,  0.8087,    0.816632,  0.824676,  0.813966,  0.808759,
      0.82158,   0.823195,  0.809164,  0.811701,  0.825845,  0.81884,   0.805833,  0.817331,  0.827856,  0.812154,
      0.805509,  0.824782,  0.826144,  0.804293,  0.8096,    0.832647,  0.819288,  0.79688,   0.819766,  0.839074,
      0.804825,  0.792172,  0.84072,   0.840609,  0.771319,  0.798923,  0.910692,  0.778345,  0.270939,  -0.233628,
      -0.363969, -0.255629, -0.229025, -0.294589, -0.294793, -0.249951, -0.261422, -0.292304, -0.275171, -0.255022,
      -0.274444, -0.285934, -0.266433, -0.26196,  -0.280003, -0.278925, -0.263395, -0.268654, -0.280999, -0.272857,
      -0.264035, -0.273856, -0.279104, -0.268688, -0.266822, -0.276898, -0.275772, -0.266796, -0.270375, -0.277685,
      -0.272286, -0.267009, -0.273547, -0.276624, -0.269623, -0.268727, -0.275565, -0.274459, -0.268326, -0.271122,
      -0.276124, -0.272046, -0.268468, -0.273364, -0.275363, -0.270131, -0.269727, -0.274832, -0.273753, -0.269186,
      -0.271529, -0.275227, -0.271919, -0.269325, -0.273245, -0.274609, -0.270448, -0.270335, -0.274372, -0.273318,
      -0.269731, -0.271782, -0.274652, -0.271844, -0.269881, -0.273162, -0.274113, -0.270663, -0.270739, -0.274059,
      -0.273026, -0.270104, -0.271952, -0.274254, -0.271794, -0.270268, -0.273102, -0.273765, -0.270816, -0.271024,
      -0.273836, -0.272818, -0.270373, -0.272074, -0.273966, -0.271757, -0.270551, -0.273058, -0.273509, -0.270928,
      -0.271236, -0.273671, -0.272663, -0.270573, -0.272167, -0.27375,  -0.271729, -0.270765, -0.273026, -0.273314,
      -0.271012, -0.271399, -0.273546, -0.272542, -0.270726, -0.27224,  -0.273584, -0.271704, -0.270931, -0.273004,
      -0.273162, -0.271076, -0.271528, -0.273449, -0.272445, -0.270845, -0.272301, -0.273453, -0.271682, -0.271063,
      -0.272989, -0.273039, -0.271124, -0.271633, -0.273375, -0.272364, -0.270939, -0.272353, -0.273348, -0.271661,
      -0.27117,  -0.272981, -0.272938, -0.271159, -0.271721, -0.273317, -0.272295, -0.271013, -0.272399, -0.273263,
      -0.271638, -0.271257, -0.272979, -0.272854, -0.271183, -0.271795, -0.273273, -0.272234, -0.271072, -0.272443,
      -0.273195, -0.271614, -0.27133,  -0.272983, -0.272782, -0.271199, -0.271862, -0.273241, -0.272179, -0.271118,
      -0.272485, -0.27314,  -0.271588, -0.271391, -0.272992, -0.27272,  -0.271206, -0.27192,  -0.273219, -0.272127,
      -0.271153, -0.272527, -0.273095, -0.271559, -0.271443, -0.273008, -0.272665, -0.271204, -0.271975, -0.273206,
      -0.272076, -0.271179, -0.27257,  -0.273058, -0.271526, -0.271487, -0.27303,  -0.272615, -0.271196, -0.272026,
      -0.273202, -0.272026, -0.271196, -0.272615, -0.27303,  -0.271487, -0.271526, -0.273058, -0.27257,  -0.271179,
      -0.272077, -0.273206, -0.271975, -0.271204, -0.272665, -0.273008, -0.271443, -0.271559, -0.273095, -0.272527,
      -0.271153, -0.272127, -0.273219, -0.27192,  -0.271206, -0.27272,  -0.272992, -0.271391, -0.271588, -0.27314,
      -0.272485, -0.271118, -0.272179, -0.273241, -0.271862, -0.271199, -0.272782, -0.272983, -0.27133,  -0.271614,
      -0.273195, -0.272443, -0.271072, -0.272234, -0.273273, -0.271795, -0.271183, -0.272854, -0.272979, -0.271257,
      -0.271638, -0.273263, -0.272399, -0.271013, -0.272295, -0.273317, -0.271721, -0.271159, -0.272938, -0.272981,
      -0.27117,  -0.271661, -0.273348, -0.272353, -0.270939, -0.272364, -0.273375, -0.271633, -0.271124, -0.273039,
      -0.272989, -0.271063, -0.271683, -0.273453, -0.272301, -0.270845, -0.272445, -0.273449, -0.271528, -0.271076,
      -0.273162, -0.273004, -0.270931, -0.271705, -0.273584, -0.27224,  -0.270726, -0.272542, -0.273546, -0.271399,
      -0.271012, -0.273314, -0.273026, -0.270765, -0.271729, -0.27375,  -0.272167, -0.270573, -0.272663, -0.273671,
      -0.271236, -0.270928, -0.273509, -0.273058, -0.270551, -0.271757, -0.273966, -0.272074, -0.270372, -0.272818,
      -0.273836, -0.271024, -0.270816, -0.273765, -0.273102, -0.270268, -0.271794, -0.274254, -0.271952, -0.270104,
      -0.273026, -0.27406,  -0.270739, -0.270663, -0.274113, -0.273162, -0.269881, -0.271844, -0.274652, -0.271782,
      -0.269731, -0.273318, -0.274372, -0.270335, -0.270448, -0.274609, -0.273245, -0.269325, -0.271919, -0.275227,
      -0.271529, -0.269186, -0.273753, -0.274832, -0.269727, -0.270131, -0.275363, -0.273365, -0.268468, -0.272046,
      -0.276124, -0.271122, -0.268326, -0.274459, -0.275565, -0.268727, -0.269623, -0.276624, -0.273547, -0.267009,
      -0.272286, -0.277685, -0.270375, -0.266796, -0.275772, -0.276898, -0.266822, -0.268688, -0.279104, -0.273856,
      -0.264035, -0.272857, -0.280999, -0.268654, -0.263395, -0.278925, -0.280003, -0.26196,  -0.266433, -0.285934,
      -0.274444, -0.255022, -0.275171, -0.292304, -0.261422, -0.249951, -0.294793, -0.294589, -0.229025, -0.255629,
      -0.363969, -0.233628},
     {0.273645,  0.716344,  0.908287,  0.859299,  0.773265,  0.783419,  0.839344,  0.844754,  0.80557,   0.792315,
      0.819654,  0.836864,  0.818818,  0.800085,  0.810552,  0.829115,  0.82485,   0.807678,  0.806979,  0.821891,
      0.826392,  0.814311,  0.807111,  0.816051,  0.824914,  0.819191,  0.809614,  0.812246,  0.821704,  0.821863,
      0.813223,  0.810709,  0.817986,  0.822322,  0.816788,  0.811217,  0.814799,  0.821,     0.819416,  0.813167,
      0.812859,  0.818633,  0.820597,  0.815733,  0.812452,  0.816083,  0.820266,  0.818071,  0.813435,  0.814123,
      0.81876,   0.819521,  0.815308,  0.813269,  0.816695,  0.819741,  0.817381,  0.813671,  0.814789,  0.818777,
      0.818963,  0.815098,  0.813659,  0.817022,  0.819552,  0.817022,  0.813659,  0.815098,  0.818963,  0.818777,
      0.814789,  0.813671,  0.817381,  0.819741,  0.816695,  0.813269,  0.815308,  0.819521,  0.81876,   0.814123,
      0.813435,  0.818071,  0.820266,  0.816083,  0.812452,  0.815733,  0.820597,  0.818633,  0.812859,  0.813167,
      0.819416,  0.821,     0.814799,  0.811217,  0.816788,  0.822322,  0.817986,  0.810709,  0.813223,  0.821863,
      0.821704,  0.812246,  0.809614,  0.819191,  0.824914,  0.816051,  0.807111,  0.814311,  0.826392,  0.821891,
      0.806979,  0.807678,  0.82485,   0.829115,  0.810552,  0.800085,  0.818818,  0.836864,  0.819654,  0.792315,
      0.80557,   0.844754,  0.839344,  0.783419,  0.773265,  0.859299,  0.908287,  0.716344,  0.273645,  -0.171631,
      -0.366783, -0.316002, -0.226318, -0.237372, -0.297174, -0.302631, -0.259575, -0.245323, -0.276301, -0.295402,
      -0.27417,  -0.252759, -0.265765, -0.287642, -0.281637, -0.26071,  -0.260837, -0.279728, -0.284375, -0.268327,
      -0.260007, -0.272664, -0.283569, -0.274603, -0.262171, -0.267371, -0.280338, -0.27877,  -0.266165, -0.264419,
      -0.275887, -0.280481, -0.270774, -0.263917, -0.271401, -0.279863, -0.274887, -0.265513, -0.26787,  -0.277467,
      -0.277672, -0.268498, -0.26594,  -0.27412,  -0.278693, -0.271975, -0.265826, -0.270739, -0.277956, -0.275057,
      -0.267314, -0.268131, -0.275857, -0.277056, -0.269854, -0.266832, -0.273061, -0.277611, -0.272715, -0.267016,
      -0.270322, -0.276736, -0.275163, -0.268492, -0.268307, -0.274783, -0.276635, -0.270775, -0.26745,  -0.272331,
      -0.276849, -0.27323,  -0.267866, -0.270031, -0.275854, -0.275231, -0.269354, -0.268447, -0.273989, -0.27631,
      -0.271461, -0.267926, -0.271783, -0.276259, -0.273617, -0.268529, -0.269816, -0.275161, -0.275273, -0.270034,
      -0.268571, -0.273359, -0.276039, -0.272007, -0.268321, -0.271349, -0.27577,  -0.273922, -0.269078, -0.269652,
      -0.274587, -0.275294, -0.270599, -0.268687, -0.272836, -0.275799, -0.27246,  -0.268666, -0.27099,  -0.275345,
      -0.27417,  -0.269554, -0.269525, -0.27409,  -0.275298, -0.271088, -0.268803, -0.272385, -0.275575, -0.272848,
      -0.26898,  -0.270685, -0.274962, -0.274377, -0.269981, -0.269426, -0.273645, -0.275286, -0.271523, -0.26892,
      -0.271985, -0.275362, -0.27319,  -0.269275, -0.270419, -0.274607, -0.274551, -0.270375, -0.26935,  -0.273237,
      -0.275261, -0.271919, -0.269042, -0.271623, -0.275152, -0.273497, -0.269557, -0.270185, -0.274269, -0.2747,
      -0.270746, -0.269294, -0.272856, -0.275223, -0.272288, -0.269171, -0.271289, -0.274942, -0.273777, -0.269835,
      -0.269976, -0.273942, -0.274828, -0.271103, -0.269255, -0.272492, -0.275172, -0.272637, -0.269308, -0.270975,
      -0.274728, -0.274036, -0.270112, -0.269787, -0.27362,  -0.274936, -0.27145,  -0.269233, -0.27214,  -0.275108,
      -0.272972, -0.269455, -0.270678, -0.274508, -0.274279, -0.270391, -0.269614, -0.273298, -0.275029, -0.271795,
      -0.269226, -0.271795, -0.275029, -0.273298, -0.269614, -0.270391, -0.274279, -0.274508, -0.270678, -0.269455,
      -0.272972, -0.275108, -0.27214,  -0.269233, -0.27145,  -0.274936, -0.27362,  -0.269787, -0.270112, -0.274036,
      -0.274728, -0.270975, -0.269308, -0.272637, -0.275172, -0.272492, -0.269255, -0.271103, -0.274828, -0.273942,
      -0.269976, -0.269835, -0.273777, -0.274942, -0.271289, -0.269171, -0.272288, -0.275223, -0.272856, -0.269294,
      -0.270746, -0.2747,   -0.274269, -0.270185, -0.269557, -0.273497, -0.275152, -0.271623, -0.269042, -0.271919,
      -0.275261, -0.273237, -0.26935,  -0.270375, -0.274551, -0.274607, -0.270419, -0.269275, -0.27319,  -0.275362,
      -0.271985, -0.26892,  -0.271523, -0.275286, -0.273645, -0.269426, -0.269981, -0.274377, -0.274962, -0.270685,
      -0.26898,  -0.272848, -0.275575, -0.272385, -0.268803, -0.271088, -0.275298, -0.27409,  -0.269525, -0.269554,
      -0.27417,  -0.275345, -0.27099,  -0.268666, -0.27246,  -0.275799, -0.272836, -0.268687, -0.270599, -0.275294,
      -0.274587, -0.269652, -0.269078, -0.273922, -0.27577,  -0.271349, -0.268321, -0.272007, -0.276039, -0.273359,
      -0.268571, -0.270034, -0.275273, -0.275161, -0.269816, -0.268529, -0.273617, -0.276259, -0.271783, -0.267926,
      -0.271461, -0.27631,  -0.273989, -0.268447, -0.269354, -0.275231, -0.275854, -0.270031, -0.267866, -0.27323,
      -0.276849, -0.272331, -0.26745,  -0.270775, -0.276635, -0.274783, -0.268307, -0.268492, -0.275163, -0.276736,
      -0.270322, -0.267016, -0.272715, -0.277611, -0.273061, -0.266832, -0.269854, -0.277056, -0.275857, -0.268131,
      -0.267314, -0.275057, -0.277956, -0.270739, -0.265826, -0.271975, -0.278693, -0.27412,  -0.26594,  -0.268498,
      -0.277672, -0.277467, -0.26787,  -0.265513, -0.274887, -0.279863, -0.271401, -0.263917, -0.270774, -0.280481,
      -0.275887, -0.264419, -0.266165, -0.27877,  -0.280338, -0.267371, -0.262171, -0.274603, -0.283569, -0.272664,
      -0.260007, -0.268327, -0.284375, -0.279728, -0.260837, -0.26071,  -0.281637, -0.287642, -0.265765, -0.252759,
      -0.27417,  -0.295402, -0.276301, -0.245323, -0.259576, -0.302631, -0.297174, -0.237372, -0.226318, -0.316002,
      -0.366783, -0.171631},
     {0.273945,  0.660801,  0.881019,  0.899998,  0.819104,  0.76658,   0.78794,   0.836086,  0.849235,  0.820898,
      0.793258,  0.798708,  0.82464,   0.836503,  0.82226,   0.803082,  0.803013,  0.819581,  0.830336,  0.822732,
      0.808291,  0.80567,   0.816868,  0.826516,  0.822716,  0.811509,  0.807639,  0.815316,  0.823866,  0.822425,
      0.813633,  0.809215,  0.814437,  0.821932,  0.821986,  0.815066,  0.810504,  0.81398,   0.820499,  0.821489,
      0.816025,  0.811551,  0.813787,  0.819449,  0.820999,  0.816649,  0.812376,  0.81375,   0.818698,  0.820566,
      0.817041,  0.812994,  0.813785,  0.818181,  0.820229,  0.817286,  0.813423,  0.813821,  0.817842,  0.820016,
      0.817456,  0.813683,  0.813803,  0.81762,   0.819943,  0.81762,   0.813803,  0.813683,  0.817456,  0.820016,
      0.817842,  0.813821,  0.813423,  0.817286,  0.820229,  0.818181,  0.813785,  0.812994,  0.817041,  0.820566,
      0.818698,  0.81375,   0.812376,  0.816649,  0.820999,  0.819449,  0.813787,  0.811551,  0.816025,  0.821489,
      0.820499,  0.81398,   0.810504,  0.815066,  0.821986,  0.821932,  0.814437,  0.809215,  0.813633,  0.822425,
      0.823866,  0.815316,  0.807639,  0.811509,  0.822716,  0.826516,  0.816868,  0.80567,   0.808291,  0.822732,
      0.830336,  0.819581,  0.803013,  0.803082,  0.82226,   0.836503,  0.82464,   0.798708,  0.793258,  0.820898,
      0.849235,  0.836086,  0.78794,   0.76658,   0.819104,  0.899998,  0.881019,  0.660802,  0.273945,  -0.115176,
      -0.339287, -0.358804, -0.274402, -0.218812, -0.241477, -0.293634, -0.308365, -0.277149, -0.245847, -0.251545,
      -0.28133,  -0.295722, -0.279435, -0.256244, -0.255332, -0.275324, -0.289397, -0.280746, -0.262212, -0.257689,
      -0.271633, -0.285179, -0.281428, -0.266331, -0.2596,   -0.269131, -0.281906, -0.281648, -0.269451, -0.261374,
      -0.267389, -0.279153, -0.281495, -0.271915, -0.263115, -0.266212, -0.276747, -0.281026, -0.27388,  -0.264855,
      -0.265498, -0.274618, -0.280292, -0.275423, -0.266587, -0.26518,  -0.272743, -0.279338, -0.276584, -0.268288,
      -0.26521,  -0.271122, -0.278212, -0.277387, -0.269924, -0.265543, -0.269763, -0.276962, -0.277855, -0.271458,
      -0.266136, -0.268676, -0.275641, -0.278009, -0.272851, -0.266943, -0.26787,  -0.274299, -0.277873, -0.27407,
      -0.267914, -0.267346, -0.272986, -0.277481, -0.275085, -0.269,    -0.267101, -0.271752, -0.276868, -0.275873,
      -0.270148, -0.267121, -0.270638, -0.276076, -0.276419, -0.271306, -0.267388, -0.269683, -0.27515,  -0.276717,
      -0.272424, -0.267872, -0.268917, -0.27414,  -0.276769, -0.273457, -0.26854,  -0.268362, -0.273095, -0.276589,
      -0.274364, -0.26935,  -0.268031, -0.272064, -0.276197, -0.27511,  -0.270258, -0.267927, -0.271093, -0.275622,
      -0.275669, -0.271218, -0.268045, -0.270224, -0.274899, -0.276024, -0.272182, -0.268367, -0.269494, -0.274069,
      -0.276167, -0.273105, -0.268872, -0.268932, -0.273174, -0.276098, -0.273945, -0.269527, -0.268558, -0.272262,
      -0.27583,  -0.274663, -0.270297, -0.268384, -0.271375, -0.275382, -0.275229, -0.271139, -0.268411, -0.270557,
      -0.27478,  -0.27562,  -0.272012, -0.268635, -0.269845, -0.274059, -0.275822, -0.272871, -0.269038, -0.269274,
      -0.273256, -0.275828, -0.273675, -0.269596, -0.268865, -0.272414, -0.275643, -0.274384, -0.270279, -0.268639,
      -0.271574, -0.275278, -0.274965, -0.27105,  -0.268602, -0.270779, -0.274756, -0.27539,  -0.27187,  -0.268755,
      -0.270068, -0.274104, -0.275641, -0.272697, -0.269086, -0.269476, -0.273357, -0.275707, -0.27349,  -0.269578,
      -0.269031, -0.272552, -0.275585, -0.274208, -0.270206, -0.268755, -0.271731, -0.275282, -0.274815, -0.270936,
      -0.268662, -0.270936, -0.274815, -0.275282, -0.271731, -0.268755, -0.270206, -0.274208, -0.275585, -0.272552,
      -0.269031, -0.269578, -0.27349,  -0.275707, -0.273357, -0.269476, -0.269086, -0.272697, -0.275641, -0.274104,
      -0.270068, -0.268755, -0.27187,  -0.27539,  -0.274756, -0.270779, -0.268602, -0.27105,  -0.274965, -0.275278,
      -0.271574, -0.268639, -0.270279, -0.274384, -0.275643, -0.272414, -0.268865, -0.269596, -0.273675, -0.275828,
      -0.273256, -0.269274, -0.269038, -0.272871, -0.275822, -0.274059, -0.269845, -0.268635, -0.272012, -0.27562,
      -0.27478,  -0.270557, -0.268411, -0.271139, -0.275229, -0.275382, -0.271375, -0.268384, -0.270297, -0.274663,
      -0.275831, -0.272262, -0.268558, -0.269527, -0.273945, -0.276098, -0.273174, -0.268932, -0.268872, -0.273105,
      -0.276167, -0.274069, -0.269494, -0.268367, -0.272182, -0.276024, -0.274899, -0.270224, -0.268045, -0.271218,
      -0.275669, -0.275622, -0.271093, -0.267927, -0.270258, -0.27511,  -0.276197, -0.272064, -0.268031, -0.26935,
      -0.274364, -0.276589, -0.273095, -0.268362, -0.26854,  -0.273457, -0.276769, -0.27414,  -0.268917, -0.267872,
      -0.272424, -0.276717, -0.27515,  -0.269683, -0.267388, -0.271306, -0.276419, -0.276076, -0.270638, -0.267121,
      -0.270147, -0.275873, -0.276868, -0.271752, -0.267101, -0.269,    -0.275086, -0.277481, -0.272986, -0.267346,
      -0.267914, -0.27407,  -0.277873, -0.274299, -0.26787,  -0.266943, -0.272851, -0.278009, -0.275641, -0.268676,
      -0.266136, -0.271458, -0.277855, -0.276962, -0.269763, -0.265543, -0.269924, -0.277387, -0.278212, -0.271122,
      -0.26521,  -0.268288, -0.276584, -0.279338, -0.272743, -0.26518,  -0.266587, -0.275423, -0.280292, -0.274618,
      -0.265498, -0.264855, -0.27388,  -0.281026, -0.276747, -0.266212, -0.263115, -0.271915, -0.281495, -0.279153,
      -0.267389, -0.261374, -0.269451, -0.281648, -0.281906, -0.269131, -0.259601, -0.266331, -0.281428, -0.285179,
      -0.271633, -0.257689, -0.262212, -0.280746, -0.289397, -0.275324, -0.255332, -0.256244, -0.279435, -0.295722,
      -0.28133,  -0.251545, -0.245847, -0.277149, -0.308366, -0.293634, -0.241477, -0.218812, -0.274402, -0.358804,
      -0.339287, -0.115176},
     {0.27429,   0.606562,  0.83336,   0.911432,  0.875151,  0.803954,  0.766541,  0.782306,  0.823497,  0.8493,
      0.84118,   0.812962,  0.792852,  0.79704,   0.817951,  0.834571,  0.832723,  0.816529,  0.802335,  0.802678,
      0.815567,  0.827935,  0.8286,    0.818154,  0.807234,  0.805884,  0.814459,  0.824187,  0.826001,  0.818894,
      0.810171,  0.80805,   0.81399,   0.821852,  0.824163,  0.819161,  0.812041,  0.809627,  0.813875,  0.820352,
      0.822805,  0.819162,  0.813239,  0.810794,  0.813958,  0.819407,  0.821809,  0.819019,  0.813972,  0.811632,
      0.814137,  0.818856,  0.821121,  0.818823,  0.814365,  0.812177,  0.814333,  0.818596,  0.820715,  0.818644,
      0.814511,  0.812447,  0.814479,  0.818548,  0.820581,  0.818548,  0.814479,  0.812447,  0.814511,  0.818644,
      0.820715,  0.818596,  0.814333,  0.812177,  0.814365,  0.818823,  0.821121,  0.818856,  0.814137,  0.811632,
      0.813972,  0.819019,  0.821809,  0.819407,  0.813958,  0.810794,  0.813239,  0.819162,  0.822805,  0.820352,
      0.813875,  0.809627,  0.812041,  0.819161,  0.824163,  0.821852,  0.81399,   0.80805,   0.810171,  0.818894,
      0.826001,  0.824187,  0.814459,  0.805884,  0.807234,  0.818154,  0.8286,    0.827935,  0.815567,  0.802678,
      0.802335,  0.816529,  0.832723,  0.83457,   0.817951,  0.79704,   0.792852,  0.812962,  0.84118,   0.8493,
      0.823497,  0.782306,  0.766541,  0.803954,  0.875151,  0.911432,  0.83336,   0.606562,  0.27429,   -0.0599483,
      -0.290815, -0.371275, -0.333479, -0.258269, -0.218076, -0.234884, -0.279977, -0.308915, -0.300243, -0.268288,
      -0.244728, -0.248967, -0.273396, -0.293737, -0.292346, -0.272903, -0.254765, -0.254142, -0.269962, -0.286447,
      -0.288582, -0.275569, -0.260414, -0.2571,   -0.267833, -0.281859, -0.286116, -0.277298, -0.264272, -0.259252,
      -0.266419, -0.27853,  -0.28417,  -0.278456, -0.267203, -0.261061, -0.265479, -0.275912, -0.282453, -0.279204,
      -0.269565, -0.262715, -0.264901, -0.273765, -0.280843, -0.279625, -0.271524, -0.264293, -0.264625, -0.271973,
      -0.279289, -0.279767, -0.273163, -0.265827, -0.264609, -0.270476, -0.277774, -0.279664, -0.274525, -0.267322,
      -0.264823, -0.269245, -0.2763,   -0.279345, -0.275629, -0.268772, -0.265241, -0.268263, -0.274879, -0.278835,
      -0.27649,  -0.27016,  -0.265836, -0.267521, -0.273528, -0.278161, -0.277115, -0.271468, -0.266581, -0.267012,
      -0.272268, -0.277352, -0.277512, -0.272675, -0.267446, -0.266726, -0.271119, -0.276438, -0.277689, -0.27376,
      -0.268403, -0.266654, -0.270103, -0.275448, -0.277659, -0.274704, -0.269418, -0.266783, -0.269236, -0.274416,
      -0.277435, -0.27549,  -0.270461, -0.267096, -0.268533, -0.273371, -0.277037, -0.276106, -0.271499, -0.267574,
      -0.268006, -0.272347, -0.276486, -0.276543, -0.272503, -0.268193, -0.267661, -0.271372, -0.275806, -0.276796,
      -0.273442, -0.268927, -0.2675,   -0.270475, -0.275025, -0.276865, -0.27429,  -0.269748, -0.26752,  -0.269682,
      -0.274171, -0.276757, -0.275023, -0.270626, -0.267714, -0.269013, -0.273276, -0.276481, -0.275622, -0.27153,
      -0.268069, -0.268487, -0.272371, -0.276052, -0.276071, -0.272429, -0.268568, -0.268117, -0.271486, -0.275488,
      -0.27636,  -0.273294, -0.26919,  -0.267912, -0.27065,  -0.274813, -0.276481, -0.274095, -0.269912, -0.267874,
      -0.269891, -0.274052, -0.276436, -0.274806, -0.270706, -0.268002, -0.269233, -0.273231, -0.276228, -0.275404,
      -0.271545, -0.268288, -0.268699, -0.272382, -0.275866, -0.27587,  -0.272397, -0.268722, -0.268304, -0.271534,
      -0.275366, -0.27619,  -0.273234, -0.269285, -0.268062, -0.270716, -0.274745, -0.276352, -0.274026, -0.269958,
      -0.267981, -0.269958, -0.274026, -0.276352, -0.274745, -0.270716, -0.268062, -0.269285, -0.273234, -0.27619,
      -0.275366, -0.271534, -0.268304, -0.268722, -0.272397, -0.27587,  -0.275866, -0.272382, -0.268699, -0.268288,
      -0.271545, -0.275404, -0.276228, -0.273231, -0.269233, -0.268002, -0.270706, -0.274806, -0.276436, -0.274052,
      -0.269891, -0.267874, -0.269912, -0.274095, -0.276481, -0.274813, -0.27065,  -0.267912, -0.26919,  -0.273294,
      -0.27636,  -0.275488, -0.271486, -0.268117, -0.268568, -0.272429, -0.276071, -0.276052, -0.272371, -0.268487,
      -0.268069, -0.27153,  -0.275622, -0.276481, -0.273276, -0.269013, -0.267714, -0.270626, -0.275023, -0.276757,
      -0.274172, -0.269682, -0.267521, -0.269748, -0.27429,  -0.276865, -0.275025, -0.270475, -0.2675,   -0.268927,
      -0.273441, -0.276796, -0.275806, -0.271372, -0.267661, -0.268193, -0.272503, -0.276543, -0.276486, -0.272347,
      -0.268006, -0.267574, -0.271499, -0.276106, -0.277037, -0.273371, -0.268533, -0.267096, -0.270461, -0.27549,
      -0.277435, -0.274416, -0.269236, -0.266783, -0.269418, -0.274704, -0.277659, -0.275448, -0.270103, -0.266654,
      -0.268403, -0.27376,  -0.277689, -0.276438, -0.271119, -0.266726, -0.267446, -0.272675, -0.277512, -0.277352,
      -0.272268, -0.267011, -0.266581, -0.271468, -0.277115, -0.278161, -0.273528, -0.267521, -0.265836, -0.27016,
      -0.27649,  -0.278835, -0.274879, -0.268263, -0.265241, -0.268772, -0.275629, -0.279345, -0.2763,   -0.269245,
      -0.264823, -0.267322, -0.274525, -0.279664, -0.277774, -0.270476, -0.264609, -0.265827, -0.273163, -0.279767,
      -0.279289, -0.271973, -0.264625, -0.264293, -0.271524, -0.279625, -0.280843, -0.273765, -0.264901, -0.262715,
      -0.269565, -0.279204, -0.282453, -0.275912, -0.265479, -0.261061, -0.267203, -0.278456, -0.28417,  -0.278529,
      -0.266418, -0.259252, -0.264272, -0.277298, -0.286116, -0.281859, -0.267834, -0.2571,   -0.260414, -0.275569,
      -0.288581, -0.286447, -0.269962, -0.254142, -0.254765, -0.272903, -0.292346, -0.293737, -0.273396, -0.248967,
      -0.244728, -0.268288, -0.300243, -0.308915, -0.279978, -0.234884, -0.218076, -0.258269, -0.333479, -0.371275,
      -0.290815, -0.0599483},
     {0.269629,  0.548702,   0.768472,  0.890932,  0.91452,   0.870994,  0.808021,  0.766696,  0.765118,  0.795238,
      0.832898,  0.85422,    0.84899,   0.824319,  0.79795,   0.786327,  0.794931,  0.816236,  0.835678,  0.841268,
      0.83072,   0.81201,    0.797582,  0.796243,  0.80793,   0.824365,  0.834797,  0.832935,  0.820657,  0.806365,
      0.799307,  0.803657,   0.816103,  0.828298,  0.832412,  0.826114,  0.813853,  0.803747,  0.802246,  0.810044,
      0.821816,  0.829829,   0.828997,  0.820089,  0.809079,  0.803162,  0.806069,  0.815731,  0.825735,  0.829565,
      0.824831,  0.81475,    0.805971,  0.804202,  0.810513,  0.820693,  0.828054,  0.827809,  0.820176,  0.810202,
      0.804428,  0.806619,   0.815309,  0.824783,  0.828825,  0.824783,  0.815309,  0.806619,  0.804428,  0.810202,
      0.820176,  0.827809,   0.828054,  0.820693,  0.810513,  0.804202,  0.805971,  0.81475,   0.824831,  0.829565,
      0.825735,  0.815731,   0.806069,  0.803162,  0.809079,  0.820089,  0.828997,  0.829829,  0.821816,  0.810044,
      0.802246,  0.803747,   0.813853,  0.826115,  0.832412,  0.828298,  0.816103,  0.803657,  0.799307,  0.806365,
      0.820657,  0.832935,   0.834797,  0.824365,  0.80793,   0.796243,  0.797582,  0.81201,   0.83072,   0.841268,
      0.835678,  0.816236,   0.794931,  0.786327,  0.79795,   0.824319,  0.84899,   0.85422,   0.832898,  0.795238,
      0.765118,  0.766696,   0.808021,  0.870994,  0.91452,   0.890932,  0.768472,  0.548703,  0.269629,  -0.00777033,
      -0.223617, -0.342481,  -0.365164, -0.324021, -0.265156, -0.226969, -0.225492, -0.252604, -0.286116, -0.304877,
      -0.30036,  -0.27922,   -0.256887, -0.247151, -0.25424,  -0.27161,  -0.287277, -0.291737, -0.283464, -0.268957,
      -0.257901, -0.256877,  -0.265592, -0.277704, -0.285301, -0.283974, -0.275276, -0.265274, -0.260391, -0.263348,
      -0.271716, -0.279814,  -0.282516, -0.278453, -0.270637, -0.264276, -0.263338, -0.268105, -0.27521,  -0.279985,
      -0.279503, -0.274351,  -0.268068, -0.264735, -0.266341, -0.271617, -0.277006, -0.279044, -0.276575, -0.271385,
      -0.266929, -0.26604,   -0.26914,  -0.27407,  -0.277582, -0.277473, -0.273952, -0.269419, -0.266835, -0.267793,
      -0.271547, -0.275575,  -0.277269, -0.275614, -0.271792, -0.268346, -0.267488, -0.269691, -0.273433, -0.276246,
      -0.27634,  -0.273735,  -0.270197, -0.268044, -0.26863,  -0.271497, -0.274726, -0.276215, -0.275045, -0.272045,
      -0.269209, -0.26837,   -0.270023, -0.273033, -0.275413, -0.275635, -0.273606, -0.270695, -0.268814, -0.26916,
      -0.271459, -0.274174,  -0.275532, -0.27468,  -0.272218, -0.26978,  -0.26895,  -0.270236, -0.27276,  -0.274855,
      -0.275167, -0.273527,  -0.271038, -0.269336, -0.269514, -0.271423, -0.27379,  -0.275065, -0.274437, -0.272346,
      -0.270179, -0.269349,  -0.270375, -0.27256,  -0.274462, -0.274845, -0.273482, -0.271288, -0.269704, -0.269756,
      -0.271387, -0.273511,  -0.274736, -0.274274, -0.272449, -0.270469, -0.269629, -0.270463, -0.272406, -0.274176,
      -0.27462,  -0.273463,  -0.271478, -0.269971, -0.269922, -0.271347, -0.273299, -0.274498, -0.274168, -0.272538,
      -0.270687, -0.269828,  -0.270512, -0.272279, -0.273964, -0.274465, -0.273465, -0.27163,  -0.270167, -0.27003,
      -0.2713,   -0.273134,  -0.274329, -0.274106, -0.272622, -0.270856, -0.269966, -0.27053,  -0.272169, -0.273804,
      -0.274364, -0.273487,  -0.271757, -0.27031,  -0.270094, -0.271244, -0.273,    -0.274209, -0.274081, -0.272705,
      -0.270987, -0.270056,  -0.270519, -0.272068, -0.273684, -0.274306, -0.27353,  -0.271868, -0.270412, -0.270118,
      -0.271176, -0.272889,  -0.274132, -0.27409,  -0.272792, -0.271092, -0.270105, -0.27048,  -0.271969, -0.273594,
      -0.274287, -0.273594,  -0.271969, -0.270481, -0.270105, -0.271092, -0.272792, -0.27409,  -0.274132, -0.272889,
      -0.271176, -0.270118,  -0.270412, -0.271868, -0.27353,  -0.274306, -0.273684, -0.272068, -0.270519, -0.270056,
      -0.270987, -0.272705,  -0.274081, -0.274209, -0.273,    -0.271244, -0.270094, -0.27031,  -0.271757, -0.273488,
      -0.274364, -0.273804,  -0.272169, -0.27053,  -0.269966, -0.270856, -0.272622, -0.274106, -0.274329, -0.273134,
      -0.2713,   -0.27003,   -0.270167, -0.27163,  -0.273465, -0.274465, -0.273964, -0.272279, -0.270512, -0.269828,
      -0.270687, -0.272538,  -0.274168, -0.274498, -0.273299, -0.271347, -0.269922, -0.269971, -0.271478, -0.273463,
      -0.27462,  -0.274176,  -0.272406, -0.270463, -0.269629, -0.270469, -0.272449, -0.274274, -0.274736, -0.273511,
      -0.271387, -0.269756,  -0.269704, -0.271288, -0.273482, -0.274845, -0.274462, -0.27256,  -0.270375, -0.269349,
      -0.270179, -0.272346,  -0.274437, -0.275065, -0.27379,  -0.271423, -0.269514, -0.269336, -0.271038, -0.273527,
      -0.275167, -0.274855,  -0.27276,  -0.270236, -0.26895,  -0.26978,  -0.272218, -0.27468,  -0.275532, -0.274174,
      -0.271459, -0.26916,   -0.268814, -0.270695, -0.273606, -0.275635, -0.275413, -0.273033, -0.270023, -0.26837,
      -0.269209, -0.272045,  -0.275045, -0.276215, -0.274726, -0.271497, -0.26863,  -0.268044, -0.270197, -0.273735,
      -0.27634,  -0.276246,  -0.273433, -0.269691, -0.267488, -0.268346, -0.271793, -0.275614, -0.277269, -0.275575,
      -0.271547, -0.267793,  -0.266835, -0.269419, -0.273952, -0.277473, -0.277582, -0.27407,  -0.26914,  -0.26604,
      -0.266929, -0.271385,  -0.276575, -0.279044, -0.277006, -0.271617, -0.266341, -0.264735, -0.268068, -0.274351,
      -0.279503, -0.279985,  -0.27521,  -0.268105, -0.263338, -0.264276, -0.270637, -0.278453, -0.282516, -0.279814,
      -0.271716, -0.263348,  -0.260391, -0.265274, -0.275276, -0.283974, -0.285301, -0.277704, -0.265592, -0.256877,
      -0.257901, -0.268957,  -0.283464, -0.291737, -0.287277, -0.27161,  -0.25424,  -0.247151, -0.256887, -0.27922,
      -0.30036,  -0.304877,  -0.286116, -0.252604, -0.225492, -0.226969, -0.265156, -0.324021, -0.365164, -0.342481,
      -0.223617, -0.00777033},
     {0.275163,  0.510351,  0.707701,  0.841693,  0.904112,  0.904771,  0.866609,  0.817176,  0.779684,  0.766667,
      0.778136,  0.804304,  0.831309,  0.847445,  0.847509,  0.833889,  0.814436,  0.798402,  0.792352,  0.79772,
      0.810829,  0.825062,  0.834043,  0.834358,  0.82673,   0.815281,  0.805414,  0.80134,   0.804349,  0.812514,
      0.821807,  0.828041,  0.828707,  0.823936,  0.816233,  0.8092,    0.805882,  0.807479,  0.81296,   0.819665,
      0.824582,  0.825671,  0.822689,  0.817179,  0.811685,  0.808598,  0.809126,  0.812854,  0.818006,  0.822284,
      0.823882,  0.822228,  0.818171,  0.81355,   0.810372,  0.809952,  0.812383,  0.816543,  0.820604,  0.822828,
      0.822296,  0.819282,  0.815108,  0.811577,  0.810205,  0.811577,  0.815108,  0.819282,  0.822296,  0.822828,
      0.820604,  0.816543,  0.812383,  0.809952,  0.810372,  0.81355,   0.818171,  0.822228,  0.823882,  0.822284,
      0.818006,  0.812854,  0.809126,  0.808598,  0.811685,  0.817179,  0.822689,  0.825671,  0.824582,  0.819665,
      0.81296,   0.807479,  0.805882,  0.8092,    0.816233,  0.823936,  0.828707,  0.828041,  0.821807,  0.812514,
      0.804349,  0.80134,   0.805414,  0.815281,  0.82673,   0.834358,  0.834043,  0.825062,  0.810829,  0.79772,
      0.792352,  0.798402,  0.814436,  0.833889,  0.847509,  0.847445,  0.831309,  0.804304,  0.778136,  0.766667,
      0.779684,  0.817176,  0.866609,  0.904771,  0.904112,  0.841693,  0.707701,  0.510351,  0.275163,  0.0385251,
      -0.162473, -0.300541, -0.365482, -0.365886, -0.324809, -0.271216, -0.230335, -0.21635,  -0.22975,  -0.259817,
      -0.290799, -0.309056, -0.308346, -0.291423, -0.267733, -0.248585, -0.242066, -0.249852, -0.267106, -0.285202,
      -0.295881, -0.294889, -0.283562, -0.267809, -0.255126, -0.251107, -0.25704,  -0.269596, -0.282621, -0.2901,
      -0.288892, -0.280013, -0.267948, -0.258426, -0.255727, -0.260786, -0.270913, -0.281196, -0.286858, -0.28546,
      -0.277932, -0.268009, -0.260396, -0.258552, -0.26313,  -0.271775, -0.280319, -0.28478,  -0.283208, -0.276525,
      -0.268011, -0.261698, -0.260474, -0.264767, -0.272412, -0.27974,  -0.283328, -0.281593, -0.275484, -0.267974,
      -0.26262,  -0.261882, -0.265996, -0.272921, -0.27934,  -0.282251, -0.280361, -0.274662, -0.267912, -0.263306,
      -0.262967, -0.26697,  -0.273348, -0.279053, -0.281413, -0.279378, -0.273985, -0.267835, -0.263838, -0.263841,
      -0.267775, -0.273721, -0.278843, -0.280738, -0.278563, -0.273407, -0.267747, -0.264262, -0.264566, -0.26846,
      -0.274055, -0.278686, -0.280178, -0.277869, -0.272899, -0.267652, -0.264611, -0.265185, -0.269058, -0.27436,
      -0.278566, -0.2797,   -0.277262, -0.272444, -0.267553, -0.264904, -0.265726, -0.269593, -0.274643, -0.278475,
      -0.279285, -0.276721, -0.272029, -0.267452, -0.265155, -0.266207, -0.270078, -0.27491,  -0.278404, -0.278917,
      -0.27623,  -0.271644, -0.267347, -0.265375, -0.266643, -0.270526, -0.275163, -0.278349, -0.278584, -0.275778,
      -0.271282, -0.267241, -0.26557,  -0.267044, -0.270946, -0.275407, -0.278307, -0.27828,  -0.275355, -0.270938,
      -0.267134, -0.265745, -0.267418, -0.271342, -0.275642, -0.278275, -0.277997, -0.274956, -0.270609, -0.267026,
      -0.265906, -0.267771, -0.271722, -0.275873, -0.278251, -0.277733, -0.274575, -0.270289, -0.266916, -0.266055,
      -0.268107, -0.272089, -0.2761,   -0.278233, -0.27748,  -0.274207, -0.269977, -0.266804, -0.266194, -0.268432,
      -0.272446, -0.276324, -0.278221, -0.277239, -0.273849, -0.269669, -0.266689, -0.266326, -0.268747, -0.272798,
      -0.276549, -0.278214, -0.277004, -0.273497, -0.269363, -0.266572, -0.266451, -0.269057, -0.273147, -0.276775,
      -0.278212, -0.276775, -0.273147, -0.269057, -0.266451, -0.266572, -0.269363, -0.273497, -0.277004, -0.278214,
      -0.276549, -0.272798, -0.268747, -0.266326, -0.266689, -0.269669, -0.273849, -0.277239, -0.278221, -0.276324,
      -0.272446, -0.268432, -0.266194, -0.266804, -0.269977, -0.274207, -0.27748,  -0.278233, -0.2761,   -0.272089,
      -0.268108, -0.266055, -0.266915, -0.270289, -0.274575, -0.277733, -0.278251, -0.275873, -0.271722, -0.267771,
      -0.265906, -0.267026, -0.270609, -0.274956, -0.277998, -0.278275, -0.275642, -0.271342, -0.267418, -0.265745,
      -0.267134, -0.270938, -0.275355, -0.27828,  -0.278307, -0.275407, -0.270946, -0.267044, -0.26557,  -0.267241,
      -0.271282, -0.275778, -0.278584, -0.278349, -0.275163, -0.270526, -0.266643, -0.265375, -0.267347, -0.271644,
      -0.27623,  -0.278917, -0.278404, -0.27491,  -0.270078, -0.266207, -0.265155, -0.267452, -0.272029, -0.276721,
      -0.279285, -0.278475, -0.274643, -0.269593, -0.265726, -0.264904, -0.267553, -0.272444, -0.277262, -0.279701,
      -0.278566, -0.27436,  -0.269058, -0.265185, -0.264611, -0.267652, -0.272899, -0.277869, -0.280178, -0.278686,
      -0.274055, -0.26846,  -0.264566, -0.264262, -0.267747, -0.273407, -0.278563, -0.280738, -0.278843, -0.273721,
      -0.267775, -0.26384,  -0.263838, -0.267835, -0.273985, -0.279378, -0.281413, -0.279053, -0.273348, -0.266971,
      -0.262967, -0.263306, -0.267912, -0.274662, -0.280361, -0.282251, -0.27934,  -0.272921, -0.265996, -0.261882,
      -0.26262,  -0.267974, -0.275484, -0.281593, -0.283328, -0.27974,  -0.272412, -0.264767, -0.260474, -0.261698,
      -0.268011, -0.276526, -0.283208, -0.28478,  -0.280319, -0.271775, -0.26313,  -0.258552, -0.260396, -0.268009,
      -0.277932, -0.28546,  -0.286858, -0.281196, -0.270913, -0.260786, -0.255727, -0.258426, -0.267948, -0.280013,
      -0.288892, -0.2901,   -0.282621, -0.269596, -0.25704,  -0.251107, -0.255126, -0.267809, -0.283562, -0.294889,
      -0.295881, -0.285202, -0.267106, -0.249852, -0.242066, -0.248585, -0.267733, -0.291423, -0.308346, -0.309056,
      -0.290799, -0.259817, -0.22975,  -0.21635,  -0.230335, -0.271216, -0.324809, -0.365886, -0.365482, -0.300541,
      -0.162473, 0.0385251},
     {0.268569,  0.469419,  0.648892,  0.788562,  0.877786,  0.915486,  0.909721,  0.875206,  0.829481,  0.788725,
      0.764284,  0.760712,  0.775725,  0.801894,  0.829499,  0.849655,  0.856837,  0.850159,  0.833148,  0.812231,
      0.79448,   0.785358,  0.78714,   0.798445,  0.814937,  0.830909,  0.841184,  0.842745,  0.835569,  0.822474,
      0.808055,  0.797112,  0.793084,  0.796997,  0.807233,  0.820165,  0.831421,  0.837339,  0.83614,   0.828452,
      0.817019,  0.805743,  0.798363,  0.797232,  0.802571,  0.812455,  0.823493,  0.831984,  0.835147,  0.832021,
      0.823755,  0.813191,  0.803892,  0.798951,  0.799969,  0.806539,  0.816405,  0.826232,  0.832723,  0.833725,
      0.82893,   0.819978,  0.809891,  0.802064,  0.799126,  0.802064,  0.809891,  0.819978,  0.82893,   0.833725,
      0.832723,  0.826232,  0.816405,  0.806539,  0.799969,  0.798951,  0.803892,  0.813191,  0.823755,  0.832021,
      0.835147,  0.831984,  0.823493,  0.812455,  0.802571,  0.797232,  0.798363,  0.805743,  0.817019,  0.828452,
      0.83614,   0.837339,  0.831421,  0.820165,  0.807233,  0.796997,  0.793084,  0.797112,  0.808055,  0.822474,
      0.835569,  0.842745,  0.841184,  0.830909,  0.814937,  0.798445,  0.78714,   0.785358,  0.79448,   0.812231,
      0.833148,  0.850159,  0.856837,  0.849655,  0.829499,  0.801894,  0.775725,  0.760712,  0.764283,  0.788725,
      0.829481,  0.875206,  0.909721,  0.915486,  0.877786,  0.788562,  0.648892,  0.469419,  0.268569,  0.0689345,
      -0.107298, -0.242794, -0.328318, -0.364039, -0.358687, -0.32684,  -0.285143, -0.248419, -0.226655, -0.223498,
      -0.236515, -0.258943, -0.282319, -0.299182, -0.305126, -0.29969,  -0.285996, -0.269361, -0.255415, -0.248332,
      -0.249688, -0.258228, -0.270536, -0.282308, -0.289789, -0.290917, -0.285837, -0.276677, -0.266718, -0.259255,
      -0.25654,  -0.259132, -0.265833, -0.274189, -0.281368, -0.285095, -0.284357, -0.279655, -0.272756, -0.266043,
      -0.261708, -0.261049, -0.264091, -0.269648, -0.275768, -0.280411, -0.282118, -0.280463, -0.276145, -0.270705,
      -0.265987, -0.263515, -0.264012, -0.267191, -0.271893, -0.276505, -0.279505, -0.279964, -0.277824, -0.273891,
      -0.26953,  -0.2662,   -0.26497,  -0.266172, -0.269328, -0.273326, -0.276812, -0.278648, -0.278276, -0.275888,
      -0.272339, -0.268842, -0.266556, -0.266206, -0.267852, -0.270891, -0.274274, -0.276867, -0.277829, -0.276884,
      -0.274395, -0.271231, -0.268461, -0.266998, -0.267297, -0.269214, -0.272075, -0.274902, -0.276756, -0.277041,
      -0.275696, -0.273207, -0.270428, -0.268291, -0.267496, -0.26828,  -0.270349, -0.272988, -0.275303, -0.27653,
      -0.276279, -0.274662, -0.272244, -0.269848, -0.268273, -0.268031, -0.269179, -0.27131,  -0.273695, -0.275533,
      -0.276218, -0.27554,  -0.273748, -0.271458, -0.269443, -0.268374, -0.268594, -0.27001,  -0.272131, -0.274238,
      -0.275626, -0.275839, -0.274823, -0.272934, -0.270815, -0.269179, -0.268569, -0.269174, -0.270779, -0.272834,
      -0.274645, -0.275607, -0.275409, -0.274129, -0.272207, -0.270296, -0.269035, -0.268841, -0.269767, -0.271494,
      -0.273433, -0.274933, -0.275493, -0.274936, -0.273457, -0.27156,  -0.269886, -0.268995, -0.269179, -0.270369,
      -0.272157, -0.273939, -0.275116, -0.275297, -0.274429, -0.272809, -0.270987, -0.269576, -0.269048, -0.269574,
      -0.270973, -0.272769, -0.274356, -0.275203, -0.275028, -0.273894, -0.272188, -0.270485, -0.269359, -0.269185,
      -0.270018, -0.271576, -0.27333,  -0.27469,  -0.275201, -0.274691, -0.273337, -0.271595, -0.270053, -0.26923,
      -0.269401, -0.270507, -0.272173, -0.273839, -0.274942, -0.275113, -0.274294, -0.272762, -0.271033, -0.269691,
      -0.269187, -0.269691, -0.271033, -0.272762, -0.274294, -0.275113, -0.274942, -0.273839, -0.272173, -0.270507,
      -0.269401, -0.26923,  -0.270053, -0.271595, -0.273337, -0.274691, -0.275201, -0.27469,  -0.27333,  -0.271576,
      -0.270018, -0.269185, -0.269359, -0.270485, -0.272188, -0.273894, -0.275028, -0.275203, -0.274356, -0.272769,
      -0.270973, -0.269574, -0.269048, -0.269576, -0.270987, -0.272809, -0.274429, -0.275297, -0.275116, -0.273939,
      -0.272157, -0.270369, -0.269179, -0.268995, -0.269886, -0.27156,  -0.273457, -0.274936, -0.275493, -0.274933,
      -0.273433, -0.271494, -0.269767, -0.268841, -0.269035, -0.270296, -0.272207, -0.274129, -0.275409, -0.275607,
      -0.274645, -0.272834, -0.270779, -0.269174, -0.268569, -0.269179, -0.270815, -0.272934, -0.274823, -0.275839,
      -0.275626, -0.274238, -0.272131, -0.27001,  -0.268593, -0.268374, -0.269443, -0.271458, -0.273748, -0.27554,
      -0.276218, -0.275533, -0.273695, -0.27131,  -0.269179, -0.268031, -0.268273, -0.269848, -0.272244, -0.274662,
      -0.276279, -0.27653,  -0.275303, -0.272988, -0.270349, -0.26828,  -0.267496, -0.268291, -0.270427, -0.273207,
      -0.275696, -0.277041, -0.276756, -0.274902, -0.272075, -0.269214, -0.267297, -0.266998, -0.268461, -0.271231,
      -0.274395, -0.276883, -0.277829, -0.276867, -0.274274, -0.270891, -0.267852, -0.266206, -0.266556, -0.268842,
      -0.272339, -0.275888, -0.278276, -0.278648, -0.276812, -0.273326, -0.269328, -0.266172, -0.26497,  -0.2662,
      -0.26953,  -0.273891, -0.277824, -0.279964, -0.279505, -0.276505, -0.271893, -0.267191, -0.264012, -0.263515,
      -0.265987, -0.270705, -0.276145, -0.280463, -0.282118, -0.280411, -0.275768, -0.269648, -0.264091, -0.261049,
      -0.261708, -0.266043, -0.272756, -0.279655, -0.284357, -0.285095, -0.281368, -0.274189, -0.265833, -0.259132,
      -0.25654,  -0.259255, -0.266718, -0.276677, -0.285837, -0.290917, -0.28979,  -0.282308, -0.270536, -0.258228,
      -0.249688, -0.248332, -0.255415, -0.269361, -0.285996, -0.29969,  -0.305126, -0.299182, -0.282319, -0.258943,
      -0.236515, -0.223498, -0.226655, -0.248419, -0.285143, -0.32684,  -0.358686, -0.364039, -0.328318, -0.242794,
      -0.107298, 0.0689345},
     {0.267848,   0.436212,  0.59232,   0.724536,  0.824489,  0.888165,  0.916284,  0.913911,  0.889404,  0.852872,
      0.814454,   0.782716,  0.763433,  0.758964,  0.768275,  0.787588,  0.81146,   0.834083,  0.850524,  0.857675,
      0.854748,   0.843238,  0.826421,  0.808504,  0.793635,  0.785002,  0.784185,  0.790908,  0.80321,   0.81797,
      0.831676,   0.841227,  0.844614,  0.841323,  0.832392,  0.820104,  0.807429,  0.797312,  0.792011,  0.792601,
      0.798766,   0.808912,  0.820572,  0.830994,  0.837783,  0.83944,   0.835691,  0.827522,  0.816924,  0.806416,
      0.798453,   0.794857,  0.796408,  0.802674,  0.812129,  0.822522,  0.831406,  0.83671,   0.837216,  0.832837,
      0.824631,   0.814545,  0.804959,  0.798128,  0.795659,  0.798129,  0.804959,  0.814545,  0.824631,  0.832837,
      0.837216,   0.83671,   0.831406,  0.822522,  0.812129,  0.802674,  0.796408,  0.794857,  0.798453,  0.806416,
      0.816924,   0.827522,  0.835691,  0.83944,   0.837783,  0.830994,  0.820572,  0.808912,  0.798766,  0.792601,
      0.792011,   0.797312,  0.807429,  0.820105,  0.832392,  0.841323,  0.844614,  0.841227,  0.831676,  0.81797,
      0.80321,    0.790908,  0.784185,  0.785002,  0.793635,  0.808504,  0.826421,  0.843238,  0.854748,  0.857675,
      0.850524,   0.834083,  0.81146,   0.787588,  0.768275,  0.758964,  0.763433,  0.782716,  0.814454,  0.852872,
      0.889404,   0.913911,  0.916284,  0.888165,  0.824489,  0.724536,  0.59232,   0.436212,  0.267848,  0.100506,
      -0.0527742, -0.181024, -0.276808, -0.337098, -0.363412, -0.361247, -0.338914, -0.306013, -0.271829, -0.243929,
      -0.227179,  -0.223334, -0.231207, -0.24735,  -0.267063, -0.285517, -0.298765, -0.304461, -0.30217,  -0.29325,
      -0.280376,  -0.266829, -0.255727, -0.24936,  -0.248759, -0.253582, -0.262299, -0.272627, -0.282094, -0.288608,
      -0.29089,   -0.288711, -0.282865, -0.274926, -0.266844, -0.260478, -0.257185, -0.257542, -0.261259, -0.267296,
      -0.27414,   -0.280173, -0.28405,  -0.284986, -0.282911, -0.278449, -0.272743, -0.267167, -0.263002, -0.261148,
      -0.261931,  -0.265058, -0.269708, -0.274741, -0.278978, -0.281469, -0.281706, -0.279719, -0.276053, -0.27162,
      -0.267475,  -0.264569, -0.263535, -0.264546, -0.267299, -0.271098, -0.275024, -0.278163, -0.279808, -0.279625,
      -0.277712,  -0.274565, -0.270954, -0.267732, -0.265639, -0.265129, -0.266277, -0.268771, -0.271993, -0.275173,
      -0.277571,  -0.278649, -0.278188, -0.276334, -0.273554, -0.270519, -0.267943, -0.266416, -0.266271, -0.26751,
      -0.269812,  -0.272617, -0.275259, -0.277123, -0.277792, -0.277133, -0.275327, -0.27282,  -0.270212, -0.268114,
      -0.267007,  -0.267132, -0.268436, -0.270592, -0.273081, -0.275315, -0.276774, -0.277131, -0.276321, -0.274553,
      -0.272256,  -0.269978, -0.268252, -0.267472, -0.267808, -0.269164, -0.271206, -0.273447, -0.275357, -0.276495,
      -0.276603,  -0.275671, -0.273931, -0.271802, -0.269789, -0.268361, -0.267848, -0.268357, -0.269758, -0.27171,
      -0.27375,   -0.275396, -0.276268, -0.27617,  -0.275133, -0.273413, -0.271419, -0.269624, -0.268446, -0.268157,
      -0.268816,  -0.27026,  -0.272141, -0.274014, -0.275438, -0.276083, -0.275804, -0.274673, -0.272964, -0.271082,
      -0.269472,  -0.26851,  -0.268419, -0.269212, -0.270699, -0.272524, -0.274255, -0.275487, -0.275931, -0.275489,
      -0.274268,  -0.272561, -0.270773, -0.269324, -0.268555, -0.268643, -0.269563, -0.271096, -0.272877, -0.274487,
      -0.275545,  -0.275806, -0.275209, -0.273899, -0.272187, -0.270477, -0.269173, -0.268581, -0.268838, -0.269883,
      -0.271468,  -0.273216, -0.274717, -0.275616, -0.275702, -0.274955, -0.273553, -0.271827, -0.270185, -0.269013,
      -0.26859,   -0.269013, -0.270185, -0.271827, -0.273553, -0.274955, -0.275702, -0.275616, -0.274717, -0.273216,
      -0.271468,  -0.269883, -0.268838, -0.268581, -0.269173, -0.270477, -0.272187, -0.273899, -0.275209, -0.275806,
      -0.275545,  -0.274487, -0.272877, -0.271096, -0.269563, -0.268643, -0.268555, -0.269324, -0.270773, -0.272561,
      -0.274268,  -0.275489, -0.275931, -0.275487, -0.274256, -0.272524, -0.270699, -0.269212, -0.268419, -0.26851,
      -0.269472,  -0.271082, -0.272964, -0.274673, -0.275804, -0.276083, -0.275438, -0.274014, -0.272141, -0.270259,
      -0.268816,  -0.268157, -0.268446, -0.269624, -0.271419, -0.273412, -0.275133, -0.276169, -0.276268, -0.275396,
      -0.27375,   -0.27171,  -0.269758, -0.268357, -0.267848, -0.268361, -0.269789, -0.271802, -0.273931, -0.275671,
      -0.276603,  -0.276495, -0.275357, -0.273447, -0.271206, -0.269164, -0.267808, -0.267472, -0.268252, -0.269978,
      -0.272256,  -0.274553, -0.276321, -0.277131, -0.276774, -0.275315, -0.273081, -0.270592, -0.268436, -0.267132,
      -0.267007,  -0.268114, -0.270212, -0.27282,  -0.275327, -0.277133, -0.277792, -0.277123, -0.275259, -0.272617,
      -0.269812,  -0.26751,  -0.266271, -0.266416, -0.267943, -0.270519, -0.273554, -0.276334, -0.278188, -0.278649,
      -0.277571,  -0.275173, -0.271993, -0.268771, -0.266277, -0.265129, -0.265639, -0.267732, -0.270954, -0.274565,
      -0.277712,  -0.279625, -0.279808, -0.278163, -0.275024, -0.271098, -0.267299, -0.264546, -0.263535, -0.264569,
      -0.267475,  -0.27162,  -0.276053, -0.279719, -0.281706, -0.281469, -0.278978, -0.274741, -0.269708, -0.265058,
      -0.261931,  -0.261148, -0.263002, -0.267167, -0.272743, -0.278449, -0.282911, -0.284986, -0.28405,  -0.280173,
      -0.27414,   -0.267296, -0.261259, -0.257542, -0.257185, -0.260478, -0.266844, -0.274926, -0.282865, -0.288711,
      -0.29089,   -0.288608, -0.282094, -0.272627, -0.262299, -0.253582, -0.248759, -0.24936,  -0.255727, -0.266829,
      -0.280376,  -0.29325,  -0.30217,  -0.304461, -0.298765, -0.285517, -0.267063, -0.24735,  -0.231207, -0.223334,
      -0.227179,  -0.243929, -0.271829, -0.306013, -0.338914, -0.361247, -0.363412, -0.337098, -0.276808, -0.181024,
      -0.0527741, 0.100506},
     {0.277269,   0.415899,  0.546242,  0.661745,  0.757332,  0.829825,  0.878166,  0.903385,  0.908357,  0.897364,
      0.875541,   0.848258,  0.820535,  0.796542,  0.779235,  0.770184,  0.769567,  0.776344,  0.788553,  0.803703,
      0.819174,   0.832604,  0.842193,  0.846894,  0.846486,  0.841524,  0.833177,  0.823006,  0.812697,  0.803806,
      0.797548,   0.794645,  0.795265,  0.799045,  0.805187,  0.812606,  0.820113,  0.826593,  0.831161,  0.833274,
      0.832782,   0.829921,  0.825255,  0.819568,  0.813743,  0.808626,  0.804913,  0.803061,  0.803238,  0.805319,
      0.80892,    0.813465,  0.818277,  0.82267,   0.826049,  0.827978,  0.828238,  0.826843,  0.824026,  0.820209,
      0.815937,   0.811803,  0.808373,  0.806111,  0.805322,  0.806111,  0.808373,  0.811803,  0.815937,  0.820209,
      0.824026,   0.826843,  0.828238,  0.827978,  0.826049,  0.82267,   0.818277,  0.813465,  0.80892,   0.805319,
      0.803238,   0.803061,  0.804913,  0.808626,  0.813743,  0.819568,  0.825255,  0.829921,  0.832782,  0.833274,
      0.831161,   0.826593,  0.820113,  0.812606,  0.805187,  0.799045,  0.795265,  0.794645,  0.797548,  0.803806,
      0.812697,   0.823006,  0.833177,  0.841524,  0.846486,  0.846894,  0.842193,  0.832604,  0.819174,  0.803703,
      0.788553,   0.776344,  0.769567,  0.770184,  0.779235,  0.796542,  0.820535,  0.848258,  0.875541,  0.897364,
      0.908357,   0.903385,  0.878166,  0.829825,  0.757332,  0.661745,  0.546242,  0.415899,  0.277269,  0.137763,
      0.00494755, -0.114206, -0.213992, -0.290517, -0.342028, -0.369011, -0.374034, -0.361369, -0.336431, -0.305122,
      -0.273151,  -0.245415, -0.225517, -0.215475, -0.215645, -0.22486,  -0.240749, -0.260192, -0.279837, -0.296602,
      -0.308109,  -0.312971, -0.310928, -0.302801, -0.290295, -0.275676, -0.261396, -0.249698, -0.242289, -0.240107,
      -0.243214,  -0.250835, -0.261525, -0.273422, -0.284564, -0.2932,   -0.298056, -0.298516, -0.294691, -0.28737,
      -0.277871,  -0.267809, -0.258826, -0.252335, -0.249293, -0.250074, -0.254422, -0.261516, -0.27012,  -0.278792,
      -0.286125,  -0.290969, -0.292612, -0.290878, -0.286143, -0.279257, -0.271399, -0.263871, -0.257889, -0.254389,
      -0.253879,  -0.256371, -0.261389, -0.268055, -0.275246, -0.281777, -0.286596, -0.288954, -0.288516, -0.285412,
      -0.280203,  -0.273781, -0.267219, -0.261594, -0.257808, -0.256447, -0.257689, -0.261286, -0.266607, -0.272752,
      -0.2787,    -0.28348,  -0.286327, -0.286806, -0.284874, -0.280886, -0.275527, -0.269697, -0.264358, -0.260381,
      -0.258399,  -0.25871,  -0.261231, -0.265519, -0.270845, -0.276323, -0.281049, -0.284256, -0.285435, -0.284418,
      -0.281397,  -0.276893, -0.271664, -0.266578, -0.262471, -0.260008, -0.259575, -0.261224, -0.264662, -0.269302,
      -0.274371,  -0.279028, -0.28251,  -0.284256, -0.283993, -0.281783, -0.278009, -0.273306, -0.268457, -0.264264,
      -0.261411,  -0.260359, -0.261266, -0.263967, -0.268002, -0.272696, -0.277269, -0.280967, -0.283187, -0.283573,
      -0.282074,  -0.27895,  -0.274727, -0.270111, -0.265866, -0.26269,  -0.261101, -0.261353, -0.263392, -0.266871,
      -0.271209,  -0.275682, -0.279552, -0.282181, -0.283143, -0.282286, -0.279761, -0.275994, -0.271613, -0.267345,
      -0.263895,  -0.26183,  -0.261486, -0.262912, -0.265866, -0.269853, -0.27421,  -0.278215, -0.281205, -0.282692,
      -0.282432,  -0.280475, -0.27715,  -0.273012, -0.268747, -0.265061, -0.262564, -0.261665, -0.26251,  -0.264954,
      -0.268589,  -0.272811, -0.276919, -0.280235, -0.282209, -0.282517, -0.281111, -0.278227, -0.274344, -0.270106,
      -0.266217,  -0.263319, -0.261893, -0.262173, -0.264111, -0.267385, -0.271452, -0.275638, -0.279248, -0.281685,
      -0.282545,  -0.281685, -0.279248, -0.275638, -0.271452, -0.267385, -0.264111, -0.262173, -0.261893, -0.263319,
      -0.266217,  -0.270106, -0.274344, -0.278227, -0.281111, -0.282517, -0.282209, -0.280235, -0.276919, -0.272811,
      -0.268589,  -0.264954, -0.26251,  -0.261665, -0.262564, -0.265061, -0.268747, -0.273012, -0.27715,  -0.280475,
      -0.282432,  -0.282692, -0.281205, -0.278215, -0.27421,  -0.269853, -0.265866, -0.262912, -0.261486, -0.26183,
      -0.263895,  -0.267345, -0.271613, -0.275994, -0.279761, -0.282286, -0.283143, -0.282181, -0.279552, -0.275682,
      -0.271209,  -0.266872, -0.263392, -0.261353, -0.261101, -0.26269,  -0.265866, -0.270111, -0.274727, -0.27895,
      -0.282074,  -0.283573, -0.283187, -0.280967, -0.277269, -0.272696, -0.268002, -0.263967, -0.261266, -0.260359,
      -0.261411,  -0.264264, -0.268457, -0.273306, -0.278009, -0.281783, -0.283993, -0.284256, -0.28251,  -0.279028,
      -0.274371,  -0.269302, -0.264662, -0.261224, -0.259575, -0.260008, -0.262471, -0.266578, -0.271664, -0.276893,
      -0.281397,  -0.284418, -0.285435, -0.284256, -0.281049, -0.276323, -0.270845, -0.265519, -0.261231, -0.25871,
      -0.258399,  -0.260381, -0.264358, -0.269697, -0.275527, -0.280886, -0.284874, -0.286806, -0.286327, -0.28348,
      -0.2787,    -0.272752, -0.266607, -0.261286, -0.257689, -0.256447, -0.257808, -0.261594, -0.267219, -0.273781,
      -0.280203,  -0.285412, -0.288516, -0.288954, -0.286596, -0.281776, -0.275246, -0.268055, -0.261389, -0.256371,
      -0.253879,  -0.254389, -0.257889, -0.263871, -0.271399, -0.279257, -0.286143, -0.290878, -0.292612, -0.290969,
      -0.286125,  -0.278792, -0.27012,  -0.261516, -0.254422, -0.250074, -0.249293, -0.252335, -0.258826, -0.267809,
      -0.277871,  -0.28737,  -0.294691, -0.298516, -0.298056, -0.2932,   -0.284564, -0.273422, -0.261525, -0.250835,
      -0.243214,  -0.240107, -0.242289, -0.249698, -0.261396, -0.275676, -0.290295, -0.302801, -0.310928, -0.312971,
      -0.308109,  -0.296602, -0.279837, -0.260192, -0.240749, -0.22486,  -0.215645, -0.215475, -0.225517, -0.245415,
      -0.273151,  -0.305122, -0.336431, -0.361369, -0.374034, -0.369011, -0.342028, -0.290517, -0.213992, -0.114206,
      0.00494759, 0.137763},
     {0.265996,  0.384659,   0.499414,  0.605867,  0.700176,  0.779305,  0.841233,  0.885068,  0.911076,  0.920615,
      0.91599,   0.900229,   0.87682,   0.849404,  0.821488,  0.796167,  0.775908,  0.762389,  0.756421,  0.757954,
      0.766157,  0.779562,   0.796267,  0.814159,  0.83115,   0.845387,  0.855441,  0.860424,  0.860058,  0.854669,
      0.845124,  0.832704,   0.818953,  0.805495,  0.793849,  0.785273,  0.780632,  0.780315,  0.784213,  0.791744,
      0.801935,  0.813539,   0.825186,  0.835536,  0.843432,  0.848022,  0.848849,  0.845895,  0.839574,  0.830674,
      0.820266,  0.809577,   0.799846,  0.792185,  0.787456,  0.786174,  0.788454,  0.793999,  0.802141,  0.811918,
      0.822186,  0.831748,   0.839497,  0.844536,  0.846283,  0.844536,  0.839497,  0.831748,  0.822186,  0.811918,
      0.802141,  0.793999,   0.788454,  0.786174,  0.787456,  0.792185,  0.799846,  0.809577,  0.820266,  0.830674,
      0.839574,  0.845895,   0.848849,  0.848022,  0.843432,  0.835536,  0.825186,  0.813539,  0.801935,  0.791744,
      0.784213,  0.780315,   0.780632,  0.785274,  0.793849,  0.805495,  0.818953,  0.832704,  0.845124,  0.854669,
      0.860058,  0.860424,   0.855441,  0.845387,  0.83115,   0.814159,  0.796267,  0.779562,  0.766157,  0.757954,
      0.756421,  0.762389,   0.775908,  0.796167,  0.821488,  0.849404,  0.87682,   0.900229,  0.91599,   0.920615,
      0.911076,  0.885068,   0.841233,  0.779305,  0.700176,  0.605867,  0.499414,  0.384659,  0.265996,  0.148057,
      0.0353884, -0.0678593, -0.158215, -0.233107, -0.291008, -0.331497, -0.355231, -0.363838, -0.359734, -0.345893,
      -0.325579, -0.302078,  -0.278441, -0.257265, -0.240529, -0.229496, -0.224683, -0.225897, -0.232334, -0.242726,
      -0.255515, -0.269042,  -0.281726, -0.29222,  -0.299538, -0.30312,  -0.302865, -0.299098, -0.292509, -0.284045,
      -0.274797, -0.265863,  -0.258233, -0.252689, -0.249727, -0.249525, -0.25194,  -0.256547, -0.262696, -0.269602,
      -0.276439, -0.28243,   -0.286937, -0.289521, -0.289982, -0.288371, -0.284968, -0.280248, -0.274808, -0.269304,
      -0.264367, -0.260538,  -0.25821,  -0.257587, -0.258672, -0.261272, -0.26503,  -0.269471, -0.27406,  -0.278265,
      -0.281616, -0.28376,   -0.284492, -0.283776, -0.281745, -0.278675, -0.274953, -0.271029, -0.26736,  -0.264361,
      -0.262356, -0.261546,  -0.261989, -0.263598, -0.266153, -0.269334, -0.272756, -0.276019, -0.27875,  -0.280648,
      -0.281516, -0.281281,  -0.279998, -0.277841, -0.275079, -0.272048, -0.269103, -0.266583, -0.264768, -0.263853,
      -0.263923, -0.264948,  -0.266789, -0.269216, -0.271935, -0.274627, -0.27698,  -0.278729, -0.279683, -0.279748,
      -0.278934, -0.27735,   -0.275195, -0.272729, -0.270243, -0.268026, -0.266328, -0.265339, -0.26516,  -0.2658,
      -0.267169, -0.269099,  -0.271356, -0.273673, -0.275781, -0.277438, -0.27846,  -0.278737, -0.278246, -0.277058,
      -0.275318, -0.273236,  -0.271059, -0.26904,  -0.267413, -0.26636,  -0.265996, -0.266357, -0.26739,  -0.268968,
      -0.270901, -0.272961,  -0.274907, -0.276514, -0.277599, -0.278041, -0.277795, -0.276898, -0.27546,  -0.273653,
      -0.271691, -0.269804,  -0.26821,  -0.267092, -0.266577, -0.266718, -0.267494, -0.26881,  -0.270508, -0.272388,
      -0.274229, -0.275817,  -0.27697,  -0.277555, -0.27751,  -0.276843, -0.275635, -0.274032, -0.272222, -0.270416,
      -0.268827, -0.267636,  -0.266982, -0.266938, -0.267505, -0.268615, -0.270136, -0.271888, -0.273667, -0.275266,
      -0.276497, -0.27722,   -0.277351, -0.276877, -0.275855, -0.274407, -0.272702, -0.27094,  -0.269326, -0.268049,
      -0.267257, -0.267041,  -0.267427, -0.268367, -0.269751, -0.271418, -0.273172, -0.274808, -0.276136, -0.277,
      -0.2773,   -0.277,     -0.276136, -0.274808, -0.273172, -0.271418, -0.269751, -0.268367, -0.267427, -0.267041,
      -0.267257, -0.268049,  -0.269326, -0.27094,  -0.272702, -0.274407, -0.275855, -0.276877, -0.277351, -0.27722,
      -0.276497, -0.275266,  -0.273667, -0.271888, -0.270136, -0.268615, -0.267505, -0.266938, -0.266982, -0.267636,
      -0.268827, -0.270416,  -0.272222, -0.274032, -0.275635, -0.276843, -0.27751,  -0.277555, -0.27697,  -0.275817,
      -0.274229, -0.272388,  -0.270508, -0.26881,  -0.267495, -0.266718, -0.266577, -0.267092, -0.26821,  -0.269804,
      -0.271691, -0.273653,  -0.27546,  -0.276898, -0.277795, -0.278041, -0.277599, -0.276514, -0.274907, -0.272961,
      -0.270901, -0.268968,  -0.26739,  -0.266357, -0.265996, -0.266359, -0.267413, -0.26904,  -0.271059, -0.273236,
      -0.275318, -0.277058,  -0.278246, -0.278737, -0.27846,  -0.277438, -0.275781, -0.273673, -0.271356, -0.269099,
      -0.267169, -0.2658,    -0.26516,  -0.265339, -0.266328, -0.268026, -0.270243, -0.272729, -0.275195, -0.27735,
      -0.278934, -0.279748,  -0.279683, -0.278729, -0.27698,  -0.274627, -0.271935, -0.269216, -0.266789, -0.264948,
      -0.263923, -0.263853,  -0.264768, -0.266583, -0.269103, -0.272048, -0.275079, -0.277841, -0.279998, -0.281281,
      -0.281516, -0.280648,  -0.27875,  -0.276019, -0.272756, -0.269334, -0.266154, -0.263598, -0.261989, -0.261546,
      -0.262356, -0.264361,  -0.26736,  -0.271029, -0.274953, -0.278675, -0.281745, -0.283776, -0.284492, -0.28376,
      -0.281616, -0.278265,  -0.27406,  -0.269471, -0.26503,  -0.261272, -0.258672, -0.257587, -0.25821,  -0.260538,
      -0.264367, -0.269304,  -0.274808, -0.280248, -0.284968, -0.288371, -0.289982, -0.289521, -0.286937, -0.28243,
      -0.276439, -0.269602,  -0.262696, -0.256547, -0.25194,  -0.249525, -0.249727, -0.252689, -0.258233, -0.265863,
      -0.274797, -0.284045,  -0.292509, -0.299098, -0.302865, -0.30312,  -0.299538, -0.29222,  -0.281726, -0.269042,
      -0.255515, -0.242726,  -0.232334, -0.225897, -0.224683, -0.229496, -0.240529, -0.257265, -0.278441, -0.302078,
      -0.325579, -0.345893,  -0.359734, -0.363838, -0.355231, -0.331497, -0.291008, -0.233107, -0.158215, -0.0678593,
      0.0353885, 0.148057},
     {0.26497,   0.366858,   0.466441,  0.560888,  0.647613,  0.724404,  0.789536,  0.841854,  0.880817,  0.906518,
      0.91965,   0.921457,   0.913638,  0.898232,  0.877492,  0.85374,   0.82923,   0.80602,   0.785857,  0.770094,
      0.759627,  0.754872,   0.755774,  0.761841,  0.772214,  0.785751,  0.801136,  0.816983,  0.83195,   0.844839,
      0.854682,  0.860802,   0.862861,  0.860861,  0.855139,  0.84632,   0.835262,  0.822972,  0.810527,  0.798978,
      0.789272,  0.782174,   0.778212,  0.77764,   0.780421,  0.786245,  0.794551,  0.804585,  0.815463,  0.826247,
      0.836023,  0.843976,   0.849457,  0.852032,  0.851516,  0.847989,  0.841781,  0.833444,  0.823706,  0.813408,
      0.803433,  0.79463,    0.787749,  0.783372,  0.781871,  0.783372,  0.787749,  0.79463,   0.803433,  0.813408,
      0.823706,  0.833444,   0.841781,  0.847989,  0.851516,  0.852032,  0.849457,  0.843976,  0.836023,  0.826247,
      0.815463,  0.804585,   0.794551,  0.786245,  0.780421,  0.77764,   0.778212,  0.782174,  0.789272,  0.798978,
      0.810527,  0.822972,   0.835262,  0.84632,   0.855139,  0.860861,  0.862861,  0.860802,  0.854682,  0.844839,
      0.83195,   0.816983,   0.801136,  0.785751,  0.772214,  0.761841,  0.755774,  0.754872,  0.759627,  0.770094,
      0.785858,  0.80602,    0.82923,   0.85374,   0.877492,  0.898232,  0.913638,  0.921457,  0.91965,   0.906518,
      0.880817,  0.841854,   0.789536,  0.724404,  0.647613,  0.560888,  0.466441,  0.366858,  0.26497,   0.163703,
      0.0659317, -0.0256684, -0.108755, -0.181429, -0.24232,  -0.290635, -0.326181, -0.349343, -0.361039, -0.362636,
      -0.355857, -0.342656,  -0.325099, -0.305239, -0.284998, -0.266067, -0.249825, -0.237283, -0.229058, -0.225366,
      -0.226052, -0.230635,  -0.238375, -0.248349, -0.25954,  -0.270921, -0.281532, -0.290552, -0.297352, -0.301527,
      -0.302914, -0.30159,   -0.297844, -0.292148, -0.285099, -0.27737,  -0.269648, -0.262579, -0.25672,  -0.252493,
      -0.250165, -0.249831,  -0.251417, -0.25469,  -0.259294, -0.264775, -0.270633, -0.276355, -0.281466, -0.285563,
      -0.288344, -0.289632,  -0.289381, -0.287675, -0.284716, -0.280806, -0.27631,  -0.271631, -0.267172, -0.263302,
      -0.260325, -0.258463,  -0.257834, -0.258449, -0.260213, -0.262939, -0.266365, -0.270178, -0.274042, -0.277628,
      -0.280641, -0.282842,  -0.284069, -0.284246, -0.283389, -0.281598, -0.279053, -0.27599,  -0.272683, -0.269419,
      -0.266475, -0.264093,  -0.262461, -0.261698, -0.261849, -0.262878, -0.264678, -0.267076, -0.269856, -0.272771,
      -0.275571, -0.278019,  -0.279916, -0.281111, -0.281517, -0.281116, -0.279959, -0.27816,  -0.275884, -0.273335,
      -0.270736, -0.268308,  -0.266256, -0.264748, -0.263902, -0.26378,  -0.264378, -0.265634, -0.267428, -0.2696,
      -0.271957, -0.274295,  -0.276414, -0.278138, -0.279326, -0.279883, -0.279772, -0.279012, -0.277676, -0.275889,
      -0.273808, -0.271615,  -0.2695,   -0.267642, -0.266196, -0.265282, -0.26497,  -0.265279, -0.266176, -0.267578,
      -0.269358, -0.271359,  -0.273408, -0.27533,  -0.27696,  -0.278163, -0.27884,  -0.278938, -0.278455, -0.277438,
      -0.275979, -0.274206,  -0.272276, -0.270354, -0.268605, -0.267177, -0.26619,  -0.265726, -0.265819, -0.266458,
      -0.267583, -0.269095,  -0.270861, -0.272728, -0.274535, -0.276127, -0.27737,  -0.27816,  -0.27843,  -0.278161,
      -0.277379, -0.276153,  -0.274593, -0.272832, -0.271023, -0.269322, -0.267874, -0.266803, -0.266198, -0.26611,
      -0.266544, -0.267462,  -0.268782, -0.270391, -0.272148, -0.273903, -0.275504, -0.276815, -0.277724, -0.278153,
      -0.278066, -0.277473,  -0.276424, -0.275011, -0.273355, -0.271599, -0.269895, -0.268389, -0.26721,  -0.266459,
      -0.266202, -0.26646,   -0.26721,  -0.268389, -0.269895, -0.271599, -0.273355, -0.275011, -0.276424, -0.277473,
      -0.278066, -0.278153,  -0.277724, -0.276815, -0.275504, -0.273903, -0.272148, -0.270391, -0.268782, -0.267462,
      -0.266544, -0.26611,   -0.266198, -0.266803, -0.267874, -0.269322, -0.271023, -0.272832, -0.274593, -0.276153,
      -0.277379, -0.278161,  -0.27843,  -0.27816,  -0.277371, -0.276127, -0.274535, -0.272728, -0.270861, -0.269095,
      -0.267583, -0.266458,  -0.265819, -0.265726, -0.26619,  -0.267177, -0.268605, -0.270354, -0.272276, -0.274206,
      -0.275979, -0.277438,  -0.278455, -0.278938, -0.27884,  -0.278163, -0.27696,  -0.27533,  -0.273408, -0.271359,
      -0.269358, -0.267578,  -0.266176, -0.265279, -0.26497,  -0.265282, -0.266196, -0.267642, -0.2695,   -0.271616,
      -0.273808, -0.275889,  -0.277676, -0.279012, -0.279772, -0.279883, -0.279326, -0.278138, -0.276414, -0.274295,
      -0.271957, -0.2696,    -0.267428, -0.265634, -0.264378, -0.26378,  -0.263902, -0.264748, -0.266256, -0.268308,
      -0.270736, -0.273335,  -0.275884, -0.27816,  -0.279959, -0.281116, -0.281517, -0.281111, -0.279916, -0.278019,
      -0.275571, -0.272771,  -0.269856, -0.267076, -0.264678, -0.262879, -0.261849, -0.261698, -0.26246,  -0.264093,
      -0.266475, -0.269419,  -0.272683, -0.27599,  -0.279053, -0.281598, -0.283389, -0.284246, -0.284069, -0.282842,
      -0.280641, -0.277628,  -0.274042, -0.270178, -0.266365, -0.262939, -0.260213, -0.258449, -0.257834, -0.258463,
      -0.260325, -0.263302,  -0.267172, -0.271631, -0.27631,  -0.280806, -0.284716, -0.287675, -0.289381, -0.289632,
      -0.288344, -0.285563,  -0.281466, -0.276355, -0.270633, -0.264775, -0.259294, -0.25469,  -0.251417, -0.249832,
      -0.250165, -0.252493,  -0.25672,  -0.262579, -0.269648, -0.277369, -0.285099, -0.292148, -0.297844, -0.30159,
      -0.302914, -0.301527,  -0.297352, -0.290552, -0.281532, -0.270921, -0.25954,  -0.248349, -0.238375, -0.230635,
      -0.226052, -0.225366,  -0.229058, -0.237283, -0.249825, -0.266067, -0.284998, -0.305239, -0.325099, -0.342656,
      -0.355857, -0.362636,  -0.361039, -0.349343, -0.326181, -0.290635, -0.24232,  -0.181429, -0.108755, -0.0256684,
      0.0659318, 0.163703},
     {0.263535,  0.348567,  0.432421,   0.513429,  0.590012,  0.660737,  0.724369,  0.779912,  0.826642,   0.864133,
      0.892261,  0.911208,  0.921444,   0.923702,  0.918942,  0.908305,  0.893064,  0.874565,  0.854172,   0.833213,
      0.81292,   0.794388,  0.778532,   0.76606,   0.757448,  0.752934,  0.752522,  0.755993,  0.762929,   0.772746,
      0.784729,  0.798081,  0.811967,   0.825556,  0.838071,  0.848827,  0.857264,  0.862971,  0.865708,   0.865411,
      0.862188,  0.856315,  0.848206,   0.838395,  0.8275,    0.816186,  0.805126,  0.794965,  0.786285,   0.779568,
      0.77518,   0.773342,  0.774125,   0.777449,  0.783087,  0.79068,   0.799759,  0.809774,  0.820125,   0.830196,
      0.839392,  0.847172,  0.853079,   0.856767,  0.858021,  0.856767,  0.853079,  0.847172,  0.839392,   0.830196,
      0.820125,  0.809774,  0.799759,   0.79068,   0.783087,  0.777449,  0.774125,  0.773342,  0.77518,    0.779568,
      0.786285,  0.794965,  0.805126,   0.816186,  0.8275,    0.838395,  0.848206,  0.856315,  0.862188,   0.865411,
      0.865708,  0.862971,  0.857264,   0.848827,  0.838071,  0.825556,  0.811967,  0.798081,  0.784729,   0.772746,
      0.762929,  0.755993,  0.752522,   0.752934,  0.757448,  0.76606,   0.778532,  0.794388,  0.81292,    0.833213,
      0.854172,  0.874565,  0.893064,   0.908305,  0.918942,  0.923702,  0.921444,  0.911208,  0.892261,   0.864133,
      0.826642,  0.779912,  0.724369,   0.660737,  0.590012,  0.513429,  0.432421,  0.348567,  0.263535,   0.179021,
      0.0966942, 0.0181301, -0.0552377, -0.122168, -0.181652, -0.23294,  -0.275565, -0.309344, -0.334379,  -0.351037,
      -0.35993,  -0.361872, -0.357848,  -0.348958, -0.336374, -0.321289, -0.304866, -0.288196, -0.272258,  -0.257885,
      -0.245742, -0.23631,  -0.229878,  -0.226548, -0.226246, -0.228736, -0.23365,  -0.240517, -0.248791,  -0.257891,
      -0.26723,  -0.276251, -0.284449,  -0.291401, -0.296781, -0.300373, -0.302073, -0.301894, -0.299951,  -0.296456,
      -0.291698, -0.286022, -0.279806,  -0.273442, -0.26731,  -0.261757, -0.257082, -0.253518, -0.251222,  -0.250274,
      -0.250669, -0.252328, -0.2551,    -0.258776, -0.263103, -0.267802, -0.272581, -0.277157, -0.281268,  -0.284689,
      -0.287244, -0.288813, -0.289338,  -0.288825, -0.287338, -0.284998, -0.281971, -0.278457, -0.274678,  -0.270867,
      -0.267248, -0.26403,  -0.261391,  -0.25947,  -0.258359, -0.258101, -0.258688, -0.260062, -0.262121,  -0.264724,
      -0.267704, -0.270874, -0.274043,  -0.277022, -0.279641, -0.281753, -0.283245, -0.284043, -0.284116,  -0.283477,
      -0.282178, -0.280312, -0.278002,  -0.275393, -0.272647, -0.269929, -0.2674,   -0.265206, -0.263471,  -0.262287,
      -0.261716, -0.261779, -0.26246,   -0.263709, -0.26544,  -0.267542, -0.269884, -0.272323, -0.274713,  -0.276912,
      -0.278792, -0.280248, -0.2812,    -0.281599, -0.281429, -0.28071,  -0.279492, -0.277855, -0.275903,  -0.273756,
      -0.271544, -0.269399, -0.267449,  -0.265807, -0.264566, -0.263795, -0.263535, -0.263793, -0.264549,  -0.265752,
      -0.267325, -0.26917,  -0.271174,  -0.273216, -0.275175, -0.276934, -0.27839,  -0.279461, -0.280085,  -0.280231,
      -0.279894, -0.279099, -0.277897,  -0.276364, -0.274593, -0.272693, -0.270777, -0.268961, -0.267351,  -0.266042,
      -0.265109, -0.264607, -0.264561,  -0.26497,  -0.265809, -0.267023, -0.268538, -0.270261, -0.272089,  -0.273912,
      -0.275621, -0.277114, -0.278304,  -0.279121, -0.279518, -0.279474, -0.278993, -0.278105, -0.276866,  -0.275351,
      -0.273651, -0.271869, -0.270112,  -0.268483, -0.267081, -0.265989, -0.26527,  -0.264967, -0.265097,  -0.265652,
      -0.266596, -0.267874, -0.269408,  -0.271105, -0.272865, -0.274582, -0.276153, -0.277484, -0.278496,  -0.279129,
      -0.279344, -0.279129, -0.278496,  -0.277484, -0.276153, -0.274582, -0.272865, -0.271105, -0.269408,  -0.267874,
      -0.266596, -0.265651, -0.265097,  -0.264967, -0.26527,  -0.265989, -0.267081, -0.268483, -0.270112,  -0.271869,
      -0.273651, -0.275351, -0.276866,  -0.278105, -0.278993, -0.279474, -0.279518, -0.279121, -0.278304,  -0.277114,
      -0.275621, -0.273912, -0.272089,  -0.270261, -0.268538, -0.267023, -0.265809, -0.26497,  -0.264561,  -0.264607,
      -0.265109, -0.266042, -0.267351,  -0.268961, -0.270777, -0.272693, -0.274593, -0.276364, -0.277897,  -0.279099,
      -0.279894, -0.280231, -0.280085,  -0.279461, -0.27839,  -0.276934, -0.275175, -0.273216, -0.271174,  -0.26917,
      -0.267325, -0.265752, -0.264549,  -0.263793, -0.263535, -0.263795, -0.264566, -0.265807, -0.267449,  -0.269399,
      -0.271544, -0.273756, -0.275903,  -0.277855, -0.279492, -0.28071,  -0.281429, -0.281599, -0.2812,    -0.280248,
      -0.278792, -0.276912, -0.274713,  -0.272323, -0.269884, -0.267542, -0.26544,  -0.263709, -0.26246,   -0.261779,
      -0.261716, -0.262287, -0.263471,  -0.265206, -0.2674,   -0.269929, -0.272647, -0.275393, -0.278002,  -0.280312,
      -0.282178, -0.283477, -0.284116,  -0.284043, -0.283245, -0.281753, -0.279641, -0.277022, -0.274043,  -0.270874,
      -0.267704, -0.264724, -0.262121,  -0.260062, -0.258688, -0.258101, -0.258359, -0.25947,  -0.261391,  -0.26403,
      -0.267248, -0.270867, -0.274678,  -0.278457, -0.281971, -0.284998, -0.287338, -0.288825, -0.289338,  -0.288813,
      -0.287244, -0.284689, -0.281268,  -0.277157, -0.272581, -0.267802, -0.263103, -0.258776, -0.2551,    -0.252328,
      -0.250669, -0.250274, -0.251222,  -0.253517, -0.257082, -0.261757, -0.26731,  -0.273442, -0.279806,  -0.286022,
      -0.291698, -0.296456, -0.299951,  -0.301894, -0.302073, -0.300373, -0.296781, -0.291401, -0.284449,  -0.276251,
      -0.26723,  -0.257891, -0.248791,  -0.240517, -0.23365,  -0.228736, -0.226246, -0.226549, -0.229878,  -0.23631,
      -0.245742, -0.257885, -0.272258,  -0.288196, -0.304866, -0.321289, -0.336374, -0.348958, -0.357848,  -0.361872,
      -0.35993,  -0.351037, -0.334379,  -0.309344, -0.275565, -0.23294,  -0.181652, -0.122168, -0.0552376, 0.0181301,
      0.0966942, 0.179021},
     {0.261389,  0.329497,  0.397152,   0.46349,    0.527668,  0.588889,  0.646415,  0.699587,   0.74784,    0.790712,
      0.827858,  0.859055,  0.884205,   0.903338,   0.916607,  0.92428,   0.926737,  0.924453,   0.917987,   0.907962,
      0.895054,  0.879966,  0.863414,   0.846105,   0.828723,  0.811906,  0.796231,  0.782206,   0.770252,   0.760699,
      0.753776,  0.749612,  0.748234,   0.749572,   0.753465,  0.759667,  0.767862,  0.777674,   0.788683,   0.800442,
      0.812488,  0.824365,  0.835632,   0.845885,   0.854765,  0.86197,   0.867268,  0.870499,   0.87158,    0.870511,
      0.867367,  0.862299,  0.855525,   0.847324,   0.838021,  0.827979,  0.817584,  0.807233,   0.797316,   0.788204,
      0.780239,  0.773715,  0.768875,   0.765897,   0.764893,  0.765897,  0.768875,  0.773715,   0.780239,   0.788204,
      0.797316,  0.807233,  0.817584,   0.827979,   0.838021,  0.847324,  0.855525,  0.862299,   0.867367,   0.870511,
      0.87158,   0.870499,  0.867268,   0.86197,    0.854765,  0.845885,  0.835632,  0.824365,   0.812488,   0.800442,
      0.788683,  0.777674,  0.767862,   0.759667,   0.753465,  0.749572,  0.748234,  0.749612,   0.753776,   0.760699,
      0.770252,  0.782206,  0.796231,   0.811906,   0.828723,  0.846105,  0.863414,  0.879966,   0.895054,   0.907962,
      0.917987,  0.924453,  0.926737,   0.92428,    0.916607,  0.903338,  0.884205,  0.859055,   0.827858,   0.790712,
      0.74784,   0.699587,  0.646415,   0.588889,   0.527668,  0.46349,   0.397152,  0.329497,   0.261389,   0.193697,
      0.127274,  0.0629391, 0.00145674, -0.0564769, -0.11025,  -0.159346, -0.203355, -0.241978,  -0.275033,  -0.302454,
      -0.32429,  -0.340698, -0.351937,  -0.358358,  -0.360391, -0.358533, -0.353328, -0.345358,  -0.335222,  -0.323523,
      -0.31085,  -0.297765, -0.28479,   -0.272396,  -0.260992, -0.250919, -0.242443, -0.235757,  -0.230974,  -0.228133,
      -0.227205, -0.228091, -0.230639,  -0.234645,  -0.239868, -0.246039, -0.252869, -0.260064,  -0.267335,  -0.274404,
      -0.281018, -0.286952, -0.292019,  -0.296073,  -0.299012, -0.300779, -0.301362, -0.300797,  -0.299154,  -0.296546,
      -0.293111, -0.289015, -0.28444,   -0.279577,  -0.274622, -0.269765, -0.265185, -0.261045,  -0.257484,  -0.254615,
      -0.252521, -0.251255, -0.250833,  -0.251245,  -0.252445, -0.254362, -0.256901, -0.259945,  -0.263363,  -0.267014,
      -0.270754, -0.274437, -0.277926,  -0.281096,  -0.283834, -0.286049, -0.287673, -0.28866,   -0.288989,  -0.288665,
      -0.287719, -0.286201, -0.284185,  -0.281757,  -0.279022, -0.27609,  -0.273076, -0.270098,  -0.267267,  -0.264688,
      -0.262452, -0.260637, -0.259303,  -0.25849,   -0.258218, -0.258486, -0.259273, -0.260539,  -0.262226,  -0.264261,
      -0.266561, -0.269033, -0.27158,   -0.274104,  -0.276509, -0.278706, -0.280614, -0.282168,  -0.283312,  -0.284011,
      -0.284246, -0.284014, -0.283332,  -0.282233,  -0.280766, -0.278992, -0.276982, -0.274817,  -0.272582,  -0.270363,
      -0.268243, -0.266303, -0.264614,  -0.263237,  -0.26222,  -0.261598, -0.261389, -0.261596,  -0.262206,  -0.263192,
      -0.264511, -0.266109, -0.267922,  -0.269879,  -0.271903, -0.273916, -0.275842, -0.277608,  -0.279149,  -0.280407,
      -0.281338, -0.281908, -0.2821,    -0.281909,  -0.281347, -0.280437, -0.279217, -0.277737,  -0.276055,  -0.274237,
      -0.272353, -0.270476, -0.268678,  -0.267026,  -0.265583, -0.264403, -0.263529, -0.262992,  -0.262811,  -0.262991,
      -0.263523, -0.264385, -0.265542,  -0.266948,  -0.268548, -0.27028,  -0.272077, -0.273871,  -0.275592,  -0.277175,
      -0.278561, -0.279695, -0.280537,  -0.281055,  -0.281229, -0.281055, -0.28054,  -0.279704,  -0.278581,  -0.277213,
      -0.275655, -0.273965, -0.272209,  -0.270454,  -0.268768, -0.267215, -0.265854, -0.264738,  -0.263909,  -0.263398,
      -0.263226, -0.263398, -0.263909,  -0.264738,  -0.265854, -0.267215, -0.268768, -0.270454,  -0.272209,  -0.273965,
      -0.275655, -0.277213, -0.278581,  -0.279704,  -0.28054,  -0.281055, -0.281229, -0.281055,  -0.280537,  -0.279695,
      -0.278561, -0.277175, -0.275592,  -0.273871,  -0.272077, -0.27028,  -0.268548, -0.266948,  -0.265542,  -0.264385,
      -0.263523, -0.262991, -0.262811,  -0.262992,  -0.263529, -0.264403, -0.265583, -0.267026,  -0.268678,  -0.270476,
      -0.272353, -0.274237, -0.276055,  -0.277737,  -0.279217, -0.280437, -0.281347, -0.281909,  -0.2821,    -0.281908,
      -0.281338, -0.280407, -0.279149,  -0.277608,  -0.275842, -0.273916, -0.271903, -0.269879,  -0.267922,  -0.266109,
      -0.264511, -0.263192, -0.262206,  -0.261596,  -0.261389, -0.261598, -0.26222,  -0.263237,  -0.264614,  -0.266303,
      -0.268243, -0.270363, -0.272582,  -0.274817,  -0.276982, -0.278992, -0.280766, -0.282233,  -0.283332,  -0.284014,
      -0.284246, -0.284011, -0.283312,  -0.282168,  -0.280614, -0.278706, -0.276509, -0.274104,  -0.27158,   -0.269033,
      -0.266561, -0.264261, -0.262226,  -0.260539,  -0.259273, -0.258486, -0.258218, -0.25849,   -0.259303,  -0.260637,
      -0.262452, -0.264688, -0.267267,  -0.270098,  -0.273076, -0.27609,  -0.279022, -0.281757,  -0.284184,  -0.286201,
      -0.287719, -0.288665, -0.288989,  -0.28866,   -0.287673, -0.286049, -0.283834, -0.281096,  -0.277926,  -0.274437,
      -0.270754, -0.267014, -0.263363,  -0.259945,  -0.256901, -0.254362, -0.252445, -0.251245,  -0.250833,  -0.251255,
      -0.252521, -0.254615, -0.257484,  -0.261045,  -0.265185, -0.269765, -0.274622, -0.279577,  -0.28444,   -0.289015,
      -0.293111, -0.296546, -0.299154,  -0.300797,  -0.301362, -0.300779, -0.299012, -0.296073,  -0.292019,  -0.286952,
      -0.281018, -0.274404, -0.267335,  -0.260064,  -0.252869, -0.246039, -0.239868, -0.234645,  -0.230639,  -0.228091,
      -0.227205, -0.228133, -0.230974,  -0.235757,  -0.242443, -0.250919, -0.260992, -0.272396,  -0.28479,   -0.297765,
      -0.31085,  -0.323523, -0.335222,  -0.345358,  -0.353328, -0.358533, -0.360391, -0.358358,  -0.351937,  -0.340698,
      -0.32429,  -0.302454, -0.275033,  -0.241978,  -0.203355, -0.159346, -0.11025,  -0.0564769, 0.00145677, 0.0629391,
      0.127274,  0.193697},
     {0.257834,  0.308963,  0.36004,   0.410698,  0.460574,   0.509309,   0.556559,  0.601995,  0.64531,   0.686218,
      0.724464,  0.759824,  0.792107,  0.82116,   0.846866,   0.869152,   0.88798,   0.903357,  0.915326,  0.923973,
      0.929419,  0.931821,  0.931369,  0.928282,  0.922806,   0.915209,   0.905777,  0.894811,  0.882619,  0.869516,
      0.855816,  0.841828,  0.827853,  0.814176,  0.801068,   0.788776,   0.777524,  0.767506,  0.758889,  0.751806,
      0.746358,  0.74261,   0.740594,  0.740307,  0.741712,   0.744741,   0.749296,  0.75525,   0.762452,  0.770728,
      0.779888,  0.789726,  0.800025,  0.810563,  0.821117,   0.831464,   0.841388,  0.850686,  0.859165,  0.866653,
      0.872997,  0.878069,  0.881767,  0.884016,  0.884771,   0.884016,   0.881767,  0.878069,  0.872997,  0.866653,
      0.859165,  0.850686,  0.841388,  0.831464,  0.821117,   0.810563,   0.800025,  0.789726,  0.779888,  0.770728,
      0.762452,  0.75525,   0.749296,  0.744741,  0.741712,   0.740307,   0.740594,  0.74261,   0.746358,  0.751806,
      0.758889,  0.767506,  0.777524,  0.788776,  0.801068,   0.814176,   0.827853,  0.841828,  0.855816,  0.869516,
      0.882619,  0.894811,  0.905777,  0.915209,  0.922806,   0.928282,   0.931369,  0.931821,  0.929419,  0.923973,
      0.915326,  0.903357,  0.88798,   0.869152,  0.846866,   0.82116,    0.792107,  0.759824,  0.724464,  0.686218,
      0.64531,   0.601995,  0.556559,  0.509309,  0.460574,   0.410698,   0.36004,   0.308963,  0.257834,  0.207018,
      0.156872,  0.107744,  0.059965,  0.0138479, -0.0303181, -0.0722694, -0.111772, -0.148624, -0.182655, -0.213732,
      -0.241755, -0.266664, -0.288433, -0.307071, -0.322623,  -0.335167,  -0.34481,  -0.35169,  -0.355969, -0.357834,
      -0.35749,  -0.355159, -0.351073, -0.345476, -0.338616,  -0.330742,  -0.3221,   -0.312932, -0.303472, -0.293938,
      -0.284537, -0.275459, -0.266874, -0.25893,  -0.251755,  -0.245453,  -0.240106, -0.23577,  -0.232481, -0.230249,
      -0.229064, -0.228897, -0.229697, -0.2314,   -0.233924,  -0.237177,  -0.241054, -0.245445, -0.250232, -0.255298,
      -0.260521, -0.265786, -0.270977, -0.275988, -0.280719,  -0.285082,  -0.288998, -0.292401, -0.295237, -0.297468,
      -0.299067, -0.300024, -0.30034,  -0.300031, -0.299124,  -0.29766,   -0.295686, -0.293262, -0.290453, -0.287331,
      -0.283973, -0.280456, -0.276861, -0.273267, -0.269749,  -0.266382,  -0.263232, -0.26036,  -0.257821, -0.25566,
      -0.253913, -0.252606, -0.251757, -0.251372, -0.251447,  -0.251971,  -0.252921, -0.254268, -0.255972, -0.257989,
      -0.260271, -0.262761, -0.265402, -0.268135, -0.270898,  -0.273634,  -0.276282, -0.27879,  -0.281105, -0.283183,
      -0.284983, -0.286472, -0.287623, -0.28842,  -0.28885,   -0.288911,  -0.288609, -0.287956, -0.286972, -0.285683,
      -0.284123, -0.282329, -0.280343, -0.27821,  -0.275979,  -0.273699,  -0.271419, -0.269189, -0.267054, -0.265061,
      -0.263249, -0.261654, -0.260309, -0.259238, -0.258461,  -0.257991,  -0.257834, -0.25799,  -0.258451, -0.259204,
      -0.26023,  -0.261502, -0.262992, -0.264665, -0.266483,  -0.268405,  -0.27039,  -0.272393, -0.274372, -0.276285,
      -0.278091, -0.279752, -0.281234, -0.282507, -0.283545,  -0.284328,  -0.284841, -0.285075, -0.285029, -0.284704,
      -0.28411,  -0.283261, -0.282178, -0.280886, -0.279414,  -0.277794,  -0.276062, -0.274257, -0.272417, -0.270583,
      -0.268793, -0.267086, -0.265498, -0.264063, -0.262811,  -0.261768,  -0.260956, -0.26039,  -0.260082, -0.260038,
      -0.260257, -0.260735, -0.261459, -0.262413, -0.263577,  -0.264923,  -0.266424, -0.268046, -0.269754, -0.271511,
      -0.273279, -0.27502,  -0.276697, -0.278273, -0.279714,  -0.280991,  -0.282074, -0.282942, -0.283576, -0.283962,
      -0.284091, -0.283962, -0.283576, -0.282942, -0.282074,  -0.280991,  -0.279714, -0.278273, -0.276697, -0.27502,
      -0.273279, -0.271511, -0.269754, -0.268046, -0.266424,  -0.264924,  -0.263577, -0.262413, -0.261459, -0.260735,
      -0.260257, -0.260038, -0.260082, -0.26039,  -0.260956,  -0.261768,  -0.262811, -0.264063, -0.265498, -0.267086,
      -0.268793, -0.270583, -0.272417, -0.274257, -0.276062,  -0.277794,  -0.279414, -0.280886, -0.282178, -0.283261,
      -0.28411,  -0.284704, -0.285029, -0.285075, -0.284841,  -0.284328,  -0.283545, -0.282507, -0.281234, -0.279752,
      -0.278091, -0.276285, -0.274372, -0.272393, -0.27039,   -0.268405,  -0.266483, -0.264665, -0.262992, -0.261502,
      -0.26023,  -0.259204, -0.258451, -0.25799,  -0.257834,  -0.257991,  -0.258461, -0.259238, -0.260309, -0.261654,
      -0.263249, -0.265061, -0.267054, -0.269189, -0.271419,  -0.273699,  -0.275979, -0.27821,  -0.280343, -0.282329,
      -0.284123, -0.285683, -0.286972, -0.287956, -0.288609,  -0.288911,  -0.28885,  -0.28842,  -0.287623, -0.286472,
      -0.284983, -0.283183, -0.281105, -0.27879,  -0.276282,  -0.273634,  -0.270898, -0.268135, -0.265402, -0.262761,
      -0.260271, -0.257989, -0.255972, -0.254268, -0.252921,  -0.251971,  -0.251447, -0.251372, -0.251757, -0.252606,
      -0.253913, -0.25566,  -0.257821, -0.26036,  -0.263232,  -0.266382,  -0.269749, -0.273267, -0.276861, -0.280456,
      -0.283973, -0.287331, -0.290453, -0.293262, -0.295686,  -0.29766,   -0.299124, -0.300031, -0.30034,  -0.300024,
      -0.299067, -0.297468, -0.295237, -0.292401, -0.288998,  -0.285082,  -0.280719, -0.275988, -0.270977, -0.265785,
      -0.260521, -0.255298, -0.250232, -0.245445, -0.241054,  -0.237177,  -0.233924, -0.2314,   -0.229697, -0.228897,
      -0.229064, -0.230249, -0.232481, -0.23577,  -0.240106,  -0.245453,  -0.251755, -0.25893,  -0.266874, -0.275459,
      -0.284537, -0.293938, -0.303472, -0.312932, -0.3221,    -0.330742,  -0.338616, -0.345476, -0.351073, -0.355159,
      -0.35749,  -0.357834, -0.355969, -0.35169,  -0.34481,   -0.335167,  -0.322623, -0.307071, -0.288433, -0.266664,
      -0.241755, -0.213731, -0.182655, -0.148624, -0.111772,  -0.0722694, -0.030318, 0.0138479, 0.059965,  0.107744,
      0.156872,  0.207018},
     {0.289338,  0.335941,  0.382001,  0.427242,  0.471399,   0.51422,    0.555466,   0.594918,  0.632376,  0.667664,
      0.700628,  0.731139,  0.759095,  0.784421,  0.80707,    0.827022,   0.844283,   0.858887,  0.870893,  0.880386,
      0.88747,   0.892274,  0.894943,  0.89564,   0.894541,   0.891837,   0.887722,   0.882402,  0.876082,  0.868969,
      0.86127,   0.853183,  0.844903,  0.836611,  0.828479,   0.820665,   0.813309,   0.806538,  0.800457,  0.795154,
      0.790697,  0.787133,  0.784491,  0.78278,   0.781988,   0.782087,   0.783032,   0.784763,  0.787204,  0.79027,
      0.793864,  0.797881,  0.802211,  0.806741,  0.811355,   0.815941,   0.820386,   0.824586,  0.828443,  0.831868,
      0.834782,  0.83712,   0.838828,  0.839868,  0.840217,   0.839868,   0.838828,   0.83712,   0.834782,  0.831868,
      0.828443,  0.824586,  0.820386,  0.815941,  0.811355,   0.806741,   0.802211,   0.797881,  0.793864,  0.79027,
      0.787204,  0.784763,  0.783032,  0.782087,  0.781988,   0.78278,    0.784491,   0.787133,  0.790697,  0.795154,
      0.800457,  0.806538,  0.813309,  0.820665,  0.828479,   0.836611,   0.844903,   0.853183,  0.86127,   0.868969,
      0.876082,  0.882402,  0.887722,  0.891837,  0.894541,   0.89564,    0.894943,   0.892274,  0.88747,   0.880386,
      0.870893,  0.858887,  0.844283,  0.827022,  0.80707,    0.784421,   0.759095,   0.731139,  0.700628,  0.667664,
      0.632376,  0.594918,  0.555466,  0.51422,   0.471399,   0.427242,   0.382001,   0.335941,  0.289338,  0.242475,
      0.195638,  0.149112,  0.103183,  0.05813,   0.0142221,  -0.0282816, -0.0691371, -0.108117, -0.145014, -0.179641,
      -0.211835, -0.241459, -0.268401, -0.292578, -0.313931,  -0.332435,  -0.348087,  -0.360917, -0.370979, -0.378353,
      -0.383145, -0.385482, -0.385513, -0.383407, -0.379347,  -0.373532,  -0.366171,  -0.357483, -0.34769,  -0.33702,
      -0.3257,   -0.313952, -0.301997, -0.290045, -0.278295,  -0.266936,  -0.25614,   -0.246065, -0.236848, -0.228609,
      -0.221447, -0.215441, -0.210648, -0.207104, -0.204823,  -0.2038,    -0.204009,  -0.205405, -0.207927, -0.211497,
      -0.216021, -0.221396, -0.227506, -0.234226, -0.241427,  -0.248973,  -0.25673,   -0.264561, -0.272332, -0.279914,
      -0.287184, -0.294028, -0.30034,  -0.306027, -0.311007,  -0.315213,  -0.318591,  -0.321101, -0.322721, -0.32344,
      -0.323265, -0.322218, -0.320332, -0.317656, -0.314249,  -0.310182,  -0.305536,  -0.300399, -0.294866, -0.289037,
      -0.283014, -0.276902, -0.270806, -0.264827, -0.259064,  -0.253611,  -0.248554,  -0.243973, -0.239937, -0.236506,
      -0.23373,  -0.231645, -0.230278, -0.229641, -0.229736,  -0.230551,  -0.232064,  -0.23424,  -0.237034, -0.240392,
      -0.244251, -0.248541, -0.253183, -0.258096, -0.263196,  -0.268393,  -0.2736,    -0.278729, -0.283694, -0.288416,
      -0.292815, -0.296823, -0.300374, -0.303415, -0.305899,  -0.30779,   -0.30906,   -0.309695, -0.309689, -0.309049,
      -0.307789, -0.305936, -0.303527, -0.300606, -0.297227,  -0.293449,  -0.289338,  -0.284968, -0.280411, -0.275748,
      -0.271055, -0.266413, -0.261899, -0.257587, -0.25355,   -0.249852,  -0.246554,  -0.243708, -0.24136,  -0.239547,
      -0.238294, -0.237622, -0.237536, -0.238037, -0.239112,  -0.24074,   -0.242892,  -0.245528, -0.248602, -0.252061,
      -0.255845, -0.259889, -0.264123, -0.268477, -0.272876,  -0.277247,  -0.281516,  -0.285612, -0.289467, -0.293017,
      -0.296204, -0.298974, -0.301284, -0.303095, -0.30438,   -0.305116,  -0.305295,  -0.304913, -0.30398,  -0.302511,
      -0.300533, -0.298081, -0.295195, -0.291926, -0.288329,  -0.284465,  -0.2804,    -0.276201, -0.27194,  -0.267689,
      -0.263517, -0.259497, -0.255694, -0.252173, -0.248993,  -0.246206,  -0.243859,  -0.241992, -0.240636, -0.239813,
      -0.239537, -0.239813, -0.240636, -0.241992, -0.243859,  -0.246206,  -0.248993,  -0.252173, -0.255694, -0.259497,
      -0.263518, -0.267689, -0.27194,  -0.276201, -0.2804,    -0.284465,  -0.288329,  -0.291926, -0.295195, -0.298081,
      -0.300533, -0.302511, -0.30398,  -0.304913, -0.305295,  -0.305116,  -0.30438,   -0.303096, -0.301284, -0.298974,
      -0.296204, -0.293017, -0.289467, -0.285612, -0.281516,  -0.277247,  -0.272876,  -0.268477, -0.264123, -0.259889,
      -0.255845, -0.252061, -0.248602, -0.245528, -0.242892,  -0.24074,   -0.239112,  -0.238037, -0.237536, -0.237622,
      -0.238294, -0.239547, -0.24136,  -0.243708, -0.246554,  -0.249852,  -0.25355,   -0.257587, -0.261899, -0.266413,
      -0.271055, -0.275748, -0.280411, -0.284968, -0.289338,  -0.293449,  -0.297227,  -0.300606, -0.303527, -0.305936,
      -0.307789, -0.309049, -0.309689, -0.309695, -0.30906,   -0.30779,   -0.305899,  -0.303415, -0.300374, -0.296823,
      -0.292815, -0.288416, -0.283694, -0.278729, -0.2736,    -0.268393,  -0.263196,  -0.258096, -0.253183, -0.248541,
      -0.244251, -0.240392, -0.237034, -0.23424,  -0.232064,  -0.230551,  -0.229736,  -0.229641, -0.230278, -0.231645,
      -0.23373,  -0.236506, -0.239937, -0.243973, -0.248554,  -0.253611,  -0.259064,  -0.264827, -0.270806, -0.276902,
      -0.283014, -0.289037, -0.294866, -0.300399, -0.305536,  -0.310182,  -0.314249,  -0.317656, -0.320332, -0.322218,
      -0.323265, -0.32344,  -0.322721, -0.321101, -0.318591,  -0.315213,  -0.311007,  -0.306027, -0.30034,  -0.294028,
      -0.287184, -0.279914, -0.272332, -0.264561, -0.25673,   -0.248973,  -0.241427,  -0.234226, -0.227506, -0.221396,
      -0.216021, -0.211497, -0.207927, -0.205405, -0.204009,  -0.2038,    -0.204823,  -0.207104, -0.210648, -0.215441,
      -0.221447, -0.228609, -0.236848, -0.246065, -0.25614,   -0.266936,  -0.278295,  -0.290045, -0.301997, -0.313952,
      -0.3257,   -0.33702,  -0.34769,  -0.357483, -0.366171,  -0.373532,  -0.379347,  -0.383407, -0.385513, -0.385482,
      -0.383145, -0.378353, -0.370979, -0.360917, -0.348087,  -0.332435,  -0.313931,  -0.292578, -0.268401, -0.241459,
      -0.211835, -0.179641, -0.145014, -0.108117, -0.0691371, -0.0282816, 0.0142222,  0.05813,   0.103183,  0.149112,
      0.195638,  0.242475},
     {0.250833,    0.284942,    0.319154,   0.353361,   0.387456,  0.42133,   0.454875,   0.487986,   0.520556,
      0.552482,    0.583664,    0.614005,   0.643412,   0.671796,  0.699073,  0.725164,   0.749996,   0.773504,
      0.795626,    0.81631,     0.835511,   0.853189,   0.869315,  0.883866,  0.896827,   0.908192,   0.917963,
      0.92615,     0.93277,     0.93785,    0.941423,   0.943531,  0.944221,  0.94355,    0.94158,    0.93838,
      0.934023,    0.92859,     0.922165,   0.914837,   0.906699,  0.897847,  0.88838,    0.878398,   0.868003,
      0.857298,    0.846387,    0.835371,   0.824351,   0.813428,  0.802697,  0.792253,   0.782186,   0.772582,
      0.763522,    0.755083,    0.747334,   0.740341,   0.73416,   0.728842,  0.724431,   0.720962,   0.718464,
      0.716957,    0.716454,    0.716957,   0.718464,   0.720962,  0.724431,  0.728842,   0.73416,    0.740341,
      0.747334,    0.755083,    0.763522,   0.772582,   0.782186,  0.792253,  0.802697,   0.813428,   0.824351,
      0.835371,    0.846387,    0.857298,   0.868003,   0.878398,  0.88838,   0.897847,   0.906699,   0.914837,
      0.922165,    0.92859,     0.934023,   0.93838,    0.94158,   0.94355,   0.944221,   0.943531,   0.941423,
      0.93785,     0.93277,     0.92615,    0.917963,   0.908192,  0.896827,  0.883866,   0.869315,   0.853189,
      0.835511,    0.81631,     0.795626,   0.773504,   0.749996,  0.725164,  0.699073,   0.671796,   0.643412,
      0.614005,    0.583664,    0.552482,   0.520556,   0.487986,  0.454875,  0.42133,    0.387456,   0.353361,
      0.319154,    0.284942,    0.250833,   0.216933,   0.183345,  0.150172,  0.11751,    0.0854567,  0.0541016,
      0.0235317,   -0.00617106, -0.0349302, -0.0626746, -0.089339, -0.114864, -0.139198,  -0.162294,  -0.184112,
      -0.204621,   -0.223794,   -0.241612,  -0.258064,  -0.273145, -0.286855, -0.299204,  -0.310206,  -0.319882,
      -0.328259,   -0.335368,   -0.341249,  -0.345943,  -0.349498, -0.351967, -0.353404,  -0.35387,   -0.353426,
      -0.352136,   -0.350069,   -0.347292,  -0.343875,  -0.33989,  -0.335406, -0.330495,  -0.325226,  -0.31967,
      -0.313894,   -0.307963,   -0.301943,  -0.295893,  -0.289874, -0.283941, -0.278145,  -0.272535,  -0.267157,
      -0.26205,    -0.257253,   -0.252796,  -0.248709,  -0.245014, -0.241732, -0.238878,  -0.236461,  -0.234489,
      -0.232963,   -0.231883,   -0.231242,  -0.231031,  -0.231237, -0.231844, -0.232834,  -0.234183,  -0.235869,
      -0.237864,   -0.240139,   -0.242665,  -0.245411,  -0.248343, -0.251428, -0.254633,  -0.257924,  -0.261268,
      -0.264631,   -0.267982,   -0.271287,  -0.274519,  -0.277647, -0.280645, -0.283487,  -0.286151,  -0.288616,
      -0.290862,   -0.292875,   -0.294639,  -0.296145,  -0.297383, -0.298348, -0.299036,  -0.299448,  -0.299584,
      -0.29945,    -0.299051,   -0.298398,  -0.297501,  -0.296375, -0.295032, -0.293492,  -0.291771,  -0.28989,
      -0.287869,   -0.28573,    -0.283495,  -0.281188,  -0.27883,  -0.276446, -0.274059,  -0.271691,  -0.269364,
      -0.2671,     -0.264919,   -0.262841,  -0.260884,  -0.259065, -0.257398, -0.255899,  -0.254578,  -0.253445,
      -0.25251,    -0.251778,   -0.251253,  -0.250938,  -0.250833, -0.250937, -0.251246,  -0.251755,  -0.252456,
      -0.253341,   -0.254399,   -0.255619,  -0.256986,  -0.258487, -0.260105, -0.261825,  -0.263629,  -0.265498,
      -0.267415,   -0.269361,   -0.271316,  -0.273264,  -0.275184, -0.277058, -0.278871,  -0.280604,  -0.282242,
      -0.28377,    -0.285174,   -0.286442,  -0.287563,  -0.288527, -0.289326, -0.289954,  -0.290405,  -0.290677,
      -0.290767,   -0.290677,   -0.290408,  -0.289963,  -0.289348, -0.28857,  -0.287636,  -0.286556,  -0.285342,
      -0.284005,   -0.282558,   -0.281017,  -0.279395,  -0.277709, -0.275975, -0.274209,  -0.272429,  -0.270652,
      -0.268894,   -0.267172,   -0.265503,  -0.263901,  -0.262384, -0.260964, -0.259655,  -0.258469,  -0.257418,
      -0.256512,   -0.255758,   -0.255165,  -0.254737,  -0.254479, -0.254392, -0.254479,  -0.254737,  -0.255165,
      -0.255758,   -0.256512,   -0.257418,  -0.258469,  -0.259655, -0.260964, -0.262384,  -0.263901,  -0.265503,
      -0.267172,   -0.268894,   -0.270652,  -0.272429,  -0.274209, -0.275975, -0.277709,  -0.279395,  -0.281017,
      -0.282558,   -0.284005,   -0.285342,  -0.286556,  -0.287636, -0.28857,  -0.289348,  -0.289963,  -0.290408,
      -0.290677,   -0.290767,   -0.290677,  -0.290405,  -0.289954, -0.289326, -0.288527,  -0.287563,  -0.286442,
      -0.285174,   -0.28377,    -0.282242,  -0.280604,  -0.278871, -0.277058, -0.275184,  -0.273264,  -0.271316,
      -0.269361,   -0.267415,   -0.265498,  -0.263629,  -0.261825, -0.260105, -0.258487,  -0.256986,  -0.255619,
      -0.254399,   -0.253341,   -0.252456,  -0.251755,  -0.251246, -0.250937, -0.250833,  -0.250938,  -0.251253,
      -0.251778,   -0.25251,    -0.253445,  -0.254578,  -0.255899, -0.257398, -0.259065,  -0.260884,  -0.262841,
      -0.264919,   -0.2671,     -0.269364,  -0.271691,  -0.274059, -0.276446, -0.27883,   -0.281188,  -0.283495,
      -0.28573,    -0.287869,   -0.28989,   -0.291771,  -0.293492, -0.295032, -0.296375,  -0.297501,  -0.298398,
      -0.299051,   -0.29945,    -0.299584,  -0.299448,  -0.299036, -0.298348, -0.297383,  -0.296145,  -0.294639,
      -0.292875,   -0.290862,   -0.288616,  -0.286151,  -0.283487, -0.280645, -0.277647,  -0.274519,  -0.271287,
      -0.267982,   -0.264631,   -0.261268,  -0.257924,  -0.254633, -0.251428, -0.248343,  -0.245411,  -0.242665,
      -0.240139,   -0.237864,   -0.235869,  -0.234183,  -0.232834, -0.231844, -0.231237,  -0.231031,  -0.231242,
      -0.231883,   -0.232963,   -0.234489,  -0.236461,  -0.238877, -0.241732, -0.245014,  -0.248709,  -0.252796,
      -0.257253,   -0.26205,    -0.267157,  -0.272535,  -0.278145, -0.283941, -0.289874,  -0.295893,  -0.301943,
      -0.307963,   -0.313894,   -0.31967,   -0.325226,  -0.330495, -0.335406, -0.33989,   -0.343875,  -0.347292,
      -0.350069,   -0.352136,   -0.353426,  -0.35387,   -0.353404, -0.351967, -0.349498,  -0.345943,  -0.341248,
      -0.335368,   -0.328259,   -0.319882,  -0.310206,  -0.299204, -0.286855, -0.273145,  -0.258064,  -0.241612,
      -0.223794,   -0.204621,   -0.184112,  -0.162294,  -0.139198, -0.114864, -0.0893389, -0.0626746, -0.0349302,
      -0.00617107, 0.0235318,   0.0541016,  0.0854567,  0.11751,   0.150172,  0.183345,   0.216933},
     {0.30034,    0.330019,   0.359468,   0.388615,  0.41739,   0.445724,  0.473549,  0.500801,  0.527418,   0.553341,
      0.578514,   0.602883,   0.6264,     0.64902,   0.670701,  0.691405,  0.711099,  0.729755,  0.747349,   0.763861,
      0.779276,   0.793583,   0.806778,   0.818859,  0.829829,  0.839698,  0.848477,  0.856185,  0.862842,   0.868474,
      0.873111,   0.876787,   0.879538,   0.881404,  0.88243,   0.882661,  0.882147,  0.880939,  0.879091,   0.876657,
      0.873695,   0.870262,   0.866418,   0.862221,  0.85773,   0.853005,  0.848105,  0.843088,  0.83801,    0.832928,
      0.827894,   0.822962,   0.81818,    0.813595,  0.809253,  0.805193,  0.801455,  0.798073,  0.795077,   0.792495,
      0.790351,   0.788663,   0.787446,   0.786712,  0.786467,  0.786712,  0.787446,  0.788663,  0.790351,   0.792495,
      0.795077,   0.798073,   0.801455,   0.805193,  0.809253,  0.813595,  0.81818,   0.822962,  0.827894,   0.832928,
      0.83801,    0.843088,   0.848105,   0.853005,  0.85773,   0.862221,  0.866418,  0.870262,  0.873695,   0.876657,
      0.879091,   0.880939,   0.882147,   0.882661,  0.88243,   0.881404,  0.879538,  0.876787,  0.873111,   0.868474,
      0.862842,   0.856185,   0.848477,   0.839698,  0.829829,  0.818859,  0.806778,  0.793583,  0.779276,   0.763861,
      0.747349,   0.729755,   0.711099,   0.691405,  0.670701,  0.64902,   0.6264,    0.602883,  0.578514,   0.553341,
      0.527418,   0.500801,   0.473549,   0.445724,  0.41739,   0.388615,  0.359468,  0.330019,  0.30034,    0.270505,
      0.240587,   0.210661,   0.180801,   0.151082,  0.121578,  0.0923617, 0.0635046, 0.0350774, 0.00714857, -0.0202152,
      -0.0469497, -0.0729933, -0.0982873, -0.122776, -0.146407, -0.169132, -0.190905, -0.211686, -0.231438,  -0.250127,
      -0.267726,  -0.284209,  -0.299558,  -0.313758, -0.326798, -0.338672, -0.349378, -0.358921, -0.367307,  -0.374549,
      -0.380663,  -0.385669,  -0.389593,  -0.392462, -0.39431,  -0.395171, -0.395084, -0.394093, -0.392241,  -0.389576,
      -0.386149,  -0.382012,  -0.377218,  -0.371824, -0.365885, -0.35946,  -0.352608, -0.345387, -0.337857,  -0.330076,
      -0.322102,  -0.313995,  -0.30581,   -0.297604, -0.28943,  -0.281341, -0.273387, -0.265616, -0.258075,  -0.250807,
      -0.243852,  -0.237249,  -0.231031,  -0.22523,  -0.219875, -0.21499,  -0.210597, -0.206714, -0.203355,  -0.200531,
      -0.19825,   -0.196515,  -0.195328,  -0.194686, -0.194581, -0.195006, -0.195947, -0.197389, -0.199314,  -0.201701,
      -0.204527,  -0.207766,  -0.21139,   -0.215369, -0.219672, -0.224266, -0.229116, -0.234188, -0.239445,  -0.24485,
      -0.250365,  -0.255954,  -0.26158,   -0.267204, -0.272791, -0.278305, -0.283711, -0.288976, -0.294066,  -0.298952,
      -0.303603,  -0.307992,  -0.312095,  -0.315887, -0.319348, -0.322458, -0.325202, -0.327565, -0.329537,  -0.331108,
      -0.332273,  -0.333027,  -0.33337,   -0.333304, -0.332834, -0.331965, -0.330707, -0.329072, -0.327074,  -0.324729,
      -0.322055,  -0.319071,  -0.315801,  -0.312267, -0.308495, -0.30451,  -0.30034,  -0.296014, -0.29156,   -0.287009,
      -0.28239,   -0.277735,  -0.273073,  -0.268434, -0.263849, -0.259346, -0.254955, -0.250703, -0.246617,  -0.242722,
      -0.239043,  -0.235602,  -0.232419,  -0.229515, -0.226907, -0.224609, -0.222636, -0.220998, -0.219705,  -0.218762,
      -0.218176,  -0.217947,  -0.218077,  -0.218562, -0.219398, -0.220578, -0.222093, -0.223933, -0.226084,  -0.228531,
      -0.231257,  -0.234244,  -0.237472,  -0.240919, -0.244562, -0.248376, -0.252338, -0.25642,  -0.260597,  -0.26484,
      -0.269122,  -0.273416,  -0.277693,  -0.281926, -0.286088, -0.290152, -0.294091, -0.297881, -0.301496,  -0.304915,
      -0.308114,  -0.311074,  -0.313776,  -0.316201, -0.318336, -0.320165, -0.321679, -0.322866, -0.323719,  -0.324233,
      -0.324405,  -0.324233,  -0.323719,  -0.322866, -0.321679, -0.320165, -0.318336, -0.316201, -0.313776,  -0.311074,
      -0.308114,  -0.304915,  -0.301496,  -0.297881, -0.294091, -0.290152, -0.286088, -0.281926, -0.277693,  -0.273416,
      -0.269122,  -0.26484,   -0.260597,  -0.25642,  -0.252338, -0.248376, -0.244562, -0.240919, -0.237472,  -0.234244,
      -0.231257,  -0.228531,  -0.226084,  -0.223933, -0.222093, -0.220578, -0.219398, -0.218562, -0.218077,  -0.217947,
      -0.218176,  -0.218762,  -0.219705,  -0.220998, -0.222636, -0.224609, -0.226907, -0.229515, -0.232419,  -0.235602,
      -0.239043,  -0.242722,  -0.246617,  -0.250703, -0.254955, -0.259346, -0.263849, -0.268434, -0.273073,  -0.277735,
      -0.282391,  -0.287009,  -0.29156,   -0.296014, -0.30034,  -0.30451,  -0.308494, -0.312267, -0.315801,  -0.319071,
      -0.322054,  -0.324729,  -0.327074,  -0.329072, -0.330707, -0.331965, -0.332834, -0.333304, -0.33337,   -0.333027,
      -0.332273,  -0.331108,  -0.329537,  -0.327565, -0.325202, -0.322458, -0.319348, -0.315887, -0.312095,  -0.307992,
      -0.303603,  -0.298952,  -0.294066,  -0.288976, -0.283711, -0.278305, -0.272791, -0.267204, -0.26158,   -0.255954,
      -0.250365,  -0.24485,   -0.239445,  -0.234188, -0.229116, -0.224266, -0.219672, -0.215369, -0.21139,   -0.207766,
      -0.204527,  -0.201701,  -0.199314,  -0.197389, -0.195947, -0.195006, -0.194581, -0.194686, -0.195328,  -0.196515,
      -0.19825,   -0.200531,  -0.203355,  -0.206714, -0.210597, -0.21499,  -0.219875, -0.22523,  -0.231031,  -0.237249,
      -0.243852,  -0.250807,  -0.258075,  -0.265616, -0.273387, -0.281341, -0.28943,  -0.297604, -0.30581,   -0.313995,
      -0.322102,  -0.330076,  -0.337857,  -0.345387, -0.352608, -0.35946,  -0.365885, -0.371824, -0.377218,  -0.382012,
      -0.386149,  -0.389576,  -0.392241,  -0.394093, -0.395084, -0.395171, -0.39431,  -0.392462, -0.389593,  -0.385669,
      -0.380663,  -0.374549,  -0.367307,  -0.358921, -0.349378, -0.338672, -0.326798, -0.313758, -0.299558,  -0.284209,
      -0.267726,  -0.250127,  -0.231438,  -0.211686, -0.190905, -0.169132, -0.146407, -0.122776, -0.0982873, -0.0729933,
      -0.0469497, -0.0202152, 0.00714857, 0.0350774, 0.0635046, 0.0923618, 0.121578,  0.151082,  0.180801,   0.210661,
      0.240587,   0.270505},
     {0.30034,    0.321521,   0.342518,   0.363306,    0.383858,  0.40415,   0.42416,   0.443864,    0.463241,
      0.482272,   0.500938,   0.519221,   0.537106,    0.554576,  0.57162,   0.588223,  0.604377,    0.62007,
      0.635296,   0.650046,   0.664317,   0.678103,    0.691402,  0.704212,  0.716533,  0.728367,    0.739714,
      0.750579,   0.760966,   0.770881,   0.780329,    0.789318,  0.797856,  0.805953,  0.813617,    0.82086,
      0.827693,   0.834127,   0.840175,   0.845848,    0.851159,  0.856122,  0.86075,   0.865055,    0.869052,
      0.872754,   0.876173,   0.879323,   0.882216,    0.884865,  0.887281,  0.889477,  0.891462,    0.893248,
      0.894844,   0.89626,    0.897503,   0.898581,    0.899502,  0.90027,   0.900892,  0.901372,    0.901711,
      0.901914,   0.901982,   0.901914,   0.901711,    0.901372,  0.900892,  0.90027,   0.899502,    0.898581,
      0.897503,   0.89626,    0.894844,   0.893248,    0.891462,  0.889477,  0.887281,  0.884865,    0.882216,
      0.879323,   0.876173,   0.872754,   0.869052,    0.865055,  0.86075,   0.856122,  0.851159,    0.845848,
      0.840175,   0.834127,   0.827693,   0.820861,    0.813617,  0.805953,  0.797856,  0.789318,    0.780329,
      0.770881,   0.760966,   0.750579,   0.739714,    0.728367,  0.716533,  0.704212,  0.691402,    0.678103,
      0.664317,   0.650046,   0.635296,   0.62007,     0.604377,  0.588223,  0.57162,   0.554576,    0.537106,
      0.519221,   0.500938,   0.482272,   0.463241,    0.443864,  0.42416,   0.40415,   0.383858,    0.363306,
      0.342518,   0.321521,   0.30034,    0.279003,    0.257536,  0.23597,   0.214334,  0.192656,    0.170967,
      0.149299,   0.127682,   0.106146,   0.084724,    0.0634465, 0.042345,  0.0214504, 0.000793633, -0.0195948,
      -0.0396848, -0.0594468, -0.0788519, -0.0978717,  -0.116479, -0.134647, -0.152349, -0.169563,   -0.186263,
      -0.202427,  -0.218035,  -0.233066,  -0.247503,   -0.261327, -0.274524, -0.287079, -0.298981,   -0.310218,
      -0.32078,   -0.330662,  -0.339856,  -0.348359,   -0.356168, -0.363283, -0.369705, -0.375436,   -0.380481,
      -0.384847,  -0.388541,  -0.391572,  -0.393953,   -0.395696, -0.396814, -0.397324, -0.397243,   -0.39659,
      -0.395385,  -0.393648,  -0.391402,  -0.38867,    -0.385477, -0.381849, -0.377811, -0.373391,   -0.368617,
      -0.363516,  -0.358118,  -0.352451,  -0.346546,   -0.340432, -0.33414,  -0.327699, -0.321138,   -0.314489,
      -0.307779,  -0.301039,  -0.294297,  -0.287582,   -0.28092,  -0.274338, -0.267863, -0.26152,    -0.255334,
      -0.249326,  -0.24352,   -0.237936,  -0.232595,   -0.227514, -0.222712, -0.218204, -0.214004,   -0.210126,
      -0.206581,  -0.203379,  -0.200529,  -0.198038,   -0.195912, -0.194154, -0.192767, -0.191753,   -0.19111,
      -0.190836,  -0.190929,  -0.191382,  -0.192191,   -0.193346, -0.19484,  -0.196661, -0.198799,   -0.20124,
      -0.203971,  -0.206977,  -0.210243,  -0.21375,    -0.217483, -0.221423, -0.22555,  -0.229846,   -0.234289,
      -0.238861,  -0.243539,  -0.248303,  -0.253132,   -0.258004, -0.262897, -0.267791, -0.272665,   -0.277498,
      -0.282269,  -0.286957,  -0.291545,  -0.296012,   -0.30034,  -0.304512, -0.30851,  -0.312319,   -0.315923,
      -0.319308,  -0.322462,  -0.325371,  -0.328026,   -0.330415, -0.33253,  -0.334365, -0.335912,   -0.337166,
      -0.338124,  -0.338783,  -0.339142,  -0.339201,   -0.33896,  -0.338424, -0.337595, -0.336479,   -0.335081,
      -0.333409,  -0.331472,  -0.329278,  -0.32684,    -0.324167, -0.321273, -0.318172, -0.314876,   -0.311402,
      -0.307766,  -0.303982,  -0.30007,   -0.296045,   -0.291926, -0.28773,  -0.283478, -0.279186,   -0.274874,
      -0.270561,  -0.266265,  -0.262005,  -0.2578,     -0.253667, -0.249625, -0.245691, -0.241882,   -0.238215,
      -0.234704,  -0.231366,  -0.228214,  -0.225262,   -0.222523, -0.220008, -0.217728, -0.215693,   -0.213911,
      -0.21239,   -0.211137,  -0.210157,  -0.209454,   -0.209031, -0.20889,  -0.209031, -0.209454,   -0.210157,
      -0.211137,  -0.21239,   -0.213911,  -0.215693,   -0.217728, -0.220008, -0.222523, -0.225262,   -0.228214,
      -0.231366,  -0.234704,  -0.238215,  -0.241882,   -0.245691, -0.249625, -0.253667, -0.2578,     -0.262005,
      -0.266265,  -0.270561,  -0.274874,  -0.279186,   -0.283478, -0.28773,  -0.291926, -0.296045,   -0.30007,
      -0.303982,  -0.307766,  -0.311402,  -0.314876,   -0.318172, -0.321273, -0.324167, -0.32684,    -0.329278,
      -0.331472,  -0.333409,  -0.335081,  -0.336479,   -0.337595, -0.338424, -0.33896,  -0.339201,   -0.339142,
      -0.338783,  -0.338124,  -0.337166,  -0.335912,   -0.334365, -0.33253,  -0.330415, -0.328026,   -0.325371,
      -0.322462,  -0.319308,  -0.315923,  -0.312319,   -0.30851,  -0.304512, -0.30034,  -0.296012,   -0.291545,
      -0.286957,  -0.282269,  -0.277498,  -0.272665,   -0.267791, -0.262897, -0.258004, -0.253132,   -0.248303,
      -0.243539,  -0.238861,  -0.234289,  -0.229846,   -0.22555,  -0.221423, -0.217483, -0.21375,    -0.210243,
      -0.206977,  -0.203971,  -0.20124,   -0.198799,   -0.196661, -0.19484,  -0.193346, -0.192191,   -0.191382,
      -0.190929,  -0.190836,  -0.19111,   -0.191753,   -0.192767, -0.194154, -0.195912, -0.198038,   -0.200529,
      -0.203379,  -0.206581,  -0.210126,  -0.214004,   -0.218204, -0.222712, -0.227514, -0.232595,   -0.237936,
      -0.24352,   -0.249326,  -0.255334,  -0.26152,    -0.267863, -0.274338, -0.28092,  -0.287582,   -0.294297,
      -0.301039,  -0.307779,  -0.314489,  -0.321138,   -0.327699, -0.33414,  -0.340432, -0.346546,   -0.352451,
      -0.358118,  -0.363516,  -0.368617,  -0.373391,   -0.377811, -0.381849, -0.385477, -0.38867,    -0.391402,
      -0.393648,  -0.395385,  -0.39659,   -0.397243,   -0.397324, -0.396814, -0.395696, -0.393953,   -0.391572,
      -0.388541,  -0.384847,  -0.380481,  -0.375436,   -0.369705, -0.363283, -0.356168, -0.348359,   -0.339856,
      -0.330662,  -0.32078,   -0.310218,  -0.298981,   -0.287079, -0.274524, -0.261327, -0.247503,   -0.233066,
      -0.218035,  -0.202427,  -0.186263,  -0.169563,   -0.152349, -0.134647, -0.116479, -0.0978717,  -0.0788519,
      -0.0594468, -0.0396848, -0.0195948, 0.000793631, 0.0214504, 0.042345,  0.0634466, 0.084724,    0.106146,
      0.127682,   0.149299,   0.170968,   0.192656,    0.214334,  0.23597,   0.257536,  0.279003},
     {0.231031,   0.248092,   0.265246,    0.282481,   0.299785,   0.317145,   0.33455,    0.351987,   0.369444,
      0.386907,   0.404363,   0.421801,    0.439206,   0.456566,   0.473867,   0.491097,   0.508242,   0.525289,
      0.542225,   0.559036,   0.575709,    0.592232,   0.608591,   0.624772,   0.640764,   0.656553,   0.672127,
      0.687472,   0.702577,   0.717429,    0.732016,   0.746325,   0.760346,   0.774066,   0.787475,   0.80056,
      0.813311,   0.825718,   0.837769,    0.849455,   0.860767,   0.871693,   0.882226,   0.892355,   0.902074,
      0.911372,   0.920243,   0.928679,    0.936672,   0.944216,   0.951304,   0.95793,    0.964089,   0.969774,
      0.974982,   0.979708,   0.983947,    0.987696,   0.990952,   0.993712,   0.995973,   0.997734,   0.998992,
      0.999748,   1,          0.999748,    0.998992,   0.997734,   0.995973,   0.993712,   0.990952,   0.987696,
      0.983947,   0.979708,   0.974982,    0.969774,   0.964089,   0.95793,    0.951304,   0.944216,   0.936672,
      0.928679,   0.920243,   0.911372,    0.902074,   0.892355,   0.882226,   0.871693,   0.860767,   0.849455,
      0.837769,   0.825718,   0.813311,    0.80056,    0.787475,   0.774066,   0.760346,   0.746325,   0.732016,
      0.717429,   0.702577,   0.687472,    0.672127,   0.656553,   0.640764,   0.624772,   0.608591,   0.592232,
      0.575709,   0.559036,   0.542225,    0.525289,   0.508242,   0.491097,   0.473867,   0.456566,   0.439206,
      0.421801,   0.404363,   0.386907,    0.369444,   0.351987,   0.33455,    0.317145,   0.299785,   0.282481,
      0.265246,   0.248092,   0.231031,    0.214074,   0.197233,   0.180518,   0.163942,   0.147515,   0.131247,
      0.115148,   0.0992284,  0.0834983,   0.0679667,  0.0526428,  0.0375355,  0.0226532,  0.00800429, -0.00640347,
      -0.0205624, -0.0344653, -0.0481054,  -0.0614759, -0.0745707, -0.0873839, -0.09991,   -0.112144,  -0.124081,
      -0.135716,  -0.147046,  -0.158066,   -0.168774,  -0.179166,  -0.18924,   -0.198993,  -0.208424,  -0.217531,
      -0.226313,  -0.234769,  -0.242899,   -0.250702,  -0.25818,   -0.265331,  -0.272159,  -0.278663,  -0.284845,
      -0.290707,  -0.296252,  -0.301483,   -0.306401,  -0.311011,  -0.315315,  -0.319318,  -0.323023,  -0.326436,
      -0.32956,   -0.3324,    -0.334962,   -0.337251,  -0.339272,  -0.341032,  -0.342535,  -0.343789,  -0.3448,
      -0.345575,  -0.346119,  -0.346441,   -0.346546,  -0.346443,  -0.346138,  -0.34564,   -0.344955,  -0.344091,
      -0.343055,  -0.341857,  -0.340503,   -0.339001,  -0.337359,  -0.335586,  -0.333688,  -0.331675,  -0.329554,
      -0.327332,  -0.325019,  -0.322621,   -0.320147,  -0.317604,  -0.315,     -0.312343,  -0.30964,   -0.306899,
      -0.304127,  -0.30133,   -0.298517,   -0.295695,  -0.292869,  -0.290047,  -0.287235,  -0.284439,  -0.281666,
      -0.278922,  -0.276213,  -0.273543,   -0.270919,  -0.268346,  -0.265829,  -0.263372,  -0.260981,  -0.258659,
      -0.256411,  -0.25424,   -0.252151,   -0.250146,  -0.24823,   -0.246404,  -0.244673,  -0.243037,  -0.2415,
      -0.240064,  -0.23873,   -0.237499,   -0.236374,  -0.235356,  -0.234444,  -0.23364,   -0.232944,  -0.232357,
      -0.231877,  -0.231506,  -0.231241,   -0.231083,  -0.231031,  -0.231083,  -0.231238,  -0.231494,  -0.23185,
      -0.232304,  -0.232853,  -0.233495,   -0.234228,  -0.235049,  -0.235955,  -0.236944,  -0.238012,  -0.239155,
      -0.240371,  -0.241657,  -0.243007,   -0.244419,  -0.24589,   -0.247414,  -0.248988,  -0.250608,  -0.25227,
      -0.25397,   -0.255703,  -0.257465,   -0.259252,  -0.26106,   -0.262884,  -0.26472,   -0.266563,  -0.26841,
      -0.270256,  -0.272096,  -0.273927,   -0.275744,  -0.277543,  -0.279321,  -0.281072,  -0.282794,  -0.284481,
      -0.286131,  -0.28774,   -0.289305,   -0.290821,  -0.292285,  -0.293695,  -0.295047,  -0.296338,  -0.297566,
      -0.298727,  -0.299819,  -0.300841,   -0.301789,  -0.302661,  -0.303456,  -0.304172,  -0.304808,  -0.305361,
      -0.305832,  -0.306218,  -0.306519,   -0.306735,  -0.306864,  -0.306908,  -0.306864,  -0.306735,  -0.306519,
      -0.306218,  -0.305832,  -0.305361,   -0.304808,  -0.304172,  -0.303456,  -0.302661,  -0.301789,  -0.300841,
      -0.299819,  -0.298727,  -0.297566,   -0.296338,  -0.295047,  -0.293695,  -0.292285,  -0.290821,  -0.289305,
      -0.28774,   -0.286131,  -0.284481,   -0.282794,  -0.281072,  -0.279321,  -0.277543,  -0.275744,  -0.273927,
      -0.272096,  -0.270256,  -0.26841,    -0.266563,  -0.26472,   -0.262884,  -0.26106,   -0.259252,  -0.257465,
      -0.255703,  -0.25397,   -0.25227,    -0.250608,  -0.248988,  -0.247414,  -0.24589,   -0.244419,  -0.243007,
      -0.241657,  -0.240371,  -0.239155,   -0.238012,  -0.236944,  -0.235955,  -0.235049,  -0.234228,  -0.233495,
      -0.232853,  -0.232304,  -0.23185,    -0.231494,  -0.231238,  -0.231083,  -0.231031,  -0.231083,  -0.231241,
      -0.231506,  -0.231877,  -0.232357,   -0.232944,  -0.23364,   -0.234444,  -0.235356,  -0.236374,  -0.237499,
      -0.23873,   -0.240064,  -0.2415,     -0.243037,  -0.244673,  -0.246404,  -0.24823,   -0.250146,  -0.252151,
      -0.25424,   -0.256411,  -0.258659,   -0.260981,  -0.263372,  -0.265829,  -0.268346,  -0.270919,  -0.273543,
      -0.276213,  -0.278922,  -0.281666,   -0.284439,  -0.287235,  -0.290047,  -0.292869,  -0.295695,  -0.298517,
      -0.30133,   -0.304127,  -0.306899,   -0.30964,   -0.312343,  -0.315,     -0.317604,  -0.320147,  -0.322621,
      -0.325019,  -0.327332,  -0.329554,   -0.331675,  -0.333688,  -0.335586,  -0.337359,  -0.339001,  -0.340503,
      -0.341857,  -0.343055,  -0.344091,   -0.344955,  -0.34564,   -0.346138,  -0.346443,  -0.346546,  -0.346441,
      -0.346119,  -0.345575,  -0.3448,     -0.343789,  -0.342535,  -0.341032,  -0.339272,  -0.337251,  -0.334962,
      -0.3324,    -0.32956,   -0.326436,   -0.323023,  -0.319318,  -0.315315,  -0.311011,  -0.306401,  -0.301483,
      -0.296252,  -0.290707,  -0.284845,   -0.278662,  -0.272159,  -0.265331,  -0.25818,   -0.250702,  -0.242899,
      -0.234769,  -0.226313,  -0.217531,   -0.208424,  -0.198993,  -0.18924,   -0.179166,  -0.168774,  -0.158066,
      -0.147046,  -0.135716,  -0.124081,   -0.112144,  -0.09991,   -0.0873839, -0.0745707, -0.0614759, -0.0481054,
      -0.0344654, -0.0205624, -0.00640347, 0.00800429, 0.0226532,  0.0375355,  0.0526428,  0.0679667,  0.0834983,
      0.0992284,  0.115148,   0.131247,    0.147515,   0.163942,   0.180518,   0.197233,   0.214074},
     {0.231031,   0.248092,   0.265246,    0.282481,   0.299785,   0.317145,   0.33455,    0.351987,   0.369444,
      0.386907,   0.404363,   0.421801,    0.439206,   0.456566,   0.473867,   0.491097,   0.508242,   0.525289,
      0.542225,   0.559036,   0.575709,    0.592232,   0.608591,   0.624772,   0.640764,   0.656553,   0.672127,
      0.687472,   0.702577,   0.717429,    0.732016,   0.746325,   0.760346,   0.774066,   0.787475,   0.80056,
      0.813311,   0.825718,   0.837769,    0.849455,   0.860767,   0.871693,   0.882226,   0.892355,   0.902074,
      0.911372,   0.920243,   0.928679,    0.936672,   0.944216,   0.951304,   0.95793,    0.964089,   0.969774,
      0.974982,   0.979708,   0.983947,    0.987696,   0.990952,   0.993712,   0.995973,   0.997734,   0.998992,
      0.999748,   1,          0.999748,    0.998992,   0.997734,   0.995973,   0.993712,   0.990952,   0.987696,
      0.983947,   0.979708,   0.974982,    0.969774,   0.964089,   0.95793,    0.951304,   0.944216,   0.936672,
      0.928679,   0.920243,   0.911372,    0.902074,   0.892355,   0.882226,   0.871693,   0.860767,   0.849455,
      0.837769,   0.825718,   0.813311,    0.80056,    0.787475,   0.774066,   0.760346,   0.746325,   0.732016,
      0.717429,   0.702577,   0.687472,    0.672127,   0.656553,   0.640764,   0.624772,   0.608591,   0.592232,
      0.575709,   0.559036,   0.542225,    0.525289,   0.508242,   0.491097,   0.473867,   0.456566,   0.439206,
      0.421801,   0.404363,   0.386907,    0.369444,   0.351987,   0.33455,    0.317145,   0.299785,   0.282481,
      0.265246,   0.248092,   0.231031,    0.214074,   0.197233,   0.180518,   0.163942,   0.147515,   0.131247,
      0.115148,   0.0992284,  0.0834983,   0.0679667,  0.0526428,  0.0375355,  0.0226532,  0.00800429, -0.00640347,
      -0.0205624, -0.0344653, -0.0481054,  -0.0614759, -0.0745707, -0.0873839, -0.09991,   -0.112144,  -0.124081,
      -0.135716,  -0.147046,  -0.158066,   -0.168774,  -0.179166,  -0.18924,   -0.198993,  -0.208424,  -0.217531,
      -0.226313,  -0.234769,  -0.242899,   -0.250702,  -0.25818,   -0.265331,  -0.272159,  -0.278663,  -0.284845,
      -0.290707,  -0.296252,  -0.301483,   -0.306401,  -0.311011,  -0.315315,  -0.319318,  -0.323023,  -0.326436,
      -0.32956,   -0.3324,    -0.334962,   -0.337251,  -0.339272,  -0.341032,  -0.342535,  -0.343789,  -0.3448,
      -0.345575,  -0.346119,  -0.346441,   -0.346546,  -0.346443,  -0.346138,  -0.34564,   -0.344955,  -0.344091,
      -0.343055,  -0.341857,  -0.340503,   -0.339001,  -0.337359,  -0.335586,  -0.333688,  -0.331675,  -0.329554,
      -0.327332,  -0.325019,  -0.322621,   -0.320147,  -0.317604,  -0.315,     -0.312343,  -0.30964,   -0.306899,
      -0.304127,  -0.30133,   -0.298517,   -0.295695,  -0.292869,  -0.290047,  -0.287235,  -0.284439,  -0.281666,
      -0.278922,  -0.276213,  -0.273543,   -0.270919,  -0.268346,  -0.265829,  -0.263372,  -0.260981,  -0.258659,
      -0.256411,  -0.25424,   -0.252151,   -0.250146,  -0.24823,   -0.246404,  -0.244673,  -0.243037,  -0.2415,
      -0.240064,  -0.23873,   -0.237499,   -0.236374,  -0.235356,  -0.234444,  -0.23364,   -0.232944,  -0.232357,
      -0.231877,  -0.231506,  -0.231241,   -0.231083,  -0.231031,  -0.231083,  -0.231238,  -0.231494,  -0.23185,
      -0.232304,  -0.232853,  -0.233495,   -0.234228,  -0.235049,  -0.235955,  -0.236944,  -0.238012,  -0.239155,
      -0.240371,  -0.241657,  -0.243007,   -0.244419,  -0.24589,   -0.247414,  -0.248988,  -0.250608,  -0.25227,
      -0.25397,   -0.255703,  -0.257465,   -0.259252,  -0.26106,   -0.262884,  -0.26472,   -0.266563,  -0.26841,
      -0.270256,  -0.272096,  -0.273927,   -0.275744,  -0.277543,  -0.279321,  -0.281072,  -0.282794,  -0.284481,
      -0.286131,  -0.28774,   -0.289305,   -0.290821,  -0.292285,  -0.293695,  -0.295047,  -0.296338,  -0.297566,
      -0.298727,  -0.299819,  -0.300841,   -0.301789,  -0.302661,  -0.303456,  -0.304172,  -0.304808,  -0.305361,
      -0.305832,  -0.306218,  -0.306519,   -0.306735,  -0.306864,  -0.306908,  -0.306864,  -0.306735,  -0.306519,
      -0.306218,  -0.305832,  -0.305361,   -0.304808,  -0.304172,  -0.303456,  -0.302661,  -0.301789,  -0.300841,
      -0.299819,  -0.298727,  -0.297566,   -0.296338,  -0.295047,  -0.293695,  -0.292285,  -0.290821,  -0.289305,
      -0.28774,   -0.286131,  -0.284481,   -0.282794,  -0.281072,  -0.279321,  -0.277543,  -0.275744,  -0.273927,
      -0.272096,  -0.270256,  -0.26841,    -0.266563,  -0.26472,   -0.262884,  -0.26106,   -0.259252,  -0.257465,
      -0.255703,  -0.25397,   -0.25227,    -0.250608,  -0.248988,  -0.247414,  -0.24589,   -0.244419,  -0.243007,
      -0.241657,  -0.240371,  -0.239155,   -0.238012,  -0.236944,  -0.235955,  -0.235049,  -0.234228,  -0.233495,
      -0.232853,  -0.232304,  -0.23185,    -0.231494,  -0.231238,  -0.231083,  -0.231031,  -0.231083,  -0.231241,
      -0.231506,  -0.231877,  -0.232357,   -0.232944,  -0.23364,   -0.234444,  -0.235356,  -0.236374,  -0.237499,
      -0.23873,   -0.240064,  -0.2415,     -0.243037,  -0.244673,  -0.246404,  -0.24823,   -0.250146,  -0.252151,
      -0.25424,   -0.256411,  -0.258659,   -0.260981,  -0.263372,  -0.265829,  -0.268346,  -0.270919,  -0.273543,
      -0.276213,  -0.278922,  -0.281666,   -0.284439,  -0.287235,  -0.290047,  -0.292869,  -0.295695,  -0.298517,
      -0.30133,   -0.304127,  -0.306899,   -0.30964,   -0.312343,  -0.315,     -0.317604,  -0.320147,  -0.322621,
      -0.325019,  -0.327332,  -0.329554,   -0.331675,  -0.333688,  -0.335586,  -0.337359,  -0.339001,  -0.340503,
      -0.341857,  -0.343055,  -0.344091,   -0.344955,  -0.34564,   -0.346138,  -0.346443,  -0.346546,  -0.346441,
      -0.346119,  -0.345575,  -0.3448,     -0.343789,  -0.342535,  -0.341032,  -0.339272,  -0.337251,  -0.334962,
      -0.3324,    -0.32956,   -0.326436,   -0.323023,  -0.319318,  -0.315315,  -0.311011,  -0.306401,  -0.301483,
      -0.296252,  -0.290707,  -0.284845,   -0.278662,  -0.272159,  -0.265331,  -0.25818,   -0.250702,  -0.242899,
      -0.234769,  -0.226313,  -0.217531,   -0.208424,  -0.198993,  -0.18924,   -0.179166,  -0.168774,  -0.158066,
      -0.147046,  -0.135716,  -0.124081,   -0.112144,  -0.09991,   -0.0873839, -0.0745707, -0.0614759, -0.0481054,
      -0.0344654, -0.0205624, -0.00640347, 0.00800429, 0.0226532,  0.0375355,  0.0526428,  0.0679667,  0.0834983,
      0.0992284,  0.115148,   0.131247,    0.147515,   0.163942,   0.180518,   0.197233,   0.214074},
     {0.346546,   0.359277,   0.371951,   0.38456,    0.3971,     0.409565,   0.42195,    0.434247,   0.446453,
      0.45856,    0.470565,   0.48246,    0.494241,   0.505902,   0.517438,   0.528843,   0.540113,   0.551241,
      0.562222,   0.573052,   0.583725,   0.594237,   0.604582,   0.614755,   0.624752,   0.634568,   0.644198,
      0.653638,   0.662883,   0.671929,   0.680772,   0.689406,   0.69783,    0.706037,   0.714024,   0.721789,
      0.729325,   0.736631,   0.743703,   0.750537,   0.75713,    0.763478,   0.76958,    0.775431,   0.781029,
      0.786372,   0.791456,   0.79628,    0.80084,    0.805136,   0.809163,   0.812922,   0.81641,    0.819625,
      0.822565,   0.82523,    0.827618,   0.829727,   0.831558,   0.833108,   0.834377,   0.835365,   0.836071,
      0.836495,   0.836636,   0.836495,   0.836071,   0.835365,   0.834377,   0.833108,   0.831558,   0.829727,
      0.827618,   0.82523,    0.822565,   0.819625,   0.81641,    0.812922,   0.809163,   0.805136,   0.80084,
      0.79628,    0.791456,   0.786372,   0.781029,   0.775431,   0.76958,    0.763478,   0.75713,    0.750537,
      0.743703,   0.736631,   0.729325,   0.721789,   0.714024,   0.706037,   0.69783,    0.689406,   0.680772,
      0.671929,   0.662883,   0.653638,   0.644198,   0.634568,   0.624752,   0.614755,   0.604582,   0.594237,
      0.583725,   0.573052,   0.562222,   0.551241,   0.540113,   0.528843,   0.517438,   0.505902,   0.494241,
      0.48246,    0.470565,   0.45856,    0.446453,   0.434247,   0.42195,    0.409565,   0.3971,     0.38456,
      0.371951,   0.359277,   0.346546,   0.333763,   0.320933,   0.308062,   0.295157,   0.282223,   0.269265,
      0.256289,   0.243302,   0.230309,   0.217315,   0.204327,   0.191349,   0.178389,   0.16545,    0.152539,
      0.139662,   0.126824,   0.11403,    0.101285,   0.088596,   0.0759673,  0.0634043,  0.0509122,  0.0384962,
      0.0261614,  0.0139129,  0.00175539, -0.010306,  -0.0222665, -0.0341213, -0.045866,  -0.0574957, -0.0690061,
      -0.0803927, -0.0916512, -0.102777,  -0.113767,  -0.124616,  -0.135321,  -0.145877,  -0.156281,  -0.166529,
      -0.176618,  -0.186544,  -0.196304,  -0.205895,  -0.215313,  -0.224555,  -0.233619,  -0.242502,  -0.2512,
      -0.259713,  -0.268036,  -0.276168,  -0.284107,  -0.29185,   -0.299396,  -0.306742,  -0.313887,  -0.32083,
      -0.327568,  -0.334101,  -0.340428,  -0.346546,  -0.352456,  -0.358156,  -0.363646,  -0.368925,  -0.373993,
      -0.378849,  -0.383493,  -0.387925,  -0.392145,  -0.396153,  -0.39995,   -0.403535,  -0.40691,   -0.410075,
      -0.413031,  -0.415779,  -0.418319,  -0.420653,  -0.422783,  -0.424709,  -0.426433,  -0.427956,  -0.429281,
      -0.430408,  -0.431341,  -0.432081,  -0.43263,   -0.43299,   -0.433164,  -0.433155,  -0.432964,  -0.432595,
      -0.432049,  -0.431331,  -0.430443,  -0.429387,  -0.428168,  -0.426787,  -0.42525,   -0.423558,  -0.421715,
      -0.419725,  -0.417591,  -0.415318,  -0.412907,  -0.410365,  -0.407693,  -0.404897,  -0.40198,   -0.398946,
      -0.395799,  -0.392543,  -0.389183,  -0.385723,  -0.382166,  -0.378518,  -0.374782,  -0.370963,  -0.367065,
      -0.363092,  -0.359049,  -0.354941,  -0.350772,  -0.346546,  -0.342268,  -0.337942,  -0.333573,  -0.329165,
      -0.324724,  -0.320252,  -0.315755,  -0.311237,  -0.306703,  -0.302157,  -0.297604,  -0.293047,  -0.288492,
      -0.283943,  -0.279403,  -0.274878,  -0.270371,  -0.265887,  -0.26143,   -0.257004,  -0.252613,  -0.248261,
      -0.243952,  -0.23969,   -0.235479,  -0.231323,  -0.227225,  -0.22319,   -0.21922,   -0.215319,  -0.211491,
      -0.207739,  -0.204067,  -0.200477,  -0.196973,  -0.193558,  -0.190235,  -0.187006,  -0.183875,  -0.180845,
      -0.177917,  -0.175095,  -0.17238,   -0.169776,  -0.167285,  -0.164908,  -0.162648,  -0.160506,  -0.158485,
      -0.156587,  -0.154812,  -0.153162,  -0.151639,  -0.150244,  -0.148978,  -0.147843,  -0.146839,  -0.145967,
      -0.145228,  -0.144622,  -0.144151,  -0.143814,  -0.143612,  -0.143544,  -0.143612,  -0.143814,  -0.144151,
      -0.144622,  -0.145228,  -0.145967,  -0.146839,  -0.147843,  -0.148978,  -0.150244,  -0.151639,  -0.153162,
      -0.154812,  -0.156587,  -0.158485,  -0.160506,  -0.162648,  -0.164908,  -0.167285,  -0.169776,  -0.17238,
      -0.175095,  -0.177917,  -0.180845,  -0.183875,  -0.187006,  -0.190235,  -0.193558,  -0.196973,  -0.200477,
      -0.204067,  -0.207739,  -0.211491,  -0.215319,  -0.21922,   -0.22319,   -0.227225,  -0.231323,  -0.235479,
      -0.23969,   -0.243952,  -0.248261,  -0.252613,  -0.257004,  -0.26143,   -0.265887,  -0.270371,  -0.274878,
      -0.279403,  -0.283942,  -0.288492,  -0.293047,  -0.297604,  -0.302157,  -0.306703,  -0.311237,  -0.315755,
      -0.320252,  -0.324724,  -0.329165,  -0.333573,  -0.337942,  -0.342268,  -0.346546,  -0.350772,  -0.354941,
      -0.359049,  -0.363092,  -0.367065,  -0.370963,  -0.374782,  -0.378518,  -0.382166,  -0.385723,  -0.389183,
      -0.392543,  -0.395799,  -0.398946,  -0.40198,   -0.404897,  -0.407693,  -0.410365,  -0.412907,  -0.415318,
      -0.417591,  -0.419725,  -0.421715,  -0.423558,  -0.42525,   -0.426787,  -0.428168,  -0.429387,  -0.430443,
      -0.431331,  -0.432049,  -0.432595,  -0.432964,  -0.433155,  -0.433164,  -0.43299,   -0.43263,   -0.432081,
      -0.431341,  -0.430408,  -0.429281,  -0.427956,  -0.426433,  -0.424709,  -0.422783,  -0.420653,  -0.418319,
      -0.415779,  -0.413031,  -0.410075,  -0.40691,   -0.403535,  -0.39995,   -0.396153,  -0.392145,  -0.387925,
      -0.383493,  -0.378849,  -0.373993,  -0.368925,  -0.363646,  -0.358156,  -0.352456,  -0.346546,  -0.340428,
      -0.334101,  -0.327568,  -0.32083,   -0.313887,  -0.306742,  -0.299396,  -0.29185,   -0.284107,  -0.276168,
      -0.268036,  -0.259713,  -0.251201,  -0.242502,  -0.233619,  -0.224555,  -0.215313,  -0.205895,  -0.196304,
      -0.186544,  -0.176618,  -0.166529,  -0.156281,  -0.145877,  -0.135321,  -0.124616,  -0.113767,  -0.102777,
      -0.0916512, -0.0803927, -0.0690061, -0.0574957, -0.0458659, -0.0341213, -0.0222665, -0.010306,  0.00175541,
      0.0139128,  0.0261614,  0.0384962,  0.0509122,  0.0634043,  0.0759673,  0.088596,   0.101285,   0.11403,
      0.126824,   0.139662,   0.152539,   0.16545,    0.178389,   0.191349,   0.204327,   0.217315,   0.230309,
      0.243302,   0.256289,   0.269265,   0.282223,   0.295157,   0.308062,   0.320933,   0.333763},
     {0.346546,   0.350773,   0.354946,   0.359067,     0.363133,    0.367144,   0.371101,    0.375001,    0.378845,
      0.382632,   0.386361,   0.390032,   0.393644,     0.397197,    0.40069,    0.404123,    0.407495,    0.410806,
      0.414055,   0.417241,   0.420364,   0.423425,     0.426421,    0.429353,   0.432221,    0.435024,    0.437761,
      0.440432,   0.443036,   0.445574,   0.448045,     0.450449,    0.452784,   0.455052,    0.457251,    0.459381,
      0.461442,   0.463433,   0.465355,   0.467206,     0.468987,    0.470698,   0.472337,    0.473906,    0.475403,
      0.476828,   0.478182,   0.479464,   0.480673,     0.48181,     0.482875,   0.483867,    0.484786,    0.485632,
      0.486405,   0.487104,   0.48773,    0.488283,     0.488762,    0.489168,   0.4895,      0.489758,    0.489943,
      0.490053,   0.49009,    0.490053,   0.489943,     0.489758,    0.4895,     0.489168,    0.488762,    0.488283,
      0.48773,    0.487104,   0.486405,   0.485632,     0.484786,    0.483867,   0.482875,    0.48181,     0.480673,
      0.479464,   0.478182,   0.476828,   0.475403,     0.473906,    0.472337,   0.470698,    0.468987,    0.467206,
      0.465355,   0.463433,   0.461442,   0.459381,     0.457251,    0.455052,   0.452784,    0.450449,    0.448045,
      0.445574,   0.443036,   0.440432,   0.437761,     0.435024,    0.432221,   0.429353,    0.426421,    0.423425,
      0.420364,   0.417241,   0.414055,   0.410806,     0.407495,    0.404123,   0.40069,     0.397197,    0.393644,
      0.390032,   0.386361,   0.382632,   0.378845,     0.375001,    0.371101,   0.367144,    0.363133,    0.359067,
      0.354946,   0.350773,   0.346546,   0.342267,     0.337937,    0.333556,   0.329125,    0.324644,    0.320114,
      0.315536,   0.31091,    0.306238,   0.301519,     0.296755,    0.291946,   0.287094,    0.282198,    0.27726,
      0.27228,    0.267258,   0.262197,   0.257096,     0.251957,    0.246779,   0.241565,    0.236314,    0.231027,
      0.225706,   0.22035,    0.214962,   0.209541,     0.204088,    0.198605,   0.193092,    0.187549,    0.181979,
      0.176381,   0.170757,   0.165106,   0.159431,     0.153732,    0.14801,    0.142266,    0.1365,      0.130713,
      0.124907,   0.119082,   0.113239,   0.107379,     0.101503,    0.0956119,  0.0897061,   0.0837868,   0.0778548,
      0.0719112,  0.0659567,  0.0599923,  0.0540188,    0.0480372,   0.0420484,  0.0360533,   0.0300527,   0.0240476,
      0.0180389,  0.0120274,  0.00601416, -7.06034e-09, -0.00601417, -0.0120274, -0.0180389,  -0.0240476,  -0.0300527,
      -0.0360533, -0.0420484, -0.0480372, -0.0540188,   -0.0599923,  -0.0659567, -0.0719112,  -0.0778548,  -0.0837868,
      -0.0897061, -0.0956119, -0.101503,  -0.107379,    -0.113239,   -0.119082,  -0.124907,   -0.130713,   -0.1365,
      -0.142266,  -0.14801,   -0.153732,  -0.159431,    -0.165106,   -0.170757,  -0.176381,   -0.181979,   -0.187549,
      -0.193092,  -0.198605,  -0.204088,  -0.209541,    -0.214962,   -0.22035,   -0.225706,   -0.231027,   -0.236314,
      -0.241565,  -0.246779,  -0.251957,  -0.257096,    -0.262197,   -0.267258,  -0.27228,    -0.27726,    -0.282198,
      -0.287094,  -0.291946,  -0.296755,  -0.301519,    -0.306238,   -0.31091,   -0.315536,   -0.320114,   -0.324644,
      -0.329125,  -0.333556,  -0.337937,  -0.342267,    -0.346546,   -0.350773,  -0.354946,   -0.359067,   -0.363133,
      -0.367144,  -0.371101,  -0.375001,  -0.378845,    -0.382632,   -0.386361,  -0.390032,   -0.393644,   -0.397197,
      -0.40069,   -0.404123,  -0.407495,  -0.410806,    -0.414055,   -0.417241,  -0.420364,   -0.423425,   -0.426421,
      -0.429353,  -0.432221,  -0.435024,  -0.437761,    -0.440432,   -0.443036,  -0.445574,   -0.448045,   -0.450449,
      -0.452784,  -0.455052,  -0.457251,  -0.459381,    -0.461442,   -0.463433,  -0.465355,   -0.467206,   -0.468987,
      -0.470698,  -0.472337,  -0.473906,  -0.475403,    -0.476828,   -0.478182,  -0.479464,   -0.480673,   -0.48181,
      -0.482875,  -0.483867,  -0.484786,  -0.485632,    -0.486405,   -0.487104,  -0.48773,    -0.488283,   -0.488762,
      -0.489168,  -0.4895,    -0.489758,  -0.489943,    -0.490053,   -0.49009,   -0.490053,   -0.489943,   -0.489758,
      -0.4895,    -0.489168,  -0.488762,  -0.488283,    -0.48773,    -0.487104,  -0.486405,   -0.485632,   -0.484786,
      -0.483867,  -0.482875,  -0.48181,   -0.480673,    -0.479464,   -0.478182,  -0.476828,   -0.475403,   -0.473906,
      -0.472337,  -0.470698,  -0.468987,  -0.467206,    -0.465355,   -0.463433,  -0.461442,   -0.459381,   -0.457251,
      -0.455052,  -0.452784,  -0.450449,  -0.448045,    -0.445574,   -0.443036,  -0.440432,   -0.437761,   -0.435024,
      -0.432221,  -0.429353,  -0.426421,  -0.423425,    -0.420364,   -0.417241,  -0.414055,   -0.410806,   -0.407495,
      -0.404123,  -0.40069,   -0.397197,  -0.393644,    -0.390032,   -0.386361,  -0.382632,   -0.378845,   -0.375001,
      -0.371101,  -0.367144,  -0.363133,  -0.359067,    -0.354946,   -0.350773,  -0.346546,   -0.342267,   -0.337937,
      -0.333556,  -0.329125,  -0.324644,  -0.320114,    -0.315536,   -0.31091,   -0.306238,   -0.301519,   -0.296755,
      -0.291946,  -0.287094,  -0.282198,  -0.27726,     -0.27228,    -0.267258,  -0.262197,   -0.257096,   -0.251957,
      -0.246779,  -0.241565,  -0.236314,  -0.231027,    -0.225706,   -0.22035,   -0.214962,   -0.209541,   -0.204088,
      -0.198605,  -0.193092,  -0.187549,  -0.181979,    -0.176381,   -0.170757,  -0.165106,   -0.159431,   -0.153732,
      -0.14801,   -0.142266,  -0.1365,    -0.130713,    -0.124907,   -0.119082,  -0.113239,   -0.107379,   -0.101503,
      -0.0956119, -0.0897061, -0.0837868, -0.0778548,   -0.0719112,  -0.0659567, -0.0599923,  -0.0540188,  -0.0480372,
      -0.0420484, -0.0360533, -0.0300527, -0.0240476,   -0.0180389,  -0.0120274, -0.00601416, 7.06034e-09, 0.00601417,
      0.0120274,  0.0180389,  0.0240476,  0.0300527,    0.0360533,   0.0420484,  0.0480372,   0.0540188,   0.0599923,
      0.0659567,  0.0719112,  0.0778548,  0.0837868,    0.0897061,   0.0956119,  0.101503,    0.107379,    0.113239,
      0.119082,   0.124907,   0.130713,   0.1365,       0.142266,    0.14801,    0.153732,    0.159431,    0.165106,
      0.170757,   0.176381,   0.181979,   0.187549,     0.193092,    0.198605,   0.204088,    0.209541,    0.214962,
      0.22035,    0.225706,   0.231027,   0.236314,     0.241565,    0.246779,   0.251957,    0.257096,    0.262197,
      0.267258,   0.27228,    0.27726,    0.282198,     0.287094,    0.291946,   0.296755,    0.301519,    0.306238,
      0.31091,    0.315536,   0.320114,   0.324644,     0.329125,    0.333556,   0.337937,    0.342267},
     {0.346546,   0.350773,   0.354946,   0.359067,     0.363133,    0.367144,   0.371101,    0.375001,    0.378845,
      0.382632,   0.386361,   0.390032,   0.393644,     0.397197,    0.40069,    0.404123,    0.407495,    0.410806,
      0.414055,   0.417241,   0.420364,   0.423425,     0.426421,    0.429353,   0.432221,    0.435024,    0.437761,
      0.440432,   0.443036,   0.445574,   0.448045,     0.450449,    0.452784,   0.455052,    0.457251,    0.459381,
      0.461442,   0.463433,   0.465355,   0.467206,     0.468987,    0.470698,   0.472337,    0.473906,    0.475403,
      0.476828,   0.478182,   0.479464,   0.480673,     0.48181,     0.482875,   0.483867,    0.484786,    0.485632,
      0.486405,   0.487104,   0.48773,    0.488283,     0.488762,    0.489168,   0.4895,      0.489758,    0.489943,
      0.490053,   0.49009,    0.490053,   0.489943,     0.489758,    0.4895,     0.489168,    0.488762,    0.488283,
      0.48773,    0.487104,   0.486405,   0.485632,     0.484786,    0.483867,   0.482875,    0.48181,     0.480673,
      0.479464,   0.478182,   0.476828,   0.475403,     0.473906,    0.472337,   0.470698,    0.468987,    0.467206,
      0.465355,   0.463433,   0.461442,   0.459381,     0.457251,    0.455052,   0.452784,    0.450449,    0.448045,
      0.445574,   0.443036,   0.440432,   0.437761,     0.435024,    0.432221,   0.429353,    0.426421,    0.423425,
      0.420364,   0.417241,   0.414055,   0.410806,     0.407495,    0.404123,   0.40069,     0.397197,    0.393644,
      0.390032,   0.386361,   0.382632,   0.378845,     0.375001,    0.371101,   0.367144,    0.363133,    0.359067,
      0.354946,   0.350773,   0.346546,   0.342267,     0.337937,    0.333556,   0.329125,    0.324644,    0.320114,
      0.315536,   0.31091,    0.306238,   0.301519,     0.296755,    0.291946,   0.287094,    0.282198,    0.27726,
      0.27228,    0.267258,   0.262197,   0.257096,     0.251957,    0.246779,   0.241565,    0.236314,    0.231027,
      0.225706,   0.22035,    0.214962,   0.209541,     0.204088,    0.198605,   0.193092,    0.187549,    0.181979,
      0.176381,   0.170757,   0.165106,   0.159431,     0.153732,    0.14801,    0.142266,    0.1365,      0.130713,
      0.124907,   0.119082,   0.113239,   0.107379,     0.101503,    0.0956119,  0.0897061,   0.0837868,   0.0778548,
      0.0719112,  0.0659567,  0.0599923,  0.0540188,    0.0480372,   0.0420484,  0.0360533,   0.0300527,   0.0240476,
      0.0180389,  0.0120274,  0.00601416, -7.06034e-09, -0.00601417, -0.0120274, -0.0180389,  -0.0240476,  -0.0300527,
      -0.0360533, -0.0420484, -0.0480372, -0.0540188,   -0.0599923,  -0.0659567, -0.0719112,  -0.0778548,  -0.0837868,
      -0.0897061, -0.0956119, -0.101503,  -0.107379,    -0.113239,   -0.119082,  -0.124907,   -0.130713,   -0.1365,
      -0.142266,  -0.14801,   -0.153732,  -0.159431,    -0.165106,   -0.170757,  -0.176381,   -0.181979,   -0.187549,
      -0.193092,  -0.198605,  -0.204088,  -0.209541,    -0.214962,   -0.22035,   -0.225706,   -0.231027,   -0.236314,
      -0.241565,  -0.246779,  -0.251957,  -0.257096,    -0.262197,   -0.267258,  -0.27228,    -0.27726,    -0.282198,
      -0.287094,  -0.291946,  -0.296755,  -0.301519,    -0.306238,   -0.31091,   -0.315536,   -0.320114,   -0.324644,
      -0.329125,  -0.333556,  -0.337937,  -0.342267,    -0.346546,   -0.350773,  -0.354946,   -0.359067,   -0.363133,
      -0.367144,  -0.371101,  -0.375001,  -0.378845,    -0.382632,   -0.386361,  -0.390032,   -0.393644,   -0.397197,
      -0.40069,   -0.404123,  -0.407495,  -0.410806,    -0.414055,   -0.417241,  -0.420364,   -0.423425,   -0.426421,
      -0.429353,  -0.432221,  -0.435024,  -0.437761,    -0.440432,   -0.443036,  -0.445574,   -0.448045,   -0.450449,
      -0.452784,  -0.455052,  -0.457251,  -0.459381,    -0.461442,   -0.463433,  -0.465355,   -0.467206,   -0.468987,
      -0.470698,  -0.472337,  -0.473906,  -0.475403,    -0.476828,   -0.478182,  -0.479464,   -0.480673,   -0.48181,
      -0.482875,  -0.483867,  -0.484786,  -0.485632,    -0.486405,   -0.487104,  -0.48773,    -0.488283,   -0.488762,
      -0.489168,  -0.4895,    -0.489758,  -0.489943,    -0.490053,   -0.49009,   -0.490053,   -0.489943,   -0.489758,
      -0.4895,    -0.489168,  -0.488762,  -0.488283,    -0.48773,    -0.487104,  -0.486405,   -0.485632,   -0.484786,
      -0.483867,  -0.482875,  -0.48181,   -0.480673,    -0.479464,   -0.478182,  -0.476828,   -0.475403,   -0.473906,
      -0.472337,  -0.470698,  -0.468987,  -0.467206,    -0.465355,   -0.463433,  -0.461442,   -0.459381,   -0.457251,
      -0.455052,  -0.452784,  -0.450449,  -0.448045,    -0.445574,   -0.443036,  -0.440432,   -0.437761,   -0.435024,
      -0.432221,  -0.429353,  -0.426421,  -0.423425,    -0.420364,   -0.417241,  -0.414055,   -0.410806,   -0.407495,
      -0.404123,  -0.40069,   -0.397197,  -0.393644,    -0.390032,   -0.386361,  -0.382632,   -0.378845,   -0.375001,
      -0.371101,  -0.367144,  -0.363133,  -0.359067,    -0.354946,   -0.350773,  -0.346546,   -0.342267,   -0.337937,
      -0.333556,  -0.329125,  -0.324644,  -0.320114,    -0.315536,   -0.31091,   -0.306238,   -0.301519,   -0.296755,
      -0.291946,  -0.287094,  -0.282198,  -0.27726,     -0.27228,    -0.267258,  -0.262197,   -0.257096,   -0.251957,
      -0.246779,  -0.241565,  -0.236314,  -0.231027,    -0.225706,   -0.22035,   -0.214962,   -0.209541,   -0.204088,
      -0.198605,  -0.193092,  -0.187549,  -0.181979,    -0.176381,   -0.170757,  -0.165106,   -0.159431,   -0.153732,
      -0.14801,   -0.142266,  -0.1365,    -0.130713,    -0.124907,   -0.119082,  -0.113239,   -0.107379,   -0.101503,
      -0.0956119, -0.0897061, -0.0837868, -0.0778548,   -0.0719112,  -0.0659567, -0.0599923,  -0.0540188,  -0.0480372,
      -0.0420484, -0.0360533, -0.0300527, -0.0240476,   -0.0180389,  -0.0120274, -0.00601416, 7.06034e-09, 0.00601417,
      0.0120274,  0.0180389,  0.0240476,  0.0300527,    0.0360533,   0.0420484,  0.0480372,   0.0540188,   0.0599923,
      0.0659567,  0.0719112,  0.0778548,  0.0837868,    0.0897061,   0.0956119,  0.101503,    0.107379,    0.113239,
      0.119082,   0.124907,   0.130713,   0.1365,       0.142266,    0.14801,    0.153732,    0.159431,    0.165106,
      0.170757,   0.176381,   0.181979,   0.187549,     0.193092,    0.198605,   0.204088,    0.209541,    0.214962,
      0.22035,    0.225706,   0.231027,   0.236314,     0.241565,    0.246779,   0.251957,    0.257096,    0.262197,
      0.267258,   0.27228,    0.27726,    0.282198,     0.287094,    0.291946,   0.296755,    0.301519,    0.306238,
      0.31091,    0.315536,   0.320114,   0.324644,     0.329125,    0.333556,   0.337937,    0.342267}},
    {{0.355244,   0.918814,  0.784554,  0.865222,  0.806909,  0.852924,  0.814688,   0.847568,  0.818594,   0.844602,
      0.820921,   0.842731,  0.82245,   0.841462,  0.82352,   0.840552,  0.824298,   0.839882,  0.824878,   0.839379,
      0.825318,   0.838996,  0.82565,   0.838706,  0.825899,  0.838492,  0.826082,   0.83834,   0.826206,   0.838243,
      0.826278,   0.838195,  0.8263,    0.838195,  0.826278,  0.838243,  0.826206,   0.838341,  0.826081,   0.838492,
      0.825901,   0.838706,  0.825649,  0.838995,  0.825317,  0.839377,  0.824879,   0.839883,  0.824297,   0.840553,
      0.823519,   0.841461,  0.822451,  0.842732,  0.820921,  0.844601,  0.818594,   0.84757,   0.814687,   0.852924,
      0.806911,   0.865224,  0.784554,  0.918814,  0.355251,  -0.202606, -0.0740595, -0.149008, -0.0964237, -0.136699,
      -0.104216,  -0.131325, -0.108142, -0.128333, -0.110498, -0.126431, -0.112062,  -0.125123, -0.113172,  -0.124169,
      -0.114001,  -0.123447, -0.114639, -0.12288,  -0.115144, -0.122425, -0.115553,  -0.122052, -0.115894,  -0.121743,
      -0.116178,  -0.12148,  -0.116418, -0.121258, -0.116626, -0.121066, -0.116804,  -0.120899, -0.11696,   -0.12075,
      -0.117099,  -0.120624, -0.117221, -0.120509, -0.117328, -0.120405, -0.117426,  -0.120312, -0.117513,  -0.120229,
      -0.117592,  -0.120154, -0.117663, -0.120088, -0.117728, -0.120025, -0.117788,  -0.119969, -0.117842,  -0.119918,
      -0.117892,  -0.119869, -0.117937, -0.119825, -0.117979, -0.119784, -0.118019,  -0.119745, -0.118055,  -0.119711,
      -0.11809,   -0.119678, -0.118121, -0.119649, -0.11815,  -0.11962,  -0.118178,  -0.119594, -0.118204,  -0.119569,
      -0.118228,  -0.119547, -0.11825,  -0.119523, -0.118272, -0.119502, -0.118292,  -0.119485, -0.11831,   -0.119465,
      -0.118328,  -0.119449, -0.118343, -0.119432, -0.118359, -0.119415, -0.118374,  -0.119402, -0.118388,  -0.119388,
      -0.118401,  -0.119375, -0.118415, -0.119363, -0.118428, -0.119351, -0.118438,  -0.119341, -0.118448,  -0.119329,
      -0.11846,   -0.11932,  -0.118469, -0.119311, -0.118478, -0.119301, -0.118489,  -0.119291, -0.118495,  -0.119283,
      -0.118504,  -0.119277, -0.118511, -0.119269, -0.118521, -0.119262, -0.118528,  -0.119255, -0.118535,  -0.119249,
      -0.118541,  -0.119242, -0.118546, -0.119235, -0.118552, -0.119231, -0.118558,  -0.119223, -0.118561,  -0.119219,
      -0.118569,  -0.119214, -0.118573, -0.119209, -0.118576, -0.119205, -0.118581,  -0.119201, -0.118586,  -0.119197,
      -0.118591,  -0.119193, -0.118594, -0.119188, -0.118599, -0.119184, -0.118602,  -0.119181, -0.118605,  -0.119179,
      -0.118608,  -0.119174, -0.118612, -0.119171, -0.118615, -0.119167, -0.118618,  -0.119165, -0.118621,  -0.119162,
      -0.118624,  -0.119161, -0.118625, -0.119157, -0.118627, -0.119156, -0.11863,   -0.119152, -0.118632,  -0.119151,
      -0.118634,  -0.119149, -0.118637, -0.119147, -0.118637, -0.119144, -0.11864,   -0.119143, -0.118641,  -0.119142,
      -0.118642,  -0.119141, -0.118645, -0.119139, -0.118647, -0.119139, -0.118645,  -0.119137, -0.118648,  -0.119134,
      -0.118649,  -0.119135, -0.11865,  -0.119133, -0.118651, -0.119133, -0.118652,  -0.119132, -0.118653,  -0.119132,
      -0.118654,  -0.11913,  -0.118653, -0.11913,  -0.118655, -0.119129, -0.118656,  -0.119129, -0.118656,  -0.119128,
      -0.118657,  -0.119128, -0.118658, -0.119128, -0.118657, -0.119128, -0.118658,  -0.119127, -0.118657,  -0.119127,
      -0.118657,  -0.119128, -0.118657, -0.119128, -0.118658, -0.119126, -0.118657,  -0.119128, -0.118656,  -0.119128,
      -0.118656,  -0.119129, -0.118656, -0.119131, -0.118655, -0.11913,  -0.118654,  -0.119131, -0.118653,  -0.119132,
      -0.118651,  -0.119132, -0.118652, -0.119134, -0.118651, -0.119136, -0.11865,   -0.119134, -0.118648,  -0.119137,
      -0.118647,  -0.119138, -0.118646, -0.119139, -0.118644, -0.11914,  -0.118644,  -0.119142, -0.118642,  -0.119143,
      -0.11864,   -0.119146, -0.118638, -0.119146, -0.118636, -0.119149, -0.118634,  -0.119151, -0.118632,  -0.119153,
      -0.11863,   -0.119155, -0.118628, -0.119157, -0.118625, -0.119159, -0.118623,  -0.119163, -0.118622,  -0.119166,
      -0.118617,  -0.119169, -0.118615, -0.119172, -0.118612, -0.119174, -0.118608,  -0.119177, -0.118604,  -0.119181,
      -0.118602,  -0.119186, -0.118598, -0.119188, -0.118595, -0.119193, -0.11859,   -0.119196, -0.118587,  -0.1192,
      -0.118582,  -0.119205, -0.118578, -0.119209, -0.118574, -0.119214, -0.118569,  -0.119218, -0.118563,  -0.119223,
      -0.118558,  -0.11923,  -0.118552, -0.119236, -0.118545, -0.119242, -0.118539,  -0.119248, -0.118533,  -0.119255,
      -0.118527,  -0.119262, -0.11852,  -0.119269, -0.118512, -0.119276, -0.118505,  -0.119283, -0.118496,  -0.119292,
      -0.118488,  -0.119301, -0.118478, -0.11931,  -0.11847,  -0.11932,  -0.118459,  -0.119331, -0.118448,  -0.11934,
      -0.118439,  -0.119352, -0.118427, -0.119362, -0.118415, -0.119375, -0.118403,  -0.119389, -0.118389,  -0.119403,
      -0.118374,  -0.119416, -0.118359, -0.119431, -0.118345, -0.119448, -0.118327,  -0.119466, -0.118309,  -0.119484,
      -0.118291,  -0.119502, -0.118271, -0.119524, -0.118251, -0.119546, -0.118228,  -0.119568, -0.118203,  -0.119594,
      -0.118178,  -0.119621, -0.11815,  -0.119647, -0.118122, -0.119678, -0.118088,  -0.119711, -0.118056,  -0.119746,
      -0.118019,  -0.119783, -0.11798,  -0.119824, -0.117939, -0.119868, -0.117892,  -0.119917, -0.117842,  -0.119969,
      -0.117788,  -0.120025, -0.11773,  -0.120087, -0.117663, -0.120155, -0.117591,  -0.120231, -0.117514,  -0.120315,
      -0.117426,  -0.120406, -0.117328, -0.120508, -0.117221, -0.120622, -0.1171,    -0.120753, -0.116961,  -0.120898,
      -0.116805,  -0.121066, -0.116626, -0.121258, -0.116419, -0.121481, -0.116176,  -0.121742, -0.115894,  -0.122052,
      -0.115555,  -0.122425, -0.115144, -0.122879, -0.114638, -0.123447, -0.113998,  -0.12417,  -0.113171,  -0.125123,
      -0.112061,  -0.126432, -0.110499, -0.128331, -0.108143, -0.131325, -0.104216,  -0.136699, -0.0964222, -0.149009,
      -0.0740595, -0.202604},
     {0.355244,   0.918814,  0.784554,  0.865222,  0.806909,  0.852924,  0.814688,   0.847568,  0.818594,   0.844602,
      0.820921,   0.842731,  0.82245,   0.841462,  0.82352,   0.840552,  0.824298,   0.839882,  0.824878,   0.839379,
      0.825318,   0.838996,  0.82565,   0.838706,  0.825899,  0.838492,  0.826082,   0.83834,   0.826206,   0.838243,
      0.826278,   0.838195,  0.8263,    0.838195,  0.826278,  0.838243,  0.826206,   0.838341,  0.826081,   0.838492,
      0.825901,   0.838706,  0.825649,  0.838995,  0.825317,  0.839377,  0.824879,   0.839883,  0.824297,   0.840553,
      0.823519,   0.841461,  0.822451,  0.842732,  0.820921,  0.844601,  0.818594,   0.84757,   0.814687,   0.852924,
      0.806911,   0.865224,  0.784554,  0.918814,  0.355251,  -0.202606, -0.0740595, -0.149008, -0.0964237, -0.136699,
      -0.104216,  -0.131325, -0.108142, -0.128333, -0.110498, -0.126431, -0.112062,  -0.125123, -0.113172,  -0.124169,
      -0.114001,  -0.123447, -0.114639, -0.12288,  -0.115144, -0.122425, -0.115553,  -0.122052, -0.115894,  -0.121743,
      -0.116178,  -0.12148,  -0.116418, -0.121258, -0.116626, -0.121066, -0.116804,  -0.120899, -0.11696,   -0.12075,
      -0.117099,  -0.120624, -0.117221, -0.120509, -0.117328, -0.120405, -0.117426,  -0.120312, -0.117513,  -0.120229,
      -0.117592,  -0.120154, -0.117663, -0.120088, -0.117728, -0.120025, -0.117788,  -0.119969, -0.117842,  -0.119918,
      -0.117892,  -0.119869, -0.117937, -0.119825, -0.117979, -0.119784, -0.118019,  -0.119745, -0.118055,  -0.119711,
      -0.11809,   -0.119678, -0.118121, -0.119649, -0.11815,  -0.11962,  -0.118178,  -0.119594, -0.118204,  -0.119569,
      -0.118228,  -0.119547, -0.11825,  -0.119523, -0.118272, -0.119502, -0.118292,  -0.119485, -0.11831,   -0.119465,
      -0.118328,  -0.119449, -0.118343, -0.119432, -0.118359, -0.119415, -0.118374,  -0.119402, -0.118388,  -0.119388,
      -0.118401,  -0.119375, -0.118415, -0.119363, -0.118428, -0.119351, -0.118438,  -0.119341, -0.118448,  -0.119329,
      -0.11846,   -0.11932,  -0.118469, -0.119311, -0.118478, -0.119301, -0.118489,  -0.119291, -0.118495,  -0.119283,
      -0.118504,  -0.119277, -0.118511, -0.119269, -0.118521, -0.119262, -0.118528,  -0.119255, -0.118535,  -0.119249,
      -0.118541,  -0.119242, -0.118546, -0.119235, -0.118552, -0.119231, -0.118558,  -0.119223, -0.118561,  -0.119219,
      -0.118569,  -0.119214, -0.118573, -0.119209, -0.118576, -0.119205, -0.118581,  -0.119201, -0.118586,  -0.119197,
      -0.118591,  -0.119193, -0.118594, -0.119188, -0.118599, -0.119184, -0.118602,  -0.119181, -0.118605,  -0.119179,
      -0.118608,  -0.119174, -0.118612, -0.119171, -0.118615, -0.119167, -0.118618,  -0.119165, -0.118621,  -0.119162,
      -0.118624,  -0.119161, -0.118625, -0.119157, -0.118627, -0.119156, -0.11863,   -0.119152, -0.118632,  -0.119151,
      -0.118634,  -0.119149, -0.118637, -0.119147, -0.118637, -0.119144, -0.11864,   -0.119143, -0.118641,  -0.119142,
      -0.118642,  -0.119141, -0.118645, -0.119139, -0.118647, -0.119139, -0.118645,  -0.119137, -0.118648,  -0.119134,
      -0.118649,  -0.119135, -0.11865,  -0.119133, -0.118651, -0.119133, -0.118652,  -0.119132, -0.118653,  -0.119132,
      -0.118654,  -0.11913,  -0.118653, -0.11913,  -0.118655, -0.119129, -0.118656,  -0.119129, -0.118656,  -0.119128,
      -0.118657,  -0.119128, -0.118658, -0.119128, -0.118657, -0.119128, -0.118658,  -0.119127, -0.118657,  -0.119127,
      -0.118657,  -0.119128, -0.118657, -0.119128, -0.118658, -0.119126, -0.118657,  -0.119128, -0.118656,  -0.119128,
      -0.118656,  -0.119129, -0.118656, -0.119131, -0.118655, -0.11913,  -0.118654,  -0.119131, -0.118653,  -0.119132,
      -0.118651,  -0.119132, -0.118652, -0.119134, -0.118651, -0.119136, -0.11865,   -0.119134, -0.118648,  -0.119137,
      -0.118647,  -0.119138, -0.118646, -0.119139, -0.118644, -0.11914,  -0.118644,  -0.119142, -0.118642,  -0.119143,
      -0.11864,   -0.119146, -0.118638, -0.119146, -0.118636, -0.119149, -0.118634,  -0.119151, -0.118632,  -0.119153,
      -0.11863,   -0.119155, -0.118628, -0.119157, -0.118625, -0.119159, -0.118623,  -0.119163, -0.118622,  -0.119166,
      -0.118617,  -0.119169, -0.118615, -0.119172, -0.118612, -0.119174, -0.118608,  -0.119177, -0.118604,  -0.119181,
      -0.118602,  -0.119186, -0.118598, -0.119188, -0.118595, -0.119193, -0.11859,   -0.119196, -0.118587,  -0.1192,
      -0.118582,  -0.119205, -0.118578, -0.119209, -0.118574, -0.119214, -0.118569,  -0.119218, -0.118563,  -0.119223,
      -0.118558,  -0.11923,  -0.118552, -0.119236, -0.118545, -0.119242, -0.118539,  -0.119248, -0.118533,  -0.119255,
      -0.118527,  -0.119262, -0.11852,  -0.119269, -0.118512, -0.119276, -0.118505,  -0.119283, -0.118496,  -0.119292,
      -0.118488,  -0.119301, -0.118478, -0.11931,  -0.11847,  -0.11932,  -0.118459,  -0.119331, -0.118448,  -0.11934,
      -0.118439,  -0.119352, -0.118427, -0.119362, -0.118415, -0.119375, -0.118403,  -0.119389, -0.118389,  -0.119403,
      -0.118374,  -0.119416, -0.118359, -0.119431, -0.118345, -0.119448, -0.118327,  -0.119466, -0.118309,  -0.119484,
      -0.118291,  -0.119502, -0.118271, -0.119524, -0.118251, -0.119546, -0.118228,  -0.119568, -0.118203,  -0.119594,
      -0.118178,  -0.119621, -0.11815,  -0.119647, -0.118122, -0.119678, -0.118088,  -0.119711, -0.118056,  -0.119746,
      -0.118019,  -0.119783, -0.11798,  -0.119824, -0.117939, -0.119868, -0.117892,  -0.119917, -0.117842,  -0.119969,
      -0.117788,  -0.120025, -0.11773,  -0.120087, -0.117663, -0.120155, -0.117591,  -0.120231, -0.117514,  -0.120315,
      -0.117426,  -0.120406, -0.117328, -0.120508, -0.117221, -0.120622, -0.1171,    -0.120753, -0.116961,  -0.120898,
      -0.116805,  -0.121066, -0.116626, -0.121258, -0.116419, -0.121481, -0.116176,  -0.121742, -0.115894,  -0.122052,
      -0.115555,  -0.122425, -0.115144, -0.122879, -0.114638, -0.123447, -0.113998,  -0.12417,  -0.113171,  -0.125123,
      -0.112061,  -0.126432, -0.110499, -0.128331, -0.108143, -0.131325, -0.104216,  -0.136699, -0.0964222, -0.149009,
      -0.0740595, -0.202604},
     {0.355244,   0.918814,  0.784554,  0.865222,  0.806909,  0.852924,  0.814688,   0.847568,  0.818594,   0.844602,
      0.820921,   0.842731,  0.82245,   0.841462,  0.82352,   0.840552,  0.824298,   0.839882,  0.824878,   0.839379,
      0.825318,   0.838996,  0.82565,   0.838706,  0.825899,  0.838492,  0.826082,   0.83834,   0.826206,   0.838243,
      0.826278,   0.838195,  0.8263,    0.838195,  0.826278,  0.838243,  0.826206,   0.838341,  0.826081,   0.838492,
      0.825901,   0.838706,  0.825649,  0.838995,  0.825317,  0.839377,  0.824879,   0.839883,  0.824297,   0.840553,
      0.823519,   0.841461,  0.822451,  0.842732,  0.820921,  0.844601,  0.818594,   0.84757,   0.814687,   0.852924,
      0.806911,   0.865224,  0.784554,  0.918814,  0.355251,  -0.202606, -0.0740595, -0.149008, -0.0964237, -0.136699,
      -0.104216,  -0.131325, -0.108142, -0.128333, -0.110498, -0.126431, -0.112062,  -0.125123, -0.113172,  -0.124169,
      -0.114001,  -0.123447, -0.114639, -0.12288,  -0.115144, -0.122425, -0.115553,  -0.122052, -0.115894,  -0.121743,
      -0.116178,  -0.12148,  -0.116418, -0.121258, -0.116626, -0.121066, -0.116804,  -0.120899, -0.11696,   -0.12075,
      -0.117099,  -0.120624, -0.117221, -0.120509, -0.117328, -0.120405, -0.117426,  -0.120312, -0.117513,  -0.120229,
      -0.117592,  -0.120154, -0.117663, -0.120088, -0.117728, -0.120025, -0.117788,  -0.119969, -0.117842,  -0.119918,
      -0.117892,  -0.119869, -0.117937, -0.119825, -0.117979, -0.119784, -0.118019,  -0.119745, -0.118055,  -0.119711,
      -0.11809,   -0.119678, -0.118121, -0.119649, -0.11815,  -0.11962,  -0.118178,  -0.119594, -0.118204,  -0.119569,
      -0.118228,  -0.119547, -0.11825,  -0.119523, -0.118272, -0.119502, -0.118292,  -0.119485, -0.11831,   -0.119465,
      -0.118328,  -0.119449, -0.118343, -0.119432, -0.118359, -0.119415, -0.118374,  -0.119402, -0.118388,  -0.119388,
      -0.118401,  -0.119375, -0.118415, -0.119363, -0.118428, -0.119351, -0.118438,  -0.119341, -0.118448,  -0.119329,
      -0.11846,   -0.11932,  -0.118469, -0.119311, -0.118478, -0.119301, -0.118489,  -0.119291, -0.118495,  -0.119283,
      -0.118504,  -0.119277, -0.118511, -0.119269, -0.118521, -0.119262, -0.118528,  -0.119255, -0.118535,  -0.119249,
      -0.118541,  -0.119242, -0.118546, -0.119235, -0.118552, -0.119231, -0.118558,  -0.119223, -0.118561,  -0.119219,
      -0.118569,  -0.119214, -0.118573, -0.119209, -0.118576, -0.119205, -0.118581,  -0.119201, -0.118586,  -0.119197,
      -0.118591,  -0.119193, -0.118594, -0.119188, -0.118599, -0.119184, -0.118602,  -0.119181, -0.118605,  -0.119179,
      -0.118608,  -0.119174, -0.118612, -0.119171, -0.118615, -0.119167, -0.118618,  -0.119165, -0.118621,  -0.119162,
      -0.118624,  -0.119161, -0.118625, -0.119157, -0.118627, -0.119156, -0.11863,   -0.119152, -0.118632,  -0.119151,
      -0.118634,  -0.119149, -0.118637, -0.119147, -0.118637, -0.119144, -0.11864,   -0.119143, -0.118641,  -0.119142,
      -0.118642,  -0.119141, -0.118645, -0.119139, -0.118647, -0.119139, -0.118645,  -0.119137, -0.118648,  -0.119134,
      -0.118649,  -0.119135, -0.11865,  -0.119133, -0.118651, -0.119133, -0.118652,  -0.119132, -0.118653,  -0.119132,
      -0.118654,  -0.11913,  -0.118653, -0.11913,  -0.118655, -0.119129, -0.118656,  -0.119129, -0.118656,  -0.119128,
      -0.118657,  -0.119128, -0.118658, -0.119128, -0.118657, -0.119128, -0.118658,  -0.119127, -0.118657,  -0.119127,
      -0.118657,  -0.119128, -0.118657, -0.119128, -0.118658, -0.119126, -0.118657,  -0.119128, -0.118656,  -0.119128,
      -0.118656,  -0.119129, -0.118656, -0.119131, -0.118655, -0.11913,  -0.118654,  -0.119131, -0.118653,  -0.119132,
      -0.118651,  -0.119132, -0.118652, -0.119134, -0.118651, -0.119136, -0.11865,   -0.119134, -0.118648,  -0.119137,
      -0.118647,  -0.119138, -0.118646, -0.119139, -0.118644, -0.11914,  -0.118644,  -0.119142, -0.118642,  -0.119143,
      -0.11864,   -0.119146, -0.118638, -0.119146, -0.118636, -0.119149, -0.118634,  -0.119151, -0.118632,  -0.119153,
      -0.11863,   -0.119155, -0.118628, -0.119157, -0.118625, -0.119159, -0.118623,  -0.119163, -0.118622,  -0.119166,
      -0.118617,  -0.119169, -0.118615, -0.119172, -0.118612, -0.119174, -0.118608,  -0.119177, -0.118604,  -0.119181,
      -0.118602,  -0.119186, -0.118598, -0.119188, -0.118595, -0.119193, -0.11859,   -0.119196, -0.118587,  -0.1192,
      -0.118582,  -0.119205, -0.118578, -0.119209, -0.118574, -0.119214, -0.118569,  -0.119218, -0.118563,  -0.119223,
      -0.118558,  -0.11923,  -0.118552, -0.119236, -0.118545, -0.119242, -0.118539,  -0.119248, -0.118533,  -0.119255,
      -0.118527,  -0.119262, -0.11852,  -0.119269, -0.118512, -0.119276, -0.118505,  -0.119283, -0.118496,  -0.119292,
      -0.118488,  -0.119301, -0.118478, -0.11931,  -0.11847,  -0.11932,  -0.118459,  -0.119331, -0.118448,  -0.11934,
      -0.118439,  -0.119352, -0.118427, -0.119362, -0.118415, -0.119375, -0.118403,  -0.119389, -0.118389,  -0.119403,
      -0.118374,  -0.119416, -0.118359, -0.119431, -0.118345, -0.119448, -0.118327,  -0.119466, -0.118309,  -0.119484,
      -0.118291,  -0.119502, -0.118271, -0.119524, -0.118251, -0.119546, -0.118228,  -0.119568, -0.118203,  -0.119594,
      -0.118178,  -0.119621, -0.11815,  -0.119647, -0.118122, -0.119678, -0.118088,  -0.119711, -0.118056,  -0.119746,
      -0.118019,  -0.119783, -0.11798,  -0.119824, -0.117939, -0.119868, -0.117892,  -0.119917, -0.117842,  -0.119969,
      -0.117788,  -0.120025, -0.11773,  -0.120087, -0.117663, -0.120155, -0.117591,  -0.120231, -0.117514,  -0.120315,
      -0.117426,  -0.120406, -0.117328, -0.120508, -0.117221, -0.120622, -0.1171,    -0.120753, -0.116961,  -0.120898,
      -0.116805,  -0.121066, -0.116626, -0.121258, -0.116419, -0.121481, -0.116176,  -0.121742, -0.115894,  -0.122052,
      -0.115555,  -0.122425, -0.115144, -0.122879, -0.114638, -0.123447, -0.113998,  -0.12417,  -0.113171,  -0.125123,
      -0.112061,  -0.126432, -0.110499, -0.128331, -0.108143, -0.131325, -0.104216,  -0.136699, -0.0964222, -0.149009,
      -0.0740595, -0.202604},
     {0.355244,   0.918814,  0.784554,  0.865222,  0.806909,  0.852924,  0.814688,   0.847568,  0.818594,   0.844602,
      0.820921,   0.842731,  0.82245,   0.841462,  0.82352,   0.840552,  0.824298,   0.839882,  0.824878,   0.839379,
      0.825318,   0.838996,  0.82565,   0.838706,  0.825899,  0.838492,  0.826082,   0.83834,   0.826206,   0.838243,
      0.826278,   0.838195,  0.8263,    0.838195,  0.826278,  0.838243,  0.826206,   0.838341,  0.826081,   0.838492,
      0.825901,   0.838706,  0.825649,  0.838995,  0.825317,  0.839377,  0.824879,   0.839883,  0.824297,   0.840553,
      0.823519,   0.841461,  0.822451,  0.842732,  0.820921,  0.844601,  0.818594,   0.84757,   0.814687,   0.852924,
      0.806911,   0.865224,  0.784554,  0.918814,  0.355251,  -0.202606, -0.0740595, -0.149008, -0.0964237, -0.136699,
      -0.104216,  -0.131325, -0.108142, -0.128333, -0.110498, -0.126431, -0.112062,  -0.125123, -0.113172,  -0.124169,
      -0.114001,  -0.123447, -0.114639, -0.12288,  -0.115144, -0.122425, -0.115553,  -0.122052, -0.115894,  -0.121743,
      -0.116178,  -0.12148,  -0.116418, -0.121258, -0.116626, -0.121066, -0.116804,  -0.120899, -0.11696,   -0.12075,
      -0.117099,  -0.120624, -0.117221, -0.120509, -0.117328, -0.120405, -0.117426,  -0.120312, -0.117513,  -0.120229,
      -0.117592,  -0.120154, -0.117663, -0.120088, -0.117728, -0.120025, -0.117788,  -0.119969, -0.117842,  -0.119918,
      -0.117892,  -0.119869, -0.117937, -0.119825, -0.117979, -0.119784, -0.118019,  -0.119745, -0.118055,  -0.119711,
      -0.11809,   -0.119678, -0.118121, -0.119649, -0.11815,  -0.11962,  -0.118178,  -0.119594, -0.118204,  -0.119569,
      -0.118228,  -0.119547, -0.11825,  -0.119523, -0.118272, -0.119502, -0.118292,  -0.119485, -0.11831,   -0.119465,
      -0.118328,  -0.119449, -0.118343, -0.119432, -0.118359, -0.119415, -0.118374,  -0.119402, -0.118388,  -0.119388,
      -0.118401,  -0.119375, -0.118415, -0.119363, -0.118428, -0.119351, -0.118438,  -0.119341, -0.118448,  -0.119329,
      -0.11846,   -0.11932,  -0.118469, -0.119311, -0.118478, -0.119301, -0.118489,  -0.119291, -0.118495,  -0.119283,
      -0.118504,  -0.119277, -0.118511, -0.119269, -0.118521, -0.119262, -0.118528,  -0.119255, -0.118535,  -0.119249,
      -0.118541,  -0.119242, -0.118546, -0.119235, -0.118552, -0.119231, -0.118558,  -0.119223, -0.118561,  -0.119219,
      -0.118569,  -0.119214, -0.118573, -0.119209, -0.118576, -0.119205, -0.118581,  -0.119201, -0.118586,  -0.119197,
      -0.118591,  -0.119193, -0.118594, -0.119188, -0.118599, -0.119184, -0.118602,  -0.119181, -0.118605,  -0.119179,
      -0.118608,  -0.119174, -0.118612, -0.119171, -0.118615, -0.119167, -0.118618,  -0.119165, -0.118621,  -0.119162,
      -0.118624,  -0.119161, -0.118625, -0.119157, -0.118627, -0.119156, -0.11863,   -0.119152, -0.118632,  -0.119151,
      -0.118634,  -0.119149, -0.118637, -0.119147, -0.118637, -0.119144, -0.11864,   -0.119143, -0.118641,  -0.119142,
      -0.118642,  -0.119141, -0.118645, -0.119139, -0.118647, -0.119139, -0.118645,  -0.119137, -0.118648,  -0.119134,
      -0.118649,  -0.119135, -0.11865,  -0.119133, -0.118651, -0.119133, -0.118652,  -0.119132, -0.118653,  -0.119132,
      -0.118654,  -0.11913,  -0.118653, -0.11913,  -0.118655, -0.119129, -0.118656,  -0.119129, -0.118656,  -0.119128,
      -0.118657,  -0.119128, -0.118658, -0.119128, -0.118657, -0.119128, -0.118658,  -0.119127, -0.118657,  -0.119127,
      -0.118657,  -0.119128, -0.118657, -0.119128, -0.118658, -0.119126, -0.118657,  -0.119128, -0.118656,  -0.119128,
      -0.118656,  -0.119129, -0.118656, -0.119131, -0.118655, -0.11913,  -0.118654,  -0.119131, -0.118653,  -0.119132,
      -0.118651,  -0.119132, -0.118652, -0.119134, -0.118651, -0.119136, -0.11865,   -0.119134, -0.118648,  -0.119137,
      -0.118647,  -0.119138, -0.118646, -0.119139, -0.118644, -0.11914,  -0.118644,  -0.119142, -0.118642,  -0.119143,
      -0.11864,   -0.119146, -0.118638, -0.119146, -0.118636, -0.119149, -0.118634,  -0.119151, -0.118632,  -0.119153,
      -0.11863,   -0.119155, -0.118628, -0.119157, -0.118625, -0.119159, -0.118623,  -0.119163, -0.118622,  -0.119166,
      -0.118617,  -0.119169, -0.118615, -0.119172, -0.118612, -0.119174, -0.118608,  -0.119177, -0.118604,  -0.119181,
      -0.118602,  -0.119186, -0.118598, -0.119188, -0.118595, -0.119193, -0.11859,   -0.119196, -0.118587,  -0.1192,
      -0.118582,  -0.119205, -0.118578, -0.119209, -0.118574, -0.119214, -0.118569,  -0.119218, -0.118563,  -0.119223,
      -0.118558,  -0.11923,  -0.118552, -0.119236, -0.118545, -0.119242, -0.118539,  -0.119248, -0.118533,  -0.119255,
      -0.118527,  -0.119262, -0.11852,  -0.119269, -0.118512, -0.119276, -0.118505,  -0.119283, -0.118496,  -0.119292,
      -0.118488,  -0.119301, -0.118478, -0.11931,  -0.11847,  -0.11932,  -0.118459,  -0.119331, -0.118448,  -0.11934,
      -0.118439,  -0.119352, -0.118427, -0.119362, -0.118415, -0.119375, -0.118403,  -0.119389, -0.118389,  -0.119403,
      -0.118374,  -0.119416, -0.118359, -0.119431, -0.118345, -0.119448, -0.118327,  -0.119466, -0.118309,  -0.119484,
      -0.118291,  -0.119502, -0.118271, -0.119524, -0.118251, -0.119546, -0.118228,  -0.119568, -0.118203,  -0.119594,
      -0.118178,  -0.119621, -0.11815,  -0.119647, -0.118122, -0.119678, -0.118088,  -0.119711, -0.118056,  -0.119746,
      -0.118019,  -0.119783, -0.11798,  -0.119824, -0.117939, -0.119868, -0.117892,  -0.119917, -0.117842,  -0.119969,
      -0.117788,  -0.120025, -0.11773,  -0.120087, -0.117663, -0.120155, -0.117591,  -0.120231, -0.117514,  -0.120315,
      -0.117426,  -0.120406, -0.117328, -0.120508, -0.117221, -0.120622, -0.1171,    -0.120753, -0.116961,  -0.120898,
      -0.116805,  -0.121066, -0.116626, -0.121258, -0.116419, -0.121481, -0.116176,  -0.121742, -0.115894,  -0.122052,
      -0.115555,  -0.122425, -0.115144, -0.122879, -0.114638, -0.123447, -0.113998,  -0.12417,  -0.113171,  -0.125123,
      -0.112061,  -0.126432, -0.110499, -0.128331, -0.108143, -0.131325, -0.104216,  -0.136699, -0.0964222, -0.149009,
      -0.0740595, -0.202604},
     {0.355244,   0.918814,  0.784554,  0.865222,  0.806909,  0.852924,  0.814688,   0.847568,  0.818594,   0.844602,
      0.820921,   0.842731,  0.82245,   0.841462,  0.82352,   0.840552,  0.824298,   0.839882,  0.824878,   0.839379,
      0.825318,   0.838996,  0.82565,   0.838706,  0.825899,  0.838492,  0.826082,   0.83834,   0.826206,   0.838243,
      0.826278,   0.838195,  0.8263,    0.838195,  0.826278,  0.838243,  0.826206,   0.838341,  0.826081,   0.838492,
      0.825901,   0.838706,  0.825649,  0.838995,  0.825317,  0.839377,  0.824879,   0.839883,  0.824297,   0.840553,
      0.823519,   0.841461,  0.822451,  0.842732,  0.820921,  0.844601,  0.818594,   0.84757,   0.814687,   0.852924,
      0.806911,   0.865224,  0.784554,  0.918814,  0.355251,  -0.202606, -0.0740595, -0.149008, -0.0964237, -0.136699,
      -0.104216,  -0.131325, -0.108142, -0.128333, -0.110498, -0.126431, -0.112062,  -0.125123, -0.113172,  -0.124169,
      -0.114001,  -0.123447, -0.114639, -0.12288,  -0.115144, -0.122425, -0.115553,  -0.122052, -0.115894,  -0.121743,
      -0.116178,  -0.12148,  -0.116418, -0.121258, -0.116626, -0.121066, -0.116804,  -0.120899, -0.11696,   -0.12075,
      -0.117099,  -0.120624, -0.117221, -0.120509, -0.117328, -0.120405, -0.117426,  -0.120312, -0.117513,  -0.120229,
      -0.117592,  -0.120154, -0.117663, -0.120088, -0.117728, -0.120025, -0.117788,  -0.119969, -0.117842,  -0.119918,
      -0.117892,  -0.119869, -0.117937, -0.119825, -0.117979, -0.119784, -0.118019,  -0.119745, -0.118055,  -0.119711,
      -0.11809,   -0.119678, -0.118121, -0.119649, -0.11815,  -0.11962,  -0.118178,  -0.119594, -0.118204,  -0.119569,
      -0.118228,  -0.119547, -0.11825,  -0.119523, -0.118272, -0.119502, -0.118292,  -0.119485, -0.11831,   -0.119465,
      -0.118328,  -0.119449, -0.118343, -0.119432, -0.118359, -0.119415, -0.118374,  -0.119402, -0.118388,  -0.119388,
      -0.118401,  -0.119375, -0.118415, -0.119363, -0.118428, -0.119351, -0.118438,  -0.119341, -0.118448,  -0.119329,
      -0.11846,   -0.11932,  -0.118469, -0.119311, -0.118478, -0.119301, -0.118489,  -0.119291, -0.118495,  -0.119283,
      -0.118504,  -0.119277, -0.118511, -0.119269, -0.118521, -0.119262, -0.118528,  -0.119255, -0.118535,  -0.119249,
      -0.118541,  -0.119242, -0.118546, -0.119235, -0.118552, -0.119231, -0.118558,  -0.119223, -0.118561,  -0.119219,
      -0.118569,  -0.119214, -0.118573, -0.119209, -0.118576, -0.119205, -0.118581,  -0.119201, -0.118586,  -0.119197,
      -0.118591,  -0.119193, -0.118594, -0.119188, -0.118599, -0.119184, -0.118602,  -0.119181, -0.118605,  -0.119179,
      -0.118608,  -0.119174, -0.118612, -0.119171, -0.118615, -0.119167, -0.118618,  -0.119165, -0.118621,  -0.119162,
      -0.118624,  -0.119161, -0.118625, -0.119157, -0.118627, -0.119156, -0.11863,   -0.119152, -0.118632,  -0.119151,
      -0.118634,  -0.119149, -0.118637, -0.119147, -0.118637, -0.119144, -0.11864,   -0.119143, -0.118641,  -0.119142,
      -0.118642,  -0.119141, -0.118645, -0.119139, -0.118647, -0.119139, -0.118645,  -0.119137, -0.118648,  -0.119134,
      -0.118649,  -0.119135, -0.11865,  -0.119133, -0.118651, -0.119133, -0.118652,  -0.119132, -0.118653,  -0.119132,
      -0.118654,  -0.11913,  -0.118653, -0.11913,  -0.118655, -0.119129, -0.118656,  -0.119129, -0.118656,  -0.119128,
      -0.118657,  -0.119128, -0.118658, -0.119128, -0.118657, -0.119128, -0.118658,  -0.119127, -0.118657,  -0.119127,
      -0.118657,  -0.119128, -0.118657, -0.119128, -0.118658, -0.119126, -0.118657,  -0.119128, -0.118656,  -0.119128,
      -0.118656,  -0.119129, -0.118656, -0.119131, -0.118655, -0.11913,  -0.118654,  -0.119131, -0.118653,  -0.119132,
      -0.118651,  -0.119132, -0.118652, -0.119134, -0.118651, -0.119136, -0.11865,   -0.119134, -0.118648,  -0.119137,
      -0.118647,  -0.119138, -0.118646, -0.119139, -0.118644, -0.11914,  -0.118644,  -0.119142, -0.118642,  -0.119143,
      -0.11864,   -0.119146, -0.118638, -0.119146, -0.118636, -0.119149, -0.118634,  -0.119151, -0.118632,  -0.119153,
      -0.11863,   -0.119155, -0.118628, -0.119157, -0.118625, -0.119159, -0.118623,  -0.119163, -0.118622,  -0.119166,
      -0.118617,  -0.119169, -0.118615, -0.119172, -0.118612, -0.119174, -0.118608,  -0.119177, -0.118604,  -0.119181,
      -0.118602,  -0.119186, -0.118598, -0.119188, -0.118595, -0.119193, -0.11859,   -0.119196, -0.118587,  -0.1192,
      -0.118582,  -0.119205, -0.118578, -0.119209, -0.118574, -0.119214, -0.118569,  -0.119218, -0.118563,  -0.119223,
      -0.118558,  -0.11923,  -0.118552, -0.119236, -0.118545, -0.119242, -0.118539,  -0.119248, -0.118533,  -0.119255,
      -0.118527,  -0.119262, -0.11852,  -0.119269, -0.118512, -0.119276, -0.118505,  -0.119283, -0.118496,  -0.119292,
      -0.118488,  -0.119301, -0.118478, -0.11931,  -0.11847,  -0.11932,  -0.118459,  -0.119331, -0.118448,  -0.11934,
      -0.118439,  -0.119352, -0.118427, -0.119362, -0.118415, -0.119375, -0.118403,  -0.119389, -0.118389,  -0.119403,
      -0.118374,  -0.119416, -0.118359, -0.119431, -0.118345, -0.119448, -0.118327,  -0.119466, -0.118309,  -0.119484,
      -0.118291,  -0.119502, -0.118271, -0.119524, -0.118251, -0.119546, -0.118228,  -0.119568, -0.118203,  -0.119594,
      -0.118178,  -0.119621, -0.11815,  -0.119647, -0.118122, -0.119678, -0.118088,  -0.119711, -0.118056,  -0.119746,
      -0.118019,  -0.119783, -0.11798,  -0.119824, -0.117939, -0.119868, -0.117892,  -0.119917, -0.117842,  -0.119969,
      -0.117788,  -0.120025, -0.11773,  -0.120087, -0.117663, -0.120155, -0.117591,  -0.120231, -0.117514,  -0.120315,
      -0.117426,  -0.120406, -0.117328, -0.120508, -0.117221, -0.120622, -0.1171,    -0.120753, -0.116961,  -0.120898,
      -0.116805,  -0.121066, -0.116626, -0.121258, -0.116419, -0.121481, -0.116176,  -0.121742, -0.115894,  -0.122052,
      -0.115555,  -0.122425, -0.115144, -0.122879, -0.114638, -0.123447, -0.113998,  -0.12417,  -0.113171,  -0.125123,
      -0.112061,  -0.126432, -0.110499, -0.128331, -0.108143, -0.131325, -0.104216,  -0.136699, -0.0964222, -0.149009,
      -0.0740595, -0.202604},
     {0.355244,   0.918814,  0.784554,  0.865222,  0.806909,  0.852924,  0.814688,   0.847568,  0.818594,   0.844602,
      0.820921,   0.842731,  0.82245,   0.841462,  0.82352,   0.840552,  0.824298,   0.839882,  0.824878,   0.839379,
      0.825318,   0.838996,  0.82565,   0.838706,  0.825899,  0.838492,  0.826082,   0.83834,   0.826206,   0.838243,
      0.826278,   0.838195,  0.8263,    0.838195,  0.826278,  0.838243,  0.826206,   0.838341,  0.826081,   0.838492,
      0.825901,   0.838706,  0.825649,  0.838995,  0.825317,  0.839377,  0.824879,   0.839883,  0.824297,   0.840553,
      0.823519,   0.841461,  0.822451,  0.842732,  0.820921,  0.844601,  0.818594,   0.84757,   0.814687,   0.852924,
      0.806911,   0.865224,  0.784554,  0.918814,  0.355251,  -0.202606, -0.0740595, -0.149008, -0.0964237, -0.136699,
      -0.104216,  -0.131325, -0.108142, -0.128333, -0.110498, -0.126431, -0.112062,  -0.125123, -0.113172,  -0.124169,
      -0.114001,  -0.123447, -0.114639, -0.12288,  -0.115144, -0.122425, -0.115553,  -0.122052, -0.115894,  -0.121743,
      -0.116178,  -0.12148,  -0.116418, -0.121258, -0.116626, -0.121066, -0.116804,  -0.120899, -0.11696,   -0.12075,
      -0.117099,  -0.120624, -0.117221, -0.120509, -0.117328, -0.120405, -0.117426,  -0.120312, -0.117513,  -0.120229,
      -0.117592,  -0.120154, -0.117663, -0.120088, -0.117728, -0.120025, -0.117788,  -0.119969, -0.117842,  -0.119918,
      -0.117892,  -0.119869, -0.117937, -0.119825, -0.117979, -0.119784, -0.118019,  -0.119745, -0.118055,  -0.119711,
      -0.11809,   -0.119678, -0.118121, -0.119649, -0.11815,  -0.11962,  -0.118178,  -0.119594, -0.118204,  -0.119569,
      -0.118228,  -0.119547, -0.11825,  -0.119523, -0.118272, -0.119502, -0.118292,  -0.119485, -0.11831,   -0.119465,
      -0.118328,  -0.119449, -0.118343, -0.119432, -0.118359, -0.119415, -0.118374,  -0.119402, -0.118388,  -0.119388,
      -0.118401,  -0.119375, -0.118415, -0.119363, -0.118428, -0.119351, -0.118438,  -0.119341, -0.118448,  -0.119329,
      -0.11846,   -0.11932,  -0.118469, -0.119311, -0.118478, -0.119301, -0.118489,  -0.119291, -0.118495,  -0.119283,
      -0.118504,  -0.119277, -0.118511, -0.119269, -0.118521, -0.119262, -0.118528,  -0.119255, -0.118535,  -0.119249,
      -0.118541,  -0.119242, -0.118546, -0.119235, -0.118552, -0.119231, -0.118558,  -0.119223, -0.118561,  -0.119219,
      -0.118569,  -0.119214, -0.118573, -0.119209, -0.118576, -0.119205, -0.118581,  -0.119201, -0.118586,  -0.119197,
      -0.118591,  -0.119193, -0.118594, -0.119188, -0.118599, -0.119184, -0.118602,  -0.119181, -0.118605,  -0.119179,
      -0.118608,  -0.119174, -0.118612, -0.119171, -0.118615, -0.119167, -0.118618,  -0.119165, -0.118621,  -0.119162,
      -0.118624,  -0.119161, -0.118625, -0.119157, -0.118627, -0.119156, -0.11863,   -0.119152, -0.118632,  -0.119151,
      -0.118634,  -0.119149, -0.118637, -0.119147, -0.118637, -0.119144, -0.11864,   -0.119143, -0.118641,  -0.119142,
      -0.118642,  -0.119141, -0.118645, -0.119139, -0.118647, -0.119139, -0.118645,  -0.119137, -0.118648,  -0.119134,
      -0.118649,  -0.119135, -0.11865,  -0.119133, -0.118651, -0.119133, -0.118652,  -0.119132, -0.118653,  -0.119132,
      -0.118654,  -0.11913,  -0.118653, -0.11913,  -0.118655, -0.119129, -0.118656,  -0.119129, -0.118656,  -0.119128,
      -0.118657,  -0.119128, -0.118658, -0.119128, -0.118657, -0.119128, -0.118658,  -0.119127, -0.118657,  -0.119127,
      -0.118657,  -0.119128, -0.118657, -0.119128, -0.118658, -0.119126, -0.118657,  -0.119128, -0.118656,  -0.119128,
      -0.118656,  -0.119129, -0.118656, -0.119131, -0.118655, -0.11913,  -0.118654,  -0.119131, -0.118653,  -0.119132,
      -0.118651,  -0.119132, -0.118652, -0.119134, -0.118651, -0.119136, -0.11865,   -0.119134, -0.118648,  -0.119137,
      -0.118647,  -0.119138, -0.118646, -0.119139, -0.118644, -0.11914,  -0.118644,  -0.119142, -0.118642,  -0.119143,
      -0.11864,   -0.119146, -0.118638, -0.119146, -0.118636, -0.119149, -0.118634,  -0.119151, -0.118632,  -0.119153,
      -0.11863,   -0.119155, -0.118628, -0.119157, -0.118625, -0.119159, -0.118623,  -0.119163, -0.118622,  -0.119166,
      -0.118617,  -0.119169, -0.118615, -0.119172, -0.118612, -0.119174, -0.118608,  -0.119177, -0.118604,  -0.119181,
      -0.118602,  -0.119186, -0.118598, -0.119188, -0.118595, -0.119193, -0.11859,   -0.119196, -0.118587,  -0.1192,
      -0.118582,  -0.119205, -0.118578, -0.119209, -0.118574, -0.119214, -0.118569,  -0.119218, -0.118563,  -0.119223,
      -0.118558,  -0.11923,  -0.118552, -0.119236, -0.118545, -0.119242, -0.118539,  -0.119248, -0.118533,  -0.119255,
      -0.118527,  -0.119262, -0.11852,  -0.119269, -0.118512, -0.119276, -0.118505,  -0.119283, -0.118496,  -0.119292,
      -0.118488,  -0.119301, -0.118478, -0.11931,  -0.11847,  -0.11932,  -0.118459,  -0.119331, -0.118448,  -0.11934,
      -0.118439,  -0.119352, -0.118427, -0.119362, -0.118415, -0.119375, -0.118403,  -0.119389, -0.118389,  -0.119403,
      -0.118374,  -0.119416, -0.118359, -0.119431, -0.118345, -0.119448, -0.118327,  -0.119466, -0.118309,  -0.119484,
      -0.118291,  -0.119502, -0.118271, -0.119524, -0.118251, -0.119546, -0.118228,  -0.119568, -0.118203,  -0.119594,
      -0.118178,  -0.119621, -0.11815,  -0.119647, -0.118122, -0.119678, -0.118088,  -0.119711, -0.118056,  -0.119746,
      -0.118019,  -0.119783, -0.11798,  -0.119824, -0.117939, -0.119868, -0.117892,  -0.119917, -0.117842,  -0.119969,
      -0.117788,  -0.120025, -0.11773,  -0.120087, -0.117663, -0.120155, -0.117591,  -0.120231, -0.117514,  -0.120315,
      -0.117426,  -0.120406, -0.117328, -0.120508, -0.117221, -0.120622, -0.1171,    -0.120753, -0.116961,  -0.120898,
      -0.116805,  -0.121066, -0.116626, -0.121258, -0.116419, -0.121481, -0.116176,  -0.121742, -0.115894,  -0.122052,
      -0.115555,  -0.122425, -0.115144, -0.122879, -0.114638, -0.123447, -0.113998,  -0.12417,  -0.113171,  -0.125123,
      -0.112061,  -0.126432, -0.110499, -0.128331, -0.108143, -0.131325, -0.104216,  -0.136699, -0.0964222, -0.149009,
      -0.0740595, -0.202604},
     {0.355244,   0.918814,  0.784554,  0.865222,  0.806909,  0.852924,  0.814688,   0.847568,  0.818594,   0.844602,
      0.820921,   0.842731,  0.82245,   0.841462,  0.82352,   0.840552,  0.824298,   0.839882,  0.824878,   0.839379,
      0.825318,   0.838996,  0.82565,   0.838706,  0.825899,  0.838492,  0.826082,   0.83834,   0.826206,   0.838243,
      0.826278,   0.838195,  0.8263,    0.838195,  0.826278,  0.838243,  0.826206,   0.838341,  0.826081,   0.838492,
      0.825901,   0.838706,  0.825649,  0.838995,  0.825317,  0.839377,  0.824879,   0.839883,  0.824297,   0.840553,
      0.823519,   0.841461,  0.822451,  0.842732,  0.820921,  0.844601,  0.818594,   0.84757,   0.814687,   0.852924,
      0.806911,   0.865224,  0.784554,  0.918814,  0.355251,  -0.202606, -0.0740595, -0.149008, -0.0964237, -0.136699,
      -0.104216,  -0.131325, -0.108142, -0.128333, -0.110498, -0.126431, -0.112062,  -0.125123, -0.113172,  -0.124169,
      -0.114001,  -0.123447, -0.114639, -0.12288,  -0.115144, -0.122425, -0.115553,  -0.122052, -0.115894,  -0.121743,
      -0.116178,  -0.12148,  -0.116418, -0.121258, -0.116626, -0.121066, -0.116804,  -0.120899, -0.11696,   -0.12075,
      -0.117099,  -0.120624, -0.117221, -0.120509, -0.117328, -0.120405, -0.117426,  -0.120312, -0.117513,  -0.120229,
      -0.117592,  -0.120154, -0.117663, -0.120088, -0.117728, -0.120025, -0.117788,  -0.119969, -0.117842,  -0.119918,
      -0.117892,  -0.119869, -0.117937, -0.119825, -0.117979, -0.119784, -0.118019,  -0.119745, -0.118055,  -0.119711,
      -0.11809,   -0.119678, -0.118121, -0.119649, -0.11815,  -0.11962,  -0.118178,  -0.119594, -0.118204,  -0.119569,
      -0.118228,  -0.119547, -0.11825,  -0.119523, -0.118272, -0.119502, -0.118292,  -0.119485, -0.11831,   -0.119465,
      -0.118328,  -0.119449, -0.118343, -0.119432, -0.118359, -0.119415, -0.118374,  -0.119402, -0.118388,  -0.119388,
      -0.118401,  -0.119375, -0.118415, -0.119363, -0.118428, -0.119351, -0.118438,  -0.119341, -0.118448,  -0.119329,
      -0.11846,   -0.11932,  -0.118469, -0.119311, -0.118478, -0.119301, -0.118489,  -0.119291, -0.118495,  -0.119283,
      -0.118504,  -0.119277, -0.118511, -0.119269, -0.118521, -0.119262, -0.118528,  -0.119255, -0.118535,  -0.119249,
      -0.118541,  -0.119242, -0.118546, -0.119235, -0.118552, -0.119231, -0.118558,  -0.119223, -0.118561,  -0.119219,
      -0.118569,  -0.119214, -0.118573, -0.119209, -0.118576, -0.119205, -0.118581,  -0.119201, -0.118586,  -0.119197,
      -0.118591,  -0.119193, -0.118594, -0.119188, -0.118599, -0.119184, -0.118602,  -0.119181, -0.118605,  -0.119179,
      -0.118608,  -0.119174, -0.118612, -0.119171, -0.118615, -0.119167, -0.118618,  -0.119165, -0.118621,  -0.119162,
      -0.118624,  -0.119161, -0.118625, -0.119157, -0.118627, -0.119156, -0.11863,   -0.119152, -0.118632,  -0.119151,
      -0.118634,  -0.119149, -0.118637, -0.119147, -0.118637, -0.119144, -0.11864,   -0.119143, -0.118641,  -0.119142,
      -0.118642,  -0.119141, -0.118645, -0.119139, -0.118647, -0.119139, -0.118645,  -0.119137, -0.118648,  -0.119134,
      -0.118649,  -0.119135, -0.11865,  -0.119133, -0.118651, -0.119133, -0.118652,  -0.119132, -0.118653,  -0.119132,
      -0.118654,  -0.11913,  -0.118653, -0.11913,  -0.118655, -0.119129, -0.118656,  -0.119129, -0.118656,  -0.119128,
      -0.118657,  -0.119128, -0.118658, -0.119128, -0.118657, -0.119128, -0.118658,  -0.119127, -0.118657,  -0.119127,
      -0.118657,  -0.119128, -0.118657, -0.119128, -0.118658, -0.119126, -0.118657,  -0.119128, -0.118656,  -0.119128,
      -0.118656,  -0.119129, -0.118656, -0.119131, -0.118655, -0.11913,  -0.118654,  -0.119131, -0.118653,  -0.119132,
      -0.118651,  -0.119132, -0.118652, -0.119134, -0.118651, -0.119136, -0.11865,   -0.119134, -0.118648,  -0.119137,
      -0.118647,  -0.119138, -0.118646, -0.119139, -0.118644, -0.11914,  -0.118644,  -0.119142, -0.118642,  -0.119143,
      -0.11864,   -0.119146, -0.118638, -0.119146, -0.118636, -0.119149, -0.118634,  -0.119151, -0.118632,  -0.119153,
      -0.11863,   -0.119155, -0.118628, -0.119157, -0.118625, -0.119159, -0.118623,  -0.119163, -0.118622,  -0.119166,
      -0.118617,  -0.119169, -0.118615, -0.119172, -0.118612, -0.119174, -0.118608,  -0.119177, -0.118604,  -0.119181,
      -0.118602,  -0.119186, -0.118598, -0.119188, -0.118595, -0.119193, -0.11859,   -0.119196, -0.118587,  -0.1192,
      -0.118582,  -0.119205, -0.118578, -0.119209, -0.118574, -0.119214, -0.118569,  -0.119218, -0.118563,  -0.119223,
      -0.118558,  -0.11923,  -0.118552, -0.119236, -0.118545, -0.119242, -0.118539,  -0.119248, -0.118533,  -0.119255,
      -0.118527,  -0.119262, -0.11852,  -0.119269, -0.118512, -0.119276, -0.118505,  -0.119283, -0.118496,  -0.119292,
      -0.118488,  -0.119301, -0.118478, -0.11931,  -0.11847,  -0.11932,  -0.118459,  -0.119331, -0.118448,  -0.11934,
      -0.118439,  -0.119352, -0.118427, -0.119362, -0.118415, -0.119375, -0.118403,  -0.119389, -0.118389,  -0.119403,
      -0.118374,  -0.119416, -0.118359, -0.119431, -0.118345, -0.119448, -0.118327,  -0.119466, -0.118309,  -0.119484,
      -0.118291,  -0.119502, -0.118271, -0.119524, -0.118251, -0.119546, -0.118228,  -0.119568, -0.118203,  -0.119594,
      -0.118178,  -0.119621, -0.11815,  -0.119647, -0.118122, -0.119678, -0.118088,  -0.119711, -0.118056,  -0.119746,
      -0.118019,  -0.119783, -0.11798,  -0.119824, -0.117939, -0.119868, -0.117892,  -0.119917, -0.117842,  -0.119969,
      -0.117788,  -0.120025, -0.11773,  -0.120087, -0.117663, -0.120155, -0.117591,  -0.120231, -0.117514,  -0.120315,
      -0.117426,  -0.120406, -0.117328, -0.120508, -0.117221, -0.120622, -0.1171,    -0.120753, -0.116961,  -0.120898,
      -0.116805,  -0.121066, -0.116626, -0.121258, -0.116419, -0.121481, -0.116176,  -0.121742, -0.115894,  -0.122052,
      -0.115555,  -0.122425, -0.115144, -0.122879, -0.114638, -0.123447, -0.113998,  -0.12417,  -0.113171,  -0.125123,
      -0.112061,  -0.126432, -0.110499, -0.128331, -0.108143, -0.131325, -0.104216,  -0.136699, -0.0964222, -0.149009,
      -0.0740595, -0.202604},
     {0.35822,    0.913094,  0.792851,  0.854584,  0.819596,  0.838524,  0.830433,   0.830861,  0.83588,   0.827108,
      0.838278,   0.825819,  0.838657,  0.82617,   0.837742,  0.827496,  0.836147,   0.82923,   0.834385,  0.830926,
      0.832835,   0.832279,  0.831712,  0.833156,  0.831074,  0.833571,  0.83085,    0.833648,  0.830877,  0.833561,
      0.830982,   0.83347,   0.831033,  0.833471,  0.830982,  0.833562,  0.830877,   0.833649,  0.830848,  0.833571,
      0.831076,   0.833155,  0.831711,  0.832278,  0.832834,  0.830923,  0.834386,   0.829231,  0.836147,  0.827495,
      0.837742,   0.82617,   0.838658,  0.82582,   0.838278,  0.827108,  0.83588,    0.830863,  0.830432,  0.838525,
      0.819598,   0.854586,  0.79285,   0.913095,  0.358226,  -0.202747, -0.0767634, -0.143533, -0.104514, -0.126226,
      -0.11677,   -0.117053, -0.123726, -0.111875, -0.127378, -0.109579, -0.128457,  -0.109582, -0.127511, -0.111318,
      -0.125146,  -0.11415,  -0.122024, -0.117392, -0.11882,  -0.120405, -0.116127,  -0.122668, -0.114375, -0.12386,
      -0.11377,   -0.123882, -0.114293, -0.122873, -0.115712, -0.121141, -0.117649,  -0.119111, -0.11966,  -0.117221,
      -0.12133,   -0.115854, -0.122341, -0.115243, -0.122536, -0.115453, -0.121943,  -0.116382, -0.12074,  -0.117783,
      -0.119225,  -0.119327, -0.117738, -0.120679, -0.116592, -0.121562, -0.116012,  -0.121817, -0.116086, -0.121427,
      -0.116765,  -0.120507, -0.117866, -0.119286, -0.119134, -0.118042, -0.120287,  -0.117041, -0.121081, -0.116492,
      -0.121363,  -0.116489, -0.121093, -0.117012, -0.120354, -0.117921, -0.119327,  -0.119007, -0.118246, -0.120024,
      -0.117349,  -0.120756, -0.116822, -0.121049, -0.116771, -0.120859, -0.117186,  -0.120248, -0.117961, -0.119356,
      -0.118914,  -0.118394, -0.119831, -0.117571, -0.120514, -0.117063, -0.120818,  -0.116975, -0.12069,  -0.117312,
      -0.120167,  -0.117986, -0.119381, -0.118842, -0.118507, -0.119686, -0.117741,  -0.120332, -0.117248, -0.120643,
      -0.117133,  -0.12056,  -0.117408, -0.120111, -0.118004, -0.119402, -0.118785,  -0.118596, -0.119568, -0.117875,
      -0.120187,  -0.117395, -0.120505, -0.117256, -0.120461, -0.117482, -0.120069,  -0.118016, -0.119424, -0.118736,
      -0.118673,  -0.119474, -0.117985, -0.12007,  -0.117512, -0.120397, -0.117353,  -0.12038,  -0.117537, -0.120036,
      -0.118022,  -0.119443, -0.11869,  -0.118736, -0.119392, -0.118077, -0.119973,  -0.117607, -0.120307, -0.117431,
      -0.12032,   -0.117581, -0.120014, -0.118021, -0.119465, -0.118649, -0.118794,  -0.119324, -0.118154, -0.119895,
      -0.117685,  -0.120234, -0.117492, -0.120271, -0.117613, -0.12,     -0.118017,  -0.119487, -0.118612, -0.118844,
      -0.119264,  -0.118222, -0.119825, -0.117752, -0.120173, -0.117543, -0.120233,  -0.117635, -0.119994, -0.118008,
      -0.11951,   -0.118575, -0.118893, -0.119208, -0.118279, -0.119765, -0.117808,  -0.120124, -0.117581, -0.120206,
      -0.117649,  -0.119993, -0.117995, -0.119535, -0.11854,  -0.118938, -0.119156,  -0.118331, -0.119715, -0.117853,
      -0.120085,  -0.117612, -0.120187, -0.117656, -0.119999, -0.117977, -0.119564,  -0.118501, -0.118981, -0.119112,
      -0.11838,   -0.11967,  -0.117893, -0.120053, -0.117633, -0.120175, -0.117657,  -0.120011, -0.117955, -0.119595,
      -0.118464,  -0.119024, -0.119067, -0.118423, -0.11963,  -0.117928, -0.120029,  -0.117649, -0.120172, -0.117649,
      -0.120028,  -0.117928, -0.11963,  -0.118423, -0.119068, -0.119022, -0.118463,  -0.119595, -0.117954, -0.120011,
      -0.117656,  -0.120176, -0.117635, -0.120055, -0.117894, -0.11967,  -0.118379,  -0.119111, -0.11898,  -0.118501,
      -0.119563,  -0.117977, -0.119999, -0.117657, -0.120187, -0.117613, -0.120086,  -0.117853, -0.119714, -0.118332,
      -0.119158,  -0.118937, -0.118539, -0.119536, -0.117995, -0.119993, -0.11765,   -0.120206, -0.117582, -0.120125,
      -0.117808,  -0.119767, -0.118279, -0.119207, -0.118892, -0.118575, -0.119509,  -0.118008, -0.119993, -0.117635,
      -0.120233,  -0.117542, -0.120174, -0.117752, -0.119825, -0.11822,  -0.119262,  -0.118846, -0.118613, -0.119487,
      -0.118017,  -0.120001, -0.117613, -0.120271, -0.117493, -0.120233, -0.117686,  -0.119893, -0.118153, -0.119324,
      -0.118795,  -0.118651, -0.119465, -0.118021, -0.120015, -0.117582, -0.120319,  -0.11743,  -0.120307, -0.117607,
      -0.119974,  -0.118077, -0.119394, -0.118738, -0.118691, -0.119444, -0.118022,  -0.120036, -0.117537, -0.12038,
      -0.117353,  -0.120396, -0.117512, -0.120072, -0.117984, -0.119474, -0.118672,  -0.118734, -0.119423, -0.118016,
      -0.120068,  -0.117482, -0.12046,  -0.117255, -0.120506, -0.117394, -0.120188,  -0.117875, -0.119569, -0.118597,
      -0.118784,  -0.119402, -0.118004, -0.120111, -0.117409, -0.12056,  -0.117132,  -0.120644, -0.117248, -0.120332,
      -0.117741,  -0.119686, -0.118506, -0.118841, -0.119381, -0.117986, -0.12017,   -0.117313, -0.12069,  -0.116977,
      -0.120818,  -0.117064, -0.120514, -0.11757,  -0.119833, -0.118393, -0.118913,  -0.119357, -0.117959, -0.120247,
      -0.117185,  -0.12086,  -0.11677,  -0.12105,  -0.116824, -0.120754, -0.117349,  -0.120023, -0.118246, -0.119008,
      -0.119327,  -0.117923, -0.120354, -0.11701,  -0.121094, -0.116489, -0.121361,  -0.116492, -0.121082, -0.117042,
      -0.120287,  -0.118042, -0.119134, -0.119286, -0.117867, -0.120507, -0.116764,  -0.121426, -0.116086, -0.121818,
      -0.116011,  -0.121561, -0.116594, -0.120679, -0.117737, -0.119327, -0.119224,  -0.117784, -0.120741, -0.116384,
      -0.121943,  -0.115453, -0.122537, -0.115241, -0.12234,  -0.115853, -0.12133,   -0.117224, -0.119661, -0.11911,
      -0.11765,   -0.121141, -0.115712, -0.122873, -0.114293, -0.123884, -0.113768,  -0.123858, -0.114375, -0.122668,
      -0.116129,  -0.120405, -0.118822, -0.117391, -0.122024, -0.11415,  -0.125144,  -0.111319, -0.127511, -0.109582,
      -0.128456,  -0.10958,  -0.127379, -0.111873, -0.123726, -0.117053, -0.116769,  -0.126226, -0.104512, -0.143535,
      -0.0767626, -0.202746},
     {0.355921,  0.892029,  0.831583,  0.808224,  0.86228,   0.808746,  0.842656,  0.83539,    0.819924,  0.846941,
      0.821579,  0.835149,  0.837172,  0.82259,   0.841984,  0.826567,  0.831844,  0.838,      0.824059,  0.839141,
      0.829544,  0.82984,   0.838424,  0.825187,  0.837047,  0.831722,  0.828404,  0.838628,   0.82621,   0.835261,
      0.833549,  0.827245,  0.838688,  0.827246,  0.833549,  0.835261,  0.82621,   0.838628,   0.828403,  0.831722,
      0.837048,  0.825187,  0.838422,  0.82984,   0.829543,  0.839139,  0.82406,   0.838,      0.831844,  0.826567,
      0.841984,  0.82259,   0.837173,  0.83515,   0.821579,  0.846941,  0.819924,  0.835391,   0.842656,  0.808745,
      0.862282,  0.808226,  0.831581,  0.892031,  0.355926,  -0.177499, -0.118577, -0.0955127, -0.147565, -0.0968975,
      -0.128311, -0.122074, -0.107529, -0.132026, -0.10972,  -0.121035, -0.123482, -0.110566,  -0.126861, -0.114646,
      -0.118058, -0.123836, -0.112461, -0.12384,  -0.117449, -0.116534, -0.123657, -0.114042,  -0.121663, -0.119268,
      -0.115783, -0.123139, -0.115492, -0.119975, -0.120459, -0.115552, -0.122386, -0.116833,  -0.118665, -0.12117,
      -0.115706, -0.121488, -0.11804,  -0.117702, -0.121484, -0.116148, -0.120525, -0.119067,  -0.117066, -0.121459,
      -0.116792, -0.119579, -0.119878, -0.116751, -0.121159, -0.117548, -0.118726, -0.120439,  -0.116727, -0.120656,
      -0.118334, -0.118026, -0.120736, -0.116954, -0.120023, -0.119068, -0.117528, -0.120776,  -0.117375, -0.119345,
      -0.119684, -0.117256, -0.120589, -0.117926, -0.118697, -0.120129, -0.117214, -0.120219,  -0.118529, -0.118146,
      -0.120376, -0.117382, -0.119725, -0.119111, -0.117745, -0.120412, -0.117718, -0.119181,  -0.11961,  -0.117525,
      -0.120257, -0.11817,  -0.118646, -0.119973, -0.117497, -0.11994,  -0.118673, -0.11819,   -0.120168, -0.117649,
      -0.119518, -0.119165, -0.117861, -0.120185, -0.117949, -0.119048, -0.119585, -0.117689,  -0.120033, -0.118348,
      -0.118591, -0.119885, -0.117684, -0.119744, -0.118792, -0.118203, -0.120037, -0.117837,  -0.11936,  -0.119221,
      -0.117928, -0.120029, -0.118121, -0.118939, -0.119584, -0.117798, -0.119871, -0.118491,  -0.118535, -0.119835,
      -0.117819, -0.119591, -0.118895, -0.118197, -0.119945, -0.117983, -0.119232, -0.119277,  -0.117968, -0.119911,
      -0.11826,  -0.118844, -0.119593, -0.117875, -0.11974,  -0.11861,  -0.118478, -0.1198,    -0.117924, -0.119465,
      -0.118986, -0.118184, -0.119876, -0.118099, -0.11912,  -0.119333, -0.117996, -0.119817,  -0.118377, -0.118758,
      -0.11961,  -0.117935, -0.119634, -0.118716, -0.118424, -0.119779, -0.118008, -0.119355,  -0.119068, -0.118164,
      -0.119824, -0.1182,   -0.11902,  -0.119387, -0.118012, -0.119739, -0.11848,  -0.118676,  -0.119631, -0.117984,
      -0.119539, -0.118812, -0.118371, -0.119767, -0.11808,  -0.119255, -0.119147, -0.118141,  -0.119779, -0.118288,
      -0.118926, -0.119441, -0.118022, -0.11967,  -0.118577, -0.1186,   -0.119653, -0.118023,  -0.119455, -0.118901,
      -0.118316, -0.119759, -0.118145, -0.119163, -0.119223, -0.118117, -0.119742, -0.11837,   -0.118839, -0.119496,
      -0.118028, -0.119608, -0.118664, -0.118523, -0.119681, -0.118058, -0.119375, -0.11899,   -0.118262, -0.119756,
      -0.118206, -0.119076, -0.119299, -0.118089, -0.11971,  -0.118449, -0.118753, -0.11955,   -0.118029, -0.11955,
      -0.118752, -0.118448, -0.11971,  -0.11809,  -0.1193,   -0.119075, -0.118206, -0.119756,  -0.118261, -0.118989,
      -0.119375, -0.118058, -0.119682, -0.118525, -0.118665, -0.119608, -0.118027, -0.119495,  -0.118838, -0.11837,
      -0.119742, -0.118116, -0.119223, -0.119164, -0.118146, -0.119761, -0.118317, -0.118901,  -0.119454, -0.118024,
      -0.119654, -0.118599, -0.118576, -0.11967,  -0.118022, -0.119441, -0.118928, -0.118289,  -0.11978,  -0.118142,
      -0.119147, -0.119257, -0.118081, -0.119766, -0.11837,  -0.118812, -0.119539, -0.117983,  -0.11963,  -0.118676,
      -0.11848,  -0.119738, -0.118012, -0.119388, -0.119019, -0.118199, -0.119823, -0.118165,  -0.11907,  -0.119355,
      -0.118008, -0.11978,  -0.118424, -0.118716, -0.119634, -0.117936, -0.11961,  -0.118757,  -0.118376, -0.119817,
      -0.117996, -0.119335, -0.119121, -0.118099, -0.119878, -0.118185, -0.118985, -0.119464,  -0.117924, -0.119801,
      -0.118479, -0.118611, -0.119742, -0.117876, -0.119594, -0.118844, -0.11826,  -0.119911,  -0.117969, -0.119277,
      -0.119232, -0.117982, -0.119945, -0.118198, -0.118894, -0.11959,  -0.117819, -0.119833,  -0.118534, -0.118491,
      -0.119871, -0.117798, -0.119583, -0.118939, -0.118121, -0.120028, -0.117929, -0.119222,  -0.119361, -0.117838,
      -0.120036, -0.118202, -0.118792, -0.119744, -0.117685, -0.119885, -0.11859,  -0.118349,  -0.120033, -0.117688,
      -0.119586, -0.119048, -0.117948, -0.120185, -0.117861, -0.119166, -0.11952,  -0.11765,   -0.120169, -0.118191,
      -0.118674, -0.119941, -0.117497, -0.119973, -0.118647, -0.11817,  -0.120255, -0.117525,  -0.11961,  -0.119178,
      -0.117718, -0.120412, -0.117744, -0.119112, -0.119726, -0.117381, -0.120376, -0.118145,  -0.118528, -0.120219,
      -0.117214, -0.120131, -0.118697, -0.117925, -0.120589, -0.117256, -0.119682, -0.119345,  -0.117377, -0.120776,
      -0.117528, -0.119068, -0.120023, -0.116954, -0.120736, -0.118026, -0.118334, -0.120655,  -0.116727, -0.120439,
      -0.118725, -0.117548, -0.12116,  -0.116751, -0.119877, -0.119579, -0.116792, -0.121459,  -0.117068, -0.119069,
      -0.120525, -0.116149, -0.121484, -0.117701, -0.118039, -0.121487, -0.115707, -0.121173,  -0.118666, -0.116833,
      -0.122387, -0.115552, -0.120459, -0.119975, -0.115493, -0.123139, -0.115782, -0.119266,  -0.121663, -0.114043,
      -0.123658, -0.116535, -0.117449, -0.123839, -0.112461, -0.123835, -0.118057, -0.114646,  -0.126862, -0.110565,
      -0.123481, -0.121036, -0.109719, -0.132025, -0.107529, -0.122073, -0.128311, -0.096897,  -0.147564, -0.0955139,
      -0.118576, -0.177498},
     {0.35578,    0.850959,  0.882605,  0.785328,  0.84209,   0.853658,  0.807913,   0.836873,   0.847004,  0.815911,
      0.834315,   0.844114,  0.820026,  0.83278,   0.842517,  0.822558,  0.831729,   0.841518,   0.824288,  0.830936,
      0.840859,   0.825557,  0.830283,  0.840414,  0.826539,  0.829706,  0.840128,   0.827335,   0.829158,  0.839966,
      0.828008,   0.828603,  0.839913,  0.828604,  0.828008,  0.839966,  0.829159,   0.827335,   0.840127,  0.829706,
      0.826539,   0.840414,  0.830282,  0.825557,  0.840858,  0.830934,  0.824288,   0.841519,   0.831729,  0.822558,
      0.842517,   0.832779,  0.820027,  0.844116,  0.834315,  0.81591,   0.847005,   0.836875,   0.807912,  0.853658,
      0.842092,   0.785329,  0.882604,  0.850961,  0.355784,  -0.136736, -0.168311,  -0.0737736, -0.127926, -0.139278,
      -0.0963962, -0.122765, -0.132511, -0.104455, -0.120269, -0.129483, -0.108652,  -0.118808,  -0.127708, -0.111282,
      -0.117856,  -0.126496, -0.113124, -0.117193, -0.125574, -0.114509, -0.116714,  -0.124821,  -0.115608, -0.116369,
      -0.124173,  -0.11651,  -0.116119, -0.12359,  -0.117271, -0.11595,  -0.123053,  -0.117921,  -0.115845, -0.122546,
      -0.118484,  -0.115799, -0.122066, -0.118973, -0.1158,   -0.121602, -0.119396,  -0.115847,  -0.121157, -0.11976,
      -0.115935,  -0.120729, -0.120071, -0.116059, -0.120319, -0.12033,  -0.116216,  -0.119927,  -0.120541, -0.116401,
      -0.119555,  -0.120704, -0.116609, -0.119203, -0.120823, -0.11684,  -0.118876,  -0.120899,  -0.117086, -0.118576,
      -0.120935,  -0.117347, -0.118303, -0.120932, -0.117616, -0.11806,  -0.120892,  -0.11789,   -0.117849, -0.120819,
      -0.118165,  -0.11767,  -0.120715, -0.118434, -0.117524, -0.120583, -0.118698,  -0.117413,  -0.120428, -0.118948,
      -0.117335,  -0.120252, -0.119186, -0.11729,  -0.120058, -0.119405, -0.117278,  -0.119853,  -0.119605, -0.117299,
      -0.119638,  -0.11978,  -0.11735,  -0.11942,  -0.119931, -0.117428, -0.1192,    -0.120055,  -0.117531, -0.118982,
      -0.120151,  -0.117658, -0.118773, -0.120218, -0.117804, -0.118573, -0.120257,  -0.117966,  -0.118386, -0.120265,
      -0.118142,  -0.118218, -0.120247, -0.118326, -0.118069, -0.120203, -0.118516,  -0.11794,   -0.120133, -0.118708,
      -0.117836,  -0.120039, -0.118896, -0.117754, -0.119925, -0.11908,  -0.1177,    -0.119792,  -0.119253, -0.117671,
      -0.119646,  -0.119417, -0.117667, -0.119486, -0.119564, -0.11769,  -0.11932,   -0.119694,  -0.117737, -0.119149,
      -0.119806,  -0.117807, -0.118975, -0.119894, -0.117897, -0.118803, -0.119961,  -0.118007,  -0.118638, -0.120005,
      -0.118133,  -0.118479, -0.120023, -0.118272, -0.118334, -0.120017, -0.118422,  -0.118203,  -0.119989, -0.118579,
      -0.118088,  -0.119939, -0.11874,  -0.11799,  -0.119865, -0.118903, -0.117914,  -0.119772,  -0.119062, -0.117861,
      -0.119663,  -0.119216, -0.11783,  -0.11954,  -0.11936,  -0.117819, -0.119402,  -0.119494,  -0.117833, -0.119257,
      -0.119613,  -0.11787,  -0.119105, -0.119717, -0.117929, -0.11895,  -0.1198,    -0.118005,  -0.118795, -0.119864,
      -0.118101,  -0.118643, -0.119908, -0.118213, -0.118498, -0.119929, -0.118339,  -0.118361,  -0.119929, -0.118477,
      -0.118238,  -0.119905, -0.118621, -0.118128, -0.11986,  -0.118771, -0.118035,  -0.119796,  -0.118924, -0.117961,
      -0.119711,  -0.119076, -0.117907, -0.119609, -0.119222, -0.117875, -0.119493,  -0.119362,  -0.117863, -0.119362,
      -0.119492,  -0.117874, -0.119223, -0.11961,  -0.117907, -0.119075, -0.119711,  -0.117961,  -0.118923, -0.119795,
      -0.118035,  -0.118772, -0.119861, -0.118129, -0.118621, -0.119905, -0.118238,  -0.118476,  -0.119928, -0.118361,
      -0.118339,  -0.119929, -0.118498, -0.118214, -0.119909, -0.118644, -0.118102,  -0.119864,  -0.118794, -0.118006,
      -0.119801,  -0.11895,  -0.117928, -0.119717, -0.119105, -0.11787,  -0.119614,  -0.119258,  -0.117834, -0.119494,
      -0.119403,  -0.117821, -0.119361, -0.119539, -0.117829, -0.119216, -0.119663,  -0.11786,   -0.119062, -0.119773,
      -0.117914,  -0.118902, -0.119865, -0.117991, -0.11874,  -0.119937, -0.118087,  -0.11858,   -0.11999,  -0.118202,
      -0.118422,  -0.120018, -0.118334, -0.118272, -0.120023, -0.11848,  -0.118132,  -0.120004,  -0.118637, -0.118006,
      -0.119962,  -0.118805, -0.117897, -0.119894, -0.118976, -0.117808, -0.119805,  -0.119148,  -0.117738, -0.119695,
      -0.11932,   -0.117691, -0.119565, -0.119488, -0.117669, -0.119417, -0.119646,  -0.117671,  -0.119253, -0.119792,
      -0.1177,    -0.119079, -0.119925, -0.117755, -0.118895, -0.120038, -0.117835,  -0.118706,  -0.120132, -0.11794,
      -0.118515,  -0.120203, -0.118068, -0.118326, -0.120247, -0.118218, -0.118142,  -0.120266,  -0.118386, -0.117966,
      -0.120256,  -0.118573, -0.117804, -0.120218, -0.118773, -0.117658, -0.120151,  -0.118983,  -0.117532, -0.120055,
      -0.1192,    -0.117429, -0.119931, -0.119419, -0.11735,  -0.119781, -0.119639,  -0.1173,    -0.119605, -0.119853,
      -0.117279,  -0.119405, -0.120058, -0.11729,  -0.119186, -0.120251, -0.117334,  -0.118949,  -0.120428, -0.117412,
      -0.118697,  -0.120583, -0.117523, -0.118434, -0.120716, -0.11767,  -0.118163,  -0.120819,  -0.117848, -0.11789,
      -0.120893,  -0.118061, -0.117616, -0.120932, -0.118304, -0.117347, -0.120934,  -0.118576,  -0.117088, -0.120899,
      -0.118876,  -0.116839, -0.120823, -0.119203, -0.11661,  -0.120705, -0.119554,  -0.1164,    -0.120541, -0.119927,
      -0.116215,  -0.12033,  -0.12032,  -0.116059, -0.120071, -0.12073,  -0.115935,  -0.119761,  -0.121159, -0.115849,
      -0.119396,  -0.121603, -0.1158,   -0.118972, -0.122065, -0.115798, -0.118485,  -0.122548,  -0.115846, -0.117921,
      -0.123053,  -0.115951, -0.117271, -0.12359,  -0.116121, -0.11651,  -0.124171,  -0.116368,  -0.115608, -0.124822,
      -0.116716,  -0.11451,  -0.125574, -0.117192, -0.113124, -0.126496, -0.117855,  -0.111282,  -0.127708, -0.118808,
      -0.108652,  -0.129483, -0.120269, -0.104453, -0.132511, -0.122766, -0.0963963, -0.139276,  -0.127926, -0.0737741,
      -0.16831,   -0.136737},
     {0.359284,  0.79616,    0.911499,  0.820507,  0.794798,  0.84896,    0.852498,  0.815651,  0.821595,   0.847245,
      0.836842,  0.819408,   0.831603,  0.84273,   0.830358,  0.824079,   0.835624,  0.838272,  0.828144,   0.828075,
      0.836517,  0.834907,   0.828176,  0.830723,  0.835906,  0.832986,   0.829059,  0.831968,  0.835005,   0.832307,
      0.829777,  0.832242,   0.83461,   0.832242,  0.829777,  0.832307,   0.835005,  0.831968,  0.829059,   0.832986,
      0.835906,  0.830723,   0.828175,  0.834907,  0.836516,  0.828073,   0.828143,  0.838273,  0.835625,   0.824079,
      0.830357,  0.84273,    0.831604,  0.819409,  0.836842,  0.847245,   0.821596,  0.815651,  0.852497,   0.848961,
      0.794799,  0.820508,   0.911499,  0.796162,  0.359287,  -0.083576,  -0.203146, -0.104913, -0.077091,  -0.139143,
      -0.14248,  -0.0977577, -0.106222, -0.139066, -0.123998, -0.100676,  -0.119327, -0.134507, -0.114392,  -0.106292,
      -0.126242, -0.128254,  -0.109755, -0.112817, -0.128873, -0.121801,  -0.108899, -0.118882, -0.128187,  -0.116395,
      -0.110868, -0.123404,  -0.125218, -0.112922, -0.114533, -0.12573,   -0.121168, -0.111773, -0.118663,  -0.125742,
      -0.11724,  -0.112793,  -0.122143, -0.123852, -0.114415, -0.115352,  -0.124168, -0.120853, -0.113267,  -0.118543,
      -0.124418, -0.11771,   -0.113872, -0.121417, -0.123059, -0.115297,  -0.115841, -0.123223, -0.120662,  -0.114197,
      -0.118468, -0.123578,  -0.118011, -0.114571, -0.120944, -0.122537,  -0.115882, -0.116167, -0.122582,  -0.120531,
      -0.114832, -0.118414,  -0.122995, -0.118223, -0.115063, -0.120608,  -0.122166, -0.116303, -0.116403,  -0.122122,
      -0.120438, -0.115297,  -0.118375, -0.122565, -0.11838,  -0.115427,  -0.120358, -0.121891, -0.116619,  -0.116577,
      -0.121771, -0.120369,  -0.115649, -0.118341, -0.122237, -0.118503,  -0.115705, -0.120161, -0.121677,  -0.116865,
      -0.11671,  -0.121496,  -0.120317, -0.115927, -0.118313, -0.121979,  -0.118603, -0.115926, -0.120004,  -0.12151,
      -0.117064, -0.116816,  -0.121277, -0.120278, -0.116149, -0.118288,  -0.121772, -0.118686, -0.116101,  -0.119873,
      -0.121378, -0.117227,  -0.116898, -0.121096, -0.120251, -0.116333,  -0.118264, -0.121604, -0.118759,  -0.116246,
      -0.119766, -0.121271,  -0.117363, -0.116962, -0.120947, -0.120232,  -0.116482, -0.118238, -0.121464,  -0.11882,
      -0.116361, -0.119671,  -0.121185, -0.117477, -0.117012, -0.120821,  -0.120218, -0.116607, -0.118215,  -0.121352,
      -0.118878, -0.116455,  -0.119589, -0.121117, -0.117577, -0.117049,  -0.120714, -0.120213, -0.116712,  -0.118191,
      -0.121256, -0.118928,  -0.116532, -0.119518, -0.121064, -0.117662,  -0.117076, -0.120624, -0.120213,  -0.116799,
      -0.118165, -0.12118,   -0.118976, -0.116592, -0.119452, -0.121024,  -0.117737, -0.117093, -0.120546,  -0.12022,
      -0.116873, -0.118136,  -0.121116, -0.119022, -0.11664,  -0.119393,  -0.120994, -0.117802, -0.117101,  -0.120479,
      -0.120231, -0.116934,  -0.118106, -0.121065, -0.119067, -0.116677,  -0.119339, -0.120975, -0.117861,  -0.117102,
      -0.120422, -0.120248,  -0.116984, -0.118074, -0.121025, -0.11911,   -0.116702, -0.119289, -0.120967,  -0.117914,
      -0.117096, -0.120374,  -0.12027,  -0.117025, -0.118039, -0.120996,  -0.119153, -0.116717, -0.119243,  -0.120967,
      -0.11796,  -0.117081,  -0.120334, -0.120299, -0.117057, -0.118002,  -0.120978, -0.119197, -0.116721,  -0.119197,
      -0.120977, -0.118002,  -0.117057, -0.120299, -0.120334, -0.11708,   -0.117959, -0.120967, -0.119242,  -0.116717,
      -0.119153, -0.120997,  -0.118041, -0.117026, -0.120271, -0.120374,  -0.117095, -0.117913, -0.120967,  -0.119289,
      -0.116701, -0.119109,  -0.121025, -0.118075, -0.116985, -0.120249,  -0.120423, -0.117102, -0.11786,   -0.120976,
      -0.11934,  -0.116677,  -0.119066, -0.121065, -0.118107, -0.116934,  -0.120231, -0.120481, -0.117102,  -0.117802,
      -0.120995, -0.119395,  -0.116641, -0.119021, -0.121115, -0.118137,  -0.116873, -0.120219, -0.120546,  -0.117094,
      -0.117737, -0.121023,  -0.119453, -0.116593, -0.118976, -0.121178,  -0.118164, -0.1168,   -0.120214,  -0.120625,
      -0.117076, -0.117663,  -0.121065, -0.119518, -0.116532, -0.118928,  -0.121257, -0.11819,  -0.11671,   -0.120213,
      -0.120716, -0.117051,  -0.117577, -0.121118, -0.11959,  -0.116456,  -0.118877, -0.12135,  -0.118215,  -0.116607,
      -0.120219, -0.120821,  -0.117013, -0.117479, -0.121186, -0.119672,  -0.116361, -0.118821, -0.121464,  -0.118238,
      -0.116481, -0.120231,  -0.120947, -0.116963, -0.117363, -0.121271,  -0.119765, -0.116245, -0.118758,  -0.121603,
      -0.118263, -0.116332,  -0.120251, -0.121096, -0.116898, -0.117227,  -0.121377, -0.119874, -0.116102,  -0.118686,
      -0.121772, -0.118287,  -0.116149, -0.120278, -0.121277, -0.116816,  -0.117064, -0.12151,  -0.120004,  -0.115926,
      -0.118604, -0.121979,  -0.118313, -0.115926, -0.120316, -0.121497,  -0.116712, -0.116867, -0.121678,  -0.120162,
      -0.115706, -0.118503,  -0.122237, -0.118341, -0.115649, -0.120368,  -0.121771, -0.116577, -0.116619,  -0.12189,
      -0.120357, -0.115427,  -0.11838,  -0.122566, -0.118375, -0.115297,  -0.120438, -0.122121, -0.116402,  -0.116303,
      -0.122167, -0.120609,  -0.115063, -0.118223, -0.122995, -0.118414,  -0.114831, -0.12053,  -0.122583,  -0.116168,
      -0.115882, -0.122536,  -0.120944, -0.114572, -0.118012, -0.123578,  -0.118468, -0.114196, -0.120662,  -0.123222,
      -0.115841, -0.115297,  -0.12306,  -0.121418, -0.113872, -0.117709,  -0.124418, -0.118544, -0.113269,  -0.120855,
      -0.124169, -0.115352,  -0.114415, -0.123852, -0.122141, -0.112792,  -0.11724,  -0.125743, -0.118665,  -0.111773,
      -0.121169, -0.125731,  -0.114534, -0.112922, -0.125219, -0.123405,  -0.110868, -0.116393, -0.128186,  -0.118883,
      -0.1089,   -0.121801,  -0.128873, -0.112817, -0.109755, -0.128252,  -0.126242, -0.106292, -0.114391,  -0.134506,
      -0.119328, -0.100676,  -0.123998, -0.139065, -0.106222, -0.0977576, -0.14248,  -0.139143, -0.0770909, -0.104912,
      -0.203146, -0.0835773},
     {0.357994,  0.749131,  0.913493,  0.865359,   0.79225,   0.807122,  0.855402,  0.853813,  0.818567,   0.813226,
      0.839743,  0.849022,  0.829077,  0.817584,   0.832282,  0.84488,   0.834493,  0.821539,  0.828345,   0.841138,
      0.83732,   0.825039,  0.826362,  0.837901,   0.838666,  0.828007,  0.825484,  0.835181,  0.839207,   0.830523,
      0.825181,  0.832812,  0.839342,  0.832812,   0.825181,  0.830523,  0.839207,  0.835181,  0.825484,   0.828007,
      0.838666,  0.837901,  0.826362,  0.825039,   0.837318,  0.841136,  0.828345,  0.821539,  0.834493,   0.84488,
      0.832282,  0.817584,  0.829077,  0.849022,   0.839744,  0.813226,  0.818567,  0.853813,  0.855403,   0.807123,
      0.79225,   0.86536,   0.913494,  0.749133,   0.357997,  -0.03535,  -0.202649, -0.153258, -0.0767716, -0.0918079,
      -0.143571, -0.142958, -0.10447,  -0.0970675, -0.126246, -0.138518, -0.116791, -0.101617, -0.11698,   -0.13363,
      -0.123844, -0.10684,  -0.111729, -0.128175,  -0.127528, -0.112382, -0.109455, -0.122711, -0.128521,  -0.117593,
      -0.10961,  -0.117922, -0.127366, -0.121811,  -0.111602, -0.1144,   -0.124717, -0.124545, -0.114715,  -0.11251,
      -0.121333, -0.125571, -0.118175, -0.11233,   -0.117988, -0.124966, -0.121238, -0.113624, -0.115349,  -0.123099,
      -0.123336, -0.11592,  -0.113871, -0.120532,  -0.124151, -0.118598, -0.113725, -0.117905, -0.123661,  -0.121029,
      -0.114789, -0.115802, -0.122117, -0.122697,  -0.116695, -0.114641, -0.119978, -0.123305, -0.118928,  -0.114593,
      -0.117786, -0.122815, -0.120949, -0.11557,   -0.116052, -0.121433, -0.122305, -0.117257, -0.115142,  -0.119557,
      -0.122735, -0.119202, -0.115203, -0.117665,  -0.122205, -0.120927, -0.11615,  -0.116207, -0.120913,  -0.122038,
      -0.117696, -0.115499, -0.119217, -0.122311,  -0.119432, -0.115662, -0.117547, -0.121733, -0.12093,   -0.116606,
      -0.116308, -0.120493, -0.121842, -0.118057,  -0.115773, -0.11893,  -0.121978, -0.119633, -0.116033,  -0.117439,
      -0.121347, -0.120946, -0.116986, -0.116382,  -0.120141, -0.121688, -0.118365, -0.115995, -0.118681,  -0.121702,
      -0.119811, -0.116345, -0.117339, -0.121019,  -0.120968, -0.117314, -0.11644,  -0.119835, -0.12156,   -0.118636,
      -0.116187, -0.118462, -0.121464, -0.11997,   -0.116618, -0.117248, -0.12073,  -0.120988, -0.117601,  -0.116486,
      -0.119562, -0.121448, -0.118877, -0.116352,  -0.118262, -0.121251, -0.120116, -0.116861, -0.117163,  -0.12047,
      -0.121011, -0.117865, -0.116528, -0.119312,  -0.121347, -0.119099, -0.116506, -0.118081, -0.121057,  -0.12025,
      -0.117086, -0.117084, -0.120228, -0.121029,  -0.118107, -0.116567, -0.119081, -0.121252, -0.119304,  -0.116649,
      -0.117912, -0.120875, -0.120373, -0.117296,  -0.117012, -0.120002, -0.121045, -0.118335, -0.116606,  -0.118864,
      -0.121161, -0.119498, -0.116787, -0.117753,  -0.120699, -0.120487, -0.117497, -0.116947, -0.119786,  -0.121058,
      -0.118552, -0.116646, -0.118658, -0.121072,  -0.119682, -0.11692,  -0.117602, -0.120529, -0.120595,  -0.117692,
      -0.116887, -0.119577, -0.121067, -0.118763,  -0.116688, -0.118459, -0.120981, -0.119857, -0.117053,  -0.11746,
      -0.120364, -0.120698, -0.117884, -0.116831,  -0.119373, -0.121073, -0.118969, -0.116733, -0.118265,  -0.12089,
      -0.120029, -0.117186, -0.117321, -0.120197,  -0.120796, -0.118075, -0.116781, -0.119171, -0.121075,  -0.119171,
      -0.11678,  -0.118074, -0.120796, -0.120197,  -0.117321, -0.117186, -0.120028, -0.12089,  -0.118265,  -0.116732,
      -0.118968, -0.121074, -0.119374, -0.116832,  -0.117884, -0.120698, -0.120363, -0.11746,  -0.117053,  -0.119857,
      -0.120981, -0.118459, -0.116688, -0.118763,  -0.121068, -0.119578, -0.116887, -0.117692, -0.120595,  -0.12053,
      -0.117603, -0.116921, -0.119681, -0.121071,  -0.118658, -0.116647, -0.118553, -0.121058, -0.119786,  -0.116948,
      -0.117498, -0.120488, -0.1207,   -0.117753,  -0.116786, -0.119497, -0.121161, -0.118864, -0.116606,  -0.118335,
      -0.121045, -0.120002, -0.117013, -0.117296,  -0.120372, -0.120874, -0.117911, -0.11665,  -0.119305,  -0.121253,
      -0.119082, -0.116568, -0.118108, -0.12103,   -0.120229, -0.117084, -0.117086, -0.120249, -0.121056,  -0.118081,
      -0.116507, -0.1191,   -0.121348, -0.119312,  -0.116528, -0.117865, -0.121011, -0.120469, -0.117162,  -0.116862,
      -0.120116, -0.121252, -0.118263, -0.116354,  -0.118878, -0.121449, -0.119561, -0.116486, -0.117602,  -0.120988,
      -0.120729, -0.117247, -0.116618, -0.119971,  -0.121464, -0.118461, -0.116185, -0.118635, -0.12156,   -0.119834,
      -0.116439, -0.117313, -0.120967, -0.121019,  -0.117339, -0.116345, -0.119811, -0.121702, -0.118681,  -0.115996,
      -0.118365, -0.121688, -0.120141, -0.116382,  -0.116987, -0.120947, -0.121347, -0.117439, -0.116033,  -0.119634,
      -0.121979, -0.11893,  -0.115773, -0.118056,  -0.121842, -0.120494, -0.116309, -0.116608, -0.120931,  -0.121734,
      -0.117548, -0.115663, -0.119432, -0.122311,  -0.119216, -0.115499, -0.117695, -0.122038, -0.120913,  -0.116206,
      -0.116149, -0.120927, -0.122205, -0.117665,  -0.115203, -0.119202, -0.122734, -0.119556, -0.115141,  -0.117257,
      -0.122306, -0.121433, -0.116052, -0.11557,   -0.120949, -0.122814, -0.117786, -0.114594, -0.118929,  -0.123306,
      -0.119978, -0.11464,  -0.116694, -0.122698,  -0.122118, -0.115802, -0.114788, -0.121028, -0.123661,  -0.117904,
      -0.113725, -0.118598, -0.124152, -0.120533,  -0.113871, -0.115919, -0.123336, -0.1231,   -0.11535,   -0.113625,
      -0.121238, -0.124967, -0.117988, -0.112329,  -0.118174, -0.12557,  -0.121334, -0.112511, -0.114716,  -0.124545,
      -0.124718, -0.1144,   -0.111602, -0.121811,  -0.127366, -0.117922, -0.109609, -0.117591, -0.12852,   -0.122712,
      -0.109457, -0.112383, -0.127528, -0.128175,  -0.111728, -0.106839, -0.123844, -0.13363,  -0.11698,   -0.101617,
      -0.116792, -0.138518, -0.126246, -0.0970671, -0.104469, -0.142957, -0.143571, -0.091808, -0.0767711, -0.153257,
      -0.20265,  -0.0353514},
     {0.358165,  0.6912,    0.885036,   0.907724,   0.839984,  0.789947,  0.802595,   0.844573,   0.862182,
      0.841945,  0.814769,  0.812681,   0.833492,   0.849581,  0.843196,  0.824929,   0.817507,   0.828195,
      0.842458,  0.84328,   0.831055,   0.821301,   0.825235,  0.837156,  0.842476,   0.83536,    0.824923,
      0.823667,  0.832682,  0.840898,   0.838555,   0.828664,  0.823171,  0.828664,   0.838555,   0.840898,
      0.832682,  0.823667,  0.824923,   0.83536,    0.842476,  0.837156,  0.825234,   0.8213,     0.831053,
      0.843279,  0.842458,  0.828196,   0.817507,   0.824928,  0.843196,  0.849581,   0.833493,   0.812682,
      0.81477,   0.841945,  0.862182,   0.844573,   0.802596,  0.789947,  0.839984,   0.907725,   0.885037,
      0.691202,  0.358168,  0.0231034,  -0.174066,  -0.19686,  -0.125823, -0.0735494, -0.0880964, -0.133587,
      -0.151543, -0.127931, -0.0981848, -0.0978861, -0.122538, -0.139317, -0.129396,  -0.10805,   -0.102261,
      -0.117272, -0.132734, -0.129823,  -0.113797,  -0.105397, -0.114277, -0.128153,  -0.129565,  -0.117676,
      -0.108102, -0.112541, -0.124593,  -0.128824,  -0.120435, -0.110593, -0.111646,  -0.121702,  -0.127732,
      -0.122394, -0.11292,  -0.111375,  -0.119338,  -0.126395, -0.123719, -0.115079,  -0.111586,  -0.117435,
      -0.124898, -0.124507, -0.117043,  -0.112177,  -0.115963, -0.123325, -0.124838,  -0.118779,  -0.113054,
      -0.114899, -0.121748, -0.124776,  -0.120257,  -0.114135, -0.114219, -0.120232,  -0.124383,  -0.12145,
      -0.115343, -0.113899, -0.118837,  -0.123725,  -0.122348, -0.116606, -0.113906,  -0.117614,  -0.122867,
      -0.122943, -0.117857, -0.114197,  -0.116597,  -0.121874, -0.123244, -0.119038,  -0.114729,  -0.115814,
      -0.120807, -0.123263, -0.120095,  -0.115449,  -0.115282, -0.119729, -0.123031,  -0.12099,   -0.116302,
      -0.115001, -0.118694, -0.12258,   -0.121689,  -0.117234, -0.114967, -0.117753,  -0.121954,  -0.122175,
      -0.118192, -0.115161, -0.116948,  -0.121199,  -0.122439, -0.119121, -0.115553,  -0.116308,  -0.120362,
      -0.122482, -0.119976, -0.116113,  -0.115858,  -0.119495, -0.122316, -0.120716,  -0.116796,  -0.115607,
      -0.118643, -0.121964, -0.12131,   -0.117562,  -0.115561, -0.117854, -0.121457,  -0.121734,  -0.118363,
      -0.115706, -0.117164, -0.120827,  -0.121972,  -0.119154, -0.116026, -0.116606,  -0.120116,  -0.122024,
      -0.119893, -0.116495, -0.116204,  -0.119368,  -0.121895, -0.120544, -0.117082,  -0.115971,  -0.118621,
      -0.121599, -0.121076, -0.117751,  -0.115917,  -0.11792,  -0.121159, -0.121461,  -0.118459,  -0.116033,
      -0.117299, -0.120605, -0.121688,  -0.11917,   -0.116311, -0.116789, -0.119969,  -0.121746,  -0.119841,
      -0.116727, -0.116415, -0.119292,  -0.121639,  -0.12044,  -0.117256, -0.116194,  -0.118609,  -0.121377,
      -0.120934, -0.117865, -0.116132,  -0.117959,  -0.120979, -0.121299, -0.118519,  -0.11623,   -0.117378,
      -0.120471, -0.121519, -0.11918,   -0.116479,  -0.116894, -0.119881, -0.121583,  -0.119814,  -0.116862,
      -0.116535, -0.119245, -0.121493,  -0.120384,  -0.117356, -0.116315, -0.118597,  -0.121252,  -0.12086,
      -0.117932, -0.116248, -0.117975,  -0.12088,   -0.121217, -0.118556, -0.116333,  -0.117412,  -0.120398,
      -0.121438, -0.119195, -0.116565,  -0.116939,  -0.119831, -0.121509, -0.119811,  -0.11693,   -0.116583,
      -0.119214, -0.121429, -0.120371,  -0.117406,  -0.11636,  -0.118581, -0.121203,  -0.120843,  -0.117967,
      -0.116285, -0.117967, -0.120843,  -0.121203,  -0.118582, -0.116361, -0.117406,  -0.12037,   -0.121429,
      -0.119214, -0.116582, -0.116929,  -0.119811,  -0.121509, -0.119832, -0.11694,   -0.116565,  -0.119195,
      -0.121437, -0.120397, -0.117412,  -0.116333,  -0.118556, -0.121217, -0.12088,   -0.117975,  -0.116249,
      -0.117933, -0.12086,  -0.121252,  -0.118596,  -0.116315, -0.117357, -0.120384,  -0.121493,  -0.119244,
      -0.116535, -0.116863, -0.119814,  -0.121584,  -0.119881, -0.116895, -0.11648,   -0.119181,  -0.121519,
      -0.120471, -0.117378, -0.11623,   -0.118519,  -0.121299, -0.120979, -0.117959,  -0.116132,  -0.117865,
      -0.120934, -0.121377, -0.118609,  -0.116193,  -0.117256, -0.12044,  -0.12164,   -0.119292,  -0.116415,
      -0.116727, -0.119842, -0.121746,  -0.11997,   -0.116789, -0.11631,  -0.119169,  -0.121687,  -0.120604,
      -0.117299, -0.116035, -0.11846,   -0.121462,  -0.121159, -0.11792,  -0.115917,  -0.117751,  -0.121076,
      -0.121599, -0.118622, -0.115973,  -0.117083,  -0.120546, -0.121896, -0.119368,  -0.116204,  -0.116495,
      -0.119893, -0.122023, -0.120116,  -0.116606,  -0.116026, -0.119154, -0.121972,  -0.120826,  -0.117163,
      -0.115705, -0.118362, -0.121733,  -0.121456,  -0.117854, -0.11556,  -0.117562,  -0.121309,  -0.121964,
      -0.118643, -0.115608, -0.116796,  -0.120716,  -0.122316, -0.119494, -0.115858,  -0.116113,  -0.119976,
      -0.122482, -0.120363, -0.116308,  -0.115554,  -0.119121, -0.122439, -0.121199,  -0.116948,  -0.11516,
      -0.118192, -0.122176, -0.121956,  -0.117755,  -0.114968, -0.117235, -0.12169,   -0.122581,  -0.118694,
      -0.115001, -0.116302, -0.120989,  -0.123031,  -0.119729, -0.115281, -0.115448,  -0.120095,  -0.123263,
      -0.120807, -0.115815, -0.114729,  -0.119037,  -0.123243, -0.121873, -0.116597,  -0.114197,  -0.117857,
      -0.122944, -0.122868, -0.117614,  -0.113905,  -0.116605, -0.122347, -0.123725,  -0.118838,  -0.113899,
      -0.115343, -0.12145,  -0.124382,  -0.120232,  -0.11422,  -0.114135, -0.120256,  -0.124775,  -0.121747,
      -0.114898, -0.113054, -0.118779,  -0.124838,  -0.123325, -0.115963, -0.112177,  -0.117043,  -0.124508,
      -0.124899, -0.117436, -0.111587,  -0.115079,  -0.123718, -0.126394, -0.119337,  -0.111375,  -0.11292,
      -0.122396, -0.127733, -0.121703,  -0.111646,  -0.110592, -0.120436, -0.128825,  -0.124594,  -0.112542,
      -0.108101, -0.117674, -0.129564,  -0.128154,  -0.114279, -0.105398, -0.113797,  -0.129823,  -0.132734,
      -0.117271, -0.102261, -0.108049,  -0.129396,  -0.139316, -0.122538, -0.0978864, -0.0981847, -0.127931,
      -0.151543, -0.133586, -0.0880965, -0.0735493, -0.125822, -0.196859, -0.174067,  0.0231021},
     {0.358444,   0.643383,  0.841183,  0.914508,  0.888678,  0.827549,   0.789995,   0.797413,   0.831546,  0.858624,
      0.858339,   0.836372,  0.81469,   0.811129,  0.825831,  0.843944,   0.84991,    0.840258,   0.824888,  0.817306,
      0.823093,   0.836132,  0.844827,  0.842202,  0.83129,   0.821839,   0.82175,    0.83062,    0.840541,  0.843049,
      0.836219,   0.826071,  0.82134,   0.826071,  0.836219,  0.843049,   0.840541,   0.83062,    0.82175,   0.82184,
      0.83129,    0.842202,  0.844826,  0.836131,  0.823092,  0.817305,   0.824887,   0.840259,   0.84991,   0.843944,
      0.825831,   0.811129,  0.81469,   0.836372,  0.858339,  0.858624,   0.831546,   0.797413,   0.789995,  0.827549,
      0.888679,   0.914509,  0.841184,  0.643385,  0.358446,  0.0717314,  -0.129623,  -0.204724,  -0.17709,  -0.11235,
      -0.072986,  -0.082255, -0.120112, -0.149074, -0.146877, -0.121016,  -0.0973261, -0.0957435, -0.114568, -0.134871,
      -0.138793,  -0.124732, -0.106923, -0.10144,  -0.111986, -0.127789,  -0.134349,  -0.12655,   -0.112455, -0.105148,
      -0.110717,  -0.123298, -0.131109, -0.127397, -0.116197, -0.108069,  -0.110207,  -0.120126,  -0.12842,  -0.12763,
      -0.118913,  -0.110578, -0.110208, -0.117789, -0.126059, -0.127431,  -0.120929,  -0.112814,  -0.11058,  -0.116054,
      -0.123935,  -0.126906, -0.12241,  -0.114831, -0.111237, -0.114804,  -0.122023,  -0.126136,  -0.123451, -0.116642,
      -0.112106,  -0.113959, -0.120314, -0.125183, -0.124112, -0.118245,  -0.113127,  -0.113467,  -0.118815, -0.124104,
      -0.124444,  -0.119637, -0.114251, -0.113285, -0.117534, -0.122949,  -0.124487,  -0.120807,  -0.115428, -0.113372,
      -0.116479,  -0.121764, -0.124281, -0.121749, -0.116612, -0.113688,  -0.115651,  -0.120589,  -0.123864, -0.122462,
      -0.117767,  -0.114198, -0.115053, -0.119464, -0.123272, -0.122944,  -0.118852,  -0.11486,   -0.11468,  -0.118423,
      -0.122546,  -0.123207, -0.11984,  -0.115639, -0.114526, -0.117495,  -0.121726,  -0.123259,  -0.120703, -0.116492,
      -0.114573,  -0.116703, -0.120848, -0.123118, -0.12142,  -0.117385,  -0.114804,  -0.116066,  -0.119949, -0.122802,
      -0.121975,  -0.11828,  -0.115196, -0.115596, -0.119068, -0.12234,   -0.122361,  -0.119143,  -0.115725, -0.115298,
      -0.118233,  -0.121756, -0.122571, -0.119942, -0.116357, -0.115173,  -0.117474,  -0.12108,   -0.12261,  -0.120652,
      -0.117065,  -0.115216, -0.116818, -0.120346, -0.122486, -0.121249,  -0.117817,  -0.115417,  -0.116284, -0.119585,
      -0.122214,  -0.121718, -0.118582, -0.115758, -0.115885, -0.118825,  -0.121808,  -0.122043,  -0.119329, -0.116223,
      -0.115635,  -0.118099, -0.121292, -0.122219, -0.120027, -0.116785,  -0.115533,  -0.117434,  -0.120689, -0.122245,
      -0.120653,  -0.11742,  -0.115582, -0.116853, -0.120028, -0.122124,  -0.121183,  -0.118099,  -0.115772, -0.116378,
      -0.119337,  -0.121867, -0.121599, -0.118796, -0.116093, -0.116024,  -0.118642,  -0.121485,  -0.121887, -0.11948,
      -0.116529,  -0.115803, -0.117975, -0.121001, -0.12204,  -0.120125,  -0.117059,  -0.11572,   -0.117359, -0.120431,
      -0.122052,  -0.120705, -0.11766,  -0.115777, -0.11682,  -0.119804,  -0.121927,  -0.121199,  -0.118308, -0.11597,
      -0.116378,  -0.119145, -0.12167,  -0.121585, -0.118973, -0.116287,  -0.116049,  -0.11848,   -0.121295, -0.121853,
      -0.119631,  -0.116718, -0.115847, -0.117836, -0.120816, -0.121989,  -0.120254,  -0.117241,  -0.115779, -0.117241,
      -0.120254,  -0.121989, -0.120816, -0.117837, -0.115847, -0.116717,  -0.119631,  -0.121852,  -0.121294, -0.118479,
      -0.11605,   -0.116288, -0.118974, -0.121587, -0.121671, -0.119145,  -0.116378,  -0.11597,   -0.118307, -0.121198,
      -0.121927,  -0.119804, -0.11682,  -0.115778, -0.117661, -0.120706,  -0.122053,  -0.120432,  -0.117359, -0.11572,
      -0.117059,  -0.120125, -0.12204,  -0.121001, -0.117975, -0.115803,  -0.116529,  -0.11948,   -0.121888, -0.121486,
      -0.118643,  -0.116024, -0.116094, -0.118796, -0.121599, -0.121867,  -0.119336,  -0.116377,  -0.115772, -0.1181,
      -0.121183,  -0.122124, -0.120028, -0.116853, -0.115582, -0.11742,   -0.120653,  -0.122245,  -0.12069,  -0.117434,
      -0.115534,  -0.116785, -0.120027, -0.12222,  -0.121292, -0.118099,  -0.115634,  -0.116222,  -0.119328, -0.122043,
      -0.121808,  -0.118826, -0.115887, -0.115759, -0.118583, -0.121718,  -0.122214,  -0.119584,  -0.116284, -0.115417,
      -0.117818,  -0.12125,  -0.122488, -0.120347, -0.116819, -0.115217,  -0.117066,  -0.120652,  -0.12261,  -0.12108,
      -0.117474,  -0.115173, -0.116357, -0.119943, -0.122571, -0.121756,  -0.118232,  -0.115297,  -0.115724, -0.119143,
      -0.12236,   -0.12234,  -0.119068, -0.115595, -0.115196, -0.11828,   -0.121975,  -0.122803,  -0.11995,  -0.116066,
      -0.114804,  -0.117385, -0.12142,  -0.123118, -0.120848, -0.116704,  -0.114573,  -0.116493,  -0.120703, -0.123259,
      -0.121726,  -0.117495, -0.114525, -0.115638, -0.11984,  -0.123207,  -0.122547,  -0.118424,  -0.114682, -0.114861,
      -0.118853,  -0.122945, -0.123272, -0.119464, -0.115053, -0.114197,  -0.117766,  -0.122461,  -0.123863, -0.120588,
      -0.11565,   -0.113688, -0.116613, -0.121749, -0.124282, -0.121763,  -0.116478,  -0.113371,  -0.115427, -0.120807,
      -0.124488,  -0.122949, -0.117535, -0.113285, -0.114251, -0.119636,  -0.124443,  -0.124104,  -0.118815, -0.113467,
      -0.113127,  -0.118245, -0.124112, -0.125183, -0.120314, -0.11396,   -0.112106,  -0.116642,  -0.12345,  -0.126136,
      -0.122023,  -0.114804, -0.111237, -0.114831, -0.12241,  -0.126906,  -0.123935,  -0.116055,  -0.110581, -0.112815,
      -0.12093,   -0.127431, -0.126058, -0.117788, -0.110207, -0.110578,  -0.118914,  -0.127632,  -0.128421, -0.120127,
      -0.110207,  -0.108069, -0.116198, -0.127398, -0.131109, -0.123298,  -0.110717,  -0.105148,  -0.112455, -0.12655,
      -0.13435,   -0.12779,  -0.111986, -0.10144,  -0.106922, -0.12473,   -0.138792,  -0.13487,   -0.114568, -0.0957437,
      -0.0973261, -0.121016, -0.146877, -0.149074, -0.120112, -0.0822549, -0.0729857, -0.112349,  -0.17709,  -0.204724,
      -0.129624,  0.0717301},
     {0.362046,   0.606632,   0.793769,   0.893401,   0.909067,   0.871914,  0.823146,   0.794585,  0.796976,
      0.820634,   0.846069,   0.857337,   0.850501,   0.833463,   0.81887,   0.815488,   0.823458,  0.83569,
      0.843563,   0.842697,   0.83512,    0.826954,   0.823748,   0.826848,  0.833091,   0.837616,  0.837495,
      0.833555,   0.829319,   0.828089,   0.830471,   0.834132,   0.835844,  0.834132,   0.830471,  0.828089,
      0.829319,   0.833555,   0.837495,   0.837617,   0.833091,   0.826847,  0.823747,   0.826953,  0.835119,
      0.842696,   0.843563,   0.83569,    0.823458,   0.815488,   0.81887,   0.833462,   0.850502,  0.857337,
      0.846069,   0.820634,   0.796977,   0.794585,   0.823146,   0.871914,  0.909068,   0.893402,  0.793771,
      0.606633,   0.362047,   0.11393,    -0.0814843, -0.188707,  -0.206288, -0.16409,   -0.106607, -0.0713788,
      -0.0735555, -0.103644,  -0.137973,  -0.154754,  -0.146373,  -0.121664, -0.098265,  -0.090748, -0.102064,
      -0.123036,  -0.139349,  -0.141023,  -0.128276,  -0.110492,  -0.099503, -0.101876,  -0.11512,  -0.12993,
      -0.136621,  -0.13137,   -0.118304,  -0.106363,  -0.103243,  -0.110499, -0.122864,  -0.132025, -0.132164,
      -0.123616,  -0.11236,   -0.10587,   -0.108184,  -0.11742,   -0.127252, -0.131219,  -0.126948, -0.117548,
      -0.109369,  -0.107731,  -0.113481,  -0.122594,  -0.128975,  -0.128522, -0.12175,   -0.113305, -0.10879,
      -0.111057,  -0.118417,  -0.125883,  -0.128539,  -0.124768,  -0.117226, -0.110978,  -0.110106, -0.115048,
      -0.122402,  -0.127264,  -0.126487,  -0.120718,  -0.113876,  -0.110498, -0.112734,  -0.118987, -0.125043,
      -0.12691,   -0.123444,  -0.117041,  -0.11199,   -0.111598,  -0.116034, -0.122274,  -0.126162, -0.125173,
      -0.12005,   -0.114254,  -0.111627,  -0.11385,   -0.11937,   -0.12448,  -0.125809,  -0.122541, -0.116911,
      -0.112682,  -0.112628,  -0.11672,   -0.122187,  -0.12539,   -0.124244, -0.119571,  -0.114516, -0.11243,
      -0.114652,  -0.119651,  -0.12408,   -0.125013,  -0.121879,  -0.116808, -0.113183,  -0.113386, -0.117236,
      -0.122135,  -0.124825,  -0.123551,  -0.119204,  -0.114702,  -0.113029, -0.115262,  -0.119876, -0.123787,
      -0.124409,  -0.121366,  -0.116715,  -0.113556,  -0.113969,  -0.117644, -0.12211,   -0.124398, -0.123012,
      -0.118907,  -0.114832,  -0.11349,   -0.115745,  -0.120068,  -0.123573, -0.12394,   -0.120954, -0.116625,
      -0.113838,  -0.114429,  -0.117978,  -0.122105,  -0.124065,  -0.122576, -0.118652,  -0.114917, -0.11385,
      -0.116139,  -0.12024,   -0.123416,  -0.123565,  -0.12061,   -0.116534, -0.114052,  -0.114803, -0.118264,
      -0.122121,  -0.123808,  -0.122218,  -0.118428,  -0.11497,   -0.114138, -0.116471,  -0.120399, -0.123304,
      -0.12326,   -0.120313,  -0.116438,  -0.114214,  -0.115112,  -0.118518, -0.122156,  -0.123607, -0.121916,
      -0.118222,  -0.114991,  -0.114368,  -0.116757,  -0.120555,  -0.123231, -0.12301,   -0.120052, -0.116334,
      -0.114332,  -0.115371,  -0.118748,  -0.122209,  -0.123451,  -0.121655, -0.118027,  -0.114986, -0.114554,
      -0.11701,   -0.120711,  -0.123192,  -0.122804,  -0.119814,  -0.116218, -0.114411,  -0.115591, -0.118965,
      -0.122282,  -0.123335,  -0.121428,  -0.117836,  -0.114954,  -0.1147,   -0.117237,  -0.120872, -0.123183,
      -0.122633,  -0.119593,  -0.116091,  -0.114458,  -0.115781,  -0.119174, -0.122376,  -0.123254, -0.121226,
      -0.117645,  -0.114898,  -0.114813,  -0.117447,  -0.121042,  -0.123204, -0.122492,  -0.119382, -0.115946,
      -0.114474,  -0.115946,  -0.119382,  -0.122492,  -0.123204,  -0.121042, -0.117447,  -0.114813, -0.114897,
      -0.117644,  -0.121225,  -0.123254,  -0.122376,  -0.119175,  -0.115782, -0.114459,  -0.116091, -0.119593,
      -0.122633,  -0.123182,  -0.120871,  -0.117236,  -0.114699,  -0.114954, -0.117836,  -0.121429, -0.123336,
      -0.122283,  -0.118966,  -0.115591,  -0.114412,  -0.116218,  -0.119814, -0.122804,  -0.123191, -0.120711,
      -0.11701,   -0.114554,  -0.114986,  -0.118027,  -0.121656,  -0.123452, -0.12221,   -0.118749, -0.115371,
      -0.114332,  -0.116333,  -0.120051,  -0.12301,   -0.12323,   -0.120555, -0.116757,  -0.114369, -0.114991,
      -0.118222,  -0.121915,  -0.123606,  -0.122156,  -0.118518,  -0.115112, -0.114215,  -0.116438, -0.120314,
      -0.12326,   -0.123304,  -0.1204,    -0.116471,  -0.114138,  -0.114969, -0.118428,  -0.122218, -0.123808,
      -0.122121,  -0.118265,  -0.114804,  -0.114053,  -0.116535,  -0.12061,  -0.123565,  -0.123415, -0.120239,
      -0.116139,  -0.113851,  -0.114918,  -0.118653,  -0.122577,  -0.124066, -0.122105,  -0.117978, -0.114429,
      -0.113838,  -0.116625,  -0.120953,  -0.12394,   -0.123573,  -0.120068, -0.115745,  -0.113489, -0.114831,
      -0.118906,  -0.123011,  -0.124397,  -0.122109,  -0.117643,  -0.113969, -0.113556,  -0.116715, -0.121366,
      -0.124409,  -0.123787,  -0.119876,  -0.115262,  -0.113029,  -0.114701, -0.119204,  -0.123551, -0.124825,
      -0.122135,  -0.117236,  -0.113387,  -0.113183,  -0.116808,  -0.121879, -0.125012,  -0.124079, -0.119651,
      -0.114652,  -0.11243,   -0.114517,  -0.119573,  -0.124245,  -0.125391, -0.122187,  -0.116721, -0.112628,
      -0.112682,  -0.116911,  -0.122541,  -0.125809,  -0.124479,  -0.119369, -0.11385,   -0.111627, -0.114254,
      -0.120051,  -0.125173,  -0.126162,  -0.122274,  -0.116034,  -0.111598, -0.11199,   -0.117041, -0.123444,
      -0.126911,  -0.125044,  -0.118987,  -0.112734,  -0.110497,  -0.113876, -0.120718,  -0.126488, -0.127264,
      -0.122403,  -0.115048,  -0.110106,  -0.110979,  -0.117226,  -0.124768, -0.128538,  -0.125882, -0.118416,
      -0.111056,  -0.10879,   -0.113305,  -0.12175,   -0.128522,  -0.128975, -0.122594,  -0.113481, -0.107732,
      -0.10937,   -0.117549,  -0.126949,  -0.131219,  -0.127251,  -0.117419, -0.108184,  -0.10587,  -0.11236,
      -0.123617,  -0.132165,  -0.132026,  -0.122865,  -0.110499,  -0.103243, -0.106363,  -0.118304, -0.13137,
      -0.136621,  -0.12993,   -0.11512,   -0.101876,  -0.0995036, -0.110492, -0.128277,  -0.141023, -0.139349,
      -0.123035,  -0.102063,  -0.0907472, -0.0982645, -0.121664,  -0.146373, -0.154754,  -0.137973, -0.103644,
      -0.0735552, -0.0713781, -0.106607,  -0.16409,   -0.206287,  -0.188708, -0.0814851, 0.113929},
     {0.353912,   0.558208,  0.732546,   0.853799,   0.912854,   0.916134,  0.882328,   0.83563,   0.797897,  0.782414,
      0.791184,   0.816355,  0.844836,   0.864154,   0.867277,   0.854743,  0.833571,   0.813704,  0.803614,  0.806901,
      0.821169,   0.839473,  0.853567,   0.857489,   0.849997,   0.834871,  0.819075,   0.809626,  0.81055,   0.821214,
      0.836701,   0.85003,   0.855248,   0.850031,   0.836701,   0.821215,  0.81055,    0.809626,  0.819075,  0.834871,
      0.849997,   0.857488,  0.853566,   0.839473,   0.821169,   0.8069,    0.803614,   0.813704,  0.833571,  0.854743,
      0.867277,   0.864154,  0.844837,   0.816355,   0.791185,   0.782414,  0.797898,   0.83563,   0.882329,  0.916134,
      0.912855,   0.853801,  0.732547,   0.55821,    0.353914,   0.150816,  -0.0204368, -0.138043, -0.194465, -0.19728,
      -0.165416,  -0.122265, -0.0881668, -0.0748077, -0.0832113, -0.105605, -0.130049,  -0.145822, -0.147501, -0.136363,
      -0.118929,  -0.103562, -0.0967292, -0.100478,  -0.112048,  -0.125553, -0.134832,  -0.13615,  -0.129609, -0.118779,
      -0.108842,  -0.10418,  -0.1065,    -0.114265,  -0.123607,  -0.130207, -0.131257,  -0.126621, -0.118737, -0.11137,
      -0.107839,  -0.109544, -0.115434,  -0.122611,  -0.127734,  -0.128561, -0.124913,  -0.118666, -0.112796, -0.10998,
      -0.111383,  -0.116187, -0.122047,  -0.126224,  -0.12686,   -0.123792, -0.118572,  -0.113684, -0.111374, -0.112623,
      -0.116734,  -0.121712, -0.125224,  -0.12569,   -0.122987,  -0.118463, -0.114271,  -0.112346, -0.113519, -0.117159,
      -0.121506,  -0.124521, -0.124835,  -0.122373,  -0.11835,   -0.11468,  -0.113063,  -0.114205, -0.117508, -0.121381,
      -0.124004,  -0.124181, -0.121882,  -0.118236,  -0.114973,  -0.113612, -0.11475,   -0.117803, -0.121306, -0.12361,
      -0.123661,  -0.121476, -0.118121,  -0.115189,  -0.114046,  -0.115196, -0.118059,  -0.121264, -0.123301, -0.123234,
      -0.121129,  -0.118008, -0.115352,  -0.114401,  -0.115574,  -0.118289, -0.121247,  -0.123053, -0.122877, -0.120828,
      -0.117898,  -0.115477, -0.114696,  -0.1159,    -0.118497,  -0.121246, -0.12285,   -0.12257,  -0.120561, -0.117791,
      -0.115573,  -0.114946, -0.116187,  -0.118688,  -0.121257,  -0.122682, -0.122304,  -0.120321, -0.117687, -0.11565,
      -0.115165,  -0.116444, -0.118865,  -0.121275,  -0.122537,  -0.122065, -0.1201,    -0.117583, -0.115709, -0.115355,
      -0.116676,  -0.119031, -0.1213,    -0.122411,  -0.12185,   -0.119895, -0.117482,  -0.115756, -0.115526, -0.11689,
      -0.11919,   -0.121331, -0.122303,  -0.121654,  -0.119704,  -0.117383, -0.115793,  -0.115681, -0.117089, -0.119341,
      -0.121366,  -0.122207, -0.121473,  -0.119523,  -0.117286,  -0.115823, -0.115822,  -0.117276, -0.119486, -0.121403,
      -0.12212,   -0.121304, -0.11935,   -0.117189,  -0.115846,  -0.115953, -0.117452,  -0.119627, -0.121442, -0.122041,
      -0.121144,  -0.119184, -0.117094,  -0.115865,  -0.116076,  -0.117622, -0.119764,  -0.121484, -0.121968, -0.120992,
      -0.119023,  -0.116998, -0.115879,  -0.116193,  -0.117786,  -0.119899, -0.121528,  -0.121902, -0.120846, -0.118865,
      -0.116903,  -0.115889, -0.116303,  -0.117945,  -0.120033,  -0.121575, -0.12184,   -0.120705, -0.118712, -0.116808,
      -0.115897,  -0.11641,  -0.118101,  -0.120166,  -0.121623,  -0.121781, -0.120567,  -0.118559, -0.116711, -0.115901,
      -0.116513,  -0.118255, -0.120299,  -0.121673,  -0.121726,  -0.120432, -0.118407,  -0.116613, -0.115902, -0.116613,
      -0.118407,  -0.120432, -0.121726,  -0.121673,  -0.120299,  -0.118255, -0.116512,  -0.115901, -0.116711, -0.118559,
      -0.120567,  -0.121781, -0.121623,  -0.120166,  -0.118102,  -0.11641,  -0.115897,  -0.116807, -0.118711, -0.120704,
      -0.121839,  -0.121575, -0.120033,  -0.117946,  -0.116304,  -0.11589,  -0.116903,  -0.118866, -0.120846, -0.121902,
      -0.121528,  -0.119899, -0.117786,  -0.116193,  -0.115879,  -0.116999, -0.119023,  -0.120992, -0.121969, -0.121485,
      -0.119765,  -0.117623, -0.116077,  -0.115865,  -0.117094,  -0.119184, -0.121144,  -0.12204,  -0.121442, -0.119626,
      -0.117453,  -0.115954, -0.115847,  -0.117189,  -0.11935,   -0.121304, -0.12212,   -0.121403, -0.119486, -0.117276,
      -0.115823,  -0.115824, -0.117286,  -0.119523,  -0.121473,  -0.122206, -0.121365,  -0.11934,  -0.117088, -0.115681,
      -0.115794,  -0.117384, -0.119704,  -0.121655,  -0.122303,  -0.121331, -0.11919,   -0.11689,  -0.115526, -0.115756,
      -0.117483,  -0.119896, -0.121851,  -0.122413,  -0.121301,  -0.119032, -0.116676,  -0.115355, -0.115708, -0.117583,
      -0.120099,  -0.122065, -0.122536,  -0.121275,  -0.118865,  -0.116443, -0.115164,  -0.115649, -0.117686, -0.12032,
      -0.122303,  -0.122681, -0.121256,  -0.118688,  -0.116187,  -0.114946, -0.115573,  -0.117791, -0.120561, -0.12257,
      -0.12285,   -0.121245, -0.118497,  -0.1159,    -0.114696,  -0.115477, -0.117899,  -0.120829, -0.122877, -0.123054,
      -0.121247,  -0.118289, -0.115574,  -0.114401,  -0.115352,  -0.118009, -0.12113,   -0.123235, -0.123302, -0.121265,
      -0.11806,   -0.115197, -0.114046,  -0.115189,  -0.118121,  -0.121475, -0.12366,   -0.12361,  -0.121305, -0.117803,
      -0.114749,  -0.113612, -0.114973,  -0.118235,  -0.121882,  -0.124181, -0.124004,  -0.121381, -0.117508, -0.114205,
      -0.113063,  -0.11468,  -0.11835,   -0.122373,  -0.124835,  -0.12452,  -0.121506,  -0.117159, -0.113519, -0.112346,
      -0.114271,  -0.118463, -0.122987,  -0.12569,   -0.125224,  -0.121712, -0.116734,  -0.112623, -0.111374, -0.113683,
      -0.118571,  -0.123792, -0.12686,   -0.126225,  -0.122047,  -0.116188, -0.111384,  -0.109981, -0.112797, -0.118667,
      -0.124914,  -0.128561, -0.127734,  -0.12261,   -0.115434,  -0.109544, -0.107839,  -0.11137,  -0.118737, -0.126622,
      -0.131258,  -0.130208, -0.123608,  -0.114265,  -0.1065,    -0.10418,  -0.108841,  -0.118779, -0.129609, -0.13615,
      -0.134833,  -0.125554, -0.112049,  -0.100478,  -0.0967288, -0.103562, -0.118928,  -0.136362, -0.1475,   -0.145822,
      -0.130049,  -0.105605, -0.0832114, -0.0748076, -0.0881663, -0.122265, -0.165416,  -0.197279, -0.194465, -0.138044,
      -0.0204376, 0.150815},
     {0.349073,  0.525306,  0.684169,   0.808909,   0.88932,    0.9236,     0.918274,   0.886222,   0.843345,
      0.804741,  0.781353,  0.777913,   0.792625,   0.818544,   0.8462,     0.866629,   0.873988,   0.867029,
      0.849096,  0.826757,  0.807541,   0.797534,   0.799535,   0.812343,   0.831312,   0.849972,   0.862171,
      0.864042,  0.855193,  0.83876,    0.820323,   0.806057,   0.800711,   0.806058,   0.820323,   0.83876,
      0.855193,  0.864042,  0.862171,   0.849972,   0.831312,   0.812343,   0.799535,   0.797533,   0.807541,
      0.826756,  0.849095,  0.867028,   0.873988,   0.866629,   0.8462,     0.818545,   0.792625,   0.777914,
      0.781353,  0.80474,   0.843345,   0.886222,   0.918275,   0.9236,     0.889321,   0.808911,   0.684171,
      0.525308,  0.349074,  0.175407,   0.0233825,  -0.0925452, -0.165134,  -0.195226,  -0.190774,  -0.164393,
      -0.1301,   -0.100115, -0.0824672, -0.0799178, -0.0903128, -0.108109,  -0.126535,  -0.139743,  -0.144371,
      -0.140174, -0.12966,  -0.116964,  -0.106383,  -0.10104,   -0.102053,  -0.108414,  -0.117532,  -0.126204,
      -0.131686, -0.13251,  -0.128831,  -0.122231,  -0.115092,  -0.109769,  -0.107841,  -0.109669,  -0.114374,
      -0.120214, -0.125207, -0.127787,  -0.12728,   -0.124058,  -0.119351,  -0.11479,   -0.111858,  -0.111413,
      -0.113451, -0.117158, -0.121224,  -0.124296,  -0.125421,  -0.124337,  -0.121517,  -0.117978,  -0.114921,
      -0.113326, -0.113644, -0.115679,  -0.118677,  -0.121607,  -0.123506,  -0.123795,  -0.122452,  -0.11999,
      -0.117272, -0.115203, -0.114441,  -0.115183,  -0.117122,  -0.11957,   -0.121697,  -0.122814,  -0.122589,
      -0.121147, -0.119012, -0.116914,  -0.115548,  -0.115339,  -0.116316,  -0.118114,  -0.12011,   -0.121635,
      -0.1222,   -0.121648, -0.120198,  -0.118361,  -0.116757,  -0.115913,  -0.116084,  -0.117184,  -0.118819,
      -0.120431, -0.121485, -0.121646,  -0.120886,  -0.119484,  -0.117923,  -0.116726,  -0.116282,  -0.116718,
      -0.117868, -0.119329, -0.120607,  -0.121283,  -0.121145,  -0.12026,   -0.11894,   -0.117635,  -0.11678,
      -0.116649, -0.117269, -0.118416,  -0.119697,  -0.120682,  -0.121048,  -0.120686,  -0.119734,  -0.11852,
      -0.117455, -0.116892, -0.117007,  -0.11775,   -0.11886,   -0.11996,   -0.120682,  -0.120793,  -0.120267,
      -0.119291, -0.1182,   -0.117359,  -0.117046,  -0.117356,  -0.118174,  -0.119219,  -0.120137,  -0.120624,
      -0.120524, -0.119879, -0.118915,  -0.117957,  -0.117327,  -0.11723,   -0.117691,  -0.118547,  -0.119507,
      -0.120247, -0.120523, -0.12025,   -0.119525,  -0.118598,  -0.117782,  -0.117348,  -0.117437,  -0.118013,
      -0.118876, -0.119734, -0.1203,    -0.120387,  -0.119972,  -0.1192,    -0.118333,  -0.117663,  -0.117413,
      -0.117661, -0.11832,  -0.119164,  -0.119909,  -0.120305,  -0.120223,  -0.119696,  -0.118903,  -0.118115,
      -0.117594, -0.117514, -0.117897,  -0.118611,  -0.119413,  -0.120034,  -0.120267,  -0.120036,  -0.119422,
      -0.118635, -0.11794,  -0.117569,  -0.117646,  -0.11814,   -0.118884,  -0.119626,  -0.120116,  -0.120192,
      -0.11983,  -0.119155, -0.118396,  -0.117807,  -0.117586,  -0.117806,  -0.11839,   -0.11914,   -0.119803,
      -0.120157, -0.120083, -0.11961,   -0.118896,  -0.118184,  -0.117713,  -0.11764,   -0.117989,  -0.118641,
      -0.119376, -0.119945, -0.120159,  -0.119946,  -0.119378,  -0.118648,  -0.118002,  -0.117657,  -0.117728,
      -0.118192, -0.118891, -0.11959,   -0.120053,  -0.120124,  -0.11978,   -0.119138,  -0.118413,  -0.117849,
      -0.117638, -0.117849, -0.118413,  -0.119138,  -0.11978,   -0.120124,  -0.120052,  -0.119589,  -0.118891,
      -0.118192, -0.117728, -0.117657,  -0.118002,  -0.118648,  -0.119378,  -0.119946,  -0.12016,   -0.119946,
      -0.119376, -0.118641, -0.117989,  -0.11764,   -0.117712,  -0.118184,  -0.118896,  -0.11961,   -0.120084,
      -0.120158, -0.119804, -0.11914,   -0.11839,   -0.117806,  -0.117586,  -0.117806,  -0.118395,  -0.119155,
      -0.11983,  -0.120192, -0.120117,  -0.119627,  -0.118885,  -0.118141,  -0.117647,  -0.11757,   -0.11794,
      -0.118635, -0.119422, -0.120035,  -0.120267,  -0.120034,  -0.119413,  -0.118611,  -0.117897,  -0.117514,
      -0.117594, -0.118114, -0.118903,  -0.119695,  -0.120223,  -0.120305,  -0.119909,  -0.119165,  -0.118321,
      -0.117662, -0.117413, -0.117663,  -0.118333,  -0.119199,  -0.119972,  -0.120387,  -0.1203,    -0.119734,
      -0.118877, -0.118014, -0.117438,  -0.117349,  -0.117782,  -0.118598,  -0.119525,  -0.120249,  -0.120523,
      -0.120247, -0.119507, -0.118548,  -0.117692,  -0.117231,  -0.117328,  -0.117958,  -0.118915,  -0.11988,
      -0.120524, -0.120624, -0.120137,  -0.119218,  -0.118174,  -0.117355,  -0.117046,  -0.117359,  -0.118199,
      -0.119291, -0.120266, -0.120792,  -0.120681,  -0.119959,  -0.11886,   -0.11775,   -0.117007,  -0.116892,
      -0.117456, -0.11852,  -0.119734,  -0.120686,  -0.121047,  -0.120681,  -0.119697,  -0.118416,  -0.117269,
      -0.116649, -0.11678,  -0.117635,  -0.11894,   -0.12026,   -0.121145,  -0.121283,  -0.120607,  -0.119329,
      -0.117868, -0.116719, -0.116283,  -0.116727,  -0.117924,  -0.119485,  -0.120887,  -0.121647,  -0.121485,
      -0.120431, -0.118819, -0.117183,  -0.116083,  -0.115912,  -0.116757,  -0.11836,   -0.120198,  -0.121647,
      -0.122199, -0.121635, -0.12011,   -0.118114,  -0.116316,  -0.115339,  -0.115548,  -0.116914,  -0.119012,
      -0.121147, -0.122589, -0.122814,  -0.121697,  -0.119569,  -0.117122,  -0.115183,  -0.114441,  -0.115204,
      -0.117272, -0.119991, -0.122452,  -0.123795,  -0.123506,  -0.121607,  -0.118677,  -0.115679,  -0.113644,
      -0.113325, -0.114921, -0.117978,  -0.121517,  -0.124337,  -0.125421,  -0.124296,  -0.121225,  -0.117159,
      -0.113452, -0.111414, -0.111859,  -0.11479,   -0.11935,   -0.124058,  -0.12728,   -0.127787,  -0.125207,
      -0.120214, -0.114375, -0.10967,   -0.107842,  -0.109769,  -0.115092,  -0.122231,  -0.128831,  -0.13251,
      -0.131686, -0.126204, -0.117532,  -0.108414,  -0.102053,  -0.10104,   -0.106384,  -0.116964,  -0.12966,
      -0.140174, -0.14437,  -0.139742,  -0.126534,  -0.108109,  -0.0903126, -0.0799176, -0.0824672, -0.100115,
      -0.1301,   -0.164393, -0.190774,  -0.195225,  -0.165134,  -0.0925454, 0.0233819,  0.175406},
     {0.347558,  0.495289,  0.633477,   0.75157,    0.841667,   0.899599,   0.925417,   0.923194,   0.900201,
      0.865583,  0.828797,  0.798081,   0.779218,   0.774805,   0.784147,   0.803741,   0.828254,   0.851777,
      0.869091,  0.876717,  0.873534,   0.86088,    0.842127,   0.821846,   0.804756,   0.794677,   0.79372,
      0.801863,  0.817016,  0.835532,   0.853054,   0.865502,   0.869998,   0.865503,   0.853054,   0.835533,
      0.817016,  0.801863,  0.79372,    0.794677,   0.804756,   0.821845,   0.842126,   0.86088,    0.873533,
      0.876716,  0.86909,   0.851777,   0.828254,   0.803741,   0.784148,   0.774806,   0.779218,   0.798081,
      0.828797,  0.865583,  0.900201,   0.923194,   0.925417,   0.8996,     0.841668,   0.751571,   0.633478,
      0.49529,   0.347559,  0.201986,   0.0697663,  -0.039952,  -0.121237,  -0.172,     -0.193992,  -0.192211,
      -0.173851, -0.146994, -0.119289,  -0.0968334, -0.0834438, -0.0803867, -0.0865877, -0.0992245, -0.114558,
      -0.128821, -0.138998, -0.143348,  -0.141613,  -0.13489,   -0.125242,  -0.115148,  -0.106922,  -0.10223,
      -0.101788, -0.1053,   -0.111614,  -0.119056,  -0.125843,  -0.130489,  -0.13211,   -0.130573,  -0.126469,
      -0.120921, -0.1153,   -0.110894,  -0.108625,  -0.108869,  -0.111405,  -0.115505,  -0.120132,  -0.124193,
      -0.126792, -0.127417, -0.126039,  -0.123088,  -0.11933,   -0.115673,  -0.112952,  -0.111745,  -0.112252,
      -0.11427,  -0.117258, -0.12048,   -0.123182,  -0.124765,  -0.124915,  -0.123663,  -0.12136,   -0.118586,
      -0.116002, -0.114197, -0.113556,  -0.11418,   -0.115871,  -0.118197,  -0.120593,  -0.122502,  -0.1235,
      -0.123389, -0.122238, -0.120351,  -0.118192,  -0.116272,  -0.115029,  -0.114727,  -0.115404,  -0.116871,
      -0.11876,  -0.120618, -0.122015,  -0.122641,  -0.122375,  -0.121305,  -0.119705,  -0.117964,  -0.116491,
      -0.11562,  -0.115537, -0.116239,  -0.117539,  -0.11912,   -0.120604,  -0.121649,  -0.122022,  -0.121655,
      -0.120653, -0.119265, -0.117825,  -0.116669,  -0.116062,  -0.11613,   -0.116842,  -0.118016,  -0.119367,
      -0.120577, -0.121365, -0.121557,  -0.121122,  -0.120175,  -0.118948,  -0.117735,  -0.116817,  -0.116404,
      -0.116581, -0.117296, -0.11837,   -0.119545,  -0.120545,  -0.121139,  -0.121195,  -0.120712,  -0.119811,
      -0.118712, -0.117675, -0.116941,  -0.116678,  -0.116938,  -0.117651,  -0.118644,  -0.119679,  -0.120512,
      -0.120952, -0.120902, -0.120382,  -0.11952,   -0.118524,  -0.117629,  -0.117044,  -0.1169,    -0.117226,
      -0.117939, -0.118865, -0.119785,  -0.120483,  -0.120798,  -0.120662,  -0.120112,  -0.119283,  -0.118372,
      -0.117595, -0.117132, -0.117087,  -0.117468,  -0.118178,  -0.119049,  -0.119872,  -0.120457,  -0.120667,
      -0.120458, -0.119884, -0.119082,  -0.118243,  -0.117565,  -0.117206,  -0.117247,  -0.117674,  -0.118384,
      -0.119207, -0.119949, -0.120435,  -0.120555,  -0.120282,  -0.119685,  -0.118905,  -0.118129,  -0.117538,
      -0.11727,  -0.117386, -0.117856,  -0.118566,  -0.119348,  -0.120018,  -0.120418,  -0.120457,  -0.120126,
      -0.119507, -0.118746, -0.118024,  -0.117511,  -0.117325,  -0.11751,   -0.118019,  -0.118732,  -0.119479,
      -0.120085, -0.120406, -0.12037,   -0.119985,  -0.119344,  -0.118598,  -0.117925,  -0.117482,  -0.117373,
      -0.117622, -0.118171, -0.118888,  -0.119605,  -0.120151,  -0.1204,    -0.120292,  -0.119854,  -0.119189,
      -0.118456, -0.117827, -0.11745,   -0.117414,  -0.117727,  -0.118315,  -0.119039,  -0.119728,  -0.12022,
      -0.120397, -0.12022,  -0.119728,  -0.119039,  -0.118315,  -0.117727,  -0.117414,  -0.11745,   -0.117827,
      -0.118456, -0.11919,  -0.119854,  -0.120292,  -0.1204,    -0.120152,  -0.119605,  -0.118888,  -0.118171,
      -0.117622, -0.117373, -0.117482,  -0.117925,  -0.118598,  -0.119344,  -0.119985,  -0.12037,   -0.120407,
      -0.120085, -0.11948,  -0.118732,  -0.11802,   -0.11751,   -0.117325,  -0.117511,  -0.118024,  -0.118746,
      -0.119507, -0.120126, -0.120457,  -0.120419,  -0.120019,  -0.119349,  -0.118567,  -0.117856,  -0.117386,
      -0.11727,  -0.117538, -0.118129,  -0.118905,  -0.119684,  -0.120282,  -0.120554,  -0.120435,  -0.119948,
      -0.119207, -0.118384, -0.117675,  -0.117247,  -0.117207,  -0.117566,  -0.118243,  -0.119082,  -0.119884,
      -0.120459, -0.120667, -0.120457,  -0.119872,  -0.119049,  -0.118178,  -0.117468,  -0.117088,  -0.117132,
      -0.117595, -0.118372, -0.119283,  -0.120112,  -0.120662,  -0.120798,  -0.120483,  -0.119785,  -0.118865,
      -0.117939, -0.117227, -0.116901,  -0.117044,  -0.11763,   -0.118525,  -0.119521,  -0.120383,  -0.120903,
      -0.120952, -0.120512, -0.119679,  -0.118644,  -0.117651,  -0.116937,  -0.116677,  -0.11694,   -0.117674,
      -0.118711, -0.11981,  -0.120711,  -0.121195,  -0.121138,  -0.120544,  -0.119545,  -0.11837,   -0.117296,
      -0.116581, -0.116404, -0.116817,  -0.117735,  -0.118948,  -0.120175,  -0.121122,  -0.121557,  -0.121365,
      -0.120577, -0.119367, -0.118016,  -0.116842,  -0.11613,   -0.116062,  -0.11667,   -0.117825,  -0.119265,
      -0.120653, -0.121656, -0.122023,  -0.12165,   -0.120605,  -0.119121,  -0.11754,   -0.116239,  -0.115537,
      -0.11562,  -0.116491, -0.117964,  -0.119705,  -0.121304,  -0.122374,  -0.122641,  -0.122015,  -0.120618,
      -0.118759, -0.116871, -0.115404,  -0.114727,  -0.115029,  -0.116273,  -0.118192,  -0.120351,  -0.122238,
      -0.123389, -0.123499, -0.122502,  -0.120593,  -0.118197,  -0.115872,  -0.11418,   -0.113557,  -0.114197,
      -0.116002, -0.118587, -0.121361,  -0.123663,  -0.124915,  -0.124765,  -0.123182,  -0.12048,   -0.117257,
      -0.114269, -0.112252, -0.111745,  -0.112952,  -0.115673,  -0.11933,   -0.123089,  -0.126039,  -0.127417,
      -0.126792, -0.124194, -0.120132,  -0.115505,  -0.111405,  -0.108869,  -0.108625,  -0.110894,  -0.1153,
      -0.120921, -0.126469, -0.130574,  -0.132111,  -0.13049,   -0.125844,  -0.119057,  -0.111614,  -0.1053,
      -0.101788, -0.10223,  -0.106922,  -0.115148,  -0.125242,  -0.13489,   -0.141613,  -0.143348,  -0.138998,
      -0.128821, -0.114558, -0.0992244, -0.0865875, -0.0803864, -0.0834435, -0.0968329, -0.119288,  -0.146994,
      -0.173851, -0.192211, -0.193992,  -0.172,     -0.121238,  -0.0399526, 0.0697655,  0.201985},
     {0.35178,    0.471071,   0.584916,   0.68765,    0.774589,   0.842441,   0.88957,    0.91608,    0.923731,
      0.91568,    0.896099,   0.869692,   0.841199,   0.814903,   0.794229,   0.781456,   0.777566,   0.782263,
      0.794123,   0.810872,   0.82974,    0.847863,   0.862661,   0.872162,   0.875237,   0.871707,   0.862329,
      0.848662,   0.832823,   0.817186,   0.804052,   0.795327,   0.792273,   0.795328,   0.804052,   0.817187,
      0.832823,   0.848662,   0.862329,   0.871706,   0.875237,   0.872162,   0.86266,    0.847863,   0.82974,
      0.810871,   0.794123,   0.782263,   0.777566,   0.781455,   0.794229,   0.814903,   0.841199,   0.869692,
      0.896099,   0.915681,   0.923731,   0.916081,   0.889571,   0.842442,   0.77459,    0.687651,   0.584917,
      0.471072,   0.351781,   0.233179,   0.121309,   0.0215724,  -0.0617548, -0.125875,  -0.169669,  -0.193718,
      -0.200149,  -0.192326,  -0.17443,   -0.150975,  -0.12632,   -0.104227,  -0.0875247, -0.0778969, -0.0758255,
      -0.0806777, -0.0909199, -0.104424,  -0.118822,  -0.131856,  -0.141685,  -0.14711,   -0.147685,  -0.143725,
      -0.136194,  -0.126518,  -0.116339,  -0.107261,  -0.100608,  -0.09725,   -0.0974986, -0.101095,  -0.107282,
      -0.114949,  -0.122819,  -0.129652,  -0.134433,  -0.136518,  -0.135713,  -0.132282,  -0.126887,  -0.120467,
      -0.114077,  -0.108725,  -0.105212,  -0.104018,  -0.105241,  -0.108592,  -0.113458,  -0.119013,  -0.124347,
      -0.128621,  -0.131192,  -0.131707,  -0.130154,  -0.126847,  -0.122369,  -0.117473,  -0.112954,  -0.109523,
      -0.107698,  -0.107725,  -0.109547,  -0.112823,  -0.116987,  -0.121347,  -0.125197,  -0.127932,  -0.12914,
      -0.128665,  -0.126623,  -0.123381,  -0.11949,   -0.115592,  -0.112316,  -0.110177,  -0.109496,  -0.110351,
      -0.112571,  -0.115769,  -0.119408,  -0.12289,   -0.125654,  -0.127268,  -0.12749,   -0.126313,  -0.123953,
      -0.120813,  -0.117418,  -0.114323,  -0.112025,  -0.110883,  -0.111064,  -0.112516,  -0.114981,  -0.118044,
      -0.121195,  -0.123922,  -0.125787,  -0.126499,  -0.12596,   -0.124277,  -0.12174,   -0.118775,  -0.115871,
      -0.113501,  -0.112043,  -0.111724,  -0.11258,   -0.114455,  -0.117031,  -0.119878,  -0.122528,  -0.124551,
      -0.125623,  -0.125582,  -0.124446,  -0.122416,  -0.119832,  -0.117124,  -0.114736,  -0.113055,  -0.112349,
      -0.112721,  -0.114101,  -0.116251,  -0.118812,  -0.12136,   -0.123479,  -0.124824,  -0.125184,  -0.124509,
      -0.122919,  -0.120683,  -0.118174,  -0.115805,  -0.113964,  -0.112948,  -0.112916,  -0.113865,  -0.115632,
      -0.11792,   -0.120349,  -0.122519,  -0.124076,  -0.12477,   -0.124493,  -0.123298,  -0.121387,  -0.11908,
      -0.116759,  -0.114805,  -0.113536,  -0.113156,  -0.113722,  -0.115135,  -0.117157,  -0.119451,  -0.121639,
      -0.123362,  -0.12434,   -0.124415,  -0.12358,   -0.121979,  -0.119879,  -0.117628,  -0.115596,  -0.114119,
      -0.113434,  -0.113652,  -0.114732,  -0.116492,  -0.118639,  -0.120817,  -0.122669,  -0.12389,   -0.124283,
      -0.123785,  -0.122484,  -0.120595,  -0.118433,  -0.116355,  -0.114703,  -0.113748,  -0.113644,  -0.114405,
      -0.115904,  -0.117891,  -0.120037,  -0.121987,  -0.123421,  -0.124104,  -0.123925,  -0.122916,  -0.121247,
      -0.119192,  -0.117094,  -0.115296,  -0.114096,  -0.113691,  -0.114144,  -0.11538,   -0.117194,  -0.119284,
      -0.121307,  -0.122927,  -0.123879,  -0.124006,  -0.123289,  -0.121847,  -0.119918,  -0.117822,  -0.115905,
      -0.114483,  -0.11379,   -0.113941,  -0.114909,  -0.116535,  -0.118549,  -0.12062,   -0.122405,  -0.123609,
      -0.124033,  -0.123608,  -0.122404,  -0.12062,   -0.118549,  -0.116535,  -0.114909,  -0.11394,   -0.11379,
      -0.114483,  -0.115905,  -0.117822,  -0.119918,  -0.121847,  -0.123289,  -0.124007,  -0.123879,  -0.122927,
      -0.121307,  -0.119284,  -0.117194,  -0.11538,   -0.114144,  -0.113691,  -0.114097,  -0.115297,  -0.117094,
      -0.119193,  -0.121247,  -0.122917,  -0.123925,  -0.124104,  -0.123421,  -0.121987,  -0.120037,  -0.117891,
      -0.115905,  -0.114406,  -0.113644,  -0.113748,  -0.114703,  -0.116356,  -0.118433,  -0.120595,  -0.122484,
      -0.123786,  -0.124283,  -0.123891,  -0.122669,  -0.120817,  -0.118638,  -0.116491,  -0.114731,  -0.113652,
      -0.113434,  -0.114118,  -0.115596,  -0.117628,  -0.119879,  -0.12198,   -0.123581,  -0.124415,  -0.12434,
      -0.123363,  -0.121639,  -0.119451,  -0.117157,  -0.115135,  -0.113722,  -0.113156,  -0.113536,  -0.114805,
      -0.116759,  -0.11908,   -0.121387,  -0.123298,  -0.124493,  -0.12477,   -0.124077,  -0.122519,  -0.120349,
      -0.11792,   -0.115633,  -0.113866,  -0.112917,  -0.112948,  -0.113965,  -0.115806,  -0.118174,  -0.120683,
      -0.122919,  -0.124509,  -0.125184,  -0.124824,  -0.123478,  -0.12136,   -0.118812,  -0.116251,  -0.1141,
      -0.11272,   -0.112348,  -0.113054,  -0.114735,  -0.117124,  -0.119832,  -0.122415,  -0.124446,  -0.125582,
      -0.125623,  -0.124551,  -0.122529,  -0.119879,  -0.117032,  -0.114455,  -0.11258,   -0.111724,  -0.112043,
      -0.113501,  -0.115871,  -0.118775,  -0.12174,   -0.124277,  -0.12596,   -0.126499,  -0.125787,  -0.123922,
      -0.121196,  -0.118045,  -0.114982,  -0.112517,  -0.111065,  -0.110884,  -0.112026,  -0.114323,  -0.117418,
      -0.120813,  -0.123952,  -0.126313,  -0.12749,   -0.127267,  -0.125654,  -0.122889,  -0.119407,  -0.115769,
      -0.11257,   -0.11035,   -0.109496,  -0.110177,  -0.112316,  -0.115592,  -0.11949,   -0.123381,  -0.126623,
      -0.128665,  -0.12914,   -0.127932,  -0.125197,  -0.121347,  -0.116987,  -0.112823,  -0.109547,  -0.107725,
      -0.107698,  -0.109523,  -0.112954,  -0.117473,  -0.122369,  -0.126847,  -0.130154,  -0.131707,  -0.131191,
      -0.128621,  -0.124347,  -0.119012,  -0.113458,  -0.108592,  -0.105241,  -0.104019,  -0.105212,  -0.108725,
      -0.114077,  -0.120467,  -0.126888,  -0.132283,  -0.135713,  -0.136518,  -0.134433,  -0.129652,  -0.122819,
      -0.11495,   -0.107282,  -0.101095,  -0.0974988, -0.0972503, -0.100608,  -0.107261,  -0.11634,   -0.126518,
      -0.136194,  -0.143725,  -0.147686,  -0.14711,   -0.141686,  -0.131856,  -0.118822,  -0.104424,  -0.0909196,
      -0.0806774, -0.0758253, -0.0778966, -0.0875243, -0.104227,  -0.126319,  -0.150975,  -0.174429,  -0.192325,
      -0.200149,  -0.193718,  -0.169669,  -0.125875,  -0.0617549, 0.021572,   0.121309,   0.233178},
     {0.369672,   0.468608,   0.562456,   0.648066,   0.722895,    0.785147,    0.833854,   0.868891,   0.890917,
      0.901269,   0.901807,   0.89473,    0.882385,   0.867074,    0.850892,    0.835599,   0.822527,   0.812542,
      0.806053,   0.803056,   0.803208,   0.805932,   0.810517,    0.816219,    0.822349,   0.828332,   0.833748,
      0.838336,   0.841983,   0.844689,   0.846522,   0.847573,    0.847914,    0.847573,   0.846522,   0.844689,
      0.841983,   0.838336,   0.833748,   0.828332,   0.822349,    0.816219,    0.810516,   0.805932,   0.803207,
      0.803055,   0.806053,   0.812542,   0.822527,   0.835599,    0.850892,    0.867074,   0.882385,   0.894731,
      0.901807,   0.901269,   0.890918,   0.868892,   0.833855,    0.785148,    0.722896,   0.648068,   0.562457,
      0.468609,   0.369673,   0.269211,   0.170961,   0.0785809,   -0.00460183, -0.0758233, -0.133072,  -0.175223,
      -0.202093,  -0.214436,  -0.213854,  -0.202646,  -0.183608,   -0.159795,   -0.134275,  -0.10989,   -0.089042,
      -0.0735344, -0.064465,  -0.0621896, -0.0663517, -0.0759742,  -0.089602,   -0.10548,   -0.121747,  -0.136633,
      -0.148628,  -0.156621,  -0.159991,  -0.158642,  -0.152984,   -0.143861,   -0.132444,  -0.12009,   -0.108189,
      -0.0980156, -0.0906019, -0.0866352, -0.0864008, -0.0897687,  -0.096224,   -0.104937,  -0.114866,  -0.124875,
      -0.133863,  -0.140876,  -0.145214,  -0.146489,  -0.144662,   -0.140036,   -0.133208,  -0.125,     -0.11636,
      -0.108254,  -0.101562,  -0.0969834, -0.0949652, -0.0956607,  -0.0989202,  -0.104316,  -0.111194,  -0.118757,
      -0.126149,  -0.132555,  -0.137288,  -0.139863,  -0.140044,   -0.137865,   -0.133621,  -0.127828,  -0.121164,
      -0.114386,  -0.108251,  -0.103427,  -0.100424,  -0.0995403,  -0.100832,   -0.104114,  -0.108983,  -0.114867,
      -0.121094,  -0.126963,  -0.131827,  -0.135163,  -0.136624,   -0.136081,   -0.133626,  -0.129566,  -0.124379,
      -0.118661,  -0.113059,  -0.108196,  -0.104603,  -0.102661,   -0.102562,   -0.104291,  -0.107628,  -0.112177,
      -0.117414,  -0.122743,  -0.127569,  -0.131359,  -0.133704,   -0.13436,    -0.133277,  -0.130597,  -0.126641,
      -0.121866,  -0.116816,  -0.11206,   -0.108125,  -0.105442,   -0.104297,   -0.104799,  -0.106875,  -0.110274,
      -0.114601,  -0.119363,  -0.124021,  -0.128055,  -0.131021,   -0.132597,   -0.132621,  -0.131106,  -0.128236,
      -0.124347,  -0.119883,  -0.115349,  -0.111256,  -0.108056,   -0.1061,     -0.105596,  -0.106589,  -0.108953,
      -0.112412,  -0.116569,  -0.120953,  -0.125069,  -0.12846,    -0.13075,    -0.131691,  -0.131188,  -0.129309,
      -0.126275,  -0.122434,  -0.118223,  -0.114117,  -0.110576,   -0.107994,   -0.106652,  -0.106695,  -0.108107,
      -0.110721,  -0.114236,  -0.118252,  -0.122316,  -0.12597,    -0.128808,   -0.130515,  -0.130906,  -0.129945,
      -0.127747,  -0.124566,  -0.120765,  -0.116773,  -0.11304,    -0.109984,   -0.107944,  -0.107145,  -0.10767,
      -0.109454,  -0.112292,  -0.115858,  -0.11975,   -0.123529,   -0.12677,    -0.129112,  -0.130295,  -0.130191,
      -0.128817,  -0.126331,  -0.123018,  -0.119253,  -0.11546,    -0.112066,   -0.109452,  -0.107908,  -0.107604,
      -0.108572,  -0.110698,  -0.11374,   -0.117353,  -0.12113,    -0.124644,   -0.127502,  -0.129384,  -0.130081,
      -0.129516,  -0.127757,  -0.125004,  -0.121568,  -0.117837,   -0.114233,   -0.111159,  -0.108962,  -0.107886,
      -0.108051,  -0.109437,  -0.111886,  -0.11512,   -0.118776,   -0.12244,    -0.125701,  -0.128191,  -0.129633,
      -0.129863,  -0.128857,  -0.126729,  -0.123719,  -0.120167,   -0.116473,   -0.113053,  -0.110292,  -0.1085,
      -0.107879,  -0.1085,    -0.110292,  -0.113053,  -0.116473,   -0.120167,   -0.123719,  -0.126729,  -0.128857,
      -0.129863,  -0.129633,  -0.128192,  -0.125701,  -0.12244,    -0.118776,   -0.11512,   -0.111886,  -0.109437,
      -0.108052,  -0.107886,  -0.108962,  -0.11116,   -0.114233,   -0.117838,   -0.121568,  -0.125004,  -0.127757,
      -0.129516,  -0.130081,  -0.129385,  -0.127503,  -0.124644,   -0.12113,    -0.117354,  -0.11374,   -0.110699,
      -0.108573,  -0.107605,  -0.107908,  -0.109452,  -0.112067,   -0.11546,    -0.119253,  -0.123018,  -0.126332,
      -0.128817,  -0.130191,  -0.130295,  -0.129112,  -0.12677,    -0.123529,   -0.11975,   -0.115858,  -0.112291,
      -0.109454,  -0.10767,   -0.107145,  -0.107944,  -0.109984,   -0.11304,    -0.116773,  -0.120765,  -0.124567,
      -0.127747,  -0.129945,  -0.130906,  -0.130515,  -0.128808,   -0.12597,    -0.122316,  -0.118253,  -0.114236,
      -0.110721,  -0.108107,  -0.106695,  -0.106652,  -0.107994,   -0.110577,   -0.114117,  -0.118223,  -0.122434,
      -0.126275,  -0.12931,   -0.131189,  -0.131691,  -0.13075,    -0.12846,    -0.12507,   -0.120954,  -0.11657,
      -0.112413,  -0.108953,  -0.106589,  -0.105596,  -0.1061,     -0.108055,   -0.111255,  -0.115349,  -0.119882,
      -0.124346,  -0.128235,  -0.131105,  -0.132621,  -0.132597,   -0.131021,   -0.128055,  -0.124021,  -0.119363,
      -0.114601,  -0.110274,  -0.106875,  -0.104799,  -0.104297,   -0.105442,   -0.108125,  -0.11206,   -0.116816,
      -0.121866,  -0.126641,  -0.130597,  -0.133277,  -0.13436,    -0.133704,   -0.131359,  -0.127569,  -0.122744,
      -0.117414,  -0.112178,  -0.107629,  -0.104292,  -0.102563,   -0.102661,   -0.104603,  -0.108196,  -0.113059,
      -0.118661,  -0.124379,  -0.129566,  -0.133626,  -0.13608,    -0.136624,   -0.135163,  -0.131827,  -0.126963,
      -0.121093,  -0.114867,  -0.108982,  -0.104113,  -0.100832,   -0.0995401,  -0.100424,  -0.103427,  -0.108251,
      -0.114386,  -0.121164,  -0.127828,  -0.133621,  -0.137865,   -0.140044,   -0.139863,  -0.137288,  -0.132555,
      -0.126149,  -0.118757,  -0.111194,  -0.104315,  -0.09892,    -0.0956606,  -0.0949651, -0.0969833, -0.101562,
      -0.108254,  -0.11636,   -0.125,     -0.133208,  -0.140036,   -0.144662,   -0.146489,  -0.145214,  -0.140877,
      -0.133863,  -0.124876,  -0.114867,  -0.104938,  -0.0962244,  -0.0897691,  -0.0864011, -0.0866354, -0.0906022,
      -0.0980159, -0.108189,  -0.12009,   -0.132444,  -0.143861,   -0.152984,   -0.158643,  -0.159992,  -0.156621,
      -0.148628,  -0.136633,  -0.121747,  -0.10548,   -0.0896021,  -0.0759743,  -0.0663518, -0.0621896, -0.0644649,
      -0.0735343, -0.0890418, -0.109889,  -0.134275,  -0.159794,   -0.183607,   -0.202646,  -0.213854,  -0.214436,
      -0.202092,  -0.175222,  -0.133072,  -0.0758234, -0.00460211, 0.0785804,   0.17096,    0.269211},
     {0.341536,  0.430939,  0.519096,   0.603464,   0.681652,   0.75154,    0.811392,   0.859944,   0.896468,
      0.920807,  0.933372,  0.935112,   0.92745,    0.912188,   0.891404,   0.867314,   0.842148,   0.818013,
      0.796772,  0.779942,  0.768614,   0.763398,   0.764411,   0.771286,   0.783219,   0.799045,   0.817332,
      0.836495,  0.85492,   0.871082,   0.883661,   0.891638,   0.89437,    0.891638,   0.883661,   0.871082,
      0.85492,   0.836495,  0.817332,   0.799045,   0.783219,   0.771286,   0.764411,   0.763398,   0.768613,
      0.779942,  0.796771,  0.818012,   0.842148,   0.867314,   0.891404,   0.912188,   0.92745,    0.935113,
      0.933373,  0.920807,  0.896469,   0.859944,   0.811393,   0.751541,   0.681653,   0.603465,   0.519096,
      0.43094,   0.341537,  0.253445,   0.169112,   0.0907555,  0.0202577,  -0.0409154, -0.0917703, -0.131815,
      -0.161056, -0.17997,  -0.189454,  -0.190744,  -0.185331,  -0.174857,  -0.161021,  -0.145472,  -0.129727,
      -0.115095, -0.10262,  -0.0930471, -0.0868063, -0.0840211, -0.0845338, -0.0879472, -0.0936797, -0.101026,
      -0.109223, -0.117514, -0.125202,  -0.131703,  -0.136578,  -0.139556,  -0.140541,  -0.139607,  -0.136977,
      -0.132997, -0.128095, -0.122746,  -0.117427,  -0.112581,  -0.108583,  -0.105711,  -0.104137,  -0.103912,
      -0.104973, -0.107157, -0.110215,  -0.113841,  -0.117699,  -0.121453,  -0.124792,  -0.127457,  -0.129259,
      -0.130091, -0.12993,  -0.128838,  -0.126951,  -0.124467,  -0.121622,  -0.118673,  -0.115872,  -0.11345,
      -0.111594, -0.110438, -0.110048,  -0.110427,  -0.111511,  -0.11318,   -0.11527,   -0.117588,  -0.11993,
      -0.122096, -0.123909, -0.12523,   -0.125964,  -0.12607,   -0.12556,   -0.124501,  -0.122999,  -0.121198,
      -0.119259, -0.117352, -0.115637,  -0.114253,  -0.113308,  -0.112867,  -0.112954,  -0.113544,  -0.114573,
      -0.11594,  -0.11752,  -0.119172,  -0.120754,  -0.122134,  -0.1232,    -0.123869,  -0.124096,  -0.123873,
      -0.123231, -0.122234, -0.120978,  -0.119574,  -0.118147,  -0.116818,  -0.115697,  -0.114876,  -0.114417,
      -0.11435,  -0.114673, -0.11535,   -0.116313,  -0.117477,  -0.118736,  -0.119981,  -0.121108,  -0.122022,
      -0.12265,  -0.122943, -0.122885,  -0.122487,  -0.121789,  -0.120856,  -0.119773,  -0.118635,  -0.11754,
      -0.116581, -0.115836, -0.115366,  -0.115206,  -0.115364,  -0.115822,  -0.116534,  -0.117437,  -0.118449,
      -0.119484, -0.120451, -0.12127,   -0.121872,  -0.122211,  -0.12226,   -0.12202,   -0.121515,  -0.120793,
      -0.119919, -0.118968, -0.118024,  -0.117167,  -0.11647,   -0.115989,  -0.115763,  -0.115808,  -0.116117,
      -0.11666,  -0.117388, -0.118236,  -0.119131,  -0.119995,  -0.120754,  -0.121346,  -0.12172,   -0.121848,
      -0.121721, -0.121353, -0.120777,  -0.120045,  -0.119222,  -0.118378,  -0.117587,  -0.116914,  -0.116418,
      -0.116139, -0.116098, -0.116298,  -0.116718,  -0.117322,  -0.118056,  -0.118856,  -0.119653,  -0.120378,
      -0.12097,  -0.12138,  -0.121573,  -0.121534,  -0.121269,  -0.120801,  -0.120172,  -0.119436,  -0.118659,
      -0.117906, -0.117242, -0.116724,  -0.116395,  -0.116282,  -0.116394,  -0.116721,  -0.117233,  -0.117885,
      -0.118621, -0.119377, -0.120088,  -0.120694,  -0.121142,  -0.121395,  -0.121432,  -0.12125,   -0.120866,
      -0.120313, -0.119639, -0.118903,  -0.118168,  -0.117497,  -0.116947,  -0.116566,  -0.116386,  -0.116423,
      -0.116672, -0.117112, -0.117704,  -0.118399,  -0.119135,  -0.11985,   -0.120482,  -0.120976,  -0.121291,
      -0.121399, -0.121291, -0.120976,  -0.120482,  -0.11985,   -0.119135,  -0.118399,  -0.117704,  -0.117111,
      -0.116672, -0.116423, -0.116386,  -0.116566,  -0.116947,  -0.117497,  -0.118168,  -0.118903,  -0.119639,
      -0.120313, -0.120866, -0.12125,   -0.121432,  -0.121395,  -0.121142,  -0.120694,  -0.120088,  -0.119377,
      -0.118621, -0.117885, -0.117233,  -0.116721,  -0.116395,  -0.116282,  -0.116395,  -0.116724,  -0.117243,
      -0.117906, -0.118659, -0.119437,  -0.120172,  -0.120801,  -0.121269,  -0.121535,  -0.121573,  -0.12138,
      -0.120971, -0.120378, -0.119653,  -0.118856,  -0.118056,  -0.117322,  -0.116718,  -0.116297,  -0.116098,
      -0.116138, -0.116418, -0.116914,  -0.117587,  -0.118378,  -0.119222,  -0.120045,  -0.120777,  -0.121353,
      -0.121721, -0.121848, -0.12172,   -0.121346,  -0.120754,  -0.119995,  -0.119131,  -0.118236,  -0.117388,
      -0.11666,  -0.116117, -0.115808,  -0.115763,  -0.115989,  -0.11647,   -0.117168,  -0.118025,  -0.118969,
      -0.119919, -0.120794, -0.121516,  -0.12202,   -0.12226,   -0.122211,  -0.121873,  -0.12127,   -0.120451,
      -0.119484, -0.118449, -0.117437,  -0.116534,  -0.115821,  -0.115364,  -0.115206,  -0.115366,  -0.115836,
      -0.11658,  -0.11754,  -0.118635,  -0.119773,  -0.120856,  -0.121788,  -0.122486,  -0.122885,  -0.122943,
      -0.122649, -0.122022, -0.121108,  -0.119981,  -0.118736,  -0.117477,  -0.116313,  -0.11535,   -0.114673,
      -0.11435,  -0.114417, -0.114876,  -0.115697,  -0.116818,  -0.118147,  -0.119575,  -0.120978,  -0.122235,
      -0.123231, -0.123874, -0.124097,  -0.12387,   -0.1232,    -0.122135,  -0.120755,  -0.119173,  -0.11752,
      -0.115941, -0.114573, -0.113544,  -0.112954,  -0.112867,  -0.113307,  -0.114252,  -0.115636,  -0.117351,
      -0.119259, -0.121197, -0.122999,  -0.1245,    -0.12556,   -0.126069,  -0.125963,  -0.12523,   -0.123909,
      -0.122096, -0.11993,  -0.117588,  -0.11527,   -0.11318,   -0.111511,  -0.110427,  -0.110048,  -0.110438,
      -0.111594, -0.11345,  -0.115872,  -0.118673,  -0.121622,  -0.124467,  -0.126951,  -0.128837,  -0.129929,
      -0.130091, -0.129259, -0.127457,  -0.124792,  -0.121453,  -0.1177,    -0.113842,  -0.110216,  -0.107158,
      -0.104974, -0.103912, -0.104137,  -0.105712,  -0.108583,  -0.112582,  -0.117427,  -0.122746,  -0.128095,
      -0.132997, -0.136977, -0.139607,  -0.140541,  -0.139556,  -0.136578,  -0.131703,  -0.125202,  -0.117514,
      -0.109224, -0.101026, -0.0936799, -0.0879475, -0.0845339, -0.0840212, -0.0868063, -0.0930471, -0.10262,
      -0.115095, -0.129726, -0.145471,  -0.16102,   -0.174857,  -0.18533,   -0.190744,  -0.189454,  -0.17997,
      -0.161055, -0.131815, -0.0917704, -0.0409156, 0.0202573,  0.0907549,  0.169111,   0.253444},
     {0.3748,     0.444627,   0.512093,   0.576041,   0.635455,   0.689497,   0.737522,   0.7791,     0.814013,
      0.842254,   0.864014,   0.879662,   0.889715,   0.894811,   0.89567,    0.893063,   0.887769,   0.880551,
      0.872117,   0.863105,   0.854056,   0.845406,   0.83748,    0.830496,   0.824567,   0.819717,   0.815899,
      0.813012,   0.810923,   0.809489,   0.808577,   0.808077,   0.807918,   0.808077,   0.808577,   0.809489,
      0.810922,   0.813011,   0.815898,   0.819716,   0.824566,   0.830496,   0.83748,    0.845405,   0.854055,
      0.863105,   0.872117,   0.880551,   0.887769,   0.893063,   0.895671,   0.894811,   0.889715,   0.879662,
      0.864015,   0.842254,   0.814014,   0.779101,   0.737523,   0.689497,   0.635456,   0.576041,   0.512094,
      0.444627,   0.374801,   0.303878,   0.23319,    0.164082,   0.0978706,  0.035795,   -0.0210293, -0.0716501,
      -0.115312,  -0.151485,  -0.179878,  -0.200451,  -0.213409,  -0.219189,  -0.218442,  -0.212001,  -0.20084,
      -0.186038,  -0.168728,  -0.150053,  -0.131118,  -0.11295,   -0.0964539, -0.0823855, -0.0713246, -0.0636598,
      -0.0595817, -0.0590857, -0.061983,  -0.06792,   -0.0764049, -0.0868389, -0.0985523, -0.110841,  -0.123007,
      -0.134388,  -0.144397,  -0.152546,  -0.158465,  -0.161924,  -0.16283,   -0.161236,  -0.157324,  -0.151397,
      -0.143857,  -0.135177,  -0.125878,  -0.116496,  -0.107553,  -0.0995311, -0.0928461, -0.0878279, -0.0847049,
      -0.0835943, -0.0844998, -0.0873135, -0.0918255, -0.0977382, -0.104685,  -0.11225,   -0.119997,  -0.127489,
      -0.134313,  -0.140105,  -0.144566,  -0.147478,  -0.148714,  -0.148242,  -0.146128,  -0.142526,  -0.137669,
      -0.131856,  -0.125432,  -0.11877,   -0.112248,  -0.106229,  -0.10104,   -0.0969571, -0.0941876, -0.0928627,
      -0.09303,   -0.0946534, -0.0976158, -0.101727,  -0.106737,  -0.112348,  -0.118236,  -0.124064,  -0.129505,
      -0.134261,  -0.138075,  -0.140746,  -0.142142,  -0.142204,  -0.140948,  -0.138464,  -0.13491,   -0.130501,
      -0.125498,  -0.120191,  -0.114882,  -0.109871,  -0.105437,  -0.101822,  -0.0992179, -0.0977599, -0.0975152,
      -0.0984826, -0.100593,  -0.103712,  -0.107654,  -0.112185,  -0.117044,  -0.121952,  -0.126631,  -0.130821,
      -0.13429,   -0.136849,  -0.138366,  -0.138763,  -0.138032,  -0.136224,  -0.133453,  -0.129885,  -0.12573,
      -0.121227,  -0.116635,  -0.112214,  -0.108212,  -0.104851,  -0.102317,  -0.100744,  -0.100213,  -0.100745,
      -0.102301,  -0.104785,  -0.108047,  -0.111898,  -0.116114,  -0.120454,  -0.124673,  -0.128531,  -0.131813,
      -0.134339,  -0.13597,   -0.13662,   -0.136261,  -0.13492,   -0.132678,  -0.12967,   -0.12607,   -0.122087,
      -0.117949,  -0.11389,   -0.11014,   -0.10691,   -0.10438,   -0.102688,  -0.101925,  -0.10213,   -0.103285,
      -0.10532,   -0.108113,  -0.111504,  -0.115296,  -0.119273,  -0.123208,  -0.126878,  -0.130077,  -0.132626,
      -0.134383,  -0.135252,  -0.135189,  -0.1342,    -0.132346,  -0.129735,  -0.12652,   -0.122884,  -0.119036,
      -0.115195,  -0.111578,  -0.10839,   -0.10581,   -0.103982,  -0.103008,  -0.10294,   -0.103778,  -0.105472,
      -0.107925,  -0.110992,  -0.114501,  -0.118248,  -0.122022,  -0.125609,  -0.128804,  -0.131428,  -0.133333,
      -0.134412,  -0.134607,  -0.133908,  -0.132357,  -0.130042,  -0.127099,  -0.123694,  -0.120021,  -0.116291,
      -0.112714,  -0.109494,  -0.106813,  -0.104822,  -0.103634,  -0.103316,  -0.103884,  -0.105305,  -0.107498,
      -0.110338,  -0.113662,  -0.117282,  -0.120991,  -0.124579,  -0.127842,  -0.130594,  -0.13268,   -0.133981,
      -0.134423,  -0.133981,  -0.13268,   -0.130594,  -0.127842,  -0.124579,  -0.120991,  -0.117282,  -0.113662,
      -0.110338,  -0.107498,  -0.105305,  -0.103884,  -0.103316,  -0.103634,  -0.104822,  -0.106813,  -0.109494,
      -0.112714,  -0.116291,  -0.120021,  -0.123694,  -0.127099,  -0.130043,  -0.132357,  -0.133908,  -0.134607,
      -0.134413,  -0.133333,  -0.131428,  -0.128804,  -0.125609,  -0.122023,  -0.118249,  -0.114501,  -0.110993,
      -0.107925,  -0.105473,  -0.103778,  -0.10294,   -0.103008,  -0.103982,  -0.10581,   -0.10839,   -0.111578,
      -0.115195,  -0.119036,  -0.122884,  -0.12652,   -0.129735,  -0.132346,  -0.1342,    -0.135189,  -0.135252,
      -0.134383,  -0.132626,  -0.130077,  -0.126878,  -0.123208,  -0.119273,  -0.115296,  -0.111504,  -0.108113,
      -0.10532,   -0.103285,  -0.10213,   -0.101925,  -0.102688,  -0.10438,   -0.10691,   -0.11014,   -0.11389,
      -0.117949,  -0.122087,  -0.12607,   -0.12967,   -0.132678,  -0.13492,   -0.136262,  -0.136621,  -0.13597,
      -0.134339,  -0.131814,  -0.128531,  -0.124673,  -0.120455,  -0.116114,  -0.111898,  -0.108047,  -0.104785,
      -0.102301,  -0.100745,  -0.100213,  -0.100744,  -0.102317,  -0.104851,  -0.108212,  -0.112213,  -0.116635,
      -0.121227,  -0.125729,  -0.129885,  -0.133453,  -0.136224,  -0.138031,  -0.138763,  -0.138365,  -0.136849,
      -0.134289,  -0.130821,  -0.126631,  -0.121952,  -0.117044,  -0.112185,  -0.107654,  -0.103713,  -0.100593,
      -0.0984828, -0.0975155, -0.0977602, -0.0992183, -0.101822,  -0.105438,  -0.109872,  -0.114883,  -0.120191,
      -0.125498,  -0.130501,  -0.13491,   -0.138464,  -0.140948,  -0.142204,  -0.142142,  -0.140746,  -0.138075,
      -0.134261,  -0.129505,  -0.124063,  -0.118235,  -0.112348,  -0.106737,  -0.101727,  -0.0976156, -0.0946532,
      -0.0930298, -0.0928623, -0.0941873, -0.0969568, -0.10104,   -0.106229,  -0.112248,  -0.11877,   -0.125432,
      -0.131856,  -0.137669,  -0.142526,  -0.146128,  -0.148242,  -0.148714,  -0.147478,  -0.144566,  -0.140105,
      -0.134313,  -0.127489,  -0.119997,  -0.11225,   -0.104685,  -0.0977383, -0.0918256, -0.0873135, -0.0844999,
      -0.0835944, -0.0847049, -0.0878279, -0.0928461, -0.0995311, -0.107553,  -0.116496,  -0.125878,  -0.135177,
      -0.143857,  -0.151397,  -0.157324,  -0.161236,  -0.162831,  -0.161924,  -0.158466,  -0.152546,  -0.144398,
      -0.134388,  -0.123007,  -0.110842,  -0.0985527, -0.0868393, -0.0764053, -0.0679204, -0.0619833, -0.059086,
      -0.059582,  -0.0636599, -0.0713246, -0.0823855, -0.0964538, -0.11295,   -0.131118,  -0.150052,  -0.168727,
      -0.186037,  -0.20084,   -0.212,     -0.218442,  -0.219189,  -0.213408,  -0.200451,  -0.179878,  -0.151485,
      -0.115312,  -0.0716502, -0.0210295, 0.0357947,  0.0978703,  0.164081,   0.233189,   0.303878},
     {0.33412,    0.393882,   0.453776,   0.513036,   0.5709,     0.626622,   0.679489,   0.728841,   0.774081,
      0.814696,   0.850261,   0.880456,   0.905072,   0.924013,   0.937301,   0.945077,   0.947595,   0.945215,
      0.938397,   0.927687,   0.913704,   0.897126,   0.878671,   0.859078,   0.83909,    0.819436,   0.80081,
      0.783853,   0.76914,    0.757161,   0.748313,   0.742887,   0.741058,   0.742887,   0.748313,   0.757161,
      0.769139,   0.783852,   0.800809,   0.819436,   0.83909,    0.859077,   0.87867,    0.897126,   0.913704,
      0.927686,   0.938396,   0.945215,   0.947595,   0.945077,   0.937301,   0.924013,   0.905072,   0.880457,
      0.850261,   0.814696,   0.774082,   0.728841,   0.67949,    0.626622,   0.570901,   0.513037,   0.453776,
      0.393883,   0.33412,    0.275235,   0.217943,   0.162912,   0.110747,   0.0619844,  0.0170774,  -0.0236102,
      -0.0598076, -0.0913412, -0.118133,  -0.140201,  -0.157651,  -0.170674,  -0.179535,  -0.184564,  -0.186148,
      -0.184713,  -0.180717,  -0.174635,  -0.166948,  -0.158127,  -0.148629,  -0.13888,   -0.129268,  -0.120138,
      -0.111784,  -0.104446,  -0.0983048, -0.0934858, -0.0900565, -0.0880305, -0.0873711, -0.0879963, -0.0897851,
      -0.0925844, -0.0962164, -0.100487,  -0.105191,  -0.110123,  -0.115085,  -0.119886,  -0.124358,  -0.128353,
      -0.131749,  -0.134454,  -0.136407,  -0.137576,  -0.137961,  -0.13759,   -0.136517,  -0.13482,   -0.132595,
      -0.129952,  -0.127011,  -0.123899,  -0.120739,  -0.117653,  -0.114755,  -0.112145,  -0.109908,  -0.108113,
      -0.106808,  -0.106021,  -0.10576,   -0.106014,  -0.106751,  -0.107925,  -0.109474,  -0.111325,  -0.113396,
      -0.115601,  -0.117852,  -0.120061,  -0.122147,  -0.124035,  -0.125662,  -0.126973,  -0.127931,  -0.128512,
      -0.128705,  -0.128516,  -0.127965,  -0.127083,  -0.125916,  -0.124515,  -0.122941,  -0.121259,  -0.119536,
      -0.117837,  -0.116228,  -0.114766,  -0.113503,  -0.11248,   -0.11173,   -0.111275,  -0.111123,  -0.111272,
      -0.111709,  -0.11241,   -0.113341,  -0.114462,  -0.115725,  -0.117078,  -0.118469,  -0.119843,  -0.121149,
      -0.122339,  -0.12337,   -0.124207,  -0.124822,  -0.125196,  -0.125322,  -0.125198,  -0.124836,  -0.124254,
      -0.123478,  -0.122543,  -0.121486,  -0.120351,  -0.119182,  -0.118024,  -0.116921,  -0.115914,  -0.115039,
      -0.114328,  -0.113805,  -0.113485,  -0.113378,  -0.113483,  -0.113795,  -0.114296,  -0.114965,  -0.115773,
      -0.116688,  -0.117673,  -0.11869,   -0.119698,  -0.120661,  -0.121541,  -0.122307,  -0.122931,  -0.123392,
      -0.123673,  -0.123768,  -0.123674,  -0.123399,  -0.122954,  -0.12236,   -0.12164,   -0.120824,  -0.119944,
      -0.119035,  -0.118131,  -0.117267,  -0.116475,  -0.115786,  -0.115223,  -0.114807,  -0.114552,  -0.114466,
      -0.114551,  -0.114802,  -0.115207,  -0.115749,  -0.116407,  -0.117153,  -0.117959,  -0.118793,  -0.119624,
      -0.120419,  -0.121149,  -0.121785,  -0.122306,  -0.122691,  -0.122927,  -0.123007,  -0.122927,  -0.122694,
      -0.122316,  -0.12181,   -0.121195,  -0.120496,  -0.11974,   -0.118957,  -0.118176,  -0.117427,  -0.116739,
      -0.116138,  -0.115646,  -0.115281,  -0.115057,  -0.114982,  -0.115057,  -0.115279,  -0.115639,  -0.116122,
      -0.11671,   -0.117379,  -0.118103,  -0.118855,  -0.119606,  -0.120326,  -0.120989,  -0.121568,  -0.122044,
      -0.122396,  -0.122613,  -0.122686,  -0.122613,  -0.122397,  -0.122047,  -0.121576,  -0.121003,  -0.120349,
      -0.119641,  -0.118904,  -0.118168,  -0.117461,  -0.11681,   -0.116239,  -0.115771,  -0.115423,  -0.115208,
      -0.115136,  -0.115208,  -0.115423,  -0.115771,  -0.116239,  -0.11681,   -0.117461,  -0.118168,  -0.118904,
      -0.119641,  -0.120349,  -0.121003,  -0.121576,  -0.122047,  -0.122397,  -0.122613,  -0.122686,  -0.122613,
      -0.122396,  -0.122044,  -0.121569,  -0.120989,  -0.120326,  -0.119606,  -0.118855,  -0.118104,  -0.117379,
      -0.11671,   -0.116123,  -0.115639,  -0.11528,   -0.115057,  -0.114982,  -0.115058,  -0.115281,  -0.115646,
      -0.116138,  -0.116739,  -0.117427,  -0.118176,  -0.118957,  -0.119741,  -0.120496,  -0.121195,  -0.12181,
      -0.122317,  -0.122694,  -0.122928,  -0.123007,  -0.122927,  -0.122691,  -0.122306,  -0.121785,  -0.121149,
      -0.120419,  -0.119624,  -0.118793,  -0.117959,  -0.117153,  -0.116406,  -0.115749,  -0.115207,  -0.114802,
      -0.114551,  -0.114466,  -0.114552,  -0.114807,  -0.115223,  -0.115786,  -0.116476,  -0.117267,  -0.118131,
      -0.119035,  -0.119944,  -0.120824,  -0.12164,   -0.12236,   -0.122954,  -0.123399,  -0.123675,  -0.123768,
      -0.123674,  -0.123392,  -0.122932,  -0.122308,  -0.121542,  -0.120661,  -0.119699,  -0.11869,   -0.117674,
      -0.116689,  -0.115773,  -0.114965,  -0.114296,  -0.113795,  -0.113483,  -0.113377,  -0.113485,  -0.113804,
      -0.114328,  -0.115039,  -0.115914,  -0.11692,   -0.118023,  -0.119181,  -0.12035,   -0.121486,  -0.122542,
      -0.123478,  -0.124254,  -0.124836,  -0.125198,  -0.125321,  -0.125196,  -0.124822,  -0.124207,  -0.12337,
      -0.122339,  -0.12115,   -0.119844,  -0.118469,  -0.117079,  -0.115725,  -0.114462,  -0.113342,  -0.11241,
      -0.11171,   -0.111273,  -0.111123,  -0.111275,  -0.111731,  -0.11248,   -0.113503,  -0.114766,  -0.116228,
      -0.117838,  -0.119536,  -0.121259,  -0.122941,  -0.124515,  -0.125915,  -0.127083,  -0.127964,  -0.128516,
      -0.128704,  -0.128511,  -0.127931,  -0.126973,  -0.125661,  -0.124035,  -0.122147,  -0.120061,  -0.117851,
      -0.115601,  -0.113396,  -0.111325,  -0.109474,  -0.107925,  -0.106751,  -0.106014,  -0.10576,   -0.106021,
      -0.106808,  -0.108113,  -0.109909,  -0.112145,  -0.114755,  -0.117653,  -0.120739,  -0.123898,  -0.127012,
      -0.129952,  -0.132595,  -0.13482,   -0.136517,  -0.13759,   -0.137961,  -0.137576,  -0.136407,  -0.134455,
      -0.131749,  -0.128353,  -0.124359,  -0.119887,  -0.115085,  -0.110124,  -0.105191,  -0.100487,  -0.0962169,
      -0.0925848, -0.0897855, -0.0879967, -0.0873715, -0.0880309, -0.0900568, -0.0934861, -0.0983051, -0.104446,
      -0.111785,  -0.120138,  -0.129268,  -0.13888,   -0.148629,  -0.158127,  -0.166947,  -0.174635,  -0.180716,
      -0.184712,  -0.186148,  -0.184564,  -0.179534,  -0.170674,  -0.157651,  -0.140201,  -0.118133,  -0.0913411,
      -0.0598076, -0.0236102, 0.0170772,  0.0619842,  0.110747,   0.162911,   0.217943,   0.275235},
     {0.386485,   0.434384,   0.481206,   0.52655,    0.570047,   0.611355,   0.650172,   0.686239,   0.719342,
      0.749314,   0.776043,   0.799467,   0.819575,   0.836409,   0.850061,   0.860667,   0.868408,   0.873505,
      0.87621,    0.876803,   0.875588,   0.87288,    0.869007,   0.864294,   0.859062,   0.85362,    0.848256,
      0.843235,   0.838791,   0.83512,    0.832382,   0.830693,   0.830121,   0.830693,   0.832382,   0.83512,
      0.838791,   0.843235,   0.848256,   0.85362,    0.859062,   0.864294,   0.869007,   0.87288,    0.875588,
      0.876803,   0.87621,    0.873505,   0.868409,   0.860667,   0.850061,   0.836409,   0.819575,   0.799467,
      0.776044,   0.749314,   0.719342,   0.686239,   0.650172,   0.611355,   0.570047,   0.526551,   0.481206,
      0.434385,   0.386486,   0.337927,   0.289141,   0.240566,   0.192638,   0.145787,   0.100428,   0.0569535,
      0.0157287,  -0.0229146, -0.0586832, -0.0913269, -0.120642,  -0.146474,  -0.16872,   -0.187328,  -0.202301,
      -0.213689,  -0.221595,  -0.226168,  -0.227599,  -0.226119,  -0.221995,  -0.215521,  -0.207015,  -0.196813,
      -0.185261,  -0.172712,  -0.159515,  -0.146014,  -0.132537,  -0.119396,  -0.106876,  -0.095238,  -0.0847073,
      -0.0754763, -0.0676997, -0.0614933, -0.0569335, -0.0540572, -0.0528624, -0.05331,   -0.055326,  -0.0588042,
      -0.0636098, -0.0695832, -0.0765442, -0.0842968, -0.0926336, -0.101341,  -0.110204,  -0.119012,  -0.127559,
      -0.135655,  -0.143123,  -0.149807,  -0.155573,  -0.160312,  -0.16394,   -0.166403,  -0.167672,  -0.167748,
      -0.16666,   -0.164462,  -0.161231,  -0.157068,  -0.152091,  -0.146436,  -0.14025,   -0.133689,  -0.126915,
      -0.120091,  -0.113377,  -0.106929,  -0.100891,  -0.0953973, -0.090565,  -0.0864946, -0.0832667, -0.0809412,
      -0.0795557, -0.0791257, -0.079644,  -0.0810819, -0.0833898, -0.0864987, -0.0903223, -0.0947595, -0.0996961,
      -0.105009,  -0.110567,  -0.116237,  -0.121883,  -0.127376,  -0.132587,  -0.137399,  -0.141706,  -0.145414,
      -0.148443,  -0.150734,  -0.152243,  -0.152944,  -0.152832,  -0.15192,   -0.150241,  -0.147844,  -0.144793,
      -0.141168,  -0.137062,  -0.132577,  -0.127821,  -0.12291,   -0.11796,   -0.113089,  -0.108408,  -0.104026,
      -0.100042,  -0.0965457, -0.0936127, -0.0913064, -0.089674,  -0.088747,  -0.0885398, -0.0890502, -0.0902591,
      -0.0921313, -0.0946167, -0.097651,  -0.101158,  -0.105051,  -0.109236,  -0.113611,  -0.118073,  -0.122516,
      -0.126836,  -0.130933,  -0.134713,  -0.138089,  -0.140986,  -0.14334,   -0.145099,  -0.146227,  -0.146703,
      -0.14652,   -0.145687,  -0.144229,  -0.142184,  -0.139605,  -0.136555,  -0.13311,   -0.129352,  -0.125373,
      -0.121266,  -0.117129,  -0.11306,   -0.109153,  -0.105499,  -0.102182,  -0.0992784, -0.0968533, -0.0949612,
      -0.0936434, -0.0929276, -0.0928275, -0.0933421, -0.0944561, -0.0961403, -0.0983523, -0.101038,  -0.104131,
      -0.107558,  -0.111236,  -0.115078,  -0.118993,  -0.122889,  -0.126674,  -0.130261,  -0.133565,  -0.13651,
      -0.139029,  -0.141064,  -0.142568,  -0.14351,   -0.143867,  -0.143635,  -0.142821,  -0.141445,  -0.139541,
      -0.137157,  -0.134349,  -0.131185,  -0.12774,   -0.124096,  -0.120339,  -0.116557,  -0.11284,   -0.109274,
      -0.105943,  -0.102924,  -0.100289,  -0.0980974, -0.0964007, -0.0952374, -0.0946341, -0.0946039, -0.0951465,
      -0.0962483, -0.0978825, -0.10001,   -0.10258,   -0.105532,  -0.108795,  -0.112293,  -0.115944,  -0.11966,
      -0.123356,  -0.126944,  -0.130339,  -0.133462,  -0.13624,   -0.138608,  -0.14051,   -0.141901,  -0.142749,
      -0.143033,  -0.142749,  -0.141901,  -0.14051,   -0.138608,  -0.13624,   -0.133462,  -0.130339,  -0.126944,
      -0.123356,  -0.11966,   -0.115944,  -0.112293,  -0.108795,  -0.105532,  -0.10258,   -0.10001,   -0.0978826,
      -0.0962484, -0.0951466, -0.0946041, -0.0946343, -0.0952376, -0.0964009, -0.0980977, -0.100289,  -0.102924,
      -0.105943,  -0.109274,  -0.11284,   -0.116557,  -0.120339,  -0.124097,  -0.127741,  -0.131186,  -0.13435,
      -0.137157,  -0.139542,  -0.141445,  -0.142821,  -0.143635,  -0.143868,  -0.14351,   -0.142569,  -0.141064,
      -0.139029,  -0.13651,   -0.133565,  -0.130261,  -0.126674,  -0.122889,  -0.118993,  -0.115078,  -0.111236,
      -0.107558,  -0.104131,  -0.101038,  -0.0983522, -0.0961402, -0.0944561, -0.0933421, -0.0928275, -0.0929276,
      -0.0936434, -0.0949612, -0.0968535, -0.0992786, -0.102182,  -0.105499,  -0.109153,  -0.11306,   -0.11713,
      -0.121266,  -0.125373,  -0.129353,  -0.13311,   -0.136556,  -0.139605,  -0.142185,  -0.14423,   -0.145688,
      -0.14652,   -0.146703,  -0.146228,  -0.145099,  -0.14334,   -0.140986,  -0.138089,  -0.134713,  -0.130933,
      -0.126836,  -0.122516,  -0.118073,  -0.113611,  -0.109236,  -0.105051,  -0.101158,  -0.0976508, -0.0946164,
      -0.0921311, -0.0902588, -0.0890499, -0.0885395, -0.0887466, -0.0896736, -0.091306,  -0.0936124, -0.0965454,
      -0.100042,  -0.104026,  -0.108408,  -0.113088,  -0.11796,   -0.12291,   -0.127821,  -0.132577,  -0.137062,
      -0.141169,  -0.144793,  -0.147844,  -0.150242,  -0.151921,  -0.152832,  -0.152944,  -0.152243,  -0.150735,
      -0.148444,  -0.145414,  -0.141707,  -0.1374,    -0.132587,  -0.127376,  -0.121884,  -0.116237,  -0.110567,
      -0.105009,  -0.0996963, -0.0947596, -0.0903225, -0.0864988, -0.0833898, -0.081082,  -0.079644,  -0.0791256,
      -0.0795556, -0.080941,  -0.0832665, -0.0864943, -0.0905647, -0.0953971, -0.100891,  -0.106929,  -0.113377,
      -0.120091,  -0.126915,  -0.133689,  -0.14025,   -0.146436,  -0.152091,  -0.157068,  -0.161231,  -0.164462,
      -0.16666,   -0.167748,  -0.167672,  -0.166403,  -0.16394,   -0.160312,  -0.155574,  -0.149807,  -0.143123,
      -0.135655,  -0.127559,  -0.119012,  -0.110205,  -0.101342,  -0.092634,  -0.0842971, -0.0765446, -0.0695836,
      -0.0636102, -0.0588046, -0.0553263, -0.0533103, -0.0528627, -0.0540575, -0.0569338, -0.0614935, -0.0676998,
      -0.0754765, -0.0847074, -0.0952381, -0.106876,  -0.119396,  -0.132537,  -0.146014,  -0.159515,  -0.172712,
      -0.185261,  -0.196813,  -0.207015,  -0.215521,  -0.221995,  -0.226119,  -0.227599,  -0.226168,  -0.221595,
      -0.213689,  -0.202301,  -0.187328,  -0.16872,   -0.146474,  -0.120642,  -0.091327,  -0.0586834, -0.0229148,
      0.0157285,  0.0569533,  0.100428,   0.145787,   0.192637,   0.240565,   0.289141,   0.337927},
     {0.367023,   0.401372,   0.43527,    0.468577,   0.501165,   0.532915,   0.563718,   0.593479,   0.622112,
      0.649545,   0.675719,   0.700587,   0.724112,   0.746271,   0.767051,   0.786449,   0.804474,   0.82114,
      0.83647,    0.850495,   0.863248,   0.874768,   0.885095,   0.894274,   0.902346,   0.909353,   0.915335,
      0.920329,   0.924367,   0.927478,   0.929683,   0.930999,   0.931437,   0.930999,   0.929683,   0.927478,
      0.924367,   0.920329,   0.915335,   0.909353,   0.902346,   0.894274,   0.885096,   0.874768,   0.863248,
      0.850495,   0.836471,   0.82114,    0.804474,   0.78645,    0.767051,   0.746271,   0.724112,   0.700587,
      0.67572,    0.649545,   0.622112,   0.593479,   0.563718,   0.532915,   0.501165,   0.468577,   0.43527,
      0.401372,   0.367024,   0.332369,   0.297563,   0.262764,   0.228134,   0.193838,   0.160043,   0.126913,
      0.09461,    0.0632926,  0.0331125,  0.00421377, -0.0232686, -0.0492106, -0.0735,    -0.0960383, -0.116741,
      -0.13554,   -0.152383,  -0.167233,  -0.180073,  -0.1909,    -0.199733,  -0.206603,  -0.211562,  -0.214675,
      -0.216024,  -0.215705,  -0.213828,  -0.210512,  -0.205891,  -0.200103,  -0.193297,  -0.185624,  -0.177243,
      -0.168311,  -0.158987,  -0.149428,  -0.139786,  -0.130209,  -0.120839,  -0.111808,  -0.103238,  -0.095242,
      -0.0879188, -0.0813551, -0.0756235, -0.0707824, -0.0668752, -0.0639306, -0.0619622, -0.0609693, -0.0609365,
      -0.061835,  -0.0636232, -0.0662473, -0.0696426, -0.0737349, -0.0784413, -0.0836722, -0.089332,  -0.0953215,
      -0.101539,  -0.107881,  -0.114246,  -0.120533,  -0.126646,  -0.132493,  -0.137988,  -0.143053,  -0.147618,
      -0.15162,   -0.155011,  -0.157748,  -0.159802,  -0.161155,  -0.161799,  -0.161737,  -0.160986,  -0.159569,
      -0.157521,  -0.154888,  -0.15172,   -0.148078,  -0.144029,  -0.139643,  -0.134997,  -0.130169,  -0.125238,
      -0.120284,  -0.115388,  -0.110627,  -0.106074,  -0.101798,  -0.0978645, -0.0943306, -0.0912469, -0.0886562,
      -0.0865929, -0.0850827, -0.0841418, -0.0837776, -0.0839881, -0.0847622, -0.0860801, -0.0879135, -0.0902264,
      -0.0929755, -0.0961114, -0.0995786, -0.103318,  -0.107265,  -0.111355,  -0.115519,  -0.119691,  -0.123803,
      -0.127788,  -0.131585,  -0.135135,  -0.138381,  -0.141277,  -0.143778,  -0.145848,  -0.147459,  -0.148588,
      -0.149222,  -0.149357,  -0.148993,  -0.148143,  -0.146824,  -0.145062,  -0.14289,   -0.140346,  -0.137474,
      -0.134324,  -0.13095,   -0.127407,  -0.123755,  -0.120053,  -0.116362,  -0.112742,  -0.109251,  -0.105943,
      -0.102872,  -0.100086,  -0.0976266, -0.0955325, -0.0938347, -0.0925581, -0.0917202, -0.0913319, -0.0913963,
      -0.0919095, -0.0928602, -0.0942302, -0.0959945, -0.0981222, -0.100576,  -0.103315,  -0.106293,  -0.10946,
      -0.112762,  -0.116147,  -0.119558,  -0.12294,   -0.126238,  -0.129399,  -0.132372,  -0.13511,   -0.13757,
      -0.139711,  -0.141503,  -0.142916,  -0.143929,  -0.144529,  -0.144706,  -0.14446,   -0.143796,  -0.142728,
      -0.141273,  -0.139457,  -0.137312,  -0.134873,  -0.13218,   -0.12928,   -0.126219,  -0.123048,  -0.119819,
      -0.116586,  -0.113399,  -0.110313,  -0.107375,  -0.104634,  -0.102135,  -0.0999163, -0.0980143, -0.0964591,
      -0.0952753, -0.0944812, -0.094089,  -0.0941043, -0.0945259, -0.0953461, -0.096551,  -0.09812,   -0.100027,
      -0.10224,   -0.104724,  -0.107436,  -0.110332,  -0.113365,  -0.116486,  -0.119642,  -0.122783,  -0.125857,
      -0.128815,  -0.131607,  -0.134189,  -0.136519,  -0.138558,  -0.140273,  -0.141638,  -0.142628,  -0.143229,
      -0.14343,   -0.143229,  -0.142628,  -0.141638,  -0.140274,  -0.138558,  -0.136519,  -0.134189,  -0.131607,
      -0.128815,  -0.125857,  -0.122783,  -0.119642,  -0.116486,  -0.113365,  -0.110332,  -0.107436,  -0.104724,
      -0.102241,  -0.100027,  -0.0981203, -0.0965512, -0.0953464, -0.0945261, -0.0941045, -0.0940893, -0.0944814,
      -0.0952755, -0.0964593, -0.0980145, -0.0999164, -0.102135,  -0.104635,  -0.107375,  -0.110313,  -0.113399,
      -0.116586,  -0.11982,   -0.123048,  -0.126219,  -0.12928,   -0.13218,   -0.134873,  -0.137312,  -0.139458,
      -0.141273,  -0.142728,  -0.143796,  -0.14446,   -0.144706,  -0.144529,  -0.143929,  -0.142916,  -0.141503,
      -0.139712,  -0.13757,   -0.13511,   -0.132373,  -0.129399,  -0.126239,  -0.12294,   -0.119558,  -0.116147,
      -0.112763,  -0.10946,   -0.106293,  -0.103316,  -0.100577,  -0.0981225, -0.0959948, -0.0942304, -0.0928604,
      -0.0919098, -0.0913966, -0.0913321, -0.0917205, -0.0925582, -0.0938349, -0.0955327, -0.0976267, -0.100086,
      -0.102872,  -0.105943,  -0.109251,  -0.112742,  -0.116362,  -0.120053,  -0.123755,  -0.127407,  -0.13095,
      -0.134324,  -0.137474,  -0.140346,  -0.14289,   -0.145062,  -0.146824,  -0.148143,  -0.148993,  -0.149356,
      -0.149222,  -0.148588,  -0.147459,  -0.145848,  -0.143778,  -0.141277,  -0.138381,  -0.135134,  -0.131585,
      -0.127788,  -0.123802,  -0.119691,  -0.115519,  -0.111355,  -0.107265,  -0.103318,  -0.0995787, -0.0961114,
      -0.0929756, -0.0902265, -0.0879136, -0.0860802, -0.0847623, -0.0839882, -0.0837777, -0.0841419, -0.0850828,
      -0.0865931, -0.0886564, -0.0912471, -0.0943308, -0.0978647, -0.101798,  -0.106074,  -0.110627,  -0.115389,
      -0.120284,  -0.125238,  -0.130169,  -0.134997,  -0.139644,  -0.144029,  -0.148078,  -0.15172,   -0.154888,
      -0.157521,  -0.159569,  -0.160986,  -0.161737,  -0.161799,  -0.161155,  -0.159802,  -0.157748,  -0.155011,
      -0.15162,   -0.147617,  -0.143053,  -0.137988,  -0.132493,  -0.126646,  -0.120533,  -0.114246,  -0.107881,
      -0.101539,  -0.0953214, -0.089332,  -0.0836721, -0.0784413, -0.0737349, -0.0696427, -0.0662473, -0.0636232,
      -0.0618351, -0.0609365, -0.0609693, -0.0619623, -0.0639307, -0.0668753, -0.0707825, -0.0756237, -0.0813553,
      -0.087919,  -0.0952422, -0.103238,  -0.111808,  -0.120839,  -0.130209,  -0.139786,  -0.149428,  -0.158988,
      -0.168312,  -0.177243,  -0.185625,  -0.193297,  -0.200103,  -0.205891,  -0.210513,  -0.213828,  -0.215705,
      -0.216024,  -0.214675,  -0.211562,  -0.206603,  -0.199733,  -0.190901,  -0.180073,  -0.167233,  -0.152383,
      -0.13554,   -0.116741,  -0.0960383, -0.0735,    -0.0492107, -0.0232687, 0.00421373, 0.0331124,  0.0632925,
      0.0946098,  0.126913,   0.160043,   0.193838,   0.228133,   0.262764,   0.297563,   0.332369},
     {0.312961,   0.34289,    0.373177,   0.403736,   0.434477,   0.465309,   0.496139,   0.526872,   0.557412,
      0.58766,    0.617518,   0.64689,    0.675677,   0.703783,   0.731111,   0.75757,    0.783066,   0.807512,
      0.83082,    0.852909,   0.873701,   0.893119,   0.911096,   0.927565,   0.942467,   0.955747,   0.967357,
      0.977254,   0.985402,   0.991771,   0.996337,   0.999083,   1,          0.999083,   0.996337,   0.991771,
      0.985402,   0.977254,   0.967357,   0.955747,   0.942467,   0.927565,   0.911096,   0.893119,   0.873701,
      0.852909,   0.83082,    0.807512,   0.783066,   0.75757,    0.731112,   0.703783,   0.675677,   0.64689,
      0.617518,   0.58766,    0.557412,   0.526873,   0.49614,    0.465309,   0.434477,   0.403736,   0.373178,
      0.342891,   0.312961,   0.283472,   0.254501,   0.226125,   0.198414,   0.171436,   0.145251,   0.119918,
      0.0954892,  0.0720107,  0.0495249,  0.0280681,  0.00767158, -0.0116391, -0.0298435, -0.0469271, -0.0628801,
      -0.0776984, -0.0913829, -0.103939,  -0.115379,  -0.125716,  -0.134972,  -0.14317,   -0.150339,  -0.156509,
      -0.161717,  -0.166001,  -0.169403,  -0.171965,  -0.173735,  -0.174761,  -0.175091,  -0.174778,  -0.173872,
      -0.172428,  -0.170497,  -0.168133,  -0.165388,  -0.162314,  -0.158963,  -0.155385,  -0.151628,  -0.14774,
      -0.143765,  -0.139748,  -0.13573,   -0.131748,  -0.12784,   -0.124038,  -0.120374,  -0.116875,  -0.113567,
      -0.110471,  -0.107606,  -0.10499,   -0.102634,  -0.100549,  -0.0987422, -0.0972187, -0.0959801, -0.0950255,
      -0.0943519, -0.0939537, -0.093823,  -0.0939501, -0.0943232, -0.094929,  -0.0957524, -0.0967772, -0.0979859,
      -0.09936,   -0.10088,   -0.102527,  -0.10428,   -0.106118,  -0.108021,  -0.10997,   -0.111942,  -0.11392,
      -0.115884,  -0.117816,  -0.119699,  -0.121515,  -0.123251,  -0.124891,  -0.126424,  -0.127838,  -0.129123,
      -0.13027,   -0.131273,  -0.132126,  -0.132826,  -0.13337,   -0.133757,  -0.133987,  -0.134063,  -0.133988,
      -0.133767,  -0.133406,  -0.132911,  -0.13229,   -0.131553,  -0.130709,  -0.12977,   -0.128746,  -0.127648,
      -0.12649,   -0.125283,  -0.12404,   -0.122774,  -0.121497,  -0.120222,  -0.11896,   -0.117723,  -0.116523,
      -0.115371,  -0.114275,  -0.113246,  -0.112292,  -0.11142,   -0.110638,  -0.10995,   -0.109363,  -0.108879,
      -0.1085,    -0.10823,   -0.108068,  -0.108015,  -0.108068,  -0.108225,  -0.108484,  -0.10884,   -0.109287,
      -0.109821,  -0.110435,  -0.111122,  -0.111874,  -0.112683,  -0.11354,   -0.114437,  -0.115364,  -0.116312,
      -0.117272,  -0.118235,  -0.119191,  -0.120132,  -0.121048,  -0.121932,  -0.122774,  -0.123569,  -0.124308,
      -0.124986,  -0.125597,  -0.126136,  -0.126598,  -0.12698,   -0.127279,  -0.127493,  -0.127622,  -0.127665,
      -0.127623,  -0.127496,  -0.127287,  -0.126998,  -0.126634,  -0.126199,  -0.125696,  -0.125133,  -0.124513,
      -0.123845,  -0.123135,  -0.122389,  -0.121616,  -0.120823,  -0.120017,  -0.119207,  -0.1184,    -0.117603,
      -0.116825,  -0.116073,  -0.115353,  -0.114672,  -0.114037,  -0.113453,  -0.112925,  -0.112459,  -0.112057,
      -0.111724,  -0.111462,  -0.111274,  -0.111161,  -0.111123,  -0.111161,  -0.111273,  -0.111459,  -0.111716,
      -0.112041,  -0.112432,  -0.112883,  -0.113391,  -0.113951,  -0.114556,  -0.115201,  -0.11588,   -0.116586,
      -0.117313,  -0.118052,  -0.118798,  -0.119543,  -0.12028,   -0.121001,  -0.121701,  -0.122372,  -0.123009,
      -0.123604,  -0.124153,  -0.124651,  -0.125091,  -0.125472,  -0.125788,  -0.126037,  -0.126216,  -0.126325,
      -0.126361,  -0.126325,  -0.126216,  -0.126037,  -0.125788,  -0.125472,  -0.125091,  -0.124651,  -0.124153,
      -0.123604,  -0.123009,  -0.122373,  -0.121701,  -0.121001,  -0.12028,   -0.119543,  -0.118798,  -0.118052,
      -0.117313,  -0.116586,  -0.11588,   -0.115201,  -0.114556,  -0.113951,  -0.113391,  -0.112884,  -0.112432,
      -0.112042,  -0.111716,  -0.111459,  -0.111274,  -0.111161,  -0.111123,  -0.111161,  -0.111275,  -0.111463,
      -0.111724,  -0.112057,  -0.112459,  -0.112925,  -0.113453,  -0.114037,  -0.114673,  -0.115353,  -0.116073,
      -0.116826,  -0.117604,  -0.1184,    -0.119207,  -0.120017,  -0.120823,  -0.121616,  -0.122389,  -0.123135,
      -0.123845,  -0.124514,  -0.125133,  -0.125696,  -0.126199,  -0.126635,  -0.126999,  -0.127287,  -0.127496,
      -0.127623,  -0.127665,  -0.127622,  -0.127494,  -0.127279,  -0.12698,   -0.126598,  -0.126136,  -0.125597,
      -0.124986,  -0.124309,  -0.123569,  -0.122775,  -0.121932,  -0.121048,  -0.120132,  -0.119191,  -0.118235,
      -0.117272,  -0.116312,  -0.115364,  -0.114437,  -0.11354,   -0.112683,  -0.111874,  -0.111122,  -0.110435,
      -0.109821,  -0.109287,  -0.10884,   -0.108484,  -0.108225,  -0.108068,  -0.108015,  -0.108068,  -0.10823,
      -0.1085,    -0.108879,  -0.109363,  -0.109951,  -0.110638,  -0.11142,   -0.112292,  -0.113246,  -0.114275,
      -0.115371,  -0.116523,  -0.117723,  -0.11896,   -0.120222,  -0.121497,  -0.122774,  -0.12404,   -0.125283,
      -0.12649,   -0.127648,  -0.128746,  -0.12977,   -0.13071,   -0.131553,  -0.13229,   -0.132911,  -0.133406,
      -0.133767,  -0.133988,  -0.134063,  -0.133987,  -0.133757,  -0.13337,   -0.132826,  -0.132126,  -0.131273,
      -0.13027,   -0.129123,  -0.127838,  -0.126424,  -0.124891,  -0.123251,  -0.121515,  -0.119699,  -0.117816,
      -0.115884,  -0.11392,   -0.111942,  -0.109969,  -0.108021,  -0.106118,  -0.10428,   -0.102527,  -0.10088,
      -0.09936,   -0.0979859, -0.0967772, -0.0957524, -0.094929,  -0.0943232, -0.0939501, -0.093823,  -0.0939537,
      -0.0943519, -0.0950256, -0.0959801, -0.0972188, -0.0987423, -0.100549,  -0.102634,  -0.10499,   -0.107606,
      -0.110471,  -0.113567,  -0.116875,  -0.120374,  -0.124038,  -0.12784,   -0.131748,  -0.13573,   -0.139748,
      -0.143765,  -0.14774,   -0.151628,  -0.155385,  -0.158963,  -0.162314,  -0.165388,  -0.168133,  -0.170497,
      -0.172428,  -0.173873,  -0.174778,  -0.175091,  -0.174761,  -0.173735,  -0.171965,  -0.169403,  -0.166002,
      -0.161718,  -0.156509,  -0.150339,  -0.14317,   -0.134972,  -0.12