/* LibraryFiles.c generated by valac 0.56.18, the Vala compiler
 * generated from LibraryFiles.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <time.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _video_reader_unref0(var) ((var == NULL) ? NULL : (var = (video_reader_unref (var), NULL)))
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))

VALA_EXTERN GFile* app_dirs_get_baked_import_dir (gint64 tm);
VALA_EXTERN GFile* library_files_duplicate (GFile* src,
                                GFileProgressCallback progress_callback,
                                gpointer progress_callback_target,
                                gboolean blacklist,
                                GError** error);

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

GFile*
library_files_generate_unique_file (const gchar* basename,
                                    MediaMetadata* metadata,
                                    gint64 ts,
                                    gboolean* collision,
                                    GError** error)
{
	gboolean _vala_collision = FALSE;
	gint64 timestamp = 0LL;
	GFile* dir = NULL;
	GFile* _tmp4_;
	GSettings* file_settings = NULL;
	GSettings* _tmp9_;
	gchar* newbasename = NULL;
	gchar* _tmp10_;
	GSettings* _tmp11_;
	GFile* _tmp14_ = NULL;
	GFile* _tmp15_;
	const gchar* _tmp16_;
	gboolean _tmp17_ = FALSE;
	GFile* _tmp18_;
	GFile* _tmp19_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (basename != NULL, NULL);
	timestamp = ts;
	if (metadata != NULL) {
		MetadataDateTime* date_time = NULL;
		MetadataDateTime* _tmp0_;
		MetadataDateTime* _tmp1_;
		_tmp0_ = media_metadata_get_creation_date_time (metadata);
		date_time = _tmp0_;
		_tmp1_ = date_time;
		if (_tmp1_ != NULL) {
			MetadataDateTime* _tmp2_;
			_tmp2_ = date_time;
			timestamp = metadata_date_time_get_timestamp (_tmp2_);
		} else {
			if (timestamp == ((gint64) 0)) {
				time_t _tmp3_;
				_tmp3_ = time (NULL);
				timestamp = (gint64) _tmp3_;
			}
		}
		_metadata_date_time_unref0 (date_time);
	}
	_tmp4_ = app_dirs_get_baked_import_dir (timestamp);
	dir = _tmp4_;
	{
		GFile* _tmp5_;
		_tmp5_ = dir;
		g_file_make_directory_with_parents (_tmp5_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		if (!g_error_matches (_tmp6_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
			GError* _tmp7_;
			GError* _tmp8_;
			_tmp7_ = err;
			_tmp8_ = _g_error_copy0 (_tmp7_);
			_inner_error0_ = _tmp8_;
			_g_error_free0 (err);
			goto __finally0;
		}
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dir);
		return NULL;
	}
	_tmp9_ = g_settings_new (GSETTINGS_CONFIGURATION_ENGINE_FILES_PREFS_SCHEMA_NAME);
	file_settings = _tmp9_;
	_tmp10_ = g_strdup (basename);
	newbasename = _tmp10_;
	_tmp11_ = file_settings;
	if (g_settings_get_boolean (_tmp11_, "use-lowercase-filenames")) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = newbasename;
		_tmp13_ = g_utf8_strdown (_tmp12_, (gssize) -1);
		_g_free0 (newbasename);
		newbasename = _tmp13_;
	}
	_tmp15_ = dir;
	_tmp16_ = newbasename;
	_tmp18_ = generate_unique_file (_tmp15_, _tmp16_, &_tmp17_, &_inner_error0_);
	_vala_collision = _tmp17_;
	_tmp14_ = _tmp18_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (newbasename);
		_g_object_unref0 (file_settings);
		_g_object_unref0 (dir);
		return NULL;
	}
	_tmp19_ = _tmp14_;
	_tmp14_ = NULL;
	result = _tmp19_;
	_g_object_unref0 (_tmp14_);
	_g_free0 (newbasename);
	_g_object_unref0 (file_settings);
	_g_object_unref0 (dir);
	if (collision) {
		*collision = _vala_collision;
	}
	return result;
}

GFile*
library_files_duplicate (GFile* src,
                         GFileProgressCallback progress_callback,
                         gpointer progress_callback_target,
                         gboolean blacklist,
                         GError** error)
{
	gint64 timestamp = 0LL;
	MediaMetadata* metadata = NULL;
	gboolean collision = FALSE;
	GFile* dest = NULL;
	gchar* _tmp18_;
	gchar* _tmp19_;
	MediaMetadata* _tmp20_;
	gboolean _tmp21_ = FALSE;
	GFile* _tmp22_;
	GFile* _tmp23_;
	GFile* _tmp24_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (src != NULL, NULL);
	timestamp = (gint64) 0;
	{
		gint64 _tmp0_ = 0LL;
		_tmp0_ = query_file_modified (src, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		timestamp = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = g_file_get_path (src);
		_tmp2_ = _tmp1_;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_critical ("LibraryFiles.vala:66: Unable to access file modification for %s: %s", _tmp2_, _tmp4_);
		_g_free0 (_tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	metadata = NULL;
	if (video_reader_is_supported_video_file (src)) {
		VideoReader* reader = NULL;
		VideoReader* _tmp5_;
		_tmp5_ = video_reader_new (src);
		reader = _tmp5_;
		{
			VideoMetadata* _tmp6_ = NULL;
			VideoReader* _tmp7_;
			VideoMetadata* _tmp8_;
			VideoMetadata* _tmp9_;
			_tmp7_ = reader;
			_tmp8_ = video_reader_read_metadata (_tmp7_, &_inner_error0_);
			_tmp6_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp9_ = _tmp6_;
			_tmp6_ = NULL;
			_media_metadata_unref0 (metadata);
			metadata = (MediaMetadata*) _tmp9_;
			_media_metadata_unref0 (_tmp6_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_video_reader_unref0 (reader);
			_media_metadata_unref0 (metadata);
			return NULL;
		}
		_video_reader_unref0 (reader);
	} else {
		PhotoFileReader* reader = NULL;
		gchar* _tmp10_;
		gchar* _tmp11_;
		PhotoFileReader* _tmp12_;
		PhotoFileReader* _tmp13_;
		_tmp10_ = g_file_get_path (src);
		_tmp11_ = _tmp10_;
		_tmp12_ = photo_file_format_create_reader (photo_file_format_get_by_file_extension (src), _tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		reader = _tmp13_;
		{
			PhotoMetadata* _tmp14_ = NULL;
			PhotoFileReader* _tmp15_;
			PhotoMetadata* _tmp16_;
			PhotoMetadata* _tmp17_;
			_tmp15_ = reader;
			_tmp16_ = photo_file_reader_read_metadata (_tmp15_, &_inner_error0_);
			_tmp14_ = _tmp16_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
			_tmp17_ = _tmp14_;
			_tmp14_ = NULL;
			_media_metadata_unref0 (metadata);
			metadata = (MediaMetadata*) _tmp17_;
			_media_metadata_unref0 (_tmp14_);
		}
		goto __finally2;
		__catch2_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_photo_file_adapter_unref0 (reader);
			_media_metadata_unref0 (metadata);
			return NULL;
		}
		_photo_file_adapter_unref0 (reader);
	}
	_tmp18_ = g_file_get_basename (src);
	_tmp19_ = _tmp18_;
	_tmp20_ = metadata;
	_tmp22_ = library_files_generate_unique_file (_tmp19_, _tmp20_, timestamp, &_tmp21_, &_inner_error0_);
	collision = _tmp21_;
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp19_);
	dest = _tmp23_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_media_metadata_unref0 (metadata);
		return NULL;
	}
	_tmp24_ = dest;
	if (_tmp24_ == NULL) {
		GError* _tmp25_;
		_tmp25_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, "Unable to generate unique pathname for destination");
		_inner_error0_ = _tmp25_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dest);
		_media_metadata_unref0 (metadata);
		return NULL;
	}
	if (blacklist) {
		GFile* _tmp26_;
		_tmp26_ = dest;
		library_monitor_blacklist_file (_tmp26_, "LibraryFiles.duplicate");
	}
	{
		GFile* _tmp27_;
		_tmp27_ = dest;
		g_file_copy (src, _tmp27_, G_FILE_COPY_ALL_METADATA | G_FILE_COPY_OVERWRITE, NULL, progress_callback, progress_callback_target, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch3_g_error;
		}
		if (blacklist) {
			GFile* _tmp28_;
			_tmp28_ = dest;
			library_monitor_unblacklist_file (_tmp28_);
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* err = NULL;
		gchar* _tmp29_;
		gchar* _tmp30_;
		GError* _tmp31_;
		const gchar* _tmp32_;
		gboolean _tmp33_ = FALSE;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp29_ = g_file_get_path (src);
		_tmp30_ = _tmp29_;
		_tmp31_ = err;
		_tmp32_ = _tmp31_->message;
		g_message ("LibraryFiles.vala:100: There was a problem copying %s: %s", _tmp30_, _tmp32_);
		_g_free0 (_tmp30_);
		if (blacklist) {
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_;
			gchar* _tmp36_ = NULL;
			GFile* _tmp37_;
			gchar* _tmp38_;
			_tmp35_ = md5_file (src, &_inner_error0_);
			_tmp34_ = _tmp35_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_error_free0 (err);
				goto __finally3;
			}
			_tmp37_ = dest;
			_tmp38_ = md5_file (_tmp37_, &_inner_error0_);
			_tmp36_ = _tmp38_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (_tmp34_);
				_g_error_free0 (err);
				goto __finally3;
			}
			_tmp33_ = g_strcmp0 (_tmp34_, _tmp36_) != 0;
			_g_free0 (_tmp36_);
			_g_free0 (_tmp34_);
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			GFile* _tmp39_;
			_tmp39_ = dest;
			library_monitor_unblacklist_file (_tmp39_);
		}
		_g_error_free0 (err);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dest);
		_media_metadata_unref0 (metadata);
		return NULL;
	}
	{
		GFileInfo* info = NULL;
		GFile* _tmp40_;
		GFileInfo* _tmp41_;
		guint32 mode = 0U;
		GFileInfo* _tmp42_;
		gboolean _tmp43_ = FALSE;
		GFile* _tmp44_;
		_tmp40_ = dest;
		_tmp41_ = g_file_query_info (_tmp40_, G_FILE_ATTRIBUTE_UNIX_MODE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		info = _tmp41_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch4_g_error;
		}
		_tmp42_ = info;
		mode = g_file_info_get_attribute_uint32 (_tmp42_, G_FILE_ATTRIBUTE_UNIX_MODE) | 0600;
		_tmp44_ = dest;
		_tmp43_ = g_file_set_attribute_uint32 (_tmp44_, G_FILE_ATTRIBUTE_UNIX_MODE, mode, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (info);
			goto __catch4_g_error;
		}
		if (!_tmp43_) {
			g_warning ("LibraryFiles.vala:110: Could not make file writable");
		}
		_g_object_unref0 (info);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* err = NULL;
		GError* _tmp45_;
		const gchar* _tmp46_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp45_ = err;
		_tmp46_ = _tmp45_->message;
		g_warning ("LibraryFiles.vala:113: Could not make file writable: %s", _tmp46_);
		_g_error_free0 (err);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dest);
		_media_metadata_unref0 (metadata);
		return NULL;
	}
	result = dest;
	_media_metadata_unref0 (metadata);
	return result;
}

