/* LibraryMonitor.c generated by valac 0.56.18, the Vala compiler
 * generated from LibraryMonitor.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/
/**/
/* LibraryMonitor uses DirectoryMonitor to track assets in the user's library directory and make*/
/* sure they're reflected in the application.*/
/**/
/* NOTE: There appears to be a bug where prior versions of Photos (<= 0.6.x) were not*/
/* properly loading the file modification timestamp during import.  This was no issue*/
/* before but becomes imperative now with file monitoring.  A "proper" algorithm is*/
/* to reimport an entire photo if the modification time in the database is different*/
/* than the file's, but that's Real Bad when the user first turns on monitoring, as it*/
/* will cause a lot of reimports (think of a 10,000 photo database) and will blow away*/
/* ALL transformations, as they are now suspect.*/
/**/
/* So: If the modification time is zero and filesize is the same, simply update the*/
/* timestamp in the database and move on.*/
/**/
/* TODO: Although it seems highly unlikely that a file's timestamp could change but the file size*/
/* has not and the file really be "changed", it *is* possible, even in the case of complex little*/
/* animals like photo files.  We could be more liberal and treat this case as a metadata-changed*/
/* situation (since that's a likely case).*/
/**/

#include "io.elementary.photos.h"
#include <glib.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>

#define LIBRARY_MONITOR_FLUSH_IMPORT_QUEUE_SEC 3
#define LIBRARY_MONITOR_IMPORT_ROLL_QUIET_SEC (5 * 60)
#define LIBRARY_MONITOR_MIN_BLACKLIST_DURATION_MSEC (5 * 1000)
#define LIBRARY_MONITOR_MAX_VERIFY_EXISTING_MEDIA_JOBS 5
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _library_monitor_pool_unref0(var) ((var == NULL) ? NULL : (var = (library_monitor_pool_unref (var), NULL)))
typedef struct _ParamSpecLibraryMonitorPool ParamSpecLibraryMonitorPool;
enum  {
	LIBRARY_MONITOR_POOL_MONITOR_INSTALLED_SIGNAL,
	LIBRARY_MONITOR_POOL_MONITOR_DESTROYED_SIGNAL,
	LIBRARY_MONITOR_POOL_NUM_SIGNALS
};
static guint library_monitor_pool_signals[LIBRARY_MONITOR_POOL_NUM_SIGNALS] = {0};

#define LIBRARY_MONITOR_TYPE_VERIFY_JOB (library_monitor_verify_job_get_type ())
#define LIBRARY_MONITOR_VERIFY_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIBRARY_MONITOR_TYPE_VERIFY_JOB, LibraryMonitorVerifyJob))
#define LIBRARY_MONITOR_VERIFY_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIBRARY_MONITOR_TYPE_VERIFY_JOB, LibraryMonitorVerifyJobClass))
#define LIBRARY_MONITOR_IS_VERIFY_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIBRARY_MONITOR_TYPE_VERIFY_JOB))
#define LIBRARY_MONITOR_IS_VERIFY_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIBRARY_MONITOR_TYPE_VERIFY_JOB))
#define LIBRARY_MONITOR_VERIFY_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIBRARY_MONITOR_TYPE_VERIFY_JOB, LibraryMonitorVerifyJobClass))

typedef struct _LibraryMonitorVerifyJob LibraryMonitorVerifyJob;
typedef struct _LibraryMonitorVerifyJobClass LibraryMonitorVerifyJobClass;
enum  {
	LIBRARY_MONITOR_0_PROPERTY,
	LIBRARY_MONITOR_NUM_PROPERTIES
};
static GParamSpec* library_monitor_properties[LIBRARY_MONITOR_NUM_PROPERTIES];
#define _workers_unref0(var) ((var == NULL) ? NULL : (var = (workers_unref (var), NULL)))
#define _batch_import_roll_unref0(var) ((var == NULL) ? NULL : (var = (batch_import_roll_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _media_collection_registry_unref0(var) ((var == NULL) ? NULL : (var = (media_collection_registry_unref (var), NULL)))

#define LIBRARY_MONITOR_TYPE_FIND_MOVE_JOB (library_monitor_find_move_job_get_type ())
#define LIBRARY_MONITOR_FIND_MOVE_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIBRARY_MONITOR_TYPE_FIND_MOVE_JOB, LibraryMonitorFindMoveJob))
#define LIBRARY_MONITOR_FIND_MOVE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIBRARY_MONITOR_TYPE_FIND_MOVE_JOB, LibraryMonitorFindMoveJobClass))
#define LIBRARY_MONITOR_IS_FIND_MOVE_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIBRARY_MONITOR_TYPE_FIND_MOVE_JOB))
#define LIBRARY_MONITOR_IS_FIND_MOVE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIBRARY_MONITOR_TYPE_FIND_MOVE_JOB))
#define LIBRARY_MONITOR_FIND_MOVE_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIBRARY_MONITOR_TYPE_FIND_MOVE_JOB, LibraryMonitorFindMoveJobClass))

typedef struct _LibraryMonitorFindMoveJob LibraryMonitorFindMoveJob;
typedef struct _LibraryMonitorFindMoveJobClass LibraryMonitorFindMoveJobClass;
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))
typedef struct _LibraryMonitorAsyncDiscoveryCompletedData LibraryMonitorAsyncDiscoveryCompletedData;
typedef struct _LibraryMonitorFindMoveJobPrivate LibraryMonitorFindMoveJobPrivate;
#define _source_holding_tank_unref0(var) ((var == NULL) ? NULL : (var = (source_holding_tank_unref (var), NULL)))
#define _library_monitor_verify_job_unref0(var) ((var == NULL) ? NULL : (var = (library_monitor_verify_job_unref (var), NULL)))
typedef struct _LibraryMonitorVerifyJobPrivate LibraryMonitorVerifyJobPrivate;
typedef struct _LibraryMonitorVerifyMonitorableData LibraryMonitorVerifyMonitorableData;
#define _batch_import_job_unref0(var) ((var == NULL) ? NULL : (var = (batch_import_job_unref (var), NULL)))
#define _batch_import_result_unref0(var) ((var == NULL) ? NULL : (var = (batch_import_result_unref (var), NULL)))
#define _tombstoned_file_unref0(var) ((var == NULL) ? NULL : (var = (tombstoned_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define LIBRARY_MONITOR_TYPE_RUNTIME_FIND_MOVE_JOB (library_monitor_runtime_find_move_job_get_type ())
#define LIBRARY_MONITOR_RUNTIME_FIND_MOVE_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIBRARY_MONITOR_TYPE_RUNTIME_FIND_MOVE_JOB, LibraryMonitorRuntimeFindMoveJob))
#define LIBRARY_MONITOR_RUNTIME_FIND_MOVE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIBRARY_MONITOR_TYPE_RUNTIME_FIND_MOVE_JOB, LibraryMonitorRuntimeFindMoveJobClass))
#define LIBRARY_MONITOR_IS_RUNTIME_FIND_MOVE_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIBRARY_MONITOR_TYPE_RUNTIME_FIND_MOVE_JOB))
#define LIBRARY_MONITOR_IS_RUNTIME_FIND_MOVE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIBRARY_MONITOR_TYPE_RUNTIME_FIND_MOVE_JOB))
#define LIBRARY_MONITOR_RUNTIME_FIND_MOVE_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIBRARY_MONITOR_TYPE_RUNTIME_FIND_MOVE_JOB, LibraryMonitorRuntimeFindMoveJobClass))

typedef struct _LibraryMonitorRuntimeFindMoveJob LibraryMonitorRuntimeFindMoveJob;
typedef struct _LibraryMonitorRuntimeFindMoveJobClass LibraryMonitorRuntimeFindMoveJobClass;
typedef struct _LibraryMonitorRuntimeFindMoveJobPrivate LibraryMonitorRuntimeFindMoveJobPrivate;
typedef struct _LibraryMonitorParamSpecVerifyJob LibraryMonitorParamSpecVerifyJob;
enum  {
	LIBRARY_MONITOR_AUTO_UPDATE_PROGRESS_SIGNAL,
	LIBRARY_MONITOR_AUTO_IMPORT_PREPARING_SIGNAL,
	LIBRARY_MONITOR_AUTO_IMPORT_PROGRESS_SIGNAL,
	LIBRARY_MONITOR_NUM_SIGNALS
};
static guint library_monitor_signals[LIBRARY_MONITOR_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _LibraryMonitorPoolPrivate {
	LibraryMonitor* monitor;
	guint timer_id;
};

struct _ParamSpecLibraryMonitorPool {
	GParamSpec parent_instance;
};

struct _LibraryMonitorPrivate {
	Workers* workers;
	GCancellable* cancellable;
	gboolean auto_import;
	GeeHashSet* unknown_files;
	GeeList* monitors;
	GeeHashMap* discovered;
	GeeHashSet* import_queue;
	GeeHashSet* pending_imports;
	GeeArrayList* batch_import_queue;
	BatchImportRoll* current_import_roll;
	gint64 last_import_roll_use;
	BatchImport* current_batch_import;
	gint checksums_completed;
	gint checksums_total;
	guint import_queue_timer_id;
	GeeQueue* verify_queue;
	gint outstanding_verify_jobs;
	gint completed_monitorable_verifies;
	gint total_monitorable_verifies;
	GSettings* file_settings;
};

struct _LibraryMonitorAsyncDiscoveryCompletedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	LibraryMonitor* self;
	GeeHashSet* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* all_candidates;
	GeeArrayList* _tmp3_;
	GeeArrayList* adopted;
	GeeArrayList* _tmp4_;
	GeeIterator* _file_it;
	GeeHashSet* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _tmp7_;
	GFile* file;
	GeeIterator* _tmp8_;
	gpointer _tmp9_;
	GFileInfo* info;
	GFile* _tmp10_;
	GFileInfo* _tmp11_;
	GFileInfo* _tmp12_;
	GeeArrayList* _tmp13_;
	GeeCollection* candidates;
	gboolean associated;
	GeeList* _monitor_list;
	GeeList* _tmp14_;
	gint _monitor_size;
	GeeList* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _monitor_index;
	gint _tmp18_;
	gint _tmp19_;
	MediaMonitor* monitor;
	GeeList* _tmp20_;
	gpointer _tmp21_;
	MediaMonitorDiscoveredFile _result_;
	MediaMonitor* _tmp22_;
	GFile* _tmp23_;
	GFileInfo* _tmp24_;
	MediaMonitorDiscoveredFile _tmp25_;
	GeeCollection* _tmp26_;
	gboolean _tmp27_;
	GeeCollection* _tmp28_;
	GeeArrayList* _tmp29_;
	GeeCollection* _tmp30_;
	GeeArrayList* _tmp31_;
	GFile* _tmp32_;
	GeeArrayList* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	GeeArrayList* job_candidates;
	GeeArrayList* _tmp36_;
	GeeArrayList* _tmp37_;
	GeeArrayList* _tmp38_;
	gint _tmp39_;
	Workers* _tmp40_;
	GFile* _tmp41_;
	GeeArrayList* _tmp42_;
	LibraryMonitorFindMoveJob* _tmp43_;
	LibraryMonitorFindMoveJob* _tmp44_;
	GeeHashSet* _tmp45_;
	GeeArrayList* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
};

struct _LibraryMonitorFindMoveJob {
	BackgroundJob parent_instance;
	LibraryMonitorFindMoveJobPrivate * priv;
	GFile* file;
	GeeCollection* candidates;
	Monitorable* match;
	GeeArrayList* losers;
	GError* err;
};

struct _LibraryMonitorFindMoveJobClass {
	BackgroundJobClass parent_class;
};

struct _LibraryMonitorVerifyJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LibraryMonitorVerifyJobPrivate * priv;
	Monitorable* monitorable;
	MediaMonitor* monitor;
};

struct _LibraryMonitorVerifyJobClass {
	GTypeClass parent_class;
	void (*finalize) (LibraryMonitorVerifyJob *self);
};

struct _LibraryMonitorVerifyMonitorableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	LibraryMonitor* self;
	Monitorable* monitorable;
	MediaMonitor* monitor;
	GFile** files;
	GFile** _tmp0_;
	gint files_length1;
	gint _files_size_;
	GFile** _tmp1_;
	gint _tmp1__length1;
	GFile* _tmp2_;
	GFile** aux_files;
	gint _tmp3_;
	GFile** _tmp4_;
	gint aux_files_length1;
	gint _aux_files_size_;
	GFile** _tmp5_;
	gint _tmp5__length1;
	GFile** _tmp6_;
	gint _tmp6__length1;
	GFile** aux_file_collection;
	gint aux_file_collection_length1;
	gint _aux_file_collection_size_;
	gint aux_file_it;
	GFile* _tmp7_;
	GFile* aux_file;
	GFile* _tmp8_;
	GFile* _tmp9_;
	gint ctr;
	gboolean _tmp10_;
	gint _tmp11_;
	GFile** _tmp12_;
	gint _tmp12__length1;
	GFile* file;
	GFile** _tmp13_;
	gint _tmp13__length1;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GFileInfo* info;
	GFile* _tmp16_;
	GFileInfo* _tmp17_;
	GFileInfo* _tmp18_;
	GFileInfo* _tmp19_;
	GFile* _tmp20_;
	GCancellable* _tmp21_;
	GFileInfo* _tmp22_;
	GFileInfo* _tmp23_;
	gboolean _tmp24_;
	GFileInfo* _tmp25_;
	gboolean _tmp26_;
	GFileInfo* _tmp27_;
	GFile* _tmp28_;
	GFileInfo* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	GError* _inner_error0_;
};

struct _LibraryMonitorRuntimeFindMoveJob {
	BackgroundJob parent_instance;
	LibraryMonitorRuntimeFindMoveJobPrivate * priv;
	GFile* file;
	GeeCollection* candidates;
	Monitorable* match;
	GError* err;
};

struct _LibraryMonitorRuntimeFindMoveJobClass {
	BackgroundJobClass parent_class;
};

struct _LibraryMonitorParamSpecVerifyJob {
	GParamSpec parent_instance;
};

static gint LibraryMonitorPool_private_offset;
static gpointer library_monitor_pool_parent_class = NULL;
static LibraryMonitorPool* library_monitor_pool_instance;
static LibraryMonitorPool* library_monitor_pool_instance = NULL;
static gint LibraryMonitor_private_offset;
static gpointer library_monitor_parent_class = NULL;
static GeeHashSet* library_monitor_blacklist;
static GRecMutex __lock_library_monitor_library_monitor_blacklist = {0};
static GeeHashSet* library_monitor_blacklist = NULL;
static HashTimedQueue* library_monitor_to_unblacklist;
static HashTimedQueue* library_monitor_to_unblacklist = NULL;
VALA_EXTERN gboolean commandline_options_no_runtime_monitoring;
static gpointer library_monitor_find_move_job_parent_class = NULL;
static gpointer library_monitor_runtime_find_move_job_parent_class = NULL;
static gpointer library_monitor_verify_job_parent_class = NULL;

static LibraryMonitorPool* library_monitor_pool_new (void);
static LibraryMonitorPool* library_monitor_pool_construct (GType object_type);
static void library_monitor_pool_close (LibraryMonitorPool* self);
static gboolean library_monitor_pool_on_start_monitor (LibraryMonitorPool* self);
static gboolean _library_monitor_pool_on_start_monitor_gsource_func (gpointer self);
static void library_monitor_pool_finalize (LibraryMonitorPool * obj);
static GType library_monitor_pool_get_type_once (void);
static gpointer library_monitor_verify_job_ref (gpointer instance);
static void library_monitor_verify_job_unref (gpointer instance);
static GParamSpec* library_monitor_param_spec_verify_job (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags) G_GNUC_UNUSED ;
static void library_monitor_value_set_verify_job (GValue* value,
                                           gpointer v_object) G_GNUC_UNUSED ;
static void library_monitor_value_take_verify_job (GValue* value,
                                            gpointer v_object) G_GNUC_UNUSED ;
static gpointer library_monitor_value_get_verify_job (const GValue* value) G_GNUC_UNUSED ;
static GType library_monitor_verify_job_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static guint _file_hash_gee_hash_data_func (gconstpointer v,
                                     gpointer self);
static gboolean _file_equal_gee_equal_data_func (gconstpointer a,
                                          gconstpointer b,
                                          gpointer self);
static void library_monitor_on_unblacklist_file (GFile* file);
static void _library_monitor_on_unblacklist_file_dequeued_callback (gconstpointer item,
                                                             gpointer self);
static void library_monitor_on_config_changed (LibraryMonitor* self,
                                        const gchar* key);
static void _library_monitor_on_config_changed_g_settings_changed (GSettings* _sender,
                                                            const gchar* key,
                                                            gpointer self);
static gboolean library_monitor_on_flush_import_queue (LibraryMonitor* self);
static gboolean _library_monitor_on_flush_import_queue_gsource_func (gpointer self);
static void library_monitor_real_close (DirectoryMonitor* base);
static void library_monitor_add_to_discovered_list (LibraryMonitor* self,
                                             MediaMonitor* monitor,
                                             Monitorable* monitorable);
static MediaMonitor* library_monitor_get_monitor_for_monitorable (LibraryMonitor* self,
                                                           Monitorable* monitorable);
static void library_monitor_real_discovery_started (DirectoryMonitor* base);
static void library_monitor_real_file_discovered (DirectoryMonitor* base,
                                           GFile* file,
                                           GFileInfo* info);
static gboolean library_monitor_is_supported_filetype (LibraryMonitor* self,
                                                GFile* file);
static void library_monitor_real_discovery_completed (DirectoryMonitor* base);
static void library_monitor_async_discovery_completed (LibraryMonitor* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void library_monitor_async_discovery_completed_finish (LibraryMonitor* self,
                                                       GAsyncResult* _res_);
static void library_monitor_async_discovery_completed_data_free (gpointer _data);
static gboolean library_monitor_async_discovery_completed_co (LibraryMonitorAsyncDiscoveryCompletedData* _data_);
static void library_monitor_discovery_stage_completed (LibraryMonitor* self);
static LibraryMonitorFindMoveJob* library_monitor_find_move_job_new (LibraryMonitor* owner,
                                                              GFile* file,
                                                              GeeCollection* candidates);
static LibraryMonitorFindMoveJob* library_monitor_find_move_job_construct (GType object_type,
                                                                    LibraryMonitor* owner,
                                                                    GFile* file,
                                                                    GeeCollection* candidates);
static GType library_monitor_find_move_job_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gboolean _library_monitor_async_discovery_completed_co_gsource_func (gpointer self);
static void library_monitor_report_checksum_job_completed (LibraryMonitor* self);
static void library_monitor_on_find_move_completed (LibraryMonitor* self,
                                             BackgroundJob* j);
static void library_monitor_on_find_move_cancelled (LibraryMonitor* self,
                                             BackgroundJob* j);
static void library_monitor_enqueue_verify_monitorable (LibraryMonitor* self,
                                                 Monitorable* monitorable,
                                                 MediaMonitor* monitor);
static void library_monitor_enqueue_import_many (LibraryMonitor* self,
                                          GeeCollection* files);
static LibraryMonitorVerifyJob* library_monitor_verify_job_new (Monitorable* monitorable,
                                                         MediaMonitor* monitor);
static LibraryMonitorVerifyJob* library_monitor_verify_job_construct (GType object_type,
                                                               Monitorable* monitorable,
                                                               MediaMonitor* monitor);
static void library_monitor_execute_next_verify_job (LibraryMonitor* self);
static void library_monitor_verify_monitorable (LibraryMonitor* self,
                                         Monitorable* monitorable,
                                         MediaMonitor* monitor,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static void library_monitor_verify_monitorable_finish (LibraryMonitor* self,
                                                GAsyncResult* _res_);
static void library_monitor_verify_monitorable_data_free (gpointer _data);
static gboolean library_monitor_verify_monitorable_co (LibraryMonitorVerifyMonitorableData* _data_);
static void _vala_array_add3 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
static void library_monitor_verify_monitorable_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static gboolean _library_monitor_verify_monitorable_co_gsource_func (gpointer self);
static void library_monitor_import_unrepresented_files (LibraryMonitor* self);
static void library_monitor_cancel_batch_imports (LibraryMonitor* self);
static void library_monitor_enqueue_import (LibraryMonitor* self,
                                     GFile* file);
static void library_monitor_remove_queued_import (LibraryMonitor* self,
                                           GFile* file);
static void library_monitor_schedule_next_batch_import (LibraryMonitor* self);
static void library_monitor_on_import_preparing (LibraryMonitor* self);
static void _library_monitor_on_import_preparing_batch_import_preparing (BatchImport* _sender,
                                                                  gpointer self);
static void library_monitor_on_import_progress (LibraryMonitor* self,
                                         guint64 completed_bytes,
                                         guint64 total_bytes);
static void _library_monitor_on_import_progress_batch_import_progress (BatchImport* _sender,
                                                                guint64 completed_bytes,
                                                                guint64 total_bytes,
                                                                gpointer self);
static void library_monitor_on_import_complete (LibraryMonitor* self,
                                         BatchImport* batch_import,
                                         ImportManifest* manifest,
                                         BatchImportRoll* import_roll);
static void _library_monitor_on_import_complete_batch_import_import_complete (BatchImport* _sender,
                                                                       ImportManifest* manifest,
                                                                       BatchImportRoll* import_roll,
                                                                       gpointer self);
static void library_monitor_discard_current_batch_import (LibraryMonitor* self);
static void library_monitor_runtime_unknown_file_discovered (LibraryMonitor* self,
                                                      GFile* file);
static void library_monitor_real_notify_file_created (DirectoryMonitor* base,
                                               GFile* file,
                                               GFileInfo* info);
static LibraryMonitorRuntimeFindMoveJob* library_monitor_runtime_find_move_job_new (LibraryMonitor* owner,
                                                                             GFile* file,
                                                                             GeeCollection* candidates);
static LibraryMonitorRuntimeFindMoveJob* library_monitor_runtime_find_move_job_construct (GType object_type,
                                                                                   LibraryMonitor* owner,
                                                                                   GFile* file,
                                                                                   GeeCollection* candidates);
static GType library_monitor_runtime_find_move_job_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void library_monitor_on_runtime_find_move_completed (LibraryMonitor* self,
                                                     BackgroundJob* j);
static void library_monitor_real_notify_file_moved (DirectoryMonitor* base,
                                             GFile* old_file,
                                             GFile* new_file,
                                             GFileInfo* new_info);
static void library_monitor_real_notify_file_altered (DirectoryMonitor* base,
                                               GFile* file);
static void library_monitor_real_notify_file_attributes_altered (DirectoryMonitor* base,
                                                          GFile* file);
static void library_monitor_real_notify_file_alteration_completed (DirectoryMonitor* base,
                                                            GFile* file,
                                                            GFileInfo* info);
static void library_monitor_real_notify_file_deleted (DirectoryMonitor* base,
                                               GFile* file);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT64_UINT64 (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void _library_monitor_on_find_move_completed_completion_callback (BackgroundJob* job,
                                                                  gpointer self);
static void _library_monitor_on_find_move_cancelled_cancellation_callback (BackgroundJob* job,
                                                                    gpointer self);
static void library_monitor_find_move_job_real_execute (BackgroundJob* base);
static void library_monitor_find_move_job_finalize (BackgroundJob * obj);
static GType library_monitor_find_move_job_get_type_once (void);
static void _library_monitor_on_runtime_find_move_completed_completion_callback (BackgroundJob* job,
                                                                          gpointer self);
static void library_monitor_runtime_find_move_job_real_execute (BackgroundJob* base);
static void library_monitor_runtime_find_move_job_finalize (BackgroundJob * obj);
static GType library_monitor_runtime_find_move_job_get_type_once (void);
static void library_monitor_verify_job_finalize (LibraryMonitorVerifyJob * obj);
static GType library_monitor_verify_job_get_type_once (void);
static GObject * library_monitor_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void library_monitor_finalize (GObject * obj);
static GType library_monitor_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
library_monitor_pool_get_instance_private (LibraryMonitorPool* self)
{
	return G_STRUCT_MEMBER_P (self, LibraryMonitorPool_private_offset);
}

static LibraryMonitorPool*
library_monitor_pool_construct (GType object_type)
{
	LibraryMonitorPool* self = NULL;
	self = (LibraryMonitorPool*) g_type_create_instance (object_type);
	return self;
}

static LibraryMonitorPool*
library_monitor_pool_new (void)
{
	return library_monitor_pool_construct (TYPE_LIBRARY_MONITOR_POOL);
}

void
library_monitor_pool_init (void)
{
}

void
library_monitor_pool_terminate (void)
{
	LibraryMonitorPool* _tmp0_;
	_tmp0_ = library_monitor_pool_instance;
	if (_tmp0_ != NULL) {
		LibraryMonitorPool* _tmp1_;
		_tmp1_ = library_monitor_pool_instance;
		library_monitor_pool_close (_tmp1_);
	}
	_library_monitor_pool_unref0 (library_monitor_pool_instance);
	library_monitor_pool_instance = NULL;
}

static gpointer
_library_monitor_pool_ref0 (gpointer self)
{
	return self ? library_monitor_pool_ref (self) : NULL;
}

LibraryMonitorPool*
library_monitor_pool_get_instance (void)
{
	LibraryMonitorPool* _tmp0_;
	LibraryMonitorPool* _tmp2_;
	LibraryMonitorPool* _tmp3_;
	LibraryMonitorPool* result;
	_tmp0_ = library_monitor_pool_instance;
	if (_tmp0_ == NULL) {
		LibraryMonitorPool* _tmp1_;
		_tmp1_ = library_monitor_pool_new ();
		_library_monitor_pool_unref0 (library_monitor_pool_instance);
		library_monitor_pool_instance = _tmp1_;
	}
	_tmp2_ = library_monitor_pool_instance;
	_tmp3_ = _library_monitor_pool_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

LibraryMonitor*
library_monitor_pool_get_monitor (LibraryMonitorPool* self)
{
	LibraryMonitor* _tmp0_;
	LibraryMonitor* _tmp1_;
	LibraryMonitor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->monitor;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
_library_monitor_pool_on_start_monitor_gsource_func (gpointer self)
{
	gboolean result;
	result = library_monitor_pool_on_start_monitor ((LibraryMonitorPool*) self);
	return result;
}

void
library_monitor_pool_replace (LibraryMonitorPool* self,
                              LibraryMonitor* replacement,
                              gint start_msec_delay)
{
	LibraryMonitor* _tmp0_;
	gboolean _tmp1_ = FALSE;
	LibraryMonitor* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (replacement != NULL);
	library_monitor_pool_close (self);
	_tmp0_ = _g_object_ref0 (replacement);
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp0_;
	if (start_msec_delay > 0) {
		_tmp1_ = self->priv->timer_id == ((guint) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		self->priv->timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) start_msec_delay, _library_monitor_pool_on_start_monitor_gsource_func, library_monitor_pool_ref (self), library_monitor_pool_unref);
	}
	_tmp2_ = self->priv->monitor;
	g_signal_emit (self, library_monitor_pool_signals[LIBRARY_MONITOR_POOL_MONITOR_INSTALLED_SIGNAL], 0, _tmp2_);
}

static void
library_monitor_pool_close (LibraryMonitorPool* self)
{
	LibraryMonitor* _tmp0_;
	LibraryMonitor* _tmp1_;
	LibraryMonitor* closed = NULL;
	LibraryMonitor* _tmp2_;
	LibraryMonitor* _tmp3_;
	LibraryMonitor* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->monitor;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->monitor;
	directory_monitor_close ((DirectoryMonitor*) _tmp1_);
	_tmp2_ = self->priv->monitor;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	closed = _tmp3_;
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = NULL;
	_tmp4_ = closed;
	g_signal_emit (self, library_monitor_pool_signals[LIBRARY_MONITOR_POOL_MONITOR_DESTROYED_SIGNAL], 0, _tmp4_);
	_g_object_unref0 (closed);
}

static gboolean
library_monitor_pool_on_start_monitor (LibraryMonitorPool* self)
{
	LibraryMonitor* _tmp0_;
	LibraryMonitor* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->timer_id = (guint) 0;
	_tmp0_ = self->priv->monitor;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->monitor;
	directory_monitor_start_discovery ((DirectoryMonitor*) _tmp1_);
	result = FALSE;
	return result;
}

static void
value_library_monitor_pool_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_library_monitor_pool_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		library_monitor_pool_unref (value->data[0].v_pointer);
	}
}

static void
value_library_monitor_pool_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = library_monitor_pool_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_library_monitor_pool_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_library_monitor_pool_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		LibraryMonitorPool * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = library_monitor_pool_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_library_monitor_pool_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	LibraryMonitorPool ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = library_monitor_pool_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_library_monitor_pool (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	ParamSpecLibraryMonitorPool* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_LIBRARY_MONITOR_POOL), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_library_monitor_pool (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LIBRARY_MONITOR_POOL), NULL);
	return value->data[0].v_pointer;
}

void
value_set_library_monitor_pool (GValue* value,
                                gpointer v_object)
{
	LibraryMonitorPool * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LIBRARY_MONITOR_POOL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LIBRARY_MONITOR_POOL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		library_monitor_pool_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		library_monitor_pool_unref (old);
	}
}

void
value_take_library_monitor_pool (GValue* value,
                                 gpointer v_object)
{
	LibraryMonitorPool * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LIBRARY_MONITOR_POOL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LIBRARY_MONITOR_POOL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		library_monitor_pool_unref (old);
	}
}

static void
library_monitor_pool_class_init (LibraryMonitorPoolClass * klass,
                                 gpointer klass_data)
{
	library_monitor_pool_parent_class = g_type_class_peek_parent (klass);
	((LibraryMonitorPoolClass *) klass)->finalize = library_monitor_pool_finalize;
	g_type_class_adjust_private_offset (klass, &LibraryMonitorPool_private_offset);
	library_monitor_pool_signals[LIBRARY_MONITOR_POOL_MONITOR_INSTALLED_SIGNAL] = g_signal_new ("monitor-installed", TYPE_LIBRARY_MONITOR_POOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_LIBRARY_MONITOR);
	library_monitor_pool_signals[LIBRARY_MONITOR_POOL_MONITOR_DESTROYED_SIGNAL] = g_signal_new ("monitor-destroyed", TYPE_LIBRARY_MONITOR_POOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_LIBRARY_MONITOR);
}

static void
library_monitor_pool_instance_init (LibraryMonitorPool * self,
                                    gpointer klass)
{
	self->priv = library_monitor_pool_get_instance_private (self);
	self->priv->monitor = NULL;
	self->priv->timer_id = (guint) 0;
	self->ref_count = 1;
}

static void
library_monitor_pool_finalize (LibraryMonitorPool * obj)
{
	LibraryMonitorPool * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIBRARY_MONITOR_POOL, LibraryMonitorPool);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->monitor);
}

static GType
library_monitor_pool_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_library_monitor_pool_init, value_library_monitor_pool_free_value, value_library_monitor_pool_copy_value, value_library_monitor_pool_peek_pointer, "p", value_library_monitor_pool_collect_value, "p", value_library_monitor_pool_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (LibraryMonitorPoolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) library_monitor_pool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibraryMonitorPool), 0, (GInstanceInitFunc) library_monitor_pool_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType library_monitor_pool_type_id;
	library_monitor_pool_type_id = g_type_register_fundamental (g_type_fundamental_next (), "LibraryMonitorPool", &g_define_type_info, &g_define_type_fundamental_info, 0);
	LibraryMonitorPool_private_offset = g_type_add_instance_private (library_monitor_pool_type_id, sizeof (LibraryMonitorPoolPrivate));
	return library_monitor_pool_type_id;
}

GType
library_monitor_pool_get_type (void)
{
	static volatile gsize library_monitor_pool_type_id__once = 0;
	if (g_once_init_enter (&library_monitor_pool_type_id__once)) {
		GType library_monitor_pool_type_id;
		library_monitor_pool_type_id = library_monitor_pool_get_type_once ();
		g_once_init_leave (&library_monitor_pool_type_id__once, library_monitor_pool_type_id);
	}
	return library_monitor_pool_type_id__once;
}

gpointer
library_monitor_pool_ref (gpointer instance)
{
	LibraryMonitorPool * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
library_monitor_pool_unref (gpointer instance)
{
	LibraryMonitorPool * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		LIBRARY_MONITOR_POOL_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
library_monitor_get_instance_private (LibraryMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, LibraryMonitor_private_offset);
}

static guint
_file_hash_gee_hash_data_func (gconstpointer v,
                               gpointer self)
{
	guint result;
	result = file_hash ((GFile*) v);
	return result;
}

static gboolean
_file_equal_gee_equal_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gboolean result;
	result = file_equal ((GFile*) a, (GFile*) b);
	return result;
}

static void
_library_monitor_on_unblacklist_file_dequeued_callback (gconstpointer item,
                                                        gpointer self)
{
	library_monitor_on_unblacklist_file ((GFile*) item);
}

static void
_library_monitor_on_config_changed_g_settings_changed (GSettings* _sender,
                                                       const gchar* key,
                                                       gpointer self)
{
	library_monitor_on_config_changed ((LibraryMonitor*) self, key);
}

static gboolean
_library_monitor_on_flush_import_queue_gsource_func (gpointer self)
{
	gboolean result;
	result = library_monitor_on_flush_import_queue ((LibraryMonitor*) self);
	return result;
}

LibraryMonitor*
library_monitor_construct (GType object_type,
                           GFile* root,
                           gboolean recurse,
                           gboolean monitoring)
{
	LibraryMonitor * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_val_if_fail (root != NULL, NULL);
	self = (LibraryMonitor*) directory_monitor_construct (object_type, root, recurse, monitoring);
	_tmp0_ = self->priv->file_settings;
	self->priv->auto_import = g_settings_get_boolean (_tmp0_, "auto-import");
	_tmp1_ = self->priv->file_settings;
	g_signal_connect_object (_tmp1_, "changed", (GCallback) _library_monitor_on_config_changed_g_settings_changed, self, 0);
	self->priv->import_queue_timer_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) LIBRARY_MONITOR_FLUSH_IMPORT_QUEUE_SEC, _library_monitor_on_flush_import_queue_gsource_func, g_object_ref (self), g_object_unref);
	return self;
}

LibraryMonitor*
library_monitor_new (GFile* root,
                     gboolean recurse,
                     gboolean monitoring)
{
	return library_monitor_construct (TYPE_LIBRARY_MONITOR, root, recurse, monitoring);
}

static void
library_monitor_real_close (DirectoryMonitor* base)
{
	LibraryMonitor * self;
	GCancellable* _tmp0_;
	self = (LibraryMonitor*) base;
	_tmp0_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp0_);
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp1_;
		gint _monitor_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _monitor_index = 0;
		_tmp1_ = self->priv->monitors;
		_monitor_list = _tmp1_;
		_tmp2_ = _monitor_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_monitor_size = _tmp4_;
		_monitor_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			MediaMonitor* _tmp9_;
			_monitor_index = _monitor_index + 1;
			_tmp5_ = _monitor_index;
			_tmp6_ = _monitor_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _monitor_list;
			_tmp8_ = gee_list_get (_tmp7_, _monitor_index);
			monitor = (MediaMonitor*) _tmp8_;
			_tmp9_ = monitor;
			media_monitor_close (_tmp9_);
			_g_object_unref0 (monitor);
		}
	}
	if (self->priv->import_queue_timer_id != ((guint) 0)) {
		g_source_remove (self->priv->import_queue_timer_id);
		self->priv->import_queue_timer_id = (guint) 0;
	}
	DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->close (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor));
}

static void
library_monitor_add_to_discovered_list (LibraryMonitor* self,
                                        MediaMonitor* monitor,
                                        Monitorable* monitorable)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp4_;
	gpointer _tmp5_;
	GeeSet* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	g_return_if_fail (monitorable != NULL);
	_tmp0_ = self->priv->discovered;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, monitor)) {
		GeeHashMap* _tmp1_;
		GeeHashSet* _tmp2_;
		GeeHashSet* _tmp3_;
		_tmp1_ = self->priv->discovered;
		_tmp2_ = gee_hash_set_new (TYPE_MONITORABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		_tmp3_ = _tmp2_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, monitor, (GeeSet*) _tmp3_);
		_g_object_unref0 (_tmp3_);
	}
	_tmp4_ = self->priv->discovered;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, monitor);
	_tmp6_ = (GeeSet*) _tmp5_;
	gee_collection_add ((GeeCollection*) _tmp6_, monitorable);
	_g_object_unref0 (_tmp6_);
}

static MediaMonitor*
library_monitor_get_monitor_for_monitorable (LibraryMonitor* self,
                                             Monitorable* monitorable)
{
	gchar* _tmp12_;
	gchar* _tmp13_;
	MediaMonitor* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (monitorable != NULL, NULL);
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp0_;
		gint _monitor_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _monitor_index = 0;
		_tmp0_ = self->priv->monitors;
		_monitor_list = _tmp0_;
		_tmp1_ = _monitor_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_monitor_size = _tmp3_;
		_monitor_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			MediaMonitor* _tmp8_;
			MediaSourceCollection* _tmp9_;
			MediaSourceCollection* _tmp10_;
			gboolean _tmp11_;
			_monitor_index = _monitor_index + 1;
			_tmp4_ = _monitor_index;
			_tmp5_ = _monitor_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _monitor_list;
			_tmp7_ = gee_list_get (_tmp6_, _monitor_index);
			monitor = (MediaMonitor*) _tmp7_;
			_tmp8_ = monitor;
			_tmp9_ = media_monitor_get_media_source_collection (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = source_collection_holds_type_of_source ((SourceCollection*) _tmp10_, (DataSource*) monitorable);
			_data_collection_unref0 (_tmp10_);
			if (_tmp11_) {
				result = monitor;
				return result;
			}
			_g_object_unref0 (monitor);
		}
	}
	_tmp12_ = data_object_to_string ((DataObject*) monitorable);
	_tmp13_ = _tmp12_;
	g_error ("LibraryMonitor.vala:291: Unable to locate MediaMonitor for %s", _tmp13_);
	_g_free0 (_tmp13_);
}

static void
library_monitor_real_discovery_started (DirectoryMonitor* base)
{
	LibraryMonitor * self;
	GeeHashMap* _tmp24_;
	GeeHashSet* _tmp25_;
	self = (LibraryMonitor*) base;
	{
		GeeIterator* _collection_it = NULL;
		MediaCollectionRegistry* _tmp0_;
		MediaCollectionRegistry* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = media_collection_registry_get_instance ();
		_tmp1_ = _tmp0_;
		_tmp2_ = media_collection_registry_get_all (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_media_collection_registry_unref0 (_tmp1_);
		_collection_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			MediaSourceCollection* collection = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GeeList* _tmp9_;
			MediaSourceCollection* _tmp10_;
			Workers* _tmp11_;
			GCancellable* _tmp12_;
			MediaMonitor* _tmp13_;
			MediaMonitor* _tmp14_;
			_tmp6_ = _collection_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _collection_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			collection = (MediaSourceCollection*) _tmp8_;
			_tmp9_ = self->priv->monitors;
			_tmp10_ = collection;
			_tmp11_ = self->priv->workers;
			_tmp12_ = self->priv->cancellable;
			_tmp13_ = media_source_collection_create_media_monitor (_tmp10_, _tmp11_, _tmp12_);
			_tmp14_ = _tmp13_;
			gee_collection_add ((GeeCollection*) _tmp9_, _tmp14_);
			_g_object_unref0 (_tmp14_);
			_data_collection_unref0 (collection);
		}
		_g_object_unref0 (_collection_it);
	}
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp15_;
		gint _monitor_size = 0;
		GeeList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _monitor_index = 0;
		_tmp15_ = self->priv->monitors;
		_monitor_list = _tmp15_;
		_tmp16_ = _monitor_list;
		_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_monitor_size = _tmp18_;
		_monitor_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp21_;
			gpointer _tmp22_;
			MediaMonitor* _tmp23_;
			_monitor_index = _monitor_index + 1;
			_tmp19_ = _monitor_index;
			_tmp20_ = _monitor_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _monitor_list;
			_tmp22_ = gee_list_get (_tmp21_, _monitor_index);
			monitor = (MediaMonitor*) _tmp22_;
			_tmp23_ = monitor;
			media_monitor_notify_discovery_started (_tmp23_);
			_g_object_unref0 (monitor);
		}
	}
	_tmp24_ = gee_hash_map_new (TYPE_MEDIA_MONITOR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEE_TYPE_SET, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->discovered);
	self->priv->discovered = _tmp24_;
	_tmp25_ = gee_hash_set_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (self->priv->unknown_files);
	self->priv->unknown_files = _tmp25_;
	DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->discovery_started (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor));
}

static void
library_monitor_real_file_discovered (DirectoryMonitor* base,
                                      GFile* file,
                                      GFileInfo* info)
{
	LibraryMonitor * self;
	Monitorable* representation = NULL;
	MediaMonitor* representing = NULL;
	gboolean ignore = FALSE;
	MediaMonitor* _tmp13_;
	self = (LibraryMonitor*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (info != NULL);
	representation = NULL;
	representing = NULL;
	ignore = FALSE;
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp0_;
		gint _monitor_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _monitor_index = 0;
		_tmp0_ = self->priv->monitors;
		_monitor_list = _tmp0_;
		_tmp1_ = _monitor_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_monitor_size = _tmp3_;
		_monitor_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			MediaMonitorDiscoveredFile _result_ = 0;
			MediaMonitor* _tmp8_;
			Monitorable* _tmp9_ = NULL;
			MediaMonitorDiscoveredFile _tmp10_;
			_monitor_index = _monitor_index + 1;
			_tmp4_ = _monitor_index;
			_tmp5_ = _monitor_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _monitor_list;
			_tmp7_ = gee_list_get (_tmp6_, _monitor_index);
			monitor = (MediaMonitor*) _tmp7_;
			_tmp8_ = monitor;
			_tmp10_ = media_monitor_notify_file_discovered (_tmp8_, file, info, &_tmp9_);
			_g_object_unref0 (representation);
			representation = _tmp9_;
			_result_ = _tmp10_;
			if (_result_ == MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED) {
				MediaMonitor* _tmp11_;
				MediaMonitor* _tmp12_;
				_tmp11_ = monitor;
				_tmp12_ = _g_object_ref0 (_tmp11_);
				_g_object_unref0 (representing);
				representing = _tmp12_;
				_g_object_unref0 (monitor);
				break;
			} else {
				if (_result_ == MEDIA_MONITOR_DISCOVERED_FILE_IGNORE) {
					ignore = TRUE;
					_g_object_unref0 (monitor);
					break;
				}
			}
			_g_object_unref0 (monitor);
		}
	}
	_tmp13_ = representing;
	if (_tmp13_ != NULL) {
		gboolean _tmp14_ = FALSE;
		Monitorable* _tmp15_;
		MediaMonitor* _tmp16_;
		Monitorable* _tmp17_;
		_tmp15_ = representation;
		if (_tmp15_ != NULL) {
			_tmp14_ = !ignore;
		} else {
			_tmp14_ = FALSE;
		}
		_vala_assert (_tmp14_, "representation != null && !ignore");
		_tmp16_ = representing;
		_tmp17_ = representation;
		library_monitor_add_to_discovered_list (self, _tmp16_, _tmp17_);
	} else {
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		if (!ignore) {
			TombstoneSourceCollection* _tmp20_;
			_tmp20_ = tombstone_global;
			_tmp19_ = !tombstone_source_collection_matches (_tmp20_, file);
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			_tmp18_ = library_monitor_is_supported_filetype (self, file);
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			GeeHashSet* _tmp21_;
			_tmp21_ = self->priv->unknown_files;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, file);
		}
	}
	DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->file_discovered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), file, info);
	_g_object_unref0 (representing);
	_g_object_unref0 (representation);
}

static void
library_monitor_real_discovery_completed (DirectoryMonitor* base)
{
	LibraryMonitor * self;
	self = (LibraryMonitor*) base;
	library_monitor_async_discovery_completed (self, NULL, NULL);
}

static void
library_monitor_async_discovery_completed_data_free (gpointer _data)
{
	LibraryMonitorAsyncDiscoveryCompletedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (LibraryMonitorAsyncDiscoveryCompletedData, _data_);
}

static void
library_monitor_async_discovery_completed (LibraryMonitor* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	LibraryMonitorAsyncDiscoveryCompletedData* _data_;
	LibraryMonitor* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (LibraryMonitorAsyncDiscoveryCompletedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, library_monitor_async_discovery_completed_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	library_monitor_async_discovery_completed_co (_data_);
}

static void
library_monitor_async_discovery_completed_finish (LibraryMonitor* self,
                                                  GAsyncResult* _res_)
{
	LibraryMonitorAsyncDiscoveryCompletedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
_library_monitor_async_discovery_completed_co_gsource_func (gpointer self)
{
	gboolean result;
	result = library_monitor_async_discovery_completed_co (self);
	return result;
}

static gboolean
library_monitor_async_discovery_completed_co (LibraryMonitorAsyncDiscoveryCompletedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->unknown_files;
	_data_->_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_tmp2_ == 0) {
		library_monitor_discovery_stage_completed (_data_->self);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = gee_array_list_new (TYPE_MONITORABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data_->all_candidates = _data_->_tmp3_;
	_data_->_tmp4_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_equal_gee_equal_data_func, NULL, NULL);
	_data_->adopted = _data_->_tmp4_;
	{
		_data_->_tmp5_ = _data_->self->priv->unknown_files;
		_data_->_tmp6_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _data_->_tmp5_);
		_data_->_file_it = _data_->_tmp6_;
		while (TRUE) {
			_data_->_tmp7_ = _data_->_file_it;
			if (!gee_iterator_next (_data_->_tmp7_)) {
				break;
			}
			_data_->_tmp8_ = _data_->_file_it;
			_data_->_tmp9_ = gee_iterator_get (_data_->_tmp8_);
			_data_->file = (GFile*) _data_->_tmp9_;
			_data_->_tmp10_ = _data_->file;
			_data_->_tmp11_ = directory_monitor_get_file_info ((DirectoryMonitor*) _data_->self, _data_->_tmp10_);
			_data_->info = _data_->_tmp11_;
			_data_->_tmp12_ = _data_->info;
			if (_data_->_tmp12_ == NULL) {
				_g_object_unref0 (_data_->info);
				_g_object_unref0 (_data_->file);
				continue;
			}
			_data_->_tmp13_ = _data_->all_candidates;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _data_->_tmp13_);
			_data_->candidates = NULL;
			_data_->associated = FALSE;
			{
				_data_->_tmp14_ = _data_->self->priv->monitors;
				_data_->_monitor_list = _data_->_tmp14_;
				_data_->_tmp15_ = _data_->_monitor_list;
				_data_->_tmp16_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp15_);
				_data_->_tmp17_ = _data_->_tmp16_;
				_data_->_monitor_size = _data_->_tmp17_;
				_data_->_monitor_index = -1;
				while (TRUE) {
					_data_->_monitor_index = _data_->_monitor_index + 1;
					_data_->_tmp18_ = _data_->_monitor_index;
					_data_->_tmp19_ = _data_->_monitor_size;
					if (!(_data_->_tmp18_ < _data_->_tmp19_)) {
						break;
					}
					_data_->_tmp20_ = _data_->_monitor_list;
					_data_->_tmp21_ = gee_list_get (_data_->_tmp20_, _data_->_monitor_index);
					_data_->monitor = (MediaMonitor*) _data_->_tmp21_;
					_data_->_tmp22_ = _data_->monitor;
					_data_->_tmp23_ = _data_->file;
					_data_->_tmp24_ = _data_->info;
					_data_->_tmp25_ = 0;
					_data_->_tmp26_ = media_monitor_candidates_for_unknown_file (_data_->_tmp22_, _data_->_tmp23_, _data_->_tmp24_, &_data_->_tmp25_);
					_data_->_result_ = _data_->_tmp25_;
					_g_object_unref0 (_data_->candidates);
					_data_->candidates = _data_->_tmp26_;
					if (_data_->_result_ == MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED) {
						_data_->_tmp27_ = TRUE;
					} else {
						_data_->_tmp27_ = _data_->_result_ == MEDIA_MONITOR_DISCOVERED_FILE_IGNORE;
					}
					if (_data_->_tmp27_) {
						_data_->associated = TRUE;
						_g_object_unref0 (_data_->monitor);
						break;
					} else {
						_data_->_tmp28_ = _data_->candidates;
						if (_data_->_tmp28_ != NULL) {
							_data_->_tmp29_ = _data_->all_candidates;
							_data_->_tmp30_ = _data_->candidates;
							gee_array_list_add_all (_data_->_tmp29_, _data_->_tmp30_);
						}
					}
					_g_object_unref0 (_data_->monitor);
				}
			}
			if (_data_->associated) {
				_data_->_tmp31_ = _data_->adopted;
				_data_->_tmp32_ = _data_->file;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp31_, _data_->_tmp32_);
				_g_object_unref0 (_data_->candidates);
				_g_object_unref0 (_data_->info);
				_g_object_unref0 (_data_->file);
				continue;
			}
			_data_->_tmp33_ = _data_->all_candidates;
			_data_->_tmp34_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp33_);
			_data_->_tmp35_ = _data_->_tmp34_;
			if (_data_->_tmp35_ > 0) {
				_data_->_tmp36_ = _data_->all_candidates;
				_data_->_tmp37_ = _g_object_ref0 (_data_->_tmp36_);
				_data_->job_candidates = _data_->_tmp37_;
				_data_->_tmp38_ = gee_array_list_new (TYPE_MONITORABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
				_g_object_unref0 (_data_->all_candidates);
				_data_->all_candidates = _data_->_tmp38_;
				_data_->_tmp39_ = _data_->self->priv->checksums_total;
				_data_->self->priv->checksums_total = _data_->_tmp39_ + 1;
				_data_->_tmp40_ = _data_->self->priv->workers;
				_data_->_tmp41_ = _data_->file;
				_data_->_tmp42_ = _data_->job_candidates;
				_data_->_tmp43_ = library_monitor_find_move_job_new (_data_->self, _data_->_tmp41_, (GeeCollection*) _data_->_tmp42_);
				_data_->_tmp44_ = _data_->_tmp43_;
				workers_enqueue (_data_->_tmp40_, (BackgroundJob*) _data_->_tmp44_);
				_background_job_unref0 (_data_->_tmp44_);
				_g_object_unref0 (_data_->job_candidates);
			}
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _library_monitor_async_discovery_completed_co_gsource_func, _data_, NULL);
			_data_->_state_ = 1;
			return FALSE;
			_state_1:
			;
			_g_object_unref0 (_data_->candidates);
			_g_object_unref0 (_data_->info);
			_g_object_unref0 (_data_->file);
		}
		_g_object_unref0 (_data_->_file_it);
	}
	_data_->_tmp45_ = _data_->self->priv->unknown_files;
	_data_->_tmp46_ = _data_->adopted;
	gee_collection_remove_all ((GeeCollection*) _data_->_tmp45_, (GeeCollection*) _data_->_tmp46_);
	_data_->self->priv->checksums_completed = 0;
	if (_data_->self->priv->checksums_total == 0) {
		library_monitor_discovery_stage_completed (_data_->self);
	} else {
		_data_->_tmp47_ = g_strdup_printf ("%d checksum jobs initiated to verify unknown photo files", _data_->self->priv->checksums_total);
		_data_->_tmp48_ = _data_->_tmp47_;
		directory_monitor_mdbg (_data_->_tmp48_);
		_g_free0 (_data_->_tmp48_);
		g_signal_emit (_data_->self, library_monitor_signals[LIBRARY_MONITOR_AUTO_UPDATE_PROGRESS_SIGNAL], 0, _data_->self->priv->checksums_completed, _data_->self->priv->checksums_total);
	}
	_g_object_unref0 (_data_->adopted);
	_g_object_unref0 (_data_->all_candidates);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
library_monitor_report_checksum_job_completed (LibraryMonitor* self)
{
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_vala_assert (self->priv->checksums_completed < self->priv->checksums_total, "checksums_completed < checksums_total");
	_tmp0_ = self->priv->checksums_completed;
	self->priv->checksums_completed = _tmp0_ + 1;
	g_signal_emit (self, library_monitor_signals[LIBRARY_MONITOR_AUTO_UPDATE_PROGRESS_SIGNAL], 0, self->priv->checksums_completed, self->priv->checksums_total);
	if (self->priv->checksums_completed == self->priv->checksums_total) {
		library_monitor_discovery_stage_completed (self);
	}
}

static gpointer
_background_job_ref0 (gpointer self)
{
	return self ? background_job_ref (self) : NULL;
}

static void
library_monitor_on_find_move_completed (LibraryMonitor* self,
                                        BackgroundJob* j)
{
	LibraryMonitorFindMoveJob* job = NULL;
	LibraryMonitorFindMoveJob* _tmp0_;
	LibraryMonitorFindMoveJob* _tmp1_;
	Monitorable* _tmp2_;
	LibraryMonitorFindMoveJob* _tmp27_;
	GError* _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (j != NULL);
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, LIBRARY_MONITOR_TYPE_FIND_MOVE_JOB, LibraryMonitorFindMoveJob));
	job = _tmp0_;
	_tmp1_ = job;
	_tmp2_ = _tmp1_->match;
	if (_tmp2_ != NULL) {
		LibraryMonitorFindMoveJob* _tmp3_;
		GFile* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		LibraryMonitorFindMoveJob* _tmp7_;
		Monitorable* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		MediaMonitor* monitor = NULL;
		LibraryMonitorFindMoveJob* _tmp13_;
		Monitorable* _tmp14_;
		MediaMonitor* _tmp15_;
		MediaMonitor* _tmp16_;
		LibraryMonitorFindMoveJob* _tmp17_;
		Monitorable* _tmp18_;
		LibraryMonitorFindMoveJob* _tmp19_;
		GFile* _tmp20_;
		GeeHashSet* _tmp21_;
		LibraryMonitorFindMoveJob* _tmp22_;
		GFile* _tmp23_;
		MediaMonitor* _tmp24_;
		LibraryMonitorFindMoveJob* _tmp25_;
		Monitorable* _tmp26_;
		_tmp3_ = job;
		_tmp4_ = _tmp3_->file;
		_tmp5_ = g_file_get_path (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = job;
		_tmp8_ = _tmp7_->match;
		_tmp9_ = data_object_to_string ((DataObject*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf ("Found moved master file: %s matches %s", _tmp6_, _tmp10_);
		_tmp12_ = _tmp11_;
		directory_monitor_mdbg (_tmp12_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp6_);
		_tmp13_ = job;
		_tmp14_ = _tmp13_->match;
		_tmp15_ = library_monitor_get_monitor_for_monitorable (self, _tmp14_);
		monitor = _tmp15_;
		_tmp16_ = monitor;
		_tmp17_ = job;
		_tmp18_ = _tmp17_->match;
		_tmp19_ = job;
		_tmp20_ = _tmp19_->file;
		media_monitor_update_master_file (_tmp16_, _tmp18_, _tmp20_);
		_tmp21_ = self->priv->unknown_files;
		_tmp22_ = job;
		_tmp23_ = _tmp22_->file;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp21_, _tmp23_);
		_tmp24_ = monitor;
		_tmp25_ = job;
		_tmp26_ = _tmp25_->match;
		library_monitor_add_to_discovered_list (self, _tmp24_, _tmp26_);
		_g_object_unref0 (monitor);
	}
	_tmp27_ = job;
	_tmp28_ = _tmp27_->err;
	if (_tmp28_ != NULL) {
		LibraryMonitorFindMoveJob* _tmp29_;
		GFile* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		LibraryMonitorFindMoveJob* _tmp33_;
		GError* _tmp34_;
		const gchar* _tmp35_;
		_tmp29_ = job;
		_tmp30_ = _tmp29_->file;
		_tmp31_ = g_file_get_path (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = job;
		_tmp34_ = _tmp33_->err;
		_tmp35_ = _tmp34_->message;
		g_warning ("LibraryMonitor.vala:436: Unable to checksum unknown media file %s: %s", _tmp32_, _tmp35_);
		_g_free0 (_tmp32_);
	}
	library_monitor_report_checksum_job_completed (self);
	_background_job_unref0 (job);
}

static void
library_monitor_on_find_move_cancelled (LibraryMonitor* self,
                                        BackgroundJob* j)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (j != NULL);
	library_monitor_report_checksum_job_completed (self);
}

static void
library_monitor_discovery_stage_completed (LibraryMonitor* self)
{
	TombstoneSourceCollection* _tmp58_;
	GCancellable* _tmp59_;
	g_return_if_fail (self != NULL);
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp0_;
		gint _monitor_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _monitor_index = 0;
		_tmp0_ = self->priv->monitors;
		_monitor_list = _tmp0_;
		_tmp1_ = _monitor_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_monitor_size = _tmp3_;
		_monitor_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			GeeSet* monitorables = NULL;
			GeeHashMap* _tmp8_;
			MediaMonitor* _tmp9_;
			gpointer _tmp10_;
			GeeSet* _tmp11_;
			_monitor_index = _monitor_index + 1;
			_tmp4_ = _monitor_index;
			_tmp5_ = _monitor_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _monitor_list;
			_tmp7_ = gee_list_get (_tmp6_, _monitor_index);
			monitor = (MediaMonitor*) _tmp7_;
			_tmp8_ = self->priv->discovered;
			_tmp9_ = monitor;
			_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, _tmp9_);
			monitorables = (GeeSet*) _tmp10_;
			_tmp11_ = monitorables;
			if (_tmp11_ != NULL) {
				{
					GeeIterator* _monitorable_it = NULL;
					GeeSet* _tmp12_;
					GeeIterator* _tmp13_;
					_tmp12_ = monitorables;
					_tmp13_ = gee_iterable_iterator ((GeeIterable*) _tmp12_);
					_monitorable_it = _tmp13_;
					while (TRUE) {
						GeeIterator* _tmp14_;
						Monitorable* monitorable = NULL;
						GeeIterator* _tmp15_;
						gpointer _tmp16_;
						Monitorable* _tmp17_;
						MediaMonitor* _tmp18_;
						_tmp14_ = _monitorable_it;
						if (!gee_iterator_next (_tmp14_)) {
							break;
						}
						_tmp15_ = _monitorable_it;
						_tmp16_ = gee_iterator_get (_tmp15_);
						monitorable = (Monitorable*) _tmp16_;
						_tmp17_ = monitorable;
						_tmp18_ = monitor;
						library_monitor_enqueue_verify_monitorable (self, _tmp17_, _tmp18_);
						_g_object_unref0 (monitorable);
					}
					_g_object_unref0 (_monitorable_it);
				}
			}
			{
				GeeIterator* _object_it = NULL;
				MediaMonitor* _tmp19_;
				MediaSourceCollection* _tmp20_;
				MediaSourceCollection* _tmp21_;
				GeeCollection* _tmp22_;
				GeeCollection* _tmp23_;
				GeeIterator* _tmp24_;
				GeeIterator* _tmp25_;
				_tmp19_ = monitor;
				_tmp20_ = media_monitor_get_media_source_collection (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = data_collection_get_all ((DataCollection*) _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = gee_iterable_iterator ((GeeIterable*) _tmp23_);
				_tmp25_ = _tmp24_;
				_g_object_unref0 (_tmp23_);
				_data_collection_unref0 (_tmp21_);
				_object_it = _tmp25_;
				while (TRUE) {
					GeeIterator* _tmp26_;
					DataObject* object = NULL;
					GeeIterator* _tmp27_;
					gpointer _tmp28_;
					Monitorable* monitorable = NULL;
					DataObject* _tmp29_;
					Monitorable* _tmp30_;
					gboolean _tmp31_ = FALSE;
					GeeSet* _tmp32_;
					Monitorable* _tmp35_;
					MediaMonitor* _tmp36_;
					_tmp26_ = _object_it;
					if (!gee_iterator_next (_tmp26_)) {
						break;
					}
					_tmp27_ = _object_it;
					_tmp28_ = gee_iterator_get (_tmp27_);
					object = (DataObject*) _tmp28_;
					_tmp29_ = object;
					_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_MONITORABLE, Monitorable));
					monitorable = _tmp30_;
					_tmp32_ = monitorables;
					if (_tmp32_ != NULL) {
						GeeSet* _tmp33_;
						Monitorable* _tmp34_;
						_tmp33_ = monitorables;
						_tmp34_ = monitorable;
						_tmp31_ = gee_collection_contains ((GeeCollection*) _tmp33_, _tmp34_);
					} else {
						_tmp31_ = FALSE;
					}
					if (_tmp31_) {
						_g_object_unref0 (monitorable);
						_g_object_unref0 (object);
						continue;
					}
					_tmp35_ = monitorable;
					_tmp36_ = monitor;
					library_monitor_enqueue_verify_monitorable (self, _tmp35_, _tmp36_);
					_g_object_unref0 (monitorable);
					_g_object_unref0 (object);
				}
				_g_object_unref0 (_object_it);
			}
			{
				GeeIterator* _source_it = NULL;
				MediaMonitor* _tmp37_;
				MediaSourceCollection* _tmp38_;
				MediaSourceCollection* _tmp39_;
				MediaSourceHoldingTank* _tmp40_;
				MediaSourceHoldingTank* _tmp41_;
				GeeCollection* _tmp42_;
				GeeCollection* _tmp43_;
				GeeIterator* _tmp44_;
				GeeIterator* _tmp45_;
				_tmp37_ = monitor;
				_tmp38_ = media_monitor_get_media_source_collection (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = media_source_collection_get_offline_bin (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = source_holding_tank_get_all ((SourceHoldingTank*) _tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = gee_iterable_iterator ((GeeIterable*) _tmp43_);
				_tmp45_ = _tmp44_;
				_g_object_unref0 (_tmp43_);
				_source_holding_tank_unref0 (_tmp41_);
				_data_collection_unref0 (_tmp39_);
				_source_it = _tmp45_;
				while (TRUE) {
					GeeIterator* _tmp46_;
					DataSource* source = NULL;
					GeeIterator* _tmp47_;
					gpointer _tmp48_;
					Monitorable* monitorable = NULL;
					DataSource* _tmp49_;
					Monitorable* _tmp50_;
					gboolean _tmp51_ = FALSE;
					GeeSet* _tmp52_;
					Monitorable* _tmp55_;
					MediaMonitor* _tmp56_;
					_tmp46_ = _source_it;
					if (!gee_iterator_next (_tmp46_)) {
						break;
					}
					_tmp47_ = _source_it;
					_tmp48_ = gee_iterator_get (_tmp47_);
					source = (DataSource*) _tmp48_;
					_tmp49_ = source;
					_tmp50_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, TYPE_MONITORABLE, Monitorable));
					monitorable = _tmp50_;
					_tmp52_ = monitorables;
					if (_tmp52_ != NULL) {
						GeeSet* _tmp53_;
						Monitorable* _tmp54_;
						_tmp53_ = monitorables;
						_tmp54_ = monitorable;
						_tmp51_ = gee_collection_contains ((GeeCollection*) _tmp53_, _tmp54_);
					} else {
						_tmp51_ = FALSE;
					}
					if (_tmp51_) {
						_g_object_unref0 (monitorable);
						_g_object_unref0 (source);
						continue;
					}
					_tmp55_ = monitorable;
					_tmp56_ = monitor;
					library_monitor_enqueue_verify_monitorable (self, _tmp55_, _tmp56_);
					_g_object_unref0 (monitorable);
					_g_object_unref0 (source);
				}
				_g_object_unref0 (_source_it);
			}
			_g_object_unref0 (monitorables);
			_g_object_unref0 (monitor);
		}
	}
	if (self->priv->auto_import) {
		GeeHashSet* _tmp57_;
		_tmp57_ = self->priv->unknown_files;
		library_monitor_enqueue_import_many (self, (GeeCollection*) _tmp57_);
	}
	_g_object_unref0 (self->priv->discovered);
	self->priv->discovered = NULL;
	_g_object_unref0 (self->priv->unknown_files);
	self->priv->unknown_files = NULL;
	_tmp58_ = tombstone_global;
	_tmp59_ = self->priv->cancellable;
	tombstone_source_collection_launch_scan (_tmp58_, (DirectoryMonitor*) self, _tmp59_);
	DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->discovery_completed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor));
}

static void
library_monitor_enqueue_verify_monitorable (LibraryMonitor* self,
                                            Monitorable* monitorable,
                                            MediaMonitor* monitor)
{
	gboolean offered = FALSE;
	GeeQueue* _tmp0_;
	LibraryMonitorVerifyJob* _tmp1_;
	LibraryMonitorVerifyJob* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitorable != NULL);
	g_return_if_fail (monitor != NULL);
	_tmp0_ = self->priv->verify_queue;
	_tmp1_ = library_monitor_verify_job_new (monitorable, monitor);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_queue_offer (_tmp0_, _tmp2_);
	_library_monitor_verify_job_unref0 (_tmp2_);
	offered = _tmp3_;
	_vala_assert (offered, "offered");
	library_monitor_execute_next_verify_job (self);
}

static void
library_monitor_execute_next_verify_job (LibraryMonitor* self)
{
	gboolean _tmp0_ = FALSE;
	LibraryMonitorVerifyJob* job = NULL;
	GeeQueue* _tmp4_;
	gpointer _tmp5_;
	LibraryMonitorVerifyJob* _tmp6_;
	gint _tmp7_;
	LibraryMonitorVerifyJob* _tmp8_;
	Monitorable* _tmp9_;
	LibraryMonitorVerifyJob* _tmp10_;
	MediaMonitor* _tmp11_;
	g_return_if_fail (self != NULL);
	if (self->priv->outstanding_verify_jobs >= LIBRARY_MONITOR_MAX_VERIFY_EXISTING_MEDIA_JOBS) {
		_tmp0_ = TRUE;
	} else {
		GeeQueue* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->verify_queue;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->priv->verify_queue;
	_tmp5_ = gee_queue_poll (_tmp4_);
	job = (LibraryMonitorVerifyJob*) _tmp5_;
	_tmp6_ = job;
	_vala_assert (_tmp6_ != NULL, "job != null");
	_tmp7_ = self->priv->outstanding_verify_jobs;
	self->priv->outstanding_verify_jobs = _tmp7_ + 1;
	_tmp8_ = job;
	_tmp9_ = _tmp8_->monitorable;
	_tmp10_ = job;
	_tmp11_ = _tmp10_->monitor;
	library_monitor_verify_monitorable (self, _tmp9_, _tmp11_, NULL, NULL);
	_library_monitor_verify_job_unref0 (job);
}

static void
library_monitor_verify_monitorable_data_free (gpointer _data)
{
	LibraryMonitorVerifyMonitorableData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->monitorable);
	_g_object_unref0 (_data_->monitor);
	_g_object_unref0 (_data_->self);
	g_slice_free (LibraryMonitorVerifyMonitorableData, _data_);
}

static void
library_monitor_verify_monitorable (LibraryMonitor* self,
                                    Monitorable* monitorable,
                                    MediaMonitor* monitor,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	LibraryMonitorVerifyMonitorableData* _data_;
	LibraryMonitor* _tmp0_;
	Monitorable* _tmp1_;
	MediaMonitor* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitorable != NULL);
	g_return_if_fail (monitor != NULL);
	_data_ = g_slice_new0 (LibraryMonitorVerifyMonitorableData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, library_monitor_verify_monitorable_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (monitorable);
	_g_object_unref0 (_data_->monitorable);
	_data_->monitorable = _tmp1_;
	_tmp2_ = _g_object_ref0 (monitor);
	_g_object_unref0 (_data_->monitor);
	_data_->monitor = _tmp2_;
	library_monitor_verify_monitorable_co (_data_);
}

static void
library_monitor_verify_monitorable_finish (LibraryMonitor* self,
                                           GAsyncResult* _res_)
{
	LibraryMonitorVerifyMonitorableData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
_vala_array_add3 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
library_monitor_verify_monitorable_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	LibraryMonitorVerifyMonitorableData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	library_monitor_verify_monitorable_co (_data_);
}

static gboolean
_library_monitor_verify_monitorable_co_gsource_func (gpointer self)
{
	gboolean result;
	result = library_monitor_verify_monitorable_co (self);
	return result;
}

static gboolean
library_monitor_verify_monitorable_co (LibraryMonitorVerifyMonitorableData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_new0 (GFile*, 1 + 1);
	_data_->files = _data_->_tmp0_;
	_data_->files_length1 = 1;
	_data_->_files_size_ = _data_->files_length1;
	_data_->_tmp1_ = _data_->files;
	_data_->_tmp1__length1 = _data_->files_length1;
	_data_->_tmp2_ = media_monitor_get_master_file (_data_->monitor, _data_->monitorable);
	_g_object_unref0 (_data_->_tmp1_[0]);
	_data_->_tmp1_[0] = _data_->_tmp2_;
	_data_->_tmp3_ = 0;
	_data_->_tmp4_ = media_monitor_get_auxilliary_backing_files (_data_->monitor, _data_->monitorable, &_data_->_tmp3_);
	_data_->aux_files = _data_->_tmp4_;
	_data_->aux_files_length1 = _data_->_tmp3_;
	_data_->_aux_files_size_ = _data_->aux_files_length1;
	_data_->_tmp5_ = _data_->aux_files;
	_data_->_tmp5__length1 = _data_->aux_files_length1;
	if (_data_->_tmp5_ != NULL) {
		_data_->_tmp6_ = _data_->aux_files;
		_data_->_tmp6__length1 = _data_->aux_files_length1;
		{
			_data_->aux_file_collection_length1 = 0;
			_data_->_aux_file_collection_size_ = 0;
			_data_->aux_file_collection = _data_->_tmp6_;
			_data_->aux_file_collection_length1 = _data_->_tmp6__length1;
			for (_data_->aux_file_it = 0; _data_->aux_file_it < _data_->aux_file_collection_length1; _data_->aux_file_it = _data_->aux_file_it + 1) {
				_data_->_tmp7_ = _g_object_ref0 (_data_->aux_file_collection[_data_->aux_file_it]);
				_data_->aux_file = _data_->_tmp7_;
				{
					_data_->_tmp8_ = _data_->aux_file;
					_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
					_vala_array_add3 (&_data_->files, &_data_->files_length1, &_data_->_files_size_, _data_->_tmp9_);
					_g_object_unref0 (_data_->aux_file);
				}
			}
		}
	}
	{
		_data_->ctr = 0;
		{
			_data_->_tmp10_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp10_) {
					_data_->_tmp11_ = _data_->ctr;
					_data_->ctr = _data_->_tmp11_ + 1;
				}
				_data_->_tmp10_ = FALSE;
				_data_->_tmp12_ = _data_->files;
				_data_->_tmp12__length1 = _data_->files_length1;
				if (!(_data_->ctr < _data_->_tmp12__length1)) {
					break;
				}
				_data_->_tmp13_ = _data_->files;
				_data_->_tmp13__length1 = _data_->files_length1;
				_data_->_tmp14_ = _data_->_tmp13_[_data_->ctr];
				_data_->_tmp15_ = _g_object_ref0 (_data_->_tmp14_);
				_data_->file = _data_->_tmp15_;
				_data_->_tmp16_ = _data_->file;
				_data_->_tmp17_ = directory_monitor_get_file_info ((DirectoryMonitor*) _data_->self, _data_->_tmp16_);
				_data_->info = _data_->_tmp17_;
				_data_->_tmp18_ = _data_->info;
				if (_data_->_tmp18_ == NULL) {
					{
						_data_->_tmp20_ = _data_->file;
						_data_->_tmp21_ = _data_->self->priv->cancellable;
						_data_->_state_ = 1;
						g_file_query_info_async (_data_->_tmp20_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, DIRECTORY_MONITOR_FILE_INFO_FLAGS, DIRECTORY_MONITOR_DEFAULT_PRIORITY, _data_->_tmp21_, library_monitor_verify_monitorable_ready, _data_);
						return FALSE;
						_state_1:
						_data_->_tmp22_ = g_file_query_info_finish (_data_->_tmp20_, _data_->_res_, &_data_->_inner_error0_);
						_data_->_tmp19_ = _data_->_tmp22_;
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
						_data_->_tmp23_ = _data_->_tmp19_;
						_data_->_tmp19_ = NULL;
						_g_object_unref0 (_data_->info);
						_data_->info = _data_->_tmp23_;
						_g_object_unref0 (_data_->_tmp19_);
					}
					goto __finally0;
					__catch0_g_error:
					{
						g_clear_error (&_data_->_inner_error0_);
					}
					__finally0:
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						_g_object_unref0 (_data_->info);
						_g_object_unref0 (_data_->file);
						_data_->aux_files = (_vala_array_free (_data_->aux_files, _data_->aux_files_length1, (GDestroyNotify) g_object_unref), NULL);
						_data_->files = (_vala_array_free (_data_->files, _data_->files_length1, (GDestroyNotify) g_object_unref), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				if (_data_->ctr == 0) {
					_data_->_tmp25_ = _data_->info;
					if (_data_->_tmp25_ != NULL) {
						_data_->_tmp24_ = media_monitor_is_offline (_data_->monitor, _data_->monitorable);
					} else {
						_data_->_tmp24_ = FALSE;
					}
					if (_data_->_tmp24_) {
						media_monitor_update_online (_data_->monitor, _data_->monitorable);
					} else {
						_data_->_tmp27_ = _data_->info;
						if (_data_->_tmp27_ == NULL) {
							_data_->_tmp26_ = !media_monitor_is_offline (_data_->monitor, _data_->monitorable);
						} else {
							_data_->_tmp26_ = FALSE;
						}
						if (_data_->_tmp26_) {
							media_monitor_update_offline (_data_->monitor, _data_->monitorable);
						}
					}
				}
				_data_->_tmp28_ = _data_->file;
				_data_->_tmp29_ = _data_->info;
				media_monitor_update_backing_file_info (_data_->monitor, _data_->monitorable, _data_->_tmp28_, _data_->_tmp29_);
				_g_object_unref0 (_data_->info);
				_g_object_unref0 (_data_->file);
			}
		}
	}
	_data_->_tmp30_ = _data_->self->priv->completed_monitorable_verifies;
	_data_->self->priv->completed_monitorable_verifies = _data_->_tmp30_ + 1;
	g_signal_emit (_data_->self, library_monitor_signals[LIBRARY_MONITOR_AUTO_UPDATE_PROGRESS_SIGNAL], 0, _data_->self->priv->completed_monitorable_verifies, _data_->self->priv->total_monitorable_verifies);
	g_idle_add_full (DIRECTORY_MONITOR_DEFAULT_PRIORITY, _library_monitor_verify_monitorable_co_gsource_func, _data_, NULL);
	_data_->_state_ = 2;
	return FALSE;
	_state_2:
	;
	_vala_assert (_data_->self->priv->outstanding_verify_jobs > 0, "outstanding_verify_jobs > 0");
	_data_->_tmp31_ = _data_->self->priv->outstanding_verify_jobs;
	_data_->self->priv->outstanding_verify_jobs = _data_->_tmp31_ - 1;
	library_monitor_execute_next_verify_job (_data_->self);
	_data_->aux_files = (_vala_array_free (_data_->aux_files, _data_->aux_files_length1, (GDestroyNotify) g_object_unref), NULL);
	_data_->files = (_vala_array_free (_data_->files, _data_->files_length1, (GDestroyNotify) g_object_unref), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
library_monitor_on_config_changed (LibraryMonitor* self,
                                   const gchar* key)
{
	gboolean value = FALSE;
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "auto-import") != 0) {
		return;
	}
	_tmp0_ = self->priv->file_settings;
	value = g_settings_get_boolean (_tmp0_, "auto-import");
	if (self->priv->auto_import == value) {
		return;
	}
	self->priv->auto_import = value;
	if (self->priv->auto_import) {
		if (!commandline_options_no_runtime_monitoring) {
			library_monitor_import_unrepresented_files (self);
		}
	} else {
		library_monitor_cancel_batch_imports (self);
	}
}

static void
library_monitor_enqueue_import (LibraryMonitor* self,
                                GFile* file)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GeeHashSet* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp2_ = self->priv->pending_imports;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp2_, file)) {
		_tmp1_ = library_monitor_is_supported_filetype (self, file);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !library_monitor_is_blacklisted (file);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GeeHashSet* _tmp3_;
		_tmp3_ = self->priv->import_queue;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, file);
	}
}

static void
library_monitor_enqueue_import_many (LibraryMonitor* self,
                                     GeeCollection* files)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (files != NULL);
	{
		GeeIterator* _file_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) files);
		_file_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			GFile* file = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			GFile* _tmp4_;
			_tmp1_ = _file_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _file_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			file = (GFile*) _tmp3_;
			_tmp4_ = file;
			library_monitor_enqueue_import (self, _tmp4_);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_it);
	}
}

static void
library_monitor_remove_queued_import (LibraryMonitor* self,
                                      GFile* file)
{
	GeeHashSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->import_queue;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, file);
}

static gboolean
library_monitor_on_flush_import_queue (LibraryMonitor* self)
{
	GCancellable* _tmp0_;
	GeeHashSet* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	BatchImport* _tmp4_;
	GeeHashSet* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gint64 now = 0LL;
	gboolean _tmp10_ = FALSE;
	BatchImportRoll* _tmp11_;
	GeeArrayList* jobs = NULL;
	GeeArrayList* _tmp13_;
	GeeHashSet* _tmp26_;
	BatchImport* importer = NULL;
	GeeArrayList* _tmp27_;
	BatchImportRoll* _tmp28_;
	BatchImport* _tmp29_;
	BatchImport* _tmp30_;
	BatchImport* _tmp31_;
	GeeArrayList* _tmp32_;
	BatchImport* _tmp33_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->cancellable;
	if (g_cancellable_is_cancelled (_tmp0_)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->import_queue;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		result = TRUE;
		return result;
	}
	_tmp4_ = self->priv->current_batch_import;
	if (_tmp4_ != NULL) {
		result = TRUE;
		return result;
	}
	_tmp5_ = self->priv->import_queue;
	_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("Auto-importing %d files", _tmp7_);
	_tmp9_ = _tmp8_;
	directory_monitor_mdbg (_tmp9_);
	_g_free0 (_tmp9_);
	now = now_sec ();
	_tmp11_ = self->priv->current_import_roll;
	if (_tmp11_ == NULL) {
		_tmp10_ = TRUE;
	} else {
		_tmp10_ = (now - self->priv->last_import_roll_use) >= ((gint64) LIBRARY_MONITOR_IMPORT_ROLL_QUIET_SEC);
	}
	if (_tmp10_) {
		BatchImportRoll* _tmp12_;
		_tmp12_ = batch_import_roll_new ();
		_batch_import_roll_unref0 (self->priv->current_import_roll);
		self->priv->current_import_roll = _tmp12_;
	}
	self->priv->last_import_roll_use = now;
	_tmp13_ = gee_array_list_new (TYPE_BATCH_IMPORT_JOB, (GBoxedCopyFunc) batch_import_job_ref, (GDestroyNotify) batch_import_job_unref, NULL, NULL, NULL);
	jobs = _tmp13_;
	{
		GeeIterator* _file_it = NULL;
		GeeHashSet* _tmp14_;
		GeeIterator* _tmp15_;
		_tmp14_ = self->priv->import_queue;
		_tmp15_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp14_);
		_file_it = _tmp15_;
		while (TRUE) {
			GeeIterator* _tmp16_;
			GFile* file = NULL;
			GeeIterator* _tmp17_;
			gpointer _tmp18_;
			GFile* _tmp19_;
			GeeArrayList* _tmp20_;
			GFile* _tmp21_;
			FileImportJob* _tmp22_;
			FileImportJob* _tmp23_;
			GeeHashSet* _tmp24_;
			GFile* _tmp25_;
			_tmp16_ = _file_it;
			if (!gee_iterator_next (_tmp16_)) {
				break;
			}
			_tmp17_ = _file_it;
			_tmp18_ = gee_iterator_get (_tmp17_);
			file = (GFile*) _tmp18_;
			_tmp19_ = file;
			if (library_monitor_is_blacklisted (_tmp19_)) {
				_g_object_unref0 (file);
				continue;
			}
			_tmp20_ = jobs;
			_tmp21_ = file;
			_tmp22_ = file_import_job_new (_tmp21_, FALSE);
			_tmp23_ = _tmp22_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, (BatchImportJob*) _tmp23_);
			_batch_import_job_unref0 (_tmp23_);
			_tmp24_ = self->priv->pending_imports;
			_tmp25_ = file;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, _tmp25_);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_it);
	}
	_tmp26_ = self->priv->import_queue;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp26_);
	_tmp27_ = jobs;
	_tmp28_ = self->priv->current_import_roll;
	_tmp29_ = batch_import_new ((GeeIterable*) _tmp27_, "LibraryMonitor autoimport", NULL, NULL, NULL, NULL, NULL, _tmp28_, NULL);
	importer = _tmp29_;
	_tmp30_ = importer;
	batch_import_set_untrash_duplicates (_tmp30_, FALSE);
	_tmp31_ = importer;
	batch_import_set_mark_duplicates_online (_tmp31_, FALSE);
	_tmp32_ = self->priv->batch_import_queue;
	_tmp33_ = importer;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp32_, _tmp33_);
	library_monitor_schedule_next_batch_import (self);
	result = TRUE;
	_g_object_unref0 (importer);
	_g_object_unref0 (jobs);
	return result;
}

static void
_library_monitor_on_import_preparing_batch_import_preparing (BatchImport* _sender,
                                                             gpointer self)
{
	library_monitor_on_import_preparing ((LibraryMonitor*) self);
}

static void
_library_monitor_on_import_progress_batch_import_progress (BatchImport* _sender,
                                                           guint64 completed_bytes,
                                                           guint64 total_bytes,
                                                           gpointer self)
{
	library_monitor_on_import_progress ((LibraryMonitor*) self, completed_bytes, total_bytes);
}

static void
_library_monitor_on_import_complete_batch_import_import_complete (BatchImport* _sender,
                                                                  ImportManifest* manifest,
                                                                  BatchImportRoll* import_roll,
                                                                  gpointer self)
{
	library_monitor_on_import_complete ((LibraryMonitor*) self, _sender, manifest, import_roll);
}

static void
library_monitor_schedule_next_batch_import (LibraryMonitor* self)
{
	gboolean _tmp0_ = FALSE;
	BatchImport* _tmp1_;
	GeeArrayList* _tmp5_;
	gpointer _tmp6_;
	BatchImport* _tmp7_;
	BatchImport* _tmp8_;
	BatchImport* _tmp9_;
	BatchImport* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->current_batch_import;
	if (_tmp1_ != NULL) {
		_tmp0_ = TRUE;
	} else {
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->batch_import_queue;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp5_ = self->priv->batch_import_queue;
	_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, 0);
	_g_object_unref0 (self->priv->current_batch_import);
	self->priv->current_batch_import = (BatchImport*) _tmp6_;
	_tmp7_ = self->priv->current_batch_import;
	g_signal_connect_object (_tmp7_, "preparing", (GCallback) _library_monitor_on_import_preparing_batch_import_preparing, self, 0);
	_tmp8_ = self->priv->current_batch_import;
	g_signal_connect_object (_tmp8_, "progress", (GCallback) _library_monitor_on_import_progress_batch_import_progress, self, 0);
	_tmp9_ = self->priv->current_batch_import;
	g_signal_connect_object (_tmp9_, "import-complete", (GCallback) _library_monitor_on_import_complete_batch_import_import_complete, self, 0);
	_tmp10_ = self->priv->current_batch_import;
	batch_import_schedule (_tmp10_);
}

static void
library_monitor_discard_current_batch_import (LibraryMonitor* self)
{
	BatchImport* _tmp0_;
	gboolean removed = FALSE;
	GeeArrayList* _tmp1_;
	BatchImport* _tmp2_;
	BatchImport* _tmp3_;
	guint _tmp4_;
	BatchImport* _tmp5_;
	guint _tmp6_;
	BatchImport* _tmp7_;
	guint _tmp8_;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_batch_import;
	_vala_assert (_tmp0_ != NULL, "current_batch_import != null");
	_tmp1_ = self->priv->batch_import_queue;
	_tmp2_ = self->priv->current_batch_import;
	removed = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp1_, _tmp2_);
	_vala_assert (removed, "removed");
	_tmp3_ = self->priv->current_batch_import;
	g_signal_parse_name ("preparing", TYPE_BATCH_IMPORT, &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _library_monitor_on_import_preparing_batch_import_preparing, self);
	_tmp5_ = self->priv->current_batch_import;
	g_signal_parse_name ("progress", TYPE_BATCH_IMPORT, &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _library_monitor_on_import_progress_batch_import_progress, self);
	_tmp7_ = self->priv->current_batch_import;
	g_signal_parse_name ("import-complete", TYPE_BATCH_IMPORT, &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _library_monitor_on_import_complete_batch_import_import_complete, self);
	_g_object_unref0 (self->priv->current_batch_import);
	self->priv->current_batch_import = NULL;
	_tmp9_ = self->priv->batch_import_queue;
	_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ == 0) {
		GeeHashSet* _tmp12_;
		_tmp12_ = self->priv->pending_imports;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp12_);
	}
}

static void
library_monitor_cancel_batch_imports (LibraryMonitor* self)
{
	gint ctr = 0;
	BatchImport* _tmp13_;
	GeeHashSet* _tmp15_;
	g_return_if_fail (self != NULL);
	ctr = 0;
	while (TRUE) {
		GeeArrayList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		GeeArrayList* _tmp3_;
		gpointer _tmp4_;
		BatchImport* _tmp5_;
		BatchImport* _tmp6_;
		gboolean _tmp7_;
		GeeArrayList* _tmp9_;
		GeeArrayList* _tmp10_;
		gpointer _tmp11_;
		BatchImport* _tmp12_;
		_tmp0_ = self->priv->batch_import_queue;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		if (!(ctr < _tmp2_)) {
			break;
		}
		_tmp3_ = self->priv->batch_import_queue;
		_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, ctr);
		_tmp5_ = (BatchImport*) _tmp4_;
		_tmp6_ = self->priv->current_batch_import;
		_tmp7_ = _tmp5_ == _tmp6_;
		_g_object_unref0 (_tmp5_);
		if (_tmp7_) {
			gint _tmp8_;
			_tmp8_ = ctr;
			ctr = _tmp8_ + 1;
			continue;
		}
		_tmp9_ = self->priv->batch_import_queue;
		_tmp10_ = self->priv->batch_import_queue;
		_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, ctr);
		_tmp12_ = (BatchImport*) _tmp11_;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp9_, _tmp12_);
		_g_object_unref0 (_tmp12_);
	}
	_tmp13_ = self->priv->current_batch_import;
	if (_tmp13_ != NULL) {
		BatchImport* _tmp14_;
		_tmp14_ = self->priv->current_batch_import;
		batch_import_user_halt (_tmp14_);
	}
	_tmp15_ = self->priv->pending_imports;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp15_);
}

static void
library_monitor_on_import_preparing (LibraryMonitor* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, library_monitor_signals[LIBRARY_MONITOR_AUTO_IMPORT_PREPARING_SIGNAL], 0);
}

static void
library_monitor_on_import_progress (LibraryMonitor* self,
                                    guint64 completed_bytes,
                                    guint64 total_bytes)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, library_monitor_signals[LIBRARY_MONITOR_AUTO_IMPORT_PROGRESS_SIGNAL], 0, completed_bytes, total_bytes);
}

static void
library_monitor_on_import_complete (LibraryMonitor* self,
                                    BatchImport* batch_import,
                                    ImportManifest* manifest,
                                    BatchImportRoll* import_roll)
{
	BatchImport* _tmp0_;
	GeeList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GeeList* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	GeeHashSet* _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (batch_import != NULL);
	g_return_if_fail (manifest != NULL);
	g_return_if_fail (import_roll != NULL);
	_tmp0_ = self->priv->current_batch_import;
	_vala_assert (batch_import == _tmp0_, "batch_import == current_batch_import");
	_tmp1_ = manifest->all;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("auto-import batch completed %d", _tmp3_);
	_tmp5_ = _tmp4_;
	directory_monitor_mdbg (_tmp5_);
	_g_free0 (_tmp5_);
	g_signal_emit (self, library_monitor_signals[LIBRARY_MONITOR_AUTO_IMPORT_PROGRESS_SIGNAL], 0, (guint64) 0, (guint64) 0);
	{
		GeeList* _result_list = NULL;
		GeeList* _tmp6_;
		gint _result_size = 0;
		GeeList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _result_index = 0;
		_tmp6_ = manifest->all;
		_result_list = _tmp6_;
		_tmp7_ = _result_list;
		_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_result_size = _tmp9_;
		_result_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			BatchImportResult* _result_ = NULL;
			GeeList* _tmp12_;
			gpointer _tmp13_;
			BatchImportResult* _tmp14_;
			GFile* _tmp15_;
			_result_index = _result_index + 1;
			_tmp10_ = _result_index;
			_tmp11_ = _result_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _result_list;
			_tmp13_ = gee_list_get (_tmp12_, _result_index);
			_result_ = (BatchImportResult*) _tmp13_;
			_tmp14_ = _result_;
			_tmp15_ = _tmp14_->file;
			if (_tmp15_ != NULL) {
				GeeHashSet* _tmp16_;
				BatchImportResult* _tmp17_;
				GFile* _tmp18_;
				_tmp16_ = self->priv->pending_imports;
				_tmp17_ = _result_;
				_tmp18_ = _tmp17_->file;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp16_, _tmp18_);
			}
			_batch_import_result_unref0 (_result_);
		}
	}
	_tmp19_ = manifest->already_imported;
	_tmp20_ = gee_collection_get_size ((GeeCollection*) _tmp19_);
	_tmp21_ = _tmp20_;
	if (_tmp21_ > 0) {
		GeeArrayList* to_tombstone = NULL;
		GeeArrayList* _tmp22_;
		_tmp22_ = gee_array_list_new (TYPE_TOMBSTONED_FILE, (GBoxedCopyFunc) tombstoned_file_ref, (GDestroyNotify) tombstoned_file_unref, NULL, NULL, NULL);
		to_tombstone = _tmp22_;
		{
			GeeList* _result_list = NULL;
			GeeList* _tmp23_;
			gint _result_size = 0;
			GeeList* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gint _result_index = 0;
			_tmp23_ = manifest->already_imported;
			_result_list = _tmp23_;
			_tmp24_ = _result_list;
			_tmp25_ = gee_collection_get_size ((GeeCollection*) _tmp24_);
			_tmp26_ = _tmp25_;
			_result_size = _tmp26_;
			_result_index = -1;
			while (TRUE) {
				gint _tmp27_;
				gint _tmp28_;
				BatchImportResult* _result_ = NULL;
				GeeList* _tmp29_;
				gpointer _tmp30_;
				GFileInfo* info = NULL;
				BatchImportResult* _tmp31_;
				GFile* _tmp32_;
				GFileInfo* _tmp33_;
				GFileInfo* _tmp34_;
				GeeArrayList* _tmp39_;
				BatchImportResult* _tmp40_;
				GFile* _tmp41_;
				GFileInfo* _tmp42_;
				TombstonedFile* _tmp43_;
				TombstonedFile* _tmp44_;
				_result_index = _result_index + 1;
				_tmp27_ = _result_index;
				_tmp28_ = _result_size;
				if (!(_tmp27_ < _tmp28_)) {
					break;
				}
				_tmp29_ = _result_list;
				_tmp30_ = gee_list_get (_tmp29_, _result_index);
				_result_ = (BatchImportResult*) _tmp30_;
				_tmp31_ = _result_;
				_tmp32_ = _tmp31_->file;
				_tmp33_ = directory_monitor_get_file_info ((DirectoryMonitor*) self, _tmp32_);
				info = _tmp33_;
				_tmp34_ = info;
				if (_tmp34_ == NULL) {
					BatchImportResult* _tmp35_;
					GFile* _tmp36_;
					gchar* _tmp37_;
					gchar* _tmp38_;
					_tmp35_ = _result_;
					_tmp36_ = _tmp35_->file;
					_tmp37_ = g_file_get_path (_tmp36_);
					_tmp38_ = _tmp37_;
					g_warning ("LibraryMonitor.vala:711: Unable to get info for duplicate file %s", _tmp38_);
					_g_free0 (_tmp38_);
					_g_object_unref0 (info);
					_batch_import_result_unref0 (_result_);
					continue;
				}
				_tmp39_ = to_tombstone;
				_tmp40_ = _result_;
				_tmp41_ = _tmp40_->file;
				_tmp42_ = info;
				_tmp43_ = tombstoned_file_new (_tmp41_, g_file_info_get_size (_tmp42_), NULL);
				_tmp44_ = _tmp43_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, _tmp44_);
				_tombstoned_file_unref0 (_tmp44_);
				_g_object_unref0 (info);
				_batch_import_result_unref0 (_result_);
			}
		}
		{
			GeeArrayList* _tmp45_;
			_tmp45_ = to_tombstone;
			tombstone_entomb_many_files ((GeeCollection*) _tmp45_, TOMBSTONE_REASON_AUTO_DETECTED_DUPLICATE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					goto __catch0_database_error;
				}
				_g_object_unref0 (to_tombstone);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally0;
		__catch0_database_error:
		{
			GError* err = NULL;
			GError* _tmp46_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp46_ = err;
			app_window_database_error (_tmp46_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (to_tombstone);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_object_unref0 (to_tombstone);
	}
	_tmp47_ = self->priv->pending_imports;
	_tmp48_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = g_strdup_printf ("%d files remain pending for auto-import", _tmp49_);
	_tmp51_ = _tmp50_;
	directory_monitor_mdbg (_tmp51_);
	_g_free0 (_tmp51_);
	library_monitor_discard_current_batch_import (self);
	library_monitor_schedule_next_batch_import (self);
}

void
library_monitor_blacklist_file (GFile* file,
                                const gchar* reason)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (file != NULL);
	g_return_if_fail (reason != NULL);
	_tmp0_ = g_file_get_path (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("[%s] Blacklisting %s", reason, _tmp1_);
	_tmp3_ = _tmp2_;
	directory_monitor_mdbg (_tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	{
		GeeHashSet* _tmp4_;
		_tmp4_ = library_monitor_blacklist;
		g_rec_mutex_lock (&__lock_library_monitor_library_monitor_blacklist);
		{
			GeeHashSet* _tmp5_;
			_tmp5_ = library_monitor_blacklist;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, file);
		}
		__finally0:
		{
			GeeHashSet* _tmp6_;
			_tmp6_ = library_monitor_blacklist;
			g_rec_mutex_unlock (&__lock_library_monitor_library_monitor_blacklist);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
library_monitor_unblacklist_file (GFile* file)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (file != NULL);
	{
		GeeHashSet* _tmp0_;
		_tmp0_ = library_monitor_blacklist;
		g_rec_mutex_lock (&__lock_library_monitor_library_monitor_blacklist);
		{
			gboolean _tmp1_ = FALSE;
			GeeHashSet* _tmp2_;
			_tmp2_ = library_monitor_blacklist;
			if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp2_, file)) {
				HashTimedQueue* _tmp3_;
				_tmp3_ = library_monitor_to_unblacklist;
				_tmp1_ = !timed_queue_contains ((TimedQueue*) _tmp3_, file);
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				HashTimedQueue* _tmp4_;
				_tmp4_ = library_monitor_to_unblacklist;
				timed_queue_enqueue ((TimedQueue*) _tmp4_, file);
			}
		}
		__finally0:
		{
			GeeHashSet* _tmp5_;
			_tmp5_ = library_monitor_blacklist;
			g_rec_mutex_unlock (&__lock_library_monitor_library_monitor_blacklist);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
library_monitor_on_unblacklist_file (GFile* file)
{
	gboolean removed = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (file != NULL);
	{
		GeeHashSet* _tmp0_;
		_tmp0_ = library_monitor_blacklist;
		g_rec_mutex_lock (&__lock_library_monitor_library_monitor_blacklist);
		{
			GeeHashSet* _tmp1_;
			_tmp1_ = library_monitor_blacklist;
			removed = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp1_, file);
		}
		__finally0:
		{
			GeeHashSet* _tmp2_;
			_tmp2_ = library_monitor_blacklist;
			g_rec_mutex_unlock (&__lock_library_monitor_library_monitor_blacklist);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (removed) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = g_file_get_path (file);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("Blacklist for %s removed", _tmp4_);
		_tmp6_ = _tmp5_;
		directory_monitor_mdbg (_tmp6_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
	} else {
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = g_file_get_path (file);
		_tmp8_ = _tmp7_;
		g_warning ("LibraryMonitor.vala:770: File %s was not blacklisted but unblacklisted", _tmp8_);
		_g_free0 (_tmp8_);
	}
}

gboolean
library_monitor_is_blacklisted (GFile* file)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	{
		GeeHashSet* _tmp0_;
		gboolean _tmp4_ = FALSE;
		_tmp0_ = library_monitor_blacklist;
		g_rec_mutex_lock (&__lock_library_monitor_library_monitor_blacklist);
		{
			GeeHashSet* _tmp1_;
			_tmp1_ = library_monitor_blacklist;
			result = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp1_, file);
			{
				GeeHashSet* _tmp2_;
				_tmp2_ = library_monitor_blacklist;
				g_rec_mutex_unlock (&__lock_library_monitor_library_monitor_blacklist);
			}
			return result;
		}
		__finally0:
		{
			GeeHashSet* _tmp3_;
			_tmp3_ = library_monitor_blacklist;
			g_rec_mutex_unlock (&__lock_library_monitor_library_monitor_blacklist);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

static gboolean
library_monitor_is_supported_filetype (LibraryMonitor* self,
                                       GFile* file)
{
	MediaCollectionRegistry* _tmp0_;
	MediaCollectionRegistry* _tmp1_;
	MediaSourceCollection* _tmp2_;
	MediaSourceCollection* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = media_collection_registry_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = media_collection_registry_get_collection_for_file (_tmp1_, file);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ != NULL;
	_data_collection_unref0 (_tmp3_);
	_media_collection_registry_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}

static void
library_monitor_import_unrepresented_files (LibraryMonitor* self)
{
	GeeArrayList* to_import = NULL;
	GeeArrayList* _tmp31_;
	g_return_if_fail (self != NULL);
	if (!self->priv->auto_import) {
		return;
	}
	to_import = NULL;
	{
		GeeIterator* _file_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = directory_monitor_get_files ((DirectoryMonitor*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_file_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			GFile* file = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GFileInfo* info = NULL;
			GFile* _tmp7_;
			GFileInfo* _tmp8_;
			gboolean _tmp9_ = FALSE;
			GFileInfo* _tmp10_;
			GeeHashSet* _tmp12_;
			GFile* _tmp13_;
			TombstoneSourceCollection* _tmp14_;
			GFile* _tmp15_;
			gboolean represented = FALSE;
			GFile* _tmp26_;
			GeeArrayList* _tmp27_;
			GeeArrayList* _tmp29_;
			GFile* _tmp30_;
			_tmp4_ = _file_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _file_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			file = (GFile*) _tmp6_;
			_tmp7_ = file;
			_tmp8_ = directory_monitor_get_file_info ((DirectoryMonitor*) self, _tmp7_);
			info = _tmp8_;
			_tmp10_ = info;
			if (_tmp10_ == NULL) {
				_tmp9_ = TRUE;
			} else {
				GFileInfo* _tmp11_;
				_tmp11_ = info;
				_tmp9_ = g_file_info_get_file_type (_tmp11_) != G_FILE_TYPE_REGULAR;
			}
			if (_tmp9_) {
				_g_object_unref0 (info);
				_g_object_unref0 (file);
				continue;
			}
			_tmp12_ = self->priv->pending_imports;
			_tmp13_ = file;
			if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp12_, _tmp13_)) {
				_g_object_unref0 (info);
				_g_object_unref0 (file);
				continue;
			}
			_tmp14_ = tombstone_global;
			_tmp15_ = file;
			if (tombstone_source_collection_matches (_tmp14_, _tmp15_)) {
				_g_object_unref0 (info);
				_g_object_unref0 (file);
				continue;
			}
			represented = FALSE;
			{
				GeeList* _monitor_list = NULL;
				GeeList* _tmp16_;
				gint _monitor_size = 0;
				GeeList* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gint _monitor_index = 0;
				_tmp16_ = self->priv->monitors;
				_monitor_list = _tmp16_;
				_tmp17_ = _monitor_list;
				_tmp18_ = gee_collection_get_size ((GeeCollection*) _tmp17_);
				_tmp19_ = _tmp18_;
				_monitor_size = _tmp19_;
				_monitor_index = -1;
				while (TRUE) {
					gint _tmp20_;
					gint _tmp21_;
					MediaMonitor* monitor = NULL;
					GeeList* _tmp22_;
					gpointer _tmp23_;
					MediaMonitor* _tmp24_;
					GFile* _tmp25_;
					_monitor_index = _monitor_index + 1;
					_tmp20_ = _monitor_index;
					_tmp21_ = _monitor_size;
					if (!(_tmp20_ < _tmp21_)) {
						break;
					}
					_tmp22_ = _monitor_list;
					_tmp23_ = gee_list_get (_tmp22_, _monitor_index);
					monitor = (MediaMonitor*) _tmp23_;
					_tmp24_ = monitor;
					_tmp25_ = file;
					if (media_monitor_is_file_represented (_tmp24_, _tmp25_)) {
						represented = TRUE;
						_g_object_unref0 (monitor);
						break;
					}
					_g_object_unref0 (monitor);
				}
			}
			if (represented) {
				_g_object_unref0 (info);
				_g_object_unref0 (file);
				continue;
			}
			_tmp26_ = file;
			if (!library_monitor_is_supported_filetype (self, _tmp26_)) {
				_g_object_unref0 (info);
				_g_object_unref0 (file);
				continue;
			}
			_tmp27_ = to_import;
			if (_tmp27_ == NULL) {
				GeeArrayList* _tmp28_;
				_tmp28_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_equal_gee_equal_data_func, NULL, NULL);
				_g_object_unref0 (to_import);
				to_import = _tmp28_;
			}
			_tmp29_ = to_import;
			_tmp30_ = file;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, _tmp30_);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_it);
	}
	_tmp31_ = to_import;
	if (_tmp31_ != NULL) {
		GeeArrayList* _tmp32_;
		_tmp32_ = to_import;
		library_monitor_enqueue_import_many (self, (GeeCollection*) _tmp32_);
	}
	_g_object_unref0 (to_import);
}

static void
library_monitor_runtime_unknown_file_discovered (LibraryMonitor* self,
                                                 GFile* file)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	if (self->priv->auto_import) {
		_tmp1_ = library_monitor_is_supported_filetype (self, file);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		TombstoneSourceCollection* _tmp2_;
		_tmp2_ = tombstone_global;
		_tmp0_ = !tombstone_source_collection_matches (_tmp2_, file);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = g_file_get_path (file);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("Unknown file %s discovered, enqueuing for import", _tmp4_);
		_tmp6_ = _tmp5_;
		directory_monitor_mdbg (_tmp6_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		library_monitor_enqueue_import (self, file);
	}
}

static void
library_monitor_real_notify_file_created (DirectoryMonitor* base,
                                          GFile* file,
                                          GFileInfo* info)
{
	LibraryMonitor * self;
	gboolean known = FALSE;
	self = (LibraryMonitor*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (info != NULL);
	if (library_monitor_is_blacklisted (file)) {
		DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_created (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), file, info);
		return;
	}
	known = FALSE;
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp0_;
		gint _monitor_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _monitor_index = 0;
		_tmp0_ = self->priv->monitors;
		_monitor_list = _tmp0_;
		_tmp1_ = _monitor_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_monitor_size = _tmp3_;
		_monitor_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			MediaMonitor* _tmp8_;
			_monitor_index = _monitor_index + 1;
			_tmp4_ = _monitor_index;
			_tmp5_ = _monitor_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _monitor_list;
			_tmp7_ = gee_list_get (_tmp6_, _monitor_index);
			monitor = (MediaMonitor*) _tmp7_;
			_tmp8_ = monitor;
			if (media_monitor_notify_file_created (_tmp8_, file, info)) {
				known = TRUE;
				_g_object_unref0 (monitor);
				break;
			}
			_g_object_unref0 (monitor);
		}
	}
	if (!known) {
		GeeHashSet* all_candidates = NULL;
		gboolean _tmp55_ = FALSE;
		gboolean _tmp56_ = FALSE;
		all_candidates = NULL;
		{
			GeeList* _monitor_list = NULL;
			GeeList* _tmp9_;
			gint _monitor_size = 0;
			GeeList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gint _monitor_index = 0;
			_tmp9_ = self->priv->monitors;
			_monitor_list = _tmp9_;
			_tmp10_ = _monitor_list;
			_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
			_tmp12_ = _tmp11_;
			_monitor_size = _tmp12_;
			_monitor_index = -1;
			while (TRUE) {
				gint _tmp13_;
				gint _tmp14_;
				MediaMonitor* monitor = NULL;
				GeeList* _tmp15_;
				gpointer _tmp16_;
				MediaMonitorDiscoveredFile _result_ = 0;
				GeeCollection* candidates = NULL;
				MediaMonitor* _tmp17_;
				MediaMonitorDiscoveredFile _tmp18_ = 0;
				GeeCollection* _tmp19_;
				gboolean _tmp20_ = FALSE;
				_monitor_index = _monitor_index + 1;
				_tmp13_ = _monitor_index;
				_tmp14_ = _monitor_size;
				if (!(_tmp13_ < _tmp14_)) {
					break;
				}
				_tmp15_ = _monitor_list;
				_tmp16_ = gee_list_get (_tmp15_, _monitor_index);
				monitor = (MediaMonitor*) _tmp16_;
				_tmp17_ = monitor;
				_tmp19_ = media_monitor_candidates_for_unknown_file (_tmp17_, file, info, &_tmp18_);
				_result_ = _tmp18_;
				candidates = _tmp19_;
				if (_result_ == MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED) {
					_tmp20_ = TRUE;
				} else {
					_tmp20_ = _result_ == MEDIA_MONITOR_DISCOVERED_FILE_IGNORE;
				}
				if (_tmp20_) {
					MediaMonitor* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					GEnumValue* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					_tmp21_ = monitor;
					_tmp22_ = media_monitor_to_string (_tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = g_enum_get_value (g_type_class_ref (MEDIA_MONITOR_TYPE_DISCOVERED_FILE), _result_);
					_tmp25_ = g_file_get_path (file);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_strdup_printf ("%s %s created file %s", _tmp23_, (_tmp24_ != NULL) ? _tmp24_->value_name : NULL, _tmp26_);
					_tmp28_ = _tmp27_;
					directory_monitor_mdbg (_tmp28_);
					_g_free0 (_tmp28_);
					_g_free0 (_tmp26_);
					_g_free0 (_tmp23_);
					known = TRUE;
					_g_object_unref0 (candidates);
					_g_object_unref0 (monitor);
					break;
				} else {
					gboolean _tmp29_ = FALSE;
					GeeCollection* _tmp30_;
					_tmp30_ = candidates;
					if (_tmp30_ != NULL) {
						GeeCollection* _tmp31_;
						gint _tmp32_;
						gint _tmp33_;
						_tmp31_ = candidates;
						_tmp32_ = gee_collection_get_size (_tmp31_);
						_tmp33_ = _tmp32_;
						_tmp29_ = _tmp33_ > 0;
					} else {
						_tmp29_ = FALSE;
					}
					if (_tmp29_) {
						MediaMonitor* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
						GeeCollection* _tmp37_;
						gint _tmp38_;
						gint _tmp39_;
						gchar* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						gchar* _tmp43_;
						GeeHashSet* _tmp44_;
						_tmp34_ = monitor;
						_tmp35_ = media_monitor_to_string (_tmp34_);
						_tmp36_ = _tmp35_;
						_tmp37_ = candidates;
						_tmp38_ = gee_collection_get_size (_tmp37_);
						_tmp39_ = _tmp38_;
						_tmp40_ = g_file_get_path (file);
						_tmp41_ = _tmp40_;
						_tmp42_ = g_strdup_printf ("%s suggests %d candidates for created file %s", _tmp36_, _tmp39_, _tmp41_);
						_tmp43_ = _tmp42_;
						directory_monitor_mdbg (_tmp43_);
						_g_free0 (_tmp43_);
						_g_free0 (_tmp41_);
						_g_free0 (_tmp36_);
						_tmp44_ = all_candidates;
						if (_tmp44_ == NULL) {
							GeeHashSet* _tmp45_;
							_tmp45_ = gee_hash_set_new (TYPE_MONITORABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
							_g_object_unref0 (all_candidates);
							all_candidates = _tmp45_;
						}
						{
							GeeIterator* _candidate_it = NULL;
							GeeCollection* _tmp46_;
							GeeIterator* _tmp47_;
							_tmp46_ = candidates;
							_tmp47_ = gee_iterable_iterator ((GeeIterable*) _tmp46_);
							_candidate_it = _tmp47_;
							while (TRUE) {
								GeeIterator* _tmp48_;
								Monitorable* candidate = NULL;
								GeeIterator* _tmp49_;
								gpointer _tmp50_;
								MediaMonitor* _tmp51_;
								Monitorable* _tmp52_;
								_tmp48_ = _candidate_it;
								if (!gee_iterator_next (_tmp48_)) {
									break;
								}
								_tmp49_ = _candidate_it;
								_tmp50_ = gee_iterator_get (_tmp49_);
								candidate = (Monitorable*) _tmp50_;
								_tmp51_ = monitor;
								_tmp52_ = candidate;
								if (media_monitor_is_offline (_tmp51_, _tmp52_)) {
									GeeHashSet* _tmp53_;
									Monitorable* _tmp54_;
									_tmp53_ = all_candidates;
									_tmp54_ = candidate;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp53_, _tmp54_);
								}
								_g_object_unref0 (candidate);
							}
							_g_object_unref0 (_candidate_it);
						}
					}
				}
				_g_object_unref0 (candidates);
				_g_object_unref0 (monitor);
			}
		}
		if (!known) {
			GeeHashSet* _tmp57_;
			_tmp57_ = all_candidates;
			_tmp56_ = _tmp57_ != NULL;
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			GeeHashSet* _tmp58_;
			gint _tmp59_;
			gint _tmp60_;
			_tmp58_ = all_candidates;
			_tmp59_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp58_);
			_tmp60_ = _tmp59_;
			_tmp55_ = _tmp60_ > 0;
		} else {
			_tmp55_ = FALSE;
		}
		if (_tmp55_) {
			GeeHashSet* _tmp61_;
			gint _tmp62_;
			gint _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			Workers* _tmp68_;
			GeeHashSet* _tmp69_;
			LibraryMonitorRuntimeFindMoveJob* _tmp70_;
			LibraryMonitorRuntimeFindMoveJob* _tmp71_;
			_tmp61_ = all_candidates;
			_tmp62_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp61_);
			_tmp63_ = _tmp62_;
			_tmp64_ = g_file_get_path (file);
			_tmp65_ = _tmp64_;
			_tmp66_ = g_strdup_printf ("%d candidates for created file %s being checksummed", _tmp63_, _tmp65_);
			_tmp67_ = _tmp66_;
			directory_monitor_mdbg (_tmp67_);
			_g_free0 (_tmp67_);
			_g_free0 (_tmp65_);
			_tmp68_ = self->priv->workers;
			_tmp69_ = all_candidates;
			_tmp70_ = library_monitor_runtime_find_move_job_new (self, file, (GeeCollection*) _tmp69_);
			_tmp71_ = _tmp70_;
			workers_enqueue (_tmp68_, (BackgroundJob*) _tmp71_);
			_background_job_unref0 (_tmp71_);
			known = TRUE;
		}
		_g_object_unref0 (all_candidates);
	}
	if (!known) {
		library_monitor_runtime_unknown_file_discovered (self, file);
	}
	DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_created (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), file, info);
}

static void
library_monitor_on_runtime_find_move_completed (LibraryMonitor* self,
                                                BackgroundJob* j)
{
	LibraryMonitorRuntimeFindMoveJob* job = NULL;
	LibraryMonitorRuntimeFindMoveJob* _tmp0_;
	LibraryMonitorRuntimeFindMoveJob* _tmp1_;
	GError* _tmp2_;
	LibraryMonitorRuntimeFindMoveJob* _tmp10_;
	Monitorable* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (j != NULL);
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, LIBRARY_MONITOR_TYPE_RUNTIME_FIND_MOVE_JOB, LibraryMonitorRuntimeFindMoveJob));
	job = _tmp0_;
	_tmp1_ = job;
	_tmp2_ = _tmp1_->err;
	if (_tmp2_ != NULL) {
		LibraryMonitorRuntimeFindMoveJob* _tmp3_;
		GFile* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		LibraryMonitorRuntimeFindMoveJob* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		_tmp3_ = job;
		_tmp4_ = _tmp3_->file;
		_tmp5_ = g_file_get_path (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = job;
		_tmp8_ = _tmp7_->err;
		_tmp9_ = _tmp8_->message;
		g_critical ("LibraryMonitor.vala:900: Error attempting to find a match at runtime f" \
"or %s: %s", _tmp6_, _tmp9_);
		_g_free0 (_tmp6_);
	}
	_tmp10_ = job;
	_tmp11_ = _tmp10_->match;
	if (_tmp11_ != NULL) {
		MediaMonitor* monitor = NULL;
		LibraryMonitorRuntimeFindMoveJob* _tmp12_;
		Monitorable* _tmp13_;
		MediaMonitor* _tmp14_;
		MediaMonitor* _tmp15_;
		LibraryMonitorRuntimeFindMoveJob* _tmp16_;
		Monitorable* _tmp17_;
		LibraryMonitorRuntimeFindMoveJob* _tmp18_;
		GFile* _tmp19_;
		MediaMonitor* _tmp20_;
		LibraryMonitorRuntimeFindMoveJob* _tmp21_;
		Monitorable* _tmp22_;
		_tmp12_ = job;
		_tmp13_ = _tmp12_->match;
		_tmp14_ = library_monitor_get_monitor_for_monitorable (self, _tmp13_);
		monitor = _tmp14_;
		_tmp15_ = monitor;
		_tmp16_ = job;
		_tmp17_ = _tmp16_->match;
		_tmp18_ = job;
		_tmp19_ = _tmp18_->file;
		media_monitor_update_master_file (_tmp15_, _tmp17_, _tmp19_);
		_tmp20_ = monitor;
		_tmp21_ = job;
		_tmp22_ = _tmp21_->match;
		media_monitor_update_online (_tmp20_, _tmp22_);
		_g_object_unref0 (monitor);
	} else {
		LibraryMonitorRuntimeFindMoveJob* _tmp23_;
		GFile* _tmp24_;
		_tmp23_ = job;
		_tmp24_ = _tmp23_->file;
		library_monitor_runtime_unknown_file_discovered (self, _tmp24_);
	}
	_background_job_unref0 (job);
}

static void
library_monitor_real_notify_file_moved (DirectoryMonitor* base,
                                        GFile* old_file,
                                        GFile* new_file,
                                        GFileInfo* new_info)
{
	LibraryMonitor * self;
	gboolean _tmp0_ = FALSE;
	gboolean known = FALSE;
	self = (LibraryMonitor*) base;
	g_return_if_fail (old_file != NULL);
	g_return_if_fail (new_file != NULL);
	g_return_if_fail (new_info != NULL);
	if (library_monitor_is_blacklisted (old_file)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = library_monitor_is_blacklisted (new_file);
	}
	if (_tmp0_) {
		DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_moved (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), old_file, new_file, new_info);
		return;
	}
	known = FALSE;
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp1_;
		gint _monitor_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _monitor_index = 0;
		_tmp1_ = self->priv->monitors;
		_monitor_list = _tmp1_;
		_tmp2_ = _monitor_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_monitor_size = _tmp4_;
		_monitor_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			MediaMonitor* _tmp9_;
			_monitor_index = _monitor_index + 1;
			_tmp5_ = _monitor_index;
			_tmp6_ = _monitor_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _monitor_list;
			_tmp8_ = gee_list_get (_tmp7_, _monitor_index);
			monitor = (MediaMonitor*) _tmp8_;
			_tmp9_ = monitor;
			if (media_monitor_notify_file_moved (_tmp9_, old_file, new_file, new_info)) {
				known = TRUE;
				_g_object_unref0 (monitor);
				break;
			}
			_g_object_unref0 (monitor);
		}
	}
	if (!known) {
		library_monitor_runtime_unknown_file_discovered (self, new_file);
	}
	DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_moved (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), old_file, new_file, new_info);
}

static void
library_monitor_real_notify_file_altered (DirectoryMonitor* base,
                                          GFile* file)
{
	LibraryMonitor * self;
	gboolean known = FALSE;
	self = (LibraryMonitor*) base;
	g_return_if_fail (file != NULL);
	if (library_monitor_is_blacklisted (file)) {
		DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), file);
		return;
	}
	known = FALSE;
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp0_;
		gint _monitor_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _monitor_index = 0;
		_tmp0_ = self->priv->monitors;
		_monitor_list = _tmp0_;
		_tmp1_ = _monitor_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_monitor_size = _tmp3_;
		_monitor_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			MediaMonitor* _tmp8_;
			_monitor_index = _monitor_index + 1;
			_tmp4_ = _monitor_index;
			_tmp5_ = _monitor_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _monitor_list;
			_tmp7_ = gee_list_get (_tmp6_, _monitor_index);
			monitor = (MediaMonitor*) _tmp7_;
			_tmp8_ = monitor;
			if (media_monitor_notify_file_altered (_tmp8_, file)) {
				known = TRUE;
				_g_object_unref0 (monitor);
				break;
			}
			_g_object_unref0 (monitor);
		}
	}
	if (!known) {
		library_monitor_runtime_unknown_file_discovered (self, file);
	}
	DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), file);
}

static void
library_monitor_real_notify_file_attributes_altered (DirectoryMonitor* base,
                                                     GFile* file)
{
	LibraryMonitor * self;
	gboolean known = FALSE;
	self = (LibraryMonitor*) base;
	g_return_if_fail (file != NULL);
	if (library_monitor_is_blacklisted (file)) {
		DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_attributes_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), file);
		return;
	}
	known = FALSE;
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp0_;
		gint _monitor_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _monitor_index = 0;
		_tmp0_ = self->priv->monitors;
		_monitor_list = _tmp0_;
		_tmp1_ = _monitor_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_monitor_size = _tmp3_;
		_monitor_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			MediaMonitor* _tmp8_;
			_monitor_index = _monitor_index + 1;
			_tmp4_ = _monitor_index;
			_tmp5_ = _monitor_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _monitor_list;
			_tmp7_ = gee_list_get (_tmp6_, _monitor_index);
			monitor = (MediaMonitor*) _tmp7_;
			_tmp8_ = monitor;
			if (media_monitor_notify_file_attributes_altered (_tmp8_, file)) {
				known = TRUE;
				_g_object_unref0 (monitor);
				break;
			}
			_g_object_unref0 (monitor);
		}
	}
	if (!known) {
		library_monitor_runtime_unknown_file_discovered (self, file);
	}
	DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_attributes_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), file);
}

static void
library_monitor_real_notify_file_alteration_completed (DirectoryMonitor* base,
                                                       GFile* file,
                                                       GFileInfo* info)
{
	LibraryMonitor * self;
	gboolean known = FALSE;
	self = (LibraryMonitor*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (info != NULL);
	if (library_monitor_is_blacklisted (file)) {
		DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_alteration_completed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), file, info);
		return;
	}
	known = FALSE;
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp0_;
		gint _monitor_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _monitor_index = 0;
		_tmp0_ = self->priv->monitors;
		_monitor_list = _tmp0_;
		_tmp1_ = _monitor_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_monitor_size = _tmp3_;
		_monitor_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			MediaMonitor* _tmp8_;
			_monitor_index = _monitor_index + 1;
			_tmp4_ = _monitor_index;
			_tmp5_ = _monitor_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _monitor_list;
			_tmp7_ = gee_list_get (_tmp6_, _monitor_index);
			monitor = (MediaMonitor*) _tmp7_;
			_tmp8_ = monitor;
			if (media_monitor_notify_file_alteration_completed (_tmp8_, file, info)) {
				known = TRUE;
				_g_object_unref0 (monitor);
				break;
			}
			_g_object_unref0 (monitor);
		}
	}
	if (!known) {
		library_monitor_runtime_unknown_file_discovered (self, file);
	}
	DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_alteration_completed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), file, info);
}

static void
library_monitor_real_notify_file_deleted (DirectoryMonitor* base,
                                          GFile* file)
{
	LibraryMonitor * self;
	gboolean known = FALSE;
	self = (LibraryMonitor*) base;
	g_return_if_fail (file != NULL);
	if (library_monitor_is_blacklisted (file)) {
		DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_deleted (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), file);
		return;
	}
	known = FALSE;
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp0_;
		gint _monitor_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _monitor_index = 0;
		_tmp0_ = self->priv->monitors;
		_monitor_list = _tmp0_;
		_tmp1_ = _monitor_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_monitor_size = _tmp3_;
		_monitor_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			MediaMonitor* _tmp8_;
			_monitor_index = _monitor_index + 1;
			_tmp4_ = _monitor_index;
			_tmp5_ = _monitor_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _monitor_list;
			_tmp7_ = gee_list_get (_tmp6_, _monitor_index);
			monitor = (MediaMonitor*) _tmp7_;
			_tmp8_ = monitor;
			if (media_monitor_notify_file_deleted (_tmp8_, file)) {
				known = TRUE;
				_g_object_unref0 (monitor);
				break;
			}
			_g_object_unref0 (monitor);
		}
	}
	if (!known) {
		Tombstone* tombstone = NULL;
		TombstoneSourceCollection* _tmp9_;
		Tombstone* _tmp10_;
		Tombstone* _tmp11_;
		_tmp9_ = tombstone_global;
		_tmp10_ = tombstone_source_collection_locate (_tmp9_, file);
		tombstone = _tmp10_;
		_tmp11_ = tombstone;
		if (_tmp11_ != NULL) {
			gchar* _tmp12_;
			gchar* _tmp13_;
			TombstoneSourceCollection* _tmp14_;
			Tombstone* _tmp15_;
			_tmp12_ = g_file_get_path (file);
			_tmp13_ = _tmp12_;
			g_debug ("LibraryMonitor.vala:1022: Resurrecting tombstoned file %s", _tmp13_);
			_g_free0 (_tmp13_);
			_tmp14_ = tombstone_global;
			_tmp15_ = tombstone;
			tombstone_source_collection_resurrect (_tmp14_, _tmp15_);
		}
		library_monitor_remove_queued_import (self, file);
		_g_object_unref0 (tombstone);
	}
	DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_deleted (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), file);
}

static void
g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__UINT64_UINT64 (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT64_UINT64) (gpointer data1, guint64 arg_1, guint64 arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT64_UINT64 callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT64_UINT64) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint64 (param_values + 1), g_value_get_uint64 (param_values + 2), data2);
}

static void
_library_monitor_on_find_move_completed_completion_callback (BackgroundJob* job,
                                                             gpointer self)
{
	library_monitor_on_find_move_completed ((LibraryMonitor*) self, job);
}

static void
_library_monitor_on_find_move_cancelled_cancellation_callback (BackgroundJob* job,
                                                               gpointer self)
{
	library_monitor_on_find_move_cancelled ((LibraryMonitor*) self, job);
}

static LibraryMonitorFindMoveJob*
library_monitor_find_move_job_construct (GType object_type,
                                         LibraryMonitor* owner,
                                         GFile* file,
                                         GeeCollection* candidates)
{
	LibraryMonitorFindMoveJob* self = NULL;
	GCancellable* _tmp0_;
	GFile* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_val_if_fail (owner != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (candidates != NULL, NULL);
	_tmp0_ = owner->priv->cancellable;
	self = (LibraryMonitorFindMoveJob*) background_job_construct (object_type, (GObject*) owner, _library_monitor_on_find_move_completed_completion_callback, owner, _tmp0_, _library_monitor_on_find_move_cancelled_cancellation_callback, owner, NULL);
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (self->file);
	self->file = _tmp1_;
	_tmp2_ = _g_object_ref0 (candidates);
	_g_object_unref0 (self->candidates);
	self->candidates = _tmp2_;
	background_job_set_completion_priority ((BackgroundJob*) self, G_PRIORITY_LOW);
	return self;
}

static LibraryMonitorFindMoveJob*
library_monitor_find_move_job_new (LibraryMonitor* owner,
                                   GFile* file,
                                   GeeCollection* candidates)
{
	return library_monitor_find_move_job_construct (LIBRARY_MONITOR_TYPE_FIND_MOVE_JOB, owner, file, candidates);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
library_monitor_find_move_job_real_execute (BackgroundJob* base)
{
	LibraryMonitorFindMoveJob * self;
	GeeIterator* iter = NULL;
	GeeCollection* _tmp0_;
	GeeIterator* _tmp1_;
	GeeCollection* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gchar* md5 = NULL;
	GError* _inner_error0_ = NULL;
	self = (LibraryMonitorFindMoveJob*) base;
	_tmp0_ = self->candidates;
	_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		gpointer _tmp4_;
		Monitorable* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		gboolean _tmp8_;
		_tmp2_ = iter;
		if (!gee_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = iter;
		_tmp4_ = gee_iterator_get (_tmp3_);
		_tmp5_ = (Monitorable*) _tmp4_;
		_tmp6_ = media_source_get_master_file ((MediaSource*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_file_query_exists (_tmp7_, NULL);
		_g_object_unref0 (_tmp7_);
		_g_object_unref0 (_tmp5_);
		if (_tmp8_) {
			GeeIterator* _tmp9_;
			_tmp9_ = iter;
			gee_iterator_remove (_tmp9_);
		}
	}
	_tmp10_ = self->candidates;
	_tmp11_ = gee_collection_get_size (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == 0) {
		_g_object_unref0 (iter);
		return;
	}
	md5 = NULL;
	{
		gchar* _tmp13_ = NULL;
		GFile* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp14_ = self->file;
		_tmp15_ = md5_file (_tmp14_, &_inner_error0_);
		_tmp13_ = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp16_ = _tmp13_;
		_tmp13_ = NULL;
		_g_free0 (md5);
		md5 = _tmp16_;
		_g_free0 (_tmp13_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp17_;
		GError* _tmp18_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = err;
		_tmp18_ = _g_error_copy0 (_tmp17_);
		_g_error_free0 (self->err);
		self->err = _tmp18_;
		_g_error_free0 (err);
		_g_free0 (md5);
		_g_object_unref0 (iter);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (md5);
		_g_object_unref0 (iter);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		GeeIterator* _candidate_it = NULL;
		GeeCollection* _tmp19_;
		GeeIterator* _tmp20_;
		_tmp19_ = self->candidates;
		_tmp20_ = gee_iterable_iterator ((GeeIterable*) _tmp19_);
		_candidate_it = _tmp20_;
		while (TRUE) {
			GeeIterator* _tmp21_;
			Monitorable* candidate = NULL;
			GeeIterator* _tmp22_;
			gpointer _tmp23_;
			Monitorable* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			const gchar* _tmp27_;
			gboolean _tmp28_;
			Monitorable* _tmp29_;
			Monitorable* _tmp43_;
			Monitorable* _tmp44_;
			_tmp21_ = _candidate_it;
			if (!gee_iterator_next (_tmp21_)) {
				break;
			}
			_tmp22_ = _candidate_it;
			_tmp23_ = gee_iterator_get (_tmp22_);
			candidate = (Monitorable*) _tmp23_;
			_tmp24_ = candidate;
			_tmp25_ = media_source_get_master_md5 ((MediaSource*) _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = md5;
			_tmp28_ = g_strcmp0 (_tmp26_, _tmp27_) != 0;
			_g_free0 (_tmp26_);
			if (_tmp28_) {
				_g_object_unref0 (candidate);
				continue;
			}
			_tmp29_ = self->match;
			if (_tmp29_ != NULL) {
				GFile* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				Monitorable* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				Monitorable* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				GeeArrayList* _tmp39_;
				GeeArrayList* _tmp41_;
				Monitorable* _tmp42_;
				_tmp30_ = self->file;
				_tmp31_ = g_file_get_path (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = self->match;
				_tmp34_ = data_object_to_string ((DataObject*) _tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = candidate;
				_tmp37_ = data_object_to_string ((DataObject*) _tmp36_);
				_tmp38_ = _tmp37_;
				g_warning ("LibraryMonitor.vala:158: Found more than one media match for %s: %s an" \
"d %s", _tmp32_, _tmp35_, _tmp38_);
				_g_free0 (_tmp38_);
				_g_free0 (_tmp35_);
				_g_free0 (_tmp32_);
				_tmp39_ = self->losers;
				if (_tmp39_ == NULL) {
					GeeArrayList* _tmp40_;
					_tmp40_ = gee_array_list_new (TYPE_MONITORABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (self->losers);
					self->losers = _tmp40_;
				}
				_tmp41_ = self->losers;
				_tmp42_ = candidate;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp41_, _tmp42_);
				_g_object_unref0 (candidate);
				continue;
			}
			_tmp43_ = candidate;
			_tmp44_ = _g_object_ref0 (_tmp43_);
			_g_object_unref0 (self->match);
			self->match = _tmp44_;
			_g_object_unref0 (candidate);
		}
		_g_object_unref0 (_candidate_it);
	}
	_g_free0 (md5);
	_g_object_unref0 (iter);
}

static void
library_monitor_find_move_job_class_init (LibraryMonitorFindMoveJobClass * klass,
                                          gpointer klass_data)
{
	library_monitor_find_move_job_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobClass *) klass)->finalize = library_monitor_find_move_job_finalize;
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob*)) library_monitor_find_move_job_real_execute;
}

static void
library_monitor_find_move_job_instance_init (LibraryMonitorFindMoveJob * self,
                                             gpointer klass)
{
	self->match = NULL;
	self->losers = NULL;
	self->err = NULL;
}

static void
library_monitor_find_move_job_finalize (BackgroundJob * obj)
{
	LibraryMonitorFindMoveJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LIBRARY_MONITOR_TYPE_FIND_MOVE_JOB, LibraryMonitorFindMoveJob);
	_g_object_unref0 (self->file);
	_g_object_unref0 (self->candidates);
	_g_object_unref0 (self->match);
	_g_object_unref0 (self->losers);
	_g_error_free0 (self->err);
	BACKGROUND_JOB_CLASS (library_monitor_find_move_job_parent_class)->finalize (obj);
}

static GType
library_monitor_find_move_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LibraryMonitorFindMoveJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) library_monitor_find_move_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibraryMonitorFindMoveJob), 0, (GInstanceInitFunc) library_monitor_find_move_job_instance_init, NULL };
	GType library_monitor_find_move_job_type_id;
	library_monitor_find_move_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "LibraryMonitorFindMoveJob", &g_define_type_info, 0);
	return library_monitor_find_move_job_type_id;
}

static GType
library_monitor_find_move_job_get_type (void)
{
	static volatile gsize library_monitor_find_move_job_type_id__once = 0;
	if (g_once_init_enter (&library_monitor_find_move_job_type_id__once)) {
		GType library_monitor_find_move_job_type_id;
		library_monitor_find_move_job_type_id = library_monitor_find_move_job_get_type_once ();
		g_once_init_leave (&library_monitor_find_move_job_type_id__once, library_monitor_find_move_job_type_id);
	}
	return library_monitor_find_move_job_type_id__once;
}

static void
_library_monitor_on_runtime_find_move_completed_completion_callback (BackgroundJob* job,
                                                                     gpointer self)
{
	library_monitor_on_runtime_find_move_completed ((LibraryMonitor*) self, job);
}

static LibraryMonitorRuntimeFindMoveJob*
library_monitor_runtime_find_move_job_construct (GType object_type,
                                                 LibraryMonitor* owner,
                                                 GFile* file,
                                                 GeeCollection* candidates)
{
	LibraryMonitorRuntimeFindMoveJob* self = NULL;
	GCancellable* _tmp0_;
	GFile* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_val_if_fail (owner != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (candidates != NULL, NULL);
	_tmp0_ = owner->priv->cancellable;
	self = (LibraryMonitorRuntimeFindMoveJob*) background_job_construct (object_type, (GObject*) owner, _library_monitor_on_runtime_find_move_completed_completion_callback, owner, _tmp0_, NULL, NULL, NULL);
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (self->file);
	self->file = _tmp1_;
	_tmp2_ = _g_object_ref0 (candidates);
	_g_object_unref0 (self->candidates);
	self->candidates = _tmp2_;
	background_job_set_completion_priority ((BackgroundJob*) self, G_PRIORITY_LOW);
	return self;
}

static LibraryMonitorRuntimeFindMoveJob*
library_monitor_runtime_find_move_job_new (LibraryMonitor* owner,
                                           GFile* file,
                                           GeeCollection* candidates)
{
	return library_monitor_runtime_find_move_job_construct (LIBRARY_MONITOR_TYPE_RUNTIME_FIND_MOVE_JOB, owner, file, candidates);
}

static void
library_monitor_runtime_find_move_job_real_execute (BackgroundJob* base)
{
	LibraryMonitorRuntimeFindMoveJob * self;
	gchar* md5 = NULL;
	GError* _inner_error0_ = NULL;
	self = (LibraryMonitorRuntimeFindMoveJob*) base;
	md5 = NULL;
	{
		gchar* _tmp0_ = NULL;
		GFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->file;
		_tmp2_ = md5_file (_tmp1_, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (md5);
		md5 = _tmp3_;
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _g_error_copy0 (_tmp4_);
		_g_error_free0 (self->err);
		self->err = _tmp5_;
		_g_error_free0 (err);
		_g_free0 (md5);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (md5);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		GeeIterator* _candidate_it = NULL;
		GeeCollection* _tmp6_;
		GeeIterator* _tmp7_;
		_tmp6_ = self->candidates;
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
		_candidate_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			Monitorable* candidate = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			Monitorable* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			gboolean _tmp15_;
			_tmp8_ = _candidate_it;
			if (!gee_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _candidate_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			candidate = (Monitorable*) _tmp10_;
			_tmp11_ = candidate;
			_tmp12_ = media_source_get_master_md5 ((MediaSource*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = md5;
			_tmp15_ = g_strcmp0 (_tmp13_, _tmp14_) == 0;
			_g_free0 (_tmp13_);
			if (_tmp15_) {
				Monitorable* _tmp16_;
				Monitorable* _tmp17_;
				_tmp16_ = candidate;
				_tmp17_ = _g_object_ref0 (_tmp16_);
				_g_object_unref0 (self->match);
				self->match = _tmp17_;
				_g_object_unref0 (candidate);
				break;
			}
			_g_object_unref0 (candidate);
		}
		_g_object_unref0 (_candidate_it);
	}
	_g_free0 (md5);
}

static void
library_monitor_runtime_find_move_job_class_init (LibraryMonitorRuntimeFindMoveJobClass * klass,
                                                  gpointer klass_data)
{
	library_monitor_runtime_find_move_job_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobClass *) klass)->finalize = library_monitor_runtime_find_move_job_finalize;
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob*)) library_monitor_runtime_find_move_job_real_execute;
}

static void
library_monitor_runtime_find_move_job_instance_init (LibraryMonitorRuntimeFindMoveJob * self,
                                                     gpointer klass)
{
	self->match = NULL;
	self->err = NULL;
}

static void
library_monitor_runtime_find_move_job_finalize (BackgroundJob * obj)
{
	LibraryMonitorRuntimeFindMoveJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LIBRARY_MONITOR_TYPE_RUNTIME_FIND_MOVE_JOB, LibraryMonitorRuntimeFindMoveJob);
	_g_object_unref0 (self->file);
	_g_object_unref0 (self->candidates);
	_g_object_unref0 (self->match);
	_g_error_free0 (self->err);
	BACKGROUND_JOB_CLASS (library_monitor_runtime_find_move_job_parent_class)->finalize (obj);
}

static GType
library_monitor_runtime_find_move_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LibraryMonitorRuntimeFindMoveJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) library_monitor_runtime_find_move_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibraryMonitorRuntimeFindMoveJob), 0, (GInstanceInitFunc) library_monitor_runtime_find_move_job_instance_init, NULL };
	GType library_monitor_runtime_find_move_job_type_id;
	library_monitor_runtime_find_move_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "LibraryMonitorRuntimeFindMoveJob", &g_define_type_info, 0);
	return library_monitor_runtime_find_move_job_type_id;
}

static GType
library_monitor_runtime_find_move_job_get_type (void)
{
	static volatile gsize library_monitor_runtime_find_move_job_type_id__once = 0;
	if (g_once_init_enter (&library_monitor_runtime_find_move_job_type_id__once)) {
		GType library_monitor_runtime_find_move_job_type_id;
		library_monitor_runtime_find_move_job_type_id = library_monitor_runtime_find_move_job_get_type_once ();
		g_once_init_leave (&library_monitor_runtime_find_move_job_type_id__once, library_monitor_runtime_find_move_job_type_id);
	}
	return library_monitor_runtime_find_move_job_type_id__once;
}

static LibraryMonitorVerifyJob*
library_monitor_verify_job_construct (GType object_type,
                                      Monitorable* monitorable,
                                      MediaMonitor* monitor)
{
	LibraryMonitorVerifyJob* self = NULL;
	Monitorable* _tmp0_;
	MediaMonitor* _tmp1_;
	g_return_val_if_fail (monitorable != NULL, NULL);
	g_return_val_if_fail (monitor != NULL, NULL);
	self = (LibraryMonitorVerifyJob*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (monitorable);
	_g_object_unref0 (self->monitorable);
	self->monitorable = _tmp0_;
	_tmp1_ = _g_object_ref0 (monitor);
	_g_object_unref0 (self->monitor);
	self->monitor = _tmp1_;
	return self;
}

static LibraryMonitorVerifyJob*
library_monitor_verify_job_new (Monitorable* monitorable,
                                MediaMonitor* monitor)
{
	return library_monitor_verify_job_construct (LIBRARY_MONITOR_TYPE_VERIFY_JOB, monitorable, monitor);
}

static void
library_monitor_value_verify_job_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
library_monitor_value_verify_job_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		library_monitor_verify_job_unref (value->data[0].v_pointer);
	}
}

static void
library_monitor_value_verify_job_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = library_monitor_verify_job_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
library_monitor_value_verify_job_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
library_monitor_value_verify_job_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		LibraryMonitorVerifyJob * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = library_monitor_verify_job_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
library_monitor_value_verify_job_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	LibraryMonitorVerifyJob ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = library_monitor_verify_job_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
library_monitor_param_spec_verify_job (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	LibraryMonitorParamSpecVerifyJob* spec;
	g_return_val_if_fail (g_type_is_a (object_type, LIBRARY_MONITOR_TYPE_VERIFY_JOB), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
library_monitor_value_get_verify_job (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, LIBRARY_MONITOR_TYPE_VERIFY_JOB), NULL);
	return value->data[0].v_pointer;
}

static void
library_monitor_value_set_verify_job (GValue* value,
                                      gpointer v_object)
{
	LibraryMonitorVerifyJob * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, LIBRARY_MONITOR_TYPE_VERIFY_JOB));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, LIBRARY_MONITOR_TYPE_VERIFY_JOB));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		library_monitor_verify_job_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		library_monitor_verify_job_unref (old);
	}
}

static void
library_monitor_value_take_verify_job (GValue* value,
                                       gpointer v_object)
{
	LibraryMonitorVerifyJob * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, LIBRARY_MONITOR_TYPE_VERIFY_JOB));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, LIBRARY_MONITOR_TYPE_VERIFY_JOB));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		library_monitor_verify_job_unref (old);
	}
}

static void
library_monitor_verify_job_class_init (LibraryMonitorVerifyJobClass * klass,
                                       gpointer klass_data)
{
	library_monitor_verify_job_parent_class = g_type_class_peek_parent (klass);
	((LibraryMonitorVerifyJobClass *) klass)->finalize = library_monitor_verify_job_finalize;
}

static void
library_monitor_verify_job_instance_init (LibraryMonitorVerifyJob * self,
                                          gpointer klass)
{
	self->ref_count = 1;
}

static void
library_monitor_verify_job_finalize (LibraryMonitorVerifyJob * obj)
{
	LibraryMonitorVerifyJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LIBRARY_MONITOR_TYPE_VERIFY_JOB, LibraryMonitorVerifyJob);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->monitorable);
	_g_object_unref0 (self->monitor);
}

static GType
library_monitor_verify_job_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { library_monitor_value_verify_job_init, library_monitor_value_verify_job_free_value, library_monitor_value_verify_job_copy_value, library_monitor_value_verify_job_peek_pointer, "p", library_monitor_value_verify_job_collect_value, "p", library_monitor_value_verify_job_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (LibraryMonitorVerifyJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) library_monitor_verify_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibraryMonitorVerifyJob), 0, (GInstanceInitFunc) library_monitor_verify_job_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType library_monitor_verify_job_type_id;
	library_monitor_verify_job_type_id = g_type_register_fundamental (g_type_fundamental_next (), "LibraryMonitorVerifyJob", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return library_monitor_verify_job_type_id;
}

static GType
library_monitor_verify_job_get_type (void)
{
	static volatile gsize library_monitor_verify_job_type_id__once = 0;
	if (g_once_init_enter (&library_monitor_verify_job_type_id__once)) {
		GType library_monitor_verify_job_type_id;
		library_monitor_verify_job_type_id = library_monitor_verify_job_get_type_once ();
		g_once_init_leave (&library_monitor_verify_job_type_id__once, library_monitor_verify_job_type_id);
	}
	return library_monitor_verify_job_type_id__once;
}

static gpointer
library_monitor_verify_job_ref (gpointer instance)
{
	LibraryMonitorVerifyJob * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
library_monitor_verify_job_unref (gpointer instance)
{
	LibraryMonitorVerifyJob * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		LIBRARY_MONITOR_VERIFY_JOB_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static GObject *
library_monitor_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	LibraryMonitor * self;
	GSettings* _tmp0_;
	parent_class = G_OBJECT_CLASS (library_monitor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIBRARY_MONITOR, LibraryMonitor);
	_tmp0_ = g_settings_new (GSETTINGS_CONFIGURATION_ENGINE_FILES_PREFS_SCHEMA_NAME);
	_g_object_unref0 (self->priv->file_settings);
	self->priv->file_settings = _tmp0_;
	return obj;
}

static void
library_monitor_class_init (LibraryMonitorClass * klass,
                            gpointer klass_data)
{
	GeeHashSet* _tmp0_;
	HashTimedQueue* _tmp1_;
	library_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &LibraryMonitor_private_offset);
	((DirectoryMonitorClass *) klass)->close = (void (*) (DirectoryMonitor*)) library_monitor_real_close;
	((DirectoryMonitorClass *) klass)->discovery_started = (void (*) (DirectoryMonitor*)) library_monitor_real_discovery_started;
	((DirectoryMonitorClass *) klass)->file_discovered = (void (*) (DirectoryMonitor*, GFile*, GFileInfo*)) library_monitor_real_file_discovered;
	((DirectoryMonitorClass *) klass)->discovery_completed = (void (*) (DirectoryMonitor*)) library_monitor_real_discovery_completed;
	((DirectoryMonitorClass *) klass)->notify_file_created = (void (*) (DirectoryMonitor*, GFile*, GFileInfo*)) library_monitor_real_notify_file_created;
	((DirectoryMonitorClass *) klass)->notify_file_moved = (void (*) (DirectoryMonitor*, GFile*, GFile*, GFileInfo*)) library_monitor_real_notify_file_moved;
	((DirectoryMonitorClass *) klass)->notify_file_altered = (void (*) (DirectoryMonitor*, GFile*)) library_monitor_real_notify_file_altered;
	((DirectoryMonitorClass *) klass)->notify_file_attributes_altered = (void (*) (DirectoryMonitor*, GFile*)) library_monitor_real_notify_file_attributes_altered;
	((DirectoryMonitorClass *) klass)->notify_file_alteration_completed = (void (*) (DirectoryMonitor*, GFile*, GFileInfo*)) library_monitor_real_notify_file_alteration_completed;
	((DirectoryMonitorClass *) klass)->notify_file_deleted = (void (*) (DirectoryMonitor*, GFile*)) library_monitor_real_notify_file_deleted;
	G_OBJECT_CLASS (klass)->constructor = library_monitor_constructor;
	G_OBJECT_CLASS (klass)->finalize = library_monitor_finalize;
	library_monitor_signals[LIBRARY_MONITOR_AUTO_UPDATE_PROGRESS_SIGNAL] = g_signal_new ("auto-update-progress", TYPE_LIBRARY_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
	library_monitor_signals[LIBRARY_MONITOR_AUTO_IMPORT_PREPARING_SIGNAL] = g_signal_new ("auto-import-preparing", TYPE_LIBRARY_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	library_monitor_signals[LIBRARY_MONITOR_AUTO_IMPORT_PROGRESS_SIGNAL] = g_signal_new ("auto-import-progress", TYPE_LIBRARY_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT64_UINT64, G_TYPE_NONE, 2, G_TYPE_UINT64, G_TYPE_UINT64);
	g_rec_mutex_init (&__lock_library_monitor_library_monitor_blacklist);
	_tmp0_ = gee_hash_set_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL);
	library_monitor_blacklist = _tmp0_;
	_tmp1_ = hash_timed_queue_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (guint) LIBRARY_MONITOR_MIN_BLACKLIST_DURATION_MSEC, _library_monitor_on_unblacklist_file_dequeued_callback, NULL, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, G_PRIORITY_LOW);
	library_monitor_to_unblacklist = _tmp1_;
}

static void
library_monitor_instance_init (LibraryMonitor * self,
                               gpointer klass)
{
	Workers* _tmp0_;
	GCancellable* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeHashSet* _tmp3_;
	GeeHashSet* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeLinkedList* _tmp6_;
	self->priv = library_monitor_get_instance_private (self);
	_tmp0_ = workers_new (workers_thread_per_cpu_minus_one (), FALSE);
	self->priv->workers = _tmp0_;
	_tmp1_ = g_cancellable_new ();
	self->priv->cancellable = _tmp1_;
	self->priv->auto_import = FALSE;
	self->priv->unknown_files = NULL;
	_tmp2_ = gee_array_list_new (TYPE_MEDIA_MONITOR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->monitors = (GeeList*) _tmp2_;
	self->priv->discovered = NULL;
	_tmp3_ = gee_hash_set_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL);
	self->priv->import_queue = _tmp3_;
	_tmp4_ = gee_hash_set_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL);
	self->priv->pending_imports = _tmp4_;
	_tmp5_ = gee_array_list_new (TYPE_BATCH_IMPORT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->batch_import_queue = _tmp5_;
	self->priv->current_import_roll = NULL;
	self->priv->last_import_roll_use = (gint64) 0;
	self->priv->current_batch_import = NULL;
	self->priv->checksums_completed = 0;
	self->priv->checksums_total = 0;
	self->priv->import_queue_timer_id = (guint) 0;
	_tmp6_ = gee_linked_list_new (LIBRARY_MONITOR_TYPE_VERIFY_JOB, (GBoxedCopyFunc) library_monitor_verify_job_ref, (GDestroyNotify) library_monitor_verify_job_unref, NULL, NULL, NULL);
	self->priv->verify_queue = (GeeQueue*) _tmp6_;
	self->priv->outstanding_verify_jobs = 0;
	self->priv->completed_monitorable_verifies = 0;
	self->priv->total_monitorable_verifies = 0;
}

static void
library_monitor_finalize (GObject * obj)
{
	LibraryMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIBRARY_MONITOR, LibraryMonitor);
	_workers_unref0 (self->priv->workers);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->unknown_files);
	_g_object_unref0 (self->priv->monitors);
	_g_object_unref0 (self->priv->discovered);
	_g_object_unref0 (self->priv->import_queue);
	_g_object_unref0 (self->priv->pending_imports);
	_g_object_unref0 (self->priv->batch_import_queue);
	_batch_import_roll_unref0 (self->priv->current_import_roll);
	_g_object_unref0 (self->priv->current_batch_import);
	_g_object_unref0 (self->priv->verify_queue);
	_g_object_unref0 (self->priv->file_settings);
	G_OBJECT_CLASS (library_monitor_parent_class)->finalize (obj);
}

static GType
library_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LibraryMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) library_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibraryMonitor), 0, (GInstanceInitFunc) library_monitor_instance_init, NULL };
	GType library_monitor_type_id;
	library_monitor_type_id = g_type_register_static (TYPE_DIRECTORY_MONITOR, "LibraryMonitor", &g_define_type_info, 0);
	LibraryMonitor_private_offset = g_type_add_instance_private (library_monitor_type_id, sizeof (LibraryMonitorPrivate));
	return library_monitor_type_id;
}

GType
library_monitor_get_type (void)
{
	static volatile gsize library_monitor_type_id__once = 0;
	if (g_once_init_enter (&library_monitor_type_id__once)) {
		GType library_monitor_type_id;
		library_monitor_type_id = library_monitor_get_type_once ();
		g_once_init_leave (&library_monitor_type_id__once, library_monitor_type_id);
	}
	return library_monitor_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

