/* ImportQueuePage.c generated by valac 0.56.18, the Vala compiler
 * generated from ImportQueuePage.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <gee.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <granite.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	IMPORT_QUEUE_PAGE_0_PROPERTY,
	IMPORT_QUEUE_PAGE_NUM_PROPERTIES
};
static GParamSpec* import_queue_page_properties[IMPORT_QUEUE_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	IMPORT_QUEUE_PAGE_BATCH_ADDED_SIGNAL,
	IMPORT_QUEUE_PAGE_BATCH_REMOVED_SIGNAL,
	IMPORT_QUEUE_PAGE_NUM_SIGNALS
};
static guint import_queue_page_signals[IMPORT_QUEUE_PAGE_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ImportQueuePagePrivate {
	GeeArrayList* queue;
	GeeHashSet* cancel_unallowed;
	BatchImport* current_batch;
	GtkProgressBar* progress_bar;
	gboolean stopped;
};

static gint ImportQueuePage_private_offset;
static gpointer import_queue_page_parent_class = NULL;

static void import_queue_page_real_add_toolbar_widgets (ImportQueuePage* self,
                                                 GtkActionBar* toolbar);
static GtkActionEntry* import_queue_page_real_init_collect_action_entries (Page* base,
                                                                    gint* result_length1);
static void import_queue_page_on_stop (ImportQueuePage* self);
static void _import_queue_page_on_stop_gcallback (GtkAction* action,
                                           gpointer self);
static void _vala_array_add156 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void import_queue_page_on_starting (ImportQueuePage* self,
                                    BatchImport* batch_import);
static void _import_queue_page_on_starting_batch_import_starting (BatchImport* _sender,
                                                           gpointer self);
static void import_queue_page_on_preparing (ImportQueuePage* self);
static void _import_queue_page_on_preparing_batch_import_preparing (BatchImport* _sender,
                                                             gpointer self);
static void import_queue_page_on_progress (ImportQueuePage* self,
                                    guint64 completed_bytes,
                                    guint64 total_bytes);
static void _import_queue_page_on_progress_batch_import_progress (BatchImport* _sender,
                                                           guint64 completed_bytes,
                                                           guint64 total_bytes,
                                                           gpointer self);
static void import_queue_page_on_imported (ImportQueuePage* self,
                                    ThumbnailSource* source,
                                    GdkPixbuf* pixbuf,
                                    gint to_follow);
static void _import_queue_page_on_imported_batch_import_imported (BatchImport* _sender,
                                                           MediaSource* source,
                                                           GdkPixbuf* pixbuf,
                                                           gint to_follow,
                                                           gpointer self);
static void import_queue_page_on_import_complete (ImportQueuePage* self,
                                           BatchImport* batch_import,
                                           ImportManifest* manifest,
                                           BatchImportRoll* import_roll);
static void _import_queue_page_on_import_complete_batch_import_import_complete (BatchImport* _sender,
                                                                         ImportManifest* manifest,
                                                                         BatchImportRoll* import_roll,
                                                                         gpointer self);
static void import_queue_page_on_fatal_error (ImportQueuePage* self,
                                       ImportResult _result_,
                                       const gchar* message);
static void _import_queue_page_on_fatal_error_batch_import_fatal_error (BatchImport* _sender,
                                                                 ImportResult _result_,
                                                                 const gchar* message,
                                                                 gpointer self);
static void import_queue_page_update_stop_action (ImportQueuePage* self);
static void import_queue_page_finalize (GObject * obj);
static GType import_queue_page_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
import_queue_page_get_instance_private (ImportQueuePage* self)
{
	return G_STRUCT_MEMBER_P (self, ImportQueuePage_private_offset);
}

ImportQueuePage*
import_queue_page_construct (GType object_type)
{
	ImportQueuePage * self = NULL;
	self = (ImportQueuePage*) single_photo_page_construct (object_type, IMPORT_QUEUE_PAGE_NAME, FALSE);
	granite_services_application_set_progress_visible (TRUE, NULL, NULL);
	return self;
}

ImportQueuePage*
import_queue_page_new (void)
{
	return import_queue_page_construct (TYPE_IMPORT_QUEUE_PAGE);
}

static void
import_queue_page_real_add_toolbar_widgets (ImportQueuePage* self,
                                            GtkActionBar* toolbar)
{
	GtkToolItem* progress_item = NULL;
	GtkToolItem* _tmp0_;
	GtkProgressBar* _tmp1_;
	GtkProgressBar* _tmp2_;
	GtkButton* stop_button = NULL;
	GtkButton* _tmp3_;
	GtkAction* _tmp4_;
	GtkAction* _tmp5_;
	g_return_if_fail (toolbar != NULL);
	_tmp0_ = gtk_tool_item_new ();
	g_object_ref_sink (_tmp0_);
	progress_item = _tmp0_;
	gtk_tool_item_set_expand (progress_item, TRUE);
	_tmp1_ = self->priv->progress_bar;
	gtk_container_add ((GtkContainer*) progress_item, (GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->progress_bar;
	gtk_progress_bar_set_show_text (_tmp2_, TRUE);
	_tmp3_ = (GtkButton*) gtk_button_new_from_icon_name ("process-stop-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp3_);
	stop_button = _tmp3_;
	_tmp4_ = page_get_action ((Page*) self, "Stop");
	_tmp5_ = _tmp4_;
	gtk_activatable_set_related_action ((GtkActivatable*) stop_button, _tmp5_);
	_g_object_unref0 (_tmp5_);
	gtk_action_bar_pack_start (toolbar, (GtkWidget*) progress_item);
	gtk_action_bar_pack_end (toolbar, (GtkWidget*) stop_button);
	PAGE_CLASS (import_queue_page_parent_class)->add_toolbar_widgets ((Page*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SINGLE_PHOTO_PAGE, SinglePhotoPage), toolbar);
	_g_object_unref0 (stop_button);
	_g_object_unref0 (progress_item);
}

void
import_queue_page_add_toolbar_widgets (ImportQueuePage* self,
                                       GtkActionBar* toolbar)
{
	ImportQueuePageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = IMPORT_QUEUE_PAGE_GET_CLASS (self);
	if (_klass_->add_toolbar_widgets) {
		_klass_->add_toolbar_widgets (self, toolbar);
	}
}

static void
_import_queue_page_on_stop_gcallback (GtkAction* action,
                                      gpointer self)
{
	import_queue_page_on_stop ((ImportQueuePage*) self);
}

static void
_vala_array_add156 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static GtkActionEntry*
import_queue_page_real_init_collect_action_entries (Page* base,
                                                    gint* result_length1)
{
	ImportQueuePage * self;
	GtkActionEntry* actions = NULL;
	gint _tmp0_ = 0;
	GtkActionEntry* _tmp1_;
	gint actions_length1;
	gint _actions_size_;
	GtkActionEntry stop = {0};
	GtkActionEntry _tmp2_ = {0};
	GtkActionEntry _tmp3_;
	GtkActionEntry* _tmp4_;
	gint _tmp4__length1;
	GtkActionEntry* result;
	self = (ImportQueuePage*) base;
	_tmp1_ = PAGE_CLASS (import_queue_page_parent_class)->init_collect_action_entries ((Page*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SINGLE_PHOTO_PAGE, SinglePhotoPage), &_tmp0_);
	actions = _tmp1_;
	actions_length1 = _tmp0_;
	_actions_size_ = actions_length1;
	_tmp2_.name = "Stop";
	_tmp2_.stock_id = NULL;
	_tmp2_.label = _ ("_Stop Import");
	_tmp2_.accelerator = NULL;
	_tmp2_.tooltip = _ ("Stop importing photos");
	_tmp2_.callback = (GCallback) _import_queue_page_on_stop_gcallback;
	stop = _tmp2_;
	_tmp3_ = stop;
	_vala_array_add156 (&actions, &actions_length1, &_actions_size_, &_tmp3_);
	_tmp4_ = actions;
	_tmp4__length1 = actions_length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

static void
_import_queue_page_on_starting_batch_import_starting (BatchImport* _sender,
                                                      gpointer self)
{
	import_queue_page_on_starting ((ImportQueuePage*) self, _sender);
}

static void
_import_queue_page_on_preparing_batch_import_preparing (BatchImport* _sender,
                                                        gpointer self)
{
	import_queue_page_on_preparing ((ImportQueuePage*) self);
}

static void
_import_queue_page_on_progress_batch_import_progress (BatchImport* _sender,
                                                      guint64 completed_bytes,
                                                      guint64 total_bytes,
                                                      gpointer self)
{
	import_queue_page_on_progress ((ImportQueuePage*) self, completed_bytes, total_bytes);
}

static void
_import_queue_page_on_imported_batch_import_imported (BatchImport* _sender,
                                                      MediaSource* source,
                                                      GdkPixbuf* pixbuf,
                                                      gint to_follow,
                                                      gpointer self)
{
	import_queue_page_on_imported ((ImportQueuePage*) self, source, pixbuf, to_follow);
}

static void
_import_queue_page_on_import_complete_batch_import_import_complete (BatchImport* _sender,
                                                                    ImportManifest* manifest,
                                                                    BatchImportRoll* import_roll,
                                                                    gpointer self)
{
	import_queue_page_on_import_complete ((ImportQueuePage*) self, _sender, manifest, import_roll);
}

static void
_import_queue_page_on_fatal_error_batch_import_fatal_error (BatchImport* _sender,
                                                            ImportResult _result_,
                                                            const gchar* message,
                                                            gpointer self)
{
	import_queue_page_on_fatal_error ((ImportQueuePage*) self, _result_, message);
}

void
import_queue_page_enqueue_and_schedule (ImportQueuePage* self,
                                        BatchImport* batch_import,
                                        gboolean allow_user_cancel)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (batch_import != NULL);
	_tmp0_ = self->priv->queue;
	_vala_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, batch_import), "!queue.contains (batch_import)");
	g_signal_connect_object (batch_import, "starting", (GCallback) _import_queue_page_on_starting_batch_import_starting, self, 0);
	g_signal_connect_object (batch_import, "preparing", (GCallback) _import_queue_page_on_preparing_batch_import_preparing, self, 0);
	g_signal_connect_object (batch_import, "progress", (GCallback) _import_queue_page_on_progress_batch_import_progress, self, 0);
	g_signal_connect_object (batch_import, "imported", (GCallback) _import_queue_page_on_imported_batch_import_imported, self, 0);
	g_signal_connect_object (batch_import, "import-complete", (GCallback) _import_queue_page_on_import_complete_batch_import_import_complete, self, 0);
	g_signal_connect_object (batch_import, "fatal-error", (GCallback) _import_queue_page_on_fatal_error_batch_import_fatal_error, self, 0);
	if (!allow_user_cancel) {
		GeeHashSet* _tmp1_;
		_tmp1_ = self->priv->cancel_unallowed;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, batch_import);
	}
	_tmp2_ = self->priv->queue;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, batch_import);
	g_signal_emit (self, import_queue_page_signals[IMPORT_QUEUE_PAGE_BATCH_ADDED_SIGNAL], 0, batch_import);
	_tmp3_ = self->priv->queue;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 1) {
		batch_import_schedule (batch_import);
	}
	import_queue_page_update_stop_action (self);
}

gint
import_queue_page_get_batch_count (ImportQueuePage* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->queue;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
import_queue_page_update_stop_action (ImportQueuePage* self)
{
	gboolean _tmp0_ = FALSE;
	GeeHashSet* _tmp1_;
	BatchImport* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->cancel_unallowed;
	_tmp2_ = self->priv->current_batch;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp1_, _tmp2_)) {
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = self->priv->queue;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	page_set_action_sensitive ((Page*) self, "Stop", _tmp0_);
}

static void
import_queue_page_on_stop (ImportQueuePage* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	AppWindow* _tmp3_;
	AppWindow* _tmp4_;
	g_return_if_fail (self != NULL);
	import_queue_page_update_stop_action (self);
	_tmp0_ = self->priv->queue;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		return;
	}
	_tmp3_ = app_window_get_instance ();
	_tmp4_ = _tmp3_;
	page_window_set_busy_cursor ((PageWindow*) _tmp4_);
	_g_object_unref0 (_tmp4_);
	self->priv->stopped = TRUE;
	{
		GeeArrayList* _batch_import_list = NULL;
		GeeArrayList* _tmp5_;
		gint _batch_import_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _batch_import_index = 0;
		_tmp5_ = self->priv->queue;
		_batch_import_list = _tmp5_;
		_tmp6_ = _batch_import_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_batch_import_size = _tmp8_;
		_batch_import_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			BatchImport* batch_import = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			BatchImport* _tmp13_;
			_batch_import_index = _batch_import_index + 1;
			_tmp9_ = _batch_import_index;
			_tmp10_ = _batch_import_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _batch_import_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _batch_import_index);
			batch_import = (BatchImport*) _tmp12_;
			_tmp13_ = batch_import;
			batch_import_user_halt (_tmp13_);
			_g_object_unref0 (batch_import);
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
import_queue_page_on_starting (ImportQueuePage* self,
                               BatchImport* batch_import)
{
	BatchImport* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (batch_import != NULL);
	import_queue_page_update_stop_action (self);
	_tmp0_ = _g_object_ref0 (batch_import);
	_g_object_unref0 (self->priv->current_batch);
	self->priv->current_batch = _tmp0_;
}

static void
import_queue_page_on_preparing (ImportQueuePage* self)
{
	GtkProgressBar* _tmp0_;
	GtkProgressBar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_bar;
	gtk_progress_bar_set_text (_tmp0_, _ ("Preparing to import…"));
	_tmp1_ = self->priv->progress_bar;
	gtk_progress_bar_pulse (_tmp1_);
}

static void
import_queue_page_on_progress (ImportQueuePage* self,
                               guint64 completed_bytes,
                               guint64 total_bytes)
{
	gdouble _tmp0_ = 0.0;
	gdouble pct = 0.0;
	GtkProgressBar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (completed_bytes <= total_bytes) {
		_tmp0_ = ((gdouble) completed_bytes) / ((gdouble) total_bytes);
	} else {
		_tmp0_ = 0.0;
	}
	pct = _tmp0_;
	_tmp1_ = self->priv->progress_bar;
	gtk_progress_bar_set_fraction (_tmp1_, pct);
	granite_services_application_set_progress (pct, NULL, NULL);
}

static void
import_queue_page_on_imported (ImportQueuePage* self,
                               ThumbnailSource* source,
                               GdkPixbuf* pixbuf,
                               gint to_follow)
{
	gboolean _tmp0_ = FALSE;
	Dimensions _tmp3_ = {0};
	ViewCollection* _tmp4_;
	ViewCollection* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GtkProgressBar* _tmp15_;
	GtkProgressBar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (pixbuf != NULL);
	if (to_follow > 0) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = page_get_in_view ((Page*) self);
		_tmp2_ = _tmp1_;
		_tmp0_ = !_tmp2_;
	}
	if (_tmp0_) {
		return;
	}
	dimensions_for_pixbuf (pixbuf, &_tmp3_);
	single_photo_page_set_pixbuf ((SinglePhotoPage*) self, pixbuf, &_tmp3_, NULL);
	_tmp4_ = page_get_view ((Page*) self);
	_tmp5_ = _tmp4_;
	data_collection_clear ((DataCollection*) _tmp5_);
	_data_collection_unref0 (_tmp5_);
	if (IS_LIBRARY_PHOTO (source)) {
		ViewCollection* _tmp7_;
		ViewCollection* _tmp8_;
		PhotoView* _tmp9_;
		PhotoView* _tmp10_;
		_tmp7_ = page_get_view ((Page*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = photo_view_new ((PhotoSource*) (IS_LIBRARY_PHOTO (source) ? ((LibraryPhoto*) source) : NULL));
		_tmp10_ = _tmp9_;
		_tmp6_ = data_collection_add ((DataCollection*) _tmp8_, (DataObject*) _tmp10_);
		_g_object_unref0 (_tmp10_);
		_data_collection_unref0 (_tmp8_);
	} else {
		ViewCollection* _tmp11_;
		ViewCollection* _tmp12_;
		VideoView* _tmp13_;
		VideoView* _tmp14_;
		_tmp11_ = page_get_view ((Page*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = video_view_new ((VideoSource*) (IS_VIDEO (source) ? ((Video*) source) : NULL));
		_tmp14_ = _tmp13_;
		_tmp6_ = data_collection_add ((DataCollection*) _tmp12_, (DataObject*) _tmp14_);
		_g_object_unref0 (_tmp14_);
		_data_collection_unref0 (_tmp12_);
	}
	_tmp15_ = self->priv->progress_bar;
	gtk_progress_bar_set_ellipsize (_tmp15_, PANGO_ELLIPSIZE_MIDDLE);
	_tmp16_ = self->priv->progress_bar;
	_tmp17_ = data_object_get_name ((DataObject*) source);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup_printf (_ ("Imported %s"), _tmp18_);
	_tmp20_ = _tmp19_;
	gtk_progress_bar_set_text (_tmp16_, _tmp20_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
}

static void
import_queue_page_on_import_complete (ImportQueuePage* self,
                                      BatchImport* batch_import,
                                      ImportManifest* manifest,
                                      BatchImportRoll* import_roll)
{
	BatchImport* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	gpointer _tmp5_;
	BatchImport* _tmp6_;
	gboolean removed = FALSE;
	GeeArrayList* _tmp7_;
	GeeHashSet* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	guint _tmp14_;
	GeeArrayList* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (batch_import != NULL);
	g_return_if_fail (manifest != NULL);
	g_return_if_fail (import_roll != NULL);
	_tmp0_ = self->priv->current_batch;
	_vala_assert (batch_import == _tmp0_, "batch_import == current_batch");
	_g_object_unref0 (self->priv->current_batch);
	self->priv->current_batch = NULL;
	_tmp1_ = self->priv->queue;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_assert (_tmp3_ > 0, "queue.size > 0");
	_tmp4_ = self->priv->queue;
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, 0);
	_tmp6_ = (BatchImport*) _tmp5_;
	_vala_assert (_tmp6_ == batch_import, "queue.get (0) == batch_import");
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->queue;
	removed = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp7_, batch_import);
	_vala_assert (removed, "removed");
	_tmp8_ = self->priv->cancel_unallowed;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp8_, batch_import);
	g_signal_parse_name ("starting", TYPE_BATCH_IMPORT, &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (batch_import, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _import_queue_page_on_starting_batch_import_starting, self);
	g_signal_parse_name ("preparing", TYPE_BATCH_IMPORT, &_tmp10_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (batch_import, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _import_queue_page_on_preparing_batch_import_preparing, self);
	g_signal_parse_name ("progress", TYPE_BATCH_IMPORT, &_tmp11_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (batch_import, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _import_queue_page_on_progress_batch_import_progress, self);
	g_signal_parse_name ("imported", TYPE_BATCH_IMPORT, &_tmp12_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (batch_import, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _import_queue_page_on_imported_batch_import_imported, self);
	g_signal_parse_name ("import-complete", TYPE_BATCH_IMPORT, &_tmp13_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (batch_import, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _import_queue_page_on_import_complete_batch_import_import_complete, self);
	g_signal_parse_name ("fatal-error", TYPE_BATCH_IMPORT, &_tmp14_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (batch_import, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _import_queue_page_on_fatal_error_batch_import_fatal_error, self);
	_tmp15_ = self->priv->queue;
	_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ > 0) {
		GeeArrayList* _tmp18_;
		gpointer _tmp19_;
		BatchImport* _tmp20_;
		_tmp18_ = self->priv->queue;
		_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, 0);
		_tmp20_ = (BatchImport*) _tmp19_;
		batch_import_schedule (_tmp20_);
		_g_object_unref0 (_tmp20_);
	} else {
		GtkProgressBar* _tmp21_;
		GtkProgressBar* _tmp22_;
		GtkProgressBar* _tmp23_;
		_tmp21_ = self->priv->progress_bar;
		gtk_progress_bar_set_ellipsize (_tmp21_, PANGO_ELLIPSIZE_NONE);
		_tmp22_ = self->priv->progress_bar;
		gtk_progress_bar_set_text (_tmp22_, "");
		_tmp23_ = self->priv->progress_bar;
		gtk_progress_bar_set_fraction (_tmp23_, 0.0);
		granite_services_application_set_progress_visible (FALSE, NULL, NULL);
		granite_services_application_set_progress (0.0, NULL, NULL);
		single_photo_page_blank_display ((SinglePhotoPage*) self);
		if (self->priv->stopped) {
			AppWindow* _tmp24_;
			AppWindow* _tmp25_;
			_tmp24_ = app_window_get_instance ();
			_tmp25_ = _tmp24_;
			page_window_set_normal_cursor ((PageWindow*) _tmp25_);
			_g_object_unref0 (_tmp25_);
		}
		self->priv->stopped = FALSE;
	}
	import_queue_page_update_stop_action (self);
	g_signal_emit (self, import_queue_page_signals[IMPORT_QUEUE_PAGE_BATCH_REMOVED_SIGNAL], 0, batch_import);
}

static void
import_queue_page_on_fatal_error (ImportQueuePage* self,
                                  ImportResult _result_,
                                  const gchar* message)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	app_window_error_message (message, NULL, NULL);
}

static void
import_queue_page_class_init (ImportQueuePageClass * klass,
                              gpointer klass_data)
{
	import_queue_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ImportQueuePage_private_offset);
	((ImportQueuePageClass *) klass)->add_toolbar_widgets = (void (*) (ImportQueuePage*, GtkActionBar*)) import_queue_page_real_add_toolbar_widgets;
	((PageClass *) klass)->init_collect_action_entries = (GtkActionEntry* (*) (Page*, gint*)) import_queue_page_real_init_collect_action_entries;
	G_OBJECT_CLASS (klass)->finalize = import_queue_page_finalize;
	import_queue_page_signals[IMPORT_QUEUE_PAGE_BATCH_ADDED_SIGNAL] = g_signal_new ("batch-added", TYPE_IMPORT_QUEUE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_BATCH_IMPORT);
	import_queue_page_signals[IMPORT_QUEUE_PAGE_BATCH_REMOVED_SIGNAL] = g_signal_new ("batch-removed", TYPE_IMPORT_QUEUE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_BATCH_IMPORT);
}

static void
import_queue_page_instance_init (ImportQueuePage * self,
                                 gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeHashSet* _tmp1_;
	GtkProgressBar* _tmp2_;
	self->priv = import_queue_page_get_instance_private (self);
	_tmp0_ = gee_array_list_new (TYPE_BATCH_IMPORT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->queue = _tmp0_;
	_tmp1_ = gee_hash_set_new (TYPE_BATCH_IMPORT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->cancel_unallowed = _tmp1_;
	self->priv->current_batch = NULL;
	_tmp2_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp2_);
	self->priv->progress_bar = _tmp2_;
	self->priv->stopped = FALSE;
}

static void
import_queue_page_finalize (GObject * obj)
{
	ImportQueuePage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IMPORT_QUEUE_PAGE, ImportQueuePage);
	_g_object_unref0 (self->priv->queue);
	_g_object_unref0 (self->priv->cancel_unallowed);
	_g_object_unref0 (self->priv->current_batch);
	_g_object_unref0 (self->priv->progress_bar);
	G_OBJECT_CLASS (import_queue_page_parent_class)->finalize (obj);
}

static GType
import_queue_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ImportQueuePageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) import_queue_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ImportQueuePage), 0, (GInstanceInitFunc) import_queue_page_instance_init, NULL };
	GType import_queue_page_type_id;
	import_queue_page_type_id = g_type_register_static (TYPE_SINGLE_PHOTO_PAGE, "ImportQueuePage", &g_define_type_info, 0);
	ImportQueuePage_private_offset = g_type_add_instance_private (import_queue_page_type_id, sizeof (ImportQueuePagePrivate));
	return import_queue_page_type_id;
}

GType
import_queue_page_get_type (void)
{
	static volatile gsize import_queue_page_type_id__once = 0;
	if (g_once_init_enter (&import_queue_page_type_id__once)) {
		GType import_queue_page_type_id;
		import_queue_page_type_id = import_queue_page_get_type_once ();
		g_once_init_leave (&import_queue_page_type_id__once, import_queue_page_type_id);
	}
	return import_queue_page_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

