// python wrapper for vtkSMTransferFunction2DProxy
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSmartPointer.h"
#include "vtkSMTransferFunction2DProxy.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMTransferFunction2DProxy(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMTransferFunction2DProxy_ClassNew(); }


static PyObject *
PyvtkSMTransferFunction2DProxy_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMTransferFunction2DProxy::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunction2DProxy_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunction2DProxy *op = static_cast<vtkSMTransferFunction2DProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMTransferFunction2DProxy::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunction2DProxy_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMTransferFunction2DProxy *tempr = vtkSMTransferFunction2DProxy::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunction2DProxy_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunction2DProxy *op = static_cast<vtkSMTransferFunction2DProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMTransferFunction2DProxy *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMTransferFunction2DProxy::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunction2DProxy_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMTransferFunction2DProxy::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunction2DProxy_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunction2DProxy *op = static_cast<vtkSMTransferFunction2DProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMTransferFunction2DProxy::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunction2DProxy_RescaleTransferFunction_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RescaleTransferFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunction2DProxy *op = static_cast<vtkSMTransferFunction2DProxy *>(vp);

  const size_t size0 = 4;
  double temp0[4];
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetArray(temp0, size0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    bool tempr = (ap.IsBound() ?
      op->RescaleTransferFunction(temp0, temp1) :
      op->vtkSMTransferFunction2DProxy::RescaleTransferFunction(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMTransferFunction2DProxy_RescaleTransferFunction_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RescaleTransferFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunction2DProxy *op = static_cast<vtkSMTransferFunction2DProxy *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  bool temp4 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4, 5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)))
  {
    bool tempr = (ap.IsBound() ?
      op->RescaleTransferFunction(temp0, temp1, temp2, temp3, temp4) :
      op->vtkSMTransferFunction2DProxy::RescaleTransferFunction(temp0, temp1, temp2, temp3, temp4));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMTransferFunction2DProxy_RescaleTransferFunction_s3(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RescaleTransferFunction");

  vtkSMProxy *temp0 = nullptr;
  double temp1;
  double temp2;
  double temp3;
  double temp4;
  bool temp5 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(5, 6) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4) &&
      (ap.NoArgsLeft() || ap.GetValue(temp5)))
  {
    bool tempr = vtkSMTransferFunction2DProxy::RescaleTransferFunction(temp0, temp1, temp2, temp3, temp4, temp5);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMTransferFunction2DProxy_RescaleTransferFunction_s4(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RescaleTransferFunction");

  vtkSMProxy *temp0 = nullptr;
  const size_t size1 = 4;
  double temp1[4];
  bool temp2 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1, size1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    bool tempr = vtkSMTransferFunction2DProxy::RescaleTransferFunction(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMTransferFunction2DProxy_RescaleTransferFunction_Methods[] = {
  {"RescaleTransferFunction", PyvtkSMTransferFunction2DProxy_RescaleTransferFunction_s1, METH_VARARGS,
   "@P|q *d"},
  {"RescaleTransferFunction", PyvtkSMTransferFunction2DProxy_RescaleTransferFunction_s2, METH_VARARGS,
   "@dddd|q"},
  {"RescaleTransferFunction", PyvtkSMTransferFunction2DProxy_RescaleTransferFunction_s3, METH_VARARGS | METH_STATIC,
   "Vdddd|q *vtkSMProxy"},
  {"RescaleTransferFunction", PyvtkSMTransferFunction2DProxy_RescaleTransferFunction_s4, METH_VARARGS | METH_STATIC,
   "VP|q *vtkSMProxy *d"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMTransferFunction2DProxy_RescaleTransferFunction(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMTransferFunction2DProxy_RescaleTransferFunction_Methods;
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 1:
      return PyvtkSMTransferFunction2DProxy_RescaleTransferFunction_s1(self, args);
    case 4:
      return PyvtkSMTransferFunction2DProxy_RescaleTransferFunction_s2(self, args);
    case 6:
      return PyvtkSMTransferFunction2DProxy_RescaleTransferFunction_s3(self, args);
    case 3:
      return PyvtkSMTransferFunction2DProxy_RescaleTransferFunction_s4(self, args);
    case 2:
    case 5:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RescaleTransferFunction");
  return nullptr;
}


static PyObject *
PyvtkSMTransferFunction2DProxy_RescaleTransferFunctionToDataRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RescaleTransferFunctionToDataRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunction2DProxy *op = static_cast<vtkSMTransferFunction2DProxy *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0, 1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp0)))
  {
    bool tempr = (ap.IsBound() ?
      op->RescaleTransferFunctionToDataRange(temp0) :
      op->vtkSMTransferFunction2DProxy::RescaleTransferFunctionToDataRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMTransferFunction2DProxy_RescaleTransferFunctionToDataRange_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RescaleTransferFunctionToDataRange");

  vtkSMProxy *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1, 2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    bool tempr = vtkSMTransferFunction2DProxy::RescaleTransferFunctionToDataRange(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMTransferFunction2DProxy_RescaleTransferFunctionToDataRange_Methods[] = {
  {"RescaleTransferFunctionToDataRange", PyvtkSMTransferFunction2DProxy_RescaleTransferFunctionToDataRange_s1, METH_VARARGS,
   "@|q"},
  {"RescaleTransferFunctionToDataRange", PyvtkSMTransferFunction2DProxy_RescaleTransferFunctionToDataRange_s2, METH_VARARGS | METH_STATIC,
   "V|q *vtkSMProxy"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMTransferFunction2DProxy_RescaleTransferFunctionToDataRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMTransferFunction2DProxy_RescaleTransferFunctionToDataRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkSMTransferFunction2DProxy_RescaleTransferFunctionToDataRange_s1(self, args);
    case 2:
      return PyvtkSMTransferFunction2DProxy_RescaleTransferFunctionToDataRange_s2(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RescaleTransferFunctionToDataRange");
  return nullptr;
}


static PyObject *
PyvtkSMTransferFunction2DProxy_ComputeDataRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ComputeDataRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunction2DProxy *op = static_cast<vtkSMTransferFunction2DProxy *>(vp);

  const size_t size0 = 4;
  double temp0[4];
  double save0[4];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    bool tempr = (ap.IsBound() ?
      op->ComputeDataRange(temp0) :
      op->vtkSMTransferFunction2DProxy::ComputeDataRange(temp0));

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMTransferFunction2DProxy_ComputeDataRange_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ComputeDataRange");

  vtkSMProxy *temp0 = nullptr;
  const size_t size1 = 4;
  double temp1[4];
  double save1[4];
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1, size1))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    bool tempr = vtkSMTransferFunction2DProxy::ComputeDataRange(temp0, temp1);

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMTransferFunction2DProxy_ComputeDataRange(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 1:
      return PyvtkSMTransferFunction2DProxy_ComputeDataRange_s1(self, args);
    case 2:
      return PyvtkSMTransferFunction2DProxy_ComputeDataRange_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "ComputeDataRange");
  return nullptr;
}


static PyObject *
PyvtkSMTransferFunction2DProxy_ComputeDataHistogram2D_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ComputeDataHistogram2D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunction2DProxy *op = static_cast<vtkSMTransferFunction2DProxy *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkSmartPointer<vtkImageData> tempr = (ap.IsBound() ?
      op->ComputeDataHistogram2D(temp0) :
      op->vtkSMTransferFunction2DProxy::ComputeDataHistogram2D(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMTransferFunction2DProxy_ComputeDataHistogram2D_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ComputeDataHistogram2D");

  vtkSMProxy *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    vtkSmartPointer<vtkImageData> tempr = vtkSMTransferFunction2DProxy::ComputeDataHistogram2D(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMTransferFunction2DProxy_ComputeDataHistogram2D(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 1:
      return PyvtkSMTransferFunction2DProxy_ComputeDataHistogram2D_s1(self, args);
    case 2:
      return PyvtkSMTransferFunction2DProxy_ComputeDataHistogram2D_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "ComputeDataHistogram2D");
  return nullptr;
}


static PyObject *
PyvtkSMTransferFunction2DProxy_GetHistogram2DCache_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHistogram2DCache");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunction2DProxy *op = static_cast<vtkSMTransferFunction2DProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkImageData *tempr = (ap.IsBound() ?
      op->GetHistogram2DCache() :
      op->vtkSMTransferFunction2DProxy::GetHistogram2DCache());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMTransferFunction2DProxy_GetHistogram2DCache_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetHistogram2DCache");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    vtkImageData *tempr = vtkSMTransferFunction2DProxy::GetHistogram2DCache(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMTransferFunction2DProxy_GetHistogram2DCache(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkSMTransferFunction2DProxy_GetHistogram2DCache_s1(self, args);
    case 1:
      return PyvtkSMTransferFunction2DProxy_GetHistogram2DCache_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetHistogram2DCache");
  return nullptr;
}


static PyObject *
PyvtkSMTransferFunction2DProxy_GetRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunction2DProxy *op = static_cast<vtkSMTransferFunction2DProxy *>(vp);

  const size_t size0 = 4;
  double temp0[4];
  double save0[4];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    bool tempr = (ap.IsBound() ?
      op->GetRange(temp0) :
      op->vtkSMTransferFunction2DProxy::GetRange(temp0));

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMTransferFunction2DProxy_GetRange_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetRange");

  vtkSMProxy *temp0 = nullptr;
  const size_t size1 = 4;
  double temp1[4];
  double save1[4];
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1, size1))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    bool tempr = vtkSMTransferFunction2DProxy::GetRange(temp0, temp1);

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMTransferFunction2DProxy_GetRange(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 1:
      return PyvtkSMTransferFunction2DProxy_GetRange_s1(self, args);
    case 2:
      return PyvtkSMTransferFunction2DProxy_GetRange_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetRange");
  return nullptr;
}

static PyMethodDef PyvtkSMTransferFunction2DProxy_Methods[] = {
  {"IsTypeOf", PyvtkSMTransferFunction2DProxy_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMTransferFunction2DProxy_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMTransferFunction2DProxy_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMTransferFunction2DProxy\nC++: static vtkSMTransferFunction2DProxy *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMTransferFunction2DProxy_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMTransferFunction2DProxy\nC++: vtkSMTransferFunction2DProxy *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMTransferFunction2DProxy_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMTransferFunction2DProxy_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"RescaleTransferFunction", PyvtkSMTransferFunction2DProxy_RescaleTransferFunction, METH_VARARGS,
   "RescaleTransferFunction(self, range:(float, float, float, float),\n    extend:bool=False) -> bool\nC++: virtual bool RescaleTransferFunction(const double range[4],\n    bool extend=false)\nRescaleTransferFunction(self, rangeXMin:float, rangeXMax:float,\n    rangeYMin:float, rangeYMax:float, extend:bool=False) -> bool\nC++: virtual bool RescaleTransferFunction(double rangeXMin,\n    double rangeXMax, double rangeYMin, double rangeYMax,\n    bool extend=false)\nRescaleTransferFunction(proxy:vtkSMProxy, rangeXMin:float,\n    rangeXMax:float, rangeYMin:float, rangeYMax:float,\n    extend:bool=False) -> bool\nC++: static bool RescaleTransferFunction(vtkSMProxy *proxy,\n    double rangeXMin, double rangeXMax, double rangeYMin,\n    double rangeYMax, bool extend=false)\nRescaleTransferFunction(proxy:vtkSMProxy, range:(float, float,\n    float, float), extend:bool=False) -> bool\nC++: static bool RescaleTransferFunction(vtkSMProxy *proxy,\n    const double range[4], bool extend=false)\n\nRescale the control boxes for the 2D transfer function to match\nthe new range. Returns true if rescale was successful. If extend\nis true (false by default), the transfer function range will only\nbe extended as needed to fit the data range.\n"},
  {"RescaleTransferFunctionToDataRange", PyvtkSMTransferFunction2DProxy_RescaleTransferFunctionToDataRange, METH_VARARGS,
   "RescaleTransferFunctionToDataRange(self, extend:bool=False)\n    -> bool\nC++: virtual bool RescaleTransferFunctionToDataRange(\n    bool extend=false)\nRescaleTransferFunctionToDataRange(proxy:vtkSMProxy,\n    extend:bool=False) -> bool\nC++: static bool RescaleTransferFunctionToDataRange(\n    vtkSMProxy *proxy, bool extend=false)\n\nLocates all representations that are currently using this\ntransfer function and then rescales the transfer function scalar\nrange to exactly match the combined valid scalar ranges obtained\nfrom them all.\n"},
  {"ComputeDataRange", PyvtkSMTransferFunction2DProxy_ComputeDataRange, METH_VARARGS,
   "ComputeDataRange(self, range:[float, float, float, float]) -> bool\nC++: virtual bool ComputeDataRange(double range[4])\nComputeDataRange(proxy:vtkSMProxy, range:[float, float, float,\n    float]) -> bool\nC++: static bool ComputeDataRange(vtkSMProxy *proxy,\n    double range[4])\n\nHelper method used by RescaleTransferFunctionToDataRange() to\ncompute range from all visible representations using the transfer\nfunction. Returns true if a valid range was determined.\n"},
  {"ComputeDataHistogram2D", PyvtkSMTransferFunction2DProxy_ComputeDataHistogram2D, METH_VARARGS,
   "ComputeDataHistogram2D(self, numberOfBins:int) -> vtkImageData\nC++: virtual vtkSmartPointer<vtkImageData> ComputeDataHistogram2D(\n    int numberOfBins)\nComputeDataHistogram2D(proxy:vtkSMProxy, numberOfBins:int)\n    -> vtkImageData\nC++: static vtkSmartPointer<vtkImageData> ComputeDataHistogram2D(\n    vtkSMProxy *proxy, int numberOfBins)\n\nHelper method used to compute a 2D histogram image with provided\nnumber of bins based on the data from all the visible\nrepresentations using the transfer function. If successful,\nreturns the histogram as a vtkImageData of type double. If not,\nreturns nullptr.\n"},
  {"GetHistogram2DCache", PyvtkSMTransferFunction2DProxy_GetHistogram2DCache, METH_VARARGS,
   "GetHistogram2DCache(self) -> vtkImageData\nC++: virtual vtkImageData *GetHistogram2DCache()\nGetHistogram2DCache(proxy:vtkSMProxy) -> vtkImageData\nC++: static vtkImageData *GetHistogram2DCache(vtkSMProxy *proxy)\n\nHelper method used to recover the last histogram computed by\nComputeDataHistogram2D Returns the histogram as a vtkImageData if\navailable, nullptr otherwise.\n"},
  {"GetRange", PyvtkSMTransferFunction2DProxy_GetRange, METH_VARARGS,
   "GetRange(self, range:[float, float, float, float]) -> bool\nC++: virtual bool GetRange(double range[4])\nGetRange(proxy:vtkSMProxy, range:[float, float, float, float])\n    -> bool\nC++: static bool GetRange(vtkSMProxy *proxy, double range[4])\n\nReturns current transfer function data range. Returns false is a\nvalid range could not be determined.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMTransferFunction2DProxy_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("histogram2d_cache"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMTransferFunction2DProxy_GetHistogram2DCache(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetHistogram2DCache\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMTransferFunction2DProxy_Doc =
  "vtkSMTransferFunction2DProxy - vtkSMTransferFunction2DProxy is the\nproxy used for \"TransferFunction2D\".\n\n"
  "Superclass: vtkSMProxy\n\n"
  "vtkSMTransferFunction2DProxy provides the utility API to update 2D\n"
  "transfer function range, control boxes, etc.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMTransferFunction2DProxy_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSMTransferFunction2DProxy", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMTransferFunction2DProxy_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMTransferFunction2DProxy_StaticNew()
{
  return vtkSMTransferFunction2DProxy::New();
}

PyObject *PyvtkSMTransferFunction2DProxy_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMTransferFunction2DProxy_Type, PyvtkSMTransferFunction2DProxy_Methods,
    "vtkSMTransferFunction2DProxy",
 &PyvtkSMTransferFunction2DProxy_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkSMProxy");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  o = PyLong_FromLong(8);
  if (o)
  {
    PyDict_SetItemString(d, "BOX_PROPERTY_SIZE", o);
    Py_DECREF(o);
  }
  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMTransferFunction2DProxy_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMTransferFunction2DProxy(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMTransferFunction2DProxy_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMTransferFunction2DProxy", o) != 0)
  {
    Py_DECREF(o);
  }

}

