// python wrapper for vtkFileSeriesWriter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkFileSeriesWriter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkFileSeriesWriter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkFileSeriesWriter_ClassNew(); }


static PyObject *
PyvtkFileSeriesWriter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkFileSeriesWriter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkFileSeriesWriter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkFileSeriesWriter *tempr = vtkFileSeriesWriter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkFileSeriesWriter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkFileSeriesWriter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkFileSeriesWriter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkFileSeriesWriter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_SetWriter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWriter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  vtkAlgorithm *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAlgorithm"))
  {
    if (ap.IsBound())
    {
      op->SetWriter(temp0);
    }
    else
    {
      op->vtkFileSeriesWriter::SetWriter(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_GetWriter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWriter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAlgorithm *tempr = (ap.IsBound() ?
      op->GetWriter() :
      op->vtkFileSeriesWriter::GetWriter());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_GetMTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetMTime() :
      op->vtkFileSeriesWriter::GetMTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_SetFileNameMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileNameMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileNameMethod(temp0);
    }
    else
    {
      op->vtkFileSeriesWriter::SetFileNameMethod(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_GetFileNameMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileNameMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileNameMethod() :
      op->vtkFileSeriesWriter::GetFileNameMethod());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->vtkFileSeriesWriter::SetFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileName() :
      op->vtkFileSeriesWriter::GetFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_Write(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Write");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->Write() :
      op->vtkFileSeriesWriter::Write());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_GetWriteAllTimeSteps(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWriteAllTimeSteps");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetWriteAllTimeSteps() :
      op->vtkFileSeriesWriter::GetWriteAllTimeSteps());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_SetWriteAllTimeSteps(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWriteAllTimeSteps");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWriteAllTimeSteps(temp0);
    }
    else
    {
      op->vtkFileSeriesWriter::SetWriteAllTimeSteps(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_WriteAllTimeStepsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteAllTimeStepsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->WriteAllTimeStepsOn();
    }
    else
    {
      op->vtkFileSeriesWriter::WriteAllTimeStepsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_WriteAllTimeStepsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteAllTimeStepsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->WriteAllTimeStepsOff();
    }
    else
    {
      op->vtkFileSeriesWriter::WriteAllTimeStepsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_GetWriteJsonMetaFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWriteJsonMetaFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetWriteJsonMetaFile() :
      op->vtkFileSeriesWriter::GetWriteJsonMetaFile());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_SetWriteJsonMetaFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWriteJsonMetaFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWriteJsonMetaFile(temp0);
    }
    else
    {
      op->vtkFileSeriesWriter::SetWriteJsonMetaFile(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_WriteJsonMetaFileOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteJsonMetaFileOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->WriteJsonMetaFileOn();
    }
    else
    {
      op->vtkFileSeriesWriter::WriteJsonMetaFileOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_WriteJsonMetaFileOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteJsonMetaFileOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->WriteJsonMetaFileOff();
    }
    else
    {
      op->vtkFileSeriesWriter::WriteJsonMetaFileOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_GetFileNameSuffix(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileNameSuffix");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileNameSuffix() :
      op->vtkFileSeriesWriter::GetFileNameSuffix());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_SetFileNameSuffix(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileNameSuffix");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileNameSuffix(temp0);
    }
    else
    {
      op->vtkFileSeriesWriter::SetFileNameSuffix(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_GetMinTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMinTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMinTimeStep() :
      op->vtkFileSeriesWriter::GetMinTimeStep());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_SetMinTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMinTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMinTimeStep(temp0);
    }
    else
    {
      op->vtkFileSeriesWriter::SetMinTimeStep(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_GetMinTimeStepMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMinTimeStepMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMinTimeStepMinValue() :
      op->vtkFileSeriesWriter::GetMinTimeStepMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_GetMinTimeStepMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMinTimeStepMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMinTimeStepMaxValue() :
      op->vtkFileSeriesWriter::GetMinTimeStepMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_GetMaxTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaxTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMaxTimeStep() :
      op->vtkFileSeriesWriter::GetMaxTimeStep());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_SetMaxTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaxTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaxTimeStep(temp0);
    }
    else
    {
      op->vtkFileSeriesWriter::SetMaxTimeStep(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_GetTimeStepStride(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeStepStride");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTimeStepStride() :
      op->vtkFileSeriesWriter::GetTimeStepStride());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_SetTimeStepStride(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTimeStepStride");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTimeStepStride(temp0);
    }
    else
    {
      op->vtkFileSeriesWriter::SetTimeStepStride(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_GetTimeStepStrideMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeStepStrideMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTimeStepStrideMinValue() :
      op->vtkFileSeriesWriter::GetTimeStepStrideMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_GetTimeStepStrideMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeStepStrideMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTimeStepStrideMaxValue() :
      op->vtkFileSeriesWriter::GetTimeStepStrideMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_SetInterpreter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInterpreter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFileSeriesWriter *op = static_cast<vtkFileSeriesWriter *>(vp);

  vtkClientServerInterpreter *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkClientServerInterpreter"))
  {
    if (ap.IsBound())
    {
      op->SetInterpreter(temp0);
    }
    else
    {
      op->vtkFileSeriesWriter::SetInterpreter(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFileSeriesWriter_SuffixValidation(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SuffixValidation");

  size_t size0 = ap.GetStringSize(0);
  vtkPythonArgs::Array<char> store0(2*size0 + 1);
  char *temp0 = store0.Data();
  char *save0 = temp0 + size0 + 1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    bool tempr = vtkFileSeriesWriter::SuffixValidation(temp0);

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkFileSeriesWriter_Methods[] = {
  {"IsTypeOf", PyvtkFileSeriesWriter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkFileSeriesWriter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkFileSeriesWriter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkFileSeriesWriter\nC++: static vtkFileSeriesWriter *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkFileSeriesWriter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkFileSeriesWriter\nC++: vtkFileSeriesWriter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkFileSeriesWriter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkFileSeriesWriter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetWriter", PyvtkFileSeriesWriter_SetWriter, METH_VARARGS,
   "SetWriter(self, __a:vtkAlgorithm) -> None\nC++: virtual void SetWriter(vtkAlgorithm *)\n\nSet/get the internal writer.\n"},
  {"GetWriter", PyvtkFileSeriesWriter_GetWriter, METH_VARARGS,
   "GetWriter(self) -> vtkAlgorithm\nC++: virtual vtkAlgorithm *GetWriter()\n\n"},
  {"GetMTime", PyvtkFileSeriesWriter_GetMTime, METH_VARARGS,
   "GetMTime(self) -> int\nC++: vtkMTimeType GetMTime() override;\n\nReturn the MTime also considering the internal writer.\n"},
  {"SetFileNameMethod", PyvtkFileSeriesWriter_SetFileNameMethod, METH_VARARGS,
   "SetFileNameMethod(self, _arg:str) -> None\nC++: virtual void SetFileNameMethod(const char *_arg)\n\nName of the method used to set the file name of the internal\nwriter. By default, this is SetFileName.\n"},
  {"GetFileNameMethod", PyvtkFileSeriesWriter_GetFileNameMethod, METH_VARARGS,
   "GetFileNameMethod(self) -> str\nC++: virtual char *GetFileNameMethod()\n\n"},
  {"SetFileName", PyvtkFileSeriesWriter_SetFileName, METH_VARARGS,
   "SetFileName(self, _arg:str) -> None\nC++: virtual void SetFileName(const char *_arg)\n\nGet/Set the name of the output file.\n"},
  {"GetFileName", PyvtkFileSeriesWriter_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: virtual char *GetFileName()\n\n"},
  {"Write", PyvtkFileSeriesWriter_Write, METH_VARARGS,
   "Write(self) -> int\nC++: int Write()\n\nInvoke the writer.  Returns 1 for success, 0 for failure.\n"},
  {"GetWriteAllTimeSteps", PyvtkFileSeriesWriter_GetWriteAllTimeSteps, METH_VARARGS,
   "GetWriteAllTimeSteps(self) -> int\nC++: virtual int GetWriteAllTimeSteps()\n\nIf Off, which is the default, only the current timestep is\nwritten. If true the writer will write every timestep, or at\nleast those within the range of min to max.\n"},
  {"SetWriteAllTimeSteps", PyvtkFileSeriesWriter_SetWriteAllTimeSteps, METH_VARARGS,
   "SetWriteAllTimeSteps(self, _arg:int) -> None\nC++: virtual void SetWriteAllTimeSteps(int _arg)\n\n"},
  {"WriteAllTimeStepsOn", PyvtkFileSeriesWriter_WriteAllTimeStepsOn, METH_VARARGS,
   "WriteAllTimeStepsOn(self) -> None\nC++: virtual void WriteAllTimeStepsOn()\n\n"},
  {"WriteAllTimeStepsOff", PyvtkFileSeriesWriter_WriteAllTimeStepsOff, METH_VARARGS,
   "WriteAllTimeStepsOff(self) -> None\nC++: virtual void WriteAllTimeStepsOff()\n\n"},
  {"GetWriteJsonMetaFile", PyvtkFileSeriesWriter_GetWriteJsonMetaFile, METH_VARARGS,
   "GetWriteJsonMetaFile(self) -> bool\nC++: virtual bool GetWriteJsonMetaFile()\n\nIf true, write a .series json meta file when writing all time\nsteps. Default is false.\n"},
  {"SetWriteJsonMetaFile", PyvtkFileSeriesWriter_SetWriteJsonMetaFile, METH_VARARGS,
   "SetWriteJsonMetaFile(self, _arg:bool) -> None\nC++: virtual void SetWriteJsonMetaFile(bool _arg)\n\n"},
  {"WriteJsonMetaFileOn", PyvtkFileSeriesWriter_WriteJsonMetaFileOn, METH_VARARGS,
   "WriteJsonMetaFileOn(self) -> None\nC++: virtual void WriteJsonMetaFileOn()\n\n"},
  {"WriteJsonMetaFileOff", PyvtkFileSeriesWriter_WriteJsonMetaFileOff, METH_VARARGS,
   "WriteJsonMetaFileOff(self) -> None\nC++: virtual void WriteJsonMetaFileOff()\n\n"},
  {"GetFileNameSuffix", PyvtkFileSeriesWriter_GetFileNameSuffix, METH_VARARGS,
   "GetFileNameSuffix(self) -> str\nC++: virtual char *GetFileNameSuffix()\n\nProvides an option to pad the time step when writing out time\nseries data. Only allow this format: ABC%.Xd where ABC is an\narbitrary string which may or may not exist and d must exist and\nd must be the last character '.' and X may or may not exist, X\nmust be an integer if it exists. Default is nullptr.\n"},
  {"SetFileNameSuffix", PyvtkFileSeriesWriter_SetFileNameSuffix, METH_VARARGS,
   "SetFileNameSuffix(self, _arg:str) -> None\nC++: virtual void SetFileNameSuffix(const char *_arg)\n\n"},
  {"GetMinTimeStep", PyvtkFileSeriesWriter_GetMinTimeStep, METH_VARARGS,
   "GetMinTimeStep(self) -> int\nC++: virtual int GetMinTimeStep()\n\nSets a minimum timestep constraint on WriteAllTimeSteps.\n"},
  {"SetMinTimeStep", PyvtkFileSeriesWriter_SetMinTimeStep, METH_VARARGS,
   "SetMinTimeStep(self, _arg:int) -> None\nC++: virtual void SetMinTimeStep(int _arg)\n\n"},
  {"GetMinTimeStepMinValue", PyvtkFileSeriesWriter_GetMinTimeStepMinValue, METH_VARARGS,
   "GetMinTimeStepMinValue(self) -> int\nC++: virtual int GetMinTimeStepMinValue()\n\n"},
  {"GetMinTimeStepMaxValue", PyvtkFileSeriesWriter_GetMinTimeStepMaxValue, METH_VARARGS,
   "GetMinTimeStepMaxValue(self) -> int\nC++: virtual int GetMinTimeStepMaxValue()\n\n"},
  {"GetMaxTimeStep", PyvtkFileSeriesWriter_GetMaxTimeStep, METH_VARARGS,
   "GetMaxTimeStep(self) -> int\nC++: virtual int GetMaxTimeStep()\n\nSets a maximum timestep constraint on WriteAllTimeSteps. If less\nthan MinTimeStep, then the MaxTimeStep constraint is ignored\n(i.e. all time steps from MinTimeStep to the actual last time\nstep are written out).\n"},
  {"SetMaxTimeStep", PyvtkFileSeriesWriter_SetMaxTimeStep, METH_VARARGS,
   "SetMaxTimeStep(self, _arg:int) -> None\nC++: virtual void SetMaxTimeStep(int _arg)\n\n"},
  {"GetTimeStepStride", PyvtkFileSeriesWriter_GetTimeStepStride, METH_VARARGS,
   "GetTimeStepStride(self) -> int\nC++: virtual int GetTimeStepStride()\n\nSets a stride to write out time series.\n"},
  {"SetTimeStepStride", PyvtkFileSeriesWriter_SetTimeStepStride, METH_VARARGS,
   "SetTimeStepStride(self, _arg:int) -> None\nC++: virtual void SetTimeStepStride(int _arg)\n\n"},
  {"GetTimeStepStrideMinValue", PyvtkFileSeriesWriter_GetTimeStepStrideMinValue, METH_VARARGS,
   "GetTimeStepStrideMinValue(self) -> int\nC++: virtual int GetTimeStepStrideMinValue()\n\n"},
  {"GetTimeStepStrideMaxValue", PyvtkFileSeriesWriter_GetTimeStepStrideMaxValue, METH_VARARGS,
   "GetTimeStepStrideMaxValue(self) -> int\nC++: virtual int GetTimeStepStrideMaxValue()\n\n"},
  {"SetInterpreter", PyvtkFileSeriesWriter_SetInterpreter, METH_VARARGS,
   "SetInterpreter(self, interp:vtkClientServerInterpreter) -> None\nC++: void SetInterpreter(vtkClientServerInterpreter *interp)\n\nGet/Set the interpreter to use to call methods on the writer.\n"},
  {"SuffixValidation", PyvtkFileSeriesWriter_SuffixValidation, METH_VARARGS,
   "SuffixValidation(fileNameSuffix:str) -> bool\nC++: static bool SuffixValidation(char *fileNameSuffix)\n\nUtility function for validating the file name suffix.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkFileSeriesWriter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("writer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFileSeriesWriter_GetWriter(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFileSeriesWriter_SetWriter(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFileSeriesWriter_SetWriter(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWriter/SetWriter\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("file_name_method"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFileSeriesWriter_GetFileNameMethod(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFileSeriesWriter_SetFileNameMethod(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFileSeriesWriter_SetFileNameMethod(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileNameMethod/SetFileNameMethod\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFileSeriesWriter_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFileSeriesWriter_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFileSeriesWriter_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileName/SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("write_all_time_steps"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFileSeriesWriter_GetWriteAllTimeSteps(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFileSeriesWriter_SetWriteAllTimeSteps(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFileSeriesWriter_SetWriteAllTimeSteps(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWriteAllTimeSteps/SetWriteAllTimeSteps\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("write_json_meta_file"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFileSeriesWriter_GetWriteJsonMetaFile(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFileSeriesWriter_SetWriteJsonMetaFile(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFileSeriesWriter_SetWriteJsonMetaFile(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWriteJsonMetaFile/SetWriteJsonMetaFile\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("file_name_suffix"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFileSeriesWriter_GetFileNameSuffix(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFileSeriesWriter_SetFileNameSuffix(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFileSeriesWriter_SetFileNameSuffix(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileNameSuffix/SetFileNameSuffix\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("min_time_step"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFileSeriesWriter_GetMinTimeStep(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFileSeriesWriter_SetMinTimeStep(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFileSeriesWriter_SetMinTimeStep(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMinTimeStep/SetMinTimeStep\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("max_time_step"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFileSeriesWriter_GetMaxTimeStep(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFileSeriesWriter_SetMaxTimeStep(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFileSeriesWriter_SetMaxTimeStep(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaxTimeStep/SetMaxTimeStep\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time_step_stride"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFileSeriesWriter_GetTimeStepStride(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFileSeriesWriter_SetTimeStepStride(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFileSeriesWriter_SetTimeStepStride(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTimeStepStride/SetTimeStepStride\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interpreter"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFileSeriesWriter_SetInterpreter(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFileSeriesWriter_SetInterpreter(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInterpreter\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("m_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFileSeriesWriter_GetMTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMTime\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkFileSeriesWriter_Doc =
  "vtkFileSeriesWriter - meta-writer for writing a file series using\nwriters that are not time-aware.\n\n"
  "Superclass: vtkDataObjectAlgorithm\n\n"
  "vtkFileSeriesWriter is a meta-writer that enables writing a file\n"
  "series using writers that are not time-aware.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkFileSeriesWriter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsIOCore.vtkFileSeriesWriter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkFileSeriesWriter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkFileSeriesWriter_StaticNew()
{
  return vtkFileSeriesWriter::New();
}

PyObject *PyvtkFileSeriesWriter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkFileSeriesWriter_Type, PyvtkFileSeriesWriter_Methods,
    "vtkFileSeriesWriter",
 &PyvtkFileSeriesWriter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkDataObjectAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkFileSeriesWriter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkFileSeriesWriter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkFileSeriesWriter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkFileSeriesWriter", o) != 0)
  {
    Py_DECREF(o);
  }

}

