#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


    /* the C header of the library */
    #include <tss2/tss2_esys.h>
    #include <tss2/tss2_tcti.h>
    #include <tss2/tss2_tctildr.h>
    #include <tss2/tss2_rc.h>
    #include <tss2/tss2_mu.h>

    /*
     * Add the structure for the Python TCTI which is the TCTI structure and void *
     * for the pyobject representing the object instance. We add it here and to
     * prepare headers so CFFI knows about it (prepare_headers) and here so
     * C code knows about it.
     */
    typedef struct PYTCTI_CONTEXT PYTCTI_CONTEXT;
    struct PYTCTI_CONTEXT {
        TSS2_TCTI_CONTEXT_COMMON_V2 common;
        void *thiz;
    };
    #include <tss2/tss2_fapi.h>
    #include <tss2/tss2_policy.h>
    #include <tss2/tss2_tcti_spi_helper.h>

/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3849), // TSS2_TCTI_INFO const *()(void)
/*  1 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION, 10), // char const *()(TSS2_RC_INFO *)
/*  3 */ _CFFI_OP(_CFFI_OP_POINTER, 3841), // TSS2_RC_INFO *
/*  4 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  5 */ _CFFI_OP(_CFFI_OP_FUNCTION, 10), // char const *()(uint32_t)
/*  6 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22), // uint32_t
/*  7 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // char const *(*()(uint8_t, char const *, char const *(*)(uint32_t)))(uint32_t)
/*  9 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18), // uint8_t
/* 10 */ _CFFI_OP(_CFFI_OP_POINTER, 3855), // char const *
/* 11 */ _CFFI_OP(_CFFI_OP_POINTER, 5), // char const *(*)(uint32_t)
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 13 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT * *, TSS2_TCTI_CONTEXT *, TSS2_ABI_VERSION *)
/* 14 */ _CFFI_OP(_CFFI_OP_POINTER, 19), // ESYS_CONTEXT * *
/* 15 */ _CFFI_OP(_CFFI_OP_POINTER, 3844), // TSS2_TCTI_CONTEXT *
/* 16 */ _CFFI_OP(_CFFI_OP_POINTER, 3834), // TSS2_ABI_VERSION *
/* 17 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *)
/* 19 */ _CFFI_OP(_CFFI_OP_POINTER, 3687), // ESYS_CONTEXT *
/* 20 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 21 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, ESYS_CRYPTO_CALLBACKS *)
/* 22 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 23 */ _CFFI_OP(_CFFI_OP_POINTER, 3688), // ESYS_CRYPTO_CALLBACKS *
/* 24 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 25 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_ATTEST * *, TPMT_SIGNATURE * *)
/* 26 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 27 */ _CFFI_OP(_CFFI_OP_POINTER, 2890), // TPM2B_ATTEST * *
/* 28 */ _CFFI_OP(_CFFI_OP_POINTER, 2489), // TPMT_SIGNATURE * *
/* 29 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 30 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_DATA * *)
/* 31 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 32 */ _CFFI_OP(_CFFI_OP_POINTER, 2914), // TPM2B_DATA * *
/* 33 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 34 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_DATA * *, TPM2B_PRIVATE * *, TPM2B_ENCRYPTED_SECRET * *)
/* 35 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 36 */ _CFFI_OP(_CFFI_OP_NOOP, 32),
/* 37 */ _CFFI_OP(_CFFI_OP_POINTER, 2992), // TPM2B_PRIVATE * *
/* 38 */ _CFFI_OP(_CFFI_OP_POINTER, 2938), // TPM2B_ENCRYPTED_SECRET * *
/* 39 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 40 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_DIGEST * *)
/* 41 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 42 */ _CFFI_OP(_CFFI_OP_POINTER, 1948), // TPM2B_DIGEST * *
/* 43 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 44 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_DIGEST * *, TPMT_TK_AUTH * *)
/* 45 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 46 */ _CFFI_OP(_CFFI_OP_NOOP, 42),
/* 47 */ _CFFI_OP(_CFFI_OP_POINTER, 3466), // TPMT_TK_AUTH * *
/* 48 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 49 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_DIGEST * *, TPMT_TK_HASHCHECK * *)
/* 50 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 51 */ _CFFI_OP(_CFFI_OP_NOOP, 42),
/* 52 */ _CFFI_OP(_CFFI_OP_POINTER, 3478), // TPMT_TK_HASHCHECK * *
/* 53 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 54 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_ECC_POINT * *)
/* 55 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 56 */ _CFFI_OP(_CFFI_OP_POINTER, 2932), // TPM2B_ECC_POINT * *
/* 57 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 58 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_ECC_POINT * *, TPM2B_ECC_POINT * *)
/* 59 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 60 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 61 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 62 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 63 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_ECC_POINT * *, TPM2B_ECC_POINT * *, TPM2B_ECC_POINT * *, uint16_t *)
/* 64 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 65 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 66 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 67 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 68 */ _CFFI_OP(_CFFI_OP_POINTER, 205), // uint16_t *
/* 69 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 70 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_ECC_POINT * *, uint16_t *)
/* 71 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 72 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 73 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 74 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 75 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_ID_OBJECT * *, TPM2B_ENCRYPTED_SECRET * *)
/* 76 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 77 */ _CFFI_OP(_CFFI_OP_POINTER, 2950), // TPM2B_ID_OBJECT * *
/* 78 */ _CFFI_OP(_CFFI_OP_NOOP, 38),
/* 79 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 80 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_MAX_BUFFER * *)
/* 81 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 82 */ _CFFI_OP(_CFFI_OP_POINTER, 1455), // TPM2B_MAX_BUFFER * *
/* 83 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 84 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_MAX_BUFFER * *, TPM2B_DIGEST * *, TPMT_SIGNATURE * *)
/* 85 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 86 */ _CFFI_OP(_CFFI_OP_NOOP, 82),
/* 87 */ _CFFI_OP(_CFFI_OP_NOOP, 42),
/* 88 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 89 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 90 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_MAX_BUFFER * *, TPM2B_IV * *)
/* 91 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 92 */ _CFFI_OP(_CFFI_OP_NOOP, 82),
/* 93 */ _CFFI_OP(_CFFI_OP_POINTER, 2956), // TPM2B_IV * *
/* 94 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 95 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_MAX_BUFFER * *, uint32_t *)
/* 96 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 97 */ _CFFI_OP(_CFFI_OP_NOOP, 82),
/* 98 */ _CFFI_OP(_CFFI_OP_POINTER, 6), // uint32_t *
/* 99 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 100 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_MAX_NV_BUFFER * *)
/* 101 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 102 */ _CFFI_OP(_CFFI_OP_POINTER, 2974), // TPM2B_MAX_NV_BUFFER * *
/* 103 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 104 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_NV_PUBLIC * *, TPM2B_NAME * *)
/* 105 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 106 */ _CFFI_OP(_CFFI_OP_POINTER, 2986), // TPM2B_NV_PUBLIC * *
/* 107 */ _CFFI_OP(_CFFI_OP_POINTER, 347), // TPM2B_NAME * *
/* 108 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 109 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_PRIVATE * *)
/* 110 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 111 */ _CFFI_OP(_CFFI_OP_NOOP, 37),
/* 112 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 113 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_PRIVATE * *, TPM2B_ENCRYPTED_SECRET * *)
/* 114 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 115 */ _CFFI_OP(_CFFI_OP_NOOP, 37),
/* 116 */ _CFFI_OP(_CFFI_OP_NOOP, 38),
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 118 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_PRIVATE * *, TPM2B_PUBLIC * *, TPM2B_CREATION_DATA * *, TPM2B_DIGEST * *, TPMT_TK_CREATION * *)
/* 119 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 120 */ _CFFI_OP(_CFFI_OP_NOOP, 37),
/* 121 */ _CFFI_OP(_CFFI_OP_POINTER, 2053), // TPM2B_PUBLIC * *
/* 122 */ _CFFI_OP(_CFFI_OP_POINTER, 2908), // TPM2B_CREATION_DATA * *
/* 123 */ _CFFI_OP(_CFFI_OP_NOOP, 42),
/* 124 */ _CFFI_OP(_CFFI_OP_POINTER, 3472), // TPMT_TK_CREATION * *
/* 125 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 126 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_PUBLIC * *, TPM2B_NAME * *, TPM2B_NAME * *)
/* 127 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 128 */ _CFFI_OP(_CFFI_OP_NOOP, 121),
/* 129 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 130 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 131 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 132 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_PUBLIC_KEY_RSA * *)
/* 133 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 134 */ _CFFI_OP(_CFFI_OP_POINTER, 3010), // TPM2B_PUBLIC_KEY_RSA * *
/* 135 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 136 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPM2B_SENSITIVE_DATA * *)
/* 137 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 138 */ _CFFI_OP(_CFFI_OP_POINTER, 3028), // TPM2B_SENSITIVE_DATA * *
/* 139 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 140 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPML_ALG * *)
/* 141 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 142 */ _CFFI_OP(_CFFI_OP_POINTER, 3058), // TPML_ALG * *
/* 143 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 144 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPML_DIGEST_VALUES * *)
/* 145 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 146 */ _CFFI_OP(_CFFI_OP_POINTER, 3088), // TPML_DIGEST_VALUES * *
/* 147 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 148 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPMS_AC_OUTPUT * *)
/* 149 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 150 */ _CFFI_OP(_CFFI_OP_POINTER, 3142), // TPMS_AC_OUTPUT * *
/* 151 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 152 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPMS_ALGORITHM_DETAIL_ECC * *)
/* 153 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 154 */ _CFFI_OP(_CFFI_OP_POINTER, 3148), // TPMS_ALGORITHM_DETAIL_ECC * *
/* 155 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 156 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPMS_CONTEXT * *)
/* 157 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 158 */ _CFFI_OP(_CFFI_OP_POINTER, 3202), // TPMS_CONTEXT * *
/* 159 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 160 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPMS_CONTEXT const *)
/* 161 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 162 */ _CFFI_OP(_CFFI_OP_POINTER, 3757), // TPMS_CONTEXT const *
/* 163 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 164 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPMS_CONTEXT const *, uint32_t *)
/* 165 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 166 */ _CFFI_OP(_CFFI_OP_NOOP, 162),
/* 167 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 168 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 169 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPMS_TIME_INFO * *)
/* 170 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 171 */ _CFFI_OP(_CFFI_OP_POINTER, 3376), // TPMS_TIME_INFO * *
/* 172 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 173 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPMT_HA * *, TPMT_HA * *)
/* 174 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 175 */ _CFFI_OP(_CFFI_OP_POINTER, 3394), // TPMT_HA * *
/* 176 */ _CFFI_OP(_CFFI_OP_NOOP, 175),
/* 177 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 178 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPMT_SIGNATURE * *)
/* 179 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 180 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 181 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 182 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TPMT_TK_VERIFIED * *)
/* 183 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 184 */ _CFFI_OP(_CFFI_OP_POINTER, 3484), // TPMT_TK_VERIFIED * *
/* 185 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 186 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TSS2_SYS_CONTEXT * *)
/* 187 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 188 */ _CFFI_OP(_CFFI_OP_POINTER, 3842), // TSS2_SYS_CONTEXT * *
/* 189 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 190 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TSS2_TCTI_CONTEXT * *)
/* 191 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 192 */ _CFFI_OP(_CFFI_OP_POINTER, 15), // TSS2_TCTI_CONTEXT * *
/* 193 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 194 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, TSS2_TCTI_POLL_HANDLE * *, size_t *)
/* 195 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 196 */ _CFFI_OP(_CFFI_OP_POINTER, 2718), // TSS2_TCTI_POLL_HANDLE * *
/* 197 */ _CFFI_OP(_CFFI_OP_POINTER, 1612), // size_t *
/* 198 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 199 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, int32_t)
/* 200 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 201 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21), // int32_t
/* 202 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 203 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint16_t)
/* 204 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 205 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20), // uint16_t
/* 206 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 207 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t *)
/* 208 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 209 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 210 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 211 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t *, TPM2B_PRIVATE * *, TPM2B_PUBLIC * *)
/* 212 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 213 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 214 */ _CFFI_OP(_CFFI_OP_NOOP, 37),
/* 215 */ _CFFI_OP(_CFFI_OP_NOOP, 121),
/* 216 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 217 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t *, TPM2B_PUBLIC * *, TPM2B_CREATION_DATA * *, TPM2B_DIGEST * *, TPMT_TK_CREATION * *)
/* 218 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 219 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 220 */ _CFFI_OP(_CFFI_OP_NOOP, 121),
/* 221 */ _CFFI_OP(_CFFI_OP_NOOP, 122),
/* 222 */ _CFFI_OP(_CFFI_OP_NOOP, 42),
/* 223 */ _CFFI_OP(_CFFI_OP_NOOP, 124),
/* 224 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 225 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t *, TPML_PCR_SELECTION * *, TPML_DIGEST * *)
/* 226 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 227 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 228 */ _CFFI_OP(_CFFI_OP_POINTER, 2709), // TPML_PCR_SELECTION * *
/* 229 */ _CFFI_OP(_CFFI_OP_POINTER, 2710), // TPML_DIGEST * *
/* 230 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 231 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t)
/* 232 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 233 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 234 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 235 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, TPM2B_DIGEST * *)
/* 236 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 237 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 238 */ _CFFI_OP(_CFFI_OP_NOOP, 42),
/* 239 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 240 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, TPM2B_DIGEST const *)
/* 241 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 242 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 243 */ _CFFI_OP(_CFFI_OP_POINTER, 3698), // TPM2B_DIGEST const *
/* 244 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 245 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, TPM2B_NAME * *)
/* 246 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 247 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 248 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 249 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 250 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, TPMS_CONTEXT * *)
/* 251 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 252 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 253 */ _CFFI_OP(_CFFI_OP_NOOP, 158),
/* 254 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 255 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t *)
/* 256 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 257 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 258 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 259 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 260 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t)
/* 261 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 262 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 263 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 264 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 265 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 266 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, TPM2B_DATA const *)
/* 267 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 268 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 269 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 270 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 271 */ _CFFI_OP(_CFFI_OP_POINTER, 3696), // TPM2B_DATA const *
/* 272 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 273 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, TPM2B_DATA const *, TPM2B_DATA * *)
/* 274 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 275 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 276 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 277 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 278 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 279 */ _CFFI_OP(_CFFI_OP_NOOP, 32),
/* 280 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 281 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, uint16_t)
/* 282 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 283 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 284 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 285 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 286 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 287 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 288 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 289 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, uint16_t, uint32_t *)
/* 290 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 291 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 292 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 293 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 294 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 295 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 296 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 297 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 298 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, TPM2B_MAX_BUFFER * *, uint32_t *)
/* 299 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 300 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 301 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 302 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 303 */ _CFFI_OP(_CFFI_OP_NOOP, 82),
/* 304 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 305 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 306 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, TPM2B_MAX_BUFFER const *)
/* 307 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 308 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 309 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 310 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 311 */ _CFFI_OP(_CFFI_OP_POINTER, 3708), // TPM2B_MAX_BUFFER const *
/* 312 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 313 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, TPM2B_MAX_BUFFER const *, TPMT_HA * *, TPMT_HA * *)
/* 314 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 315 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 316 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 317 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 318 */ _CFFI_OP(_CFFI_OP_NOOP, 311),
/* 319 */ _CFFI_OP(_CFFI_OP_NOOP, 175),
/* 320 */ _CFFI_OP(_CFFI_OP_NOOP, 175),
/* 321 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 322 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, TPM2B_MAX_BUFFER const *, uint16_t, uint32_t)
/* 323 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 324 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 325 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 326 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 327 */ _CFFI_OP(_CFFI_OP_NOOP, 311),
/* 328 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 329 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 330 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 331 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, TPM2B_MAX_BUFFER const *, uint16_t, uint32_t, TPM2B_DIGEST * *, TPMT_TK_HASHCHECK * *)
/* 332 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 333 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 334 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 335 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 336 */ _CFFI_OP(_CFFI_OP_NOOP, 311),
/* 337 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 338 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 339 */ _CFFI_OP(_CFFI_OP_NOOP, 42),
/* 340 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 341 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 342 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, TPM2B_NAME *, TPM2B_NAME *, TPM2B_NAME *, uint8_t)
/* 343 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 344 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 345 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 346 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 347 */ _CFFI_OP(_CFFI_OP_POINTER, 3711), // TPM2B_NAME *
/* 348 */ _CFFI_OP(_CFFI_OP_NOOP, 347),
/* 349 */ _CFFI_OP(_CFFI_OP_NOOP, 347),
/* 350 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18),
/* 351 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 352 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, TPM2B_SENSITIVE const *, TPM2B_PUBLIC const *, uint32_t)
/* 353 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 354 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 355 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 356 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 357 */ _CFFI_OP(_CFFI_OP_POINTER, 3718), // TPM2B_SENSITIVE const *
/* 358 */ _CFFI_OP(_CFFI_OP_POINTER, 3716), // TPM2B_PUBLIC const *
/* 359 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 360 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 361 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, TPM2B_SENSITIVE const *, TPM2B_PUBLIC const *, uint32_t, uint32_t *)
/* 362 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 363 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 364 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 365 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 366 */ _CFFI_OP(_CFFI_OP_NOOP, 357),
/* 367 */ _CFFI_OP(_CFFI_OP_NOOP, 358),
/* 368 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 369 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 370 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 371 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, TPM2B_SENSITIVE_DATA const *)
/* 372 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 373 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 374 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 375 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 376 */ _CFFI_OP(_CFFI_OP_POINTER, 3720), // TPM2B_SENSITIVE_DATA const *
/* 377 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 378 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, TPML_ALG const *)
/* 379 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 380 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 381 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 382 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 383 */ _CFFI_OP(_CFFI_OP_POINTER, 3725), // TPML_ALG const *
/* 384 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 385 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, TPML_ALG const *, TPML_ALG * *)
/* 386 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 387 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 388 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 389 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 390 */ _CFFI_OP(_CFFI_OP_NOOP, 383),
/* 391 */ _CFFI_OP(_CFFI_OP_NOOP, 142),
/* 392 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 393 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, TPML_PCR_SELECTION const *)
/* 394 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 395 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 396 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 397 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 398 */ _CFFI_OP(_CFFI_OP_POINTER, 3735), // TPML_PCR_SELECTION const *
/* 399 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 400 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, TPML_PCR_SELECTION const *, uint32_t *, TPML_PCR_SELECTION * *, TPML_DIGEST * *)
/* 401 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 402 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 403 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 404 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 405 */ _CFFI_OP(_CFFI_OP_NOOP, 398),
/* 406 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 407 */ _CFFI_OP(_CFFI_OP_NOOP, 228),
/* 408 */ _CFFI_OP(_CFFI_OP_NOOP, 229),
/* 409 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 410 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, TPMS_TIME_INFO * *)
/* 411 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 412 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 413 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 414 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 415 */ _CFFI_OP(_CFFI_OP_NOOP, 171),
/* 416 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 417 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, TPMT_PUBLIC_PARMS const *)
/* 418 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 419 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 420 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 421 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 422 */ _CFFI_OP(_CFFI_OP_POINTER, 3806), // TPMT_PUBLIC_PARMS const *
/* 423 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 424 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint16_t)
/* 425 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 426 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 427 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 428 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 429 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 430 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 431 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint16_t, TPM2B_DIGEST * *)
/* 432 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 433 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 434 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 435 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 436 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 437 */ _CFFI_OP(_CFFI_OP_NOOP, 42),
/* 438 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 439 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint16_t, TPM2B_ECC_POINT * *, uint16_t *)
/* 440 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 441 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 442 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 443 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 444 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 445 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 446 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 447 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 448 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint16_t, TPMS_ALGORITHM_DETAIL_ECC * *)
/* 449 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 450 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 451 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 452 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 453 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 454 */ _CFFI_OP(_CFFI_OP_NOOP, 154),
/* 455 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 456 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t)
/* 457 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 458 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 459 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 460 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 461 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 462 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 463 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DATA const *, TPM2B_PUBLIC const *, TPM2B_PRIVATE const *, TPM2B_ENCRYPTED_SECRET const *, TPMT_SYM_DEF_OBJECT const *)
/* 464 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 465 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 466 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 467 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 468 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 469 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 470 */ _CFFI_OP(_CFFI_OP_NOOP, 358),
/* 471 */ _CFFI_OP(_CFFI_OP_POINTER, 3713), // TPM2B_PRIVATE const *
/* 472 */ _CFFI_OP(_CFFI_OP_POINTER, 3703), // TPM2B_ENCRYPTED_SECRET const *
/* 473 */ _CFFI_OP(_CFFI_OP_POINTER, 3813), // TPMT_SYM_DEF_OBJECT const *
/* 474 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 475 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DATA const *, TPM2B_PUBLIC const *, TPM2B_PRIVATE const *, TPM2B_ENCRYPTED_SECRET const *, TPMT_SYM_DEF_OBJECT const *, TPM2B_PRIVATE * *)
/* 476 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 477 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 478 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 479 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 480 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 481 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 482 */ _CFFI_OP(_CFFI_OP_NOOP, 358),
/* 483 */ _CFFI_OP(_CFFI_OP_NOOP, 471),
/* 484 */ _CFFI_OP(_CFFI_OP_NOOP, 472),
/* 485 */ _CFFI_OP(_CFFI_OP_NOOP, 473),
/* 486 */ _CFFI_OP(_CFFI_OP_NOOP, 37),
/* 487 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 488 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DATA const *, TPMT_SIG_SCHEME const *, TPML_PCR_SELECTION const *)
/* 489 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 490 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 491 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 492 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 493 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 494 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 495 */ _CFFI_OP(_CFFI_OP_POINTER, 3811), // TPMT_SIG_SCHEME const *
/* 496 */ _CFFI_OP(_CFFI_OP_NOOP, 398),
/* 497 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 498 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DATA const *, TPMT_SIG_SCHEME const *, TPML_PCR_SELECTION const *, TPM2B_ATTEST * *, TPMT_SIGNATURE * *)
/* 499 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 500 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 501 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 502 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 503 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 504 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 505 */ _CFFI_OP(_CFFI_OP_NOOP, 495),
/* 506 */ _CFFI_OP(_CFFI_OP_NOOP, 398),
/* 507 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 508 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 509 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 510 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST * *)
/* 511 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 512 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 513 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 514 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 515 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 516 */ _CFFI_OP(_CFFI_OP_NOOP, 42),
/* 517 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 518 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *)
/* 519 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 520 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 521 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 522 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 523 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 524 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 525 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 526 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, TPM2B_DIGEST const *, TPM2B_DIGEST const *, TPM2B_NAME const *, TPMT_TK_AUTH const *)
/* 527 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 528 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 529 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 530 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 531 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 532 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 533 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 534 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 535 */ _CFFI_OP(_CFFI_OP_POINTER, 3711), // TPM2B_NAME const *
/* 536 */ _CFFI_OP(_CFFI_OP_POINTER, 3814), // TPMT_TK_AUTH const *
/* 537 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 538 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, TPM2B_DIGEST const *, TPM2B_NAME const *, TPMT_TK_VERIFIED const *)
/* 539 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 540 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 541 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 542 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 543 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 544 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 545 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 546 */ _CFFI_OP(_CFFI_OP_NOOP, 535),
/* 547 */ _CFFI_OP(_CFFI_OP_POINTER, 3817), // TPMT_TK_VERIFIED const *
/* 548 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 549 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, TPM2B_NAME const *)
/* 550 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 551 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 552 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 553 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 554 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 555 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 556 */ _CFFI_OP(_CFFI_OP_NOOP, 535),
/* 557 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 558 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, TPM2B_NAME const *, TPM2B_ID_OBJECT * *, TPM2B_ENCRYPTED_SECRET * *)
/* 559 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 560 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 561 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 562 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 563 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 564 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 565 */ _CFFI_OP(_CFFI_OP_NOOP, 535),
/* 566 */ _CFFI_OP(_CFFI_OP_NOOP, 77),
/* 567 */ _CFFI_OP(_CFFI_OP_NOOP, 38),
/* 568 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 569 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, TPM2B_NV_PUBLIC const *)
/* 570 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 571 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 572 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 573 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 574 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 575 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 576 */ _CFFI_OP(_CFFI_OP_POINTER, 3712), // TPM2B_NV_PUBLIC const *
/* 577 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 578 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, TPM2B_NV_PUBLIC const *, uint32_t *)
/* 579 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 580 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 581 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 582 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 583 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 584 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 585 */ _CFFI_OP(_CFFI_OP_NOOP, 576),
/* 586 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 587 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 588 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, TPML_PCR_SELECTION const *)
/* 589 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 590 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 591 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 592 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 593 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 594 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 595 */ _CFFI_OP(_CFFI_OP_NOOP, 398),
/* 596 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 597 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, TPMT_SIGNATURE const *)
/* 598 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 599 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 600 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 601 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 602 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 603 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 604 */ _CFFI_OP(_CFFI_OP_POINTER, 3810), // TPMT_SIGNATURE const *
/* 605 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 606 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, TPMT_SIGNATURE const *, TPMT_TK_VERIFIED * *)
/* 607 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 608 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 609 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 610 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 611 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 612 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 613 */ _CFFI_OP(_CFFI_OP_NOOP, 604),
/* 614 */ _CFFI_OP(_CFFI_OP_NOOP, 184),
/* 615 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 616 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, TPMT_SIG_SCHEME const *, TPMT_TK_HASHCHECK const *)
/* 617 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 618 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 619 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 620 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 621 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 622 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 623 */ _CFFI_OP(_CFFI_OP_NOOP, 495),
/* 624 */ _CFFI_OP(_CFFI_OP_POINTER, 3816), // TPMT_TK_HASHCHECK const *
/* 625 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 626 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, TPMT_SIG_SCHEME const *, TPMT_TK_HASHCHECK const *, TPMT_SIGNATURE * *)
/* 627 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 628 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 629 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 630 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 631 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 632 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 633 */ _CFFI_OP(_CFFI_OP_NOOP, 495),
/* 634 */ _CFFI_OP(_CFFI_OP_NOOP, 624),
/* 635 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 636 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 637 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, uint16_t)
/* 638 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 639 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 640 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 641 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 642 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 643 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 644 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 645 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 646 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, uint16_t, uint16_t)
/* 647 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 648 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 649 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 650 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 651 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 652 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 653 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 654 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 655 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 656 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, uint16_t, uint32_t *)
/* 657 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 658 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 659 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 660 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 661 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 662 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 663 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 664 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 665 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 666 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, uint16_t, uint32_t)
/* 667 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 668 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 669 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 670 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 671 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 672 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 673 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 674 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 675 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 676 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_ECC_POINT * *, TPM2B_ECC_POINT * *)
/* 677 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 678 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 679 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 680 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 681 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 682 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 683 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 684 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 685 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_ECC_POINT const *)
/* 686 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 687 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 688 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 689 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 690 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 691 */ _CFFI_OP(_CFFI_OP_POINTER, 3702), // TPM2B_ECC_POINT const *
/* 692 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 693 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_ECC_POINT const *, TPM2B_ECC_POINT * *)
/* 694 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 695 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 696 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 697 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 698 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 699 */ _CFFI_OP(_CFFI_OP_NOOP, 691),
/* 700 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 701 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 702 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_ECC_POINT const *, TPM2B_ECC_POINT const *, uint16_t, uint16_t)
/* 703 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 704 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 705 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 706 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 707 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 708 */ _CFFI_OP(_CFFI_OP_NOOP, 691),
/* 709 */ _CFFI_OP(_CFFI_OP_NOOP, 691),
/* 710 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 711 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 712 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 713 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_ECC_POINT const *, TPM2B_ECC_POINT const *, uint16_t, uint16_t, TPM2B_ECC_POINT * *, TPM2B_ECC_POINT * *)
/* 714 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 715 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 716 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 717 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 718 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 719 */ _CFFI_OP(_CFFI_OP_NOOP, 691),
/* 720 */ _CFFI_OP(_CFFI_OP_NOOP, 691),
/* 721 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 722 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 723 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 724 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 725 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 726 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_ECC_POINT const *, TPM2B_SENSITIVE_DATA const *, TPM2B_ECC_PARAMETER const *)
/* 727 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 728 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 729 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 730 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 731 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 732 */ _CFFI_OP(_CFFI_OP_NOOP, 691),
/* 733 */ _CFFI_OP(_CFFI_OP_NOOP, 376),
/* 734 */ _CFFI_OP(_CFFI_OP_POINTER, 3701), // TPM2B_ECC_PARAMETER const *
/* 735 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 736 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_ECC_POINT const *, TPM2B_SENSITIVE_DATA const *, TPM2B_ECC_PARAMETER const *, TPM2B_ECC_POINT * *, TPM2B_ECC_POINT * *, TPM2B_ECC_POINT * *, uint16_t *)
/* 737 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 738 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 739 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 740 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 741 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 742 */ _CFFI_OP(_CFFI_OP_NOOP, 691),
/* 743 */ _CFFI_OP(_CFFI_OP_NOOP, 376),
/* 744 */ _CFFI_OP(_CFFI_OP_NOOP, 734),
/* 745 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 746 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 747 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 748 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 749 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 750 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_EVENT const *)
/* 751 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 752 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 753 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 754 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 755 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 756 */ _CFFI_OP(_CFFI_OP_POINTER, 3704), // TPM2B_EVENT const *
/* 757 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 758 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_EVENT const *, TPML_DIGEST_VALUES * *)
/* 759 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 760 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 761 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 762 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 763 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 764 */ _CFFI_OP(_CFFI_OP_NOOP, 756),
/* 765 */ _CFFI_OP(_CFFI_OP_NOOP, 146),
/* 766 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 767 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_MAX_BUFFER * *)
/* 768 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 769 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 770 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 771 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 772 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 773 */ _CFFI_OP(_CFFI_OP_NOOP, 82),
/* 774 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 775 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_MAX_BUFFER const *)
/* 776 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 777 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 778 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 779 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 780 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 781 */ _CFFI_OP(_CFFI_OP_NOOP, 311),
/* 782 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 783 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_MAX_BUFFER const *, uint16_t)
/* 784 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 785 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 786 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 787 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 788 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 789 */ _CFFI_OP(_CFFI_OP_NOOP, 311),
/* 790 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 791 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 792 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_MAX_BUFFER const *, uint16_t, TPM2B_DIGEST * *)
/* 793 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 794 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 795 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 796 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 797 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 798 */ _CFFI_OP(_CFFI_OP_NOOP, 311),
/* 799 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 800 */ _CFFI_OP(_CFFI_OP_NOOP, 42),
/* 801 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 802 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_MAX_BUFFER const *, uint32_t)
/* 803 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 804 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 805 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 806 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 807 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 808 */ _CFFI_OP(_CFFI_OP_NOOP, 311),
/* 809 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 810 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 811 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_MAX_BUFFER const *, uint32_t, TPM2B_DIGEST * *, TPMT_TK_HASHCHECK * *)
/* 812 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 813 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 814 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 815 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 816 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 817 */ _CFFI_OP(_CFFI_OP_NOOP, 311),
/* 818 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 819 */ _CFFI_OP(_CFFI_OP_NOOP, 42),
/* 820 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 821 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 822 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_MAX_BUFFER const *, uint8_t, uint16_t, TPM2B_IV const *)
/* 823 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 824 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 825 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 826 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 827 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 828 */ _CFFI_OP(_CFFI_OP_NOOP, 311),
/* 829 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18),
/* 830 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 831 */ _CFFI_OP(_CFFI_OP_POINTER, 3706), // TPM2B_IV const *
/* 832 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 833 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_MAX_BUFFER const *, uint8_t, uint16_t, TPM2B_IV const *, TPM2B_MAX_BUFFER * *, TPM2B_IV * *)
/* 834 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 835 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 836 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 837 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 838 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 839 */ _CFFI_OP(_CFFI_OP_NOOP, 311),
/* 840 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18),
/* 841 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 842 */ _CFFI_OP(_CFFI_OP_NOOP, 831),
/* 843 */ _CFFI_OP(_CFFI_OP_NOOP, 82),
/* 844 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 845 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 846 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_NAME const *, TPM2B_NAME const *, uint8_t)
/* 847 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 848 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 849 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 850 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 851 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 852 */ _CFFI_OP(_CFFI_OP_NOOP, 535),
/* 853 */ _CFFI_OP(_CFFI_OP_NOOP, 535),
/* 854 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18),
/* 855 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 856 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_NV_PUBLIC * *, TPM2B_NAME * *)
/* 857 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 858 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 859 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 860 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 861 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 862 */ _CFFI_OP(_CFFI_OP_NOOP, 106),
/* 863 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 864 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 865 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_PRIVATE const *, TPM2B_PUBLIC const *)
/* 866 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 867 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 868 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 869 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 870 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 871 */ _CFFI_OP(_CFFI_OP_NOOP, 471),
/* 872 */ _CFFI_OP(_CFFI_OP_NOOP, 358),
/* 873 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 874 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_PRIVATE const *, TPM2B_PUBLIC const *, uint32_t *)
/* 875 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 876 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 877 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 878 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 879 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 880 */ _CFFI_OP(_CFFI_OP_NOOP, 471),
/* 881 */ _CFFI_OP(_CFFI_OP_NOOP, 358),
/* 882 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 883 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 884 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_PUBLIC * *, TPM2B_NAME * *, TPM2B_NAME * *)
/* 885 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 886 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 887 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 888 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 889 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 890 */ _CFFI_OP(_CFFI_OP_NOOP, 121),
/* 891 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 892 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 893 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 894 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_PUBLIC_KEY_RSA const *, TPMT_RSA_DECRYPT const *, TPM2B_DATA const *)
/* 895 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 896 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 897 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 898 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 899 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 900 */ _CFFI_OP(_CFFI_OP_POINTER, 3717), // TPM2B_PUBLIC_KEY_RSA const *
/* 901 */ _CFFI_OP(_CFFI_OP_POINTER, 3807), // TPMT_RSA_DECRYPT const *
/* 902 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 903 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 904 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_PUBLIC_KEY_RSA const *, TPMT_RSA_DECRYPT const *, TPM2B_DATA const *, TPM2B_PUBLIC_KEY_RSA * *)
/* 905 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 906 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 907 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 908 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 909 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 910 */ _CFFI_OP(_CFFI_OP_NOOP, 900),
/* 911 */ _CFFI_OP(_CFFI_OP_NOOP, 901),
/* 912 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 913 */ _CFFI_OP(_CFFI_OP_NOOP, 134),
/* 914 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 915 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_SENSITIVE_CREATE const *, TPM2B_PUBLIC const *, TPM2B_DATA const *, TPML_PCR_SELECTION const *)
/* 916 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 917 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 918 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 919 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 920 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 921 */ _CFFI_OP(_CFFI_OP_POINTER, 3719), // TPM2B_SENSITIVE_CREATE const *
/* 922 */ _CFFI_OP(_CFFI_OP_NOOP, 358),
/* 923 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 924 */ _CFFI_OP(_CFFI_OP_NOOP, 398),
/* 925 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 926 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_SENSITIVE_CREATE const *, TPM2B_PUBLIC const *, TPM2B_DATA const *, TPML_PCR_SELECTION const *, TPM2B_PRIVATE * *, TPM2B_PUBLIC * *, TPM2B_CREATION_DATA * *, TPM2B_DIGEST * *, TPMT_TK_CREATION * *)
/* 927 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 928 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 929 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 930 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 931 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 932 */ _CFFI_OP(_CFFI_OP_NOOP, 921),
/* 933 */ _CFFI_OP(_CFFI_OP_NOOP, 358),
/* 934 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 935 */ _CFFI_OP(_CFFI_OP_NOOP, 398),
/* 936 */ _CFFI_OP(_CFFI_OP_NOOP, 37),
/* 937 */ _CFFI_OP(_CFFI_OP_NOOP, 121),
/* 938 */ _CFFI_OP(_CFFI_OP_NOOP, 122),
/* 939 */ _CFFI_OP(_CFFI_OP_NOOP, 42),
/* 940 */ _CFFI_OP(_CFFI_OP_NOOP, 124),
/* 941 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 942 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_SENSITIVE_CREATE const *, TPM2B_PUBLIC const *, TPM2B_DATA const *, TPML_PCR_SELECTION const *, uint32_t *, TPM2B_PUBLIC * *, TPM2B_CREATION_DATA * *, TPM2B_DIGEST * *, TPMT_TK_CREATION * *)
/* 943 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 944 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 945 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 946 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 947 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 948 */ _CFFI_OP(_CFFI_OP_NOOP, 921),
/* 949 */ _CFFI_OP(_CFFI_OP_NOOP, 358),
/* 950 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 951 */ _CFFI_OP(_CFFI_OP_NOOP, 398),
/* 952 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 953 */ _CFFI_OP(_CFFI_OP_NOOP, 121),
/* 954 */ _CFFI_OP(_CFFI_OP_NOOP, 122),
/* 955 */ _CFFI_OP(_CFFI_OP_NOOP, 42),
/* 956 */ _CFFI_OP(_CFFI_OP_NOOP, 124),
/* 957 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 958 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_SENSITIVE_CREATE const *, TPM2B_TEMPLATE const *)
/* 959 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 960 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 961 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 962 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 963 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 964 */ _CFFI_OP(_CFFI_OP_NOOP, 921),
/* 965 */ _CFFI_OP(_CFFI_OP_POINTER, 3722), // TPM2B_TEMPLATE const *
/* 966 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 967 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_SENSITIVE_CREATE const *, TPM2B_TEMPLATE const *, uint32_t *, TPM2B_PRIVATE * *, TPM2B_PUBLIC * *)
/* 968 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 969 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 970 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 971 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 972 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 973 */ _CFFI_OP(_CFFI_OP_NOOP, 921),
/* 974 */ _CFFI_OP(_CFFI_OP_NOOP, 965),
/* 975 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 976 */ _CFFI_OP(_CFFI_OP_NOOP, 37),
/* 977 */ _CFFI_OP(_CFFI_OP_NOOP, 121),
/* 978 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 979 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_SENSITIVE_DATA * *)
/* 980 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 981 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 982 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 983 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 984 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 985 */ _CFFI_OP(_CFFI_OP_NOOP, 138),
/* 986 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 987 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPML_CC const *, TPML_CC const *)
/* 988 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 989 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 990 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 991 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 992 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 993 */ _CFFI_OP(_CFFI_OP_POINTER, 3727), // TPML_CC const *
/* 994 */ _CFFI_OP(_CFFI_OP_NOOP, 993),
/* 995 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 996 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPML_DIGEST const *)
/* 997 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 998 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 999 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1000 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1001 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1002 */ _CFFI_OP(_CFFI_OP_POINTER, 3729), // TPML_DIGEST const *
/* 1003 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1004 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPML_DIGEST_VALUES const *)
/* 1005 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1006 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1007 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1008 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1009 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1010 */ _CFFI_OP(_CFFI_OP_POINTER, 3730), // TPML_DIGEST_VALUES const *
/* 1011 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1012 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPML_PCR_SELECTION const *)
/* 1013 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1014 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1015 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1016 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1017 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1018 */ _CFFI_OP(_CFFI_OP_NOOP, 398),
/* 1019 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1020 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, TPML_PCR_SELECTION const *, uint8_t *, uint32_t *, uint32_t *, uint32_t *)
/* 1021 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1022 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1023 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1024 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1025 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1026 */ _CFFI_OP(_CFFI_OP_NOOP, 398),
/* 1027 */ _CFFI_OP(_CFFI_OP_POINTER, 9), // uint8_t *
/* 1028 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 1029 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 1030 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 1031 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1032 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, int8_t)
/* 1033 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1034 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1035 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1036 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1037 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1038 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 17), // int8_t
/* 1039 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1040 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint16_t, TPML_CC const *, TPML_CC const *)
/* 1041 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1042 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1043 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1044 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1045 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1046 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 1047 */ _CFFI_OP(_CFFI_OP_NOOP, 993),
/* 1048 */ _CFFI_OP(_CFFI_OP_NOOP, 993),
/* 1049 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1050 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t *)
/* 1051 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1052 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1053 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1054 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1055 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1056 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 1057 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1058 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t)
/* 1059 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1060 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1061 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1062 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1063 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1064 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1065 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1066 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DATA const *, TPM2B_DIGEST const *, TPMT_SIG_SCHEME const *, TPMT_TK_CREATION const *)
/* 1067 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1068 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1069 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1070 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1071 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1072 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1073 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 1074 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1075 */ _CFFI_OP(_CFFI_OP_NOOP, 495),
/* 1076 */ _CFFI_OP(_CFFI_OP_POINTER, 3815), // TPMT_TK_CREATION const *
/* 1077 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1078 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DATA const *, TPM2B_DIGEST const *, TPMT_SIG_SCHEME const *, TPMT_TK_CREATION const *, TPM2B_ATTEST * *, TPMT_SIGNATURE * *)
/* 1079 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1080 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1081 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1082 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1083 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1084 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1085 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 1086 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1087 */ _CFFI_OP(_CFFI_OP_NOOP, 495),
/* 1088 */ _CFFI_OP(_CFFI_OP_NOOP, 1076),
/* 1089 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 1090 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 1091 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1092 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DATA const *, TPMT_SIG_SCHEME const *)
/* 1093 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1094 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1095 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1096 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1097 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1098 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1099 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 1100 */ _CFFI_OP(_CFFI_OP_NOOP, 495),
/* 1101 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1102 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DATA const *, TPMT_SIG_SCHEME const *, TPM2B_ATTEST * *, TPMT_SIGNATURE * *)
/* 1103 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1104 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1105 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1106 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1107 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1108 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1109 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 1110 */ _CFFI_OP(_CFFI_OP_NOOP, 495),
/* 1111 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 1112 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 1113 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1114 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DATA const *, TPMT_SIG_SCHEME const *, TPM2B_MAX_BUFFER const *)
/* 1115 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1116 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1117 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1118 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1119 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1120 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1121 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 1122 */ _CFFI_OP(_CFFI_OP_NOOP, 495),
/* 1123 */ _CFFI_OP(_CFFI_OP_NOOP, 311),
/* 1124 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1125 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DATA const *, TPMT_SIG_SCHEME const *, TPM2B_MAX_BUFFER const *, TPM2B_MAX_BUFFER * *, TPM2B_DIGEST * *, TPMT_SIGNATURE * *)
/* 1126 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1127 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1128 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1129 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1130 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1131 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1132 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 1133 */ _CFFI_OP(_CFFI_OP_NOOP, 495),
/* 1134 */ _CFFI_OP(_CFFI_OP_NOOP, 311),
/* 1135 */ _CFFI_OP(_CFFI_OP_NOOP, 82),
/* 1136 */ _CFFI_OP(_CFFI_OP_NOOP, 42),
/* 1137 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 1138 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1139 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DATA const *, TPMT_SYM_DEF_OBJECT const *)
/* 1140 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1141 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1142 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1143 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1144 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1145 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1146 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 1147 */ _CFFI_OP(_CFFI_OP_NOOP, 473),
/* 1148 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1149 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DATA const *, TPMT_SYM_DEF_OBJECT const *, TPM2B_DATA * *, TPM2B_PRIVATE * *, TPM2B_ENCRYPTED_SECRET * *)
/* 1150 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1151 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1152 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1153 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1154 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1155 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1156 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 1157 */ _CFFI_OP(_CFFI_OP_NOOP, 473),
/* 1158 */ _CFFI_OP(_CFFI_OP_NOOP, 32),
/* 1159 */ _CFFI_OP(_CFFI_OP_NOOP, 37),
/* 1160 */ _CFFI_OP(_CFFI_OP_NOOP, 38),
/* 1161 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1162 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *)
/* 1163 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1164 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1165 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1166 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1167 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1168 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1169 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1170 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1171 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, TPM2B_DIGEST const *, TPM2B_DIGEST const *, int32_t)
/* 1172 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1173 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1174 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1175 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1176 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1177 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1178 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1179 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1180 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1181 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 1182 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1183 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, TPM2B_DIGEST const *, TPM2B_DIGEST const *, int32_t, TPM2B_DIGEST * *, TPMT_TK_AUTH * *)
/* 1184 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1185 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1186 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1187 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1188 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1189 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1190 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1191 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1192 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1193 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 1194 */ _CFFI_OP(_CFFI_OP_NOOP, 42),
/* 1195 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 1196 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1197 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, TPM2B_DIGEST const *, TPM2B_DIGEST const *, int32_t, TPMT_SIGNATURE const *)
/* 1198 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1199 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1200 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1201 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1202 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1203 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1204 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1205 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1206 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1207 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 1208 */ _CFFI_OP(_CFFI_OP_NOOP, 604),
/* 1209 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1210 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, TPM2B_DIGEST const *, TPM2B_DIGEST const *, int32_t, TPMT_SIGNATURE const *, TPM2B_DIGEST * *, TPMT_TK_AUTH * *)
/* 1211 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1212 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1213 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1214 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1215 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1216 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1217 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1218 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1219 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1220 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 1221 */ _CFFI_OP(_CFFI_OP_NOOP, 604),
/* 1222 */ _CFFI_OP(_CFFI_OP_NOOP, 42),
/* 1223 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 1224 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1225 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, TPM2B_PRIVATE * *)
/* 1226 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1227 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1228 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1229 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1230 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1231 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1232 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1233 */ _CFFI_OP(_CFFI_OP_NOOP, 37),
/* 1234 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1235 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, TPMT_SIGNATURE const *)
/* 1236 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1237 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1238 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1239 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1240 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1241 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1242 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1243 */ _CFFI_OP(_CFFI_OP_NOOP, 604),
/* 1244 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1245 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, uint8_t, TPMT_SYM_DEF const *, uint16_t)
/* 1246 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1247 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1248 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1249 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1250 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1251 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1252 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1253 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18),
/* 1254 */ _CFFI_OP(_CFFI_OP_POINTER, 3812), // TPMT_SYM_DEF const *
/* 1255 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 1256 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1257 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, uint8_t, TPMT_SYM_DEF const *, uint16_t, uint32_t *)
/* 1258 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1259 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1260 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1261 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1262 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1263 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1264 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1265 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18),
/* 1266 */ _CFFI_OP(_CFFI_OP_NOOP, 1254),
/* 1267 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 1268 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 1269 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1270 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_ID_OBJECT const *, TPM2B_ENCRYPTED_SECRET const *)
/* 1271 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1272 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1273 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1274 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1275 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1276 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1277 */ _CFFI_OP(_CFFI_OP_POINTER, 3705), // TPM2B_ID_OBJECT const *
/* 1278 */ _CFFI_OP(_CFFI_OP_NOOP, 472),
/* 1279 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1280 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_ID_OBJECT const *, TPM2B_ENCRYPTED_SECRET const *, TPM2B_DIGEST * *)
/* 1281 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1282 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1283 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1284 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1285 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1286 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1287 */ _CFFI_OP(_CFFI_OP_NOOP, 1277),
/* 1288 */ _CFFI_OP(_CFFI_OP_NOOP, 472),
/* 1289 */ _CFFI_OP(_CFFI_OP_NOOP, 42),
/* 1290 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1291 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_MAX_BUFFER const *)
/* 1292 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1293 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1294 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1295 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1296 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1297 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1298 */ _CFFI_OP(_CFFI_OP_NOOP, 311),
/* 1299 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1300 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_MAX_BUFFER const *, TPML_DIGEST_VALUES * *)
/* 1301 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1302 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1303 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1304 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1305 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1306 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1307 */ _CFFI_OP(_CFFI_OP_NOOP, 311),
/* 1308 */ _CFFI_OP(_CFFI_OP_NOOP, 146),
/* 1309 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1310 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_MAX_NV_BUFFER const *)
/* 1311 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1312 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1313 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1314 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1315 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1316 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1317 */ _CFFI_OP(_CFFI_OP_POINTER, 3710), // TPM2B_MAX_NV_BUFFER const *
/* 1318 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1319 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_MAX_NV_BUFFER const *, uint16_t)
/* 1320 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1321 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1322 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1323 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1324 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1325 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1326 */ _CFFI_OP(_CFFI_OP_NOOP, 1317),
/* 1327 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 1328 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1329 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_PRIVATE const *, TPM2B_NAME const *, TPM2B_ENCRYPTED_SECRET const *)
/* 1330 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1331 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1332 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1333 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1334 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1335 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1336 */ _CFFI_OP(_CFFI_OP_NOOP, 471),
/* 1337 */ _CFFI_OP(_CFFI_OP_NOOP, 535),
/* 1338 */ _CFFI_OP(_CFFI_OP_NOOP, 472),
/* 1339 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1340 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_PRIVATE const *, TPM2B_NAME const *, TPM2B_ENCRYPTED_SECRET const *, TPM2B_PRIVATE * *, TPM2B_ENCRYPTED_SECRET * *)
/* 1341 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1342 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1343 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1344 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1345 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1346 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1347 */ _CFFI_OP(_CFFI_OP_NOOP, 471),
/* 1348 */ _CFFI_OP(_CFFI_OP_NOOP, 535),
/* 1349 */ _CFFI_OP(_CFFI_OP_NOOP, 472),
/* 1350 */ _CFFI_OP(_CFFI_OP_NOOP, 37),
/* 1351 */ _CFFI_OP(_CFFI_OP_NOOP, 38),
/* 1352 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1353 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint16_t, uint16_t)
/* 1354 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1355 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1356 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1357 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1358 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1359 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1360 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 1361 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 1362 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1363 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint16_t, uint16_t, TPM2B_MAX_NV_BUFFER * *)
/* 1364 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1365 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1366 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1367 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1368 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1369 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1370 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 1371 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 1372 */ _CFFI_OP(_CFFI_OP_NOOP, 102),
/* 1373 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1374 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t)
/* 1375 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1376 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1377 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1378 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1379 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1380 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1381 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1382 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1383 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DATA const *, TPMT_SIG_SCHEME const *)
/* 1384 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1385 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1386 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1387 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1388 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1389 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1390 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1391 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 1392 */ _CFFI_OP(_CFFI_OP_NOOP, 495),
/* 1393 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1394 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DATA const *, TPMT_SIG_SCHEME const *, TPM2B_ATTEST * *, TPMT_SIGNATURE * *)
/* 1395 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1396 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1397 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1398 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1399 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1400 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1401 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1402 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 1403 */ _CFFI_OP(_CFFI_OP_NOOP, 495),
/* 1404 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 1405 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 1406 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1407 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DATA const *, TPMT_SIG_SCHEME const *, uint16_t, uint16_t)
/* 1408 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1409 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1410 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1411 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1412 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1413 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1414 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1415 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 1416 */ _CFFI_OP(_CFFI_OP_NOOP, 495),
/* 1417 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 1418 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 1419 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1420 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DATA const *, TPMT_SIG_SCHEME const *, uint16_t, uint16_t, TPM2B_ATTEST * *, TPMT_SIGNATURE * *)
/* 1421 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1422 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1423 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1424 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1425 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1426 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1427 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1428 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 1429 */ _CFFI_OP(_CFFI_OP_NOOP, 495),
/* 1430 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 1431 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 1432 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 1433 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 1434 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1435 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_DIGEST const *, uint16_t, uint16_t)
/* 1436 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1437 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1438 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1439 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1440 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1441 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1442 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1443 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1444 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 1445 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 1446 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1447 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_MAX_BUFFER *)
/* 1448 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1449 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1450 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1451 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1452 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1453 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1454 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1455 */ _CFFI_OP(_CFFI_OP_POINTER, 3708), // TPM2B_MAX_BUFFER *
/* 1456 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1457 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, TPM2B_MAX_BUFFER *, TPMS_AC_OUTPUT * *)
/* 1458 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1459 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1460 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1461 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1462 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1463 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1464 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1465 */ _CFFI_OP(_CFFI_OP_NOOP, 1455),
/* 1466 */ _CFFI_OP(_CFFI_OP_NOOP, 150),
/* 1467 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1468 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t *)
/* 1469 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1470 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1471 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1472 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1473 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1474 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1475 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1476 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 1477 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1478 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t)
/* 1479 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1480 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1481 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1482 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1483 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1484 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1485 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1486 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1487 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1488 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint8_t *, TPML_AC_CAPABILITIES * *)
/* 1489 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1490 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1491 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1492 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1493 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1494 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1495 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1496 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1497 */ _CFFI_OP(_CFFI_OP_POINTER, 3052), // TPML_AC_CAPABILITIES * *
/* 1498 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1499 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint8_t *, TPMS_CAPABILITY_DATA * *)
/* 1500 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1501 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1502 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1503 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1504 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1505 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1506 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1507 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1508 */ _CFFI_OP(_CFFI_OP_POINTER, 3178), // TPMS_CAPABILITY_DATA * *
/* 1509 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1510 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint64_t)
/* 1511 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1512 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1513 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1514 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1515 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1516 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1517 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24), // uint64_t
/* 1518 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1519 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint8_t)
/* 1520 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1521 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1522 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1523 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1524 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1525 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1526 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18),
/* 1527 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1528 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint64_t)
/* 1529 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1530 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1531 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1532 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1533 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1534 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1535 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1536 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint8_t)
/* 1537 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1538 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1539 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1540 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1541 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1542 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18),
/* 1543 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1544 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint8_t, uint16_t, TPM2B_IV const *, TPM2B_MAX_BUFFER const *)
/* 1545 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1546 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1547 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1548 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1549 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1550 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18),
/* 1551 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 1552 */ _CFFI_OP(_CFFI_OP_NOOP, 831),
/* 1553 */ _CFFI_OP(_CFFI_OP_NOOP, 311),
/* 1554 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1555 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint32_t, uint8_t, uint16_t, TPM2B_IV const *, TPM2B_MAX_BUFFER const *, TPM2B_MAX_BUFFER * *, TPM2B_IV * *)
/* 1556 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1557 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1558 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1559 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1560 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1561 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18),
/* 1562 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 1563 */ _CFFI_OP(_CFFI_OP_NOOP, 831),
/* 1564 */ _CFFI_OP(_CFFI_OP_NOOP, 311),
/* 1565 */ _CFFI_OP(_CFFI_OP_NOOP, 82),
/* 1566 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 1567 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1568 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint32_t, uint32_t, uint8_t)
/* 1569 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1570 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1571 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1572 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1573 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18),
/* 1574 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1575 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint8_t * *, size_t *)
/* 1576 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1577 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1578 */ _CFFI_OP(_CFFI_OP_POINTER, 1027), // uint8_t * *
/* 1579 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1580 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1581 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint8_t *)
/* 1582 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1583 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1584 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1585 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1586 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint32_t, uint8_t, uint8_t)
/* 1587 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1588 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1589 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18),
/* 1590 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18),
/* 1591 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1592 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint8_t *, TPML_AC_CAPABILITIES * *)
/* 1593 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1594 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1595 */ _CFFI_OP(_CFFI_OP_NOOP, 1497),
/* 1596 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1597 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint8_t *, TPMS_CAPABILITY_DATA * *)
/* 1598 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1599 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1600 */ _CFFI_OP(_CFFI_OP_NOOP, 1508),
/* 1601 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1602 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint8_t *, uint32_t *, uint32_t *, uint32_t *)
/* 1603 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1604 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1605 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 1606 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 1607 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 1608 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1609 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CONTEXT *, uint8_t const *, size_t, uint32_t *)
/* 1610 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 1611 */ _CFFI_OP(_CFFI_OP_POINTER, 9), // uint8_t const *
/* 1612 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/* 1613 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 1614 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1615 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CRYPTO_CONTEXT_BLOB * *, uint16_t, uint8_t const *, size_t, void *)
/* 1616 */ _CFFI_OP(_CFFI_OP_POINTER, 1634), // ESYS_CRYPTO_CONTEXT_BLOB * *
/* 1617 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 1618 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 1619 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1620 */ _CFFI_OP(_CFFI_OP_POINTER, 3980), // void *
/* 1621 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1622 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CRYPTO_CONTEXT_BLOB * *, uint16_t, void *)
/* 1623 */ _CFFI_OP(_CFFI_OP_NOOP, 1616),
/* 1624 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 1625 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 1626 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1627 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CRYPTO_CONTEXT_BLOB * *, uint8_t *, size_t *, void *)
/* 1628 */ _CFFI_OP(_CFFI_OP_NOOP, 1616),
/* 1629 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1630 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1631 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 1632 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1633 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(ESYS_CRYPTO_CONTEXT_BLOB *, uint8_t const *, size_t, void *)
/* 1634 */ _CFFI_OP(_CFFI_OP_POINTER, 3689), // ESYS_CRYPTO_CONTEXT_BLOB *
/* 1635 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 1636 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1637 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 1638 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1639 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT * *)
/* 1640 */ _CFFI_OP(_CFFI_OP_POINTER, 1647), // FAPI_CONTEXT * *
/* 1641 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1642 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT * *, char const *)
/* 1643 */ _CFFI_OP(_CFFI_OP_NOOP, 1640),
/* 1644 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1645 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1646 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *)
/* 1647 */ _CFFI_OP(_CFFI_OP_POINTER, 3690), // FAPI_CONTEXT *
/* 1648 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1649 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, TSS2_TCTI_CONTEXT * *)
/* 1650 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1651 */ _CFFI_OP(_CFFI_OP_NOOP, 192),
/* 1652 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1653 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, TSS2_TCTI_POLL_HANDLE * *, size_t *)
/* 1654 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1655 */ _CFFI_OP(_CFFI_OP_NOOP, 196),
/* 1656 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1657 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1658 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char * *)
/* 1659 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1660 */ _CFFI_OP(_CFFI_OP_POINTER, 2704), // char * *
/* 1661 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1662 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char * *, uint8_t * *, size_t *, char * *, char * *)
/* 1663 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1664 */ _CFFI_OP(_CFFI_OP_NOOP, 1660),
/* 1665 */ _CFFI_OP(_CFFI_OP_NOOP, 1578),
/* 1666 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1667 */ _CFFI_OP(_CFFI_OP_NOOP, 1660),
/* 1668 */ _CFFI_OP(_CFFI_OP_NOOP, 1660),
/* 1669 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1670 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char const *)
/* 1671 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1672 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1673 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1674 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char const *, char * *)
/* 1675 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1676 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1677 */ _CFFI_OP(_CFFI_OP_NOOP, 1660),
/* 1678 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1679 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char const *, char const *)
/* 1680 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1681 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1682 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1683 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1684 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char const *, char const *, char * *)
/* 1685 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1686 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1687 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1688 */ _CFFI_OP(_CFFI_OP_NOOP, 1660),
/* 1689 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1690 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char const *, char const *, char const *)
/* 1691 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1692 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1693 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1694 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1695 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1696 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char const *, char const *, char const *, char const *)
/* 1697 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1698 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1699 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1700 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1701 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1702 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1703 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char const *, char const *, size_t, char const *, char const *)
/* 1704 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1705 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1706 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1707 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1708 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1709 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1710 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1711 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char const *, char const *, size_t, char const *, char const *, uint8_t const *)
/* 1712 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1713 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1714 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1715 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1716 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1717 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1718 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 1719 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1720 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char const *, char const *, uint8_t const *, size_t)
/* 1721 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1722 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1723 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1724 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 1725 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1726 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1727 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char const *, char const *, uint8_t const *, size_t, uint8_t * *, size_t *, char * *, char * *)
/* 1728 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1729 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1730 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1731 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 1732 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1733 */ _CFFI_OP(_CFFI_OP_NOOP, 1578),
/* 1734 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1735 */ _CFFI_OP(_CFFI_OP_NOOP, 1660),
/* 1736 */ _CFFI_OP(_CFFI_OP_NOOP, 1660),
/* 1737 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1738 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char const *, uint64_t)
/* 1739 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1740 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1741 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1742 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1743 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char const *, uint8_t * *, size_t *)
/* 1744 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1745 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1746 */ _CFFI_OP(_CFFI_OP_NOOP, 1578),
/* 1747 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1748 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1749 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char const *, uint8_t * *, size_t *, char * *)
/* 1750 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1751 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1752 */ _CFFI_OP(_CFFI_OP_NOOP, 1578),
/* 1753 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1754 */ _CFFI_OP(_CFFI_OP_NOOP, 1660),
/* 1755 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1756 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char const *, uint8_t * *, size_t *, uint8_t * *, size_t *, char * *)
/* 1757 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1758 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1759 */ _CFFI_OP(_CFFI_OP_NOOP, 1578),
/* 1760 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1761 */ _CFFI_OP(_CFFI_OP_NOOP, 1578),
/* 1762 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1763 */ _CFFI_OP(_CFFI_OP_NOOP, 1660),
/* 1764 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1765 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char const *, uint8_t *, uint8_t * *, size_t *)
/* 1766 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1767 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1768 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1769 */ _CFFI_OP(_CFFI_OP_NOOP, 1578),
/* 1770 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1771 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1772 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char const *, uint8_t const *, size_t)
/* 1773 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1774 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1775 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 1776 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1777 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1778 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char const *, uint8_t const *, size_t, char const *)
/* 1779 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1780 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1781 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 1782 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1783 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1784 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1785 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char const *, uint8_t const *, size_t, char const *, uint8_t const *, size_t, char const *)
/* 1786 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1787 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1788 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 1789 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1790 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1791 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 1792 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1793 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1794 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1795 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char const *, uint8_t const *, size_t, uint8_t * *, size_t *)
/* 1796 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1797 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1798 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 1799 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1800 */ _CFFI_OP(_CFFI_OP_NOOP, 1578),
/* 1801 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1802 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1803 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, char const *, uint8_t const *, size_t, uint8_t const *, size_t)
/* 1804 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1805 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1806 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 1807 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1808 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 1809 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1810 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1811 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, size_t)
/* 1812 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1813 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1814 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1815 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, size_t, uint8_t * *)
/* 1816 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1817 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1818 */ _CFFI_OP(_CFFI_OP_NOOP, 1578),
/* 1819 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1820 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, uint32_t *, size_t, char const *, char const *, uint8_t const *, size_t)
/* 1821 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1822 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 1823 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1824 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1825 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1826 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 1827 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1828 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1829 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, uint32_t *, size_t, char const *, char const *, uint8_t const *, size_t, char * *, uint8_t * *, size_t *, char * *, char * *)
/* 1830 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1831 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 1832 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1833 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1834 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1835 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 1836 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1837 */ _CFFI_OP(_CFFI_OP_NOOP, 1660),
/* 1838 */ _CFFI_OP(_CFFI_OP_NOOP, 1578),
/* 1839 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1840 */ _CFFI_OP(_CFFI_OP_NOOP, 1660),
/* 1841 */ _CFFI_OP(_CFFI_OP_NOOP, 1660),
/* 1842 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1843 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, uint32_t(*)(char const *, char const *, char const * *, size_t, size_t *, void *), void *)
/* 1844 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1845 */ _CFFI_OP(_CFFI_OP_POINTER, 2784), // uint32_t(*)(char const *, char const *, char const * *, size_t, size_t *, void *)
/* 1846 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 1847 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1848 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, uint32_t(*)(char const *, char const *, char const * *, void *), void *)
/* 1849 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1850 */ _CFFI_OP(_CFFI_OP_POINTER, 2792), // uint32_t(*)(char const *, char const *, char const * *, void *)
/* 1851 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 1852 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1853 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, uint32_t(*)(char const *, char const *, char const *, char const *, uint32_t, uint8_t const *, size_t, uint8_t const * *, size_t *, void *), void *)
/* 1854 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1855 */ _CFFI_OP(_CFFI_OP_POINTER, 2798), // uint32_t(*)(char const *, char const *, char const *, char const *, uint32_t, uint8_t const *, size_t, uint8_t const * *, size_t *, void *)
/* 1856 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 1857 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1858 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, uint32_t(*)(char const *, char const *, void *), void *)
/* 1859 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1860 */ _CFFI_OP(_CFFI_OP_POINTER, 2810), // uint32_t(*)(char const *, char const *, void *)
/* 1861 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 1862 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1863 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, uint32_t)
/* 1864 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1865 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1866 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1867 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, uint32_t, uint8_t * *, size_t *, char * *)
/* 1868 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1869 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1870 */ _CFFI_OP(_CFFI_OP_NOOP, 1578),
/* 1871 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1872 */ _CFFI_OP(_CFFI_OP_NOOP, 1660),
/* 1873 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1874 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, uint32_t, uint8_t const *, size_t, char const *)
/* 1875 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1876 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1877 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 1878 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1879 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 1880 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1881 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, uint8_t * *)
/* 1882 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1883 */ _CFFI_OP(_CFFI_OP_NOOP, 1578),
/* 1884 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1885 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, uint8_t * *, size_t *)
/* 1886 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1887 */ _CFFI_OP(_CFFI_OP_NOOP, 1578),
/* 1888 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1889 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1890 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, uint8_t * *, size_t *, char * *)
/* 1891 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1892 */ _CFFI_OP(_CFFI_OP_NOOP, 1578),
/* 1893 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1894 */ _CFFI_OP(_CFFI_OP_NOOP, 1660),
/* 1895 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1896 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, uint8_t * *, size_t *, char * *, char * *)
/* 1897 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1898 */ _CFFI_OP(_CFFI_OP_NOOP, 1578),
/* 1899 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1900 */ _CFFI_OP(_CFFI_OP_NOOP, 1660),
/* 1901 */ _CFFI_OP(_CFFI_OP_NOOP, 1660),
/* 1902 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1903 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, uint8_t * *, size_t *, uint8_t * *, size_t *, char * *)
/* 1904 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1905 */ _CFFI_OP(_CFFI_OP_NOOP, 1578),
/* 1906 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1907 */ _CFFI_OP(_CFFI_OP_NOOP, 1578),
/* 1908 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1909 */ _CFFI_OP(_CFFI_OP_NOOP, 1660),
/* 1910 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1911 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(FAPI_CONTEXT *, uint8_t *, uint8_t * *, size_t *)
/* 1912 */ _CFFI_OP(_CFFI_OP_NOOP, 1647),
/* 1913 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1914 */ _CFFI_OP(_CFFI_OP_NOOP, 1578),
/* 1915 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1916 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1917 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_ATTEST const *, uint8_t *, size_t, size_t *)
/* 1918 */ _CFFI_OP(_CFFI_OP_POINTER, 3692), // TPM2B_ATTEST const *
/* 1919 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1920 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1921 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1922 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1923 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_CONTEXT_DATA const *, uint8_t *, size_t, size_t *)
/* 1924 */ _CFFI_OP(_CFFI_OP_POINTER, 3693), // TPM2B_CONTEXT_DATA const *
/* 1925 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1926 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1927 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1928 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1929 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_CONTEXT_SENSITIVE const *, uint8_t *, size_t, size_t *)
/* 1930 */ _CFFI_OP(_CFFI_OP_POINTER, 3694), // TPM2B_CONTEXT_SENSITIVE const *
/* 1931 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1932 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1933 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1934 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1935 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_CREATION_DATA const *, uint8_t *, size_t, size_t *)
/* 1936 */ _CFFI_OP(_CFFI_OP_POINTER, 3695), // TPM2B_CREATION_DATA const *
/* 1937 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1938 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1939 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1940 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1941 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_DATA const *, uint8_t *, size_t, size_t *)
/* 1942 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 1943 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1944 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1945 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1946 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1947 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_DIGEST *, size_t, void *)
/* 1948 */ _CFFI_OP(_CFFI_OP_POINTER, 3698), // TPM2B_DIGEST *
/* 1949 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1950 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 1951 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1952 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_DIGEST const *, uint8_t *, size_t, size_t *)
/* 1953 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1954 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1955 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1956 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1957 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1958 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_ECC_PARAMETER const *, uint8_t *, size_t, size_t *)
/* 1959 */ _CFFI_OP(_CFFI_OP_NOOP, 734),
/* 1960 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1961 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1962 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1963 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1964 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_ECC_POINT const *, uint8_t *, size_t, size_t *)
/* 1965 */ _CFFI_OP(_CFFI_OP_NOOP, 691),
/* 1966 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1967 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1968 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1969 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1970 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_ENCRYPTED_SECRET const *, uint8_t *, size_t, size_t *)
/* 1971 */ _CFFI_OP(_CFFI_OP_NOOP, 472),
/* 1972 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1973 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1974 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1975 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1976 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_EVENT const *, uint8_t *, size_t, size_t *)
/* 1977 */ _CFFI_OP(_CFFI_OP_NOOP, 756),
/* 1978 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1979 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1980 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1981 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1982 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_ID_OBJECT const *, uint8_t *, size_t, size_t *)
/* 1983 */ _CFFI_OP(_CFFI_OP_NOOP, 1277),
/* 1984 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1985 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1986 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1987 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1988 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_IV const *, uint8_t *, size_t, size_t *)
/* 1989 */ _CFFI_OP(_CFFI_OP_NOOP, 831),
/* 1990 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1991 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1992 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1993 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1994 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_MAX_BUFFER const *, uint8_t *, size_t, size_t *)
/* 1995 */ _CFFI_OP(_CFFI_OP_NOOP, 311),
/* 1996 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 1997 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1998 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 1999 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2000 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_MAX_CAP_BUFFER const *, uint8_t *, size_t, size_t *)
/* 2001 */ _CFFI_OP(_CFFI_OP_POINTER, 3709), // TPM2B_MAX_CAP_BUFFER const *
/* 2002 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2003 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2004 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2005 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2006 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_MAX_NV_BUFFER const *, uint8_t *, size_t, size_t *)
/* 2007 */ _CFFI_OP(_CFFI_OP_NOOP, 1317),
/* 2008 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2009 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2010 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2011 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2012 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_NAME *, uint32_t *, uint32_t *, uint32_t *, void *)
/* 2013 */ _CFFI_OP(_CFFI_OP_NOOP, 347),
/* 2014 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 2015 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 2016 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 2017 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 2018 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2019 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_NAME *, uint32_t *, void *)
/* 2020 */ _CFFI_OP(_CFFI_OP_NOOP, 347),
/* 2021 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 2022 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 2023 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2024 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_NAME *, void *)
/* 2025 */ _CFFI_OP(_CFFI_OP_NOOP, 347),
/* 2026 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 2027 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2028 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_NAME const *, uint8_t *, size_t, size_t *)
/* 2029 */ _CFFI_OP(_CFFI_OP_NOOP, 535),
/* 2030 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2031 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2032 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2033 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2034 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_NV_PUBLIC const *, uint8_t *, size_t, size_t *)
/* 2035 */ _CFFI_OP(_CFFI_OP_NOOP, 576),
/* 2036 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2037 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2038 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2039 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2040 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_PRIVATE const *, uint8_t *, size_t, size_t *)
/* 2041 */ _CFFI_OP(_CFFI_OP_NOOP, 471),
/* 2042 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2043 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2044 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2045 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2046 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_PRIVATE_KEY_RSA const *, uint8_t *, size_t, size_t *)
/* 2047 */ _CFFI_OP(_CFFI_OP_POINTER, 3714), // TPM2B_PRIVATE_KEY_RSA const *
/* 2048 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2049 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2050 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2051 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2052 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_PUBLIC *, size_t, TPM2B_ECC_PARAMETER *, TPMS_ECC_POINT *, uint8_t *, size_t *, void *)
/* 2053 */ _CFFI_OP(_CFFI_OP_POINTER, 3716), // TPM2B_PUBLIC *
/* 2054 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2055 */ _CFFI_OP(_CFFI_OP_POINTER, 3701), // TPM2B_ECC_PARAMETER *
/* 2056 */ _CFFI_OP(_CFFI_OP_POINTER, 3763), // TPMS_ECC_POINT *
/* 2057 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2058 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2059 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 2060 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2061 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_PUBLIC *, size_t, uint8_t *, size_t, uint8_t *, size_t *, char const *, void *)
/* 2062 */ _CFFI_OP(_CFFI_OP_NOOP, 2053),
/* 2063 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2064 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2065 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2066 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2067 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2068 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 2069 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 2070 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2071 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_PUBLIC const *, uint8_t *, size_t, size_t *)
/* 2072 */ _CFFI_OP(_CFFI_OP_NOOP, 358),
/* 2073 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2074 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2075 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2076 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2077 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_PUBLIC_KEY_RSA const *, uint8_t *, size_t, size_t *)
/* 2078 */ _CFFI_OP(_CFFI_OP_NOOP, 900),
/* 2079 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2080 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2081 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2082 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2083 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_SENSITIVE const *, uint8_t *, size_t, size_t *)
/* 2084 */ _CFFI_OP(_CFFI_OP_NOOP, 357),
/* 2085 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2086 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2087 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2088 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2089 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_SENSITIVE_CREATE const *, uint8_t *, size_t, size_t *)
/* 2090 */ _CFFI_OP(_CFFI_OP_NOOP, 921),
/* 2091 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2092 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2093 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2094 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2095 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_SENSITIVE_DATA const *, uint8_t *, size_t, size_t *)
/* 2096 */ _CFFI_OP(_CFFI_OP_NOOP, 376),
/* 2097 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2098 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2099 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2100 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2101 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_SYM_KEY const *, uint8_t *, size_t, size_t *)
/* 2102 */ _CFFI_OP(_CFFI_OP_POINTER, 3721), // TPM2B_SYM_KEY const *
/* 2103 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2104 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2105 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2106 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2107 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPM2B_TEMPLATE const *, uint8_t *, size_t, size_t *)
/* 2108 */ _CFFI_OP(_CFFI_OP_NOOP, 965),
/* 2109 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2110 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2111 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2112 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2113 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPML_ACT_DATA const *, uint8_t *, size_t, size_t *)
/* 2114 */ _CFFI_OP(_CFFI_OP_POINTER, 3723), // TPML_ACT_DATA const *
/* 2115 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2116 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2117 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2118 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2119 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPML_AC_CAPABILITIES const *, uint8_t *, size_t, size_t *)
/* 2120 */ _CFFI_OP(_CFFI_OP_POINTER, 3724), // TPML_AC_CAPABILITIES const *
/* 2121 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2122 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2123 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2124 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2125 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPML_ALG const *, uint8_t *, size_t, size_t *)
/* 2126 */ _CFFI_OP(_CFFI_OP_NOOP, 383),
/* 2127 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2128 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2129 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2130 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2131 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPML_ALG_PROPERTY const *, uint8_t *, size_t, size_t *)
/* 2132 */ _CFFI_OP(_CFFI_OP_POINTER, 3726), // TPML_ALG_PROPERTY const *
/* 2133 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2134 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2135 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2136 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2137 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPML_CC const *, uint8_t *, size_t, size_t *)
/* 2138 */ _CFFI_OP(_CFFI_OP_NOOP, 993),
/* 2139 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2140 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2141 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2142 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2143 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPML_CCA const *, uint8_t *, size_t, size_t *)
/* 2144 */ _CFFI_OP(_CFFI_OP_POINTER, 3728), // TPML_CCA const *
/* 2145 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2146 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2147 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2148 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2149 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPML_DIGEST const *, uint8_t *, size_t, size_t *)
/* 2150 */ _CFFI_OP(_CFFI_OP_NOOP, 1002),
/* 2151 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2152 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2153 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2154 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2155 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPML_DIGEST_VALUES const *, uint8_t *, size_t, size_t *)
/* 2156 */ _CFFI_OP(_CFFI_OP_NOOP, 1010),
/* 2157 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2158 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2159 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2160 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2161 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPML_ECC_CURVE const *, uint8_t *, size_t, size_t *)
/* 2162 */ _CFFI_OP(_CFFI_OP_POINTER, 3731), // TPML_ECC_CURVE const *
/* 2163 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2164 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2165 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2166 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2167 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPML_HANDLE const *, uint8_t *, size_t, size_t *)
/* 2168 */ _CFFI_OP(_CFFI_OP_POINTER, 3732), // TPML_HANDLE const *
/* 2169 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2170 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2171 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2172 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2173 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPML_INTEL_PTT_PROPERTY const *, uint8_t *, size_t, size_t *)
/* 2174 */ _CFFI_OP(_CFFI_OP_POINTER, 3733), // TPML_INTEL_PTT_PROPERTY const *
/* 2175 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2176 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2177 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2178 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2179 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPML_PCR_SELECTION const *, uint8_t *, size_t, size_t *)
/* 2180 */ _CFFI_OP(_CFFI_OP_NOOP, 398),
/* 2181 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2182 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2183 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2184 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2185 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPML_TAGGED_PCR_PROPERTY const *, uint8_t *, size_t, size_t *)
/* 2186 */ _CFFI_OP(_CFFI_OP_POINTER, 3736), // TPML_TAGGED_PCR_PROPERTY const *
/* 2187 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2188 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2189 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2190 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2191 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPML_TAGGED_POLICY const *, uint8_t *, size_t, size_t *)
/* 2192 */ _CFFI_OP(_CFFI_OP_POINTER, 3737), // TPML_TAGGED_POLICY const *
/* 2193 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2194 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2195 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2196 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2197 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPML_TAGGED_TPM_PROPERTY const *, uint8_t *, size_t, size_t *)
/* 2198 */ _CFFI_OP(_CFFI_OP_POINTER, 3738), // TPML_TAGGED_TPM_PROPERTY const *
/* 2199 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2200 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2201 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2202 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2203 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_ACT_DATA const *, uint8_t *, size_t, size_t *)
/* 2204 */ _CFFI_OP(_CFFI_OP_POINTER, 3739), // TPMS_ACT_DATA const *
/* 2205 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2206 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2207 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2208 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2209 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_AC_OUTPUT const *, uint8_t *, size_t, size_t *)
/* 2210 */ _CFFI_OP(_CFFI_OP_POINTER, 3742), // TPMS_AC_OUTPUT const *
/* 2211 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2212 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2213 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2214 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2215 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_ALGORITHM_DETAIL_ECC const *, uint8_t *, size_t, size_t *)
/* 2216 */ _CFFI_OP(_CFFI_OP_POINTER, 3745), // TPMS_ALGORITHM_DETAIL_ECC const *
/* 2217 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2218 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2219 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2220 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2221 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_ALG_PROPERTY const *, uint8_t *, size_t, size_t *)
/* 2222 */ _CFFI_OP(_CFFI_OP_POINTER, 3746), // TPMS_ALG_PROPERTY const *
/* 2223 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2224 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2225 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2226 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2227 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_ATTEST const *, uint8_t *, size_t, size_t *)
/* 2228 */ _CFFI_OP(_CFFI_OP_POINTER, 3750), // TPMS_ATTEST const *
/* 2229 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2230 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2231 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2232 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2233 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_AUTH_COMMAND const *, uint8_t *, size_t, size_t *)
/* 2234 */ _CFFI_OP(_CFFI_OP_POINTER, 3751), // TPMS_AUTH_COMMAND const *
/* 2235 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2236 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2237 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2238 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2239 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_AUTH_RESPONSE const *, uint8_t *, size_t, size_t *)
/* 2240 */ _CFFI_OP(_CFFI_OP_POINTER, 3752), // TPMS_AUTH_RESPONSE const *
/* 2241 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2242 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2243 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2244 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2245 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_CAPABILITY_DATA const *, uint8_t *, size_t, size_t *)
/* 2246 */ _CFFI_OP(_CFFI_OP_POINTER, 3753), // TPMS_CAPABILITY_DATA const *
/* 2247 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2248 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2249 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2250 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2251 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_CERTIFY_INFO const *, uint8_t *, size_t, size_t *)
/* 2252 */ _CFFI_OP(_CFFI_OP_POINTER, 3754), // TPMS_CERTIFY_INFO const *
/* 2253 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2254 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2255 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2256 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2257 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_CLOCK_INFO const *, uint8_t *, size_t, size_t *)
/* 2258 */ _CFFI_OP(_CFFI_OP_POINTER, 3755), // TPMS_CLOCK_INFO const *
/* 2259 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2260 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2261 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2262 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2263 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_COMMAND_AUDIT_INFO const *, uint8_t *, size_t, size_t *)
/* 2264 */ _CFFI_OP(_CFFI_OP_POINTER, 3756), // TPMS_COMMAND_AUDIT_INFO const *
/* 2265 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2266 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2267 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2268 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2269 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_CONTEXT const *, uint8_t *, size_t, size_t *)
/* 2270 */ _CFFI_OP(_CFFI_OP_NOOP, 162),
/* 2271 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2272 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2273 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2274 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2275 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_CONTEXT_DATA const *, uint8_t *, size_t, size_t *)
/* 2276 */ _CFFI_OP(_CFFI_OP_POINTER, 3758), // TPMS_CONTEXT_DATA const *
/* 2277 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2278 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2279 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2280 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2281 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_CREATION_DATA const *, uint8_t *, size_t, size_t *)
/* 2282 */ _CFFI_OP(_CFFI_OP_POINTER, 3759), // TPMS_CREATION_DATA const *
/* 2283 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2284 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2285 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2286 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2287 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_CREATION_INFO const *, uint8_t *, size_t, size_t *)
/* 2288 */ _CFFI_OP(_CFFI_OP_POINTER, 3760), // TPMS_CREATION_INFO const *
/* 2289 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2290 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2291 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2292 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2293 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_ECC_PARMS const *, uint8_t *, size_t, size_t *)
/* 2294 */ _CFFI_OP(_CFFI_OP_POINTER, 3762), // TPMS_ECC_PARMS const *
/* 2295 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2296 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2297 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2298 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2299 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_ECC_POINT const *, uint8_t *, size_t, size_t *)
/* 2300 */ _CFFI_OP(_CFFI_OP_POINTER, 3763), // TPMS_ECC_POINT const *
/* 2301 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2302 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2303 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2304 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2305 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_EMPTY const *, uint8_t *, size_t, size_t *)
/* 2306 */ _CFFI_OP(_CFFI_OP_POINTER, 3764), // TPMS_EMPTY const *
/* 2307 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2308 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2309 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2310 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2311 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_ID_OBJECT const *, uint8_t *, size_t, size_t *)
/* 2312 */ _CFFI_OP(_CFFI_OP_POINTER, 3765), // TPMS_ID_OBJECT const *
/* 2313 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2314 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2315 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2316 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2317 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_KEYEDHASH_PARMS const *, uint8_t *, size_t, size_t *)
/* 2318 */ _CFFI_OP(_CFFI_OP_POINTER, 3766), // TPMS_KEYEDHASH_PARMS const *
/* 2319 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2320 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2321 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2322 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2323 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_NV_CERTIFY_INFO const *, uint8_t *, size_t, size_t *)
/* 2324 */ _CFFI_OP(_CFFI_OP_POINTER, 3767), // TPMS_NV_CERTIFY_INFO const *
/* 2325 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2326 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2327 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2328 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2329 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_NV_DIGEST_CERTIFY_INFO const *, uint8_t *, size_t, size_t *)
/* 2330 */ _CFFI_OP(_CFFI_OP_POINTER, 3768), // TPMS_NV_DIGEST_CERTIFY_INFO const *
/* 2331 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2332 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2333 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2334 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2335 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_NV_PIN_COUNTER_PARAMETERS const *, uint8_t *, size_t, size_t *)
/* 2336 */ _CFFI_OP(_CFFI_OP_POINTER, 3769), // TPMS_NV_PIN_COUNTER_PARAMETERS const *
/* 2337 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2338 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2339 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2340 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2341 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_NV_PUBLIC *, uint16_t, void *)
/* 2342 */ _CFFI_OP(_CFFI_OP_POINTER, 3770), // TPMS_NV_PUBLIC *
/* 2343 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 2344 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 2345 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2346 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_NV_PUBLIC const *, uint8_t *, size_t, size_t *)
/* 2347 */ _CFFI_OP(_CFFI_OP_POINTER, 3770), // TPMS_NV_PUBLIC const *
/* 2348 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2349 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2350 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2351 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2352 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_PCR_SELECT const *, uint8_t *, size_t, size_t *)
/* 2353 */ _CFFI_OP(_CFFI_OP_POINTER, 3773), // TPMS_PCR_SELECT const *
/* 2354 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2355 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2356 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2357 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2358 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_PCR_SELECTION const *, uint8_t *, size_t, size_t *)
/* 2359 */ _CFFI_OP(_CFFI_OP_POINTER, 3774), // TPMS_PCR_SELECTION const *
/* 2360 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2361 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2362 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2363 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2364 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_QUOTE_INFO const *, uint8_t *, size_t, size_t *)
/* 2365 */ _CFFI_OP(_CFFI_OP_POINTER, 3777), // TPMS_QUOTE_INFO const *
/* 2366 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2367 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2368 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2369 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2370 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_RSA_PARMS const *, uint8_t *, size_t, size_t *)
/* 2371 */ _CFFI_OP(_CFFI_OP_POINTER, 3778), // TPMS_RSA_PARMS const *
/* 2372 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2373 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2374 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2375 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2376 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_SCHEME_ECDAA const *, uint8_t *, size_t, size_t *)
/* 2377 */ _CFFI_OP(_CFFI_OP_POINTER, 3779), // TPMS_SCHEME_ECDAA const *
/* 2378 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2379 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2380 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2381 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2382 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_SCHEME_HASH const *, uint8_t *, size_t, size_t *)
/* 2383 */ _CFFI_OP(_CFFI_OP_POINTER, 3780), // TPMS_SCHEME_HASH const *
/* 2384 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2385 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2386 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2387 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2388 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_SCHEME_XOR const *, uint8_t *, size_t, size_t *)
/* 2389 */ _CFFI_OP(_CFFI_OP_POINTER, 3781), // TPMS_SCHEME_XOR const *
/* 2390 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2391 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2392 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2393 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2394 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_SENSITIVE_CREATE const *, uint8_t *, size_t, size_t *)
/* 2395 */ _CFFI_OP(_CFFI_OP_POINTER, 3782), // TPMS_SENSITIVE_CREATE const *
/* 2396 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2397 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2398 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2399 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2400 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_SESSION_AUDIT_INFO const *, uint8_t *, size_t, size_t *)
/* 2401 */ _CFFI_OP(_CFFI_OP_POINTER, 3783), // TPMS_SESSION_AUDIT_INFO const *
/* 2402 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2403 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2404 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2405 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2406 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_SIGNATURE_ECC const *, uint8_t *, size_t, size_t *)
/* 2407 */ _CFFI_OP(_CFFI_OP_POINTER, 3784), // TPMS_SIGNATURE_ECC const *
/* 2408 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2409 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2410 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2411 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2412 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_SIGNATURE_RSA const *, uint8_t *, size_t, size_t *)
/* 2413 */ _CFFI_OP(_CFFI_OP_POINTER, 3785), // TPMS_SIGNATURE_RSA const *
/* 2414 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2415 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2416 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2417 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2418 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_SYMCIPHER_PARMS const *, uint8_t *, size_t, size_t *)
/* 2419 */ _CFFI_OP(_CFFI_OP_POINTER, 3786), // TPMS_SYMCIPHER_PARMS const *
/* 2420 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2421 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2422 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2423 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2424 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_TAGGED_PCR_SELECT const *, uint8_t *, size_t, size_t *)
/* 2425 */ _CFFI_OP(_CFFI_OP_POINTER, 3787), // TPMS_TAGGED_PCR_SELECT const *
/* 2426 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2427 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2428 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2429 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2430 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_TAGGED_POLICY const *, uint8_t *, size_t, size_t *)
/* 2431 */ _CFFI_OP(_CFFI_OP_POINTER, 3790), // TPMS_TAGGED_POLICY const *
/* 2432 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2433 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2434 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2435 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2436 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_TAGGED_PROPERTY const *, uint8_t *, size_t, size_t *)
/* 2437 */ _CFFI_OP(_CFFI_OP_POINTER, 3793), // TPMS_TAGGED_PROPERTY const *
/* 2438 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2439 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2440 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2441 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2442 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_TIME_ATTEST_INFO const *, uint8_t *, size_t, size_t *)
/* 2443 */ _CFFI_OP(_CFFI_OP_POINTER, 3796), // TPMS_TIME_ATTEST_INFO const *
/* 2444 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2445 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2446 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2447 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2448 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMS_TIME_INFO const *, uint8_t *, size_t, size_t *)
/* 2449 */ _CFFI_OP(_CFFI_OP_POINTER, 3797), // TPMS_TIME_INFO const *
/* 2450 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2451 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2452 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2453 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2454 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMT_ASYM_SCHEME const *, uint8_t *, size_t, size_t *)
/* 2455 */ _CFFI_OP(_CFFI_OP_POINTER, 3798), // TPMT_ASYM_SCHEME const *
/* 2456 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2457 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2458 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2459 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2460 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMT_ECC_SCHEME const *, uint8_t *, size_t, size_t *)
/* 2461 */ _CFFI_OP(_CFFI_OP_POINTER, 3799), // TPMT_ECC_SCHEME const *
/* 2462 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2463 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2464 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2465 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2466 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMT_HA const *, uint8_t *, size_t, size_t *)
/* 2467 */ _CFFI_OP(_CFFI_OP_POINTER, 3800), // TPMT_HA const *
/* 2468 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2469 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2470 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2471 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2472 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMT_KDF_SCHEME const *, uint8_t *, size_t, size_t *)
/* 2473 */ _CFFI_OP(_CFFI_OP_POINTER, 3803), // TPMT_KDF_SCHEME const *
/* 2474 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2475 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2476 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2477 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2478 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMT_KEYEDHASH_SCHEME const *, uint8_t *, size_t, size_t *)
/* 2479 */ _CFFI_OP(_CFFI_OP_POINTER, 3804), // TPMT_KEYEDHASH_SCHEME const *
/* 2480 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2481 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2482 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2483 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2484 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMT_PUBLIC *, uint16_t, TPM2B_DIGEST *, TPM2B_DIGEST *, TPMT_SIGNATURE *, void *)
/* 2485 */ _CFFI_OP(_CFFI_OP_POINTER, 3805), // TPMT_PUBLIC *
/* 2486 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 2487 */ _CFFI_OP(_CFFI_OP_NOOP, 1948),
/* 2488 */ _CFFI_OP(_CFFI_OP_NOOP, 1948),
/* 2489 */ _CFFI_OP(_CFFI_OP_POINTER, 3810), // TPMT_SIGNATURE *
/* 2490 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 2491 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2492 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMT_PUBLIC const *, uint8_t *, size_t, size_t *)
/* 2493 */ _CFFI_OP(_CFFI_OP_POINTER, 3805), // TPMT_PUBLIC const *
/* 2494 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2495 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2496 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2497 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2498 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMT_PUBLIC_PARMS const *, uint8_t *, size_t, size_t *)
/* 2499 */ _CFFI_OP(_CFFI_OP_NOOP, 422),
/* 2500 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2501 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2502 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2503 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2504 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMT_RSA_DECRYPT const *, uint8_t *, size_t, size_t *)
/* 2505 */ _CFFI_OP(_CFFI_OP_NOOP, 901),
/* 2506 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2507 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2508 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2509 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2510 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMT_RSA_SCHEME const *, uint8_t *, size_t, size_t *)
/* 2511 */ _CFFI_OP(_CFFI_OP_POINTER, 3808), // TPMT_RSA_SCHEME const *
/* 2512 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2513 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2514 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2515 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2516 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMT_SENSITIVE const *, uint8_t *, size_t, size_t *)
/* 2517 */ _CFFI_OP(_CFFI_OP_POINTER, 3809), // TPMT_SENSITIVE const *
/* 2518 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2519 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2520 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2521 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2522 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMT_SIGNATURE const *, uint8_t *, size_t, size_t *)
/* 2523 */ _CFFI_OP(_CFFI_OP_NOOP, 604),
/* 2524 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2525 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2526 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2527 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2528 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMT_SIG_SCHEME const *, uint8_t *, size_t, size_t *)
/* 2529 */ _CFFI_OP(_CFFI_OP_NOOP, 495),
/* 2530 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2531 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2532 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2533 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2534 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMT_SYM_DEF const *, uint8_t *, size_t, size_t *)
/* 2535 */ _CFFI_OP(_CFFI_OP_NOOP, 1254),
/* 2536 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2537 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2538 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2539 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2540 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMT_SYM_DEF_OBJECT const *, uint8_t *, size_t, size_t *)
/* 2541 */ _CFFI_OP(_CFFI_OP_NOOP, 473),
/* 2542 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2543 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2544 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2545 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2546 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMT_TK_AUTH const *, uint8_t *, size_t, size_t *)
/* 2547 */ _CFFI_OP(_CFFI_OP_NOOP, 536),
/* 2548 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2549 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2550 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2551 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2552 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMT_TK_CREATION const *, uint8_t *, size_t, size_t *)
/* 2553 */ _CFFI_OP(_CFFI_OP_NOOP, 1076),
/* 2554 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2555 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2556 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2557 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2558 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMT_TK_HASHCHECK const *, uint8_t *, size_t, size_t *)
/* 2559 */ _CFFI_OP(_CFFI_OP_NOOP, 624),
/* 2560 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2561 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2562 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2563 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2564 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMT_TK_VERIFIED const *, uint8_t *, size_t, size_t *)
/* 2565 */ _CFFI_OP(_CFFI_OP_NOOP, 547),
/* 2566 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2567 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2568 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2569 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2570 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMU_ASYM_SCHEME const *, uint32_t, uint8_t *, size_t, size_t *)
/* 2571 */ _CFFI_OP(_CFFI_OP_POINTER, 3818), // TPMU_ASYM_SCHEME const *
/* 2572 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 2573 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2574 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2575 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2576 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2577 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMU_ATTEST const *, uint32_t, uint8_t *, size_t, size_t *)
/* 2578 */ _CFFI_OP(_CFFI_OP_POINTER, 3819), // TPMU_ATTEST const *
/* 2579 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 2580 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2581 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2582 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2583 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2584 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMU_CAPABILITIES const *, uint32_t, uint8_t *, size_t, size_t *)
/* 2585 */ _CFFI_OP(_CFFI_OP_POINTER, 3820), // TPMU_CAPABILITIES const *
/* 2586 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 2587 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2588 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2589 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2590 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2591 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMU_ENCRYPTED_SECRET const *, uint32_t, uint8_t *, size_t, size_t *)
/* 2592 */ _CFFI_OP(_CFFI_OP_POINTER, 3821), // TPMU_ENCRYPTED_SECRET const *
/* 2593 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 2594 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2595 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2596 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2597 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2598 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMU_HA const *, uint32_t, uint8_t *, size_t, size_t *)
/* 2599 */ _CFFI_OP(_CFFI_OP_POINTER, 3822), // TPMU_HA const *
/* 2600 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 2601 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2602 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2603 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2604 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2605 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMU_KDF_SCHEME const *, uint32_t, uint8_t *, size_t, size_t *)
/* 2606 */ _CFFI_OP(_CFFI_OP_POINTER, 3823), // TPMU_KDF_SCHEME const *
/* 2607 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 2608 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2609 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2610 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2611 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2612 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMU_NAME const *, uint32_t, uint8_t *, size_t, size_t *)
/* 2613 */ _CFFI_OP(_CFFI_OP_POINTER, 3824), // TPMU_NAME const *
/* 2614 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 2615 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2616 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2617 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2618 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2619 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMU_PUBLIC_ID const *, uint32_t, uint8_t *, size_t, size_t *)
/* 2620 */ _CFFI_OP(_CFFI_OP_POINTER, 3825), // TPMU_PUBLIC_ID const *
/* 2621 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 2622 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2623 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2624 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2625 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2626 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMU_PUBLIC_PARMS const *, uint32_t, uint8_t *, size_t, size_t *)
/* 2627 */ _CFFI_OP(_CFFI_OP_POINTER, 3826), // TPMU_PUBLIC_PARMS const *
/* 2628 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 2629 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2630 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2631 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2632 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2633 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMU_SCHEME_KEYEDHASH const *, uint32_t, uint8_t *, size_t, size_t *)
/* 2634 */ _CFFI_OP(_CFFI_OP_POINTER, 3827), // TPMU_SCHEME_KEYEDHASH const *
/* 2635 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 2636 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2637 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2638 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2639 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2640 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMU_SENSITIVE_COMPOSITE const *, uint32_t, uint8_t *, size_t, size_t *)
/* 2641 */ _CFFI_OP(_CFFI_OP_POINTER, 3828), // TPMU_SENSITIVE_COMPOSITE const *
/* 2642 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 2643 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2644 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2645 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2646 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2647 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMU_SIGNATURE const *, uint32_t, uint8_t *, size_t, size_t *)
/* 2648 */ _CFFI_OP(_CFFI_OP_POINTER, 3830), // TPMU_SIGNATURE const *
/* 2649 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 2650 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2651 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2652 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2653 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2654 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMU_SIG_SCHEME const *, uint32_t, uint8_t *, size_t, size_t *)
/* 2655 */ _CFFI_OP(_CFFI_OP_POINTER, 3831), // TPMU_SIG_SCHEME const *
/* 2656 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 2657 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2658 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2659 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2660 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2661 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMU_SYM_KEY_BITS const *, uint32_t, uint8_t *, size_t, size_t *)
/* 2662 */ _CFFI_OP(_CFFI_OP_POINTER, 3832), // TPMU_SYM_KEY_BITS const *
/* 2663 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 2664 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2665 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2666 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2667 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2668 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TPMU_SYM_MODE const *, uint32_t, uint8_t *, size_t, size_t *)
/* 2669 */ _CFFI_OP(_CFFI_OP_POINTER, 3833), // TPMU_SYM_MODE const *
/* 2670 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 2671 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2672 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2673 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2674 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2675 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TSS2_OBJECT *, char const * *, size_t, size_t *, void *)
/* 2676 */ _CFFI_OP(_CFFI_OP_POINTER, 3835), // TSS2_OBJECT *
/* 2677 */ _CFFI_OP(_CFFI_OP_POINTER, 10), // char const * *
/* 2678 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2679 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2680 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 2681 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2682 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TSS2_POLICY_CTX *)
/* 2683 */ _CFFI_OP(_CFFI_OP_POINTER, 3837), // TSS2_POLICY_CTX *
/* 2684 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2685 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TSS2_POLICY_CTX *, ESYS_CONTEXT *, uint32_t)
/* 2686 */ _CFFI_OP(_CFFI_OP_NOOP, 2683),
/* 2687 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 2688 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 2689 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2690 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TSS2_POLICY_CTX *, TPM2B_DIGEST *)
/* 2691 */ _CFFI_OP(_CFFI_OP_NOOP, 2683),
/* 2692 */ _CFFI_OP(_CFFI_OP_NOOP, 1948),
/* 2693 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2694 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TSS2_POLICY_CTX *, TSS2_POLICY_CALC_CALLBACKS *)
/* 2695 */ _CFFI_OP(_CFFI_OP_NOOP, 2683),
/* 2696 */ _CFFI_OP(_CFFI_OP_POINTER, 3836), // TSS2_POLICY_CALC_CALLBACKS *
/* 2697 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2698 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TSS2_POLICY_CTX *, TSS2_POLICY_EXEC_CALLBACKS *)
/* 2699 */ _CFFI_OP(_CFFI_OP_NOOP, 2683),
/* 2700 */ _CFFI_OP(_CFFI_OP_POINTER, 3838), // TSS2_POLICY_EXEC_CALLBACKS *
/* 2701 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2702 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TSS2_POLICY_CTX *, char *, size_t *)
/* 2703 */ _CFFI_OP(_CFFI_OP_NOOP, 2683),
/* 2704 */ _CFFI_OP(_CFFI_OP_POINTER, 3855), // char *
/* 2705 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2706 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2707 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TSS2_POLICY_PCR_SELECTION *, TPML_PCR_SELECTION *, TPML_DIGEST *, void *)
/* 2708 */ _CFFI_OP(_CFFI_OP_POINTER, 3839), // TSS2_POLICY_PCR_SELECTION *
/* 2709 */ _CFFI_OP(_CFFI_OP_POINTER, 3735), // TPML_PCR_SELECTION *
/* 2710 */ _CFFI_OP(_CFFI_OP_POINTER, 3729), // TPML_DIGEST *
/* 2711 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 2712 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2713 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TSS2_TCTI_CONTEXT *)
/* 2714 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 2715 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2716 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TSS2_TCTI_CONTEXT *, TSS2_TCTI_POLL_HANDLE *, size_t *)
/* 2717 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 2718 */ _CFFI_OP(_CFFI_OP_POINTER, 3851), // TSS2_TCTI_POLL_HANDLE *
/* 2719 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2720 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2721 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TSS2_TCTI_CONTEXT *, size_t *, TSS2_TCTI_SPI_HELPER_PLATFORM *)
/* 2722 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 2723 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2724 */ _CFFI_OP(_CFFI_OP_POINTER, 3852), // TSS2_TCTI_SPI_HELPER_PLATFORM *
/* 2725 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2726 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TSS2_TCTI_CONTEXT *, size_t *, char const *)
/* 2727 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 2728 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2729 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 2730 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2731 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TSS2_TCTI_CONTEXT *, size_t *, uint8_t *, int32_t)
/* 2732 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 2733 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2734 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2735 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 2736 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2737 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TSS2_TCTI_CONTEXT *, size_t, uint8_t const *)
/* 2738 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 2739 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2740 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 2741 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2742 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TSS2_TCTI_CONTEXT *, uint32_t *, uint8_t)
/* 2743 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 2744 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 2745 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18),
/* 2746 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2747 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(TSS2_TCTI_CONTEXT *, uint8_t)
/* 2748 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 2749 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18),
/* 2750 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2751 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(char *, char *, uint16_t, uint8_t *, size_t, uint8_t const * *, size_t *, void *)
/* 2752 */ _CFFI_OP(_CFFI_OP_NOOP, 2704),
/* 2753 */ _CFFI_OP(_CFFI_OP_NOOP, 2704),
/* 2754 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 2755 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2756 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2757 */ _CFFI_OP(_CFFI_OP_POINTER, 1611), // uint8_t const * *
/* 2758 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2759 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 2760 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2761 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(char const *, TPM2B_NAME *, void *)
/* 2762 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 2763 */ _CFFI_OP(_CFFI_OP_NOOP, 347),
/* 2764 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 2765 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2766 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(char const *, TPMT_PUBLIC *, void *)
/* 2767 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 2768 */ _CFFI_OP(_CFFI_OP_NOOP, 2485),
/* 2769 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 2770 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2771 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(char const *, TSS2_TCTI_CONTEXT * *)
/* 2772 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 2773 */ _CFFI_OP(_CFFI_OP_NOOP, 192),
/* 2774 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2775 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(char const *, TSS2_TCTI_INFO * *)
/* 2776 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 2777 */ _CFFI_OP(_CFFI_OP_POINTER, 3847), // TSS2_TCTI_INFO * *
/* 2778 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2779 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(char const *, char const *, TSS2_TCTI_CONTEXT * *)
/* 2780 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 2781 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 2782 */ _CFFI_OP(_CFFI_OP_NOOP, 192),
/* 2783 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2784 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(char const *, char const *, char const * *, size_t, size_t *, void *)
/* 2785 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 2786 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 2787 */ _CFFI_OP(_CFFI_OP_NOOP, 2677),
/* 2788 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2789 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2790 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 2791 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2792 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(char const *, char const *, char const * *, void *)
/* 2793 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 2794 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 2795 */ _CFFI_OP(_CFFI_OP_NOOP, 2677),
/* 2796 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 2797 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2798 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(char const *, char const *, char const *, char const *, uint32_t, uint8_t const *, size_t, uint8_t const * *, size_t *, void *)
/* 2799 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 2800 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 2801 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 2802 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 2803 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 2804 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 2805 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2806 */ _CFFI_OP(_CFFI_OP_NOOP, 2757),
/* 2807 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2808 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 2809 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2810 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(char const *, char const *, void *)
/* 2811 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 2812 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 2813 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 2814 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2815 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(char const *, uint16_t, TSS2_POLICY_CTX * *)
/* 2816 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 2817 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 2818 */ _CFFI_OP(_CFFI_OP_POINTER, 2683), // TSS2_POLICY_CTX * *
/* 2819 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2820 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(char const *, uint32_t, TPMS_NV_PUBLIC *, void *)
/* 2821 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 2822 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 2823 */ _CFFI_OP(_CFFI_OP_NOOP, 2342),
/* 2824 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 2825 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2826 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(char const *, void *)
/* 2827 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 2828 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 2829 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2830 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(int16_t, uint8_t *, size_t, size_t *)
/* 2831 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 19), // int16_t
/* 2832 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2833 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2834 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2835 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2836 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(int32_t, uint8_t *, size_t, size_t *)
/* 2837 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 2838 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2839 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2840 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2841 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2842 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(int64_t, uint8_t *, size_t, size_t *)
/* 2843 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 23), // int64_t
/* 2844 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2845 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2846 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2847 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2848 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(int8_t, uint8_t *, size_t, size_t *)
/* 2849 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 17),
/* 2850 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2851 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2852 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2853 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2854 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint16_t, uint8_t *, size_t, size_t *)
/* 2855 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 2856 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2857 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2858 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2859 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2860 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint32_t, TSS2_RC_INFO *)
/* 2861 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 2862 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 2863 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2864 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint32_t, uint8_t *, size_t, size_t *)
/* 2865 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 2866 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2867 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2868 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2869 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2870 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint64_t, uint8_t *, size_t, size_t *)
/* 2871 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 2872 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2873 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2874 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2875 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2876 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t *, uint16_t, uint16_t, uint16_t, uint8_t *, size_t, uint8_t *, void *)
/* 2877 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2878 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 2879 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 2880 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 2881 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2882 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2883 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 2884 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 2885 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2886 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_ATTEST *)
/* 2887 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 2888 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2889 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2890 */ _CFFI_OP(_CFFI_OP_POINTER, 3692), // TPM2B_ATTEST *
/* 2891 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2892 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_CONTEXT_DATA *)
/* 2893 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 2894 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2895 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2896 */ _CFFI_OP(_CFFI_OP_POINTER, 3693), // TPM2B_CONTEXT_DATA *
/* 2897 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2898 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_CONTEXT_SENSITIVE *)
/* 2899 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 2900 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2901 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2902 */ _CFFI_OP(_CFFI_OP_POINTER, 3694), // TPM2B_CONTEXT_SENSITIVE *
/* 2903 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2904 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_CREATION_DATA *)
/* 2905 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 2906 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2907 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2908 */ _CFFI_OP(_CFFI_OP_POINTER, 3695), // TPM2B_CREATION_DATA *
/* 2909 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2910 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_DATA *)
/* 2911 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 2912 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2913 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2914 */ _CFFI_OP(_CFFI_OP_POINTER, 3696), // TPM2B_DATA *
/* 2915 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2916 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_DIGEST *)
/* 2917 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 2918 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2919 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2920 */ _CFFI_OP(_CFFI_OP_NOOP, 1948),
/* 2921 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2922 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_ECC_PARAMETER *)
/* 2923 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 2924 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2925 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2926 */ _CFFI_OP(_CFFI_OP_NOOP, 2055),
/* 2927 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2928 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_ECC_POINT *)
/* 2929 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 2930 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2931 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2932 */ _CFFI_OP(_CFFI_OP_POINTER, 3702), // TPM2B_ECC_POINT *
/* 2933 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2934 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_ENCRYPTED_SECRET *)
/* 2935 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 2936 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2937 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2938 */ _CFFI_OP(_CFFI_OP_POINTER, 3703), // TPM2B_ENCRYPTED_SECRET *
/* 2939 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2940 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_EVENT *)
/* 2941 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 2942 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2943 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2944 */ _CFFI_OP(_CFFI_OP_POINTER, 3704), // TPM2B_EVENT *
/* 2945 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2946 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_ID_OBJECT *)
/* 2947 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 2948 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2949 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2950 */ _CFFI_OP(_CFFI_OP_POINTER, 3705), // TPM2B_ID_OBJECT *
/* 2951 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2952 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_IV *)
/* 2953 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 2954 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2955 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2956 */ _CFFI_OP(_CFFI_OP_POINTER, 3706), // TPM2B_IV *
/* 2957 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2958 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_MAX_BUFFER *)
/* 2959 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 2960 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2961 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2962 */ _CFFI_OP(_CFFI_OP_NOOP, 1455),
/* 2963 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2964 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_MAX_CAP_BUFFER *)
/* 2965 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 2966 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2967 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2968 */ _CFFI_OP(_CFFI_OP_POINTER, 3709), // TPM2B_MAX_CAP_BUFFER *
/* 2969 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2970 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_MAX_NV_BUFFER *)
/* 2971 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 2972 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2973 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2974 */ _CFFI_OP(_CFFI_OP_POINTER, 3710), // TPM2B_MAX_NV_BUFFER *
/* 2975 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2976 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_NAME *)
/* 2977 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 2978 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2979 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2980 */ _CFFI_OP(_CFFI_OP_NOOP, 347),
/* 2981 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2982 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_NV_PUBLIC *)
/* 2983 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 2984 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2985 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2986 */ _CFFI_OP(_CFFI_OP_POINTER, 3712), // TPM2B_NV_PUBLIC *
/* 2987 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2988 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_PRIVATE *)
/* 2989 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 2990 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2991 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2992 */ _CFFI_OP(_CFFI_OP_POINTER, 3713), // TPM2B_PRIVATE *
/* 2993 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 2994 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_PRIVATE_KEY_RSA *)
/* 2995 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 2996 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 2997 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 2998 */ _CFFI_OP(_CFFI_OP_POINTER, 3714), // TPM2B_PRIVATE_KEY_RSA *
/* 2999 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3000 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_PUBLIC *)
/* 3001 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3002 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3003 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3004 */ _CFFI_OP(_CFFI_OP_NOOP, 2053),
/* 3005 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3006 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_PUBLIC_KEY_RSA *)
/* 3007 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3008 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3009 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3010 */ _CFFI_OP(_CFFI_OP_POINTER, 3717), // TPM2B_PUBLIC_KEY_RSA *
/* 3011 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3012 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_SENSITIVE *)
/* 3013 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3014 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3015 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3016 */ _CFFI_OP(_CFFI_OP_POINTER, 3718), // TPM2B_SENSITIVE *
/* 3017 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3018 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_SENSITIVE_CREATE *)
/* 3019 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3020 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3021 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3022 */ _CFFI_OP(_CFFI_OP_POINTER, 3719), // TPM2B_SENSITIVE_CREATE *
/* 3023 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3024 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_SENSITIVE_DATA *)
/* 3025 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3026 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3027 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3028 */ _CFFI_OP(_CFFI_OP_POINTER, 3720), // TPM2B_SENSITIVE_DATA *
/* 3029 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3030 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_SYM_KEY *)
/* 3031 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3032 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3033 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3034 */ _CFFI_OP(_CFFI_OP_POINTER, 3721), // TPM2B_SYM_KEY *
/* 3035 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3036 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPM2B_TEMPLATE *)
/* 3037 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3038 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3039 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3040 */ _CFFI_OP(_CFFI_OP_POINTER, 3722), // TPM2B_TEMPLATE *
/* 3041 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3042 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPML_ACT_DATA *)
/* 3043 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3044 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3045 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3046 */ _CFFI_OP(_CFFI_OP_POINTER, 3723), // TPML_ACT_DATA *
/* 3047 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3048 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPML_AC_CAPABILITIES *)
/* 3049 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3050 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3051 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3052 */ _CFFI_OP(_CFFI_OP_POINTER, 3724), // TPML_AC_CAPABILITIES *
/* 3053 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3054 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPML_ALG *)
/* 3055 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3056 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3057 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3058 */ _CFFI_OP(_CFFI_OP_POINTER, 3725), // TPML_ALG *
/* 3059 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3060 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPML_ALG_PROPERTY *)
/* 3061 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3062 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3063 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3064 */ _CFFI_OP(_CFFI_OP_POINTER, 3726), // TPML_ALG_PROPERTY *
/* 3065 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3066 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPML_CC *)
/* 3067 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3068 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3069 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3070 */ _CFFI_OP(_CFFI_OP_POINTER, 3727), // TPML_CC *
/* 3071 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3072 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPML_CCA *)
/* 3073 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3074 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3075 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3076 */ _CFFI_OP(_CFFI_OP_POINTER, 3728), // TPML_CCA *
/* 3077 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3078 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPML_DIGEST *)
/* 3079 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3080 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3081 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3082 */ _CFFI_OP(_CFFI_OP_NOOP, 2710),
/* 3083 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3084 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPML_DIGEST_VALUES *)
/* 3085 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3086 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3087 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3088 */ _CFFI_OP(_CFFI_OP_POINTER, 3730), // TPML_DIGEST_VALUES *
/* 3089 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3090 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPML_ECC_CURVE *)
/* 3091 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3092 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3093 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3094 */ _CFFI_OP(_CFFI_OP_POINTER, 3731), // TPML_ECC_CURVE *
/* 3095 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3096 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPML_HANDLE *)
/* 3097 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3098 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3099 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3100 */ _CFFI_OP(_CFFI_OP_POINTER, 3732), // TPML_HANDLE *
/* 3101 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3102 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPML_INTEL_PTT_PROPERTY *)
/* 3103 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3104 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3105 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3106 */ _CFFI_OP(_CFFI_OP_POINTER, 3733), // TPML_INTEL_PTT_PROPERTY *
/* 3107 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3108 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPML_PCR_SELECTION *)
/* 3109 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3110 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3111 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3112 */ _CFFI_OP(_CFFI_OP_NOOP, 2709),
/* 3113 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3114 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPML_TAGGED_PCR_PROPERTY *)
/* 3115 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3116 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3117 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3118 */ _CFFI_OP(_CFFI_OP_POINTER, 3736), // TPML_TAGGED_PCR_PROPERTY *
/* 3119 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3120 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPML_TAGGED_POLICY *)
/* 3121 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3122 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3123 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3124 */ _CFFI_OP(_CFFI_OP_POINTER, 3737), // TPML_TAGGED_POLICY *
/* 3125 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3126 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPML_TAGGED_TPM_PROPERTY *)
/* 3127 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3128 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3129 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3130 */ _CFFI_OP(_CFFI_OP_POINTER, 3738), // TPML_TAGGED_TPM_PROPERTY *
/* 3131 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3132 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_ACT_DATA *)
/* 3133 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3134 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3135 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3136 */ _CFFI_OP(_CFFI_OP_POINTER, 3739), // TPMS_ACT_DATA *
/* 3137 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3138 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_AC_OUTPUT *)
/* 3139 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3140 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3141 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3142 */ _CFFI_OP(_CFFI_OP_POINTER, 3742), // TPMS_AC_OUTPUT *
/* 3143 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3144 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_ALGORITHM_DETAIL_ECC *)
/* 3145 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3146 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3147 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3148 */ _CFFI_OP(_CFFI_OP_POINTER, 3745), // TPMS_ALGORITHM_DETAIL_ECC *
/* 3149 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3150 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_ALG_PROPERTY *)
/* 3151 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3152 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3153 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3154 */ _CFFI_OP(_CFFI_OP_POINTER, 3746), // TPMS_ALG_PROPERTY *
/* 3155 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3156 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_ATTEST *)
/* 3157 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3158 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3159 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3160 */ _CFFI_OP(_CFFI_OP_POINTER, 3750), // TPMS_ATTEST *
/* 3161 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3162 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_AUTH_COMMAND *)
/* 3163 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3164 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3165 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3166 */ _CFFI_OP(_CFFI_OP_POINTER, 3751), // TPMS_AUTH_COMMAND *
/* 3167 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3168 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_AUTH_RESPONSE *)
/* 3169 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3170 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3171 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3172 */ _CFFI_OP(_CFFI_OP_POINTER, 3752), // TPMS_AUTH_RESPONSE *
/* 3173 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3174 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_CAPABILITY_DATA *)
/* 3175 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3176 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3177 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3178 */ _CFFI_OP(_CFFI_OP_POINTER, 3753), // TPMS_CAPABILITY_DATA *
/* 3179 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3180 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_CERTIFY_INFO *)
/* 3181 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3182 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3183 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3184 */ _CFFI_OP(_CFFI_OP_POINTER, 3754), // TPMS_CERTIFY_INFO *
/* 3185 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3186 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_CLOCK_INFO *)
/* 3187 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3188 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3189 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3190 */ _CFFI_OP(_CFFI_OP_POINTER, 3755), // TPMS_CLOCK_INFO *
/* 3191 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3192 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_COMMAND_AUDIT_INFO *)
/* 3193 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3194 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3195 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3196 */ _CFFI_OP(_CFFI_OP_POINTER, 3756), // TPMS_COMMAND_AUDIT_INFO *
/* 3197 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3198 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_CONTEXT *)
/* 3199 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3200 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3201 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3202 */ _CFFI_OP(_CFFI_OP_POINTER, 3757), // TPMS_CONTEXT *
/* 3203 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3204 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_CONTEXT_DATA *)
/* 3205 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3206 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3207 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3208 */ _CFFI_OP(_CFFI_OP_POINTER, 3758), // TPMS_CONTEXT_DATA *
/* 3209 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3210 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_CREATION_DATA *)
/* 3211 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3212 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3213 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3214 */ _CFFI_OP(_CFFI_OP_POINTER, 3759), // TPMS_CREATION_DATA *
/* 3215 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3216 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_CREATION_INFO *)
/* 3217 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3218 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3219 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3220 */ _CFFI_OP(_CFFI_OP_POINTER, 3760), // TPMS_CREATION_INFO *
/* 3221 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3222 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_ECC_PARMS *)
/* 3223 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3224 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3225 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3226 */ _CFFI_OP(_CFFI_OP_POINTER, 3762), // TPMS_ECC_PARMS *
/* 3227 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3228 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_ECC_POINT *)
/* 3229 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3230 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3231 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3232 */ _CFFI_OP(_CFFI_OP_NOOP, 2056),
/* 3233 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3234 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_EMPTY *)
/* 3235 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3236 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3237 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3238 */ _CFFI_OP(_CFFI_OP_POINTER, 3764), // TPMS_EMPTY *
/* 3239 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3240 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_ID_OBJECT *)
/* 3241 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3242 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3243 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3244 */ _CFFI_OP(_CFFI_OP_POINTER, 3765), // TPMS_ID_OBJECT *
/* 3245 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3246 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_KEYEDHASH_PARMS *)
/* 3247 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3248 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3249 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3250 */ _CFFI_OP(_CFFI_OP_POINTER, 3766), // TPMS_KEYEDHASH_PARMS *
/* 3251 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3252 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_NV_CERTIFY_INFO *)
/* 3253 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3254 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3255 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3256 */ _CFFI_OP(_CFFI_OP_POINTER, 3767), // TPMS_NV_CERTIFY_INFO *
/* 3257 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3258 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_NV_DIGEST_CERTIFY_INFO *)
/* 3259 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3260 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3261 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3262 */ _CFFI_OP(_CFFI_OP_POINTER, 3768), // TPMS_NV_DIGEST_CERTIFY_INFO *
/* 3263 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3264 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_NV_PIN_COUNTER_PARAMETERS *)
/* 3265 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3266 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3267 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3268 */ _CFFI_OP(_CFFI_OP_POINTER, 3769), // TPMS_NV_PIN_COUNTER_PARAMETERS *
/* 3269 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3270 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_NV_PUBLIC *)
/* 3271 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3272 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3273 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3274 */ _CFFI_OP(_CFFI_OP_NOOP, 2342),
/* 3275 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3276 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_PCR_SELECT *)
/* 3277 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3278 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3279 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3280 */ _CFFI_OP(_CFFI_OP_POINTER, 3773), // TPMS_PCR_SELECT *
/* 3281 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3282 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_PCR_SELECTION *)
/* 3283 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3284 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3285 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3286 */ _CFFI_OP(_CFFI_OP_POINTER, 3774), // TPMS_PCR_SELECTION *
/* 3287 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3288 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_QUOTE_INFO *)
/* 3289 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3290 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3291 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3292 */ _CFFI_OP(_CFFI_OP_POINTER, 3777), // TPMS_QUOTE_INFO *
/* 3293 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3294 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_RSA_PARMS *)
/* 3295 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3296 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3297 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3298 */ _CFFI_OP(_CFFI_OP_POINTER, 3778), // TPMS_RSA_PARMS *
/* 3299 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3300 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_SCHEME_ECDAA *)
/* 3301 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3302 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3303 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3304 */ _CFFI_OP(_CFFI_OP_POINTER, 3779), // TPMS_SCHEME_ECDAA *
/* 3305 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3306 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_SCHEME_HASH *)
/* 3307 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3308 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3309 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3310 */ _CFFI_OP(_CFFI_OP_POINTER, 3780), // TPMS_SCHEME_HASH *
/* 3311 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3312 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_SCHEME_XOR *)
/* 3313 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3314 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3315 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3316 */ _CFFI_OP(_CFFI_OP_POINTER, 3781), // TPMS_SCHEME_XOR *
/* 3317 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3318 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_SENSITIVE_CREATE *)
/* 3319 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3320 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3321 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3322 */ _CFFI_OP(_CFFI_OP_POINTER, 3782), // TPMS_SENSITIVE_CREATE *
/* 3323 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3324 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_SESSION_AUDIT_INFO *)
/* 3325 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3326 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3327 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3328 */ _CFFI_OP(_CFFI_OP_POINTER, 3783), // TPMS_SESSION_AUDIT_INFO *
/* 3329 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3330 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_SIGNATURE_ECC *)
/* 3331 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3332 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3333 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3334 */ _CFFI_OP(_CFFI_OP_POINTER, 3784), // TPMS_SIGNATURE_ECC *
/* 3335 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3336 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_SIGNATURE_RSA *)
/* 3337 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3338 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3339 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3340 */ _CFFI_OP(_CFFI_OP_POINTER, 3785), // TPMS_SIGNATURE_RSA *
/* 3341 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3342 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_SYMCIPHER_PARMS *)
/* 3343 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3344 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3345 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3346 */ _CFFI_OP(_CFFI_OP_POINTER, 3786), // TPMS_SYMCIPHER_PARMS *
/* 3347 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3348 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_TAGGED_PCR_SELECT *)
/* 3349 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3350 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3351 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3352 */ _CFFI_OP(_CFFI_OP_POINTER, 3787), // TPMS_TAGGED_PCR_SELECT *
/* 3353 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3354 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_TAGGED_POLICY *)
/* 3355 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3356 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3357 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3358 */ _CFFI_OP(_CFFI_OP_POINTER, 3790), // TPMS_TAGGED_POLICY *
/* 3359 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3360 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_TAGGED_PROPERTY *)
/* 3361 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3362 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3363 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3364 */ _CFFI_OP(_CFFI_OP_POINTER, 3793), // TPMS_TAGGED_PROPERTY *
/* 3365 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3366 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_TIME_ATTEST_INFO *)
/* 3367 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3368 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3369 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3370 */ _CFFI_OP(_CFFI_OP_POINTER, 3796), // TPMS_TIME_ATTEST_INFO *
/* 3371 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3372 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMS_TIME_INFO *)
/* 3373 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3374 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3375 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3376 */ _CFFI_OP(_CFFI_OP_POINTER, 3797), // TPMS_TIME_INFO *
/* 3377 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3378 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMT_ASYM_SCHEME *)
/* 3379 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3380 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3381 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3382 */ _CFFI_OP(_CFFI_OP_POINTER, 3798), // TPMT_ASYM_SCHEME *
/* 3383 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3384 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMT_ECC_SCHEME *)
/* 3385 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3386 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3387 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3388 */ _CFFI_OP(_CFFI_OP_POINTER, 3799), // TPMT_ECC_SCHEME *
/* 3389 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3390 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMT_HA *)
/* 3391 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3392 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3393 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3394 */ _CFFI_OP(_CFFI_OP_POINTER, 3800), // TPMT_HA *
/* 3395 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3396 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMT_KDF_SCHEME *)
/* 3397 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3398 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3399 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3400 */ _CFFI_OP(_CFFI_OP_POINTER, 3803), // TPMT_KDF_SCHEME *
/* 3401 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3402 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMT_KEYEDHASH_SCHEME *)
/* 3403 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3404 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3405 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3406 */ _CFFI_OP(_CFFI_OP_POINTER, 3804), // TPMT_KEYEDHASH_SCHEME *
/* 3407 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3408 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMT_PUBLIC *)
/* 3409 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3410 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3411 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3412 */ _CFFI_OP(_CFFI_OP_NOOP, 2485),
/* 3413 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3414 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMT_PUBLIC_PARMS *)
/* 3415 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3416 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3417 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3418 */ _CFFI_OP(_CFFI_OP_POINTER, 3806), // TPMT_PUBLIC_PARMS *
/* 3419 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3420 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMT_RSA_DECRYPT *)
/* 3421 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3422 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3423 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3424 */ _CFFI_OP(_CFFI_OP_POINTER, 3807), // TPMT_RSA_DECRYPT *
/* 3425 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3426 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMT_RSA_SCHEME *)
/* 3427 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3428 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3429 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3430 */ _CFFI_OP(_CFFI_OP_POINTER, 3808), // TPMT_RSA_SCHEME *
/* 3431 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3432 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMT_SENSITIVE *)
/* 3433 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3434 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3435 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3436 */ _CFFI_OP(_CFFI_OP_POINTER, 3809), // TPMT_SENSITIVE *
/* 3437 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3438 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMT_SIGNATURE *)
/* 3439 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3440 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3441 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3442 */ _CFFI_OP(_CFFI_OP_NOOP, 2489),
/* 3443 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3444 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMT_SIG_SCHEME *)
/* 3445 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3446 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3447 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3448 */ _CFFI_OP(_CFFI_OP_POINTER, 3811), // TPMT_SIG_SCHEME *
/* 3449 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3450 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMT_SYM_DEF *)
/* 3451 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3452 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3453 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3454 */ _CFFI_OP(_CFFI_OP_POINTER, 3812), // TPMT_SYM_DEF *
/* 3455 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3456 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMT_SYM_DEF_OBJECT *)
/* 3457 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3458 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3459 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3460 */ _CFFI_OP(_CFFI_OP_POINTER, 3813), // TPMT_SYM_DEF_OBJECT *
/* 3461 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3462 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMT_TK_AUTH *)
/* 3463 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3464 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3465 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3466 */ _CFFI_OP(_CFFI_OP_POINTER, 3814), // TPMT_TK_AUTH *
/* 3467 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3468 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMT_TK_CREATION *)
/* 3469 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3470 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3471 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3472 */ _CFFI_OP(_CFFI_OP_POINTER, 3815), // TPMT_TK_CREATION *
/* 3473 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3474 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMT_TK_HASHCHECK *)
/* 3475 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3476 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3477 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3478 */ _CFFI_OP(_CFFI_OP_POINTER, 3816), // TPMT_TK_HASHCHECK *
/* 3479 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3480 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, TPMT_TK_VERIFIED *)
/* 3481 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3482 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3483 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3484 */ _CFFI_OP(_CFFI_OP_POINTER, 3817), // TPMT_TK_VERIFIED *
/* 3485 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3486 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, int16_t *)
/* 3487 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3488 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3489 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3490 */ _CFFI_OP(_CFFI_OP_POINTER, 2831), // int16_t *
/* 3491 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3492 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, int32_t *)
/* 3493 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3494 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3495 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3496 */ _CFFI_OP(_CFFI_OP_POINTER, 201), // int32_t *
/* 3497 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3498 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, int64_t *)
/* 3499 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3500 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3501 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3502 */ _CFFI_OP(_CFFI_OP_POINTER, 2843), // int64_t *
/* 3503 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3504 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, int8_t *)
/* 3505 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3506 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3507 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3508 */ _CFFI_OP(_CFFI_OP_POINTER, 1038), // int8_t *
/* 3509 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3510 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, uint16_t *)
/* 3511 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3512 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3513 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3514 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 3515 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3516 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, uint32_t *)
/* 3517 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3518 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3519 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3520 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 3521 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3522 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, uint32_t, TPMU_ASYM_SCHEME *)
/* 3523 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3524 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3525 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3526 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 3527 */ _CFFI_OP(_CFFI_OP_POINTER, 3818), // TPMU_ASYM_SCHEME *
/* 3528 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3529 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, uint32_t, TPMU_ATTEST *)
/* 3530 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3531 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3532 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3533 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 3534 */ _CFFI_OP(_CFFI_OP_POINTER, 3819), // TPMU_ATTEST *
/* 3535 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3536 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, uint32_t, TPMU_CAPABILITIES *)
/* 3537 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3538 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3539 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3540 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 3541 */ _CFFI_OP(_CFFI_OP_POINTER, 3820), // TPMU_CAPABILITIES *
/* 3542 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3543 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, uint32_t, TPMU_ENCRYPTED_SECRET *)
/* 3544 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3545 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3546 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3547 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 3548 */ _CFFI_OP(_CFFI_OP_POINTER, 3821), // TPMU_ENCRYPTED_SECRET *
/* 3549 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3550 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, uint32_t, TPMU_HA *)
/* 3551 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3552 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3553 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3554 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 3555 */ _CFFI_OP(_CFFI_OP_POINTER, 3822), // TPMU_HA *
/* 3556 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3557 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, uint32_t, TPMU_KDF_SCHEME *)
/* 3558 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3559 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3560 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3561 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 3562 */ _CFFI_OP(_CFFI_OP_POINTER, 3823), // TPMU_KDF_SCHEME *
/* 3563 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3564 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, uint32_t, TPMU_NAME *)
/* 3565 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3566 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3567 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3568 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 3569 */ _CFFI_OP(_CFFI_OP_POINTER, 3824), // TPMU_NAME *
/* 3570 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3571 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, uint32_t, TPMU_PUBLIC_ID *)
/* 3572 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3573 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3574 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3575 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 3576 */ _CFFI_OP(_CFFI_OP_POINTER, 3825), // TPMU_PUBLIC_ID *
/* 3577 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3578 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, uint32_t, TPMU_PUBLIC_PARMS *)
/* 3579 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3580 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3581 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3582 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 3583 */ _CFFI_OP(_CFFI_OP_POINTER, 3826), // TPMU_PUBLIC_PARMS *
/* 3584 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3585 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, uint32_t, TPMU_SCHEME_KEYEDHASH *)
/* 3586 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3587 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3588 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3589 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 3590 */ _CFFI_OP(_CFFI_OP_POINTER, 3827), // TPMU_SCHEME_KEYEDHASH *
/* 3591 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3592 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, uint32_t, TPMU_SENSITIVE_COMPOSITE *)
/* 3593 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3594 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3595 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3596 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 3597 */ _CFFI_OP(_CFFI_OP_POINTER, 3828), // TPMU_SENSITIVE_COMPOSITE *
/* 3598 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3599 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, uint32_t, TPMU_SIGNATURE *)
/* 3600 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3601 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3602 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3603 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 3604 */ _CFFI_OP(_CFFI_OP_POINTER, 3830), // TPMU_SIGNATURE *
/* 3605 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3606 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, uint32_t, TPMU_SIG_SCHEME *)
/* 3607 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3608 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3609 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3610 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 3611 */ _CFFI_OP(_CFFI_OP_POINTER, 3831), // TPMU_SIG_SCHEME *
/* 3612 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3613 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, uint32_t, TPMU_SYM_KEY_BITS *)
/* 3614 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3615 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3616 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3617 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 3618 */ _CFFI_OP(_CFFI_OP_POINTER, 3832), // TPMU_SYM_KEY_BITS *
/* 3619 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3620 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, uint32_t, TPMU_SYM_MODE *)
/* 3621 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3622 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3623 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3624 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 3625 */ _CFFI_OP(_CFFI_OP_POINTER, 3833), // TPMU_SYM_MODE *
/* 3626 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3627 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, uint64_t *)
/* 3628 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3629 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3630 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3631 */ _CFFI_OP(_CFFI_OP_POINTER, 1517), // uint64_t *
/* 3632 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3633 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t const *, size_t, size_t *, uint8_t *)
/* 3634 */ _CFFI_OP(_CFFI_OP_NOOP, 1611),
/* 3635 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3636 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3637 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 3638 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3639 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(uint8_t, uint8_t *, size_t, size_t *)
/* 3640 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18),
/* 3641 */ _CFFI_OP(_CFFI_OP_NOOP, 1027),
/* 3642 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3643 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 3644 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3645 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(void *)
/* 3646 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 3647 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3648 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(void *, _Bool *)
/* 3649 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 3650 */ _CFFI_OP(_CFFI_OP_POINTER, 3853), // _Bool *
/* 3651 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3652 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(void *, int)
/* 3653 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 3654 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 3655 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3656 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // uint32_t()(void *, void const *, void *, size_t)
/* 3657 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 3658 */ _CFFI_OP(_CFFI_OP_POINTER, 3980), // void const *
/* 3659 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 3660 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 3661 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3662 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3980), // void()(ESYS_CONTEXT * *)
/* 3663 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 3664 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3665 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3980), // void()(ESYS_CRYPTO_CONTEXT_BLOB * *, void *)
/* 3666 */ _CFFI_OP(_CFFI_OP_NOOP, 1616),
/* 3667 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 3668 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3669 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3980), // void()(FAPI_CONTEXT * *)
/* 3670 */ _CFFI_OP(_CFFI_OP_NOOP, 1640),
/* 3671 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3672 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3980), // void()(TSS2_POLICY_CTX * *)
/* 3673 */ _CFFI_OP(_CFFI_OP_NOOP, 2818),
/* 3674 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3675 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3980), // void()(TSS2_TCTI_CONTEXT * *)
/* 3676 */ _CFFI_OP(_CFFI_OP_NOOP, 192),
/* 3677 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3678 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3980), // void()(TSS2_TCTI_CONTEXT *)
/* 3679 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 3680 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3681 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3980), // void()(TSS2_TCTI_INFO * *)
/* 3682 */ _CFFI_OP(_CFFI_OP_NOOP, 2777),
/* 3683 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3684 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3980), // void()(void *)
/* 3685 */ _CFFI_OP(_CFFI_OP_NOOP, 1620),
/* 3686 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 3687 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // ESYS_CONTEXT
/* 3688 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // ESYS_CRYPTO_CALLBACKS
/* 3689 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // ESYS_CRYPTO_CONTEXT_BLOB
/* 3690 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // FAPI_CONTEXT
/* 3691 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // PYTCTI_CONTEXT
/* 3692 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // TPM2B_ATTEST
/* 3693 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // TPM2B_CONTEXT_DATA
/* 3694 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // TPM2B_CONTEXT_SENSITIVE
/* 3695 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // TPM2B_CREATION_DATA
/* 3696 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // TPM2B_DATA
/* 3697 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // TPM2B_DERIVE
/* 3698 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // TPM2B_DIGEST
/* 3699 */ _CFFI_OP(_CFFI_OP_ARRAY, 3698), // TPM2B_DIGEST[_cffi_array_len(((TPML_DIGEST *)0)->digests)]
/* 3700 */ (_cffi_opcode_t)(_cffi_array_len(((TPML_DIGEST *)0)->digests)),
/* 3701 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // TPM2B_ECC_PARAMETER
/* 3702 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 13), // TPM2B_ECC_POINT
/* 3703 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 14), // TPM2B_ENCRYPTED_SECRET
/* 3704 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 15), // TPM2B_EVENT
/* 3705 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 16), // TPM2B_ID_OBJECT
/* 3706 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 17), // TPM2B_IV
/* 3707 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 18), // TPM2B_LABEL
/* 3708 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 19), // TPM2B_MAX_BUFFER
/* 3709 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 20), // TPM2B_MAX_CAP_BUFFER
/* 3710 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 21), // TPM2B_MAX_NV_BUFFER
/* 3711 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 22), // TPM2B_NAME
/* 3712 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 23), // TPM2B_NV_PUBLIC
/* 3713 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 24), // TPM2B_PRIVATE
/* 3714 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 25), // TPM2B_PRIVATE_KEY_RSA
/* 3715 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 26), // TPM2B_PRIVATE_VENDOR_SPECIFIC
/* 3716 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 27), // TPM2B_PUBLIC
/* 3717 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 28), // TPM2B_PUBLIC_KEY_RSA
/* 3718 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 29), // TPM2B_SENSITIVE
/* 3719 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 30), // TPM2B_SENSITIVE_CREATE
/* 3720 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 31), // TPM2B_SENSITIVE_DATA
/* 3721 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 32), // TPM2B_SYM_KEY
/* 3722 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 33), // TPM2B_TEMPLATE
/* 3723 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 34), // TPML_ACT_DATA
/* 3724 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 35), // TPML_AC_CAPABILITIES
/* 3725 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 36), // TPML_ALG
/* 3726 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 37), // TPML_ALG_PROPERTY
/* 3727 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 38), // TPML_CC
/* 3728 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 39), // TPML_CCA
/* 3729 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 40), // TPML_DIGEST
/* 3730 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 41), // TPML_DIGEST_VALUES
/* 3731 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 42), // TPML_ECC_CURVE
/* 3732 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 43), // TPML_HANDLE
/* 3733 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 44), // TPML_INTEL_PTT_PROPERTY
/* 3734 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 45), // TPML_PCRVALUES
/* 3735 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 46), // TPML_PCR_SELECTION
/* 3736 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 47), // TPML_TAGGED_PCR_PROPERTY
/* 3737 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 48), // TPML_TAGGED_POLICY
/* 3738 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 49), // TPML_TAGGED_TPM_PROPERTY
/* 3739 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 50), // TPMS_ACT_DATA
/* 3740 */ _CFFI_OP(_CFFI_OP_ARRAY, 3739), // TPMS_ACT_DATA[_cffi_array_len(((TPML_ACT_DATA *)0)->actData)]
/* 3741 */ (_cffi_opcode_t)(_cffi_array_len(((TPML_ACT_DATA *)0)->actData)),
/* 3742 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 51), // TPMS_AC_OUTPUT
/* 3743 */ _CFFI_OP(_CFFI_OP_ARRAY, 3742), // TPMS_AC_OUTPUT[_cffi_array_len(((TPML_AC_CAPABILITIES *)0)->acCapabilities)]
/* 3744 */ (_cffi_opcode_t)(_cffi_array_len(((TPML_AC_CAPABILITIES *)0)->acCapabilities)),
/* 3745 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 52), // TPMS_ALGORITHM_DETAIL_ECC
/* 3746 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 53), // TPMS_ALG_PROPERTY
/* 3747 */ _CFFI_OP(_CFFI_OP_ARRAY, 3746), // TPMS_ALG_PROPERTY[_cffi_array_len(((TPML_ALG_PROPERTY *)0)->algProperties)]
/* 3748 */ (_cffi_opcode_t)(_cffi_array_len(((TPML_ALG_PROPERTY *)0)->algProperties)),
/* 3749 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 54), // TPMS_ASYM_PARMS
/* 3750 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 55), // TPMS_ATTEST
/* 3751 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 56), // TPMS_AUTH_COMMAND
/* 3752 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 57), // TPMS_AUTH_RESPONSE
/* 3753 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 58), // TPMS_CAPABILITY_DATA
/* 3754 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 59), // TPMS_CERTIFY_INFO
/* 3755 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 60), // TPMS_CLOCK_INFO
/* 3756 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 61), // TPMS_COMMAND_AUDIT_INFO
/* 3757 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 62), // TPMS_CONTEXT
/* 3758 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 63), // TPMS_CONTEXT_DATA
/* 3759 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 64), // TPMS_CREATION_DATA
/* 3760 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 65), // TPMS_CREATION_INFO
/* 3761 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 66), // TPMS_DERIVE
/* 3762 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 67), // TPMS_ECC_PARMS
/* 3763 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 68), // TPMS_ECC_POINT
/* 3764 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 69), // TPMS_EMPTY
/* 3765 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 70), // TPMS_ID_OBJECT
/* 3766 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 71), // TPMS_KEYEDHASH_PARMS
/* 3767 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 72), // TPMS_NV_CERTIFY_INFO
/* 3768 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 73), // TPMS_NV_DIGEST_CERTIFY_INFO
/* 3769 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 74), // TPMS_NV_PIN_COUNTER_PARAMETERS
/* 3770 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 75), // TPMS_NV_PUBLIC
/* 3771 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 76), // TPMS_PCRVALUE
/* 3772 */ _CFFI_OP(_CFFI_OP_OPEN_ARRAY, 3771), // TPMS_PCRVALUE[]
/* 3773 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 77), // TPMS_PCR_SELECT
/* 3774 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 78), // TPMS_PCR_SELECTION
/* 3775 */ _CFFI_OP(_CFFI_OP_ARRAY, 3774), // TPMS_PCR_SELECTION[_cffi_array_len(((TPML_PCR_SELECTION *)0)->pcrSelections)]
/* 3776 */ (_cffi_opcode_t)(_cffi_array_len(((TPML_PCR_SELECTION *)0)->pcrSelections)),
/* 3777 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 79), // TPMS_QUOTE_INFO
/* 3778 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 80), // TPMS_RSA_PARMS
/* 3779 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 81), // TPMS_SCHEME_ECDAA
/* 3780 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 82), // TPMS_SCHEME_HASH
/* 3781 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 83), // TPMS_SCHEME_XOR
/* 3782 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 84), // TPMS_SENSITIVE_CREATE
/* 3783 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 85), // TPMS_SESSION_AUDIT_INFO
/* 3784 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 86), // TPMS_SIGNATURE_ECC
/* 3785 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 87), // TPMS_SIGNATURE_RSA
/* 3786 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 88), // TPMS_SYMCIPHER_PARMS
/* 3787 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 89), // TPMS_TAGGED_PCR_SELECT
/* 3788 */ _CFFI_OP(_CFFI_OP_ARRAY, 3787), // TPMS_TAGGED_PCR_SELECT[_cffi_array_len(((TPML_TAGGED_PCR_PROPERTY *)0)->pcrProperty)]
/* 3789 */ (_cffi_opcode_t)(_cffi_array_len(((TPML_TAGGED_PCR_PROPERTY *)0)->pcrProperty)),
/* 3790 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 90), // TPMS_TAGGED_POLICY
/* 3791 */ _CFFI_OP(_CFFI_OP_ARRAY, 3790), // TPMS_TAGGED_POLICY[_cffi_array_len(((TPML_TAGGED_POLICY *)0)->policies)]
/* 3792 */ (_cffi_opcode_t)(_cffi_array_len(((TPML_TAGGED_POLICY *)0)->policies)),
/* 3793 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 91), // TPMS_TAGGED_PROPERTY
/* 3794 */ _CFFI_OP(_CFFI_OP_ARRAY, 3793), // TPMS_TAGGED_PROPERTY[_cffi_array_len(((TPML_TAGGED_TPM_PROPERTY *)0)->tpmProperty)]
/* 3795 */ (_cffi_opcode_t)(_cffi_array_len(((TPML_TAGGED_TPM_PROPERTY *)0)->tpmProperty)),
/* 3796 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 92), // TPMS_TIME_ATTEST_INFO
/* 3797 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 93), // TPMS_TIME_INFO
/* 3798 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 94), // TPMT_ASYM_SCHEME
/* 3799 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 95), // TPMT_ECC_SCHEME
/* 3800 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 96), // TPMT_HA
/* 3801 */ _CFFI_OP(_CFFI_OP_ARRAY, 3800), // TPMT_HA[_cffi_array_len(((TPML_DIGEST_VALUES *)0)->digests)]
/* 3802 */ (_cffi_opcode_t)(_cffi_array_len(((TPML_DIGEST_VALUES *)0)->digests)),
/* 3803 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 97), // TPMT_KDF_SCHEME
/* 3804 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 98), // TPMT_KEYEDHASH_SCHEME
/* 3805 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 99), // TPMT_PUBLIC
/* 3806 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 100), // TPMT_PUBLIC_PARMS
/* 3807 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 101), // TPMT_RSA_DECRYPT
/* 3808 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 102), // TPMT_RSA_SCHEME
/* 3809 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 103), // TPMT_SENSITIVE
/* 3810 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 104), // TPMT_SIGNATURE
/* 3811 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 105), // TPMT_SIG_SCHEME
/* 3812 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 106), // TPMT_SYM_DEF
/* 3813 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 107), // TPMT_SYM_DEF_OBJECT
/* 3814 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 108), // TPMT_TK_AUTH
/* 3815 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 109), // TPMT_TK_CREATION
/* 3816 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 110), // TPMT_TK_HASHCHECK
/* 3817 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 111), // TPMT_TK_VERIFIED
/* 3818 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 112), // TPMU_ASYM_SCHEME
/* 3819 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 113), // TPMU_ATTEST
/* 3820 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 114), // TPMU_CAPABILITIES
/* 3821 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 115), // TPMU_ENCRYPTED_SECRET
/* 3822 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 116), // TPMU_HA
/* 3823 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 117), // TPMU_KDF_SCHEME
/* 3824 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 118), // TPMU_NAME
/* 3825 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 119), // TPMU_PUBLIC_ID
/* 3826 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 120), // TPMU_PUBLIC_PARMS
/* 3827 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 121), // TPMU_SCHEME_KEYEDHASH
/* 3828 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 122), // TPMU_SENSITIVE_COMPOSITE
/* 3829 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 123), // TPMU_SENSITIVE_CREATE
/* 3830 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 124), // TPMU_SIGNATURE
/* 3831 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 125), // TPMU_SIG_SCHEME
/* 3832 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 126), // TPMU_SYM_KEY_BITS
/* 3833 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 127), // TPMU_SYM_MODE
/* 3834 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 128), // TSS2_ABI_VERSION
/* 3835 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 129), // TSS2_OBJECT
/* 3836 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 130), // TSS2_POLICY_CALC_CALLBACKS
/* 3837 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 131), // TSS2_POLICY_CTX
/* 3838 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 132), // TSS2_POLICY_EXEC_CALLBACKS
/* 3839 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 133), // TSS2_POLICY_PCR_SELECTION
/* 3840 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 134), // TSS2_POLICY_PCR_SELECTIONS
/* 3841 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 135), // TSS2_RC_INFO
/* 3842 */ _CFFI_OP(_CFFI_OP_POINTER, 3843), // TSS2_SYS_CONTEXT *
/* 3843 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 136), // TSS2_SYS_CONTEXT
/* 3844 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 140), // TSS2_TCTI_CONTEXT
/* 3845 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 137), // TSS2_TCTI_CONTEXT_COMMON_V1
/* 3846 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 138), // TSS2_TCTI_CONTEXT_COMMON_V2
/* 3847 */ _CFFI_OP(_CFFI_OP_POINTER, 3850), // TSS2_TCTI_INFO *
/* 3848 */ _CFFI_OP(_CFFI_OP_POINTER, 0), // TSS2_TCTI_INFO const *(*)(void)
/* 3849 */ _CFFI_OP(_CFFI_OP_POINTER, 3850), // TSS2_TCTI_INFO const *
/* 3850 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 139), // TSS2_TCTI_INFO
/* 3851 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 143), // TSS2_TCTI_POLL_HANDLE
/* 3852 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 141), // TSS2_TCTI_SPI_HELPER_PLATFORM
/* 3853 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1), // _Bool
/* 3854 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 142), // _PRIVATE
/* 3855 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 3856 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // enum TSS2_POLICY_PCR_SELECTOR
/* 3857 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 5), // short
/* 3858 */ _CFFI_OP(_CFFI_OP_ARRAY, 205), // uint16_t[_cffi_array_len(((TPML_ALG *)0)->algorithms)]
/* 3859 */ (_cffi_opcode_t)(_cffi_array_len(((TPML_ALG *)0)->algorithms)),
/* 3860 */ _CFFI_OP(_CFFI_OP_ARRAY, 205), // uint16_t[_cffi_array_len(((TPML_ECC_CURVE *)0)->eccCurves)]
/* 3861 */ (_cffi_opcode_t)(_cffi_array_len(((TPML_ECC_CURVE *)0)->eccCurves)),
/* 3862 */ _CFFI_OP(_CFFI_OP_POINTER, 1615), // uint32_t(*)(ESYS_CRYPTO_CONTEXT_BLOB * *, uint16_t, uint8_t const *, size_t, void *)
/* 3863 */ _CFFI_OP(_CFFI_OP_POINTER, 1622), // uint32_t(*)(ESYS_CRYPTO_CONTEXT_BLOB * *, uint16_t, void *)
/* 3864 */ _CFFI_OP(_CFFI_OP_POINTER, 1627), // uint32_t(*)(ESYS_CRYPTO_CONTEXT_BLOB * *, uint8_t *, size_t *, void *)
/* 3865 */ _CFFI_OP(_CFFI_OP_POINTER, 1633), // uint32_t(*)(ESYS_CRYPTO_CONTEXT_BLOB *, uint8_t const *, size_t, void *)
/* 3866 */ _CFFI_OP(_CFFI_OP_POINTER, 1947), // uint32_t(*)(TPM2B_DIGEST *, size_t, void *)
/* 3867 */ _CFFI_OP(_CFFI_OP_POINTER, 2012), // uint32_t(*)(TPM2B_NAME *, uint32_t *, uint32_t *, uint32_t *, void *)
/* 3868 */ _CFFI_OP(_CFFI_OP_POINTER, 2019), // uint32_t(*)(TPM2B_NAME *, uint32_t *, void *)
/* 3869 */ _CFFI_OP(_CFFI_OP_POINTER, 2024), // uint32_t(*)(TPM2B_NAME *, void *)
/* 3870 */ _CFFI_OP(_CFFI_OP_POINTER, 2052), // uint32_t(*)(TPM2B_PUBLIC *, size_t, TPM2B_ECC_PARAMETER *, TPMS_ECC_POINT *, uint8_t *, size_t *, void *)
/* 3871 */ _CFFI_OP(_CFFI_OP_POINTER, 2061), // uint32_t(*)(TPM2B_PUBLIC *, size_t, uint8_t *, size_t, uint8_t *, size_t *, char const *, void *)
/* 3872 */ _CFFI_OP(_CFFI_OP_POINTER, 2341), // uint32_t(*)(TPMS_NV_PUBLIC *, uint16_t, void *)
/* 3873 */ _CFFI_OP(_CFFI_OP_POINTER, 2484), // uint32_t(*)(TPMT_PUBLIC *, uint16_t, TPM2B_DIGEST *, TPM2B_DIGEST *, TPMT_SIGNATURE *, void *)
/* 3874 */ _CFFI_OP(_CFFI_OP_POINTER, 2675), // uint32_t(*)(TSS2_OBJECT *, char const * *, size_t, size_t *, void *)
/* 3875 */ _CFFI_OP(_CFFI_OP_POINTER, 2707), // uint32_t(*)(TSS2_POLICY_PCR_SELECTION *, TPML_PCR_SELECTION *, TPML_DIGEST *, void *)
/* 3876 */ _CFFI_OP(_CFFI_OP_POINTER, 2713), // uint32_t(*)(TSS2_TCTI_CONTEXT *)
/* 3877 */ _CFFI_OP(_CFFI_OP_POINTER, 2716), // uint32_t(*)(TSS2_TCTI_CONTEXT *, TSS2_TCTI_POLL_HANDLE *, size_t *)
/* 3878 */ _CFFI_OP(_CFFI_OP_POINTER, 2726), // uint32_t(*)(TSS2_TCTI_CONTEXT *, size_t *, char const *)
/* 3879 */ _CFFI_OP(_CFFI_OP_POINTER, 2731), // uint32_t(*)(TSS2_TCTI_CONTEXT *, size_t *, uint8_t *, int32_t)
/* 3880 */ _CFFI_OP(_CFFI_OP_POINTER, 2737), // uint32_t(*)(TSS2_TCTI_CONTEXT *, size_t, uint8_t const *)
/* 3881 */ _CFFI_OP(_CFFI_OP_POINTER, 2742), // uint32_t(*)(TSS2_TCTI_CONTEXT *, uint32_t *, uint8_t)
/* 3882 */ _CFFI_OP(_CFFI_OP_POINTER, 2747), // uint32_t(*)(TSS2_TCTI_CONTEXT *, uint8_t)
/* 3883 */ _CFFI_OP(_CFFI_OP_POINTER, 2751), // uint32_t(*)(char *, char *, uint16_t, uint8_t *, size_t, uint8_t const * *, size_t *, void *)
/* 3884 */ _CFFI_OP(_CFFI_OP_POINTER, 2761), // uint32_t(*)(char const *, TPM2B_NAME *, void *)
/* 3885 */ _CFFI_OP(_CFFI_OP_POINTER, 2766), // uint32_t(*)(char const *, TPMT_PUBLIC *, void *)
/* 3886 */ _CFFI_OP(_CFFI_OP_POINTER, 2820), // uint32_t(*)(char const *, uint32_t, TPMS_NV_PUBLIC *, void *)
/* 3887 */ _CFFI_OP(_CFFI_OP_POINTER, 2826), // uint32_t(*)(char const *, void *)
/* 3888 */ _CFFI_OP(_CFFI_OP_POINTER, 2876), // uint32_t(*)(uint8_t *, uint16_t, uint16_t, uint16_t, uint8_t *, size_t, uint8_t *, void *)
/* 3889 */ _CFFI_OP(_CFFI_OP_POINTER, 3645), // uint32_t(*)(void *)
/* 3890 */ _CFFI_OP(_CFFI_OP_POINTER, 3648), // uint32_t(*)(void *, _Bool *)
/* 3891 */ _CFFI_OP(_CFFI_OP_POINTER, 3652), // uint32_t(*)(void *, int)
/* 3892 */ _CFFI_OP(_CFFI_OP_POINTER, 3656), // uint32_t(*)(void *, void const *, void *, size_t)
/* 3893 */ _CFFI_OP(_CFFI_OP_ARRAY, 6), // uint32_t[_cffi_array_len(((TPML_CC *)0)->commandCodes)]
/* 3894 */ (_cffi_opcode_t)(_cffi_array_len(((TPML_CC *)0)->commandCodes)),
/* 3895 */ _CFFI_OP(_CFFI_OP_ARRAY, 6), // uint32_t[_cffi_array_len(((TPML_CCA *)0)->commandAttributes)]
/* 3896 */ (_cffi_opcode_t)(_cffi_array_len(((TPML_CCA *)0)->commandAttributes)),
/* 3897 */ _CFFI_OP(_CFFI_OP_ARRAY, 6), // uint32_t[_cffi_array_len(((TPML_HANDLE *)0)->handle)]
/* 3898 */ (_cffi_opcode_t)(_cffi_array_len(((TPML_HANDLE *)0)->handle)),
/* 3899 */ _CFFI_OP(_CFFI_OP_ARRAY, 6), // uint32_t[_cffi_array_len(((TPML_INTEL_PTT_PROPERTY *)0)->property)]
/* 3900 */ (_cffi_opcode_t)(_cffi_array_len(((TPML_INTEL_PTT_PROPERTY *)0)->property)),
/* 3901 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_ATTEST *)0)->attestationData)]
/* 3902 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_ATTEST *)0)->attestationData)),
/* 3903 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_CONTEXT_DATA *)0)->buffer)]
/* 3904 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_CONTEXT_DATA *)0)->buffer)),
/* 3905 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_CONTEXT_SENSITIVE *)0)->buffer)]
/* 3906 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_CONTEXT_SENSITIVE *)0)->buffer)),
/* 3907 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_DATA *)0)->buffer)]
/* 3908 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_DATA *)0)->buffer)),
/* 3909 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_DERIVE *)0)->buffer)]
/* 3910 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_DERIVE *)0)->buffer)),
/* 3911 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_DIGEST *)0)->buffer)]
/* 3912 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_DIGEST *)0)->buffer)),
/* 3913 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_ECC_PARAMETER *)0)->buffer)]
/* 3914 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_ECC_PARAMETER *)0)->buffer)),
/* 3915 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_ENCRYPTED_SECRET *)0)->secret)]
/* 3916 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_ENCRYPTED_SECRET *)0)->secret)),
/* 3917 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_EVENT *)0)->buffer)]
/* 3918 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_EVENT *)0)->buffer)),
/* 3919 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_ID_OBJECT *)0)->credential)]
/* 3920 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_ID_OBJECT *)0)->credential)),
/* 3921 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_IV *)0)->buffer)]
/* 3922 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_IV *)0)->buffer)),
/* 3923 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_LABEL *)0)->buffer)]
/* 3924 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_LABEL *)0)->buffer)),
/* 3925 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_MAX_BUFFER *)0)->buffer)]
/* 3926 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_MAX_BUFFER *)0)->buffer)),
/* 3927 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_MAX_CAP_BUFFER *)0)->buffer)]
/* 3928 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_MAX_CAP_BUFFER *)0)->buffer)),
/* 3929 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_MAX_NV_BUFFER *)0)->buffer)]
/* 3930 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_MAX_NV_BUFFER *)0)->buffer)),
/* 3931 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_NAME *)0)->name)]
/* 3932 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_NAME *)0)->name)),
/* 3933 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_PRIVATE *)0)->buffer)]
/* 3934 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_PRIVATE *)0)->buffer)),
/* 3935 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_PRIVATE_KEY_RSA *)0)->buffer)]
/* 3936 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_PRIVATE_KEY_RSA *)0)->buffer)),
/* 3937 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_PRIVATE_VENDOR_SPECIFIC *)0)->buffer)]
/* 3938 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_PRIVATE_VENDOR_SPECIFIC *)0)->buffer)),
/* 3939 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_PUBLIC_KEY_RSA *)0)->buffer)]
/* 3940 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_PUBLIC_KEY_RSA *)0)->buffer)),
/* 3941 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_SENSITIVE_DATA *)0)->buffer)]
/* 3942 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_SENSITIVE_DATA *)0)->buffer)),
/* 3943 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_SYM_KEY *)0)->buffer)]
/* 3944 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_SYM_KEY *)0)->buffer)),
/* 3945 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPM2B_TEMPLATE *)0)->buffer)]
/* 3946 */ (_cffi_opcode_t)(_cffi_array_len(((TPM2B_TEMPLATE *)0)->buffer)),
/* 3947 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPMS_EMPTY *)0)->empty)]
/* 3948 */ (_cffi_opcode_t)(_cffi_array_len(((TPMS_EMPTY *)0)->empty)),
/* 3949 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPMS_PCR_SELECT *)0)->pcrSelect)]
/* 3950 */ (_cffi_opcode_t)(_cffi_array_len(((TPMS_PCR_SELECT *)0)->pcrSelect)),
/* 3951 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPMS_PCR_SELECTION *)0)->pcrSelect)]
/* 3952 */ (_cffi_opcode_t)(_cffi_array_len(((TPMS_PCR_SELECTION *)0)->pcrSelect)),
/* 3953 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPMS_TAGGED_PCR_SELECT *)0)->pcrSelect)]
/* 3954 */ (_cffi_opcode_t)(_cffi_array_len(((TPMS_TAGGED_PCR_SELECT *)0)->pcrSelect)),
/* 3955 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPMU_ENCRYPTED_SECRET *)0)->ecc)]
/* 3956 */ (_cffi_opcode_t)(_cffi_array_len(((TPMU_ENCRYPTED_SECRET *)0)->ecc)),
/* 3957 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPMU_ENCRYPTED_SECRET *)0)->keyedHash)]
/* 3958 */ (_cffi_opcode_t)(_cffi_array_len(((TPMU_ENCRYPTED_SECRET *)0)->keyedHash)),
/* 3959 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPMU_ENCRYPTED_SECRET *)0)->rsa)]
/* 3960 */ (_cffi_opcode_t)(_cffi_array_len(((TPMU_ENCRYPTED_SECRET *)0)->rsa)),
/* 3961 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPMU_ENCRYPTED_SECRET *)0)->symmetric)]
/* 3962 */ (_cffi_opcode_t)(_cffi_array_len(((TPMU_ENCRYPTED_SECRET *)0)->symmetric)),
/* 3963 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPMU_HA *)0)->sha)]
/* 3964 */ (_cffi_opcode_t)(_cffi_array_len(((TPMU_HA *)0)->sha)),
/* 3965 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPMU_HA *)0)->sha1)]
/* 3966 */ (_cffi_opcode_t)(_cffi_array_len(((TPMU_HA *)0)->sha1)),
/* 3967 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPMU_HA *)0)->sha256)]
/* 3968 */ (_cffi_opcode_t)(_cffi_array_len(((TPMU_HA *)0)->sha256)),
/* 3969 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPMU_HA *)0)->sha384)]
/* 3970 */ (_cffi_opcode_t)(_cffi_array_len(((TPMU_HA *)0)->sha384)),
/* 3971 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPMU_HA *)0)->sha512)]
/* 3972 */ (_cffi_opcode_t)(_cffi_array_len(((TPMU_HA *)0)->sha512)),
/* 3973 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPMU_HA *)0)->sm3_256)]
/* 3974 */ (_cffi_opcode_t)(_cffi_array_len(((TPMU_HA *)0)->sm3_256)),
/* 3975 */ _CFFI_OP(_CFFI_OP_ARRAY, 9), // uint8_t[_cffi_array_len(((TPMU_SENSITIVE_CREATE *)0)->create)]
/* 3976 */ (_cffi_opcode_t)(_cffi_array_len(((TPMU_SENSITIVE_CREATE *)0)->create)),
/* 3977 */ _CFFI_OP(_CFFI_OP_POINTER, 3665), // void(*)(ESYS_CRYPTO_CONTEXT_BLOB * *, void *)
/* 3978 */ _CFFI_OP(_CFFI_OP_POINTER, 3678), // void(*)(TSS2_TCTI_CONTEXT *)
/* 3979 */ _CFFI_OP(_CFFI_OP_POINTER, 3684), // void(*)(void *)
/* 3980 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static int _cffi_const_TSS2_POLICY_PCR_SELECTOR_PCR_SELECT(unsigned long long *o)
{
  int n = (TSS2_POLICY_PCR_SELECTOR_PCR_SELECT) <= 0;
  *o = (unsigned long long)((TSS2_POLICY_PCR_SELECTOR_PCR_SELECT) | 0);  /* check that TSS2_POLICY_PCR_SELECTOR_PCR_SELECT is an integer */
  return n;
}

static int _cffi_const_TSS2_POLICY_PCR_SELECTOR_PCR_SELECTION(unsigned long long *o)
{
  int n = (TSS2_POLICY_PCR_SELECTOR_PCR_SELECTION) <= 0;
  *o = (unsigned long long)((TSS2_POLICY_PCR_SELECTOR_PCR_SELECTION) | 0);  /* check that TSS2_POLICY_PCR_SELECTOR_PCR_SELECTION is an integer */
  return n;
}

static struct _cffi_externpy_s _cffi_externpy___fapi_auth_callback =
  { "tpm2_pytss._libtpm2_pytss._fapi_auth_callback", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _fapi_auth_callback(char const * a0, char const * a1, char const * * a2, void * a3)
{
  char a[32];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  *(char const * *)(p + 8) = a1;
  *(char const * * *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___fapi_auth_callback, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___fapi_branch_callback =
  { "tpm2_pytss._libtpm2_pytss._fapi_branch_callback", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _fapi_branch_callback(char const * a0, char const * a1, char const * * a2, size_t a3, size_t * a4, void * a5)
{
  char a[48];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  *(char const * *)(p + 8) = a1;
  *(char const * * *)(p + 16) = a2;
  *(size_t *)(p + 24) = a3;
  *(size_t * *)(p + 32) = a4;
  *(void * *)(p + 40) = a5;
  _cffi_call_python(&_cffi_externpy___fapi_branch_callback, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___fapi_policy_action_callback =
  { "tpm2_pytss._libtpm2_pytss._fapi_policy_action_callback", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _fapi_policy_action_callback(char const * a0, char const * a1, void * a2)
{
  char a[24];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  *(char const * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___fapi_policy_action_callback, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___fapi_sign_callback =
  { "tpm2_pytss._libtpm2_pytss._fapi_sign_callback", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _fapi_sign_callback(char const * a0, char const * a1, char const * a2, char const * a3, uint32_t a4, uint8_t const * a5, size_t a6, uint8_t const * * a7, size_t * a8, void * a9)
{
  char a[80];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  *(char const * *)(p + 8) = a1;
  *(char const * *)(p + 16) = a2;
  *(char const * *)(p + 24) = a3;
  *(uint32_t *)(p + 32) = a4;
  *(uint8_t const * *)(p + 40) = a5;
  *(size_t *)(p + 48) = a6;
  *(uint8_t const * * *)(p + 56) = a7;
  *(size_t * *)(p + 64) = a8;
  *(void * *)(p + 72) = a9;
  _cffi_call_python(&_cffi_externpy___fapi_sign_callback, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___policy_cb_calc_name =
  { "tpm2_pytss._libtpm2_pytss._policy_cb_calc_name", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _policy_cb_calc_name(char const * a0, TPM2B_NAME * a1, void * a2)
{
  char a[24];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  *(TPM2B_NAME * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___policy_cb_calc_name, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___policy_cb_calc_nvpublic =
  { "tpm2_pytss._libtpm2_pytss._policy_cb_calc_nvpublic", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _policy_cb_calc_nvpublic(char const * a0, uint32_t a1, TPMS_NV_PUBLIC * a2, void * a3)
{
  char a[32];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  *(uint32_t *)(p + 8) = a1;
  *(TPMS_NV_PUBLIC * *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___policy_cb_calc_nvpublic, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___policy_cb_calc_pcr =
  { "tpm2_pytss._libtpm2_pytss._policy_cb_calc_pcr", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _policy_cb_calc_pcr(TSS2_POLICY_PCR_SELECTION * a0, TPML_PCR_SELECTION * a1, TPML_DIGEST * a2, void * a3)
{
  char a[32];
  char *p = a;
  *(TSS2_POLICY_PCR_SELECTION * *)(p + 0) = a0;
  *(TPML_PCR_SELECTION * *)(p + 8) = a1;
  *(TPML_DIGEST * *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___policy_cb_calc_pcr, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___policy_cb_calc_public =
  { "tpm2_pytss._libtpm2_pytss._policy_cb_calc_public", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _policy_cb_calc_public(char const * a0, TPMT_PUBLIC * a1, void * a2)
{
  char a[24];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  *(TPMT_PUBLIC * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___policy_cb_calc_public, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___policy_cb_exec_auth =
  { "tpm2_pytss._libtpm2_pytss._policy_cb_exec_auth", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _policy_cb_exec_auth(TPM2B_NAME * a0, uint32_t * a1, uint32_t * a2, uint32_t * a3, void * a4)
{
  char a[40];
  char *p = a;
  *(TPM2B_NAME * *)(p + 0) = a0;
  *(uint32_t * *)(p + 8) = a1;
  *(uint32_t * *)(p + 16) = a2;
  *(uint32_t * *)(p + 24) = a3;
  *(void * *)(p + 32) = a4;
  _cffi_call_python(&_cffi_externpy___policy_cb_exec_auth, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___policy_cb_exec_polaction =
  { "tpm2_pytss._libtpm2_pytss._policy_cb_exec_polaction", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _policy_cb_exec_polaction(char const * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy___policy_cb_exec_polaction, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___policy_cb_exec_polauth =
  { "tpm2_pytss._libtpm2_pytss._policy_cb_exec_polauth", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _policy_cb_exec_polauth(TPMT_PUBLIC * a0, uint16_t a1, TPM2B_DIGEST * a2, TPM2B_DIGEST * a3, TPMT_SIGNATURE * a4, void * a5)
{
  char a[48];
  char *p = a;
  *(TPMT_PUBLIC * *)(p + 0) = a0;
  *(uint16_t *)(p + 8) = a1;
  *(TPM2B_DIGEST * *)(p + 16) = a2;
  *(TPM2B_DIGEST * *)(p + 24) = a3;
  *(TPMT_SIGNATURE * *)(p + 32) = a4;
  *(void * *)(p + 40) = a5;
  _cffi_call_python(&_cffi_externpy___policy_cb_exec_polauth, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___policy_cb_exec_polauthnv =
  { "tpm2_pytss._libtpm2_pytss._policy_cb_exec_polauthnv", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _policy_cb_exec_polauthnv(TPMS_NV_PUBLIC * a0, uint16_t a1, void * a2)
{
  char a[24];
  char *p = a;
  *(TPMS_NV_PUBLIC * *)(p + 0) = a0;
  *(uint16_t *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___policy_cb_exec_polauthnv, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___policy_cb_exec_poldup =
  { "tpm2_pytss._libtpm2_pytss._policy_cb_exec_poldup", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _policy_cb_exec_poldup(TPM2B_NAME * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(TPM2B_NAME * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy___policy_cb_exec_poldup, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___policy_cb_exec_polsel =
  { "tpm2_pytss._libtpm2_pytss._policy_cb_exec_polsel", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _policy_cb_exec_polsel(TSS2_OBJECT * a0, char const * * a1, size_t a2, size_t * a3, void * a4)
{
  char a[40];
  char *p = a;
  *(TSS2_OBJECT * *)(p + 0) = a0;
  *(char const * * *)(p + 8) = a1;
  *(size_t *)(p + 16) = a2;
  *(size_t * *)(p + 24) = a3;
  *(void * *)(p + 32) = a4;
  _cffi_call_python(&_cffi_externpy___policy_cb_exec_polsel, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___policy_cb_exec_sign =
  { "tpm2_pytss._libtpm2_pytss._policy_cb_exec_sign", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _policy_cb_exec_sign(char * a0, char * a1, uint16_t a2, uint8_t * a3, size_t a4, uint8_t const * * a5, size_t * a6, void * a7)
{
  char a[64];
  char *p = a;
  *(char * *)(p + 0) = a0;
  *(char * *)(p + 8) = a1;
  *(uint16_t *)(p + 16) = a2;
  *(uint8_t * *)(p + 24) = a3;
  *(size_t *)(p + 32) = a4;
  *(uint8_t const * * *)(p + 40) = a5;
  *(size_t * *)(p + 48) = a6;
  *(void * *)(p + 56) = a7;
  _cffi_call_python(&_cffi_externpy___policy_cb_exec_sign, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___tcti_cancel_wrapper =
  { "tpm2_pytss._libtpm2_pytss._tcti_cancel_wrapper", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _tcti_cancel_wrapper(TSS2_TCTI_CONTEXT * a0)
{
  char a[8];
  char *p = a;
  *(TSS2_TCTI_CONTEXT * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy___tcti_cancel_wrapper, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___tcti_finalize_wrapper =
  { "tpm2_pytss._libtpm2_pytss._tcti_finalize_wrapper", 0, 0, 0 };

static void _tcti_finalize_wrapper(TSS2_TCTI_CONTEXT * a0)
{
  char a[8];
  char *p = a;
  *(TSS2_TCTI_CONTEXT * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy___tcti_finalize_wrapper, p);
}

static struct _cffi_externpy_s _cffi_externpy___tcti_get_pollfds_wrapper =
  { "tpm2_pytss._libtpm2_pytss._tcti_get_pollfds_wrapper", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _tcti_get_pollfds_wrapper(TSS2_TCTI_CONTEXT * a0, TSS2_TCTI_POLL_HANDLE * a1, size_t * a2)
{
  char a[24];
  char *p = a;
  *(TSS2_TCTI_CONTEXT * *)(p + 0) = a0;
  *(TSS2_TCTI_POLL_HANDLE * *)(p + 8) = a1;
  *(size_t * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___tcti_get_pollfds_wrapper, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___tcti_make_sticky_wrapper =
  { "tpm2_pytss._libtpm2_pytss._tcti_make_sticky_wrapper", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _tcti_make_sticky_wrapper(TSS2_TCTI_CONTEXT * a0, uint32_t * a1, uint8_t a2)
{
  char a[24];
  char *p = a;
  *(TSS2_TCTI_CONTEXT * *)(p + 0) = a0;
  *(uint32_t * *)(p + 8) = a1;
  *(uint8_t *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___tcti_make_sticky_wrapper, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___tcti_receive_wrapper =
  { "tpm2_pytss._libtpm2_pytss._tcti_receive_wrapper", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _tcti_receive_wrapper(TSS2_TCTI_CONTEXT * a0, size_t * a1, uint8_t * a2, int32_t a3)
{
  char a[32];
  char *p = a;
  *(TSS2_TCTI_CONTEXT * *)(p + 0) = a0;
  *(size_t * *)(p + 8) = a1;
  *(uint8_t * *)(p + 16) = a2;
  *(int32_t *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___tcti_receive_wrapper, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___tcti_set_locality_wrapper =
  { "tpm2_pytss._libtpm2_pytss._tcti_set_locality_wrapper", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _tcti_set_locality_wrapper(TSS2_TCTI_CONTEXT * a0, uint8_t a1)
{
  char a[16];
  char *p = a;
  *(TSS2_TCTI_CONTEXT * *)(p + 0) = a0;
  *(uint8_t *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy___tcti_set_locality_wrapper, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___tcti_spi_helper_finalize =
  { "tpm2_pytss._libtpm2_pytss._tcti_spi_helper_finalize", 0, 0, 0 };

static void _tcti_spi_helper_finalize(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy___tcti_spi_helper_finalize, p);
}

static struct _cffi_externpy_s _cffi_externpy___tcti_spi_helper_sleep_ms =
  { "tpm2_pytss._libtpm2_pytss._tcti_spi_helper_sleep_ms", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _tcti_spi_helper_sleep_ms(void * a0, int a1)
{
  char a[16];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy___tcti_spi_helper_sleep_ms, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___tcti_spi_helper_spi_acquire =
  { "tpm2_pytss._libtpm2_pytss._tcti_spi_helper_spi_acquire", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _tcti_spi_helper_spi_acquire(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy___tcti_spi_helper_spi_acquire, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___tcti_spi_helper_spi_release =
  { "tpm2_pytss._libtpm2_pytss._tcti_spi_helper_spi_release", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _tcti_spi_helper_spi_release(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy___tcti_spi_helper_spi_release, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___tcti_spi_helper_spi_transfer =
  { "tpm2_pytss._libtpm2_pytss._tcti_spi_helper_spi_transfer", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _tcti_spi_helper_spi_transfer(void * a0, void const * a1, void * a2, size_t a3)
{
  char a[32];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(void const * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  *(size_t *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___tcti_spi_helper_spi_transfer, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___tcti_spi_helper_start_timeout =
  { "tpm2_pytss._libtpm2_pytss._tcti_spi_helper_start_timeout", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _tcti_spi_helper_start_timeout(void * a0, int a1)
{
  char a[16];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy___tcti_spi_helper_start_timeout, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___tcti_spi_helper_timeout_expired =
  { "tpm2_pytss._libtpm2_pytss._tcti_spi_helper_timeout_expired", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _tcti_spi_helper_timeout_expired(void * a0, _Bool * a1)
{
  char a[16];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(_Bool * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy___tcti_spi_helper_timeout_expired, p);
  return *(uint32_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___tcti_transmit_wrapper =
  { "tpm2_pytss._libtpm2_pytss._tcti_transmit_wrapper", (int)sizeof(uint32_t), 0, 0 };

static uint32_t _tcti_transmit_wrapper(TSS2_TCTI_CONTEXT * a0, size_t a1, uint8_t const * a2)
{
  char a[24];
  char *p = a;
  *(TSS2_TCTI_CONTEXT * *)(p + 0) = a0;
  *(size_t *)(p + 8) = a1;
  *(uint8_t const * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___tcti_transmit_wrapper, p);
  return *(uint32_t *)p;
}

static uint32_t _cffi_d_Esys_ACT_SetTimeout(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5)
{
  return Esys_ACT_SetTimeout(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ACT_SetTimeout(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_ACT_SetTimeout", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ACT_SetTimeout(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ACT_SetTimeout _cffi_d_Esys_ACT_SetTimeout
#endif

static uint32_t _cffi_d_Esys_ACT_SetTimeout_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5)
{
  return Esys_ACT_SetTimeout_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ACT_SetTimeout_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_ACT_SetTimeout_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ACT_SetTimeout_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ACT_SetTimeout_Async _cffi_d_Esys_ACT_SetTimeout_Async
#endif

static uint32_t _cffi_d_Esys_ACT_SetTimeout_Finish(ESYS_CONTEXT * x0)
{
  return Esys_ACT_SetTimeout_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ACT_SetTimeout_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ACT_SetTimeout_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ACT_SetTimeout_Finish _cffi_d_Esys_ACT_SetTimeout_Finish
#endif

static uint32_t _cffi_d_Esys_AC_GetCapability(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint32_t x6, uint8_t * x7, TPML_AC_CAPABILITIES * * x8)
{
  return Esys_AC_GetCapability(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_AC_GetCapability(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint8_t * x7;
  TPML_AC_CAPABILITIES * * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "Esys_AC_GetCapability", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1027), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1027), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1497), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPML_AC_CAPABILITIES * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1497), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_AC_GetCapability(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_AC_GetCapability _cffi_d_Esys_AC_GetCapability
#endif

static uint32_t _cffi_d_Esys_AC_GetCapability_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint32_t x6)
{
  return Esys_AC_GetCapability_Async(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_AC_GetCapability_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_AC_GetCapability_Async", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_AC_GetCapability_Async(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_AC_GetCapability_Async _cffi_d_Esys_AC_GetCapability_Async
#endif

static uint32_t _cffi_d_Esys_AC_GetCapability_Finish(ESYS_CONTEXT * x0, uint8_t * x1, TPML_AC_CAPABILITIES * * x2)
{
  return Esys_AC_GetCapability_Finish(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_AC_GetCapability_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint8_t * x1;
  TPML_AC_CAPABILITIES * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_AC_GetCapability_Finish", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1027), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1027), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1497), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPML_AC_CAPABILITIES * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1497), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_AC_GetCapability_Finish(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_AC_GetCapability_Finish _cffi_d_Esys_AC_GetCapability_Finish
#endif

static uint32_t _cffi_d_Esys_AC_Send(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint32_t x6, TPM2B_MAX_BUFFER * x7, TPMS_AC_OUTPUT * * x8)
{
  return Esys_AC_Send(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_AC_Send(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  TPM2B_MAX_BUFFER * x7;
  TPMS_AC_OUTPUT * * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "Esys_AC_Send", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1455), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1455), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(150), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPMS_AC_OUTPUT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(150), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_AC_Send(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_AC_Send _cffi_d_Esys_AC_Send
#endif

static uint32_t _cffi_d_Esys_AC_Send_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint32_t x6, TPM2B_MAX_BUFFER * x7)
{
  return Esys_AC_Send_Async(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_AC_Send_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  TPM2B_MAX_BUFFER * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_AC_Send_Async", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1455), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1455), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_AC_Send_Async(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_AC_Send_Async _cffi_d_Esys_AC_Send_Async
#endif

static uint32_t _cffi_d_Esys_AC_Send_Finish(ESYS_CONTEXT * x0, TPMS_AC_OUTPUT * * x1)
{
  return Esys_AC_Send_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_AC_Send_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPMS_AC_OUTPUT * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_AC_Send_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(150), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPMS_AC_OUTPUT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(150), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_AC_Send_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_AC_Send_Finish _cffi_d_Esys_AC_Send_Finish
#endif

static uint32_t _cffi_d_Esys_ActivateCredential(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_ID_OBJECT const * x6, TPM2B_ENCRYPTED_SECRET const * x7, TPM2B_DIGEST * * x8)
{
  return Esys_ActivateCredential(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ActivateCredential(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_ID_OBJECT const * x6;
  TPM2B_ENCRYPTED_SECRET const * x7;
  TPM2B_DIGEST * * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "Esys_ActivateCredential", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1277), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_ID_OBJECT const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1277), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(472), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_ENCRYPTED_SECRET const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(472), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ActivateCredential(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ActivateCredential _cffi_d_Esys_ActivateCredential
#endif

static uint32_t _cffi_d_Esys_ActivateCredential_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_ID_OBJECT const * x6, TPM2B_ENCRYPTED_SECRET const * x7)
{
  return Esys_ActivateCredential_Async(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ActivateCredential_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_ID_OBJECT const * x6;
  TPM2B_ENCRYPTED_SECRET const * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_ActivateCredential_Async", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1277), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_ID_OBJECT const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1277), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(472), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_ENCRYPTED_SECRET const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(472), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ActivateCredential_Async(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ActivateCredential_Async _cffi_d_Esys_ActivateCredential_Async
#endif

static uint32_t _cffi_d_Esys_ActivateCredential_Finish(ESYS_CONTEXT * x0, TPM2B_DIGEST * * x1)
{
  return Esys_ActivateCredential_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ActivateCredential_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_DIGEST * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_ActivateCredential_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ActivateCredential_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ActivateCredential_Finish _cffi_d_Esys_ActivateCredential_Finish
#endif

static uint32_t _cffi_d_Esys_Certify(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_DATA const * x6, TPMT_SIG_SCHEME const * x7, TPM2B_ATTEST * * x8, TPMT_SIGNATURE * * x9)
{
  return Esys_Certify(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Certify(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_DATA const * x6;
  TPMT_SIG_SCHEME const * x7;
  TPM2B_ATTEST * * x8;
  TPMT_SIGNATURE * * x9;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;

  if (!PyArg_UnpackTuple(args, "Esys_Certify", 10, 10, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(495), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPMT_SIG_SCHEME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(495), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_ATTEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (TPMT_SIGNATURE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Certify(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Certify _cffi_d_Esys_Certify
#endif

static uint32_t _cffi_d_Esys_CertifyCreation(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_DATA const * x6, TPM2B_DIGEST const * x7, TPMT_SIG_SCHEME const * x8, TPMT_TK_CREATION const * x9, TPM2B_ATTEST * * x10, TPMT_SIGNATURE * * x11)
{
  return Esys_CertifyCreation(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_CertifyCreation(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_DATA const * x6;
  TPM2B_DIGEST const * x7;
  TPMT_SIG_SCHEME const * x8;
  TPMT_TK_CREATION const * x9;
  TPM2B_ATTEST * * x10;
  TPMT_SIGNATURE * * x11;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;
  PyObject *arg11;

  if (!PyArg_UnpackTuple(args, "Esys_CertifyCreation", 12, 12, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10, &arg11))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(495), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPMT_SIG_SCHEME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(495), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1076), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (TPMT_TK_CREATION const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1076), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg10, (char **)&x10);
  if (datasize != 0) {
    x10 = ((size_t)datasize) <= 640 ? (TPM2B_ATTEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg10, (char **)&x10,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg11, (char **)&x11);
  if (datasize != 0) {
    x11 = ((size_t)datasize) <= 640 ? (TPMT_SIGNATURE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg11, (char **)&x11,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_CertifyCreation(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_CertifyCreation _cffi_d_Esys_CertifyCreation
#endif

static uint32_t _cffi_d_Esys_CertifyCreation_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_DATA const * x6, TPM2B_DIGEST const * x7, TPMT_SIG_SCHEME const * x8, TPMT_TK_CREATION const * x9)
{
  return Esys_CertifyCreation_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_CertifyCreation_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_DATA const * x6;
  TPM2B_DIGEST const * x7;
  TPMT_SIG_SCHEME const * x8;
  TPMT_TK_CREATION const * x9;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;

  if (!PyArg_UnpackTuple(args, "Esys_CertifyCreation_Async", 10, 10, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(495), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPMT_SIG_SCHEME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(495), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1076), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (TPMT_TK_CREATION const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1076), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_CertifyCreation_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_CertifyCreation_Async _cffi_d_Esys_CertifyCreation_Async
#endif

static uint32_t _cffi_d_Esys_CertifyCreation_Finish(ESYS_CONTEXT * x0, TPM2B_ATTEST * * x1, TPMT_SIGNATURE * * x2)
{
  return Esys_CertifyCreation_Finish(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_CertifyCreation_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_ATTEST * * x1;
  TPMT_SIGNATURE * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_CertifyCreation_Finish", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_ATTEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPMT_SIGNATURE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_CertifyCreation_Finish(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_CertifyCreation_Finish _cffi_d_Esys_CertifyCreation_Finish
#endif

static uint32_t _cffi_d_Esys_CertifyX509(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_DATA const * x6, TPMT_SIG_SCHEME const * x7, TPM2B_MAX_BUFFER const * x8, TPM2B_MAX_BUFFER * * x9, TPM2B_DIGEST * * x10, TPMT_SIGNATURE * * x11)
{
  return Esys_CertifyX509(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_CertifyX509(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_DATA const * x6;
  TPMT_SIG_SCHEME const * x7;
  TPM2B_MAX_BUFFER const * x8;
  TPM2B_MAX_BUFFER * * x9;
  TPM2B_DIGEST * * x10;
  TPMT_SIGNATURE * * x11;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;
  PyObject *arg11;

  if (!PyArg_UnpackTuple(args, "Esys_CertifyX509", 12, 12, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10, &arg11))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(495), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPMT_SIG_SCHEME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(495), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(311), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(311), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(82), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg10, (char **)&x10);
  if (datasize != 0) {
    x10 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg10, (char **)&x10,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg11, (char **)&x11);
  if (datasize != 0) {
    x11 = ((size_t)datasize) <= 640 ? (TPMT_SIGNATURE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg11, (char **)&x11,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_CertifyX509(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_CertifyX509 _cffi_d_Esys_CertifyX509
#endif

static uint32_t _cffi_d_Esys_CertifyX509_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_DATA const * x6, TPMT_SIG_SCHEME const * x7, TPM2B_MAX_BUFFER const * x8)
{
  return Esys_CertifyX509_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_CertifyX509_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_DATA const * x6;
  TPMT_SIG_SCHEME const * x7;
  TPM2B_MAX_BUFFER const * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "Esys_CertifyX509_Async", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(495), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPMT_SIG_SCHEME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(495), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(311), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(311), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_CertifyX509_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_CertifyX509_Async _cffi_d_Esys_CertifyX509_Async
#endif

static uint32_t _cffi_d_Esys_CertifyX509_Finish(ESYS_CONTEXT * x0, TPM2B_MAX_BUFFER * * x1, TPM2B_DIGEST * * x2, TPMT_SIGNATURE * * x3)
{
  return Esys_CertifyX509_Finish(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_CertifyX509_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_MAX_BUFFER * * x1;
  TPM2B_DIGEST * * x2;
  TPMT_SIGNATURE * * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "Esys_CertifyX509_Finish", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(82), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (TPMT_SIGNATURE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_CertifyX509_Finish(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_CertifyX509_Finish _cffi_d_Esys_CertifyX509_Finish
#endif

static uint32_t _cffi_d_Esys_Certify_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_DATA const * x6, TPMT_SIG_SCHEME const * x7)
{
  return Esys_Certify_Async(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Certify_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_DATA const * x6;
  TPMT_SIG_SCHEME const * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_Certify_Async", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(495), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPMT_SIG_SCHEME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(495), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Certify_Async(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Certify_Async _cffi_d_Esys_Certify_Async
#endif

static uint32_t _cffi_d_Esys_Certify_Finish(ESYS_CONTEXT * x0, TPM2B_ATTEST * * x1, TPMT_SIGNATURE * * x2)
{
  return Esys_Certify_Finish(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Certify_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_ATTEST * * x1;
  TPMT_SIGNATURE * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_Certify_Finish", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_ATTEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPMT_SIGNATURE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Certify_Finish(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Certify_Finish _cffi_d_Esys_Certify_Finish
#endif

static uint32_t _cffi_d_Esys_ChangeEPS(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_ChangeEPS(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ChangeEPS(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_ChangeEPS", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ChangeEPS(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ChangeEPS _cffi_d_Esys_ChangeEPS
#endif

static uint32_t _cffi_d_Esys_ChangeEPS_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_ChangeEPS_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ChangeEPS_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_ChangeEPS_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ChangeEPS_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ChangeEPS_Async _cffi_d_Esys_ChangeEPS_Async
#endif

static uint32_t _cffi_d_Esys_ChangeEPS_Finish(ESYS_CONTEXT * x0)
{
  return Esys_ChangeEPS_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ChangeEPS_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ChangeEPS_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ChangeEPS_Finish _cffi_d_Esys_ChangeEPS_Finish
#endif

static uint32_t _cffi_d_Esys_ChangePPS(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_ChangePPS(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ChangePPS(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_ChangePPS", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ChangePPS(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ChangePPS _cffi_d_Esys_ChangePPS
#endif

static uint32_t _cffi_d_Esys_ChangePPS_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_ChangePPS_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ChangePPS_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_ChangePPS_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ChangePPS_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ChangePPS_Async _cffi_d_Esys_ChangePPS_Async
#endif

static uint32_t _cffi_d_Esys_ChangePPS_Finish(ESYS_CONTEXT * x0)
{
  return Esys_ChangePPS_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ChangePPS_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ChangePPS_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ChangePPS_Finish _cffi_d_Esys_ChangePPS_Finish
#endif

static uint32_t _cffi_d_Esys_Clear(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_Clear(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Clear(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_Clear", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Clear(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Clear _cffi_d_Esys_Clear
#endif

static uint32_t _cffi_d_Esys_ClearControl(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint8_t x5)
{
  return Esys_ClearControl(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ClearControl(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint8_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_ClearControl", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint8_t);
  if (x5 == (uint8_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ClearControl(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ClearControl _cffi_d_Esys_ClearControl
#endif

static uint32_t _cffi_d_Esys_ClearControl_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint8_t x5)
{
  return Esys_ClearControl_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ClearControl_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint8_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_ClearControl_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint8_t);
  if (x5 == (uint8_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ClearControl_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ClearControl_Async _cffi_d_Esys_ClearControl_Async
#endif

static uint32_t _cffi_d_Esys_ClearControl_Finish(ESYS_CONTEXT * x0)
{
  return Esys_ClearControl_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ClearControl_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ClearControl_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ClearControl_Finish _cffi_d_Esys_ClearControl_Finish
#endif

static uint32_t _cffi_d_Esys_Clear_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_Clear_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Clear_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_Clear_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Clear_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Clear_Async _cffi_d_Esys_Clear_Async
#endif

static uint32_t _cffi_d_Esys_Clear_Finish(ESYS_CONTEXT * x0)
{
  return Esys_Clear_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Clear_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Clear_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Clear_Finish _cffi_d_Esys_Clear_Finish
#endif

static uint32_t _cffi_d_Esys_ClockRateAdjust(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, int8_t x5)
{
  return Esys_ClockRateAdjust(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ClockRateAdjust(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  int8_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_ClockRateAdjust", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int8_t);
  if (x5 == (int8_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ClockRateAdjust(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ClockRateAdjust _cffi_d_Esys_ClockRateAdjust
#endif

static uint32_t _cffi_d_Esys_ClockRateAdjust_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, int8_t x5)
{
  return Esys_ClockRateAdjust_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ClockRateAdjust_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  int8_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_ClockRateAdjust_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int8_t);
  if (x5 == (int8_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ClockRateAdjust_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ClockRateAdjust_Async _cffi_d_Esys_ClockRateAdjust_Async
#endif

static uint32_t _cffi_d_Esys_ClockRateAdjust_Finish(ESYS_CONTEXT * x0)
{
  return Esys_ClockRateAdjust_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ClockRateAdjust_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ClockRateAdjust_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ClockRateAdjust_Finish _cffi_d_Esys_ClockRateAdjust_Finish
#endif

static uint32_t _cffi_d_Esys_ClockSet(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint64_t x5)
{
  return Esys_ClockSet(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ClockSet(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint64_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_ClockSet", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint64_t);
  if (x5 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ClockSet(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ClockSet _cffi_d_Esys_ClockSet
#endif

static uint32_t _cffi_d_Esys_ClockSet_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint64_t x5)
{
  return Esys_ClockSet_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ClockSet_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint64_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_ClockSet_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint64_t);
  if (x5 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ClockSet_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ClockSet_Async _cffi_d_Esys_ClockSet_Async
#endif

static uint32_t _cffi_d_Esys_ClockSet_Finish(ESYS_CONTEXT * x0)
{
  return Esys_ClockSet_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ClockSet_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ClockSet_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ClockSet_Finish _cffi_d_Esys_ClockSet_Finish
#endif

static uint32_t _cffi_d_Esys_Commit(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_ECC_POINT const * x5, TPM2B_SENSITIVE_DATA const * x6, TPM2B_ECC_PARAMETER const * x7, TPM2B_ECC_POINT * * x8, TPM2B_ECC_POINT * * x9, TPM2B_ECC_POINT * * x10, uint16_t * x11)
{
  return Esys_Commit(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Commit(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_ECC_POINT const * x5;
  TPM2B_SENSITIVE_DATA const * x6;
  TPM2B_ECC_PARAMETER const * x7;
  TPM2B_ECC_POINT * * x8;
  TPM2B_ECC_POINT * * x9;
  TPM2B_ECC_POINT * * x10;
  uint16_t * x11;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;
  PyObject *arg11;

  if (!PyArg_UnpackTuple(args, "Esys_Commit", 12, 12, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10, &arg11))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(691), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_ECC_POINT const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(691), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(376), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_SENSITIVE_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(376), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(734), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_ECC_PARAMETER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(734), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_ECC_POINT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (TPM2B_ECC_POINT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg10, (char **)&x10);
  if (datasize != 0) {
    x10 = ((size_t)datasize) <= 640 ? (TPM2B_ECC_POINT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg10, (char **)&x10,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg11, (char **)&x11);
  if (datasize != 0) {
    x11 = ((size_t)datasize) <= 640 ? (uint16_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg11, (char **)&x11,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Commit(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Commit _cffi_d_Esys_Commit
#endif

static uint32_t _cffi_d_Esys_Commit_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_ECC_POINT const * x5, TPM2B_SENSITIVE_DATA const * x6, TPM2B_ECC_PARAMETER const * x7)
{
  return Esys_Commit_Async(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Commit_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_ECC_POINT const * x5;
  TPM2B_SENSITIVE_DATA const * x6;
  TPM2B_ECC_PARAMETER const * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_Commit_Async", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(691), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_ECC_POINT const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(691), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(376), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_SENSITIVE_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(376), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(734), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_ECC_PARAMETER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(734), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Commit_Async(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Commit_Async _cffi_d_Esys_Commit_Async
#endif

static uint32_t _cffi_d_Esys_Commit_Finish(ESYS_CONTEXT * x0, TPM2B_ECC_POINT * * x1, TPM2B_ECC_POINT * * x2, TPM2B_ECC_POINT * * x3, uint16_t * x4)
{
  return Esys_Commit_Finish(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Commit_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_ECC_POINT * * x1;
  TPM2B_ECC_POINT * * x2;
  TPM2B_ECC_POINT * * x3;
  uint16_t * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_Commit_Finish", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_ECC_POINT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPM2B_ECC_POINT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (TPM2B_ECC_POINT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (uint16_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Commit_Finish(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Commit_Finish _cffi_d_Esys_Commit_Finish
#endif

static uint32_t _cffi_d_Esys_ContextLoad(ESYS_CONTEXT * x0, TPMS_CONTEXT const * x1, uint32_t * x2)
{
  return Esys_ContextLoad(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ContextLoad(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPMS_CONTEXT const * x1;
  uint32_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_ContextLoad", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(162), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPMS_CONTEXT const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(162), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ContextLoad(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ContextLoad _cffi_d_Esys_ContextLoad
#endif

static uint32_t _cffi_d_Esys_ContextLoad_Async(ESYS_CONTEXT * x0, TPMS_CONTEXT const * x1)
{
  return Esys_ContextLoad_Async(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ContextLoad_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPMS_CONTEXT const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_ContextLoad_Async", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(162), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPMS_CONTEXT const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(162), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ContextLoad_Async(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ContextLoad_Async _cffi_d_Esys_ContextLoad_Async
#endif

static uint32_t _cffi_d_Esys_ContextLoad_Finish(ESYS_CONTEXT * x0, uint32_t * x1)
{
  return Esys_ContextLoad_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ContextLoad_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_ContextLoad_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ContextLoad_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ContextLoad_Finish _cffi_d_Esys_ContextLoad_Finish
#endif

static uint32_t _cffi_d_Esys_ContextSave(ESYS_CONTEXT * x0, uint32_t x1, TPMS_CONTEXT * * x2)
{
  return Esys_ContextSave(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ContextSave(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  TPMS_CONTEXT * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_ContextSave", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPMS_CONTEXT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ContextSave(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ContextSave _cffi_d_Esys_ContextSave
#endif

static uint32_t _cffi_d_Esys_ContextSave_Async(ESYS_CONTEXT * x0, uint32_t x1)
{
  return Esys_ContextSave_Async(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ContextSave_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_ContextSave_Async", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ContextSave_Async(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ContextSave_Async _cffi_d_Esys_ContextSave_Async
#endif

static uint32_t _cffi_d_Esys_ContextSave_Finish(ESYS_CONTEXT * x0, TPMS_CONTEXT * * x1)
{
  return Esys_ContextSave_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ContextSave_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPMS_CONTEXT * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_ContextSave_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPMS_CONTEXT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ContextSave_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ContextSave_Finish _cffi_d_Esys_ContextSave_Finish
#endif

static uint32_t _cffi_d_Esys_Create(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_SENSITIVE_CREATE const * x5, TPM2B_PUBLIC const * x6, TPM2B_DATA const * x7, TPML_PCR_SELECTION const * x8, TPM2B_PRIVATE * * x9, TPM2B_PUBLIC * * x10, TPM2B_CREATION_DATA * * x11, TPM2B_DIGEST * * x12, TPMT_TK_CREATION * * x13)
{
  return Esys_Create(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Create(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_SENSITIVE_CREATE const * x5;
  TPM2B_PUBLIC const * x6;
  TPM2B_DATA const * x7;
  TPML_PCR_SELECTION const * x8;
  TPM2B_PRIVATE * * x9;
  TPM2B_PUBLIC * * x10;
  TPM2B_CREATION_DATA * * x11;
  TPM2B_DIGEST * * x12;
  TPMT_TK_CREATION * * x13;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;
  PyObject *arg11;
  PyObject *arg12;
  PyObject *arg13;

  if (!PyArg_UnpackTuple(args, "Esys_Create", 14, 14, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10, &arg11, &arg12, &arg13))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(921), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_SENSITIVE_CREATE const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(921), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(358), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(358), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(398), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPML_PCR_SELECTION const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(398), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (TPM2B_PRIVATE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg10, (char **)&x10);
  if (datasize != 0) {
    x10 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg10, (char **)&x10,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(122), arg11, (char **)&x11);
  if (datasize != 0) {
    x11 = ((size_t)datasize) <= 640 ? (TPM2B_CREATION_DATA * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(122), arg11, (char **)&x11,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg12, (char **)&x12);
  if (datasize != 0) {
    x12 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg12, (char **)&x12,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(124), arg13, (char **)&x13);
  if (datasize != 0) {
    x13 = ((size_t)datasize) <= 640 ? (TPMT_TK_CREATION * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(124), arg13, (char **)&x13,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Create(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Create _cffi_d_Esys_Create
#endif

static uint32_t _cffi_d_Esys_CreateLoaded(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_SENSITIVE_CREATE const * x5, TPM2B_TEMPLATE const * x6, uint32_t * x7, TPM2B_PRIVATE * * x8, TPM2B_PUBLIC * * x9)
{
  return Esys_CreateLoaded(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_CreateLoaded(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_SENSITIVE_CREATE const * x5;
  TPM2B_TEMPLATE const * x6;
  uint32_t * x7;
  TPM2B_PRIVATE * * x8;
  TPM2B_PUBLIC * * x9;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;

  if (!PyArg_UnpackTuple(args, "Esys_CreateLoaded", 10, 10, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(921), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_SENSITIVE_CREATE const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(921), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(965), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_TEMPLATE const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(965), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_PRIVATE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_CreateLoaded(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_CreateLoaded _cffi_d_Esys_CreateLoaded
#endif

static uint32_t _cffi_d_Esys_CreateLoaded_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_SENSITIVE_CREATE const * x5, TPM2B_TEMPLATE const * x6)
{
  return Esys_CreateLoaded_Async(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_CreateLoaded_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_SENSITIVE_CREATE const * x5;
  TPM2B_TEMPLATE const * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_CreateLoaded_Async", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(921), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_SENSITIVE_CREATE const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(921), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(965), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_TEMPLATE const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(965), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_CreateLoaded_Async(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_CreateLoaded_Async _cffi_d_Esys_CreateLoaded_Async
#endif

static uint32_t _cffi_d_Esys_CreateLoaded_Finish(ESYS_CONTEXT * x0, uint32_t * x1, TPM2B_PRIVATE * * x2, TPM2B_PUBLIC * * x3)
{
  return Esys_CreateLoaded_Finish(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_CreateLoaded_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t * x1;
  TPM2B_PRIVATE * * x2;
  TPM2B_PUBLIC * * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "Esys_CreateLoaded_Finish", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPM2B_PRIVATE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_CreateLoaded_Finish(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_CreateLoaded_Finish _cffi_d_Esys_CreateLoaded_Finish
#endif

static uint32_t _cffi_d_Esys_CreatePrimary(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_SENSITIVE_CREATE const * x5, TPM2B_PUBLIC const * x6, TPM2B_DATA const * x7, TPML_PCR_SELECTION const * x8, uint32_t * x9, TPM2B_PUBLIC * * x10, TPM2B_CREATION_DATA * * x11, TPM2B_DIGEST * * x12, TPMT_TK_CREATION * * x13)
{
  return Esys_CreatePrimary(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_CreatePrimary(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_SENSITIVE_CREATE const * x5;
  TPM2B_PUBLIC const * x6;
  TPM2B_DATA const * x7;
  TPML_PCR_SELECTION const * x8;
  uint32_t * x9;
  TPM2B_PUBLIC * * x10;
  TPM2B_CREATION_DATA * * x11;
  TPM2B_DIGEST * * x12;
  TPMT_TK_CREATION * * x13;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;
  PyObject *arg11;
  PyObject *arg12;
  PyObject *arg13;

  if (!PyArg_UnpackTuple(args, "Esys_CreatePrimary", 14, 14, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10, &arg11, &arg12, &arg13))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(921), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_SENSITIVE_CREATE const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(921), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(358), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(358), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(398), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPML_PCR_SELECTION const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(398), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg10, (char **)&x10);
  if (datasize != 0) {
    x10 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg10, (char **)&x10,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(122), arg11, (char **)&x11);
  if (datasize != 0) {
    x11 = ((size_t)datasize) <= 640 ? (TPM2B_CREATION_DATA * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(122), arg11, (char **)&x11,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg12, (char **)&x12);
  if (datasize != 0) {
    x12 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg12, (char **)&x12,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(124), arg13, (char **)&x13);
  if (datasize != 0) {
    x13 = ((size_t)datasize) <= 640 ? (TPMT_TK_CREATION * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(124), arg13, (char **)&x13,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_CreatePrimary(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_CreatePrimary _cffi_d_Esys_CreatePrimary
#endif

static uint32_t _cffi_d_Esys_CreatePrimary_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_SENSITIVE_CREATE const * x5, TPM2B_PUBLIC const * x6, TPM2B_DATA const * x7, TPML_PCR_SELECTION const * x8)
{
  return Esys_CreatePrimary_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_CreatePrimary_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_SENSITIVE_CREATE const * x5;
  TPM2B_PUBLIC const * x6;
  TPM2B_DATA const * x7;
  TPML_PCR_SELECTION const * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "Esys_CreatePrimary_Async", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(921), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_SENSITIVE_CREATE const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(921), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(358), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(358), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(398), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPML_PCR_SELECTION const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(398), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_CreatePrimary_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_CreatePrimary_Async _cffi_d_Esys_CreatePrimary_Async
#endif

static uint32_t _cffi_d_Esys_CreatePrimary_Finish(ESYS_CONTEXT * x0, uint32_t * x1, TPM2B_PUBLIC * * x2, TPM2B_CREATION_DATA * * x3, TPM2B_DIGEST * * x4, TPMT_TK_CREATION * * x5)
{
  return Esys_CreatePrimary_Finish(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_CreatePrimary_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t * x1;
  TPM2B_PUBLIC * * x2;
  TPM2B_CREATION_DATA * * x3;
  TPM2B_DIGEST * * x4;
  TPMT_TK_CREATION * * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_CreatePrimary_Finish", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(122), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (TPM2B_CREATION_DATA * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(122), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(124), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPMT_TK_CREATION * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(124), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_CreatePrimary_Finish(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_CreatePrimary_Finish _cffi_d_Esys_CreatePrimary_Finish
#endif

static uint32_t _cffi_d_Esys_Create_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_SENSITIVE_CREATE const * x5, TPM2B_PUBLIC const * x6, TPM2B_DATA const * x7, TPML_PCR_SELECTION const * x8)
{
  return Esys_Create_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Create_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_SENSITIVE_CREATE const * x5;
  TPM2B_PUBLIC const * x6;
  TPM2B_DATA const * x7;
  TPML_PCR_SELECTION const * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "Esys_Create_Async", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(921), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_SENSITIVE_CREATE const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(921), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(358), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(358), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(398), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPML_PCR_SELECTION const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(398), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Create_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Create_Async _cffi_d_Esys_Create_Async
#endif

static uint32_t _cffi_d_Esys_Create_Finish(ESYS_CONTEXT * x0, TPM2B_PRIVATE * * x1, TPM2B_PUBLIC * * x2, TPM2B_CREATION_DATA * * x3, TPM2B_DIGEST * * x4, TPMT_TK_CREATION * * x5)
{
  return Esys_Create_Finish(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Create_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_PRIVATE * * x1;
  TPM2B_PUBLIC * * x2;
  TPM2B_CREATION_DATA * * x3;
  TPM2B_DIGEST * * x4;
  TPMT_TK_CREATION * * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_Create_Finish", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_PRIVATE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(122), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (TPM2B_CREATION_DATA * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(122), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(124), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPMT_TK_CREATION * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(124), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Create_Finish(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Create_Finish _cffi_d_Esys_Create_Finish
#endif

static uint32_t _cffi_d_Esys_DictionaryAttackLockReset(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_DictionaryAttackLockReset(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_DictionaryAttackLockReset(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_DictionaryAttackLockReset", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_DictionaryAttackLockReset(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_DictionaryAttackLockReset _cffi_d_Esys_DictionaryAttackLockReset
#endif

static uint32_t _cffi_d_Esys_DictionaryAttackLockReset_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_DictionaryAttackLockReset_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_DictionaryAttackLockReset_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_DictionaryAttackLockReset_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_DictionaryAttackLockReset_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_DictionaryAttackLockReset_Async _cffi_d_Esys_DictionaryAttackLockReset_Async
#endif

static uint32_t _cffi_d_Esys_DictionaryAttackLockReset_Finish(ESYS_CONTEXT * x0)
{
  return Esys_DictionaryAttackLockReset_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_DictionaryAttackLockReset_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_DictionaryAttackLockReset_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_DictionaryAttackLockReset_Finish _cffi_d_Esys_DictionaryAttackLockReset_Finish
#endif

static uint32_t _cffi_d_Esys_DictionaryAttackParameters(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint32_t x6, uint32_t x7)
{
  return Esys_DictionaryAttackParameters(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_DictionaryAttackParameters(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_DictionaryAttackParameters", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, uint32_t);
  if (x7 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_DictionaryAttackParameters(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_DictionaryAttackParameters _cffi_d_Esys_DictionaryAttackParameters
#endif

static uint32_t _cffi_d_Esys_DictionaryAttackParameters_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint32_t x6, uint32_t x7)
{
  return Esys_DictionaryAttackParameters_Async(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_DictionaryAttackParameters_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_DictionaryAttackParameters_Async", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, uint32_t);
  if (x7 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_DictionaryAttackParameters_Async(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_DictionaryAttackParameters_Async _cffi_d_Esys_DictionaryAttackParameters_Async
#endif

static uint32_t _cffi_d_Esys_DictionaryAttackParameters_Finish(ESYS_CONTEXT * x0)
{
  return Esys_DictionaryAttackParameters_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_DictionaryAttackParameters_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_DictionaryAttackParameters_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_DictionaryAttackParameters_Finish _cffi_d_Esys_DictionaryAttackParameters_Finish
#endif

static uint32_t _cffi_d_Esys_Duplicate(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_DATA const * x6, TPMT_SYM_DEF_OBJECT const * x7, TPM2B_DATA * * x8, TPM2B_PRIVATE * * x9, TPM2B_ENCRYPTED_SECRET * * x10)
{
  return Esys_Duplicate(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Duplicate(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_DATA const * x6;
  TPMT_SYM_DEF_OBJECT const * x7;
  TPM2B_DATA * * x8;
  TPM2B_PRIVATE * * x9;
  TPM2B_ENCRYPTED_SECRET * * x10;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;

  if (!PyArg_UnpackTuple(args, "Esys_Duplicate", 11, 11, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(473), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPMT_SYM_DEF_OBJECT const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(473), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(32), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_DATA * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(32), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (TPM2B_PRIVATE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg10, (char **)&x10);
  if (datasize != 0) {
    x10 = ((size_t)datasize) <= 640 ? (TPM2B_ENCRYPTED_SECRET * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg10, (char **)&x10,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Duplicate(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Duplicate _cffi_d_Esys_Duplicate
#endif

static uint32_t _cffi_d_Esys_Duplicate_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_DATA const * x6, TPMT_SYM_DEF_OBJECT const * x7)
{
  return Esys_Duplicate_Async(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Duplicate_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_DATA const * x6;
  TPMT_SYM_DEF_OBJECT const * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_Duplicate_Async", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(473), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPMT_SYM_DEF_OBJECT const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(473), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Duplicate_Async(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Duplicate_Async _cffi_d_Esys_Duplicate_Async
#endif

static uint32_t _cffi_d_Esys_Duplicate_Finish(ESYS_CONTEXT * x0, TPM2B_DATA * * x1, TPM2B_PRIVATE * * x2, TPM2B_ENCRYPTED_SECRET * * x3)
{
  return Esys_Duplicate_Finish(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Duplicate_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_DATA * * x1;
  TPM2B_PRIVATE * * x2;
  TPM2B_ENCRYPTED_SECRET * * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "Esys_Duplicate_Finish", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(32), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_DATA * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(32), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPM2B_PRIVATE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (TPM2B_ENCRYPTED_SECRET * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Duplicate_Finish(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Duplicate_Finish _cffi_d_Esys_Duplicate_Finish
#endif

static uint32_t _cffi_d_Esys_ECC_Parameters(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint16_t x4, TPMS_ALGORITHM_DETAIL_ECC * * x5)
{
  return Esys_ECC_Parameters(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ECC_Parameters(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint16_t x4;
  TPMS_ALGORITHM_DETAIL_ECC * * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_ECC_Parameters", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint16_t);
  if (x4 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(154), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPMS_ALGORITHM_DETAIL_ECC * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(154), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ECC_Parameters(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ECC_Parameters _cffi_d_Esys_ECC_Parameters
#endif

static uint32_t _cffi_d_Esys_ECC_Parameters_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint16_t x4)
{
  return Esys_ECC_Parameters_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ECC_Parameters_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint16_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_ECC_Parameters_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint16_t);
  if (x4 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ECC_Parameters_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ECC_Parameters_Async _cffi_d_Esys_ECC_Parameters_Async
#endif

static uint32_t _cffi_d_Esys_ECC_Parameters_Finish(ESYS_CONTEXT * x0, TPMS_ALGORITHM_DETAIL_ECC * * x1)
{
  return Esys_ECC_Parameters_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ECC_Parameters_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPMS_ALGORITHM_DETAIL_ECC * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_ECC_Parameters_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(154), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPMS_ALGORITHM_DETAIL_ECC * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(154), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ECC_Parameters_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ECC_Parameters_Finish _cffi_d_Esys_ECC_Parameters_Finish
#endif

static uint32_t _cffi_d_Esys_ECDH_KeyGen(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_ECC_POINT * * x5, TPM2B_ECC_POINT * * x6)
{
  return Esys_ECDH_KeyGen(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ECDH_KeyGen(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_ECC_POINT * * x5;
  TPM2B_ECC_POINT * * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_ECDH_KeyGen", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_ECC_POINT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_ECC_POINT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ECDH_KeyGen(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ECDH_KeyGen _cffi_d_Esys_ECDH_KeyGen
#endif

static uint32_t _cffi_d_Esys_ECDH_KeyGen_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_ECDH_KeyGen_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ECDH_KeyGen_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_ECDH_KeyGen_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ECDH_KeyGen_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ECDH_KeyGen_Async _cffi_d_Esys_ECDH_KeyGen_Async
#endif

static uint32_t _cffi_d_Esys_ECDH_KeyGen_Finish(ESYS_CONTEXT * x0, TPM2B_ECC_POINT * * x1, TPM2B_ECC_POINT * * x2)
{
  return Esys_ECDH_KeyGen_Finish(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ECDH_KeyGen_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_ECC_POINT * * x1;
  TPM2B_ECC_POINT * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_ECDH_KeyGen_Finish", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_ECC_POINT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPM2B_ECC_POINT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ECDH_KeyGen_Finish(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ECDH_KeyGen_Finish _cffi_d_Esys_ECDH_KeyGen_Finish
#endif

static uint32_t _cffi_d_Esys_ECDH_ZGen(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_ECC_POINT const * x5, TPM2B_ECC_POINT * * x6)
{
  return Esys_ECDH_ZGen(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ECDH_ZGen(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_ECC_POINT const * x5;
  TPM2B_ECC_POINT * * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_ECDH_ZGen", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(691), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_ECC_POINT const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(691), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_ECC_POINT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ECDH_ZGen(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ECDH_ZGen _cffi_d_Esys_ECDH_ZGen
#endif

static uint32_t _cffi_d_Esys_ECDH_ZGen_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_ECC_POINT const * x5)
{
  return Esys_ECDH_ZGen_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ECDH_ZGen_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_ECC_POINT const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_ECDH_ZGen_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(691), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_ECC_POINT const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(691), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ECDH_ZGen_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ECDH_ZGen_Async _cffi_d_Esys_ECDH_ZGen_Async
#endif

static uint32_t _cffi_d_Esys_ECDH_ZGen_Finish(ESYS_CONTEXT * x0, TPM2B_ECC_POINT * * x1)
{
  return Esys_ECDH_ZGen_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ECDH_ZGen_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_ECC_POINT * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_ECDH_ZGen_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_ECC_POINT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ECDH_ZGen_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ECDH_ZGen_Finish _cffi_d_Esys_ECDH_ZGen_Finish
#endif

static uint32_t _cffi_d_Esys_EC_Ephemeral(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint16_t x4, TPM2B_ECC_POINT * * x5, uint16_t * x6)
{
  return Esys_EC_Ephemeral(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_EC_Ephemeral(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint16_t x4;
  TPM2B_ECC_POINT * * x5;
  uint16_t * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_EC_Ephemeral", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint16_t);
  if (x4 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_ECC_POINT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (uint16_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_EC_Ephemeral(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_EC_Ephemeral _cffi_d_Esys_EC_Ephemeral
#endif

static uint32_t _cffi_d_Esys_EC_Ephemeral_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint16_t x4)
{
  return Esys_EC_Ephemeral_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_EC_Ephemeral_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint16_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_EC_Ephemeral_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint16_t);
  if (x4 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_EC_Ephemeral_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_EC_Ephemeral_Async _cffi_d_Esys_EC_Ephemeral_Async
#endif

static uint32_t _cffi_d_Esys_EC_Ephemeral_Finish(ESYS_CONTEXT * x0, TPM2B_ECC_POINT * * x1, uint16_t * x2)
{
  return Esys_EC_Ephemeral_Finish(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_EC_Ephemeral_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_ECC_POINT * * x1;
  uint16_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_EC_Ephemeral_Finish", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_ECC_POINT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint16_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_EC_Ephemeral_Finish(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_EC_Ephemeral_Finish _cffi_d_Esys_EC_Ephemeral_Finish
#endif

static uint32_t _cffi_d_Esys_EncryptDecrypt(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint8_t x5, uint16_t x6, TPM2B_IV const * x7, TPM2B_MAX_BUFFER const * x8, TPM2B_MAX_BUFFER * * x9, TPM2B_IV * * x10)
{
  return Esys_EncryptDecrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_EncryptDecrypt(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint8_t x5;
  uint16_t x6;
  TPM2B_IV const * x7;
  TPM2B_MAX_BUFFER const * x8;
  TPM2B_MAX_BUFFER * * x9;
  TPM2B_IV * * x10;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;

  if (!PyArg_UnpackTuple(args, "Esys_EncryptDecrypt", 11, 11, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint8_t);
  if (x5 == (uint8_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint16_t);
  if (x6 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(831), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_IV const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(831), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(311), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(311), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(82), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg10, (char **)&x10);
  if (datasize != 0) {
    x10 = ((size_t)datasize) <= 640 ? (TPM2B_IV * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg10, (char **)&x10,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_EncryptDecrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_EncryptDecrypt _cffi_d_Esys_EncryptDecrypt
#endif

static uint32_t _cffi_d_Esys_EncryptDecrypt2(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_MAX_BUFFER const * x5, uint8_t x6, uint16_t x7, TPM2B_IV const * x8, TPM2B_MAX_BUFFER * * x9, TPM2B_IV * * x10)
{
  return Esys_EncryptDecrypt2(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_EncryptDecrypt2(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_MAX_BUFFER const * x5;
  uint8_t x6;
  uint16_t x7;
  TPM2B_IV const * x8;
  TPM2B_MAX_BUFFER * * x9;
  TPM2B_IV * * x10;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;

  if (!PyArg_UnpackTuple(args, "Esys_EncryptDecrypt2", 11, 11, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(311), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(311), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, uint8_t);
  if (x6 == (uint8_t)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, uint16_t);
  if (x7 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(831), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_IV const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(831), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(82), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg10, (char **)&x10);
  if (datasize != 0) {
    x10 = ((size_t)datasize) <= 640 ? (TPM2B_IV * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg10, (char **)&x10,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_EncryptDecrypt2(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_EncryptDecrypt2 _cffi_d_Esys_EncryptDecrypt2
#endif

static uint32_t _cffi_d_Esys_EncryptDecrypt2_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_MAX_BUFFER const * x5, uint8_t x6, uint16_t x7, TPM2B_IV const * x8)
{
  return Esys_EncryptDecrypt2_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_EncryptDecrypt2_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_MAX_BUFFER const * x5;
  uint8_t x6;
  uint16_t x7;
  TPM2B_IV const * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "Esys_EncryptDecrypt2_Async", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(311), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(311), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, uint8_t);
  if (x6 == (uint8_t)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, uint16_t);
  if (x7 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(831), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_IV const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(831), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_EncryptDecrypt2_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_EncryptDecrypt2_Async _cffi_d_Esys_EncryptDecrypt2_Async
#endif

static uint32_t _cffi_d_Esys_EncryptDecrypt2_Finish(ESYS_CONTEXT * x0, TPM2B_MAX_BUFFER * * x1, TPM2B_IV * * x2)
{
  return Esys_EncryptDecrypt2_Finish(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_EncryptDecrypt2_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_MAX_BUFFER * * x1;
  TPM2B_IV * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_EncryptDecrypt2_Finish", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(82), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPM2B_IV * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_EncryptDecrypt2_Finish(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_EncryptDecrypt2_Finish _cffi_d_Esys_EncryptDecrypt2_Finish
#endif

static uint32_t _cffi_d_Esys_EncryptDecrypt_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint8_t x5, uint16_t x6, TPM2B_IV const * x7, TPM2B_MAX_BUFFER const * x8)
{
  return Esys_EncryptDecrypt_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_EncryptDecrypt_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint8_t x5;
  uint16_t x6;
  TPM2B_IV const * x7;
  TPM2B_MAX_BUFFER const * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "Esys_EncryptDecrypt_Async", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint8_t);
  if (x5 == (uint8_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint16_t);
  if (x6 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(831), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_IV const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(831), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(311), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(311), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_EncryptDecrypt_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_EncryptDecrypt_Async _cffi_d_Esys_EncryptDecrypt_Async
#endif

static uint32_t _cffi_d_Esys_EncryptDecrypt_Finish(ESYS_CONTEXT * x0, TPM2B_MAX_BUFFER * * x1, TPM2B_IV * * x2)
{
  return Esys_EncryptDecrypt_Finish(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_EncryptDecrypt_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_MAX_BUFFER * * x1;
  TPM2B_IV * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_EncryptDecrypt_Finish", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(82), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPM2B_IV * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_EncryptDecrypt_Finish(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_EncryptDecrypt_Finish _cffi_d_Esys_EncryptDecrypt_Finish
#endif

static uint32_t _cffi_d_Esys_EventSequenceComplete(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_MAX_BUFFER const * x6, TPML_DIGEST_VALUES * * x7)
{
  return Esys_EventSequenceComplete(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_EventSequenceComplete(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_MAX_BUFFER const * x6;
  TPML_DIGEST_VALUES * * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_EventSequenceComplete", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(311), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(311), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(146), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPML_DIGEST_VALUES * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(146), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_EventSequenceComplete(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_EventSequenceComplete _cffi_d_Esys_EventSequenceComplete
#endif

static uint32_t _cffi_d_Esys_EventSequenceComplete_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_MAX_BUFFER const * x6)
{
  return Esys_EventSequenceComplete_Async(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_EventSequenceComplete_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_MAX_BUFFER const * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_EventSequenceComplete_Async", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(311), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(311), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_EventSequenceComplete_Async(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_EventSequenceComplete_Async _cffi_d_Esys_EventSequenceComplete_Async
#endif

static uint32_t _cffi_d_Esys_EventSequenceComplete_Finish(ESYS_CONTEXT * x0, TPML_DIGEST_VALUES * * x1)
{
  return Esys_EventSequenceComplete_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_EventSequenceComplete_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPML_DIGEST_VALUES * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_EventSequenceComplete_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(146), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPML_DIGEST_VALUES * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(146), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_EventSequenceComplete_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_EventSequenceComplete_Finish _cffi_d_Esys_EventSequenceComplete_Finish
#endif

static uint32_t _cffi_d_Esys_EvictControl(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint32_t x6, uint32_t * x7)
{
  return Esys_EvictControl(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_EvictControl(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_EvictControl", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_EvictControl(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_EvictControl _cffi_d_Esys_EvictControl
#endif

static uint32_t _cffi_d_Esys_EvictControl_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint32_t x6)
{
  return Esys_EvictControl_Async(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_EvictControl_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_EvictControl_Async", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_EvictControl_Async(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_EvictControl_Async _cffi_d_Esys_EvictControl_Async
#endif

static uint32_t _cffi_d_Esys_EvictControl_Finish(ESYS_CONTEXT * x0, uint32_t * x1)
{
  return Esys_EvictControl_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_EvictControl_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_EvictControl_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_EvictControl_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_EvictControl_Finish _cffi_d_Esys_EvictControl_Finish
#endif

static uint32_t _cffi_d_Esys_FieldUpgradeData(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, TPM2B_MAX_BUFFER const * x4, TPMT_HA * * x5, TPMT_HA * * x6)
{
  return Esys_FieldUpgradeData(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_FieldUpgradeData(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  TPM2B_MAX_BUFFER const * x4;
  TPMT_HA * * x5;
  TPMT_HA * * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_FieldUpgradeData", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(311), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(311), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(175), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPMT_HA * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(175), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(175), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPMT_HA * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(175), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_FieldUpgradeData(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_FieldUpgradeData _cffi_d_Esys_FieldUpgradeData
#endif

static uint32_t _cffi_d_Esys_FieldUpgradeData_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, TPM2B_MAX_BUFFER const * x4)
{
  return Esys_FieldUpgradeData_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_FieldUpgradeData_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  TPM2B_MAX_BUFFER const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_FieldUpgradeData_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(311), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(311), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_FieldUpgradeData_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_FieldUpgradeData_Async _cffi_d_Esys_FieldUpgradeData_Async
#endif

static uint32_t _cffi_d_Esys_FieldUpgradeData_Finish(ESYS_CONTEXT * x0, TPMT_HA * * x1, TPMT_HA * * x2)
{
  return Esys_FieldUpgradeData_Finish(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_FieldUpgradeData_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPMT_HA * * x1;
  TPMT_HA * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_FieldUpgradeData_Finish", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(175), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPMT_HA * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(175), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(175), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPMT_HA * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(175), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_FieldUpgradeData_Finish(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_FieldUpgradeData_Finish _cffi_d_Esys_FieldUpgradeData_Finish
#endif

static uint32_t _cffi_d_Esys_FieldUpgradeStart(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_DIGEST const * x6, TPMT_SIGNATURE const * x7)
{
  return Esys_FieldUpgradeStart(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_FieldUpgradeStart(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_DIGEST const * x6;
  TPMT_SIGNATURE const * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_FieldUpgradeStart", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(604), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPMT_SIGNATURE const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(604), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_FieldUpgradeStart(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_FieldUpgradeStart _cffi_d_Esys_FieldUpgradeStart
#endif

static uint32_t _cffi_d_Esys_FieldUpgradeStart_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_DIGEST const * x6, TPMT_SIGNATURE const * x7)
{
  return Esys_FieldUpgradeStart_Async(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_FieldUpgradeStart_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_DIGEST const * x6;
  TPMT_SIGNATURE const * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_FieldUpgradeStart_Async", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(604), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPMT_SIGNATURE const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(604), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_FieldUpgradeStart_Async(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_FieldUpgradeStart_Async _cffi_d_Esys_FieldUpgradeStart_Async
#endif

static uint32_t _cffi_d_Esys_FieldUpgradeStart_Finish(ESYS_CONTEXT * x0)
{
  return Esys_FieldUpgradeStart_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_FieldUpgradeStart_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_FieldUpgradeStart_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_FieldUpgradeStart_Finish _cffi_d_Esys_FieldUpgradeStart_Finish
#endif

static void _cffi_d_Esys_Finalize(ESYS_CONTEXT * * x0)
{
  Esys_Finalize(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Finalize(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { Esys_Finalize(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_Esys_Finalize _cffi_d_Esys_Finalize
#endif

static uint32_t _cffi_d_Esys_FirmwareRead(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_MAX_BUFFER * * x5)
{
  return Esys_FirmwareRead(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_FirmwareRead(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_MAX_BUFFER * * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_FirmwareRead", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(82), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_FirmwareRead(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_FirmwareRead _cffi_d_Esys_FirmwareRead
#endif

static uint32_t _cffi_d_Esys_FirmwareRead_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_FirmwareRead_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_FirmwareRead_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_FirmwareRead_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_FirmwareRead_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_FirmwareRead_Async _cffi_d_Esys_FirmwareRead_Async
#endif

static uint32_t _cffi_d_Esys_FirmwareRead_Finish(ESYS_CONTEXT * x0, TPM2B_MAX_BUFFER * * x1)
{
  return Esys_FirmwareRead_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_FirmwareRead_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_MAX_BUFFER * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_FirmwareRead_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(82), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_FirmwareRead_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_FirmwareRead_Finish _cffi_d_Esys_FirmwareRead_Finish
#endif

static uint32_t _cffi_d_Esys_FlushContext(ESYS_CONTEXT * x0, uint32_t x1)
{
  return Esys_FlushContext(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_FlushContext(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_FlushContext", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_FlushContext(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_FlushContext _cffi_d_Esys_FlushContext
#endif

static uint32_t _cffi_d_Esys_FlushContext_Async(ESYS_CONTEXT * x0, uint32_t x1)
{
  return Esys_FlushContext_Async(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_FlushContext_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_FlushContext_Async", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_FlushContext_Async(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_FlushContext_Async _cffi_d_Esys_FlushContext_Async
#endif

static uint32_t _cffi_d_Esys_FlushContext_Finish(ESYS_CONTEXT * x0)
{
  return Esys_FlushContext_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_FlushContext_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_FlushContext_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_FlushContext_Finish _cffi_d_Esys_FlushContext_Finish
#endif

static void _cffi_d_Esys_Free(void * x0)
{
  Esys_Free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Free(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1620), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1620), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { Esys_Free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_Esys_Free _cffi_d_Esys_Free
#endif

static uint32_t _cffi_d_Esys_GetCapability(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint32_t x6, uint8_t * x7, TPMS_CAPABILITY_DATA * * x8)
{
  return Esys_GetCapability(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_GetCapability(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint8_t * x7;
  TPMS_CAPABILITY_DATA * * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "Esys_GetCapability", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1027), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1027), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1508), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPMS_CAPABILITY_DATA * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1508), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_GetCapability(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_GetCapability _cffi_d_Esys_GetCapability
#endif

static uint32_t _cffi_d_Esys_GetCapability_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint32_t x6)
{
  return Esys_GetCapability_Async(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_GetCapability_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_GetCapability_Async", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_GetCapability_Async(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_GetCapability_Async _cffi_d_Esys_GetCapability_Async
#endif

static uint32_t _cffi_d_Esys_GetCapability_Finish(ESYS_CONTEXT * x0, uint8_t * x1, TPMS_CAPABILITY_DATA * * x2)
{
  return Esys_GetCapability_Finish(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_GetCapability_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint8_t * x1;
  TPMS_CAPABILITY_DATA * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_GetCapability_Finish", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1027), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1027), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1508), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPMS_CAPABILITY_DATA * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1508), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_GetCapability_Finish(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_GetCapability_Finish _cffi_d_Esys_GetCapability_Finish
#endif

static uint32_t _cffi_d_Esys_GetCommandAuditDigest(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_DATA const * x6, TPMT_SIG_SCHEME const * x7, TPM2B_ATTEST * * x8, TPMT_SIGNATURE * * x9)
{
  return Esys_GetCommandAuditDigest(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_GetCommandAuditDigest(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_DATA const * x6;
  TPMT_SIG_SCHEME const * x7;
  TPM2B_ATTEST * * x8;
  TPMT_SIGNATURE * * x9;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;

  if (!PyArg_UnpackTuple(args, "Esys_GetCommandAuditDigest", 10, 10, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(495), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPMT_SIG_SCHEME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(495), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_ATTEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (TPMT_SIGNATURE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_GetCommandAuditDigest(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_GetCommandAuditDigest _cffi_d_Esys_GetCommandAuditDigest
#endif

static uint32_t _cffi_d_Esys_GetCommandAuditDigest_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_DATA const * x6, TPMT_SIG_SCHEME const * x7)
{
  return Esys_GetCommandAuditDigest_Async(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_GetCommandAuditDigest_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_DATA const * x6;
  TPMT_SIG_SCHEME const * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_GetCommandAuditDigest_Async", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(495), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPMT_SIG_SCHEME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(495), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_GetCommandAuditDigest_Async(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_GetCommandAuditDigest_Async _cffi_d_Esys_GetCommandAuditDigest_Async
#endif

static uint32_t _cffi_d_Esys_GetCommandAuditDigest_Finish(ESYS_CONTEXT * x0, TPM2B_ATTEST * * x1, TPMT_SIGNATURE * * x2)
{
  return Esys_GetCommandAuditDigest_Finish(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_GetCommandAuditDigest_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_ATTEST * * x1;
  TPMT_SIGNATURE * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_GetCommandAuditDigest_Finish", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_ATTEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPMT_SIGNATURE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_GetCommandAuditDigest_Finish(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_GetCommandAuditDigest_Finish _cffi_d_Esys_GetCommandAuditDigest_Finish
#endif

static uint32_t _cffi_d_Esys_GetPollHandles(ESYS_CONTEXT * x0, TSS2_TCTI_POLL_HANDLE * * x1, size_t * x2)
{
  return Esys_GetPollHandles(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_GetPollHandles(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TSS2_TCTI_POLL_HANDLE * * x1;
  size_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_GetPollHandles", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(196), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TSS2_TCTI_POLL_HANDLE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(196), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(197), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(197), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_GetPollHandles(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_GetPollHandles _cffi_d_Esys_GetPollHandles
#endif

static uint32_t _cffi_d_Esys_GetRandom(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint16_t x4, TPM2B_DIGEST * * x5)
{
  return Esys_GetRandom(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_GetRandom(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint16_t x4;
  TPM2B_DIGEST * * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_GetRandom", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint16_t);
  if (x4 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_GetRandom(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_GetRandom _cffi_d_Esys_GetRandom
#endif

static uint32_t _cffi_d_Esys_GetRandom_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint16_t x4)
{
  return Esys_GetRandom_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_GetRandom_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint16_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_GetRandom_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint16_t);
  if (x4 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_GetRandom_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_GetRandom_Async _cffi_d_Esys_GetRandom_Async
#endif

static uint32_t _cffi_d_Esys_GetRandom_Finish(ESYS_CONTEXT * x0, TPM2B_DIGEST * * x1)
{
  return Esys_GetRandom_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_GetRandom_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_DIGEST * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_GetRandom_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_GetRandom_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_GetRandom_Finish _cffi_d_Esys_GetRandom_Finish
#endif

static uint32_t _cffi_d_Esys_GetSessionAuditDigest(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint32_t x6, TPM2B_DATA const * x7, TPMT_SIG_SCHEME const * x8, TPM2B_ATTEST * * x9, TPMT_SIGNATURE * * x10)
{
  return Esys_GetSessionAuditDigest(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_GetSessionAuditDigest(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  TPM2B_DATA const * x7;
  TPMT_SIG_SCHEME const * x8;
  TPM2B_ATTEST * * x9;
  TPMT_SIGNATURE * * x10;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;

  if (!PyArg_UnpackTuple(args, "Esys_GetSessionAuditDigest", 11, 11, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(495), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPMT_SIG_SCHEME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(495), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (TPM2B_ATTEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg10, (char **)&x10);
  if (datasize != 0) {
    x10 = ((size_t)datasize) <= 640 ? (TPMT_SIGNATURE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg10, (char **)&x10,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_GetSessionAuditDigest(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_GetSessionAuditDigest _cffi_d_Esys_GetSessionAuditDigest
#endif

static uint32_t _cffi_d_Esys_GetSessionAuditDigest_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint32_t x6, TPM2B_DATA const * x7, TPMT_SIG_SCHEME const * x8)
{
  return Esys_GetSessionAuditDigest_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_GetSessionAuditDigest_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  TPM2B_DATA const * x7;
  TPMT_SIG_SCHEME const * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "Esys_GetSessionAuditDigest_Async", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(495), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPMT_SIG_SCHEME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(495), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_GetSessionAuditDigest_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_GetSessionAuditDigest_Async _cffi_d_Esys_GetSessionAuditDigest_Async
#endif

static uint32_t _cffi_d_Esys_GetSessionAuditDigest_Finish(ESYS_CONTEXT * x0, TPM2B_ATTEST * * x1, TPMT_SIGNATURE * * x2)
{
  return Esys_GetSessionAuditDigest_Finish(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_GetSessionAuditDigest_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_ATTEST * * x1;
  TPMT_SIGNATURE * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_GetSessionAuditDigest_Finish", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_ATTEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPMT_SIGNATURE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_GetSessionAuditDigest_Finish(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_GetSessionAuditDigest_Finish _cffi_d_Esys_GetSessionAuditDigest_Finish
#endif

static uint32_t _cffi_d_Esys_GetSysContext(ESYS_CONTEXT * x0, TSS2_SYS_CONTEXT * * x1)
{
  return Esys_GetSysContext(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_GetSysContext(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TSS2_SYS_CONTEXT * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_GetSysContext", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(188), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TSS2_SYS_CONTEXT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(188), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_GetSysContext(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_GetSysContext _cffi_d_Esys_GetSysContext
#endif

static uint32_t _cffi_d_Esys_GetTcti(ESYS_CONTEXT * x0, TSS2_TCTI_CONTEXT * * x1)
{
  return Esys_GetTcti(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_GetTcti(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TSS2_TCTI_CONTEXT * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_GetTcti", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(192), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TSS2_TCTI_CONTEXT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(192), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_GetTcti(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_GetTcti _cffi_d_Esys_GetTcti
#endif

static uint32_t _cffi_d_Esys_GetTestResult(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, TPM2B_MAX_BUFFER * * x4, uint32_t * x5)
{
  return Esys_GetTestResult(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_GetTestResult(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  TPM2B_MAX_BUFFER * * x4;
  uint32_t * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_GetTestResult", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(82), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_GetTestResult(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_GetTestResult _cffi_d_Esys_GetTestResult
#endif

static uint32_t _cffi_d_Esys_GetTestResult_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3)
{
  return Esys_GetTestResult_Async(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_GetTestResult_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "Esys_GetTestResult_Async", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_GetTestResult_Async(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_GetTestResult_Async _cffi_d_Esys_GetTestResult_Async
#endif

static uint32_t _cffi_d_Esys_GetTestResult_Finish(ESYS_CONTEXT * x0, TPM2B_MAX_BUFFER * * x1, uint32_t * x2)
{
  return Esys_GetTestResult_Finish(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_GetTestResult_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_MAX_BUFFER * * x1;
  uint32_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_GetTestResult_Finish", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(82), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_GetTestResult_Finish(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_GetTestResult_Finish _cffi_d_Esys_GetTestResult_Finish
#endif

static uint32_t _cffi_d_Esys_GetTime(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_DATA const * x6, TPMT_SIG_SCHEME const * x7, TPM2B_ATTEST * * x8, TPMT_SIGNATURE * * x9)
{
  return Esys_GetTime(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_GetTime(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_DATA const * x6;
  TPMT_SIG_SCHEME const * x7;
  TPM2B_ATTEST * * x8;
  TPMT_SIGNATURE * * x9;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;

  if (!PyArg_UnpackTuple(args, "Esys_GetTime", 10, 10, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(495), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPMT_SIG_SCHEME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(495), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_ATTEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (TPMT_SIGNATURE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_GetTime(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_GetTime _cffi_d_Esys_GetTime
#endif

static uint32_t _cffi_d_Esys_GetTime_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_DATA const * x6, TPMT_SIG_SCHEME const * x7)
{
  return Esys_GetTime_Async(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_GetTime_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_DATA const * x6;
  TPMT_SIG_SCHEME const * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_GetTime_Async", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(495), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPMT_SIG_SCHEME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(495), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_GetTime_Async(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_GetTime_Async _cffi_d_Esys_GetTime_Async
#endif

static uint32_t _cffi_d_Esys_GetTime_Finish(ESYS_CONTEXT * x0, TPM2B_ATTEST * * x1, TPMT_SIGNATURE * * x2)
{
  return Esys_GetTime_Finish(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_GetTime_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_ATTEST * * x1;
  TPMT_SIGNATURE * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_GetTime_Finish", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_ATTEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPMT_SIGNATURE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_GetTime_Finish(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_GetTime_Finish _cffi_d_Esys_GetTime_Finish
#endif

static uint32_t _cffi_d_Esys_HMAC(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_MAX_BUFFER const * x5, uint16_t x6, TPM2B_DIGEST * * x7)
{
  return Esys_HMAC(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_HMAC(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_MAX_BUFFER const * x5;
  uint16_t x6;
  TPM2B_DIGEST * * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_HMAC", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(311), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(311), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, uint16_t);
  if (x6 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_HMAC(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_HMAC _cffi_d_Esys_HMAC
#endif

static uint32_t _cffi_d_Esys_HMAC_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_MAX_BUFFER const * x5, uint16_t x6)
{
  return Esys_HMAC_Async(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_HMAC_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_MAX_BUFFER const * x5;
  uint16_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_HMAC_Async", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(311), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(311), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, uint16_t);
  if (x6 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_HMAC_Async(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_HMAC_Async _cffi_d_Esys_HMAC_Async
#endif

static uint32_t _cffi_d_Esys_HMAC_Finish(ESYS_CONTEXT * x0, TPM2B_DIGEST * * x1)
{
  return Esys_HMAC_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_HMAC_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_DIGEST * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_HMAC_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_HMAC_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_HMAC_Finish _cffi_d_Esys_HMAC_Finish
#endif

static uint32_t _cffi_d_Esys_HMAC_Start(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5, uint16_t x6, uint32_t * x7)
{
  return Esys_HMAC_Start(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_HMAC_Start(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  uint16_t x6;
  uint32_t * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_HMAC_Start", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, uint16_t);
  if (x6 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_HMAC_Start(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_HMAC_Start _cffi_d_Esys_HMAC_Start
#endif

static uint32_t _cffi_d_Esys_HMAC_Start_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5, uint16_t x6)
{
  return Esys_HMAC_Start_Async(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_HMAC_Start_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  uint16_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_HMAC_Start_Async", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, uint16_t);
  if (x6 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_HMAC_Start_Async(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_HMAC_Start_Async _cffi_d_Esys_HMAC_Start_Async
#endif

static uint32_t _cffi_d_Esys_HMAC_Start_Finish(ESYS_CONTEXT * x0, uint32_t * x1)
{
  return Esys_HMAC_Start_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_HMAC_Start_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_HMAC_Start_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_HMAC_Start_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_HMAC_Start_Finish _cffi_d_Esys_HMAC_Start_Finish
#endif

static uint32_t _cffi_d_Esys_Hash(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, TPM2B_MAX_BUFFER const * x4, uint16_t x5, uint32_t x6, TPM2B_DIGEST * * x7, TPMT_TK_HASHCHECK * * x8)
{
  return Esys_Hash(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Hash(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  TPM2B_MAX_BUFFER const * x4;
  uint16_t x5;
  uint32_t x6;
  TPM2B_DIGEST * * x7;
  TPMT_TK_HASHCHECK * * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "Esys_Hash", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(311), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(311), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, uint16_t);
  if (x5 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPMT_TK_HASHCHECK * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Hash(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Hash _cffi_d_Esys_Hash
#endif

static uint32_t _cffi_d_Esys_HashSequenceStart(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, TPM2B_DIGEST const * x4, uint16_t x5, uint32_t * x6)
{
  return Esys_HashSequenceStart(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_HashSequenceStart(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  TPM2B_DIGEST const * x4;
  uint16_t x5;
  uint32_t * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_HashSequenceStart", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, uint16_t);
  if (x5 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_HashSequenceStart(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_HashSequenceStart _cffi_d_Esys_HashSequenceStart
#endif

static uint32_t _cffi_d_Esys_HashSequenceStart_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, TPM2B_DIGEST const * x4, uint16_t x5)
{
  return Esys_HashSequenceStart_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_HashSequenceStart_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  TPM2B_DIGEST const * x4;
  uint16_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_HashSequenceStart_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, uint16_t);
  if (x5 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_HashSequenceStart_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_HashSequenceStart_Async _cffi_d_Esys_HashSequenceStart_Async
#endif

static uint32_t _cffi_d_Esys_HashSequenceStart_Finish(ESYS_CONTEXT * x0, uint32_t * x1)
{
  return Esys_HashSequenceStart_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_HashSequenceStart_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_HashSequenceStart_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_HashSequenceStart_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_HashSequenceStart_Finish _cffi_d_Esys_HashSequenceStart_Finish
#endif

static uint32_t _cffi_d_Esys_Hash_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, TPM2B_MAX_BUFFER const * x4, uint16_t x5, uint32_t x6)
{
  return Esys_Hash_Async(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Hash_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  TPM2B_MAX_BUFFER const * x4;
  uint16_t x5;
  uint32_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_Hash_Async", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(311), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(311), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, uint16_t);
  if (x5 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Hash_Async(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Hash_Async _cffi_d_Esys_Hash_Async
#endif

static uint32_t _cffi_d_Esys_Hash_Finish(ESYS_CONTEXT * x0, TPM2B_DIGEST * * x1, TPMT_TK_HASHCHECK * * x2)
{
  return Esys_Hash_Finish(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Hash_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_DIGEST * * x1;
  TPMT_TK_HASHCHECK * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_Hash_Finish", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPMT_TK_HASHCHECK * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Hash_Finish(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Hash_Finish _cffi_d_Esys_Hash_Finish
#endif

static uint32_t _cffi_d_Esys_HierarchyChangeAuth(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5)
{
  return Esys_HierarchyChangeAuth(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_HierarchyChangeAuth(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_HierarchyChangeAuth", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_HierarchyChangeAuth(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_HierarchyChangeAuth _cffi_d_Esys_HierarchyChangeAuth
#endif

static uint32_t _cffi_d_Esys_HierarchyChangeAuth_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5)
{
  return Esys_HierarchyChangeAuth_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_HierarchyChangeAuth_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_HierarchyChangeAuth_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_HierarchyChangeAuth_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_HierarchyChangeAuth_Async _cffi_d_Esys_HierarchyChangeAuth_Async
#endif

static uint32_t _cffi_d_Esys_HierarchyChangeAuth_Finish(ESYS_CONTEXT * x0)
{
  return Esys_HierarchyChangeAuth_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_HierarchyChangeAuth_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_HierarchyChangeAuth_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_HierarchyChangeAuth_Finish _cffi_d_Esys_HierarchyChangeAuth_Finish
#endif

static uint32_t _cffi_d_Esys_HierarchyControl(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint8_t x6)
{
  return Esys_HierarchyControl(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_HierarchyControl(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint8_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_HierarchyControl", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint8_t);
  if (x6 == (uint8_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_HierarchyControl(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_HierarchyControl _cffi_d_Esys_HierarchyControl
#endif

static uint32_t _cffi_d_Esys_HierarchyControl_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint8_t x6)
{
  return Esys_HierarchyControl_Async(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_HierarchyControl_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint8_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_HierarchyControl_Async", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint8_t);
  if (x6 == (uint8_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_HierarchyControl_Async(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_HierarchyControl_Async _cffi_d_Esys_HierarchyControl_Async
#endif

static uint32_t _cffi_d_Esys_HierarchyControl_Finish(ESYS_CONTEXT * x0)
{
  return Esys_HierarchyControl_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_HierarchyControl_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_HierarchyControl_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_HierarchyControl_Finish _cffi_d_Esys_HierarchyControl_Finish
#endif

static uint32_t _cffi_d_Esys_Import(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DATA const * x5, TPM2B_PUBLIC const * x6, TPM2B_PRIVATE const * x7, TPM2B_ENCRYPTED_SECRET const * x8, TPMT_SYM_DEF_OBJECT const * x9, TPM2B_PRIVATE * * x10)
{
  return Esys_Import(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Import(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DATA const * x5;
  TPM2B_PUBLIC const * x6;
  TPM2B_PRIVATE const * x7;
  TPM2B_ENCRYPTED_SECRET const * x8;
  TPMT_SYM_DEF_OBJECT const * x9;
  TPM2B_PRIVATE * * x10;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;

  if (!PyArg_UnpackTuple(args, "Esys_Import", 11, 11, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(358), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(358), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(471), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_PRIVATE const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(471), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(472), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_ENCRYPTED_SECRET const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(472), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(473), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (TPMT_SYM_DEF_OBJECT const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(473), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg10, (char **)&x10);
  if (datasize != 0) {
    x10 = ((size_t)datasize) <= 640 ? (TPM2B_PRIVATE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg10, (char **)&x10,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Import(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Import _cffi_d_Esys_Import
#endif

static uint32_t _cffi_d_Esys_Import_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DATA const * x5, TPM2B_PUBLIC const * x6, TPM2B_PRIVATE const * x7, TPM2B_ENCRYPTED_SECRET const * x8, TPMT_SYM_DEF_OBJECT const * x9)
{
  return Esys_Import_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Import_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DATA const * x5;
  TPM2B_PUBLIC const * x6;
  TPM2B_PRIVATE const * x7;
  TPM2B_ENCRYPTED_SECRET const * x8;
  TPMT_SYM_DEF_OBJECT const * x9;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;

  if (!PyArg_UnpackTuple(args, "Esys_Import_Async", 10, 10, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(358), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(358), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(471), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_PRIVATE const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(471), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(472), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_ENCRYPTED_SECRET const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(472), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(473), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (TPMT_SYM_DEF_OBJECT const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(473), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Import_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Import_Async _cffi_d_Esys_Import_Async
#endif

static uint32_t _cffi_d_Esys_Import_Finish(ESYS_CONTEXT * x0, TPM2B_PRIVATE * * x1)
{
  return Esys_Import_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Import_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_PRIVATE * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_Import_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_PRIVATE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Import_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Import_Finish _cffi_d_Esys_Import_Finish
#endif

static uint32_t _cffi_d_Esys_IncrementalSelfTest(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, TPML_ALG const * x4, TPML_ALG * * x5)
{
  return Esys_IncrementalSelfTest(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_IncrementalSelfTest(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  TPML_ALG const * x4;
  TPML_ALG * * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_IncrementalSelfTest", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(383), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (TPML_ALG const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(383), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(142), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPML_ALG * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(142), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_IncrementalSelfTest(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_IncrementalSelfTest _cffi_d_Esys_IncrementalSelfTest
#endif

static uint32_t _cffi_d_Esys_IncrementalSelfTest_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, TPML_ALG const * x4)
{
  return Esys_IncrementalSelfTest_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_IncrementalSelfTest_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  TPML_ALG const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_IncrementalSelfTest_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(383), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (TPML_ALG const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(383), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_IncrementalSelfTest_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_IncrementalSelfTest_Async _cffi_d_Esys_IncrementalSelfTest_Async
#endif

static uint32_t _cffi_d_Esys_IncrementalSelfTest_Finish(ESYS_CONTEXT * x0, TPML_ALG * * x1)
{
  return Esys_IncrementalSelfTest_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_IncrementalSelfTest_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPML_ALG * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_IncrementalSelfTest_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(142), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPML_ALG * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(142), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_IncrementalSelfTest_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_IncrementalSelfTest_Finish _cffi_d_Esys_IncrementalSelfTest_Finish
#endif

static uint32_t _cffi_d_Esys_Initialize(ESYS_CONTEXT * * x0, TSS2_TCTI_CONTEXT * x1, TSS2_ABI_VERSION * x2)
{
  return Esys_Initialize(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Initialize(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * * x0;
  TSS2_TCTI_CONTEXT * x1;
  TSS2_ABI_VERSION * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_Initialize", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TSS2_TCTI_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(15), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TSS2_ABI_VERSION *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Initialize(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Initialize _cffi_d_Esys_Initialize
#endif

static uint32_t _cffi_d_Esys_Load(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_PRIVATE const * x5, TPM2B_PUBLIC const * x6, uint32_t * x7)
{
  return Esys_Load(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Load(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_PRIVATE const * x5;
  TPM2B_PUBLIC const * x6;
  uint32_t * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_Load", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(471), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_PRIVATE const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(471), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(358), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(358), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Load(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Load _cffi_d_Esys_Load
#endif

static uint32_t _cffi_d_Esys_LoadExternal(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, TPM2B_SENSITIVE const * x4, TPM2B_PUBLIC const * x5, uint32_t x6, uint32_t * x7)
{
  return Esys_LoadExternal(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_LoadExternal(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  TPM2B_SENSITIVE const * x4;
  TPM2B_PUBLIC const * x5;
  uint32_t x6;
  uint32_t * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_LoadExternal", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(357), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (TPM2B_SENSITIVE const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(357), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(358), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(358), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_LoadExternal(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_LoadExternal _cffi_d_Esys_LoadExternal
#endif

static uint32_t _cffi_d_Esys_LoadExternal_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, TPM2B_SENSITIVE const * x4, TPM2B_PUBLIC const * x5, uint32_t x6)
{
  return Esys_LoadExternal_Async(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_LoadExternal_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  TPM2B_SENSITIVE const * x4;
  TPM2B_PUBLIC const * x5;
  uint32_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_LoadExternal_Async", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(357), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (TPM2B_SENSITIVE const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(357), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(358), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(358), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_LoadExternal_Async(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_LoadExternal_Async _cffi_d_Esys_LoadExternal_Async
#endif

static uint32_t _cffi_d_Esys_LoadExternal_Finish(ESYS_CONTEXT * x0, uint32_t * x1)
{
  return Esys_LoadExternal_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_LoadExternal_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_LoadExternal_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_LoadExternal_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_LoadExternal_Finish _cffi_d_Esys_LoadExternal_Finish
#endif

static uint32_t _cffi_d_Esys_Load_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_PRIVATE const * x5, TPM2B_PUBLIC const * x6)
{
  return Esys_Load_Async(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Load_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_PRIVATE const * x5;
  TPM2B_PUBLIC const * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_Load_Async", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(471), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_PRIVATE const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(471), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(358), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(358), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Load_Async(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Load_Async _cffi_d_Esys_Load_Async
#endif

static uint32_t _cffi_d_Esys_Load_Finish(ESYS_CONTEXT * x0, uint32_t * x1)
{
  return Esys_Load_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Load_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_Load_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Load_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Load_Finish _cffi_d_Esys_Load_Finish
#endif

static uint32_t _cffi_d_Esys_MAC(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_MAX_BUFFER const * x5, uint16_t x6, TPM2B_DIGEST * * x7)
{
  return Esys_MAC(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_MAC(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_MAX_BUFFER const * x5;
  uint16_t x6;
  TPM2B_DIGEST * * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_MAC", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(311), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(311), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, uint16_t);
  if (x6 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_MAC(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_MAC _cffi_d_Esys_MAC
#endif

static uint32_t _cffi_d_Esys_MAC_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_MAX_BUFFER const * x5, uint16_t x6)
{
  return Esys_MAC_Async(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_MAC_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_MAX_BUFFER const * x5;
  uint16_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_MAC_Async", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(311), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_BUFFER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(311), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, uint16_t);
  if (x6 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_MAC_Async(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_MAC_Async _cffi_d_Esys_MAC_Async
#endif

static uint32_t _cffi_d_Esys_MAC_Finish(ESYS_CONTEXT * x0, TPM2B_DIGEST * * x1)
{
  return Esys_MAC_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_MAC_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_DIGEST * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_MAC_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_MAC_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_MAC_Finish _cffi_d_Esys_MAC_Finish
#endif

static uint32_t _cffi_d_Esys_MAC_Start(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5, uint16_t x6, uint32_t * x7)
{
  return Esys_MAC_Start(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_MAC_Start(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  uint16_t x6;
  uint32_t * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_MAC_Start", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, uint16_t);
  if (x6 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_MAC_Start(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_MAC_Start _cffi_d_Esys_MAC_Start
#endif

static uint32_t _cffi_d_Esys_MAC_Start_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5, uint16_t x6)
{
  return Esys_MAC_Start_Async(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_MAC_Start_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  uint16_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_MAC_Start_Async", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, uint16_t);
  if (x6 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_MAC_Start_Async(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_MAC_Start_Async _cffi_d_Esys_MAC_Start_Async
#endif

static uint32_t _cffi_d_Esys_MAC_Start_Finish(ESYS_CONTEXT * x0, uint32_t * x1)
{
  return Esys_MAC_Start_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_MAC_Start_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_MAC_Start_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_MAC_Start_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_MAC_Start_Finish _cffi_d_Esys_MAC_Start_Finish
#endif

static uint32_t _cffi_d_Esys_MakeCredential(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5, TPM2B_NAME const * x6, TPM2B_ID_OBJECT * * x7, TPM2B_ENCRYPTED_SECRET * * x8)
{
  return Esys_MakeCredential(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_MakeCredential(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  TPM2B_NAME const * x6;
  TPM2B_ID_OBJECT * * x7;
  TPM2B_ENCRYPTED_SECRET * * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "Esys_MakeCredential", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(535), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_NAME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(535), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(77), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_ID_OBJECT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(77), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_ENCRYPTED_SECRET * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_MakeCredential(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_MakeCredential _cffi_d_Esys_MakeCredential
#endif

static uint32_t _cffi_d_Esys_MakeCredential_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5, TPM2B_NAME const * x6)
{
  return Esys_MakeCredential_Async(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_MakeCredential_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  TPM2B_NAME const * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_MakeCredential_Async", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(535), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_NAME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(535), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_MakeCredential_Async(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_MakeCredential_Async _cffi_d_Esys_MakeCredential_Async
#endif

static uint32_t _cffi_d_Esys_MakeCredential_Finish(ESYS_CONTEXT * x0, TPM2B_ID_OBJECT * * x1, TPM2B_ENCRYPTED_SECRET * * x2)
{
  return Esys_MakeCredential_Finish(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_MakeCredential_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_ID_OBJECT * * x1;
  TPM2B_ENCRYPTED_SECRET * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_MakeCredential_Finish", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(77), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_ID_OBJECT * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(77), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPM2B_ENCRYPTED_SECRET * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_MakeCredential_Finish(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_MakeCredential_Finish _cffi_d_Esys_MakeCredential_Finish
#endif

static uint32_t _cffi_d_Esys_NV_Certify(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint32_t x6, TPM2B_DATA const * x7, TPMT_SIG_SCHEME const * x8, uint16_t x9, uint16_t x10, TPM2B_ATTEST * * x11, TPMT_SIGNATURE * * x12)
{
  return Esys_NV_Certify(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_Certify(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  TPM2B_DATA const * x7;
  TPMT_SIG_SCHEME const * x8;
  uint16_t x9;
  uint16_t x10;
  TPM2B_ATTEST * * x11;
  TPMT_SIGNATURE * * x12;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;
  PyObject *arg11;
  PyObject *arg12;

  if (!PyArg_UnpackTuple(args, "Esys_NV_Certify", 13, 13, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10, &arg11, &arg12))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(495), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPMT_SIG_SCHEME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(495), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x9 = _cffi_to_c_int(arg9, uint16_t);
  if (x9 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x10 = _cffi_to_c_int(arg10, uint16_t);
  if (x10 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg11, (char **)&x11);
  if (datasize != 0) {
    x11 = ((size_t)datasize) <= 640 ? (TPM2B_ATTEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg11, (char **)&x11,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg12, (char **)&x12);
  if (datasize != 0) {
    x12 = ((size_t)datasize) <= 640 ? (TPMT_SIGNATURE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg12, (char **)&x12,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_Certify(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_Certify _cffi_d_Esys_NV_Certify
#endif

static uint32_t _cffi_d_Esys_NV_Certify_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint32_t x6, TPM2B_DATA const * x7, TPMT_SIG_SCHEME const * x8, uint16_t x9, uint16_t x10)
{
  return Esys_NV_Certify_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_Certify_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  TPM2B_DATA const * x7;
  TPMT_SIG_SCHEME const * x8;
  uint16_t x9;
  uint16_t x10;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;

  if (!PyArg_UnpackTuple(args, "Esys_NV_Certify_Async", 11, 11, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(495), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPMT_SIG_SCHEME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(495), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x9 = _cffi_to_c_int(arg9, uint16_t);
  if (x9 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x10 = _cffi_to_c_int(arg10, uint16_t);
  if (x10 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_Certify_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_Certify_Async _cffi_d_Esys_NV_Certify_Async
#endif

static uint32_t _cffi_d_Esys_NV_Certify_Finish(ESYS_CONTEXT * x0, TPM2B_ATTEST * * x1, TPMT_SIGNATURE * * x2)
{
  return Esys_NV_Certify_Finish(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_Certify_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_ATTEST * * x1;
  TPMT_SIGNATURE * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_NV_Certify_Finish", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_ATTEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPMT_SIGNATURE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_Certify_Finish(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_Certify_Finish _cffi_d_Esys_NV_Certify_Finish
#endif

static uint32_t _cffi_d_Esys_NV_ChangeAuth(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5)
{
  return Esys_NV_ChangeAuth(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_ChangeAuth(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_NV_ChangeAuth", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_ChangeAuth(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_ChangeAuth _cffi_d_Esys_NV_ChangeAuth
#endif

static uint32_t _cffi_d_Esys_NV_ChangeAuth_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5)
{
  return Esys_NV_ChangeAuth_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_ChangeAuth_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_NV_ChangeAuth_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_ChangeAuth_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_ChangeAuth_Async _cffi_d_Esys_NV_ChangeAuth_Async
#endif

static uint32_t _cffi_d_Esys_NV_ChangeAuth_Finish(ESYS_CONTEXT * x0)
{
  return Esys_NV_ChangeAuth_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_ChangeAuth_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_ChangeAuth_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_ChangeAuth_Finish _cffi_d_Esys_NV_ChangeAuth_Finish
#endif

static uint32_t _cffi_d_Esys_NV_DefineSpace(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5, TPM2B_NV_PUBLIC const * x6, uint32_t * x7)
{
  return Esys_NV_DefineSpace(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_DefineSpace(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  TPM2B_NV_PUBLIC const * x6;
  uint32_t * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_NV_DefineSpace", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(576), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_NV_PUBLIC const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(576), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_DefineSpace(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_DefineSpace _cffi_d_Esys_NV_DefineSpace
#endif

static uint32_t _cffi_d_Esys_NV_DefineSpace_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5, TPM2B_NV_PUBLIC const * x6)
{
  return Esys_NV_DefineSpace_Async(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_DefineSpace_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  TPM2B_NV_PUBLIC const * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_NV_DefineSpace_Async", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(576), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_NV_PUBLIC const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(576), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_DefineSpace_Async(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_DefineSpace_Async _cffi_d_Esys_NV_DefineSpace_Async
#endif

static uint32_t _cffi_d_Esys_NV_DefineSpace_Finish(ESYS_CONTEXT * x0, uint32_t * x1)
{
  return Esys_NV_DefineSpace_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_DefineSpace_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_NV_DefineSpace_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_DefineSpace_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_DefineSpace_Finish _cffi_d_Esys_NV_DefineSpace_Finish
#endif

static uint32_t _cffi_d_Esys_NV_Extend(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_MAX_NV_BUFFER const * x6)
{
  return Esys_NV_Extend(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_Extend(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_MAX_NV_BUFFER const * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_NV_Extend", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1317), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_NV_BUFFER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1317), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_Extend(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_Extend _cffi_d_Esys_NV_Extend
#endif

static uint32_t _cffi_d_Esys_NV_Extend_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_MAX_NV_BUFFER const * x6)
{
  return Esys_NV_Extend_Async(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_Extend_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_MAX_NV_BUFFER const * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_NV_Extend_Async", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1317), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_NV_BUFFER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1317), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_Extend_Async(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_Extend_Async _cffi_d_Esys_NV_Extend_Async
#endif

static uint32_t _cffi_d_Esys_NV_Extend_Finish(ESYS_CONTEXT * x0)
{
  return Esys_NV_Extend_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_Extend_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_Extend_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_Extend_Finish _cffi_d_Esys_NV_Extend_Finish
#endif

static uint32_t _cffi_d_Esys_NV_GlobalWriteLock(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_NV_GlobalWriteLock(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_GlobalWriteLock(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_NV_GlobalWriteLock", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_GlobalWriteLock(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_GlobalWriteLock _cffi_d_Esys_NV_GlobalWriteLock
#endif

static uint32_t _cffi_d_Esys_NV_GlobalWriteLock_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_NV_GlobalWriteLock_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_GlobalWriteLock_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_NV_GlobalWriteLock_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_GlobalWriteLock_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_GlobalWriteLock_Async _cffi_d_Esys_NV_GlobalWriteLock_Async
#endif

static uint32_t _cffi_d_Esys_NV_GlobalWriteLock_Finish(ESYS_CONTEXT * x0)
{
  return Esys_NV_GlobalWriteLock_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_GlobalWriteLock_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_GlobalWriteLock_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_GlobalWriteLock_Finish _cffi_d_Esys_NV_GlobalWriteLock_Finish
#endif

static uint32_t _cffi_d_Esys_NV_Increment(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5)
{
  return Esys_NV_Increment(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_Increment(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_NV_Increment", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_Increment(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_Increment _cffi_d_Esys_NV_Increment
#endif

static uint32_t _cffi_d_Esys_NV_Increment_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5)
{
  return Esys_NV_Increment_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_Increment_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_NV_Increment_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_Increment_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_Increment_Async _cffi_d_Esys_NV_Increment_Async
#endif

static uint32_t _cffi_d_Esys_NV_Increment_Finish(ESYS_CONTEXT * x0)
{
  return Esys_NV_Increment_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_Increment_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_Increment_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_Increment_Finish _cffi_d_Esys_NV_Increment_Finish
#endif

static uint32_t _cffi_d_Esys_NV_Read(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint16_t x6, uint16_t x7, TPM2B_MAX_NV_BUFFER * * x8)
{
  return Esys_NV_Read(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_Read(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint16_t x6;
  uint16_t x7;
  TPM2B_MAX_NV_BUFFER * * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "Esys_NV_Read", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint16_t);
  if (x6 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, uint16_t);
  if (x7 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(102), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_NV_BUFFER * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(102), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_Read(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_Read _cffi_d_Esys_NV_Read
#endif

static uint32_t _cffi_d_Esys_NV_ReadLock(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5)
{
  return Esys_NV_ReadLock(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_ReadLock(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_NV_ReadLock", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_ReadLock(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_ReadLock _cffi_d_Esys_NV_ReadLock
#endif

static uint32_t _cffi_d_Esys_NV_ReadLock_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5)
{
  return Esys_NV_ReadLock_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_ReadLock_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_NV_ReadLock_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_ReadLock_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_ReadLock_Async _cffi_d_Esys_NV_ReadLock_Async
#endif

static uint32_t _cffi_d_Esys_NV_ReadLock_Finish(ESYS_CONTEXT * x0)
{
  return Esys_NV_ReadLock_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_ReadLock_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_ReadLock_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_ReadLock_Finish _cffi_d_Esys_NV_ReadLock_Finish
#endif

static uint32_t _cffi_d_Esys_NV_ReadPublic(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_NV_PUBLIC * * x5, TPM2B_NAME * * x6)
{
  return Esys_NV_ReadPublic(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_ReadPublic(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_NV_PUBLIC * * x5;
  TPM2B_NAME * * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_NV_ReadPublic", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(106), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_NV_PUBLIC * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(106), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_NAME * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_ReadPublic(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_ReadPublic _cffi_d_Esys_NV_ReadPublic
#endif

static uint32_t _cffi_d_Esys_NV_ReadPublic_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_NV_ReadPublic_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_ReadPublic_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_NV_ReadPublic_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_ReadPublic_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_ReadPublic_Async _cffi_d_Esys_NV_ReadPublic_Async
#endif

static uint32_t _cffi_d_Esys_NV_ReadPublic_Finish(ESYS_CONTEXT * x0, TPM2B_NV_PUBLIC * * x1, TPM2B_NAME * * x2)
{
  return Esys_NV_ReadPublic_Finish(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_ReadPublic_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_NV_PUBLIC * * x1;
  TPM2B_NAME * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_NV_ReadPublic_Finish", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(106), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_NV_PUBLIC * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(106), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPM2B_NAME * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_ReadPublic_Finish(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_ReadPublic_Finish _cffi_d_Esys_NV_ReadPublic_Finish
#endif

static uint32_t _cffi_d_Esys_NV_Read_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint16_t x6, uint16_t x7)
{
  return Esys_NV_Read_Async(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_Read_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint16_t x6;
  uint16_t x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_NV_Read_Async", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint16_t);
  if (x6 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, uint16_t);
  if (x7 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_Read_Async(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_Read_Async _cffi_d_Esys_NV_Read_Async
#endif

static uint32_t _cffi_d_Esys_NV_Read_Finish(ESYS_CONTEXT * x0, TPM2B_MAX_NV_BUFFER * * x1)
{
  return Esys_NV_Read_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_Read_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_MAX_NV_BUFFER * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_NV_Read_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(102), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_NV_BUFFER * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(102), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_Read_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_Read_Finish _cffi_d_Esys_NV_Read_Finish
#endif

static uint32_t _cffi_d_Esys_NV_SetBits(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint64_t x6)
{
  return Esys_NV_SetBits(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_SetBits(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint64_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_NV_SetBits", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint64_t);
  if (x6 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_SetBits(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_SetBits _cffi_d_Esys_NV_SetBits
#endif

static uint32_t _cffi_d_Esys_NV_SetBits_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint64_t x6)
{
  return Esys_NV_SetBits_Async(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_SetBits_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint64_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_NV_SetBits_Async", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint64_t);
  if (x6 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_SetBits_Async(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_SetBits_Async _cffi_d_Esys_NV_SetBits_Async
#endif

static uint32_t _cffi_d_Esys_NV_SetBits_Finish(ESYS_CONTEXT * x0)
{
  return Esys_NV_SetBits_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_SetBits_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_SetBits_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_SetBits_Finish _cffi_d_Esys_NV_SetBits_Finish
#endif

static uint32_t _cffi_d_Esys_NV_UndefineSpace(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5)
{
  return Esys_NV_UndefineSpace(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_UndefineSpace(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_NV_UndefineSpace", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_UndefineSpace(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_UndefineSpace _cffi_d_Esys_NV_UndefineSpace
#endif

static uint32_t _cffi_d_Esys_NV_UndefineSpaceSpecial(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5)
{
  return Esys_NV_UndefineSpaceSpecial(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_UndefineSpaceSpecial(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_NV_UndefineSpaceSpecial", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_UndefineSpaceSpecial(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_UndefineSpaceSpecial _cffi_d_Esys_NV_UndefineSpaceSpecial
#endif

static uint32_t _cffi_d_Esys_NV_UndefineSpaceSpecial_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5)
{
  return Esys_NV_UndefineSpaceSpecial_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_UndefineSpaceSpecial_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_NV_UndefineSpaceSpecial_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_UndefineSpaceSpecial_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_UndefineSpaceSpecial_Async _cffi_d_Esys_NV_UndefineSpaceSpecial_Async
#endif

static uint32_t _cffi_d_Esys_NV_UndefineSpaceSpecial_Finish(ESYS_CONTEXT * x0)
{
  return Esys_NV_UndefineSpaceSpecial_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_UndefineSpaceSpecial_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_UndefineSpaceSpecial_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_UndefineSpaceSpecial_Finish _cffi_d_Esys_NV_UndefineSpaceSpecial_Finish
#endif

static uint32_t _cffi_d_Esys_NV_UndefineSpace_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5)
{
  return Esys_NV_UndefineSpace_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_UndefineSpace_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_NV_UndefineSpace_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_UndefineSpace_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_UndefineSpace_Async _cffi_d_Esys_NV_UndefineSpace_Async
#endif

static uint32_t _cffi_d_Esys_NV_UndefineSpace_Finish(ESYS_CONTEXT * x0)
{
  return Esys_NV_UndefineSpace_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_UndefineSpace_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_UndefineSpace_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_UndefineSpace_Finish _cffi_d_Esys_NV_UndefineSpace_Finish
#endif

static uint32_t _cffi_d_Esys_NV_Write(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_MAX_NV_BUFFER const * x6, uint16_t x7)
{
  return Esys_NV_Write(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_Write(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_MAX_NV_BUFFER const * x6;
  uint16_t x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_NV_Write", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1317), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_NV_BUFFER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1317), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x7 = _cffi_to_c_int(arg7, uint16_t);
  if (x7 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_Write(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_Write _cffi_d_Esys_NV_Write
#endif

static uint32_t _cffi_d_Esys_NV_WriteLock(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5)
{
  return Esys_NV_WriteLock(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_WriteLock(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_NV_WriteLock", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_WriteLock(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_WriteLock _cffi_d_Esys_NV_WriteLock
#endif

static uint32_t _cffi_d_Esys_NV_WriteLock_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5)
{
  return Esys_NV_WriteLock_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_WriteLock_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_NV_WriteLock_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_WriteLock_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_WriteLock_Async _cffi_d_Esys_NV_WriteLock_Async
#endif

static uint32_t _cffi_d_Esys_NV_WriteLock_Finish(ESYS_CONTEXT * x0)
{
  return Esys_NV_WriteLock_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_WriteLock_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_WriteLock_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_WriteLock_Finish _cffi_d_Esys_NV_WriteLock_Finish
#endif

static uint32_t _cffi_d_Esys_NV_Write_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_MAX_NV_BUFFER const * x6, uint16_t x7)
{
  return Esys_NV_Write_Async(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_Write_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_MAX_NV_BUFFER const * x6;
  uint16_t x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_NV_Write_Async", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1317), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_MAX_NV_BUFFER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1317), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x7 = _cffi_to_c_int(arg7, uint16_t);
  if (x7 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_Write_Async(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_Write_Async _cffi_d_Esys_NV_Write_Async
#endif

static uint32_t _cffi_d_Esys_NV_Write_Finish(ESYS_CONTEXT * x0)
{
  return Esys_NV_Write_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_NV_Write_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_NV_Write_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_NV_Write_Finish _cffi_d_Esys_NV_Write_Finish
#endif

static uint32_t _cffi_d_Esys_ObjectChangeAuth(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_DIGEST const * x6, TPM2B_PRIVATE * * x7)
{
  return Esys_ObjectChangeAuth(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ObjectChangeAuth(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_DIGEST const * x6;
  TPM2B_PRIVATE * * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_ObjectChangeAuth", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_PRIVATE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ObjectChangeAuth(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ObjectChangeAuth _cffi_d_Esys_ObjectChangeAuth
#endif

static uint32_t _cffi_d_Esys_ObjectChangeAuth_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_DIGEST const * x6)
{
  return Esys_ObjectChangeAuth_Async(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ObjectChangeAuth_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_DIGEST const * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_ObjectChangeAuth_Async", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ObjectChangeAuth_Async(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ObjectChangeAuth_Async _cffi_d_Esys_ObjectChangeAuth_Async
#endif

static uint32_t _cffi_d_Esys_ObjectChangeAuth_Finish(ESYS_CONTEXT * x0, TPM2B_PRIVATE * * x1)
{
  return Esys_ObjectChangeAuth_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ObjectChangeAuth_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_PRIVATE * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_ObjectChangeAuth_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_PRIVATE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ObjectChangeAuth_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ObjectChangeAuth_Finish _cffi_d_Esys_ObjectChangeAuth_Finish
#endif

static uint32_t _cffi_d_Esys_PCR_Allocate(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPML_PCR_SELECTION const * x5, uint8_t * x6, uint32_t * x7, uint32_t * x8, uint32_t * x9)
{
  return Esys_PCR_Allocate(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PCR_Allocate(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPML_PCR_SELECTION const * x5;
  uint8_t * x6;
  uint32_t * x7;
  uint32_t * x8;
  uint32_t * x9;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;

  if (!PyArg_UnpackTuple(args, "Esys_PCR_Allocate", 10, 10, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(398), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPML_PCR_SELECTION const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(398), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1027), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1027), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PCR_Allocate(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PCR_Allocate _cffi_d_Esys_PCR_Allocate
#endif

static uint32_t _cffi_d_Esys_PCR_Allocate_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPML_PCR_SELECTION const * x5)
{
  return Esys_PCR_Allocate_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PCR_Allocate_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPML_PCR_SELECTION const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_PCR_Allocate_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(398), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPML_PCR_SELECTION const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(398), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PCR_Allocate_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PCR_Allocate_Async _cffi_d_Esys_PCR_Allocate_Async
#endif

static uint32_t _cffi_d_Esys_PCR_Allocate_Finish(ESYS_CONTEXT * x0, uint8_t * x1, uint32_t * x2, uint32_t * x3, uint32_t * x4)
{
  return Esys_PCR_Allocate_Finish(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PCR_Allocate_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint8_t * x1;
  uint32_t * x2;
  uint32_t * x3;
  uint32_t * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_PCR_Allocate_Finish", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1027), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1027), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PCR_Allocate_Finish(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PCR_Allocate_Finish _cffi_d_Esys_PCR_Allocate_Finish
#endif

static uint32_t _cffi_d_Esys_PCR_Event(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_EVENT const * x5, TPML_DIGEST_VALUES * * x6)
{
  return Esys_PCR_Event(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PCR_Event(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_EVENT const * x5;
  TPML_DIGEST_VALUES * * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_PCR_Event", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(756), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_EVENT const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(756), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(146), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPML_DIGEST_VALUES * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(146), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PCR_Event(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PCR_Event _cffi_d_Esys_PCR_Event
#endif

static uint32_t _cffi_d_Esys_PCR_Event_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_EVENT const * x5)
{
  return Esys_PCR_Event_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PCR_Event_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_EVENT const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_PCR_Event_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(756), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_EVENT const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(756), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PCR_Event_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PCR_Event_Async _cffi_d_Esys_PCR_Event_Async
#endif

static uint32_t _cffi_d_Esys_PCR_Event_Finish(ESYS_CONTEXT * x0, TPML_DIGEST_VALUES * * x1)
{
  return Esys_PCR_Event_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PCR_Event_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPML_DIGEST_VALUES * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_PCR_Event_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(146), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPML_DIGEST_VALUES * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(146), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PCR_Event_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PCR_Event_Finish _cffi_d_Esys_PCR_Event_Finish
#endif

static uint32_t _cffi_d_Esys_PCR_Extend(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPML_DIGEST_VALUES const * x5)
{
  return Esys_PCR_Extend(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PCR_Extend(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPML_DIGEST_VALUES const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_PCR_Extend", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1010), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPML_DIGEST_VALUES const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1010), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PCR_Extend(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PCR_Extend _cffi_d_Esys_PCR_Extend
#endif

static uint32_t _cffi_d_Esys_PCR_Extend_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPML_DIGEST_VALUES const * x5)
{
  return Esys_PCR_Extend_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PCR_Extend_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPML_DIGEST_VALUES const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_PCR_Extend_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1010), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPML_DIGEST_VALUES const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1010), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PCR_Extend_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PCR_Extend_Async _cffi_d_Esys_PCR_Extend_Async
#endif

static uint32_t _cffi_d_Esys_PCR_Extend_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PCR_Extend_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PCR_Extend_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PCR_Extend_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PCR_Extend_Finish _cffi_d_Esys_PCR_Extend_Finish
#endif

static uint32_t _cffi_d_Esys_PCR_Read(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, TPML_PCR_SELECTION const * x4, uint32_t * x5, TPML_PCR_SELECTION * * x6, TPML_DIGEST * * x7)
{
  return Esys_PCR_Read(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PCR_Read(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  TPML_PCR_SELECTION const * x4;
  uint32_t * x5;
  TPML_PCR_SELECTION * * x6;
  TPML_DIGEST * * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_PCR_Read", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(398), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (TPML_PCR_SELECTION const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(398), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(228), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPML_PCR_SELECTION * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(228), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(229), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPML_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(229), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PCR_Read(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PCR_Read _cffi_d_Esys_PCR_Read
#endif

static uint32_t _cffi_d_Esys_PCR_Read_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, TPML_PCR_SELECTION const * x4)
{
  return Esys_PCR_Read_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PCR_Read_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  TPML_PCR_SELECTION const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_PCR_Read_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(398), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (TPML_PCR_SELECTION const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(398), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PCR_Read_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PCR_Read_Async _cffi_d_Esys_PCR_Read_Async
#endif

static uint32_t _cffi_d_Esys_PCR_Read_Finish(ESYS_CONTEXT * x0, uint32_t * x1, TPML_PCR_SELECTION * * x2, TPML_DIGEST * * x3)
{
  return Esys_PCR_Read_Finish(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PCR_Read_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t * x1;
  TPML_PCR_SELECTION * * x2;
  TPML_DIGEST * * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "Esys_PCR_Read_Finish", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(228), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPML_PCR_SELECTION * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(228), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(229), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (TPML_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(229), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PCR_Read_Finish(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PCR_Read_Finish _cffi_d_Esys_PCR_Read_Finish
#endif

static uint32_t _cffi_d_Esys_PCR_Reset(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_PCR_Reset(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PCR_Reset(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_PCR_Reset", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PCR_Reset(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PCR_Reset _cffi_d_Esys_PCR_Reset
#endif

static uint32_t _cffi_d_Esys_PCR_Reset_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_PCR_Reset_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PCR_Reset_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_PCR_Reset_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PCR_Reset_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PCR_Reset_Async _cffi_d_Esys_PCR_Reset_Async
#endif

static uint32_t _cffi_d_Esys_PCR_Reset_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PCR_Reset_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PCR_Reset_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PCR_Reset_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PCR_Reset_Finish _cffi_d_Esys_PCR_Reset_Finish
#endif

static uint32_t _cffi_d_Esys_PCR_SetAuthPolicy(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5, uint16_t x6, uint32_t x7)
{
  return Esys_PCR_SetAuthPolicy(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PCR_SetAuthPolicy(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  uint16_t x6;
  uint32_t x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_PCR_SetAuthPolicy", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, uint16_t);
  if (x6 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, uint32_t);
  if (x7 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PCR_SetAuthPolicy(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PCR_SetAuthPolicy _cffi_d_Esys_PCR_SetAuthPolicy
#endif

static uint32_t _cffi_d_Esys_PCR_SetAuthPolicy_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5, uint16_t x6, uint32_t x7)
{
  return Esys_PCR_SetAuthPolicy_Async(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PCR_SetAuthPolicy_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  uint16_t x6;
  uint32_t x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_PCR_SetAuthPolicy_Async", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, uint16_t);
  if (x6 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, uint32_t);
  if (x7 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PCR_SetAuthPolicy_Async(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PCR_SetAuthPolicy_Async _cffi_d_Esys_PCR_SetAuthPolicy_Async
#endif

static uint32_t _cffi_d_Esys_PCR_SetAuthPolicy_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PCR_SetAuthPolicy_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PCR_SetAuthPolicy_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PCR_SetAuthPolicy_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PCR_SetAuthPolicy_Finish _cffi_d_Esys_PCR_SetAuthPolicy_Finish
#endif

static uint32_t _cffi_d_Esys_PCR_SetAuthValue(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5)
{
  return Esys_PCR_SetAuthValue(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PCR_SetAuthValue(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_PCR_SetAuthValue", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PCR_SetAuthValue(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PCR_SetAuthValue _cffi_d_Esys_PCR_SetAuthValue
#endif

static uint32_t _cffi_d_Esys_PCR_SetAuthValue_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5)
{
  return Esys_PCR_SetAuthValue_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PCR_SetAuthValue_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_PCR_SetAuthValue_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PCR_SetAuthValue_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PCR_SetAuthValue_Async _cffi_d_Esys_PCR_SetAuthValue_Async
#endif

static uint32_t _cffi_d_Esys_PCR_SetAuthValue_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PCR_SetAuthValue_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PCR_SetAuthValue_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PCR_SetAuthValue_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PCR_SetAuthValue_Finish _cffi_d_Esys_PCR_SetAuthValue_Finish
#endif

static uint32_t _cffi_d_Esys_PP_Commands(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPML_CC const * x5, TPML_CC const * x6)
{
  return Esys_PP_Commands(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PP_Commands(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPML_CC const * x5;
  TPML_CC const * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_PP_Commands", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(993), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPML_CC const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(993), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(993), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPML_CC const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(993), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PP_Commands(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PP_Commands _cffi_d_Esys_PP_Commands
#endif

static uint32_t _cffi_d_Esys_PP_Commands_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPML_CC const * x5, TPML_CC const * x6)
{
  return Esys_PP_Commands_Async(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PP_Commands_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPML_CC const * x5;
  TPML_CC const * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_PP_Commands_Async", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(993), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPML_CC const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(993), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(993), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPML_CC const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(993), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PP_Commands_Async(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PP_Commands_Async _cffi_d_Esys_PP_Commands_Async
#endif

static uint32_t _cffi_d_Esys_PP_Commands_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PP_Commands_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PP_Commands_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PP_Commands_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PP_Commands_Finish _cffi_d_Esys_PP_Commands_Finish
#endif

static uint32_t _cffi_d_Esys_PolicyAuthValue(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_PolicyAuthValue(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyAuthValue(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyAuthValue", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyAuthValue(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyAuthValue _cffi_d_Esys_PolicyAuthValue
#endif

static uint32_t _cffi_d_Esys_PolicyAuthValue_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_PolicyAuthValue_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyAuthValue_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyAuthValue_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyAuthValue_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyAuthValue_Async _cffi_d_Esys_PolicyAuthValue_Async
#endif

static uint32_t _cffi_d_Esys_PolicyAuthValue_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PolicyAuthValue_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyAuthValue_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyAuthValue_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyAuthValue_Finish _cffi_d_Esys_PolicyAuthValue_Finish
#endif

static uint32_t _cffi_d_Esys_PolicyAuthorize(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5, TPM2B_DIGEST const * x6, TPM2B_NAME const * x7, TPMT_TK_VERIFIED const * x8)
{
  return Esys_PolicyAuthorize(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyAuthorize(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  TPM2B_DIGEST const * x6;
  TPM2B_NAME const * x7;
  TPMT_TK_VERIFIED const * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyAuthorize", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(535), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_NAME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(535), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(547), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPMT_TK_VERIFIED const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(547), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyAuthorize(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyAuthorize _cffi_d_Esys_PolicyAuthorize
#endif

static uint32_t _cffi_d_Esys_PolicyAuthorizeNV(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint32_t x6)
{
  return Esys_PolicyAuthorizeNV(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyAuthorizeNV(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyAuthorizeNV", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyAuthorizeNV(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyAuthorizeNV _cffi_d_Esys_PolicyAuthorizeNV
#endif

static uint32_t _cffi_d_Esys_PolicyAuthorizeNV_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint32_t x6)
{
  return Esys_PolicyAuthorizeNV_Async(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyAuthorizeNV_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyAuthorizeNV_Async", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyAuthorizeNV_Async(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyAuthorizeNV_Async _cffi_d_Esys_PolicyAuthorizeNV_Async
#endif

static uint32_t _cffi_d_Esys_PolicyAuthorizeNV_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PolicyAuthorizeNV_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyAuthorizeNV_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyAuthorizeNV_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyAuthorizeNV_Finish _cffi_d_Esys_PolicyAuthorizeNV_Finish
#endif

static uint32_t _cffi_d_Esys_PolicyAuthorize_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5, TPM2B_DIGEST const * x6, TPM2B_NAME const * x7, TPMT_TK_VERIFIED const * x8)
{
  return Esys_PolicyAuthorize_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyAuthorize_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  TPM2B_DIGEST const * x6;
  TPM2B_NAME const * x7;
  TPMT_TK_VERIFIED const * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyAuthorize_Async", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(535), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_NAME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(535), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(547), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPMT_TK_VERIFIED const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(547), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyAuthorize_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyAuthorize_Async _cffi_d_Esys_PolicyAuthorize_Async
#endif

static uint32_t _cffi_d_Esys_PolicyAuthorize_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PolicyAuthorize_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyAuthorize_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyAuthorize_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyAuthorize_Finish _cffi_d_Esys_PolicyAuthorize_Finish
#endif

static uint32_t _cffi_d_Esys_PolicyCommandCode(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5)
{
  return Esys_PolicyCommandCode(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyCommandCode(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyCommandCode", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyCommandCode(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyCommandCode _cffi_d_Esys_PolicyCommandCode
#endif

static uint32_t _cffi_d_Esys_PolicyCommandCode_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5)
{
  return Esys_PolicyCommandCode_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyCommandCode_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyCommandCode_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyCommandCode_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyCommandCode_Async _cffi_d_Esys_PolicyCommandCode_Async
#endif

static uint32_t _cffi_d_Esys_PolicyCommandCode_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PolicyCommandCode_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyCommandCode_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyCommandCode_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyCommandCode_Finish _cffi_d_Esys_PolicyCommandCode_Finish
#endif

static uint32_t _cffi_d_Esys_PolicyCounterTimer(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5, uint16_t x6, uint16_t x7)
{
  return Esys_PolicyCounterTimer(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyCounterTimer(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  uint16_t x6;
  uint16_t x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyCounterTimer", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, uint16_t);
  if (x6 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, uint16_t);
  if (x7 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyCounterTimer(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyCounterTimer _cffi_d_Esys_PolicyCounterTimer
#endif

static uint32_t _cffi_d_Esys_PolicyCounterTimer_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5, uint16_t x6, uint16_t x7)
{
  return Esys_PolicyCounterTimer_Async(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyCounterTimer_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  uint16_t x6;
  uint16_t x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyCounterTimer_Async", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, uint16_t);
  if (x6 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, uint16_t);
  if (x7 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyCounterTimer_Async(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyCounterTimer_Async _cffi_d_Esys_PolicyCounterTimer_Async
#endif

static uint32_t _cffi_d_Esys_PolicyCounterTimer_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PolicyCounterTimer_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyCounterTimer_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyCounterTimer_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyCounterTimer_Finish _cffi_d_Esys_PolicyCounterTimer_Finish
#endif

static uint32_t _cffi_d_Esys_PolicyCpHash(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5)
{
  return Esys_PolicyCpHash(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyCpHash(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyCpHash", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyCpHash(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyCpHash _cffi_d_Esys_PolicyCpHash
#endif

static uint32_t _cffi_d_Esys_PolicyCpHash_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5)
{
  return Esys_PolicyCpHash_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyCpHash_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyCpHash_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyCpHash_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyCpHash_Async _cffi_d_Esys_PolicyCpHash_Async
#endif

static uint32_t _cffi_d_Esys_PolicyCpHash_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PolicyCpHash_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyCpHash_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyCpHash_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyCpHash_Finish _cffi_d_Esys_PolicyCpHash_Finish
#endif

static uint32_t _cffi_d_Esys_PolicyDuplicationSelect(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_NAME const * x5, TPM2B_NAME const * x6, uint8_t x7)
{
  return Esys_PolicyDuplicationSelect(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyDuplicationSelect(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_NAME const * x5;
  TPM2B_NAME const * x6;
  uint8_t x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyDuplicationSelect", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(535), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_NAME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(535), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(535), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_NAME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(535), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x7 = _cffi_to_c_int(arg7, uint8_t);
  if (x7 == (uint8_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyDuplicationSelect(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyDuplicationSelect _cffi_d_Esys_PolicyDuplicationSelect
#endif

static uint32_t _cffi_d_Esys_PolicyDuplicationSelect_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_NAME const * x5, TPM2B_NAME const * x6, uint8_t x7)
{
  return Esys_PolicyDuplicationSelect_Async(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyDuplicationSelect_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_NAME const * x5;
  TPM2B_NAME const * x6;
  uint8_t x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyDuplicationSelect_Async", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(535), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_NAME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(535), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(535), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_NAME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(535), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x7 = _cffi_to_c_int(arg7, uint8_t);
  if (x7 == (uint8_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyDuplicationSelect_Async(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyDuplicationSelect_Async _cffi_d_Esys_PolicyDuplicationSelect_Async
#endif

static uint32_t _cffi_d_Esys_PolicyDuplicationSelect_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PolicyDuplicationSelect_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyDuplicationSelect_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyDuplicationSelect_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyDuplicationSelect_Finish _cffi_d_Esys_PolicyDuplicationSelect_Finish
#endif

static uint32_t _cffi_d_Esys_PolicyGetDigest(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST * * x5)
{
  return Esys_PolicyGetDigest(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyGetDigest(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST * * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyGetDigest", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyGetDigest(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyGetDigest _cffi_d_Esys_PolicyGetDigest
#endif

static uint32_t _cffi_d_Esys_PolicyGetDigest_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_PolicyGetDigest_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyGetDigest_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyGetDigest_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyGetDigest_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyGetDigest_Async _cffi_d_Esys_PolicyGetDigest_Async
#endif

static uint32_t _cffi_d_Esys_PolicyGetDigest_Finish(ESYS_CONTEXT * x0, TPM2B_DIGEST * * x1)
{
  return Esys_PolicyGetDigest_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyGetDigest_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_DIGEST * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyGetDigest_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyGetDigest_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyGetDigest_Finish _cffi_d_Esys_PolicyGetDigest_Finish
#endif

static uint32_t _cffi_d_Esys_PolicyLocality(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint8_t x5)
{
  return Esys_PolicyLocality(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyLocality(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint8_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyLocality", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint8_t);
  if (x5 == (uint8_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyLocality(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyLocality _cffi_d_Esys_PolicyLocality
#endif

static uint32_t _cffi_d_Esys_PolicyLocality_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint8_t x5)
{
  return Esys_PolicyLocality_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyLocality_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint8_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyLocality_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint8_t);
  if (x5 == (uint8_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyLocality_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyLocality_Async _cffi_d_Esys_PolicyLocality_Async
#endif

static uint32_t _cffi_d_Esys_PolicyLocality_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PolicyLocality_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyLocality_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyLocality_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyLocality_Finish _cffi_d_Esys_PolicyLocality_Finish
#endif

static uint32_t _cffi_d_Esys_PolicyNV(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint32_t x6, TPM2B_DIGEST const * x7, uint16_t x8, uint16_t x9)
{
  return Esys_PolicyNV(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyNV(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  TPM2B_DIGEST const * x7;
  uint16_t x8;
  uint16_t x9;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyNV", 10, 10, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x8 = _cffi_to_c_int(arg8, uint16_t);
  if (x8 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x9 = _cffi_to_c_int(arg9, uint16_t);
  if (x9 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyNV(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyNV _cffi_d_Esys_PolicyNV
#endif

static uint32_t _cffi_d_Esys_PolicyNV_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint32_t x6, TPM2B_DIGEST const * x7, uint16_t x8, uint16_t x9)
{
  return Esys_PolicyNV_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyNV_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  TPM2B_DIGEST const * x7;
  uint16_t x8;
  uint16_t x9;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyNV_Async", 10, 10, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x8 = _cffi_to_c_int(arg8, uint16_t);
  if (x8 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x9 = _cffi_to_c_int(arg9, uint16_t);
  if (x9 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyNV_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyNV_Async _cffi_d_Esys_PolicyNV_Async
#endif

static uint32_t _cffi_d_Esys_PolicyNV_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PolicyNV_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyNV_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyNV_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyNV_Finish _cffi_d_Esys_PolicyNV_Finish
#endif

static uint32_t _cffi_d_Esys_PolicyNameHash(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5)
{
  return Esys_PolicyNameHash(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyNameHash(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyNameHash", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyNameHash(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyNameHash _cffi_d_Esys_PolicyNameHash
#endif

static uint32_t _cffi_d_Esys_PolicyNameHash_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5)
{
  return Esys_PolicyNameHash_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyNameHash_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyNameHash_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyNameHash_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyNameHash_Async _cffi_d_Esys_PolicyNameHash_Async
#endif

static uint32_t _cffi_d_Esys_PolicyNameHash_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PolicyNameHash_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyNameHash_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyNameHash_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyNameHash_Finish _cffi_d_Esys_PolicyNameHash_Finish
#endif

static uint32_t _cffi_d_Esys_PolicyNvWritten(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint8_t x5)
{
  return Esys_PolicyNvWritten(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyNvWritten(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint8_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyNvWritten", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint8_t);
  if (x5 == (uint8_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyNvWritten(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyNvWritten _cffi_d_Esys_PolicyNvWritten
#endif

static uint32_t _cffi_d_Esys_PolicyNvWritten_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint8_t x5)
{
  return Esys_PolicyNvWritten_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyNvWritten_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint8_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyNvWritten_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint8_t);
  if (x5 == (uint8_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyNvWritten_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyNvWritten_Async _cffi_d_Esys_PolicyNvWritten_Async
#endif

static uint32_t _cffi_d_Esys_PolicyNvWritten_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PolicyNvWritten_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyNvWritten_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyNvWritten_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyNvWritten_Finish _cffi_d_Esys_PolicyNvWritten_Finish
#endif

static uint32_t _cffi_d_Esys_PolicyOR(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPML_DIGEST const * x5)
{
  return Esys_PolicyOR(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyOR(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPML_DIGEST const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyOR", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1002), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPML_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1002), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyOR(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyOR _cffi_d_Esys_PolicyOR
#endif

static uint32_t _cffi_d_Esys_PolicyOR_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPML_DIGEST const * x5)
{
  return Esys_PolicyOR_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyOR_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPML_DIGEST const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyOR_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1002), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPML_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1002), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyOR_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyOR_Async _cffi_d_Esys_PolicyOR_Async
#endif

static uint32_t _cffi_d_Esys_PolicyOR_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PolicyOR_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyOR_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyOR_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyOR_Finish _cffi_d_Esys_PolicyOR_Finish
#endif

static uint32_t _cffi_d_Esys_PolicyPCR(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5, TPML_PCR_SELECTION const * x6)
{
  return Esys_PolicyPCR(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyPCR(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  TPML_PCR_SELECTION const * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyPCR", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(398), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPML_PCR_SELECTION const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(398), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyPCR(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyPCR _cffi_d_Esys_PolicyPCR
#endif

static uint32_t _cffi_d_Esys_PolicyPCR_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5, TPML_PCR_SELECTION const * x6)
{
  return Esys_PolicyPCR_Async(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyPCR_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  TPML_PCR_SELECTION const * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyPCR_Async", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(398), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPML_PCR_SELECTION const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(398), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyPCR_Async(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyPCR_Async _cffi_d_Esys_PolicyPCR_Async
#endif

static uint32_t _cffi_d_Esys_PolicyPCR_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PolicyPCR_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyPCR_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyPCR_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyPCR_Finish _cffi_d_Esys_PolicyPCR_Finish
#endif

static uint32_t _cffi_d_Esys_PolicyPassword(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_PolicyPassword(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyPassword(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyPassword", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyPassword(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyPassword _cffi_d_Esys_PolicyPassword
#endif

static uint32_t _cffi_d_Esys_PolicyPassword_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_PolicyPassword_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyPassword_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyPassword_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyPassword_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyPassword_Async _cffi_d_Esys_PolicyPassword_Async
#endif

static uint32_t _cffi_d_Esys_PolicyPassword_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PolicyPassword_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyPassword_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyPassword_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyPassword_Finish _cffi_d_Esys_PolicyPassword_Finish
#endif

static uint32_t _cffi_d_Esys_PolicyPhysicalPresence(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_PolicyPhysicalPresence(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyPhysicalPresence(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyPhysicalPresence", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyPhysicalPresence(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyPhysicalPresence _cffi_d_Esys_PolicyPhysicalPresence
#endif

static uint32_t _cffi_d_Esys_PolicyPhysicalPresence_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_PolicyPhysicalPresence_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyPhysicalPresence_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyPhysicalPresence_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyPhysicalPresence_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyPhysicalPresence_Async _cffi_d_Esys_PolicyPhysicalPresence_Async
#endif

static uint32_t _cffi_d_Esys_PolicyPhysicalPresence_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PolicyPhysicalPresence_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyPhysicalPresence_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyPhysicalPresence_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyPhysicalPresence_Finish _cffi_d_Esys_PolicyPhysicalPresence_Finish
#endif

static uint32_t _cffi_d_Esys_PolicyRestart(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_PolicyRestart(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyRestart(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyRestart", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyRestart(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyRestart _cffi_d_Esys_PolicyRestart
#endif

static uint32_t _cffi_d_Esys_PolicyRestart_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_PolicyRestart_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyRestart_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyRestart_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyRestart_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyRestart_Async _cffi_d_Esys_PolicyRestart_Async
#endif

static uint32_t _cffi_d_Esys_PolicyRestart_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PolicyRestart_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyRestart_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyRestart_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyRestart_Finish _cffi_d_Esys_PolicyRestart_Finish
#endif

static uint32_t _cffi_d_Esys_PolicySecret(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_DIGEST const * x6, TPM2B_DIGEST const * x7, TPM2B_DIGEST const * x8, int32_t x9, TPM2B_DIGEST * * x10, TPMT_TK_AUTH * * x11)
{
  return Esys_PolicySecret(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicySecret(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_DIGEST const * x6;
  TPM2B_DIGEST const * x7;
  TPM2B_DIGEST const * x8;
  int32_t x9;
  TPM2B_DIGEST * * x10;
  TPMT_TK_AUTH * * x11;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;
  PyObject *arg11;

  if (!PyArg_UnpackTuple(args, "Esys_PolicySecret", 12, 12, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10, &arg11))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x9 = _cffi_to_c_int(arg9, int32_t);
  if (x9 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg10, (char **)&x10);
  if (datasize != 0) {
    x10 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg10, (char **)&x10,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg11, (char **)&x11);
  if (datasize != 0) {
    x11 = ((size_t)datasize) <= 640 ? (TPMT_TK_AUTH * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg11, (char **)&x11,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicySecret(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicySecret _cffi_d_Esys_PolicySecret
#endif

static uint32_t _cffi_d_Esys_PolicySecret_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_DIGEST const * x6, TPM2B_DIGEST const * x7, TPM2B_DIGEST const * x8, int32_t x9)
{
  return Esys_PolicySecret_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicySecret_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_DIGEST const * x6;
  TPM2B_DIGEST const * x7;
  TPM2B_DIGEST const * x8;
  int32_t x9;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;

  if (!PyArg_UnpackTuple(args, "Esys_PolicySecret_Async", 10, 10, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x9 = _cffi_to_c_int(arg9, int32_t);
  if (x9 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicySecret_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicySecret_Async _cffi_d_Esys_PolicySecret_Async
#endif

static uint32_t _cffi_d_Esys_PolicySecret_Finish(ESYS_CONTEXT * x0, TPM2B_DIGEST * * x1, TPMT_TK_AUTH * * x2)
{
  return Esys_PolicySecret_Finish(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicySecret_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_DIGEST * * x1;
  TPMT_TK_AUTH * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_PolicySecret_Finish", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPMT_TK_AUTH * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicySecret_Finish(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicySecret_Finish _cffi_d_Esys_PolicySecret_Finish
#endif

static uint32_t _cffi_d_Esys_PolicySigned(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_DIGEST const * x6, TPM2B_DIGEST const * x7, TPM2B_DIGEST const * x8, int32_t x9, TPMT_SIGNATURE const * x10, TPM2B_DIGEST * * x11, TPMT_TK_AUTH * * x12)
{
  return Esys_PolicySigned(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicySigned(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_DIGEST const * x6;
  TPM2B_DIGEST const * x7;
  TPM2B_DIGEST const * x8;
  int32_t x9;
  TPMT_SIGNATURE const * x10;
  TPM2B_DIGEST * * x11;
  TPMT_TK_AUTH * * x12;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;
  PyObject *arg11;
  PyObject *arg12;

  if (!PyArg_UnpackTuple(args, "Esys_PolicySigned", 13, 13, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10, &arg11, &arg12))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x9 = _cffi_to_c_int(arg9, int32_t);
  if (x9 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(604), arg10, (char **)&x10);
  if (datasize != 0) {
    x10 = ((size_t)datasize) <= 640 ? (TPMT_SIGNATURE const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(604), arg10, (char **)&x10,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg11, (char **)&x11);
  if (datasize != 0) {
    x11 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg11, (char **)&x11,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg12, (char **)&x12);
  if (datasize != 0) {
    x12 = ((size_t)datasize) <= 640 ? (TPMT_TK_AUTH * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg12, (char **)&x12,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicySigned(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicySigned _cffi_d_Esys_PolicySigned
#endif

static uint32_t _cffi_d_Esys_PolicySigned_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_DIGEST const * x6, TPM2B_DIGEST const * x7, TPM2B_DIGEST const * x8, int32_t x9, TPMT_SIGNATURE const * x10)
{
  return Esys_PolicySigned_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicySigned_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_DIGEST const * x6;
  TPM2B_DIGEST const * x7;
  TPM2B_DIGEST const * x8;
  int32_t x9;
  TPMT_SIGNATURE const * x10;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;

  if (!PyArg_UnpackTuple(args, "Esys_PolicySigned_Async", 11, 11, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x9 = _cffi_to_c_int(arg9, int32_t);
  if (x9 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(604), arg10, (char **)&x10);
  if (datasize != 0) {
    x10 = ((size_t)datasize) <= 640 ? (TPMT_SIGNATURE const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(604), arg10, (char **)&x10,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicySigned_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicySigned_Async _cffi_d_Esys_PolicySigned_Async
#endif

static uint32_t _cffi_d_Esys_PolicySigned_Finish(ESYS_CONTEXT * x0, TPM2B_DIGEST * * x1, TPMT_TK_AUTH * * x2)
{
  return Esys_PolicySigned_Finish(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicySigned_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_DIGEST * * x1;
  TPMT_TK_AUTH * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_PolicySigned_Finish", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPMT_TK_AUTH * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicySigned_Finish(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicySigned_Finish _cffi_d_Esys_PolicySigned_Finish
#endif

static uint32_t _cffi_d_Esys_PolicyTemplate(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5)
{
  return Esys_PolicyTemplate(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyTemplate(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyTemplate", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyTemplate(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyTemplate _cffi_d_Esys_PolicyTemplate
#endif

static uint32_t _cffi_d_Esys_PolicyTemplate_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5)
{
  return Esys_PolicyTemplate_Async(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyTemplate_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyTemplate_Async", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyTemplate_Async(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyTemplate_Async _cffi_d_Esys_PolicyTemplate_Async
#endif

static uint32_t _cffi_d_Esys_PolicyTemplate_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PolicyTemplate_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyTemplate_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyTemplate_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyTemplate_Finish _cffi_d_Esys_PolicyTemplate_Finish
#endif

static uint32_t _cffi_d_Esys_PolicyTicket(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5, TPM2B_DIGEST const * x6, TPM2B_DIGEST const * x7, TPM2B_NAME const * x8, TPMT_TK_AUTH const * x9)
{
  return Esys_PolicyTicket(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyTicket(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  TPM2B_DIGEST const * x6;
  TPM2B_DIGEST const * x7;
  TPM2B_NAME const * x8;
  TPMT_TK_AUTH const * x9;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyTicket", 10, 10, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(535), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_NAME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(535), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(536), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (TPMT_TK_AUTH const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(536), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyTicket(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyTicket _cffi_d_Esys_PolicyTicket
#endif

static uint32_t _cffi_d_Esys_PolicyTicket_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DIGEST const * x5, TPM2B_DIGEST const * x6, TPM2B_DIGEST const * x7, TPM2B_NAME const * x8, TPMT_TK_AUTH const * x9)
{
  return Esys_PolicyTicket_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyTicket_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DIGEST const * x5;
  TPM2B_DIGEST const * x6;
  TPM2B_DIGEST const * x7;
  TPM2B_NAME const * x8;
  TPMT_TK_AUTH const * x9;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;

  if (!PyArg_UnpackTuple(args, "Esys_PolicyTicket_Async", 10, 10, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DIGEST const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(535), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_NAME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(535), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(536), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (TPMT_TK_AUTH const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(536), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyTicket_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyTicket_Async _cffi_d_Esys_PolicyTicket_Async
#endif

static uint32_t _cffi_d_Esys_PolicyTicket_Finish(ESYS_CONTEXT * x0)
{
  return Esys_PolicyTicket_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_PolicyTicket_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_PolicyTicket_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_PolicyTicket_Finish _cffi_d_Esys_PolicyTicket_Finish
#endif

static uint32_t _cffi_d_Esys_Policy_AC_SendSelect(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, TPM2B_NAME * x4, TPM2B_NAME * x5, TPM2B_NAME * x6, uint8_t x7)
{
  return Esys_Policy_AC_SendSelect(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Policy_AC_SendSelect(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  TPM2B_NAME * x4;
  TPM2B_NAME * x5;
  TPM2B_NAME * x6;
  uint8_t x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_Policy_AC_SendSelect", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(347), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (TPM2B_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(347), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(347), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(347), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(347), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(347), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x7 = _cffi_to_c_int(arg7, uint8_t);
  if (x7 == (uint8_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Policy_AC_SendSelect(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Policy_AC_SendSelect _cffi_d_Esys_Policy_AC_SendSelect
#endif

static uint32_t _cffi_d_Esys_Policy_AC_SendSelect_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, TPM2B_NAME * x4, TPM2B_NAME * x5, TPM2B_NAME * x6, uint8_t x7)
{
  return Esys_Policy_AC_SendSelect_Async(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Policy_AC_SendSelect_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  TPM2B_NAME * x4;
  TPM2B_NAME * x5;
  TPM2B_NAME * x6;
  uint8_t x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_Policy_AC_SendSelect_Async", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(347), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (TPM2B_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(347), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(347), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(347), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(347), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(347), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x7 = _cffi_to_c_int(arg7, uint8_t);
  if (x7 == (uint8_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Policy_AC_SendSelect_Async(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Policy_AC_SendSelect_Async _cffi_d_Esys_Policy_AC_SendSelect_Async
#endif

static uint32_t _cffi_d_Esys_Policy_AC_SendSelect_Finish(ESYS_CONTEXT * x0)
{
  return Esys_Policy_AC_SendSelect_Finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Policy_AC_SendSelect_Finish(PyObject *self, PyObject *arg0)
{
  ESYS_CONTEXT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Policy_AC_SendSelect_Finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Policy_AC_SendSelect_Finish _cffi_d_Esys_Policy_AC_SendSelect_Finish
#endif

static uint32_t _cffi_d_Esys_Quote(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DATA const * x5, TPMT_SIG_SCHEME const * x6, TPML_PCR_SELECTION const * x7, TPM2B_ATTEST * * x8, TPMT_SIGNATURE * * x9)
{
  return Esys_Quote(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Quote(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DATA const * x5;
  TPMT_SIG_SCHEME const * x6;
  TPML_PCR_SELECTION const * x7;
  TPM2B_ATTEST * * x8;
  TPMT_SIGNATURE * * x9;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;

  if (!PyArg_UnpackTuple(args, "Esys_Quote", 10, 10, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(495), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPMT_SIG_SCHEME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(495), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(398), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPML_PCR_SELECTION const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(398), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_ATTEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (TPMT_SIGNATURE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Quote(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Quote _cffi_d_Esys_Quote
#endif

static uint32_t _cffi_d_Esys_Quote_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_DATA const * x5, TPMT_SIG_SCHEME const * x6, TPML_PCR_SELECTION const * x7)
{
  return Esys_Quote_Async(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Quote_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_DATA const * x5;
  TPMT_SIG_SCHEME const * x6;
  TPML_PCR_SELECTION const * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_Quote_Async", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(495), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPMT_SIG_SCHEME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(495), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(398), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPML_PCR_SELECTION const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(398), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Quote_Async(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Quote_Async _cffi_d_Esys_Quote_Async
#endif

static uint32_t _cffi_d_Esys_Quote_Finish(ESYS_CONTEXT * x0, TPM2B_ATTEST * * x1, TPMT_SIGNATURE * * x2)
{
  return Esys_Quote_Finish(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Quote_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_ATTEST * * x1;
  TPMT_SIGNATURE * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_Quote_Finish", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_ATTEST * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPMT_SIGNATURE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Quote_Finish(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Quote_Finish _cffi_d_Esys_Quote_Finish
#endif

static uint32_t _cffi_d_Esys_RSA_Decrypt(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_PUBLIC_KEY_RSA const * x5, TPMT_RSA_DECRYPT const * x6, TPM2B_DATA const * x7, TPM2B_PUBLIC_KEY_RSA * * x8)
{
  return Esys_RSA_Decrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_RSA_Decrypt(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_PUBLIC_KEY_RSA const * x5;
  TPMT_RSA_DECRYPT const * x6;
  TPM2B_DATA const * x7;
  TPM2B_PUBLIC_KEY_RSA * * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "Esys_RSA_Decrypt", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(900), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC_KEY_RSA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(900), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(901), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPMT_RSA_DECRYPT const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(901), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(134), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC_KEY_RSA * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(134), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_RSA_Decrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_RSA_Decrypt _cffi_d_Esys_RSA_Decrypt
#endif

static uint32_t _cffi_d_Esys_RSA_Decrypt_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_PUBLIC_KEY_RSA const * x5, TPMT_RSA_DECRYPT const * x6, TPM2B_DATA const * x7)
{
  return Esys_RSA_Decrypt_Async(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_RSA_Decrypt_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_PUBLIC_KEY_RSA const * x5;
  TPMT_RSA_DECRYPT const * x6;
  TPM2B_DATA const * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_RSA_Decrypt_Async", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(900), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC_KEY_RSA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(900), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(901), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPMT_RSA_DECRYPT const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(901), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_RSA_Decrypt_Async(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_RSA_Decrypt_Async _cffi_d_Esys_RSA_Decrypt_Async
#endif

static uint32_t _cffi_d_Esys_RSA_Decrypt_Finish(ESYS_CONTEXT * x0, TPM2B_PUBLIC_KEY_RSA * * x1)
{
  return Esys_RSA_Decrypt_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_RSA_Decrypt_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_PUBLIC_KEY_RSA * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_RSA_Decrypt_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(134), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC_KEY_RSA * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(134), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_RSA_Decrypt_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_RSA_Decrypt_Finish _cffi_d_Esys_RSA_Decrypt_Finish
#endif

static uint32_t _cffi_d_Esys_RSA_Encrypt(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_PUBLIC_KEY_RSA const * x5, TPMT_RSA_DECRYPT const * x6, TPM2B_DATA const * x7, TPM2B_PUBLIC_KEY_RSA * * x8)
{
  return Esys_RSA_Encrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_RSA_Encrypt(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_PUBLIC_KEY_RSA const * x5;
  TPMT_RSA_DECRYPT const * x6;
  TPM2B_DATA const * x7;
  TPM2B_PUBLIC_KEY_RSA * * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "Esys_RSA_Encrypt", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(900), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC_KEY_RSA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(900), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(901), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPMT_RSA_DECRYPT const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(901), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(134), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC_KEY_RSA * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(134), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_RSA_Encrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_RSA_Encrypt _cffi_d_Esys_RSA_Encrypt
#endif

static uint32_t _cffi_d_Esys_RSA_Encrypt_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_PUBLIC_KEY_RSA const * x5, TPMT_RSA_DECRYPT const * x6, TPM2B_DATA const * x7)
{
  return Esys_RSA_Encrypt_Async(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_RSA_Encrypt_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_PUBLIC_KEY_RSA const * x5;
  TPMT_RSA_DECRYPT const * x6;
  TPM2B_DATA const * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_RSA_Encrypt_Async", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(900), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC_KEY_RSA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(900), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(901), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPMT_RSA_DECRYPT const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(901), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_DATA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_RSA_Encrypt_Async(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_RSA_Encrypt_Async _cffi_d_Esys_RSA_Encrypt_Async
#endif

static uint32_t _cffi_d_Esys_RSA_Encrypt_Finish(ESYS_CONTEXT * x0, TPM2B_PUBLIC_KEY_RSA * * x1)
{
  return Esys_RSA_Encrypt_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_RSA_Encrypt_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_PUBLIC_KEY_RSA * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_RSA_Encrypt_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(134), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC_KEY_RSA * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(134), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_RSA_Encrypt_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_RSA_Encrypt_Finish _cffi_d_Esys_RSA_Encrypt_Finish
#endif

static uint32_t _cffi_d_Esys_ReadClock(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, TPMS_TIME_INFO * * x4)
{
  return Esys_ReadClock(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ReadClock(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  TPMS_TIME_INFO * * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_ReadClock", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(171), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (TPMS_TIME_INFO * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(171), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ReadClock(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ReadClock _cffi_d_Esys_ReadClock
#endif

static uint32_t _cffi_d_Esys_ReadClock_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3)
{
  return Esys_ReadClock_Async(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ReadClock_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "Esys_ReadClock_Async", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ReadClock_Async(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ReadClock_Async _cffi_d_Esys_ReadClock_Async
#endif

static uint32_t _cffi_d_Esys_ReadClock_Finish(ESYS_CONTEXT * x0, TPMS_TIME_INFO * * x1)
{
  return Esys_ReadClock_Finish(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ReadClock_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPMS_TIME_INFO * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Esys_ReadClock_Finish", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(171), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPMS_TIME_INFO * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(171), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ReadClock_Finish(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ReadClock_Finish _cffi_d_Esys_ReadClock_Finish
#endif

static uint32_t _cffi_d_Esys_ReadPublic(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, TPM2B_PUBLIC * * x5, TPM2B_NAME * * x6, TPM2B_NAME * * x7)
{
  return Esys_ReadPublic(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ReadPublic(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  TPM2B_PUBLIC * * x5;
  TPM2B_NAME * * x6;
  TPM2B_NAME * * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "Esys_ReadPublic", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_NAME * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_NAME * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ReadPublic(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ReadPublic _cffi_d_Esys_ReadPublic
#endif

static uint32_t _cffi_d_Esys_ReadPublic_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  return Esys_ReadPublic_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ReadPublic_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_ReadPublic_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ReadPublic_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ReadPublic_Async _cffi_d_Esys_ReadPublic_Async
#endif

static uint32_t _cffi_d_Esys_ReadPublic_Finish(ESYS_CONTEXT * x0, TPM2B_PUBLIC * * x1, TPM2B_NAME * * x2, TPM2B_NAME * * x3)
{
  return Esys_ReadPublic_Finish(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_ReadPublic_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_PUBLIC * * x1;
  TPM2B_NAME * * x2;
  TPM2B_NAME * * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "Esys_ReadPublic_Finish", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_PUBLIC * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPM2B_NAME * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (TPM2B_NAME * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_ReadPublic_Finish(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_ReadPublic_Finish _cffi_d_Esys_ReadPublic_Finish
#endif

static uint32_t _cffi_d_Esys_Rewrap(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_PRIVATE const * x6, TPM2B_NAME const * x7, TPM2B_ENCRYPTED_SECRET const * x8, TPM2B_PRIVATE * * x9, TPM2B_ENCRYPTED_SECRET * * x10)
{
  return Esys_Rewrap(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Rewrap(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_PRIVATE const * x6;
  TPM2B_NAME const * x7;
  TPM2B_ENCRYPTED_SECRET const * x8;
  TPM2B_PRIVATE * * x9;
  TPM2B_ENCRYPTED_SECRET * * x10;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;

  if (!PyArg_UnpackTuple(args, "Esys_Rewrap", 11, 11, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(471), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_PRIVATE const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(471), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(535), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_NAME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(535), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(472), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_ENCRYPTED_SECRET const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(472), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (TPM2B_PRIVATE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg10, (char **)&x10);
  if (datasize != 0) {
    x10 = ((size_t)datasize) <= 640 ? (TPM2B_ENCRYPTED_SECRET * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg10, (char **)&x10,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Rewrap(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Rewrap _cffi_d_Esys_Rewrap
#endif

static uint32_t _cffi_d_Esys_Rewrap_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, TPM2B_PRIVATE const * x6, TPM2B_NAME const * x7, TPM2B_ENCRYPTED_SECRET const * x8)
{
  return Esys_Rewrap_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Rewrap_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  TPM2B_PRIVATE const * x6;
  TPM2B_NAME const * x7;
  TPM2B_ENCRYPTED_SECRET const * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "Esys_Rewrap_Async", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(471), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (TPM2B_PRIVATE const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(471), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(535), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (TPM2B_NAME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(535), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(472), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (TPM2B_ENCRYPTED_SECRET const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(472), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Rewrap_Async(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Rewrap_Async _cffi_d_Esys_Rewrap_Async
#endif

static uint32_t _cffi_d_Esys_Rewrap_Finish(ESYS_CONTEXT * x0, TPM2B_PRIVATE * * x1, TPM2B_ENCRYPTED_SECRET * * x2)
{
  return Esys_Rewrap_Finish(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_Rewrap_Finish(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  TPM2B_PRIVATE * * x1;
  TPM2B_ENCRYPTED_SECRET * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Esys_Rewrap_Finish", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (TPM2B_PRIVATE * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (TPM2B_ENCRYPTED_SECRET * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_Rewrap_Finish(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_Rewrap_Finish _cffi_d_Esys_Rewrap_Finish
#endif

static uint32_t _cffi_d_Esys_SelfTest(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint8_t x4)
{
  return Esys_SelfTest(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_SelfTest(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint8_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_SelfTest", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint8_t);
  if (x4 == (uint8_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_SelfTest(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Esys_SelfTest _cffi_d_Esys_SelfTest
#endif

static uint32_t _cffi_d_Esys_SelfTest_Async(ESYS_CONTEXT * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint8_t x4)
{
  return Esys_SelfTest_Async(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Esys_SelfTest_Async(PyObject *self, PyObject *args)
{
  ESYS_CONTEXT * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint8_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Esys_SelfTest_Async", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ESYS_CONTEXT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint8_t);
  if (x4 == (uint8_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Esys_SelfTest_Async(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(lar