
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "cutterbindings_python.h"

// main header
#include "basicinstructionhighlighter_wrapper.h"

// Argument includes
#include <qcolor.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_BasicInstructionHighlighter_Type = nullptr;
static PyTypeObject *Sbk_BasicInstructionHighlighter_TypeF(void)
{
    return _Sbk_BasicInstructionHighlighter_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_BasicInstructionHighlighter_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::BasicInstructionHighlighter >()))
        return -1;

    ::BasicInstructionHighlighter *cptr{};
    Shiboken::PythonContextMarker pcm;


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkCutterBindingsTypeStructs[SBK_BasicInstructionHighlighter_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {

        // BasicInstructionHighlighter()
        cptr = new ::BasicInstructionHighlighter();
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::BasicInstructionHighlighter >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_BasicInstructionHighlighterFunc_clear(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::BasicInstructionHighlighter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_BasicInstructionHighlighter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "clear", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: BasicInstructionHighlighter::clear(qulonglong,qulonglong)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[1])))) {
        overloadId = 0; // clear(qulonglong,qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "clear", errInfo, SbkCutterBindingsTypeStructs[SBK_BasicInstructionHighlighter_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned long long cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // clear(qulonglong,qulonglong)
            cppSelf->clear(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_BasicInstructionHighlighterFunc_highlight(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::BasicInstructionHighlighter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_BasicInstructionHighlighter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "highlight", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: BasicInstructionHighlighter::highlight(qulonglong,qulonglong,QColor)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArgs[2])))) {
        overloadId = 0; // highlight(qulonglong,qulonglong,QColor)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "highlight", errInfo, SbkCutterBindingsTypeStructs[SBK_BasicInstructionHighlighter_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned long long cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QColor cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // highlight(qulonglong,qulonglong,QColor)
            cppSelf->highlight(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_BasicInstructionHighlighter_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_BasicInstructionHighlighter_methods[] = {
    {"clear", reinterpret_cast<PyCFunction>(Sbk_BasicInstructionHighlighterFunc_clear), METH_VARARGS, nullptr},
    {"highlight", reinterpret_cast<PyCFunction>(Sbk_BasicInstructionHighlighterFunc_highlight), METH_VARARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_BasicInstructionHighlighter_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_BasicInstructionHighlighter_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_BasicInstructionHighlighter_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_BasicInstructionHighlighter_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_BasicInstructionHighlighter_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_BasicInstructionHighlighter_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_BasicInstructionHighlighter_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_BasicInstructionHighlighter_spec = {
    "1:CutterBindings.BasicInstructionHighlighter",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_BasicInstructionHighlighter_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void BasicInstructionHighlighter_PythonToCpp_BasicInstructionHighlighter_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_BasicInstructionHighlighter_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_BasicInstructionHighlighter_PythonToCpp_BasicInstructionHighlighter_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_BasicInstructionHighlighter_TypeF()))
        return BasicInstructionHighlighter_PythonToCpp_BasicInstructionHighlighter_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *BasicInstructionHighlighter_PTR_CppToPython_BasicInstructionHighlighter(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_BasicInstructionHighlighter_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_BasicInstructionHighlighter_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *BasicInstructionHighlighter_SignatureStrings[] = {
    "CutterBindings.BasicInstructionHighlighter(self)",
    "CutterBindings.BasicInstructionHighlighter.clear(self,address:unsigned long long,size:unsigned long long)",
    "CutterBindings.BasicInstructionHighlighter.highlight(self,address:unsigned long long,size:unsigned long long,color:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int])",
    nullptr}; // Sentinel
#else
static constexpr size_t BasicInstructionHighlighter_SignatureByteSize = 188;
static constexpr uint8_t BasicInstructionHighlighter_SignatureBytes[188] = {
    0x78, 0xda, 0x9d, 0x8e, 0x3f, 0x0b, 0xc2, 0x30, 0x10, 0xc5, 0xf7, 0x7e, 0x8a, 0x8e, 0x16, 0x42,
    0x40, 0x90, 0x0e, 0x1d, 0xdb, 0xa1, 0x0a, 0x0e, 0xd6, 0xa2, 0x8b, 0x38, 0xa4, 0x4d, 0x4c, 0x0f,
    0xc2, 0x45, 0x92, 0xcb, 0x50, 0x3f, 0xbd, 0x51, 0xa9, 0x88, 0x38, 0xa8, 0xc3, 0xfd, 0xe1, 0xf8,
    0xbd, 0xf7, 0xae, 0x0a, 0x44, 0xca, 0x95, 0x80, 0x12, 0x50, 0x7b, 0x5e, 0x0a, 0x0f, 0xfd, 0x0a,
    0x3d, 0xb9, 0xd0, 0x13, 0x58, 0x5c, 0x82, 0x1e, 0x4c, 0xac, 0xc8, 0xcc, 0xbc, 0x32, 0xa7, 0x2c,
    0xa9, 0xbe, 0x16, 0xf0, 0xde, 0x28, 0xf1, 0x90, 0x31, 0x21, 0xa5, 0x53, 0xde, 0x17, 0x01, 0x3d,
    0x68, 0x54, 0x32, 0x35, 0x16, 0xf5, 0xbd, 0x31, 0x0f, 0x17, 0xf5, 0xe1, 0xfe, 0x53, 0xd2, 0x30,
    0xed, 0xff, 0xa6, 0xb1, 0xde, 0x1a, 0xeb, 0x0a, 0x1a, 0xcf, 0x31, 0x8b, 0xef, 0x30, 0xfa, 0x1f,
    0x36, 0x63, 0x0b, 0x52, 0xe5, 0xbc, 0xa1, 0x3a, 0x00, 0x6f, 0xaa, 0x1b, 0xc1, 0xd2, 0x66, 0x2d,
    0x08, 0x70, 0xde, 0x92, 0x8b, 0x24, 0x4b, 0xdf, 0xa0, 0xad, 0xee, 0x44, 0xbe, 0x88, 0xd4, 0x5e,
    0x38, 0x10, 0x48, 0xaf, 0x40, 0x65, 0x9d, 0x8a, 0x83, 0xd7, 0xc6, 0x76, 0xc2, 0x4c, 0x76, 0x93,
    0xd1, 0xf3, 0x27, 0x40, 0x3a, 0x66, 0xc9, 0x15, 0x11, 0x91, 0x97, 0x55
};
#endif

PyTypeObject *init_BasicInstructionHighlighter(PyObject *module)
{
    if (SbkCutterBindingsTypeStructs[SBK_BasicInstructionHighlighter_IDX].type != nullptr)
        return SbkCutterBindingsTypeStructs[SBK_BasicInstructionHighlighter_IDX].type;

    Shiboken::AutoDecRef Sbk_BasicInstructionHighlighter_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_BasicInstructionHighlighter_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "BasicInstructionHighlighter",
        "BasicInstructionHighlighter*",
        &Sbk_BasicInstructionHighlighter_spec,
        &Shiboken::callCppDestructor< ::BasicInstructionHighlighter >,
        Sbk_BasicInstructionHighlighter_Type_bases.object(),
        0);
    auto *pyType = _Sbk_BasicInstructionHighlighter_Type; // references _Sbk_BasicInstructionHighlighter_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, BasicInstructionHighlighter_SignatureStrings);
#else
    InitSignatureBytes(pyType, BasicInstructionHighlighter_SignatureBytes, BasicInstructionHighlighter_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_BasicInstructionHighlighter_PropertyStrings);
    SbkCutterBindingsTypeStructs[SBK_BasicInstructionHighlighter_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        BasicInstructionHighlighter_PythonToCpp_BasicInstructionHighlighter_PTR,
        is_BasicInstructionHighlighter_PythonToCpp_BasicInstructionHighlighter_PTR_Convertible,
        BasicInstructionHighlighter_PTR_CppToPython_BasicInstructionHighlighter);

    Shiboken::Conversions::registerConverterName(converter, "BasicInstructionHighlighter");
    Shiboken::Conversions::registerConverterName(converter, "BasicInstructionHighlighter*");
    Shiboken::Conversions::registerConverterName(converter, "BasicInstructionHighlighter&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::BasicInstructionHighlighter).name());

    qRegisterMetaType< ::BasicInstructionHighlighter *>();

    return pyType;
}
