/* FileManager.c generated by valac 0.56.18, the Vala compiler
 * generated from FileManager.vala, do not modify */

/*
* Copyright (c) 2016 Felipe Escoto (https://github.com/Philip-Scott/Spice-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <granite.h>
#include <cairo-gobject.h>
#include <json-glib/json-glib.h>
#include <float.h>
#include <math.h>
#include <cairo-pdf.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>

#define SPICE_SERVICES_FILE_MANAGER_FILE_EXTENSION ".spice"
#define SPICE_SERVICES_FILE_MANAGER_RESOURCE_PATH "resource:///com/github/philip-scott/spice-up/%s"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SPICE_SERVICES_TYPE_FILE_MANAGER (spice_services_file_manager_get_type ())
#define SPICE_SERVICES_FILE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_SERVICES_TYPE_FILE_MANAGER, SpiceServicesFileManager))
#define SPICE_SERVICES_FILE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_SERVICES_TYPE_FILE_MANAGER, SpiceServicesFileManagerClass))
#define SPICE_SERVICES_IS_FILE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_SERVICES_TYPE_FILE_MANAGER))
#define SPICE_SERVICES_IS_FILE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_SERVICES_TYPE_FILE_MANAGER))
#define SPICE_SERVICES_FILE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_SERVICES_TYPE_FILE_MANAGER, SpiceServicesFileManagerClass))

typedef struct _SpiceServicesFileManager SpiceServicesFileManager;
typedef struct _SpiceServicesFileManagerClass SpiceServicesFileManagerClass;
typedef struct _SpiceServicesFileManagerPrivate SpiceServicesFileManagerPrivate;
typedef struct _Block3Data Block3Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SPICE_TYPE_WINDOW (spice_window_get_type ())
#define SPICE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_WINDOW, SpiceWindow))
#define SPICE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_WINDOW, SpiceWindowClass))
#define SPICE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_WINDOW))
#define SPICE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_WINDOW))
#define SPICE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_WINDOW, SpiceWindowClass))

typedef struct _SpiceWindow SpiceWindow;
typedef struct _SpiceWindowClass SpiceWindowClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define SPICE_SERVICES_TYPE_SETTINGS (spice_services_settings_get_type ())
#define SPICE_SERVICES_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_SERVICES_TYPE_SETTINGS, SpiceServicesSettings))
#define SPICE_SERVICES_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_SERVICES_TYPE_SETTINGS, SpiceServicesSettingsClass))
#define SPICE_SERVICES_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_SERVICES_TYPE_SETTINGS))
#define SPICE_SERVICES_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_SERVICES_TYPE_SETTINGS))
#define SPICE_SERVICES_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_SERVICES_TYPE_SETTINGS, SpiceServicesSettingsClass))

typedef struct _SpiceServicesSettings SpiceServicesSettings;
typedef struct _SpiceServicesSettingsClass SpiceServicesSettingsClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SPICE_TYPE_SLIDE_MANAGER (spice_slide_manager_get_type ())
#define SPICE_SLIDE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManager))
#define SPICE_SLIDE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManagerClass))
#define SPICE_IS_SLIDE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_SLIDE_MANAGER))
#define SPICE_IS_SLIDE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_SLIDE_MANAGER))
#define SPICE_SLIDE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManagerClass))

typedef struct _SpiceSlideManager SpiceSlideManager;
typedef struct _SpiceSlideManagerClass SpiceSlideManagerClass;
typedef struct _Block4Data Block4Data;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define SPICE_TYPE_CANVAS (spice_canvas_get_type ())
#define SPICE_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS, SpiceCanvas))
#define SPICE_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS, SpiceCanvasClass))
#define SPICE_IS_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS))
#define SPICE_IS_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS))
#define SPICE_CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS, SpiceCanvasClass))

typedef struct _SpiceCanvas SpiceCanvas;
typedef struct _SpiceCanvasClass SpiceCanvasClass;

#define SPICE_TYPE_SLIDE (spice_slide_get_type ())
#define SPICE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_SLIDE, SpiceSlide))
#define SPICE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_SLIDE, SpiceSlideClass))
#define SPICE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_SLIDE))
#define SPICE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_SLIDE))
#define SPICE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_SLIDE, SpiceSlideClass))

typedef struct _SpiceSlide SpiceSlide;
typedef struct _SpiceSlideClass SpiceSlideClass;
typedef struct _SpiceSlidePrivate SpiceSlidePrivate;
typedef struct _Block5Data Block5Data;
typedef struct _SpiceCanvasPrivate SpiceCanvasPrivate;

#define SPICE_CANVAS_TYPE_CANVAS_GRID (spice_canvas_canvas_grid_get_type ())
#define SPICE_CANVAS_CANVAS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGrid))
#define SPICE_CANVAS_CANVAS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGridClass))
#define SPICE_CANVAS_IS_CANVAS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_CANVAS_TYPE_CANVAS_GRID))
#define SPICE_CANVAS_IS_CANVAS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_CANVAS_TYPE_CANVAS_GRID))
#define SPICE_CANVAS_CANVAS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGridClass))

typedef struct _SpiceCanvasCanvasGrid SpiceCanvasCanvasGrid;
typedef struct _SpiceCanvasCanvasGridClass SpiceCanvasCanvasGridClass;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _SpiceServicesParamSpecFileManager SpiceServicesParamSpecFileManager;

struct _SpiceServicesFileManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SpiceServicesFileManagerPrivate * priv;
};

struct _SpiceServicesFileManagerClass {
	GTypeClass parent_class;
	void (*finalize) (SpiceServicesFileManager *self);
};

struct _Block3Data {
	int _ref_count_;
	GtkFileChooserNative* dialog;
};

struct _Block4Data {
	int _ref_count_;
	cairo_surface_t* pdf;
	SpiceSlideManager* manager;
};

struct _SpiceSlide {
	GObject parent_instance;
	SpiceSlidePrivate * priv;
	JsonObject* save_data;
	SpiceCanvas* canvas;
	GtkImage* preview;
};

struct _SpiceSlideClass {
	GObjectClass parent_class;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	SpiceSlide* slide;
};

struct _SpiceCanvas {
	GtkOverlay parent_instance;
	SpiceCanvasPrivate * priv;
	SpiceWindow* window;
	gdouble current_allocated_width;
	gdouble current_allocated_height;
	SpiceCanvasCanvasGrid* grid;
	JsonObject* save_data;
	GraniteDrawingBufferSurface* surface;
};

struct _SpiceCanvasClass {
	GtkOverlayClass parent_class;
};

struct _SpiceServicesParamSpecFileManager {
	GParamSpec parent_instance;
};

static gpointer spice_services_file_manager_parent_class = NULL;
static gchar* spice_services_file_manager_header;
static gchar* spice_services_file_manager_header = NULL;
static gchar* spice_services_file_manager_footer;
static gchar* spice_services_file_manager_footer = NULL;
VALA_EXTERN SpiceServicesSettings* spice_settings;

VALA_EXTERN gpointer spice_services_file_manager_ref (gpointer instance);
VALA_EXTERN void spice_services_file_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* spice_services_param_spec_file_manager (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
VALA_EXTERN void spice_services_value_set_file_manager (GValue* value,
                                            gpointer v_object);
VALA_EXTERN void spice_services_value_take_file_manager (GValue* value,
                                             gpointer v_object);
VALA_EXTERN gpointer spice_services_value_get_file_manager (const GValue* value);
VALA_EXTERN GType spice_services_file_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceServicesFileManager, spice_services_file_manager_unref)
static GFile* spice_services_file_manager_get_file_from_user (const gchar* title,
                                                       const gchar* accept_button_label,
                                                       GtkFileChooserAction chooser_action,
                                                       GList* filters);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN GType spice_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceWindow, g_object_unref)
VALA_EXTERN SpiceWindow* spice_application_get_active_spice_window (void);
static void __lambda15_ (Block3Data* _data3_,
                  GtkFileFilter* filter);
static void ___lambda15__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN GFile* spice_services_file_manager_open_image (void);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN GFile* spice_services_file_manager_open_presentation (void);
VALA_EXTERN GFile* spice_services_file_manager_new_presentation (const gchar* data);
VALA_EXTERN GType spice_services_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceServicesSettings, g_object_unref)
VALA_EXTERN void spice_services_settings_add_file (SpiceServicesSettings* self,
                                       const gchar* file);
VALA_EXTERN void spice_services_file_manager_write_file (GFile* file,
                                             const gchar* contents);
VALA_EXTERN void spice_services_file_manager_create_file_if_not_exists (GFile* file);
VALA_EXTERN gchar* spice_services_file_manager_open_file (GFile* file);
VALA_EXTERN gchar* spice_services_file_manager_get_presentation_data (GFile* file);
VALA_EXTERN void spice_services_file_manager_delete_file (GFile* file);
VALA_EXTERN gchar* spice_services_file_manager_get_data (GFile* file);
VALA_EXTERN GType spice_slide_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceSlideManager, g_object_unref)
VALA_EXTERN void spice_services_file_manager_export_to_pdf (SpiceSlideManager* manager);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN GType spice_canvas_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvas, g_object_unref)
VALA_EXTERN GType spice_slide_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceSlide, g_object_unref)
VALA_EXTERN SpiceSlide* spice_slide_manager_get_current_slide (SpiceSlideManager* self);
VALA_EXTERN GeeArrayList* spice_slide_manager_get_slides (SpiceSlideManager* self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
VALA_EXTERN GType spice_canvas_canvas_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvasCanvasGrid, g_object_unref)
static gboolean _____lambda20_ (Block5Data* _data5_);
VALA_EXTERN void spice_slide_manager_set_current_slide (SpiceSlideManager* self,
                                            SpiceSlide* value);
static gboolean ______lambda20__gsource_func (gpointer self);
static gboolean __lambda21_ (Block4Data* _data4_);
VALA_EXTERN gboolean spice_slide_get_visible (SpiceSlide* self);
static gboolean ___lambda21__gsource_func (gpointer self);
VALA_EXTERN gchar* spice_services_file_manager_file_to_base64 (GFile* file);
VALA_EXTERN void spice_services_file_manager_base64_to_file (const gchar* filename,
                                                 const gchar* base64_data);
VALA_EXTERN SpiceServicesFileManager* spice_services_file_manager_new (void);
VALA_EXTERN SpiceServicesFileManager* spice_services_file_manager_construct (GType object_type);
static void spice_services_file_manager_finalize (SpiceServicesFileManager * obj);
static GType spice_services_file_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
#line 25 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 25 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return _data3_;
#line 299 "FileManager.c"
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 25 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 25 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_object_unref0 (_data3_->dialog);
#line 25 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_slice_free (Block3Data, _data3_);
#line 313 "FileManager.c"
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 40 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return self ? g_object_ref (self) : NULL;
#line 322 "FileManager.c"
}

static void
__lambda15_ (Block3Data* _data3_,
             GtkFileFilter* filter)
{
	GtkFileChooserNative* _tmp0_;
	GtkFileFilter* _tmp1_;
#line 42 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_return_if_fail (filter != NULL);
#line 43 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp0_ = _data3_->dialog;
#line 43 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp1_ = _g_object_ref0 (filter);
#line 43 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp0_, _tmp1_);
#line 339 "FileManager.c"
}

static void
___lambda15__gfunc (gconstpointer data,
                    gpointer self)
{
#line 42 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	__lambda15_ (self, (GtkFileFilter*) data);
#line 348 "FileManager.c"
}

static GFile*
spice_services_file_manager_get_file_from_user (const gchar* title,
                                                const gchar* accept_button_label,
                                                GtkFileChooserAction chooser_action,
                                                GList* filters)
{
	Block3Data* _data3_;
	GFile* _result_ = NULL;
	SpiceWindow* _tmp0_;
	GtkFileChooserNative* _tmp1_;
	GtkFileFilter* all_filter = NULL;
	GtkFileFilter* _tmp2_;
	GtkFileFilter* _tmp3_;
	GtkFileFilter* _tmp4_;
	GtkFileFilter* _tmp5_;
	GtkFileFilter* _tmp6_;
	GtkFileChooserNative* _tmp7_;
	GtkFileChooserNative* _tmp10_;
	GFile* result;
#line 25 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 25 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_return_val_if_fail (accept_button_label != NULL, NULL);
#line 25 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 25 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_data3_->_ref_count_ = 1;
#line 26 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_result_ = NULL;
#line 28 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp0_ = spice_application_get_active_spice_window ();
#line 28 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp1_ = gtk_file_chooser_native_new (title, (GtkWindow*) _tmp0_, chooser_action, accept_button_label, _ ("Cancel"));
#line 28 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_data3_->dialog = _tmp1_;
#line 36 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp2_ = gtk_file_filter_new ();
#line 36 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_object_ref_sink (_tmp2_);
#line 36 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	all_filter = _tmp2_;
#line 37 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp3_ = all_filter;
#line 37 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	gtk_file_filter_set_name (_tmp3_, "All Files");
#line 38 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp4_ = all_filter;
#line 38 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	gtk_file_filter_add_pattern (_tmp4_, "*");
#line 40 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp5_ = all_filter;
#line 40 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 40 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	filters = g_list_append (filters, _tmp6_);
#line 42 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_list_foreach (filters, ___lambda15__gfunc, _data3_);
#line 46 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp7_ = _data3_->dialog;
#line 46 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (gtk_native_dialog_run ((GtkNativeDialog*) _tmp7_) == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 412 "FileManager.c"
		GtkFileChooserNative* _tmp8_;
		GFile* _tmp9_;
#line 47 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp8_ = _data3_->dialog;
#line 47 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp9_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp8_);
#line 47 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_object_unref0 (_result_);
#line 47 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_result_ = _tmp9_;
#line 423 "FileManager.c"
	}
#line 50 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp10_ = _data3_->dialog;
#line 50 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	gtk_native_dialog_destroy ((GtkNativeDialog*) _tmp10_);
#line 52 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	result = _result_;
#line 52 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_g_object_unref0 (all_filter);
#line 52 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	block3_data_unref (_data3_);
#line 52 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_data3_ = NULL;
#line 52 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return result;
#line 439 "FileManager.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 63 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 447 "FileManager.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 63 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 455 "FileManager.c"
}

GFile*
spice_services_file_manager_open_image (void)
{
	GList* filters = NULL;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp0_;
	GtkFileFilter* _tmp1_;
	GFile* _tmp2_;
	GFile* result;
#line 56 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	filters = NULL;
#line 57 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp0_ = gtk_file_filter_new ();
#line 57 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_object_ref_sink (_tmp0_);
#line 57 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	filter = _tmp0_;
#line 58 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	gtk_file_filter_set_name (filter, "Images");
#line 59 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	gtk_file_filter_add_mime_type (filter, "image/*");
#line 61 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp1_ = _g_object_ref0 (filter);
#line 61 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	filters = g_list_append (filters, _tmp1_);
#line 63 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp2_ = spice_services_file_manager_get_file_from_user (_ ("Open Image"), _ ("Open"), GTK_FILE_CHOOSER_ACTION_SAVE, filters);
#line 63 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	result = _tmp2_;
#line 63 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_g_object_unref0 (filter);
#line 63 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	(filters == NULL) ? NULL : (filters = (_g_list_free__g_object_unref0_ (filters), NULL));
#line 63 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return result;
#line 493 "FileManager.c"
}

GFile*
spice_services_file_manager_open_presentation (void)
{
	GFile* _result_ = NULL;
	GList* filters = NULL;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp0_;
	GtkFileFilter* _tmp1_;
	GFile* _tmp2_;
	GFile* result;
#line 67 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_result_ = NULL;
#line 69 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	filters = NULL;
#line 70 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp0_ = gtk_file_filter_new ();
#line 70 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_object_ref_sink (_tmp0_);
#line 70 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	filter = _tmp0_;
#line 71 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	gtk_file_filter_set_name (filter, "Presentation");
#line 72 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	gtk_file_filter_add_mime_type (filter, "application/x-spiceup");
#line 74 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp1_ = _g_object_ref0 (filter);
#line 74 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	filters = g_list_append (filters, _tmp1_);
#line 76 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp2_ = spice_services_file_manager_get_file_from_user (_ ("Open file"), _ ("Open"), GTK_FILE_CHOOSER_ACTION_OPEN, filters);
#line 76 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_g_object_unref0 (_result_);
#line 76 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_result_ = _tmp2_;
#line 78 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	result = _result_;
#line 78 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_g_object_unref0 (filter);
#line 78 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	(filters == NULL) ? NULL : (filters = (_g_list_free__g_object_unref0_ (filters), NULL));
#line 78 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return result;
#line 538 "FileManager.c"
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
#line 1609 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1610 "glib-2.0.vapi"
	res = (guint8*) self;
#line 1610 "glib-2.0.vapi"
	res_length1 = -1;
#line 1610 "glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1611 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1611 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1611 "glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1612 "glib-2.0.vapi"
	_tmp2_ = res;
#line 1612 "glib-2.0.vapi"
	_tmp2__length1 = res_length1;
#line 1612 "glib-2.0.vapi"
	if (result_length1) {
#line 1612 "glib-2.0.vapi"
		*result_length1 = _tmp2__length1;
#line 575 "FileManager.c"
	}
#line 1612 "glib-2.0.vapi"
	result = _tmp2_;
#line 1612 "glib-2.0.vapi"
	return result;
#line 581 "FileManager.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 603 "FileManager.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 607 "FileManager.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 613 "FileManager.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 617 "FileManager.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 621 "FileManager.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 629 "FileManager.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 657 "FileManager.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 666 "FileManager.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 680 "FileManager.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 689 "FileManager.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 703 "FileManager.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 712 "FileManager.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 721 "FileManager.c"
}

GFile*
spice_services_file_manager_new_presentation (const gchar* data)
{
	GFile* _result_ = NULL;
	gchar* documents = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gint id = 0;
	SpiceServicesSettings* _tmp18_;
	GFile* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* title = NULL;
	guint8* _tmp22_;
	gint _tmp22__length1;
	gint _tmp23_ = 0;
	guint8* _tmp24_;
	gint _tmp24__length1;
	gchar* _tmp25_;
	gchar* name = NULL;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	guint8* _tmp29_;
	gint _tmp29__length1;
	gint _tmp30_ = 0;
	guint8* _tmp31_;
	gint _tmp31__length1;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* formatted_data = NULL;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	GFile* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	guint8* _tmp41_;
	gint _tmp41__length1;
	gint _tmp42_ = 0;
	guint8* _tmp43_;
	gint _tmp43__length1;
	GError* _inner_error0_ = NULL;
	GFile* result;
#line 81 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_return_val_if_fail (data != NULL, NULL);
#line 82 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_result_ = NULL;
#line 84 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp0_ = g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS);
#line 84 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp1_ = g_strdup_printf ("/%s", _ ("Presentations"));
#line 84 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp2_ = _tmp1_;
#line 84 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp3_ = g_strconcat (_tmp0_, _tmp2_, NULL);
#line 84 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp4_ = _tmp3_;
#line 84 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_g_free0 (_tmp2_);
#line 84 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	documents = _tmp4_;
#line 86 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp5_ = documents;
#line 86 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (_tmp5_ != NULL) {
#line 795 "FileManager.c"
		const gchar* _tmp6_;
#line 87 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp6_ = documents;
#line 87 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_mkdir_with_parents (_tmp6_, 0775);
#line 801 "FileManager.c"
	} else {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
#line 89 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp7_ = g_get_home_dir ();
#line 89 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp8_ = g_strdup (_tmp7_);
#line 89 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (documents);
#line 89 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		documents = _tmp8_;
#line 90 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp9_ = documents;
#line 90 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		if (_tmp9_ == NULL) {
#line 818 "FileManager.c"
			gchar* _tmp10_;
#line 91 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp10_ = g_strdup (".");
#line 91 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_g_free0 (documents);
#line 91 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			documents = _tmp10_;
#line 826 "FileManager.c"
		}
	}
#line 95 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	id = 1;
#line 831 "FileManager.c"
	{
		gboolean _tmp11_ = FALSE;
#line 96 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp11_ = TRUE;
#line 96 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		while (TRUE) {
#line 838 "FileManager.c"
			const gchar* _tmp13_;
			gint _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			GFile* _tmp17_;
#line 96 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			if (!_tmp11_) {
#line 846 "FileManager.c"
				GFile* _tmp12_;
#line 98 "../Spice-up-1.9.1/src/Services/FileManager.vala"
				_tmp12_ = _result_;
#line 98 "../Spice-up-1.9.1/src/Services/FileManager.vala"
				if (!g_file_query_exists (_tmp12_, NULL)) {
#line 98 "../Spice-up-1.9.1/src/Services/FileManager.vala"
					break;
#line 854 "FileManager.c"
				}
			}
#line 96 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp11_ = FALSE;
#line 97 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp13_ = documents;
#line 97 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp14_ = id;
#line 97 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			id = _tmp14_ + 1;
#line 97 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp15_ = g_strdup_printf ("%s/%s %d%s", _tmp13_, _ ("Untitled Presentation"), _tmp14_, SPICE_SERVICES_FILE_MANAGER_FILE_EXTENSION);
#line 97 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp16_ = _tmp15_;
#line 97 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp17_ = g_file_new_for_path (_tmp16_);
#line 97 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_g_object_unref0 (_result_);
#line 97 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_result_ = _tmp17_;
#line 97 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_g_free0 (_tmp16_);
#line 877 "FileManager.c"
		}
	}
#line 100 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp18_ = spice_settings;
#line 100 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp19_ = _result_;
#line 100 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp20_ = g_file_get_path (_tmp19_);
#line 100 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp21_ = _tmp20_;
#line 100 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	spice_services_settings_add_file (_tmp18_, _tmp21_);
#line 100 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_g_free0 (_tmp21_);
#line 102 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp22_ = string_get_data (_ ("My Presentation"), &_tmp23_);
#line 102 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp22__length1 = _tmp23_;
#line 102 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp24_ = _tmp22_;
#line 102 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp24__length1 = _tmp22__length1;
#line 102 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp25_ = g_base64_encode (_tmp24_, (gint) _tmp24__length1);
#line 102 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	title = _tmp25_;
#line 103 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp26_ = g_get_real_name ();
#line 103 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp27_ = g_strdup_printf (_ ("By: %s"), _tmp26_);
#line 103 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp28_ = _tmp27_;
#line 103 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp29_ = string_get_data (_tmp28_, &_tmp30_);
#line 103 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp29__length1 = _tmp30_;
#line 103 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp31_ = _tmp29_;
#line 103 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp31__length1 = _tmp29__length1;
#line 103 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp32_ = g_base64_encode (_tmp31_, (gint) _tmp31__length1);
#line 103 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp33_ = _tmp32_;
#line 103 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_g_free0 (_tmp28_);
#line 103 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	name = _tmp33_;
#line 105 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp34_ = string_replace (data, "{title}", title);
#line 105 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp35_ = _tmp34_;
#line 105 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp36_ = string_replace (_tmp35_, "{subtitle}", name);
#line 105 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp37_ = _tmp36_;
#line 105 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_g_free0 (_tmp35_);
#line 105 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	formatted_data = _tmp37_;
#line 107 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp38_ = _result_;
#line 107 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp39_ = g_file_get_path (_tmp38_);
#line 107 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp40_ = _tmp39_;
#line 107 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp41_ = string_get_data (formatted_data, &_tmp42_);
#line 107 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp41__length1 = _tmp42_;
#line 107 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp43_ = _tmp41_;
#line 107 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp43__length1 = _tmp41__length1;
#line 107 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_file_set_contents (_tmp40_, (const char*) _tmp43_, (gsize) _tmp43__length1, &_inner_error0_);
#line 107 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_g_free0 (_tmp40_);
#line 107 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 107 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (formatted_data);
#line 107 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (name);
#line 107 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (title);
#line 107 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (documents);
#line 107 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_object_unref0 (_result_);
#line 107 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 107 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_clear_error (&_inner_error0_);
#line 107 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		return NULL;
#line 974 "FileManager.c"
	}
#line 109 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	result = _result_;
#line 109 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_g_free0 (formatted_data);
#line 109 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_g_free0 (name);
#line 109 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_g_free0 (title);
#line 109 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_g_free0 (documents);
#line 109 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return result;
#line 988 "FileManager.c"
}

void
spice_services_file_manager_write_file (GFile* file,
                                        const gchar* contents)
{
	const gchar* _tmp2_;
	const gchar* _tmp16_;
	GError* _inner_error0_ = NULL;
#line 116 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_return_if_fail (file != NULL);
#line 116 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_return_if_fail (contents != NULL);
#line 117 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (file == NULL) {
#line 118 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		return;
#line 1006 "FileManager.c"
	}
#line 121 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (g_file_query_exists (file, NULL)) {
#line 1010 "FileManager.c"
		{
#line 123 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			g_file_delete (file, NULL, &_inner_error0_);
#line 123 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1016 "FileManager.c"
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp0_;
			const gchar* _tmp1_;
#line 122 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			e = _inner_error0_;
#line 122 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_inner_error0_ = NULL;
#line 125 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp0_ = e;
#line 125 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp1_ = _tmp0_->message;
#line 125 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			g_warning ("FileManager.vala:125: Could not delete file: %s", _tmp1_);
#line 122 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_g_error_free0 (e);
#line 1038 "FileManager.c"
		}
		__finally0:
#line 122 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 122 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 122 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			g_clear_error (&_inner_error0_);
#line 122 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			return;
#line 1049 "FileManager.c"
		}
	}
#line 129 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp2_ = spice_services_file_manager_header;
#line 129 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (_tmp2_ == NULL) {
#line 1056 "FileManager.c"
		GFile* temp_file = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		GFileInputStream* _tmp7_ = NULL;
		GFile* _tmp8_;
		GFileInputStream* _tmp9_;
		GDataInputStream* dis = NULL;
		GDataInputStream* _tmp10_;
		gsize size = 0UL;
		gchar* _tmp11_ = NULL;
		GDataInputStream* _tmp12_;
		gsize _tmp13_ = 0UL;
		gchar* _tmp14_;
		gchar* _tmp15_;
#line 130 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp3_ = g_strdup_printf (SPICE_SERVICES_FILE_MANAGER_RESOURCE_PATH, "save-header");
#line 130 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp4_ = _tmp3_;
#line 130 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp5_ = g_file_new_for_uri (_tmp4_);
#line 130 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp6_ = _tmp5_;
#line 130 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (_tmp4_);
#line 130 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		temp_file = _tmp6_;
#line 131 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp8_ = temp_file;
#line 131 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp9_ = g_file_read (_tmp8_, NULL, &_inner_error0_);
#line 131 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp7_ = _tmp9_;
#line 131 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 131 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_g_object_unref0 (temp_file);
#line 131 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 131 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			g_clear_error (&_inner_error0_);
#line 131 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			return;
#line 1101 "FileManager.c"
		}
#line 131 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp10_ = g_data_input_stream_new ((GInputStream*) _tmp7_);
#line 131 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		dis = _tmp10_;
#line 134 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp12_ = dis;
#line 134 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp14_ = g_data_input_stream_read_upto (_tmp12_, "\0", (gssize) -1, &_tmp13_, NULL, &_inner_error0_);
#line 134 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		size = _tmp13_;
#line 134 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp11_ = _tmp14_;
#line 134 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 134 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_g_object_unref0 (dis);
#line 134 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_g_object_unref0 (_tmp7_);
#line 134 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_g_object_unref0 (temp_file);
#line 134 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 134 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			g_clear_error (&_inner_error0_);
#line 134 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			return;
#line 1129 "FileManager.c"
		}
#line 134 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp15_ = _tmp11_;
#line 134 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp11_ = NULL;
#line 134 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (spice_services_file_manager_header);
#line 134 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		spice_services_file_manager_header = _tmp15_;
#line 129 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (_tmp11_);
#line 129 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_object_unref0 (dis);
#line 129 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_object_unref0 (_tmp7_);
#line 129 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_object_unref0 (temp_file);
#line 1147 "FileManager.c"
	}
#line 137 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp16_ = spice_services_file_manager_footer;
#line 137 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (_tmp16_ == NULL) {
#line 1153 "FileManager.c"
		GFile* temp_file = NULL;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GFile* _tmp19_;
		GFile* _tmp20_;
		GFileInputStream* _tmp21_ = NULL;
		GFile* _tmp22_;
		GFileInputStream* _tmp23_;
		GDataInputStream* dis = NULL;
		GDataInputStream* _tmp24_;
		gsize size = 0UL;
		gchar* _tmp25_ = NULL;
		GDataInputStream* _tmp26_;
		gsize _tmp27_ = 0UL;
		gchar* _tmp28_;
		gchar* _tmp29_;
#line 138 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp17_ = g_strdup_printf (SPICE_SERVICES_FILE_MANAGER_RESOURCE_PATH, "save-footer");
#line 138 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp18_ = _tmp17_;
#line 138 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp19_ = g_file_new_for_uri (_tmp18_);
#line 138 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp20_ = _tmp19_;
#line 138 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (_tmp18_);
#line 138 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		temp_file = _tmp20_;
#line 139 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp22_ = temp_file;
#line 139 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp23_ = g_file_read (_tmp22_, NULL, &_inner_error0_);
#line 139 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp21_ = _tmp23_;
#line 139 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 139 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_g_object_unref0 (temp_file);
#line 139 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 139 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			g_clear_error (&_inner_error0_);
#line 139 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			return;
#line 1198 "FileManager.c"
		}
#line 139 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp24_ = g_data_input_stream_new ((GInputStream*) _tmp21_);
#line 139 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		dis = _tmp24_;
#line 142 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp26_ = dis;
#line 142 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp28_ = g_data_input_stream_read_upto (_tmp26_, "\0", (gssize) -1, &_tmp27_, NULL, &_inner_error0_);
#line 142 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		size = _tmp27_;
#line 142 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp25_ = _tmp28_;
#line 142 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 142 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_g_object_unref0 (dis);
#line 142 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_g_object_unref0 (_tmp21_);
#line 142 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_g_object_unref0 (temp_file);
#line 142 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 142 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			g_clear_error (&_inner_error0_);
#line 142 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			return;
#line 1226 "FileManager.c"
		}
#line 142 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp29_ = _tmp25_;
#line 142 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp25_ = NULL;
#line 142 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (spice_services_file_manager_footer);
#line 142 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		spice_services_file_manager_footer = _tmp29_;
#line 137 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (_tmp25_);
#line 137 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_object_unref0 (dis);
#line 137 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_object_unref0 (_tmp21_);
#line 137 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_object_unref0 (temp_file);
#line 1244 "FileManager.c"
	}
#line 145 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	spice_services_file_manager_create_file_if_not_exists (file);
#line 1248 "FileManager.c"
	{
		gchar* _tmp30_;
		gchar* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		guint8* _tmp38_;
		gint _tmp38__length1;
		gint _tmp39_ = 0;
		guint8* _tmp40_;
		gint _tmp40__length1;
#line 148 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp30_ = g_file_get_path (file);
#line 148 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp31_ = _tmp30_;
#line 148 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp32_ = spice_services_file_manager_header;
#line 148 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp33_ = g_strconcat (_tmp32_, contents, NULL);
#line 148 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp34_ = _tmp33_;
#line 148 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp35_ = spice_services_file_manager_footer;
#line 148 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp36_ = g_strconcat (_tmp34_, _tmp35_, NULL);
#line 148 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp37_ = _tmp36_;
#line 148 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp38_ = string_get_data (_tmp37_, &_tmp39_);
#line 148 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp38__length1 = _tmp39_;
#line 148 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp40_ = _tmp38_;
#line 148 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp40__length1 = _tmp38__length1;
#line 148 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_file_set_contents (_tmp31_, (const char*) _tmp40_, (gsize) _tmp40__length1, &_inner_error0_);
#line 148 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (_tmp37_);
#line 148 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (_tmp34_);
#line 148 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (_tmp31_);
#line 148 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1297 "FileManager.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		gchar* _tmp41_;
		gchar* _tmp42_;
		GError* _tmp43_;
		const gchar* _tmp44_;
#line 147 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		e = _inner_error0_;
#line 147 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_inner_error0_ = NULL;
#line 150 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp41_ = g_file_get_basename (file);
#line 150 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp42_ = _tmp41_;
#line 150 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp43_ = e;
#line 150 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp44_ = _tmp43_->message;
#line 150 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_warning ("FileManager.vala:150: Could not write file \"%s\": %s", _tmp42_, _tmp44_);
#line 150 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (_tmp42_);
#line 147 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_error_free0 (e);
#line 1327 "FileManager.c"
	}
	__finally1:
#line 147 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 147 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 147 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_clear_error (&_inner_error0_);
#line 147 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		return;
#line 1338 "FileManager.c"
	}
}

gchar*
spice_services_file_manager_open_file (GFile* file)
{
	SpiceServicesSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
#line 154 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 155 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp0_ = spice_settings;
#line 155 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp1_ = g_file_get_path (file);
#line 155 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp2_ = _tmp1_;
#line 155 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	spice_services_settings_add_file (_tmp0_, _tmp2_);
#line 155 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_g_free0 (_tmp2_);
#line 156 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp3_ = spice_services_file_manager_get_presentation_data (file);
#line 156 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	result = _tmp3_;
#line 156 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return result;
#line 1368 "FileManager.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1585 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1585 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1585 "glib-2.0.vapi"
	return result;
#line 1387 "FileManager.c"
}

void
spice_services_file_manager_delete_file (GFile* file)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 159 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_return_if_fail (file != NULL);
#line 160 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (file != NULL) {
#line 161 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp1_ = g_file_query_exists (file, NULL);
#line 1401 "FileManager.c"
	} else {
#line 160 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp1_ = FALSE;
#line 1405 "FileManager.c"
	}
#line 160 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (_tmp1_) {
#line 1409 "FileManager.c"
		gchar* _tmp2_;
		gchar* _tmp3_;
#line 162 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp2_ = g_file_get_basename (file);
#line 162 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp3_ = _tmp2_;
#line 162 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp0_ = string_contains (_tmp3_, SPICE_SERVICES_FILE_MANAGER_FILE_EXTENSION);
#line 162 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (_tmp3_);
#line 1420 "FileManager.c"
	} else {
#line 160 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp0_ = FALSE;
#line 1424 "FileManager.c"
	}
#line 160 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (_tmp0_) {
#line 1428 "FileManager.c"
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 163 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp4_ = g_file_get_path (file);
#line 163 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp5_ = _tmp4_;
#line 163 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_remove (_tmp5_);
#line 163 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (_tmp5_);
#line 1439 "FileManager.c"
	}
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
#line 1313 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1314 "glib-2.0.vapi"
	result = g_utf8_get_char (((gchar*) self) + index);
#line 1314 "glib-2.0.vapi"
	return result;
#line 1454 "FileManager.c"
}

gchar*
spice_services_file_manager_get_presentation_data (GFile* file)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp13_;
	gchar* result;
#line 167 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 168 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (file != NULL) {
#line 168 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp0_ = g_file_query_exists (file, NULL);
#line 1469 "FileManager.c"
	} else {
#line 168 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp0_ = FALSE;
#line 1473 "FileManager.c"
	}
#line 168 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (_tmp0_) {
#line 1477 "FileManager.c"
		gchar* data = NULL;
		gchar* _tmp1_;
		const gchar* _tmp2_;
#line 169 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp1_ = spice_services_file_manager_get_data (file);
#line 169 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		data = _tmp1_;
#line 170 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp2_ = data;
#line 170 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		if (string_get_char (_tmp2_, (glong) 0) == ((gunichar) '<')) {
#line 1489 "FileManager.c"
			const gchar* _tmp3_;
			gchar** _tmp4_;
			gchar** _tmp5_;
			gchar** _tmp6_;
			gint _tmp6__length1;
			const gchar* _tmp7_;
			gchar** _tmp8_;
			gchar** _tmp9_;
			gchar** _tmp10_;
			gint _tmp10__length1;
			const gchar* _tmp11_;
			gchar* _tmp12_;
#line 171 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp3_ = data;
#line 171 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, "<content id=\"content\">", 0);
#line 171 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp6_ = _tmp5_;
#line 171 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp6__length1 = _vala_array_length (_tmp4_);
#line 171 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp7_ = _tmp6_[1];
#line 171 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, "</content>", 0);
#line 171 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp10_ = _tmp9_;
#line 171 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp10__length1 = _vala_array_length (_tmp8_);
#line 171 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp11_ = _tmp10_[0];
#line 171 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp12_ = g_strdup (_tmp11_);
#line 171 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_g_free0 (data);
#line 171 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			data = _tmp12_;
#line 171 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
#line 171 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
#line 1530 "FileManager.c"
		}
#line 174 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		result = data;
#line 174 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		return result;
#line 1536 "FileManager.c"
	}
#line 177 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp13_ = g_strdup ("");
#line 177 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	result = _tmp13_;
#line 177 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return result;
#line 1544 "FileManager.c"
}

gchar*
spice_services_file_manager_get_data (GFile* file)
{
	gchar* data = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 180 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 181 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp0_ = g_strdup ("");
#line 181 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	data = _tmp0_;
#line 1560 "FileManager.c"
	{
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
#line 184 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp1_ = g_file_get_path (file);
#line 184 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp2_ = _tmp1_;
#line 184 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_file_get_contents (_tmp2_, &_tmp3_, NULL, &_inner_error0_);
#line 184 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (data);
#line 184 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		data = _tmp3_;
#line 184 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (_tmp2_);
#line 184 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1579 "FileManager.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 183 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		e = _inner_error0_;
#line 183 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_inner_error0_ = NULL;
#line 186 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp4_ = e;
#line 186 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp5_ = _tmp4_->message;
#line 186 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_warning ("FileManager.vala:186: Error reading file: %s", _tmp5_);
#line 183 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_error_free0 (e);
#line 1601 "FileManager.c"
	}
	__finally0:
#line 183 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 183 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (data);
#line 183 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 183 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_clear_error (&_inner_error0_);
#line 183 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		return NULL;
#line 1614 "FileManager.c"
	}
#line 188 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	result = data;
#line 188 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return result;
#line 1620 "FileManager.c"
}

void
spice_services_file_manager_create_file_if_not_exists (GFile* file)
{
	GError* _inner_error0_ = NULL;
#line 191 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_return_if_fail (file != NULL);
#line 192 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (!g_file_query_exists (file, NULL)) {
#line 1631 "FileManager.c"
		{
			GFileOutputStream* _tmp0_;
			GFileOutputStream* _tmp1_;
#line 194 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp0_ = g_file_create (file, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
#line 194 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp1_ = _tmp0_;
#line 194 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_g_object_unref0 (_tmp1_);
#line 194 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1643 "FileManager.c"
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp2_;
#line 193 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			e = _inner_error0_;
#line 193 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_inner_error0_ = NULL;
#line 196 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp2_ = e->message;
#line 196 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			g_error ("FileManager.vala:196: Could not write file: %s", _tmp2_);
#line 193 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_g_error_free0 (e);
#line 1662 "FileManager.c"
		}
		__finally0:
#line 193 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 193 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 193 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			g_clear_error (&_inner_error0_);
#line 193 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			return;
#line 1673 "FileManager.c"
		}
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
#line 201 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 201 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return _data4_;
#line 1685 "FileManager.c"
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 201 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 201 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_cairo_surface_destroy0 (_data4_->pdf);
#line 201 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_object_unref0 (_data4_->manager);
#line 201 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_slice_free (Block4Data, _data4_);
#line 1701 "FileManager.c"
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return _data5_;
#line 1712 "FileManager.c"
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_object_unref0 (_data5_->slide);
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		block4_data_unref (_data5_->_data4_);
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_data5_->_data4_ = NULL;
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_slice_free (Block5Data, _data5_);
#line 1730 "FileManager.c"
	}
}

static gboolean
_____lambda20_ (Block5Data* _data5_)
{
	Block4Data* _data4_;
	SpiceSlide* _tmp0_;
	SpiceSlide* _tmp1_;
	SpiceSlide* _tmp2_;
	SpiceCanvas* _tmp3_;
	gboolean result;
#line 223 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_data4_ = _data5_->_data4_;
#line 224 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp0_ = _data5_->slide;
#line 224 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	spice_slide_manager_set_current_slide (_data4_->manager, _tmp0_);
#line 225 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp1_ = spice_slide_manager_get_current_slide (_data4_->manager);
#line 225 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp2_ = _tmp1_;
#line 225 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp3_ = _tmp2_->canvas;
#line 225 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp3_);
#line 226 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	result = FALSE;
#line 226 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return result;
#line 1761 "FileManager.c"
}

static gboolean
______lambda20__gsource_func (gpointer self)
{
	gboolean result;
	result = _____lambda20_ (self);
#line 223 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return result;
#line 1771 "FileManager.c"
}

static gboolean
__lambda21_ (Block4Data* _data4_)
{
	gboolean first = FALSE;
	cairo_surface_t* _tmp24_;
	gboolean result;
#line 232 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	first = TRUE;
#line 1782 "FileManager.c"
	{
		GeeArrayList* _slide_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _slide_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _slide_index = 0;
#line 233 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp0_ = spice_slide_manager_get_slides (_data4_->manager);
#line 233 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp1_ = _tmp0_;
#line 233 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_slide_list = _tmp1_;
#line 233 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp2_ = _slide_list;
#line 233 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 233 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp4_ = _tmp3_;
#line 233 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_slide_size = _tmp4_;
#line 233 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_slide_index = -1;
#line 233 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		while (TRUE) {
#line 1810 "FileManager.c"
			gint _tmp5_;
			gint _tmp6_;
			SpiceSlide* slide = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			SpiceSlide* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			GraniteDrawingBufferSurface* buffer = NULL;
			SpiceSlide* _tmp13_;
			SpiceCanvas* _tmp14_;
			GraniteDrawingBufferSurface* _tmp15_;
			GraniteDrawingBufferSurface* _tmp16_;
			cairo_t* pdfcontext = NULL;
			cairo_surface_t* _tmp17_;
			cairo_t* _tmp18_;
			cairo_t* _tmp19_;
			GraniteDrawingBufferSurface* _tmp20_;
			cairo_surface_t* _tmp21_;
			cairo_surface_t* _tmp22_;
			cairo_t* _tmp23_;
#line 233 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_slide_index = _slide_index + 1;
#line 233 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp5_ = _slide_index;
#line 233 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp6_ = _slide_size;
#line 233 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			if (!(_tmp5_ < _tmp6_)) {
#line 233 "../Spice-up-1.9.1/src/Services/FileManager.vala"
				break;
#line 1842 "FileManager.c"
			}
#line 233 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp7_ = _slide_list;
#line 233 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _slide_index);
#line 233 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			slide = (SpiceSlide*) _tmp8_;
#line 234 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp9_ = slide;
#line 234 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp10_ = spice_slide_get_visible (_tmp9_);
#line 234 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp11_ = _tmp10_;
#line 234 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			if (!_tmp11_) {
#line 234 "../Spice-up-1.9.1/src/Services/FileManager.vala"
				_g_object_unref0 (slide);
#line 234 "../Spice-up-1.9.1/src/Services/FileManager.vala"
				continue;
#line 1862 "FileManager.c"
			}
#line 236 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			if (!first) {
#line 1866 "FileManager.c"
				cairo_surface_t* _tmp12_;
#line 237 "../Spice-up-1.9.1/src/Services/FileManager.vala"
				_tmp12_ = _data4_->pdf;
#line 237 "../Spice-up-1.9.1/src/Services/FileManager.vala"
				cairo_surface_copy_page (_tmp12_);
#line 1872 "FileManager.c"
			} else {
#line 239 "../Spice-up-1.9.1/src/Services/FileManager.vala"
				first = FALSE;
#line 1876 "FileManager.c"
			}
#line 242 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp13_ = slide;
#line 242 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp14_ = _tmp13_->canvas;
#line 242 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp15_ = _tmp14_->surface;
#line 242 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp16_ = _g_object_ref0 (_tmp15_);
#line 242 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			buffer = _tmp16_;
#line 244 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp17_ = _data4_->pdf;
#line 244 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp18_ = cairo_create (_tmp17_);
#line 244 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			pdfcontext = _tmp18_;
#line 245 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp19_ = pdfcontext;
#line 245 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp20_ = buffer;
#line 245 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp21_ = granite_drawing_buffer_surface_get_surface (_tmp20_);
#line 245 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp22_ = _tmp21_;
#line 245 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			cairo_set_source_surface (_tmp19_, _tmp22_, (gdouble) 0, (gdouble) 0);
#line 246 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp23_ = pdfcontext;
#line 246 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			cairo_paint (_tmp23_);
#line 233 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_cairo_destroy0 (pdfcontext);
#line 233 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_g_object_unref0 (buffer);
#line 233 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_g_object_unref0 (slide);
#line 1914 "FileManager.c"
		}
	}
#line 249 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp24_ = _data4_->pdf;
#line 249 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	cairo_surface_finish (_tmp24_);
#line 250 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	result = FALSE;
#line 250 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return result;
#line 1925 "FileManager.c"
}

static gboolean
___lambda21__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda21_ (self);
#line 231 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return result;
#line 1935 "FileManager.c"
}

void
spice_services_file_manager_export_to_pdf (SpiceSlideManager* manager)
{
	Block4Data* _data4_;
	SpiceSlideManager* _tmp0_;
	GList* filters = NULL;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp1_;
	GtkFileFilter* _tmp2_;
	GtkFileFilter* _tmp3_;
	GtkFileFilter* _tmp4_;
	GtkFileFilter* _tmp5_;
	GFile* file = NULL;
	GList* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean _tmp14_;
	SpiceCanvas* current_slide = NULL;
	SpiceSlide* _tmp21_;
	SpiceSlide* _tmp22_;
	SpiceCanvas* _tmp23_;
	SpiceCanvas* _tmp24_;
	GFile* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	SpiceCanvas* _tmp28_;
	SpiceCanvas* _tmp29_;
	cairo_surface_t* _tmp30_;
	cairo_surface_t* _tmp31_;
	gint pages_to_draw = 0;
#line 201 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_return_if_fail (manager != NULL);
#line 201 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 201 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_data4_->_ref_count_ = 1;
#line 201 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp0_ = _g_object_ref0 (manager);
#line 201 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_g_object_unref0 (_data4_->manager);
#line 201 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_data4_->manager = _tmp0_;
#line 202 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	filters = NULL;
#line 203 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp1_ = gtk_file_filter_new ();
#line 203 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_object_ref_sink (_tmp1_);
#line 203 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	filter = _tmp1_;
#line 204 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp2_ = filter;
#line 204 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	gtk_file_filter_set_name (_tmp2_, "PDF");
#line 205 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp3_ = filter;
#line 205 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	gtk_file_filter_add_mime_type (_tmp3_, "application/pdf");
#line 207 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp4_ = filter;
#line 207 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 207 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	filters = g_list_append (filters, _tmp5_);
#line 209 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp6_ = filters;
#line 209 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp7_ = spice_services_file_manager_get_file_from_user (_ ("Export to PDF"), _ ("Save"), GTK_FILE_CHOOSER_ACTION_SAVE, _tmp6_);
#line 209 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	file = _tmp7_;
#line 210 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp8_ = file;
#line 210 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (_tmp8_ == NULL) {
#line 210 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_object_unref0 (file);
#line 210 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_object_unref0 (filter);
#line 210 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		(filters == NULL) ? NULL : (filters = (_g_list_free__g_object_unref0_ (filters), NULL));
#line 210 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		block4_data_unref (_data4_);
#line 210 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_data4_ = NULL;
#line 210 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		return;
#line 2029 "FileManager.c"
	}
#line 212 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp9_ = file;
#line 212 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp10_ = g_file_get_basename (_tmp9_);
#line 212 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp11_ = _tmp10_;
#line 212 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) -1);
#line 212 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp13_ = _tmp12_;
#line 212 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp14_ = !g_str_has_suffix (_tmp13_, ".pdf");
#line 212 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_g_free0 (_tmp13_);
#line 212 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_g_free0 (_tmp11_);
#line 212 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (_tmp14_) {
#line 2049 "FileManager.c"
		GFile* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		GFile* _tmp20_;
#line 213 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp15_ = file;
#line 213 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp16_ = g_file_get_path (_tmp15_);
#line 213 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp17_ = _tmp16_;
#line 213 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp18_ = g_strconcat (_tmp17_, ".pdf", NULL);
#line 213 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp19_ = _tmp18_;
#line 213 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp20_ = g_file_new_for_path (_tmp19_);
#line 213 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_object_unref0 (file);
#line 213 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		file = _tmp20_;
#line 213 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (_tmp19_);
#line 213 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (_tmp17_);
#line 2076 "FileManager.c"
	}
#line 216 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp21_ = spice_slide_manager_get_current_slide (_data4_->manager);
#line 216 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp22_ = _tmp21_;
#line 216 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp23_ = _tmp22_->canvas;
#line 216 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp24_ = _g_object_ref0 (_tmp23_);
#line 216 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	current_slide = _tmp24_;
#line 217 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp25_ = file;
#line 217 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp26_ = g_file_get_path (_tmp25_);
#line 217 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp27_ = _tmp26_;
#line 217 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp28_ = current_slide;
#line 217 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp29_ = current_slide;
#line 217 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp30_ = cairo_pdf_surface_create (_tmp27_, (gdouble) gtk_widget_get_allocated_width ((GtkWidget*) _tmp28_), (gdouble) gtk_widget_get_allocated_height ((GtkWidget*) _tmp29_));
#line 217 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp31_ = _tmp30_;
#line 217 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_g_free0 (_tmp27_);
#line 217 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_data4_->pdf = _tmp31_;
#line 220 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	pages_to_draw = 1;
#line 2108 "FileManager.c"
	{
		GeeArrayList* _slide_list = NULL;
		GeeArrayList* _tmp32_;
		GeeArrayList* _tmp33_;
		gint _slide_size = 0;
		GeeArrayList* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		gint _slide_index = 0;
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp32_ = spice_slide_manager_get_slides (_data4_->manager);
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp33_ = _tmp32_;
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_slide_list = _tmp33_;
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp34_ = _slide_list;
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp35_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp34_);
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp36_ = _tmp35_;
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_slide_size = _tmp36_;
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_slide_index = -1;
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		while (TRUE) {
#line 2136 "FileManager.c"
			Block5Data* _data5_;
			gint _tmp37_;
			gint _tmp38_;
			GeeArrayList* _tmp39_;
			gpointer _tmp40_;
			gboolean _tmp41_ = FALSE;
			SpiceSlide* _tmp42_;
			SpiceCanvas* _tmp43_;
			GraniteDrawingBufferSurface* _tmp44_;
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_data5_ = g_slice_new0 (Block5Data);
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_data5_->_ref_count_ = 1;
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_data5_->_data4_ = block4_data_ref (_data4_);
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_slide_index = _slide_index + 1;
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp37_ = _slide_index;
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp38_ = _slide_size;
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			if (!(_tmp37_ < _tmp38_)) {
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
				block5_data_unref (_data5_);
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
				_data5_ = NULL;
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
				break;
#line 2166 "FileManager.c"
			}
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp39_ = _slide_list;
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, _slide_index);
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_data5_->slide = (SpiceSlide*) _tmp40_;
#line 222 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp42_ = _data5_->slide;
#line 222 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp43_ = _tmp42_->canvas;
#line 222 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_tmp44_ = _tmp43_->surface;
#line 222 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			if (_tmp44_ == NULL) {
#line 222 "../Spice-up-1.9.1/src/Services/FileManager.vala"
				_tmp41_ = TRUE;
#line 2184 "FileManager.c"
			} else {
				SpiceSlide* _tmp45_;
				SpiceCanvas* _tmp46_;
				SpiceCanvas* _tmp47_;
#line 222 "../Spice-up-1.9.1/src/Services/FileManager.vala"
				_tmp45_ = _data5_->slide;
#line 222 "../Spice-up-1.9.1/src/Services/FileManager.vala"
				_tmp46_ = _tmp45_->canvas;
#line 222 "../Spice-up-1.9.1/src/Services/FileManager.vala"
				_tmp47_ = current_slide;
#line 222 "../Spice-up-1.9.1/src/Services/FileManager.vala"
				_tmp41_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp46_) != gtk_widget_get_allocated_width ((GtkWidget*) _tmp47_);
#line 2197 "FileManager.c"
			}
#line 222 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			if (_tmp41_) {
#line 2201 "FileManager.c"
				gint _tmp48_;
#line 223 "../Spice-up-1.9.1/src/Services/FileManager.vala"
				_tmp48_ = pages_to_draw;
#line 223 "../Spice-up-1.9.1/src/Services/FileManager.vala"
				pages_to_draw = _tmp48_ + 1;
#line 223 "../Spice-up-1.9.1/src/Services/FileManager.vala"
				g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (500 * _tmp48_), ______lambda20__gsource_func, block5_data_ref (_data5_), block5_data_unref);
#line 2209 "FileManager.c"
			}
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			block5_data_unref (_data5_);
#line 221 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			_data5_ = NULL;
#line 2215 "FileManager.c"
		}
	}
#line 231 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (600 * pages_to_draw), ___lambda21__gsource_func, block4_data_ref (_data4_), block4_data_unref);
#line 201 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_g_object_unref0 (current_slide);
#line 201 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_g_object_unref0 (file);
#line 201 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_g_object_unref0 (filter);
#line 201 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	(filters == NULL) ? NULL : (filters = (_g_list_free__g_object_unref0_ (filters), NULL));
#line 201 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	block4_data_unref (_data4_);
#line 201 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_data4_ = NULL;
#line 2232 "FileManager.c"
}

gchar*
spice_services_file_manager_file_to_base64 (GFile* file)
{
	guint8* data = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 254 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 2246 "FileManager.c"
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		guint8* _tmp2_ = NULL;
		gsize _tmp3_ = 0;
#line 258 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp0_ = g_file_get_path (file);
#line 258 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp1_ = _tmp0_;
#line 258 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_file_get_contents (_tmp1_, (gchar**) (&_tmp2_), &_tmp3_, &_inner_error0_);
#line 258 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		data = (g_free (data), NULL);
#line 258 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		data = _tmp2_;
#line 258 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		data_length1 = _tmp3_;
#line 258 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_data_size_ = data_length1;
#line 258 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_free0 (_tmp1_);
#line 258 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2270 "FileManager.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 257 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		e = _inner_error0_;
#line 257 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_inner_error0_ = NULL;
#line 260 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp4_ = e;
#line 260 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp5_ = _tmp4_->message;
#line 260 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_warning ("FileManager.vala:260: Could not get file data: %s", _tmp5_);
#line 257 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_error_free0 (e);
#line 2292 "FileManager.c"
	}
	__finally0:
#line 257 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 257 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		data = (g_free (data), NULL);
#line 257 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 257 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_clear_error (&_inner_error0_);
#line 257 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		return NULL;
#line 2305 "FileManager.c"
	}
#line 263 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp6_ = g_base64_encode (data, (gint) data_length1);
#line 263 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	result = _tmp6_;
#line 263 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	data = (g_free (data), NULL);
#line 263 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return result;
#line 2315 "FileManager.c"
}

void
spice_services_file_manager_base64_to_file (const gchar* filename,
                                            const gchar* base64_data)
{
	guchar* data = NULL;
	gsize _tmp0_ = 0;
	guchar* _tmp1_;
	gint data_length1;
	gint _data_size_;
	GError* _inner_error0_ = NULL;
#line 266 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_return_if_fail (filename != NULL);
#line 266 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_return_if_fail (base64_data != NULL);
#line 267 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_tmp1_ = g_base64_decode (base64_data, &_tmp0_);
#line 267 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	data = _tmp1_;
#line 267 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	data_length1 = _tmp0_;
#line 267 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	_data_size_ = data_length1;
#line 2340 "FileManager.c"
	{
#line 269 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_file_set_contents (filename, (const char*) data, (gsize) data_length1, &_inner_error0_);
#line 269 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2346 "FileManager.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 268 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		e = _inner_error0_;
#line 268 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_inner_error0_ = NULL;
#line 271 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp2_ = e;
#line 271 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_tmp3_ = _tmp2_->message;
#line 271 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_warning ("FileManager.vala:271: Could not save data to file: %s", _tmp3_);
#line 268 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		_g_error_free0 (e);
#line 2368 "FileManager.c"
	}
	__finally0:
#line 268 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 268 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		data = (g_free (data), NULL);
#line 268 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 268 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_clear_error (&_inner_error0_);
#line 268 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		return;
#line 2381 "FileManager.c"
	}
#line 266 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	data = (g_free (data), NULL);
#line 2385 "FileManager.c"
}

SpiceServicesFileManager*
spice_services_file_manager_construct (GType object_type)
{
	SpiceServicesFileManager* self = NULL;
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	self = (SpiceServicesFileManager*) g_type_create_instance (object_type);
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return self;
#line 2396 "FileManager.c"
}

SpiceServicesFileManager*
spice_services_file_manager_new (void)
{
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return spice_services_file_manager_construct (SPICE_SERVICES_TYPE_FILE_MANAGER);
#line 2404 "FileManager.c"
}

static void
spice_services_value_file_manager_init (GValue* value)
{
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	value->data[0].v_pointer = NULL;
#line 2412 "FileManager.c"
}

static void
spice_services_value_file_manager_free_value (GValue* value)
{
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (value->data[0].v_pointer) {
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		spice_services_file_manager_unref (value->data[0].v_pointer);
#line 2422 "FileManager.c"
	}
}

static void
spice_services_value_file_manager_copy_value (const GValue* src_value,
                                              GValue* dest_value)
{
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		dest_value->data[0].v_pointer = spice_services_file_manager_ref (src_value->data[0].v_pointer);
#line 2434 "FileManager.c"
	} else {
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2438 "FileManager.c"
	}
}

static gpointer
spice_services_value_file_manager_peek_pointer (const GValue* value)
{
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return value->data[0].v_pointer;
#line 2447 "FileManager.c"
}

static gchar*
spice_services_value_file_manager_collect_value (GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (collect_values[0].v_pointer) {
#line 2458 "FileManager.c"
		SpiceServicesFileManager * object;
		object = collect_values[0].v_pointer;
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2465 "FileManager.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2469 "FileManager.c"
		}
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		value->data[0].v_pointer = spice_services_file_manager_ref (object);
#line 2473 "FileManager.c"
	} else {
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		value->data[0].v_pointer = NULL;
#line 2477 "FileManager.c"
	}
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return NULL;
#line 2481 "FileManager.c"
}

static gchar*
spice_services_value_file_manager_lcopy_value (const GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	SpiceServicesFileManager ** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (!object_p) {
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2496 "FileManager.c"
	}
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (!value->data[0].v_pointer) {
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		*object_p = NULL;
#line 2502 "FileManager.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		*object_p = value->data[0].v_pointer;
#line 2506 "FileManager.c"
	} else {
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		*object_p = spice_services_file_manager_ref (value->data[0].v_pointer);
#line 2510 "FileManager.c"
	}
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return NULL;
#line 2514 "FileManager.c"
}

GParamSpec*
spice_services_param_spec_file_manager (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags)
{
	SpiceServicesParamSpecFileManager* spec;
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_return_val_if_fail (g_type_is_a (object_type, SPICE_SERVICES_TYPE_FILE_MANAGER), NULL);
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return G_PARAM_SPEC (spec);
#line 2533 "FileManager.c"
}

gpointer
spice_services_value_get_file_manager (const GValue* value)
{
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SPICE_SERVICES_TYPE_FILE_MANAGER), NULL);
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return value->data[0].v_pointer;
#line 2543 "FileManager.c"
}

void
spice_services_value_set_file_manager (GValue* value,
                                       gpointer v_object)
{
	SpiceServicesFileManager * old;
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SPICE_SERVICES_TYPE_FILE_MANAGER));
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	old = value->data[0].v_pointer;
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (v_object) {
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SPICE_SERVICES_TYPE_FILE_MANAGER));
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		value->data[0].v_pointer = v_object;
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		spice_services_file_manager_ref (value->data[0].v_pointer);
#line 2565 "FileManager.c"
	} else {
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		value->data[0].v_pointer = NULL;
#line 2569 "FileManager.c"
	}
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (old) {
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		spice_services_file_manager_unref (old);
#line 2575 "FileManager.c"
	}
}

void
spice_services_value_take_file_manager (GValue* value,
                                        gpointer v_object)
{
	SpiceServicesFileManager * old;
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SPICE_SERVICES_TYPE_FILE_MANAGER));
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	old = value->data[0].v_pointer;
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (v_object) {
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SPICE_SERVICES_TYPE_FILE_MANAGER));
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		value->data[0].v_pointer = v_object;
#line 2596 "FileManager.c"
	} else {
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		value->data[0].v_pointer = NULL;
#line 2600 "FileManager.c"
	}
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (old) {
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		spice_services_file_manager_unref (old);
#line 2606 "FileManager.c"
	}
}

static void
spice_services_file_manager_class_init (SpiceServicesFileManagerClass * klass,
                                        gpointer klass_data)
{
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	spice_services_file_manager_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	((SpiceServicesFileManagerClass *) klass)->finalize = spice_services_file_manager_finalize;
#line 2618 "FileManager.c"
}

static void
spice_services_file_manager_instance_init (SpiceServicesFileManager * self,
                                           gpointer klass)
{
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	self->ref_count = 1;
#line 2627 "FileManager.c"
}

static void
spice_services_file_manager_finalize (SpiceServicesFileManager * obj)
{
	SpiceServicesFileManager * self;
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_SERVICES_TYPE_FILE_MANAGER, SpiceServicesFileManager);
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_signal_handlers_destroy (self);
#line 2638 "FileManager.c"
}

static GType
spice_services_file_manager_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { spice_services_value_file_manager_init, spice_services_value_file_manager_free_value, spice_services_value_file_manager_copy_value, spice_services_value_file_manager_peek_pointer, "p", spice_services_value_file_manager_collect_value, "p", spice_services_value_file_manager_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SpiceServicesFileManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_services_file_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceServicesFileManager), 0, (GInstanceInitFunc) spice_services_file_manager_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType spice_services_file_manager_type_id;
	spice_services_file_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SpiceServicesFileManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return spice_services_file_manager_type_id;
}

GType
spice_services_file_manager_get_type (void)
{
	static volatile gsize spice_services_file_manager_type_id__once = 0;
	if (g_once_init_enter (&spice_services_file_manager_type_id__once)) {
		GType spice_services_file_manager_type_id;
		spice_services_file_manager_type_id = spice_services_file_manager_get_type_once ();
		g_once_init_leave (&spice_services_file_manager_type_id__once, spice_services_file_manager_type_id);
	}
	return spice_services_file_manager_type_id__once;
}

gpointer
spice_services_file_manager_ref (gpointer instance)
{
	SpiceServicesFileManager * self;
	self = instance;
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	return instance;
#line 2673 "FileManager.c"
}

void
spice_services_file_manager_unref (gpointer instance)
{
	SpiceServicesFileManager * self;
	self = instance;
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		SPICE_SERVICES_FILE_MANAGER_GET_CLASS (self)->finalize (self);
#line 22 "../Spice-up-1.9.1/src/Services/FileManager.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2687 "FileManager.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

