/* bluetooth.h generated by valac 0.56.18-dirty, the Vala compiler, do not modify */

#ifndef __SRC_BLUETOOTH_H__
#define __SRC_BLUETOOTH_H__

#include <granite-7.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <switchboard.h>
#include <gio/gio.h>
#include <gmodule.h>
#include <gee.h>

G_BEGIN_DECLS

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif
#define GETTEXT_PACKAGE "io.elementary.settings.bluetooth"
#define LOCALEDIR "/usr/share/locale"

#define TYPE_PAIR_DIALOG (pair_dialog_get_type ())
#define PAIR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAIR_DIALOG, PairDialog))
#define PAIR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAIR_DIALOG, PairDialogClass))
#define IS_PAIR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAIR_DIALOG))
#define IS_PAIR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAIR_DIALOG))
#define PAIR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAIR_DIALOG, PairDialogClass))

typedef struct _PairDialog PairDialog;
typedef struct _PairDialogClass PairDialogClass;
typedef struct _PairDialogPrivate PairDialogPrivate;
typedef enum  {
	PAIR_DIALOG_AUTH_TYPE_REQUEST_CONFIRMATION,
	PAIR_DIALOG_AUTH_TYPE_REQUEST_AUTHORIZATION,
	PAIR_DIALOG_AUTH_TYPE_DISPLAY_PASSKEY,
	PAIR_DIALOG_AUTH_TYPE_DISPLAY_PIN_CODE
} PairDialogAuthType;

#define PAIR_DIALOG_TYPE_AUTH_TYPE (pair_dialog_auth_type_get_type ())

#define BLUETOOTH_TYPE_PLUG (bluetooth_plug_get_type ())
#define BLUETOOTH_PLUG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_TYPE_PLUG, BluetoothPlug))
#define BLUETOOTH_PLUG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BLUETOOTH_TYPE_PLUG, BluetoothPlugClass))
#define BLUETOOTH_IS_PLUG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_TYPE_PLUG))
#define BLUETOOTH_IS_PLUG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BLUETOOTH_TYPE_PLUG))
#define BLUETOOTH_PLUG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BLUETOOTH_TYPE_PLUG, BluetoothPlugClass))

typedef struct _BluetoothPlug BluetoothPlug;
typedef struct _BluetoothPlugClass BluetoothPlugClass;
typedef struct _BluetoothPlugPrivate BluetoothPlugPrivate;

#define BLUETOOTH_TYPE_MAIN_VIEW (bluetooth_main_view_get_type ())
#define BLUETOOTH_MAIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_TYPE_MAIN_VIEW, BluetoothMainView))
#define BLUETOOTH_MAIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BLUETOOTH_TYPE_MAIN_VIEW, BluetoothMainViewClass))
#define BLUETOOTH_IS_MAIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_TYPE_MAIN_VIEW))
#define BLUETOOTH_IS_MAIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BLUETOOTH_TYPE_MAIN_VIEW))
#define BLUETOOTH_MAIN_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BLUETOOTH_TYPE_MAIN_VIEW, BluetoothMainViewClass))

typedef struct _BluetoothMainView BluetoothMainView;
typedef struct _BluetoothMainViewClass BluetoothMainViewClass;
typedef struct _BluetoothMainViewPrivate BluetoothMainViewPrivate;

#define BLUETOOTH_TYPE_DEVICE_ROW (bluetooth_device_row_get_type ())
#define BLUETOOTH_DEVICE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_TYPE_DEVICE_ROW, BluetoothDeviceRow))
#define BLUETOOTH_DEVICE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BLUETOOTH_TYPE_DEVICE_ROW, BluetoothDeviceRowClass))
#define BLUETOOTH_IS_DEVICE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_TYPE_DEVICE_ROW))
#define BLUETOOTH_IS_DEVICE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BLUETOOTH_TYPE_DEVICE_ROW))
#define BLUETOOTH_DEVICE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BLUETOOTH_TYPE_DEVICE_ROW, BluetoothDeviceRowClass))

typedef struct _BluetoothDeviceRow BluetoothDeviceRow;
typedef struct _BluetoothDeviceRowClass BluetoothDeviceRowClass;
typedef struct _BluetoothDeviceRowPrivate BluetoothDeviceRowPrivate;

#define BLUETOOTH_SERVICES_TYPE_DEVICE (bluetooth_services_device_get_type ())
#define BLUETOOTH_SERVICES_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_SERVICES_TYPE_DEVICE, BluetoothServicesDevice))
#define BLUETOOTH_SERVICES_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_SERVICES_TYPE_DEVICE))
#define BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BLUETOOTH_SERVICES_TYPE_DEVICE, BluetoothServicesDeviceIface))

typedef struct _BluetoothServicesDevice BluetoothServicesDevice;
typedef struct _BluetoothServicesDeviceIface BluetoothServicesDeviceIface;

#define BLUETOOTH_SERVICES_TYPE_DEVICE_PROXY (bluetooth_services_device_proxy_get_type ())

#define TYPE_BLUEZ_ERROR (bluez_error_get_type ())

#define BLUETOOTH_SERVICES_TYPE_AGENT (bluetooth_services_agent_get_type ())
#define BLUETOOTH_SERVICES_AGENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_SERVICES_TYPE_AGENT, BluetoothServicesAgent))
#define BLUETOOTH_SERVICES_AGENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BLUETOOTH_SERVICES_TYPE_AGENT, BluetoothServicesAgentClass))
#define BLUETOOTH_SERVICES_IS_AGENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_SERVICES_TYPE_AGENT))
#define BLUETOOTH_SERVICES_IS_AGENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BLUETOOTH_SERVICES_TYPE_AGENT))
#define BLUETOOTH_SERVICES_AGENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BLUETOOTH_SERVICES_TYPE_AGENT, BluetoothServicesAgentClass))

typedef struct _BluetoothServicesAgent BluetoothServicesAgent;
typedef struct _BluetoothServicesAgentClass BluetoothServicesAgentClass;
typedef struct _BluetoothServicesAgentPrivate BluetoothServicesAgentPrivate;

#define BLUETOOTH_SERVICES_TYPE_AGENT_MANAGER (bluetooth_services_agent_manager_get_type ())
#define BLUETOOTH_SERVICES_AGENT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_SERVICES_TYPE_AGENT_MANAGER, BluetoothServicesAgentManager))
#define BLUETOOTH_SERVICES_IS_AGENT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_SERVICES_TYPE_AGENT_MANAGER))
#define BLUETOOTH_SERVICES_AGENT_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BLUETOOTH_SERVICES_TYPE_AGENT_MANAGER, BluetoothServicesAgentManagerIface))

typedef struct _BluetoothServicesAgentManager BluetoothServicesAgentManager;
typedef struct _BluetoothServicesAgentManagerIface BluetoothServicesAgentManagerIface;

#define BLUETOOTH_SERVICES_TYPE_AGENT_MANAGER_PROXY (bluetooth_services_agent_manager_proxy_get_type ())

#define BLUETOOTH_SERVICES_TYPE_OBJECT_MANAGER (bluetooth_services_object_manager_get_type ())
#define BLUETOOTH_SERVICES_OBJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_SERVICES_TYPE_OBJECT_MANAGER, BluetoothServicesObjectManager))
#define BLUETOOTH_SERVICES_OBJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BLUETOOTH_SERVICES_TYPE_OBJECT_MANAGER, BluetoothServicesObjectManagerClass))
#define BLUETOOTH_SERVICES_IS_OBJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_SERVICES_TYPE_OBJECT_MANAGER))
#define BLUETOOTH_SERVICES_IS_OBJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BLUETOOTH_SERVICES_TYPE_OBJECT_MANAGER))
#define BLUETOOTH_SERVICES_OBJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BLUETOOTH_SERVICES_TYPE_OBJECT_MANAGER, BluetoothServicesObjectManagerClass))

typedef struct _BluetoothServicesObjectManager BluetoothServicesObjectManager;
typedef struct _BluetoothServicesObjectManagerClass BluetoothServicesObjectManagerClass;
typedef struct _BluetoothServicesObjectManagerPrivate BluetoothServicesObjectManagerPrivate;

#define BLUETOOTH_SERVICES_TYPE_ADAPTER (bluetooth_services_adapter_get_type ())
#define BLUETOOTH_SERVICES_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_SERVICES_TYPE_ADAPTER, BluetoothServicesAdapter))
#define BLUETOOTH_SERVICES_IS_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_SERVICES_TYPE_ADAPTER))
#define BLUETOOTH_SERVICES_ADAPTER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BLUETOOTH_SERVICES_TYPE_ADAPTER, BluetoothServicesAdapterIface))

typedef struct _BluetoothServicesAdapter BluetoothServicesAdapter;
typedef struct _BluetoothServicesAdapterIface BluetoothServicesAdapterIface;

#define BLUETOOTH_SERVICES_TYPE_ADAPTER_PROXY (bluetooth_services_adapter_proxy_get_type ())

struct _PairDialog {
	GraniteMessageDialog parent_instance;
	PairDialogPrivate * priv;
};

struct _PairDialogClass {
	GraniteMessageDialogClass parent_class;
};

struct _BluetoothPlug {
	SwitchboardPlug parent_instance;
	BluetoothPlugPrivate * priv;
};

struct _BluetoothPlugClass {
	SwitchboardPlugClass parent_class;
};

struct _BluetoothMainView {
	SwitchboardSettingsPage parent_instance;
	BluetoothMainViewPrivate * priv;
};

struct _BluetoothMainViewClass {
	SwitchboardSettingsPageClass parent_class;
};

struct _BluetoothDeviceRow {
	GtkListBoxRow parent_instance;
	BluetoothDeviceRowPrivate * priv;
};

struct _BluetoothDeviceRowClass {
	GtkListBoxRowClass parent_class;
};

struct _BluetoothServicesDeviceIface {
	GTypeInterface parent_iface;
	void (*cancel_pairing) (BluetoothServicesDevice* self, GError** error);
	void (*connect) (BluetoothServicesDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*connect_finish) (BluetoothServicesDevice* self, GAsyncResult* _res_, GError** error);
	void (*connect_profile) (BluetoothServicesDevice* self, const gchar* UUID, GError** error);
	void (*disconnect) (BluetoothServicesDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*disconnect_finish) (BluetoothServicesDevice* self, GAsyncResult* _res_, GError** error);
	void (*disconnect_profile) (BluetoothServicesDevice* self, const gchar* UUID, GError** error);
	void (*pair) (BluetoothServicesDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*pair_finish) (BluetoothServicesDevice* self, GAsyncResult* _res_, GError** error);
	gchar** (*get_UUIDs) (BluetoothServicesDevice* self, gint* result_length1);
	gboolean (*get_blocked) (BluetoothServicesDevice* self);
	void (*set_blocked) (BluetoothServicesDevice* self, gboolean value);
	gboolean (*get_connected) (BluetoothServicesDevice* self);
	gboolean (*get_legacy_pairing) (BluetoothServicesDevice* self);
	gboolean (*get_paired) (BluetoothServicesDevice* self);
	gboolean (*get_trusted) (BluetoothServicesDevice* self);
	void (*set_trusted) (BluetoothServicesDevice* self, gboolean value);
	gint16 (*get_RSSI) (BluetoothServicesDevice* self);
	char* (*get_adapter) (BluetoothServicesDevice* self);
	gchar* (*get_address) (BluetoothServicesDevice* self);
	gchar* (*get_alias) (BluetoothServicesDevice* self);
	void (*set_alias) (BluetoothServicesDevice* self, const gchar* value);
	gchar* (*get_icon) (BluetoothServicesDevice* self);
	gchar* (*get_modalias) (BluetoothServicesDevice* self);
	gchar* (*get_name) (BluetoothServicesDevice* self);
	guint16 (*get_appearance) (BluetoothServicesDevice* self);
	guint32 (*get_class) (BluetoothServicesDevice* self);
};

typedef enum  {
	BLUEZ_ERROR_REJECTED,
	BLUEZ_ERROR_CANCELED
} BluezError;
#define BLUEZ_ERROR bluez_error_quark ()

struct _BluetoothServicesAgent {
	GObject parent_instance;
	BluetoothServicesAgentPrivate * priv;
};

struct _BluetoothServicesAgentClass {
	GObjectClass parent_class;
};

struct _BluetoothServicesAgentManagerIface {
	GTypeInterface parent_iface;
	void (*register_agent) (BluetoothServicesAgentManager* self, const char* agent, const gchar* capability, GError** error);
	void (*request_default_agent) (BluetoothServicesAgentManager* self, const char* agent, GError** error);
	void (*unregister_agent) (BluetoothServicesAgentManager* self, const char* agent, GError** error);
};

struct _BluetoothServicesObjectManager {
	GObject parent_instance;
	BluetoothServicesObjectManagerPrivate * priv;
};

struct _BluetoothServicesObjectManagerClass {
	GObjectClass parent_class;
};

struct _BluetoothServicesAdapterIface {
	GTypeInterface parent_iface;
	void (*remove_device) (BluetoothServicesAdapter* self, const char* device, GError** error);
	void (*set_discovery_filter) (BluetoothServicesAdapter* self, GHashTable* properties, GError** error);
	void (*start_discovery) (BluetoothServicesAdapter* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*start_discovery_finish) (BluetoothServicesAdapter* self, GAsyncResult* _res_, GError** error);
	void (*stop_discovery) (BluetoothServicesAdapter* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*stop_discovery_finish) (BluetoothServicesAdapter* self, GAsyncResult* _res_, GError** error);
	gchar** (*get_UUIDs) (BluetoothServicesAdapter* self, gint* result_length1);
	gboolean (*get_discoverable) (BluetoothServicesAdapter* self);
	void (*set_discoverable) (BluetoothServicesAdapter* self, gboolean value);
	gboolean (*get_discovering) (BluetoothServicesAdapter* self);
	gboolean (*get_pairable) (BluetoothServicesAdapter* self);
	void (*set_pairable) (BluetoothServicesAdapter* self, gboolean value);
	gboolean (*get_powered) (BluetoothServicesAdapter* self);
	void (*set_powered) (BluetoothServicesAdapter* self, gboolean value);
	gchar* (*get_address) (BluetoothServicesAdapter* self);
	gchar* (*get_alias) (BluetoothServicesAdapter* self);
	void (*set_alias) (BluetoothServicesAdapter* self, const gchar* value);
	gchar* (*get_modalias) (BluetoothServicesAdapter* self);
	gchar* (*get_name) (BluetoothServicesAdapter* self);
	guint (*get_class) (BluetoothServicesAdapter* self);
	guint (*get_discoverable_timeout) (BluetoothServicesAdapter* self);
	guint (*get_pairable_timeout) (BluetoothServicesAdapter* self);
};

VALA_EXTERN GType pair_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PairDialog, g_object_unref)
VALA_EXTERN GType pair_dialog_auth_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PairDialog* pair_dialog_new_request_authorization (const char* object_path,
                                                   GtkWindow* main_window);
VALA_EXTERN PairDialog* pair_dialog_construct_request_authorization (GType object_type,
                                                         const char* object_path,
                                                         GtkWindow* main_window);
VALA_EXTERN PairDialog* pair_dialog_new_display_passkey (const char* object_path,
                                             guint32 passkey,
                                             guint16 entered,
                                             GtkWindow* main_window);
VALA_EXTERN PairDialog* pair_dialog_construct_display_passkey (GType object_type,
                                                   const char* object_path,
                                                   guint32 passkey,
                                                   guint16 entered,
                                                   GtkWindow* main_window);
VALA_EXTERN PairDialog* pair_dialog_new_request_confirmation (const char* object_path,
                                                  guint32 passkey,
                                                  GtkWindow* main_window);
VALA_EXTERN PairDialog* pair_dialog_construct_request_confirmation (GType object_type,
                                                        const char* object_path,
                                                        guint32 passkey,
                                                        GtkWindow* main_window);
VALA_EXTERN PairDialog* pair_dialog_new_display_pin_code (const char* object_path,
                                              const gchar* pincode,
                                              GtkWindow* main_window);
VALA_EXTERN PairDialog* pair_dialog_construct_display_pin_code (GType object_type,
                                                    const char* object_path,
                                                    const gchar* pincode,
                                                    GtkWindow* main_window);
VALA_EXTERN const char* pair_dialog_get_object_path (PairDialog* self);
VALA_EXTERN PairDialogAuthType pair_dialog_get_auth_type (PairDialog* self);
VALA_EXTERN const gchar* pair_dialog_get_passkey (PairDialog* self);
VALA_EXTERN gboolean pair_dialog_get_cancelled (PairDialog* self);
VALA_EXTERN void pair_dialog_set_cancelled (PairDialog* self,
                                gboolean value);
VALA_EXTERN GType bluetooth_plug_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothPlug, g_object_unref)
VALA_EXTERN BluetoothPlug* bluetooth_plug_new (void);
VALA_EXTERN BluetoothPlug* bluetooth_plug_construct (GType object_type);
VALA_EXTERN SwitchboardPlug* get_plug (GModule* module);
VALA_EXTERN GType bluetooth_main_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothMainView, g_object_unref)
VALA_EXTERN BluetoothMainView* bluetooth_main_view_new (void);
VALA_EXTERN BluetoothMainView* bluetooth_main_view_construct (GType object_type);
VALA_EXTERN GType bluetooth_device_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothDeviceRow, g_object_unref)
VALA_EXTERN GType bluetooth_services_device_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint bluetooth_services_device_register_object (void* object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error);
VALA_EXTERN GType bluetooth_services_device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothServicesDevice, g_object_unref)
VALA_EXTERN BluetoothDeviceRow* bluetooth_device_row_new (BluetoothServicesDevice* device);
VALA_EXTERN BluetoothDeviceRow* bluetooth_device_row_construct (GType object_type,
                                                    BluetoothServicesDevice* device);
VALA_EXTERN void bluetooth_device_row_on_activate (BluetoothDeviceRow* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN void bluetooth_device_row_on_activate_finish (BluetoothDeviceRow* self,
                                              GAsyncResult* _res_);
VALA_EXTERN BluetoothServicesDevice* bluetooth_device_row_get_device (BluetoothDeviceRow* self);
VALA_EXTERN GQuark bluez_error_quark (void);
VALA_EXTERN GType bluez_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType bluetooth_services_agent_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothServicesAgent, g_object_unref)
VALA_EXTERN guint bluetooth_services_agent_register_object (void* object,
                                                GDBusConnection* connection,
                                                const gchar* path,
                                                GError** error);
VALA_EXTERN BluetoothServicesAgent* bluetooth_services_agent_new (GtkWindow* main_window);
VALA_EXTERN BluetoothServicesAgent* bluetooth_services_agent_construct (GType object_type,
                                                            GtkWindow* main_window);
VALA_EXTERN char* bluetooth_services_agent_get_path (BluetoothServicesAgent* self);
VALA_EXTERN void bluetooth_services_agent_release (BluetoothServicesAgent* self,
                                       GError** error);
VALA_EXTERN void bluetooth_services_agent_request_pin_code (BluetoothServicesAgent* self,
                                                const char* device,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
VALA_EXTERN gchar* bluetooth_services_agent_request_pin_code_finish (BluetoothServicesAgent* self,
                                                         GAsyncResult* _res_,
                                                         GError** error);
VALA_EXTERN void bluetooth_services_agent_display_pin_code (BluetoothServicesAgent* self,
                                                const char* device,
                                                const gchar* pincode,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
VALA_EXTERN void bluetooth_services_agent_display_pin_code_finish (BluetoothServicesAgent* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
VALA_EXTERN void bluetooth_services_agent_request_passkey (BluetoothServicesAgent* self,
                                               const char* device,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN guint32 bluetooth_services_agent_request_passkey_finish (BluetoothServicesAgent* self,
                                                         GAsyncResult* _res_,
                                                         GError** error);
VALA_EXTERN void bluetooth_services_agent_display_passkey (BluetoothServicesAgent* self,
                                               const char* device,
                                               guint32 passkey,
                                               guint16 entered,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN void bluetooth_services_agent_display_passkey_finish (BluetoothServicesAgent* self,
                                                      GAsyncResult* _res_,
                                                      GError** error);
VALA_EXTERN void bluetooth_services_agent_request_confirmation (BluetoothServicesAgent* self,
                                                    const char* device,
                                                    guint32 passkey,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
VALA_EXTERN void bluetooth_services_agent_request_confirmation_finish (BluetoothServicesAgent* self,
                                                           GAsyncResult* _res_,
                                                           GError** error);
VALA_EXTERN void bluetooth_services_agent_request_authorization (BluetoothServicesAgent* self,
                                                     const char* device,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
VALA_EXTERN void bluetooth_services_agent_request_authorization_finish (BluetoothServicesAgent* self,
                                                            GAsyncResult* _res_,
                                                            GError** error);
VALA_EXTERN void bluetooth_services_agent_authorize_service (BluetoothServicesAgent* self,
                                                 const char* device_path,
                                                 const gchar* uuid,
                                                 GError** error);
VALA_EXTERN void bluetooth_services_agent_cancel (BluetoothServicesAgent* self,
                                      GError** error);
VALA_EXTERN gboolean bluetooth_services_agent_get_ready (BluetoothServicesAgent* self);
VALA_EXTERN GType bluetooth_services_agent_manager_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint bluetooth_services_agent_manager_register_object (void* object,
                                                        GDBusConnection* connection,
                                                        const gchar* path,
                                                        GError** error);
VALA_EXTERN GType bluetooth_services_agent_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothServicesAgentManager, g_object_unref)
VALA_EXTERN void bluetooth_services_agent_manager_register_agent (BluetoothServicesAgentManager* self,
                                                      const char* agent,
                                                      const gchar* capability,
                                                      GError** error);
VALA_EXTERN void bluetooth_services_agent_manager_request_default_agent (BluetoothServicesAgentManager* self,
                                                             const char* agent,
                                                             GError** error);
VALA_EXTERN void bluetooth_services_agent_manager_unregister_agent (BluetoothServicesAgentManager* self,
                                                        const char* agent,
                                                        GError** error);
VALA_EXTERN GType bluetooth_services_object_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothServicesObjectManager, g_object_unref)
VALA_EXTERN BluetoothServicesObjectManager* bluetooth_services_object_manager_get_default (void);
VALA_EXTERN void bluetooth_services_object_manager_check_discovering (BluetoothServicesObjectManager* self);
VALA_EXTERN void bluetooth_services_object_manager_check_discoverable (BluetoothServicesObjectManager* self);
VALA_EXTERN gchar* bluetooth_services_object_manager_get_name (BluetoothServicesObjectManager* self);
VALA_EXTERN GType bluetooth_services_adapter_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint bluetooth_services_adapter_register_object (void* object,
                                                  GDBusConnection* connection,
                                                  const gchar* path,
                                                  GError** error);
VALA_EXTERN GType bluetooth_services_adapter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothServicesAdapter, g_object_unref)
VALA_EXTERN GeeLinkedList* bluetooth_services_object_manager_get_adapters (BluetoothServicesObjectManager* self);
VALA_EXTERN GeeCollection* bluetooth_services_object_manager_get_devices (BluetoothServicesObjectManager* self);
VALA_EXTERN BluetoothServicesAdapter* bluetooth_services_object_manager_get_adapter_from_path (BluetoothServicesObjectManager* self,
                                                                                   const gchar* path);
VALA_EXTERN void bluetooth_services_object_manager_register_agent (BluetoothServicesObjectManager* self,
                                                       GtkWindow* window,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
VALA_EXTERN void bluetooth_services_object_manager_register_agent_finish (BluetoothServicesObjectManager* self,
                                                              GAsyncResult* _res_);
VALA_EXTERN void bluetooth_services_object_manager_unregister_agent (BluetoothServicesObjectManager* self,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
VALA_EXTERN void bluetooth_services_object_manager_unregister_agent_finish (BluetoothServicesObjectManager* self,
                                                                GAsyncResult* _res_);
VALA_EXTERN void bluetooth_services_object_manager_check_global_state (BluetoothServicesObjectManager* self);
VALA_EXTERN void bluetooth_services_object_manager_start_discovery (BluetoothServicesObjectManager* self,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
VALA_EXTERN void bluetooth_services_object_manager_start_discovery_finish (BluetoothServicesObjectManager* self,
                                                               GAsyncResult* _res_);
VALA_EXTERN void bluetooth_services_object_manager_stop_discovery (BluetoothServicesObjectManager* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
VALA_EXTERN void bluetooth_services_object_manager_stop_discovery_finish (BluetoothServicesObjectManager* self,
                                                              GAsyncResult* _res_);
VALA_EXTERN gboolean bluetooth_services_object_manager_get_connected (BluetoothServicesObjectManager* self);
VALA_EXTERN gboolean bluetooth_services_object_manager_get_global_state (BluetoothServicesObjectManager* self);
VALA_EXTERN void bluetooth_services_object_manager_set_global_state (BluetoothServicesObjectManager* self,
                                                         gboolean state,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
VALA_EXTERN void bluetooth_services_object_manager_set_global_state_finish (BluetoothServicesObjectManager* self,
                                                                GAsyncResult* _res_);
VALA_EXTERN gboolean bluetooth_services_object_manager_get_discoverable (BluetoothServicesObjectManager* self);
VALA_EXTERN void bluetooth_services_object_manager_set_discoverable (BluetoothServicesObjectManager* self,
                                                         gboolean value);
VALA_EXTERN gboolean bluetooth_services_object_manager_get_has_object (BluetoothServicesObjectManager* self);
VALA_EXTERN gboolean bluetooth_services_object_manager_get_retrieve_finished (BluetoothServicesObjectManager* self);
VALA_EXTERN gboolean bluetooth_services_object_manager_get_is_discovering (BluetoothServicesObjectManager* self);
VALA_EXTERN gboolean bluetooth_services_object_manager_get_is_powered (BluetoothServicesObjectManager* self);
VALA_EXTERN gboolean bluetooth_services_object_manager_get_is_connected (BluetoothServicesObjectManager* self);
VALA_EXTERN void bluetooth_services_device_cancel_pairing (BluetoothServicesDevice* self,
                                               GError** error);
VALA_EXTERN void bluetooth_services_device_connect (BluetoothServicesDevice* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void bluetooth_services_device_connect_finish (BluetoothServicesDevice* self,
                                               GAsyncResult* _res_,
                                               GError** error);
VALA_EXTERN void bluetooth_services_device_connect_profile (BluetoothServicesDevice* self,
                                                const gchar* UUID,
                                                GError** error);
VALA_EXTERN void bluetooth_services_device_disconnect (BluetoothServicesDevice* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN void bluetooth_services_device_disconnect_finish (BluetoothServicesDevice* self,
                                                  GAsyncResult* _res_,
                                                  GError** error);
VALA_EXTERN void bluetooth_services_device_disconnect_profile (BluetoothServicesDevice* self,
                                                   const gchar* UUID,
                                                   GError** error);
VALA_EXTERN void bluetooth_services_device_pair (BluetoothServicesDevice* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN void bluetooth_services_device_pair_finish (BluetoothServicesDevice* self,
                                            GAsyncResult* _res_,
                                            GError** error);
VALA_EXTERN gint bluetooth_services_device_compare (BluetoothServicesDevice* device1,
                                        BluetoothServicesDevice* device2);
VALA_EXTERN gchar** bluetooth_services_device_get_UUIDs (BluetoothServicesDevice* self,
                                             gint* result_length1);
VALA_EXTERN gboolean bluetooth_services_device_get_blocked (BluetoothServicesDevice* self);
VALA_EXTERN void bluetooth_services_device_set_blocked (BluetoothServicesDevice* self,
                                            gboolean value);
VALA_EXTERN gboolean bluetooth_services_device_get_connected (BluetoothServicesDevice* self);
VALA_EXTERN gboolean bluetooth_services_device_get_legacy_pairing (BluetoothServicesDevice* self);
VALA_EXTERN gboolean bluetooth_services_device_get_paired (BluetoothServicesDevice* self);
VALA_EXTERN gboolean bluetooth_services_device_get_trusted (BluetoothServicesDevice* self);
VALA_EXTERN void bluetooth_services_device_set_trusted (BluetoothServicesDevice* self,
                                            gboolean value);
VALA_EXTERN gint16 bluetooth_services_device_get_RSSI (BluetoothServicesDevice* self);
VALA_EXTERN char* bluetooth_services_device_get_adapter (BluetoothServicesDevice* self);
VALA_EXTERN gchar* bluetooth_services_device_get_address (BluetoothServicesDevice* self);
VALA_EXTERN gchar* bluetooth_services_device_get_alias (BluetoothServicesDevice* self);
VALA_EXTERN void bluetooth_services_device_set_alias (BluetoothServicesDevice* self,
                                          const gchar* value);
VALA_EXTERN gchar* bluetooth_services_device_get_icon (BluetoothServicesDevice* self);
VALA_EXTERN gchar* bluetooth_services_device_get_modalias (BluetoothServicesDevice* self);
VALA_EXTERN gchar* bluetooth_services_device_get_name (BluetoothServicesDevice* self);
VALA_EXTERN guint16 bluetooth_services_device_get_appearance (BluetoothServicesDevice* self);
VALA_EXTERN guint32 bluetooth_services_device_get_class (BluetoothServicesDevice* self);
VALA_EXTERN void bluetooth_services_adapter_remove_device (BluetoothServicesAdapter* self,
                                               const char* device,
                                               GError** error);
VALA_EXTERN void bluetooth_services_adapter_set_discovery_filter (BluetoothServicesAdapter* self,
                                                      GHashTable* properties,
                                                      GError** error);
VALA_EXTERN void bluetooth_services_adapter_start_discovery (BluetoothServicesAdapter* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN void bluetooth_services_adapter_start_discovery_finish (BluetoothServicesAdapter* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
VALA_EXTERN void bluetooth_services_adapter_stop_discovery (BluetoothServicesAdapter* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
VALA_EXTERN void bluetooth_services_adapter_stop_discovery_finish (BluetoothServicesAdapter* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
VALA_EXTERN gchar** bluetooth_services_adapter_get_UUIDs (BluetoothServicesAdapter* self,
                                              gint* result_length1);
VALA_EXTERN gboolean bluetooth_services_adapter_get_discoverable (BluetoothServicesAdapter* self);
VALA_EXTERN void bluetooth_services_adapter_set_discoverable (BluetoothServicesAdapter* self,
                                                  gboolean value);
VALA_EXTERN gboolean bluetooth_services_adapter_get_discovering (BluetoothServicesAdapter* self);
VALA_EXTERN gboolean bluetooth_services_adapter_get_pairable (BluetoothServicesAdapter* self);
VALA_EXTERN void bluetooth_services_adapter_set_pairable (BluetoothServicesAdapter* self,
                                              gboolean value);
VALA_EXTERN gboolean bluetooth_services_adapter_get_powered (BluetoothServicesAdapter* self);
VALA_EXTERN void bluetooth_services_adapter_set_powered (BluetoothServicesAdapter* self,
                                             gboolean value);
VALA_EXTERN gchar* bluetooth_services_adapter_get_address (BluetoothServicesAdapter* self);
VALA_EXTERN gchar* bluetooth_services_adapter_get_alias (BluetoothServicesAdapter* self);
VALA_EXTERN void bluetooth_services_adapter_set_alias (BluetoothServicesAdapter* self,
                                           const gchar* value);
VALA_EXTERN gchar* bluetooth_services_adapter_get_modalias (BluetoothServicesAdapter* self);
VALA_EXTERN gchar* bluetooth_services_adapter_get_name (BluetoothServicesAdapter* self);
VALA_EXTERN guint bluetooth_services_adapter_get_class (BluetoothServicesAdapter* self);
VALA_EXTERN guint bluetooth_services_adapter_get_discoverable_timeout (BluetoothServicesAdapter* self);
VALA_EXTERN guint bluetooth_services_adapter_get_pairable_timeout (BluetoothServicesAdapter* self);

G_END_DECLS

#endif
