/* TimeZoneGrid.c generated by valac 0.56.17, the Vala compiler
 * generated from TimeZoneGrid.vala, do not modify */

/*-
 * Copyright 2014-2024 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementaryos.org>
 */

#include "datetime.h"
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libical-glib/libical-glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <granite-7.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DATE_TIME_TIME_ZONE_GRID_0_PROPERTY,
	DATE_TIME_TIME_ZONE_GRID_TIME_ZONE_PROPERTY,
	DATE_TIME_TIME_ZONE_GRID_NUM_PROPERTIES
};
static GParamSpec* date_time_time_zone_grid_properties[DATE_TIME_TIME_ZONE_GRID_NUM_PROPERTIES];
typedef enum  {
	DATE_TIME_TIME_ZONE_GRID_CLOCK_FORMAT_24_H,
	DATE_TIME_TIME_ZONE_GRID_CLOCK_FORMAT_12_H
} DateTimeTimeZoneGridClockFormat;

#define DATE_TIME_TIME_ZONE_GRID_TYPE_CLOCK_FORMAT (date_time_time_zone_grid_clock_format_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gtk_expression_unref0(var) ((var == NULL) ? NULL : (var = (gtk_expression_unref (var), NULL)))
enum  {
	DATE_TIME_TIME_ZONE_GRID_REQUEST_TIMEZONE_CHANGE_SIGNAL,
	DATE_TIME_TIME_ZONE_GRID_NUM_SIGNALS
};
static guint date_time_time_zone_grid_signals[DATE_TIME_TIME_ZONE_GRID_NUM_SIGNALS] = {0};

struct _DateTimeTimeZoneGridPrivate {
	GtkDropDown* dropdown;
	GListStore* timezone_list;
	gchar* time_format;
	gchar* _time_zone;
};

static gint DateTimeTimeZoneGrid_private_offset;
static gpointer date_time_time_zone_grid_parent_class = NULL;

static GType date_time_time_zone_grid_clock_format_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gchar* date_time_time_zone_grid_get_timezone_name (ICalTimezone* timezone);
static void date_time_time_zone_grid_setup_factory (DateTimeTimeZoneGrid* self,
                                             GObject* object);
static void date_time_time_zone_grid_bind_factory (DateTimeTimeZoneGrid* self,
                                            GObject* object);
static gchar* date_time_time_zone_grid_seconds_to_utc_offset (DateTimeTimeZoneGrid* self,
                                                       gint seconds);
static GObject * date_time_time_zone_grid_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static gint _date_time_time_zone_grid______lambda4_ (DateTimeTimeZoneGrid* self,
                                              GObject* a,
                                              GObject* b);
static gint __date_time_time_zone_grid______lambda4__gcompare_data_func (gconstpointer a,
                                                                  gconstpointer b,
                                                                  gpointer self);
static void _date_time_time_zone_grid_setup_factory_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                                 GObject* object,
                                                                                 gpointer self);
static void _date_time_time_zone_grid_bind_factory_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                               GObject* object,
                                                                               gpointer self);
static void _date_time_time_zone_grid___lambda5_ (DateTimeTimeZoneGrid* self);
static void __date_time_time_zone_grid___lambda5__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void date_time_time_zone_grid_finalize (GObject * obj);
static GType date_time_time_zone_grid_get_type_once (void);
static void _vala_date_time_time_zone_grid_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_date_time_time_zone_grid_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);

static inline gpointer
date_time_time_zone_grid_get_instance_private (DateTimeTimeZoneGrid* self)
{
	return G_STRUCT_MEMBER_P (self, DateTimeTimeZoneGrid_private_offset);
}

static GType
date_time_time_zone_grid_clock_format_get_type_once (void)
{
	static const GEnumValue values[] = {{DATE_TIME_TIME_ZONE_GRID_CLOCK_FORMAT_24_H, "DATE_TIME_TIME_ZONE_GRID_CLOCK_FORMAT_24_H", "24-h"}, {DATE_TIME_TIME_ZONE_GRID_CLOCK_FORMAT_12_H, "DATE_TIME_TIME_ZONE_GRID_CLOCK_FORMAT_12_H", "12-h"}, {0, NULL, NULL}};
	GType date_time_time_zone_grid_clock_format_type_id;
	date_time_time_zone_grid_clock_format_type_id = g_enum_register_static ("DateTimeTimeZoneGridClockFormat", values);
	return date_time_time_zone_grid_clock_format_type_id;
}

static GType
date_time_time_zone_grid_clock_format_get_type (void)
{
	static volatile gsize date_time_time_zone_grid_clock_format_type_id__once = 0;
	if (g_once_init_enter (&date_time_time_zone_grid_clock_format_type_id__once)) {
		GType date_time_time_zone_grid_clock_format_type_id;
		date_time_time_zone_grid_clock_format_type_id = date_time_time_zone_grid_clock_format_get_type_once ();
		g_once_init_leave (&date_time_time_zone_grid_clock_format_type_id__once, date_time_time_zone_grid_clock_format_type_id);
	}
	return date_time_time_zone_grid_clock_format_type_id__once;
}

static gchar*
date_time_time_zone_grid_get_timezone_name (ICalTimezone* timezone)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (timezone != NULL, NULL);
	_tmp0_ = i_cal_timezone_get_display_name (timezone);
	_tmp1_ = date_time_parser_format_city (_ (_tmp0_));
	result = _tmp1_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
date_time_time_zone_grid_setup_factory (DateTimeTimeZoneGrid* self,
                                        GObject* object)
{
	GtkLabel* title = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* time = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp2_;
	GtkListItem* list_item = NULL;
	GtkListItem* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp0_);
	title = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	gtk_label_set_use_markup (_tmp1_, TRUE);
	g_object_ref_sink (_tmp1_);
	time = _tmp1_;
	gtk_widget_add_css_class ((GtkWidget*) time, GRANITE_STYLE_CLASS_DIM_LABEL);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp2_);
	box = _tmp2_;
	gtk_box_append (box, (GtkWidget*) title);
	gtk_box_append (box, (GtkWidget*) time);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL);
	list_item = _tmp3_;
	_tmp4_ = _g_object_ref0 (title);
	g_object_set_data_full ((GObject*) list_item, "title", _tmp4_, g_object_unref);
	_tmp5_ = _g_object_ref0 (time);
	g_object_set_data_full ((GObject*) list_item, "time", _tmp5_, g_object_unref);
	gtk_list_item_set_child (list_item, (GtkWidget*) box);
	_g_object_unref0 (list_item);
	_g_object_unref0 (box);
	_g_object_unref0 (time);
	_g_object_unref0 (title);
}

static GTimeZone*
vala_g_time_zone_new_identifier (const gchar* identifier,
                                 GError** error)
{
	GTimeZone* self;
	GError* _inner_error0_ = NULL;
	self = (GTimeZone*) g_time_zone_new_identifier (identifier);
	if (((GTimeZone*) self) == NULL) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (G_CONVERT_ERROR, G_CONVERT_ERROR_ILLEGAL_SEQUENCE, "Invalid identifier argument");
		_inner_error0_ = _tmp0_;
		g_propagate_error (error, _inner_error0_);
		_g_time_zone_unref0 (self);
		return NULL;
	}
	return self;
}

static void
date_time_time_zone_grid_bind_factory (DateTimeTimeZoneGrid* self,
                                       GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkListItem* _tmp0_;
	ICalTimezone* ical_timezone = NULL;
	GObject* _tmp1_;
	ICalTimezone* _tmp2_;
	gchar* localized_tz = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GtkLabel* title = NULL;
	gconstpointer _tmp5_;
	GtkLabel* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL);
	list_item = _tmp0_;
	_tmp1_ = gtk_list_item_get_item (list_item);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, i_cal_timezone_get_type (), ICalTimezone));
	ical_timezone = _tmp2_;
	_tmp3_ = i_cal_timezone_get_display_name (ical_timezone);
	_tmp4_ = g_strdup (_ (_tmp3_));
	localized_tz = _tmp4_;
	_tmp5_ = g_object_get_data ((GObject*) list_item, "title");
	_tmp6_ = _g_object_ref0 ((GtkLabel*) _tmp5_);
	title = _tmp6_;
	{
		GTimeZone* glib_timezone = NULL;
		const gchar* _tmp7_;
		GTimeZone* _tmp8_;
		GDateTime* datetime = NULL;
		GDateTime* _tmp9_;
		gint32 offset = 0;
		GDateTime* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GtkLabel* time = NULL;
		gconstpointer _tmp17_;
		GtkLabel* _tmp18_;
		GtkLabel* _tmp19_;
		GDateTime* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp7_ = i_cal_timezone_get_display_name (ical_timezone);
		_tmp8_ = vala_g_time_zone_new_identifier (_tmp7_, &_inner_error0_);
		glib_timezone = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = g_date_time_new_now (glib_timezone);
		datetime = _tmp9_;
		_tmp10_ = datetime;
		offset = g_time_zone_get_offset (glib_timezone, g_time_zone_find_interval (glib_timezone, G_TIME_TYPE_UNIVERSAL, g_date_time_to_unix (_tmp10_)));
		_tmp11_ = date_time_parser_format_city (localized_tz);
		_tmp12_ = _tmp11_;
		_tmp13_ = date_time_time_zone_grid_seconds_to_utc_offset (self, (gint) offset);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup_printf (_ ("%s (%s)"), _tmp12_, _tmp14_);
		_tmp16_ = _tmp15_;
		gtk_label_set_label (title, _tmp16_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_tmp17_ = g_object_get_data ((GObject*) list_item, "time");
		_tmp18_ = _g_object_ref0 ((GtkLabel*) _tmp17_);
		time = _tmp18_;
		_tmp19_ = time;
		_tmp20_ = datetime;
		_tmp21_ = self->priv->time_format;
		_tmp22_ = g_date_time_format (_tmp20_, _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strdup_printf ("<span font-features='tnum'>%s</span>", _tmp23_);
		_tmp25_ = _tmp24_;
		gtk_label_set_label (_tmp19_, _tmp25_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
		_g_object_unref0 (time);
		_g_date_time_unref0 (datetime);
		_g_time_zone_unref0 (glib_timezone);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp26_ = e;
		_tmp27_ = _tmp26_->message;
		g_warning ("TimeZoneGrid.vala:152: %s", _tmp27_);
		_tmp28_ = date_time_parser_format_city (localized_tz);
		_tmp29_ = _tmp28_;
		gtk_label_set_label (title, _tmp29_);
		_g_free0 (_tmp29_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (title);
		_g_free0 (localized_tz);
		_g_object_unref0 (ical_timezone);
		_g_object_unref0 (list_item);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (title);
	_g_free0 (localized_tz);
	_g_object_unref0 (ical_timezone);
	_g_object_unref0 (list_item);
}

static gchar*
date_time_time_zone_grid_seconds_to_utc_offset (DateTimeTimeZoneGrid* self,
                                                gint seconds)
{
	gint hours = 0;
	gint minutes = 0;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (seconds == 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (_ ("UTC"));
		result = _tmp0_;
		return result;
	}
	hours = seconds / 3600;
	minutes = (seconds % 3600) / 60;
	if (hours > 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup_printf (_ ("UTC +%i:%02i"), hours, minutes);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = g_strdup_printf (_ ("UTC −%i:%02i"), abs (hours), abs (minutes));
	result = _tmp2_;
	return result;
}

DateTimeTimeZoneGrid*
date_time_time_zone_grid_construct (GType object_type)
{
	DateTimeTimeZoneGrid * self = NULL;
	self = (DateTimeTimeZoneGrid*) g_object_new (object_type, NULL);
	return self;
}

DateTimeTimeZoneGrid*
date_time_time_zone_grid_new (void)
{
	return date_time_time_zone_grid_construct (DATE_TIME_TYPE_TIME_ZONE_GRID);
}

const gchar*
date_time_time_zone_grid_get_time_zone (DateTimeTimeZoneGrid* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_time_zone;
	result = _tmp0_;
	return result;
}

void
date_time_time_zone_grid_set_time_zone (DateTimeTimeZoneGrid* self,
                                        const gchar* value)
{
	gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GListStore* _tmp2_;
				GListStore* _tmp3_;
				GObject* _tmp4_;
				ICalTimezone* _tmp5_;
				const gchar* _tmp6_;
				gboolean _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->timezone_list;
				if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) _tmp2_))) {
					break;
				}
				_tmp3_ = self->priv->timezone_list;
				_tmp4_ = g_list_model_get_item ((GListModel*) _tmp3_, (guint) i);
				_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, i_cal_timezone_get_type (), ICalTimezone);
				_tmp6_ = i_cal_timezone_get_display_name (_tmp5_);
				_tmp7_ = g_strcmp0 (_tmp6_, value) == 0;
				_g_object_unref0 (_tmp5_);
				if (_tmp7_) {
					GtkDropDown* _tmp8_;
					_tmp8_ = self->priv->dropdown;
					gtk_drop_down_set_selected (_tmp8_, (guint) i);
					break;
				}
			}
		}
	}
	_tmp9_ = g_strdup (value);
	_g_free0 (self->priv->_time_zone);
	self->priv->_time_zone = _tmp9_;
	g_object_notify_by_pspec ((GObject *) self, date_time_time_zone_grid_properties[DATE_TIME_TIME_ZONE_GRID_TIME_ZONE_PROPERTY]);
}

static gint
_date_time_time_zone_grid______lambda4_ (DateTimeTimeZoneGrid* self,
                                         GObject* a,
                                         GObject* b)
{
	gchar* a_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* b_name = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = i_cal_timezone_get_display_name (G_TYPE_CHECK_INSTANCE_CAST (a, i_cal_timezone_get_type (), ICalTimezone));
	_tmp1_ = g_strdup (_tmp0_);
	a_name = _tmp1_;
	_tmp2_ = i_cal_timezone_get_display_name (G_TYPE_CHECK_INSTANCE_CAST (b, i_cal_timezone_get_type (), ICalTimezone));
	_tmp3_ = g_strdup (_tmp2_);
	b_name = _tmp3_;
	_tmp4_ = a_name;
	_tmp5_ = b_name;
	result = g_utf8_collate (_tmp4_, _tmp5_);
	_g_free0 (b_name);
	_g_free0 (a_name);
	return result;
}

static gint
__date_time_time_zone_grid______lambda4__gcompare_data_func (gconstpointer a,
                                                             gconstpointer b,
                                                             gpointer self)
{
	gint result;
	result = _date_time_time_zone_grid______lambda4_ ((DateTimeTimeZoneGrid*) self, (GObject*) a, (GObject*) b);
	return result;
}

static void
_date_time_time_zone_grid_setup_factory_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                            GObject* object,
                                                                            gpointer self)
{
	date_time_time_zone_grid_setup_factory ((DateTimeTimeZoneGrid*) self, object);
}

static void
_date_time_time_zone_grid_bind_factory_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                          GObject* object,
                                                                          gpointer self)
{
	date_time_time_zone_grid_bind_factory ((DateTimeTimeZoneGrid*) self, object);
}

static gpointer
_gtk_expression_ref0 (gpointer self)
{
	return self ? gtk_expression_ref (self) : NULL;
}

static void
_date_time_time_zone_grid___lambda5_ (DateTimeTimeZoneGrid* self)
{
	ICalTimezone* timezone = NULL;
	GtkDropDown* _tmp0_;
	GObject* _tmp1_;
	ICalTimezone* _tmp2_;
	ICalTimezone* _tmp3_;
	const gchar* _tmp4_;
	_tmp0_ = self->priv->dropdown;
	_tmp1_ = gtk_drop_down_get_selected_item (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, i_cal_timezone_get_type (), ICalTimezone));
	timezone = _tmp2_;
	_tmp3_ = timezone;
	_tmp4_ = i_cal_timezone_get_display_name (_tmp3_);
	g_signal_emit (self, date_time_time_zone_grid_signals[DATE_TIME_TIME_ZONE_GRID_REQUEST_TIMEZONE_CHANGE_SIGNAL], 0, _tmp4_);
	_g_object_unref0 (timezone);
}

static void
__date_time_time_zone_grid___lambda5__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	_date_time_time_zone_grid___lambda5_ ((DateTimeTimeZoneGrid*) self);
}

static GObject *
date_time_time_zone_grid_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DateTimeTimeZoneGrid * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	GListStore* _tmp3_;
	ICalArray* timezone_array = NULL;
	ICalArray* _tmp4_;
	ICalArray* _tmp5_;
	GtkCClosureExpression* expression = NULL;
	GtkExpression** _tmp13_;
	GtkCClosureExpression* _tmp14_;
	GtkSignalListItemFactory* list_factory = NULL;
	GtkSignalListItemFactory* _tmp15_;
	GtkSignalListItemFactory* _tmp16_;
	GtkSignalListItemFactory* _tmp17_;
	GListStore* _tmp18_;
	GListModel* _tmp19_;
	GtkCClosureExpression* _tmp20_;
	GtkExpression* _tmp21_;
	GtkSignalListItemFactory* _tmp22_;
	GtkListItemFactory* _tmp23_;
	GtkDropDown* _tmp24_ = NULL;
	GtkDropDown* _tmp25_;
	GtkDropDown* _tmp26_;
	parent_class = G_OBJECT_CLASS (date_time_time_zone_grid_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DATE_TIME_TYPE_TIME_ZONE_GRID, DateTimeTimeZoneGrid);
	_tmp0_ = g_settings_new ("org.gnome.desktop.interface");
	_tmp1_ = _tmp0_;
	_tmp2_ = granite_date_time_get_default_time_format (g_settings_get_enum (_tmp1_, "clock-format") == ((gint) DATE_TIME_TIME_ZONE_GRID_CLOCK_FORMAT_12_H), FALSE);
	_g_free0 (self->priv->time_format);
	self->priv->time_format = _tmp2_;
	_g_object_unref0 (_tmp1_);
	_tmp3_ = g_list_store_new (i_cal_timezone_get_type ());
	_g_object_unref0 (self->priv->timezone_list);
	self->priv->timezone_list = _tmp3_;
	_tmp4_ = i_cal_timezone_get_builtin_timezones ();
	_tmp5_ = _g_object_ref0 (_tmp4_);
	timezone_array = _tmp5_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				ICalArray* _tmp8_;
				GListStore* _tmp9_;
				ICalArray* _tmp10_;
				ICalTimezone* _tmp11_;
				ICalTimezone* _tmp12_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = timezone_array;
				if (!(i < i_cal_array_size (_tmp8_))) {
					break;
				}
				_tmp9_ = self->priv->timezone_list;
				_tmp10_ = timezone_array;
				_tmp11_ = i_cal_timezone_array_element_at (_tmp10_, (guint) i);
				_tmp12_ = _tmp11_;
				g_list_store_insert_sorted (_tmp9_, (GObject*) _tmp12_, __date_time_time_zone_grid______lambda4__gcompare_data_func, self);
				_g_object_unref0 (_tmp12_);
			}
		}
	}
	_tmp13_ = g_new0 (GtkExpression*, 0 + 1);
	_tmp14_ = (GtkCClosureExpression*) gtk_cclosure_expression_new (G_TYPE_STRING, NULL, 0, _tmp13_, (GCallback) date_time_time_zone_grid_get_timezone_name, NULL, NULL);
	expression = _tmp14_;
	_tmp15_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	list_factory = _tmp15_;
	_tmp16_ = list_factory;
	g_signal_connect_object (_tmp16_, "setup", (GCallback) _date_time_time_zone_grid_setup_factory_gtk_signal_list_item_factory_setup, self, 0);
	_tmp17_ = list_factory;
	g_signal_connect_object (_tmp17_, "bind", (GCallback) _date_time_time_zone_grid_bind_factory_gtk_signal_list_item_factory_bind, self, 0);
	_tmp18_ = self->priv->timezone_list;
	_tmp19_ = _g_object_ref0 ((GListModel*) _tmp18_);
	_tmp20_ = expression;
	_tmp21_ = _gtk_expression_ref0 ((GtkExpression*) _tmp20_);
	_tmp22_ = list_factory;
	_tmp23_ = _g_object_ref0 ((GtkListItemFactory*) _tmp22_);
	_tmp24_ = (GtkDropDown*) gtk_drop_down_new (_tmp19_, NULL);
	gtk_drop_down_set_enable_search (_tmp24_, TRUE);
	gtk_drop_down_set_expression (_tmp24_, _tmp21_);
	_gtk_expression_unref0 (_tmp21_);
	gtk_drop_down_set_factory (_tmp24_, _tmp23_);
	_g_object_unref0 (_tmp23_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp24_, TRUE);
	gtk_drop_down_set_search_match_mode (_tmp24_, GTK_STRING_FILTER_MATCH_MODE_SUBSTRING);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->dropdown);
	self->priv->dropdown = _tmp24_;
	_tmp25_ = self->priv->dropdown;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp25_);
	_tmp26_ = self->priv->dropdown;
	g_signal_connect_object ((GObject*) _tmp26_, "notify::selected", (GCallback) __date_time_time_zone_grid___lambda5__g_object_notify, self, 0);
	_g_object_unref0 (list_factory);
	_gtk_expression_unref0 (expression);
	_g_object_unref0 (timezone_array);
	return obj;
}

static void
date_time_time_zone_grid_class_init (DateTimeTimeZoneGridClass * klass,
                                     gpointer klass_data)
{
	date_time_time_zone_grid_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DateTimeTimeZoneGrid_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_date_time_time_zone_grid_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_date_time_time_zone_grid_set_property;
	G_OBJECT_CLASS (klass)->constructor = date_time_time_zone_grid_constructor;
	G_OBJECT_CLASS (klass)->finalize = date_time_time_zone_grid_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DATE_TIME_TIME_ZONE_GRID_TIME_ZONE_PROPERTY, date_time_time_zone_grid_properties[DATE_TIME_TIME_ZONE_GRID_TIME_ZONE_PROPERTY] = g_param_spec_string ("time-zone", "time-zone", "time-zone", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	date_time_time_zone_grid_signals[DATE_TIME_TIME_ZONE_GRID_REQUEST_TIMEZONE_CHANGE_SIGNAL] = g_signal_new ("request-timezone-change", DATE_TIME_TYPE_TIME_ZONE_GRID, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
date_time_time_zone_grid_instance_init (DateTimeTimeZoneGrid * self,
                                        gpointer klass)
{
	self->priv = date_time_time_zone_grid_get_instance_private (self);
}

static void
date_time_time_zone_grid_finalize (GObject * obj)
{
	DateTimeTimeZoneGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DATE_TIME_TYPE_TIME_ZONE_GRID, DateTimeTimeZoneGrid);
	i_cal_timezone_free_builtin_timezones ();
	_g_object_unref0 (self->priv->dropdown);
	_g_object_unref0 (self->priv->timezone_list);
	_g_free0 (self->priv->time_format);
	_g_free0 (self->priv->_time_zone);
	G_OBJECT_CLASS (date_time_time_zone_grid_parent_class)->finalize (obj);
}

static GType
date_time_time_zone_grid_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DateTimeTimeZoneGridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) date_time_time_zone_grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DateTimeTimeZoneGrid), 0, (GInstanceInitFunc) date_time_time_zone_grid_instance_init, NULL };
	GType date_time_time_zone_grid_type_id;
	date_time_time_zone_grid_type_id = g_type_register_static (gtk_box_get_type (), "DateTimeTimeZoneGrid", &g_define_type_info, 0);
	DateTimeTimeZoneGrid_private_offset = g_type_add_instance_private (date_time_time_zone_grid_type_id, sizeof (DateTimeTimeZoneGridPrivate));
	return date_time_time_zone_grid_type_id;
}

GType
date_time_time_zone_grid_get_type (void)
{
	static volatile gsize date_time_time_zone_grid_type_id__once = 0;
	if (g_once_init_enter (&date_time_time_zone_grid_type_id__once)) {
		GType date_time_time_zone_grid_type_id;
		date_time_time_zone_grid_type_id = date_time_time_zone_grid_get_type_once ();
		g_once_init_leave (&date_time_time_zone_grid_type_id__once, date_time_time_zone_grid_type_id);
	}
	return date_time_time_zone_grid_type_id__once;
}

static void
_vala_date_time_time_zone_grid_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	DateTimeTimeZoneGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DATE_TIME_TYPE_TIME_ZONE_GRID, DateTimeTimeZoneGrid);
	switch (property_id) {
		case DATE_TIME_TIME_ZONE_GRID_TIME_ZONE_PROPERTY:
		g_value_set_string (value, date_time_time_zone_grid_get_time_zone (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_date_time_time_zone_grid_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	DateTimeTimeZoneGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DATE_TIME_TYPE_TIME_ZONE_GRID, DateTimeTimeZoneGrid);
	switch (property_id) {
		case DATE_TIME_TIME_ZONE_GRID_TIME_ZONE_PROPERTY:
		date_time_time_zone_grid_set_time_zone (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

