// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             (unknown)
// source: internal/plugin/grpc_stdio.proto

package plugin

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	GRPCStdio_StreamStdio_FullMethodName = "/plugin.GRPCStdio/StreamStdio"
)

// GRPCStdioClient is the client API for GRPCStdio service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GRPCStdioClient interface {
	// StreamStdio returns a stream that contains all the stdout/stderr.
	// This RPC endpoint must only be called ONCE. Once stdio data is consumed
	// it is not sent again.
	//
	// Callers should connect early to prevent blocking on the plugin process.
	StreamStdio(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (GRPCStdio_StreamStdioClient, error)
}

type gRPCStdioClient struct {
	cc grpc.ClientConnInterface
}

func NewGRPCStdioClient(cc grpc.ClientConnInterface) GRPCStdioClient {
	return &gRPCStdioClient{cc}
}

func (c *gRPCStdioClient) StreamStdio(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (GRPCStdio_StreamStdioClient, error) {
	stream, err := c.cc.NewStream(ctx, &GRPCStdio_ServiceDesc.Streams[0], GRPCStdio_StreamStdio_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &gRPCStdioStreamStdioClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type GRPCStdio_StreamStdioClient interface {
	Recv() (*StdioData, error)
	grpc.ClientStream
}

type gRPCStdioStreamStdioClient struct {
	grpc.ClientStream
}

func (x *gRPCStdioStreamStdioClient) Recv() (*StdioData, error) {
	m := new(StdioData)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// GRPCStdioServer is the server API for GRPCStdio service.
// All implementations should embed UnimplementedGRPCStdioServer
// for forward compatibility
type GRPCStdioServer interface {
	// StreamStdio returns a stream that contains all the stdout/stderr.
	// This RPC endpoint must only be called ONCE. Once stdio data is consumed
	// it is not sent again.
	//
	// Callers should connect early to prevent blocking on the plugin process.
	StreamStdio(*emptypb.Empty, GRPCStdio_StreamStdioServer) error
}

// UnimplementedGRPCStdioServer should be embedded to have forward compatible implementations.
type UnimplementedGRPCStdioServer struct {
}

func (UnimplementedGRPCStdioServer) StreamStdio(*emptypb.Empty, GRPCStdio_StreamStdioServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamStdio not implemented")
}

// UnsafeGRPCStdioServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GRPCStdioServer will
// result in compilation errors.
type UnsafeGRPCStdioServer interface {
	mustEmbedUnimplementedGRPCStdioServer()
}

func RegisterGRPCStdioServer(s grpc.ServiceRegistrar, srv GRPCStdioServer) {
	s.RegisterService(&GRPCStdio_ServiceDesc, srv)
}

func _GRPCStdio_StreamStdio_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(emptypb.Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(GRPCStdioServer).StreamStdio(m, &gRPCStdioStreamStdioServer{stream})
}

type GRPCStdio_StreamStdioServer interface {
	Send(*StdioData) error
	grpc.ServerStream
}

type gRPCStdioStreamStdioServer struct {
	grpc.ServerStream
}

func (x *gRPCStdioStreamStdioServer) Send(m *StdioData) error {
	return x.ServerStream.SendMsg(m)
}

// GRPCStdio_ServiceDesc is the grpc.ServiceDesc for GRPCStdio service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GRPCStdio_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "plugin.GRPCStdio",
	HandlerType: (*GRPCStdioServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamStdio",
			Handler:       _GRPCStdio_StreamStdio_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "internal/plugin/grpc_stdio.proto",
}
