// python wrapper for ttkBottleneckDistance
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkBottleneckDistance.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkBottleneckDistance(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkBottleneckDistance_ClassNew(); }


static PyObject *
PyttkBottleneckDistance_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkBottleneckDistance::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkBottleneckDistance::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkBottleneckDistance *tempr = ttkBottleneckDistance::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkBottleneckDistance *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkBottleneckDistance::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkBottleneckDistance::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkBottleneckDistance::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_SetTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTolerance(temp0);
    }
    else
    {
      op->ttkBottleneckDistance::SetTolerance(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_GetTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTolerance() :
      op->ttkBottleneckDistance::GetTolerance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_SetPX(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPX");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPX(temp0);
    }
    else
    {
      op->ttkBottleneckDistance::SetPX(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_GetPX(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPX");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetPX() :
      op->ttkBottleneckDistance::GetPX());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_SetPY(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPY");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPY(temp0);
    }
    else
    {
      op->ttkBottleneckDistance::SetPY(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_GetPY(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPY");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetPY() :
      op->ttkBottleneckDistance::GetPY());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_SetPZ(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPZ");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPZ(temp0);
    }
    else
    {
      op->ttkBottleneckDistance::SetPZ(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_GetPZ(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPZ");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetPZ() :
      op->ttkBottleneckDistance::GetPZ());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_SetPE(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPE");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPE(temp0);
    }
    else
    {
      op->ttkBottleneckDistance::SetPE(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_GetPE(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPE");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetPE() :
      op->ttkBottleneckDistance::GetPE());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_SetPS(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPS");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPS(temp0);
    }
    else
    {
      op->ttkBottleneckDistance::SetPS(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_GetPS(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPS");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetPS() :
      op->ttkBottleneckDistance::GetPS());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_SetUseOutputMatching(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseOutputMatching");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseOutputMatching(temp0);
    }
    else
    {
      op->ttkBottleneckDistance::SetUseOutputMatching(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_GetUseOutputMatching(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseOutputMatching");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseOutputMatching() :
      op->ttkBottleneckDistance::GetUseOutputMatching());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_SetWassersteinMetric(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWassersteinMetric");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWassersteinMetric(temp0);
    }
    else
    {
      op->ttkBottleneckDistance::SetWassersteinMetric(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_GetWassersteinMetric(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWassersteinMetric");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetWassersteinMetric() :
      op->ttkBottleneckDistance::GetWassersteinMetric());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_SetDistanceAlgorithm(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDistanceAlgorithm");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDistanceAlgorithm(temp0);
    }
    else
    {
      op->ttkBottleneckDistance::SetDistanceAlgorithm(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_GetDistanceAlgorithm(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDistanceAlgorithm");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetDistanceAlgorithm() :
      op->ttkBottleneckDistance::GetDistanceAlgorithm());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_SetPVAlgorithm(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPVAlgorithm");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPVAlgorithm(temp0);
    }
    else
    {
      op->ttkBottleneckDistance::SetPVAlgorithm(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_GetPVAlgorithm(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPVAlgorithm");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPVAlgorithm() :
      op->ttkBottleneckDistance::GetPVAlgorithm());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_SetUseGeometricSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseGeometricSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseGeometricSpacing(temp0);
    }
    else
    {
      op->ttkBottleneckDistance::SetUseGeometricSpacing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_GetUseGeometricSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseGeometricSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseGeometricSpacing() :
      op->ttkBottleneckDistance::GetUseGeometricSpacing());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_SetSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSpacing(temp0);
    }
    else
    {
      op->ttkBottleneckDistance::SetSpacing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_GetSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetSpacing() :
      op->ttkBottleneckDistance::GetSpacing());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_Getresult(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getresult");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->Getresult() :
      op->ttkBottleneckDistance::Getresult());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_FillInputPortInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillInputPortInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  int temp0;
  vtkInformation *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkInformation"))
  {
    int tempr = (ap.IsBound() ?
      op->FillInputPortInformation(temp0, temp1) :
      op->ttkBottleneckDistance::FillInputPortInformation(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkBottleneckDistance_FillOutputPortInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FillOutputPortInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkBottleneckDistance *op = static_cast<ttkBottleneckDistance *>(vp);

  int temp0;
  vtkInformation *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkInformation"))
  {
    int tempr = (ap.IsBound() ?
      op->FillOutputPortInformation(temp0, temp1) :
      op->ttkBottleneckDistance::FillOutputPortInformation(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkBottleneckDistance_Methods[] = {
  {"IsTypeOf", PyttkBottleneckDistance_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkBottleneckDistance_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkBottleneckDistance_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkBottleneckDistance\nC++: static ttkBottleneckDistance *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkBottleneckDistance_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkBottleneckDistance\nC++: ttkBottleneckDistance *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkBottleneckDistance_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkBottleneckDistance_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetTolerance", PyttkBottleneckDistance_SetTolerance, METH_VARARGS,
   "SetTolerance(self, _arg:float) -> None\nC++: virtual void SetTolerance(double _arg)\n\n"},
  {"GetTolerance", PyttkBottleneckDistance_GetTolerance, METH_VARARGS,
   "GetTolerance(self) -> float\nC++: virtual double GetTolerance()\n\n"},
  {"SetPX", PyttkBottleneckDistance_SetPX, METH_VARARGS,
   "SetPX(self, _arg:float) -> None\nC++: virtual void SetPX(double _arg)\n\n"},
  {"GetPX", PyttkBottleneckDistance_GetPX, METH_VARARGS,
   "GetPX(self) -> float\nC++: virtual double GetPX()\n\n"},
  {"SetPY", PyttkBottleneckDistance_SetPY, METH_VARARGS,
   "SetPY(self, _arg:float) -> None\nC++: virtual void SetPY(double _arg)\n\n"},
  {"GetPY", PyttkBottleneckDistance_GetPY, METH_VARARGS,
   "GetPY(self) -> float\nC++: virtual double GetPY()\n\n"},
  {"SetPZ", PyttkBottleneckDistance_SetPZ, METH_VARARGS,
   "SetPZ(self, _arg:float) -> None\nC++: virtual void SetPZ(double _arg)\n\n"},
  {"GetPZ", PyttkBottleneckDistance_GetPZ, METH_VARARGS,
   "GetPZ(self) -> float\nC++: virtual double GetPZ()\n\n"},
  {"SetPE", PyttkBottleneckDistance_SetPE, METH_VARARGS,
   "SetPE(self, _arg:float) -> None\nC++: virtual void SetPE(double _arg)\n\n"},
  {"GetPE", PyttkBottleneckDistance_GetPE, METH_VARARGS,
   "GetPE(self) -> float\nC++: virtual double GetPE()\n\n"},
  {"SetPS", PyttkBottleneckDistance_SetPS, METH_VARARGS,
   "SetPS(self, _arg:float) -> None\nC++: virtual void SetPS(double _arg)\n\n"},
  {"GetPS", PyttkBottleneckDistance_GetPS, METH_VARARGS,
   "GetPS(self) -> float\nC++: virtual double GetPS()\n\n"},
  {"SetUseOutputMatching", PyttkBottleneckDistance_SetUseOutputMatching, METH_VARARGS,
   "SetUseOutputMatching(self, _arg:bool) -> None\nC++: virtual void SetUseOutputMatching(bool _arg)\n\n"},
  {"GetUseOutputMatching", PyttkBottleneckDistance_GetUseOutputMatching, METH_VARARGS,
   "GetUseOutputMatching(self) -> bool\nC++: virtual bool GetUseOutputMatching()\n\n"},
  {"SetWassersteinMetric", PyttkBottleneckDistance_SetWassersteinMetric, METH_VARARGS,
   "SetWassersteinMetric(self, _arg:str) -> None\nC++: virtual void SetWassersteinMetric(const std::string &_arg)\n\n"},
  {"GetWassersteinMetric", PyttkBottleneckDistance_GetWassersteinMetric, METH_VARARGS,
   "GetWassersteinMetric(self) -> str\nC++: virtual std::string GetWassersteinMetric()\n\n"},
  {"SetDistanceAlgorithm", PyttkBottleneckDistance_SetDistanceAlgorithm, METH_VARARGS,
   "SetDistanceAlgorithm(self, _arg:str) -> None\nC++: virtual void SetDistanceAlgorithm(const std::string &_arg)\n\n"},
  {"GetDistanceAlgorithm", PyttkBottleneckDistance_GetDistanceAlgorithm, METH_VARARGS,
   "GetDistanceAlgorithm(self) -> str\nC++: virtual std::string GetDistanceAlgorithm()\n\n"},
  {"SetPVAlgorithm", PyttkBottleneckDistance_SetPVAlgorithm, METH_VARARGS,
   "SetPVAlgorithm(self, _arg:int) -> None\nC++: virtual void SetPVAlgorithm(int _arg)\n\n"},
  {"GetPVAlgorithm", PyttkBottleneckDistance_GetPVAlgorithm, METH_VARARGS,
   "GetPVAlgorithm(self) -> int\nC++: virtual int GetPVAlgorithm()\n\n"},
  {"SetUseGeometricSpacing", PyttkBottleneckDistance_SetUseGeometricSpacing, METH_VARARGS,
   "SetUseGeometricSpacing(self, _arg:bool) -> None\nC++: virtual void SetUseGeometricSpacing(bool _arg)\n\n"},
  {"GetUseGeometricSpacing", PyttkBottleneckDistance_GetUseGeometricSpacing, METH_VARARGS,
   "GetUseGeometricSpacing(self) -> bool\nC++: virtual bool GetUseGeometricSpacing()\n\n"},
  {"SetSpacing", PyttkBottleneckDistance_SetSpacing, METH_VARARGS,
   "SetSpacing(self, _arg:float) -> None\nC++: virtual void SetSpacing(double _arg)\n\n"},
  {"GetSpacing", PyttkBottleneckDistance_GetSpacing, METH_VARARGS,
   "GetSpacing(self) -> float\nC++: virtual double GetSpacing()\n\n"},
  {"Getresult", PyttkBottleneckDistance_Getresult, METH_VARARGS,
   "Getresult(self) -> float\nC++: double Getresult()\n\n"},
  {"FillInputPortInformation", PyttkBottleneckDistance_FillInputPortInformation, METH_VARARGS,
   "FillInputPortInformation(self, port:int, info:vtkInformation)\n    -> int\nC++: int FillInputPortInformation(int port, vtkInformation *info)\n    override;\n\nThis method specifies the required input object data types of the\nfilter by adding the vtkAlgorithm::INPUT_REQUIRED_DATA_TYPE() key\nto the port information.\n\nThis method has to be overridden to specify the required input\ndata types.\n"},
  {"FillOutputPortInformation", PyttkBottleneckDistance_FillOutputPortInformation, METH_VARARGS,
   "FillOutputPortInformation(self, port:int, info:vtkInformation)\n    -> int\nC++: int FillOutputPortInformation(int port, vtkInformation *info)\n     override;\n\nThis method specifies in the port information the data type of\nthe output objects. It is possible to either explicitly specify a\ntype by adding a vtkDataObject::DATA_TYPE_NAME() key, or to pass\na type of an input port to an output port by adding the\nttkAlgorithm::SAME_DATA_TYPE_AS_INPUT_PORT() key.\n\nThis method has to be overridden to specify the data types of the\noutputs.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkBottleneckDistance_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("tolerance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkBottleneckDistance_GetTolerance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkBottleneckDistance_SetTolerance(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkBottleneckDistance_SetTolerance(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTolerance/SetTolerance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("px"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkBottleneckDistance_GetPX(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkBottleneckDistance_SetPX(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkBottleneckDistance_SetPX(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPX/SetPX\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("py"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkBottleneckDistance_GetPY(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkBottleneckDistance_SetPY(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkBottleneckDistance_SetPY(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPY/SetPY\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pz"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkBottleneckDistance_GetPZ(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkBottleneckDistance_SetPZ(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkBottleneckDistance_SetPZ(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPZ/SetPZ\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pe"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkBottleneckDistance_GetPE(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkBottleneckDistance_SetPE(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkBottleneckDistance_SetPE(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPE/SetPE\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("ps"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkBottleneckDistance_GetPS(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkBottleneckDistance_SetPS(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkBottleneckDistance_SetPS(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPS/SetPS\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_output_matching"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkBottleneckDistance_GetUseOutputMatching(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkBottleneckDistance_SetUseOutputMatching(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkBottleneckDistance_SetUseOutputMatching(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseOutputMatching/SetUseOutputMatching\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("wasserstein_metric"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkBottleneckDistance_GetWassersteinMetric(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkBottleneckDistance_SetWassersteinMetric(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkBottleneckDistance_SetWassersteinMetric(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWassersteinMetric/SetWassersteinMetric\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("distance_algorithm"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkBottleneckDistance_GetDistanceAlgorithm(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkBottleneckDistance_SetDistanceAlgorithm(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkBottleneckDistance_SetDistanceAlgorithm(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDistanceAlgorithm/SetDistanceAlgorithm\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pv_algorithm"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkBottleneckDistance_GetPVAlgorithm(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkBottleneckDistance_SetPVAlgorithm(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkBottleneckDistance_SetPVAlgorithm(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPVAlgorithm/SetPVAlgorithm\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_geometric_spacing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkBottleneckDistance_GetUseGeometricSpacing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkBottleneckDistance_SetUseGeometricSpacing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkBottleneckDistance_SetUseGeometricSpacing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseGeometricSpacing/SetUseGeometricSpacing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("spacing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkBottleneckDistance_GetSpacing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkBottleneckDistance_SetSpacing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkBottleneckDistance_SetSpacing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSpacing/SetSpacing\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkBottleneckDistance_Doc =
  "ttkBottleneckDistance - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Maxime Soler <soler.maxime@total.com>\\date The Date Here.\n\n"
  "TTK VTK-filter that wraps the bottleneckDistance processing package.\n\n"
  "VTK wrapping code for the ttk::BottleneckDistance package.\n\n"
  "\\param Input Input scalar field (vtkDataSet)\n"
  "\\param Output Output scalar field (vtkDataSet)\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the corresponding ParaView state file example for a usage example\n"
  "within a VTK pipeline.\n\n"
  "\\sa ttk::BottleneckDistance\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkBottleneckDistance_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkBottleneckDistance.ttkBottleneckDistance", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkBottleneckDistance_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkBottleneckDistance_StaticNew()
{
  return ttkBottleneckDistance::New();
}

PyObject *PyttkBottleneckDistance_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkBottleneckDistance_Type, PyttkBottleneckDistance_Methods,
    "ttkBottleneckDistance",
 &PyttkBottleneckDistance_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkBottleneckDistance_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkBottleneckDistance(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkBottleneckDistance_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkBottleneckDistance", o) != 0)
  {
    Py_DECREF(o);
  }

}

