/** @file
 * VirtualBox API class wrapper code for IKeyboard.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_KEYBOARD

#include "KeyboardWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(KeyboardWrap)

//
// IKeyboard properties
//

STDMETHODIMP KeyboardWrap::COMGETTER(KeyboardLEDs)(ComSafeArrayOut(KeyboardLED_T, aKeyboardLEDs))
{
    LogRelFlow(("{%p} %s: enter aKeyboardLEDs=%p\n", this, "Keyboard::getKeyboardLEDs", aKeyboardLEDs));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aKeyboardLEDs);
        ArrayOutConverter<KeyboardLED_T> TmpKeyboardLEDs(ComSafeArrayOutArg(aKeyboardLEDs));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_GET_KEYBOARDLEDS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getKeyboardLEDs(TmpKeyboardLEDs.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_GET_KEYBOARDLEDS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpKeyboardLEDs.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_GET_KEYBOARDLEDS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_GET_KEYBOARDLEDS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aKeyboardLEDs=%zu hrc=%Rhrc\n", this, "Keyboard::getKeyboardLEDs", ComSafeArraySize(*aKeyboardLEDs), hrc));
    return hrc;
}

STDMETHODIMP KeyboardWrap::COMGETTER(EventSource)(IEventSource **aEventSource)
{
    LogRelFlow(("{%p} %s: enter aEventSource=%p\n", this, "Keyboard::getEventSource", aEventSource));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEventSource);
        ComTypeOutConverter<IEventSource> TmpEventSource(aEventSource);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_GET_EVENTSOURCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEventSource(TmpEventSource.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_GET_EVENTSOURCE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpEventSource.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_GET_EVENTSOURCE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_GET_EVENTSOURCE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEventSource=%p hrc=%Rhrc\n", this, "Keyboard::getEventSource", *aEventSource, hrc));
    return hrc;
}

STDMETHODIMP KeyboardWrap::COMGETTER(InternalAndReservedAttribute1IKeyboard)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP KeyboardWrap::COMGETTER(InternalAndReservedAttribute2IKeyboard)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP KeyboardWrap::COMGETTER(InternalAndReservedAttribute3IKeyboard)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP KeyboardWrap::COMGETTER(InternalAndReservedAttribute4IKeyboard)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IKeyboard methods
//

STDMETHODIMP KeyboardWrap::PutScancode(LONG aScancode)
{
    LogRelFlow(("{%p} %s: enter aScancode=%RI32\n", this, "Keyboard::putScancode", aScancode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_PUTSCANCODE_ENTER(this, aScancode);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = putScancode(aScancode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_PUTSCANCODE_RETURN(this, hrc, 0 /*normal*/, aScancode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_PUTSCANCODE_RETURN(this, hrc, 1 /*hrc exception*/, aScancode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_PUTSCANCODE_RETURN(this, hrc, 9 /*unhandled exception*/, aScancode);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Keyboard::putScancode", hrc));
    return hrc;
}

STDMETHODIMP KeyboardWrap::PutScancodes(ComSafeArrayIn(LONG, aScancodes),
                                        ULONG *aCodesStored)
{
    LogRelFlow(("{%p} %s: enter aScancodes=%zu aCodesStored=%p\n", this, "Keyboard::putScancodes", aScancodes, aCodesStored));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCodesStored);


        ArrayInConverter<LONG> TmpScancodes(ComSafeArrayInArg(aScancodes));
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_PUTSCANCODES_ENTER(this, (uint32_t)TmpScancodes.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = putScancodes(TmpScancodes.array(),
                               aCodesStored);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_PUTSCANCODES_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpScancodes.array().size(), NULL /*for now*/, *aCodesStored);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_PUTSCANCODES_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, *aCodesStored);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_PUTSCANCODES_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, *aCodesStored);
#endif
    }

    LogRelFlow(("{%p} %s: leave aCodesStored=%RU32 hrc=%Rhrc\n", this, "Keyboard::putScancodes", *aCodesStored, hrc));
    return hrc;
}

STDMETHODIMP KeyboardWrap::PutCAD()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Keyboard::putCAD"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_PUTCAD_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = putCAD();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_PUTCAD_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_PUTCAD_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_PUTCAD_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Keyboard::putCAD", hrc));
    return hrc;
}

STDMETHODIMP KeyboardWrap::ReleaseKeys()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Keyboard::releaseKeys"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_RELEASEKEYS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = releaseKeys();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_RELEASEKEYS_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_RELEASEKEYS_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_RELEASEKEYS_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Keyboard::releaseKeys", hrc));
    return hrc;
}

STDMETHODIMP KeyboardWrap::PutUsageCode(LONG aUsageCode,
                                        LONG aUsagePage,
                                        BOOL aKeyRelease)
{
    LogRelFlow(("{%p} %s: enter aUsageCode=%RI32 aUsagePage=%RI32 aKeyRelease=%RTbool\n", this, "Keyboard::putUsageCode", aUsageCode, aUsagePage, aKeyRelease));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_PUTUSAGECODE_ENTER(this, aUsageCode, aUsagePage, aKeyRelease != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = putUsageCode(aUsageCode,
                               aUsagePage,
                               aKeyRelease != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_PUTUSAGECODE_RETURN(this, hrc, 0 /*normal*/, aUsageCode, aUsagePage, aKeyRelease != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_PUTUSAGECODE_RETURN(this, hrc, 1 /*hrc exception*/, aUsageCode, aUsagePage, aKeyRelease != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_KEYBOARD_PUTUSAGECODE_RETURN(this, hrc, 9 /*unhandled exception*/, aUsageCode, aUsagePage, aKeyRelease != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Keyboard::putUsageCode", hrc));
    return hrc;
}

STDMETHODIMP KeyboardWrap::InternalAndReservedMethod1IKeyboard()
{
    return E_NOTIMPL;
}

STDMETHODIMP KeyboardWrap::InternalAndReservedMethod2IKeyboard()
{
    return E_NOTIMPL;
}

STDMETHODIMP KeyboardWrap::InternalAndReservedMethod3IKeyboard()
{
    return E_NOTIMPL;
}

STDMETHODIMP KeyboardWrap::InternalAndReservedMethod4IKeyboard()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(KeyboardWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(KeyboardWrap, IKeyboard)
#endif // VBOX_WITH_XPCOM
