#include <wayland-client-protocol-extra.hpp>

using namespace wayland;
using namespace wayland::detail;

const wl_interface* presentation_interface_destroy_request[0] = {
};

const wl_interface* presentation_interface_feedback_request[2] = {
  &surface_interface,
  &presentation_feedback_interface,
};

const wl_interface* presentation_interface_clock_id_event[1] = {
  nullptr,
};

const wl_message presentation_interface_requests[2] = {
  {
    "destroy",
    "",
    presentation_interface_destroy_request,
  },
  {
    "feedback",
    "on",
    presentation_interface_feedback_request,
  },
};

const wl_message presentation_interface_events[1] = {
  {
    "clock_id",
    "u",
    presentation_interface_clock_id_event,
  },
};

const wl_interface wayland::detail::presentation_interface =
  {
    "wp_presentation",
    1,
    2,
    presentation_interface_requests,
    1,
    presentation_interface_events,
  };

const wl_interface* presentation_feedback_interface_sync_output_event[1] = {
  &output_interface,
};

const wl_interface* presentation_feedback_interface_presented_event[7] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* presentation_feedback_interface_discarded_event[0] = {
};

const wl_message presentation_feedback_interface_requests[0] = {
};

const wl_message presentation_feedback_interface_events[3] = {
  {
    "sync_output",
    "o",
    presentation_feedback_interface_sync_output_event,
  },
  {
    "presented",
    "uuuuuuu",
    presentation_feedback_interface_presented_event,
  },
  {
    "discarded",
    "",
    presentation_feedback_interface_discarded_event,
  },
};

const wl_interface wayland::detail::presentation_feedback_interface =
  {
    "wp_presentation_feedback",
    1,
    0,
    presentation_feedback_interface_requests,
    3,
    presentation_feedback_interface_events,
  };

const wl_interface* viewporter_interface_destroy_request[0] = {
};

const wl_interface* viewporter_interface_get_viewport_request[2] = {
  &viewport_interface,
  &surface_interface,
};

const wl_message viewporter_interface_requests[2] = {
  {
    "destroy",
    "",
    viewporter_interface_destroy_request,
  },
  {
    "get_viewport",
    "no",
    viewporter_interface_get_viewport_request,
  },
};

const wl_message viewporter_interface_events[0] = {
};

const wl_interface wayland::detail::viewporter_interface =
  {
    "wp_viewporter",
    1,
    2,
    viewporter_interface_requests,
    0,
    viewporter_interface_events,
  };

const wl_interface* viewport_interface_destroy_request[0] = {
};

const wl_interface* viewport_interface_set_source_request[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* viewport_interface_set_destination_request[2] = {
  nullptr,
  nullptr,
};

const wl_message viewport_interface_requests[3] = {
  {
    "destroy",
    "",
    viewport_interface_destroy_request,
  },
  {
    "set_source",
    "ffff",
    viewport_interface_set_source_request,
  },
  {
    "set_destination",
    "ii",
    viewport_interface_set_destination_request,
  },
};

const wl_message viewport_interface_events[0] = {
};

const wl_interface wayland::detail::viewport_interface =
  {
    "wp_viewport",
    1,
    3,
    viewport_interface_requests,
    0,
    viewport_interface_events,
  };

const wl_interface* xdg_wm_base_interface_destroy_request[0] = {
};

const wl_interface* xdg_wm_base_interface_create_positioner_request[1] = {
  &xdg_positioner_interface,
};

const wl_interface* xdg_wm_base_interface_get_xdg_surface_request[2] = {
  &xdg_surface_interface,
  &surface_interface,
};

const wl_interface* xdg_wm_base_interface_pong_request[1] = {
  nullptr,
};

const wl_interface* xdg_wm_base_interface_ping_event[1] = {
  nullptr,
};

const wl_message xdg_wm_base_interface_requests[4] = {
  {
    "destroy",
    "",
    xdg_wm_base_interface_destroy_request,
  },
  {
    "create_positioner",
    "n",
    xdg_wm_base_interface_create_positioner_request,
  },
  {
    "get_xdg_surface",
    "no",
    xdg_wm_base_interface_get_xdg_surface_request,
  },
  {
    "pong",
    "u",
    xdg_wm_base_interface_pong_request,
  },
};

const wl_message xdg_wm_base_interface_events[1] = {
  {
    "ping",
    "u",
    xdg_wm_base_interface_ping_event,
  },
};

const wl_interface wayland::detail::xdg_wm_base_interface =
  {
    "xdg_wm_base",
    4,
    4,
    xdg_wm_base_interface_requests,
    1,
    xdg_wm_base_interface_events,
  };

const wl_interface* xdg_positioner_interface_destroy_request[0] = {
};

const wl_interface* xdg_positioner_interface_set_size_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* xdg_positioner_interface_set_anchor_rect_request[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* xdg_positioner_interface_set_anchor_request[1] = {
  nullptr,
};

const wl_interface* xdg_positioner_interface_set_gravity_request[1] = {
  nullptr,
};

const wl_interface* xdg_positioner_interface_set_constraint_adjustment_request[1] = {
  nullptr,
};

const wl_interface* xdg_positioner_interface_set_offset_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* xdg_positioner_interface_set_reactive_request[0] = {
};

const wl_interface* xdg_positioner_interface_set_parent_size_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* xdg_positioner_interface_set_parent_configure_request[1] = {
  nullptr,
};

const wl_message xdg_positioner_interface_requests[10] = {
  {
    "destroy",
    "",
    xdg_positioner_interface_destroy_request,
  },
  {
    "set_size",
    "ii",
    xdg_positioner_interface_set_size_request,
  },
  {
    "set_anchor_rect",
    "iiii",
    xdg_positioner_interface_set_anchor_rect_request,
  },
  {
    "set_anchor",
    "u",
    xdg_positioner_interface_set_anchor_request,
  },
  {
    "set_gravity",
    "u",
    xdg_positioner_interface_set_gravity_request,
  },
  {
    "set_constraint_adjustment",
    "u",
    xdg_positioner_interface_set_constraint_adjustment_request,
  },
  {
    "set_offset",
    "ii",
    xdg_positioner_interface_set_offset_request,
  },
  {
    "set_reactive",
    "3",
    xdg_positioner_interface_set_reactive_request,
  },
  {
    "set_parent_size",
    "3ii",
    xdg_positioner_interface_set_parent_size_request,
  },
  {
    "set_parent_configure",
    "3u",
    xdg_positioner_interface_set_parent_configure_request,
  },
};

const wl_message xdg_positioner_interface_events[0] = {
};

const wl_interface wayland::detail::xdg_positioner_interface =
  {
    "xdg_positioner",
    4,
    10,
    xdg_positioner_interface_requests,
    0,
    xdg_positioner_interface_events,
  };

const wl_interface* xdg_surface_interface_destroy_request[0] = {
};

const wl_interface* xdg_surface_interface_get_toplevel_request[1] = {
  &xdg_toplevel_interface,
};

const wl_interface* xdg_surface_interface_get_popup_request[3] = {
  &xdg_popup_interface,
  &xdg_surface_interface,
  &xdg_positioner_interface,
};

const wl_interface* xdg_surface_interface_set_window_geometry_request[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* xdg_surface_interface_ack_configure_request[1] = {
  nullptr,
};

const wl_interface* xdg_surface_interface_configure_event[1] = {
  nullptr,
};

const wl_message xdg_surface_interface_requests[5] = {
  {
    "destroy",
    "",
    xdg_surface_interface_destroy_request,
  },
  {
    "get_toplevel",
    "n",
    xdg_surface_interface_get_toplevel_request,
  },
  {
    "get_popup",
    "n?oo",
    xdg_surface_interface_get_popup_request,
  },
  {
    "set_window_geometry",
    "iiii",
    xdg_surface_interface_set_window_geometry_request,
  },
  {
    "ack_configure",
    "u",
    xdg_surface_interface_ack_configure_request,
  },
};

const wl_message xdg_surface_interface_events[1] = {
  {
    "configure",
    "u",
    xdg_surface_interface_configure_event,
  },
};

const wl_interface wayland::detail::xdg_surface_interface =
  {
    "xdg_surface",
    4,
    5,
    xdg_surface_interface_requests,
    1,
    xdg_surface_interface_events,
  };

const wl_interface* xdg_toplevel_interface_destroy_request[0] = {
};

const wl_interface* xdg_toplevel_interface_set_parent_request[1] = {
  &xdg_toplevel_interface,
};

const wl_interface* xdg_toplevel_interface_set_title_request[1] = {
  nullptr,
};

const wl_interface* xdg_toplevel_interface_set_app_id_request[1] = {
  nullptr,
};

const wl_interface* xdg_toplevel_interface_show_window_menu_request[4] = {
  &seat_interface,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* xdg_toplevel_interface_move_request[2] = {
  &seat_interface,
  nullptr,
};

const wl_interface* xdg_toplevel_interface_resize_request[3] = {
  &seat_interface,
  nullptr,
  nullptr,
};

const wl_interface* xdg_toplevel_interface_set_max_size_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* xdg_toplevel_interface_set_min_size_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* xdg_toplevel_interface_set_maximized_request[0] = {
};

const wl_interface* xdg_toplevel_interface_unset_maximized_request[0] = {
};

const wl_interface* xdg_toplevel_interface_set_fullscreen_request[1] = {
  &output_interface,
};

const wl_interface* xdg_toplevel_interface_unset_fullscreen_request[0] = {
};

const wl_interface* xdg_toplevel_interface_set_minimized_request[0] = {
};

const wl_interface* xdg_toplevel_interface_configure_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* xdg_toplevel_interface_close_event[0] = {
};

const wl_interface* xdg_toplevel_interface_configure_bounds_event[2] = {
  nullptr,
  nullptr,
};

const wl_message xdg_toplevel_interface_requests[14] = {
  {
    "destroy",
    "",
    xdg_toplevel_interface_destroy_request,
  },
  {
    "set_parent",
    "?o",
    xdg_toplevel_interface_set_parent_request,
  },
  {
    "set_title",
    "s",
    xdg_toplevel_interface_set_title_request,
  },
  {
    "set_app_id",
    "s",
    xdg_toplevel_interface_set_app_id_request,
  },
  {
    "show_window_menu",
    "ouii",
    xdg_toplevel_interface_show_window_menu_request,
  },
  {
    "move",
    "ou",
    xdg_toplevel_interface_move_request,
  },
  {
    "resize",
    "ouu",
    xdg_toplevel_interface_resize_request,
  },
  {
    "set_max_size",
    "ii",
    xdg_toplevel_interface_set_max_size_request,
  },
  {
    "set_min_size",
    "ii",
    xdg_toplevel_interface_set_min_size_request,
  },
  {
    "set_maximized",
    "",
    xdg_toplevel_interface_set_maximized_request,
  },
  {
    "unset_maximized",
    "",
    xdg_toplevel_interface_unset_maximized_request,
  },
  {
    "set_fullscreen",
    "?o",
    xdg_toplevel_interface_set_fullscreen_request,
  },
  {
    "unset_fullscreen",
    "",
    xdg_toplevel_interface_unset_fullscreen_request,
  },
  {
    "set_minimized",
    "",
    xdg_toplevel_interface_set_minimized_request,
  },
};

const wl_message xdg_toplevel_interface_events[3] = {
  {
    "configure",
    "iia",
    xdg_toplevel_interface_configure_event,
  },
  {
    "close",
    "",
    xdg_toplevel_interface_close_event,
  },
  {
    "configure_bounds",
    "4ii",
    xdg_toplevel_interface_configure_bounds_event,
  },
};

const wl_interface wayland::detail::xdg_toplevel_interface =
  {
    "xdg_toplevel",
    4,
    14,
    xdg_toplevel_interface_requests,
    3,
    xdg_toplevel_interface_events,
  };

const wl_interface* xdg_popup_interface_destroy_request[0] = {
};

const wl_interface* xdg_popup_interface_grab_request[2] = {
  &seat_interface,
  nullptr,
};

const wl_interface* xdg_popup_interface_reposition_request[2] = {
  &xdg_positioner_interface,
  nullptr,
};

const wl_interface* xdg_popup_interface_configure_event[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* xdg_popup_interface_popup_done_event[0] = {
};

const wl_interface* xdg_popup_interface_repositioned_event[1] = {
  nullptr,
};

const wl_message xdg_popup_interface_requests[3] = {
  {
    "destroy",
    "",
    xdg_popup_interface_destroy_request,
  },
  {
    "grab",
    "ou",
    xdg_popup_interface_grab_request,
  },
  {
    "reposition",
    "3ou",
    xdg_popup_interface_reposition_request,
  },
};

const wl_message xdg_popup_interface_events[3] = {
  {
    "configure",
    "iiii",
    xdg_popup_interface_configure_event,
  },
  {
    "popup_done",
    "",
    xdg_popup_interface_popup_done_event,
  },
  {
    "repositioned",
    "3u",
    xdg_popup_interface_repositioned_event,
  },
};

const wl_interface wayland::detail::xdg_popup_interface =
  {
    "xdg_popup",
    4,
    3,
    xdg_popup_interface_requests,
    3,
    xdg_popup_interface_events,
  };

presentation_t::presentation_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&presentation_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return presentation_t(p); });
}

presentation_t::presentation_t()
{
  set_interface(&presentation_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return presentation_t(p); });
}

presentation_t::presentation_t(wp_presentation *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&presentation_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return presentation_t(p); });
}

presentation_t::presentation_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&presentation_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return presentation_t(p); });
}

presentation_t presentation_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string presentation_t::interface_name = "wp_presentation";

presentation_t::operator wp_presentation*() const
{
  return reinterpret_cast<wp_presentation*> (c_ptr());
}

presentation_feedback_t presentation_t::feedback(surface_t const& surface)
{
  proxy_t p = marshal_constructor(1U, &presentation_feedback_interface, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr, nullptr);
  return presentation_feedback_t(p);
}


std::function<void(uint32_t)> &presentation_t::on_clock_id()
{
  return std::static_pointer_cast<events_t>(get_events())->clock_id;
}

int presentation_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->clock_id) events->clock_id(args[0].get<uint32_t>());
      break;
    }
  return 0;
}


presentation_feedback_t::presentation_feedback_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&presentation_feedback_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return presentation_feedback_t(p); });
}

presentation_feedback_t::presentation_feedback_t()
{
  set_interface(&presentation_feedback_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return presentation_feedback_t(p); });
}

presentation_feedback_t::presentation_feedback_t(wp_presentation_feedback *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&presentation_feedback_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return presentation_feedback_t(p); });
}

presentation_feedback_t::presentation_feedback_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&presentation_feedback_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return presentation_feedback_t(p); });
}

presentation_feedback_t presentation_feedback_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string presentation_feedback_t::interface_name = "wp_presentation_feedback";

presentation_feedback_t::operator wp_presentation_feedback*() const
{
  return reinterpret_cast<wp_presentation_feedback*> (c_ptr());
}

std::function<void(output_t)> &presentation_feedback_t::on_sync_output()
{
  return std::static_pointer_cast<events_t>(get_events())->sync_output;
}

std::function<void(uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, presentation_feedback_kind)> &presentation_feedback_t::on_presented()
{
  return std::static_pointer_cast<events_t>(get_events())->presented;
}

std::function<void()> &presentation_feedback_t::on_discarded()
{
  return std::static_pointer_cast<events_t>(get_events())->discarded;
}

int presentation_feedback_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->sync_output) events->sync_output(output_t(args[0].get<proxy_t>()));
      break;
    case 1:
      if(events->presented) events->presented(args[0].get<uint32_t>(), args[1].get<uint32_t>(), args[2].get<uint32_t>(), args[3].get<uint32_t>(), args[4].get<uint32_t>(), args[5].get<uint32_t>(), presentation_feedback_kind(args[6].get<uint32_t>()));
      break;
    case 2:
      if(events->discarded) events->discarded();
      break;
    }
  return 0;
}
const bitfield<4, 1> presentation_feedback_kind::vsync{0x1};
const bitfield<4, 1> presentation_feedback_kind::hw_clock{0x2};
const bitfield<4, 1> presentation_feedback_kind::hw_completion{0x4};
const bitfield<4, 1> presentation_feedback_kind::zero_copy{0x8};


viewporter_t::viewporter_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&viewporter_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return viewporter_t(p); });
}

viewporter_t::viewporter_t()
{
  set_interface(&viewporter_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return viewporter_t(p); });
}

viewporter_t::viewporter_t(wp_viewporter *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&viewporter_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return viewporter_t(p); });
}

viewporter_t::viewporter_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&viewporter_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return viewporter_t(p); });
}

viewporter_t viewporter_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string viewporter_t::interface_name = "wp_viewporter";

viewporter_t::operator wp_viewporter*() const
{
  return reinterpret_cast<wp_viewporter*> (c_ptr());
}

viewport_t viewporter_t::get_viewport(surface_t const& surface)
{
  proxy_t p = marshal_constructor(1U, &viewport_interface, nullptr, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
  return viewport_t(p);
}


int viewporter_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}


viewport_t::viewport_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&viewport_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return viewport_t(p); });
}

viewport_t::viewport_t()
{
  set_interface(&viewport_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return viewport_t(p); });
}

viewport_t::viewport_t(wp_viewport *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&viewport_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return viewport_t(p); });
}

viewport_t::viewport_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&viewport_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return viewport_t(p); });
}

viewport_t viewport_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string viewport_t::interface_name = "wp_viewport";

viewport_t::operator wp_viewport*() const
{
  return reinterpret_cast<wp_viewport*> (c_ptr());
}

void viewport_t::set_source(double x, double y, double width, double height)
{
  marshal(1U, x, y, width, height);
}


void viewport_t::set_destination(int32_t width, int32_t height)
{
  marshal(2U, width, height);
}


int viewport_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}


xdg_wm_base_t::xdg_wm_base_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&xdg_wm_base_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_wm_base_t(p); });
}

xdg_wm_base_t::xdg_wm_base_t()
{
  set_interface(&xdg_wm_base_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_wm_base_t(p); });
}

xdg_wm_base_t::xdg_wm_base_t(xdg_wm_base *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&xdg_wm_base_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_wm_base_t(p); });
}

xdg_wm_base_t::xdg_wm_base_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&xdg_wm_base_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_wm_base_t(p); });
}

xdg_wm_base_t xdg_wm_base_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string xdg_wm_base_t::interface_name = "xdg_wm_base";

xdg_wm_base_t::operator xdg_wm_base*() const
{
  return reinterpret_cast<xdg_wm_base*> (c_ptr());
}

xdg_positioner_t xdg_wm_base_t::create_positioner()
{
  proxy_t p = marshal_constructor(1U, &xdg_positioner_interface, nullptr);
  return xdg_positioner_t(p);
}


xdg_surface_t xdg_wm_base_t::get_xdg_surface(surface_t const& surface)
{
  proxy_t p = marshal_constructor(2U, &xdg_surface_interface, nullptr, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
  return xdg_surface_t(p);
}


void xdg_wm_base_t::pong(uint32_t serial)
{
  marshal(3U, serial);
}


std::function<void(uint32_t)> &xdg_wm_base_t::on_ping()
{
  return std::static_pointer_cast<events_t>(get_events())->ping;
}

int xdg_wm_base_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->ping) events->ping(args[0].get<uint32_t>());
      break;
    }
  return 0;
}


xdg_positioner_t::xdg_positioner_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&xdg_positioner_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_positioner_t(p); });
}

xdg_positioner_t::xdg_positioner_t()
{
  set_interface(&xdg_positioner_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_positioner_t(p); });
}

xdg_positioner_t::xdg_positioner_t(xdg_positioner *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&xdg_positioner_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_positioner_t(p); });
}

xdg_positioner_t::xdg_positioner_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&xdg_positioner_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_positioner_t(p); });
}

xdg_positioner_t xdg_positioner_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string xdg_positioner_t::interface_name = "xdg_positioner";

xdg_positioner_t::operator xdg_positioner*() const
{
  return reinterpret_cast<xdg_positioner*> (c_ptr());
}

void xdg_positioner_t::set_size(int32_t width, int32_t height)
{
  marshal(1U, width, height);
}


void xdg_positioner_t::set_anchor_rect(int32_t x, int32_t y, int32_t width, int32_t height)
{
  marshal(2U, x, y, width, height);
}


void xdg_positioner_t::set_anchor(xdg_positioner_anchor const& anchor)
{
  marshal(3U, static_cast<uint32_t>(anchor));
}


void xdg_positioner_t::set_gravity(xdg_positioner_gravity const& gravity)
{
  marshal(4U, static_cast<uint32_t>(gravity));
}


void xdg_positioner_t::set_constraint_adjustment(xdg_positioner_constraint_adjustment const& constraint_adjustment)
{
  marshal(5U, static_cast<uint32_t>(constraint_adjustment));
}


void xdg_positioner_t::set_offset(int32_t x, int32_t y)
{
  marshal(6U, x, y);
}


void xdg_positioner_t::set_reactive()
{
  marshal(7U);
}

bool xdg_positioner_t::can_set_reactive() const
{
  return (get_version() >= set_reactive_since_version);
}


void xdg_positioner_t::set_parent_size(int32_t parent_width, int32_t parent_height)
{
  marshal(8U, parent_width, parent_height);
}

bool xdg_positioner_t::can_set_parent_size() const
{
  return (get_version() >= set_parent_size_since_version);
}


void xdg_positioner_t::set_parent_configure(uint32_t serial)
{
  marshal(9U, serial);
}

bool xdg_positioner_t::can_set_parent_configure() const
{
  return (get_version() >= set_parent_configure_since_version);
}


int xdg_positioner_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}



const bitfield<6, 8> xdg_positioner_constraint_adjustment::none{0};
const bitfield<6, 8> xdg_positioner_constraint_adjustment::slide_x{1};
const bitfield<6, 8> xdg_positioner_constraint_adjustment::slide_y{2};
const bitfield<6, 8> xdg_positioner_constraint_adjustment::flip_x{4};
const bitfield<6, 8> xdg_positioner_constraint_adjustment::flip_y{8};
const bitfield<6, 8> xdg_positioner_constraint_adjustment::resize_x{16};
const bitfield<6, 8> xdg_positioner_constraint_adjustment::resize_y{32};


xdg_surface_t::xdg_surface_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&xdg_surface_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_surface_t(p); });
}

xdg_surface_t::xdg_surface_t()
{
  set_interface(&xdg_surface_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_surface_t(p); });
}

xdg_surface_t::xdg_surface_t(xdg_surface *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&xdg_surface_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_surface_t(p); });
}

xdg_surface_t::xdg_surface_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&xdg_surface_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_surface_t(p); });
}

xdg_surface_t xdg_surface_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string xdg_surface_t::interface_name = "xdg_surface";

xdg_surface_t::operator xdg_surface*() const
{
  return reinterpret_cast<xdg_surface*> (c_ptr());
}

xdg_toplevel_t xdg_surface_t::get_toplevel()
{
  proxy_t p = marshal_constructor(1U, &xdg_toplevel_interface, nullptr);
  return xdg_toplevel_t(p);
}


xdg_popup_t xdg_surface_t::get_popup(xdg_surface_t const& parent, xdg_positioner_t const& positioner)
{
  proxy_t p = marshal_constructor(2U, &xdg_popup_interface, nullptr, parent.proxy_has_object() ? reinterpret_cast<wl_object*>(parent.c_ptr()) : nullptr, positioner.proxy_has_object() ? reinterpret_cast<wl_object*>(positioner.c_ptr()) : nullptr);
  return xdg_popup_t(p);
}


void xdg_surface_t::set_window_geometry(int32_t x, int32_t y, int32_t width, int32_t height)
{
  marshal(3U, x, y, width, height);
}


void xdg_surface_t::ack_configure(uint32_t serial)
{
  marshal(4U, serial);
}


std::function<void(uint32_t)> &xdg_surface_t::on_configure()
{
  return std::static_pointer_cast<events_t>(get_events())->configure;
}

int xdg_surface_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->configure) events->configure(args[0].get<uint32_t>());
      break;
    }
  return 0;
}


xdg_toplevel_t::xdg_toplevel_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&xdg_toplevel_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_toplevel_t(p); });
}

xdg_toplevel_t::xdg_toplevel_t()
{
  set_interface(&xdg_toplevel_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_toplevel_t(p); });
}

xdg_toplevel_t::xdg_toplevel_t(xdg_toplevel *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&xdg_toplevel_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_toplevel_t(p); });
}

xdg_toplevel_t::xdg_toplevel_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&xdg_toplevel_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_toplevel_t(p); });
}

xdg_toplevel_t xdg_toplevel_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string xdg_toplevel_t::interface_name = "xdg_toplevel";

xdg_toplevel_t::operator xdg_toplevel*() const
{
  return reinterpret_cast<xdg_toplevel*> (c_ptr());
}

void xdg_toplevel_t::set_parent(xdg_toplevel_t const& parent)
{
  marshal(1U, parent.proxy_has_object() ? reinterpret_cast<wl_object*>(parent.c_ptr()) : nullptr);
}


void xdg_toplevel_t::set_title(std::string const& title)
{
  marshal(2U, title);
}


void xdg_toplevel_t::set_app_id(std::string const& app_id)
{
  marshal(3U, app_id);
}


void xdg_toplevel_t::show_window_menu(seat_t const& seat, uint32_t serial, int32_t x, int32_t y)
{
  marshal(4U, seat.proxy_has_object() ? reinterpret_cast<wl_object*>(seat.c_ptr()) : nullptr, serial, x, y);
}


void xdg_toplevel_t::move(seat_t const& seat, uint32_t serial)
{
  marshal(5U, seat.proxy_has_object() ? reinterpret_cast<wl_object*>(seat.c_ptr()) : nullptr, serial);
}


void xdg_toplevel_t::resize(seat_t const& seat, uint32_t serial, xdg_toplevel_resize_edge const& edges)
{
  marshal(6U, seat.proxy_has_object() ? reinterpret_cast<wl_object*>(seat.c_ptr()) : nullptr, serial, static_cast<uint32_t>(edges));
}


void xdg_toplevel_t::set_max_size(int32_t width, int32_t height)
{
  marshal(7U, width, height);
}


void xdg_toplevel_t::set_min_size(int32_t width, int32_t height)
{
  marshal(8U, width, height);
}


void xdg_toplevel_t::set_maximized()
{
  marshal(9U);
}


void xdg_toplevel_t::unset_maximized()
{
  marshal(10U);
}


void xdg_toplevel_t::set_fullscreen(output_t const& output)
{
  marshal(11U, output.proxy_has_object() ? reinterpret_cast<wl_object*>(output.c_ptr()) : nullptr);
}


void xdg_toplevel_t::unset_fullscreen()
{
  marshal(12U);
}


void xdg_toplevel_t::set_minimized()
{
  marshal(13U);
}


std::function<void(int32_t, int32_t, array_t)> &xdg_toplevel_t::on_configure()
{
  return std::static_pointer_cast<events_t>(get_events())->configure;
}

std::function<void()> &xdg_toplevel_t::on_close()
{
  return std::static_pointer_cast<events_t>(get_events())->close;
}

std::function<void(int32_t, int32_t)> &xdg_toplevel_t::on_configure_bounds()
{
  return std::static_pointer_cast<events_t>(get_events())->configure_bounds;
}

int xdg_toplevel_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->configure) events->configure(args[0].get<int32_t>(), args[1].get<int32_t>(), args[2].get<array_t>());
      break;
    case 1:
      if(events->close) events->close();
      break;
    case 2:
      if(events->configure_bounds) events->configure_bounds(args[0].get<int32_t>(), args[1].get<int32_t>());
      break;
    }
  return 0;
}

const bitfield<4, 11> xdg_toplevel_resize_edge::none{0};
const bitfield<4, 11> xdg_toplevel_resize_edge::top{1};
const bitfield<4, 11> xdg_toplevel_resize_edge::bottom{2};
const bitfield<4, 11> xdg_toplevel_resize_edge::left{4};
const bitfield<4, 11> xdg_toplevel_resize_edge::top_left{5};
const bitfield<4, 11> xdg_toplevel_resize_edge::bottom_left{6};
const bitfield<4, 11> xdg_toplevel_resize_edge::right{8};
const bitfield<4, 11> xdg_toplevel_resize_edge::top_right{9};
const bitfield<4, 11> xdg_toplevel_resize_edge::bottom_right{10};



xdg_popup_t::xdg_popup_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&xdg_popup_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_popup_t(p); });
}

xdg_popup_t::xdg_popup_t()
{
  set_interface(&xdg_popup_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_popup_t(p); });
}

xdg_popup_t::xdg_popup_t(xdg_popup *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&xdg_popup_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_popup_t(p); });
}

xdg_popup_t::xdg_popup_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&xdg_popup_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_popup_t(p); });
}

xdg_popup_t xdg_popup_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string xdg_popup_t::interface_name = "xdg_popup";

xdg_popup_t::operator xdg_popup*() const
{
  return reinterpret_cast<xdg_popup*> (c_ptr());
}

void xdg_popup_t::grab(seat_t const& seat, uint32_t serial)
{
  marshal(1U, seat.proxy_has_object() ? reinterpret_cast<wl_object*>(seat.c_ptr()) : nullptr, serial);
}


void xdg_popup_t::reposition(xdg_positioner_t const& positioner, uint32_t token)
{
  marshal(2U, positioner.proxy_has_object() ? reinterpret_cast<wl_object*>(positioner.c_ptr()) : nullptr, token);
}

bool xdg_popup_t::can_reposition() const
{
  return (get_version() >= reposition_since_version);
}


std::function<void(int32_t, int32_t, int32_t, int32_t)> &xdg_popup_t::on_configure()
{
  return std::static_pointer_cast<events_t>(get_events())->configure;
}

std::function<void()> &xdg_popup_t::on_popup_done()
{
  return std::static_pointer_cast<events_t>(get_events())->popup_done;
}

std::function<void(uint32_t)> &xdg_popup_t::on_repositioned()
{
  return std::static_pointer_cast<events_t>(get_events())->repositioned;
}

int xdg_popup_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->configure) events->configure(args[0].get<int32_t>(), args[1].get<int32_t>(), args[2].get<int32_t>(), args[3].get<int32_t>());
      break;
    case 1:
      if(events->popup_done) events->popup_done();
      break;
    case 2:
      if(events->repositioned) events->repositioned(args[0].get<uint32_t>());
      break;
    }
  return 0;
}



